      FUNCTION MOVA2I(A)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    MOVA2I
C   PRGMMR: GILBERT          ORG: NP11       DATE: 2003-11-04
C
C ABSTRACT: THIS FUNCTION COPIES A BIT STRING FROM A CHARACTER*1
C   VARIABLE TO AN INTEGER VARIABLE.  IT IS INTENDED TO REPLACE THE
C   FORTRAN INTRINSIC FUNCTION ICHAR, WHICH ONLY SUPPORTS VALUES OF
C   ICHAR(A) BETWEEN ZERO AND 127, INCLUSIVE ON SOME PLATFORMS (E.G.,
C   THE NCEP IBM SP).  IF "A" IS GREATER THAN 127 IN THE COLLATING
C   SEQUENCE, ICHAR(A) DOES NOT RETURN THE EXPECTED BIT VALUE.  THIS
C   FUNCTION CAN BE USED FOR ALL VALUES OF ICHAR(A) BETWEEN ZERO AND
C   255.  SINCE THIS FUNCTION IS PRESENT IN THE W3 LIBRARIES (IN C
C   LANGUAGE), AND SINCE IT IS NO LONGER CALLED BY ANY BUFR ARCHIVE
C   LIBRARY ROUTINES, IT MAY BE REMOVED FROM THE BUFR ARCHIVE LIBRARY
C   IN A FUTURE VERSION.  USERS SHOULD MIGRATE TO MOVA2I IN THE W3
C   LIBRARIES WHICH IS USED IN THE SAME WAY AS MOVA2I IS USED HERE.
C
C PROGRAM HISTORY LOG:
C 2003-11-04  S. GILBERT -- ORIGINAL AUTHOR
C 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF
C 2005-11-29  D. KEYSER  -- MARKED AS OBSOLETE AND ADDED PRINT
C                           NOTIFICATION
C
C USAGE:    CALL MOVA2I (A)
C   INPUT ARGUMENT LIST:
C     A        - CHARACTER*1: VARIABLE THAT HOLDS THE BITSTRING TO
C                EXTRACT
C
C   OUTPUT ARGUMENT LIST:
C     MOVA2I   - INTEGER: VALUE OF THE BITSTRING IN CHARACTER A
C
C REMARKS:
C    THIS ROUTINE CALLS:        None
C    THIS ROUTINE IS CALLED BY: None
C                               Possibly called by application
C                               programs?
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      COMMON /QUIET / IPRT

      CHARACTER*1 A
      CHARACTER*4 CTEMP
      INTEGER*4 ITEMP,FF

      EQUIVALENCE (CTEMP,ITEMP)

      DATA IFIRST/0/

      SAVE IFIRST

      IF(IFIRST.EQ.0) THEN
         IF(IPRT.GE.0) THEN
      PRINT*
      PRINT*,'+++++++++++++++++BUFR ARCHIVE LIBRARY++++++++++++++++++++'
      PRINT 101
101   FORMAT(' BUFRLIB: MOVA2I - THIS SUBROUTINE IS NOW OBSOLETE; ',
     . 'USE IDENTICAL SUBROUTINE MOVA2I IN W3 LIBRARIES INSTEAD')
      PRINT*,'+++++++++++++++++BUFR ARCHIVE LIBRARY++++++++++++++++++++'
      PRINT*
         ENDIF
         IFIRST = 1
      ENDIF

      FF=255
      CTEMP=A//A//A//A
      MOVA2I=IAND(ITEMP,FF)
      RETURN
      END
