load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
;load "/usr/local/ncl_ncarg-5.1.0/lib/ncarg/nclscripts/csm/contributed.ncl"

begin

; this was written for noleap year - for leap years some adjustments are needed. 

  f = addfile("./geo_em.d02.nc","r")

  var_in = ( (/"ALBEDO12M", "GREENFRAC"/) )
  var_out= ( (/"ALBBCK", "VEGFRA"/) )
  dimVar = dimsizes(var_in)

  MO =   ( (/ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" /) )
  days = ( (/    31,    28,    31,    30,    31,    30,    31,    31,    30,    31,    30,    31 /) )

  do ivar = 0,dimVar-1

  var = f->$var_in(ivar)$
  dims = dimsizes(var)

  var365 = new ( (/365,dims(2),dims(3)/), typeof(var) )
  var365!0 = "day"
  var365!1 = var!2
  var365!2 = var!3
  copy_VarAtts(var,var365)

  id = 14
  do im = 0,11

    if ( im .eq. 11 ) then
      tend = (var(0,0,:,:) - var(0,im,:,:))/days(im)
    else
      tend = (var(0,im+1,:,:) - var(0,im,:,:))/days(im)
    end if

    do dd = 0, days(im)-1
      id = id + 1
      if ( id .eq. 365 ) then
        id = 0
      end if
      print("Creating data for " + MO(im) + " : " + id + " (" + dd + ")" )
      if ( dd .eq. 0 ) then
        var365(id,:,:) = (/ var(0,im,:,:) /)
      else
        if ( id .eq. 0 ) then
          var365(id,:,:) = var365(364,:,:) + tend(:,:)
        else
          var365(id,:,:) = var365(id-1,:,:) + tend(:,:)
        end if
      end if
    end do
  
  end do

  if ( ivar .eq. 0 ) then
    out = addfile ("static_daily.d02.nc","c")
    dimNames      = (/"day","south_north","west_east"/)
    dimSizes      = (/-1,dims(2),dims(3)/)
    dimUnLim      = (/True,False,False/)
    filedimdef(out,dimNames,dimSizes,dimUnLim)
  end if

  out->$var_out(ivar)$ = var365

  delete(var)
  delete(var365)
  delete(tend)

  end do

end


