!   IBM flags
!      xlf interp_wrflowinp_cg2fg.f -L/usr/local/netcdf/lib -lnetcdf -lm  \
!      -I/usr/local/netcdf/include  -qfree=f90  -o interp_wrflowinp_cg2fg
!
  program interp_wrflowinp_cg2fg

  implicit none
  character (len=80)    :: input_file1,input_file2                        

! Get the input files we are going to work with
  call read_args(input_file1,input_file2)
  print*," INPUT FILE IS: ",trim(input_file1)
  print*,"OUTPUT FILE IS: ",trim(input_file2)
  print*," "


! Now read the file
  call get_info_from_cdf (input_file1,input_file2)

  end program interp_wrflowinp_cg2fg

!------------------------------------------------------------------------------

  subroutine read_args(input_file1,input_file2)

  implicit none
  character (len=80)    :: input_file1,input_file2                        

  integer               :: numarg, i, idummy
  real                  :: rdummy
  integer, external     :: iargc
  character (len=80)    :: dummy

! set up some defaults first
  input_file1 = " "
  input_file2 = " "
  numarg = iargc()
  i = 1

  if (numarg .lt. 2) then
    print*,"MUST SUPPLY INPUT FILE NAMES"
    print*,"eg, interp_wrflowinp_cg2fg wrflowinp_d01 wrflowinp_d02"
    STOP
  endif 

  call getarg(1,input_file1)
  call getarg(2,input_file2)

  end subroutine read_args
!------------------------------------------------------------------------------
  subroutine get_info_from_cdf( file1,file2)
        
  implicit none

  include 'netcdf.inc'

  character (len=80), intent(in) :: file1,file2
  integer                        :: cdfid1, cdfid2, rcode

  integer                        :: i,j,k,ivtype, time1,time2
  integer                        :: plot_dim(3), get_x, get_y, get_z
  
  character (len=80) :: varnam, att_name, value_chr, print_time
  character (len=80) :: att_sav(10)
  integer            :: dimids(10), FieldType
  character (len=80) ::  units, MemoryOrder, description, stagger

  integer  id_var, idvar, id_att, attlen, ios
  integer nDims, nVars, nAtts, unlimDimID, dims(4),unit_place,order_place
  integer type_to_get, dims3, id_time, n_times, itimes, iatt

  double precision,  allocatable, dimension(:,:,:) :: data_dp_r
  real,    allocatable, dimension(:,:,:) :: data_r , cg, fg
  integer, allocatable, dimension(:,:,:) :: data_i
  character (len=80) :: times(2000)
  integer istart(4), iend(4), isample(4)
  integer istart2(4), iend2(4)
  integer istart_t(2), iend_t(2)
  real    sample_value_r, minvalue_r, maxvalue_r
  real, allocatable, dimension(:) :: value_real
  integer sample_value_i, minvalue_i, maxvalue_i, value_int
  integer fg_x, fg_y, I_PARENT_START, J_PARENT_START


! OPEN FILEs
  rcode = nf_open(file1, NF_WRITE, cdfid1 )
  print*,"Attempting to open netCDF file with write access"
  if( rcode == 0) then
    write(6,*) ' '
  else
    write(6,*) ' error opening netcdf file ',trim(file1)
    stop
  end if
  rcode = nf_open(file2, NF_WRITE, cdfid2 )
  print*,"Attempting to open netCDF file with write access"
  if( rcode == 0) then
    write(6,*) ' '
  else
    write(6,*) ' error opening netcdf file ',trim(file2)
    stop
  end if

! Get the times first:
  rcode = nf_inq_varid ( cdfid1, 'Times', id_var )
  id_time = ncvid( cdfid1, 'Times', rcode )
  rcode = nf_inq_var( cdfid1, id_time, varnam, ivtype, ndims, dimids, natts )
  do i=1,ndims
    rcode = nf_inq_dimlen( cdfid1, dimids(i), dims(i) )
  enddo
  n_times = dims(2)
  do i=1,dims(2)
    istart_t(1) = 1
    iend_t(1) = dims(1)
    istart_t(2) = i
    iend_t(2) = 1
    rcode = NF_GET_VARA_TEXT  ( cdfid1, id_time, istart_t, iend_t, times(i))
  enddo
  print*,dims
  print*,iend_t
   print*,"TIMES in file"
   do itimes = 1,n_times
     print_time = times(itimes)
     print*,trim(print_time)
  enddo



!  SET THE FINE GRID INFO 
!  This is the staggered grid dimensions
!  Also set fine grid location inside the cg domain, for the CALL below
      rcode = nf_get_att_int (cdfid2, nf_global, 'WEST-EAST_GRID_DIMENSION', fg_x)
      rcode = nf_get_att_int (cdfid2, nf_global, 'SOUTH-NORTH_GRID_DIMENSION', fg_y)
      rcode = nf_get_att_int (cdfid2, nf_global, 'I_PARENT_START', I_PARENT_START)
      rcode = nf_get_att_int (cdfid2, nf_global, 'J_PARENT_START', J_PARENT_START)

  rcode = nf_inq(cdfid1, nDims, nVars, nAtts, unlimDimID)

!===========================================================================================

! New we are ready to start with the time loop

    do itimes = 1,n_times


      do id_var = 2,nVars
        dims = 1
        rcode = nf_inq_var( cdfid1, id_var, varnam, ivtype, nDims, dimids, nAtts )
        
        IF ( varnam == 'SST' .OR. varnam == 'SEAICE' ) THEN

           do i=1,ndims
             rcode = nf_inq_dimlen( cdfid1, dimids(i), dims(i) )
           enddo
           istart        = 1
           istart(nDims) = itimes
           iend          = 1
           do i = 1,nDims-1
             iend(i)     = dims(i)
           enddo
          ! Get field from netCDF file
             allocate (data_r(iend(1),iend(2),iend(3)))
             call ncvgt( cdfid1,id_var,istart,iend,data_r,rcode)
             allocate (cg(iend(1)+1,iend(2)+1,iend(3)))
             do i = 1, iend(1)
            do j = 1, iend(2)
                 cg(i,j,1) = data_r(i,j,1)
               enddo
             enddo
   
   
            allocate (fg(fg_x,fg_y,1))      ! domain3

            CALL quaint  ( cg , iend(1)+1, iend(2)+1 , 1 , &
                           fg , fg_x ,    fg_y ,     I_PARENT_START , J_PARENT_START , 1 )
   
   
             print*,"WRITE: ", trim(varnam)
             deallocate (data_r)
             istart2        = 1
             istart2(nDims) = itimes
             iend2          = 1
             iend2(1)     = fg_x - 1
             iend2(2)     = fg_y - 1
             allocate (data_r(iend2(1),iend2(2),1))

             do i = 1, iend2(1)
               do j = 1, iend2(2)
                 data_r(i,j,1) = fg(i,j,1)
                 if (varnam == 'SEAICE')then
                    if (fg(i,j,1) >= .5) then
                       data_r(i,j,1) = 1.
                    endif
                    if (fg(i,j,1) < .5) then
                       data_r(i,j,1) = 0.
                    endif
                 endif
               enddo
             enddo

             call ncvpt( cdfid2,id_var,istart2,iend2,data_r,rcode)
   
   
             deallocate (data_r)
             deallocate (cg)
             deallocate (fg)

          ENDIF

    enddo
    istart_t(2) = itimes
    rcode = NF_PUT_VARA_TEXT  ( cdfid2, id_time, istart_t, iend_t, times(itimes))
    print*, times(itimes)
  enddo


!===========================================================================================
! END OF OPTIONS


  call ncclos(cdfid1,rcode)
  call ncclos(cdfid2,rcode)

  print*,"  "
  print*,"   --- End of input file ---   "

  end subroutine get_info_from_cdf
!-------------------------------------------------------------------------------------------
   SUBROUTINE quaint(fin,ixc,jxc,kx,fout,ixn,jxn,inest,jnest,icrsdot)
   
      IMPLICIT NONE
   
      INTEGER :: ixc,jxc,kx,ixn,jxn,inest,jnest,icrsdot
      REAL , dimension(ixc,jxc,kx) :: fin
      REAL , dimension(ixn,jxn,kx) :: fout
   
      INTEGER , PARAMETER :: iratio=3
      REAL , PARAMETER :: onethrd =1./3. , twothrd =2./3. , &
                          onethrd1=1./3.+1. , twothrd1=2./3.+1.
   
      REAL :: biparab , x , f1,f2,f3,f4,a,b,c,d,e,f,g,h
      INTEGER :: i , j , k , iendc , jendc , ic , jc
   
      biparab(x,f1,f2,f3,f4)= &
        ((x-1.0)*(x-2.0)*f1*0.5   - (x    )*(x-2.0)*f2 + &
         (x    )*(x-1.0)*f3*0.5 ) * ABS(x-2.0) + &
        ((x-2.0)*(x-3.0)*f2*0.5   - (x-1.0)*(x-3.0)*f3 + &
         (x-1.0)*(x-2.0)*f4*0.5 ) * ABS(x-1.0)
   
      !  Coarse i,j (ic,jc) to nest i,j
   
      jendc=(jxn-1)/iratio + jnest
      iendc=(ixn-1)/iratio + inest
   
!$OMP PARALLEL DO DEFAULT ( SHARED ) &
!$OMP PRIVATE ( i , j , k , ic , jc , a , b , c , d , e , f , g , h )
      DO k = 1 , kx
  
         !  Computation different for cross and dot point
      
         IF(icrsdot.EQ.0) THEN ! this is dot point interpolation
       
            !  Fill in all coincident points.
      
            DO jc=jnest,jendc
               j=jc*iratio-jnest*iratio+1
               DO ic=inest,iendc
                  i=ic*iratio-inest*iratio+1
                  fout(i,j,k)=fin(ic,jc,k)
               END DO
            END DO
      
            !  Set nested values in same rows as coarse
      
               DO jc=jnest,jendc-1
                  j=jc*iratio-jnest*iratio+1
            DO ic=inest,iendc
               i=ic*iratio-inest*iratio+1
                  fout(i,j+1,k)=biparab(onethrd1,fin(ic,jc-1,k),fin(ic,jc,k), &
                     fin(ic,jc+1,k),fin(ic,jc+2,k))
                  fout(i,j+2,k)=biparab(twothrd1,fin(ic,jc-1,k),fin(ic,jc,k), &
                     fin(ic,jc+1,k),fin(ic,jc+2,k))
               END DO
            END DO
      
            !  Set nested values in same columns as coarse
      
            DO jc=jnest,jendc
               j=jc*iratio-jnest*iratio+1
               DO ic=inest,iendc-1
                  i=ic*iratio-inest*iratio+1
                  fout(i+1,j,k)=biparab(onethrd1,fin(ic-1,jc,k),fin(ic,jc,k), &
                     fin(ic+1,jc,k),fin(ic+2,jc,k))
                  fout(i+2,j,k)=biparab(twothrd1,fin(ic-1,jc,k),fin(ic,jc,k), &
                     fin(ic+1,jc,k),fin(ic+2,jc,k))
               END DO
            END DO
      
            !  Set rest of 4 points in each of boundary corners
      
            jc=jnest ! lower left
            ic=inest
            j=jc*iratio-jnest*iratio+1
            a=biparab(onethrd1,fin(ic-1,jc-1,k),fin(ic,jc-1,k), &
               fin(ic+1,jc-1,k),fin(ic+2,jc-1,k))
            b=biparab(twothrd1,fin(ic-1,jc-1,k),fin(ic,jc-1,k), &
               fin(ic+1,jc-1,k),fin(ic+2,jc-1,k))
            fout(2,j+1,k)=biparab(onethrd1,a,fout(2,j,k),fout(2,j+3,k),fout(2,j+6,k))
            fout(2,j+2,k)=biparab(twothrd1,a,fout(2,j,k),fout(2,j+3,k),fout(2,j+6,k))
            fout(3,j+1,k)=biparab(onethrd1,b,fout(3,j,k),fout(3,j+3,k),fout(3,j+6,k))
            fout(3,j+2,k)=biparab(twothrd1,b,fout(3,j,k),fout(3,j+3,k),fout(3,j+6,k))
      
            jc=jendc-2 ! lower right
            ic=inest
            j=jc*iratio-jnest*iratio+1
            a=biparab(onethrd1,fin(ic-1,jc+3,k),fin(ic,jc+3,k), &
               fin(ic+1,jc+3,k),fin(ic+2,jc+3,k))
            b=biparab(twothrd1,fin(ic-1,jc+3,k),fin(ic,jc+3,k), &
               fin(ic+1,jc+3,k),fin(ic+2,jc+3,k))
            fout(2,j+4,k)=biparab(onethrd1,fout(2,j,k),fout(2,j+3,k),fout(2,j+6,k),a)
            fout(2,j+5,k)=biparab(twothrd1,fout(2,j,k),fout(2,j+3,k),fout(2,j+6,k),a)
            fout(3,j+4,k)=biparab(onethrd1,fout(3,j,k),fout(3,j+3,k),fout(3,j+6,k),b)
            fout(3,j+5,k)=biparab(twothrd1,fout(3,j,k),fout(3,j+3,k),fout(3,j+6,k),b)
      
            jc=jnest ! upper left
            ic=iendc-1
            j=jc*iratio-jnest*iratio+1
            a=biparab(onethrd1,fin(ic-1,jc-1,k),fin(ic,jc-1,k), &
               fin(ic+1,jc-1,k),fin(ic+2,jc-1,k))
            b=biparab(twothrd1,fin(ic-1,jc-1,k),fin(ic,jc-1,k), &
               fin(ic+1,jc-1,k),fin(ic+2,jc-1,k))
            fout(ixn-2,j+1,k)=biparab(onethrd1,a,fout(ixn-2,j,k),fout(ixn-2,j+3,k), &
               fout(ixn-2,j+6,k))
            fout(ixn-2,j+2,k)=biparab(twothrd1,a,fout(ixn-2,j,k),fout(ixn-2,j+3,k), &
               fout(ixn-2,j+6,k))
            fout(ixn-1,j+1,k)=biparab(onethrd1,b,fout(ixn-1,j,k),fout(ixn-1,j+3,k), &
               fout(ixn-1,j+6,k))
            fout(ixn-1,j+2,k)=biparab(twothrd1,b,fout(ixn-1,j,k),fout(ixn-1,j+3,k), &
               fout(ixn-1,j+6,k))
      
            jc=jendc-2 ! upper right
            ic=iendc-1
            j=jc*iratio-jnest*iratio+1
            a=biparab(onethrd1,fin(ic-1,jc+3,k),fin(ic,jc+3,k), &
               fin(ic+1,jc+3,k),fin(ic+2,jc+3,k))
            b=biparab(twothrd1,fin(ic-1,jc+3,k),fin(ic,jc+3,k), &
               fin(ic+1,jc+3,k),fin(ic+2,jc+3,k))
            fout(ixn-2,j+4,k)=biparab(onethrd1,fout(ixn-2,j,k),fout(ixn-2,j+3,k), &
               fout(ixn-2,j+6,k),a)
            fout(ixn-2,j+5,k)=biparab(twothrd1,fout(ixn-2,j,k),fout(ixn-2,j+3,k), &
               fout(ixn-2,j+6,k),a)
            fout(ixn-1,j+4,k)=biparab(onethrd1,fout(ixn-1,j,k),fout(ixn-1,j+3,k), &
               fout(ixn-1,j+6,k),b)
            fout(ixn-1,j+5,k)=biparab(twothrd1,fout(ixn-1,j,k),fout(ixn-1,j+3,k), &
               fout(ixn-1,j+6,k),b)
      
            !  Do inside of lower row and upper row
      
            DO jc=jnest+1,jendc-2
               j=jc*iratio-jnest*iratio+1
               fout(2,j+1,k)=biparab(onethrd1,fout(2,j-3,k),fout(2,j,k), &
                  fout(2,j+3,k),fout(2,j+6,k))
               fout(3,j+1,k)=biparab(onethrd1,fout(3,j-3,k),fout(3,j,k), &
                  fout(3,j+3,k),fout(3,j+6,k))
               fout(2,j+2,k)=biparab(twothrd1,fout(2,j-3,k),fout(2,j,k), &
                  fout(2,j+3,k),fout(2,j+6,k))
               fout(3,j+2,k)=biparab(twothrd1,fout(3,j-3,k),fout(3,j,k), &
                  fout(3,j+3,k),fout(3,j+6,k))
               fout(ixn-2,j+1,k)=biparab(onethrd1,fout(ixn-2,j-3,k),fout(ixn-2,j,k), &
                  fout(ixn-2,j+3,k),fout(ixn-2,j+6,k))
               fout(ixn-1,j+1,k)=biparab(onethrd1,fout(ixn-1,j-3,k),fout(ixn-1,j,k), &
                  fout(ixn-1,j+3,k),fout(ixn-1,j+6,k))
               fout(ixn-2,j+2,k)=biparab(twothrd1,fout(ixn-2,j-3,k),fout(ixn-2,j,k), &
                  fout(ixn-2,j+3,k),fout(ixn-2,j+6,k))
               fout(ixn-1,j+2,k)=biparab(twothrd1,fout(ixn-1,j-3,k),fout(ixn-1,j,k), &
                  fout(ixn-1,j+3,k),fout(ixn-1,j+6,k))
            END DO
      
            !  Fill in everyone
      
            DO jc=jnest,jendc-1
               j=jc*iratio-jnest*iratio+1
               DO ic=inest+1,iendc-2
                  i=ic*iratio-inest*iratio+1
                  a=fout(i-3,j+1,k)
                  b=fout(i  ,j+1,k)
                  c=fout(i+3,j+1,k)
                  d=fout(i+6,j+1,k)
                  fout(i+1,j+1,k)=biparab(onethrd1,a,b,c,d)
                  fout(i+2,j+1,k)=biparab(twothrd1,a,b,c,d)
                  e=fout(i-3,j+2,k)
                  f=fout(i  ,j+2,k)
                  g=fout(i+3,j+2,k)
                  h=fout(i+6,j+2,k)
                  fout(i+1,j+2,k)=biparab(onethrd1,e,f,g,h)
                  fout(i+2,j+2,k)=biparab(twothrd1,e,f,g,h)
               END DO
            END DO
      
         !     ... this is the cross point deal
      
         ELSE IF(icrsdot.EQ.1) THEN ! this is cross point interpolation
      
            !  Fill in all coincident points: nest is on top of coarse
      
            DO jc=jnest,jendc-icrsdot
               j=jc*iratio-jnest*iratio+1+icrsdot
               DO ic=inest,iendc-icrsdot
                  i=ic*iratio-inest*iratio+1+icrsdot
                  fout(i,j,k)=fin(ic,jc,k)
               END DO
            END DO
      
           !  Set nested values in same rows as coarse
      
               DO jc=jnest,jendc-1
                  j=jc*iratio-jnest*iratio+1+icrsdot
            DO ic=inest,iendc-icrsdot
               i=ic*iratio-inest*iratio+1+icrsdot
                  fout(i,j+1,k)=biparab(onethrd1,fin(ic,jc-1,k),fin(ic,jc,k), &
                     fin(ic,jc+1,k),fin(ic,jc+2,k))
                  fout(i,j+2,k)=biparab(twothrd1,fin(ic,jc-1,k),fin(ic,jc,k), &
                     fin(ic,jc+1,k),fin(ic,jc+2,k))
               END DO
            END DO
            DO ic=inest,iendc-icrsdot
               i=ic*iratio-inest*iratio+1+icrsdot
               jc=jnest ! inside nest INTERFACE, outside cross pt x=1
               j=jc*iratio-jnest*iratio+1+icrsdot
               fout(i,j-1,k)=biparab(twothrd1,fin(ic,jc-2,k),fin(ic,jc-1,k), &
                  fin(ic,jc,k),fin(ic,jc+1,k))
               jc=jendc ! inside nest interface, outside cross pt x=jx-1
               j=jc*iratio-jnest*iratio+1+icrsdot
               fout(i,j-2,k)=biparab(onethrd1,fin(ic,jc-2,k),fin(ic,jc-1,k), &
                  fin(ic,jc,k),fin(ic,jc+1,k))
            END DO
      
            !  Set nested values in same columns as coarse
      
            DO jc=jnest,jendc-icrsdot
               j=jc*iratio-jnest*iratio+1+icrsdot
               DO ic=inest,iendc-1
                  i=ic*iratio-inest*iratio+1+icrsdot
                  fout(i+1,j,k)=biparab(onethrd1,fin(ic-1,jc,k),fin(ic,jc,k), &
                     fin(ic+1,jc,k),fin(ic+2,jc,k))
                  fout(i+2,j,k)=biparab(twothrd1,fin(ic-1,jc,k),fin(ic,jc,k), &
                     fin(ic+1,jc,k),fin(ic+2,jc,k))
               END DO
            END DO
            DO jc=jnest,jendc-icrsdot
               j=jc*iratio-jnest*iratio+1+icrsdot
               ic=inest ! inside nest INTERFACE, outside cross pt y=1
               i=ic*iratio-inest*iratio+1+icrsdot
               fout(i-1,j,k)=biparab(twothrd1,fin(ic-2,jc,k),fin(ic-1,jc,k), &
                  fin(ic,jc,k),fin(ic+1,jc,k))
               ic=iendc ! inside nest interface, outside cross pt y=ix-1
               i=ic*iratio-inest*iratio+1+icrsdot
               fout(i-2,j,k)=biparab(onethrd1,fin(ic-2,jc,k),fin(ic-1,jc,k), &
                  fin(ic,jc,k),fin(ic+1,jc,k))
            END DO
      
            !  Set rest of 4 points in each of boundary corners
      
            jc=jnest ! lower left + lower left straggler
            ic=inest
            j=jc*iratio-jnest*iratio+1+icrsdot
            i=ic*iratio-inest*iratio+1+icrsdot
            a=biparab(onethrd1,fin(ic-1,jc-1,k),fin(ic,jc-1,k), &
               fin(ic+1,jc-1,k),fin(ic+2,jc-1,k))
            b=biparab(twothrd1,fin(ic-1,jc-1,k),fin(ic,jc-1,k), &
               fin(ic+1,jc-1,k),fin(ic+2,jc-1,k))
            fout(i+1,j+1,k)=biparab(onethrd1,a,fout(i+1,j,k),fout(i+1,j+3,k), &
               fout(i+1,j+6,k))
            fout(i+1,j+2,k)=biparab(twothrd1,a,fout(i+1,j,k),fout(i+1,j+3,k), &
               fout(i+1,j+6,k))
            fout(i+2,j+1,k)=biparab(onethrd1,b,fout(i+2,j,k),fout(i+2,j+3,k), &
               fout(i+2,j+6,k))
            fout(i+2,j+2,k)=biparab(twothrd1,b,fout(i+2,j,k),fout(i+2,j+3,k), &
               fout(i+2,j+6,k))
            c=biparab(twothrd1,fin(ic-2,jc-2,k),fin(ic-1,jc-2,k), &
               fin(ic,jc-2,k),fin(ic+1,jc-2,k))
            d=biparab(twothrd1,fin(ic-2,jc-1,k),fin(ic-1,jc-1,k), &
               fin(ic,jc-1,k),fin(ic+1,jc-1,k))
            fout(i-1,j-1,k)=biparab(twothrd1,c,d,fout(i-1,j,k),fout(i-1,j+3,k))
            fout(i-1,j+1,k)=biparab(onethrd1,d,fout(i-1,j,k),fout(i-1,j+3,k), &
               fout(i-1,j+6,k))
            fout(i-1,j+2,k)=biparab(twothrd1,d,fout(i-1,j,k),fout(i-1,j+3,k), &
               fout(i-1,j+6,k))
            e=biparab(twothrd1,fin(ic-1,jc-2,k),fin(ic-1,jc-1,k), &
               fin(ic-1,jc,k),fin(ic-1,jc+1,k))
            fout(i+1,j-1,k)=biparab(onethrd1,e,fout(i,j-1,k),fout(i+3,j-1,k), &
               fout(i+6,j-1,k))
            fout(i+2,j-1,k)=biparab(twothrd1,e,fout(i,j-1,k),fout(i+3,j-1,k), &
               fout(i+6,j-1,k))
      
            jc=jendc-2-icrsdot ! lower right + lower right straggler
            ic=inest
            j=jc*iratio-jnest*iratio+1+icrsdot
            i=ic*iratio-inest*iratio+1+icrsdot
            a=biparab(onethrd1,fin(ic-1,jc+3,k),fin(ic,jc+3,k), &
               fin(ic+1,jc+3,k),fin(ic+2,jc+3,k))
            b=biparab(twothrd1,fin(ic-1,jc+3,k),fin(ic,jc+3,k), &
               fin(ic+1,jc+3,k),fin(ic+2,jc+3,k))
            fout(i+1,j+4,k)=biparab(onethrd1,fout(i+1,j,k),fout(i+1,j+3,k), &
               fout(i+1,j+6,k),a)
            fout(i+1,j+5,k)=biparab(twothrd1,fout(i+1,j,k),fout(i+1,j+3,k), &
               fout(i+1,j+6,k),a)
            fout(i+2,j+4,k)=biparab(onethrd1,fout(i+2,j,k),fout(i+2,j+3,k), &
               fout(i+2,j+6,k),b)
            fout(i+2,j+5,k)=biparab(twothrd1,fout(i+2,j,k),fout(i+2,j+3,k), &
               fout(i+2,j+6,k),b)
            c=biparab(twothrd1,fin(ic-2,jc+3,k),fin(ic-1,jc+3,k), &
               fin(ic,jc+3,k),fin(ic+1,jc+3,k))
            d=biparab(twothrd1,fin(ic-2,jc+4,k),fin(ic-1,jc+4,k), &
               fin(ic,jc+4,k),fin(ic+1,jc+4,k))
            fout(i-1,j+7,k)=biparab(onethrd1,fout(i-1,j+3,k),fout(i-1,j+6,k),c,d)
            fout(i-1,j+4,k)=biparab(onethrd1,fout(i-1,j,k),fout(i-1,j+3,k), &
               fout(i-1,j+6,k),c)
            fout(i-1,j+5,k)=biparab(twothrd1,fout(i-1,j,k),fout(i-1,j+3,k), &
               fout(i-1,j+6,k),c)
            e=biparab(onethrd1,fin(ic-1,jc+1,k),fin(ic-1,jc+2,k), &
               fin(ic-1,jc+3,k),fin(ic-1,jc+4,k))
            fout(i+1,j+7,k)=biparab(onethrd1,e,fout(i,j+7,k),fout(i+3,j+7,k), &
               fout(i+6,j+7,k))
            fout(i+2,j+7,k)=biparab(twothrd1,e,fout(i,j+7,k),fout(i+3,j+7,k), &
               fout(i+6,j+7,k))
      
            jc=jnest ! upper left + upper left straggler
            ic=iendc-1-icrsdot
            j=jc*iratio-jnest*iratio+1+icrsdot
            i=ic*iratio-inest*iratio+1+icrsdot
            a=biparab(onethrd1,fin(ic-1,jc-1,k),fin(ic,jc-1,k), &
               fin(ic+1,jc-1,k),fin(ic+2,jc-1,k))
            b=biparab(twothrd1,fin(ic-1,jc-1,k),fin(ic,jc-1,k), &
               fin(ic+1,jc-1,k),fin(ic+2,jc-1,k))
            fout(i+1,j+1,k)=biparab(onethrd1,a,fout(i+1,j,k),fout(i+1,j+3,k), &
               fout(i+1,j+6,k))
            fout(i+1,j+2,k)=biparab(twothrd1,a,fout(i+1,j,k),fout(i+1,j+3,k), &
               fout(i+1,j+6,k))
            fout(i+2,j+1,k)=biparab(onethrd1,b,fout(i+2,j,k),fout(i+2,j+3,k), &
               fout(i+2,j+6,k))
            fout(i+2,j+2,k)=biparab(twothrd1,b,fout(i+2,j,k),fout(i+2,j+3,k), &
               fout(i+2,j+6,k))
            c=biparab(onethrd1,fin(ic,jc-2,k),fin(ic+1,jc-2,k), &
               fin(ic+2,jc-2,k),fin(ic+3,jc-2,k))
            d=biparab(onethrd1,fin(ic,jc-1,k),fin(ic+1,jc-1,k), &
               fin(ic+2,jc-1,k),fin(ic+3,jc-1,k))
            fout(i+4,j-1,k)=biparab(twothrd1,c,d,fout(i+4,j,k),fout(i+4,j+3,k))
            fout(i+4,j+1,k)=biparab(onethrd1,d,fout(i+4,j,k),fout(i+4,j+3,k), &
               fout(i+4,j+6,k))
            fout(i+4,j+2,k)=biparab(twothrd1,d,fout(i+4,j,k),fout(i+4,j+3,k), &
               fout(i+4,j+6,k))
            e=biparab(twothrd1,fin(ic+2,jc-2,k),fin(ic+2,jc-1,k), &
               fin(ic+2,jc,k),fin(ic+2,jc+1,k))
            fout(i+1,j-1,k)=biparab(onethrd1,fout(i-3,j-1,k),fout(i,j-1,k), &
               fout(i+3,j-1,k),e)
            fout(i+2,j-1,k)=biparab(twothrd1,fout(i-3,j-1,k),fout(i,j-1,k), &
               fout(i+3,j-1,k),e)
      
            jc=jendc-2-icrsdot ! upper right + upper right straggler
            ic=iendc-1-icrsdot
            j=jc*iratio-jnest*iratio+1+icrsdot
            i=ic*iratio-inest*iratio+1+icrsdot
            a=biparab(onethrd1,fin(ic-1,jc+3,k),fin(ic,jc+3,k), &
               fin(ic+1,jc+3,k),fin(ic+2,jc+3,k))
            b=biparab(twothrd1,fin(ic-1,jc+3,k),fin(ic,jc+3,k), &
               fin(ic+1,jc+3,k),fin(ic+2,jc+3,k))
            fout(i+1,j+4,k)=biparab(onethrd1,fout(i+1,j,k),fout(i+1,j+3,k), &
               fout(i+1,j+6,k),a)
            fout(i+1,j+5,k)=biparab(twothrd1,fout(i+1,j,k),fout(i+1,j+3,k), &
               fout(i+1,j+6,k),a)
            fout(i+2,j+4,k)=biparab(onethrd1,fout(i+2,j,k),fout(i+2,j+3,k), &
               fout(i+2,j+6,k),b)
            fout(i+2,j+5,k)=biparab(twothrd1,fout(i+2,j,k),fout(i+2,j+3,k), &
               fout(i+2,j+6,k),b)
            c=biparab(onethrd1,fin(ic,jc+3,k),fin(ic+1,jc+3,k), &
               fin(ic+2,jc+3,k),fin(ic+3,jc+3,k))
            d=biparab(onethrd1,fin(ic,jc+4,k),fin(ic+1,jc+4,k), &
               fin(ic+2,jc+4,k),fin(ic+3,jc+4,k))
            fout(i+4,j+7,k)=biparab(onethrd1,fout(i+4,j+3,k),fout(i+4,j+6,k),c,d)
            fout(i+4,j+4,k)=biparab(onethrd1,fout(i+4,j,k),fout(i+4,j+3,k), &
               fout(i+4,j+6,k),c)
            fout(i+4,j+5,k)=biparab(twothrd1,fout(i+4,j,k),fout(i+4,j+3,k), &
               fout(i+4,j+6,k),c)
            e=biparab(onethrd1,fin(ic+2,jc+1,k),fin(ic+2,jc+2,k), &
               fin(ic+2,jc+3,k),fin(ic+2,jc+4,k))
            fout(i+1,j+7,k)=biparab(onethrd1,fout(i-3,j+7,k),fout(i,j+7,k), &
               fout(i+3,j+7,k),e)
            fout(i+2,j+7,k)=biparab(twothrd1,fout(i-3,j+7,k),fout(i,j+7,k), &
               fout(i+3,j+7,k),e)
      
            !  Do inside of lower row and upper row
      
            DO jc=jnest+1,jendc-2-icrsdot
               j=jc*iratio-jnest*iratio+1+icrsdot
               ic=inest
               i=ic*iratio-inest*iratio+1+icrsdot
               fout(i+1,j+1,k)=biparab(onethrd1,fout(i+1,j-3,k),fout(i+1,j,k), &
                  fout(i+1,j+3,k),fout(i+1,j+6,k))
               fout(i+2,j+1,k)=biparab(onethrd1,fout(i+2,j-3,k),fout(i+2,j,k), &
                  fout(i+2,j+3,k),fout(i+2,j+6,k))
               fout(i+1,j+2,k)=biparab(twothrd1,fout(i+1,j-3,k),fout(i+1,j,k), &
                  fout(i+1,j+3,k),fout(i+1,j+6,k))
               fout(i+2,j+2,k)=biparab(twothrd1,fout(i+2,j-3,k),fout(i+2,j,k), &
                  fout(i+2,j+3,k),fout(i+2,j+6,k))
               fout(i-1,j+1,k)=biparab(onethrd1,fout(i-1,j-3,k),fout(i-1,j,k), &
                  fout(i-1,j+3,k),fout(i-1,j+6,k))
               fout(i-1,j+2,k)=biparab(twothrd1,fout(i-1,j-3,k),fout(i-1,j,k), &
                  fout(i-1,j+3,k),fout(i-1,j+6,k))
               ic=iendc-1-icrsdot
               i=ic*iratio-inest*iratio+1+icrsdot
               fout(i+1,j+1,k)=biparab(onethrd1,fout(i+1,j-3,k),fout(i+1,j,k), &
                  fout(i+1,j+3,k),fout(i+1,j+6,k))
               fout(i+2,j+1,k)=biparab(onethrd1,fout(i+2,j-3,k),fout(i+2,j,k), &
                  fout(i+2,j+3,k),fout(i+2,j+6,k))
               fout(i+1,j+2,k)=biparab(twothrd1,fout(i+1,j-3,k),fout(i+1,j,k), &
                  fout(i+1,j+3,k),fout(i+1,j+6,k))
               fout(i+2,j+2,k)=biparab(twothrd1,fout(i+2,j-3,k),fout(i+2,j,k), &
                  fout(i+2,j+3,k),fout(i+2,j+6,k))
               fout(i+4,j+1,k)=biparab(onethrd1,fout(i+4,j-3,k),fout(i+4,j,k), &
                  fout(i+4,j+3,k),fout(i+4,j+6,k))
               fout(i+4,j+2,k)=biparab(twothrd1,fout(i+4,j-3,k),fout(i+4,j,k), &
                  fout(i+4,j+3,k),fout(i+4,j+6,k))
            END DO
      
            !  Fill in everyone
      
            DO jc=jnest,jendc-1-icrsdot
               j=jc*iratio-jnest*iratio+1+icrsdot
               DO ic=inest+1,iendc-2-icrsdot
                  i=ic*iratio-inest*iratio+1+icrsdot
                  a=fout(i-3,j+1,k)
                  b=fout(i  ,j+1,k)
                  c=fout(i+3,j+1,k)
                  d=fout(i+6,j+1,k)
                  fout(i+1,j+1,k)=biparab(onethrd1,a,b,c,d)
                  fout(i+2,j+1,k)=biparab(twothrd1,a,b,c,d)
                  e=fout(i-3,j+2,k)
                  f=fout(i  ,j+2,k)
                  g=fout(i+3,j+2,k)
                  h=fout(i+6,j+2,k)
                  fout(i+1,j+2,k)=biparab(onethrd1,e,f,g,h)
                  fout(i+2,j+2,k)=biparab(twothrd1,e,f,g,h)
               END DO
            END DO
            DO ic=inest+1,iendc-2-icrsdot
               j=1
               i=ic*iratio-inest*iratio+1+icrsdot
               a=fout(i-3,j,k)
               b=fout(i  ,j,k)
               c=fout(i+3,j,k)
               d=fout(i+6,j,k)
               fout(i+1,j,k)=biparab(onethrd1,a,b,c,d)
               fout(i+2,j,k)=biparab(twothrd1,a,b,c,d)
               j=jxn-1
               e=fout(i-3,j,k)
               f=fout(i  ,j,k)
               g=fout(i+3,j,k)
               h=fout(i+6,j,k)
               fout(i+1,j,k)=biparab(onethrd1,e,f,g,h)
               fout(i+2,j,k)=biparab(twothrd1,e,f,g,h)
            END DO
         END IF

      END DO 
   
   END SUBROUTINE quaint



