load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"   
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

begin

       mm = new ( 13, integer ) 
       ym = new ( 13, integer ) 
       mm = (/ 0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 /)
       ym(0) = mm(0)
       do i = 1, 12
          ym(i) = ym(i-1) + mm(i)
       end do

       wrflow2       = addfile ("wrflowinp_d02.nc","w")
       static_daily  = addfile ("static_daily.d02.nc","r")
       time     = wrflow2->Times
       ;date     = static_daily->date
       albbck_s = static_daily->ALBBCK
       vegfra_s = static_daily->VEGFRA
       albbck_s!0 = "Time"
       vegfra_s!0 = "Time"

       dims = dimsizes(time)
       print("Times in wrflow file " + dims(0) )

       wmm_old = 0
       do it = 0, dims(0)-1
          smm = chartostring(time(it,5:6))
          sdd = chartostring(time(it,8:9))
          wmm = stringtoint(smm)
          wdd = stringtoint(sdd)
          yd = ym(wmm-1) + wdd - 1
          if ( wmm .ne. wmm_old ) then
             print("Now working on: " + time(it,0:6) )
          end if
          wmm_old = wmm
          wrflow2->ALBBCK(it,:,:) = albbck_s(yd,:,:)
          wrflow2->VEGFRA(it,:,:) = vegfra_s(yd,:,:)
       end do

end

