c                                                                     c
c*********************************************************************c
c                                                                     c
      function tonpsadiabat(thte,prs)
c
c   This function gives the temperature (in K) on a moist adiabat
c   (specified by thte in K) given pressure in hPa.  It uses a
c   lookup table, with data that was generated by the Bolton (1980)
c   formula for theta_e.
c
      include 'comconst'
c
      do jtch=1,150-1
         if (thte.ge.psadithte(jtch).and.thte.lt.psadithte(jtch+1)) then
            jt=jtch
            goto 213
         endif
      enddo
      jt=-1
 213  continue
      do ipch=1,150-1
         if (prs.le.psadiprs(ipch).and.prs.gt.psadiprs(ipch+1)) then
            ip=ipch
            goto 215
         endif
      enddo
      ip=-1
 215  continue
      if (jt.eq.-1.or.ip.eq.-1) then
         write(iup,*)
     &      'Outside of lookup table bounds. prs,thte=',prs,thte
         stop
      endif
      fracjt=(thte-psadithte(jt))/(psadithte(jt+1)-psadithte(jt))
      fracjt2=1.-fracjt
      fracip=(psadiprs(ip)-prs)/(psadiprs(ip)-psadiprs(ip+1))
      fracip2=1.-fracip
      if (psaditmk(ip,jt).gt.1e9.or.psaditmk(ip+1,jt).gt.1e9.or.
     &    psaditmk(ip,jt+1).gt.1e9.or.psaditmk(ip+1,jt+1).gt.1e9) then
         write(iup,*)
     &      'Tried to access missing tmperature in lookup table.'
         write(iup,*)
     &      'Prs and Thte probably unreasonable. prs,thte=',prs,thte
         stop
      endif
      tonpsadiabat=fracip2*fracjt2*psaditmk(ip  ,jt  )+
     &       fracip *fracjt2*psaditmk(ip+1,jt  )+
     &       fracip2*fracjt *psaditmk(ip  ,jt+1)+
     &       fracip *fracjt *psaditmk(ip+1,jt+1)
c
      return
      end
