!WRF:MODEL_LAYER:PHYSICS
!
! RG 10/2014 - Added LU-based SNOALB that is used for LU fraction weighted value if specificed.
!            
!

MODULE  module_sf_pxlsm_data

!*****************************************************************************
! MODIS-ONLY (1XX)/MODIS (2XX) LU characterization ... 
!-------------------------------------------------------------------------------
!Index Rstmin  Zo    Mxfr MnFr  MxLA MnLA SNUP  ALB SNOALB
!  1    175.   100.   93.  93.  5.5  3.5  0.08  12. 30.      Evergreen Needleleaf Forest
!  2    120.   90.    92.  92.  6.0  3.5  0.08  12. 30.      Evergreen Broadleaf Forest
!  3    175.   100.   60.  60.  3.0  1.5  0.08  14. 30.      Deciduous Needleleaf Forest
!  4    200.   100.   91.  91.  6.0  1.5  0.08  16. 40.      Deciduous Broadleaf Forest'
!  5    200.   100.   92.  92.  5.5  2.2  0.08  13. 35.      Mixed Forest
!  6    200.   15.    40.  20.  1.5  1.0  0.03  22. 50.      Closed Shrublands
!  7    200.   15.    40.  17.  1.5  1.3  0.035 20. 60.      Open Shrublands
!  8    150.   25.    70.  60.  2.3  2.0  0.03  22. 50.      Woody Savanna
!  9    120.   15.    70.  40.  1.5  0.5  0.04  20. 50.      Savanna
!-------------------------------------------------------------------------------
! 10    100.    7.    50.  20.  1.5  0.5  0.04  19. 70.      Grasslands
! 11    200    20.    65.  35.  2.5  1.0  0.08  15. 50.      Perminent Wetlands
! 12     70.   10.    90.  20.  3.5  0.7  0.04  18. 66.      Croplands
! 13    150.   80.     5.   5.  2.0  0.5  0.04  11. 46.      Urban andBuilt-up'
! 14    100.   30.    80.  40.  3.5  1.0  0.04  18. 68.      Cropland/Natural Vegetation Mosaic
! 15   9999.   1.2    0.1  0.1  0.1  0.1  0.02  60. 82.      Snow and Ice
! 16    100.    5.    0.5  0.5  0.2  0.1  0.02  25. 75.      Barren or Sparsely Vegetated
! 17   9999.   0.1    00.  00.  0.0  0.0  0.01  8.0 08.      IGBP water
! 18    175.   30.    70.  50.  3.4  2.0  0.80  15. 45.      wooded tundra
! 19    120.   15.    40.  20.  2.4  1.0  0.40  15. 50.      mixed tundra
! 20    100.   10.    20.   5.  1.4  0.1  .015  25. 75.      barren tundra
! 21   9999.   0.1    00.  00.  0.0  0.0  0.01  8.0 08.      inland lakes
! 22-50                                                      Unassigned
! 51-61 150.   80.     5.   5.  2.0  0.5  0.04  11. 46.      Urban LCZ 1-10 * Static urban settings *                                                     
!------------------------------------------------------------------------------------
!****************************************************************************************
!****************************************************************************************
      REAL, DIMENSION(61), TARGET  :: RSMIN_MODIS, Z00_MODIS,     &
                                      VEG0_MODIS, VEGMN0_MODIS,   &
                                      LAI0_MODIS, LAIMN0_MODIS,   &
                                      SNUP0_MODIS, ALBF_MODIS,    &
                                      SNOALB_MODIS

      DATA RSMIN_MODIS                                             &
             / 175.0,   120.0,   175.0,   200.0,    200.0,         &
               200.0,   200.0,   150.0,   120.0,    100.0,         &
               200.0,    70.0,   150.0,   100.0,   9999.0,         &
               100.0,  9999.0,   175.0,   120.0,    100.0,         &
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &
               150.0,   150.0,   150.0,   150.0,    150.0,         &
               150.0,   150.0,   150.0,   150.0,    150.0,  150.0  / 

      DATA Z00_MODIS                                               &
             / 100.0,    90.0,   100.0,   100.0,   100.0,          &
                15.0,    15.0,    25.0,    15.0,     7.0,          &
                20.0,    10.0,    80.0,    30.0,     1.2,          &
                 5.0,     0.1,    30.0,    15.0,    10.0,          & 
                 0.1,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
                80.0,    80.0,    80.0,    80.0,     80.0,         &
                80.0,    80.0,    80.0,    80.0,     80.0,  80.0   / 
                    
      DATA VEG0_MODIS                                              &
             /  93.0,    92.0,    60.0,    91.0,    92.0,          &
                40.0,    20.0,    70.0,    70.0,    50.0,          &
                65.0,    90.0,     5.0,    80.0,     0.1,          &
                 0.5,     0.0,    70.0,    40.0,    20.0,          & 
                 0.0,  9999.0,  9999.0,  9999.0,   9999.0,         &
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
                 5.0,     5.0,     5.0,     5.0,      5.0,         &
                 5.0,     5.0,     5.0,     5.0,      5.0,  5.0    /
                   
      DATA VEGMN0_MODIS                                            &
             /  93.0,    92.0,    60.0,    91.0,    92.0,          &
                20.0,    10.0,    60.0,    40.0,    20.0,          &
                35.0,    20.0,     5.0,    40.0,     0.1,          &
                 0.5,     0.0,    50.0,    20.0,     5.0,          &
                 0.0,  9999.0,  9999.0,  9999.0,   9999.0,         &
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
                 5.0,     5.0,     5.0,     5.0,      5.0,         &
                 5.0,     5.0,     5.0,     5.0,      5.0,  5.0    /
                     
      DATA LAI0_MODIS                                              &
             /   5.5,     6.0,     3.0,     6.0,     5.5,          &
                 1.5,     1.5,     2.3,     1.5,     1.5,          &
                 2.5,     3.5,     2.0,     3.5,     0.1,          &
                 0.2,     0.0,     3.4,     2.4,     1.4,          & 
                 0.0,  9999.0,  9999.0,  9999.0,   9999.0,         &
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
                 2.0,     2.0,     2.0,     2.0,      2.0,         &
                 2.0,     2.0,     2.0,     2.0,      2.0,  2.0    /
                    
      DATA LAIMN0_MODIS                                            &
             /   3.5,     3.5,     1.5,     2.0,     2.5,          &
                 1.0,     1.3,     2.0,     1.5,     1.5,          &
                 2.0,     1.5,     1.5,     1.5,     0.1,          &
                 0.1,     0.0,     2.0,     1.0,     0.1,          & 
                 0.0,  9999.0,  9999.0,  9999.0,   9999.0,         &    
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
                 1.5,     1.5,     1.5,     1.5,      1.5,         &
                 1.5,     1.5,     1.5,     1.5,      1.5,  1.5    /

      DATA SNUP0_MODIS                                             &
             /   0.08,    0.08,    0.08,    0.08,     0.08,        &
                 0.03,    0.035,   0.03,    0.04,     0.04,        &
                 0.08,    0.04,    0.04,    0.04,     0.02,        &
                 0.02,    0.01,    0.80,    0.40,     0.015,       &
                 0.01, 9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
                0.04,    0.04,    0.04,    0.04,     0.04,         &
                0.04,    0.04,    0.04,    0.04,     0.04,  0.04   / 
 
      DATA ALBF_MODIS                                              &
             /  12.0,    12.0,    14.0,    16.0,    13.0,          &
                22.0,    20.0,    22.0,    20.0,    19.0,          &
                17.0,    18.0,    11.0,    18.0,    60.0,          &
                25.0,     8.0,    15.0,    15.0,    25.0,          &
                 8.0,  9999.0,  9999.0,  9999.0,   9999.0,         &    
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
                11.0,    11.0,    11.0,    11.0,     11.0,         &
                11.0,    11.0,    11.0,    11.0,     11.0,   11.0  / 
 
      DATA SNOALB_MODIS                                            &
             /  30.0,    30.0,    30.0,    40.0,    35.0,          &
                50.0,    60.0,    50.0,    50.0,    70.0,          &
                50.0,    66.0,    46.0,    68.0,    82.0,          &
                75.0,     8.0,    45.0,    55.0,    75.0,          &   
                 8.0,  9999.0,  9999.0,  9999.0,   9999.0,         &    
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
              9999.0,  9999.0,  9999.0,  9999.0,   9999.0,         &   
                46.0,    46.0,    46.0,    46.0,     46.0,         &
                46.0,    46.0,    46.0,    46.0,     46.0,   46.0  / 

!****************************************************************************************
!****************************************************************************************
! 50 CLASS NLCD (US only, cats 1-30)/MODIS (Outside US, cats 31-50) LU characterization
!---------------------------------------------------------------------------------------
!Index Rstmin  Zo    Mxfr MnFr  MxLA MnLA ALB SNOALB  Cat Desc.
! 1    9999.   0.1    00.  00.  0.0  0.0   8  70.     Open water
! 2    9999.   1.2     5.  02.  0.1  0.1  60  82.     Perennial Ice/snow
! 3     120.   30.    90.  80.  3.0  1.0  12  60.     Developed, Open space
! 4     120.   40.    70   60.  3.0  1.0  11  46.     Developed, Low Intensity
! 5     140.   60.    40.  30.  3.0  1.0  10  43.     Developed, Medium Intensity
! 6     160.   100.   15.   5.  3.0  1.0  10  40.     Developed, High Intensity
! 7     100.    5.    20.   5.  1.0  0.5  20  75.     Barren land
! 8     100.    5.    15.   5.  0.5  0.2  35  75.     Unconsolidated Shore
! 9     200.   100.   95.  50.  5.0  1.0  15  40.     Deciduous Forest
! 10    175.   100.   90.  80.  4.0  3.0  10  30.     Evergreen Forest
!-------------------------------------------------------------------------------
! 11    200.   100.   95.  60.  5.0  2.0  13  35.     Mixed Forest
! 12    200.   10.    50.  20.  2.0  1.0  20  65.     Dwarf Scrub
! 13    200.   15.    75.  50.  2.5  1.0  20  60.     Shrub/Scrub
! 14    100.    7.    85.  60.  2.5  1.0  19  70.     Grassland/Herbaceous
! 15    100.    7.    80.  20.  2.0  1.0  23  60.     Sedge/Herbaceous
! 16    100.    5.    80.  20.  1.0  1.0  20  60.     Lichens
! 17    100.    5.    80.  20.  1.0  1.0  20  60.     Moss
! 18    100.    5.    50.  20.  1.0  1.0  15  75.     Tundra
! 19     80.    7.    95.  80.  3.0  1.0  18  68.     Pasture/Hay'
! 20     70.   10.    95.  10.  3.0  0.5  18  66.     Cultivated Crops
!-------------------------------------------------------------------------------
! 21    200.   55.    90.  80.  5.0  2.0  15  40.     Woody Wetland
! 22    200.   80.    90.  80.  5.0  2.0  15  40.     Palustrine Forested Wetland
! 23    164.   30.    90.  80.  3.0  1.0  15  50.     Palustrine Scrub/Shrub Wetland
! 24    200.   60.    90.  80.  5.0  2.0  15  50.     Estuarine Forested Wetland
! 25    164.   30.    90.  80.  3.0  1.0  15  50.     Estuarine Scrub/Shrub Wetland
! 26    120.   11.    85.  40.  2.0  1.0  18  59.     Emergent Herbaceous Wetland
! 27    120.   11.    85.  40.  2.0  1.0  18  59.     Palustrine Emergent Wetland
! 28    120.   11.    85.  40.  2.0  1.0  18  59.     Estuarine Emergent Wetland
! 29    100.    5.    60.  20.  1.0  0.5  10  50.     Palustrine Aquatic Bed
! 30    100.    5.    60.  20.  1.0  0.5  10  50.     Estuarine Aquatic Bed
!-------------------------------------------------------------------------------
! 31   9999.   0.1    00.  00.  0.0  0.0   8   8.     Open water (mapped to 1)
! 32    175.   100.   90.  80.  4.0  3.0  12  30.     Evergreen Needleleaf Forest
! 33    120.   90.    95.  85.  5.0  4.0  12  30.     Evergreen Broadleaf Forest
! 34    175.   100.   95.  50.  5.0  1.0  14  40.     Deciduous Needleleaf Forest
! 35    200.   100.   95.  50.  5.0  1.0  16  40.     Deciduous Broadleaf Forest'
! 36    200.   100.   95.  60.  5.0  2.0  13  35.     Mixed Forest
! 37    200.   15.    90.  50.  3.0  1.0  22  50.     Closed Shrublands
! 38    200.   15.    75.  50.  2.5  1.0  20  60.     Open Shrublands
! 39    150.   25.    80.  60.  2.5  1.0  22  50.     Woody Savanna
! 40    120.   15.    70.  50   2.0  1.0  20  50.     Savanna
!-------------------------------------------------------------------------------
! 41    100.    7.    85.  60.  2.5  1.0  19  70.     Grasslands
! 42    160.   20.    75.  45.  3.0  1.0  14  59.     Perminent Wetlands
! 43     70.   10.    95.  10.  3.0  0.5  18  66.     Croplands
! 44    150.   80.    40.  20.  3.0  1.0  11  46.     Urban andBuilt-up'
! 45    100.   30.    95.  40.  3.0  1.0  18  68.     Cropland/Natural Vegetation Mosaic
! 46   9999.   1.2     5.  02.  0.1  0.1  60  82.     Snow and Ice
! 47    100.    5.    20.   5.  1.0  0.5  25  75.     Barren or Sparsely Vegetated
! 48   9999.   0.1    00.  00.  0.0  0.0   8  08.     IGBP water
! 49   9999.   0.1    00.  00.  0.0  0.0   8  60.     unclassified
! 50   9999.   0.1    00.  00.  0.0  0.0   8  75.     fill value (normally ocean water)
!------------------------------------------------------------------------------------

      REAL, DIMENSION(50), TARGET  :: RSMIN_NLCD50, Z00_NLCD50,      &
                                      VEG0_NLCD50, VEGMN0_NLCD50,    &
                                      LAI0_NLCD50, LAIMN0_NLCD50,    &
                                      SNUP0_NLCD50, ALBF_NLCD50,     &
                                      SNOALB_NLCD50

      DATA RSMIN_NLCD50                                      &
             / 9999.0,  9999.0,   120.0,   120.0,   140.0,   &
                160.0,   100.0,   100.0,   200.0,   175.0,   &
                200.0,   200.0,   200.0,   100.0,   100.0,   &
                100.0,   100.0,   100.0,    80.0,    70.0,   &
                200.0,   200.0,   164.0,   200.0,   164.0,   &
                120.0,   120.0,   120.0,   100.0,   100.0,   &
               9999.0,   175.0,   120.0,   175.0,   200.0,   &
                200.0,   200.0,   200.0,   150.0,   120.0,   &
                100.0,   160.0,    70.0,   150.0,   100.0,   &
               9999.0,   100.0,  9999.0,  9999.0,  9999.0  /

      DATA Z00_NLCD50                                        &
             /   0.10,    1.20,   30.0,    40.0,    60.0,    &
               100.0,     5.0,     5.0,   100.0,   100.0,    &
               100.0,    10.0,    15.0,     7.0,     7.0,    &
                 5.0,     5.0,     5.0,     7.0,    10.0,    &
                55.0,    80.0,    30.0,    60.0,    30.0,    &
                11.0,    11.0,    11.0,     5.0,     5.0,    &
                 0.1,   100.0,    90.0,   100.0,   100.0,    &
               100.0,    15.0,    15.0,    25.0,    15.0,    &
                 7.0,    20.0,    10.0,    80.0,    30.0,    &
                 1.2,     5.0,     0.1,     0.1,     0.1   /
                    
      DATA VEG0_NLCD50                                       &
             /  00.0,     5.0,    90.0,    70.0,    40.0,    &
                15.0,    20.0,    15.0,    95.0,    90.0,    &
                95.0,    50.0,    75.0,    85.0,    80.0,    &
                80.0,    80.0,    50.0,    95.0,    95.0,    &
                90.0,    90.0,    90.0,    90.0,    90.0,    &
                85.0,    85.0,    85.0,    60.0,    60.0,    &
                 0.0,    90.0,    95.0,    95.0,    95.0,    &
                95.0,    90.0,    75.0,    80.0,    70.0,    &
                85.0,    75.0,    95.0,    40.0,    95.0,    &
                 5.0,    20.0,     0.0,     0.0,     0.0   /
                   
      DATA VEGMN0_NLCD50                                     &
             /  00.0,     2.0,    80.0,    60.0,    30.0,    &
                05.0,    05.0,     5.0,    50.0,    80.0,    &
                60.0,    20.0,    50.0,    60.0,    20.0,    &
                20.0,    20.0,    20.0,    80.0,    10.0,    &
                80.0,    80.0,    80.0,    80.0,    80.0,    &
                40.0,    40.0,    40.0,    20.0,    20.0,    &
                 0.0,    80.0,    85.0,    50.0,    50.0,    &
                60.0,    50.0,    50.0,    60.0,    50.0,    &
                60.0,    45.0,    10.0,    20.0,    40.0,    &
                 2.0,     5.0,     0.0,     0.0,     0.0   /
                     
      DATA LAI0_NLCD50                                       &
             /   0.0,     0.1,     3.0,     3.0,     3.0,    &
                 3.0,     1.0,     0.5,     5.0,     4.0,    &
                 5.0,     2.0,     2.5,     2.5,     2.0,    &
                 1.0,     1.0,     1.0,     3.0,     3.0,    &
                 5.0,     5.0,     3.0,     5.0,     3.0,    &
                 2.0,     2.0,     2.0,     1.0,     1.0,    &
                 0.0,     4.0,     5.0,     5.0,     5.0,    &
                 5.0,     3.0,     2.5,     2.5,     2.0,    &
                 2.5,     3.0,     3.0,     3.0,     3.0,    &
                 0.1,     1.0,     0.0,     0.0,     0.0   /
                    
      DATA LAIMN0_NLCD50                                     &
             /   0.0,     0.1,     1.0,     1.0,     1.0,    &
                 1.0,     0.5,     0.2,     1.0,     3.0,    &
                 2.0,     1.0,     1.0,     1.0,     1.0,    &
                 1.0,     1.0,     1.0,     1.0,     0.5,    &
                 2.0,     2.0,     1.0,     2.0,     1.0,    &
                 1.0,     1.0,     1.0,     0.5,     0.5,    &
                 0.0,     3.0,     4.0,     1.0,     1.0,    &
                 2.0,     1.0,     1.0,     1.0,     1.0,    &
                 1.0,     1.0,     0.5,     1.0,     1.0,    &
                 0.1,     0.5,     0.0,     0.0,     0.0   /

      DATA SNUP0_NLCD50                                      &
             /   0.01,    0.02,    0.04,    0.04,    0.04,   &
                 0.04,    0.02,    0.02,    0.08,    0.08,   &
                 0.08,    0.04,    0.04,    0.04,    0.01,   &
                 0.01,    0.01,    0.02,    0.04,    0.04,   &
                 0.08,    0.08,    0.04,    0.08,    0.04,   &
                 0.04,    0.06,    0.06,    0.02,    0.02,   &
                 0.08,    0.08,    0.08,    0.08,    0.08,   &
                 0.08,    0.03,    0.035,   0.03,    0.04,   &
                 0.04,   0.015,    0.04,    0.04,    0.04,   &
                 0.02,    0.02,    0.01,    0.01,    0.01  /

      DATA ALBF_NLCD50                                       &
             /   8.0,    60.0,    12.0,    11.0,    10.0,    &
                10.0,    20.0,    35.0,    15.0,    10.0,    &
                13.0,    20.0,    20.0,    19.0,    23.0,    &
                20.0,    20.0,    15.0,    18.0,    18.0,    &
                15.0,    15.0,    15.0,    15.0,    15.0,    &
                18.0,    18.0,    18.0,    10.0,    10.0,    &
                 8.0,    12.0,    12.0,    14.0,    16.0,    &
                13.0,    22.0,    20.0,    22.0,    20.0,    &
                19.0,    14.0,    18.0,    11.0,    18.0,    &
                60.0,    25.0,     8.0,     8.0,     8.0   /

      DATA SNOALB_NLCD50                                     &
             /  70.0,    82.0,    60.0,    46.0,    43.0,    &
                40.0,    75.0,    75.0,    40.0,    30.0,    &
                35.0,    65.0,    60.0,    70.0,    60.0,    &
                60.0,    60.0,    75.0,    68.0,    66.0,    &
                40.0,    40.0,    50.0,    50.0,    50.0,    &
                59.0,    59.0,    59.0,    50.0,    50.0,    &
                 8.0,    30.0,    30.0,    40.0,    40.0,    &
                35.0,    50.0,    60.0,    50.0,    50.0,    &
                70.0,    59.0,    66.0,    46.0,    68.0,    &
                82.0,    75.0,     8.0,    60.0,    75.0   /

!****************************************************************************************
!****************************************************************************************


!****************************************************************************************
!****************************************************************************************
! 40 CLASS MODIS (Outside US, cats 1-20)/NLCD (US only, cats 21-40) LU characterization
!-------------------------------------------------------------------------------
!Index Rstmin  Zo    Mxfr MnFr  MxLA MnLA SNUP  ALB SNOALB
!  1    175.   100.   93.  93.  5.5  3.5  0.08  12. 30.      Evergreen Needleleaf Forest
!  2    120.   90.    92.  92.  6.0  3.5  0.08  12. 30.      Evergreen Broadleaf Forest
!  3    175.   100.   60.  60.  3.0  1.5  0.08  14. 30.      Deciduous Needleleaf Forest
!  4    200.   100.   91.  91.  6.0  2.0  0.08  16. 40.      Deciduous Broadleaf Forest'
!  5    200.   100.   92.  92.  5.5  2.5  0.08  13. 35.      Mixed Forest
!  6    200.   15.    40.  20.  1.5  1.0  0.03  22. 50.      Closed Shrublands
!  7    200.   15.    20.  10.  1.5  1.3  0.035 20. 60.      Open Shrublands
!  8    150.   25.    70.  60.  2.3  2.0  0.03  22. 50.      Woody Savanna
!  9    120.   15.    70.  40.  1.5  1.5  0.04  20. 50.      Savanna
!-------------------------------------------------------------------------------
! 10    100.    7.    50.  20.  1.5  1.5  0.04  19. 70.      Grasslands
! 11    200    20.    65.  35.  2.5  2.0  0.08  15. 50.      Perminent Wetlands
! 12     70.   10.    90.  20.  3.5  1.5  0.04  18. 66.      Croplands
! 13    150.   80.     5.   5.  2.0  1.5  0.04  11. 46.      Urban andBuilt-up'
! 14    100.   30.    80.  40.  3.5  1.5  0.04  18. 68.      Cropland/Natural Vegetation Mosaic
! 15   9999.   1.2    0.1  0.1  0.1  0.1  0.02  60. 82.      Snow and Ice
! 16    100.    5.    0.5  0.5  0.2  0.1  0.02  25. 75.      Barren or Sparsely Vegetated
! 17   9999.   0.1    00.  00.  0.0  0.0  0.01  8.0 08.      IGBP water
! 18    175.   30.    70.  50.  3.4  2.0  0.80  15. 45.      wooded tundra
! 19    120.   15.    40.  20.  2.4  1.0  0.40  15. 50.      mixed tundra
! 20    100.   10.    20.   5.  1.4  0.1  .015  25. 75.      barren tundra
! 21   9999.   0.1    00.  00.  0.0  0.0  0.01  8.0 08.      Open water
! 22   9999.   1.2    0.1  0.1  0.1  0.1  0.02  60. 82.      Perennial Ice/snow
! 23    120.   30.    25.  25.  5.5  1.7  0.04  16. 60.      Developed, Open space
! 24    120.   80.    15.  15.  3.0  1.7  0.04  13. 46.      Developed, Low Intensity
! 25    140.   120.   5.   5.   2.5  1.7  0.04  11. 43.      Developed, Medium Intensity
! 26    160.   200.   1.   1.   2.5  2.0  0.04  10. 40.      Developed, High Intensity
! 27    100.    5.    0.5  0.5  0.2  0.1  0.02  20. 75.      Barren land
! 28    200.   100.   91.  91.  6.0  2.0  0.08  15. 40.      Deciduous Forest
! 29    175.   100.   93.  93.  5.5  3.5  0.08  12. 30.      Evergreen Forest
!-------------------------------------------------------------------------------
! 30    200.   100.   92.  92.  5.5  2.5  0.08  13. 35.      Mixed Forest
! 31    200.   10.    15.  10.  1.0  1.0  0.04  20. 65.      Dwarf Scrub
! 32    200.   15.    20.  10.  1.5  1.3  0.04  20. 60.      Shrub/Scrub
! 33    100.    7.    50.  20.  2.0  1.5  0.04  19. 70.      Grassland/Herbaceous
! 34    100.    7.    30.  20.  2.0  1.5  0.01  23. 60.      Sedge/Herbaceous
! 35    100.    5.    20.  20.  1.0  1.0  0.01  20. 60.      Lichens
! 36    100.    5.    20.  20.  1.0  1.0  0.01  20. 60.      Moss
! 37     80.    7.    80.  10.  3.5  1.5  0.04  18. 68.      Pasture/Hay'
! 38     70.   10.    90.  10.  4.0  1.5  0.04  18. 66.      Cultivated Crops
!-------------------------------------------------------------------------------
! 39    200.   55.    92.  50.  5.5  2.2  0.08  15. 40.      Woody Wetland
! 40    120.   11.    50.  30.  3.0  2.0  0.04  18. 50.      Emergent Herbaceous Wetland
!------------------------------------------------------------------------------------

      REAL, DIMENSION(40), TARGET  :: RSMIN_NLCD40, Z00_NLCD40,      &
                                      VEG0_NLCD40, VEGMN0_NLCD40,    &
                                      LAI0_NLCD40, LAIMN0_NLCD40,    &
                                      SNUP0_NLCD40, ALBF_NLCD40,     &
                                      SNOALB_NLCD40

      DATA RSMIN_NLCD40                                      &
             / 175.0,   120.0,   175.0,   200.0,    200.0,   &
               200.0,   200.0,   150.0,   120.0,    100.0,   &
               200.0,    70.0,   150.0,   100.0,   9999.0,   &
               100.0,  9999.0,   175.0,   120.0,    100.0,   &
              9999.0,  9999.0,   120.0,   120.0,    140.0,   &
               160.0,   100.0,   200.0,   175.0,    200.0,   &
               200.0,   200.0,   100.0,   100.0,    100.0,   &
               100.0,    80.0,    70.0,   200.0,    120.0  /

      DATA Z00_NLCD40                                        &
             / 100.0,    90.0,   100.0,   100.0,   100.0,    &
                15.0,    15.0,    25.0,    15.0,     7.0,    &
                20.0,    10.0,    80.0,    30.0,     1.2,    &
                 5.0,     0.1,    30.0,    15.0,    10.0,    &
                0.10,    1.20,    30.0,    80.0,   120.0,    &
               200.0,     5.0,   100.0,   100.0,   100.0,    &
                10.0,    15.0,     7.0,     7.0,     5.0,    &
                 5.0,     7.0,    10.0,    55.0,    11.0   /
                    
      DATA VEG0_NLCD40                                       &
             /  93.0,    92.0,    60.0,    91.0,    92.0,    &
                40.0,    20.0,    70.0,    70.0,    50.0,    &
                65.0,    90.0,     5.0,    80.0,     0.1,    &
                 0.5,     0.0,    70.0,    40.0,    20.0,    &
                 0.0,     0.1,    25.0,    15.0,     5.0,    &
                 1.0,     0.5,    91.0,    93.0,    92.0,    &
                15.0,    20.0,    50.0,    30.0,    20.0,    &
                20.0,    80.0,    90.0,    92.0,    50.0   /
                   
      DATA VEGMN0_NLCD40                                     &
             /  93.0,    92.0,    60.0,    91.0,    92.0,    &
                20.0,    10.0,    60.0,    40.0,    20.0,    &
                35.0,    20.0,     5.0,    40.0,     0.1,    &
                 0.5,     0.0,    50.0,    20.0,     5.0,    &
                 0.0,     0.1,    25.0,    15.0,     5.0,    &
                 1.0,     0.5,    91.0,    93.0,    92.0,    &
                10.0,    10.0,    20.0,    20.0,    20.0,    &
                20.0,    10.0,    10.0,    50.0,    30.0   /
                     
      DATA LAI0_NLCD40                                       &
             /   5.5,     6.0,     3.0,     6.0,     5.5,    &
                 1.5,     1.5,     2.3,     1.5,     1.5,    &
                 2.5,     3.5,     2.0,     3.5,     0.1,    &
                 0.2,     0.0,     3.4,     2.4,     1.4,    &
                 0.0,     0.1,     5.5,     3.0,     2.5,    &
                 2.5,     0.2,     6.0,     5.5,     5.5,    &
                 1.0,     1.5,     2.0,     2.0,     1.0,    &
                 1.0,     3.5,     4.0,     5.5,     3.0   /
                    
      DATA LAIMN0_NLCD40                                     &
             /   3.5,     3.5,     1.5,     2.0,     2.5,    &
                 1.0,     1.3,     2.0,     1.5,     1.5,    &
                 2.0,     1.5,     1.5,     1.5,     0.1,    &
                 0.1,     0.0,     2.0,     1.0,     0.1,    &
                 0.0,     0.1,     1.7,     1.7,     1.7,    &
                 2.0,     0.1,     2.0,     3.5,     2.5,    &
                 1.0,     1.3,     1.5,     1.5,     1.0,    &
                 1.0,     1.5,     1.5,     2.2,     2.0   /

      DATA SNUP0_NLCD40                                      &
             /   0.08,    0.08,    0.08,    0.08,    0.08,   &
                 0.03,    0.035,   0.03,    0.04,    0.04,   &
                 0.08,    0.04,    0.04,    0.04,    0.02,   &
                 0.02,    0.01,    0.80,    0.40,   0.015,   &
                 0.01,    0.02,    0.04,    0.04,    0.04,   &
                 0.04,    0.02,    0.08,    0.08,    0.08,   &
                 0.04,    0.04,    0.04,    0.01,    0.01,   &
                 0.01,    0.04,    0.04,    0.08,    0.04  /

      DATA ALBF_NLCD40                                       &
             /  12.0,    12.0,    14.0,    16.0,    13.0,    &
                22.0,    20.0,    22.0,    20.0,    19.0,    &
                17.0,    18.0,    11.0,    18.0,    60.0,    &
                25.0,     8.0,    15.0,    15.0,    25.0,    &
                 8.0,    60.0,    12.0,    11.0,    10.0,    &
                10.0,    20.0,    15.0,    12.0,    13.0,    &
                20.0,    20.0,    19.0,    23.0,    20.0,    &
                20.0,    18.0,    18.0,    15.0,    18.0   /

      DATA SNOALB_NLCD40                                     &
             /  30.0,    30.0,    30.0,    40.0,    35.0,    &
                50.0,    60.0,    50.0,    50.0,    70.0,    &
                50.0,    66.0,    46.0,    68.0,    82.0,    &
                75.0,     8.0,    45.0,    50.0,    75.0,    &
                 8.0,    82.0,    60.0,    46.0,    43.0,    &
                40.0,    75.0,    40.0,    30.0,    35.0,    &
                65.0,    60.0,    70.0,    60.0,    60.0,    &
                60.0,    68.0,    66.0,    40.0,    50.0   /

!****************************************************************************************
!****************************************************************************************
!  USGS LU characterization
!---------------------------
!     Name  Rstmin  Zo  Mxfr MnFr  MxLA MnLA ALB SNOALB  
! 1   Urban  150.   50.  40.  20.  2.0  0.5  15  46.     Urban or Built-up Land
! 2   DrCrp   70.   10.  95.  15.  3.0  0.5  17  66.     Dryland Cropland and Pasture
! 3   IrCrp   60.   10.  95.  10.  3.0  0.5  18  66.     Irrigated Cropland and Pasture
! 4   MixCp   70.   10.  95.  15.  3.0  0.5  18  66.     Mixed Dry/Irr Crop and Past
! 5   CrGrM   80.   10.  95.  35.  2.5  1.0  18  70.     Grassland/Cropland Mosaic
! 6   CrWdM  180.   40.  95.  40.  4.0  1.5  16  50.     Woodland/Cropland Mosaic
! 7   GrsLd  100.    7.  95.  70.  2.5  1.0  19  70.     Grassland
! 8   ShrLd  200.   20.  70.  50.  3.0  1.0  22  50.     Shrubland
! 9   ShrGr  150.   20.  85.  60.  3.0  1.0  20  60.     Mixed Shrubland/Grassland
! 10  Savan  120.   20.  80.  60.  2.0  1.0  20  50.     Savanna
! 11  DBFst  200.   50.  95.  50.  5.0  1.0  16  40.     Broadleaf Deciduous Forest
! 12  DNFst  175.   50.  95.  50.  5.0  1.0  14  30.     Deciduous Coniferous Forest
! 13  EBFst  120.   40.  95.  85.  5.0  4.0  12  30.     Evergreen Broadleaf Forest (Palm?)
! 14  ENFst  175.   50.  90.  80.  4.0  3.0  12  30.     Evergreen Coniferous Forest
! 15  MxFst  200.   50.  95.  60.  5.0  2.0  13  35.     Mixed forest
! 16  Water 9999.   0.1  00.  00.  0.0  0.0  08  08.     Water
! 17  HWtld  164.   15.  60.  40.  2.0  1.0  14  50.     Herbaceous Wetland (none in east)
! 18  WWtld  200.   45.  90.  80.  5.0  3.0  14  40.     Forested Wetlands (e.g. Everglades)
! 19  BarSp  100.    5.  10.  05.  0.5  0.2  25  75.     Barren or Sparsely Vegetated
! 20  HrTun  150.   10.  20.  10.  1.0  0.5  15  55.     Herbaceous Tundra
! 21  WdTun  200.   10.  30.  10.  1.0  0.5  15  60.     Shrub and Brush Tundra
! 22  MxTun  150.    5.  20.  05.  1.0  0.5  15  60.     Mixed Tundra
! 23  BGTun  100.    5.   5.  02.  0.1  0.1  25  75.     Bare Ground Tundra
! 24  SnwIc  300.    5.   5.  02.  0.1  0.1  55  82.     Perennial Snowfields or Glaciers
!-----------------------------------------------------------------------------

      REAL, DIMENSION(24), TARGET  :: RSMIN_USGS, Z00_USGS,   &
                                      VEG0_USGS, VEGMN0_USGS, &
                                      LAI0_USGS, LAIMN0_USGS, &
                                      SNUP0_USGS, ALBF_USGS,  &
                                      SNOALB_USGS

      DATA RSMIN_USGS                                        & 
             /  150.0,    70.0,    60.0,    70.0,    80.0,   &
                180.0,   100.0,   200.0,   150.0,   120.0,   &
                200.0,   175.0,   120.0,   175.0,   200.0,   &
               9999.0,   164.0,   200.0,   100.0,   150.0,   &
                200.0,   150.0,   100.0,   300.0           /

      DATA Z00_USGS                                          & 
             /   50.0,    10.0,    10.0,    10.0,    10.0,   &
                 40.0,     7.0,    20.0,    20.0,    20.0,   &
                 50.0,    50.0,    40.0,    50.0,    50.0,   &
                  0.1,    15.0,    45.0,     5.0,    10.0,   &
                 10.0,     5.0,     5.0,     5.0           /

      DATA VEG0_USGS                                         & 
             /   40.0,    95.0,    95.0,    95.0,    95.0,   &
                 95.0,    95.0,    70.0,    85.0,    80.0,   &
                 95.0,    95.0,    95.0,    90.0,    95.0,   &
                  0.00,   60.0,    90.0,    10.0,    20.0,   &
                 30.0,    20.0,     5.0,     5.0           /

      DATA VEGMN0_USGS                                       & 
             /   20.0,    15.0,    10.0,    15.0,    35.0,   &
                 40.0,    70.0,    50.0,    60.0,    60.0,   &
                 50.0,    50.0,    85.0,    80.0,    60.0,   &
                  0.0,    40.0,    80.0,     5.0,    10.0,   &
                 10.0,     5.0,     2.0,     2.0           /

      DATA LAI0_USGS                                         & 
             /    2.0,     3.0,     3.0,     3.0,     2.5,   &
                  4.0,     2.5,     3.0,     3.0,     2.0,   &
                  5.0,     5.0,     5.0,     4.0,     5.0,   &
                  0.0,     2.0,     5.0,     0.50,    1.0,   &
                  1.0,     1.0,     0.1,     0.1           /

      DATA LAIMN0_USGS                                       & 
             /    0.50,    0.50,    0.50,    0.50,    1.0,   &
                  1.5,     1.0,     1.0,     1.0,     1.0,   &
                  1.0,     1.0,     4.0,     3.0,     2.0,   &
                  0.0,     1.0,     3.0,     0.20,    0.50,  &
                  0.50,    0.50,    0.10,    0.10          /

      DATA SNUP0_USGS                                        & 
             /    0.04,    0.04,    0.04,    0.04,    0.04,  &
                  0.04,    0.04,    0.03,    0.035,   0.04,  &
                  0.08,    0.08,    0.08,    0.08,    0.08,  &
                  0.01,    0.01,    0.01,    0.02,    0.02,  &
                  0.025,   0.025,   0.025,   0.02          /

      DATA ALBF_USGS                                         & 
             /    15.0,   17.0,    18.0,    18.0,    18.0,   &
                  16.0,   19.0,    22.0,    20.0,    20.0,   &
                  16.0,   14.0,    12.0,    12.0,    13.0,   &
                   8.0,   14.0,    14.0,    25.0,    15.0,   &
                  15.0,   15.0,    25.0,    55.0           /

      DATA SNOALB_USGS                                       & 
             /    46.0,   66.0,    66.0,    66.0,    70.0,   &
                  50.0,   70.0,    50.0,    60.0,    50.0,   &
                  40.0,   40.0,    40.0,    30.0,    35.0,   &
                   8.0,   50.0,    40.0,    75.0,    55.0,   &
                  60.0,   60.0,    75.0,    82.0           /

!****************************************************************************************
!****************************************************************************************
!****************************************************************************************
!  USGS LU characterization
!---------------------------
!     Name  Rstmin  Zo  Mxfr MnFr  MxLA MnLA ALB SNOALB  
! 1   Urban  150.   50.  40.  20.  2.0  0.5  15  46.     Urban or Built-up Land
! 2   DrCrp   70.   10.  95.  15.  3.0  0.5  17  66.     Dryland Cropland and Pasture
! 3   IrCrp   60.   10.  95.  10.  3.0  0.5  18  66.     Irrigated Cropland and Pasture
! 4   MixCp   70.   10.  95.  15.  3.0  0.5  18  66.     Mixed Dry/Irr Crop and Past
! 5   CrGrM   80.   10.  95.  35.  2.5  1.0  18  70.     Grassland/Cropland Mosaic
! 6   CrWdM  180.   40.  95.  40.  4.0  1.5  16  50.     Woodland/Cropland Mosaic
! 7   GrsLd  100.    7.  95.  70.  2.5  1.0  19  70.     Grassland
! 8   ShrLd  200.   20.  70.  50.  3.0  1.0  22  50.     Shrubland
! 9   ShrGr  150.   20.  85.  60.  3.0  1.0  20  60.     Mixed Shrubland/Grassland
! 10  Savan  120.   20.  80.  60.  2.0  1.0  20  50.     Savanna
! 11  DBFst  200.   50.  95.  50.  5.0  1.0  16  40.     Broadleaf Deciduous Forest
! 12  DNFst  175.   50.  95.  50.  5.0  1.0  14  30.     Deciduous Coniferous Forest
! 13  EBFst  120.   40.  95.  85.  5.0  4.0  12  30.     Evergreen Broadleaf Forest (Palm?)
! 14  ENFst  175.   50.  90.  80.  4.0  3.0  12  30.     Evergreen Coniferous Forest
! 15  MxFst  200.   50.  95.  60.  5.0  2.0  13  35.     Mixed forest
! 16  Water 9999.   0.1  00.  00.  0.0  0.0  08  08.     Water
! 17  HWtld  164.   15.  60.  40.  2.0  1.0  14  50.     Herbaceous Wetland (none in east)
! 18  WWtld  200.   45.  90.  80.  5.0  3.0  14  40.     Forested Wetlands (e.g. Everglades)
! 19  BarSp  100.    5.  10.  05.  0.5  0.2  25  75.     Barren or Sparsely Vegetated
! 20  HrTun  150.   10.  20.  10.  1.0  0.5  15  55.     Herbaceous Tundra
! 21  WdTun  200.   10.  30.  10.  1.0  0.5  15  60.     Shrub and Brush Tundra
! 22  MxTun  150.    5.  20.  05.  1.0  0.5  15  60.     Mixed Tundra
! 23  BGTun  100.    5.   5.  02.  0.1  0.1  25  75.     Bare Ground Tundra
! 24  SnwIc  300.    5.   5.  02.  0.1  0.1  55  82.     Perennial Snowfields or Glaciers
! 25  playa  100.    5.  10.  05.  0.5  0.2  25  75.     Playa
! 26  lava   100.    5.  10.  05.  0.5  0.2  25  75.     Lava
! 27  sand   100.    5.  10.  05.  0.5  0.2  25  75.     White Sand
! 28  nana   100.    5.  10.  05.  0.5  0.2  25  75.     Unassigned
!-----------------------------------------------------------------------------

      REAL, DIMENSION(28), TARGET  :: RSMIN_USGS28, Z00_USGS28,   &
                                      VEG0_USGS28, VEGMN0_USGS28, &
                                      LAI0_USGS28, LAIMN0_USGS28, &
                                      SNUP0_USGS28, ALBF_USGS28,  &
                                      SNOALB_USGS28

      DATA RSMIN_USGS28                                      & 
             /  150.0,    70.0,    60.0,    70.0,    80.0,   &
                180.0,   100.0,   200.0,   150.0,   120.0,   &
                200.0,   175.0,   120.0,   175.0,   200.0,   &
               9999.0,   164.0,   200.0,   100.0,   150.0,   &
                200.0,   150.0,   100.0,   300.0,   100.0,   &
                100.0,   100.0,   100.0                    /

      DATA Z00_USGS28                                        & 
             /   50.0,    10.0,    10.0,    10.0,    10.0,   &
                 40.0,     7.0,    20.0,    20.0,    20.0,   &
                 50.0,    50.0,    40.0,    50.0,    50.0,   &
                  0.1,    15.0,    45.0,     5.0,    10.0,   &
                 10.0,     5.0,     5.0,     5.0,     5.0,   &
                  5.0,     5.0,     5.0                    /

      DATA VEG0_USGS28                                       & 
             /   40.0,    95.0,    95.0,    95.0,    95.0,   &
                 95.0,    95.0,    70.0,    85.0,    80.0,   &
                 95.0,    95.0,    95.0,    90.0,    95.0,   &
                 0.00,    60.0,    90.0,    10.0,    20.0,   &
                 30.0,    20.0,     5.0,     5.0,     5.0,   &
                  5.0,     5.0,     5.0                    /

      DATA VEGMN0_USGS28                                     & 
             /   20.0,    15.0,    10.0,    15.0,    35.0,   &
                 40.0,    70.0,    50.0,    60.0,    60.0,   &
                 50.0,    50.0,    85.0,    80.0,    60.0,   &
                  0.0,    40.0,    80.0,     5.0,    10.0,   &
                 10.0,     5.0,     2.0,     2.0,     2.0,   &
                  2.0,     2.0,     2.0                    /

      DATA LAI0_USGS28                                       & 
             /    2.0,     3.0,     3.0,     3.0,     2.5,   &
                  4.0,     2.5,     3.0,     3.0,     2.0,   &
                  5.0,     5.0,     5.0,     4.0,     5.0,   &
                  0.0,     2.0,     5.0,     0.50,    1.0,   &
                  1.0,     1.0,     0.1,     0.1,     0.1,   &
                  0.1,     0.1,     0.1                    /

      DATA LAIMN0_USGS28                                     & 
             /    0.50,    0.50,    0.50,    0.50,    1.0,   &
                  1.5,     1.0,     1.0,     1.0,     1.0,   &
                  1.0,     1.0,     4.0,     3.0,     2.0,   &
                  0.0,     1.0,     3.0,     0.20,    0.50,  &
                  0.50,    0.50,    0.10,    0.10,    0.10,  &
                  0.10,    0.10,    0.10                   /

      DATA SNUP0_USGS28                                      & 
             /    0.04,    0.04,    0.04,    0.04,    0.04,  &
                  0.04,    0.04,    0.03,    0.035,   0.04,  &
                  0.08,    0.08,    0.08,    0.08,    0.08,  &
                  0.01,    0.01,    0.01,    0.02,    0.02,  &
                  0.025,   0.025,   0.025,   0.02,    0.02,  &
                  0.02,    0.02,    0.02                   /

      DATA ALBF_USGS28                                       & 
             /    15.0,   17.0,    18.0,    18.0,    18.0,   &
                  16.0,   19.0,    22.0,    20.0,    20.0,   &
                  16.0,   14.0,    12.0,    12.0,    13.0,   &
                   8.0,   14.0,    14.0,    25.0,    15.0,   &
                  15.0,   15.0,    25.0,    55.0,    25.0,   &
                  10.0,   50.0,    50.0                    /

      DATA SNOALB_USGS28                                     & 
             /    46.0,   66.0,    66.0,    66.0,    70.0,   &
                  50.0,   70.0,    50.0,    60.0,    50.0,   &
                  40.0,   40.0,    40.0,    30.0,    35.0,   &
                   8.0,   50.0,    40.0,    75.0,    55.0,   &
                  60.0,   60.0,    75.0,    82.0,    75.0,   &
                  75.0,   75.0,    75.0                    /

!****************************************************************************************
!****************************************************************************************

END MODULE  module_sf_pxlsm_data
