PROGRAM interp
   USE wrf_metadata
   USE all_io
   USE date_pack
! computes mixing ratio and sfc p - see if we can keep the new sfc p calc.
!  USE diags
! file units
   USE file
   USE header_data
   USE phys_consts
   USE util

   IMPLICIT NONE

   INTEGER :: endtime ,  i ,  ialready ,  ifirst ,  immout ,  imx ,  imxexcg ,  imxm ,  index , &
              input_count ,  ioffset ,  iprocess ,  itimes ,  iunit ,  j ,  jmx ,  jmxexcg , &
              jmxm ,  joffset ,  k ,  k_loop ,  kx ,  kxs ,  levidn ,  loop ,  loop_count ,  lp

   INTEGER :: myear, mmon, mday, mhour, mmin, msec, my1, my2, my3, months, julday

   REAL :: ds , nestds , pt

   REAL , DIMENSION(100) :: newcoord

   REAL , ALLOCATABLE , DIMENSION(:) :: p , pup , vcoord

   REAL , ALLOCATABLE , DIMENSION(:,:) :: coriolis , ground_t , ksafec , ksafed , land_use , latitcrs , &
                                          latitdot , longicrs , longidot , mapfaccr , mapfacdt , &
                                          ps0csmall , ps0dot , ps0dsmall , pscsmall , psdsmall , psealvlc , &
                                          psealvld , pstarcrs , pstardot , sfc_p , sfc_rh , sfc_t , &
                                          sfc_theta , sfc_u , sfc_v , snowcovr , terrain , terrdot , &
                                          tseasfc , w_top

   !  NAMELIST local data.

   CHARACTER (LEN=132) , DIMENSION(100) :: input_file

   INTEGER :: start_year , start_month , start_day , start_hour , start_minute=0 , start_second=0 , start_frac=0
   INTEGER ::   end_year ,   end_month ,   end_day ,   end_hour ,   end_minute=0 ,   end_second=0 ,   end_frac=0
   INTEGER :: interval
   LOGICAL :: less_than_24h=.FALSE.
   LOGICAL :: wrth2o=.TRUE.

   REAL :: ptop = -1

!KWM START
   INTEGER :: psfc_method
   REAL , ALLOCATABLE , DIMENSION(:,:) :: avgsfct
!KWM END

   CHARACTER (LEN=80) :: simulation_name, user_desc
   INTEGER            :: si_version

   !  local meta data

   CHARACTER (LEN=32) :: projection
   CHARACTER (LEN= 8) :: known_loc
   CHARACTER (LEN= 4) :: lu_source

   REAL               :: known_lat, known_lon, stand_lats, stand_lons
   REAL               :: delta_x, delta_y
   INTEGER            :: lu_water, lu_ice, st_water

   CHARACTER (LEN=  20) :: output_prefix
   CHARACTER (LEN= 132) :: output_name, metafile_name

   CHARACTER (LEN=  19) , ALLOCATABLE :: time_list(:)


   !  Process the namelist file.  The namelist is read, the data is
   !  brought back to the main program, a few tests are run on
   !  the local variables, and the sigma is tested.

   CALL do_namelist ( input_file ,  &
                      start_year , start_month , start_day , start_hour , &
                      start_minute , start_second , start_frac , &
                      end_year ,   end_month ,   end_day ,   end_hour , &
                      end_minute ,   end_second ,   end_frac , &
                      interval , less_than_24h , &
                      ptop , wrth2o , &
                      psfc_method , &
                      simulation_name, user_desc )

   !  set 'si_version' here and we may know its significance later

   si_version = 0

   !  The date info was contained in the namelist.  When to start and
   !  when to end, interval.

   WRITE ( start_date ,  &
           '(I4.4,"-",I2.2,"-",I2.2,"_",I2.2,":",I2.2,":",I2.2)') &
           start_year , start_month , start_day , start_hour , &
           start_minute , start_second

   current_date = start_date

   WRITE ( end_date ,  &
           '(I4.4,"-",I2.2,"-",I2.2,"_",I2.2,":",I2.2,":",I2.2)') &
           end_year , end_month , end_day , end_hour , &
           end_minute , end_second

   PRINT '(A)','Time periods to process'
   loop_count = 0
   which_times : DO 

      loop_count = loop_count + 1
      IF ( loop_count .GT. 1000 ) THEN
         PRINT '(A)','Seems like a lot of loops.'
         STOP 'lots_of_loops_check_dates'
      END IF

      IF ( current_date .EQ. end_date ) THEN
         PRINT '(A,A,A)','Found ending time ',current_date,'.'
         iprocess = loop_count
         EXIT which_times
      ELSE IF ( current_date .LT. end_date ) THEN
            PRINT '(A,A,A)','Found valid time ',current_date,'.'
      ELSE
         iprocess = loop_count -1 
         EXIT which_times
      END IF

      CALL geth_newdate ( new_date , current_date , interval ) 
      current_date = new_date

   END DO which_times

!  if needed, can activate this line

!  ALLOCATE (time_list(loop_count))

   !  This is some more I/O set up.  This OPENS the pressure level
   !  data set with logical unit 50 (input_press), and with the name specified
   !  in the NAMELIST file.

   input_count = 1
   CALL get_fg_file ( input_file(input_count) , input_press ) 

   !  Once we have the pressure level data ready to read, we
   !  can procees.  We process the data in the big header first.
   !  The big header data comes out of this routine, and is available
   !  via the USE association for header_data.

   CALL read_bh ( input_press )

   !  Some of this big header information is important.  Particularly, we
   !  pick up the horizontal size of the domain.  This allows us to go ahead
   !  and ALLOCATE some space a bit later.

   imx = bhi(16,1)
   jmx = bhi(17,1)
   kx  = bhi(12,bhi(1,1))
   ds  = bhr( 9,1)
   index = bhi(1,1)

   IF      ( ptop .LT. 0 ) THEN
      ptop = bhr(2,2)
      PRINT '(A,F8.2,A)','Using PTOP from the REGRID header: ',ptop,' Pa.'
   ELSE IF ( ptop .GT. bhr(2,2) ) THEN
      PRINT '(A,F8.2,A)','Using PTOP from the namelist.input file: ',ptop,' Pa.'
      bhr(2,2) = ptop
   ELSE IF ( ABS ( ptop - bhr(2,2) ) .LT. 0.1 ) THEN
      PRINT '(A,F8.2,A)','Using PTOP from the namelist.input file: ',ptop,' Pa.'
      bhr(2,2) = ptop
   ELSE
      PRINT '(A,F8.2,A)','PTOP from header = ',bhr(2,2),' Pa.'
      PRINT '(A,F8.2,A)','PTOP from the namelist.input file = ',ptop,' Pa.'
      PRINT '(A)','Namelist value must be .GE. header value.'
      STOP 'bad_ptop_choice'
   END IF

   imxm = imx - 1
   jmxm = jmx - 1
  
   !  Define most global meta data here: may move this to a subroutine

   global_meta%simulation_name = simulation_name
   global_meta%user_desc       = user_desc
   global_meta%si_version      = si_version
   global_meta%anal_version    = 0
   global_meta%wrf_version     = 1
   global_meta%post_version    = 1

   if ( bhi(7,1) .eq. 1 ) then
       projection(1:32) = 'LAMBERT CONFORMAL               '
   else if ( bhi(7,1) .eq. 2 ) then
       projection(1:32) = 'POLAR STEREOGRAPHIC             '
   else if ( bhi(7,1) .eq. 3 ) then
       projection(1:32) = 'MERCATOR                        '
   end if

   global_meta%map_projection     = projection

   global_meta%moad_known_lat     = bhr(2,1)
   global_meta%moad_known_lon     = bhr(3,1)
   !  for nest, need to compute center lat/lon, overwrites this later
   global_meta%moad_stand_lats(1) = bhr(5,1)
   global_meta%moad_stand_lats(2) = bhr(6,1)
   global_meta%moad_stand_lons(1) = bhr(3,1)
   global_meta%moad_known_loc     = 'CENTER  '

   global_meta%moad_delta_x       = bhr(9,1)
   global_meta%moad_delta_y       = bhr(9,1)

   global_meta%num_stagger_z = 1
   global_meta%stagger_dir_z(:) = 0.

   global_meta%horiz_stagger_type = 'AR-C'
   global_meta%num_stagger_xy = 4 ! (T,U, and V grids plus non-staggered grid) - may need to change

!  t_ind = 1
!  u_ind = 2
!  v_ind = 3
!  n_ind = 4

   global_meta%stagger_dir_x(t_ind) = 0.5  ! T grid (equivalent to cross-point)
   global_meta%stagger_dir_y(t_ind) = 0.5  !

   global_meta%stagger_dir_x(u_ind) = 0.0  ! U grid
   global_meta%stagger_dir_y(u_ind) = 0.5  !

   global_meta%stagger_dir_x(v_ind) = 0.5  ! V grid
   global_meta%stagger_dir_y(v_ind) = 0.0  !

   global_meta%stagger_dir_x(n_ind) = 0.0  ! Non-staggered (equivalent to dot-point)
   global_meta%stagger_dir_y(n_ind) = 0.0

   global_meta%num_stagger_z        = 1
   global_meta%stagger_dir_z(:)     = 0.

   global_meta%vertical_coord = 'PRESSURE'
   global_meta%num_domains    = bhi(13,1)

   if ( bhi(23,1) .eq. 16 ) then
        global_meta%lu_source      = 'USGS'
        global_meta%lu_water       = 16
        global_meta%lu_ice         = 24
        global_meta%st_water       = 14
   else if ( bhi(23,1) .eq. 7 ) then
        global_meta%lu_source      = 'OLD'
        global_meta%lu_water       = 7
        global_meta%lu_ice         = 11
        global_meta%st_water       = 14
   else 
        stop 'must use USGS landuse'
   end if
   
   !  Define most domain meta data here: may move this to a subroutine
   !  Populate as many of the domain metadata fields as possible

   dom_meta%id = bhi(13,1)
   dom_meta%parent_id = bhi(14,1)
   dom_meta%dyn_init_src = 'MM5     '
   dom_meta%static_init_src = 'MM5     '
   dom_meta%origin_parent_x = bhi(19,1)
   dom_meta%origin_parent_y = bhi(18,1)
   dom_meta%origin_parent_z = 1
   dom_meta%ratio_to_parent = int(bhr(1,1)/bhr(9,1)+0.01)
   dom_meta%delta_x = bhr(9,1)
   dom_meta%delta_y = bhr(9,1)
   dom_meta%top_level = bhr(2,2)
   dom_meta%xdim = bhi(17,1)
   dom_meta%ydim = bhi(16,1)
   dom_meta%zdim = kx

!  missing corner lats/lons are filled in subroutine prepare_data

   print *, dom_meta

   !  Loop over all of the time periods in the pressure level input
   !  data.  We only pick the times that match the requested values 
   !  from the NAMELIST file.  The number of vertical pressure levels
   !  is permitted to change between times, so the ALLOCATION of 3D
   !  pressure data occurs when we know how big the vertical component
   !  will be.
 
   ALLOCATE ( allp_3d( 20) )
   ALLOCATE ( all_2d (100) )
   ALLOCATE ( all_1d ( 20) )

!  Need to temporarily close input file unit
!  print *, 'temporarily close file with unit ', input_press
   CLOSE (input_press)

   ALLOCATE ( avgsfct     ( IMX , JMX ) )
!  calculate averaged sfc T and can use it for substrate temp
!  if ( ( psfc_method .eq. 1 ) .and. ( .not. less_than_24h ) ) then
   if ( .not. less_than_24h ) then
      CALL average_surface_T_over_time(input_file, imx, jmx, avgsfct, end_date)
   endif

!  After calculating average surface temp, reopen file
!  print *, 'Re-opening input file'
   input_count = 1
   CALL get_fg_file ( input_file(input_count) , input_press )
   CALL read_bh ( input_press )

   output_prefix = 'hinterp'
   itimes = 0
   current_date = start_date

   time_loop : DO 
 
      !  READ the data for this time.  This is a loop over an unknown
      !  number of variables.  We READ flags, headers and data until we
      !  find the flag that signifies the end of the time.  The data for
      !  the allp_3d, all_2d and all_1d is just the input data from the
      !  pressure level data set.  This is available from USE association
      !  of the input_data module.

      DO loop = 1 , 20
         NULLIFY(allp_3d(loop)%array)
         NULLIFY(all_1d(loop)%array)
      END DO
      DO loop = 1 , 100
         NULLIFY(all_2d(loop)%array)
      END DO

      bhi(1,1) = index

      CALL read_data ( input_press , input_file , input_count , kx )

      !  What was the date in the small header for this time period?

      test_date = sh_date

      !  Is this one of the times that we requested?

      IF ( test_date .LT. current_date ) THEN
         PRINT '(A,A,A)','Skipping ',test_date,'.  Reading another time.'
    
         !  We need to deallocate the following fields since they are pressure-level
         !  based, and we are allowed to change the number of pressure levels between
         !  time periods.
   
         DO loop = 1 , 20
            IF ( ASSOCIATED(allp_3d(loop)%array) ) THEN
               DEALLOCATE ( allp_3d(loop)%array )
            END IF
            IF ( ASSOCIATED(all_1d(loop)%array ) ) THEN
               DEALLOCATE ( all_1d(loop)%array )
            END IF
         END DO
         DO loop = 1 , 100
            IF ( ASSOCIATED ( all_2d(loop)%array ) ) THEN
               DEALLOCATE ( all_2d(loop)%array )
            END IF
         END DO
         CYCLE time_loop
      ELSE IF ( test_date .GT. current_date ) THEN
         PRINT '(A)','Seemed to have gone past the right time.'
         STOP 'past_right_time'
      ELSE 
         PRINT '(A,A,A)','Will process time ',test_date,'.'
      END IF

      !  Some more I/O things.  This sets up the names of the output files.
      !  The bhi(13,1) is the domain ID, so that we can use a number and 
      !  the current date to build file names like 
      !  hinterp.d0x.yyyy-mm-dd_hh:00:00
 
      CALL open_out_file ( output_file_unit , output_prefix, test_date, bhi(13,1) )

      !  convert yyyy-mm-dd_hh:00:00 to vt_date (yyyyjjj) and vt_time (sec since 0000 UTC)
      CALL mm5_to_wrf_date(test_date,dom_meta%vt_date,dom_meta%vt_time)
print *, 'New dates : ', test_date, dom_meta%vt_date,dom_meta%vt_time

      IF ( test_date .EQ. start_date ) THEN

      !  Fill initial date and time here

         global_meta%init_date      = dom_meta%vt_date
         global_meta%init_time      = dom_meta%vt_time

      END IF

      !  Calculate Julian date to prepare for vegfra interpolation

      CALL split_date_char (test_date,myear,mmon,mday,mhour,mmin,msec)

      my1 = mod(myear, 4)
      my2 = mod(myear, 100)
      my3 = mod(myear, 400)

      IF (my1.eq.0.and.my2.ne.0.or.my3.ne.0) days_in_month(2) = 29

      julday = mday

      DO months = 1, mmon-1
         julday = julday + days_in_month(months)
      END DO

      print *, 'Calculated Julian Day is ', julday

      !  Since this is one of the time periods that we have requested, bump the counter
      !  that tells us howm many of these time periods we actually have under our belt.

      itimes = itimes + 1

      bhr(2,2) = ptop

      PRINT '(A,I3,A,I3,A)','Data read for grid #',bhi(13,1),', time period:',itimes,'.'

      !  Prepare MM5 data for SI output format
      CALL prepare_data ( avgsfct, wrth2o, less_than_24h, psfc_method, julday )

      !  Define variable meta data
      CALL proc_make_variable_metadata(bhi(13,1),dom_meta%vt_date,dom_meta%vt_time)

      !  Output MM5 data
      CALL proc_output_variable(test_date , output_file_unit )

      ! Update the ending time of the global metadata
      global_meta%end_date = dom_meta%vt_date
      global_meta%end_time = dom_meta%vt_time

      !  Go back and process the next time until finished with all requested time periods.

      PRINT '(A)','-----------------------'
      PRINT *,'FINISHED TIME PERIOD:',ITIMES
      PRINT '(A)','-----------------------'
 
      !  We need to deallocate the following fields since they are pressure-level
      !  based, and we are allowed to change the number of pressure levels between
      !  time periods.

      DO loop = 1 , 20
         IF ( ASSOCIATED(allp_3d(loop)%array) ) THEN
            DEALLOCATE ( allp_3d(loop)%array )
         END IF
         IF ( ASSOCIATED(all_1d(loop)%array ) ) THEN
            DEALLOCATE ( all_1d(loop)%array )
         END IF
      END DO
      DO loop = 1 , 100
         IF ( ASSOCIATED ( all_2d(loop)%array ) ) THEN
            DEALLOCATE ( all_2d(loop)%array )
         END IF
      END DO

      !  What we really need is a brand new time for our processing.  Given the
      !  "current" date and the interval specified in the namelist, we now know
      !  the "new" time that this next loop will process.

      CALL geth_newdate ( new_date , current_date , interval ) 
      current_date = new_date
           
      !  Of course, we may not want to process the "new" time if it is beyond the
      !  range of the valid times that were specified in the namelist.

      IF ( current_date .gt. end_date ) THEN
         EXIT time_loop
      END IF

      CLOSE ( output_file_unit )

   END DO time_loop

   !  We are almost finished.  Just a few mop up activities.  Clean up our heap.

   DEALLOCATE ( avgsfct )
        
   !  Write global metadata
   global_meta%vertical_coord='PRESSURE'

   CALL proc_store_global_metadata (output_meta_unit, output_prefix)

   CLOSE ( output_meta_unit )

   PRINT '(A)','-------------------------------------------------'
   PRINT '(A,I1)','FINISHED INTERP FOR DOMAIN ID #',bhi(13,1)
   PRINT '(A)','-------------------------------------------------'
   PRINT '(A)','STOP 99999'

END PROGRAM interp
