MODULE util

   USE header_data
   USE map_utils

CONTAINS

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE get_new_fields ( alpha, mapfac_u, mapfac_v, xlat, xlon, jmx, imx )

      IMPLICIT NONE

      !  Input variables

      INTEGER , INTENT(IN)           :: JMX, IMX
      REAL    , INTENT(IN)           :: xlat        ( : , : )
      REAL    , INTENT(IN)           :: xlon        ( : , : )
      REAL    , INTENT(INOUT)        :: alpha       ( : , : )
      REAL    , INTENT(INOUT)        :: mapfac_u    ( : , : )
      REAL    , INTENT(INOUT)        :: mapfac_v    ( : , : )

      !  lat and long values of dot grid (1,1) 
      REAL                           :: xlatc, xlonc, conef, tlat1, tlat2, ds, lat1, lon1, latc, lonc
      INTEGER                        :: nx, ny, I, J
      REAL                           :: lat, lon, x, y, colat, colat1, rad_per_deg
      !REAL    , ALLOCATABLE , DIMENSION(:,:)        :: lat, lon

      !  data structure to use map_utils

      TYPE(proj_info) :: proj

      !  Define domain setup from TERRAIN header

      rad_per_deg = 57.29578
      xlatc= bhr(2,1)
      xlonc= bhr(3,1)
      conef= bhr(4,1)
      tlat1= bhr(5,1)
      tlat2= bhr(6,1)
      ds   = bhr(9,1)
      nx   = bhi(17,1)
      ny   = bhi(16,1)
      print *, 'JMX,IMX,NX,NY : ', JMX,IMX,NX,NY
      lat1 = xlat(1,1)
      lon1 = xlon(1,1)
      IF (bhi(13,1).EQ.1) THEN
         latc = xlatc
         lonc = xlonc
      ELSE
         latc = xlat( (nx+1)/2, (ny+1)/2 )
         lonc = xlon( (nx+1)/2, (ny+1)/2 )
      END IF

      !  Set up initializations for map projection (defined from TERRAIN header) 

      IF( bhi(7,1) .EQ. 1 )THEN
         CALL map_set ( proj_lc,   lat1, lon1, latc, lonc, ds, xlonc, tlat1, tlat2, nx, ny, proj )
      ELSE IF ( bhi(7,1) .EQ. 2 ) THEN
         CALL map_set ( proj_ps,   lat1, lon1, latc, lonc, ds, xlonc, tlat1, tlat2, nx, ny, proj )
      ELSE IF ( bhi(7,1) .EQ. 3 ) THEN
         CALL map_set ( proj_merc, lat1, lon1, latc, lonc, ds, xlonc, tlat1, tlat2, nx, ny, proj )
      END IF

      print *, 'CONE FACTOR : ', conef, proj%cone

      !  calculate rotation angel
      DO i = 1 , imx
         DO j = 1 , jmx
            CALL compute_projrot(xlat(j,i), xlon(j,i), latc, lonc, proj, alpha(j,i))
         END DO
      END DO

      !  calculate map scale factor for u on c grid
      DO i = 1 , imx-1
         y = float(i)+0.5
         DO j = 1 , jmx
            x = float(j)
            CALL ij_to_latlon(proj, x, y, lat, lon)
            if ( bhi(7,1) .EQ. 1 ) then
                CALL compute_msf_lc(lat, tlat1, tlat2, mapfac_u(j,i))
            else if ( bhi(7,1) .EQ. 2) then
                CALL compute_msf_ps(lat, tlat1, mapfac_u(j,i))
            else if ( bhi(7,1) .EQ. 3) then
                if(abs(lat) .eq. 90.)then
                    mapfac_u(j,i) = 0.
                    stop 'cannot compute msf for mercator proj at pole'
                endif
                colat  = (90. - lat)*rad_per_deg
                colat1 = (90. - tlat1)*rad_per_deg
                mapfac_u(j,i) = SIN(colat1) / SIN(colat)  
            end if
         END DO
      END DO

      !  calculate map scale factor for v on c grid
      DO i = 1 , imx
         y = float(i)
         DO j = 1 , jmx-1
            x = float(j)+0.5
            CALL ij_to_latlon(proj, x, y, lat, lon)
            if ( bhi(7,1) .EQ. 1 ) then
                CALL compute_msf_lc(lat, tlat1, tlat2, mapfac_v(j,i))
            else if ( bhi(7,1) .EQ. 2) then
                CALL compute_msf_ps(lat, tlat1, mapfac_v(j,i))
            else if ( bhi(7,1) .EQ. 3) then
                if(abs(lat) .eq. 90.)then
                    mapfac_v(j,i) = 0.
                    stop 'cannot compute msf for mercator proj at pole'
                endif
                colat  = (90. - lat)*rad_per_deg
                colat1 = (90. - tlat1)*rad_per_deg
                mapfac_v(j,i) = sin(colat1) / sin(colat) 
            end if
         END DO
      END DO

   END SUBROUTINE get_new_fields

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE invert (dum3d, imx, jmx, kx, scr)

      IMPLICIT NONE

      INTEGER                     :: I, IMX
      INTEGER                     :: J, JMX
      INTEGER                     :: K, KX

      REAL                        :: DUM3D       ( : , : , : )
      REAL                        :: SCR         ( : , : , : )

      DO k = 1, KX
         DO j = 1 , jmx
            DO i = 1 , imx
               dum3d(j,i,k) = scr(i,j,k)
            END DO
         END DO
      END DO

   END SUBROUTINE invert

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE invert2d (dum2d, imx, jmx, scr)

      IMPLICIT NONE

      INTEGER                     :: I, IMX
      INTEGER                     :: J, JMX

      REAL                        :: DUM2D       ( : , : )
      REAL                        :: SCR         ( : , : )

      DO j = 1 , jmx
         DO i = 1 , imx
            dum2d(j,i) = scr(i,j)
         END DO
      END DO

   END SUBROUTINE invert2d

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE b2c_u (dum3d, jmx, imx, kx, scr)

      IMPLICIT NONE

      INTEGER                     :: I, IMX
      INTEGER                     :: J, JMX
      INTEGER                     :: K, KX

      REAL                        :: DUM3D       ( : , : , : )
      REAL                        :: SCR         ( : , : , : )

      DO k = 1, KX
         DO j = 1 , jmx
            DO i = 1 , imx-1
               scr(j,i,k) = ( dum3d(j,i,k) + dum3d(j,i+1,k) ) * 0.5
            END DO
         END DO
      END DO

      scr(:,imx,:) = scr(:,imx-1,:)

      dum3d = scr

   END SUBROUTINE b2c_u

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE b2c_v (dum3d, jmx, imx, kx, scr)

      IMPLICIT NONE

      INTEGER                     :: I, IMX
      INTEGER                     :: J, JMX
      INTEGER                     :: K, KX

      REAL                        :: DUM3D       ( : , : , : )
      REAL                        :: SCR         ( : , : , : )

      DO k = 1, KX
         DO j = 1 , imx
            DO i = 1 , jmx-1
               scr(j,i,k) = ( dum3d(j,i,k) + dum3d(j+1,i,k) ) * 0.5
            END DO
         END DO
      END DO

      scr(jmx,:,:) = scr(jmx-1,:,:)

      dum3d = scr

   END SUBROUTINE b2c_v

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   
   SUBROUTINE crs2dot(field,dim1,dim2)
   
      IMPLICIT NONE

      INTEGER :: dim1 , dim2
      REAL , DIMENSION(dim1,dim2) :: field,dummy
      INTEGER :: i , j 
      
      dummy(2:dim1-1,2:dim2-1)           = ( field(1:dim1-2,1:dim2-2) + &
                                             field(1:dim1-2,2:dim2-1) + &
                                             field(2:dim1-1,1:dim2-2) + &
                                             field(2:dim1-1,2:dim2-1) ) * 0.25
   
      dummy(2:dim1-1,1:dim2:dim2-1)      = ( field(1:dim1-2,1:dim2-1:dim2-2) + &
                                             field(2:dim1-1,1:dim2-1:dim2-2) ) * 0.5
   
      dummy(1:dim1:dim1-1,2:dim2-1)      = ( field(1:dim1-1:dim1-2,1:dim2-2) + &
                                             field(1:dim1-1:dim1-2,2:dim2-1) ) * 0.5
   
      dummy(1:dim1:dim1-1,1:dim2:dim2-1) =   field(1:dim1-1:dim1-2,1:dim2-1:dim2-2)
   
      field                              =   dummy
   
   END SUBROUTINE crs2dot

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE dot2crs(field,dim1,dim2)

      IMPLICIT NONE

      INTEGER :: dim1 , dim2
      REAL , DIMENSION(dim1,dim2) :: field
      INTEGER :: i , j 
      DO j = 1 , dim2 - 1
         DO i = 1 , dim1 - 1
            field(i,j) = ( field(i  ,j  ) + & 
                           field(i+1,j  ) + & 
                           field(i  ,j+1) + & 
                           field(i+1,j+1) ) * 0.25
         END DO
      END DO

   END SUBROUTINE dot2crs

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE clean_rh ( rh , iew , jns , kx , rh_min , rh_max )

      IMPLICIT NONE
   
      INTEGER                             :: iew , jns , kx
      REAL , DIMENSION ( iew , jns , kx ) :: rh
      REAL                                :: rh_min , rh_max
   
      rh(iew,:,:) = rh(iew-1,:,:)
      rh(:,jns,:) = rh(:,jns-1,:)

      WHERE ( rh .GT. rh_max ) rh = rh_max
      WHERE ( rh .LT. rh_min ) rh = rh_min
   
   END SUBROUTINE clean_rh

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE fill (f, ix, jx, imx, jmx, ifirst, ilast, jfirst, jlast)

      IMPLICIT NONE

      INTEGER                     :: I
      INTEGER                     :: IFIRST
      INTEGER                     :: ILAST
      INTEGER                     :: IMX
      INTEGER                     :: IX
      INTEGER                     :: J
      INTEGER                     :: JFIRST
      INTEGER                     :: JLAST
      INTEGER                     :: JMX
      INTEGER                     :: JX

      REAL                        :: F           ( : , : )

      DO j = jfirst, jlast
         DO i = 1, ifirst - 1
            f(i,j) = f(ifirst,j)
         END DO
         DO i = ilast + 1, imx
            f(i,j) = f(ilast,j)
         END DO
      END DO

      DO j = 1, jfirst - 1
         f(:,j) = f(:,jfirst)
      END DO
      DO j = jlast + 1, jmx
         f(:,j) = f(:,jlast)
      END DO

   END SUBROUTINE fill

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE smoother_desmoother ( slab , imx , jmx , passes , crsdot )
   
      IMPLICIT NONE
   
      INTEGER                        :: imx , jmx , passes , crsdot
      REAL , DIMENSION ( imx , jmx ) :: slab , & 
                                        slabnew
   
      REAL , DIMENSION ( 2 )         :: xnu
      INTEGER                        :: i , j , loop , n 
   
      xnu  =  (/ 0.50 , -0.52 /)
   
      !  The odd number passes of this are the "smoother", the even
      !  number passes are the "de-smoother" (note the differnt signs on xnu).
   
      smoothing_passes : DO loop = 1 , passes * 2
   
         n  =  2 - MOD ( loop , 2 )
    
         DO i = 2 , imx - 1 - crsdot
            DO j = 2 , jmx - 1 - crsdot
               slabnew(i,j) = slab(i,j) + xnu(n) *  & 
               ((slab(i,j+1) + slab(i,j-1)) * 0.5-slab(i,j))
            END DO
         END DO
    
         DO i = 2 , imx - 1 - crsdot
            DO j = 2 , jmx - 1 - crsdot
               slab(i,j) = slabnew(i,j)
            END DO
         END DO
    
         DO j = 2 , jmx - 1 - crsdot
            DO i = 2 , imx - 1 - crsdot
               slabnew(i,j) = slab(i,j) + xnu(n) *  &
               ((slab(i+1,j) + slab(i-1,j)) * 0.5-slab(i,j))
            END DO
         END DO
    
         DO i = 2 , imx - 1 - crsdot
            DO j = 2 , jmx - 1 - crsdot
               slab(i,j) = slabnew(i,j)
            END DO
         END DO
    
      END DO smoothing_passes
   
   END SUBROUTINE smoother_desmoother

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   SUBROUTINE smooth_5 ( field , iew , jns , passes , crsdot )

      IMPLICIT NONE
   
      INTEGER                        :: iew , jns , &
                                        passes    , &
                                        crsdot
      REAL , DIMENSION ( iew , jns ) :: field
   
      REAL , DIMENSION ( iew , jns ) :: temp
      INTEGER                        :: i , j , num_passes
   
      !  How may passes of this smoother are we using.
   
      smoothing_passes : DO num_passes = 1 , passes
   
         !  Apply 5-point stencil smoother on interior of the domain.
      
         DO j = 2 , jns - 1 - crsdot
            DO i = 2 , iew - 1 - crsdot
               temp(i,j) = ( field(i  ,j  ) * 4. +  & 
                             field(i+1,j  )      +  & 
                             field(i-1,j  )      +  & 
                             field(i  ,j+1)      +  & 
                             field(i  ,j-1)      )  * 0.125
            END DO
         END DO
   
         !  Apply 3-point stencil smoother on the boundaries.
      
         i = 1
         DO j = 2 , jns - 1 - crsdot
            temp(i,j) = ( field(i  ,j  ) * 2. +  & 
                          field(i  ,j+1)      +  & 
                          field(i  ,j-1)      )  * 0.25
         END DO
   
         i = iew - crsdot
         DO j = 2 , jns - 1 - crsdot
            temp(i,j) = ( field(i  ,j  ) * 2. +  & 
                          field(i  ,j+1)      +  & 
                          field(i  ,j-1)      )  * 0.25
         END DO
      
         j = 1
         DO i = 2 , iew - 1 - crsdot
            temp(i,j) = ( field(i  ,j  ) * 2. +  & 
                          field(i+1,j  )      +  & 
                          field(i-1,j  )      ) * 0.25
         END DO
      
         j = jns - crsdot
         DO i = 2 , iew - 1 - crsdot
            temp(i,j) = ( field(i  ,j  ) * 2. +  & 
                          field(i+1,j  )      +  & 
                          field(i-1,j  )      ) * 0.25
         END DO
      
         !  Store smoothed field back into original array.
      
         DO j = 2 , jns - 1 - crsdot
            DO i = 2 , iew - 1 - crsdot
               field(i,j) = temp(i,j)
            END DO
         END DO
      
         !  Store smoothed boundary field back into original array.
      
         DO j = 2 , jns - 1 - crsdot
            field(1         ,j) = temp(1         ,j)
            field(iew-crsdot,j) = temp(iew-crsdot,j)
         END DO
      
         DO i = 2 , iew - 1 - crsdot
            field(i,1         ) = temp(i,1         )
            field(i,jns-crsdot) = temp(i,jns-crsdot)
         END DO
   
      END DO smoothing_passes
   
   END SUBROUTINE smooth_5

END MODULE util
