SUBROUTINE DA_Transform_XToY_Gpspw ( xb, iv, xa, xp, y )

   IMPLICIT NONE

   TYPE (xb_type), INTENT(IN)   :: xb       ! first guess state.
   TYPE (ob_type), INTENT(IN)   :: iv       ! Innovation vector (O-B).
   TYPE (x_type),  INTENT(IN)   :: xa       ! gridded analysis increment.
   TYPE (xpose_type), INTENT(IN):: xp       ! Domain decomposition vars.
   TYPE (y_type), INTENT(INOUT) :: y        ! y = h (xa)

   INTEGER                      :: n        ! Loop counter.
   INTEGER                      :: i, j     ! Index dimension.
   REAL                         :: dx, dxm  ! 
   REAL                         :: dy, dym  !
   
   IF ( iv%num_Gpspw > 0 ) THEN

      y % gpspw(:)% tpw = 0.0

      do n=1, iv % num_Gpspw

       if(iv%gpspw(n)%loc%proc_domain_with_halo) then

         i = iv%gpspw(n)%loc%i
         dy = iv%gpspw(n)%loc%dy
         dym = iv%gpspw(n)%loc%dym
         j = iv%gpspw(n)%loc%j
         dx = iv%gpspw(n)%loc%dx
         dxm = iv%gpspw(n)%loc%dxm

! Mathematical transformation:

         y % gpspw(n)% tpw = dym* ( dxm * xa%tpw(i,j) + &
                                    dx  * xa%tpw(i+1,j) ) + &
                             dy * ( dxm * xa%tpw(i,j+1) + &
                                    dx  * xa%tpw(i+1,j+1) )
       endif

      end do

   ENDIF

END SUBROUTINE DA_Transform_XToY_Gpspw

