SUBROUTINE da_get_innov_vector_gpsref ( it, xb, xp, ob, iv )

!-------------------------------------------------------------------------
   IMPLICIT NONE

   INTEGER, INTENT(IN)             :: it       ! External iteration.
   TYPE (xb_type), INTENT(IN)      :: xb       ! first guess state.
   TYPE (xpose_type), INTENT(IN)   :: xp       ! Domain decomposition vars.
   TYPE (y_type),  INTENT(IN)      :: ob       ! Observation structure.
   TYPE (ob_type), INTENT(INOUT)   :: iv       ! O-B structure.

   INTEGER                         :: n        ! Loop counter.
   INTEGER                         :: i, j, k  ! Index dimension.
   INTEGER                         :: num_levs ! Number of obs levels.
   REAL                            :: dx, dxm  ! Interpolation weights.
   REAL                            :: dy, dym  ! Interpolation weights.
   REAL, DIMENSION(1:max_ob_levels) :: model_ref !Model gpsref at ob loc

   INTEGER           :: pref, fref

   IF ( iv%num_gpsref < 1 ) RETURN

   pref = 0 ; fref = 0

   DO n=1, iv%num_gpsref

      if(iv%gpsref(n)%loc%proc_domain_with_halo) then

         num_levs = iv%gpsref(n)%info%levels

         if ( num_levs < 1 ) cycle

         model_ref(:) = 0.0

!        Get cross pt. horizontal interpolation weights:

         i = iv%gpsref(n)%loc%i
         j = iv%gpsref(n)%loc%j
         dx = iv%gpsref(n)%loc%dx
         dy = iv%gpsref(n)%loc%dy
         dxm = iv%gpsref(n)%loc%dxm
         dym = iv%gpsref(n)%loc%dym

#ifndef DEREF_KLUDGE
         call Interp_lin_3D( xb%ref, xp, i, j, dx, dy, dxm, dym, &
                             model_ref, max_ob_levels, iv%gpsref(n)%zk, num_levs )
#else
         call Interp_lin_3D( xb%ref(xp%ims,xp%jms,xp%kms), xp, i, j, dx, dy, dxm, dym, &
                             model_ref(1), max_ob_levels, iv%gpsref(n)%zk(1), num_levs )
#endif

         do k = 1, num_levs

            iv%gpsref(n)%ref(k)%inv = 0.0

            if ( ob%gpsref(n)%ref(k) > missing_r .AND. &
                 iv%gpsref(n)%ref(k)%qc >= obs_qc_pointer ) THEN

                 iv%gpsref(n)%ref(k)%inv = ob%gpsref(n)%ref(k) - model_ref(k)
            endif

         enddo
      endif

      IF ( check_max_iv ) &
         CALL da_check_max_iv_gpsref(it, iv%gpsref(n), pref, fref )

   END DO

   write(unit = check_max_iv_unit, FMT ='(A,i5,A)') &
        'For outer iteration ',it, &
        ', Total Rejections for GPSRef follows:'
   write(unit = check_max_iv_unit, FMT = '(/,10(2(A,I6),/))') &
        'Number of failed gpsrefes observations:', &
                   fref, ' on ',pref

END SUBROUTINE da_get_innov_vector_gpsref

