SUBROUTINE DA_Transfer_MM5ToXb( iy, jx, kz, xp, xb_mm5, xb, xbx )

!------------------------------------------------------------------------------
!  PURPOSE: Transfers fields from MM5 to first guess structure.
!
!  METHOD:  
!
!  HISTORY: 01/06/2000 - Creation of F90 version.           Dale Barker
!
!  PARENT_MODULE: DA_Setup_Structures
!------------------------------------------------------------------------------

   IMPLICIT NONE
   
   INTEGER, intent(in)                :: iy           ! Array size.
   INTEGER, intent(in)                :: jx           ! Array size.
   INTEGER, intent(in)                :: kz           ! Array size.   
   TYPE (xpose_type), intent(in)      :: xp           ! Domain decomposition vars.
   TYPE (mm5_model_type), INTENT(IN)  :: xb_mm5       ! MM5 model structure.
   TYPE (xb_type), INTENT(INOUT)      :: xb           ! First guess state
   TYPE (xbx_type),INTENT(INOUT)      :: xbx          ! Header & non-gridded vars.

   INTEGER                            :: is,ie   ! Range of 1st dimension of arrays.
   INTEGER                            :: js,je   ! Range of 2nd dimension of arrays.
   INTEGER                            :: ks,ke   ! Range of 3rd dimension of arrays.
   INTEGER                            :: i,j,k        ! Loop counter

   REAL                               :: ta,gamma,zcld
   REAL                               :: tpw,alw,zrhom,htpw
   REAL                               :: dum1

   REAL, DIMENSION(xb%mkz)            :: zh
   REAL, DIMENSION(xb%mkz+1)          :: zf
   REAL, DIMENSION(xb%mkz)            :: dsigma

! Set xb array range indices for processor subdomain.
   is = xp%its
   ie = xp%ite
   js = xp%jts
   je = xp%jte
   ks = xp%kts
   ke = xp%kte

   xb%map  = xb_mm5%big_header%bhi(7,1)
   xb%ds   = xb_mm5%big_header%bhr(9,1)

!---------------------------------------------------------------------------
!  [1.0] MM5-specific fields:
!---------------------------------------------------------------------------

   ptop = xb_mm5%big_header%bhr(2,2)
   ps0  = xb_mm5%big_header%bhr(2,5)
   ts0  = xb_mm5%big_header%bhr(3,5)
   tlp  = xb_mm5%big_header%bhr(4,5)
   tis0 = xb_mm5%big_header%bhr(5,5)

!  do k=ks,ke
!     print *, 'xb_mm5%sigmah (', k, ')=', xb_mm5%sigmah (k)
!  enddo

   xb%sigmah (ks:ke) = xb_mm5%sigmah (ks:ke)
   xb%sigmaf_0 = 0.0

   dsigma(ks) = 2.0 * ( xb%sigmah(ks) - xb%sigmaf_0 )
   xb%sigmaf(ks) = xb%sigmaf_0 + dsigma(ks)

   do k = ks+1,ke
     dsigma(k) = 2.0 * (xb%sigmah(k) - xb%sigmaf(k-1))
     xb%sigmaf(k) = xb%sigmaf(k-1) + dsigma(k)
   enddo

   xb%ptop = xb_mm5%big_header%bhr(2,2)
   xb%ps0  = xb_mm5%big_header%bhr(2,5)
   xb%ts0  = xb_mm5%big_header%bhr(3,5)
   xb%tlp  = xb_mm5%big_header%bhr(4,5)
   xb%tis0 = xb_mm5%big_header%bhr(5,5)

   xb%num_of_var = xb_mm5%num_of_var
   xb%psac (is:ie,js:je) = xb_mm5%psac (is:ie,js:je)
   xbx%mminlu = xb_mm5%big_header%bhic(23,1)(1:4)
   xbx%big_header = xb_mm5%big_header
   xbx%sub_header(:) = xb_mm5%sub_header(:)

!  Calculate means for later use in setting up background errors.  !ajb

   xbx%psac_mean = SUM( xb_mm5%psac(1:iy-1,1:jx-1) ) / REAL((iy-1)*(jx-1))

   allocate ( xbx%latc_mean(1:iy) )

   if(xb%map == 2) then
      do i = 1, iy    
        xbx%latc_mean(i) = SUM( xb_mm5%latc(1:iy-1,1:jx-1) ) / REAL((iy-1)*(jx-1))
      end do
   else
      do i = 1, iy    
        xbx%latc_mean(i) = SUM( xb_mm5%latc(i,1:jx-1) ) / REAL(jx-1)
      end do
   endif

   do j=js,je
   do i=is,ie
      call DA_Ref_height(ptop, xb%ztop)

      do k=1,kz
         call DA_Ref_height(xb%Psac(i,j) * xb%sigmah(k) + ptop, xb%h(i,j,k))
         call DA_Ref_height(xb%Psac(i,j) * xb%sigmaf(k) + ptop, xb%hf(i,j,k))

         xb%p (i,j,k) = xb_mm5%pp_c(i,j,k) &
                      + xb%Psac(i,j) * xb%sigmah(k) + ptop
      enddo

      xb%psfc(i,j) = xb_mm5%pp_c(i,j,kz)+xb%psac(i,j)+ptop
   enddo
   enddo

!---------------------------------------------------------------------------
!  [2.0] Transfer across MM5 fields read in:
!---------------------------------------------------------------------------

   xb%u (is:ie,js:je,ks:ke) = xb_mm5%u (is:ie,js:je,ks:ke)
   xb%v (is:ie,js:je,ks:ke) = xb_mm5%v (is:ie,js:je,ks:ke)
   xb%t (is:ie,js:je,ks:ke) = xb_mm5%t (is:ie,js:je,ks:ke)
   xb%q (is:ie,js:je,ks:ke) = xb_mm5%q (is:ie,js:je,ks:ke)
   xb%w (is:ie,js:je,ks:ke+1) = xb_mm5%w (is:ie,js:je,ks:ke+1)

   xb%map_factor(is:ie,js:je) = xb_mm5%msfc(is:ie,js:je)

!  Exchange halo for map_factor and psac.
   xb%cori (is:ie,js:je) = xb_mm5%cori (is:ie,js:je)
   xb%tgrn (is:ie,js:je) = xb_mm5%tgrn (is:ie,js:je)
   xb%lat  (is:ie,js:je) = xb_mm5%latc (is:ie,js:je)
   xb%lon  (is:ie,js:je) = xb_mm5%lonc (is:ie,js:je)
   xb%terr (is:ie,js:je) = xb_mm5%terr (is:ie,js:je)
   xb%lanu (is:ie,js:je) = xb_mm5%lanu (is:ie,js:je)
   xb%snow (is:ie,js:je) = xb_mm5%snow (is:ie,js:je)
   xb%landmask (is:ie,js:je) = xb_mm5%landmask (is:ie,js:je)
  
!------------------------------------------------------------------------------
!  [3.0] Calculate vertical inner product for use in vertical transform:
!------------------------------------------------------------------------------
      
!  Use hydrostatic definition of deltap(i,j,k) = pstar(i,j) * dsigma(k)

   IF ( vertical_ip == 1 ) THEN
   
!     Vertical inner product is SQRT(Delta p):
      DO k = ks, ke
         xb%vertical_inner_product(is:ie,js:je,k) = &
                                     SQRT( xb%psac(is:ie,js:je) * dsigma(k) ) 
      END DO
      
   ELSE IF ( vertical_ip == 2 ) THEN

!     Vertical inner product is Delta p:
      DO k = ks, ke
         xb%vertical_inner_product(is:ie,js:je,k) = &
                                           xb%psac(is:ie,js:je) * dsigma(k)   
      END DO
   
   END IF

!------------------------------------------------------------------------------
!  [4.0] Calculate density:
!------------------------------------------------------------------------------

   xb%rho(is:ie,js:je,ks:ke) = xb%p(is:ie,js:je,ks:ke) /  &
                                   ( gas_constant * xb%t(is:ie,js:je,ks:ke) )

!------------------------------------------------------------------------------
!  [5.0] Calculate 1/grid box areas:
!------------------------------------------------------------------------------

   xb%grid_box_area(is:ie,js:je) = xb%ds * xb%ds / &
                ( xb%map_factor(is:ie,js:je) * xb%map_factor(is:ie,js:je) )

!------------------------------------------------------------------------------
!  [6.0] Calculate saturation vapour pressure and relative humidity:
!------------------------------------------------------------------------------

   do j = js,je
   do k = ks, ke
   do i = is,ie
      call DA_TPQ_To_RH( xb%t(i,j,k), xb%p(i,j,k), xb%q(i,j,k), &
                         xb%es(i,j,k), xb%qs(i,j,k), xb%rh(i,j,k) )
   end do
   end do
   end do
                          
!  Calculate dew point temperature:

   call DA_TRH_To_TD ( xb%rh, xb%t, xb%td, xp )

!  Sea level pressure and total precipitable water

   do i = is, ie
      do j = js, je
         CALL DA_TPQ_to_SLP( xb%t(i,j,:), xb%q(i,j,:), xb%p(i,j,:), &
                             xb%terr(i,j), xb%Psac(i,j), xb%slp(i,j), &
                             xb%sigmah(:) )
      enddo
   enddo

   CALL INTEGRAT_dZ ( xb )

!  Roughness

   call roughness_from_lanu(19, xbx%mminlu, xbx%sub_header(1)%current_date, &
                            xp, xb%lanu, xb%rough)

!  Surface Wind speed SH Chen

   do j=js,je
      do i=is,ie
         CALL DA_Transform_XToSeaSfcWind( xb%u(i,j,kz),xb%v(i,j,kz), &
                                          xb%speed(i,j),xb%h(i,j,kz)  )
      enddo
   enddo

!  Brightness temperature SH Chen

   do j=js,je
      do i=is,ie

      zf(1) = xb%ztop
      do k=1,kz
         zh(k) = xb%h(i,j,k)
         zf(k+1) = xb%hf(i,j,k)
      enddo

      ta    = xb%tgrn(i,j) + &
              (xb%t(i,j,kz)-xb%tgrn(i,j))*log(2./0.0001)/ &
              log(zh(kz)/0.0001)

      gamma = (ta-270)*0.023 + 5.03  ! effective lapse rate   (km) (4.0 - 6.5)
      zcld  = 1                           ! effective cloud height (km)
                                               ! = 1 if no cloud infomation
      tpw   = xb%tpw(i,j) * 10.
      alw   = 0.

      call DA_Transform_XToZRhoQ(xb, i, j, zh, zf, zrhom)

      htpw  = zrhom/tpw/1000.

      call tb(1,53.,0.01*xb%psfc(i,j),ta,gamma,xb%tgrn(i,j),tpw,htpw,xb%speed(i,j),alw,zcld,       &
              xb%tb19v(i,j),xb%tb19h(i,j)                            )
      call tb(2,53.,0.01*xb%psfc(i,j),ta,gamma,xb%tgrn(i,j),tpw,htpw,xb%speed(i,j),alw,zcld,       &
              xb%tb22v(i,j),dum1                                     )
      call tb(3,53.,0.01*xb%psfc(i,j),ta,gamma,xb%tgrn(i,j),tpw,htpw,xb%speed(i,j),alw,zcld,       &
              xb%tb37v(i,j),xb%tb37h(i,j)                            )
      call tb(4,53.,0.01*xb%psfc(i,j),ta,gamma,xb%tgrn(i,j),tpw,htpw,xb%speed(i,j),alw,zcld,       &
              xb%tb85v(i,j),xb%tb85h(i,j)                            )

!-----Calculate surface variable(wind, moisture, temperature)
!-----sfc variables: 10-m wind, and 2-m T, Q, at cross points

      call sfc_wtq(xb%psfc(i,j), xb%tgrn(i,j), &
                   xb%p(i,j,kz), xb%t(i,j,kz), xb%q(i,j,kz), &
                   xb%u(i,j,kz), xb%v(i,j,kz), &
                   xb%p(i,j,kz-1), xb%t(i,j,kz-1), xb%q(i,j,kz-1), &
                   xb%h(i,j,kz), xb%rough(i,j),xb%landmask(i,j), &
                   xb%u10(i,j), xb%v10(i,j), xb%t2(i,j), xb%q2(i,j), &
                   xb%regime(i,j))
   enddo
   enddo

END SUBROUTINE DA_Transfer_MM5ToXb

