!MEDIATION_LAYER:SOLVER
!-------------------------------------------------------------------------
!  History:
!
!     Additions:        07/16/2003                    S. R. H. Rizvi
!
!      (a) Added "minimise_option" to accomodate the choice of two   
!          minimisation schemes as follows
!              1. Quasi Newton   2. Conjugate Gradient  
!      (b) DA_Add_PBL_And_SFC_Info is called to update the backround PBL 
!          and surface field information
!      (c) In outer loop "xhat" array is added to account for
!          increment control variable for effective implementation
!          of the outer loop
!         
!-------------------------------------------------------------------------
!

SUBROUTINE solve_v3d ( grid , &
!
#include <em_dummy_args.inc>
!
                 )


! Driver layer modules
   USE module_domain
   USE module_configure
   USE module_driver_constants
   USE module_machine
   USE module_tiles
   USE module_dm
! Mediation layer modules
! Model layer modules
   USE module_model_constants

   USE DA_Constants
   USE DA_Define_Structures
   USE DA_Setup_Structures
   USE DA_Test
   USE DA_Tools
   USE DA_Minimisation
   USE par_util

! Registry generated module
   USE module_state_description

   IMPLICIT NONE

   !  Input data.

   TYPE(domain) , TARGET          :: grid

   !  Definitions of dummy arguments to solve
#include <em_dummy_decl.inc>

   ! WRF state data

   ! Local data

!ajb Declare dummy for mminlu to get past character(len=4) typedef deficiency.
   character(len=4) dmminlu

!ajb xa and xb are declared in the Registry

   TYPE (xbx_type)              :: xbx         ! For header & non-grid arrays.
   TYPE (be_type)               :: be          ! Background error structure.
   TYPE (be_type)               :: be_g        ! be on globally-dimensioned grid
   TYPE (y_type)                :: ob          ! Observation structure.
   TYPE (ob_type)               :: iv          ! Obs. increment structure.
   TYPE (y_type)                :: re          ! Residual (o-a) structure.
   TYPE (y_type)                :: y           ! y = H(x_inc) structure.
   TYPE (cv_type)               :: cv1d        ! Control variable structure (local processor grid).
   INTEGER                      :: it          ! External loop counter.
   type (j_type)                :: j           ! Cost function.

   INTEGER                      :: ids , ide , jds , jde , kds , kde , &
                                   ims , ime , jms , jme , kms , kme , &
                                   ips , ipe , jps , jpe , kps , kpe

   INTEGER                      :: its,ite,jts,jte,kts,kte
   TYPE (cv_type)               :: xhat  ! Increament control variable

! storage for tendencies and decoupled state (generated from Registry)
#include <em_i1_decl.inc>

!------------------------------------------------------------------------------

   write (6, '(/,A,/)') ' *** 3-DIMENSIONAL VARIATIONAL ANALYSIS ***'

!------------------------------------------------------------------------------
!  [1.0] Read 3DVAR namelist:
!------------------------------------------------------------------------------

   CALL DA_Read_Namelist

!******************************************************************************
! INTITIALIZE
!******************************************************************************

   call da_init_3dvar( grid, xp, &
                   ids, ide, jds, jde, kds, kde, &
                   ims, ime, jms, jme, kms, kme, &
                   ips, ipe, jps, jpe, kps, kpe )

!******************************************************************************
! END INITIALIZATION
!******************************************************************************

!------------------------------------------------------------------------------
!  copy xp dimension parameter to xb.
!------------------------------------------------------------------------------

   xb%ids = xp%ids
   xb%ide = xp%ide
   xb%jds = xp%jds
   xb%jde = xp%jde
   xb%kds = xp%kds
   xb%kde = xp%kde

   xb%ims = xp%ims
   xb%ime = xp%ime
   xb%jms = xp%jms
   xb%jme = xp%jme
   xb%kms = xp%kms
   xb%kme = xp%kme

   xb%its = xp%its
   xb%ite = xp%ite
   xb%jts = xp%jts
   xb%jte = xp%jte
   xb%kts = xp%kts
   xb%kte = xp%kte

   its = xp%its
   ite = xp%ite
   jts = xp%jts
   jte = xp%jte
   kts = xp%kts
   kte = xp%kte

!------------------------------------------------------------------------------
!  [2.0] Set up first guess field (xb):
!------------------------------------------------------------------------------

   CALL DA_Setup_FirstGuess( xbx, grid, &
!
#include <em_dummy_args.inc>
!
                           )

!------------------------------------------------------------------------------
!  [3.0] Set up background errors (be):
!------------------------------------------------------------------------------

   write(unit=*, fmt='(a, i8)') &
        'cv_options=', cv_options

  if(cv_options==2)then

   CALL DA_Setup_Background_Errors( xb, xbx, be_g )

!  Create local be arrays and deallocate global copies.

   call be_local_copy( be_g, be, jts, jte, kts, kte )

  else if(cv_options==3)then

   CALL DA_Setup_Background_Errors3( xb,be,xp )

  endif

!------------------------------------------------------------------------------
!  [4.0] Set up observations (ob):
!------------------------------------------------------------------------------

   call DA_Setup_Obs_Structures( xb, xbx, xp, ob, iv )

!------------------------------------------------------------------------------
!  [5.0] Allocate cv:
!------------------------------------------------------------------------------

   call calculate_cv_local_size( xp, be, cv1d, cv_size )
   call da_allocate_cv( cv_size, cv1d )
   call da_allocate_cv( cv_size, xhat )
      
   call da_allocate_y( iv, re )
   call da_allocate_y( iv, y )

!------------------------------------------------------------------------------
!  [6.0] Test:
!------------------------------------------------------------------------------

   if ( test_transforms .or. Testing_3DVAR ) then
      CALL da_get_innov_vector( it, xb, xp, ob, iv )

      call da_check( xb, xbx, be, iv, cv1d, &
                     xa, vv, vp, xp, ob, y, &
                    ids, ide, jds, jde, kds, kde, &
                    ims, ime, jms, jme, kms, kme, &
                    its, ite, jts, jte, kts, kte )
   endif

!------------------------------------------------------------------------------
!  [7.0] Loop over O-B calculation adn minimization:
!------------------------------------------------------------------------------

   DO it = 1, max_ext_its

!     [7.1] Calculate innovation vector (O-B):
      CALL da_get_innov_vector( it, xb, xp, ob, iv )

!     [7.2] Minimize cost function:

      if(minimisation_option == 1) then
      CALL DA_Minimise( it, ob, xb, xbx, be, iv,xhat%array, &
                        cv1d, xa, vv, vp, xp, re, y, j,     &
                        ids, ide, jds, jde, kds, kde,       &
                        ims, ime, jms, jme, kms, kme,       &
                        its, ite, jts, jte, kts, kte )
      else if(minimisation_option == 2) then
      CALL DA_CG_Minimise(it, ob, xb, xbx, be, iv, xhat%array, &
                        cv1d, xa, vv, vp, xp, re, y,j,         &
                        ids, ide, jds, jde, kds, kde,          &
                        ims, ime, jms, jme, kms, kme,          &
                        its, ite, jts, jte, kts, kte )
      else
         write(unit=*, fmt='(a)') 'Wrong minimisation_option.'
      endif

!     [7.3] Update latest analysis solution:

      call da_zero_x ( xa )

      call da_transform_vtox( xb, xbx, be, xhat%array, vv, vp, xp, xa,  &
                              ids, ide, jds, jde, kds, kde,             &
                              ims, ime, jms, jme, kms, kme,             &
                              its, ite, jts, jte, kts, kte )

      if (sfc_assi_options == 2) then
         call DA_Transform_XToWTQ ( xp, xb, xa )
      endif

!-----Exchange XA halo region.
      CALL wrf_dm_halo(xp%domdesc,xp%comms,xp%halo_id4)

      if (sfc_assi_options == 2) then
!--------Exchange XA (surface variable) halo region.
         CALL wrf_dm_halo(xp%domdesc,xp%comms,xp%halo_id6)
      endif

      if ( use_ssmt1obs .or. use_ssmt2obs .or. Use_GpspwObs .or. &
           Use_SsmiTbObs .or. Use_SsmiRetrievalObs ) then

!--------Now do something for PW
         call DA_Transform_XToTPW( xa, xb )

         if ( use_ssmt1obs .or. use_ssmt2obs .or. &
              Use_SsmiTbObs .or. Use_SsmiRetrievalObs ) then
            call DA_Transform_XToSeaSfcWind_Lin( xa, xb )
         endif

         if ( Use_SsmiTbObs ) call DA_Transform_XToTb_Lin (xa, xb)

!--------Exchange XA halo region.
         CALL wrf_dm_halo(xp%domdesc,xp%comms,xp%halo_id8)
      endif

!     [7.4] Only when use_RadarObs = .false. and W_INCREMENTS =.true., 
!           the W_increment need to be diagnosed:

     if (W_INCREMENTS .and. .not.use_RadarObs) &
         CALL DA_UVPRho_To_W_Lin( xb, xa,                     &
                                  ids,ide, jds,jde, kds,kde,  &
                                  ims,ime, jms,jme, kms,kme,  &
                                  its,ite, jts,jte, kts, kte )

      CALL DA_Write_Diagnostics( ob, iv, re, y, xp, xa, j )

!------------------------------------------------------------------------------
!  [8.0] Output 3DVAR analysis and analysis increments:
!------------------------------------------------------------------------------

      call DA_Transfer_XatoWRF( xbx, grid, &
!
#include <em_dummy_args.inc>
!
                           )

      if(it < max_ext_its) then
         CALL DA_Transfer_WRFToXb( xbx, grid, &
#include <em_dummy_args.inc>
                           )

!        CALL DA_Add_Increments( it, xp, xa, xb )
!        CALL DA_Add_PBL_And_SFC_Info( xp, xb, xbx )
      endif

   END DO

!------------------------------------------------------------------------------
!  [9.0] Tidy up:
!------------------------------------------------------------------------------

   call da_deallocate_cv( cv1d )
   call da_deallocate_cv( xhat )
   call da_deallocate_y( re )
   call da_deallocate_y( y )
   
   write(6,'(a)') ' *** 3DVAR completed successfully ***'
   write(6,*)

   CALL wrf_debug ( 200 , ' call end of solve_v3d' )

CONTAINS

#include "da_init_3dvar.inc"

END SUBROUTINE solve_v3d

