#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>

#include "protos.h"
#include "registry.h"
#include "data.h"

#define DUMMY 1
#define ACTUAL 2 

int
gen_scalar_derefs ( char * dirname )
{
  int i ;
  
  for ( i = 0 ; i < get_num_cores() ; i++ )
    scalar_derefs ( dirname , get_corename_i(i) ) ; 
  return(0) ;
}

int
scalar_derefs ( char * dirname , char * corename )
{
  FILE * fp ;
  char  fname[NAMELEN] ;
  char * fn = "_scalar_derefs.inc" ;
  char * p ;
  int linelen ;
  char outstr[64*4096] ;

  if ( dirname == NULL || corename == NULL ) return(1) ;
  if ( strlen(dirname) > 0 ) 
   { sprintf(fname,"%s/%s%s",dirname,corename, fn) ; }
  else                       
   { sprintf(fname,"%s%s",corename,fn) ; }

  if ((fp = fopen( fname , "w" )) == NULL ) return(1) ;
  print_warning(fp,fname) ;
  linelen = 0 ;
  if ( sw_limit_args ) {
    fprintf(fp,"#undef SOURCE_RECORD\n") ;
    fprintf(fp,"#undef DEST_RECORD\n") ;
    fprintf(fp,"#ifdef COPY_OUT\n") ;
    fprintf(fp,"#  define SOURCE_RECORD\n") ;
    fprintf(fp,"#  define DEST_RECORD grid%%\n") ;
    fprintf(fp,"#else\n") ;
    fprintf(fp,"#  define DEST_RECORD\n") ;
    fprintf(fp,"#  define SOURCE_RECORD grid%%\n") ;
    fprintf(fp,"#endif\n") ;
    scalar_derefs1 ( fp , corename , &Domain ) ;
    fprintf(fp,"#undef COPY_IN\n") ;
    fprintf(fp,"#undef COPY_OUT\n") ;
    fprintf(fp,"#undef DEST_RECORD\n") ;
    fprintf(fp,"#undef SOURCE_RECORD\n") ;
    fprintf(fp,"#undef DEST_RECORD\n") ;
  }
  close_the_file( fp ) ;
  return(0) ;
}

int
scalar_derefs1 ( FILE * fp , char * corename, node_t * node )
{
  node_t * p ;
  int tag ;
  char fname[NAMELEN] ;

  if ( node == NULL ) return(1) ;
  for ( p = node->fields ; p != NULL ; p = p->next )
  {
    if ( p->node_kind & I1 ) continue ;              /* short circuit any field that is not state */
                                                     /* short circuit DERIVED types */
    if ( p->type->type_type == DERIVED ) continue ;
                                                     /* short circuit non-scalars */
    if ( p->ndims > 0 ) continue ; 

    if (                 (
                                                   /* if it's a core specific field and we're doing that core or... */
          (p->node_kind & FIELD && (!strncmp("dyn_",p->use,4)&&!strcmp(corename,p->use+4))) ||
                                                   /* it is not a core specific field and it is not a derived type -ajb */
          (p->node_kind & FIELD && (p->type->type_type != DERIVED) && ( strncmp("dyn_",p->use,4))) ||
                                                   /* it is a state variable */
          (p->node_kind & RCONFIG )
                         )
       )
    {
      for ( tag = 1 ; tag <= p->ntl ; tag++ )
      {
        /* if this is a core-specific variable, prepend the name of the core to */
        /* the variable at the driver level */
        if (!strcmp( corename , p->use+4 ))
          sprintf(fname,"%s_%s",corename,field_name(t4,p,(p->ntl>1)?tag:0)) ;
        else
          strcpy(fname,field_name(t4,p,(p->ntl>1)?tag:0)) ;
        /* generate deref */
        fprintf(fp," DEST_RECORD %s = SOURCE_RECORD %s\n",fname,fname) ;
      }
    }
  }
  return(0) ;
}

