SUBROUTINE da_setup_obs_structures_mm5( xb, xbx, xp, ob, iv )

!------------------------------------------------------------------------------
! PURPOSE: Define, allocate and read of observation structure.
!
! METHOD:  Define, allocate and read of observation structure.
!
! HISTORY: 01/20/2000 - Creation of F90 version.           Dale Barker
!          10/19/2001 - Mods for parallel implementation.  Al Bourgeois
!
! PARENT_MODULE: DA_Setup_Structures
!------------------------------------------------------------------------------

   IMPLICIT NONE

   TYPE (xb_type), INTENT(IN)   :: xb          ! Background structure   
   TYPE (xbx_type),INTENT(IN)   :: xbx         ! Header & non-gridded vars.
   TYPE (xpose_type), INTENT(IN) :: xp         ! Domain decomposition vars.
   TYPE ( y_type), INTENT(OUT)  :: ob          ! Observation structure.
   TYPE (ob_type), INTENT(OUT)  :: iv          ! O-B structure.
   
!-----------------------------------------------------------------------------
!  [1.0] Read GTS observation header and get idea of number of obs:
!-----------------------------------------------------------------------------

!-----------------------------------------------------------------------------
!   READ HEADER OF CONVENTIONAL OBSERVATION FILE
!-----------------------------------------------------------------------------

   CALL DA_Read_Obs_Info (gts_iunit, iv, xb, xbx)

!-----------------------------------------------------------------------------
!   READ HEADER OF SSMI OBSERVATION FILE
!-----------------------------------------------------------------------------

   if(Use_SsmiRetrievalObs .or. Use_SsmiTbObs) &
      call DA_Read_SSMI_info (ssmi_iunit, iv, xb, xbx)

!-----------------------------------------------------------------------------
!   READ HEADER OF RADAR OBSERVATION FILE
!-----------------------------------------------------------------------------

   if(Use_RadarObs) &
      call DA_Read_Radar_Info (Radar_iunit, iv, xb, xp)

!-----------------------------------------------------------------------------
!   Allocate the ob based on inputed number of obs:
!-----------------------------------------------------------------------------

   CALL DA_Allocate_Observations ( iv )

!-----------------------------------------------------------------------------
!   READ MAIN BODY OF GTS OBSERVATION FILE
!------------------------------------------------------------------------------

   call DA_Read_Obs (gts_iunit, iv, xb)

!-----------------------------------------------------------------------------
!   READ MAIN BODY OF SSMI OBSERVATION FILE
!-----------------------------------------------------------------------------
  
   if(Use_SsmiRetrievalObs .or. Use_SsmiTbObs) &
      call DA_Read_SSMI (ssmi_iunit, iv, xb)

!-----------------------------------------------------------------------------
!   READ MAIN BODY OF RADAR OBSERVATION FILE
!-----------------------------------------------------------------------------

   if(Use_RadarObs) &
      call DA_Read_Radar (Radar_iunit, iv, xb, xp)

!-----------------------------------------------------------------------------
!  [3.0] Calculate innovation vector (O-B) and create (smaller) ob structure:
!-----------------------------------------------------------------------------

   CALL da_fill_obs_structures( iv, ob )

END SUBROUTINE da_setup_obs_structures_mm5

