SUBROUTINE da_get_innov_vector_gpspw ( it, xb, xp, ob, iv )

   IMPLICIT NONE

   INTEGER, INTENT(IN)           :: it      ! External iteration.
   TYPE (xb_type), INTENT(IN)    :: xb      ! first guess state.
   TYPE (xpose_type), INTENT(IN) :: xp      ! Domain decomposition vars.
   TYPE (y_type),  INTENT(IN)    :: ob      ! Observation structure.
   TYPE (ob_type), INTENT(INOUT) :: iv      ! O-B structure.

   INTEGER                      :: n        ! Loop counter.
   INTEGER                      :: i, j     ! Index dimension.
   REAL                         :: dx, dxm  ! Interpolation weights.
   REAL                         :: dy, dym  ! Interpolation weights.
   REAL                         :: model_tpw! Model value u at oblocation.
   INTEGER           :: ittpw,ittpwf
!

   IF ( iv % num_gpspw > 0 ) THEN

   ittpw   = 0 ; ittpwf  = 0

      DO n=1, iv % num_gpspw

       if(iv%gpspw(n)%loc%proc_domain_with_halo) then

         iv % gpspw(n) % tpw % inv = 0.0

!        [1.1] Get horizontal interpolation weights:

         i = iv%gpspw(n)%loc%i
         j = iv%gpspw(n)%loc%j
         dx = iv%gpspw(n)%loc%dx
         dy = iv%gpspw(n)%loc%dy
         dxm = iv%gpspw(n)%loc%dxm
         dym = iv%gpspw(n)%loc%dym

         IF ( ob % gpspw(n) % tpw > missing_r .AND. &
              iv % gpspw(n) % tpw % qc >= obs_qc_pointer ) THEN
            model_tpw = dym*(dxm*xb%tpw(i,j)   + dx*xb%tpw(i+1,j)) + &
                        dy *(dxm*xb%tpw(i,j+1) + dx*xb%tpw(i+1,j+1))
            iv % gpspw(n) % tpw % inv = ob % gpspw(n) % tpw - model_tpw
         END IF

!------------------------------------------------------------------------
!        [5.0] Perform optional maximum error check:
!------------------------------------------------------------------------

        IF (  check_max_iv ) CALL da_check_max_iv_gpspw(it, iv % gpspw(n), &
                                          ittpw,ittpwf )
       endif

      END DO

      write(unit = check_max_iv_unit, FMT ='(A,i5,A)')'For outer iteration ',it, &
                   ', Total Rejections for Gpspw follows:'
       WRITE (UNIT = check_max_iv_unit, FMT = '(/,10(2(A,I6),/))') &
      'Number of failed TPW-observations:     ',ittpwf, ' on ',ittpw, &
      'Finally all Gpspw rejections ',ittpwf,' on ',ittpw

   ENDIF

END SUBROUTINE da_get_innov_vector_gpspw

