subroutine da_transform_XTogpsref_adj(qv,p,t,ref,qv9,p9,t9,xp)

!
!  input: qv9,p9,t9,ref,xp
! output: qv,p,t
!
! modified from MM5-4DVAR. Wei Huang, May 24, 2004
   
   TYPE (xpose_type), INTENT(IN)  :: xp         ! Domain decomposition vars.
   real, dimension(xp%ims:xp%ime, xp%jms:xp%jme, xp%kms:xp%kme), &
                   intent(in)     :: qv9, p9, t9
   real, dimension(xp%ims:xp%ime, xp%jms:xp%jme, xp%kms:xp%kme), &
                   intent(inout)  :: qv, p, t, ref
   
   real, parameter :: coeff = 3.73*1.e5/77.6
   
   integer :: i, j, k
   real    :: partone, parttwo, dividnd
   real    :: partone9,parttwo9,dividnd9
   
!  Note: p in Pascal

   do k=xp%kts,xp%kte
   do j=xp%jts,xp%jte
   do i=xp%its,xp%ite
      partone9 = 0.776*p9(i,j,k)/t9(i,j,k)
      dividnd9 = t9(i,j,k)*(0.622+0.378*qv9(i,j,k))
      parttwo9 = 1.0+coeff*qv9(i,j,k)/dividnd9

      partone = ref(i,j,k) * parttwo9
      parttwo = ref(i,j,k) * partone9

      qv(i,j,k) = qv(i,j,k) + coeff*parttwo/dividnd9
      dividnd=-coeff*qv9(i,j,k)*parttwo/(dividnd9*dividnd9)

      t(i,j,k) = t(i,j,k) + dividnd*(0.622+0.378*qv9(i,j,k))
      qv(i,j,k) = qv(i,j,k) + t9(i,j,k)*0.378*dividnd

      p(i,j,k) = p(i,j,k) + 0.776*partone/t9(i,j,k)
      t(i,j,k) = t(i,j,k) - 0.776*p9(i,j,k)*partone/(t9(i,j,k)*t9(i,j,k))
      ref(i,j,k) = 0.0
   enddo
   enddo
   enddo

end subroutine da_transform_XTogpsref_adj

