MODULE module_wrf_3dvar_io

CONTAINS

!------------------------------------------------------------------------------

SUBROUTINE med_initialdata_input_3dvar ( grid , config_flags )

!--Driver layer

   USE module_domain
   USE module_io_domain

!--Model layer

   USE module_configure
   USE module_bdyzone

   IMPLICIT NONE

!--Interface
!
!  INTERFACE
!     SUBROUTINE start_domain ( grid )  ! comes from module_start in appropriate dyn_ directory
!       USE module_domain
!       TYPE (domain) grid
!     END SUBROUTINE start_domain
!  END INTERFACE

!--Arguments

   TYPE(domain)                               :: grid
   TYPE (grid_config_rec_type) , INTENT(IN)   :: config_flags

!--Local

   INTEGER                 :: fid , ierr , myproc
   CHARACTER (LEN=80)      :: file_name
   CHARACTER (LEN=80)      :: message
   LOGICAL                 :: generate_ensemble

!------------------------------------------------------------------------------

!  Initialize the mother domain.

   CALL start_timing

   grid%input_from_file = .true.

   file_name = 'wrf_3dvar_input'

   CALL wrf_debug ( 100 , 'da_3dvar/module_wrf_3dvar_io: calling open_r_dataset for wrf 3dvar input' )
   CALL open_r_dataset ( fid, TRIM(file_name), grid , config_flags , "DATASET=INPUT", ierr )

   IF ( ierr .NE. 0 ) THEN
     WRITE( wrf_err_message , * ) 'da_3dvar/module_wrf_3dvar_io: error opening ', &
                                  TRIM(file_name),' for reading ierr=',ierr
     CALL WRF_ERROR_FATAL ( wrf_err_message )
   ENDIF

   CALL       wrf_debug ( 100 , 'wrf_da_3dvar: calling input_model_input' )
   CALL input_model_input ( fid ,   grid , config_flags , ierr )
   CALL       wrf_debug ( 100 , 'wrf_da_3dvar: back from input_model_input' )

   CALL close_dataset ( fid , config_flags , "DATASET=INPUT" )

END SUBROUTINE med_initialdata_input_3dvar

!----------------------------------------------------------

SUBROUTINE med_initialdata_output_3dvar ( grid , config_flags )

!--Driver layer

   USE module_domain
   USE module_io_domain

!--Model layer

   USE module_configure

   IMPLICIT NONE

!--Arguments

   TYPE(domain)                               :: grid
   TYPE (grid_config_rec_type) , INTENT(INOUT)   :: config_flags       

!--Local

   INTEGER                :: time_step_begin_restart
   INTEGER                :: fid , ierr
   CHARACTER (LEN=80)     :: message
   CHARACTER (LEN=80)     :: file_name

   INTEGER                :: current_day,current_hour,current_month,current_year
   CHARACTER (LEN=1)      :: single_char 
   INTEGER julyr, julday
   REAL    gmt

   grid%write_metadata = .false.

   file_name = 'wrf_3dvar_output'

   CALL wrf_debug ( 100 , 'da_3dvar/module_wrf_3dvar_io: calling open_w_dataset 3dvar output' )
   CALL open_w_dataset ( fid, TRIM(file_name), grid , config_flags , &
                         output_model_input , "DATASET=INPUT", ierr )

   IF ( ierr .NE. 0 ) THEN
      WRITE( wrf_err_message , * ) 'da_3dvar/module_wrf_3dvar_io: error opening ', &
                                    TRIM(file_name),' for writing ierr=',ierr
      CALL wrf_error_fatal( wrf_err_message )
   ENDIF

   start_date=current_date
   print *, 'current_date=', current_date
   print *, '  start_date=',   start_date

   print *, 'background gmt ', config_flags%gmt
   print *, 'background julyr ', config_flags%julyr
   print *, 'background julday ',config_flags%julday

   call geth_julgmt(julyr, julday, gmt)
   config_flags%gmt = gmt
   config_flags%julyr = julyr
   config_flags%julday = julday

   print *, 'modified gmt ', config_flags%gmt
   print *, 'modified julyr ', config_flags%julyr
   print *, 'modified julday ',config_flags%julday

!--------------------------------------------------------------------- 

   grid%write_metadata = .true.

   CALL output_model_input ( fid, grid , config_flags , ierr )

   CALL close_dataset ( fid , config_flags, "DATASET=INPUT" )
   WRITE ( message , FMT = '("Writing 3dvar output for domain ",I8)' ) grid%id
   CALL end_timing ( TRIM(message) )

END SUBROUTINE med_initialdata_output_3dvar

END MODULE module_wrf_3dvar_io

