      subroutine da_calculate_j(it, iter, xb, xbx, be, iv, xhat, cv, vv, &
                                 vp, xp, re, y, xa, j, j_grad,        &
                                 ids, ide, jds, jde, kds, kde,        &
                                 ims, ime, jms, jme, kms, kme,        &
                                 its, ite, jts, jte, kts, kte )
!------------------------------------------------------------------------------
! PURPOSE: Initialises the Y-array
!
!  Additions:
!
!           07/28/2003 -                                            R. H. Rizvi
!
!                        DA_Zero_Y is called to initialise y-array                     
!                        
! PARENT_MODULE: DA_DA_Minimisation  
!------------------------------------------------------------------------------

      implicit none

      integer, intent(in)                :: it     ! external iteration #.
      integer, intent(in)                :: iter   ! internal iteration #.
      type (xb_type), intent(in)         :: xb     ! first guess (local).
      type (xbx_type),intent(in)         :: xbx    ! For header & non-grid arrays.
      type (be_type), intent(in)         :: be     ! background error structure.
      type (ob_type), intent(in)         :: iv     ! innovation vector (o-b).
      real,intent(in),dimension(cv_size) :: xhat   ! Increament control variable
      real,intent(in),dimension(cv_size) :: cv   ! control variable (local).
      type (vp_type), intent(inout)      :: vv     ! Grdipt/EOF CV.
      type (vp_type), intent(inout)      :: vp     ! Grdipt/level CV.
      type (xpose_type), intent(inout)   :: xp     ! Domain decomposition vars.
      type (y_type) , intent(inout)      :: re     ! residual vector (o-a).
      type (y_type) , intent(inout)      :: y      ! y = H(x_inc).
      real,intent(out),dimension(cv_size):: j_grad ! grad(jo) (local grid)
      type (x_type) , intent(inout)      :: xa     ! gridded analy. incs. (local)
      type (j_type) , intent(out)        :: j      ! cost function j

      integer   , intent(in)       :: ids,ide, jds,jde, kds,kde ! domain dims.
      integer   , intent(in)       :: ims,ime, jms,jme, kms,kme ! memory dims.
      integer   , intent(in)       :: its,ite, jts,jte, kts,kte ! tile   dims.

      real                               :: jb     ! jb
      real                               :: jo     ! jo
      real                               :: jo_partial  ! jo for this processor
      real                               :: gnorm_cv, gnorm_jo, gnorm_j
 
      type (y_type)                      :: jo_grad_y ! Grad_y(jo)

      integer                            :: ierror
      integer                            :: ii, jj

!-------------------------------------------------------------------------
      integer                            :: n2d,n3d
      n2d = (xp%ite-xp%its+1)*(xp%jte-xp%jts+1)
      n3d = (xp%ite-xp%its+1)*(xp%jte-xp%jts+1)*(xp%kte-xp%kts+1)
!-------------------------------------------------------------------------
      
      call da_allocate_y( iv, jo_grad_y )

!-------------------------------------------------------------------------
!     [2.0] calculate jo:
!-------------------------------------------------------------------------
      
!     [2.1] transform from control variable to model grid space:

      call da_zero_x ( xa )
      call da_zero_y (iv, y)
! rizvi initialising now the residual array
      call da_zero_y (iv, re)
!
      if ( iter == 0) go to 10
      call da_transform_vtox( xb, xbx, be, xhat, vv, vp, xp, xa,      &
                              ids, ide, jds, jde, kds, kde,           &
                              ims, ime, jms, jme, kms, kme,           &
                              its, ite, jts, jte, kts, kte )

      if (sfc_assi_options == 2) then
         call DA_Transform_XToWTQ ( xp, xb, xa )
      endif

!-----Exchange XA halo region.
      CALL wrf_dm_halo(xp%domdesc,xp%comms,xp%halo_id4)

      if (sfc_assi_options == 2) then
!--------Exchange XA (surface variable) halo region.
         CALL wrf_dm_halo(xp%domdesc,xp%comms,xp%halo_id6)
      endif

      if ( use_ssmt1obs .or. use_ssmt2obs .or. Use_GpspwObs .or. &
           Use_SsmiTbObs .or. Use_SsmiRetrievalObs ) then

!--------Now do something for PW

         call DA_Transform_XToTPW( xa, xb )

         if ( use_ssmt1obs .or. use_ssmt2obs .or. &
              Use_SsmiTbObs .or. Use_SsmiRetrievalObs ) then
            call DA_Transform_XToSeaSfcWind_Lin( xa, xb )
         endif

         if ( Use_SsmiTbObs ) call DA_Transform_XToTb_Lin (xa, xb)

!--------Exchange XA halo region.
         CALL wrf_dm_halo(xp%domdesc,xp%comms,xp%halo_id8)
      endif

!     [2.2] transform increments to observation space y = h dx:

         call da_transform_xtoy( xb, iv, xa, xp, y )

!     [2.3] compute residual (o-a) = (o-b) - h x~

10     continue

      call da_calculate_residual( iv, y, re )

!     [2.4] calculate jo:

      call da_calculate_jo_and_grady( iv, re, jo_partial, j % jo, jo_grad_y)

#ifdef DM_PARALLEL
      call MPI_ALLREDUCE( jo_partial, j % jo % total, 1, MPI_REAL8, MPI_SUM, &
                          MPI_COMM_WORLD, IERROR )
#else
      j % jo % total = jo_partial
#endif
 

!-------------------------------------------------------------------------
!     [1.0] calculate jb:
!-------------------------------------------------------------------------

     if(minimisation_option == 1)j%jb = 0.5*da_dot(cv     ,cv     ,cv_size)
     if(minimisation_option == 2)j%jb = 0.5*da_dot(cv+xhat,cv+xhat,cv_size)

!-------------------------------------------------------------------------
!     [3.0] calculate total cost function j = jo + jb:
!-------------------------------------------------------------------------

      j % total = j % jb + j % jo % total

      if(it == 1 .and. iter == 0) then
      write(81,'(a)')'Outer   EPS   Inner      J          Jb      Jo'
      write(81,'(a)')'Iter          Iter                            '
      write(82,'(a)')'Outer   EPS   Inner      G          Gb      Go'
      write(82,'(a)')'Iter          Iter                            '
      endif

      write(81,81) it, EPS(it), iter, j % total, j % jb, j % jo % total
 81   format(2x,i2,1x,f6.3,2x,i4,2x,3f10.3)

!-------------------------------------------------------------------------
!     [2.0] calculate grad_v (jo):
!-------------------------------------------------------------------------

!     [2.1] allocate grad_x(jo) (and set to zero): 

      call DA_zero_x(xa)

!     [2.2] transform grad_y(jo) to grad_x(jo):
      call da_transform_xtoy_adj( xb, iv, xp, jo_grad_y, xa )
!-------------------------------------------------------------------------
      if ( use_ssmt1obs .or. use_ssmt2obs .or. Use_GpspwObs .or. &
           Use_SsmiTbObs .or. Use_SsmiRetrievalObs ) then

         if ( Use_SsmiTbObs ) call DA_Transform_XToTb_Adj (xa, xb)
      
!--------Sea Surface wind
         if ( use_ssmt1obs .or. use_ssmt2obs .or. &
              Use_SsmiTbObs .or. Use_SsmiRetrievalObs ) then
            call DA_Transform_XToSeaSfcWind_Adj( xa, xb )
         endif
!--------Now for PW.
         call DA_Transform_XToTPW_ADJ( xa, xb )
      endif

!-----Now do something for surface variables
      if (sfc_assi_options == 2) then
         call DA_Transform_XToWTQ_adj ( xp, xb, xa )
      endif
!-------------------------------------------------------------------------

!     [2.4] transform grad_x(jo) to grad_v(jo):
      j_grad = 0.0

      call da_transform_vtox_adj( xb, xbx, be, xa, xp, vp, vv, j_grad, &
                                  ids, ide, jds, jde, kds, kde,           &
                                  ims, ime, jms, jme, kms, kme,           &
                                  its, ite, jts, jte, kts, kte )

      call da_deallocate_y( jo_grad_y )

!-------------------------------------------------------------------------
!     [3.0] calculate grad_v (j) = grad_v (jb) + grad_v (jo):
!-------------------------------------------------------------------------

      gnorm_jo= da_dot(j_grad,j_grad,cv_size)

      gnorm_jo= sqrt(gnorm_jo)

!     add background gradient to observational gradient

      if(minimisation_option == 1) then
         j_grad =  cv        + j_grad
         gnorm_cv= da_dot(cv       , cv       , cv_size)
      else if(minimisation_option == 2) then
         j_grad =  cv + xhat + j_grad
         gnorm_cv= da_dot(cv + xhat, cv + xhat, cv_size)
      else
         write(unit=*, fmt='(a)') 'Wrong minimisation_option.'
      endif

      gnorm_cv= sqrt(gnorm_cv)
      gnorm_j = da_dot(j_grad, j_grad,cv_size)
      gnorm_j = sqrt(gnorm_j )

      write(82,81) it, EPS(it), iter, gnorm_j, gnorm_cv, gnorm_jo

  end subroutine da_calculate_j
