SUBROUTINE DA_Read_Obs_Info (iunit, ob, xb, xbx)
!-----------------------------------------------------------------------------!
!  History:
!
!  Additions:
!             07/08/2003      Profiler and Buoy Obs            S. R. H. Rizvi
! Purpose: Read the header of a MM5 3D-VAR 3.0 GTS observation file
!-----------------------------------------------------------------------------!

   implicit none

   INTEGER,        INTENT (in)  :: iunit
   TYPE (xb_type), INTENT (in)  :: xb
   TYPE (xbx_type),INTENT (in)  :: xbx     ! Header & non-gridded vars.
   TYPE (ob_type), INTENT (out) :: ob

   INTEGER                      :: iost, i, num_amdar, ii
   CHARACTER (LEN = 120)        :: char_ned
   LOGICAL                      :: connected

   INTEGER                      :: ixc, jxc, iproj, idd, maxnes
   INTEGER,  dimension(10)      :: nestix, nestjx, numnc, nesti, nestj

   REAL                         :: phic   , xlonc  , truelat1_3dv, truelat2_3dv, &
                                   ts0    , ps0    , tlp     , ptop
   REAL   ,  dimension(10)      :: dis

!----------------------------------------------------------------------------!

   ob % total_obs = 0
   ob % num_sound = 0
   ob % num_synop = 0
   ob % num_pilot = 0
   ob % num_satob = 0
   ob % num_satem = 0
   ob % num_airep = 0
   ob % num_metar = 0
   ob % num_ships = 0
   ob % num_gpspw = 0
   ob % num_ssmi_retrieval = 0
   ob % num_ssmi_tb       = 0
   ob % num_ssmt1 = 0
   ob % num_ssmt2 = 0
   ob % num_pseudo = 0
   ob % num_qscat = 0
   ob % num_profiler  = 0
   ob % num_buoy  = 0

   num_amdar = 0

!----------------------------------------------------------------------------!

! 1. OPEN FILE
!    ---------

   INQUIRE ( UNIT = iunit, OPENED = connected )

   IF ( .NOT. connected ) THEN
      OPEN ( UNIT   = iunit,     &
           FORM   = 'FORMATTED',  &
           ACCESS = 'SEQUENTIAL', &
           IOSTAT =  iost,     &
           STATUS = 'OLD')

      IF (iost /= 0) THEN
         write(unit=*, fmt='(/A,I3,A/)') &
              'ERROR IN INPUT FILE UNIT ',iunit, &
              'FOR GTS OBSERVATIONS CANNOT BE FOUND OR CANNOT BE OPENED'
         RETURN
      ENDIF

   ENDIF

   REWIND (UNIT = iunit)


! 2.  READ HEADER
! ===============

! 2.1 READ FIRST LINE
!     ---------------

   READ (UNIT = iunit, FMT = '(A)', IOSTAT = iost) char_ned

! 2.2 PROCESS ERROR
!     -------------

   IF (iost /= 0) THEN
      write(unit=*, fmt='(/a,i3/a/)') &
           'ERROR READING FILE UNIT:', iunit, &
           'in read_obs_gts_header.F' 

      return
   ENDIF

! 2.3 RED NUMBER OF REPORTS
!     ---------------------

head_line_1:  DO
 
   DO i = 0, 120-14

     SELECT CASE ( char_ned (I+1:I+5) )

  ! Number of observations
     CASE ('TOTAL') ; 
       READ (char_ned (I+9:I+14),'(I6)', IOSTAT = iost) ob % total_obs
     CASE ('SYNOP') ; 
       READ (char_ned (I+9:I+14),'(I6)', IOSTAT = iost) ob % num_synop
     CASE ('METAR') ; 
       READ (char_ned (I+9:I+14),'(I6)', IOSTAT = iost) ob % num_metar
     CASE ('SHIP ') ; 
       READ (char_ned (I+9:I+14),'(I6)', IOSTAT = iost) ob % num_ships
     CASE ('BUOY ') ;
       READ (char_ned (I+9:I+14),'(I6)', IOSTAT = iost) ob % num_buoy
     CASE ('TEMP ') ; 
       READ (char_ned (I+9:I+14),'(I6)', IOSTAT = iost) ob % num_sound
     CASE ('AIREP') ; 
       READ (char_ned (I+9:I+14),'(I6)', IOSTAT = iost) ob % num_airep
     CASE ('AMDAR') ;
       READ (char_ned (I+9:I+14),'(I6)', IOSTAT = iost) num_amdar
     CASE ('PILOT') ; 
       READ (char_ned (I+9:I+14),'(I6)', IOSTAT = iost) ob % num_pilot
     CASE ('SATEM') ; 
       READ (char_ned (I+9:I+14),'(I6)', IOSTAT = iost) ob % num_satem
     CASE ('SATOB') ; 
       READ (char_ned (I+9:I+14),'(I6)', IOSTAT = iost) ob % num_satob
     CASE ('GPSPW') ; 
       READ (char_ned (I+9:I+14),'(I6)', IOSTAT = iost) ob % num_gpspw
     CASE ('SSMT1') ; 
       READ (char_ned (I+9:I+14),'(I6)', IOSTAT = iost) ob % num_ssmt1
     CASE ('SSMT2') ; 
       READ (char_ned (I+9:I+14),'(I6)', IOSTAT = iost) ob % num_ssmt2
     CASE ('QSCAT') ;
       READ (char_ned (I+9:I+14),'(I6)', IOSTAT = iost) ob % num_qscat
     CASE ('PROFL') ; 
       READ (char_ned (I+9:I+14),'(I6)', IOSTAT = iost) ob % num_profiler

  ! Geographic area and reference atmosphere definition
 
      CASE ('MISS.') ; 
          READ (char_ned (I+8:I+15),'(F8.0)', IOSTAT = iost) ob % missing
      CASE ('PHIC ') ; 
          READ (char_ned (I+8:I+14),'(F7.2)', IOSTAT = iost) phic
      CASE ('XLONC') ; 
          READ (char_ned (I+8:I+14),'(F7.2)', IOSTAT = iost) xlonc
      CASE ('TRUE1') ; 
          READ (char_ned (I+8:I+14),'(F7.2)', IOSTAT = iost) truelat1_3dv
      CASE ('TRUE2') ; 
          READ (char_ned (I+8:I+14),'(F7.2)', IOSTAT = iost) truelat2_3dv
      CASE ('TS0  ') ; 
          READ (char_ned (I+8:I+14),'(F7.2)', IOSTAT = iost) ts0
      CASE ('TLP  ') ; 
          READ (char_ned (I+8:I+14),'(F7.2)', IOSTAT = iost) tlp
      CASE ('PTOP ') ; 
          READ (char_ned (I+8:I+14),'(F7.0)', IOSTAT = iost) ptop
      CASE ('PS0  ') ; 
          READ (char_ned (I+8:I+14),'(F7.0)', IOSTAT = iost) ps0
      CASE ('IXC  ') ; 
          READ (char_ned (I+8:I+14),'(I7)', IOSTAT = iost) ixc
      CASE ('JXC  ') ; 
          READ (char_ned (I+8:I+14),'(I7)', IOSTAT = iost) jxc
      CASE ('IPROJ') ; 
          READ (char_ned (I+8:I+14),'(I7)', IOSTAT = iost) iproj
      CASE ('IDD  ') ; 
          READ (char_ned (I+8:I+14),'(I7)', IOSTAT = iost) idd
      CASE ('MAXNE') ; 
          READ (char_ned (I+8:I+14),'(I7)', IOSTAT = iost) maxnes
      CASE DEFAULT ;
          READ (char_ned (I+9:I+14),'(I6)', IOSTAT = iost) ii

      END SELECT

   ENDDO

   READ (UNIT = iunit, FMT = '(A)', IOSTAT = iost) char_ned
   if (char_ned(1:6) == 'NESTIX') EXIT

   ENDDO head_line_1
   if(num_amdar > 0) then
      ob % num_airep = ob % num_airep + num_amdar
   endif

!--------------------------------------------------------------------

head_line_2:  DO

     SELECT CASE ( char_ned (1:6) )

  ! Model domains definition
    
      CASE ('NESTIX') ;
           CALL read_integer_array(nestix, maxnes, 8, 9)
      CASE ('NESTJX') ; 
           CALL read_integer_array(nestjx, maxnes, 8, 9)
      CASE ('NUMC  ') ; 
           CALL read_integer_array(numnc , maxnes, 8, 9)
      CASE ('DIS   ') ; 
           CALL read_real_array   (dis   , maxnes, 8, 9)
      CASE ('NESTI ') ; 
           CALL read_integer_array(nesti , maxnes, 8, 9)
      CASE ('NESTJ ') ; 
           CALL read_integer_array(nestj , maxnes, 8, 9)
     END SELECT

   READ (UNIT = iunit, FMT = '(A)', IOSTAT = iost) char_ned
   if (char_ned(1:6) == 'INFO  ') EXIT

   ENDDO head_line_2

!--------------------------------------------------------------------

! PRINT OUT
! =============

   if ( print_detail >= 1 ) then

      write (6,'(A,I6,A)') ' Expect: ',ob%num_synop,' SYNOP reports,'
      write (6,'(A,I6,A)') ' Expect: ',ob%num_metar,' METAR reports,'
      write (6,'(A,I6,A)') ' Expect: ',ob%num_ships,' SHIP  reports,'
      write (6,'(A,I6,A)') ' Expect: ',ob%num_buoy ,' BUOY  reports,'
      write (6,'(A,I6,A)') ' Expect: ',ob%num_sound,' TEMP  reports,'
      write (6,'(A,I6,A)') ' Expect: ',ob%num_airep,' AIREP reports,'
      write (6,'(A,I6,A)') ' Expect: ',   num_amdar,' AMDAR reports,'
      write (6,'(A,I6,A)') ' Expect: ',ob%num_pilot,' PILOT reports,'
      write (6,'(A,I6,A)') ' Expect: ',ob%num_satem,' SATEM reports,'
      write (6,'(A,I6,A)') ' Expect: ',ob%num_satob,' SATOB reports,'
      write (6,'(A,I6,A)') ' Expect: ',ob%num_gpspw,' GPSPW reports,'
      write (6,'(A,I6,A)') ' Expect: ',ob%num_ssmt1,' SSMT1 reports,'
      write (6,'(A,I6,A)') ' Expect: ',ob%num_ssmt2,' SSMT2 reports,'
      write (6,'(A,I6,A)') ' Expect: ',ob%num_qscat,' QSCAT reports,'
      write (6,'(A,I6,A)') ' Expect: ',ob%num_profiler,' PROFILER reports,'
      write (6,'(A,I6,A)') ' Expect: ',          ii,' OTHER reports,'

      write (6, '(A)')
      write (6,'(A,I6,A)') ' Total:  ',ob%total_obs,' reports.'

      write(6,'(/A)') 'GEOGRAPHIC AREA AND REFERENCE ATMOSPHERE:'
      write(6,'(A,f8.2)') 'PHIC     =', phic
      write(6,'(A,f8.2)') 'XLONC    =', xlonc
      write(6,'(A,f8.2)') 'TRUELAT1 =', truelat1_3dv
      write(6,'(A,f8.2)') 'TRUELAT2 =', truelat2_3dv
      write(6,'(A,f8.2)') 'TS0      =', ts0
      write(6,'(A,f8.0)') 'PS0      =', ps0
      write(6,'(A,f8.2)') 'TLP      =', tlp
      write(6,'(A,f8.0)') 'PTOP     =', ptop
      write(6,'(A,I8)'  ) 'IXC      =', ixc
      write(6,'(A,I8)'  ) 'JXC      =', jxc
      write(6,'(A,I8)'  ) 'IPROJ    =', iproj
      write(6,'(A,I8)'  ) 'IDD      =', idd
      write(6,'(A,I8)'  ) 'MAXNES   =', maxnes

      write(6,'(A,(I7,2X)  )',ADVANCE='no') 'NESTIX:', (nestix(i), i = 1,maxnes)
      write(6,'(A)')
      write(6,'(A,(I7,2X)  )',ADVANCE='no') 'NESTJX:', (nestjx(i), i = 1,maxnes)
      write(6,'(A)')
      write(6,'(A,(I7,2X)  )',ADVANCE='no') 'NUMC  :', (numnc (i), i = 1,maxnes)
      write(6,'(A)')
      write(6,'(A,(f7.1,2X))',ADVANCE='no') 'DIS   :', (dis   (i), i = 1,maxnes)
      write(6,'(A)')
      write(6,'(A,(I7,2X))  ',ADVANCE='no') 'NESTI :', (nesti (i), i = 1,maxnes)
      write(6,'(A)')
      write(6,'(A,(I7,2X))  ',ADVANCE='no') 'NESTJ :', (nestj (i), i = 1,maxnes)
      write(6,'(A)')
   
      write(6,'(/A)') 'OBSERVATION DATA LAYOUT:'
      write(6,'(A)') TRIM(char_ned)
      
   end if

   READ (UNIT = iunit, FMT = '(A)', IOSTAT = iost) char_ned
   if ( print_detail >= 1 )write(6,'(A)') TRIM(char_ned)
   READ (UNIT = iunit, FMT = '(A)', IOSTAT = iost) char_ned
   if ( print_detail >= 1 )write(6,'(A)') TRIM(char_ned)

!--------------------------------------------------------------------
!--Safety guard.
!--------------------------------------------------------------------
   if(ob % num_sound > max_sound_input ) &
      ob % num_sound = max_sound_input

   if(ob % num_synop > max_synop_input ) &
      ob % num_synop = max_synop_input
   if(ob % num_pilot > max_pilot_input ) &
      ob % num_pilot = max_pilot_input
   if(ob % num_satob > max_satob_input ) &
      ob % num_satob = max_satob_input
   if(ob % num_satem > max_satem_input ) &
      ob % num_satem = max_satem_input
   if(ob % num_airep > max_airep_input ) &
      ob % num_airep = max_airep_input
   if(ob % num_metar > max_metar_input ) &
      ob % num_metar = max_metar_input
   if(ob % num_ships > max_ships_input ) &
      ob % num_ships = max_ships_input
   if(ob % num_gpspw > max_gpspw_input ) &
      ob % num_gpspw = max_gpspw_input
   if(ob % num_ssmi_retrieval > max_ssmi_retrieval_input ) &
      ob % num_ssmi_retrieval = max_ssmi_retrieval_input
   if(ob % num_ssmi_tb > max_ssmi_tb_input ) &
      ob % num_ssmi_tb = max_ssmi_tb_input
   if(ob % num_ssmt1 > max_ssmt1_input ) &
      ob % num_ssmt1 = max_ssmt1_input
   if(ob % num_ssmt2 > max_ssmt2_input ) &
      ob % num_ssmt2 = max_ssmt2_input
   if(ob % num_profiler > max_profiler_input ) &
      ob % num_profiler = max_profiler_input
   if(ob % num_buoy > max_buoy_input ) &
      ob % num_buoy = max_buoy_input
!  if(ob % num_pseudo > max_pseudo_input ) &
!     ob % num_pseudo = max_pseudo_input

!--------------------------------------------------------------------
!--Consistancy check

   if(fg_format == 2 ) then
   if(xbx % big_header % bhi(7,1)  /= iproj .or. &
      abs(xbx % big_header % bhr(2,1)-phic) > 0.0001 .or. &
      abs(xbx % big_header % bhr(3,1)-xlonc) > 0.0001 .or. &
      abs(xbx % big_header % bhr(5,1)-truelat1_3dv) > 0.0001 .or. &
      abs(xbx % big_header % bhr(6,1)-truelat2_3dv) > 0.0001) then

     write(unit=*, fmt='(/a/)') &
          'WARNING WARNING WARNING WARNING WARNING', &
          'Map background Inconsistant between OBS and FG'

     write(unit=*, fmt='(2(a,i8))') &
          'IPROJ =', iproj, 'xb%iproj=', xbx % big_header % bhi(7,1)
     write(unit=*, fmt='(2(a,f8.0))') &
          'PHIC  =', phic,  'xb%phic=', xbx % big_header % bhr(2,1), &
          'XLONC =', xlonc, 'xb%phic=', xbx % big_header % bhr(3,1), &
          'TRUELAT1 =', truelat1_3dv, 'xb%lat1=', xbx % big_header % bhr(5,1), &
          'TRUELAT2 =', truelat2_3dv, 'xb%lat2=', xbx % big_header % bhr(6,1)
   endif
   endif

#if 0
!--Do not need to check here.
!--ps0, ts0, tlp, and ptop are for MM5. They have different meaning in WRF 3DVAR.
!  only ts0 is used to store the averaged theta, which is 300 (K).

  ! Reference atmosphere check

   if(abs(xb % ps0-ps0) > 0.0001 .or. &
      abs(xb % ts0-ts0) > 0.0001 .or. &
      abs(xb % tlp-tlp) > 0.0001 .or. &
      abs(xb % ptop-ptop) > 0.0001) then

     write(unit=*, fmt='(/a/)') &
          'WARNING WARNING WARNING WARNING WARNING', &
          'Reference atmosphere Inconsistant between OBS and FG'

     write(unit=*, fmt='(2(a,f8.0))') &
          'PS0 =', ps0, 'xb%ps0=', xb%ps0, &
          'TS0 =', ts0, 'xb%ts0=', xb%ts0, &
          'TLP =', tlp, 'xb%tlp=', xb%tlp, &
          'PTOP =', ptop, 'xb%ptop=', xb%ptop
   endif
#endif
!--------------------------------------------------------------------

CONTAINS

subroutine read_integer_array(aa,nn,i0,i_step)

  integer,                 intent(in) :: nn, i0, i_step
  integer,  dimension(:), intent(out) :: aa

  integer     :: i, ii
 
  do i = 1, nn
    ii = i_step*(i-1) + i0
    READ (char_ned (ii:ii+8),'((I7,2X))') aa(i)
  enddo
end subroutine read_integer_array

subroutine read_real_array(aa,nn,i0,i_step)

  integer,                 intent(in) :: nn, i0, i_step
  real   ,  dimension(:), intent(out) :: aa

  integer     :: i, ii
 
  do i = 1, nn
    ii = i_step*(i-1) + i0
    READ (char_ned (ii:ii+8),'((f7.2,2X))') aa(i)
  enddo
end subroutine read_real_array

END SUBROUTINE DA_Read_Obs_Info
