subroutine h_to_zk(obs_v, mdl_v, xp, zk)

   implicit none

   type(xpose_type),               intent(in)  :: xp      ! Domain decomposition vars.
   real,                           intent(in)  :: obs_v
   real, dimension(xp%kms:xp%kme), intent(in)  :: mdl_v
   real,                           intent(out) :: zk

   integer                :: k


      if (abs( obs_v - missing_r ) < 0.1) then
        write(0,'(/A,f12.2,A)') 'In h_to_zk: Height is missing =',obs_v, &
          ' This does not allow to be happen.'
        STOP 22222
      endif

      zk = -1
      if ( obs_v < mdl_v(xp%kds) ) then
        zk = 0.
      else if ( obs_v > mdl_v(xp%kde) ) then
        zk = real(xp%kde) + 0.1
      endif

      do k = xp%kts,xp%kte-1
         if( obs_v >= mdl_v(k) .and. obs_v <= mdl_v(k+1) ) then
            zk = real(k) + (mdl_v(k) - obs_v)/(mdl_v(k) - mdl_v(k+1))
            exit
         endif
      enddo

end subroutine h_to_zk
