subroutine da_transform_XTogpsref(qv,p,t,ref,xp)
!
!  input: qv,p,t,xp
! output: ref
!
! modified from MM5-4DVAR. Wei Huang, May 24, 2004

   type(xpose_type), intent(in)   :: xp         ! Domain decomposition vars.
   real, dimension(xp%ims:xp%ime, xp%jms:xp%jme, xp%kms:xp%kme), &
                   intent(in)     :: qv, p, t
   real, dimension(xp%ims:xp%ime, xp%jms:xp%jme, xp%kms:xp%kme), &
                   intent(out)    :: ref
   
   real, parameter :: coeff = 3.73*1.e5/77.6

   integer :: i, j, k
   real    :: partone, parttwo, dividnd

   do k=xp%kts,xp%kte
   do j=xp%jts,xp%jte
   do i=xp%its,xp%ite
!-----calculate refractivity
!     Note: p in Pascal
      partone  = 0.776*p(i,j,k)/t(i,j,k)
      dividnd  = t(i,j,k)*(0.622+0.378*qv(i,j,k))
      parttwo  = 1.0+coeff*qv(i,j,k)/dividnd
      ref(i,j,k)= partone * parttwo
   enddo
   enddo
   enddo
   
end subroutine da_transform_XTogpsref

