SUBROUTINE DA_Calculate_Residual_Radar( oi, y, re,                        &
                                        np_missing, np_bad_data,          &
                                        np_obs_used, np_available )

   IMPLICIT NONE

   TYPE (ob_type), INTENT(IN)        :: oi     ! Innovation vector (O-B).
   TYPE (y_type) , INTENT(IN)        :: y      ! y = H (xa)
   TYPE (y_type) , INTENT(OUT)       :: re     ! Residual structure.

   INTEGER       , INTENT(INOUT)     :: np_available, np_obs_used,          &
                                        np_missing  , np_bad_data

   TYPE (bad_data_type)              :: n_obs_bad
   INTEGER                           :: n, k

   IF ( oi%num_Radar > 0 ) THEN

      n_obs_bad % rv % num = number(0, 0, 0)

      DO n=1, oi%num_Radar

      if( oi%Radar(n)%loc%proc_domain_with_halo ) then

      do k=1, oi%Radar(n)%info%levels

         np_available = np_available + 2

         re%Radar(n)%rv(k) = residual( n, k, y%Radar(n)%rv(k), &
                                       oi%Radar(n)%rv(k), n_obs_bad % rv )
      end do

      end if

      END DO

      np_missing = np_missing + n_obs_bad % rv % num % miss
      np_bad_data = np_bad_data + n_obs_bad % rv % num % bad
      np_obs_used = np_obs_used + n_obs_bad % rv % num % use
   ENDIF

END SUBROUTINE DA_Calculate_Residual_Radar
