SUBROUTINE da_get_innov_vector_Radar ( it, xb, xp, ob, iv )

   IMPLICIT NONE

   INTEGER, INTENT(IN)            :: it       ! External iteration.
   TYPE (xb_type), INTENT(IN)     :: xb       ! first guess state.
   TYPE (xpose_type), INTENT(IN)  :: xp       ! Domain decomposition vars.
   TYPE (y_type),  INTENT(IN)     :: ob       ! Observation structure.
   TYPE (ob_type), INTENT(INOUT)  :: iv       ! O-B structure.

   INTEGER                        :: n        ! Loop counter.
   INTEGER                        :: i, j, k  ! Index dimension.
   INTEGER                        :: num_levs ! Number of obs levels.
   REAL                           :: dx, dxm  ! Interpolation weights.
   REAL                           :: dy, dym  ! Interpolation weights.
   REAL                           :: dz, dzm  ! Interpolation weights.

   REAL, DIMENSION(max_ob_levels) :: model_p  ! Model value p at ob location.
   REAL, DIMENSION(max_ob_levels) :: model_u  ! Model value u at ob location.
   REAL, DIMENSION(max_ob_levels) :: model_v  ! Model value v at ob location.
   REAL, DIMENSION(max_ob_levels) :: model_w  ! Model value w at ob location.
   REAL, DIMENSION(max_ob_levels) :: model_qrn ! Model value qrn at ob location.

   REAL, DIMENSION(max_ob_levels) :: model_rv ! Model value rv at ob location.
   REAL                           :: model_ps

   REAL                           :: xr,yr,zr
   INTEGER                        :: irv, irvf

   IF ( iv % num_Radar > 0 ) THEN

      irv = 0; irvf = 0

      DO n=1, iv % num_Radar

       if(iv%Radar(n)%loc%proc_domain_with_halo) then
         num_levs = iv % Radar(n) % info % levels

         if ( num_levs < 1 ) cycle

         model_p(:) = 0.0
         model_u(:) = 0.0
         model_v(:) = 0.0
         model_w(:) = 0.0
         model_qrn(:) = 0.0
      
!        [1.3] Get dot pt. horizontal interpolation weights:

         i = iv%Radar(n)%loc%i
         j = iv%Radar(n)%loc%j
         dx = iv%Radar(n)%loc%dx
         dy = iv%Radar(n)%loc%dy
         dxm = iv%Radar(n)%loc%dxm
         dym = iv%Radar(n)%loc%dym

!        [1.4] Interpolate horizontally from dot points:

#ifndef DEREF_KLUDGE
         call Interp_lin_3D(xb % u, xp, i, j, dx, dy, dxm, dym, &
                            model_u, num_levs, iv%Radar(n)%zk, &
                            num_levs )
         call Interp_lin_3D(xb % v, xp, i, j, dx, dy, dxm, dym, &
                            model_v, num_levs, iv%Radar(n)%zk, &
                            num_levs )
#else
         call Interp_lin_3D(xb % u(xp%ims,xp%jms,xp%kms), xp, &
                            i, j, dx, dy, dxm, dym, &
                            model_u, num_levs, iv%Radar(n)%zk, num_levs )
         call Interp_lin_3D(xb % v(xp%ims,xp%jms,xp%kms), xp, &
                            i, j, dx, dy, dxm, dym, &
                            model_v, num_levs, iv%Radar(n)%zk, num_levs )
#endif

!        [1.6] Interpolate horizontally from crs points:

#ifndef DEREF_KLUDGE
         call Interp_lin_3D(xb % qrn, xp, i, j, dx, dy, dxm, dym, &
                            model_qrn, num_levs, iv%Radar(n)%zk, num_levs )

         call Interp_lin_3D(xb % p, xp, i, j, dx, dy, dxm, dym, &
                            model_p, num_levs, iv%Radar(n)%zk, num_levs )
#else
         call Interp_lin_3D(xb % qrn(xp%ims,xp%jms,xp%kms), xp, &
                            i, j, dx, dy, dxm, dym, &
                            model_qrn, num_levs, iv%Radar(n)%zk, num_levs )

         call Interp_lin_3D(xb % p(xp%ims,xp%jms,xp%kms), xp, &
                            i, j, dx, dy, dxm, dym, &
                            model_p, num_levs, iv%Radar(n)%zk, num_levs )
#endif

         model_ps = dxm * (dym * xb % psac(i,  j) + dy * xb%psac(i+1,  j)) + &
                    dx  * (dym * xb % psac(i,j+1) + dy * xb%psac(i+1,j+1)) + &
                    xb % ptop

         iv%Radar(n)%model_p(1:num_levs) = model_p(1:num_levs)
         iv%Radar(n)%model_qrn(1:num_levs) = model_qrn(1:num_levs)
         iv%Radar(n)%model_ps = model_ps

#ifndef DEREF_KLUDGE
         call Interp_lin_3D(xb%wh, xp, i, j, dx, dy, dxm, dym, &
                            model_w, num_levs, iv%Radar(n)%zk, num_levs )
#else
         call Interp_lin_3D(xb%wh(xp%ims,xp%jms,xp%kms), xp, &
                            i, j, dx, dy, dxm, dym, &
                            model_w, num_levs, iv%Radar(n)%zk, num_levs )
#endif

!        [1.6] Calculate rv at OBS location

         xr = xb%ds * (iv%Radar(n)%loc%x - iv%Radar(n)%stn_loc%x)
         yr = xb%ds * (iv%Radar(n)%loc%y - iv%Radar(n)%stn_loc%y)

         model_rv(:) = 0.0

         do k=1, num_levs

            IF ( iv % Radar(n) % height_qc(k) /= far_below_model_surface &
                 .AND. iv % Radar(n) % height_qc(k) /= above_model_lid ) THEN

               IF ( ABS(iv % Radar(n) % rv(k) % qc - missing_data) > 1 ) THEN

                  zr=iv%Radar(n)%height(k) - iv%Radar(n)%stn_loc%elv

                  call da_radial_velocity(model_rv(k), model_p(k),  &
                       model_u(k), model_v(k), model_w(k),          &
                       model_qrn(k), model_ps, xr, yr, zr)

               END IF

            END IF

         end do

!------------------------------------------------------------------------
!        [2.0] Initialise components of innovation vector:
!------------------------------------------------------------------------

         do k = 1, iv % Radar(n) % info % levels

            iv % Radar(n) % rv(k) % inv = 0.0

            IF ( iv % Radar(n) % height_qc(k) /= far_below_model_surface &
           .AND. iv % Radar(n) % height_qc(k) /= above_model_lid ) THEN

!------------------------------------------------------------------------
!              [4.0] Fast interpolation at dot points:
!------------------------------------------------------------------------

               IF ( ABS(ob % Radar(n) % rv(k) - missing_r) > 1. .AND. &
                    iv % Radar(n) % rv(k) % qc >= obs_qc_pointer ) THEN

                    iv % Radar(n) % rv(k) % inv = ob % Radar(n) % rv(k) - &
                                                 model_rv(k)
               ENDIF

            END IF

         END DO

!------------------------------------------------------------------------
!        [5.0] Perform optional maximum error check:
!------------------------------------------------------------------------

      IF (check_max_iv )   & 
      CALL da_check_max_iv_Radar(it, iv % Radar(n), irv, irvf )

       endif
            
      END DO

    write(unit = check_max_iv_unit, FMT ='(A,i5,A)')'For outer iteration ',it,&
          ', Total Rejections for Radar follows:'
       WRITE (UNIT = check_max_iv_unit, FMT = '(/,4(2(A,I6),/))') &
      'Number of failed u-wind observations:     ',irvf, ' on ',irv

   ENDIF

END SUBROUTINE da_get_innov_vector_Radar

