!3DVAR:DRIVER_LAYER:MAIN
!

PROGRAM da_3dvar

   USE module_machine
   USE module_domain
   USE module_driver_constants
   USE module_configure

   USE module_timing
   USE module_wrf_error
#ifdef DM_PARALLEL
   USE module_dm
#endif

   USE module_wrf_3dvar_io
   USE module_wrf_3dvar_interface

   IMPLICIT NONE

   REAL    :: time

   TYPE (domain) , POINTER :: keep_grid, grid_ptr, null_domain
   TYPE (grid_config_rec_type)              :: config_flags

   INTEGER :: max_dom , domain_id , fid , oid , idum1 , idum2 , ierr
   INTEGER :: debug_level

#ifdef DM_PARALLEL
   INTEGER                 :: nbytes
   INTEGER, PARAMETER      :: configbuflen = 8*1024
   INTEGER                 :: configbuf( configbuflen )
   LOGICAL , EXTERNAL      :: wrf_dm_on_monitor
#endif

   CHARACTER (LEN=80)      :: message

!--Define the name of this program (program_name defined in module_domain)

   program_name = "WRF_3DVAR"

!--Get the NAMELIST data for input.

   CALL init_modules


#ifdef DM_PARALLEL
   IF ( wrf_dm_on_monitor() ) THEN
     CALL start_timing
     CALL initial_config
   ENDIF

   CALL get_config_as_buffer( configbuf, configbuflen, nbytes )
   CALL wrf_dm_bcast_bytes( configbuf, nbytes )
   CALL set_config_as_buffer( configbuf, configbuflen )
   CALL wrf_dm_initialize
#else
   CALL start_timing
   CALL initial_config
#endif

   CALL get_debug_level ( debug_level )
   CALL set_wrf_debug_level ( debug_level )

!--allocated and configure the mother domain

   NULLIFY( null_domain )

   CALL       wrf_debug ( 100 , 'wrf: calling alloc_and_configure_domain ' )
   CALL alloc_and_configure_domain ( domain_id  = 1 ,                  &
                                     local_time = 0 ,                  &
                                     grid       = head_grid ,          &
                                     parent     = null_domain ,        &
                                     kid        = -1                   )

   CALL       wrf_debug ( 100 , 'wrf: calling model_to_grid_config_rec ' )
   CALL model_to_grid_config_rec ( head_grid%id , model_config_rec , config_flags )
   CALL       wrf_debug ( 100 , 'wrf: calling set_scalar_indices_from_config ' )
   CALL set_scalar_indices_from_config ( head_grid%id , idum1, idum2 )
   CALL       wrf_debug ( 100 , 'wrf: calling init_wrfio' )

   if(config_flags%real_data_init_type == 1) then
     CALL init_wrfio

#ifdef DM_PARALLEL
     CALL get_config_as_buffer( configbuf, configbuflen, nbytes )
     CALL wrf_dm_bcast_bytes( configbuf, nbytes )
     CALL set_config_as_buffer( configbuf, configbuflen )
#endif

!--input background from wrf model. 

     CALL med_initialdata_input_3dvar( head_grid , config_flags )  
   endif

   call med_add_config_info_to_grid ( head_grid )

!--do 3dvar

   CALL wrf_debug ( 100 , 'da_3dvar: calling 3dvar ' )
   CALL da_3dvar_interface ( head_grid, config_flags )
   CALL wrf_debug ( 100 , 'da_3dvar: back from 3dvar ' )

!--output 3dvar analysis

   if(config_flags%real_data_init_type == 1) then
     CALL med_initialdata_output_3dvar( head_grid , config_flags )  

     CALL med_shutdown_io ( head_grid , config_flags )
   endif

#ifdef DM_PARALLEL
   IF ( wrf_dm_on_monitor() ) THEN
      message = 'Time elapsed in 3dvar'
      CALL end_timing ( TRIM(message) )
   END IF
#else
   message = 'Time elapsed in 3dvar'
   CALL end_timing ( TRIM(message) )
#endif

   CALL wrf_shutdown

   STOP "Stopped normally."

END PROGRAM da_3dvar

