SUBROUTINE DA_Transform_XToY_Gpspw_Adj( xb, oi, xp, jo_grad_y, jo_grad_x )

   IMPLICIT NONE

   TYPE (xb_type), INTENT(IN)    :: xb          ! first guess state.
   TYPE (ob_type), INTENT(IN)    :: oi          ! obs. inc vector (o-b).
   TYPE (xpose_type), INTENT(IN) :: xp          ! Domain decomposition vars.
   TYPE (y_type) , INTENT(IN)    :: jo_grad_y   ! grad_y(jo)
   TYPE (x_type) , INTENT(INOUT) :: jo_grad_x   ! grad_x(jo)

   INTEGER                       :: n        ! Loop counter.
   INTEGER                       :: i, j     ! Index dimension.
   REAL                          :: dx, dxm  ! 
   REAL                          :: dy, dym  !

   IF ( oi%num_Gpspw > 0 ) THEN

      DO n=1, oi % num_Gpspw

       if(oi%gpspw(n)%loc%proc_domain_with_halo) then

         i = oi%gpspw(n)%loc%i
         dy = oi%gpspw(n)%loc%dy
         dym = oi%gpspw(n)%loc%dym
         j = oi%gpspw(n)%loc%j
         dx = oi%gpspw(n)%loc%dx
         dxm = oi%gpspw(n)%loc%dxm

         jo_grad_x%tpw(i  ,j  ) = jo_grad_x%tpw(i  ,j  ) &
                                + dxm*dym*jo_grad_y%gpspw(n)%tpw
         jo_grad_x%tpw(i+1,j  ) = jo_grad_x%tpw(i+1,j  ) &
                                + dym*dx *jo_grad_y%gpspw(n)%tpw
         jo_grad_x%tpw(i  ,j+1) = jo_grad_x%tpw(i  ,j+1) &
                                + dxm *dy*jo_grad_y%gpspw(n)%tpw
         jo_grad_x%tpw(i+1,j+1) = jo_grad_x%tpw(i+1,j+1) &
                                + dx *dy *jo_grad_y%gpspw(n)%tpw

       endif

      END DO

   END IF

END SUBROUTINE DA_Transform_XToY_Gpspw_Adj

