SUBROUTINE DA_Read_Radar_Info (iunit, ob, xb, xp)

!-----------------------------------------------------------------------------!
! Read the header of a Radar observation file
!-----------------------------------------------------------------------------!

   implicit none

   INTEGER,        INTENT (in)   :: iunit
   TYPE (xb_type), INTENT (in)   :: xb
   TYPE (ob_type), INTENT (out)  :: ob
   TYPE (xpose_type), INTENT(IN) :: xp              ! Domain decomposition vars.

   TYPE (Radar_multi_level_type) :: platform

   INTEGER                       :: iost, i, j, k
   CHARACTER (LEN = 120)         :: char_ned
   LOGICAL                       :: connected

   REAL                          :: x, y, xc, yc
   REAL                          :: dx, dxm, dy, dym

   REAL, DIMENSION(xp%kms:xp%kme):: v_h      ! Model value h at ob hor. location.

!-----------------------------------------------------------------------------!
   WRITE (0,'(A)')  &
   '--------------------------------------------------------------------------'


! 1. OPEN FILE
!    ---------

   INQUIRE ( UNIT = iunit, OPENED = connected )

   IF ( .NOT. connected ) THEN
      OPEN ( UNIT   = iunit,     &
           FORM   = 'FORMATTED',  &
           ACCESS = 'SEQUENTIAL', &
           IOSTAT =  iost,     &
           STATUS = 'OLD')

      IF (iost /= 0) THEN
          WRITE (0,'(/,A,I3,A,/)') &
        ' INPUT FILE UNIT ',iunit, &
        ' RADAR OBSERVATIONS CANNOT BE FOUND OR CANNOT BE OPENED'
          RETURN
      ENDIF

   ENDIF

   REWIND (UNIT = iunit)


! 2.  READ HEADER
! ===============

! 2.1 READ FIRST LINE
!     ---------------

   READ (iunit, FMT = '(A)', IOSTAT = iost) char_ned

! 2.2 PROCESS ERROR
!     -------------

   IF (iost /= 0) THEN
       WRITE (0,'(/A,i3/)') ' ERROR READING FILE UNIT:', iunit
       STOP         ' in read_Radar_header.F' 
   ENDIF

! 2.3 RED NUMBER OF REPORTS
!     ---------------------

   READ (char_ned (1:5),'(A5)', IOSTAT = iost) platform % stn % platform

   WRITE (0, '(A)') 'RADAR Observations information'

   READ (char_ned (8:19), '(A12)', IOSTAT = iost) platform % stn % name

   WRITE (0,'(A,A5,A,A12)') ' Expect: ',platform % stn % platform, &
                            'data at station:', platform % stn % name

   READ (char_ned (20:27), '(F8.3)', IOSTAT = iost) platform % stn % lon

   READ (char_ned (30:37), '(F8.3)', IOSTAT = iost) platform % stn % lat

   READ (char_ned (40:47), '(F8.1)', IOSTAT = iost) platform % stn % elv

   WRITE (0, '(A,2(F8.3,2X),F8.1)') 'The station longitude, latutude, and altitude are: ', &
                            platform % stn % lon, &
                            platform % stn % lat, platform % stn % elv

   READ (char_ned (50:68), '(A19)', IOSTAT = iost) platform % stn % date_char

   WRITE (0, '(A,A19)') 'The observation time for this data is ',     &
                        platform % stn % date_char

   READ (char_ned (69:74), '(I6)', IOSTAT = iost) platform % stn % numObs

   WRITE (0, '(A,I6)') 'Total number of Super-observations is ', &
                        platform % stn % numObs

   READ (char_ned (75:80), '(I6)', IOSTAT = iost) platform % stn % levels

   WRITE (0, '(A,I6)') 'Vertical layers for each Super-observation is ', &
                        platform % stn % levels

   READ (iunit, FMT = '(A)', IOSTAT = iost)
   READ (iunit, FMT = '(A)', IOSTAT = iost)

! Allocate the ob based on inputed number of obs:

   max_Radar_input = platform % stn % numObs
   ALLOCATE (ob % Radar(1:max_Radar_input))

   ob % num_Radar = platform % stn % numObs

   ob % Radar(:) % stn_loc % lon = platform % stn % lon

   ob % Radar(:) % stn_loc % lat = platform % stn % lat

   ob % Radar(:) % stn_loc % elv = platform % stn % elv

! 1.0 get the MM5 (xj, yi) coordinates

   CALL llxy (platform%stn%lat, platform%stn%lon, x, y)

   xc = x - .5
   yc = y - .5
   ob % Radar(1:max_Radar_input) % stn_loc % x = xc
   ob % Radar(1:max_Radar_input) % stn_loc % y = yc

! 2.0 Pstar at obs site

   call toGrid (xc, 1, mix, i, dx, dxm)
   call toGrid (yc, 1, mjy, j, dy, dym)

   do k=xp%kts,xp%kte
      v_h(k) = dym*(dxm*xb%h(i,j  ,k) + dx*xb%h(i+1,j  ,k)) &
             + dy *(dxm*xb%h(i,j+1,k) + dx*xb%h(i+1,j+1,k)) 
   enddo

! 3.0 OBS vertical model's indices at (x, y), approximate, no use.

   do i=1, ob % num_Radar
      call to_zk(platform % stn % elv, v_h, xp, v_interp_h, ob % Radar(i) % stn_loc % zk )
   enddo

! PRINT OUT
! =============

   WRITE (0, '(A)')
   WRITE (0,'(A,F8.0)') ' Missing value flag:  ', ob%missing

END SUBROUTINE DA_Read_Radar_Info

