SUBROUTINE da_get_innov_vector( it, xb, xp, ob, iv )
!----------------------------------------------------------------------------   
!  History:
!
!  Additions:
!             07/08/2003      Profiler and Buoy Obs            S. R. H. Rizvi
!
!  Purpose: Compute O-B for different observation types:
!----------------------------------------------------------------------------   
   IMPLICIT NONE

   INTEGER, INTENT(IN)           :: it
   TYPE (xb_type), INTENT(IN)    :: xb           ! Background field.
   TYPE (xpose_type), INTENT(IN) :: xp           ! Domain decomposition vars.
   TYPE (y_type), INTENT(INOUT)  :: ob           ! Observations.
   TYPE (ob_type), INTENT(INOUT) :: iv           ! Innovation vector (O-B).

   write (6,'(/,A)') ' --------------------------------------'
   write (6,'(A)')   ' [5.1] Calculate innovation vector (iv)'
   write (6,'(A)')   ' --------------------------------------'
   write(6,*)
   
!  Radiosonde:

   CALL da_get_innov_vector_sound( it, xb, xp, ob, iv )
   CALL da_get_innov_vector_sonde_sfc( it, xb, xp, ob, iv )

!  Surface

   CALL da_get_innov_vector_synop( it, xb, xp, ob, iv )

!  Cloud track winds:

   CALL da_get_innov_vector_satob( it, xb, xp, ob, iv )

!  Aireps:

   CALL da_get_innov_vector_airep( it, xb, xp, ob, iv )

!  Pilot:

   CALL da_get_innov_vector_pilot( it, xb, xp, ob, iv )

!  Metar:

   CALL da_get_innov_vector_metar( it, xb, xp, ob, iv )

!  Ships:

   CALL da_get_innov_vector_ships( it, xb, xp, ob, iv )

!  GPSPW:

   CALL da_get_innov_vector_gpspw( it, xb, xp, ob, iv )

!  SSMI:

   CALL da_get_innov_vector_ssmi( it, xb, xp, ob, iv )

!  SSMT1:

   CALL da_get_innov_vector_ssmt1( it, xb, xp, ob, iv )

!  SSMT2:

   CALL da_get_innov_vector_ssmt2( it, xb, xp, ob, iv )

!  SATEM:

   CALL da_get_innov_vector_satem( it, xb, xp, ob, iv )

!  Radar obs:

   CALL da_get_innov_vector_Radar( it, xb, xp, ob, iv )

!  Pseudo obs:

   CALL da_get_innov_vector_pseudo( xb, xp, ob, iv )

!  Scatterometer:

   CALL da_get_innov_vector_qscat( it, xb, xp, ob, iv )

!  Profiler:

   CALL da_get_innov_vector_profiler( it, xb, xp, ob, iv )

!  Buoy:

   CALL da_get_innov_vector_buoy( it, xb, xp, ob, iv )

!---------------------------------------------------------------------------  
!  [2] Having calculated the real O-Bs, optionally overwrite with scaled,
!  random values:
!--------------------------------------------------------------------------- 
   
   if ( omb_set_rand ) CALL da_random_omb_all( iv, ob )
   
!---------------------------------------------------------------------------  
!  [3] Optionally rescale observation errors:
!--------------------------------------------------------------------------- 
   
   if ( use_obs_errfac ) CALL da_use_obs_errfac( iv )

!---------------------------------------------------------------------------  
!  [4] Optionally add Gaussian noise to O, O-B:
!--------------------------------------------------------------------------- 

   if ( omb_add_noise ) CALL da_add_noise_to_ob( iv, ob )

END SUBROUTINE da_get_innov_vector

