subroutine da_transform_XTogpsref_lin(qv,p,t,ref,qv9,p9,t9,ref9,xp)
!
!  input: qv,p,t,qv9,p9,t9,xp
! output: ref, ref9
!
! modified from MM5-4DVAR. Wei Huang, May 24, 2004
   
   TYPE (xpose_type), INTENT(IN) :: xp         ! Domain decomposition vars.
   real, dimension(xp%ims:xp%ime, xp%jms:xp%jme, xp%kms:xp%kme), &
                intent(in)     :: qv, p, t, qv9, p9, t9
   real, dimension(xp%ims:xp%ime, xp%jms:xp%jme, xp%kms:xp%kme), &
                intent(out)    :: ref, ref9
   
   real, parameter :: coeff = 3.73*1.e5/77.6
   
   integer :: i, j, k
   real    :: partone, parttwo, dividnd
   real    :: partone9,parttwo9,dividnd9
   
   do k=xp%kts,xp%kte
   do j=xp%jts,xp%jte
   do i=xp%its,xp%ite
!-----calculate refractivity
!     Note: p in Pascal

      partone  = 0.776*p (i,j,k)/t9(i,j,k)
               - 0.776*p9(i,j,k)*t (i,j,k)/(t9(i,j,k)*t9(i,j,k))
      partone9 = 0.776*p9(i,j,k)/t9(i,j,k)

      dividnd  = t (i,j,k)*(0.622+0.378*qv9(i,j,k))
               + t9(i,j,k)*       0.378*qv (i,j,k)
      dividnd9 = t9(i,j,k)*(0.622+0.378*qv9(i,j,k))

      parttwo  =     coeff*qv (i,j,k)/dividnd9
               -     coeff*qv9(i,j,k)*dividnd /(dividnd9*dividnd9)
      parttwo9 = 1.0+coeff*qv9(i,j,k)/dividnd9

      ref (i,j,k)= partone9 * parttwo
                 + partone  * parttwo9
      ref9(i,j,k)= partone9 * parttwo9
   enddo
   enddo
   enddo
   
end subroutine da_transform_XTogpsref_lin

