SUBROUTINE DA_Calculate_GradY_Radar( iv, re, jo_grad_y )
!-------------------------------------------------------------------------
!  HISTORY: 
!
!      Created: 08/17/2003                   S. R. H. Rizvi
!
!      Purpose: Applies obs inverse on re-vector
!               
!-------------------------------------------------------------------------

   IMPLICIT NONE

   TYPE (ob_type), INTENT(IN)     :: iv          ! Innovation vector.
   TYPE (y_type),  INTENT(INOUT)  :: re          ! Residual vector.
   TYPE (y_type),  INTENT(INOUT)  :: jo_grad_y   ! Grad_y(Jo)

   INTEGER                      :: n, k

   IF ( iv%num_radar > 0 ) THEN
   
      DO n=1, iv%num_radar
       if( iv%radar(n)%loc%proc_domain_with_halo ) then

         do k=1, iv%radar(n)%info%levels

            if(iv%radar(n)%rv(k)%qc < obs_qc_pointer) re%radar(n)%rv(k) = 0.0

            jo_grad_y%radar(n)%rv(k) = -re%radar(n)%rv(k) / &
                                      ( iv%radar(n)%rv(k)%error * &
                                        iv%radar(n)%rv(k)%error )
          end do
       endif  
      END DO
   END IF

END SUBROUTINE DA_Calculate_GradY_Radar
