SUBROUTINE DA_Print_Stats_Radar( stats_unit, nrv, Radar )

   IMPLICIT NONE

   INTEGER,           INTENT(IN)    :: stats_unit
   INTEGER,           INTENT(INOUT) :: nrv
   TYPE (stats_Radar_type), INTENT(IN)    :: Radar
   
   write(unit=stats_unit, fmt='(a/)') &
        '   var             rv (m/s)    n    k  '

   write(unit=stats_unit, fmt='(a,i16,i22)') &
        '  Number: ', nrv

   if(nrv < 1) nrv = 1
   
   write(unit=stats_unit, fmt='(a,f12.4,2i5)') &
        ' Minimum(n,k): ', Radar%minimum%rv, &
        ' Maximum(n,k): ', Radar%maximum%rv
   write(unit=stats_unit, fmt='(a,f12.4,10x)')  &
        ' Average     : ', Radar%average%rv/real(nrv),       &
        '    RMSE     : ', sqrt(Radar%rms_err%rv/real(nrv))

END SUBROUTINE DA_Print_Stats_Radar

