SUBROUTINE da_transform_xtoy_Radar ( xa, xb, iv, xp, y )

!---------------------------------------------------------------------
!  This subroutine is to calculate the Doppler radial velocity and 
!  reflectivity at the observation location from the first guess.
!  It is linearized.  Qingnong Xiao, September 2002.
!  It is Modified.    Jianfeng Gu,   April 2004.
!---------------------------------------------------------------------
 
   IMPLICIT NONE

   TYPE (x_type),  INTENT(IN)   :: xa       ! gridded analysis increment.
   type (xb_type), intent(in)   :: xb          ! first guess state.
   TYPE (ob_type), INTENT(IN)   :: iv       ! Innovation vector (O-B).
   TYPE (xpose_type), INTENT(IN):: xp       ! Domain decomposition vars.
   TYPE (y_type), INTENT(INOUT) :: y        ! y = h (xa) (linear)

   INTEGER                      :: n        ! Loop counter.
   INTEGER                      :: i, j, k  ! Index dimension.
   INTEGER                      :: num_levs ! Number of obs levels.
   INTEGER                      :: max_num_levs ! Number of obs levels.
   REAL                         :: dx, dxm  ! 
   REAL                         :: dy, dym  !
   REAL                         :: dz, dzm  !

   REAL, DIMENSION(max_levels)  :: model_p  ! Model value p at ob location.
   REAL, DIMENSION(max_levels)  :: model_u  ! Model value u at ob location.
   REAL, DIMENSION(max_levels)  :: model_v  ! Model value v at ob location.
   REAL, DIMENSION(max_levels)  :: model_w  ! Model value w at ob location.
   REAL, DIMENSION(max_levels)  :: model_qrn ! Model qrn at ob location.
   REAL, DIMENSION(max_levels)  :: model_qrnb! Model qrn at ob location.
   REAL                         :: model_ps

   REAL                         :: xr,yr,zr

   REAL, DIMENSION(xp%ims:xp%ime,xp%jms:xp%jme,xp%kms:xp%kme) :: wh
   INTEGER                      :: ii, jj, kk


   IF ( iv%num_Radar > 0 ) THEN

      do n=1, iv % num_Radar

       if(iv%Radar(n)%loc%proc_domain_with_halo) then

         num_levs = iv % Radar(n) % info % levels

!        [1.3] Get dot pt. horizontal interpolation weights:

         i = iv%Radar(n)%loc%i
         j = iv%Radar(n)%loc%j
         dx = iv%Radar(n)%loc%dx
         dy = iv%Radar(n)%loc%dy
         dxm = iv%Radar(n)%loc%dxm
         dym = iv%Radar(n)%loc%dym

!        [1.4] Interpolate horizontally from dot points:
#ifndef DEREF_KLUDGE
         call Interp_lin_3D(xa % u, xp, i, j, dx, dy, dxm, dym, &
                            model_u, num_levs, iv%Radar(n)%zk, &
                            num_levs)
         call Interp_lin_3D(xa % v, xp, i, j, dx, dy, dxm, dym, &
                            model_v, num_levs, iv%Radar(n)%zk, &
                            num_levs)
#else
         call Interp_lin_3D(xa % u(xp%ims,xp%jms,xp%kms), xp, &
                            i, j, dx, dy, dxm, dym, &
                            model_u(1), num_levs, iv%Radar(n)%zk(1), &
                            num_levs)
         call Interp_lin_3D(xa % v(xp%ims,xp%jms,xp%kms), xp, &
                            i, j, dx, dy, dxm, dym, &
                            model_v(1), num_levs, iv%Radar(n)%zk(1), &
                            num_levs)
#endif

!        [1.6] Interpolate horizontally from crs points:

         do k = 1, num_levs
            model_qrnb(k) = iv%Radar(n)%model_qrn(k)
         end do

#ifndef DEREF_KLUDGE
         call Interp_lin_3D(xa % qrn, xp, &
                            i, j, dx, dy, dxm, dym, &
                            model_qrn, num_levs, iv%Radar(n)%zk, &
                            num_levs)
#else
         call Interp_lin_3D(xa % qrn(xp%ims,xp%jms,xp%kms), xp, &
                            i, j, dx, dy, dxm, dym, &
                            model_qrn(1), num_levs, iv%Radar(n)%zk(1), &
                            num_levs)
#endif

         do k = 1, num_levs
            model_p(k) = iv%Radar(n)%model_p(k)
         end do

            model_ps   = iv%Radar(n)%model_ps

            do kk=xp%kds,xp%kde
            do jj=j,j+1
            do ii=i,i+1
               wh(ii,jj,kk)=0.5*(xa%w(ii,jj,kk)+xa%w(ii,jj,kk+1))
            enddo
            enddo
            enddo

#ifndef DEREF_KLUDGE
         call Interp_lin_3D(wh, xp,   &
                            i, j, dx, dy, dxm, dym, &
                            model_w, num_levs, iv%Radar(n)%zk, &
                            num_levs )
#else
         call Interp_lin_3D(wh(xp%ims,xp%jms,xp%kms), xp,   &
                            i, j, dx, dy, dxm, dym, &
                            model_w(1), num_levs, iv%Radar(n)%zk(1), &
                            num_levs )
#endif

!        [1.7] Calculate rv at OBS location

         xr = xb%ds * (iv%Radar(n)%loc%x - iv%Radar(n)%stn_loc%x)
         yr = xb%ds * (iv%Radar(n)%loc%y - iv%Radar(n)%stn_loc%y)

         do k = 1, num_levs
            y%Radar(n)%rv(k) = 0.0
         end do

         do k=1, num_levs

            zr=iv%Radar(n)%height(k) - iv%Radar(n)%stn_loc%elv
            call da_radial_velocity_Lin(y%Radar(n)%rv(k), model_p(k), &
                 model_u(k), model_v(k), model_w(k), model_qrn(k),    &
                 model_ps, xr, yr, zr, model_qrnb(k) )

         end do

       end if

      end do

   ENDIF

END SUBROUTINE da_transform_xtoy_Radar 

