MODULE DA_Setup_Structures

!------------------------------------------------------------------------------
!  PURPOSE: Sets up various structures.
!
!  METHOD:  Varied.
!
!  HISTORY: 01/06/2000 - Creation of F90 version.           Dale Barker
!
!------------------------------------------------------------------------------

   USE DA_Define_Structures
   USE DA_Constants
   USE DA_Grid_Definitions
   USE DA_Obs
   USE DA_SSMI
   USE DA_VToX_Transforms
   USE DA_Physics
   USE DA_Tools
   USE da_h_ops
   use DA_ReadWrite_MM5

   IMPLICIT NONE

#ifdef DM_PARALLEL
   INCLUDE 'mpif.h'
#endif

   CONTAINS

#include <da_get_vertical_truncation.inc>
#include <da_interpolate_regcoeff.inc>
#include <da_interpolate_stats.inc>
#include <da_rescale_background_errors.inc>
#include <da_setup_background_errors3.inc>
#include <da_chgvres.inc>
#include <da_setup_background_errors.inc>
#include <da_setup_firstguess.inc>
#include <da_setup_firstguess_mm5.inc>
#include <da_setup_firstguess_wrf.inc>
#include <da_setup_obs_structures.inc>
#include <da_setup_obs_structures_bufr.inc>
#include <da_setup_obs_structures_mm5.inc>
#include <da_setup_obs_interp_wts.inc>
#include <da_setup_runconstants.inc>
#include <da_transfer_mm5toxb.inc>
#include <da_transfer_wrftoxb.inc>
#include <da_transfer_xatowrf.inc>
#include <da_write_analysis.inc>
#include <da_write_interpolated_be.inc>

END MODULE DA_Setup_Structures
