SUBROUTINE DA_Setup_FirstGuess_WRF( xbx, grid, &
!
#include <em_dummy_args.inc>
!
                              )

!------------------------------------------------------------------------------
!  PURPOSE: Define/allocate components of WRF model state.
!
!  METHOD:
!
!  HISTORY: 04/16/2002 - Creation of F90 version.           Dale Barker
!
!  PARENT_MODULE: DA_Setup_Structures
!------------------------------------------------------------------------------

   IMPLICIT NONE

   TYPE (xbx_type),INTENT(OUT)         :: xbx    ! Header & non-gridded vars.

   TYPE(domain) , TARGET               :: grid

!  Definitions of dummy arguments to solve
#include <em_dummy_decl.inc>
!---------------------------------------------------------------------------

   INTEGER           :: ier    ! error index

   integer           :: i, j
   integer           :: wrf_dim1, wrf_dim2, wrf_dim3
   REAL              :: x, y
  
   real              :: theta1, theta2, conv

   character(len=24) :: xb_date, an_date
   integer(kind=4)   :: flag
   integer           :: len, index, seconds

   LOGICAL, EXTERNAL :: wrf_dm_on_monitor

!---------------------------------------------------------------------------
!  [1.0] Read original WRF format first guess:
!---------------------------------------------------------------------------

   conv = 180.0 / pi

!  IF ( wrf_dm_on_monitor() ) THEN
!  ENDIF

!  call wrf_struct_bcast( xb )
   
!---------------------------------------------------------------------------
!  [2.0] Copy header info:
!---------------------------------------------------------------------------

   map_projection = grid%map_proj
   coarse_ix = grid%e_we - grid%s_we + 1
   coarse_jy = grid%e_sn - grid%s_sn + 1
   coarse_ds = 0.001 * grid%dx

!  phic = grid%cen_lat
!  xlonc = grid%cen_lon

   phic = grid%moad_cen_lat
   xlonc = grid%stand_lon

   truelat1_3dv = grid%truelat1
   truelat2_3dv = grid%truelat2
   pole = 90.0        !XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
   dsm = 0.001 * grid%dx

   if(print_detail > 0) then
   write(unit=*, fmt='(a, i6)') &
        'map_proj =', grid%map_proj, &
        'coarse_ix =', coarse_ix, &
        'coarse_jy =', coarse_jy

   write(unit=*, fmt='(a, e16.6)') &
        'cen_lat  =', grid%cen_lat,  &
        'cen_lon  =', grid%cen_lon,  &
        'truelat1 =', grid%truelat1, &
        'truelat2 =', grid%truelat2, &
        'dsm      =', dsm
   endif

   if (map_projection == 1) then

      if(abs(truelat1_3dv - truelat2_3dv) < 0.1) then

         write(unit=*, fmt='(a, f12.3)') &
              'truelat1_3dv = ', truelat1_3dv, &
              'truelat2_3dv = ', truelat2_3dv

         cone_factor = SIGN (1.,truelat1_3dv)*SIN (truelat1_3dv / conv)

      else

         theta1 = (90.0 - truelat1_3dv)/CONV
         theta2 = (90.0 - truelat2_3dv)/CONV
 
         cone_factor = (log(sin(theta1)) - log(sin(theta2))) &
                     / (log(tan(theta1*0.5)) - log(tan(theta2*0.5)))

      endif

   else if (map_projection == 2) then

      cone_factor = 1.0

   else if (map_projection == 3) then

      cone_factor = 0.0

   endif
   
!  X,Y locations of starting point (1,1) of grid in coarse domain. Note: 0.5 
!  is added in WRF 3DVAR because original MM5 (1,1) is a dot point whereas in 
!  3DVAR there are only cross points!

!   start_x = 1.0
!   start_y = 1.0

! start_x and start_y should be the location in the mother domain
! of the nest's low-left corner (1,1). For coarset domain, they are
! 1.0, but for nest domain, they come from wrf namelist.input now
! (Y.-R. Guo 06/10/2004):
    
   start_x = real(grid%i_parent_start)
   start_y = real(grid%j_parent_start)

   CALL Set_Map_Para ! set up the map background parameters

   CALL llxy( PHIC,XLONC,X,Y )


!---------------------------------------------------------------------------
!  [3.0] Interpolate WRF C-grid winds to p points of 3DVAR grid (interpolate 
!  u to west, v to south?
!---------------------------------------------------------------------------

   xb % mix = xp%ide - xp%ids + 1
   xb % mjy = xp%jde - xp%jds + 1
   xb % mkz = xp%kde - xp%kds + 1

   xb % ds  = coarse_ds

   mix = xb % mix
   mjy = xb % mjy
   mkz = xb % mkz

   if(print_detail > 0) then
      write(unit=*, fmt='(a, i6)') &
           'mix=', mix, &
           'mjy=', mjy, &
           'mkz=', mkz

      write(unit=*, fmt='(a, e16.6)') &
           'start_x  =', start_x, &
           'start_y  =', start_y, &
           'xb % ds  =', xb % ds, &
           'dsm      =', dsm
   endif
   
   CALL DA_Transfer_WRFToXb( xbx, grid, &
 
#include <em_dummy_args.inc>

                           )

END SUBROUTINE DA_Setup_FirstGuess_WRF

