subroutine da_write_analysis( xp, xb, xa, it )

!------------------------------------------------------------------------------
!  PURPOSE: Write out full analysis.
!
!  METHOD:  
!
!  HISTORY: 10/06/2001 - Creation of F90 version.           Dale Barker
!
!  PARENT_MODULE: DA_Setup_Structures
!------------------------------------------------------------------------------

   IMPLICIT NONE

   INTEGER,           INTENT(IN)    :: it    ! outer-loop index
   TYPE (xpose_type), INTENT(IN)    :: xp    ! Domain decomposition vars.
   TYPE (xb_type),    INTENT(INOUT) :: xb    ! Analysis.
   TYPE (x_type),     INTENT(IN)    :: xa    ! Analysis increments.

   write (6,'(A)') ' ---------------------------------------------------'
   write (6,'(A)') ' [6.0] Output 3DVAR analysis and analysis increments'
   write (6,'(A)') ' ---------------------------------------------------'
   write(6,*)

!------------------------------------------------------------------------------      
!  [1.0] Write out analysis in differing formats:
!------------------------------------------------------------------------------      

   if ( fg_format == 1 ) then

!     [1.1] First guess is a WRF format file:
!      call da_write_analysis_wrf( xb )

   else if ( fg_format == 2 ) then

!     [1.2] Use increments to reconstitute the analysis in MM5 format:
      call da_write_analysis_mm5( xb % mix, xb % mjy, xb % mkz, &
                                  xp, xb, xa, it )

   end if

end subroutine da_write_analysis

