SUBROUTINE DA_ll_to_xy (info, loc, xb, &
                        outside, inside_halo)

!  This routine convert the (lat, lon) into (x,y) coordinates

   IMPLICIT NONE

   !  Argument

   TYPE(info_type),       intent(in)    :: info
   TYPE(model_loc_type),  intent(inout) :: loc
   TYPE(xb_type),         intent(in)    :: xb
   LOGICAL      ,         intent(out)   :: outside      !wrt local domain
   LOGICAL      ,         intent(out)   :: inside_halo

   outside = .false.
   inside_halo = .true.

   loc % x   = -1.0
   loc % y   = -1.0

!  1.0 First, get the (x, y) coordinates

   CALL llxy (info%lat, info%lon, loc%x, loc%y)

   call toGrid (loc%x, xb%its-2, xb%ite+2, loc%i, loc%dx, loc%dxm)
   call toGrid (loc%y, xb%jts-2, xb%jte+2, loc%j, loc%dy, loc%dym)

!-----Computation to check for edge of domain:

   if((loc%i < xb%ids) .or. (loc%i >= xb%ide) .or. &
      (loc%j < xb%jds) .or. (loc%j >= xb%jde)) then
      outside = .true.
      inside_halo = .false.
      return
   endif

   if((loc%i < xb%its-1) .or. (loc%i > xb%ite) .or. &
      (loc%j < xb%jts-1) .or. (loc%j > xb%jte)) then
      outside = .true.
      inside_halo = .false.

      if(def_sub_domain ) then
         if( x_start_sub_domain > loc%x .or. y_start_sub_domain > loc%y .or. &
             x_end_sub_domain   < loc%x .or. y_end_sub_domain   < loc%y) then
             outside = .true.
             inside_halo = .false.
         endif
      endif
   endif

END SUBROUTINE DA_ll_to_xy

