
;   Example script to show how to zoom 2d plots

load "WRFOptions.ncl"     ; set basic plot options here
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "WRFPlot.ncl"
load "WRFUserARW.ncl"
load "SkewTFunc.ncl"

begin
;
; The WRF ARW input file.  
; This needs to have a ".nc" appended, so just do it.

  a = addfile("../WRFV2/run/wrfout_d01_2000-01-24_12:00:00.nc","r")

;  We generate plots, but what kind do we prefer?

   type = "x11"
;  type = "pdf"
;  type = "ps"
;  type = "ncgm"

  wks = gsn_open_wks(type,"wrf_zoom")

; Debug information.

  debug  = False
;  debug  = True
  icount = 0

; Basic Plot Information                             

    res@MainTitle                   = "WRF Zoom Example"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;  What times and how many time steps are in the data set?

  FirstTime = True
  times  = wrf_user_list_times(a)  ; get times in the file
  ntimes = dimsizes(times)         ; number of times in the file

; The specific pressure levels that we want the data
; interpolated to.

  pressure_levels = (/ 850., 700., 500., 300./)   ; pressure levels to plot
  nlevels         = dimsizes(pressure_levels)     ; number of pressure levels

; This is the big loop over all of the time periods to process.

  ;do it = 0,ntimes-1,2
  do it = 0,2,2

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;Save some Time Information and create the Map Background 

    time = it
    if (FirstTime) then
      times_sav = times(it)
    end if
    res@TimeLabel                  = times(it)

    map      = wrf_map(wks,a,res)                ; Standard map
    x_start = 20
    y_start = 20
    x_end   = 40
    y_end   = 40
    map_zoom = wrf_map_zoom(wks,a,res,x_start,y_start,x_end,y_end)           ; Zoomed map

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; First get the variables we will need        

    tc  = wrf_user_getvar(a,"tc",time)     ; T in C
    if ( it .eq. 0 ) then                
      tc2 = tc(0,:,:)                      ; Use lowest T at time zero
    else
      tc2 = wrf_user_getvar(a,"T2",time)   ; T2 in Kelvin
      tc2 = tc2-273.16                     ; T2 in C
    end if
    tc_plane = 1.8*tc2+32.                 ; Turn temperature into Fahrenheit
    tc_zoom  = tc_plane(x_start:x_end,y_start:y_end)

    ter = wrf_user_getvar(a,"HGT",time)    ; terrain height 
    ter_zoom = ter(x_start:x_end,y_start:y_end)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; Plot full terrain, then zoomed terrain
    opts = res                          
    opts@cnFillOn           = True  
    contour  = wrf_contour(a,wks,ter,opts)
    wrf_map_overlay(wks,map,(/contour/),False)
    delete(contour)
    contour  = wrf_contour(a,wks,ter_zoom,opts)
    wrf_map_overlay(wks,map_zoom,(/contour/),False)
    delete(contour)
    delete(opts)

; Plot full tc, then zoomed tc
    opts = res                          
    opts@cnFillOn           = True  
    opts@FieldTitle         = "Surface Temperature"
    opts@UnitLabel          = "F"
    contour  = wrf_contour(a,wks,tc_plane,opts)
    wrf_map_overlay(wks,map,(/contour/),False)
    delete(contour)
    contour  = wrf_contour(a,wks,tc_zoom,opts)
    wrf_map_overlay(wks,map_zoom,(/contour/),False)
    delete(contour)
    delete(opts)
    
  ;       ************************************************************

      times_sav = times(it)
      FirstTime = False
  end do  ;       end of the time loop

end
