
;   Script to produce standard plots for a WRF hill2d run

load "WRFOptions.ncl"
;load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "gsn_code.ncl"
load "WRFPlot.ncl"
load "WRFUserARW.ncl"

begin
;
; The WRF ARW input file.  
; This needs to have a ".nc" appended, so just do it.

  a = addfile("../WRFV2/run/wrfout_d01_0001-01-01_00:00:00.nc","r")

;  We generate plots, but what kind do we prefer?

   type = "x11"
;  type = "pdf"
;  type = "ps"
;  type = "ncgm"

  wks = gsn_open_wks(type,"wrf_hill2d")

; Debug information.

  debug  = False
;  debug  = True
  icount = 0

; Basic Plot options, including header information

    res@MainTitle                 = "WRF HILL2x"     


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;  What times and how many time steps are in the data set?

  times  = wrf_user_list_times(a)  ; get times in the file
  ntimes = dimsizes(times)         ; number of times in the file

; The specific plane we want to plot data on

  plane = (/ 20., 0./)   ; (x,y) point for vertical plane
  angle = 90.0
  pii = 3.14159
  aspect_ratio = .7

; This is the big loop over all of the time periods to process.

  do it = 0,ntimes-1,30

    time = it
    res@TimeLabel                  = times(it)
    res@AspectRatio                = aspect_ratio
    res@PlotOrientation            = "(" + plane(0)+","+plane(1) + ")" + " angle " + angle


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; First get the variables we will need        

  u_in   = wrf_user_getvar(a,"ua",time)    ; ua is u averaged to mass points
  v_in   = wrf_user_getvar(a,"va",time)    ; va is v averaged to mass points
  w_in   = wrf_user_getvar(a,"wa",time)    ; vertical velocity
  th_in  = wrf_user_getvar(a,"th",time)    ; get temperature (C)
  z_in   = wrf_user_getvar(a, "Z",time)    ; grid point height
  ter    = wrf_user_getvar(a,"HGT",time)   ; need terrain height sometimes

  u   =  u_in(0:34,:,:)
  v   =  v_in(0:34,:,:)
  w   =  w_in(0:34,:,:)
  th  = th_in(0:34,:,:)
  z   =  z_in(0:34,:,:)

  u_plane  = wrf_user_intrp3d( u,z,ter,"v",plane,angle)
  v_plane  = wrf_user_intrp3d( v,z,ter,"v",plane,angle)
  w_plane  = wrf_user_intrp3d( w,z,ter,"v",plane,angle)
  th_plane = wrf_user_intrp3d(th,z,ter,"v",plane,angle)

  vel_normal  = u_plane*cos(2.*pii*angle/360.) - v_plane*sin(2.*pii*angle/360.)
  vel_tangent = u_plane*sin(2.*pii*angle/360.) + v_plane*cos(2.*pii*angle/360.)
  vel_tangent = vel_tangent - 10.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ; Theta
      opts_th  = res
      opts_th@FieldTitle           = th_in@description
      opts_th@cnFillOn             = True
      opts_th@gsnSpreadColorEnd    = -10   
      contour_th     = wrf_contour(a,wks,th_plane,opts_th)
      print_opts("opts_th",  opts_th,  debug)

 ; Vertical Velocity
      opts_w   = res
      opts_w@FieldTitle            = w_in@description
      contour_w = wrf_contour(a,wks, w_plane,opts_w)
      print_opts("opts_w",   opts_w,   debug)

 ; Vel Tangent
      opts_vt   = res
      opts_vt@FieldTitle           = "Perturbation u"
      opts_vt@UnitLabel            = "m/s"
      contour_vt     = wrf_contour(a,wks,vel_tangent,opts_vt)
      print_opts("opts_vt",  opts_vt,  debug)


      wrf_overlay(wks,(/contour_th, contour_vt/),False)
      print_header(icount,debug)
      wrf_overlay(wks,(/contour_th, contour_w/),False)
      print_header(icount,debug)

  ;       ************************************************************

  end do  ;       end of the time loop

end
