
;   Script to produce standard plots for a WRF real-data run,
;   with the ARW coordinate dynamics option.

load "WRFOptions.ncl"
;load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "gsn_code.ncl"
load "WRFPlot.ncl"
load "WRFUserARW.ncl"

begin
;
; The WRF ARW input file.  
; This needs to have a ".nc" appended, so just do it.

  a = addfile("../WRFV2/run/wrfout_d01_2000-01-24_12:00:00.nc","r")

;  We generate plots, but what kind do we prefer?

   type = "x11"
;  type = "pdf"
;  type = "ps"
;  type = "ncgm"

  wks = gsn_open_wks(type,"wrf_real_cloud")
  gsn_define_colormap(wks,"WhBlGrYeRe")

; Debug information.

   debug  = False
;  debug  = True
   icount = 0

; Basic Plot Information                             

    res@MainTitle                   = "REAL-TIME WRF"


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;  What times and how many time steps are in the data set?

  FirstTime = True
  times  = wrf_user_list_times(a)  ; get times in the file
  ntimes = dimsizes(times)         ; number of times in the file

; This is the big loop over all of the time periods to process.

  do it = 2,ntimes-1,2

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;Save some Time Information and create the Map Background 

    time = it
    if (FirstTime) then
      times_sav = times(it)
    end if
    res@TimeLabel                  = times(it)

    map = wrf_map(wks,a,res)                   

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; First get the variables we will need        

    if(isfilevar(a,"QVAPOR"))
      qv  = wrf_user_getvar(a,"QVAPOR",time) 
    end if
    if(isfilevar(a,"QCLOUD"))
      qc  = wrf_user_getvar(a,"QCLOUD",time)
    end if
    if(isfilevar(a,"QRAIN"))
      qr  = wrf_user_getvar(a,"QRAIN",time)
    end if
    if(isfilevar(a,"QICE"))
      qi  = wrf_user_getvar(a,"QICE",time)
    end if

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  ;       ************************************************************

        ;       Loop over levels to plot

    do level = 0,24,5      
      display_level = level + 1

      if (isvar("qv"))
        qv_plane  = qv(level,:,:)
        qv_plane  = qv_plane*1000.
        opts_qv = res
        opts_qv@cnFillOn         = True
        opts_qv@gsnSpreadColors  = False
        opts_qv@FieldTitle       = qv@description
        opts_qv@UnitLabel        = "g/kg"   
        opts_qv@PlotLevelID      = "Eta Level  " + display_level
        contour_qv     = wrf_contour(a,wks,qv_plane,opts_qv)
        print_opts("opts_qv",  opts_qv,  debug)
        wrf_map_overlay(wks,map,(/contour_qv/),False)
        print_header(icount,debug)
      end if

      if (isvar("qc"))
        qc_plane  = qc(level,:,:)
        qc_plane  = qc_plane*1000.
        opts_qc = res
        opts_qc@cnFillOn         = True
        opts_qc@gsnSpreadColors  = False
        opts_qc@FieldTitle       = qc@description
        opts_qc@UnitLabel        = "g/kg"   
        opts_qc@PlotLevelID      = "Eta Level  " + display_level
        contour_qc     = wrf_contour(a,wks,qc_plane,opts_qc)
        print_opts("opts_qc",  opts_qc,  debug)
        wrf_map_overlay(wks,map,(/contour_qc/),False)
        print_header(icount,debug)
      end if

      if (isvar("qr"))
        qr_plane  = qr(level,:,:)
        qr_plane  = qr_plane*1000.
        opts_qr = res
        opts_qr@cnFillOn         = True
        opts_qr@gsnSpreadColors  = False
        opts_qr@FieldTitle       = qr@description
        opts_qr@UnitLabel        = "g/kg"   
        opts_qr@PlotLevelID      = "Eta Level  " + display_level
        contour_qr     = wrf_contour(a,wks,qr_plane,opts_qr)
        print_opts("opts_qr",  opts_qr,  debug)
        wrf_map_overlay(wks,map,(/contour_qr/),False)
        print_header(icount,debug)
      end if

      if (isvar("qi"))
        qi_plane  = qi(level,:,:)
        qi_plane  = qi_plane*1000.
        opts_qi = res
        opts_qi@cnFillOn         = True
        opts_qi@gsnSpreadColors  = False
        opts_qi@FieldTitle       = qi@description
        opts_qi@UnitLabel        = "g/kg"   
        opts_qi@PlotLevelID      = "Eta Level  " + display_level
        contour_qi     = wrf_contour(a,wks,qi_plane,opts_qi)
        print_opts("opts_qi",  opts_qi,  debug)
        wrf_map_overlay(wks,map,(/contour_qi/),False)
        print_header(icount,debug)
      end if

    end do      ; END OF 3D LOOP

; Delete options and fields, so we don't have carry over
if (isvar("qv"))
  delete(opts_qv)
  delete(qv_plane)
end if
if (isvar("qc"))
  delete(opts_qc)
  delete(qc_plane)
end if
if (isvar("qr"))
  delete(opts_qr)
  delete(qr_plane)
end if
if (isvar("qi"))
  delete(opts_qi)
  delete(qi_plane)
end if

  ;       ************************************************************

      times_sav = times(it)
      FirstTime = False
  end do  ;       end of the time loop

end
