
;   Script to produce standard plots for a WRF squall run

load "WRFOptions.ncl"
;load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "gsn_code.ncl"
load "WRFPlot.ncl"
load "WRFUserARW.ncl"

begin
;
; The WRF ARW input file.  
; This needs to have a ".nc" appended, so just do it.

  a = addfile("../WRFV2/run/wrfout_d01_0001-01-01_00:00:00.nc","r")

;  We generate plots, but what kind do we prefer?

   type = "x11"
;  type = "pdf"
;  type = "ps"
;  type = "ncgm"

  wks = gsn_open_wks(type,"wrf_squall2D_y")

; Debug information.

  debug  = False
;  debug  = True
  icount = 0

; Basic Plot options, including header information

    res@MainTitle                 = "WRF squall2D_y"     


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;  What times and how many time steps are in the data set?

  times  = wrf_user_list_times(a)  ; get times in the file
  ntimes = dimsizes(times)         ; number of times in the file

; The specific plane we want to plot data on

  plane = (/ 0., 20./)   ; (x,y) point for vertical plane
  angle = 0.0
  pii = 3.14159
  aspect_ratio = .7

; This is the big loop over all of the time periods to process.

  do it = 0,ntimes-1,4

    time = it
    res@TimeLabel                  = times(it)
    res@AspectRatio                = aspect_ratio
    res@PlotOrientation            = "(" + plane(0)+","+plane(1) + ")" + " angle " + angle


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; First get the variables we will need        

  qv  = wrf_user_getvar(a,"QVAPOR",time)    ; cloud field                    
  qv  = qv*1000.                            ; convert to g/kg
  qc  = wrf_user_getvar(a,"QCLOUD",time)    ; cloud field
  qc  = qc*1000.                            ; convert to g/kg
  qr  = wrf_user_getvar(a,"QRAIN",time)     ; cloud field
  qr  = qr*1000.                            ; convert to g/kg
  u   = wrf_user_getvar(a,"ua",time)        ; ua is u averaged to mass points
  v   = wrf_user_getvar(a,"va",time)        ; va is v averaged to mass points
  w  = wrf_user_getvar(a,"wa",time)         ; w field
  z   = wrf_user_getvar(a, "Z",time)        ; grid point height
  ter    = wrf_user_getvar(a,"HGT",time)    ; need terrain height sometimes

  qv_plane  = wrf_user_intrp3d(qv,z,ter,"v",plane,angle)
  qc_plane  = wrf_user_intrp3d(qc,z,ter,"v",plane,angle)
  qr_plane  = wrf_user_intrp3d(qr,z,ter,"v",plane,angle)
  u_plane   = wrf_user_intrp3d( u,z,ter,"v",plane,angle)
  v_plane   = wrf_user_intrp3d( v,z,ter,"v",plane,angle)
  w_plane   = wrf_user_intrp3d( w,z,ter,"v",plane,angle)

  vel_normal  = u_plane*cos(2.*pii*angle/360.) - v_plane*sin(2.*pii*angle/360.)
  vel_tangent = u_plane*sin(2.*pii*angle/360.) + v_plane*cos(2.*pii*angle/360.)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ; QVAPOR
      opts_qv  = res
      opts_qv@FieldTitle           = qv@description
      opts_qv@UnitLabel            = "g/kg"
      opts_qv@cnFillOn             = True
      opts_qv@gsnSpreadColorEnd    = -10   
      contour_qv     = wrf_contour(a,wks,qv_plane,opts_qv)
      print_opts("opts_qv",  opts_qv,  debug)

 ; QCLOUD
      opts_qc  = res
      opts_qc@FieldTitle           = qc@description
      opts_qc@UnitLabel            = "g/kg"
      opts_qc@cnFillOn             = True
      opts_qc@gsnSpreadColorEnd    = -10   
      contour_qc     = wrf_contour(a,wks,qc_plane,opts_qc)
      print_opts("opts_qc",  opts_qc,  debug)

 ; QRAIN
      opts_qr  = res
      opts_qr@FieldTitle           = qr@description
      opts_qr@UnitLabel            = "g/kg"
      contour_qr     = wrf_contour(a,wks,qr_plane,opts_qr)
      print_opts("opts_qr",  opts_qr,  debug)

 ; Vertical Velocity
      opts_w   = res
      opts_w@FieldTitle            = w@description
      opts_w@cnFillOn              = True
      opts_w@gsnSpreadColorEnd     = -10   
      contour_w = wrf_contour(a,wks, w_plane,opts_w)
      print_opts("opts_w",   opts_w,   debug)

 ; Vel Tangent
      opts_vt   = res
      opts_vt@FieldTitle           = "Plane-Tangent Velocity"
      opts_vt@UnitLabel            = "m/s"
      contour_vt     = wrf_contour(a,wks,vel_tangent,opts_vt)
      print_opts("opts_vt",  opts_vt,  debug)

      wrf_overlay(wks,(/contour_qc, contour_qr/),False)
      print_header(icount,debug)
      wrf_overlay(wks,(/contour_qv/),False)
      print_header(icount,debug)
      wrf_overlay(wks,(/contour_w, contour_vt/),False)
      print_header(icount,debug)

  ;       ************************************************************

  end do  ;       end of the time loop

end
