load "wrf_plot.ncl"
load "wrf_user_mass.ncl"

a = addfile("../../WRFV2/test/em_b_wave/wrfout_d01_0001-01-01_00:00:00.nc","r")

;wks = wrf_open_X11()                ; output to screen
wks = wrf_open_ncgm("wrf_plots")   ; output to ncgm
;wks = wrf_open_PS("wrf_plots")     ; output to postscript

;frame(wks)  ; allow for window resize before beginning plots

plot_map = False
if(isatt(a,"MAP_PROJ")) then
  imap = a@MAP_PROJ
  if(imap .ne. 0) then
    plot_map = True
  end if
end if

;  plot height field, temperature, and wind barbs on pressure surface
;  for all times in the input file

times = wrf_user_list_times(a)  ; get times in  the file
;height_levels = (/ 250., 1500., 4000., 9000., 13000., 16000. /)   ;
height_levels = (/ 250., 2000. /) 
ntimes = dimsizes(times)  ; number of times in the file
nlevels = dimsizes(height_levels)  ; number of pressure levels
plot_width = .3
plot_height = .6

do it = 0, ntimes-1
;do it = 8, ntimes-1

  time = it

  p   = wrf_user_getvar(a, "p",time) ; pressure 
  z   = wrf_user_getvar(a, "Z",time) ; grid point height
  th  = wrf_user_getvar(a,"th",time) ; get temperature (C)
  u   = wrf_user_getvar(a,"ua",time) ; ua is u averaged to mass points
  v   = wrf_user_getvar(a,"va",time) ; va is v averaged to mass points
  ter = wrf_user_getvar(a,"HGT",time) ; need terrain height sometimes
  w   = wrf_user_getvar(a, "wa",time) ; pressure 
  qv   = wrf_user_getvar(a, "QVAPOR",time) ; pressure 
  rain_resolved = wrf_user_getvar(a,"RAINNC",time)
  rain_param    = wrf_user_getvar(a,"RAINC",time)
  rain_tot      = rain_resolved+rain_param

  if(isfilevar(a,"QCLOUD"))
    qc =   wrf_user_getvar(a, "QCLOUD",time)  
  end if

  if(isfilevar(a,"QRAIN"))
    qr =   wrf_user_getvar(a, "QRAIN",time)  
  end if

  if(isfilevar(a,"QSNOW"))
    qs =   wrf_user_getvar(a, "QSNOW",time)  
  end if

  if(isfilevar(a,"QICE"))
    qi =   wrf_user_getvar(a, "QICE",time)  
  end if

  if(isfilevar(a,"QGRAUP"))
    qg =   wrf_user_getvar(a, "QGRAUP",time)  
  end if

  if(isfilevar(a,"TKE"))
    tke =   wrf_user_getvar(a, "TKE",time)  
  end if

  do level = 0,nlevels-1

    height = height_levels(level)
    p_plane  = wrf_user_intrp3d( p,z,ter,"h",height,0.)
    th_plane = wrf_user_intrp3d(th,z,ter,"h",height,0.)
    u_plane  = wrf_user_intrp3d( u,z,ter,"h",height,0.)
    v_plane  = wrf_user_intrp3d( v,z,ter,"h",height,0.)
    w_plane  = wrf_user_intrp3d( w,z,ter,"h",height,0.)
    qv_plane  = wrf_user_intrp3d( qv,z,ter,"h",height,0.)
    qv_plane = 1000.*qv_plane
    w_plane = 100.*w_plane

    if(isfilevar(a,"QCLOUD"))
      qc_plane  = wrf_user_intrp3d( qc,z,ter,"h",height,0.)
      qc_plane = 1000.*qc_plane
      opts_qc = True
      opts_qc@MainTitle = "QC(g/kg, color) and winds (m/s) "
      opts_qc@UnitLabel = "Cloud Water Mixing Ratio (g/kg)"
      opts_qc@TimeLabel = times(it) 
      opts_qc@LevelLabel = 0.001*height + " km"
      opts_qc@vpWidthF = plot_width
      opts_qc@vpHeightF = plot_height
    end if

    if(isfilevar(a,"QRAIN"))
      qr_plane  = wrf_user_intrp3d( qr,z,ter,"h",height,0.)
      qr_plane = 1000.*qr_plane
      opts_qr = True
      opts_qr@MainTitle = "QR(g/kg, color) and winds (m/s) "
      opts_qr@UnitLabel = "Rain Mixing Ratio (g/kg)"
      opts_qr@TimeLabel = times(it) 
      opts_qr@LevelLabel = 0.001*height + " km"
      opts_qr@vpWidthF = plot_width
      opts_qr@vpHeightF = plot_height
    end if

    if(isfilevar(a,"QSNOW"))
      qs_plane  = wrf_user_intrp3d( qs,z,ter,"h",height,0.)
      qs_plane = 1000.*qs_plane
      opts_qs = True
      opts_qs@MainTitle = "QS(g/kg, color) and winds (m/s) "
      opts_qs@UnitLabel = "Snow Mixing Ratio (g/kg)"
      opts_qs@TimeLabel = times(it) 
      opts_qs@LevelLabel = 0.001*height + " km"
      opts_qs@vpWidthF = plot_width
      opts_qs@vpHeightF = plot_height
    end if

    if(isfilevar(a,"QICE"))
      qi_plane  = wrf_user_intrp3d( qi,z,ter,"h",height,0.)
      qi_plane = 1000.*qi_plane
      opts_qi = True
      opts_qi@MainTitle = "QI(g/kg, color) and winds (m/s) "
      opts_qi@UnitLabel = "Ice Mixing Ratio (g/kg)"
      opts_qi@TimeLabel = times(it) 
      opts_qi@LevelLabel = 0.001*height + " km"
      opts_qi@vpWidthF = plot_width
      opts_qi@vpHeightF = plot_height
    end if

    if(isfilevar(a,"QGRAUP"))
      qg_plane  = wrf_user_intrp3d( qg,z,ter,"h",height,0.)
      opts_qg = True
      qg_plane = 1000.*qg_plane
      opts_qg@MainTitle = "QG(g/kg, color) and winds (m/s) "
      opts_qg@UnitLabel = "Graupel Mixing Ratio (g/kg)"
      opts_qg@TimeLabel = times(it) 
      opts_qg@LevelLabel = 0.001*height + " km"
      opts_qg@vpWidthF = plot_width
      opts_qg@vpHeightF = plot_height
    end if

    if(isfilevar(a,"TKE"))
      tke_plane  = wrf_user_intrp3d( tke,z,ter,"h",height,0.)
      opts_tke = True
      opts_tke@MainTitle = "TKE(m^2/s^2, color) and winds (m/s) "
      opts_tke@UnitLabel = "Turbulent Kinetic Energy (m^2/s^2)"
      opts_tke@TimeLabel = times(it) 
      opts_tke@LevelLabel = 0.001*height + " km"
      opts_tke@vpWidthF = plot_width
      opts_tke@vpHeightF = plot_height
    end if

    opts_th = True
    opts_th@MainTitle = "pressure (mb, lines), T(theta, color) and winds (m/s) "
    opts_th@UnitLabel = "Potential Temperature"
    opts_th@TimeLabel = times(it) 
    opts_th@LevelLabel = 0.001*height + " km"
    opts_th@vpWidthF = plot_width
    opts_th@vpHeightF = plot_height

    opts_w = True
    opts_w@MainTitle = "W(cm/s, color) and horizontal winds (m/s) "
    opts_w@UnitLabel = "Vertical Velocity (m/3)"
    opts_w@TimeLabel = times(it) 
    opts_w@LevelLabel = 0.001*height + " km"
    opts_w@vpWidthF = plot_width
    opts_w@vpHeightF = plot_height

    opts_qv = True
    opts_qv@MainTitle = "QV(g/kg, color) and winds (m/s) "
    opts_qv@UnitLabel = "Vapor Mixing Ratio (g/kg)"
    opts_qv@TimeLabel = times(it) 
    opts_qv@LevelLabel = 0.001*height + " km"
    opts_qv@vpWidthF = plot_width
    opts_qv@vpHeightF = plot_height

    opts_p = True
    opts_p@NoTitles = True
    opts_p@cnLineColor = "black"
    opts_p@cnInfoLabelOn = True

    opts = True
    opts@NumVectors = 15
    opts@NoTitles = True
;    opts@WindBarbsOn = True
;    opts@vcWindBarbColor = "red"





  opts_r = True
  opts_r@MainTitle = "Total Precip (color, mm)"
  opts_r@UnitLabel = "Rainfall (mm)"
; opts_r@lbTitleExtentF = .030
; opts_r@lbTitleJust = "BottomRight"
  opts_r@lbBottomMarginF = .5
;  opts_r@TimeLabel = times(it) + " = " + time_save + " + " + hours + "h"
  opts_r@TimeLabel = times(it)
  opts_r@LevelLabel = "WRF Forecast"
  opts_r@cnLevelSelectionMode = "ExplicitLevels"
  opts_r@cnLevels = (/ .1, .2, .4, .8, 1.6, 3.2, 6.4, 12.8, 25.6, 51.2/)
  opts_r@cnFillColors = (/"white","white","DarkOliveGreen1","DarkOliveGreen3", "chartreuse","chartreuse3","green","forest green","yellow","orange","red","violet"/)
  opts_r@cnConstFLabelOn = False
  opts_r@lbAutoManage = False
  opts_r@lbTitleFontHeightF = .02
  opts_r@lbLabelFontHeightF = .02
  opts_r@lbBottomMarginF = .4
  opts_r@vpWidthF = plot_width
  opts_r@vpHeightF = plot_height

  if (plot_map) then

;    opts_mp = False
    opts_mp = True
    opts_mp@mpGeophysicalLineThicknessF = 0.5
    opts_mp@mpGeophysicalLineColor = "gray"
    opts_mp@mpUSStateLineThicknessF = 0.5
    opts_mp@mpUSStateLineColor = "gray"
    opts_mp@mpNationalLineThicknessF = 0.5
    opts_mp@mpNationalLineColor = "gray"
    opts_mp@mpGridLineThicknessF = 0.5
    opts_mp@mpGridLineColor = "gray"
    opts_mp@mpLimbLineThicknessF = 0.5
    opts_mp@mpLimbLineColor = "gray"
    opts_mp@mpPerimLineThicknessF = 0.5
    opts_mp@mpPerimLineColor = "gray"

    map = wrf_new_map(wks,a,opts_mp)


    opts_map = True
    opts_map@LabelFont = "HELVETICA-BOLD"
    opts_map@LabelFontHeight = .01
    wrf_maplabel(wks,map,opts_map)

    if( (it .eq. 0) .and. (level .eq. 0)) then
      contour_th       = wrf_new_fill_contour(wks,th_plane,opts_th)
      contour_pressure = wrf_new_line_contour(wks, p_plane,opts_p)
      vector           = wrf_new_vector(wks,u_plane, v_plane,opts)
    else
      wrf_update_contour_data(wks, contour_th, th_plane, opts_th)
      wrf_update_contour_data(wks, contour_pressure, p_plane, opts_p)
      wrf_update_vector_data(wks,vector,u_plane, v_plane, opts )
    end if

    wrf_mapoverlay(map,contour_th)
    wrf_mapoverlay(map,contour_pressure)
    wrf_mapoverlay(map,vector)
    draw(map)
    frame(wks)

    NhlRemoveOverlay(map,vector,False) 
    NhlRemoveOverlay(map,contour_pressure,False) 
    NhlRemoveOverlay(map,contour_th,False) 
    wrf_mapoverlay(map,contour_w)
    wrf_mapoverlay(map,vector)
    draw(map)
    frame(wks)



  else

    contour_th = wrf_new_fill_contour(wks, th_plane,opts_th)
    contour_pressure = wrf_new_line_contour(wks, p_plane,opts_p)
    vector           = wrf_new_vector(wks,u_plane, v_plane,opts)
    overlay(contour_th, contour_pressure)
    overlay(contour_th, vector)
    draw(contour_th)
    frame(wks)
    NhlRemoveOverlay(contour_th,vector,False) 

    contour_w = wrf_new_fill_contour(wks, w_plane,opts_w)
    overlay(contour_w, vector)
    draw(contour_w)
    frame(wks)
    NhlRemoveOverlay(contour_w,vector,False) 

    if(isvar("tke")) then
      contour_tke = wrf_new_fill_contour(wks, tke_plane,opts_tke)
      overlay(contour_tke, vector)
      draw(contour_tke)
      frame(wks)
      NhlRemoveOverlay(contour_tke,vector,False) 
    end if

    contour_qv = wrf_new_fill_contour(wks, qv_plane,opts_qv)
    overlay(contour_qv, vector)
    draw(contour_qv)
    frame(wks)
    NhlRemoveOverlay(contour_qv,vector,False) 

    if(level .eq. 0) then

    contour_tot  = wrf_new_fill_contour(wks, rain_param,opts_r)
    overlay(contour_tot, vector)
    draw(contour_tot)
    frame(wks)
    NhlRemoveOverlay(contour_tot,vector,False) 

    end if

    
    if(isvar("qc")) then
      contour_qc = wrf_new_fill_contour(wks, qc_plane,opts_qc)
      overlay(contour_qc, vector)
      draw(contour_qc)
      frame(wks)
      NhlRemoveOverlay(contour_qc,vector,False) 
    end if

    if(isvar("qr")) then
      contour_qr = wrf_new_fill_contour(wks, qr_plane,opts_qr)
      overlay(contour_qr, vector)
      draw(contour_qr)
      frame(wks)
      NhlRemoveOverlay(contour_qr,vector,False) 
    end if

    if(isvar("qi")) then
      contour_qi = wrf_new_fill_contour(wks, qi_plane,opts_qi)
      overlay(contour_qi, vector)
      draw(contour_qi)
      frame(wks)
      NhlRemoveOverlay(contour_qi,vector,False) 
    end if

    if(isvar("qs")) then
      contour_qs = wrf_new_fill_contour(wks, qs_plane,opts_qs)
      overlay(contour_qs, vector)
      draw(contour_qs)
      frame(wks)
      NhlRemoveOverlay(contour_qs,vector,False) 
    end if

    if(isvar("qg")) then
      contour_qg = wrf_new_fill_contour(wks, qg_plane,opts_qg)
      overlay(contour_qg, vector)
      draw(contour_qg)
      frame(wks)
      NhlRemoveOverlay(contour_qg,vector,False) 
    end if

  end if

  end do
end do





