load "wrf_plot.ncl"
load "wrf_user_mass.ncl"

a = addfile("../../WRFV2/test/em_hill2d_x/wrfout_d01_0001-01-01_00:00:00.nc","r")
;wks = wrf_open_X11()                ; output to screen
wks = wrf_open_ncgm("wrf_plots")   ; output to ncgm
;wks = wrf_open_PS("wrf_plots")     ; output to postscript

;frame(wks)  ; allow for window resize before beginning plots

;  plot height field, temperature, and wind barbs on pressure surface
;  for all times in the input file

times = wrf_user_list_times(a)  ; get times in  the file
ntimes = dimsizes(times)  ; number of times in the file
plane = (/ 20., 0./)  ; (x,y) point for vert plane
angle = 90.
pii = 3.14159
aspect_ratio = .7

do it = 0, ntimes-1


  print(" plot for time "+times(it))  

  time=it
  z_in   = wrf_user_getvar(a, "Z",time) ; grid point height
  u_in   = wrf_user_getvar(a,"ua",time) ; ua is u averaged to mass points
  v_in   = wrf_user_getvar(a,"va",time) ; va is v averaged to mass points
  ter_in = wrf_user_getvar(a,"HGT",time) ; need terrain height sometimes
  th_in  = wrf_user_getvar(a,"th",time) ; theta field
  w_in  = wrf_user_getvar(a,"wa",time) ; w field

;  z = z_in(0:34,:,51:151)
;  u = u_in(0:34,:,51:151)
;  v = v_in(0:34,:,51:151)
;  ter = ter_in(:,51:151)
;  th = th_in(0:34,:,51:151)
;  w = w_in(0:34,:,51:151)
;
  z = z_in(0:34,:,:)
  u = u_in(0:34,:,:)
  v = v_in(0:34,:,:)
  ter = ter_in(:,:)
  th = th_in(0:34,:,:)
  w = w_in(0:34,:,:)

    th_plane = wrf_user_intrp3d(th,z,ter,"v",plane,angle)
    w_plane = wrf_user_intrp3d( w,z,ter,"v",plane,angle)
    u_plane  = wrf_user_intrp3d( u,z,ter,"v",plane,angle)
    v_plane  = wrf_user_intrp3d( v,z,ter,"v",plane,angle)


    opts_u = True
;    opts_u@NoTitles = True
    opts_u@MainTitle = "w and plane-normal velocity (m/s)"
    opts_u@AspectRatio = aspect_ratio
    opts_u@TimeLabel = ""

    opts_th = True
    opts_th@AspectRatio = aspect_ratio
    opts_th@MainTitle = "theta and perturbation u (m/s)"
    opts_th@UnitLabel = "T(K)"
    opts_th@TimeLabel = times(it) 
    opts_th@LevelLabel = "(" + plane(0)+","+plane(1) + ")" + " angle " + angle
    opts_th@AspectRatio = aspect_ratio

    opts_w = True
    opts_w@AspectRatio = aspect_ratio
    opts_w@MainTitle = ""
    opts_w@TimeLabel = ""

    opts_t = opts_u
    opts_t@MainTitle = ""
    opts_t@AspectRatio = aspect_ratio
    opts_t@TimeLabel = ""

    vel_normal  = u_plane*cos(2.*pii*angle/360.) - v_plane*sin(2.*pii*angle/360.)
    vel_tangent = u_plane*sin(2.*pii*angle/360.) + v_plane*cos(2.*pii*angle/360.)
    vel_tangent = vel_tangent - 10.

        contour_th = wrf_new_fill_contour(wks, th_plane,opts_th)
        contour_w = wrf_new_line_contour(wks, w_plane,opts_w)
        contour_vt = wrf_new_line_contour(wks,vel_tangent,opts_t)

    overlay(contour_th,contour_vt)
    draw(contour_th)
    frame(wks)
    delete(contour_th)

    opts_th@MainTitle = "theta and  w (m/s)"
    contour_th = wrf_new_fill_contour(wks, th_plane,opts_th)

    overlay(contour_th,contour_w)
    draw(contour_th)
    frame(wks)
    delete(contour_th)
    delete(contour_vt)
    delete(contour_w)

end do
