;
;	Script to produce standard plots for a WRF real-data run,
;	with the MASS coordinate dynamics option.
;       
;       This script plots cloud water on selected model levels.

load "wrf_plot.ncl"
load "wrf_user_mass.ncl"
load "gsn_code.ncl"
load "skewt_func.ncl"

;	The WRF MASS input file.  Don't remove ".nc" below.

a = addfile("../../WRFV2/real/wrfout_d01_2000-01-24_12:00:00.nc","r")

;	We generate plots, but what kind do we prefer?

wks = wrf_open_ncgm("wrf_qc")   ; output to ncgm
;wks = wrf_open_X11()                ; output to screen
;wks = wrf_open_PS("wrf_plots")     ; output to postscript

;	What times and how many times are in the data set?

times = wrf_user_list_times(a)  ; get times in  the file
ntimes = dimsizes(times)  ; number of times in the file

;	The specific pressure levels that we want the data
;	interpolated to.

pressure_levels = (/ 850., 700., 500., 300./)   ; pressure levels to plot
nlevels = dimsizes(pressure_levels)  ; number of pressure levels
raster = True

;	This is the big loop over all of the time periods to process.

do it = 1, ntimes-1
;do it = 0, 4
	time = it
;if (it.eq.0) then
		time_save = times(0)
;end if
	hours = it*3.

	;	3) 3d plots: height, rh, vert vel, temp

        ter = wrf_user_getvar(a,"HGT",time) ; need terrain height sometimes

      if(isfilevar(a,"QCLOUD"))
        qc= wrf_user_getvar(a, "QCLOUD",time)
      end if
      if(isfilevar(a,"QICE"))
        qi= wrf_user_getvar(a, "QICE",time)
      end if

	;	Loop over the selected pressure levels to plot

	;do level = 0,nlevels-1
	do level = 0,20,2

              if(isfilevar(a,"QCLOUD"))
		qc_plane  = qc(level,:,:)
                qc_plane = qc_plane*1000.
		opts_qc = True
		opts_qc@MainTitle = "eta level " + level + " cloud water (g/kg) "
		opts_qc@TimeLabel = times(it) + " = " + time_save + " + " + hours + " h"
		opts_qc@LevelLabel = "WRF MASS"
	        ;opts_qc@cnLevelSelectionMode = "ExplicitLevels"
        	opts_qc@cnLevels = (/ 0., 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0 /)
        	opts_qc@cnFillColors = (/"white","white","DarkOliveGreen1","DarkOliveGreen3","chartreuse","chartreuse3","green","forest green","yellow","orange","red","violet"/)
		;opts_qc@ContourParameters = (/ 0.1 /)
		;opts_qc@cnRasterModeOn = raster
              end if
		
              if(isfilevar(a,"QICE"))
		qi_plane  = qi(level,:,:)
                qi_plane = qi_plane*1000.
		opts_qi = True
		opts_qi@MainTitle = "eta level " + level + " cloud ice (g/kg) "
		opts_qi@TimeLabel = times(it) + " = " + time_save + " + " + hours + " h"
		opts_qi@LevelLabel = "WRF MASS"
	        ;opts_qi@cnLevelSelectionMode = "ExplicitLevels"
        	opts_qc@cnLevels = (/ 0., 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0 /)
        	opts_qi@cnFillColors = (/"white","white","DarkOliveGreen1","DarkOliveGreen3","chartreuse","chartreuse3","green","forest green","yellow","orange","red","violet"/)
		;opts_qi@ContourParameters = (/ 0.1 /)
		;opts_qi@cnRasterModeOn = raster
              end if
		
		;	Plotting options for the map background

		opts_mp = True
		opts_mp@mpGeophysicalLineThicknessF = 0.5
		opts_mp@mpGeophysicalLineColor = "gray"
		opts_mp@mpUSStateLineThicknessF = 0.5
		opts_mp@mpUSStateLineColor = "gray"
		opts_mp@mpNationalLineThicknessF = 0.5
		opts_mp@mpNationalLineColor = "gray"
		opts_mp@mpGridLineThicknessF = 0.5
		opts_mp@mpGridLineColor = "gray"
		opts_mp@mpLimbLineThicknessF = 0.5
		opts_mp@mpLimbLineColor = "gray"
		opts_mp@mpPerimLineThicknessF = 0.5
		opts_mp@mpPerimLineColor = "gray"
		
		map = wrf_new_map(wks,a,opts_mp)
		
		opts_map = True
		opts_map@LabelFont = "HELVETICA-BOLD"
		opts_map@LabelFontHeight = .01
		wrf_maplabel(wks,map,opts_map)
		
              if(isvar("qc")) then
		contour_qc     = wrf_new_fill_contour(wks,qc_plane,opts_qc)
		wrf_mapoverlay(map,contour_qc)
		draw(map)
		frame(wks)
		NhlRemoveOverlay(map,contour_qc,False)
	        delete(opts_qc)
	        delete(qc_plane)
              end if

              if(isvar("qi")) then
		contour_qi     = wrf_new_fill_contour(wks,qi_plane,opts_qi)
		wrf_mapoverlay(map,contour_qi)
		draw(map)
		frame(wks)
		NhlRemoveOverlay(map,contour_qi,False)
	        delete(opts_qi)
	        delete(qi_plane)
              end if

	end do	;	end of the pressure level loop
	
	;	remove the dummy arrays


end do 	;	end of the time loop
