;
;  script to produce standard plots for a wrf real-data run
;

load "wrf_plot.ncl"
load "wrf_user_mass.ncl"
load "gsn_code.ncl"
load "skewt_func.ncl"

a = addfile("../../WRFV2/test/em_quarter_ss/wrfout_d01_0001-01-01_00:00:00.nc","r")

;wks = wrf_open_X11()                ; output to screen
wks = wrf_open_ncgm("wrf_qss")   ; output to ncgm
;wks = wrf_open_PS("wrf_plots")     ; output to postscript

;frame(wks)  ; allow for window resize before beginning plots

; 

times = wrf_user_list_times(a)  ; get times in  the file
ntimes = dimsizes(times)  ; number of times in the file
;height_levels = (/ 750., 1500., 4000., 9000., 13000., 16000. /)   ; height levels to plot
height_levels = (/ 750., 1500., 4000., 9000. /)   ; height levels to plot
nlevels = dimsizes(height_levels)  ; number of pressure levels

do it = 0, ntimes-1

  print(" plot for time "+times(it))  

  time = it

  p   = wrf_user_getvar(a, "p",time) ; pressure 
  z   = wrf_user_getvar(a, "Z",time) ; grid point height
  th  = wrf_user_getvar(a,"th",time) ; get temperature (C)
  u   = wrf_user_getvar(a,"ua",time) ; ua is u averaged to mass points
  v   = wrf_user_getvar(a,"va",time) ; va is v averaged to mass points
  ter = wrf_user_getvar(a,"HGT",time) ; need terrain height sometimes
  w   = wrf_user_getvar(a, "wa",time) ; pressure 
  qv   = wrf_user_getvar(a, "QVAPOR",time) ; pressure 

  if(isfilevar(a,"QCLOUD"))
    qc =   wrf_user_getvar(a, "QCLOUD",time)  
  end if

  if(isfilevar(a,"QRAIN"))
    qr =   wrf_user_getvar(a, "QRAIN",time)  
  end if

  if(isfilevar(a,"QSNOW"))
    qs =   wrf_user_getvar(a, "QSNOW",time)  
  end if

  if(isfilevar(a,"QICE"))
    qi =   wrf_user_getvar(a, "QICE",time)  
  end if

  if(isfilevar(a,"QGRAUP"))
    qg =   wrf_user_getvar(a, "QGRAUP",time)  
  end if

  do level = 0, nlevels-1

  print(" plot for level "+level)  
    height = height_levels(level)
    p_plane  = wrf_user_intrp3d( p,z,ter,"h",height,0.)
    th_plane = wrf_user_intrp3d(th,z,ter,"h",height,0.)
    u_plane  = wrf_user_intrp3d( u,z,ter,"h",height,0.)
    v_plane  = wrf_user_intrp3d( v,z,ter,"h",height,0.)
    w_plane  = wrf_user_intrp3d( w,z,ter,"h",height,0.)
    qv_plane  = wrf_user_intrp3d( qv,z,ter,"h",height,0.)
    qv_plane = 1000.*qv_plane
print("max(qv_plane)="+max(qv_plane))
print("min(qv_plane)="+min(qv_plane))

    if(isfilevar(a,"QCLOUD"))
      qc_plane  = wrf_user_intrp3d( qc,z,ter,"h",height,0.)
      qc_plane = 1000.*qc_plane
      opts_qc = True
      opts_qc@MainTitle = "QC(g/kg, color) and winds (m/s) "
      opts_qc@UnitLabel = "Cloud Water Mixing Ratio (g/kg)"
      opts_qc@TimeLabel = times(it) 
      opts_qc@LevelLabel = 0.001*height + " km"
      opts_qc@vpWidthF = .6
      opts_qc@vpHeightF = .6
    end if

    if(isfilevar(a,"QRAIN"))
      qr_plane  = wrf_user_intrp3d( qr,z,ter,"h",height,0.)
      qr_plane = 1000.*qr_plane
      opts_qr = True
      opts_qr@MainTitle = "QR(g/kg, color) and winds (m/s) "
      opts_qr@UnitLabel = "Rain Mixing Ratio (g/kg)"
      opts_qr@TimeLabel = times(it) 
      opts_qr@LevelLabel = 0.001*height + " km"
      opts_qr@vpWidthF = .6
      opts_qr@vpHeightF = .6
    end if

    if(isfilevar(a,"QSNOW"))
      qs_plane  = wrf_user_intrp3d( qs,z,ter,"h",height,0.)
      qs_plane = 1000.*qs_plane
      opts_qs = True
      opts_qs@MainTitle = "QS(g/kg, color) and winds (m/s) "
      opts_qs@UnitLabel = "Snow Mixing Ratio (g/kg)"
      opts_qs@TimeLabel = times(it) 
      opts_qs@LevelLabel = 0.001*height + " km"
      opts_qs@vpWidthF = .6
      opts_qs@vpHeightF = .6
    end if

    if(isfilevar(a,"QICE"))
      qi_plane  = wrf_user_intrp3d( qi,z,ter,"h",height,0.)
      qi_plane = 1000.*qi_plane
      opts_qi = True
      opts_qi@MainTitle = "QI(g/kg, color) and winds (m/s) "
      opts_qi@UnitLabel = "Ice Mixing Ratio (g/kg)"
      opts_qi@TimeLabel = times(it) 
      opts_qi@LevelLabel = 0.001*height + " km"
      opts_qi@vpWidthF = .6
      opts_qi@vpHeightF = .6
    end if

    if(isfilevar(a,"QGRAUP"))
      qg_plane  = wrf_user_intrp3d( qg,z,ter,"h",height,0.)
      opts_qg = True
      qg_plane = 1000.*qg_plane
      opts_qg@MainTitle = "QG(g/kg, color) and winds (m/s) "
      opts_qg@UnitLabel = "Graupel Mixing Ratio (g/kg)"
      opts_qg@TimeLabel = times(it) 
      opts_qg@LevelLabel = 0.001*height + " km"
      opts_qg@vpWidthF = .6
      opts_qg@vpHeightF = .6
    end if

    opts_th = True
    opts_th@MainTitle = "pressure (mb, lines), T(theta, color) and winds (m/s) "
    opts_th@UnitLabel = "Potential Temperature"
    opts_th@TimeLabel = times(it) 
    opts_th@LevelLabel = 0.001*height + " km"
    opts_th@vpWidthF = .6
    opts_th@vpHeightF = .6

    opts_w = True
    opts_w@MainTitle = "W(m/w, color) and horizontal winds (m/s) "
    opts_w@UnitLabel = "Vertical Velocity (m/3)"
    opts_w@TimeLabel = times(it) 
    opts_w@LevelLabel = 0.001*height + " km"
    opts_w@vpWidthF = .6
    opts_w@vpHeightF = .6

    opts_qv = True
    opts_qv@MainTitle = "QV(g/kg, color) and winds (m/s) "
    opts_qv@UnitLabel = "Vapor Mixing Ratio (g/kg)"
    opts_qv@TimeLabel = times(it) 
    opts_qv@LevelLabel = 0.001*height + " km"
    opts_qv@vpWidthF = .6
    opts_qv@vpHeightF = .6

    opts_p = True
    opts_p@NoTitles = True
    opts_p@cnLineColor = "black"
    opts_p@cnInfoLabelOn = True

    opts = True
    opts@NumVectors = 15
    opts@NoTitles = True
;    opts@WindBarbsOn = True
;    opts@vcWindBarbColor = "red"

; plotting

    contour_th = wrf_new_fill_contour(wks, th_plane,opts_th)
    contour_pressure = wrf_new_line_contour(wks, p_plane,opts_p)
    vector           = wrf_new_vector(wks,u_plane, v_plane,opts)
    overlay(contour_th, contour_pressure)
    overlay(contour_th, vector)
    draw(contour_th)
    frame(wks)
    NhlRemoveOverlay(contour_th,vector,False) 

    contour_w = wrf_new_fill_contour(wks, w_plane,opts_w)
    overlay(contour_w, vector)
    draw(contour_w)
    frame(wks)
    NhlRemoveOverlay(contour_w,vector,False) 

    contour_qv = wrf_new_fill_contour(wks, qv_plane,opts_qv)
    overlay(contour_qv, vector)
    draw(contour_qv)
    frame(wks)
    NhlRemoveOverlay(contour_qv,vector,False) 

    
    if(isvar("qc")) then
      contour_qc = wrf_new_fill_contour(wks, qc_plane,opts_qc)
      overlay(contour_qc, vector)
      draw(contour_qc)
      frame(wks)
      NhlRemoveOverlay(contour_qc,vector,False) 
    end if

    if(isvar("qr")) then
      contour_qr = wrf_new_fill_contour(wks, qr_plane,opts_qr)
      overlay(contour_qr, vector)
      draw(contour_qr)
      frame(wks)
      NhlRemoveOverlay(contour_qr,vector,False) 
    end if

    if(isvar("qi")) then
      contour_qi = wrf_new_fill_contour(wks, qi_plane,opts_qi)
      overlay(contour_qi, vector)
      draw(contour_qi)
      frame(wks)
      NhlRemoveOverlay(contour_qi,vector,False) 
    end if

    if(isvar("qs")) then
      contour_qs = wrf_new_fill_contour(wks, qs_plane,opts_qs)
      overlay(contour_qs, vector)
      draw(contour_qs)
      frame(wks)
      NhlRemoveOverlay(contour_qs,vector,False) 
    end if

    if(isvar("qg")) then
      contour_qg = wrf_new_fill_contour(wks, qg_plane,opts_qg)
      overlay(contour_qg, vector)
      draw(contour_qg)
      frame(wks)
      NhlRemoveOverlay(contour_qg,vector,False) 
    end if

end do

end do
