;
;	Script to produce standard plots for a WRF real-data output,
;	with the MASS coordinate dynamics option.
;
;       This script plots water vapor on selected model levels.

load "wrf_plot.ncl"
load "wrf_user_mass.ncl"
load "gsn_code.ncl"
load "skewt_func.ncl"

;	The WRF MASS input file.  Do not remove ".nc" below.

a = addfile("../../WRFV2/real/wrfout_d01_2000-01-24_12:00:00.nc","r")

;	We generate plots, but what kind do we prefer?

wks = wrf_open_ncgm("wrf_qv")   ; output to ncgm
;wks = wrf_open_X11()                ; output to screen
;wks = wrf_open_PS("wrf_plots")     ; output to postscript

;	What times and how many times are in the data set?

times = wrf_user_list_times(a)  ; get times in  the file
ntimes = dimsizes(times)  ; number of times in the file

;	The specific pressure levels that we want the data
;	interpolated to.

raster = True

;	This is the big loop over all of the time periods to process.

do it = 0, ntimes-1
;do it = 0, 0
	time = it
	if (it.eq.0) then
		time_save = times(it)
	end if
	hours = it*3. ; if output is every 3 hours

	;	3) 3d plots: height, rh, vert vel, temp

        ter = wrf_user_getvar(a,"HGT",time) ; need terrain height sometimes

        qv = wrf_user_getvar(a, "QVAPOR",time)

	;	Loop over the selected model levels to plot

	do level = 0,10,2

		qv_plane  = qv(level,:,:)
                qv_plane = qv_plane*1000.
		opts_qv = True
		opts_qv@MainTitle = "eta " + level + " water vapor (g/kg) "
		opts_qv@TimeLabel = times(it) + " = " + time_save + " + " + hours + " h"
		opts_qv@LevelLabel = "WRF MASS"
	        ;opts_qv@cnLevelSelectionMode = "ExplicitLevels"
        	;opts_qv@cnLevels = (/ 0., 5., 10., 20., 30., 40., 50., 75., 100., 150., 200./)
        	;opts_qv@cnFillColors = (/"white","white","DarkOliveGreen1","DarkOliveGreen3","chartreuse","chartreuse3","green","forest green","yellow","orange","red","violet"/)
		opts_qv@ContourParameters = (/ .4 /)
		;opts_qv@cnRasterModeOn = raster
		
		;	Plotting options for the map background

		opts_mp = True
		opts_mp@mpGeophysicalLineThicknessF = 0.5
		opts_mp@mpGeophysicalLineColor = "gray"
		opts_mp@mpUSStateLineThicknessF = 0.5
		opts_mp@mpUSStateLineColor = "gray"
		opts_mp@mpNationalLineThicknessF = 0.5
		opts_mp@mpNationalLineColor = "gray"
		opts_mp@mpGridLineThicknessF = 0.5
		opts_mp@mpGridLineColor = "gray"
		opts_mp@mpLimbLineThicknessF = 0.5
		opts_mp@mpLimbLineColor = "gray"
		opts_mp@mpPerimLineThicknessF = 0.5
		opts_mp@mpPerimLineColor = "gray"
		
		map = wrf_new_map(wks,a,opts_mp)
		
		opts_map = True
		opts_map@LabelFont = "HELVETICA-BOLD"
		opts_map@LabelFontHeight = .01
		wrf_maplabel(wks,map,opts_map)
		
		contour_qv     = wrf_new_line_contour(wks,qv_plane,opts_qv)

		;	Same logic as for contour levels, given the level that we are
		;	processing, we overlay the map with what fields.
		
		wrf_mapoverlay(map,contour_qv)
		draw(map)
		frame(wks)
		NhlRemoveOverlay(map,contour_qv,False)

	end do	;	end of the pressure level loop
	
	;	remove the dummy arrays

	delete(opts_qv)
	delete(qv_plane)

end do 	;	end of the time loop
