;
;	Script to produce non-diagnostic plots from wrfinput file
;

load "wrf_plot.ncl"
load "wrf_user_mass.ncl"
load "gsn_code.ncl"

;	The WRF MASS input file.  Do not remove ".nc" in
;	the following line

a = addfile("../../WRFV2/wrf_real_input_em.d01.2000-01-24_12:00:00.nc","r")
;a = addfile("../../WRFV2/real/wrfinput_d01.nc","r")

;	We generate plots, but what kind do we prefer?

wks = wrf_open_ncgm("wrf_input")   ; output to ncgm
;wks = wrf_open_X11()                ; output to screen
;wks = wrf_open_PS("wrf_plots")     ; output to postscript

;frame(wks)  ; allow for window resize before beginning plots

;	What times and how many times are in the data set?

times = wrf_user_list_times(a)  ; get times in  the file
ntimes = dimsizes(times)  ; number of times in the file
raster = True

;	This is the big loop over all of the time periods to process.

do it = 0, ntimes-1

	time = it

	; 	************************************************************

	;	1) mu (analogous to Pstar), sfc temp, sfc wind barbs

	;	mu = mub + mu (in pascal, convert to mb)

        if(isfilevar(a,"MU"))
          if(isfilevar(a,"MUB"))
	    mub = wrf_user_getvar(a,"MUB",time)
	    mup = wrf_user_getvar(a,"MU",time)
	    mu = (mub + mup)*0.01
          end if
        end if

	;	surface temp

	tsk = wrf_user_getvar(a,"TSK",time)

	;	Get u and v, put them in knots, again typical of a surface chart.

	u   = wrf_user_getvar(a,"ua",time) ; ua is u averaged to mass points
	v   = wrf_user_getvar(a,"va",time) ; va is v averaged to mass points
	u_plane = u(0,:,:)*1.94386
	v_plane = v(0,:,:)*1.94386

	;	Plotting options for the mu

	opts_mu = True
	opts_mu@MainTitle = "MU"
	opts_mu@UnitLabel = "mu(mb)"
	opts_mu@TimeLabel = times(it)
	opts_mu@LevelLabel = "WRF MASS Input"
	opts_mu@ContourParameters = (/ 5. /);
	opts_mu@LineThickness = 2.0
	opts_mu@cnInfoLabelOn = True
	opts_mu@cnLineLabelsOn = True
	opts_mu@lbAutoManage = False
	opts_mu@lbBottomMarginF = .4
	opts_mu@lbTitleFontHeightF = .02
	opts_mu@lbLabelFontHeightF = .02

	;	Plotting options for the temperature.

	opts_tc = True
	opts_tc@MainTitle = "Surface Theta (K, color) and winds (kts)"
	opts_tc@UnitLabel = "T(K)"
	opts_tc@TimeLabel = times(it)
	opts_tc@LevelLabel = "WRF MASS Input"
	opts_tc@ContourParameters = (/ 5. /);
	opts_tc@cnInfoLabelOn = True
	opts_tc@cnLineLabelsOn = True
	opts_tc@lbAutoManage = False
	opts_tc@lbBottomMarginF = .4
	opts_tc@lbTitleFontHeightF = .02
	opts_tc@lbLabelFontHeightF = .02

	opts_tc2 = True
	opts_tc2@NoTitles = True
	opts_tc2@ContourParameters = (/ 5. /);
	opts_tc2@LineThickness = 1.0
	opts_tc2@cnInfoLabelOn = True
	opts_tc2@cnLineLabelsOn = False
	opts_tc2@lbAutoManage = False

	;	Plotting options for the overlayed wind vectors.

	opts_vct = True
	opts_vct@NumVectors = 47
	opts_vct@WindBarbsOn = True
	opts_vct@NoTitles = True
	opts_vct@vcWindBarbColor = "black"
	opts_vct@vcRefAnnoOn = False

	;	Map options

;	opts_mp = False
	opts_mp = True
	opts_mp@mpGeophysicalLineThicknessF = 0.5
	opts_mp@mpGeophysicalLineColor = "gray"
	opts_mp@mpUSStateLineThicknessF = 0.5
	opts_mp@mpUSStateLineColor = "gray"
	opts_mp@mpNationalLineThicknessF = 0.5
	opts_mp@mpNationalLineColor = "gray"
	opts_mp@mpGridLineThicknessF = 0.5
	opts_mp@mpGridLineColor = "gray"
	opts_mp@mpLimbLineThicknessF = 0.5
	opts_mp@mpLimbLineColor = "gray"
	opts_mp@mpPerimOn = True
	opts_mp@mpPerimLineThicknessF = 1.0
	opts_mp@mpPerimLineColor = "gray"
	opts_mp@mpGridSpacingF = 10
	opts_mp@mpGridMaskMode = 3

	map = wrf_new_map(wks,a,opts_mp)

	;	... and yet more map options galore!

	opts_map = True
	opts_map@LabelFont = "HELVETICA-BOLD"
	opts_map@LabelFontHeight = .01
	wrf_maplabel(wks,map,opts_map)

	;	plot mu

        if(isvar("mu")) then
  	  contour_mu     = wrf_new_line_contour(wks,mu,opts_mu)
	  wrf_mapoverlay(map,contour_mu)
	  draw(map)
	  frame(wks)
          NhlRemoveOverlay(map,contour_mu,False)
        end if

	;	Now that we have temp, and wind values,
	;	we can overlay them to make a plot.

	contour_tc     = wrf_new_fill_contour(wks,tsk,opts_tc)
	contour_tc2    = wrf_new_line_contour(wks,tsk,opts_tc2)
	vector         = wrf_new_vector(wks,u_plane, v_plane,opts_vct)

	wrf_mapoverlay(map,contour_tc)
	wrf_mapoverlay(map,contour_tc2)
	wrf_mapoverlay(map,vector)
	draw(map)
	frame(wks)
        NhlRemoveOverlay(map,contour_tc,False)
        NhlRemoveOverlay(map,contour_tc2,False)
        NhlRemoveOverlay(map,vector,False)

        if(isvar("mu")) then
          delete(contour_mu)
        end if
        delete(contour_tc)
        delete(contour_tc2)
        delete(vector)

	; 	************************************************************

	;	2) other 2D fields

	;	Terrain elevation

	ter = wrf_user_getvar(a,"HGT",time)

	;	Plotting options for terrain

	opts_ter = True
	opts_ter@MainTitle = "TERRAIN (m)"
	opts_ter@UnitLabel = "ht(m)"
	opts_ter@TimeLabel = times(it)
	opts_ter@LevelLabel = "WRF MASS Input"
	opts_ter@ContourParameters = (/ 100. /);
	opts_ter@LineThickness = 1.0
	opts_ter@cnInfoLabelOn = False
	opts_ter@cnLineLabelsOn = True
	opts_ter@lbAutoManage = False
	opts_ter@lbBottomMarginF = .4
	opts_ter@lbTitleFontHeightF = .02
	opts_ter@lbLabelFontHeightF = .02

	;	Plot it

	contour_ter = wrf_new_line_contour(wks,ter,opts_ter)
	wrf_mapoverlay(map,contour_ter)
	draw(map)
	frame(wks)
        NhlRemoveOverlay(map,contour_ter,False)

	;	Landuse

        if(isfilevar(a,"LU_INDEX"))
	  land = wrf_user_getvar(a,"LU_INDEX",time)

	;	Plotting options for landuse

	  opts_ln = True
	  opts_ln@MainTitle = "LANDUSE (category)"
	  opts_ln@UnitLabel = "landuse(category)"
	  opts_ln@TimeLabel = times(it)
	  opts_ln@LevelLabel = "WRF MASS Input"
	  opts_ln@ContourParameters = (/ 1. /);
	  opts_ln@LineThickness = 1.0
	  opts_ln@cnInfoLabelOn = False
	  opts_ln@cnLineLabelsOn = False
	  opts_ln@lbAutoManage = False
	  opts_ln@lbBottomMarginF = .4
	  opts_ln@lbTitleFontHeightF = .02
	  opts_ln@lbLabelFontHeightF = .02
          opts_ln@cnRasterModeOn = raster

	;	Plot it

	  contour_ln = wrf_new_fill_contour(wks,land,opts_ln)
	  wrf_mapoverlay(map,contour_ln)
	  draw(map)
	  frame(wks)
          NhlRemoveOverlay(map,contour_ln,False)
        end if

	;	Soil categories

        if(isfilevar(a,"ISLTYP"))
	  isoil = wrf_user_getvar(a,"ISLTYP",time)

	;	Plotting options for soil cat

	  opts_soil = True
	  opts_soil@MainTitle = "SOIL CATEGORY"
	  opts_soil@UnitLabel = "soil(cat)"
	  opts_soil@TimeLabel = times(it)
	  opts_soil@LevelLabel = "WRF MASS Input"
	  opts_soil@ContourParameters = (/ 1. /);
	  opts_soil@LineThickness = 1.0
	  opts_soil@cnInfoLabelOn = False
	  opts_soil@cnLineLabelsOn = False
	  opts_soil@lbAutoManage = False
	  opts_soil@lbBottomMarginF = .4
	  opts_soil@lbTitleFontHeightF = .02
	  opts_soil@lbLabelFontHeightF = .02
          opts_soil@cnRasterModeOn = raster

	;	Plot it

	  contour_soil = wrf_new_fill_contour(wks,isoil,opts_soil)
	  wrf_mapoverlay(map,contour_soil)
	  draw(map)
	  frame(wks)
          NhlRemoveOverlay(map,contour_soil,False)
        end if

	;	Vegetation Fraction

        if(isfilevar(a,"VEGFRA"))
	  vgf = wrf_user_getvar(a,"VEGFRA",time)
  
	;	Plotting options for veg fraction

	  opts_vgf = True
	  opts_vgf@MainTitle = "VEGETATION FRACTION"
	  opts_vgf@UnitLabel = "veg frac(%)"
	  opts_vgf@TimeLabel = times(it)
	  opts_vgf@LevelLabel = "WRF MASS Input"
	  opts_vgf@ContourParameters = (/ 10. /);
	  opts_vgf@LineThickness = 1.0
	  opts_vgf@cnInfoLabelOn = False
	  opts_vgf@cnLineLabelsOn = False
	  opts_vgf@lbAutoManage = False
	  opts_vgf@lbBottomMarginF = .4
	  opts_vgf@lbTitleFontHeightF = .02
	  opts_vgf@lbLabelFontHeightF = .02
          opts_vgf@cnRasterModeOn = raster

	;	Plot it

	  contour_vgf = wrf_new_fill_contour(wks,vgf,opts_vgf)
	  wrf_mapoverlay(map,contour_vgf)
	  draw(map)
	  frame(wks)
          NhlRemoveOverlay(map,contour_vgf,False)
        end if

	;	Soil temperature

        if(isfilevar(a,"TSLB"))
	  tsoil = wrf_user_getvar(a,"TSLB",time)

	;	Plotting options for soil temp

	  opts_ts = True
	  opts_ts@UnitLabel = "temp(K)"
	  opts_ts@TimeLabel = times(it)
	  opts_ts@LevelLabel = "WRF MASS Input"
	  opts_ts@ContourParameters = (/ 2. /);
	  opts_ts@LineThickness = 1.0
	  opts_ts@cnInfoLabelOn = False
	  opts_ts@cnLineLabelsOn = True
	  opts_ts@lbAutoManage = False
	  opts_ts@lbBottomMarginF = .4
	  opts_ts@lbTitleFontHeightF = .02
	  opts_ts@lbLabelFontHeightF = .02

          dimsl = dimsizes(tsoil)

          do level = 0, dimsl(0)-1

            level1 = level + 1
	    opts_ts@MainTitle = "SOIL TEMPERATURE (K) at soil level " + level1

            tsoil_plane = tsoil(level,:,:)
	    contour_ts  = wrf_new_line_contour(wks,tsoil_plane,opts_ts)
	    wrf_mapoverlay(map,contour_ts)
	    draw(map)
	    frame(wks)
            NhlRemoveOverlay(map,contour_ts,False)

          end do
        end if

	;	Soil moisture
        ;         soil moisture are only available from LSM option

        if(isfilevar(a,"SMOIS"))
          sf_sfc_phys  = a@SF_SURFACE_PHYSICS
          if ( sf_sfc_phys .eq. 2 ) then

	    soilm = wrf_user_getvar(a,"SMOIS",time)

	;	Plotting options for soil moisture

	    opts_ms = True
	    opts_ms@UnitLabel = "soil mositure(%)"
	    opts_ms@TimeLabel = times(it)
	    opts_ms@LevelLabel = "WRF MASS Input"
	    opts_ms@ContourParameters = (/ .1 /);
	    opts_ms@LineThickness = 1.0
	    opts_ms@cnInfoLabelOn = False
	    opts_ms@cnLineLabelsOn = True
	    opts_ms@lbAutoManage = False
	    opts_ms@lbBottomMarginF = .4
	    opts_ms@lbTitleFontHeightF = .02
	    opts_ms@lbLabelFontHeightF = .02

            dimsl = dimsizes(soilm)

  	    do level = 0, dimsl(0)-1

              level1 = level + 1
              opts_ms@MainTitle = "SOIL MOISTURE (%) at soil level " + level1
              soilm_plane = soilm(level,:,:)
print("max(soilm_plane)="+max(soilm_plane))
print("min(soilm_plane)="+min(soilm_plane))
              ;soilm_plane@_FillValue = 1.
	      contour_ms  = wrf_new_line_contour(wks,soilm_plane,opts_ms)
	      wrf_mapoverlay(map,contour_ms)
	      draw(map)
	      frame(wks)
              NhlRemoveOverlay(map,contour_ms,False)

            end do
          end if
        end if

	; 	************************************************************

	;	3) 3d plots: 3 D fields 

        ;          first get the vertical dimension 

        if(isfilevar(a,"Z"))
	  z   = wrf_user_getvar(a,"Z",time)      ; height
        end if
	th  = wrf_user_getvar(a,"T",time)      ; pert theta
        th  = th + 300.
	qv  = wrf_user_getvar(a,"QVAPOR",time) ; Qv

        dimsv = dimsizes(th)
print(dimsv)

	;	Loop over the selected model levels 

	do level = 0,dimsv(0)-1,5

		;	set up 2d planes

              if(isvar("z")) then
		z_plane  = z(level,:,:)
              end if 
		th_plane = th(level,:,:)
		qv_plane = qv(level,:,:)*1000.
		u_plane  = u(level,:,:)
		v_plane  = v(level,:,:)
		
		;	Plotting options for temperature

		delete(opts_tc) ; zap the old temp stuff, start anew
		opts_tc = True
		opts_tc@MainTitle = "Eta Level " + level + " Theta(K)"
		opts_tc@UnitLabel = "TH(K)"
		opts_tc@TimeLabel = times(it)
		opts_tc@LevelLabel = "WRF MASS Input"
		opts_tc@cnLineColor = "red"
		opts_tc@cnLineDashPattern = "1"
		opts_tc@cnInfoLabelOn = True
		opts_tc@cnLineLabelAngleF = 0.
		opts_tc@cnLineLabelFontColor = "red"
		opts_tc@cnLineLabelFontHeightF = .015
		opts_tc@cnLineLabelPerimOn = True
		opts_tc@cnLineLabelPerimColor = "red"
		opts_tc@cnHighLabelFontColor = "red"
		opts_tc@cnLowLabelFontColor = "red"
		opts_tc@LineThickness = 2.0
		opts_tc@ContourParameters = (/ 5.0 /)
		
		;	Plotting options for Qv

		opts_qv = True
		opts_qv@MainTitle = "Eta Level " + level + " Qv(g/kg)"
		opts_qv@UnitLabel = "Qv(g/kg)"
		opts_qv@TimeLabel = times(it)
		opts_qv@LevelLabel = "WRF MASS Input"
		opts_qv@cnLineColor = "blue"
		opts_qv@cnLineDashPattern = "1"
		opts_qv@cnInfoLabelOn = True
		opts_qv@cnLineLabelAngleF = 0.
		opts_qv@cnLineLabelFontColor = "blue"
		opts_qv@cnLineLabelFontHeightF = .015
		opts_qv@cnLineLabelPerimOn = True
		opts_qv@cnLineLabelPerimColor = "blue"
		opts_qv@cnHighLabelFontColor = "blue"
		opts_qv@cnLowLabelFontColor = "blue"
		opts_qv@LineThickness = 2.0
		opts_qv@ContourParameters = (/ 2.0 /)
		
		;	Plotting options for the wind speed

		opts_spd = True
		opts_spd@MainTitle = "Eta Level Wind Speed (m/sec, green) and Wind Vector"
		opts_spd@UnitLabel = "wpsd(kts)"
		opts_spd@TimeLabel = times(it)
		opts_spd@LevelLabel = "WRF MASS Input"
		opts_spd@LineThickness = 3.0
		opts_spd@cnLineColor = "medium sea green"
		opts_spd@cnLineLabelFontColor = "medium sea green"
		opts_spd@cnLineLabelAngleF = 0.
		opts_spd@cnLineLabelFontHeightF = .015
		opts_spd@cnLineLabelPerimOn = True
		opts_spd@cnLineLabelPerimColor = "medium sea green"
		opts_spd@cnHighLabelBackgroundColor = -1
		opts_spd@cnHighLabelFontColor = "medium sea green"
		opts_spd@cnLowLabelBackgroundColor = -1
		opts_spd@cnLowLabelFontColor = "medium sea green"
		opts_spd@ContourParameters = (/ 10. /)
		opts_spd@cnInfoLabelOn = True
		
		;	Plotting options for geopotential height

		opts_z = True
		opts_z@MainTitle = "Eta Level " + level + " Height(m)"
		opts_z@UnitLabel = "Height(m)"
		opts_z@TimeLabel = times(it)
		opts_z@cnLineColor = "navy blue"
		opts_z@cnInfoLabelOn = False
		opts_z@cnHighLabelsOn = True
		opts_z@cnLowLabelsOn = True
		opts_z@cnLineLabelAngleF = 0.
		opts_z@cnLineLabelFontHeightF = .015
		opts_z@cnLineLabelPerimOn = True
		opts_z@cnLineLabelPerimColor = "navy blue"
		opts_z@cnLineLabelFontColor = "navy blue"
		opts_z@cnHighLabelBackgroundColor = -1
		opts_z@cnHighLabelFontColor = "navy blue"
		opts_z@cnLowLabelBackgroundColor = -1
		opts_z@cnLowLabelFontColor = "navy blue"
		opts_z@LineThickness = 2.

		;	Plotting options for the wind barbs
		
		opts_vct = True
		opts_vct@NumVectors = 47
		opts_vct@WindBarbsOn = True
		opts_vct@NoTitles = True
		opts_vct@vcWindBarbColor = "black"
		
		;	Plotting options for the map background

		opts_mp = True
		opts_mp@mpGeophysicalLineThicknessF = 0.5
		opts_mp@mpGeophysicalLineColor = "gray"
		opts_mp@mpUSStateLineThicknessF = 0.5
		opts_mp@mpUSStateLineColor = "gray"
		opts_mp@mpNationalLineThicknessF = 0.5
		opts_mp@mpNationalLineColor = "gray"
		opts_mp@mpGridLineThicknessF = 0.5
		opts_mp@mpGridLineColor = "gray"
		opts_mp@mpLimbLineThicknessF = 0.5
		opts_mp@mpLimbLineColor = "gray"
		opts_mp@mpPerimLineThicknessF = 0.5
		opts_mp@mpPerimLineColor = "gray"
		
		map = wrf_new_map(wks,a,opts_mp)
		
		opts_map = True
		opts_map@LabelFont = "HELVETICA-BOLD"
		opts_map@LabelFontHeight = .01
		wrf_maplabel(wks,map,opts_map)
		
		;	plot height

              if(isvar("z")) then
		opts_z@ContourParameters = (/ 30.0 /)
		contour_ht     = wrf_new_line_contour(wks,z_plane,opts_z)
		map = wrf_new_map(wks,a,opts_mp)
		wrf_maplabel(wks,map,opts_map)
                wrf_mapoverlay(map,contour_ht)
		draw(map)
		frame(wks)
                NhlRemoveOverlay(map,contour_ht,False)
              end if

		;	plot theta

		contour_th     = wrf_new_line_contour(wks,th_plane,opts_tc)
                wrf_mapoverlay(map,contour_th)
		draw(map)
		frame(wks)
                NhlRemoveOverlay(map,contour_th,False)

		;	plot Qv

		contour_qv     = wrf_new_line_contour(wks,qv_plane,opts_qv)
                wrf_mapoverlay(map,contour_qv)
		draw(map)
		frame(wks)
                NhlRemoveOverlay(map,contour_qv,False)

		;	processing, we overlay the map with what fields.
		
		spd = (u_plane*u_plane + v_plane*v_plane)^(0.5)
		contour_spd = wrf_new_line_contour(wks,spd,opts_spd)
                vector      = wrf_new_vector(wks,u_plane, v_plane,opts_vct)
		wrf_mapoverlay(map,contour_spd)
		wrf_mapoverlay(map,vector)
		
		draw(map)
		frame(wks)
	
	end do	;	end of the pressure level loop
	
	;	remove the dummy arrays

	delete(opts_tc)
	delete(th_plane)
	delete(u_plane)
	delete(v_plane)
	delete(contour_th)

	; 	************************************************************

	;	4)	xsection plots

      if(isvar("z")) then
	aspect_ratio = .75
	
	do ip = 1, 2
	
		;	                                     |
		;	                                     |
		;	Two different xsections, angle=90 is |, angle=0 is ------
		;	                                     |
		;	                                     |
			
		if(ip .eq. 1) then
			angle = 90.
		else
			angle = 0.
		end if

		;	Build planes of data for temp 
	
		dimsth = dimsizes(th)
		plane = new(2,float)
		plane = (/ dimsth(2)/2, dimsth(1)/2 /)
		
		th_plane = wrf_user_intrp3d(th,z,ter,"v",plane,angle)
		
		;	Plotting options for temperature

		opts_tc = True
                if(ip .eq. 1) then
                        opts_tc@MainTitle = "West-East Theta (K) "
                else
                        opts_tc@MainTitle = "South-North Theta (K) "
                end if
                opts_tc@UnitLabel = "Theta"
                opts_tc@TimeLabel = times(it)
		opts_tc@ContourParameters = (/ 5. /)
		
		;	Get the contour info for the temp
		
		contour_tc = wrf_new_line_contour(wks, th_plane,opts_tc)

		;	Overlay the fields on the background
		
		draw(contour_tc)
		frame(wks)

		;	Remove the dummy stuff

		delete(th_plane)
		
	end do	;	end of xsection plot rotation
      end if

	; 	************************************************************

end do 	;	end of the time loop
