;
;	Script to produce standard plots for a WRF real-data run,
;	with the MASS coordinate dynamics option.
;
;       This script plots SLP from mass model data.

load "wrf_plot.ncl"
load "wrf_user_mass.ncl"
load "gsn_code.ncl"

;	The WRF MASS input file.  Don't remove ".nc" below.

a = addfile("../../WRFV2/test/em_real/wrfout_d01_2000-01-24_12:00:00.nc","r")

;	We generate plots, but what kind do we prefer?

wks = wrf_open_ncgm("wrf_slp")   ; output to ncgm
;wks = wrf_open_X11()                ; output to screen
;wks = wrf_open_PS("wrf_plots")     ; output to postscript

;	What times and how many times are in the data set?

times = wrf_user_list_times(a)  ; get times in  the file
ntimes = dimsizes(times)  ; number of times in the file

raster = True

;	This is the big loop over all of the time periods to process.

;do it = 0, ntimes-1
do it = 0, 0
	time = it
	if (it.eq.0) then
		time_save = times(it)
	end if
	hours = it*3.

	; 	************************************************************

	;	1) SLP, sfc temp, wind barbs

	;	SLP, smooth it

	slvl = wrf_user_getvar(a,"slvl",time) ; psl amd tsl
	;slvl = wrf_user_getvar(a,"mu",time) ; sfc press
	wrf_user_filter2d(slvl, 3) ; filter the fields

	;	Turn temperature into Fahrenheit, typical of a surface map.
	tc = wrf_user_getvar(a,"tc",time)
	tc = 1.8*tc+32.
	tc_plane = tc(0,:,:)

	;	Get u and v, put them in knots, again typical of a surface chart.

	u   = wrf_user_getvar(a,"ua",time) ; ua is u averaged to mass points
	v   = wrf_user_getvar(a,"va",time) ; va is v averaged to mass points
	u = u*1.94386
	v = v*1.94386
	u_plane = u(0,:,:)
	v_plane = v(0,:,:)

	;	Plotting options for the temperature.

	opts_tc = True
	opts_tc@MainTitle = "Surface T (F, color) SLP (mb) and winds (kts)"
	opts_tc@UnitLabel = "T(F)"
	opts_tc@TimeLabel = times(it) + " = " + time_save + " + " + hours + " h"
	opts_tc@LevelLabel = "WRF MASS FCST"
	opts_tc@ContourParameters = (/ -20., 95., 5./);
	opts_tc@LineThickness = 0.5
	opts_tc@cnInfoLabelOn = False
	opts_tc@cnLineLabelsOn = False
	opts_tc@lbAutoManage = False
	opts_tc@lbBottomMarginF = .4
	; change
	opts_tc@lbTitleFontHeightF = .015
	opts_tc@lbLabelStrings = (/ -20., 0., 20., 40., 60., 80./)
	opts_tc@lbLabelFontHeightF = .02
	opts_tc@cnRasterModeOn = raster

	;	Plotting options for the sea level pressure

	opts_psl = True
	opts_psl@MainTitle = "SLP"
	opts_psl@UnitLabel = "    "
	opts_psl@TimeLabel = times(it) + " = " + time_save + " + " + hours + " h"
	opts_psl@LevelLabel = "WRF MASS FCST"
	;opts_psl@NoTitles = False
	;opts_psl@MainTitle = " sea-level pressure (mb) "
	;opts_psl@TimeLabel = times(it) + " = " + time_save + " + " + hours + " h"
	opts_psl@cnLineColor = "navy blue"
	opts_psl@cnInfoLabelOn = True
	opts_psl@cnHighLabelsOn = True
	opts_psl@cnLowLabelsOn = True
	opts_psl@cnLineLabelAngleF = 0.
	opts_psl@cnLineLabelFontHeightF = .015
	opts_psl@cnLineLabelFontColor = "navy blue"
	opts_psl@cnLineLabelPerimOn = True
	opts_psl@cnLineLabelPerimColor = "navy blue"
	opts_psl@cnLineLabelBackgroundColor = -1
	opts_psl@cnHighLabelBackgroundColor = -1
	opts_psl@cnLowLabelBackgroundColor = -1   
        opts_psl@cnInfoLabelOn = True
	opts_psl@ContourParameters = (/ 900., 1100., 2. /)
	;opts_psl@ContourParameters = (/ -1000., 4000., 400. /)
	opts_psl@LineThickness = 2.0
	;opts_psl@cnRasterModeOn = raster

	;	Plotting options for the overlayed wind vectors.

	opts_vct = True
	opts_vct@NumVectors = 45
	opts_vct@WindBarbsOn = True
	opts_vct@NoTitles = True
	opts_vct@vcWindBarbColor = "black"
	opts_vct@vcRefAnnoOn = False

	;	Map options

;	opts_mp = False
	opts_mp = True
	opts_mp@mpGeophysicalLineThicknessF = 0.5
	opts_mp@mpGeophysicalLineColor = "gray"
	opts_mp@mpUSStateLineThicknessF = 0.5
	opts_mp@mpUSStateLineColor = "gray"
	opts_mp@mpNationalLineThicknessF = 0.5
	opts_mp@mpNationalLineColor = "gray"
	opts_mp@mpGridLineThicknessF = 0.5
	opts_mp@mpGridLineColor = "gray"
	opts_mp@mpLimbLineThicknessF = 0.5
	opts_mp@mpLimbLineColor = "gray"
	opts_mp@mpPerimOn = True
	opts_mp@mpPerimLineThicknessF = 1.0
	opts_mp@mpPerimLineColor = "gray"
	opts_mp@mpGridSpacingF = 10
	opts_mp@mpGridMaskMode = 3

	map = wrf_new_map(wks,a,opts_mp)

	;	... and yet more map options galore!

	opts_map = True
	opts_map@LabelFont = "HELVETICA-BOLD"
	opts_map@LabelFontHeight = .01
	wrf_maplabel(wks,map,opts_map)

	;	Now that we have the slp, temp, and wind values,
	;	we can overlay them to make a plot.

	contour_tc     = wrf_new_fill_contour(wks,tc_plane,opts_tc)
	contour_psl    = wrf_new_line_contour(wks,slvl(:,:),opts_psl)
	vector         = wrf_new_vector(wks,u_plane, v_plane,opts_vct)

	;wrf_mapoverlay(map,contour_tc)
	wrf_mapoverlay(map,contour_psl)
	;wrf_mapoverlay(map,vector)

	;	Put on the map last, and then close the metacode frame.

	draw(map)
	frame(wks)

	NhlRemoveOverlay(map,contour_psl,False)

end do 	;	end of the time loop
