load "wrf_plot.ncl"
load "wrf_user_mass.ncl"

a = addfile("../../WRFV2/test/em_squall2d_y/wrfout_d01_0001-01-01_00:00:00.nc","r")
;wks = wrf_open_X11()                ; output to screen
wks = wrf_open_ncgm("wrf_plots")   ; output to ncgm
;wks = wrf_open_PS("wrf_plots")     ; output to postscript

;frame(wks)  ; allow for window resize before beginning plots

;  plot height field, temperature, and wind barbs on pressure surface
;  for all times in the input file

times = wrf_user_list_times(a)  ; get times in  the file
ntimes = dimsizes(times)  ; number of times in the file
plane = (/ 0., 20./)  ; (x,y) point for vert plane
angle = 0.
pii = 3.14159
aspect_ratio = .7

do it = 0, ntimes-1


  print(" plot for time "+times(it))  

  time=it

  z   = wrf_user_getvar(a, "Z",time) ; grid point height
  u   = wrf_user_getvar(a,"ua",time) ; ua is u averaged to mass points
  v   = wrf_user_getvar(a,"va",time) ; va is v averaged to mass points
  ter = wrf_user_getvar(a,"HGT",time) ; need terrain height sometimes
  qv  = wrf_user_getvar(a,"QVAPOR",time) ; cloud field
  qv = qv*1000.  ; convert qc to g/kg
  qc  = wrf_user_getvar(a,"QCLOUD",time) ; cloud field
  qc = qc*1000.  ; convert qc to g/kg
  qr  = wrf_user_getvar(a,"QRAIN",time) ; cloud field
  qr = qr*1000.  ; convert qc to g/kg
  th  = wrf_user_getvar(a,"th",time) ; theta field
  w  = wrf_user_getvar(a,"wa",time) ; w field

    qv_plane = wrf_user_intrp3d(qv,z,ter,"v",plane,angle)
    qc_plane = wrf_user_intrp3d(qc,z,ter,"v",plane,angle)
    qr_plane = wrf_user_intrp3d(qr,z,ter,"v",plane,angle)
    th_plane = wrf_user_intrp3d(th,z,ter,"v",plane,angle)
    w_plane = wrf_user_intrp3d( w,z,ter,"v",plane,angle)
    u_plane  = wrf_user_intrp3d( u,z,ter,"v",plane,angle)
    v_plane  = wrf_user_intrp3d( v,z,ter,"v",plane,angle)

    opts_u = True
;    opts_u@NoTitles = True
    opts_u@MainTitle = "w and plane-normal velocity (m/s)"
    opts_u@AspectRatio = aspect_ratio
    opts_u@TimeLabel = ""
    opts_u@cnInfoLabelOn = True

    opts_th = True
    opts_th@AspectRatio = aspect_ratio
    opts_th@MainTitle = ""
    opts_th@UnitLabel = "T(C)"
    opts_th@TimeLabel = times(it) 
    opts_th@LevelLabel = "(" + plane(0)+","+plane(1) + ")" + " angle " + angle
    opts_th@AspectRatio = aspect_ratio

    opts_qv = True
    opts_qv@MainTitle = "Water Vapor (g/kg)"
    opts_qv@UnitLabel = "QV(g/kg)"
    opts_qv@TimeLabel = times(it) 
    opts_qv@LevelLabel = "(" + plane(0)+","+plane(1) + ")" + " angle " + angle
    opts_qv@AspectRatio = aspect_ratio

    opts_qc = True
    opts_qc@MainTitle = "Cloud (color) and rain, (g/kg)"
    opts_qc@UnitLabel = "QC(g/kg)"
    opts_qc@TimeLabel = times(it) 
    opts_qc@LevelLabel = "(" + plane(0)+","+plane(1) + ")" + " angle " + angle
    opts_qc@AspectRatio = aspect_ratio

    opts_qr = True
    opts_qr@MainTitle = ""
    opts_qr@UnitLabel = "QR(g/kg)"
    opts_qr@TimeLabel = " " 
    opts_qr@LevelLabel = " "
    opts_qr@AspectRatio = aspect_ratio
    opts_qr@cnInfoLabelOn = True

    opts_w = True
    opts_w@AspectRatio = aspect_ratio
    opts_w@MainTitle = ""
    opts_w@UnitLabel = "w(m/s)"
    opts_w@TimeLabel = times(it) 
    opts_w@LevelLabel = "(" + plane(0)+","+plane(1) + ")" + " angle " + angle
    opts_w@AspectRatio = aspect_ratio

    opts_t = opts_u
    opts_t@MainTitle = "w and plane-tangent velocity (m/s)"
    opts_t@AspectRatio = aspect_ratio
    opts_t@TimeLabel = ""



;    vel_normal = u_plane
;    vel_tangent = v_plane

    vel_normal  = u_plane*cos(2.*pii*angle/360.) - v_plane*sin(2.*pii*angle/360.)
    vel_tangent = u_plane*sin(2.*pii*angle/360.) + v_plane*cos(2.*pii*angle/360.)
    if(it.eq.0)
        contour_th = wrf_new_fill_contour(wks, th_plane,opts_th)
        contour_w = wrf_new_fill_contour(wks, w_plane,opts_w)
        contour_vn = wrf_new_line_contour(wks,vel_normal,opts_u)
        contour_vt = wrf_new_line_contour(wks,vel_tangent,opts_t)
        contour_qv = wrf_new_fill_contour(wks, qv_plane,opts_qv)
        contour_qc = wrf_new_fill_contour(wks, qc_plane,opts_qc)
        contour_qr = wrf_new_line_contour(wks, qr_plane,opts_qr)
        contour_w = wrf_new_fill_contour(wks, w_plane,opts_w)

    else 
	wrf_update_contour_data(wks,contour_qv,qv_plane,opts_qv)
	wrf_update_contour_data(wks,contour_qc,qc_plane,opts_qc)
	wrf_update_contour_data(wks,contour_qr,qr_plane,opts_qr)
	wrf_update_contour_data(wks,contour_w,w_plane,opts_w)
	wrf_update_contour_data(wks,contour_vn,vel_normal,opts_u)
	wrf_update_contour_data(wks,contour_vt,vel_tangent,opts_t)
    end if

;    overlay(contour_w,contour_vn)
;    draw(contour_w)
;    frame(wks)
;    NhlRemoveOverlay(contour_w,contour_vn,False)

    overlay(contour_w,contour_vt)
    draw(contour_w)
    frame(wks)
    NhlRemoveOverlay(contour_w,contour_vt,False)

    draw(contour_qv)
    frame(wks)

    overlay(contour_qc,contour_qr)
    draw(contour_qc)
    frame(wks)
    NhlRemoveOverlay(contour_qc,contour_qr,False)

end do
