;
;	Script to produce standard plots for a WRF real-data output,
;	with the MASS coordinate dynamics option.
;
;       This script plots potential temp on selected model levels.

load "wrf_plot.ncl"
load "wrf_user_mass.ncl"
load "gsn_code.ncl"

;	The WRF MASS input file.  Don't remove ".nc" below.

a = addfile("../../WRFV2/test/em_real/wrfout_d01_2000-01-24_12:00:00.nc","r")

;	We generate plots, but what kind do we prefer?

wks = wrf_open_ncgm("wrf_the")   ; output to ncgm
;wks = wrf_open_X11()                ; output to screen
;wks = wrf_open_PS("wrf_plots")     ; output to postscript

;	What times and how many times are in the data set?

times = wrf_user_list_times(a)  ; get times in  the file
ntimes = dimsizes(times)  ; number of times in the file

;	The specific pressure levels that we want the data
;	interpolated to.

pressure_levels = (/ 850., 700., 500., 300./)   ; pressure levels to plot
nlevels = dimsizes(pressure_levels)  ; number of pressure levels
raster = True

;	This is the big loop over all of the time periods to process.

	time_save = times(0)
;do it = 8, ntimes-1
do it = 0, 0
	time = it
	if (it.eq.0) then
		time_save = times(it)
	end if
	hours = it*3.

	tc    = wrf_user_getvar(a,"T",time) ; tc

	;do level = 10,50,4
	do level = 0,2

		;	Vertically interpolate the selected 3d fields to this
		;	pressure surface.

		tc_plane = tc(level,:,:) + 300.
		
;print("max(tc_plane)="+max(tc_plane))
;print("min(tc_plane)="+min(tc_plane))

		;	Plotting options for temperature

		opts_tc = True
		opts_tc@MainTitle = "eta level " + level + " theta "
		opts_tc@UnitLabel = "T(C)"
		opts_tc@TimeLabel = times(it) + " = " + time_save + " + " + hours + " h"
		opts_tc@LevelLabel = "WRF MASS Run"
		opts_tc@ContourParameters = (/ 4.0 /)
		;opts_tc@cnRasterModeOn = raster
		
		;	Plotting options for the map background

		opts_mp = True
		opts_mp@mpGeophysicalLineThicknessF = 0.5
		opts_mp@mpGeophysicalLineColor = "gray"
		opts_mp@mpUSStateLineThicknessF = 0.5
		opts_mp@mpUSStateLineColor = "gray"
		opts_mp@mpNationalLineThicknessF = 0.5
		opts_mp@mpNationalLineColor = "gray"
		opts_mp@mpGridLineThicknessF = 0.5
		opts_mp@mpGridLineColor = "gray"
		opts_mp@mpLimbLineThicknessF = 0.5
		opts_mp@mpLimbLineColor = "gray"
		opts_mp@mpPerimLineThicknessF = 0.5
		opts_mp@mpPerimLineColor = "gray"
		
		map = wrf_new_map(wks,a,opts_mp)
		
		opts_map = True
		opts_map@LabelFont = "HELVETICA-BOLD"
		opts_map@LabelFontHeight = .01
		wrf_maplabel(wks,map,opts_map)
		
		contour_tc     = wrf_new_line_contour(wks,tc_plane(:,:),opts_tc)

		;	Same logic as for contour levels, given the level that we are
		;	processing, we overlay the map with what fields.
		
		wrf_mapoverlay(map,contour_tc)
		draw(map)
		frame(wks)
		NhlRemoveOverlay(map,contour_tc,False)

	end do	;	end of the pressure level loop
	
	;	remove the dummy arrays

	delete(opts_tc)
	delete(tc_plane)

end do 	;	end of the time loop
