module module_data_isrpia

!=======================================================================
!
! *** ISORROPIA CODE
! *** INCLUDE FILE 'ISRPIA.INC'
! *** THIS FILE CONTAINS THE DECLARATIONS OF THE GLOBAL CONSTANTS
!     AND VARIABLES. 
!
! *** COPYRIGHT 1996-2006, UNIVERSITY OF MIAMI, CARNEGIE MELLON UNIVERSITY,
! *** GEORGIA INSTITUTE OF TECHNOLOGY
! *** WRITTEN BY ATHANASIOS NENES
! *** UPDATED BY CHRISTOS FOUNTOUKIS
!
!=======================================================================
!
!

!      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
  implicit none
       INTEGER,PARAMETER::NCOMP=5,NIONS=7,NGASAQ=3,NSLDS=9,NPAIR=13,NZSR=100, &
            NERRMX=25
!
! *** INPUT VARIABLES **************************************************
!

      REAL(KIND=8) W(NCOMP), WAER(NCOMP), TEMP, RH
      INTEGER      NADJ, IPROB, METSTBL
!
! *** WATER ACTIVITIES OF PURE SALT SOLUTIONS **************************
!
       REAL(KIND=8) AWAS(NZSR), AWSS(NZSR), AWAC(NZSR), AWSC(NZSR), &
                    AWAN(NZSR), AWSN(NZSR), AWSB(NZSR), AWAB(NZSR), &
                    AWSA(NZSR), AWLC(NZSR)
!
! *** DELIQUESCENCE RELATIVE HUMIDITIES ********************************
!
      INTEGER WFTYP
      REAL(KIND=8) DRH2SO4,  DRNH42S4, DRNAHSO4, DRNACL,   DRNANO3,  &
                   DRNA2SO4, DRNH4HS4, DRLC,     DRNH4NO3, DRNH4CL
      REAL(KIND=8) DRMLCAB,  DRMLCAS,  DRMASAN,  DRMG1,    DRMG2, &
                   DRMG3,    DRMH1,    DRMH2,    DRMI1,    DRMI2, &
                   DRMI3,    DRMQ1,    DRMR1,    DRMR2,    DRMR3, &
                   DRMR4,    DRMR5,    DRMR6,    DRMR7,    DRMR8, &
                   DRMR9,    DRMR10,   DRMR11,   DRMR12,   DRMR13
!
! *** VARIABLES FOR LIQUID AEROSOL PHASE *******************************
!

      REAL(KIND=8) IONIC
      LOGICAL CALAOU, CALAIN, FRST, DRYF
      REAL(KIND=8) MOLAL(NIONS), MOLALR(NPAIR), GAMA(NPAIR), ZZ(NPAIR), &
                   Z(NIONS),     GAMOU(NPAIR),  GAMIN(NPAIR),M0(NPAIR),  &
                   GASAQ(NGASAQ),                                        &
                   EPSACT,       COH,           CHNO3,       CHCL,       & 
                   WATER

      INTEGER   IACALC
!
! *** VARIABLES FOR SOLID AEROSOL PHASE ********************************
!
       REAL(KIND=8)CH2SO4,  CNH42S4, CNH4HS4, CNACL,   CNA2SO4, &
                   CNANO3,  CNH4NO3, CNH4CL,  CNAHSO4, CLC
!
! *** VARIABLES FOR GAS PHASE ******************************************
!
      REAL(KIND=8) GNH3, GHNO3, GHCL 
!
! *** EQUILIBRIUM CONSTANTS ********************************************
!
      REAL(KIND=8) XK1, XK2, XK3, XK4, XK5, XK6, XK7, XK8, XK9, XK10, &
                   XK11,XK12,XK13,XK14,XKW, XK21,XK22,XK31,XK32,XK41,  &
                   XK42
!
! *** MOLECULAR WEIGHTS ************************************************
!
      REAL(KIND=8) R, IMW(NIONS), WMW(NCOMP), SMW(NPAIR)
!
! *** SOLUTION/INFO VARIABLES ******************************************
!
      CHARACTER SCASE*15
      
      REAL(KIND=8)  SULRATW, SULRAT, SODRAT

      REAL(KIND=8) EPS, ICLACT
      INTEGER MAXIT,  NSWEEP, NDIV
!
! *** ERROR SYSTEM *****************************************************
!
      CHARACTER *40 ERRMSG(NERRMX)
      INTEGER   ERRSTK(NERRMX), NOFER   
      LOGICAL   STKOFL   
!
! *** GENERIC VARIABLES ************************************************
!
      CHARACTER VERSION*15
      REAL(KIND=8) GREAT, TINY, TINY2, ZERO, ONE
!
! *** END OF INCLUDE FILE **********************************************
!

      REAL(KIND=8) FRSO4, FRNH4,SRI

!=======================================================================
!
! *** ISORROPIA CODE
! *** BLOCK DATA BLKISO
! *** THIS SUBROUTINE PROVIDES INITIAL (DEFAULT) VALUES TO PROGRAM
!     PARAMETERS VIA DATA STATEMENTS
!
! *** COPYRIGHT 1996-2006, UNIVERSITY OF MIAMI, CARNEGIE MELLON UNIVERSITY,
! *** GEORGIA INSTITUTE OF TECHNOLOGY
! *** WRITTEN BY ATHANASIOS NENES
! *** UPDATED BY CHRISTOS FOUNTOUKIS
!
! *** ZSR RELATIONSHIP PARAMETERS MODIFIED BY DOUGLAS WALDRON
! *** OCTOBER 2003
! *** BASED ON AIM MODEL III (http://mae.ucdavis.edu/wexler/aim)
!
!=======================================================================

!      BLOCK DATA BLKISO
!      INCLUDE 'isrpia.inc'
!
! *** DEFAULT VALUES *************************************************
!
      DATA TEMP/298.0/, R/82.0567D-6/, RH/0.9D0/, EPS/1D-6/, MAXIT/100/, &
          TINY/1D-20/, GREAT/1D10/, ZERO/0.0D0/, ONE/1.0D0/,NSWEEP/4/,   &
          TINY2/1D-11/,NDIV/5/
!
      DATA MOLAL/NIONS*0.0D0/, MOLALR/NPAIR*0.0D0/, GAMA/NPAIR*0.1D0/, &
          GAMOU/NPAIR*1D10/,  GAMIN/NPAIR*1D10/,   CALAIN/.TRUE./,    &
          CALAOU/.TRUE./,     EPSACT/5D-2/,        ICLACT/0/,         &
          IACALC/1/,          NADJ/0/,             WFTYP/2/

      DATA ERRSTK/NERRMX*0/,   ERRMSG/NERRMX*' '/,  NOFER/0/,  &
          STKOFL/.FALSE./ 

      DATA IPROB/0/, METSTBL/0/

      DATA VERSION /'1.7 (03/26/07)'/

! *** OTHER PARAMETERS ***********************************************
!
      DATA SMW/58.5,142.,85.0,132.,80.0,53.5,98.0,98.0,115.,63.0,&
              36.5,120.,247./                                   &
          IMW/ 1.0,23.0,18.0,35.5,96.0,97.0,63.0/,              &
          WMW/23.0,98.0,17.0,63.0,36.5/

      DATA ZZ/1,2,1,2,1,1,2,1,1,1,1,1,2/, Z /1,1,1,1,2,1,1/
!
! *** ZSR RELATIONSHIP PARAMETERS **************************************
!
! awas= ammonium sulfate
!
      DATA AWAS/10*187.72,                                            &
      158.13,134.41,115.37,100.10, 87.86, 78.00, 70.00, 63.45, 58.02, &
       53.46,                                                         &
       49.59, 46.26, 43.37, 40.84, 38.59, 36.59, 34.79, 33.16, 31.67, &
       30.31,                                                         &
       29.07, 27.91, 26.84, 25.84, 24.91, 24.03, 23.21, 22.44, 21.70, &
       21.01,                                                         &
       20.34, 19.71, 19.11, 18.54, 17.99, 17.46, 16.95, 16.46, 15.99, &
       15.54,                                                         &
       15.10, 14.67, 14.26, 13.86, 13.47, 13.09, 12.72, 12.36, 12.01, &
       11.67,                                                         &
       11.33, 11.00, 10.68, 10.37, 10.06,  9.75,  9.45,  9.15,  8.86, &
        8.57,                                                         &
        8.29,  8.01,  7.73,  7.45,  7.18,  6.91,  6.64,  6.37,  6.10, &
        5.83,                                                         &
        5.56,  5.29,  5.02,  4.74,  4.47,  4.19,  3.91,  3.63,  3.34, &
        3.05,                                                         &
        2.75,  2.45,  2.14,  1.83,  1.51,  1.19,  0.87,  0.56,  0.26, &
       0.1/
!
! awsn= sodium nitrate
!
      DATA AWSN/10*394.54,                                             &
      338.91,293.01,254.73,222.61,195.56,172.76,153.53,137.32,123.65, &
      112.08,                                                         &
      102.26, 93.88, 86.68, 80.45, 75.02, 70.24, 66.02, 62.26, 58.89, &
       55.85,                                                         &
       53.09, 50.57, 48.26, 46.14, 44.17, 42.35, 40.65, 39.06, 37.57, &
       36.17,                                                         &
       34.85, 33.60, 32.42, 31.29, 30.22, 29.20, 28.22, 27.28, 26.39, &
       25.52,                                                         &
       24.69, 23.89, 23.12, 22.37, 21.65, 20.94, 20.26, 19.60, 18.96, &
       18.33,                                                         &
       17.72, 17.12, 16.53, 15.96, 15.40, 14.85, 14.31, 13.78, 13.26, &
       12.75,                                                         &
       12.25, 11.75, 11.26, 10.77, 10.29,  9.82,  9.35,  8.88,  8.42, &
        7.97,                                                         &
        7.52,  7.07,  6.62,  6.18,  5.75,  5.32,  4.89,  4.47,  4.05, &
        3.64,                                                         &
        3.24,  2.84,  2.45,  2.07,  1.70,  1.34,  0.99,  0.65,  0.31, &
       0.1/                                                           
!                                                                      
! awsc= sodium chloride                                                
!                                                                      
      DATA AWSC/10*28.16,                                              &
       27.17, 26.27, 25.45, 24.69, 23.98, 23.33, 22.72, 22.14, 21.59, &
       21.08,                                                         &
       20.58, 20.12, 19.67, 19.24, 18.82, 18.43, 18.04, 17.67, 17.32, &
       16.97,                                                         &
       16.63, 16.31, 15.99, 15.68, 15.38, 15.08, 14.79, 14.51, 14.24, &
       13.97,                                                         &
       13.70, 13.44, 13.18, 12.93, 12.68, 12.44, 12.20, 11.96, 11.73, &
       11.50,                                                         &
       11.27, 11.05, 10.82, 10.60, 10.38, 10.16,  9.95,  9.74,  9.52, &
        9.31,                                                         &
        9.10,  8.89,  8.69,  8.48,  8.27,  8.07,  7.86,  7.65,  7.45, &
        7.24,                                                         &
        7.04,  6.83,  6.62,  6.42,  6.21,  6.00,  5.79,  5.58,  5.36, &
        5.15,                                                         &
        4.93,  4.71,  4.48,  4.26,  4.03,  3.80,  3.56,  3.32,  3.07, &
        2.82,                                                         &
        2.57,  2.30,  2.04,  1.76,  1.48,  1.20,  0.91,  0.61,  0.30, &
       0.1/                                                           
!                                                                      
! awac= ammonium chloride                                              
!                                                                      
      DATA AWAC/10*1209.00,                                            &
      1067.60,949.27,848.62,761.82,686.04,619.16,559.55,505.92,457.25,&
      412.69,                                                         &
      371.55,333.21,297.13,262.81,229.78,197.59,165.98,135.49,108.57, &
       88.29,                                                         &
       74.40, 64.75, 57.69, 52.25, 47.90, 44.30, 41.27, 38.65, 36.36, &
       34.34,                                                         &
       32.52, 30.88, 29.39, 28.02, 26.76, 25.60, 24.51, 23.50, 22.55, &
       21.65,                                                         &
       20.80, 20.00, 19.24, 18.52, 17.83, 17.17, 16.54, 15.93, 15.35, &
       14.79,                                                         &
       14.25, 13.73, 13.22, 12.73, 12.26, 11.80, 11.35, 10.92, 10.49, &
       10.08,                                                         &
        9.67,  9.28,  8.89,  8.51,  8.14,  7.77,  7.42,  7.06,  6.72, &
        6.37,                                                         &
        6.03,  5.70,  5.37,  5.05,  4.72,  4.40,  4.08,  3.77,  3.45, &
        3.14,                                                         &
        2.82,  2.51,  2.20,  1.89,  1.57,  1.26,  0.94,  0.62,  0.31, &
       0.1/                                                           
!                                                                      
! awss= sodium sulfate                                                 
!                                                                      
      DATA AWSS/10*24.10,                                              &
       23.17, 22.34, 21.58, 20.90, 20.27, 19.69, 19.15, 18.64, 18.17, &
       17.72,                                                         &
       17.30, 16.90, 16.52, 16.16, 15.81, 15.48, 15.16, 14.85, 14.55, &
       14.27,                                                         &
       13.99, 13.73, 13.47, 13.21, 12.97, 12.73, 12.50, 12.27, 12.05, &
       11.84,                                                         &
       11.62, 11.42, 11.21, 11.01, 10.82, 10.63, 10.44, 10.25, 10.07, &
        9.89,                                                         &
        9.71,  9.53,  9.36,  9.19,  9.02,  8.85,  8.68,  8.51,  8.35, &
        8.19,                                                         &
        8.02,  7.86,  7.70,  7.54,  7.38,  7.22,  7.06,  6.90,  6.74, &
        6.58,                                                         &
        6.42,  6.26,  6.10,  5.94,  5.78,  5.61,  5.45,  5.28,  5.11, &
        4.93,                                                         &
        4.76,  4.58,  4.39,  4.20,  4.01,  3.81,  3.60,  3.39,  3.16, &
        2.93,                                                         &
        2.68,  2.41,  2.13,  1.83,  1.52,  1.19,  0.86,  0.54,  0.25, &
       0.1/                                                           
!                                                                      
! awab= ammonium bisulfate                                             
!                                                                      
      DATA AWAB/10*312.84,                                             &
      271.43,237.19,208.52,184.28,163.64,145.97,130.79,117.72,106.42, &
       96.64,                                                         &
       88.16, 80.77, 74.33, 68.67, 63.70, 59.30, 55.39, 51.89, 48.76, &
       45.93,                                                         &
       43.38, 41.05, 38.92, 36.97, 35.18, 33.52, 31.98, 30.55, 29.22, &
       27.98,                                                         &
       26.81, 25.71, 24.67, 23.70, 22.77, 21.90, 21.06, 20.27, 19.52, &
       18.80,                                                         &
       18.11, 17.45, 16.82, 16.21, 15.63, 15.07, 14.53, 14.01, 13.51, &
       13.02,                                                         &
       12.56, 12.10, 11.66, 11.24, 10.82, 10.42, 10.04,  9.66,  9.29, &
        8.93,                                                         &
        8.58,  8.24,  7.91,  7.58,  7.26,  6.95,  6.65,  6.35,  6.05, &
        5.76,                                                         &
        5.48,  5.20,  4.92,  4.64,  4.37,  4.09,  3.82,  3.54,  3.27, &
        2.99,                                                         &
        2.70,  2.42,  2.12,  1.83,  1.52,  1.22,  0.90,  0.59,  0.28, &
       0.1/                                                           
!                                                                      
! awsa= sulfuric acid                                                  
!                                                                      
      DATA AWSA/34.00, 33.56, 29.22, 26.55, 24.61, 23.11, 21.89, 20.87,&
       19.99, 18.45,                                                  &
       17.83, 17.26, 16.73, 16.25, 15.80, 15.38, 14.98, 14.61, 14.26, &
       13.93,                                                         &
       13.61, 13.30, 13.01, 12.73, 12.47, 12.21, 11.96, 11.72, 11.49, &
       11.26,                                                         &
       11.04, 10.83, 10.62, 10.42, 10.23, 10.03,  9.85,  9.67,  9.49, &
        9.31,                                                         &
        9.14,  8.97,  8.81,  8.65,  8.49,  8.33,  8.18,  8.02,  7.87, &
        7.73,                                                         &
        7.58,  7.44,  7.29,  7.15,  7.01,  6.88,  6.74,  6.61,  6.47, &
        6.34,                                                         &
        6.21,  6.07,  5.94,  5.81,  5.68,  5.55,  5.43,  5.30,  5.17, &
        5.04,                                                         &
        4.91,  4.78,  4.65,  4.52,  4.39,  4.26,  4.13,  4.00,  3.86, &
        3.73,                                                         &
        3.59,  3.45,  3.31,  3.17,  3.02,  2.87,  2.71,  2.56,  2.39, &
        2.22,                                                         &
        2.05,  1.87,  1.68,  1.48,  1.27,  1.04,  0.80,  0.55,  0.28, &
       0.1/                                                           
!                                                                      
! awlc= (NH4)3H(SO4)2                                                  
!                                                                      
      DATA AWLC/10*125.37,                                             &
      110.10, 97.50, 86.98, 78.08, 70.49, 63.97, 58.33, 53.43, 49.14, &
       45.36,                                                         &
       42.03, 39.07, 36.44, 34.08, 31.97, 30.06, 28.33, 26.76, 25.32, &
       24.01,                                                         &
       22.81, 21.70, 20.67, 19.71, 18.83, 18.00, 17.23, 16.50, 15.82, &
       15.18,                                                         &
       14.58, 14.01, 13.46, 12.95, 12.46, 11.99, 11.55, 11.13, 10.72, &
       10.33,                                                         &
        9.96,  9.60,  9.26,  8.93,  8.61,  8.30,  8.00,  7.72,  7.44, &
        7.17,                                                         &
        6.91,  6.66,  6.42,  6.19,  5.96,  5.74,  5.52,  5.31,  5.11, &
        4.91,                                                         &
        4.71,  4.53,  4.34,  4.16,  3.99,  3.81,  3.64,  3.48,  3.31, &
        3.15,                                                         &
        2.99,  2.84,  2.68,  2.53,  2.37,  2.22,  2.06,  1.91,  1.75, &
        1.60,                                                         &
        1.44,  1.28,  1.12,  0.95,  0.79,  0.62,  0.45,  0.29,  0.14, &
       0.1/                                                           
!                                                                      
! awan= ammonium nitrate                                               
!                                                                      
      DATA AWAN/10*960.19,                                             &
      853.15,763.85,688.20,623.27,566.92,517.54,473.91,435.06,400.26, &
      368.89,                                                         &
      340.48,314.63,291.01,269.36,249.46,231.11,214.17,198.50,184.00, &
      170.58,                                                         &
      158.15,146.66,136.04,126.25,117.24,108.97,101.39, 94.45, 88.11, &
       82.33,                                                         &
       77.06, 72.25, 67.85, 63.84, 60.16, 56.78, 53.68, 50.81, 48.17, &
       45.71,                                                         &
       43.43, 41.31, 39.32, 37.46, 35.71, 34.06, 32.50, 31.03, 29.63, &
       28.30,                                                         &
       27.03, 25.82, 24.67, 23.56, 22.49, 21.47, 20.48, 19.53, 18.61, &
       17.72,                                                         &
       16.86, 16.02, 15.20, 14.41, 13.64, 12.89, 12.15, 11.43, 10.73, &
       10.05,                                                         &
        9.38,  8.73,  8.09,  7.47,  6.86,  6.27,  5.70,  5.15,  4.61, &
        4.09,                                                         &
        3.60,  3.12,  2.66,  2.23,  1.81,  1.41,  1.03,  0.67,  0.32, &
       0.1/                                                           
!                                                                      
! awsb= sodium bisulfate                                               
!                                                                      
      DATA AWSB/10*55.99,                                              &
       53.79, 51.81, 49.99, 48.31, 46.75, 45.28, 43.91, 42.62, 41.39, &
       40.22,                                                         &
       39.10, 38.02, 36.99, 36.00, 35.04, 34.11, 33.21, 32.34, 31.49, &
       30.65,                                                         &
       29.84, 29.04, 28.27, 27.50, 26.75, 26.01, 25.29, 24.57, 23.87, &
       23.17,                                                         &
       22.49, 21.81, 21.15, 20.49, 19.84, 19.21, 18.58, 17.97, 17.37, &
       16.77,                                                         &
       16.19, 15.63, 15.08, 14.54, 14.01, 13.51, 13.01, 12.53, 12.07, &
       11.62,                                                         &
       11.19, 10.77, 10.36,  9.97,  9.59,  9.23,  8.87,  8.53,  8.20, &
        7.88,                                                         &
        7.57,  7.27,  6.97,  6.69,  6.41,  6.14,  5.88,  5.62,  5.36, &
        5.11,                                                         &
        4.87,  4.63,  4.39,  4.15,  3.92,  3.68,  3.45,  3.21,  2.98, &
        2.74,                                                         &
        2.49,  2.24,  1.98,  1.72,  1.44,  1.16,  0.87,  0.57,  0.28, &
       0.1/
!
! *** ZSR RELATIONSHIP PARAMETERS **************************************

! awas= ammonium sulfate
!
!      DATA AWAS/33*100.,30,30,30,29.54,28.25,27.06,25.94,
!     & 24.89,23.90,22.97,22.10,21.27,20.48,19.73,19.02,18.34,17.69,
!     & 17.07,16.48,15.91,15.37,14.85,14.34,13.86,13.39,12.94,12.50,
!     & 12.08,11.67,11.27,10.88,10.51,10.14, 9.79, 9.44, 9.10, 8.78,
!     &  8.45, 8.14, 7.83, 7.53, 7.23, 6.94, 6.65, 6.36, 6.08, 5.81,
!     &  5.53, 5.26, 4.99, 4.72, 4.46, 4.19, 3.92, 3.65, 3.38, 3.11,
!     &  2.83, 2.54, 2.25, 1.95, 1.63, 1.31, 0.97, 0.63, 0.30, 0.001/
!
! awsn= sodium nitrate
!
!      DATA AWSN/ 9*1.e5,685.59,
!     & 451.00,336.46,268.48,223.41,191.28,
!     & 167.20,148.46,133.44,121.12,110.83,
!     & 102.09,94.57,88.03,82.29,77.20,72.65,68.56,64.87,61.51,58.44,
!     & 55.62,53.03,50.63,48.40,46.32,44.39,42.57,40.87,39.27,37.76,
!     & 36.33,34.98,33.70,32.48,31.32,30.21,29.16,28.14,27.18,26.25,
!     & 25.35,24.50,23.67,22.87,22.11,21.36,20.65,19.95,19.28,18.62,
!     & 17.99,17.37,16.77,16.18,15.61,15.05,14.51,13.98,13.45,12.94,
!     & 12.44,11.94,11.46,10.98,10.51,10.04, 9.58, 9.12, 8.67, 8.22,
!     &  7.77, 7.32, 6.88, 6.43, 5.98, 5.53, 5.07, 4.61, 4.15, 3.69,
!     &  3.22, 2.76, 2.31, 1.87, 1.47, 1.10, 0.77, 0.48, 0.23, 0.001/
!
! awsc= sodium chloride
!
!      DATA AWS!/
!     &  100., 100., 100., 100., 100., 100., 100., 100., 100., 100.,
!     &  100., 100., 100., 100., 100., 100., 100., 100., 100.,16.34,
!     & 16.28,16.22,16.15,16.09,16.02,15.95,15.88,15.80,15.72,15.64,
!     & 15.55,15.45,15.36,15.25,15.14,15.02,14.89,14.75,14.60,14.43,
!     & 14.25,14.04,13.81,13.55,13.25,12.92,12.56,12.19,11.82,11.47,
!     & 11.13,10.82,10.53,10.26,10.00, 9.76, 9.53, 9.30, 9.09, 8.88,
!     &  8.67, 8.48, 8.28, 8.09, 7.90, 7.72, 7.54, 7.36, 7.17, 6.99,
!     &  6.81, 6.63, 6.45, 6.27, 6.09, 5.91, 5.72, 5.53, 5.34, 5.14,
!     &  4.94, 4.74, 4.53, 4.31, 4.09, 3.86, 3.62, 3.37, 3.12, 2.85,
!     &  2.58, 2.30, 2.01, 1.72, 1.44, 1.16, 0.89, 0.64, 0.40, 0.18/
!
! awac= ammonium chloride
!
!      DATA AWA!/
!     &  100., 100., 100., 100., 100., 100., 100., 100., 100., 100.,
!     &  100., 100., 100., 100., 100., 100., 100., 100., 100.,31.45,
!     & 31.30,31.14,30.98,30.82,30.65,30.48,30.30,30.11,29.92,29.71,
!     & 29.50,29.29,29.06,28.82,28.57,28.30,28.03,27.78,27.78,27.77,
!     & 27.77,27.43,27.07,26.67,26.21,25.73,25.18,24.56,23.84,23.01,
!     & 22.05,20.97,19.85,18.77,17.78,16.89,16.10,15.39,14.74,14.14,
!     & 13.59,13.06,12.56,12.09,11.65,11.22,10.81,10.42,10.03, 9.66,
!     &  9.30, 8.94, 8.59, 8.25, 7.92, 7.59, 7.27, 6.95, 6.63, 6.32,
!     &  6.01, 5.70, 5.39, 5.08, 4.78, 4.47, 4.17, 3.86, 3.56, 3.25,
!     &  2.94, 2.62, 2.30, 1.98, 1.65, 1.32, 0.97, 0.62, 0.26, 0.13/
!
! awss= sodium sulfate
!
!      DATA AWSS/34*1.e5,23*14.30,14.21,12.53,11.47,
!     & 10.66,10.01, 9.46, 8.99, 8.57, 8.19, 7.85, 7.54, 7.25, 6.98,
!     &  6.74, 6.50, 6.29, 6.08, 5.88, 5.70, 5.52, 5.36, 5.20, 5.04,
!     &  4.90, 4.75, 4.54, 4.34, 4.14, 3.93, 3.71, 3.49, 3.26, 3.02,
!     &  2.76, 2.49, 2.20, 1.89, 1.55, 1.18, 0.82, 0.49, 0.22, 0.001/
!
! awab= ammonium bisulfate
!
!      DATA AWAB/356.45,296.51,253.21,220.47,194.85,
!     & 174.24,157.31,143.16,131.15,120.82,
!     & 111.86,103.99,97.04,90.86,85.31,80.31,75.78,71.66,67.90,64.44,
!     &  61.25,58.31,55.58,53.04,50.68,48.47,46.40,44.46,42.63,40.91,
!     &  39.29,37.75,36.30,34.92,33.61,32.36,31.18,30.04,28.96,27.93,
!     &  26.94,25.99,25.08,24.21,23.37,22.57,21.79,21.05,20.32,19.63,
!     &  18.96,18.31,17.68,17.07,16.49,15.92,15.36,14.83,14.31,13.80,
!     &  13.31,12.83,12.36,11.91,11.46,11.03,10.61,10.20, 9.80, 9.41,
!     &   9.02, 8.64, 8.28, 7.91, 7.56, 7.21, 6.87, 6.54, 6.21, 5.88,
!     &   5.56, 5.25, 4.94, 4.63, 4.33, 4.03, 3.73, 3.44, 3.14, 2.85,
!     &   2.57, 2.28, 1.99, 1.71, 1.42, 1.14, 0.86, 0.57, 0.29, 0.001/
!
! awsa= sulfuric acid
!
!      DATA AWSA/
!     & 34.0,33.56,29.22,26.55,24.61,23.11,21.89,20.87,19.99,
!     & 19.21,18.51,17.87,17.29,16.76,16.26,15.8,15.37,14.95,14.56,
!     & 14.20,13.85,13.53,13.22,12.93,12.66,12.40,12.14,11.90,11.67,
!     & 11.44,11.22,11.01,10.8,10.60,10.4,10.2,10.01,9.83,9.65,9.47,
!     & 9.3,9.13,8.96,8.81,8.64,8.48,8.33,8.17,8.02,7.87,7.72,7.58,
!     & 7.44,7.30,7.16,7.02,6.88,6.75,6.61,6.48,6.35,6.21,6.08,5.95,
!     & 5.82,5.69,5.56,5.44,5.31,5.18,5.05,4.92,4.79,4.66,4.53,4.40,
!     & 4.27,4.14,4.,3.87,3.73,3.6,3.46,3.31,3.17,3.02,2.87,2.72,
!     & 2.56,2.4,2.23,2.05,1.87,1.68,1.48,1.27,1.05,0.807,0.552,0.281/
!
! awlc= (NH4)3H(SO4)2
!
!      DATA AWL!/34*1.e5,17.0,16.5,15.94,15.31,14.71,14.14,
!     & 13.60,13.08,12.59,12.12,11.68,11.25,10.84,10.44,10.07, 9.71,
!     &  9.36, 9.02, 8.70, 8.39, 8.09, 7.80, 7.52, 7.25, 6.99, 6.73,
!     &  6.49, 6.25, 6.02, 5.79, 5.57, 5.36, 5.15, 4.95, 4.76, 4.56,
!     &  4.38, 4.20, 4.02, 3.84, 3.67, 3.51, 3.34, 3.18, 3.02, 2.87,
!     &  2.72, 2.57, 2.42, 2.28, 2.13, 1.99, 1.85, 1.71, 1.57, 1.43,
!     &  1.30, 1.16, 1.02, 0.89, 0.75, 0.61, 0.46, 0.32, 0.16, 0.001/
!
! awan= ammonium nitrate
!
!      DATA AWAN/31*1.e5,
!     &       97.17,92.28,87.66,83.15,78.87,74.84,70.98,67.46,64.11,
!     & 60.98,58.07,55.37,52.85,50.43,48.24,46.19,44.26,42.40,40.70,
!     & 39.10,37.54,36.10,34.69,33.35,32.11,30.89,29.71,28.58,27.46,
!     & 26.42,25.37,24.33,23.89,22.42,21.48,20.56,19.65,18.76,17.91,
!     & 17.05,16.23,15.40,14.61,13.82,13.03,12.30,11.55,10.83,10.14,
!     &  9.44, 8.79, 8.13, 7.51, 6.91, 6.32, 5.75, 5.18, 4.65, 4.14,
!     &  3.65, 3.16, 2.71, 2.26, 1.83, 1.42, 1.03, 0.66, 0.30, 0.001/
!
! awsb= sodium bisulfate
!
!      DATA AWSB/173.72,156.88,142.80,130.85,120.57,
!     & 111.64,103.80,96.88,90.71,85.18,
!     & 80.20,75.69,71.58,67.82,64.37,61.19,58.26,55.53,53.00,50.64,
!     & 48.44,46.37,44.44,42.61,40.90,39.27,37.74,36.29,34.91,33.61,
!     & 32.36,31.18,30.05,28.97,27.94,26.95,26.00,25.10,24.23,23.39,
!     & 22.59,21.81,21.07,20.35,19.65,18.98,18.34,17.71,17.11,16.52,
!     & 15.95,15.40,14.87,14.35,13.85,13.36,12.88,12.42,11.97,11.53,
!     & 11.10,10.69,10.28, 9.88, 9.49, 9.12, 8.75, 8.38, 8.03, 7.68,
!     &  7.34, 7.01, 6.69, 6.37, 6.06, 5.75, 5.45, 5.15, 4.86, 4.58,
!     &  4.30, 4.02, 3.76, 3.49, 3.23, 2.98, 2.73, 2.48, 2.24, 2.01,
!     &  1.78, 1.56, 1.34, 1.13, 0.92, 0.73, 0.53, 0.35, 0.17, 0.001/
!
! *** END OF BLOCK DATA SUBPROGRAM *************************************
!
!      END

      REAL(KIND=8) CHI1, CHI2, CHI3, CHI4, CHI5, CHI6, CHI7, CHI8,&
           PSI1, PSI2, PSI3, PSI4, PSI5, PSI6, PSI7, PSI8, &
           A1,   A2,   A3,   A4,   A5,   A6,   A7,   A8

      REAL(KIND=8) LAMDA, KAPPA

!=======================================================================
!
! *** ISORROPIA CODE
! *** BLOCK DATA AERSR
! *** CONTAINS DATA FOR AEROSOL SULFATE RATIO ARRAY NEEDED IN FUNCTION 
!     GETASR
!
! *** COPYRIGHT 1996-2006, UNIVERSITY OF MIAMI, CARNEGIE MELLON UNIVERSITY,
! *** GEORGIA INSTITUTE OF TECHNOLOGY
! *** WRITTEN BY ATHANASIOS NENES
! *** UPDATED BY CHRISTOS FOUNTOUKIS
!
!=======================================================================
!

!      BLOCK DATA AERSR
      INTEGER,PARAMETER::NSO4S=14, NRHS=20, NASRD=NSO4S*NRHS
      REAL(KIND=8) ASRAT(NASRD), ASSO4(NSO4S)
      INTEGER IA

      DATA ASSO4/1.0E-9, 2.5E-9, 5.0E-9, 7.5E-9, 1.0E-8,    &
                2.5E-8, 5.0E-8, 7.5E-8, 1.0E-7, 2.5E-7,    &
                5.0E-7, 7.5E-7, 1.0E-6, 5.0E-6/            
                                                           
     DATA (ASRAT(IA), IA=1,100)/                             &
      1.020464, 0.9998130, 0.9960167, 0.9984423, 1.004004, &
      1.010885,  1.018356,  1.026726,  1.034268, 1.043846, &
      1.052933,  1.062230,  1.062213,  1.080050, 1.088350, &
      1.096603,  1.104289,  1.111745,  1.094662, 1.121594, &
      1.268909,  1.242444,  1.233815,  1.232088, 1.234020, &
      1.238068,  1.243455,  1.250636,  1.258734, 1.267543, &
      1.276948,  1.286642,  1.293337,  1.305592, 1.314726, &
      1.323463,  1.333258,  1.343604,  1.344793, 1.355571, &
      1.431463,  1.405204,  1.395791,  1.393190, 1.394403, &
      1.398107,  1.403811,  1.411744,  1.420560, 1.429990, &
      1.439742,  1.449507,  1.458986,  1.468403, 1.477394, &
      1.487373,  1.495385,  1.503854,  1.512281, 1.520394, &
      1.514464,  1.489699,  1.480686,  1.478187, 1.479446, &
      1.483310,  1.489316,  1.497517,  1.506501, 1.515816, &
      1.524724,  1.533950,  1.542758,  1.551730, 1.559587, &
      1.568343,  1.575610,  1.583140,  1.590440, 1.596481, &
      1.567743,  1.544426,  1.535928,  1.533645, 1.535016, &
      1.539003,  1.545124,  1.553283,  1.561886, 1.570530, &
      1.579234,  1.587813,  1.595956,  1.603901, 1.611349, &
      1.618833,  1.625819,  1.632543,  1.639032, 1.645276/ 
                                                           
     DATA (ASRAT(IA), IA=101,200)/                           &
      1.707390,  1.689553,  1.683198,  1.681810, 1.683490, &
      1.687477,  1.693148,  1.700084,  1.706917, 1.713507, &
      1.719952,  1.726190,  1.731985,  1.737544, 1.742673, &
      1.747756,  1.752431,  1.756890,  1.761141, 1.765190, &
      1.785657,  1.771851,  1.767063,  1.766229, 1.767901, &
      1.771455,  1.776223,  1.781769,  1.787065, 1.792081, &
      1.796922,  1.801561,  1.805832,  1.809896, 1.813622, &
      1.817292,  1.820651,  1.823841,  1.826871, 1.829745, &
      1.822215,  1.810497,  1.806496,  1.805898, 1.807480, &
      1.810684,  1.814860,  1.819613,  1.824093, 1.828306, &
      1.832352,  1.836209,  1.839748,  1.843105, 1.846175, &
      1.849192,  1.851948,  1.854574,  1.857038, 1.859387, &
      1.844588,  1.834208,  1.830701,  1.830233, 1.831727, &
      1.834665,  1.838429,  1.842658,  1.846615, 1.850321, &
      1.853869,  1.857243,  1.860332,  1.863257, 1.865928, &
      1.868550,  1.870942,  1.873208,  1.875355, 1.877389, &
      1.899556,  1.892637,  1.890367,  1.890165, 1.891317, &
      1.893436,  1.896036,  1.898872,  1.901485, 1.903908, &
      1.906212,  1.908391,  1.910375,  1.912248, 1.913952, &
      1.915621,  1.917140,  1.918576,  1.919934, 1.921220/ 
                                                           
     DATA (ASRAT(IA), IA=201,280)/                           &
      1.928264,  1.923245,  1.921625,  1.921523, 1.922421, &
      1.924016,  1.925931,  1.927991,  1.929875, 1.931614, &
      1.933262,  1.934816,  1.936229,  1.937560, 1.938769, &
      1.939951,  1.941026,  1.942042,  1.943003, 1.943911, &
      1.941205,  1.937060,  1.935734,  1.935666, 1.936430, &
      1.937769,  1.939359,  1.941061,  1.942612, 1.944041, &
      1.945393,  1.946666,  1.947823,  1.948911, 1.949900, &
      1.950866,  1.951744,  1.952574,  1.953358, 1.954099, &
      1.948985,  1.945372,  1.944221,  1.944171, 1.944850, &
      1.946027,  1.947419,  1.948902,  1.950251, 1.951494, &
      1.952668,  1.953773,  1.954776,  1.955719, 1.956576, &
      1.957413,  1.958174,  1.958892,  1.959571, 1.960213, &
      1.977193,  1.975540,  1.975023,  1.975015, 1.975346, &
      1.975903,  1.976547,  1.977225,  1.977838, 1.978401, &
      1.978930,  1.979428,  1.979879,  1.980302, 1.980686, &
      1.981060,  1.981401,  1.981722,  1.982025, 1.982312/
!
! *** END OF BLOCK DATA AERSR ******************************************
!
!       END

      REAL(KIND=8)                                    &
      BNC01M(  741),BNC02M(  741),BNC03M(  741),BNC04M(  741),&
      BNC05M(  741),BNC06M(  741),BNC07M(  741),BNC08M(  741),&
      BNC09M(  741),BNC10M(  741),BNC11M(  741),BNC12M(  741),&
      BNC13M(  741)      


 
!  *** TEMP = 198.0
 
!      BLOCK DATA KMCF198
!
!  *** Common block definition
!
!      COMMON /KMC198/                                         &
!      BNC01M(  741),BNC02M(  741),BNC03M(  741),BNC04M(  741),&
!      BNC05M(  741),BNC06M(  741),BNC07M(  741),BNC08M(  741),&
!      BNC09M(  741),BNC10M(  741),BNC11M(  741),BNC12M(  741),&
 !     BNC13M(  741)
!
!  *** NaCl
!
      DATA (BNC01M (IA),IA=  1,100)/                                     &
     -0.54728E-01,-0.96305E-01,-0.12309E+00,-0.13978E+00,-0.15161E+00,&
     -0.16050E+00,-0.16740E+00,-0.17287E+00,-0.17725E+00,-0.18077E+00,&
     -0.18360E+00,-0.18587E+00,-0.18765E+00,-0.18904E+00,-0.19007E+00,&
     -0.19081E+00,-0.19129E+00,-0.19153E+00,-0.19157E+00,-0.19143E+00,&
     -0.19114E+00,-0.19069E+00,-0.19012E+00,-0.18943E+00,-0.18863E+00,&
     -0.18775E+00,-0.18677E+00,-0.18572E+00,-0.18460E+00,-0.18341E+00,&
     -0.18217E+00,-0.18087E+00,-0.17953E+00,-0.17814E+00,-0.17672E+00,&
     -0.17526E+00,-0.17377E+00,-0.17225E+00,-0.17071E+00,-0.16914E+00,&
     -0.16756E+00,-0.16596E+00,-0.16434E+00,-0.16271E+00,-0.16106E+00,&
     -0.15941E+00,-0.15775E+00,-0.15607E+00,-0.15440E+00,-0.15271E+00,&
     -0.15102E+00,-0.14933E+00,-0.14763E+00,-0.14592E+00,-0.14422E+00,&
     -0.14251E+00,-0.14080E+00,-0.13908E+00,-0.13736E+00,-0.13564E+00,&
     -0.13392E+00,-0.13219E+00,-0.13046E+00,-0.12872E+00,-0.12698E+00,&
     -0.12523E+00,-0.12347E+00,-0.12171E+00,-0.11995E+00,-0.11817E+00,&
     -0.11638E+00,-0.11459E+00,-0.11279E+00,-0.11097E+00,-0.10915E+00,&
     -0.10731E+00,-0.10546E+00,-0.10360E+00,-0.10172E+00,-0.99830E-01,&
     -0.97925E-01,-0.96004E-01,-0.94068E-01,-0.92116E-01,-0.90147E-01,&
     -0.88163E-01,-0.86161E-01,-0.84143E-01,-0.82108E-01,-0.80055E-01,&
     -0.77986E-01,-0.75900E-01,-0.73797E-01,-0.71678E-01,-0.69542E-01,&
     -0.67390E-01,-0.65222E-01,-0.63039E-01,-0.60840E-01,-0.58627E-01/
                             
     DATA (BNC01M (IA),IA=101,200)/                                     &
     -0.56400E-01,-0.54159E-01,-0.51905E-01,-0.49639E-01,-0.47360E-01,&
     -0.45070E-01,-0.42769E-01,-0.40457E-01,-0.38136E-01,-0.35805E-01,&
     -0.33466E-01,-0.31119E-01,-0.28765E-01,-0.26404E-01,-0.24036E-01,&
     -0.21663E-01,-0.19285E-01,-0.16902E-01,-0.14514E-01,-0.12123E-01,&
     -0.10058E-01,-0.76233E-02,-0.51896E-02,-0.27575E-02,-0.32700E-03,&
      0.21018E-02, 0.45288E-02, 0.69540E-02, 0.93773E-02, 0.11799E-01,&
      0.14218E-01, 0.16635E-01, 0.19050E-01, 0.21463E-01, 0.23873E-01,&
      0.26281E-01, 0.28687E-01, 0.31090E-01, 0.33491E-01, 0.35889E-01,&
      0.38285E-01, 0.40678E-01, 0.43068E-01, 0.45456E-01, 0.47840E-01,&
      0.50222E-01, 0.52601E-01, 0.54977E-01, 0.57350E-01, 0.59721E-01,&
      0.62088E-01, 0.64452E-01, 0.66813E-01, 0.69171E-01, 0.71526E-01,&
      0.73877E-01, 0.76225E-01, 0.78571E-01, 0.80912E-01, 0.83251E-01,&
      0.85586E-01, 0.87918E-01, 0.90247E-01, 0.92572E-01, 0.94893E-01,&
      0.97212E-01, 0.99526E-01, 0.10184E+00, 0.10415E+00, 0.10645E+00,&
      0.10875E+00, 0.11105E+00, 0.11334E+00, 0.11563E+00, 0.11792E+00,&
      0.12020E+00, 0.12248E+00, 0.12475E+00, 0.12703E+00, 0.12929E+00,&
      0.13156E+00, 0.13382E+00, 0.13608E+00, 0.13833E+00, 0.14058E+00,&
      0.14282E+00, 0.14507E+00, 0.14730E+00, 0.14954E+00, 0.15177E+00,&
      0.15399E+00, 0.15622E+00, 0.15844E+00, 0.16065E+00, 0.16286E+00,&
      0.16507E+00, 0.16727E+00, 0.16947E+00, 0.17167E+00, 0.17386E+00/
                             
     DATA (BNC01M (IA),IA=201,300)/                                     &
      0.17605E+00, 0.17823E+00, 0.18041E+00, 0.18259E+00, 0.18476E+00,&
      0.18693E+00, 0.18909E+00, 0.19126E+00, 0.19341E+00, 0.19557E+00,&
      0.19771E+00, 0.19986E+00, 0.20200E+00, 0.20414E+00, 0.20627E+00,&
      0.20840E+00, 0.21053E+00, 0.21265E+00, 0.21476E+00, 0.21688E+00,&
      0.21899E+00, 0.22109E+00, 0.22320E+00, 0.22529E+00, 0.22739E+00,&
      0.22948E+00, 0.23156E+00, 0.23364E+00, 0.23572E+00, 0.23780E+00,&
      0.23987E+00, 0.24193E+00, 0.24400E+00, 0.24606E+00, 0.24811E+00,&
      0.25016E+00, 0.25221E+00, 0.25425E+00, 0.25629E+00, 0.25832E+00,&
      0.26036E+00, 0.26238E+00, 0.26441E+00, 0.26643E+00, 0.26844E+00,&
      0.27045E+00, 0.27246E+00, 0.27447E+00, 0.27647E+00, 0.27846E+00,&
      0.28045E+00, 0.28244E+00, 0.28443E+00, 0.28641E+00, 0.28839E+00,&
      0.29036E+00, 0.29233E+00, 0.29429E+00, 0.29626E+00, 0.29821E+00,&
      0.30017E+00, 0.30212E+00, 0.30406E+00, 0.30601E+00, 0.30794E+00,&
      0.30988E+00, 0.31181E+00, 0.31374E+00, 0.31566E+00, 0.31758E+00,&
      0.31950E+00, 0.32141E+00, 0.32332E+00, 0.32522E+00, 0.32712E+00,&
      0.32902E+00, 0.33092E+00, 0.33281E+00, 0.33469E+00, 0.33657E+00,&
      0.33845E+00, 0.34033E+00, 0.34220E+00, 0.34407E+00, 0.34593E+00,&
      0.34779E+00, 0.34965E+00, 0.35150E+00, 0.35335E+00, 0.35519E+00,&
      0.35704E+00, 0.35887E+00, 0.36071E+00, 0.36254E+00, 0.36437E+00,&
      0.36619E+00, 0.36801E+00, 0.36983E+00, 0.37164E+00, 0.37345E+00/
                             
     DATA (BNC01M (IA),IA=301,400)/                                     &
      0.37526E+00, 0.37706E+00, 0.37886E+00, 0.38065E+00, 0.38244E+00,&
      0.38423E+00, 0.38602E+00, 0.38780E+00, 0.38957E+00, 0.39135E+00,&
      0.39312E+00, 0.39489E+00, 0.39665E+00, 0.39841E+00, 0.40017E+00,&
      0.40192E+00, 0.40367E+00, 0.40541E+00, 0.40716E+00, 0.40890E+00,&
      0.41063E+00, 0.41236E+00, 0.41409E+00, 0.41582E+00, 0.41754E+00,&
      0.41926E+00, 0.42097E+00, 0.42268E+00, 0.42439E+00, 0.42610E+00,&
      0.42780E+00, 0.42950E+00, 0.43119E+00, 0.43288E+00, 0.43457E+00,&
      0.43626E+00, 0.43794E+00, 0.43962E+00, 0.44129E+00, 0.44296E+00,&
      0.44463E+00, 0.44630E+00, 0.44796E+00, 0.44962E+00, 0.45127E+00,&
      0.45292E+00, 0.45457E+00, 0.45622E+00, 0.45786E+00, 0.45950E+00,&
      0.46113E+00, 0.46277E+00, 0.46439E+00, 0.46602E+00, 0.46764E+00,&
      0.46926E+00, 0.47088E+00, 0.47249E+00, 0.47410E+00, 0.47571E+00,&
      0.47731E+00, 0.47891E+00, 0.48051E+00, 0.48211E+00, 0.48370E+00,&
      0.48528E+00, 0.48687E+00, 0.48845E+00, 0.49003E+00, 0.49161E+00,&
      0.49318E+00, 0.49475E+00, 0.49631E+00, 0.49788E+00, 0.49944E+00,&
      0.50099E+00, 0.50255E+00, 0.50410E+00, 0.50565E+00, 0.50719E+00,&
      0.50873E+00, 0.51027E+00, 0.51181E+00, 0.51334E+00, 0.51487E+00,&
      0.51640E+00, 0.51792E+00, 0.51944E+00, 0.52096E+00, 0.52248E+00,&
      0.52399E+00, 0.52550E+00, 0.52700E+00, 0.52851E+00, 0.53001E+00,&
      0.53150E+00, 0.53300E+00, 0.53449E+00, 0.53598E+00, 0.53747E+00/
                             
     DATA (BNC01M (IA),IA=401,500)/                                     &
      0.53895E+00, 0.54043E+00, 0.54191E+00, 0.54338E+00, 0.54485E+00,&
      0.54632E+00, 0.54779E+00, 0.54925E+00, 0.55071E+00, 0.55217E+00,&
      0.55362E+00, 0.55507E+00, 0.55652E+00, 0.55797E+00, 0.55941E+00,&
      0.56085E+00, 0.56229E+00, 0.56372E+00, 0.56515E+00, 0.56658E+00,&
      0.56801E+00, 0.56943E+00, 0.57086E+00, 0.57227E+00, 0.57369E+00,&
      0.57510E+00, 0.57651E+00, 0.57792E+00, 0.57932E+00, 0.58073E+00,&
      0.58213E+00, 0.58352E+00, 0.58492E+00, 0.58631E+00, 0.58770E+00,&
      0.58908E+00, 0.59047E+00, 0.59185E+00, 0.59323E+00, 0.59460E+00,&
      0.59597E+00, 0.59734E+00, 0.59871E+00, 0.60008E+00, 0.60144E+00,&
      0.60280E+00, 0.60415E+00, 0.60551E+00, 0.60686E+00, 0.60821E+00,&
      0.60956E+00, 0.61090E+00, 0.61224E+00, 0.61358E+00, 0.61492E+00,&
      0.61625E+00, 0.61758E+00, 0.61891E+00, 0.62024E+00, 0.62156E+00,&
      0.62288E+00, 0.62420E+00, 0.62552E+00, 0.62683E+00, 0.62815E+00,&
      0.62945E+00, 0.63076E+00, 0.63206E+00, 0.63337E+00, 0.63467E+00,&
      0.63596E+00, 0.63726E+00, 0.63855E+00, 0.63984E+00, 0.64112E+00,&
      0.64241E+00, 0.64369E+00, 0.64497E+00, 0.64625E+00, 0.64752E+00,&
      0.64879E+00, 0.65006E+00, 0.65133E+00, 0.65260E+00, 0.65386E+00,&
      0.65512E+00, 0.65638E+00, 0.65763E+00, 0.65889E+00, 0.66014E+00,&
      0.66139E+00, 0.66263E+00, 0.66388E+00, 0.66512E+00, 0.66636E+00,&
      0.66759E+00, 0.66883E+00, 0.67006E+00, 0.67129E+00, 0.67252E+00/
                             
     DATA (BNC01M (IA),IA=501,600)/                                     &
      0.67374E+00, 0.67497E+00, 0.67619E+00, 0.67741E+00, 0.67862E+00,&
      0.67984E+00, 0.68105E+00, 0.68226E+00, 0.68347E+00, 0.68467E+00,&
      0.68587E+00, 0.68707E+00, 0.68827E+00, 0.68947E+00, 0.69066E+00,&
      0.69185E+00, 0.69304E+00, 0.69423E+00, 0.69542E+00, 0.69660E+00,&
      0.69778E+00, 0.69896E+00, 0.70013E+00, 0.70131E+00, 0.70248E+00,&
      0.70365E+00, 0.70482E+00, 0.70598E+00, 0.70715E+00, 0.70831E+00,&
      0.70947E+00, 0.71062E+00, 0.71178E+00, 0.71293E+00, 0.71408E+00,&
      0.71523E+00, 0.71638E+00, 0.71752E+00, 0.71866E+00, 0.71980E+00,&
      0.72094E+00, 0.72208E+00, 0.72321E+00, 0.72434E+00, 0.72547E+00,&
      0.72660E+00, 0.72772E+00, 0.72885E+00, 0.72997E+00, 0.73109E+00,&
      0.73220E+00, 0.73332E+00, 0.73443E+00, 0.73554E+00, 0.73665E+00,&
      0.73776E+00, 0.73886E+00, 0.73997E+00, 0.74107E+00, 0.74217E+00,&
      0.74326E+00, 0.74436E+00, 0.74545E+00, 0.74654E+00, 0.74763E+00,&
      0.74872E+00, 0.74980E+00, 0.75089E+00, 0.75197E+00, 0.75305E+00,&
      0.75412E+00, 0.75520E+00, 0.75627E+00, 0.75734E+00, 0.75841E+00,&
      0.75948E+00, 0.76055E+00, 0.76161E+00, 0.76267E+00, 0.76373E+00,&
      0.76479E+00, 0.76584E+00, 0.76690E+00, 0.76795E+00, 0.76900E+00,&
      0.77005E+00, 0.77109E+00, 0.77214E+00, 0.77318E+00, 0.77422E+00,&
      0.77526E+00, 0.77630E+00, 0.77733E+00, 0.77836E+00, 0.77940E+00,&
      0.78043E+00, 0.78145E+00, 0.78248E+00, 0.78350E+00, 0.78733E+00/
                             
     DATA (BNC01M (IA),IA=601,700)/                                     &
      0.79565E+00, 0.80557E+00, 0.81531E+00, 0.82489E+00, 0.83429E+00,&
      0.84353E+00, 0.85261E+00, 0.86153E+00, 0.87029E+00, 0.87890E+00,&
      0.88737E+00, 0.89568E+00, 0.90385E+00, 0.91188E+00, 0.91978E+00,&
      0.92754E+00, 0.93516E+00, 0.94265E+00, 0.95002E+00, 0.95726E+00,&
      0.96438E+00, 0.97138E+00, 0.97825E+00, 0.98501E+00, 0.99166E+00,&
      0.99819E+00, 0.10046E+01, 0.10109E+01, 0.10171E+01, 0.10232E+01,&
      0.10292E+01, 0.10351E+01, 0.10409E+01, 0.10466E+01, 0.10522E+01,&
      0.10577E+01, 0.10632E+01, 0.10685E+01, 0.10737E+01, 0.10788E+01,&
      0.10839E+01, 0.10889E+01, 0.10938E+01, 0.10986E+01, 0.11033E+01,&
      0.11079E+01, 0.11125E+01, 0.11169E+01, 0.11213E+01, 0.11257E+01,&
      0.11299E+01, 0.11341E+01, 0.11382E+01, 0.11422E+01, 0.11462E+01,&
      0.11501E+01, 0.11539E+01, 0.11577E+01, 0.11613E+01, 0.11650E+01,&
      0.11685E+01, 0.11720E+01, 0.11754E+01, 0.11788E+01, 0.11821E+01,&
      0.11853E+01, 0.11885E+01, 0.11916E+01, 0.11947E+01, 0.11977E+01,&
      0.12007E+01, 0.12036E+01, 0.12064E+01, 0.12092E+01, 0.12119E+01,&
      0.12146E+01, 0.12172E+01, 0.12198E+01, 0.12223E+01, 0.12248E+01,&
      0.12272E+01, 0.12296E+01, 0.12319E+01, 0.12342E+01, 0.12364E+01,&
      0.12386E+01, 0.12407E+01, 0.12428E+01, 0.12449E+01, 0.12469E+01,&
      0.12488E+01, 0.12507E+01, 0.12526E+01, 0.12544E+01, 0.12562E+01,&
      0.12579E+01, 0.12596E+01, 0.12613E+01, 0.12629E+01, 0.12645E+01/
                             
     DATA (BNC01M(IA),IA=701,741)/                                      &
      0.12660E+01, 0.12675E+01, 0.12690E+01, 0.12704E+01, 0.12718E+01,&
      0.12731E+01, 0.12744E+01, 0.12757E+01, 0.12769E+01, 0.12781E+01,&
      0.12793E+01, 0.12804E+01, 0.12815E+01, 0.12825E+01, 0.12836E+01,&
      0.12846E+01, 0.12855E+01, 0.12864E+01, 0.12873E+01, 0.12882E+01,&
      0.12890E+01, 0.12898E+01, 0.12906E+01, 0.12913E+01, 0.12920E+01,&
      0.12927E+01, 0.12933E+01, 0.12939E+01, 0.12945E+01, 0.12951E+01,&
      0.12956E+01, 0.12961E+01, 0.12966E+01, 0.12970E+01, 0.12974E+01,&
      0.12978E+01, 0.12981E+01, 0.12985E+01, 0.12988E+01, 0.12991E+01,&
      0.12993E+01 /                      
!                            
!  ** Na2SO4                 
!                            
     DATA (BNC02M (IA),IA=  1,100)/                                     &
     -0.11393E+00,-0.20901E+00,-0.27708E+00,-0.32413E+00,-0.36089E+00,&
     -0.39137E+00,-0.41757E+00,-0.44064E+00,-0.46132E+00,-0.48011E+00,&
     -0.49735E+00,-0.51331E+00,-0.52819E+00,-0.54215E+00,-0.55531E+00,&
     -0.56776E+00,-0.57959E+00,-0.59087E+00,-0.60165E+00,-0.61199E+00,&
     -0.62193E+00,-0.63150E+00,-0.64073E+00,-0.64965E+00,-0.65829E+00,&
     -0.66666E+00,-0.67479E+00,-0.68269E+00,-0.69038E+00,-0.69786E+00,&
     -0.70517E+00,-0.71229E+00,-0.71925E+00,-0.72606E+00,-0.73272E+00,&
     -0.73923E+00,-0.74562E+00,-0.75188E+00,-0.75802E+00,-0.76405E+00,&
     -0.76996E+00,-0.77578E+00,-0.78149E+00,-0.78711E+00,-0.79264E+00,&
     -0.79808E+00,-0.80343E+00,-0.80871E+00,-0.81391E+00,-0.81903E+00,&
     -0.82409E+00,-0.82907E+00,-0.83399E+00,-0.83885E+00,-0.84364E+00,&
     -0.84837E+00,-0.85305E+00,-0.85767E+00,-0.86224E+00,-0.86676E+00,&
     -0.87123E+00,-0.87565E+00,-0.88002E+00,-0.88435E+00,-0.88863E+00,&
     -0.89288E+00,-0.89708E+00,-0.90124E+00,-0.90537E+00,-0.90946E+00,&
     -0.91351E+00,-0.91753E+00,-0.92152E+00,-0.92547E+00,-0.92939E+00,&
     -0.93329E+00,-0.93715E+00,-0.94099E+00,-0.94480E+00,-0.94858E+00,&
     -0.95234E+00,-0.95607E+00,-0.95978E+00,-0.96346E+00,-0.96712E+00,&
     -0.97076E+00,-0.97438E+00,-0.97797E+00,-0.98155E+00,-0.98511E+00,&
     -0.98864E+00,-0.99216E+00,-0.99566E+00,-0.99914E+00,-0.10026E+01,&
     -0.10061E+01,-0.10095E+01,-0.10129E+01,-0.10163E+01,-0.10197E+01/
                             
     DATA (BNC02M (IA),IA=101,200)/                                     &
     -0.10230E+01,-0.10264E+01,-0.10297E+01,-0.10330E+01,-0.10363E+01,&
     -0.10396E+01,-0.10429E+01,-0.10462E+01,-0.10494E+01,-0.10526E+01,&
     -0.10559E+01,-0.10591E+01,-0.10623E+01,-0.10654E+01,-0.10686E+01,&
     -0.10718E+01,-0.10749E+01,-0.10780E+01,-0.10812E+01,-0.10843E+01,&
     -0.10873E+01,-0.10904E+01,-0.10935E+01,-0.10965E+01,-0.10996E+01,&
     -0.11026E+01,-0.11056E+01,-0.11087E+01,-0.11117E+01,-0.11147E+01,&
     -0.11176E+01,-0.11206E+01,-0.11236E+01,-0.11265E+01,-0.11295E+01,&
     -0.11324E+01,-0.11353E+01,-0.11382E+01,-0.11411E+01,-0.11440E+01,&
     -0.11469E+01,-0.11497E+01,-0.11526E+01,-0.11555E+01,-0.11583E+01,&
     -0.11611E+01,-0.11640E+01,-0.11668E+01,-0.11696E+01,-0.11724E+01,&
     -0.11752E+01,-0.11779E+01,-0.11807E+01,-0.11835E+01,-0.11862E+01,&
     -0.11890E+01,-0.11917E+01,-0.11945E+01,-0.11972E+01,-0.11999E+01,&
     -0.12026E+01,-0.12053E+01,-0.12080E+01,-0.12107E+01,-0.12134E+01,&
     -0.12160E+01,-0.12187E+01,-0.12214E+01,-0.12240E+01,-0.12267E+01,&
     -0.12293E+01,-0.12319E+01,-0.12346E+01,-0.12372E+01,-0.12398E+01,&
     -0.12424E+01,-0.12450E+01,-0.12476E+01,-0.12502E+01,-0.12528E+01,&
     -0.12553E+01,-0.12579E+01,-0.12605E+01,-0.12630E+01,-0.12656E+01,&
     -0.12681E+01,-0.12707E+01,-0.12732E+01,-0.12757E+01,-0.12782E+01,&
     -0.12807E+01,-0.12833E+01,-0.12858E+01,-0.12883E+01,-0.12908E+01,&
     -0.12932E+01,-0.12957E+01,-0.12982E+01,-0.13007E+01,-0.13032E+01/
                             
     DATA (BNC02M (IA),IA=201,300)/                                     &
     -0.13056E+01,-0.13081E+01,-0.13105E+01,-0.13130E+01,-0.13154E+01,&
     -0.13179E+01,-0.13203E+01,-0.13227E+01,-0.13251E+01,-0.13276E+01,&
     -0.13300E+01,-0.13324E+01,-0.13348E+01,-0.13372E+01,-0.13396E+01,&
     -0.13420E+01,-0.13444E+01,-0.13468E+01,-0.13491E+01,-0.13515E+01,&
     -0.13539E+01,-0.13562E+01,-0.13586E+01,-0.13610E+01,-0.13633E+01,&
     -0.13657E+01,-0.13680E+01,-0.13704E+01,-0.13727E+01,-0.13750E+01,&
     -0.13774E+01,-0.13797E+01,-0.13820E+01,-0.13843E+01,-0.13866E+01,&
     -0.13890E+01,-0.13913E+01,-0.13936E+01,-0.13959E+01,-0.13982E+01,&
     -0.14004E+01,-0.14027E+01,-0.14050E+01,-0.14073E+01,-0.14096E+01,&
     -0.14119E+01,-0.14141E+01,-0.14164E+01,-0.14187E+01,-0.14209E+01,&
     -0.14232E+01,-0.14254E+01,-0.14277E+01,-0.14299E+01,-0.14322E+01,&
     -0.14344E+01,-0.14366E+01,-0.14389E+01,-0.14411E+01,-0.14433E+01,&
     -0.14456E+01,-0.14478E+01,-0.14500E+01,-0.14522E+01,-0.14544E+01,&
     -0.14566E+01,-0.14588E+01,-0.14610E+01,-0.14632E+01,-0.14654E+01,&
     -0.14676E+01,-0.14698E+01,-0.14720E+01,-0.14742E+01,-0.14764E+01,&
     -0.14785E+01,-0.14807E+01,-0.14829E+01,-0.14851E+01,-0.14872E+01,&
     -0.14894E+01,-0.14916E+01,-0.14937E+01,-0.14959E+01,-0.14980E+01,&
     -0.15002E+01,-0.15023E+01,-0.15045E+01,-0.15066E+01,-0.15087E+01,&
     -0.15109E+01,-0.15130E+01,-0.15152E+01,-0.15173E+01,-0.15194E+01,&
     -0.15215E+01,-0.15237E+01,-0.15258E+01,-0.15279E+01,-0.15300E+01/
                             
     DATA (BNC02M (IA),IA=301,400)/                                     &
     -0.15321E+01,-0.15342E+01,-0.15363E+01,-0.15384E+01,-0.15405E+01,&
     -0.15426E+01,-0.15447E+01,-0.15468E+01,-0.15489E+01,-0.15510E+01,&
     -0.15531E+01,-0.15552E+01,-0.15573E+01,-0.15594E+01,-0.15614E+01,&
     -0.15635E+01,-0.15656E+01,-0.15677E+01,-0.15697E+01,-0.15718E+01,&
     -0.15739E+01,-0.15759E+01,-0.15780E+01,-0.15800E+01,-0.15821E+01,&
     -0.15842E+01,-0.15862E+01,-0.15883E+01,-0.15903E+01,-0.15923E+01,&
     -0.15944E+01,-0.15964E+01,-0.15985E+01,-0.16005E+01,-0.16025E+01,&
     -0.16046E+01,-0.16066E+01,-0.16086E+01,-0.16107E+01,-0.16127E+01,&
     -0.16147E+01,-0.16167E+01,-0.16188E+01,-0.16208E+01,-0.16228E+01,&
     -0.16248E+01,-0.16268E+01,-0.16288E+01,-0.16308E+01,-0.16328E+01,&
     -0.16348E+01,-0.16368E+01,-0.16388E+01,-0.16408E+01,-0.16428E+01,&
     -0.16448E+01,-0.16468E+01,-0.16488E+01,-0.16508E+01,-0.16528E+01,&
     -0.16548E+01,-0.16568E+01,-0.16587E+01,-0.16607E+01,-0.16627E+01,&
     -0.16647E+01,-0.16667E+01,-0.16686E+01,-0.16706E+01,-0.16726E+01,&
     -0.16745E+01,-0.16765E+01,-0.16785E+01,-0.16804E+01,-0.16824E+01,&
     -0.16844E+01,-0.16863E+01,-0.16883E+01,-0.16902E+01,-0.16922E+01,&
     -0.16941E+01,-0.16961E+01,-0.16980E+01,-0.17000E+01,-0.17019E+01,&
     -0.17039E+01,-0.17058E+01,-0.17077E+01,-0.17097E+01,-0.17116E+01,&
     -0.17136E+01,-0.17155E+01,-0.17174E+01,-0.17194E+01,-0.17213E+01,&
     -0.17232E+01,-0.17251E+01,-0.17271E+01,-0.17290E+01,-0.17309E+01/
                             
     DATA (BNC02M (IA),IA=401,500)/                                     &
     -0.17328E+01,-0.17347E+01,-0.17367E+01,-0.17386E+01,-0.17405E+01,&
     -0.17424E+01,-0.17443E+01,-0.17462E+01,-0.17481E+01,-0.17500E+01,&
     -0.17519E+01,-0.17538E+01,-0.17557E+01,-0.17576E+01,-0.17595E+01,&
     -0.17614E+01,-0.17633E+01,-0.17652E+01,-0.17671E+01,-0.17690E+01,&
     -0.17709E+01,-0.17728E+01,-0.17747E+01,-0.17766E+01,-0.17785E+01,&
     -0.17804E+01,-0.17822E+01,-0.17841E+01,-0.17860E+01,-0.17879E+01,&
     -0.17898E+01,-0.17916E+01,-0.17935E+01,-0.17954E+01,-0.17973E+01,&
     -0.17991E+01,-0.18010E+01,-0.18029E+01,-0.18047E+01,-0.18066E+01,&
     -0.18085E+01,-0.18103E+01,-0.18122E+01,-0.18140E+01,-0.18159E+01,&
     -0.18178E+01,-0.18196E+01,-0.18215E+01,-0.18233E+01,-0.18252E+01,&
     -0.18270E+01,-0.18289E+01,-0.18307E+01,-0.18326E+01,-0.18344E+01,&
     -0.18363E+01,-0.18381E+01,-0.18400E+01,-0.18418E+01,-0.18437E+01,&
     -0.18455E+01,-0.18473E+01,-0.18492E+01,-0.18510E+01,-0.18528E+01,&
     -0.18547E+01,-0.18565E+01,-0.18583E+01,-0.18602E+01,-0.18620E+01,&
     -0.18638E+01,-0.18657E+01,-0.18675E+01,-0.18693E+01,-0.18711E+01,&
     -0.18730E+01,-0.18748E+01,-0.18766E+01,-0.18784E+01,-0.18802E+01,&
     -0.18821E+01,-0.18839E+01,-0.18857E+01,-0.18875E+01,-0.18893E+01,&
     -0.18911E+01,-0.18929E+01,-0.18948E+01,-0.18966E+01,-0.18984E+01,&
     -0.19002E+01,-0.19020E+01,-0.19038E+01,-0.19056E+01,-0.19074E+01,&
     -0.19092E+01,-0.19110E+01,-0.19128E+01,-0.19146E+01,-0.19164E+01/
                             
     DATA (BNC02M (IA),IA=501,600)/                                     &
     -0.19182E+01,-0.19200E+01,-0.19218E+01,-0.19236E+01,-0.19254E+01,&
     -0.19272E+01,-0.19289E+01,-0.19307E+01,-0.19325E+01,-0.19343E+01,&
     -0.19361E+01,-0.19379E+01,-0.19397E+01,-0.19415E+01,-0.19432E+01,&
     -0.19450E+01,-0.19468E+01,-0.19486E+01,-0.19504E+01,-0.19521E+01,&
     -0.19539E+01,-0.19557E+01,-0.19575E+01,-0.19592E+01,-0.19610E+01,&
     -0.19628E+01,-0.19646E+01,-0.19663E+01,-0.19681E+01,-0.19699E+01,&
     -0.19716E+01,-0.19734E+01,-0.19752E+01,-0.19769E+01,-0.19787E+01,&
     -0.19804E+01,-0.19822E+01,-0.19840E+01,-0.19857E+01,-0.19875E+01,&
     -0.19892E+01,-0.19910E+01,-0.19928E+01,-0.19945E+01,-0.19963E+01,&
     -0.19980E+01,-0.19998E+01,-0.20015E+01,-0.20033E+01,-0.20050E+01,&
     -0.20068E+01,-0.20085E+01,-0.20103E+01,-0.20120E+01,-0.20138E+01,&
     -0.20155E+01,-0.20173E+01,-0.20190E+01,-0.20207E+01,-0.20225E+01,&
     -0.20242E+01,-0.20260E+01,-0.20277E+01,-0.20294E+01,-0.20312E+01,&
     -0.20329E+01,-0.20347E+01,-0.20364E+01,-0.20381E+01,-0.20399E+01,&
     -0.20416E+01,-0.20433E+01,-0.20451E+01,-0.20468E+01,-0.20485E+01,&
     -0.20502E+01,-0.20520E+01,-0.20537E+01,-0.20554E+01,-0.20572E+01,&
     -0.20589E+01,-0.20606E+01,-0.20623E+01,-0.20640E+01,-0.20658E+01,&
     -0.20675E+01,-0.20692E+01,-0.20709E+01,-0.20726E+01,-0.20744E+01,&
     -0.20761E+01,-0.20778E+01,-0.20795E+01,-0.20812E+01,-0.20829E+01,&
     -0.20847E+01,-0.20864E+01,-0.20881E+01,-0.20898E+01,-0.20962E+01/
                             
     DATA (BNC02M (IA),IA=601,700)/                                     &
     -0.21103E+01,-0.21272E+01,-0.21441E+01,-0.21610E+01,-0.21778E+01,&
     -0.21945E+01,-0.22111E+01,-0.22277E+01,-0.22442E+01,-0.22607E+01,&
     -0.22771E+01,-0.22934E+01,-0.23097E+01,-0.23260E+01,-0.23422E+01,&
     -0.23583E+01,-0.23744E+01,-0.23904E+01,-0.24064E+01,-0.24224E+01,&
     -0.24383E+01,-0.24541E+01,-0.24699E+01,-0.24857E+01,-0.25014E+01,&
     -0.25171E+01,-0.25327E+01,-0.25483E+01,-0.25639E+01,-0.25794E+01,&
     -0.25949E+01,-0.26104E+01,-0.26258E+01,-0.26412E+01,-0.26565E+01,&
     -0.26718E+01,-0.26871E+01,-0.27023E+01,-0.27175E+01,-0.27327E+01,&
     -0.27479E+01,-0.27630E+01,-0.27781E+01,-0.27931E+01,-0.28082E+01,&
     -0.28232E+01,-0.28381E+01,-0.28531E+01,-0.28680E+01,-0.28829E+01,&
     -0.28977E+01,-0.29125E+01,-0.29274E+01,-0.29421E+01,-0.29569E+01,&
     -0.29716E+01,-0.29863E+01,-0.30010E+01,-0.30157E+01,-0.30303E+01,&
     -0.30449E+01,-0.30595E+01,-0.30740E+01,-0.30886E+01,-0.31031E+01,&
     -0.31176E+01,-0.31321E+01,-0.31465E+01,-0.31610E+01,-0.31754E+01,&
     -0.31898E+01,-0.32042E+01,-0.32185E+01,-0.32328E+01,-0.32472E+01,&
     -0.32614E+01,-0.32757E+01,-0.32900E+01,-0.33042E+01,-0.33184E+01,&
     -0.33326E+01,-0.33468E+01,-0.33610E+01,-0.33751E+01,-0.33893E+01,&
     -0.34034E+01,-0.34175E+01,-0.34316E+01,-0.34456E+01,-0.34597E+01,&
     -0.34737E+01,-0.34877E+01,-0.35017E+01,-0.35157E+01,-0.35297E+01,&
     -0.35436E+01,-0.35576E+01,-0.35715E+01,-0.35854E+01,-0.35993E+01/
                             
     DATA (BNC02M(IA),IA=701,741)/                                      &
     -0.36132E+01,-0.36270E+01,-0.36409E+01,-0.36547E+01,-0.36685E+01,&
     -0.36823E+01,-0.36961E+01,-0.37099E+01,-0.37237E+01,-0.37374E+01,&
     -0.37512E+01,-0.37649E+01,-0.37786E+01,-0.37923E+01,-0.38060E+01,&
     -0.38197E+01,-0.38333E+01,-0.38470E+01,-0.38606E+01,-0.38743E+01,&
     -0.38879E+01,-0.39015E+01,-0.39151E+01,-0.39286E+01,-0.39422E+01,&
     -0.39558E+01,-0.39693E+01,-0.39828E+01,-0.39964E+01,-0.40099E+01,&
     -0.40234E+01,-0.40369E+01,-0.40503E+01,-0.40638E+01,-0.40773E+01,&
     -0.40907E+01,-0.41041E+01,-0.41176E+01,-0.41310E+01,-0.41444E+01,&
     -0.41578E+01                  /                      
!                            
!  ** NaNO3                  
!                            
     DATA (BNC03M (IA),IA=  1,100)/                                     &
     -0.57178E-01,-0.10530E+00,-0.14005E+00,-0.16425E+00,-0.18329E+00,&
     -0.19916E+00,-0.21288E+00,-0.22502E+00,-0.23595E+00,-0.24593E+00,&
     -0.25513E+00,-0.26368E+00,-0.27167E+00,-0.27920E+00,-0.28633E+00,&
     -0.29309E+00,-0.29954E+00,-0.30570E+00,-0.31162E+00,-0.31730E+00,&
     -0.32278E+00,-0.32807E+00,-0.33318E+00,-0.33813E+00,-0.34294E+00,&
     -0.34761E+00,-0.35215E+00,-0.35657E+00,-0.36088E+00,-0.36509E+00,&
     -0.36920E+00,-0.37322E+00,-0.37715E+00,-0.38099E+00,-0.38476E+00,&
     -0.38845E+00,-0.39207E+00,-0.39563E+00,-0.39912E+00,-0.40255E+00,&
     -0.40592E+00,-0.40923E+00,-0.41249E+00,-0.41570E+00,-0.41885E+00,&
     -0.42196E+00,-0.42503E+00,-0.42805E+00,-0.43102E+00,-0.43396E+00,&
     -0.43685E+00,-0.43971E+00,-0.44253E+00,-0.44532E+00,-0.44807E+00,&
     -0.45079E+00,-0.45347E+00,-0.45613E+00,-0.45875E+00,-0.46135E+00,&
     -0.46392E+00,-0.46647E+00,-0.46898E+00,-0.47148E+00,-0.47394E+00,&
     -0.47639E+00,-0.47881E+00,-0.48121E+00,-0.48360E+00,-0.48596E+00,&
     -0.48830E+00,-0.49062E+00,-0.49293E+00,-0.49522E+00,-0.49749E+00,&
     -0.49975E+00,-0.50199E+00,-0.50421E+00,-0.50642E+00,-0.50862E+00,&
     -0.51081E+00,-0.51298E+00,-0.51514E+00,-0.51729E+00,-0.51942E+00,&
     -0.52154E+00,-0.52366E+00,-0.52576E+00,-0.52785E+00,-0.52994E+00,&
     -0.53201E+00,-0.53407E+00,-0.53613E+00,-0.53817E+00,-0.54021E+00,&
     -0.54224E+00,-0.54426E+00,-0.54627E+00,-0.54827E+00,-0.55026E+00/
                             
     DATA (BNC03M (IA),IA=101,200)/                                     &
     -0.55225E+00,-0.55423E+00,-0.55620E+00,-0.55817E+00,-0.56012E+00,&
     -0.56207E+00,-0.56401E+00,-0.56595E+00,-0.56787E+00,-0.56979E+00,&
     -0.57171E+00,-0.57361E+00,-0.57551E+00,-0.57740E+00,-0.57929E+00,&
     -0.58116E+00,-0.58304E+00,-0.58490E+00,-0.58676E+00,-0.58861E+00,&
     -0.59039E+00,-0.59224E+00,-0.59407E+00,-0.59590E+00,-0.59772E+00,&
     -0.59954E+00,-0.60135E+00,-0.60315E+00,-0.60494E+00,-0.60673E+00,&
     -0.60851E+00,-0.61029E+00,-0.61206E+00,-0.61382E+00,-0.61558E+00,&
     -0.61733E+00,-0.61907E+00,-0.62081E+00,-0.62254E+00,-0.62427E+00,&
     -0.62599E+00,-0.62770E+00,-0.62941E+00,-0.63111E+00,-0.63281E+00,&
     -0.63450E+00,-0.63619E+00,-0.63787E+00,-0.63955E+00,-0.64122E+00,&
     -0.64289E+00,-0.64455E+00,-0.64620E+00,-0.64785E+00,-0.64950E+00,&
     -0.65114E+00,-0.65278E+00,-0.65441E+00,-0.65603E+00,-0.65766E+00,&
     -0.65927E+00,-0.66089E+00,-0.66250E+00,-0.66410E+00,-0.66570E+00,&
     -0.66729E+00,-0.66888E+00,-0.67047E+00,-0.67205E+00,-0.67363E+00,&
     -0.67520E+00,-0.67677E+00,-0.67834E+00,-0.67990E+00,-0.68146E+00,&
     -0.68301E+00,-0.68456E+00,-0.68610E+00,-0.68765E+00,-0.68918E+00,&
     -0.69072E+00,-0.69225E+00,-0.69377E+00,-0.69530E+00,-0.69682E+00,&
     -0.69833E+00,-0.69984E+00,-0.70135E+00,-0.70285E+00,-0.70436E+00,&
     -0.70585E+00,-0.70735E+00,-0.70884E+00,-0.71032E+00,-0.71181E+00,&
     -0.71329E+00,-0.71477E+00,-0.71624E+00,-0.71771E+00,-0.71918E+00/
                             
     DATA (BNC03M (IA),IA=201,300)/                                     &
     -0.72064E+00,-0.72210E+00,-0.72356E+00,-0.72501E+00,-0.72647E+00,&
     -0.72791E+00,-0.72936E+00,-0.73080E+00,-0.73224E+00,-0.73368E+00,&
     -0.73511E+00,-0.73654E+00,-0.73797E+00,-0.73939E+00,-0.74082E+00,&
     -0.74223E+00,-0.74365E+00,-0.74506E+00,-0.74647E+00,-0.74788E+00,&
     -0.74929E+00,-0.75069E+00,-0.75209E+00,-0.75348E+00,-0.75488E+00,&
     -0.75627E+00,-0.75766E+00,-0.75905E+00,-0.76043E+00,-0.76181E+00,&
     -0.76319E+00,-0.76456E+00,-0.76594E+00,-0.76731E+00,-0.76868E+00,&
     -0.77004E+00,-0.77141E+00,-0.77277E+00,-0.77413E+00,-0.77548E+00,&
     -0.77684E+00,-0.77819E+00,-0.77954E+00,-0.78088E+00,-0.78223E+00,&
     -0.78357E+00,-0.78491E+00,-0.78625E+00,-0.78758E+00,-0.78892E+00,&
     -0.79025E+00,-0.79158E+00,-0.79290E+00,-0.79423E+00,-0.79555E+00,&
     -0.79687E+00,-0.79819E+00,-0.79950E+00,-0.80081E+00,-0.80213E+00,&
     -0.80344E+00,-0.80474E+00,-0.80605E+00,-0.80735E+00,-0.80865E+00,&
     -0.80995E+00,-0.81125E+00,-0.81254E+00,-0.81384E+00,-0.81513E+00,&
     -0.81642E+00,-0.81770E+00,-0.81899E+00,-0.82027E+00,-0.82155E+00,&
     -0.82283E+00,-0.82411E+00,-0.82539E+00,-0.82666E+00,-0.82793E+00,&
     -0.82920E+00,-0.83047E+00,-0.83173E+00,-0.83300E+00,-0.83426E+00,&
     -0.83552E+00,-0.83678E+00,-0.83804E+00,-0.83929E+00,-0.84055E+00,&
     -0.84180E+00,-0.84305E+00,-0.84430E+00,-0.84555E+00,-0.84679E+00,&
     -0.84803E+00,-0.84928E+00,-0.85052E+00,-0.85175E+00,-0.85299E+00/
                             
     DATA (BNC03M (IA),IA=301,400)/                                     &
     -0.85423E+00,-0.85546E+00,-0.85669E+00,-0.85792E+00,-0.85915E+00,&
     -0.86038E+00,-0.86160E+00,-0.86282E+00,-0.86405E+00,-0.86527E+00,&
     -0.86648E+00,-0.86770E+00,-0.86892E+00,-0.87013E+00,-0.87134E+00,&
     -0.87256E+00,-0.87377E+00,-0.87497E+00,-0.87618E+00,-0.87738E+00,&
     -0.87859E+00,-0.87979E+00,-0.88099E+00,-0.88219E+00,-0.88339E+00,&
     -0.88458E+00,-0.88578E+00,-0.88697E+00,-0.88816E+00,-0.88935E+00,&
     -0.89054E+00,-0.89173E+00,-0.89292E+00,-0.89410E+00,-0.89528E+00,&
     -0.89647E+00,-0.89765E+00,-0.89883E+00,-0.90000E+00,-0.90118E+00,&
     -0.90236E+00,-0.90353E+00,-0.90470E+00,-0.90587E+00,-0.90704E+00,&
     -0.90821E+00,-0.90938E+00,-0.91054E+00,-0.91171E+00,-0.91287E+00,&
     -0.91403E+00,-0.91519E+00,-0.91635E+00,-0.91751E+00,-0.91867E+00,&
     -0.91982E+00,-0.92098E+00,-0.92213E+00,-0.92328E+00,-0.92443E+00,&
     -0.92558E+00,-0.92673E+00,-0.92788E+00,-0.92902E+00,-0.93017E+00,&
     -0.93131E+00,-0.93245E+00,-0.93359E+00,-0.93473E+00,-0.93587E+00,&
     -0.93701E+00,-0.93815E+00,-0.93928E+00,-0.94041E+00,-0.94155E+00,&
     -0.94268E+00,-0.94381E+00,-0.94494E+00,-0.94607E+00,-0.94719E+00,&
     -0.94832E+00,-0.94944E+00,-0.95057E+00,-0.95169E+00,-0.95281E+00,&
     -0.95393E+00,-0.95505E+00,-0.95617E+00,-0.95729E+00,-0.95840E+00,&
     -0.95952E+00,-0.96063E+00,-0.96174E+00,-0.96285E+00,-0.96396E+00,&
     -0.96507E+00,-0.96618E+00,-0.96729E+00,-0.96840E+00,-0.96950E+00/
                             
     DATA (BNC03M (IA),IA=401,500)/                                     &
     -0.97061E+00,-0.97171E+00,-0.97281E+00,-0.97391E+00,-0.97501E+00,&
     -0.97611E+00,-0.97721E+00,-0.97831E+00,-0.97940E+00,-0.98050E+00,&
     -0.98159E+00,-0.98268E+00,-0.98378E+00,-0.98487E+00,-0.98596E+00,&
     -0.98705E+00,-0.98813E+00,-0.98922E+00,-0.99031E+00,-0.99139E+00,&
     -0.99248E+00,-0.99356E+00,-0.99464E+00,-0.99572E+00,-0.99681E+00,&
     -0.99788E+00,-0.99896E+00,-0.10000E+01,-0.10011E+01,-0.10022E+01,&
     -0.10033E+01,-0.10043E+01,-0.10054E+01,-0.10065E+01,-0.10076E+01,&
     -0.10086E+01,-0.10097E+01,-0.10108E+01,-0.10118E+01,-0.10129E+01,&
     -0.10140E+01,-0.10150E+01,-0.10161E+01,-0.10172E+01,-0.10182E+01,&
     -0.10193E+01,-0.10203E+01,-0.10214E+01,-0.10225E+01,-0.10235E+01,&
     -0.10246E+01,-0.10256E+01,-0.10267E+01,-0.10277E+01,-0.10288E+01,&
     -0.10299E+01,-0.10309E+01,-0.10320E+01,-0.10330E+01,-0.10341E+01,&
     -0.10351E+01,-0.10362E+01,-0.10372E+01,-0.10382E+01,-0.10393E+01,&
     -0.10403E+01,-0.10414E+01,-0.10424E+01,-0.10435E+01,-0.10445E+01,&
     -0.10455E+01,-0.10466E+01,-0.10476E+01,-0.10487E+01,-0.10497E+01,&
     -0.10507E+01,-0.10518E+01,-0.10528E+01,-0.10538E+01,-0.10549E+01,&
     -0.10559E+01,-0.10569E+01,-0.10580E+01,-0.10590E+01,-0.10600E+01,&
     -0.10611E+01,-0.10621E+01,-0.10631E+01,-0.10642E+01,-0.10652E+01,&
     -0.10662E+01,-0.10672E+01,-0.10683E+01,-0.10693E+01,-0.10703E+01,&
     -0.10713E+01,-0.10723E+01,-0.10734E+01,-0.10744E+01,-0.10754E+01/
                             
     DATA (BNC03M (IA),IA=501,600)/                                     &
     -0.10764E+01,-0.10774E+01,-0.10785E+01,-0.10795E+01,-0.10805E+01,&
     -0.10815E+01,-0.10825E+01,-0.10835E+01,-0.10845E+01,-0.10855E+01,&
     -0.10866E+01,-0.10876E+01,-0.10886E+01,-0.10896E+01,-0.10906E+01,&
     -0.10916E+01,-0.10926E+01,-0.10936E+01,-0.10946E+01,-0.10956E+01,&
     -0.10966E+01,-0.10976E+01,-0.10986E+01,-0.10996E+01,-0.11006E+01,&
     -0.11016E+01,-0.11026E+01,-0.11036E+01,-0.11046E+01,-0.11056E+01,&
     -0.11066E+01,-0.11076E+01,-0.11086E+01,-0.11096E+01,-0.11106E+01,&
     -0.11116E+01,-0.11126E+01,-0.11136E+01,-0.11146E+01,-0.11156E+01,&
     -0.11166E+01,-0.11176E+01,-0.11186E+01,-0.11196E+01,-0.11205E+01,&
     -0.11215E+01,-0.11225E+01,-0.11235E+01,-0.11245E+01,-0.11255E+01,&
     -0.11265E+01,-0.11274E+01,-0.11284E+01,-0.11294E+01,-0.11304E+01,&
     -0.11314E+01,-0.11324E+01,-0.11333E+01,-0.11343E+01,-0.11353E+01,&
     -0.11363E+01,-0.11373E+01,-0.11382E+01,-0.11392E+01,-0.11402E+01,&
     -0.11412E+01,-0.11421E+01,-0.11431E+01,-0.11441E+01,-0.11451E+01,&
     -0.11460E+01,-0.11470E+01,-0.11480E+01,-0.11490E+01,-0.11499E+01,&
     -0.11509E+01,-0.11519E+01,-0.11528E+01,-0.11538E+01,-0.11548E+01,&
     -0.11557E+01,-0.11567E+01,-0.11577E+01,-0.11586E+01,-0.11596E+01,&
     -0.11606E+01,-0.11615E+01,-0.11625E+01,-0.11635E+01,-0.11644E+01,&
     -0.11654E+01,-0.11663E+01,-0.11673E+01,-0.11683E+01,-0.11692E+01,&
     -0.11702E+01,-0.11711E+01,-0.11721E+01,-0.11731E+01,-0.11766E+01/
                             
     DATA (BNC03M (IA),IA=601,700)/                                     &
     -0.11845E+01,-0.11940E+01,-0.12034E+01,-0.12128E+01,-0.12222E+01,&
     -0.12315E+01,-0.12407E+01,-0.12499E+01,-0.12591E+01,-0.12682E+01,&
     -0.12773E+01,-0.12863E+01,-0.12953E+01,-0.13043E+01,-0.13132E+01,&
     -0.13221E+01,-0.13310E+01,-0.13398E+01,-0.13486E+01,-0.13573E+01,&
     -0.13660E+01,-0.13747E+01,-0.13834E+01,-0.13920E+01,-0.14006E+01,&
     -0.14092E+01,-0.14177E+01,-0.14262E+01,-0.14347E+01,-0.14432E+01,&
     -0.14516E+01,-0.14600E+01,-0.14684E+01,-0.14768E+01,-0.14851E+01,&
     -0.14934E+01,-0.15017E+01,-0.15099E+01,-0.15182E+01,-0.15264E+01,&
     -0.15346E+01,-0.15427E+01,-0.15509E+01,-0.15590E+01,-0.15671E+01,&
     -0.15752E+01,-0.15833E+01,-0.15913E+01,-0.15993E+01,-0.16073E+01,&
     -0.16153E+01,-0.16233E+01,-0.16313E+01,-0.16392E+01,-0.16471E+01,&
     -0.16550E+01,-0.16629E+01,-0.16707E+01,-0.16786E+01,-0.16864E+01,&
     -0.16942E+01,-0.17020E+01,-0.17098E+01,-0.17176E+01,-0.17253E+01,&
     -0.17331E+01,-0.17408E+01,-0.17485E+01,-0.17562E+01,-0.17639E+01,&
     -0.17715E+01,-0.17792E+01,-0.17868E+01,-0.17944E+01,-0.18021E+01,&
     -0.18096E+01,-0.18172E+01,-0.18248E+01,-0.18324E+01,-0.18399E+01,&
     -0.18474E+01,-0.18550E+01,-0.18625E+01,-0.18700E+01,-0.18774E+01,&
     -0.18849E+01,-0.18924E+01,-0.18998E+01,-0.19073E+01,-0.19147E+01,&
     -0.19221E+01,-0.19295E+01,-0.19369E+01,-0.19443E+01,-0.19516E+01,&
     -0.19590E+01,-0.19664E+01,-0.19737E+01,-0.19810E+01,-0.19883E+01/
                             
     DATA (BNC03M(IA),IA=701,741)/                                      &
     -0.19957E+01,-0.20030E+01,-0.20102E+01,-0.20175E+01,-0.20248E+01,&
     -0.20321E+01,-0.20393E+01,-0.20466E+01,-0.20538E+01,-0.20610E+01,&
     -0.20682E+01,-0.20754E+01,-0.20826E+01,-0.20898E+01,-0.20970E+01,&
     -0.21042E+01,-0.21113E+01,-0.21185E+01,-0.21256E+01,-0.21328E+01,&
     -0.21399E+01,-0.21470E+01,-0.21542E+01,-0.21613E+01,-0.21684E+01,&
     -0.21754E+01,-0.21825E+01,-0.21896E+01,-0.21967E+01,-0.22037E+01,&
     -0.22108E+01,-0.22178E+01,-0.22249E+01,-0.22319E+01,-0.22389E+01,&
     -0.22459E+01,-0.22530E+01,-0.22600E+01,-0.22670E+01,-0.22739E+01,&
     -0.22809E+01                  /                      
!                            
!  ** (NH4)2SO4              
!                            
     DATA (BNC04M (IA),IA=  1,100)/                                     &
     -0.11406E+00,-0.20949E+00,-0.27798E+00,-0.32543E+00,-0.36258E+00,&
     -0.39344E+00,-0.42000E+00,-0.44344E+00,-0.46447E+00,-0.48360E+00,&
     -0.50119E+00,-0.51749E+00,-0.53270E+00,-0.54698E+00,-0.56046E+00,&
     -0.57323E+00,-0.58538E+00,-0.59697E+00,-0.60807E+00,-0.61871E+00,&
     -0.62895E+00,-0.63882E+00,-0.64835E+00,-0.65756E+00,-0.66649E+00,&
     -0.67515E+00,-0.68356E+00,-0.69174E+00,-0.69971E+00,-0.70747E+00,&
     -0.71505E+00,-0.72244E+00,-0.72967E+00,-0.73674E+00,-0.74366E+00,&
     -0.75044E+00,-0.75708E+00,-0.76359E+00,-0.76998E+00,-0.77626E+00,&
     -0.78242E+00,-0.78847E+00,-0.79443E+00,-0.80028E+00,-0.80605E+00,&
     -0.81172E+00,-0.81731E+00,-0.82281E+00,-0.82823E+00,-0.83358E+00,&
     -0.83886E+00,-0.84406E+00,-0.84919E+00,-0.85426E+00,-0.85927E+00,&
     -0.86421E+00,-0.86910E+00,-0.87392E+00,-0.87870E+00,-0.88342E+00,&
     -0.88808E+00,-0.89270E+00,-0.89727E+00,-0.90180E+00,-0.90628E+00,&
     -0.91072E+00,-0.91511E+00,-0.91947E+00,-0.92378E+00,-0.92806E+00,&
     -0.93230E+00,-0.93651E+00,-0.94069E+00,-0.94483E+00,-0.94894E+00,&
     -0.95301E+00,-0.95706E+00,-0.96108E+00,-0.96508E+00,-0.96904E+00,&
     -0.97298E+00,-0.97690E+00,-0.98079E+00,-0.98466E+00,-0.98850E+00,&
     -0.99232E+00,-0.99612E+00,-0.99990E+00,-0.10037E+01,-0.10074E+01,&
     -0.10111E+01,-0.10148E+01,-0.10185E+01,-0.10222E+01,-0.10258E+01,&
     -0.10294E+01,-0.10331E+01,-0.10366E+01,-0.10402E+01,-0.10438E+01/
                             
     DATA (BNC04M (IA),IA=101,200)/                                     &
     -0.10473E+01,-0.10509E+01,-0.10544E+01,-0.10579E+01,-0.10614E+01,&
     -0.10648E+01,-0.10683E+01,-0.10718E+01,-0.10752E+01,-0.10786E+01,&
     -0.10820E+01,-0.10854E+01,-0.10888E+01,-0.10921E+01,-0.10955E+01,&
     -0.10988E+01,-0.11021E+01,-0.11054E+01,-0.11087E+01,-0.11120E+01,&
     -0.11152E+01,-0.11185E+01,-0.11217E+01,-0.11250E+01,-0.11282E+01,&
     -0.11314E+01,-0.11346E+01,-0.11378E+01,-0.11410E+01,-0.11442E+01,&
     -0.11473E+01,-0.11505E+01,-0.11536E+01,-0.11567E+01,-0.11598E+01,&
     -0.11629E+01,-0.11660E+01,-0.11691E+01,-0.11722E+01,-0.11752E+01,&
     -0.11783E+01,-0.11813E+01,-0.11844E+01,-0.11874E+01,-0.11904E+01,&
     -0.11934E+01,-0.11964E+01,-0.11994E+01,-0.12023E+01,-0.12053E+01,&
     -0.12082E+01,-0.12112E+01,-0.12141E+01,-0.12171E+01,-0.12200E+01,&
     -0.12229E+01,-0.12258E+01,-0.12287E+01,-0.12316E+01,-0.12344E+01,&
     -0.12373E+01,-0.12402E+01,-0.12430E+01,-0.12459E+01,-0.12487E+01,&
     -0.12515E+01,-0.12544E+01,-0.12572E+01,-0.12600E+01,-0.12628E+01,&
     -0.12656E+01,-0.12683E+01,-0.12711E+01,-0.12739E+01,-0.12767E+01,&
     -0.12794E+01,-0.12822E+01,-0.12849E+01,-0.12876E+01,-0.12904E+01,&
     -0.12931E+01,-0.12958E+01,-0.12985E+01,-0.13012E+01,-0.13039E+01,&
     -0.13066E+01,-0.13093E+01,-0.13120E+01,-0.13147E+01,-0.13173E+01,&
     -0.13200E+01,-0.13226E+01,-0.13253E+01,-0.13279E+01,-0.13306E+01,&
     -0.13332E+01,-0.13358E+01,-0.13385E+01,-0.13411E+01,-0.13437E+01/
                             
     DATA (BNC04M (IA),IA=201,300)/                                     &
     -0.13463E+01,-0.13489E+01,-0.13515E+01,-0.13541E+01,-0.13567E+01,&
     -0.13592E+01,-0.13618E+01,-0.13644E+01,-0.13669E+01,-0.13695E+01,&
     -0.13720E+01,-0.13746E+01,-0.13771E+01,-0.13797E+01,-0.13822E+01,&
     -0.13847E+01,-0.13873E+01,-0.13898E+01,-0.13923E+01,-0.13948E+01,&
     -0.13973E+01,-0.13998E+01,-0.14023E+01,-0.14048E+01,-0.14073E+01,&
     -0.14098E+01,-0.14122E+01,-0.14147E+01,-0.14172E+01,-0.14196E+01,&
     -0.14221E+01,-0.14245E+01,-0.14270E+01,-0.14294E+01,-0.14319E+01,&
     -0.14343E+01,-0.14368E+01,-0.14392E+01,-0.14416E+01,-0.14440E+01,&
     -0.14465E+01,-0.14489E+01,-0.14513E+01,-0.14537E+01,-0.14561E+01,&
     -0.14585E+01,-0.14609E+01,-0.14633E+01,-0.14657E+01,-0.14681E+01,&
     -0.14704E+01,-0.14728E+01,-0.14752E+01,-0.14776E+01,-0.14799E+01,&
     -0.14823E+01,-0.14846E+01,-0.14870E+01,-0.14893E+01,-0.14917E+01,&
     -0.14940E+01,-0.14964E+01,-0.14987E+01,-0.15011E+01,-0.15034E+01,&
     -0.15057E+01,-0.15080E+01,-0.15104E+01,-0.15127E+01,-0.15150E+01,&
     -0.15173E+01,-0.15196E+01,-0.15219E+01,-0.15242E+01,-0.15265E+01,&
     -0.15288E+01,-0.15311E+01,-0.15334E+01,-0.15357E+01,-0.15380E+01,&
     -0.15402E+01,-0.15425E+01,-0.15448E+01,-0.15471E+01,-0.15493E+01,&
     -0.15516E+01,-0.15538E+01,-0.15561E+01,-0.15584E+01,-0.15606E+01,&
     -0.15629E+01,-0.15651E+01,-0.15674E+01,-0.15696E+01,-0.15718E+01,&
     -0.15741E+01,-0.15763E+01,-0.15785E+01,-0.15808E+01,-0.15830E+01/
                             
     DATA (BNC04M (IA),IA=301,400)/                                     &
     -0.15852E+01,-0.15874E+01,-0.15896E+01,-0.15919E+01,-0.15941E+01,&
     -0.15963E+01,-0.15985E+01,-0.16007E+01,-0.16029E+01,-0.16051E+01,&
     -0.16073E+01,-0.16095E+01,-0.16117E+01,-0.16138E+01,-0.16160E+01,&
     -0.16182E+01,-0.16204E+01,-0.16226E+01,-0.16247E+01,-0.16269E+01,&
     -0.16291E+01,-0.16313E+01,-0.16334E+01,-0.16356E+01,-0.16377E+01,&
     -0.16399E+01,-0.16421E+01,-0.16442E+01,-0.16464E+01,-0.16485E+01,&
     -0.16507E+01,-0.16528E+01,-0.16549E+01,-0.16571E+01,-0.16592E+01,&
     -0.16614E+01,-0.16635E+01,-0.16656E+01,-0.16678E+01,-0.16699E+01,&
     -0.16720E+01,-0.16741E+01,-0.16762E+01,-0.16784E+01,-0.16805E+01,&
     -0.16826E+01,-0.16847E+01,-0.16868E+01,-0.16889E+01,-0.16910E+01,&
     -0.16931E+01,-0.16952E+01,-0.16973E+01,-0.16994E+01,-0.17015E+01,&
     -0.17036E+01,-0.17057E+01,-0.17078E+01,-0.17099E+01,-0.17120E+01,&
     -0.17140E+01,-0.17161E+01,-0.17182E+01,-0.17203E+01,-0.17223E+01,&
     -0.17244E+01,-0.17265E+01,-0.17286E+01,-0.17306E+01,-0.17327E+01,&
     -0.17348E+01,-0.17368E+01,-0.17389E+01,-0.17409E+01,-0.17430E+01,&
     -0.17450E+01,-0.17471E+01,-0.17491E+01,-0.17512E+01,-0.17532E+01,&
     -0.17553E+01,-0.17573E+01,-0.17594E+01,-0.17614E+01,-0.17634E+01,&
     -0.17655E+01,-0.17675E+01,-0.17695E+01,-0.17716E+01,-0.17736E+01,&
     -0.17756E+01,-0.17776E+01,-0.17797E+01,-0.17817E+01,-0.17837E+01,&
     -0.17857E+01,-0.17877E+01,-0.17898E+01,-0.17918E+01,-0.17938E+01/
                             
     DATA (BNC04M (IA),IA=401,500)/                                     &
     -0.17958E+01,-0.17978E+01,-0.17998E+01,-0.18018E+01,-0.18038E+01,&
     -0.18058E+01,-0.18078E+01,-0.18098E+01,-0.18118E+01,-0.18138E+01,&
     -0.18158E+01,-0.18178E+01,-0.18198E+01,-0.18218E+01,-0.18238E+01,&
     -0.18257E+01,-0.18277E+01,-0.18297E+01,-0.18317E+01,-0.18337E+01,&
     -0.18356E+01,-0.18376E+01,-0.18396E+01,-0.18416E+01,-0.18435E+01,&
     -0.18455E+01,-0.18475E+01,-0.18494E+01,-0.18514E+01,-0.18534E+01,&
     -0.18553E+01,-0.18573E+01,-0.18593E+01,-0.18612E+01,-0.18632E+01,&
     -0.18651E+01,-0.18671E+01,-0.18690E+01,-0.18710E+01,-0.18729E+01,&
     -0.18749E+01,-0.18768E+01,-0.18788E+01,-0.18807E+01,-0.18827E+01,&
     -0.18846E+01,-0.18865E+01,-0.18885E+01,-0.18904E+01,-0.18923E+01,&
     -0.18943E+01,-0.18962E+01,-0.18981E+01,-0.19001E+01,-0.19020E+01,&
     -0.19039E+01,-0.19058E+01,-0.19078E+01,-0.19097E+01,-0.19116E+01,&
     -0.19135E+01,-0.19155E+01,-0.19174E+01,-0.19193E+01,-0.19212E+01,&
     -0.19231E+01,-0.19250E+01,-0.19269E+01,-0.19289E+01,-0.19308E+01,&
     -0.19327E+01,-0.19346E+01,-0.19365E+01,-0.19384E+01,-0.19403E+01,&
     -0.19422E+01,-0.19441E+01,-0.19460E+01,-0.19479E+01,-0.19498E+01,&
     -0.19517E+01,-0.19536E+01,-0.19555E+01,-0.19574E+01,-0.19592E+01,&
     -0.19611E+01,-0.19630E+01,-0.19649E+01,-0.19668E+01,-0.19687E+01,&
     -0.19706E+01,-0.19724E+01,-0.19743E+01,-0.19762E+01,-0.19781E+01,&
     -0.19800E+01,-0.19818E+01,-0.19837E+01,-0.19856E+01,-0.19875E+01/
                             
     DATA (BNC04M (IA),IA=501,600)/                                     &
     -0.19893E+01,-0.19912E+01,-0.19931E+01,-0.19949E+01,-0.19968E+01,&
     -0.19987E+01,-0.20005E+01,-0.20024E+01,-0.20043E+01,-0.20061E+01,&
     -0.20080E+01,-0.20098E+01,-0.20117E+01,-0.20136E+01,-0.20154E+01,&
     -0.20173E+01,-0.20191E+01,-0.20210E+01,-0.20228E+01,-0.20247E+01,&
     -0.20265E+01,-0.20284E+01,-0.20302E+01,-0.20321E+01,-0.20339E+01,&
     -0.20358E+01,-0.20376E+01,-0.20394E+01,-0.20413E+01,-0.20431E+01,&
     -0.20450E+01,-0.20468E+01,-0.20486E+01,-0.20505E+01,-0.20523E+01,&
     -0.20541E+01,-0.20560E+01,-0.20578E+01,-0.20596E+01,-0.20615E+01,&
     -0.20633E+01,-0.20651E+01,-0.20669E+01,-0.20688E+01,-0.20706E+01,&
     -0.20724E+01,-0.20742E+01,-0.20761E+01,-0.20779E+01,-0.20797E+01,&
     -0.20815E+01,-0.20833E+01,-0.20852E+01,-0.20870E+01,-0.20888E+01,&
     -0.20906E+01,-0.20924E+01,-0.20942E+01,-0.20960E+01,-0.20979E+01,&
     -0.20997E+01,-0.21015E+01,-0.21033E+01,-0.21051E+01,-0.21069E+01,&
     -0.21087E+01,-0.21105E+01,-0.21123E+01,-0.21141E+01,-0.21159E+01,&
     -0.21177E+01,-0.21195E+01,-0.21213E+01,-0.21231E+01,-0.21249E+01,&
     -0.21267E+01,-0.21285E+01,-0.21303E+01,-0.21321E+01,-0.21339E+01,&
     -0.21356E+01,-0.21374E+01,-0.21392E+01,-0.21410E+01,-0.21428E+01,&
     -0.21446E+01,-0.21464E+01,-0.21482E+01,-0.21499E+01,-0.21517E+01,&
     -0.21535E+01,-0.21553E+01,-0.21571E+01,-0.21588E+01,-0.21606E+01,&
     -0.21624E+01,-0.21642E+01,-0.21660E+01,-0.21677E+01,-0.21744E+01/
                             
     DATA (BNC04M (IA),IA=601,700)/                                     &
     -0.21890E+01,-0.22066E+01,-0.22241E+01,-0.22416E+01,-0.22589E+01,&
     -0.22762E+01,-0.22935E+01,-0.23106E+01,-0.23277E+01,-0.23448E+01,&
     -0.23617E+01,-0.23786E+01,-0.23955E+01,-0.24122E+01,-0.24290E+01,&
     -0.24456E+01,-0.24622E+01,-0.24788E+01,-0.24953E+01,-0.25117E+01,&
     -0.25281E+01,-0.25445E+01,-0.25608E+01,-0.25770E+01,-0.25932E+01,&
     -0.26094E+01,-0.26255E+01,-0.26415E+01,-0.26575E+01,-0.26735E+01,&
     -0.26894E+01,-0.27053E+01,-0.27212E+01,-0.27370E+01,-0.27528E+01,&
     -0.27685E+01,-0.27842E+01,-0.27998E+01,-0.28155E+01,-0.28310E+01,&
     -0.28466E+01,-0.28621E+01,-0.28776E+01,-0.28930E+01,-0.29084E+01,&
     -0.29238E+01,-0.29392E+01,-0.29545E+01,-0.29698E+01,-0.29850E+01,&
     -0.30002E+01,-0.30154E+01,-0.30306E+01,-0.30457E+01,-0.30608E+01,&
     -0.30759E+01,-0.30910E+01,-0.31060E+01,-0.31210E+01,-0.31360E+01,&
     -0.31509E+01,-0.31658E+01,-0.31807E+01,-0.31956E+01,-0.32104E+01,&
     -0.32252E+01,-0.32400E+01,-0.32548E+01,-0.32696E+01,-0.32843E+01,&
     -0.32990E+01,-0.33137E+01,-0.33283E+01,-0.33430E+01,-0.33576E+01,&
     -0.33722E+01,-0.33867E+01,-0.34013E+01,-0.34158E+01,-0.34303E+01,&
     -0.34448E+01,-0.34593E+01,-0.34737E+01,-0.34882E+01,-0.35026E+01,&
     -0.35170E+01,-0.35313E+01,-0.35457E+01,-0.35600E+01,-0.35743E+01,&
     -0.35886E+01,-0.36029E+01,-0.36172E+01,-0.36314E+01,-0.36456E+01,&
     -0.36599E+01,-0.36741E+01,-0.36882E+01,-0.37024E+01,-0.37165E+01/
                             
     DATA (BNC04M(IA),IA=701,741)/                                      &
     -0.37307E+01,-0.37448E+01,-0.37589E+01,-0.37730E+01,-0.37870E+01,&
     -0.38011E+01,-0.38151E+01,-0.38291E+01,-0.38431E+01,-0.38571E+01,&
     -0.38711E+01,-0.38850E+01,-0.38990E+01,-0.39129E+01,-0.39268E+01,&
     -0.39407E+01,-0.39546E+01,-0.39685E+01,-0.39824E+01,-0.39962E+01,&
     -0.40100E+01,-0.40239E+01,-0.40377E+01,-0.40515E+01,-0.40653E+01,&
     -0.40790E+01,-0.40928E+01,-0.41065E+01,-0.41203E+01,-0.41340E+01,&
     -0.41477E+01,-0.41614E+01,-0.41751E+01,-0.41887E+01,-0.42024E+01,&
     -0.42160E+01,-0.42297E+01,-0.42433E+01,-0.42569E+01,-0.42705E+01,&
     -0.42841E+01             /                      
!                            
!  ** NH4NO3                 
!                            
     DATA (BNC05M (IA),IA=  1,100)/                                     &
     -0.58030E-01,-0.10848E+00,-0.14612E+00,-0.17306E+00,-0.19474E+00,&
     -0.21318E+00,-0.22940E+00,-0.24400E+00,-0.25734E+00,-0.26968E+00,&
     -0.28121E+00,-0.29205E+00,-0.30231E+00,-0.31208E+00,-0.32141E+00,&
     -0.33035E+00,-0.33895E+00,-0.34724E+00,-0.35526E+00,-0.36302E+00,&
     -0.37055E+00,-0.37787E+00,-0.38499E+00,-0.39194E+00,-0.39871E+00,&
     -0.40532E+00,-0.41178E+00,-0.41811E+00,-0.42430E+00,-0.43037E+00,&
     -0.43632E+00,-0.44215E+00,-0.44788E+00,-0.45350E+00,-0.45902E+00,&
     -0.46446E+00,-0.46979E+00,-0.47505E+00,-0.48021E+00,-0.48530E+00,&
     -0.49031E+00,-0.49524E+00,-0.50010E+00,-0.50489E+00,-0.50962E+00,&
     -0.51427E+00,-0.51886E+00,-0.52339E+00,-0.52786E+00,-0.53228E+00,&
     -0.53663E+00,-0.54094E+00,-0.54519E+00,-0.54939E+00,-0.55354E+00,&
     -0.55764E+00,-0.56170E+00,-0.56571E+00,-0.56968E+00,-0.57361E+00,&
     -0.57750E+00,-0.58136E+00,-0.58517E+00,-0.58895E+00,-0.59270E+00,&
     -0.59641E+00,-0.60010E+00,-0.60375E+00,-0.60738E+00,-0.61098E+00,&
     -0.61455E+00,-0.61810E+00,-0.62162E+00,-0.62512E+00,-0.62860E+00,&
     -0.63206E+00,-0.63550E+00,-0.63892E+00,-0.64233E+00,-0.64571E+00,&
     -0.64908E+00,-0.65244E+00,-0.65578E+00,-0.65911E+00,-0.66242E+00,&
     -0.66572E+00,-0.66901E+00,-0.67228E+00,-0.67555E+00,-0.67880E+00,&
     -0.68205E+00,-0.68528E+00,-0.68850E+00,-0.69171E+00,-0.69492E+00,&
     -0.69811E+00,-0.70130E+00,-0.70447E+00,-0.70764E+00,-0.71080E+00/
                             
     DATA (BNC05M (IA),IA=101,200)/                                     &
     -0.71394E+00,-0.71708E+00,-0.72021E+00,-0.72334E+00,-0.72645E+00,&
     -0.72955E+00,-0.73265E+00,-0.73573E+00,-0.73881E+00,-0.74187E+00,&
     -0.74493E+00,-0.74798E+00,-0.75101E+00,-0.75404E+00,-0.75706E+00,&
     -0.76007E+00,-0.76307E+00,-0.76606E+00,-0.76903E+00,-0.77200E+00,&
     -0.77479E+00,-0.77776E+00,-0.78071E+00,-0.78366E+00,-0.78659E+00,&
     -0.78951E+00,-0.79242E+00,-0.79531E+00,-0.79820E+00,-0.80107E+00,&
     -0.80393E+00,-0.80678E+00,-0.80962E+00,-0.81245E+00,-0.81527E+00,&
     -0.81808E+00,-0.82087E+00,-0.82366E+00,-0.82644E+00,-0.82920E+00,&
     -0.83196E+00,-0.83470E+00,-0.83744E+00,-0.84016E+00,-0.84288E+00,&
     -0.84558E+00,-0.84828E+00,-0.85097E+00,-0.85365E+00,-0.85631E+00,&
     -0.85897E+00,-0.86162E+00,-0.86426E+00,-0.86689E+00,-0.86951E+00,&
     -0.87213E+00,-0.87473E+00,-0.87733E+00,-0.87992E+00,-0.88249E+00,&
     -0.88506E+00,-0.88763E+00,-0.89018E+00,-0.89272E+00,-0.89526E+00,&
     -0.89779E+00,-0.90031E+00,-0.90282E+00,-0.90532E+00,-0.90782E+00,&
     -0.91031E+00,-0.91279E+00,-0.91526E+00,-0.91773E+00,-0.92019E+00,&
     -0.92264E+00,-0.92508E+00,-0.92751E+00,-0.92994E+00,-0.93236E+00,&
     -0.93477E+00,-0.93718E+00,-0.93958E+00,-0.94197E+00,-0.94435E+00,&
     -0.94673E+00,-0.94910E+00,-0.95147E+00,-0.95382E+00,-0.95617E+00,&
     -0.95852E+00,-0.96085E+00,-0.96318E+00,-0.96550E+00,-0.96782E+00,&
     -0.97013E+00,-0.97243E+00,-0.97473E+00,-0.97702E+00,-0.97931E+00/
                             
     DATA (BNC05M (IA),IA=201,300)/                                     &
     -0.98158E+00,-0.98386E+00,-0.98612E+00,-0.98838E+00,-0.99063E+00,&
     -0.99288E+00,-0.99512E+00,-0.99736E+00,-0.99959E+00,-0.10018E+01,&
     -0.10040E+01,-0.10062E+01,-0.10084E+01,-0.10106E+01,-0.10128E+01,&
     -0.10150E+01,-0.10172E+01,-0.10194E+01,-0.10216E+01,-0.10237E+01,&
     -0.10259E+01,-0.10280E+01,-0.10302E+01,-0.10323E+01,-0.10345E+01,&
     -0.10366E+01,-0.10387E+01,-0.10409E+01,-0.10430E+01,-0.10451E+01,&
     -0.10472E+01,-0.10493E+01,-0.10514E+01,-0.10535E+01,-0.10556E+01,&
     -0.10576E+01,-0.10597E+01,-0.10618E+01,-0.10639E+01,-0.10659E+01,&
     -0.10680E+01,-0.10700E+01,-0.10721E+01,-0.10741E+01,-0.10762E+01,&
     -0.10782E+01,-0.10802E+01,-0.10822E+01,-0.10843E+01,-0.10863E+01,&
     -0.10883E+01,-0.10903E+01,-0.10923E+01,-0.10943E+01,-0.10963E+01,&
     -0.10983E+01,-0.11002E+01,-0.11022E+01,-0.11042E+01,-0.11062E+01,&
     -0.11081E+01,-0.11101E+01,-0.11120E+01,-0.11140E+01,-0.11159E+01,&
     -0.11179E+01,-0.11198E+01,-0.11218E+01,-0.11237E+01,-0.11256E+01,&
     -0.11275E+01,-0.11294E+01,-0.11314E+01,-0.11333E+01,-0.11352E+01,&
     -0.11371E+01,-0.11390E+01,-0.11409E+01,-0.11428E+01,-0.11446E+01,&
     -0.11465E+01,-0.11484E+01,-0.11503E+01,-0.11522E+01,-0.11540E+01,&
     -0.11559E+01,-0.11577E+01,-0.11596E+01,-0.11614E+01,-0.11633E+01,&
     -0.11651E+01,-0.11670E+01,-0.11688E+01,-0.11706E+01,-0.11725E+01,&
     -0.11743E+01,-0.11761E+01,-0.11779E+01,-0.11798E+01,-0.11816E+01/
                             
     DATA (BNC05M (IA),IA=301,400)/                                     &
     -0.11834E+01,-0.11852E+01,-0.11870E+01,-0.11888E+01,-0.11906E+01,&
     -0.11924E+01,-0.11941E+01,-0.11959E+01,-0.11977E+01,-0.11995E+01,&
     -0.12013E+01,-0.12030E+01,-0.12048E+01,-0.12066E+01,-0.12083E+01,&
     -0.12101E+01,-0.12118E+01,-0.12136E+01,-0.12153E+01,-0.12171E+01,&
     -0.12188E+01,-0.12205E+01,-0.12223E+01,-0.12240E+01,-0.12257E+01,&
     -0.12275E+01,-0.12292E+01,-0.12309E+01,-0.12326E+01,-0.12343E+01,&
     -0.12360E+01,-0.12377E+01,-0.12394E+01,-0.12411E+01,-0.12428E+01,&
     -0.12445E+01,-0.12462E+01,-0.12479E+01,-0.12496E+01,-0.12513E+01,&
     -0.12530E+01,-0.12546E+01,-0.12563E+01,-0.12580E+01,-0.12596E+01,&
     -0.12613E+01,-0.12630E+01,-0.12646E+01,-0.12663E+01,-0.12679E+01,&
     -0.12696E+01,-0.12712E+01,-0.12729E+01,-0.12745E+01,-0.12762E+01,&
     -0.12778E+01,-0.12794E+01,-0.12811E+01,-0.12827E+01,-0.12843E+01,&
     -0.12859E+01,-0.12876E+01,-0.12892E+01,-0.12908E+01,-0.12924E+01,&
     -0.12940E+01,-0.12956E+01,-0.12972E+01,-0.12988E+01,-0.13004E+01,&
     -0.13020E+01,-0.13036E+01,-0.13052E+01,-0.13068E+01,-0.13084E+01,&
     -0.13100E+01,-0.13116E+01,-0.13131E+01,-0.13147E+01,-0.13163E+01,&
     -0.13179E+01,-0.13194E+01,-0.13210E+01,-0.13226E+01,-0.13241E+01,&
     -0.13257E+01,-0.13272E+01,-0.13288E+01,-0.13303E+01,-0.13319E+01,&
     -0.13334E+01,-0.13350E+01,-0.13365E+01,-0.13381E+01,-0.13396E+01,&
     -0.13411E+01,-0.13427E+01,-0.13442E+01,-0.13457E+01,-0.13473E+01/
                             
     DATA (BNC05M (IA),IA=401,500)/                                     &
     -0.13488E+01,-0.13503E+01,-0.13518E+01,-0.13533E+01,-0.13549E+01,&
     -0.13564E+01,-0.13579E+01,-0.13594E+01,-0.13609E+01,-0.13624E+01,&
     -0.13639E+01,-0.13654E+01,-0.13669E+01,-0.13684E+01,-0.13699E+01,&
     -0.13714E+01,-0.13729E+01,-0.13744E+01,-0.13758E+01,-0.13773E+01,&
     -0.13788E+01,-0.13803E+01,-0.13818E+01,-0.13832E+01,-0.13847E+01,&
     -0.13862E+01,-0.13877E+01,-0.13891E+01,-0.13906E+01,-0.13920E+01,&
     -0.13935E+01,-0.13950E+01,-0.13964E+01,-0.13979E+01,-0.13993E+01,&
     -0.14008E+01,-0.14022E+01,-0.14037E+01,-0.14051E+01,-0.14066E+01,&
     -0.14080E+01,-0.14094E+01,-0.14109E+01,-0.14123E+01,-0.14137E+01,&
     -0.14152E+01,-0.14166E+01,-0.14180E+01,-0.14195E+01,-0.14209E+01,&
     -0.14223E+01,-0.14237E+01,-0.14251E+01,-0.14266E+01,-0.14280E+01,&
     -0.14294E+01,-0.14308E+01,-0.14322E+01,-0.14336E+01,-0.14350E+01,&
     -0.14364E+01,-0.14378E+01,-0.14392E+01,-0.14406E+01,-0.14420E+01,&
     -0.14434E+01,-0.14448E+01,-0.14462E+01,-0.14476E+01,-0.14490E+01,&
     -0.14504E+01,-0.14517E+01,-0.14531E+01,-0.14545E+01,-0.14559E+01,&
     -0.14573E+01,-0.14586E+01,-0.14600E+01,-0.14614E+01,-0.14627E+01,&
     -0.14641E+01,-0.14655E+01,-0.14668E+01,-0.14682E+01,-0.14696E+01,&
     -0.14709E+01,-0.14723E+01,-0.14736E+01,-0.14750E+01,-0.14764E+01,&
     -0.14777E+01,-0.14791E+01,-0.14804E+01,-0.14818E+01,-0.14831E+01,&
     -0.14844E+01,-0.14858E+01,-0.14871E+01,-0.14885E+01,-0.14898E+01/
                             
     DATA (BNC05M (IA),IA=501,600)/                                     &
     -0.14911E+01,-0.14925E+01,-0.14938E+01,-0.14951E+01,-0.14965E+01,&
     -0.14978E+01,-0.14991E+01,-0.15005E+01,-0.15018E+01,-0.15031E+01,&
     -0.15044E+01,-0.15057E+01,-0.15071E+01,-0.15084E+01,-0.15097E+01,&
     -0.15110E+01,-0.15123E+01,-0.15136E+01,-0.15149E+01,-0.15162E+01,&
     -0.15175E+01,-0.15188E+01,-0.15202E+01,-0.15215E+01,-0.15228E+01,&
     -0.15241E+01,-0.15253E+01,-0.15266E+01,-0.15279E+01,-0.15292E+01,&
     -0.15305E+01,-0.15318E+01,-0.15331E+01,-0.15344E+01,-0.15357E+01,&
     -0.15370E+01,-0.15382E+01,-0.15395E+01,-0.15408E+01,-0.15421E+01,&
     -0.15434E+01,-0.15446E+01,-0.15459E+01,-0.15472E+01,-0.15485E+01,&
     -0.15497E+01,-0.15510E+01,-0.15523E+01,-0.15535E+01,-0.15548E+01,&
     -0.15561E+01,-0.15573E+01,-0.15586E+01,-0.15598E+01,-0.15611E+01,&
     -0.15624E+01,-0.15636E+01,-0.15649E+01,-0.15661E+01,-0.15674E+01,&
     -0.15686E+01,-0.15699E+01,-0.15711E+01,-0.15724E+01,-0.15736E+01,&
     -0.15749E+01,-0.15761E+01,-0.15773E+01,-0.15786E+01,-0.15798E+01,&
     -0.15811E+01,-0.15823E+01,-0.15835E+01,-0.15848E+01,-0.15860E+01,&
     -0.15872E+01,-0.15885E+01,-0.15897E+01,-0.15909E+01,-0.15922E+01,&
     -0.15934E+01,-0.15946E+01,-0.15958E+01,-0.15971E+01,-0.15983E+01,&
     -0.15995E+01,-0.16007E+01,-0.16019E+01,-0.16031E+01,-0.16044E+01,&
     -0.16056E+01,-0.16068E+01,-0.16080E+01,-0.16092E+01,-0.16104E+01,&
     -0.16116E+01,-0.16128E+01,-0.16140E+01,-0.16152E+01,-0.16198E+01/
                             
     DATA (BNC05M (IA),IA=601,700)/                                     &
     -0.16296E+01,-0.16415E+01,-0.16532E+01,-0.16649E+01,-0.16764E+01,&
     -0.16878E+01,-0.16992E+01,-0.17104E+01,-0.17216E+01,-0.17327E+01,&
     -0.17437E+01,-0.17546E+01,-0.17654E+01,-0.17761E+01,-0.17868E+01,&
     -0.17974E+01,-0.18079E+01,-0.18184E+01,-0.18287E+01,-0.18391E+01,&
     -0.18493E+01,-0.18595E+01,-0.18696E+01,-0.18796E+01,-0.18896E+01,&
     -0.18996E+01,-0.19094E+01,-0.19193E+01,-0.19290E+01,-0.19387E+01,&
     -0.19484E+01,-0.19580E+01,-0.19675E+01,-0.19770E+01,-0.19865E+01,&
     -0.19959E+01,-0.20053E+01,-0.20146E+01,-0.20238E+01,-0.20331E+01,&
     -0.20423E+01,-0.20514E+01,-0.20605E+01,-0.20695E+01,-0.20786E+01,&
     -0.20875E+01,-0.20965E+01,-0.21054E+01,-0.21143E+01,-0.21231E+01,&
     -0.21319E+01,-0.21407E+01,-0.21494E+01,-0.21581E+01,-0.21667E+01,&
     -0.21754E+01,-0.21840E+01,-0.21925E+01,-0.22011E+01,-0.22096E+01,&
     -0.22180E+01,-0.22265E+01,-0.22349E+01,-0.22433E+01,-0.22517E+01,&
     -0.22600E+01,-0.22683E+01,-0.22766E+01,-0.22848E+01,-0.22931E+01,&
     -0.23013E+01,-0.23095E+01,-0.23176E+01,-0.23257E+01,-0.23338E+01,&
     -0.23419E+01,-0.23500E+01,-0.23580E+01,-0.23661E+01,-0.23741E+01,&
     -0.23820E+01,-0.23900E+01,-0.23979E+01,-0.24058E+01,-0.24137E+01,&
     -0.24216E+01,-0.24294E+01,-0.24373E+01,-0.24451E+01,-0.24529E+01,&
     -0.24607E+01,-0.24684E+01,-0.24762E+01,-0.24839E+01,-0.24916E+01,&
     -0.24993E+01,-0.25070E+01,-0.25146E+01,-0.25222E+01,-0.25299E+01/
                             
     DATA (BNC05M(IA),IA=701,741)/                                      &
     -0.25375E+01,-0.25451E+01,-0.25526E+01,-0.25602E+01,-0.25677E+01,&
     -0.25753E+01,-0.25828E+01,-0.25903E+01,-0.25978E+01,-0.26052E+01,&
     -0.26127E+01,-0.26201E+01,-0.26276E+01,-0.26350E+01,-0.26424E+01,&
     -0.26498E+01,-0.26571E+01,-0.26645E+01,-0.26718E+01,-0.26792E+01,&
     -0.26865E+01,-0.26938E+01,-0.27011E+01,-0.27084E+01,-0.27157E+01,&
     -0.27229E+01,-0.27302E+01,-0.27374E+01,-0.27446E+01,-0.27519E+01,&
     -0.27591E+01,-0.27663E+01,-0.27734E+01,-0.27806E+01,-0.27878E+01,&
     -0.27949E+01,-0.28021E+01,-0.28092E+01,-0.28163E+01,-0.28234E+01,&
     -0.28305E+01                  /                      
!                            
!  ** NH4Cl                  
!                            
     DATA (BNC06M (IA),IA=  1,100)/                                     &
     -0.55953E-01,-0.10077E+00,-0.13146E+00,-0.15183E+00,-0.16717E+00,&
     -0.17947E+00,-0.18969E+00,-0.19842E+00,-0.20600E+00,-0.21268E+00,&
     -0.21863E+00,-0.22398E+00,-0.22882E+00,-0.23322E+00,-0.23726E+00,&
     -0.24097E+00,-0.24440E+00,-0.24758E+00,-0.25054E+00,-0.25330E+00,&
     -0.25588E+00,-0.25830E+00,-0.26057E+00,-0.26271E+00,-0.26473E+00,&
     -0.26663E+00,-0.26844E+00,-0.27015E+00,-0.27178E+00,-0.27333E+00,&
     -0.27480E+00,-0.27621E+00,-0.27756E+00,-0.27885E+00,-0.28008E+00,&
     -0.28126E+00,-0.28240E+00,-0.28349E+00,-0.28455E+00,-0.28556E+00,&
     -0.28654E+00,-0.28749E+00,-0.28840E+00,-0.28929E+00,-0.29015E+00,&
     -0.29098E+00,-0.29179E+00,-0.29258E+00,-0.29334E+00,-0.29409E+00,&
     -0.29482E+00,-0.29552E+00,-0.29621E+00,-0.29689E+00,-0.29754E+00,&
     -0.29819E+00,-0.29881E+00,-0.29943E+00,-0.30003E+00,-0.30061E+00,&
     -0.30118E+00,-0.30174E+00,-0.30229E+00,-0.30283E+00,-0.30335E+00,&
     -0.30386E+00,-0.30436E+00,-0.30484E+00,-0.30532E+00,-0.30578E+00,&
     -0.30623E+00,-0.30667E+00,-0.30710E+00,-0.30751E+00,-0.30791E+00,&
     -0.30830E+00,-0.30868E+00,-0.30905E+00,-0.30941E+00,-0.30975E+00,&
     -0.31008E+00,-0.31040E+00,-0.31071E+00,-0.31100E+00,-0.31129E+00,&
     -0.31156E+00,-0.31182E+00,-0.31207E+00,-0.31230E+00,-0.31253E+00,&
     -0.31274E+00,-0.31295E+00,-0.31314E+00,-0.31332E+00,-0.31349E+00,&
     -0.31365E+00,-0.31380E+00,-0.31394E+00,-0.31407E+00,-0.31420E+00/
                             
     DATA (BNC06M (IA),IA=101,200)/                                     &
     -0.31431E+00,-0.31441E+00,-0.31451E+00,-0.31459E+00,-0.31467E+00,&
     -0.31474E+00,-0.31480E+00,-0.31486E+00,-0.31491E+00,-0.31495E+00,&
     -0.31499E+00,-0.31502E+00,-0.31504E+00,-0.31506E+00,-0.31508E+00,&
     -0.31508E+00,-0.31509E+00,-0.31509E+00,-0.31508E+00,-0.31507E+00,&
     -0.31518E+00,-0.31515E+00,-0.31512E+00,-0.31508E+00,-0.31505E+00,&
     -0.31501E+00,-0.31497E+00,-0.31493E+00,-0.31488E+00,-0.31484E+00,&
     -0.31479E+00,-0.31474E+00,-0.31470E+00,-0.31464E+00,-0.31459E+00,&
     -0.31454E+00,-0.31449E+00,-0.31443E+00,-0.31437E+00,-0.31432E+00,&
     -0.31426E+00,-0.31420E+00,-0.31414E+00,-0.31407E+00,-0.31401E+00,&
     -0.31395E+00,-0.31389E+00,-0.31382E+00,-0.31375E+00,-0.31369E+00,&
     -0.31362E+00,-0.31355E+00,-0.31349E+00,-0.31342E+00,-0.31335E+00,&
     -0.31328E+00,-0.31321E+00,-0.31314E+00,-0.31307E+00,-0.31300E+00,&
     -0.31293E+00,-0.31285E+00,-0.31278E+00,-0.31271E+00,-0.31264E+00,&
     -0.31257E+00,-0.31249E+00,-0.31242E+00,-0.31235E+00,-0.31227E+00,&
     -0.31220E+00,-0.31213E+00,-0.31205E+00,-0.31198E+00,-0.31190E+00,&
     -0.31183E+00,-0.31176E+00,-0.31168E+00,-0.31161E+00,-0.31154E+00,&
     -0.31146E+00,-0.31139E+00,-0.31132E+00,-0.31124E+00,-0.31117E+00,&
     -0.31110E+00,-0.31102E+00,-0.31095E+00,-0.31088E+00,-0.31081E+00,&
     -0.31073E+00,-0.31066E+00,-0.31059E+00,-0.31052E+00,-0.31045E+00,&
     -0.31038E+00,-0.31031E+00,-0.31024E+00,-0.31017E+00,-0.31010E+00/
                             
     DATA (BNC06M (IA),IA=201,300)/                                     &
     -0.31003E+00,-0.30996E+00,-0.30989E+00,-0.30982E+00,-0.30975E+00,&
     -0.30969E+00,-0.30962E+00,-0.30955E+00,-0.30949E+00,-0.30942E+00,&
     -0.30935E+00,-0.30929E+00,-0.30922E+00,-0.30916E+00,-0.30910E+00,&
     -0.30903E+00,-0.30897E+00,-0.30891E+00,-0.30884E+00,-0.30878E+00,&
     -0.30872E+00,-0.30866E+00,-0.30860E+00,-0.30854E+00,-0.30848E+00,&
     -0.30842E+00,-0.30837E+00,-0.30831E+00,-0.30825E+00,-0.30819E+00,&
     -0.30814E+00,-0.30808E+00,-0.30803E+00,-0.30797E+00,-0.30792E+00,&
     -0.30787E+00,-0.30781E+00,-0.30776E+00,-0.30771E+00,-0.30766E+00,&
     -0.30761E+00,-0.30756E+00,-0.30751E+00,-0.30746E+00,-0.30741E+00,&
     -0.30737E+00,-0.30732E+00,-0.30727E+00,-0.30723E+00,-0.30718E+00,&
     -0.30714E+00,-0.30709E+00,-0.30705E+00,-0.30701E+00,-0.30697E+00,&
     -0.30692E+00,-0.30688E+00,-0.30684E+00,-0.30680E+00,-0.30676E+00,&
     -0.30673E+00,-0.30669E+00,-0.30665E+00,-0.30662E+00,-0.30658E+00,&
     -0.30654E+00,-0.30651E+00,-0.30648E+00,-0.30644E+00,-0.30641E+00,&
     -0.30638E+00,-0.30635E+00,-0.30632E+00,-0.30629E+00,-0.30626E+00,&
     -0.30623E+00,-0.30620E+00,-0.30617E+00,-0.30615E+00,-0.30612E+00,&
     -0.30610E+00,-0.30607E+00,-0.30605E+00,-0.30602E+00,-0.30600E+00,&
     -0.30598E+00,-0.30596E+00,-0.30594E+00,-0.30592E+00,-0.30590E+00,&
     -0.30588E+00,-0.30586E+00,-0.30584E+00,-0.30583E+00,-0.30581E+00,&
     -0.30580E+00,-0.30578E+00,-0.30577E+00,-0.30576E+00,-0.30574E+00/
                             
     DATA (BNC06M (IA),IA=301,400)/                                     &
     -0.30573E+00,-0.30572E+00,-0.30571E+00,-0.30570E+00,-0.30569E+00,&
     -0.30568E+00,-0.30567E+00,-0.30567E+00,-0.30566E+00,-0.30565E+00,&
     -0.30565E+00,-0.30564E+00,-0.30564E+00,-0.30564E+00,-0.30564E+00,&
     -0.30563E+00,-0.30563E+00,-0.30563E+00,-0.30563E+00,-0.30563E+00,&
     -0.30563E+00,-0.30564E+00,-0.30564E+00,-0.30564E+00,-0.30565E+00,&
     -0.30565E+00,-0.30566E+00,-0.30567E+00,-0.30567E+00,-0.30568E+00,&
     -0.30569E+00,-0.30570E+00,-0.30571E+00,-0.30572E+00,-0.30573E+00,&
     -0.30574E+00,-0.30575E+00,-0.30577E+00,-0.30578E+00,-0.30579E+00,&
     -0.30581E+00,-0.30582E+00,-0.30584E+00,-0.30586E+00,-0.30588E+00,&
     -0.30589E+00,-0.30591E+00,-0.30593E+00,-0.30595E+00,-0.30597E+00,&
     -0.30600E+00,-0.30602E+00,-0.30604E+00,-0.30606E+00,-0.30609E+00,&
     -0.30611E+00,-0.30614E+00,-0.30617E+00,-0.30619E+00,-0.30622E+00,&
     -0.30625E+00,-0.30628E+00,-0.30631E+00,-0.30634E+00,-0.30637E+00,&
     -0.30640E+00,-0.30643E+00,-0.30646E+00,-0.30650E+00,-0.30653E+00,&
     -0.30657E+00,-0.30660E+00,-0.30664E+00,-0.30667E+00,-0.30671E+00,&
     -0.30675E+00,-0.30679E+00,-0.30683E+00,-0.30687E+00,-0.30691E+00,&
     -0.30695E+00,-0.30699E+00,-0.30703E+00,-0.30708E+00,-0.30712E+00,&
     -0.30716E+00,-0.30721E+00,-0.30726E+00,-0.30730E+00,-0.30735E+00,&
     -0.30740E+00,-0.30744E+00,-0.30749E+00,-0.30754E+00,-0.30759E+00,&
     -0.30764E+00,-0.30769E+00,-0.30775E+00,-0.30780E+00,-0.30785E+00/
                             
     DATA (BNC06M (IA),IA=401,500)/                                     &
     -0.30791E+00,-0.30796E+00,-0.30802E+00,-0.30807E+00,-0.30813E+00,&
     -0.30818E+00,-0.30824E+00,-0.30830E+00,-0.30836E+00,-0.30842E+00,&
     -0.30848E+00,-0.30854E+00,-0.30860E+00,-0.30866E+00,-0.30872E+00,&
     -0.30879E+00,-0.30885E+00,-0.30891E+00,-0.30898E+00,-0.30904E+00,&
     -0.30911E+00,-0.30918E+00,-0.30924E+00,-0.30931E+00,-0.30938E+00,&
     -0.30945E+00,-0.30952E+00,-0.30959E+00,-0.30966E+00,-0.30973E+00,&
     -0.30980E+00,-0.30987E+00,-0.30995E+00,-0.31002E+00,-0.31010E+00,&
     -0.31017E+00,-0.31025E+00,-0.31032E+00,-0.31040E+00,-0.31048E+00,&
     -0.31055E+00,-0.31063E+00,-0.31071E+00,-0.31079E+00,-0.31087E+00,&
     -0.31095E+00,-0.31103E+00,-0.31111E+00,-0.31120E+00,-0.31128E+00,&
     -0.31136E+00,-0.31145E+00,-0.31153E+00,-0.31162E+00,-0.31170E+00,&
     -0.31179E+00,-0.31188E+00,-0.31196E+00,-0.31205E+00,-0.31214E+00,&
     -0.31223E+00,-0.31232E+00,-0.31241E+00,-0.31250E+00,-0.31259E+00,&
     -0.31268E+00,-0.31278E+00,-0.31287E+00,-0.31296E+00,-0.31306E+00,&
     -0.31315E+00,-0.31325E+00,-0.31334E+00,-0.31344E+00,-0.31354E+00,&
     -0.31363E+00,-0.31373E+00,-0.31383E+00,-0.31393E+00,-0.31403E+00,&
     -0.31413E+00,-0.31423E+00,-0.31433E+00,-0.31443E+00,-0.31454E+00,&
     -0.31464E+00,-0.31474E+00,-0.31485E+00,-0.31495E+00,-0.31506E+00,&
     -0.31516E+00,-0.31527E+00,-0.31537E+00,-0.31548E+00,-0.31559E+00,&
     -0.31570E+00,-0.31581E+00,-0.31591E+00,-0.31602E+00,-0.31613E+00/
                             
     DATA (BNC06M (IA),IA=501,600)/                                     &
     -0.31625E+00,-0.31636E+00,-0.31647E+00,-0.31658E+00,-0.31669E+00,&
     -0.31681E+00,-0.31692E+00,-0.31704E+00,-0.31715E+00,-0.31727E+00,&
     -0.31738E+00,-0.31750E+00,-0.31761E+00,-0.31773E+00,-0.31785E+00,&
     -0.31797E+00,-0.31809E+00,-0.31821E+00,-0.31833E+00,-0.31845E+00,&
     -0.31857E+00,-0.31869E+00,-0.31881E+00,-0.31893E+00,-0.31906E+00,&
     -0.31918E+00,-0.31931E+00,-0.31943E+00,-0.31955E+00,-0.31968E+00,&
     -0.31981E+00,-0.31993E+00,-0.32006E+00,-0.32019E+00,-0.32032E+00,&
     -0.32044E+00,-0.32057E+00,-0.32070E+00,-0.32083E+00,-0.32096E+00,&
     -0.32109E+00,-0.32122E+00,-0.32136E+00,-0.32149E+00,-0.32162E+00,&
     -0.32175E+00,-0.32189E+00,-0.32202E+00,-0.32216E+00,-0.32229E+00,&
     -0.32243E+00,-0.32256E+00,-0.32270E+00,-0.32284E+00,-0.32298E+00,&
     -0.32311E+00,-0.32325E+00,-0.32339E+00,-0.32353E+00,-0.32367E+00,&
     -0.32381E+00,-0.32395E+00,-0.32409E+00,-0.32423E+00,-0.32438E+00,&
     -0.32452E+00,-0.32466E+00,-0.32481E+00,-0.32495E+00,-0.32509E+00,&
     -0.32524E+00,-0.32538E+00,-0.32553E+00,-0.32568E+00,-0.32582E+00,&
     -0.32597E+00,-0.32612E+00,-0.32627E+00,-0.32642E+00,-0.32656E+00,&
     -0.32671E+00,-0.32686E+00,-0.32701E+00,-0.32716E+00,-0.32732E+00,&
     -0.32747E+00,-0.32762E+00,-0.32777E+00,-0.32793E+00,-0.32808E+00,&
     -0.32823E+00,-0.32839E+00,-0.32854E+00,-0.32870E+00,-0.32885E+00,&
     -0.32901E+00,-0.32917E+00,-0.32932E+00,-0.32948E+00,-0.33007E+00/
                             
     DATA (BNC06M (IA),IA=601,700)/                                     &
     -0.33140E+00,-0.33305E+00,-0.33474E+00,-0.33647E+00,-0.33824E+00,&
     -0.34005E+00,-0.34190E+00,-0.34379E+00,-0.34571E+00,-0.34767E+00,&
     -0.34966E+00,-0.35169E+00,-0.35376E+00,-0.35586E+00,-0.35799E+00,&
     -0.36016E+00,-0.36235E+00,-0.36458E+00,-0.36684E+00,-0.36913E+00,&
     -0.37146E+00,-0.37381E+00,-0.37619E+00,-0.37859E+00,-0.38103E+00,&
     -0.38349E+00,-0.38598E+00,-0.38850E+00,-0.39105E+00,-0.39361E+00,&
     -0.39621E+00,-0.39883E+00,-0.40147E+00,-0.40414E+00,-0.40684E+00,&
     -0.40955E+00,-0.41229E+00,-0.41506E+00,-0.41784E+00,-0.42065E+00,&
     -0.42348E+00,-0.42633E+00,-0.42920E+00,-0.43209E+00,-0.43500E+00,&
     -0.43793E+00,-0.44089E+00,-0.44386E+00,-0.44685E+00,-0.44986E+00,&
     -0.45289E+00,-0.45594E+00,-0.45901E+00,-0.46209E+00,-0.46519E+00,&
     -0.46831E+00,-0.47145E+00,-0.47460E+00,-0.47777E+00,-0.48096E+00,&
     -0.48416E+00,-0.48738E+00,-0.49062E+00,-0.49387E+00,-0.49713E+00,&
     -0.50042E+00,-0.50371E+00,-0.50702E+00,-0.51035E+00,-0.51369E+00,&
     -0.51705E+00,-0.52042E+00,-0.52380E+00,-0.52720E+00,-0.53061E+00,&
     -0.53403E+00,-0.53747E+00,-0.54092E+00,-0.54438E+00,-0.54786E+00,&
     -0.55135E+00,-0.55485E+00,-0.55836E+00,-0.56189E+00,-0.56543E+00,&
     -0.56898E+00,-0.57254E+00,-0.57611E+00,-0.57970E+00,-0.58329E+00,&
     -0.58690E+00,-0.59052E+00,-0.59415E+00,-0.59779E+00,-0.60144E+00,&
     -0.60510E+00,-0.60877E+00,-0.61245E+00,-0.61614E+00,-0.61985E+00/
                             
     DATA (BNC06M(IA),IA=701,741)/                                      &
     -0.62356E+00,-0.62728E+00,-0.63101E+00,-0.63475E+00,-0.63851E+00,&
     -0.64227E+00,-0.64604E+00,-0.64982E+00,-0.65360E+00,-0.65740E+00,&
     -0.66121E+00,-0.66502E+00,-0.66885E+00,-0.67268E+00,-0.67652E+00,&
     -0.68037E+00,-0.68423E+00,-0.68809E+00,-0.69197E+00,-0.69585E+00,&
     -0.69974E+00,-0.70364E+00,-0.70755E+00,-0.71146E+00,-0.71539E+00,&
     -0.71932E+00,-0.72325E+00,-0.72720E+00,-0.73115E+00,-0.73511E+00,&
     -0.73908E+00,-0.74305E+00,-0.74703E+00,-0.75102E+00,-0.75502E+00,&
     -0.75902E+00,-0.76303E+00,-0.76705E+00,-0.77107E+00,-0.77510E+00,&
     -0.77914E+00                  /                      
!                            
!  ** (2H, SO4)              
!                            
     DATA (BNC07M (IA),IA=  1,100)/                                     &
     -0.11374E+00,-0.20831E+00,-0.27574E+00,-0.32220E+00,-0.35838E+00,&
     -0.38830E+00,-0.41395E+00,-0.43649E+00,-0.45665E+00,-0.47492E+00,&
     -0.49165E+00,-0.50711E+00,-0.52150E+00,-0.53497E+00,-0.54765E+00,&
     -0.55962E+00,-0.57099E+00,-0.58180E+00,-0.59213E+00,-0.60201E+00,&
     -0.61150E+00,-0.62062E+00,-0.62941E+00,-0.63790E+00,-0.64610E+00,&
     -0.65405E+00,-0.66175E+00,-0.66923E+00,-0.67651E+00,-0.68359E+00,&
     -0.69048E+00,-0.69721E+00,-0.70377E+00,-0.71018E+00,-0.71645E+00,&
     -0.72258E+00,-0.72859E+00,-0.73447E+00,-0.74024E+00,-0.74589E+00,&
     -0.75145E+00,-0.75690E+00,-0.76225E+00,-0.76752E+00,-0.77270E+00,&
     -0.77779E+00,-0.78281E+00,-0.78774E+00,-0.79261E+00,-0.79740E+00,&
     -0.80212E+00,-0.80678E+00,-0.81138E+00,-0.81592E+00,-0.82039E+00,&
     -0.82481E+00,-0.82918E+00,-0.83349E+00,-0.83776E+00,-0.84197E+00,&
     -0.84614E+00,-0.85026E+00,-0.85434E+00,-0.85837E+00,-0.86237E+00,&
     -0.86632E+00,-0.87023E+00,-0.87411E+00,-0.87795E+00,-0.88176E+00,&
     -0.88553E+00,-0.88927E+00,-0.89297E+00,-0.89665E+00,-0.90029E+00,&
     -0.90391E+00,-0.90750E+00,-0.91106E+00,-0.91459E+00,-0.91810E+00,&
     -0.92158E+00,-0.92503E+00,-0.92847E+00,-0.93188E+00,-0.93527E+00,&
     -0.93863E+00,-0.94197E+00,-0.94530E+00,-0.94860E+00,-0.95188E+00,&
     -0.95514E+00,-0.95839E+00,-0.96161E+00,-0.96482E+00,-0.96801E+00,&
     -0.97118E+00,-0.97433E+00,-0.97747E+00,-0.98059E+00,-0.98370E+00/
                             
     DATA (BNC07M (IA),IA=101,200)/                                     &
     -0.98679E+00,-0.98986E+00,-0.99292E+00,-0.99596E+00,-0.99899E+00,&
     -0.10020E+01,-0.10050E+01,-0.10080E+01,-0.10110E+01,-0.10139E+01,&
     -0.10169E+01,-0.10198E+01,-0.10227E+01,-0.10256E+01,-0.10285E+01,&
     -0.10314E+01,-0.10343E+01,-0.10371E+01,-0.10400E+01,-0.10428E+01,&
     -0.10456E+01,-0.10484E+01,-0.10512E+01,-0.10540E+01,-0.10568E+01,&
     -0.10596E+01,-0.10623E+01,-0.10651E+01,-0.10678E+01,-0.10706E+01,&
     -0.10733E+01,-0.10760E+01,-0.10787E+01,-0.10814E+01,-0.10840E+01,&
     -0.10867E+01,-0.10894E+01,-0.10920E+01,-0.10947E+01,-0.10973E+01,&
     -0.10999E+01,-0.11025E+01,-0.11051E+01,-0.11077E+01,-0.11103E+01,&
     -0.11129E+01,-0.11155E+01,-0.11180E+01,-0.11206E+01,-0.11232E+01,&
     -0.11257E+01,-0.11282E+01,-0.11308E+01,-0.11333E+01,-0.11358E+01,&
     -0.11383E+01,-0.11408E+01,-0.11433E+01,-0.11458E+01,-0.11482E+01,&
     -0.11507E+01,-0.11532E+01,-0.11556E+01,-0.11581E+01,-0.11605E+01,&
     -0.11629E+01,-0.11654E+01,-0.11678E+01,-0.11702E+01,-0.11726E+01,&
     -0.11750E+01,-0.11774E+01,-0.11798E+01,-0.11822E+01,-0.11846E+01,&
     -0.11870E+01,-0.11893E+01,-0.11917E+01,-0.11941E+01,-0.11964E+01,&
     -0.11988E+01,-0.12011E+01,-0.12034E+01,-0.12058E+01,-0.12081E+01,&
     -0.12104E+01,-0.12127E+01,-0.12150E+01,-0.12173E+01,-0.12196E+01,&
     -0.12219E+01,-0.12242E+01,-0.12265E+01,-0.12288E+01,-0.12311E+01,&
     -0.12333E+01,-0.12356E+01,-0.12379E+01,-0.12401E+01,-0.12424E+01/
                             
     DATA (BNC07M (IA),IA=201,300)/                                     &
     -0.12446E+01,-0.12469E+01,-0.12491E+01,-0.12514E+01,-0.12536E+01,&
     -0.12558E+01,-0.12580E+01,-0.12603E+01,-0.12625E+01,-0.12647E+01,&
     -0.12669E+01,-0.12691E+01,-0.12713E+01,-0.12735E+01,-0.12757E+01,&
     -0.12779E+01,-0.12800E+01,-0.12822E+01,-0.12844E+01,-0.12866E+01,&
     -0.12887E+01,-0.12909E+01,-0.12930E+01,-0.12952E+01,-0.12974E+01,&
     -0.12995E+01,-0.13017E+01,-0.13038E+01,-0.13059E+01,-0.13081E+01,&
     -0.13102E+01,-0.13123E+01,-0.13144E+01,-0.13166E+01,-0.13187E+01,&
     -0.13208E+01,-0.13229E+01,-0.13250E+01,-0.13271E+01,-0.13292E+01,&
     -0.13313E+01,-0.13334E+01,-0.13355E+01,-0.13376E+01,-0.13397E+01,&
     -0.13418E+01,-0.13438E+01,-0.13459E+01,-0.13480E+01,-0.13501E+01,&
     -0.13521E+01,-0.13542E+01,-0.13563E+01,-0.13583E+01,-0.13604E+01,&
     -0.13624E+01,-0.13645E+01,-0.13665E+01,-0.13686E+01,-0.13706E+01,&
     -0.13727E+01,-0.13747E+01,-0.13767E+01,-0.13788E+01,-0.13808E+01,&
     -0.13828E+01,-0.13848E+01,-0.13869E+01,-0.13889E+01,-0.13909E+01,&
     -0.13929E+01,-0.13949E+01,-0.13969E+01,-0.13989E+01,-0.14009E+01,&
     -0.14029E+01,-0.14049E+01,-0.14069E+01,-0.14089E+01,-0.14109E+01,&
     -0.14129E+01,-0.14149E+01,-0.14169E+01,-0.14188E+01,-0.14208E+01,&
     -0.14228E+01,-0.14248E+01,-0.14267E+01,-0.14287E+01,-0.14307E+01,&
     -0.14326E+01,-0.14346E+01,-0.14366E+01,-0.14385E+01,-0.14405E+01,&
     -0.14424E+01,-0.14444E+01,-0.14463E+01,-0.14483E+01,-0.14502E+01/
                             
     DATA (BNC07M (IA),IA=301,400)/                                     &
     -0.14522E+01,-0.14541E+01,-0.14561E+01,-0.14580E+01,-0.14599E+01,&
     -0.14619E+01,-0.14638E+01,-0.14657E+01,-0.14676E+01,-0.14696E+01,&
     -0.14715E+01,-0.14734E+01,-0.14753E+01,-0.14772E+01,-0.14792E+01,&
     -0.14811E+01,-0.14830E+01,-0.14849E+01,-0.14868E+01,-0.14887E+01,&
     -0.14906E+01,-0.14925E+01,-0.14944E+01,-0.14963E+01,-0.14982E+01,&
     -0.15001E+01,-0.15020E+01,-0.15039E+01,-0.15058E+01,-0.15077E+01,&
     -0.15095E+01,-0.15114E+01,-0.15133E+01,-0.15152E+01,-0.15171E+01,&
     -0.15189E+01,-0.15208E+01,-0.15227E+01,-0.15246E+01,-0.15264E+01,&
     -0.15283E+01,-0.15302E+01,-0.15320E+01,-0.15339E+01,-0.15358E+01,&
     -0.15376E+01,-0.15395E+01,-0.15413E+01,-0.15432E+01,-0.15450E+01,&
     -0.15469E+01,-0.15487E+01,-0.15506E+01,-0.15524E+01,-0.15543E+01,&
     -0.15561E+01,-0.15580E+01,-0.15598E+01,-0.15617E+01,-0.15635E+01,&
     -0.15653E+01,-0.15672E+01,-0.15690E+01,-0.15708E+01,-0.15727E+01,&
     -0.15745E+01,-0.15763E+01,-0.15781E+01,-0.15800E+01,-0.15818E+01,&
     -0.15836E+01,-0.15854E+01,-0.15873E+01,-0.15891E+01,-0.15909E+01,&
     -0.15927E+01,-0.15945E+01,-0.15963E+01,-0.15981E+01,-0.15999E+01,&
     -0.16018E+01,-0.16036E+01,-0.16054E+01,-0.16072E+01,-0.16090E+01,&
     -0.16108E+01,-0.16126E+01,-0.16144E+01,-0.16162E+01,-0.16180E+01,&
     -0.16198E+01,-0.16216E+01,-0.16233E+01,-0.16251E+01,-0.16269E+01,&
     -0.16287E+01,-0.16305E+01,-0.16323E+01,-0.16341E+01,-0.16358E+01/
                             
     DATA (BNC07M (IA),IA=401,500)/                                     &
     -0.16376E+01,-0.16394E+01,-0.16412E+01,-0.16430E+01,-0.16447E+01,&
     -0.16465E+01,-0.16483E+01,-0.16501E+01,-0.16518E+01,-0.16536E+01,&
     -0.16554E+01,-0.16571E+01,-0.16589E+01,-0.16607E+01,-0.16624E+01,&
     -0.16642E+01,-0.16660E+01,-0.16677E+01,-0.16695E+01,-0.16712E+01,&
     -0.16730E+01,-0.16748E+01,-0.16765E+01,-0.16783E+01,-0.16800E+01,&
     -0.16818E+01,-0.16835E+01,-0.16853E+01,-0.16870E+01,-0.16888E+01,&
     -0.16905E+01,-0.16923E+01,-0.16940E+01,-0.16958E+01,-0.16975E+01,&
     -0.16992E+01,-0.17010E+01,-0.17027E+01,-0.17045E+01,-0.17062E+01,&
     -0.17079E+01,-0.17097E+01,-0.17114E+01,-0.17131E+01,-0.17149E+01,&
     -0.17166E+01,-0.17183E+01,-0.17200E+01,-0.17218E+01,-0.17235E+01,&
     -0.17252E+01,-0.17270E+01,-0.17287E+01,-0.17304E+01,-0.17321E+01,&
     -0.17338E+01,-0.17356E+01,-0.17373E+01,-0.17390E+01,-0.17407E+01,&
     -0.17424E+01,-0.17441E+01,-0.17459E+01,-0.17476E+01,-0.17493E+01,&
     -0.17510E+01,-0.17527E+01,-0.17544E+01,-0.17561E+01,-0.17578E+01,&
     -0.17595E+01,-0.17612E+01,-0.17629E+01,-0.17646E+01,-0.17663E+01,&
     -0.17680E+01,-0.17697E+01,-0.17714E+01,-0.17731E+01,-0.17748E+01,&
     -0.17765E+01,-0.17782E+01,-0.17799E+01,-0.17816E+01,-0.17833E+01,&
     -0.17850E+01,-0.17867E+01,-0.17884E+01,-0.17901E+01,-0.17918E+01,&
     -0.17935E+01,-0.17951E+01,-0.17968E+01,-0.17985E+01,-0.18002E+01,&
     -0.18019E+01,-0.18036E+01,-0.18052E+01,-0.18069E+01,-0.18086E+01/
                             
     DATA (BNC07M (IA),IA=501,600)/                                     &
     -0.18103E+01,-0.18120E+01,-0.18136E+01,-0.18153E+01,-0.18170E+01,&
     -0.18187E+01,-0.18203E+01,-0.18220E+01,-0.18237E+01,-0.18254E+01,&
     -0.18270E+01,-0.18287E+01,-0.18304E+01,-0.18320E+01,-0.18337E+01,&
     -0.18354E+01,-0.18370E+01,-0.18387E+01,-0.18404E+01,-0.18420E+01,&
     -0.18437E+01,-0.18454E+01,-0.18470E+01,-0.18487E+01,-0.18503E+01,&
     -0.18520E+01,-0.18537E+01,-0.18553E+01,-0.18570E+01,-0.18586E+01,&
     -0.18603E+01,-0.18619E+01,-0.18636E+01,-0.18653E+01,-0.18669E+01,&
     -0.18686E+01,-0.18702E+01,-0.18719E+01,-0.18735E+01,-0.18752E+01,&
     -0.18768E+01,-0.18785E+01,-0.18801E+01,-0.18817E+01,-0.18834E+01,&
     -0.18850E+01,-0.18867E+01,-0.18883E+01,-0.18900E+01,-0.18916E+01,&
     -0.18932E+01,-0.18949E+01,-0.18965E+01,-0.18982E+01,-0.18998E+01,&
     -0.19014E+01,-0.19031E+01,-0.19047E+01,-0.19063E+01,-0.19080E+01,&
     -0.19096E+01,-0.19112E+01,-0.19129E+01,-0.19145E+01,-0.19161E+01,&
     -0.19178E+01,-0.19194E+01,-0.19210E+01,-0.19227E+01,-0.19243E+01,&
     -0.19259E+01,-0.19275E+01,-0.19292E+01,-0.19308E+01,-0.19324E+01,&
     -0.19340E+01,-0.19357E+01,-0.19373E+01,-0.19389E+01,-0.19405E+01,&
     -0.19421E+01,-0.19438E+01,-0.19454E+01,-0.19470E+01,-0.19486E+01,&
     -0.19502E+01,-0.19519E+01,-0.19535E+01,-0.19551E+01,-0.19567E+01,&
     -0.19583E+01,-0.19599E+01,-0.19615E+01,-0.19632E+01,-0.19648E+01,&
     -0.19664E+01,-0.19680E+01,-0.19696E+01,-0.19712E+01,-0.19772E+01/
                             
     DATA (BNC07M (IA),IA=601,700)/                                     &
     -0.19905E+01,-0.20065E+01,-0.20224E+01,-0.20383E+01,-0.20541E+01,&
     -0.20698E+01,-0.20856E+01,-0.21012E+01,-0.21168E+01,-0.21324E+01,&
     -0.21479E+01,-0.21634E+01,-0.21788E+01,-0.21942E+01,-0.22096E+01,&
     -0.22249E+01,-0.22401E+01,-0.22554E+01,-0.22705E+01,-0.22857E+01,&
     -0.23008E+01,-0.23159E+01,-0.23309E+01,-0.23459E+01,-0.23609E+01,&
     -0.23758E+01,-0.23907E+01,-0.24056E+01,-0.24204E+01,-0.24352E+01,&
     -0.24500E+01,-0.24647E+01,-0.24795E+01,-0.24941E+01,-0.25088E+01,&
     -0.25234E+01,-0.25380E+01,-0.25526E+01,-0.25672E+01,-0.25817E+01,&
     -0.25962E+01,-0.26107E+01,-0.26251E+01,-0.26395E+01,-0.26539E+01,&
     -0.26683E+01,-0.26827E+01,-0.26970E+01,-0.27113E+01,-0.27256E+01,&
     -0.27399E+01,-0.27541E+01,-0.27683E+01,-0.27825E+01,-0.27967E+01,&
     -0.28109E+01,-0.28250E+01,-0.28391E+01,-0.28532E+01,-0.28673E+01,&
     -0.28814E+01,-0.28954E+01,-0.29094E+01,-0.29235E+01,-0.29374E+01,&
     -0.29514E+01,-0.29654E+01,-0.29793E+01,-0.29932E+01,-0.30071E+01,&
     -0.30210E+01,-0.30349E+01,-0.30487E+01,-0.30626E+01,-0.30764E+01,&
     -0.30902E+01,-0.31040E+01,-0.31178E+01,-0.31315E+01,-0.31453E+01,&
     -0.31590E+01,-0.31727E+01,-0.31864E+01,-0.32001E+01,-0.32138E+01,&
     -0.32274E+01,-0.32411E+01,-0.32547E+01,-0.32683E+01,-0.32819E+01,&
     -0.32955E+01,-0.33091E+01,-0.33226E+01,-0.33362E+01,-0.33497E+01,&
     -0.33632E+01,-0.33767E+01,-0.33902E+01,-0.34037E+01,-0.34172E+01/
                             
     DATA (BNC07M(IA),IA=701,741)/                                      &
     -0.34307E+01,-0.34441E+01,-0.34576E+01,-0.34710E+01,-0.34844E+01,&
     -0.34978E+01,-0.35112E+01,-0.35246E+01,-0.35380E+01,-0.35513E+01,&
     -0.35647E+01,-0.35780E+01,-0.35913E+01,-0.36046E+01,-0.36179E+01,&
     -0.36312E+01,-0.36445E+01,-0.36578E+01,-0.36711E+01,-0.36843E+01,&
     -0.36976E+01,-0.37108E+01,-0.37240E+01,-0.37372E+01,-0.37504E+01,&
     -0.37636E+01,-0.37768E+01,-0.37900E+01,-0.38032E+01,-0.38163E+01,&
     -0.38295E+01,-0.38426E+01,-0.38557E+01,-0.38689E+01,-0.38820E+01,&
     -0.38951E+01,-0.39082E+01,-0.39213E+01,-0.39343E+01,-0.39474E+01,&
     -0.39605E+01                  /                      
!                            
!  ** (H, HSO4)              
!                            
     DATA (BNC08M (IA),IA=  1,100)/                                     &
     -0.51998E-01,-0.87278E-01,-0.10725E+00,-0.11796E+00,-0.12426E+00,&
     -0.12788E+00,-0.12969E+00,-0.13016E+00,-0.12958E+00,-0.12816E+00,&
     -0.12603E+00,-0.12329E+00,-0.12003E+00,-0.11630E+00,-0.11215E+00,&
     -0.10761E+00,-0.10272E+00,-0.97512E-01,-0.91996E-01,-0.86196E-01,&
     -0.80129E-01,-0.73810E-01,-0.67251E-01,-0.60465E-01,-0.53463E-01,&
     -0.46254E-01,-0.38847E-01,-0.31251E-01,-0.23474E-01,-0.15524E-01,&
     -0.74071E-02, 0.86952E-03, 0.92994E-02, 0.17876E-01, 0.26595E-01,&
      0.35448E-01, 0.44432E-01, 0.53541E-01, 0.62769E-01, 0.72112E-01,&
      0.81565E-01, 0.91123E-01, 0.10078E+00, 0.11054E+00, 0.12039E+00,&
      0.13032E+00, 0.14035E+00, 0.15045E+00, 0.16063E+00, 0.17089E+00,&
      0.18122E+00, 0.19162E+00, 0.20209E+00, 0.21262E+00, 0.22321E+00,&
      0.23386E+00, 0.24457E+00, 0.25534E+00, 0.26617E+00, 0.27704E+00,&
      0.28797E+00, 0.29896E+00, 0.30999E+00, 0.32108E+00, 0.33221E+00,&
      0.34340E+00, 0.35464E+00, 0.36593E+00, 0.37727E+00, 0.38867E+00,&
      0.40012E+00, 0.41162E+00, 0.42317E+00, 0.43478E+00, 0.44645E+00,&
      0.45817E+00, 0.46995E+00, 0.48179E+00, 0.49369E+00, 0.50566E+00,&
      0.51768E+00, 0.52976E+00, 0.54191E+00, 0.55412E+00, 0.56639E+00,&
      0.57873E+00, 0.59114E+00, 0.60360E+00, 0.61613E+00, 0.62873E+00,&
      0.64138E+00, 0.65410E+00, 0.66688E+00, 0.67973E+00, 0.69263E+00,&
      0.70559E+00, 0.71860E+00, 0.73167E+00, 0.74480E+00, 0.75797E+00/
                             
     DATA (BNC08M (IA),IA=101,200)/                                     &
      0.77120E+00, 0.78447E+00, 0.79778E+00, 0.81114E+00, 0.82454E+00,&
      0.83797E+00, 0.85144E+00, 0.86495E+00, 0.87848E+00, 0.89204E+00,&
      0.90562E+00, 0.91923E+00, 0.93286E+00, 0.94651E+00, 0.96017E+00,&
      0.97384E+00, 0.98753E+00, 0.10012E+01, 0.10149E+01, 0.10286E+01,&
      0.10411E+01, 0.10550E+01, 0.10688E+01, 0.10826E+01, 0.10964E+01,&
      0.11102E+01, 0.11240E+01, 0.11377E+01, 0.11514E+01, 0.11651E+01,&
      0.11788E+01, 0.11925E+01, 0.12061E+01, 0.12198E+01, 0.12334E+01,&
      0.12470E+01, 0.12605E+01, 0.12741E+01, 0.12876E+01, 0.13011E+01,&
      0.13145E+01, 0.13280E+01, 0.13414E+01, 0.13548E+01, 0.13682E+01,&
      0.13815E+01, 0.13949E+01, 0.14082E+01, 0.14214E+01, 0.14347E+01,&
      0.14479E+01, 0.14611E+01, 0.14743E+01, 0.14875E+01, 0.15006E+01,&
      0.15137E+01, 0.15267E+01, 0.15398E+01, 0.15528E+01, 0.15658E+01,&
      0.15788E+01, 0.15917E+01, 0.16046E+01, 0.16175E+01, 0.16304E+01,&
      0.16432E+01, 0.16560E+01, 0.16688E+01, 0.16815E+01, 0.16942E+01,&
      0.17069E+01, 0.17196E+01, 0.17322E+01, 0.17448E+01, 0.17574E+01,&
      0.17700E+01, 0.17825E+01, 0.17950E+01, 0.18075E+01, 0.18199E+01,&
      0.18324E+01, 0.18447E+01, 0.18571E+01, 0.18694E+01, 0.18818E+01,&
      0.18940E+01, 0.19063E+01, 0.19185E+01, 0.19307E+01, 0.19429E+01,&
      0.19550E+01, 0.19671E+01, 0.19792E+01, 0.19913E+01, 0.20033E+01,&
      0.20153E+01, 0.20273E+01, 0.20393E+01, 0.20512E+01, 0.20631E+01/
                             
     DATA (BNC08M (IA),IA=201,300)/                                     &
      0.20750E+01, 0.20868E+01, 0.20986E+01, 0.21104E+01, 0.21222E+01,&
      0.21339E+01, 0.21456E+01, 0.21573E+01, 0.21690E+01, 0.21806E+01,&
      0.21922E+01, 0.22038E+01, 0.22153E+01, 0.22269E+01, 0.22384E+01,&
      0.22498E+01, 0.22613E+01, 0.22727E+01, 0.22841E+01, 0.22955E+01,&
      0.23068E+01, 0.23181E+01, 0.23294E+01, 0.23407E+01, 0.23520E+01,&
      0.23632E+01, 0.23744E+01, 0.23855E+01, 0.23967E+01, 0.24078E+01,&
      0.24189E+01, 0.24299E+01, 0.24410E+01, 0.24520E+01, 0.24630E+01,&
      0.24740E+01, 0.24849E+01, 0.24958E+01, 0.25067E+01, 0.25176E+01,&
      0.25284E+01, 0.25393E+01, 0.25501E+01, 0.25608E+01, 0.25716E+01,&
      0.25823E+01, 0.25930E+01, 0.26037E+01, 0.26143E+01, 0.26250E+01,&
      0.26356E+01, 0.26462E+01, 0.26567E+01, 0.26673E+01, 0.26778E+01,&
      0.26883E+01, 0.26988E+01, 0.27092E+01, 0.27196E+01, 0.27300E+01,&
      0.27404E+01, 0.27508E+01, 0.27611E+01, 0.27714E+01, 0.27817E+01,&
      0.27920E+01, 0.28022E+01, 0.28124E+01, 0.28226E+01, 0.28328E+01,&
      0.28430E+01, 0.28531E+01, 0.28632E+01, 0.28733E+01, 0.28834E+01,&
      0.28934E+01, 0.29034E+01, 0.29134E+01, 0.29234E+01, 0.29334E+01,&
      0.29433E+01, 0.29533E+01, 0.29632E+01, 0.29730E+01, 0.29829E+01,&
      0.29927E+01, 0.30026E+01, 0.30123E+01, 0.30221E+01, 0.30319E+01,&
      0.30416E+01, 0.30513E+01, 0.30610E+01, 0.30707E+01, 0.30804E+01,&
      0.30900E+01, 0.30996E+01, 0.31092E+01, 0.31188E+01, 0.31283E+01/
                             
     DATA (BNC08M (IA),IA=301,400)/                                     &
      0.31379E+01, 0.31474E+01, 0.31569E+01, 0.31663E+01, 0.31758E+01,&
      0.31852E+01, 0.31947E+01, 0.32041E+01, 0.32134E+01, 0.32228E+01,&
      0.32321E+01, 0.32415E+01, 0.32508E+01, 0.32601E+01, 0.32693E+01,&
      0.32786E+01, 0.32878E+01, 0.32970E+01, 0.33062E+01, 0.33154E+01,&
      0.33245E+01, 0.33337E+01, 0.33428E+01, 0.33519E+01, 0.33610E+01,&
      0.33701E+01, 0.33791E+01, 0.33881E+01, 0.33971E+01, 0.34061E+01,&
      0.34151E+01, 0.34241E+01, 0.34330E+01, 0.34419E+01, 0.34508E+01,&
      0.34597E+01, 0.34686E+01, 0.34775E+01, 0.34863E+01, 0.34951E+01,&
      0.35039E+01, 0.35127E+01, 0.35215E+01, 0.35302E+01, 0.35390E+01,&
      0.35477E+01, 0.35564E+01, 0.35651E+01, 0.35737E+01, 0.35824E+01,&
      0.35910E+01, 0.35996E+01, 0.36083E+01, 0.36168E+01, 0.36254E+01,&
      0.36340E+01, 0.36425E+01, 0.36510E+01, 0.36595E+01, 0.36680E+01,&
      0.36765E+01, 0.36850E+01, 0.36934E+01, 0.37018E+01, 0.37102E+01,&
      0.37186E+01, 0.37270E+01, 0.37354E+01, 0.37437E+01, 0.37521E+01,&
      0.37604E+01, 0.37687E+01, 0.37770E+01, 0.37852E+01, 0.37935E+01,&
      0.38017E+01, 0.38100E+01, 0.38182E+01, 0.38264E+01, 0.38345E+01,&
      0.38427E+01, 0.38509E+01, 0.38590E+01, 0.38671E+01, 0.38752E+01,&
      0.38833E+01, 0.38914E+01, 0.38995E+01, 0.39075E+01, 0.39155E+01,&
      0.39236E+01, 0.39316E+01, 0.39396E+01, 0.39475E+01, 0.39555E+01,&
      0.39634E+01, 0.39714E+01, 0.39793E+01, 0.39872E+01, 0.39951E+01/
                             
     DATA (BNC08M (IA),IA=401,500)/                                     &
      0.40030E+01, 0.40108E+01, 0.40187E+01, 0.40265E+01, 0.40343E+01,&
      0.40421E+01, 0.40499E+01, 0.40577E+01, 0.40655E+01, 0.40732E+01,&
      0.40810E+01, 0.40887E+01, 0.40964E+01, 0.41041E+01, 0.41118E+01,&
      0.41195E+01, 0.41272E+01, 0.41348E+01, 0.41424E+01, 0.41501E+01,&
      0.41577E+01, 0.41653E+01, 0.41728E+01, 0.41804E+01, 0.41880E+01,&
      0.41955E+01, 0.42030E+01, 0.42105E+01, 0.42181E+01, 0.42255E+01,&
      0.42330E+01, 0.42405E+01, 0.42479E+01, 0.42554E+01, 0.42628E+01,&
      0.42702E+01, 0.42776E+01, 0.42850E+01, 0.42924E+01, 0.42998E+01,&
      0.43071E+01, 0.43145E+01, 0.43218E+01, 0.43291E+01, 0.43364E+01,&
      0.43437E+01, 0.43510E+01, 0.43583E+01, 0.43655E+01, 0.43728E+01,&
      0.43800E+01, 0.43872E+01, 0.43944E+01, 0.44016E+01, 0.44088E+01,&
      0.44160E+01, 0.44231E+01, 0.44303E+01, 0.44374E+01, 0.44446E+01,&
      0.44517E+01, 0.44588E+01, 0.44659E+01, 0.44729E+01, 0.44800E+01,&
      0.44871E+01, 0.44941E+01, 0.45012E+01, 0.45082E+01, 0.45152E+01,&
      0.45222E+01, 0.45292E+01, 0.45362E+01, 0.45431E+01, 0.45501E+01,&
      0.45570E+01, 0.45640E+01, 0.45709E+01, 0.45778E+01, 0.45847E+01,&
      0.45916E+01, 0.45985E+01, 0.46053E+01, 0.46122E+01, 0.46190E+01,&
      0.46259E+01, 0.46327E+01, 0.46395E+01, 0.46463E+01, 0.46531E+01,&
      0.46599E+01, 0.46667E+01, 0.46734E+01, 0.46802E+01, 0.46869E+01,&
      0.46936E+01, 0.47004E+01, 0.47071E+01, 0.47138E+01, 0.47205E+01/
                             
     DATA (BNC08M (IA),IA=501,600)/                                     &
      0.47271E+01, 0.47338E+01, 0.47405E+01, 0.47471E+01, 0.47537E+01,&
      0.47604E+01, 0.47670E+01, 0.47736E+01, 0.47802E+01, 0.47868E+01,&
      0.47934E+01, 0.47999E+01, 0.48065E+01, 0.48130E+01, 0.48196E+01,&
      0.48261E+01, 0.48326E+01, 0.48391E+01, 0.48456E+01, 0.48521E+01,&
      0.48586E+01, 0.48650E+01, 0.48715E+01, 0.48779E+01, 0.48844E+01,&
      0.48908E+01, 0.48972E+01, 0.49036E+01, 0.49100E+01, 0.49164E+01,&
      0.49228E+01, 0.49292E+01, 0.49355E+01, 0.49419E+01, 0.49482E+01,&
      0.49546E+01, 0.49609E+01, 0.49672E+01, 0.49735E+01, 0.49798E+01,&
      0.49861E+01, 0.49924E+01, 0.49986E+01, 0.50049E+01, 0.50112E+01,&
      0.50174E+01, 0.50236E+01, 0.50299E+01, 0.50361E+01, 0.50423E+01,&
      0.50485E+01, 0.50547E+01, 0.50608E+01, 0.50670E+01, 0.50732E+01,&
      0.50793E+01, 0.50855E+01, 0.50916E+01, 0.50977E+01, 0.51038E+01,&
      0.51099E+01, 0.51160E+01, 0.51221E+01, 0.51282E+01, 0.51343E+01,&
      0.51403E+01, 0.51464E+01, 0.51524E+01, 0.51585E+01, 0.51645E+01,&
      0.51705E+01, 0.51765E+01, 0.51825E+01, 0.51885E+01, 0.51945E+01,&
      0.52005E+01, 0.52065E+01, 0.52124E+01, 0.52184E+01, 0.52243E+01,&
      0.52303E+01, 0.52362E+01, 0.52421E+01, 0.52480E+01, 0.52539E+01,&
      0.52598E+01, 0.52657E+01, 0.52716E+01, 0.52775E+01, 0.52833E+01,&
      0.52892E+01, 0.52950E+01, 0.53009E+01, 0.53067E+01, 0.53125E+01,&
      0.53183E+01, 0.53241E+01, 0.53299E+01, 0.53357E+01, 0.53574E+01/
                             
     DATA (BNC08M (IA),IA=601,700)/                                     &
      0.54046E+01, 0.54611E+01, 0.55169E+01, 0.55719E+01, 0.56263E+01,&
      0.56799E+01, 0.57328E+01, 0.57851E+01, 0.58367E+01, 0.58877E+01,&
      0.59380E+01, 0.59878E+01, 0.60369E+01, 0.60855E+01, 0.61334E+01,&
      0.61808E+01, 0.62277E+01, 0.62740E+01, 0.63198E+01, 0.63651E+01,&
      0.64099E+01, 0.64542E+01, 0.64979E+01, 0.65413E+01, 0.65841E+01,&
      0.66265E+01, 0.66684E+01, 0.67099E+01, 0.67509E+01, 0.67916E+01,&
      0.68318E+01, 0.68715E+01, 0.69109E+01, 0.69499E+01, 0.69885E+01,&
      0.70267E+01, 0.70646E+01, 0.71020E+01, 0.71391E+01, 0.71759E+01,&
      0.72123E+01, 0.72483E+01, 0.72840E+01, 0.73194E+01, 0.73544E+01,&
      0.73891E+01, 0.74235E+01, 0.74576E+01, 0.74914E+01, 0.75248E+01,&
      0.75580E+01, 0.75909E+01, 0.76234E+01, 0.76557E+01, 0.76877E+01,&
      0.77195E+01, 0.77509E+01, 0.77821E+01, 0.78130E+01, 0.78437E+01,&
      0.78741E+01, 0.79042E+01, 0.79341E+01, 0.79637E+01, 0.79931E+01,&
      0.80223E+01, 0.80512E+01, 0.80799E+01, 0.81083E+01, 0.81365E+01,&
      0.81645E+01, 0.81923E+01, 0.82199E+01, 0.82472E+01, 0.82743E+01,&
      0.83012E+01, 0.83279E+01, 0.83544E+01, 0.83807E+01, 0.84068E+01,&
      0.84327E+01, 0.84584E+01, 0.84839E+01, 0.85093E+01, 0.85344E+01,&
      0.85593E+01, 0.85841E+01, 0.86087E+01, 0.86331E+01, 0.86573E+01,&
      0.86813E+01, 0.87052E+01, 0.87289E+01, 0.87524E+01, 0.87758E+01,&
      0.87990E+01, 0.88220E+01, 0.88449E+01, 0.88676E+01, 0.88902E+01/
                             
     DATA (BNC08M(IA),IA=701,741)/                                      &
      0.89126E+01, 0.89348E+01, 0.89569E+01, 0.89789E+01, 0.90006E+01,&
      0.90223E+01, 0.90438E+01, 0.90651E+01, 0.90863E+01, 0.91074E+01,&
      0.91283E+01, 0.91491E+01, 0.91698E+01, 0.91903E+01, 0.92107E+01,&
      0.92309E+01, 0.92510E+01, 0.92710E+01, 0.92909E+01, 0.93106E+01,&
      0.93302E+01, 0.93497E+01, 0.93690E+01, 0.93883E+01, 0.94074E+01,&
      0.94264E+01, 0.94452E+01, 0.94640E+01, 0.94826E+01, 0.95011E+01,&
      0.95195E+01, 0.95378E+01, 0.95560E+01, 0.95741E+01, 0.95920E+01,&
      0.96099E+01, 0.96276E+01, 0.96452E+01, 0.96628E+01, 0.96802E+01,&
      0.96975E+01                  /                      
!                            
!  ** NH4HSO4                
!                            
     DATA (BNC09M (IA),IA=  1,100)/                                     &
     -0.55422E-01,-0.99324E-01,-0.12935E+00,-0.14934E+00,-0.16445E+00,&
     -0.17660E+00,-0.18672E+00,-0.19536E+00,-0.20285E+00,-0.20943E+00,&
     -0.21526E+00,-0.22046E+00,-0.22511E+00,-0.22929E+00,-0.23305E+00,&
     -0.23643E+00,-0.23948E+00,-0.24222E+00,-0.24468E+00,-0.24688E+00,&
     -0.24884E+00,-0.25058E+00,-0.25210E+00,-0.25342E+00,-0.25456E+00,&
     -0.25551E+00,-0.25630E+00,-0.25692E+00,-0.25739E+00,-0.25771E+00,&
     -0.25789E+00,-0.25794E+00,-0.25785E+00,-0.25763E+00,-0.25730E+00,&
     -0.25685E+00,-0.25628E+00,-0.25561E+00,-0.25483E+00,-0.25395E+00,&
     -0.25297E+00,-0.25190E+00,-0.25074E+00,-0.24948E+00,-0.24815E+00,&
     -0.24673E+00,-0.24523E+00,-0.24366E+00,-0.24201E+00,-0.24029E+00,&
     -0.23850E+00,-0.23664E+00,-0.23472E+00,-0.23274E+00,-0.23069E+00,&
     -0.22859E+00,-0.22643E+00,-0.22421E+00,-0.22194E+00,-0.21962E+00,&
     -0.21725E+00,-0.21483E+00,-0.21236E+00,-0.20985E+00,-0.20729E+00,&
     -0.20468E+00,-0.20203E+00,-0.19934E+00,-0.19661E+00,-0.19384E+00,&
     -0.19102E+00,-0.18817E+00,-0.18528E+00,-0.18235E+00,-0.17938E+00,&
     -0.17637E+00,-0.17333E+00,-0.17025E+00,-0.16713E+00,-0.16398E+00,&
     -0.16079E+00,-0.15757E+00,-0.15431E+00,-0.15101E+00,-0.14768E+00,&
     -0.14432E+00,-0.14092E+00,-0.13750E+00,-0.13403E+00,-0.13054E+00,&
     -0.12701E+00,-0.12346E+00,-0.11987E+00,-0.11626E+00,-0.11261E+00,&
     -0.10894E+00,-0.10524E+00,-0.10152E+00,-0.97765E-01,-0.93990E-01/
                             
     DATA (BNC09M (IA),IA=101,200)/                                     &
     -0.90192E-01,-0.86371E-01,-0.82530E-01,-0.78668E-01,-0.74788E-01,&
     -0.70889E-01,-0.66974E-01,-0.63042E-01,-0.59097E-01,-0.55137E-01,&
     -0.51165E-01,-0.47182E-01,-0.43188E-01,-0.39185E-01,-0.35173E-01,&
     -0.31154E-01,-0.27129E-01,-0.23099E-01,-0.19063E-01,-0.15024E-01,&
     -0.11398E-01,-0.73058E-02,-0.32173E-02, 0.86749E-03, 0.49480E-02,&
      0.90243E-02, 0.13096E-01, 0.17162E-01, 0.21224E-01, 0.25280E-01,&
      0.29330E-01, 0.33374E-01, 0.37412E-01, 0.41443E-01, 0.45469E-01,&
      0.49487E-01, 0.53498E-01, 0.57502E-01, 0.61499E-01, 0.65488E-01,&
      0.69470E-01, 0.73444E-01, 0.77410E-01, 0.81368E-01, 0.85318E-01,&
      0.89260E-01, 0.93194E-01, 0.97118E-01, 0.10103E+00, 0.10494E+00,&
      0.10884E+00, 0.11273E+00, 0.11661E+00, 0.12049E+00, 0.12435E+00,&
      0.12820E+00, 0.13205E+00, 0.13588E+00, 0.13971E+00, 0.14353E+00,&
      0.14733E+00, 0.15113E+00, 0.15492E+00, 0.15870E+00, 0.16247E+00,&
      0.16623E+00, 0.16998E+00, 0.17373E+00, 0.17746E+00, 0.18118E+00,&
      0.18489E+00, 0.18860E+00, 0.19229E+00, 0.19597E+00, 0.19965E+00,&
      0.20331E+00, 0.20697E+00, 0.21061E+00, 0.21425E+00, 0.21787E+00,&
      0.22149E+00, 0.22510E+00, 0.22869E+00, 0.23228E+00, 0.23586E+00,&
      0.23943E+00, 0.24299E+00, 0.24654E+00, 0.25008E+00, 0.25361E+00,&
      0.25713E+00, 0.26064E+00, 0.26414E+00, 0.26763E+00, 0.27112E+00,&
      0.27459E+00, 0.27805E+00, 0.28151E+00, 0.28495E+00, 0.28839E+00/
                             
     DATA (BNC09M (IA),IA=201,300)/                                     &
      0.29182E+00, 0.29523E+00, 0.29864E+00, 0.30204E+00, 0.30543E+00,&
      0.30881E+00, 0.31218E+00, 0.31555E+00, 0.31890E+00, 0.32225E+00,&
      0.32558E+00, 0.32891E+00, 0.33223E+00, 0.33553E+00, 0.33883E+00,&
      0.34213E+00, 0.34541E+00, 0.34868E+00, 0.35195E+00, 0.35520E+00,&
      0.35845E+00, 0.36169E+00, 0.36492E+00, 0.36814E+00, 0.37135E+00,&
      0.37456E+00, 0.37775E+00, 0.38094E+00, 0.38412E+00, 0.38729E+00,&
      0.39045E+00, 0.39361E+00, 0.39675E+00, 0.39989E+00, 0.40302E+00,&
      0.40614E+00, 0.40925E+00, 0.41236E+00, 0.41546E+00, 0.41854E+00,&
      0.42162E+00, 0.42470E+00, 0.42776E+00, 0.43082E+00, 0.43387E+00,&
      0.43691E+00, 0.43994E+00, 0.44297E+00, 0.44598E+00, 0.44899E+00,&
      0.45200E+00, 0.45499E+00, 0.45798E+00, 0.46096E+00, 0.46393E+00,&
      0.46689E+00, 0.46985E+00, 0.47280E+00, 0.47574E+00, 0.47867E+00,&
      0.48160E+00, 0.48452E+00, 0.48743E+00, 0.49033E+00, 0.49323E+00,&
      0.49612E+00, 0.49900E+00, 0.50188E+00, 0.50475E+00, 0.50761E+00,&
      0.51046E+00, 0.51331E+00, 0.51615E+00, 0.51898E+00, 0.52181E+00,&
      0.52463E+00, 0.52744E+00, 0.53025E+00, 0.53305E+00, 0.53584E+00,&
      0.53862E+00, 0.54140E+00, 0.54417E+00, 0.54694E+00, 0.54969E+00,&
      0.55244E+00, 0.55519E+00, 0.55793E+00, 0.56066E+00, 0.56338E+00,&
      0.56610E+00, 0.56881E+00, 0.57152E+00, 0.57422E+00, 0.57691E+00,&
      0.57959E+00, 0.58227E+00, 0.58495E+00, 0.58761E+00, 0.59027E+00/
                             
     DATA (BNC09M (IA),IA=301,400)/                                     &
      0.59293E+00, 0.59558E+00, 0.59822E+00, 0.60085E+00, 0.60348E+00,&
      0.60611E+00, 0.60872E+00, 0.61133E+00, 0.61394E+00, 0.61654E+00,&
      0.61913E+00, 0.62172E+00, 0.62430E+00, 0.62687E+00, 0.62944E+00,&
      0.63200E+00, 0.63456E+00, 0.63711E+00, 0.63966E+00, 0.64219E+00,&
      0.64473E+00, 0.64726E+00, 0.64978E+00, 0.65229E+00, 0.65480E+00,&
      0.65731E+00, 0.65981E+00, 0.66230E+00, 0.66479E+00, 0.66727E+00,&
      0.66975E+00, 0.67222E+00, 0.67468E+00, 0.67714E+00, 0.67960E+00,&
      0.68205E+00, 0.68449E+00, 0.68693E+00, 0.68936E+00, 0.69179E+00,&
      0.69421E+00, 0.69663E+00, 0.69904E+00, 0.70144E+00, 0.70384E+00,&
      0.70624E+00, 0.70863E+00, 0.71101E+00, 0.71339E+00, 0.71577E+00,&
      0.71813E+00, 0.72050E+00, 0.72286E+00, 0.72521E+00, 0.72756E+00,&
      0.72990E+00, 0.73224E+00, 0.73457E+00, 0.73690E+00, 0.73922E+00,&
      0.74154E+00, 0.74386E+00, 0.74616E+00, 0.74847E+00, 0.75076E+00,&
      0.75306E+00, 0.75535E+00, 0.75763E+00, 0.75991E+00, 0.76218E+00,&
      0.76445E+00, 0.76671E+00, 0.76897E+00, 0.77123E+00, 0.77348E+00,&
      0.77572E+00, 0.77796E+00, 0.78020E+00, 0.78243E+00, 0.78465E+00,&
      0.78687E+00, 0.78909E+00, 0.79130E+00, 0.79351E+00, 0.79571E+00,&
      0.79791E+00, 0.80010E+00, 0.80229E+00, 0.80448E+00, 0.80666E+00,&
      0.80883E+00, 0.81100E+00, 0.81317E+00, 0.81533E+00, 0.81749E+00,&
      0.81964E+00, 0.82179E+00, 0.82394E+00, 0.82608E+00, 0.82821E+00/
                             
     DATA (BNC09M (IA),IA=401,500)/                                     &
      0.83034E+00, 0.83247E+00, 0.83459E+00, 0.83671E+00, 0.83882E+00,&
      0.84093E+00, 0.84304E+00, 0.84514E+00, 0.84723E+00, 0.84933E+00,&
      0.85141E+00, 0.85350E+00, 0.85558E+00, 0.85765E+00, 0.85972E+00,&
      0.86179E+00, 0.86385E+00, 0.86591E+00, 0.86797E+00, 0.87002E+00,&
      0.87207E+00, 0.87411E+00, 0.87615E+00, 0.87818E+00, 0.88021E+00,&
      0.88224E+00, 0.88426E+00, 0.88628E+00, 0.88829E+00, 0.89030E+00,&
      0.89231E+00, 0.89431E+00, 0.89631E+00, 0.89830E+00, 0.90029E+00,&
      0.90228E+00, 0.90426E+00, 0.90624E+00, 0.90822E+00, 0.91019E+00,&
      0.91216E+00, 0.91412E+00, 0.91608E+00, 0.91803E+00, 0.91999E+00,&
      0.92193E+00, 0.92388E+00, 0.92582E+00, 0.92776E+00, 0.92969E+00,&
      0.93162E+00, 0.93354E+00, 0.93547E+00, 0.93738E+00, 0.93930E+00,&
      0.94121E+00, 0.94312E+00, 0.94502E+00, 0.94692E+00, 0.94882E+00,&
      0.95071E+00, 0.95260E+00, 0.95448E+00, 0.95637E+00, 0.95824E+00,&
      0.96012E+00, 0.96199E+00, 0.96386E+00, 0.96572E+00, 0.96758E+00,&
      0.96944E+00, 0.97129E+00, 0.97314E+00, 0.97499E+00, 0.97683E+00,&
      0.97867E+00, 0.98051E+00, 0.98234E+00, 0.98417E+00, 0.98600E+00,&
      0.98782E+00, 0.98964E+00, 0.99145E+00, 0.99327E+00, 0.99507E+00,&
      0.99688E+00, 0.99868E+00, 0.10005E+01, 0.10023E+01, 0.10041E+01,&
      0.10059E+01, 0.10076E+01, 0.10094E+01, 0.10112E+01, 0.10130E+01,&
      0.10148E+01, 0.10165E+01, 0.10183E+01, 0.10200E+01, 0.10218E+01/
                             
     DATA (BNC09M (IA),IA=501,600)/                                     &
      0.10236E+01, 0.10253E+01, 0.10271E+01, 0.10288E+01, 0.10306E+01,&
      0.10323E+01, 0.10340E+01, 0.10358E+01, 0.10375E+01, 0.10392E+01,&
      0.10409E+01, 0.10427E+01, 0.10444E+01, 0.10461E+01, 0.10478E+01,&
      0.10495E+01, 0.10512E+01, 0.10529E+01, 0.10546E+01, 0.10563E+01,&
      0.10580E+01, 0.10597E+01, 0.10614E+01, 0.10631E+01, 0.10648E+01,&
      0.10664E+01, 0.10681E+01, 0.10698E+01, 0.10715E+01, 0.10731E+01,&
      0.10748E+01, 0.10765E+01, 0.10781E+01, 0.10798E+01, 0.10814E+01,&
      0.10831E+01, 0.10847E+01, 0.10864E+01, 0.10880E+01, 0.10896E+01,&
      0.10913E+01, 0.10929E+01, 0.10945E+01, 0.10961E+01, 0.10978E+01,&
      0.10994E+01, 0.11010E+01, 0.11026E+01, 0.11042E+01, 0.11058E+01,&
      0.11074E+01, 0.11090E+01, 0.11106E+01, 0.11122E+01, 0.11138E+01,&
      0.11154E+01, 0.11170E+01, 0.11186E+01, 0.11202E+01, 0.11218E+01,&
      0.11233E+01, 0.11249E+01, 0.11265E+01, 0.11281E+01, 0.11296E+01,&
      0.11312E+01, 0.11328E+01, 0.11343E+01, 0.11359E+01, 0.11374E+01,&
      0.11390E+01, 0.11405E+01, 0.11421E+01, 0.11436E+01, 0.11451E+01,&
      0.11467E+01, 0.11482E+01, 0.11497E+01, 0.11513E+01, 0.11528E+01,&
      0.11543E+01, 0.11559E+01, 0.11574E+01, 0.11589E+01, 0.11604E+01,&
      0.11619E+01, 0.11634E+01, 0.11649E+01, 0.11664E+01, 0.11679E+01,&
      0.11694E+01, 0.11709E+01, 0.11724E+01, 0.11739E+01, 0.11754E+01,&
      0.11769E+01, 0.11784E+01, 0.11798E+01, 0.11813E+01, 0.11868E+01/
                             
     DATA (BNC09M (IA),IA=601,700)/                                     &
      0.11989E+01, 0.12132E+01, 0.12273E+01, 0.12412E+01, 0.12549E+01,&
      0.12683E+01, 0.12816E+01, 0.12946E+01, 0.13074E+01, 0.13200E+01,&
      0.13324E+01, 0.13446E+01, 0.13566E+01, 0.13685E+01, 0.13801E+01,&
      0.13916E+01, 0.14029E+01, 0.14141E+01, 0.14250E+01, 0.14358E+01,&
      0.14465E+01, 0.14570E+01, 0.14673E+01, 0.14775E+01, 0.14875E+01,&
      0.14974E+01, 0.15072E+01, 0.15168E+01, 0.15262E+01, 0.15356E+01,&
      0.15448E+01, 0.15538E+01, 0.15628E+01, 0.15716E+01, 0.15803E+01,&
      0.15888E+01, 0.15973E+01, 0.16056E+01, 0.16138E+01, 0.16219E+01,&
      0.16299E+01, 0.16378E+01, 0.16455E+01, 0.16532E+01, 0.16608E+01,&
      0.16682E+01, 0.16756E+01, 0.16828E+01, 0.16900E+01, 0.16970E+01,&
      0.17040E+01, 0.17108E+01, 0.17176E+01, 0.17243E+01, 0.17308E+01,&
      0.17373E+01, 0.17438E+01, 0.17501E+01, 0.17563E+01, 0.17625E+01,&
      0.17685E+01, 0.17745E+01, 0.17804E+01, 0.17863E+01, 0.17920E+01,&
      0.17977E+01, 0.18033E+01, 0.18088E+01, 0.18142E+01, 0.18196E+01,&
      0.18249E+01, 0.18302E+01, 0.18353E+01, 0.18404E+01, 0.18454E+01,&
      0.18504E+01, 0.18553E+01, 0.18601E+01, 0.18649E+01, 0.18695E+01,&
      0.18742E+01, 0.18787E+01, 0.18832E+01, 0.18877E+01, 0.18921E+01,&
      0.18964E+01, 0.19007E+01, 0.19049E+01, 0.19090E+01, 0.19131E+01,&
      0.19171E+01, 0.19211E+01, 0.19250E+01, 0.19289E+01, 0.19327E+01,&
      0.19365E+01, 0.19402E+01, 0.19439E+01, 0.19475E+01, 0.19510E+01/
                             
     DATA (BNC09M(IA),IA=701,741)/                                      &
      0.19545E+01, 0.19580E+01, 0.19614E+01, 0.19647E+01, 0.19681E+01,&
      0.19713E+01, 0.19745E+01, 0.19777E+01, 0.19808E+01, 0.19839E+01,&
      0.19869E+01, 0.19899E+01, 0.19929E+01, 0.19958E+01, 0.19986E+01,&
      0.20014E+01, 0.20042E+01, 0.20069E+01, 0.20096E+01, 0.20123E+01,&
      0.20149E+01, 0.20175E+01, 0.20200E+01, 0.20225E+01, 0.20249E+01,&
      0.20273E+01, 0.20297E+01, 0.20320E+01, 0.20343E+01, 0.20366E+01,&
      0.20388E+01, 0.20410E+01, 0.20432E+01, 0.20453E+01, 0.20473E+01,&
      0.20494E+01, 0.20514E+01, 0.20534E+01, 0.20553E+01, 0.20572E+01,&
      0.20591E+01                  /                      
!                            
!  ** (H, NO3)               
!                            
     DATA (BNC10M (IA),IA=  1,100)/                                     &
     -0.54443E-01,-0.95281E-01,-0.12118E+00,-0.13706E+00,-0.14810E+00,&
     -0.15622E+00,-0.16239E+00,-0.16713E+00,-0.17079E+00,-0.17360E+00,&
     -0.17573E+00,-0.17729E+00,-0.17838E+00,-0.17908E+00,-0.17943E+00,&
     -0.17948E+00,-0.17928E+00,-0.17885E+00,-0.17821E+00,-0.17740E+00,&
     -0.17642E+00,-0.17531E+00,-0.17407E+00,-0.17271E+00,-0.17124E+00,&
     -0.16969E+00,-0.16805E+00,-0.16633E+00,-0.16455E+00,-0.16270E+00,&
     -0.16080E+00,-0.15884E+00,-0.15684E+00,-0.15480E+00,-0.15272E+00,&
     -0.15061E+00,-0.14847E+00,-0.14631E+00,-0.14412E+00,-0.14191E+00,&
     -0.13968E+00,-0.13744E+00,-0.13518E+00,-0.13291E+00,-0.13063E+00,&
     -0.12834E+00,-0.12605E+00,-0.12375E+00,-0.12144E+00,-0.11913E+00,&
     -0.11682E+00,-0.11450E+00,-0.11218E+00,-0.10986E+00,-0.10754E+00,&
     -0.10521E+00,-0.10289E+00,-0.10056E+00,-0.98232E-01,-0.95901E-01,&
     -0.93569E-01,-0.91233E-01,-0.88895E-01,-0.86553E-01,-0.84207E-01,&
     -0.81856E-01,-0.79499E-01,-0.77136E-01,-0.74766E-01,-0.72388E-01,&
     -0.70002E-01,-0.67607E-01,-0.65201E-01,-0.62784E-01,-0.60355E-01,&
     -0.57914E-01,-0.55459E-01,-0.52990E-01,-0.50507E-01,-0.48008E-01,&
     -0.45493E-01,-0.42962E-01,-0.40413E-01,-0.37847E-01,-0.35263E-01,&
     -0.32660E-01,-0.30039E-01,-0.27400E-01,-0.24741E-01,-0.22063E-01,&
     -0.19367E-01,-0.16651E-01,-0.13917E-01,-0.11164E-01,-0.83926E-02,&
     -0.56031E-02,-0.27959E-02, 0.28739E-04, 0.28702E-02, 0.57282E-02/
                             
     DATA (BNC10M (IA),IA=101,200)/                                     &
      0.86021E-02, 0.11491E-01, 0.14395E-01, 0.17314E-01, 0.20245E-01,&
      0.23190E-01, 0.26147E-01, 0.29115E-01, 0.32095E-01, 0.35084E-01,&
      0.38083E-01, 0.41091E-01, 0.44107E-01, 0.47130E-01, 0.50160E-01,&
      0.53197E-01, 0.56239E-01, 0.59286E-01, 0.62338E-01, 0.65393E-01,&
      0.68068E-01, 0.71174E-01, 0.74277E-01, 0.77379E-01, 0.80478E-01,&
      0.83575E-01, 0.86669E-01, 0.89761E-01, 0.92850E-01, 0.95936E-01,&
      0.99019E-01, 0.10210E+00, 0.10518E+00, 0.10825E+00, 0.11132E+00,&
      0.11439E+00, 0.11746E+00, 0.12052E+00, 0.12358E+00, 0.12663E+00,&
      0.12968E+00, 0.13273E+00, 0.13578E+00, 0.13882E+00, 0.14185E+00,&
      0.14489E+00, 0.14792E+00, 0.15094E+00, 0.15397E+00, 0.15698E+00,&
      0.16000E+00, 0.16301E+00, 0.16601E+00, 0.16902E+00, 0.17201E+00,&
      0.17501E+00, 0.17800E+00, 0.18098E+00, 0.18396E+00, 0.18694E+00,&
      0.18991E+00, 0.19288E+00, 0.19585E+00, 0.19881E+00, 0.20176E+00,&
      0.20471E+00, 0.20766E+00, 0.21060E+00, 0.21354E+00, 0.21647E+00,&
      0.21940E+00, 0.22232E+00, 0.22524E+00, 0.22816E+00, 0.23107E+00,&
      0.23397E+00, 0.23687E+00, 0.23977E+00, 0.24266E+00, 0.24554E+00,&
      0.24843E+00, 0.25130E+00, 0.25418E+00, 0.25704E+00, 0.25991E+00,&
      0.26276E+00, 0.26562E+00, 0.26846E+00, 0.27131E+00, 0.27415E+00,&
      0.27698E+00, 0.27981E+00, 0.28263E+00, 0.28545E+00, 0.28827E+00,&
      0.29107E+00, 0.29388E+00, 0.29668E+00, 0.29947E+00, 0.30226E+00/
                             
     DATA (BNC10M (IA),IA=201,300)/                                     &
      0.30505E+00, 0.30783E+00, 0.31060E+00, 0.31337E+00, 0.31614E+00,&
      0.31890E+00, 0.32165E+00, 0.32440E+00, 0.32715E+00, 0.32989E+00,&
      0.33262E+00, 0.33535E+00, 0.33808E+00, 0.34080E+00, 0.34351E+00,&
      0.34622E+00, 0.34893E+00, 0.35163E+00, 0.35432E+00, 0.35701E+00,&
      0.35970E+00, 0.36238E+00, 0.36505E+00, 0.36772E+00, 0.37039E+00,&
      0.37305E+00, 0.37571E+00, 0.37836E+00, 0.38100E+00, 0.38364E+00,&
      0.38628E+00, 0.38891E+00, 0.39153E+00, 0.39416E+00, 0.39677E+00,&
      0.39938E+00, 0.40199E+00, 0.40459E+00, 0.40719E+00, 0.40978E+00,&
      0.41236E+00, 0.41495E+00, 0.41752E+00, 0.42009E+00, 0.42266E+00,&
      0.42522E+00, 0.42778E+00, 0.43033E+00, 0.43288E+00, 0.43542E+00,&
      0.43796E+00, 0.44049E+00, 0.44302E+00, 0.44554E+00, 0.44806E+00,&
      0.45057E+00, 0.45308E+00, 0.45559E+00, 0.45808E+00, 0.46058E+00,&
      0.46307E+00, 0.46555E+00, 0.46803E+00, 0.47051E+00, 0.47298E+00,&
      0.47544E+00, 0.47790E+00, 0.48036E+00, 0.48281E+00, 0.48526E+00,&
      0.48770E+00, 0.49013E+00, 0.49257E+00, 0.49499E+00, 0.49742E+00,&
      0.49983E+00, 0.50225E+00, 0.50466E+00, 0.50706E+00, 0.50946E+00,&
      0.51185E+00, 0.51424E+00, 0.51663E+00, 0.51901E+00, 0.52139E+00,&
      0.52376E+00, 0.52612E+00, 0.52849E+00, 0.53084E+00, 0.53320E+00,&
      0.53555E+00, 0.53789E+00, 0.54023E+00, 0.54257E+00, 0.54490E+00,&
      0.54722E+00, 0.54954E+00, 0.55186E+00, 0.55417E+00, 0.55648E+00/
                             
     DATA (BNC10M (IA),IA=301,400)/                                     &
      0.55878E+00, 0.56108E+00, 0.56338E+00, 0.56567E+00, 0.56795E+00,&
      0.57023E+00, 0.57251E+00, 0.57478E+00, 0.57705E+00, 0.57932E+00,&
      0.58157E+00, 0.58383E+00, 0.58608E+00, 0.58833E+00, 0.59057E+00,&
      0.59280E+00, 0.59504E+00, 0.59727E+00, 0.59949E+00, 0.60171E+00,&
      0.60393E+00, 0.60614E+00, 0.60835E+00, 0.61055E+00, 0.61275E+00,&
      0.61494E+00, 0.61713E+00, 0.61932E+00, 0.62150E+00, 0.62368E+00,&
      0.62585E+00, 0.62802E+00, 0.63018E+00, 0.63234E+00, 0.63450E+00,&
      0.63665E+00, 0.63880E+00, 0.64095E+00, 0.64309E+00, 0.64522E+00,&
      0.64735E+00, 0.64948E+00, 0.65161E+00, 0.65372E+00, 0.65584E+00,&
      0.65795E+00, 0.66006E+00, 0.66216E+00, 0.66426E+00, 0.66636E+00,&
      0.66845E+00, 0.67053E+00, 0.67262E+00, 0.67470E+00, 0.67677E+00,&
      0.67884E+00, 0.68091E+00, 0.68297E+00, 0.68503E+00, 0.68709E+00,&
      0.68914E+00, 0.69119E+00, 0.69323E+00, 0.69527E+00, 0.69731E+00,&
      0.69934E+00, 0.70137E+00, 0.70339E+00, 0.70541E+00, 0.70743E+00,&
      0.70944E+00, 0.71145E+00, 0.71346E+00, 0.71546E+00, 0.71745E+00,&
      0.71945E+00, 0.72144E+00, 0.72342E+00, 0.72541E+00, 0.72738E+00,&
      0.72936E+00, 0.73133E+00, 0.73330E+00, 0.73526E+00, 0.73722E+00,&
      0.73918E+00, 0.74113E+00, 0.74308E+00, 0.74502E+00, 0.74697E+00,&
      0.74890E+00, 0.75084E+00, 0.75277E+00, 0.75470E+00, 0.75662E+00,&
      0.75854E+00, 0.76046E+00, 0.76237E+00, 0.76428E+00, 0.76618E+00/
                             
     DATA (BNC10M (IA),IA=401,500)/                                     &
      0.76808E+00, 0.76998E+00, 0.77188E+00, 0.77377E+00, 0.77566E+00,&
      0.77754E+00, 0.77942E+00, 0.78130E+00, 0.78317E+00, 0.78504E+00,&
      0.78691E+00, 0.78877E+00, 0.79063E+00, 0.79249E+00, 0.79434E+00,&
      0.79619E+00, 0.79803E+00, 0.79988E+00, 0.80171E+00, 0.80355E+00,&
      0.80538E+00, 0.80721E+00, 0.80904E+00, 0.81086E+00, 0.81268E+00,&
      0.81449E+00, 0.81630E+00, 0.81811E+00, 0.81992E+00, 0.82172E+00,&
      0.82352E+00, 0.82531E+00, 0.82710E+00, 0.82889E+00, 0.83068E+00,&
      0.83246E+00, 0.83424E+00, 0.83601E+00, 0.83779E+00, 0.83955E+00,&
      0.84132E+00, 0.84308E+00, 0.84484E+00, 0.84660E+00, 0.84835E+00,&
      0.85010E+00, 0.85185E+00, 0.85359E+00, 0.85533E+00, 0.85707E+00,&
      0.85880E+00, 0.86053E+00, 0.86226E+00, 0.86398E+00, 0.86570E+00,&
      0.86742E+00, 0.86914E+00, 0.87085E+00, 0.87256E+00, 0.87426E+00,&
      0.87596E+00, 0.87766E+00, 0.87936E+00, 0.88105E+00, 0.88274E+00,&
      0.88443E+00, 0.88611E+00, 0.88779E+00, 0.88947E+00, 0.89115E+00,&
      0.89282E+00, 0.89449E+00, 0.89615E+00, 0.89782E+00, 0.89948E+00,&
      0.90113E+00, 0.90279E+00, 0.90444E+00, 0.90608E+00, 0.90773E+00,&
      0.90937E+00, 0.91101E+00, 0.91265E+00, 0.91428E+00, 0.91591E+00,&
      0.91754E+00, 0.91916E+00, 0.92078E+00, 0.92240E+00, 0.92402E+00,&
      0.92563E+00, 0.92724E+00, 0.92885E+00, 0.93045E+00, 0.93205E+00,&
      0.93365E+00, 0.93525E+00, 0.93684E+00, 0.93843E+00, 0.94002E+00/
                             
     DATA (BNC10M (IA),IA=501,600)/                                     &
      0.94160E+00, 0.94318E+00, 0.94476E+00, 0.94634E+00, 0.94791E+00,&
      0.94948E+00, 0.95105E+00, 0.95261E+00, 0.95418E+00, 0.95574E+00,&
      0.95729E+00, 0.95885E+00, 0.96040E+00, 0.96195E+00, 0.96349E+00,&
      0.96504E+00, 0.96658E+00, 0.96811E+00, 0.96965E+00, 0.97118E+00,&
      0.97271E+00, 0.97424E+00, 0.97576E+00, 0.97728E+00, 0.97880E+00,&
      0.98032E+00, 0.98183E+00, 0.98334E+00, 0.98485E+00, 0.98635E+00,&
      0.98786E+00, 0.98936E+00, 0.99086E+00, 0.99235E+00, 0.99384E+00,&
      0.99533E+00, 0.99682E+00, 0.99831E+00, 0.99979E+00, 0.10013E+01,&
      0.10027E+01, 0.10042E+01, 0.10057E+01, 0.10072E+01, 0.10086E+01,&
      0.10101E+01, 0.10116E+01, 0.10130E+01, 0.10145E+01, 0.10159E+01,&
      0.10174E+01, 0.10188E+01, 0.10203E+01, 0.10217E+01, 0.10232E+01,&
      0.10246E+01, 0.10260E+01, 0.10275E+01, 0.10289E+01, 0.10303E+01,&
      0.10318E+01, 0.10332E+01, 0.10346E+01, 0.10360E+01, 0.10374E+01,&
      0.10389E+01, 0.10403E+01, 0.10417E+01, 0.10431E+01, 0.10445E+01,&
      0.10459E+01, 0.10473E+01, 0.10487E+01, 0.10501E+01, 0.10515E+01,&
      0.10529E+01, 0.10543E+01, 0.10556E+01, 0.10570E+01, 0.10584E+01,&
      0.10598E+01, 0.10612E+01, 0.10625E+01, 0.10639E+01, 0.10653E+01,&
      0.10666E+01, 0.10680E+01, 0.10694E+01, 0.10707E+01, 0.10721E+01,&
      0.10734E+01, 0.10748E+01, 0.10762E+01, 0.10775E+01, 0.10788E+01,&
      0.10802E+01, 0.10815E+01, 0.10829E+01, 0.10842E+01, 0.10892E+01/
                             
     DATA (BNC10M (IA),IA=601,700)/                                     &
      0.11001E+01, 0.11131E+01, 0.11259E+01, 0.11384E+01, 0.11508E+01,&
      0.11629E+01, 0.11749E+01, 0.11867E+01, 0.11983E+01, 0.12097E+01,&
      0.12209E+01, 0.12319E+01, 0.12428E+01, 0.12535E+01, 0.12640E+01,&
      0.12744E+01, 0.12846E+01, 0.12946E+01, 0.13045E+01, 0.13142E+01,&
      0.13238E+01, 0.13333E+01, 0.13426E+01, 0.13517E+01, 0.13607E+01,&
      0.13696E+01, 0.13784E+01, 0.13870E+01, 0.13955E+01, 0.14038E+01,&
      0.14121E+01, 0.14202E+01, 0.14282E+01, 0.14361E+01, 0.14438E+01,&
      0.14515E+01, 0.14590E+01, 0.14664E+01, 0.14738E+01, 0.14810E+01,&
      0.14881E+01, 0.14951E+01, 0.15020E+01, 0.15088E+01, 0.15155E+01,&
      0.15221E+01, 0.15286E+01, 0.15350E+01, 0.15413E+01, 0.15475E+01,&
      0.15536E+01, 0.15597E+01, 0.15656E+01, 0.15715E+01, 0.15773E+01,&
      0.15830E+01, 0.15886E+01, 0.15942E+01, 0.15996E+01, 0.16050E+01,&
      0.16103E+01, 0.16155E+01, 0.16207E+01, 0.16258E+01, 0.16308E+01,&
      0.16357E+01, 0.16406E+01, 0.16453E+01, 0.16501E+01, 0.16547E+01,&
      0.16593E+01, 0.16638E+01, 0.16682E+01, 0.16726E+01, 0.16769E+01,&
      0.16812E+01, 0.16854E+01, 0.16895E+01, 0.16936E+01, 0.16976E+01,&
      0.17015E+01, 0.17054E+01, 0.17092E+01, 0.17130E+01, 0.17167E+01,&
      0.17204E+01, 0.17240E+01, 0.17275E+01, 0.17310E+01, 0.17345E+01,&
      0.17379E+01, 0.17412E+01, 0.17445E+01, 0.17477E+01, 0.17509E+01,&
      0.17540E+01, 0.17571E+01, 0.17601E+01, 0.17631E+01, 0.17660E+01/
                             
     DATA (BNC10M(IA),IA=701,741)/                                      &
      0.17689E+01, 0.17718E+01, 0.17746E+01, 0.17773E+01, 0.17800E+01,&
      0.17827E+01, 0.17853E+01, 0.17879E+01, 0.17904E+01, 0.17929E+01,&
      0.17953E+01, 0.17977E+01, 0.18001E+01, 0.18024E+01, 0.18047E+01,&
      0.18069E+01, 0.18091E+01, 0.18113E+01, 0.18134E+01, 0.18155E+01,&
      0.18175E+01, 0.18195E+01, 0.18215E+01, 0.18234E+01, 0.18253E+01,&
      0.18271E+01, 0.18290E+01, 0.18307E+01, 0.18325E+01, 0.18342E+01,&
      0.18359E+01, 0.18375E+01, 0.18391E+01, 0.18407E+01, 0.18423E+01,&
      0.18438E+01, 0.18453E+01, 0.18467E+01, 0.18481E+01, 0.18495E+01,&
      0.18509E+01                  /                      
!                            
!  ** (H, Cl)                
!                            
     DATA (BNC11M (IA),IA=  1,100)/                                     &
     -0.52529E-01,-0.88720E-01,-0.10935E+00,-0.12044E+00,-0.12697E+00,&
     -0.13075E+00,-0.13267E+00,-0.13322E+00,-0.13273E+00,-0.13141E+00,&
     -0.12940E+00,-0.12681E+00,-0.12374E+00,-0.12024E+00,-0.11636E+00,&
     -0.11215E+00,-0.10765E+00,-0.10287E+00,-0.97853E-01,-0.92611E-01,&
     -0.87164E-01,-0.81529E-01,-0.75720E-01,-0.69751E-01,-0.63632E-01,&
     -0.57375E-01,-0.50988E-01,-0.44482E-01,-0.37863E-01,-0.31140E-01,&
     -0.24319E-01,-0.17407E-01,-0.10411E-01,-0.33352E-02, 0.38142E-02,&
      0.11032E-01, 0.18315E-01, 0.25656E-01, 0.33053E-01, 0.40501E-01,&
      0.47996E-01, 0.55536E-01, 0.63116E-01, 0.70734E-01, 0.78387E-01,&
      0.86072E-01, 0.93788E-01, 0.10153E+00, 0.10930E+00, 0.11709E+00,&
      0.12490E+00, 0.13274E+00, 0.14059E+00, 0.14847E+00, 0.15636E+00,&
      0.16426E+00, 0.17219E+00, 0.18013E+00, 0.18808E+00, 0.19605E+00,&
      0.20404E+00, 0.21204E+00, 0.22006E+00, 0.22810E+00, 0.23615E+00,&
      0.24422E+00, 0.25232E+00, 0.26043E+00, 0.26857E+00, 0.27673E+00,&
      0.28491E+00, 0.29312E+00, 0.30136E+00, 0.30962E+00, 0.31792E+00,&
      0.32624E+00, 0.33460E+00, 0.34299E+00, 0.35142E+00, 0.35989E+00,&
      0.36839E+00, 0.37693E+00, 0.38551E+00, 0.39413E+00, 0.40279E+00,&
      0.41150E+00, 0.42024E+00, 0.42903E+00, 0.43786E+00, 0.44674E+00,&
      0.45565E+00, 0.46462E+00, 0.47362E+00, 0.48266E+00, 0.49175E+00,&
      0.50087E+00, 0.51004E+00, 0.51925E+00, 0.52849E+00, 0.53777E+00/
                             
     DATA (BNC11M (IA),IA=101,200)/                                     &
      0.54708E+00, 0.55643E+00, 0.56581E+00, 0.57522E+00, 0.58465E+00,&
      0.59412E+00, 0.60361E+00, 0.61313E+00, 0.62267E+00, 0.63222E+00,&
      0.64180E+00, 0.65140E+00, 0.66101E+00, 0.67063E+00, 0.68027E+00,&
      0.68991E+00, 0.69957E+00, 0.70923E+00, 0.71890E+00, 0.72857E+00,&
      0.73737E+00, 0.74715E+00, 0.75692E+00, 0.76668E+00, 0.77643E+00,&
      0.78617E+00, 0.79590E+00, 0.80562E+00, 0.81533E+00, 0.82502E+00,&
      0.83470E+00, 0.84437E+00, 0.85403E+00, 0.86368E+00, 0.87331E+00,&
      0.88293E+00, 0.89253E+00, 0.90212E+00, 0.91170E+00, 0.92126E+00,&
      0.93081E+00, 0.94034E+00, 0.94986E+00, 0.95936E+00, 0.96885E+00,&
      0.97833E+00, 0.98778E+00, 0.99723E+00, 0.10067E+01, 0.10161E+01,&
      0.10255E+01, 0.10348E+01, 0.10442E+01, 0.10535E+01, 0.10629E+01,&
      0.10722E+01, 0.10815E+01, 0.10908E+01, 0.11000E+01, 0.11093E+01,&
      0.11185E+01, 0.11277E+01, 0.11369E+01, 0.11461E+01, 0.11552E+01,&
      0.11644E+01, 0.11735E+01, 0.11826E+01, 0.11917E+01, 0.12008E+01,&
      0.12098E+01, 0.12189E+01, 0.12279E+01, 0.12369E+01, 0.12459E+01,&
      0.12548E+01, 0.12638E+01, 0.12727E+01, 0.12816E+01, 0.12905E+01,&
      0.12994E+01, 0.13083E+01, 0.13171E+01, 0.13259E+01, 0.13347E+01,&
      0.13435E+01, 0.13523E+01, 0.13610E+01, 0.13698E+01, 0.13785E+01,&
      0.13872E+01, 0.13958E+01, 0.14045E+01, 0.14131E+01, 0.14218E+01,&
      0.14304E+01, 0.14390E+01, 0.14475E+01, 0.14561E+01, 0.14646E+01/
                             
     DATA (BNC11M (IA),IA=201,300)/                                     &
      0.14731E+01, 0.14816E+01, 0.14901E+01, 0.14986E+01, 0.15070E+01,&
      0.15154E+01, 0.15238E+01, 0.15322E+01, 0.15406E+01, 0.15489E+01,&
      0.15573E+01, 0.15656E+01, 0.15739E+01, 0.15822E+01, 0.15904E+01,&
      0.15987E+01, 0.16069E+01, 0.16151E+01, 0.16233E+01, 0.16315E+01,&
      0.16397E+01, 0.16478E+01, 0.16559E+01, 0.16640E+01, 0.16721E+01,&
      0.16802E+01, 0.16882E+01, 0.16963E+01, 0.17043E+01, 0.17123E+01,&
      0.17203E+01, 0.17283E+01, 0.17362E+01, 0.17441E+01, 0.17521E+01,&
      0.17600E+01, 0.17678E+01, 0.17757E+01, 0.17836E+01, 0.17914E+01,&
      0.17992E+01, 0.18070E+01, 0.18148E+01, 0.18226E+01, 0.18303E+01,&
      0.18380E+01, 0.18458E+01, 0.18535E+01, 0.18611E+01, 0.18688E+01,&
      0.18765E+01, 0.18841E+01, 0.18917E+01, 0.18993E+01, 0.19069E+01,&
      0.19145E+01, 0.19220E+01, 0.19296E+01, 0.19371E+01, 0.19446E+01,&
      0.19521E+01, 0.19596E+01, 0.19670E+01, 0.19745E+01, 0.19819E+01,&
      0.19893E+01, 0.19967E+01, 0.20041E+01, 0.20114E+01, 0.20188E+01,&
      0.20261E+01, 0.20334E+01, 0.20407E+01, 0.20480E+01, 0.20553E+01,&
      0.20626E+01, 0.20698E+01, 0.20770E+01, 0.20842E+01, 0.20914E+01,&
      0.20986E+01, 0.21058E+01, 0.21129E+01, 0.21201E+01, 0.21272E+01,&
      0.21343E+01, 0.21414E+01, 0.21485E+01, 0.21555E+01, 0.21626E+01,&
      0.21696E+01, 0.21767E+01, 0.21837E+01, 0.21907E+01, 0.21976E+01,&
      0.22046E+01, 0.22115E+01, 0.22185E+01, 0.22254E+01, 0.22323E+01/
                             
     DATA (BNC11M (IA),IA=301,400)/                                     &
      0.22392E+01, 0.22461E+01, 0.22529E+01, 0.22598E+01, 0.22666E+01,&
      0.22735E+01, 0.22803E+01, 0.22871E+01, 0.22938E+01, 0.23006E+01,&
      0.23074E+01, 0.23141E+01, 0.23208E+01, 0.23276E+01, 0.23343E+01,&
      0.23409E+01, 0.23476E+01, 0.23543E+01, 0.23609E+01, 0.23676E+01,&
      0.23742E+01, 0.23808E+01, 0.23874E+01, 0.23940E+01, 0.24005E+01,&
      0.24071E+01, 0.24136E+01, 0.24202E+01, 0.24267E+01, 0.24332E+01,&
      0.24397E+01, 0.24462E+01, 0.24526E+01, 0.24591E+01, 0.24655E+01,&
      0.24719E+01, 0.24784E+01, 0.24848E+01, 0.24912E+01, 0.24975E+01,&
      0.25039E+01, 0.25103E+01, 0.25166E+01, 0.25229E+01, 0.25292E+01,&
      0.25356E+01, 0.25418E+01, 0.25481E+01, 0.25544E+01, 0.25607E+01,&
      0.25669E+01, 0.25731E+01, 0.25794E+01, 0.25856E+01, 0.25918E+01,&
      0.25979E+01, 0.26041E+01, 0.26103E+01, 0.26164E+01, 0.26226E+01,&
      0.26287E+01, 0.26348E+01, 0.26409E+01, 0.26470E+01, 0.26531E+01,&
      0.26592E+01, 0.26652E+01, 0.26713E+01, 0.26773E+01, 0.26833E+01,&
      0.26894E+01, 0.26954E+01, 0.27013E+01, 0.27073E+01, 0.27133E+01,&
      0.27193E+01, 0.27252E+01, 0.27311E+01, 0.27371E+01, 0.27430E+01,&
      0.27489E+01, 0.27548E+01, 0.27607E+01, 0.27665E+01, 0.27724E+01,&
      0.27782E+01, 0.27841E+01, 0.27899E+01, 0.27957E+01, 0.28015E+01,&
      0.28073E+01, 0.28131E+01, 0.28189E+01, 0.28247E+01, 0.28304E+01,&
      0.28362E+01, 0.28419E+01, 0.28476E+01, 0.28533E+01, 0.28590E+01/
                             
     DATA (BNC11M (IA),IA=401,500)/                                     &
      0.28647E+01, 0.28704E+01, 0.28761E+01, 0.28817E+01, 0.28874E+01,&
      0.28930E+01, 0.28987E+01, 0.29043E+01, 0.29099E+01, 0.29155E+01,&
      0.29211E+01, 0.29267E+01, 0.29323E+01, 0.29378E+01, 0.29434E+01,&
      0.29489E+01, 0.29544E+01, 0.29600E+01, 0.29655E+01, 0.29710E+01,&
      0.29765E+01, 0.29820E+01, 0.29874E+01, 0.29929E+01, 0.29984E+01,&
      0.30038E+01, 0.30093E+01, 0.30147E+01, 0.30201E+01, 0.30255E+01,&
      0.30309E+01, 0.30363E+01, 0.30417E+01, 0.30471E+01, 0.30524E+01,&
      0.30578E+01, 0.30631E+01, 0.30685E+01, 0.30738E+01, 0.30791E+01,&
      0.30844E+01, 0.30897E+01, 0.30950E+01, 0.31003E+01, 0.31056E+01,&
      0.31108E+01, 0.31161E+01, 0.31213E+01, 0.31266E+01, 0.31318E+01,&
      0.31370E+01, 0.31422E+01, 0.31474E+01, 0.31526E+01, 0.31578E+01,&
      0.31630E+01, 0.31681E+01, 0.31733E+01, 0.31785E+01, 0.31836E+01,&
      0.31887E+01, 0.31939E+01, 0.31990E+01, 0.32041E+01, 0.32092E+01,&
      0.32143E+01, 0.32194E+01, 0.32244E+01, 0.32295E+01, 0.32345E+01,&
      0.32396E+01, 0.32446E+01, 0.32497E+01, 0.32547E+01, 0.32597E+01,&
      0.32647E+01, 0.32697E+01, 0.32747E+01, 0.32797E+01, 0.32847E+01,&
      0.32896E+01, 0.32946E+01, 0.32995E+01, 0.33045E+01, 0.33094E+01,&
      0.33144E+01, 0.33193E+01, 0.33242E+01, 0.33291E+01, 0.33340E+01,&
      0.33389E+01, 0.33438E+01, 0.33486E+01, 0.33535E+01, 0.33583E+01,&
      0.33632E+01, 0.33680E+01, 0.33729E+01, 0.33777E+01, 0.33825E+01/
                             
     DATA (BNC11M (IA),IA=501,600)/                                     &
      0.33873E+01, 0.33921E+01, 0.33969E+01, 0.34017E+01, 0.34065E+01,&
      0.34113E+01, 0.34160E+01, 0.34208E+01, 0.34255E+01, 0.34303E+01,&
      0.34350E+01, 0.34398E+01, 0.34445E+01, 0.34492E+01, 0.34539E+01,&
      0.34586E+01, 0.34633E+01, 0.34680E+01, 0.34726E+01, 0.34773E+01,&
      0.34820E+01, 0.34866E+01, 0.34913E+01, 0.34959E+01, 0.35006E+01,&
      0.35052E+01, 0.35098E+01, 0.35144E+01, 0.35190E+01, 0.35236E+01,&
      0.35282E+01, 0.35328E+01, 0.35374E+01, 0.35419E+01, 0.35465E+01,&
      0.35511E+01, 0.35556E+01, 0.35602E+01, 0.35647E+01, 0.35692E+01,&
      0.35737E+01, 0.35783E+01, 0.35828E+01, 0.35873E+01, 0.35918E+01,&
      0.35963E+01, 0.36007E+01, 0.36052E+01, 0.36097E+01, 0.36141E+01,&
      0.36186E+01, 0.36230E+01, 0.36275E+01, 0.36319E+01, 0.36363E+01,&
      0.36408E+01, 0.36452E+01, 0.36496E+01, 0.36540E+01, 0.36584E+01,&
      0.36628E+01, 0.36672E+01, 0.36715E+01, 0.36759E+01, 0.36803E+01,&
      0.36846E+01, 0.36890E+01, 0.36933E+01, 0.36977E+01, 0.37020E+01,&
      0.37063E+01, 0.37106E+01, 0.37150E+01, 0.37193E+01, 0.37236E+01,&
      0.37279E+01, 0.37321E+01, 0.37364E+01, 0.37407E+01, 0.37450E+01,&
      0.37492E+01, 0.37535E+01, 0.37577E+01, 0.37620E+01, 0.37662E+01,&
      0.37704E+01, 0.37747E+01, 0.37789E+01, 0.37831E+01, 0.37873E+01,&
      0.37915E+01, 0.37957E+01, 0.37999E+01, 0.38041E+01, 0.38083E+01,&
      0.38124E+01, 0.38166E+01, 0.38208E+01, 0.38249E+01, 0.38404E+01/
                             
     DATA (BNC11M (IA),IA=601,700)/                                     &
      0.38743E+01, 0.39148E+01, 0.39548E+01, 0.39942E+01, 0.40331E+01,&
      0.40715E+01, 0.41094E+01, 0.41467E+01, 0.41836E+01, 0.42200E+01,&
      0.42560E+01, 0.42915E+01, 0.43265E+01, 0.43611E+01, 0.43953E+01,&
      0.44291E+01, 0.44624E+01, 0.44954E+01, 0.45280E+01, 0.45601E+01,&
      0.45919E+01, 0.46234E+01, 0.46544E+01, 0.46852E+01, 0.47155E+01,&
      0.47456E+01, 0.47752E+01, 0.48046E+01, 0.48336E+01, 0.48624E+01,&
      0.48908E+01, 0.49189E+01, 0.49467E+01, 0.49742E+01, 0.50014E+01,&
      0.50283E+01, 0.50550E+01, 0.50814E+01, 0.51075E+01, 0.51333E+01,&
      0.51589E+01, 0.51842E+01, 0.52093E+01, 0.52341E+01, 0.52587E+01,&
      0.52830E+01, 0.53071E+01, 0.53309E+01, 0.53546E+01, 0.53780E+01,&
      0.54011E+01, 0.54241E+01, 0.54468E+01, 0.54694E+01, 0.54917E+01,&
      0.55138E+01, 0.55357E+01, 0.55574E+01, 0.55789E+01, 0.56002E+01,&
      0.56214E+01, 0.56423E+01, 0.56630E+01, 0.56836E+01, 0.57040E+01,&
      0.57242E+01, 0.57442E+01, 0.57640E+01, 0.57837E+01, 0.58032E+01,&
      0.58226E+01, 0.58417E+01, 0.58608E+01, 0.58796E+01, 0.58983E+01,&
      0.59168E+01, 0.59352E+01, 0.59534E+01, 0.59715E+01, 0.59894E+01,&
      0.60072E+01, 0.60248E+01, 0.60423E+01, 0.60597E+01, 0.60769E+01,&
      0.60940E+01, 0.61109E+01, 0.61277E+01, 0.61444E+01, 0.61609E+01,&
      0.61773E+01, 0.61936E+01, 0.62097E+01, 0.62257E+01, 0.62416E+01,&
      0.62574E+01, 0.62731E+01, 0.62886E+01, 0.63040E+01, 0.63193E+01/
                             
     DATA (BNC11M(IA),IA=701,741)/                                      &
      0.63345E+01, 0.63496E+01, 0.63645E+01, 0.63794E+01, 0.63941E+01,&
      0.64087E+01, 0.64232E+01, 0.64376E+01, 0.64519E+01, 0.64661E+01,&
      0.64802E+01, 0.64942E+01, 0.65081E+01, 0.65218E+01, 0.65355E+01,&
      0.65491E+01, 0.65626E+01, 0.65760E+01, 0.65893E+01, 0.66025E+01,&
      0.66156E+01, 0.66286E+01, 0.66415E+01, 0.66543E+01, 0.66671E+01,&
      0.66797E+01, 0.66923E+01, 0.67047E+01, 0.67171E+01, 0.67294E+01,&
      0.67416E+01, 0.67538E+01, 0.67658E+01, 0.67778E+01, 0.67897E+01,&
      0.68015E+01, 0.68132E+01, 0.68248E+01, 0.68364E+01, 0.68479E+01,&
      0.68593E+01                  /                      
!                            
!  ** NaHSO4                 
!                            
     DATA (BNC12M (IA),IA=  1,100)/                                     &
     -0.54197E-01,-0.94863E-01,-0.12098E+00,-0.13730E+00,-0.14889E+00,&
     -0.15763E+00,-0.16443E+00,-0.16981E+00,-0.17410E+00,-0.17752E+00,&
     -0.18023E+00,-0.18234E+00,-0.18394E+00,-0.18510E+00,-0.18586E+00,&
     -0.18627E+00,-0.18636E+00,-0.18617E+00,-0.18572E+00,-0.18502E+00,&
     -0.18410E+00,-0.18297E+00,-0.18165E+00,-0.18014E+00,-0.17847E+00,&
     -0.17662E+00,-0.17463E+00,-0.17249E+00,-0.17021E+00,-0.16779E+00,&
     -0.16525E+00,-0.16259E+00,-0.15982E+00,-0.15693E+00,-0.15394E+00,&
     -0.15084E+00,-0.14765E+00,-0.14437E+00,-0.14099E+00,-0.13753E+00,&
     -0.13399E+00,-0.13037E+00,-0.12667E+00,-0.12290E+00,-0.11906E+00,&
     -0.11516E+00,-0.11118E+00,-0.10715E+00,-0.10306E+00,-0.98908E-01,&
     -0.94703E-01,-0.90443E-01,-0.86133E-01,-0.81773E-01,-0.77365E-01,&
     -0.72910E-01,-0.68410E-01,-0.63866E-01,-0.59280E-01,-0.54651E-01,&
     -0.49983E-01,-0.45274E-01,-0.40525E-01,-0.35739E-01,-0.30914E-01,&
     -0.26051E-01,-0.21151E-01,-0.16213E-01,-0.11239E-01,-0.62276E-02,&
     -0.11793E-02, 0.39061E-02, 0.90287E-02, 0.14188E-01, 0.19386E-01,&
      0.24620E-01, 0.29893E-01, 0.35204E-01, 0.40552E-01, 0.45940E-01,&
      0.51365E-01, 0.56830E-01, 0.62333E-01, 0.67875E-01, 0.73455E-01,&
      0.79074E-01, 0.84733E-01, 0.90428E-01, 0.96163E-01, 0.10193E+00,&
      0.10774E+00, 0.11359E+00, 0.11947E+00, 0.12539E+00, 0.13134E+00,&
      0.13732E+00, 0.14334E+00, 0.14939E+00, 0.15547E+00, 0.16158E+00/
                             
     DATA (BNC12M (IA),IA=101,200)/                                     &
      0.16772E+00, 0.17388E+00, 0.18007E+00, 0.18628E+00, 0.19252E+00,&
      0.19878E+00, 0.20506E+00, 0.21136E+00, 0.21768E+00, 0.22401E+00,&
      0.23036E+00, 0.23672E+00, 0.24309E+00, 0.24947E+00, 0.25587E+00,&
      0.26227E+00, 0.26867E+00, 0.27509E+00, 0.28150E+00, 0.28793E+00,&
      0.29372E+00, 0.30022E+00, 0.30671E+00, 0.31319E+00, 0.31967E+00,&
      0.32613E+00, 0.33259E+00, 0.33904E+00, 0.34548E+00, 0.35192E+00,&
      0.35834E+00, 0.36475E+00, 0.37116E+00, 0.37755E+00, 0.38393E+00,&
      0.39031E+00, 0.39667E+00, 0.40302E+00, 0.40936E+00, 0.41569E+00,&
      0.42201E+00, 0.42832E+00, 0.43461E+00, 0.44090E+00, 0.44717E+00,&
      0.45343E+00, 0.45968E+00, 0.46592E+00, 0.47214E+00, 0.47835E+00,&
      0.48455E+00, 0.49074E+00, 0.49691E+00, 0.50307E+00, 0.50922E+00,&
      0.51536E+00, 0.52148E+00, 0.52759E+00, 0.53369E+00, 0.53978E+00,&
      0.54585E+00, 0.55191E+00, 0.55795E+00, 0.56398E+00, 0.57000E+00,&
      0.57601E+00, 0.58200E+00, 0.58798E+00, 0.59395E+00, 0.59990E+00,&
      0.60584E+00, 0.61177E+00, 0.61768E+00, 0.62358E+00, 0.62947E+00,&
      0.63534E+00, 0.64120E+00, 0.64705E+00, 0.65288E+00, 0.65870E+00,&
      0.66451E+00, 0.67030E+00, 0.67608E+00, 0.68185E+00, 0.68761E+00,&
      0.69335E+00, 0.69907E+00, 0.70479E+00, 0.71049E+00, 0.71618E+00,&
      0.72185E+00, 0.72752E+00, 0.73317E+00, 0.73880E+00, 0.74442E+00,&
      0.75003E+00, 0.75563E+00, 0.76122E+00, 0.76679E+00, 0.77235E+00/
                             
     DATA (BNC12M (IA),IA=201,300)/                                     &
      0.77789E+00, 0.78342E+00, 0.78894E+00, 0.79445E+00, 0.79995E+00,&
      0.80543E+00, 0.81090E+00, 0.81635E+00, 0.82180E+00, 0.82723E+00,&
      0.83265E+00, 0.83806E+00, 0.84345E+00, 0.84883E+00, 0.85420E+00,&
      0.85956E+00, 0.86490E+00, 0.87023E+00, 0.87556E+00, 0.88086E+00,&
      0.88616E+00, 0.89144E+00, 0.89671E+00, 0.90197E+00, 0.90722E+00,&
      0.91246E+00, 0.91768E+00, 0.92289E+00, 0.92809E+00, 0.93328E+00,&
      0.93846E+00, 0.94362E+00, 0.94878E+00, 0.95392E+00, 0.95905E+00,&
      0.96417E+00, 0.96928E+00, 0.97437E+00, 0.97946E+00, 0.98453E+00,&
      0.98959E+00, 0.99464E+00, 0.99968E+00, 0.10047E+01, 0.10097E+01,&
      0.10147E+01, 0.10197E+01, 0.10247E+01, 0.10297E+01, 0.10346E+01,&
      0.10396E+01, 0.10445E+01, 0.10495E+01, 0.10544E+01, 0.10593E+01,&
      0.10642E+01, 0.10691E+01, 0.10739E+01, 0.10788E+01, 0.10836E+01,&
      0.10885E+01, 0.10933E+01, 0.10981E+01, 0.11030E+01, 0.11078E+01,&
      0.11125E+01, 0.11173E+01, 0.11221E+01, 0.11269E+01, 0.11316E+01,&
      0.11363E+01, 0.11411E+01, 0.11458E+01, 0.11505E+01, 0.11552E+01,&
      0.11599E+01, 0.11646E+01, 0.11692E+01, 0.11739E+01, 0.11785E+01,&
      0.11832E+01, 0.11878E+01, 0.11924E+01, 0.11970E+01, 0.12016E+01,&
      0.12062E+01, 0.12108E+01, 0.12154E+01, 0.12199E+01, 0.12245E+01,&
      0.12290E+01, 0.12335E+01, 0.12381E+01, 0.12426E+01, 0.12471E+01,&
      0.12516E+01, 0.12561E+01, 0.12605E+01, 0.12650E+01, 0.12695E+01/
                             
     DATA (BNC12M (IA),IA=301,400)/                                     &
      0.12739E+01, 0.12784E+01, 0.12828E+01, 0.12872E+01, 0.12916E+01,&
      0.12960E+01, 0.13004E+01, 0.13048E+01, 0.13092E+01, 0.13135E+01,&
      0.13179E+01, 0.13222E+01, 0.13266E+01, 0.13309E+01, 0.13352E+01,&
      0.13396E+01, 0.13439E+01, 0.13482E+01, 0.13524E+01, 0.13567E+01,&
      0.13610E+01, 0.13653E+01, 0.13695E+01, 0.13738E+01, 0.13780E+01,&
      0.13822E+01, 0.13864E+01, 0.13907E+01, 0.13949E+01, 0.13990E+01,&
      0.14032E+01, 0.14074E+01, 0.14116E+01, 0.14157E+01, 0.14199E+01,&
      0.14240E+01, 0.14282E+01, 0.14323E+01, 0.14364E+01, 0.14405E+01,&
      0.14447E+01, 0.14487E+01, 0.14528E+01, 0.14569E+01, 0.14610E+01,&
      0.14651E+01, 0.14691E+01, 0.14732E+01, 0.14772E+01, 0.14812E+01,&
      0.14853E+01, 0.14893E+01, 0.14933E+01, 0.14973E+01, 0.15013E+01,&
      0.15053E+01, 0.15093E+01, 0.15132E+01, 0.15172E+01, 0.15212E+01,&
      0.15251E+01, 0.15290E+01, 0.15330E+01, 0.15369E+01, 0.15408E+01,&
      0.15447E+01, 0.15486E+01, 0.15525E+01, 0.15564E+01, 0.15603E+01,&
      0.15642E+01, 0.15681E+01, 0.15719E+01, 0.15758E+01, 0.15796E+01,&
      0.15835E+01, 0.15873E+01, 0.15911E+01, 0.15949E+01, 0.15988E+01,&
      0.16026E+01, 0.16064E+01, 0.16101E+01, 0.16139E+01, 0.16177E+01,&
      0.16215E+01, 0.16252E+01, 0.16290E+01, 0.16327E+01, 0.16365E+01,&
      0.16402E+01, 0.16439E+01, 0.16477E+01, 0.16514E+01, 0.16551E+01,&
      0.16588E+01, 0.16625E+01, 0.16662E+01, 0.16699E+01, 0.16735E+01/
                             
     DATA (BNC12M (IA),IA=401,500)/                                     &
      0.16772E+01, 0.16809E+01, 0.16845E+01, 0.16882E+01, 0.16918E+01,&
      0.16954E+01, 0.16991E+01, 0.17027E+01, 0.17063E+01, 0.17099E+01,&
      0.17135E+01, 0.17171E+01, 0.17207E+01, 0.17243E+01, 0.17279E+01,&
      0.17314E+01, 0.17350E+01, 0.17386E+01, 0.17421E+01, 0.17456E+01,&
      0.17492E+01, 0.17527E+01, 0.17562E+01, 0.17598E+01, 0.17633E+01,&
      0.17668E+01, 0.17703E+01, 0.17738E+01, 0.17773E+01, 0.17808E+01,&
      0.17842E+01, 0.17877E+01, 0.17912E+01, 0.17946E+01, 0.17981E+01,&
      0.18015E+01, 0.18050E+01, 0.18084E+01, 0.18118E+01, 0.18153E+01,&
      0.18187E+01, 0.18221E+01, 0.18255E+01, 0.18289E+01, 0.18323E+01,&
      0.18357E+01, 0.18391E+01, 0.18424E+01, 0.18458E+01, 0.18492E+01,&
      0.18525E+01, 0.18559E+01, 0.18592E+01, 0.18626E+01, 0.18659E+01,&
      0.18693E+01, 0.18726E+01, 0.18759E+01, 0.18792E+01, 0.18825E+01,&
      0.18858E+01, 0.18891E+01, 0.18924E+01, 0.18957E+01, 0.18990E+01,&
      0.19023E+01, 0.19055E+01, 0.19088E+01, 0.19121E+01, 0.19153E+01,&
      0.19186E+01, 0.19218E+01, 0.19250E+01, 0.19283E+01, 0.19315E+01,&
      0.19347E+01, 0.19379E+01, 0.19411E+01, 0.19443E+01, 0.19475E+01,&
      0.19507E+01, 0.19539E+01, 0.19571E+01, 0.19603E+01, 0.19635E+01,&
      0.19666E+01, 0.19698E+01, 0.19730E+01, 0.19761E+01, 0.19793E+01,&
      0.19824E+01, 0.19855E+01, 0.19887E+01, 0.19918E+01, 0.19949E+01,&
      0.19980E+01, 0.20012E+01, 0.20043E+01, 0.20074E+01, 0.20105E+01/
                             
     DATA (BNC12M (IA),IA=501,600)/                                     &
      0.20136E+01, 0.20166E+01, 0.20197E+01, 0.20228E+01, 0.20259E+01,&
      0.20289E+01, 0.20320E+01, 0.20351E+01, 0.20381E+01, 0.20412E+01,&
      0.20442E+01, 0.20472E+01, 0.20503E+01, 0.20533E+01, 0.20563E+01,&
      0.20593E+01, 0.20624E+01, 0.20654E+01, 0.20684E+01, 0.20714E+01,&
      0.20744E+01, 0.20774E+01, 0.20803E+01, 0.20833E+01, 0.20863E+01,&
      0.20893E+01, 0.20922E+01, 0.20952E+01, 0.20982E+01, 0.21011E+01,&
      0.21041E+01, 0.21070E+01, 0.21099E+01, 0.21129E+01, 0.21158E+01,&
      0.21187E+01, 0.21217E+01, 0.21246E+01, 0.21275E+01, 0.21304E+01,&
      0.21333E+01, 0.21362E+01, 0.21391E+01, 0.21420E+01, 0.21449E+01,&
      0.21477E+01, 0.21506E+01, 0.21535E+01, 0.21564E+01, 0.21592E+01,&
      0.21621E+01, 0.21649E+01, 0.21678E+01, 0.21706E+01, 0.21735E+01,&
      0.21763E+01, 0.21791E+01, 0.21820E+01, 0.21848E+01, 0.21876E+01,&
      0.21904E+01, 0.21932E+01, 0.21960E+01, 0.21988E+01, 0.22016E+01,&
      0.22044E+01, 0.22072E+01, 0.22100E+01, 0.22128E+01, 0.22156E+01,&
      0.22183E+01, 0.22211E+01, 0.22239E+01, 0.22266E+01, 0.22294E+01,&
      0.22321E+01, 0.22349E+01, 0.22376E+01, 0.22404E+01, 0.22431E+01,&
      0.22458E+01, 0.22486E+01, 0.22513E+01, 0.22540E+01, 0.22567E+01,&
      0.22594E+01, 0.22621E+01, 0.22648E+01, 0.22675E+01, 0.22702E+01,&
      0.22729E+01, 0.22756E+01, 0.22783E+01, 0.22810E+01, 0.22836E+01,&
      0.22863E+01, 0.22890E+01, 0.22916E+01, 0.22943E+01, 0.23042E+01/
                             
     DATA (BNC12M (IA),IA=601,700)/                                     &
      0.23259E+01, 0.23518E+01, 0.23774E+01, 0.24026E+01, 0.24274E+01,&
      0.24519E+01, 0.24761E+01, 0.24999E+01, 0.25234E+01, 0.25466E+01,&
      0.25694E+01, 0.25920E+01, 0.26142E+01, 0.26362E+01, 0.26579E+01,&
      0.26793E+01, 0.27004E+01, 0.27213E+01, 0.27419E+01, 0.27622E+01,&
      0.27823E+01, 0.28022E+01, 0.28218E+01, 0.28411E+01, 0.28602E+01,&
      0.28791E+01, 0.28978E+01, 0.29162E+01, 0.29344E+01, 0.29524E+01,&
      0.29702E+01, 0.29878E+01, 0.30052E+01, 0.30224E+01, 0.30393E+01,&
      0.30561E+01, 0.30727E+01, 0.30891E+01, 0.31054E+01, 0.31214E+01,&
      0.31373E+01, 0.31530E+01, 0.31685E+01, 0.31838E+01, 0.31990E+01,&
      0.32140E+01, 0.32289E+01, 0.32436E+01, 0.32581E+01, 0.32725E+01,&
      0.32868E+01, 0.33008E+01, 0.33148E+01, 0.33286E+01, 0.33422E+01,&
      0.33557E+01, 0.33691E+01, 0.33823E+01, 0.33954E+01, 0.34084E+01,&
      0.34212E+01, 0.34339E+01, 0.34465E+01, 0.34589E+01, 0.34712E+01,&
      0.34834E+01, 0.34955E+01, 0.35075E+01, 0.35193E+01, 0.35310E+01,&
      0.35426E+01, 0.35541E+01, 0.35655E+01, 0.35768E+01, 0.35880E+01,&
      0.35990E+01, 0.36100E+01, 0.36208E+01, 0.36316E+01, 0.36422E+01,&
      0.36527E+01, 0.36632E+01, 0.36735E+01, 0.36838E+01, 0.36939E+01,&
      0.37040E+01, 0.37139E+01, 0.37238E+01, 0.37336E+01, 0.37432E+01,&
      0.37528E+01, 0.37623E+01, 0.37718E+01, 0.37811E+01, 0.37903E+01,&
      0.37995E+01, 0.38086E+01, 0.38176E+01, 0.38265E+01, 0.38353E+01/
                             
     DATA (BNC12M(IA),IA=701,741)/                                      &
      0.38441E+01, 0.38528E+01, 0.38614E+01, 0.38699E+01, 0.38783E+01,&
      0.38867E+01, 0.38950E+01, 0.39032E+01, 0.39113E+01, 0.39194E+01,&
      0.39274E+01, 0.39353E+01, 0.39432E+01, 0.39510E+01, 0.39587E+01,&
      0.39664E+01, 0.39740E+01, 0.39815E+01, 0.39889E+01, 0.39963E+01,&
      0.40037E+01, 0.40109E+01, 0.40181E+01, 0.40253E+01, 0.40323E+01,&
      0.40393E+01, 0.40463E+01, 0.40532E+01, 0.40600E+01, 0.40668E+01,&
      0.40735E+01, 0.40802E+01, 0.40867E+01, 0.40933E+01, 0.40998E+01,&
      0.41062E+01, 0.41126E+01, 0.41189E+01, 0.41252E+01, 0.41314E+01,&
      0.41375E+01                  /                      
!                            
!  ** (NH4)3H(SO4)2          
!                            
     DATA (BNC13M (IA),IA=  1,100)/                                     &
     -0.90602E-01,-0.16542E+00,-0.21853E+00,-0.25500E+00,-0.28333E+00,&
     -0.30670E+00,-0.32669E+00,-0.34420E+00,-0.35982E+00,-0.37393E+00,&
     -0.38682E+00,-0.39867E+00,-0.40966E+00,-0.41990E+00,-0.42949E+00,&
     -0.43851E+00,-0.44702E+00,-0.45507E+00,-0.46272E+00,-0.46998E+00,&
     -0.47691E+00,-0.48352E+00,-0.48985E+00,-0.49591E+00,-0.50172E+00,&
     -0.50730E+00,-0.51266E+00,-0.51782E+00,-0.52278E+00,-0.52757E+00,&
     -0.53219E+00,-0.53664E+00,-0.54094E+00,-0.54510E+00,-0.54912E+00,&
     -0.55300E+00,-0.55676E+00,-0.56040E+00,-0.56392E+00,-0.56733E+00,&
     -0.57064E+00,-0.57384E+00,-0.57695E+00,-0.57996E+00,-0.58289E+00,&
     -0.58572E+00,-0.58848E+00,-0.59115E+00,-0.59374E+00,-0.59626E+00,&
     -0.59871E+00,-0.60109E+00,-0.60340E+00,-0.60565E+00,-0.60784E+00,&
     -0.60996E+00,-0.61203E+00,-0.61404E+00,-0.61599E+00,-0.61790E+00,&
     -0.61975E+00,-0.62155E+00,-0.62331E+00,-0.62502E+00,-0.62668E+00,&
     -0.62830E+00,-0.62988E+00,-0.63142E+00,-0.63291E+00,-0.63437E+00,&
     -0.63579E+00,-0.63718E+00,-0.63852E+00,-0.63984E+00,-0.64111E+00,&
     -0.64236E+00,-0.64357E+00,-0.64475E+00,-0.64590E+00,-0.64702E+00,&
     -0.64811E+00,-0.64917E+00,-0.65020E+00,-0.65120E+00,-0.65217E+00,&
     -0.65312E+00,-0.65404E+00,-0.65494E+00,-0.65581E+00,-0.65666E+00,&
     -0.65748E+00,-0.65828E+00,-0.65905E+00,-0.65980E+00,-0.66053E+00,&
     -0.66124E+00,-0.66193E+00,-0.66260E+00,-0.66324E+00,-0.66387E+00/
                             
     DATA (BNC13M (IA),IA=101,200)/                                     &
     -0.66448E+00,-0.66507E+00,-0.66564E+00,-0.66620E+00,-0.66674E+00,&
     -0.66726E+00,-0.66777E+00,-0.66827E+00,-0.66875E+00,-0.66921E+00,&
     -0.66966E+00,-0.67010E+00,-0.67053E+00,-0.67095E+00,-0.67135E+00,&
     -0.67175E+00,-0.67213E+00,-0.67250E+00,-0.67287E+00,-0.67322E+00,&
     -0.67369E+00,-0.67401E+00,-0.67433E+00,-0.67464E+00,-0.67495E+00,&
     -0.67525E+00,-0.67554E+00,-0.67583E+00,-0.67611E+00,-0.67639E+00,&
     -0.67667E+00,-0.67694E+00,-0.67720E+00,-0.67746E+00,-0.67772E+00,&
     -0.67797E+00,-0.67822E+00,-0.67847E+00,-0.67871E+00,-0.67895E+00,&
     -0.67919E+00,-0.67942E+00,-0.67965E+00,-0.67988E+00,-0.68011E+00,&
     -0.68033E+00,-0.68055E+00,-0.68077E+00,-0.68099E+00,-0.68120E+00,&
     -0.68141E+00,-0.68162E+00,-0.68183E+00,-0.68204E+00,-0.68224E+00,&
     -0.68245E+00,-0.68265E+00,-0.68285E+00,-0.68305E+00,-0.68325E+00,&
     -0.68345E+00,-0.68365E+00,-0.68384E+00,-0.68404E+00,-0.68423E+00,&
     -0.68442E+00,-0.68462E+00,-0.68481E+00,-0.68500E+00,-0.68519E+00,&
     -0.68538E+00,-0.68557E+00,-0.68576E+00,-0.68595E+00,-0.68614E+00,&
     -0.68633E+00,-0.68651E+00,-0.68670E+00,-0.68689E+00,-0.68708E+00,&
     -0.68727E+00,-0.68745E+00,-0.68764E+00,-0.68783E+00,-0.68802E+00,&
     -0.68820E+00,-0.68839E+00,-0.68858E+00,-0.68877E+00,-0.68896E+00,&
     -0.68914E+00,-0.68933E+00,-0.68952E+00,-0.68971E+00,-0.68990E+00,&
     -0.69009E+00,-0.69028E+00,-0.69047E+00,-0.69066E+00,-0.69085E+00/
                             
     DATA (BNC13M (IA),IA=201,300)/                                     &
     -0.69105E+00,-0.69124E+00,-0.69143E+00,-0.69162E+00,-0.69182E+00,&
     -0.69201E+00,-0.69221E+00,-0.69240E+00,-0.69260E+00,-0.69280E+00,&
     -0.69299E+00,-0.69319E+00,-0.69339E+00,-0.69359E+00,-0.69379E+00,&
     -0.69399E+00,-0.69419E+00,-0.69439E+00,-0.69459E+00,-0.69480E+00,&
     -0.69500E+00,-0.69520E+00,-0.69541E+00,-0.69561E+00,-0.69582E+00,&
     -0.69603E+00,-0.69624E+00,-0.69644E+00,-0.69665E+00,-0.69686E+00,&
     -0.69707E+00,-0.69729E+00,-0.69750E+00,-0.69771E+00,-0.69793E+00,&
     -0.69814E+00,-0.69836E+00,-0.69857E+00,-0.69879E+00,-0.69901E+00,&
     -0.69923E+00,-0.69945E+00,-0.69967E+00,-0.69989E+00,-0.70011E+00,&
     -0.70034E+00,-0.70056E+00,-0.70078E+00,-0.70101E+00,-0.70124E+00,&
     -0.70146E+00,-0.70169E+00,-0.70192E+00,-0.70215E+00,-0.70238E+00,&
     -0.70261E+00,-0.70285E+00,-0.70308E+00,-0.70331E+00,-0.70355E+00,&
     -0.70379E+00,-0.70402E+00,-0.70426E+00,-0.70450E+00,-0.70474E+00,&
     -0.70498E+00,-0.70522E+00,-0.70546E+00,-0.70571E+00,-0.70595E+00,&
     -0.70619E+00,-0.70644E+00,-0.70669E+00,-0.70693E+00,-0.70718E+00,&
     -0.70743E+00,-0.70768E+00,-0.70793E+00,-0.70818E+00,-0.70844E+00,&
     -0.70869E+00,-0.70895E+00,-0.70920E+00,-0.70946E+00,-0.70971E+00,&
     -0.70997E+00,-0.71023E+00,-0.71049E+00,-0.71075E+00,-0.71101E+00,&
     -0.71128E+00,-0.71154E+00,-0.71180E+00,-0.71207E+00,-0.71234E+00,&
     -0.71260E+00,-0.71287E+00,-0.71314E+00,-0.71341E+00,-0.71368E+00/
                             
     DATA (BNC13M (IA),IA=301,400)/                                     &
     -0.71395E+00,-0.71422E+00,-0.71450E+00,-0.71477E+00,-0.71505E+00,&
     -0.71532E+00,-0.71560E+00,-0.71588E+00,-0.71615E+00,-0.71643E+00,&
     -0.71671E+00,-0.71699E+00,-0.71728E+00,-0.71756E+00,-0.71784E+00,&
     -0.71813E+00,-0.71841E+00,-0.71870E+00,-0.71899E+00,-0.71927E+00,&
     -0.71956E+00,-0.71985E+00,-0.72014E+00,-0.72043E+00,-0.72073E+00,&
     -0.72102E+00,-0.72131E+00,-0.72161E+00,-0.72190E+00,-0.72220E+00,&
     -0.72250E+00,-0.72280E+00,-0.72310E+00,-0.72340E+00,-0.72370E+00,&
     -0.72400E+00,-0.72430E+00,-0.72460E+00,-0.72491E+00,-0.72521E+00,&
     -0.72552E+00,-0.72583E+00,-0.72613E+00,-0.72644E+00,-0.72675E+00,&
     -0.72706E+00,-0.72737E+00,-0.72768E+00,-0.72799E+00,-0.72831E+00,&
     -0.72862E+00,-0.72894E+00,-0.72925E+00,-0.72957E+00,-0.72989E+00,&
     -0.73020E+00,-0.73052E+00,-0.73084E+00,-0.73116E+00,-0.73149E+00,&
     -0.73181E+00,-0.73213E+00,-0.73245E+00,-0.73278E+00,-0.73310E+00,&
     -0.73343E+00,-0.73376E+00,-0.73409E+00,-0.73441E+00,-0.73474E+00,&
     -0.73507E+00,-0.73540E+00,-0.73574E+00,-0.73607E+00,-0.73640E+00,&
     -0.73674E+00,-0.73707E+00,-0.73741E+00,-0.73774E+00,-0.73808E+00,&
     -0.73842E+00,-0.73876E+00,-0.73910E+00,-0.73944E+00,-0.73978E+00,&
     -0.74012E+00,-0.74046E+00,-0.74081E+00,-0.74115E+00,-0.74150E+00,&
     -0.74184E+00,-0.74219E+00,-0.74253E+00,-0.74288E+00,-0.74323E+00,&
     -0.74358E+00,-0.74393E+00,-0.74428E+00,-0.74463E+00,-0.74499E+00/
                             
     DATA (BNC13M (IA),IA=401,500)/                                     &
     -0.74534E+00,-0.74569E+00,-0.74605E+00,-0.74640E+00,-0.74676E+00,&
     -0.74712E+00,-0.74747E+00,-0.74783E+00,-0.74819E+00,-0.74855E+00,&
     -0.74891E+00,-0.74927E+00,-0.74964E+00,-0.75000E+00,-0.75036E+00,&
     -0.75073E+00,-0.75109E+00,-0.75146E+00,-0.75182E+00,-0.75219E+00,&
     -0.75256E+00,-0.75293E+00,-0.75330E+00,-0.75367E+00,-0.75404E+00,&
     -0.75441E+00,-0.75478E+00,-0.75515E+00,-0.75553E+00,-0.75590E+00,&
     -0.75627E+00,-0.75665E+00,-0.75703E+00,-0.75740E+00,-0.75778E+00,&
     -0.75816E+00,-0.75854E+00,-0.75892E+00,-0.75930E+00,-0.75968E+00,&
     -0.76006E+00,-0.76044E+00,-0.76083E+00,-0.76121E+00,-0.76160E+00,&
     -0.76198E+00,-0.76237E+00,-0.76275E+00,-0.76314E+00,-0.76353E+00,&
     -0.76392E+00,-0.76431E+00,-0.76470E+00,-0.76509E+00,-0.76548E+00,&
     -0.76587E+00,-0.76626E+00,-0.76666E+00,-0.76705E+00,-0.76744E+00,&
     -0.76784E+00,-0.76824E+00,-0.76863E+00,-0.76903E+00,-0.76943E+00,&
     -0.76983E+00,-0.77023E+00,-0.77063E+00,-0.77103E+00,-0.77143E+00,&
     -0.77183E+00,-0.77223E+00,-0.77263E+00,-0.77304E+00,-0.77344E+00,&
     -0.77385E+00,-0.77425E+00,-0.77466E+00,-0.77507E+00,-0.77547E+00,&
     -0.77588E+00,-0.77629E+00,-0.77670E+00,-0.77711E+00,-0.77752E+00,&
     -0.77793E+00,-0.77834E+00,-0.77876E+00,-0.77917E+00,-0.77958E+00,&
     -0.78000E+00,-0.78041E+00,-0.78083E+00,-0.78124E+00,-0.78166E+00,&
     -0.78208E+00,-0.78249E+00,-0.78291E+00,-0.78333E+00,-0.78375E+00/
                             
     DATA (BNC13M (IA),IA=501,600)/                                     &
     -0.78417E+00,-0.78459E+00,-0.78502E+00,-0.78544E+00,-0.78586E+00,&
     -0.78628E+00,-0.78671E+00,-0.78713E+00,-0.78756E+00,-0.78798E+00,&
     -0.78841E+00,-0.78884E+00,-0.78926E+00,-0.78969E+00,-0.79012E+00,&
     -0.79055E+00,-0.79098E+00,-0.79141E+00,-0.79184E+00,-0.79227E+00,&
     -0.79271E+00,-0.79314E+00,-0.79357E+00,-0.79401E+00,-0.79444E+00,&
     -0.79488E+00,-0.79531E+00,-0.79575E+00,-0.79619E+00,-0.79662E+00,&
     -0.79706E+00,-0.79750E+00,-0.79794E+00,-0.79838E+00,-0.79882E+00,&
     -0.79926E+00,-0.79970E+00,-0.80014E+00,-0.80058E+00,-0.80103E+00,&
     -0.80147E+00,-0.80192E+00,-0.80236E+00,-0.80281E+00,-0.80325E+00,&
     -0.80370E+00,-0.80414E+00,-0.80459E+00,-0.80504E+00,-0.80549E+00,&
     -0.80594E+00,-0.80639E+00,-0.80684E+00,-0.80729E+00,-0.80774E+00,&
     -0.80819E+00,-0.80864E+00,-0.80910E+00,-0.80955E+00,-0.81000E+00,&
     -0.81046E+00,-0.81091E+00,-0.81137E+00,-0.81182E+00,-0.81228E+00,&
     -0.81274E+00,-0.81320E+00,-0.81365E+00,-0.81411E+00,-0.81457E+00,&
     -0.81503E+00,-0.81549E+00,-0.81595E+00,-0.81641E+00,-0.81688E+00,&
     -0.81734E+00,-0.81780E+00,-0.81826E+00,-0.81873E+00,-0.81919E+00,&
     -0.81966E+00,-0.82012E+00,-0.82059E+00,-0.82105E+00,-0.82152E+00,&
     -0.82199E+00,-0.82246E+00,-0.82293E+00,-0.82339E+00,-0.82386E+00,&
     -0.82433E+00,-0.82480E+00,-0.82528E+00,-0.82575E+00,-0.82622E+00,&
     -0.82669E+00,-0.82716E+00,-0.82764E+00,-0.82811E+00,-0.82989E+00/
                             
     DATA (BNC13M (IA),IA=601,700)/                                     &
     -0.83384E+00,-0.83866E+00,-0.84353E+00,-0.84845E+00,-0.85341E+00,&
     -0.85841E+00,-0.86346E+00,-0.86856E+00,-0.87369E+00,-0.87886E+00,&
     -0.88408E+00,-0.88933E+00,-0.89463E+00,-0.89996E+00,-0.90532E+00,&
     -0.91073E+00,-0.91617E+00,-0.92164E+00,-0.92715E+00,-0.93270E+00,&
     -0.93828E+00,-0.94389E+00,-0.94953E+00,-0.95520E+00,-0.96091E+00,&
     -0.96664E+00,-0.97241E+00,-0.97820E+00,-0.98402E+00,-0.98987E+00,&
     -0.99575E+00,-0.10017E+01,-0.10076E+01,-0.10136E+01,-0.10195E+01,&
     -0.10256E+01,-0.10316E+01,-0.10377E+01,-0.10437E+01,-0.10499E+01,&
     -0.10560E+01,-0.10621E+01,-0.10683E+01,-0.10745E+01,-0.10808E+01,&
     -0.10870E+01,-0.10933E+01,-0.10996E+01,-0.11059E+01,-0.11122E+01,&
     -0.11186E+01,-0.11249E+01,-0.11313E+01,-0.11377E+01,-0.11442E+01,&
     -0.11506E+01,-0.11571E+01,-0.11636E+01,-0.11701E+01,-0.11766E+01,&
     -0.11831E+01,-0.11897E+01,-0.11963E+01,-0.12028E+01,-0.12095E+01,&
     -0.12161E+01,-0.12227E+01,-0.12294E+01,-0.12360E+01,-0.12427E+01,&
     -0.12494E+01,-0.12561E+01,-0.12629E+01,-0.12696E+01,-0.12764E+01,&
     -0.12831E+01,-0.12899E+01,-0.12967E+01,-0.13035E+01,-0.13104E+01,&
     -0.13172E+01,-0.13241E+01,-0.13309E+01,-0.13378E+01,-0.13447E+01,&
     -0.13516E+01,-0.13585E+01,-0.13655E+01,-0.13724E+01,-0.13794E+01,&
     -0.13863E+01,-0.13933E+01,-0.14003E+01,-0.14073E+01,-0.14143E+01,&
     -0.14213E+01,-0.14284E+01,-0.14354E+01,-0.14424E+01,-0.14495E+01/
                             
     DATA (BNC13M(IA),IA=701,741)/                                      &
     -0.14566E+01,-0.14637E+01,-0.14708E+01,-0.14779E+01,-0.14850E+01,&
     -0.14921E+01,-0.14992E+01,-0.15064E+01,-0.15135E+01,-0.15207E+01,&
     -0.15279E+01,-0.15351E+01,-0.15422E+01,-0.15494E+01,-0.15567E+01,&
     -0.15639E+01,-0.15711E+01,-0.15783E+01,-0.15856E+01,-0.15928E+01,&
     -0.16001E+01,-0.16073E+01,-0.16146E+01,-0.16219E+01,-0.16292E+01,&
     -0.16365E+01,-0.16438E+01,-0.16511E+01,-0.16584E+01,-0.16657E+01,&
     -0.16731E+01,-0.16804E+01,-0.16878E+01,-0.16951E+01,-0.17025E+01,&
     -0.17099E+01,-0.17172E+01,-0.17246E+01,-0.17320E+01,-0.17394E+01,&
     -0.17468E+01                 /                      
!     END                     
                             
!  ** TEMP = 223.0           
                             
!     BLOCK DATA KMCF223      
!                            
!  ** Common block definition
!                            
!     COMMON /KMC223/                                                  &
!     BNC01M(  741),BNC02M(  741),BNC03M(  741),BNC04M(  741),         &
!     BNC05M(  741),BNC06M(  741),BNC07M(  741),BNC08M(  741),         &
 !    BNC09M(  741),BNC10M(  741),BNC11M(  741),BNC12M(  741),         &
 !    BNC13M(  741)           
!                            
!  ** NaCl                   
!                            
     DATA (BNC01M (IA),IA=  1,100)/                                     &
     -0.53546E-01,-0.94317E-01,-0.12065E+00,-0.13711E+00,-0.14879E+00,&
     -0.15760E+00,-0.16447E+00,-0.16993E+00,-0.17432E+00,-0.17787E+00,&
     -0.18074E+00,-0.18305E+00,-0.18490E+00,-0.18635E+00,-0.18746E+00,&
     -0.18827E+00,-0.18883E+00,-0.18916E+00,-0.18929E+00,-0.18925E+00,&
     -0.18904E+00,-0.18869E+00,-0.18822E+00,-0.18763E+00,-0.18693E+00,&
     -0.18614E+00,-0.18527E+00,-0.18432E+00,-0.18330E+00,-0.18222E+00,&
     -0.18107E+00,-0.17988E+00,-0.17864E+00,-0.17735E+00,-0.17603E+00,&
     -0.17467E+00,-0.17328E+00,-0.17186E+00,-0.17042E+00,-0.16895E+00,&
     -0.16746E+00,-0.16595E+00,-0.16443E+00,-0.16289E+00,-0.16134E+00,&
     -0.15977E+00,-0.15820E+00,-0.15661E+00,-0.15502E+00,-0.15342E+00,&
     -0.15181E+00,-0.15020E+00,-0.14859E+00,-0.14696E+00,-0.14534E+00,&
     -0.14371E+00,-0.14207E+00,-0.14043E+00,-0.13879E+00,-0.13714E+00,&
     -0.13549E+00,-0.13383E+00,-0.13217E+00,-0.13051E+00,-0.12883E+00,&
     -0.12716E+00,-0.12547E+00,-0.12378E+00,-0.12208E+00,-0.12038E+00,&
     -0.11866E+00,-0.11694E+00,-0.11520E+00,-0.11346E+00,-0.11170E+00,&
     -0.10993E+00,-0.10816E+00,-0.10636E+00,-0.10456E+00,-0.10274E+00,&
     -0.10091E+00,-0.99060E-01,-0.97198E-01,-0.95320E-01,-0.93428E-01,&
     -0.91520E-01,-0.89596E-01,-0.87656E-01,-0.85700E-01,-0.83729E-01,&
     -0.81741E-01,-0.79737E-01,-0.77718E-01,-0.75682E-01,-0.73632E-01,&
     -0.71566E-01,-0.69486E-01,-0.67391E-01,-0.65281E-01,-0.63158E-01/
                             
     DATA (BNC01M (IA),IA=101,200)/                                     &
     -0.61022E-01,-0.58873E-01,-0.56711E-01,-0.54538E-01,-0.52353E-01,&
     -0.50157E-01,-0.47951E-01,-0.45735E-01,-0.43510E-01,-0.41276E-01,&
     -0.39034E-01,-0.36785E-01,-0.34529E-01,-0.32266E-01,-0.29997E-01,&
     -0.27722E-01,-0.25443E-01,-0.23159E-01,-0.20871E-01,-0.18579E-01,&
     -0.16586E-01,-0.14254E-01,-0.11922E-01,-0.95920E-02,-0.72631E-02,&
     -0.49355E-02,-0.26095E-02,-0.28486E-03, 0.20382E-02, 0.43595E-02,&
      0.66792E-02, 0.89971E-02, 0.11313E-01, 0.13627E-01, 0.15940E-01,&
      0.18250E-01, 0.20558E-01, 0.22864E-01, 0.25168E-01, 0.27470E-01,&
      0.29770E-01, 0.32067E-01, 0.34362E-01, 0.36654E-01, 0.38945E-01,&
      0.41232E-01, 0.43517E-01, 0.45800E-01, 0.48080E-01, 0.50357E-01,&
      0.52632E-01, 0.54904E-01, 0.57174E-01, 0.59440E-01, 0.61704E-01,&
      0.63965E-01, 0.66223E-01, 0.68479E-01, 0.70731E-01, 0.72981E-01,&
      0.75227E-01, 0.77471E-01, 0.79711E-01, 0.81949E-01, 0.84183E-01,&
      0.86415E-01, 0.88643E-01, 0.90868E-01, 0.93091E-01, 0.95310E-01,&
      0.97525E-01, 0.99738E-01, 0.10195E+00, 0.10415E+00, 0.10636E+00,&
      0.10856E+00, 0.11075E+00, 0.11295E+00, 0.11514E+00, 0.11732E+00,&
      0.11950E+00, 0.12168E+00, 0.12386E+00, 0.12603E+00, 0.12820E+00,&
      0.13037E+00, 0.13253E+00, 0.13469E+00, 0.13685E+00, 0.13900E+00,&
      0.14115E+00, 0.14330E+00, 0.14544E+00, 0.14758E+00, 0.14971E+00,&
      0.15184E+00, 0.15397E+00, 0.15610E+00, 0.15822E+00, 0.16034E+00/
                             
     DATA (BNC01M (IA),IA=201,300)/                                     &
      0.16245E+00, 0.16456E+00, 0.16667E+00, 0.16877E+00, 0.17087E+00,&
      0.17297E+00, 0.17506E+00, 0.17715E+00, 0.17924E+00, 0.18132E+00,&
      0.18340E+00, 0.18548E+00, 0.18755E+00, 0.18962E+00, 0.19168E+00,&
      0.19374E+00, 0.19580E+00, 0.19786E+00, 0.19991E+00, 0.20195E+00,&
      0.20400E+00, 0.20604E+00, 0.20807E+00, 0.21011E+00, 0.21213E+00,&
      0.21416E+00, 0.21618E+00, 0.21820E+00, 0.22022E+00, 0.22223E+00,&
      0.22423E+00, 0.22624E+00, 0.22824E+00, 0.23024E+00, 0.23223E+00,&
      0.23422E+00, 0.23621E+00, 0.23819E+00, 0.24017E+00, 0.24214E+00,&
      0.24412E+00, 0.24608E+00, 0.24805E+00, 0.25001E+00, 0.25197E+00,&
      0.25392E+00, 0.25587E+00, 0.25782E+00, 0.25977E+00, 0.26171E+00,&
      0.26364E+00, 0.26558E+00, 0.26751E+00, 0.26943E+00, 0.27135E+00,&
      0.27327E+00, 0.27519E+00, 0.27710E+00, 0.27901E+00, 0.28092E+00,&
      0.28282E+00, 0.28472E+00, 0.28661E+00, 0.28850E+00, 0.29039E+00,&
      0.29227E+00, 0.29415E+00, 0.29603E+00, 0.29791E+00, 0.29978E+00,&
      0.30164E+00, 0.30351E+00, 0.30537E+00, 0.30722E+00, 0.30908E+00,&
      0.31093E+00, 0.31277E+00, 0.31462E+00, 0.31646E+00, 0.31829E+00,&
      0.32013E+00, 0.32196E+00, 0.32378E+00, 0.32561E+00, 0.32743E+00,&
      0.32924E+00, 0.33105E+00, 0.33286E+00, 0.33467E+00, 0.33647E+00,&
      0.33827E+00, 0.34007E+00, 0.34186E+00, 0.34365E+00, 0.34544E+00,&
      0.34722E+00, 0.34900E+00, 0.35078E+00, 0.35255E+00, 0.35432E+00/
                             
     DATA (BNC01M (IA),IA=301,400)/                                     &
      0.35608E+00, 0.35785E+00, 0.35961E+00, 0.36136E+00, 0.36312E+00,&
      0.36487E+00, 0.36661E+00, 0.36836E+00, 0.37010E+00, 0.37184E+00,&
      0.37357E+00, 0.37530E+00, 0.37703E+00, 0.37875E+00, 0.38047E+00,&
      0.38219E+00, 0.38391E+00, 0.38562E+00, 0.38733E+00, 0.38903E+00,&
      0.39073E+00, 0.39243E+00, 0.39413E+00, 0.39582E+00, 0.39751E+00,&
      0.39920E+00, 0.40088E+00, 0.40256E+00, 0.40424E+00, 0.40591E+00,&
      0.40758E+00, 0.40925E+00, 0.41092E+00, 0.41258E+00, 0.41424E+00,&
      0.41589E+00, 0.41755E+00, 0.41920E+00, 0.42084E+00, 0.42249E+00,&
      0.42413E+00, 0.42576E+00, 0.42740E+00, 0.42903E+00, 0.43066E+00,&
      0.43228E+00, 0.43391E+00, 0.43553E+00, 0.43714E+00, 0.43876E+00,&
      0.44037E+00, 0.44197E+00, 0.44358E+00, 0.44518E+00, 0.44678E+00,&
      0.44837E+00, 0.44997E+00, 0.45156E+00, 0.45315E+00, 0.45473E+00,&
      0.45631E+00, 0.45789E+00, 0.45946E+00, 0.46104E+00, 0.46261E+00,&
      0.46417E+00, 0.46574E+00, 0.46730E+00, 0.46886E+00, 0.47041E+00,&
      0.47197E+00, 0.47352E+00, 0.47506E+00, 0.47661E+00, 0.47815E+00,&
      0.47969E+00, 0.48122E+00, 0.48276E+00, 0.48429E+00, 0.48581E+00,&
      0.48734E+00, 0.48886E+00, 0.49038E+00, 0.49190E+00, 0.49341E+00,&
      0.49492E+00, 0.49643E+00, 0.49794E+00, 0.49944E+00, 0.50094E+00,&
      0.50244E+00, 0.50393E+00, 0.50542E+00, 0.50691E+00, 0.50840E+00,&
      0.50988E+00, 0.51136E+00, 0.51284E+00, 0.51432E+00, 0.51579E+00/
                             
     DATA (BNC01M (IA),IA=401,500)/                                     &
      0.51726E+00, 0.51873E+00, 0.52019E+00, 0.52166E+00, 0.52312E+00,&
      0.52457E+00, 0.52603E+00, 0.52748E+00, 0.52893E+00, 0.53038E+00,&
      0.53182E+00, 0.53326E+00, 0.53470E+00, 0.53614E+00, 0.53758E+00,&
      0.53901E+00, 0.54044E+00, 0.54186E+00, 0.54329E+00, 0.54471E+00,&
      0.54613E+00, 0.54754E+00, 0.54896E+00, 0.55037E+00, 0.55178E+00,&
      0.55318E+00, 0.55459E+00, 0.55599E+00, 0.55739E+00, 0.55878E+00,&
      0.56018E+00, 0.56157E+00, 0.56296E+00, 0.56434E+00, 0.56573E+00,&
      0.56711E+00, 0.56849E+00, 0.56987E+00, 0.57124E+00, 0.57261E+00,&
      0.57398E+00, 0.57535E+00, 0.57671E+00, 0.57808E+00, 0.57944E+00,&
      0.58079E+00, 0.58215E+00, 0.58350E+00, 0.58485E+00, 0.58620E+00,&
      0.58755E+00, 0.58889E+00, 0.59023E+00, 0.59157E+00, 0.59290E+00,&
      0.59424E+00, 0.59557E+00, 0.59690E+00, 0.59823E+00, 0.59955E+00,&
      0.60087E+00, 0.60219E+00, 0.60351E+00, 0.60483E+00, 0.60614E+00,&
      0.60745E+00, 0.60876E+00, 0.61006E+00, 0.61137E+00, 0.61267E+00,&
      0.61397E+00, 0.61527E+00, 0.61656E+00, 0.61786E+00, 0.61915E+00,&
      0.62043E+00, 0.62172E+00, 0.62300E+00, 0.62429E+00, 0.62557E+00,&
      0.62684E+00, 0.62812E+00, 0.62939E+00, 0.63066E+00, 0.63193E+00,&
      0.63320E+00, 0.63446E+00, 0.63572E+00, 0.63698E+00, 0.63824E+00,&
      0.63949E+00, 0.64075E+00, 0.64200E+00, 0.64325E+00, 0.64449E+00,&
      0.64574E+00, 0.64698E+00, 0.64822E+00, 0.64946E+00, 0.65070E+00/
                             
     DATA (BNC01M (IA),IA=501,600)/                                     &
      0.65193E+00, 0.65316E+00, 0.65439E+00, 0.65562E+00, 0.65685E+00,&
      0.65807E+00, 0.65929E+00, 0.66051E+00, 0.66173E+00, 0.66294E+00,&
      0.66416E+00, 0.66537E+00, 0.66658E+00, 0.66779E+00, 0.66899E+00,&
      0.67019E+00, 0.67139E+00, 0.67259E+00, 0.67379E+00, 0.67499E+00,&
      0.67618E+00, 0.67737E+00, 0.67856E+00, 0.67975E+00, 0.68093E+00,&
      0.68211E+00, 0.68329E+00, 0.68447E+00, 0.68565E+00, 0.68683E+00,&
      0.68800E+00, 0.68917E+00, 0.69034E+00, 0.69151E+00, 0.69267E+00,&
      0.69383E+00, 0.69500E+00, 0.69616E+00, 0.69731E+00, 0.69847E+00,&
      0.69962E+00, 0.70077E+00, 0.70192E+00, 0.70307E+00, 0.70422E+00,&
      0.70536E+00, 0.70650E+00, 0.70764E+00, 0.70878E+00, 0.70992E+00,&
      0.71105E+00, 0.71219E+00, 0.71332E+00, 0.71445E+00, 0.71557E+00,&
      0.71670E+00, 0.71782E+00, 0.71894E+00, 0.72006E+00, 0.72118E+00,&
      0.72230E+00, 0.72341E+00, 0.72452E+00, 0.72563E+00, 0.72674E+00,&
      0.72785E+00, 0.72895E+00, 0.73006E+00, 0.73116E+00, 0.73226E+00,&
      0.73335E+00, 0.73445E+00, 0.73554E+00, 0.73664E+00, 0.73773E+00,&
      0.73882E+00, 0.73990E+00, 0.74099E+00, 0.74207E+00, 0.74315E+00,&
      0.74423E+00, 0.74531E+00, 0.74639E+00, 0.74746E+00, 0.74853E+00,&
      0.74961E+00, 0.75067E+00, 0.75174E+00, 0.75281E+00, 0.75387E+00,&
      0.75493E+00, 0.75600E+00, 0.75705E+00, 0.75811E+00, 0.75917E+00,&
      0.76022E+00, 0.76127E+00, 0.76232E+00, 0.76337E+00, 0.76729E+00/
                             
     DATA (BNC01M (IA),IA=601,700)/                                     &
      0.77583E+00, 0.78602E+00, 0.79605E+00, 0.80593E+00, 0.81565E+00,&
      0.82522E+00, 0.83463E+00, 0.84391E+00, 0.85304E+00, 0.86203E+00,&
      0.87088E+00, 0.87959E+00, 0.88818E+00, 0.89663E+00, 0.90496E+00,&
      0.91316E+00, 0.92124E+00, 0.92920E+00, 0.93704E+00, 0.94477E+00,&
      0.95238E+00, 0.95988E+00, 0.96727E+00, 0.97455E+00, 0.98173E+00,&
      0.98880E+00, 0.99577E+00, 0.10026E+01, 0.10094E+01, 0.10161E+01,&
      0.10227E+01, 0.10292E+01, 0.10355E+01, 0.10418E+01, 0.10481E+01,&
      0.10542E+01, 0.10602E+01, 0.10662E+01, 0.10721E+01, 0.10778E+01,&
      0.10836E+01, 0.10892E+01, 0.10947E+01, 0.11002E+01, 0.11056E+01,&
      0.11109E+01, 0.11162E+01, 0.11213E+01, 0.11264E+01, 0.11315E+01,&
      0.11364E+01, 0.11413E+01, 0.11462E+01, 0.11509E+01, 0.11556E+01,&
      0.11603E+01, 0.11648E+01, 0.11693E+01, 0.11738E+01, 0.11782E+01,&
      0.11825E+01, 0.11867E+01, 0.11909E+01, 0.11951E+01, 0.11992E+01,&
      0.12032E+01, 0.12072E+01, 0.12111E+01, 0.12150E+01, 0.12188E+01,&
      0.12226E+01, 0.12263E+01, 0.12299E+01, 0.12335E+01, 0.12371E+01,&
      0.12406E+01, 0.12441E+01, 0.12475E+01, 0.12508E+01, 0.12542E+01,&
      0.12574E+01, 0.12607E+01, 0.12638E+01, 0.12670E+01, 0.12701E+01,&
      0.12731E+01, 0.12761E+01, 0.12791E+01, 0.12820E+01, 0.12849E+01,&
      0.12877E+01, 0.12905E+01, 0.12933E+01, 0.12960E+01, 0.12987E+01,&
      0.13013E+01, 0.13039E+01, 0.13065E+01, 0.13090E+01, 0.13115E+01/
                             
     DATA (BNC01M(IA),IA=701,741)/                                      &
      0.13139E+01, 0.13163E+01, 0.13187E+01, 0.13211E+01, 0.13234E+01,&
      0.13256E+01, 0.13279E+01, 0.13301E+01, 0.13323E+01, 0.13344E+01,&
      0.13365E+01, 0.13386E+01, 0.13406E+01, 0.13426E+01, 0.13446E+01,&
      0.13465E+01, 0.13485E+01, 0.13503E+01, 0.13522E+01, 0.13540E+01,&
      0.13558E+01, 0.13576E+01, 0.13593E+01, 0.13610E+01, 0.13627E+01,&
      0.13643E+01, 0.13660E+01, 0.13675E+01, 0.13691E+01, 0.13706E+01,&
      0.13722E+01, 0.13736E+01, 0.13751E+01, 0.13765E+01, 0.13779E+01,&
      0.13793E+01, 0.13807E+01, 0.13820E+01, 0.13833E+01, 0.13846E+01,&
      0.13858E+01                  /                      
!                            
!  ** Na2SO4                 
!                            
     DATA (BNC02M (IA),IA=  1,100)/                                     &
     -0.11119E+00,-0.20367E+00,-0.26963E+00,-0.31506E+00,-0.35045E+00,&
     -0.37972E+00,-0.40481E+00,-0.42685E+00,-0.44655E+00,-0.46441E+00,&
     -0.48077E+00,-0.49588E+00,-0.50994E+00,-0.52310E+00,-0.53548E+00,&
     -0.54717E+00,-0.55826E+00,-0.56881E+00,-0.57888E+00,-0.58852E+00,&
     -0.59777E+00,-0.60666E+00,-0.61522E+00,-0.62348E+00,-0.63147E+00,&
     -0.63919E+00,-0.64669E+00,-0.65396E+00,-0.66102E+00,-0.66789E+00,&
     -0.67458E+00,-0.68110E+00,-0.68746E+00,-0.69367E+00,-0.69974E+00,&
     -0.70567E+00,-0.71147E+00,-0.71716E+00,-0.72272E+00,-0.72818E+00,&
     -0.73353E+00,-0.73878E+00,-0.74393E+00,-0.74900E+00,-0.75397E+00,&
     -0.75886E+00,-0.76367E+00,-0.76841E+00,-0.77307E+00,-0.77765E+00,&
     -0.78217E+00,-0.78662E+00,-0.79101E+00,-0.79534E+00,-0.79961E+00,&
     -0.80382E+00,-0.80798E+00,-0.81208E+00,-0.81613E+00,-0.82013E+00,&
     -0.82409E+00,-0.82799E+00,-0.83186E+00,-0.83568E+00,-0.83946E+00,&
     -0.84320E+00,-0.84690E+00,-0.85056E+00,-0.85419E+00,-0.85778E+00,&
     -0.86133E+00,-0.86486E+00,-0.86835E+00,-0.87181E+00,-0.87525E+00,&
     -0.87865E+00,-0.88202E+00,-0.88537E+00,-0.88869E+00,-0.89199E+00,&
     -0.89526E+00,-0.89851E+00,-0.90173E+00,-0.90493E+00,-0.90811E+00,&
     -0.91127E+00,-0.91441E+00,-0.91753E+00,-0.92063E+00,-0.92370E+00,&
     -0.92676E+00,-0.92981E+00,-0.93283E+00,-0.93584E+00,-0.93883E+00,&
     -0.94180E+00,-0.94476E+00,-0.94770E+00,-0.95062E+00,-0.95353E+00/
                             
     DATA (BNC02M (IA),IA=101,200)/                                     &
     -0.95642E+00,-0.95930E+00,-0.96217E+00,-0.96502E+00,-0.96786E+00,&
     -0.97068E+00,-0.97349E+00,-0.97628E+00,-0.97907E+00,-0.98184E+00,&
     -0.98459E+00,-0.98733E+00,-0.99007E+00,-0.99278E+00,-0.99549E+00,&
     -0.99818E+00,-0.10009E+01,-0.10035E+01,-0.10062E+01,-0.10088E+01,&
     -0.10114E+01,-0.10141E+01,-0.10167E+01,-0.10193E+01,-0.10219E+01,&
     -0.10245E+01,-0.10270E+01,-0.10296E+01,-0.10321E+01,-0.10347E+01,&
     -0.10372E+01,-0.10397E+01,-0.10422E+01,-0.10447E+01,-0.10472E+01,&
     -0.10497E+01,-0.10522E+01,-0.10546E+01,-0.10571E+01,-0.10595E+01,&
     -0.10620E+01,-0.10644E+01,-0.10668E+01,-0.10692E+01,-0.10716E+01,&
     -0.10740E+01,-0.10764E+01,-0.10787E+01,-0.10811E+01,-0.10835E+01,&
     -0.10858E+01,-0.10881E+01,-0.10905E+01,-0.10928E+01,-0.10951E+01,&
     -0.10974E+01,-0.10997E+01,-0.11020E+01,-0.11043E+01,-0.11066E+01,&
     -0.11088E+01,-0.11111E+01,-0.11134E+01,-0.11156E+01,-0.11179E+01,&
     -0.11201E+01,-0.11223E+01,-0.11246E+01,-0.11268E+01,-0.11290E+01,&
     -0.11312E+01,-0.11334E+01,-0.11356E+01,-0.11378E+01,-0.11399E+01,&
     -0.11421E+01,-0.11443E+01,-0.11465E+01,-0.11486E+01,-0.11508E+01,&
     -0.11529E+01,-0.11550E+01,-0.11572E+01,-0.11593E+01,-0.11614E+01,&
     -0.11635E+01,-0.11657E+01,-0.11678E+01,-0.11699E+01,-0.11720E+01,&
     -0.11740E+01,-0.11761E+01,-0.11782E+01,-0.11803E+01,-0.11824E+01,&
     -0.11844E+01,-0.11865E+01,-0.11885E+01,-0.11906E+01,-0.11926E+01/
                             
     DATA (BNC02M (IA),IA=201,300)/                                     &
     -0.11947E+01,-0.11967E+01,-0.11987E+01,-0.12008E+01,-0.12028E+01,&
     -0.12048E+01,-0.12068E+01,-0.12088E+01,-0.12108E+01,-0.12128E+01,&
     -0.12148E+01,-0.12168E+01,-0.12188E+01,-0.12208E+01,-0.12228E+01,&
     -0.12247E+01,-0.12267E+01,-0.12287E+01,-0.12306E+01,-0.12326E+01,&
     -0.12345E+01,-0.12365E+01,-0.12384E+01,-0.12404E+01,-0.12423E+01,&
     -0.12443E+01,-0.12462E+01,-0.12481E+01,-0.12500E+01,-0.12520E+01,&
     -0.12539E+01,-0.12558E+01,-0.12577E+01,-0.12596E+01,-0.12615E+01,&
     -0.12634E+01,-0.12653E+01,-0.12672E+01,-0.12691E+01,-0.12710E+01,&
     -0.12728E+01,-0.12747E+01,-0.12766E+01,-0.12785E+01,-0.12803E+01,&
     -0.12822E+01,-0.12840E+01,-0.12859E+01,-0.12878E+01,-0.12896E+01,&
     -0.12915E+01,-0.12933E+01,-0.12951E+01,-0.12970E+01,-0.12988E+01,&
     -0.13006E+01,-0.13025E+01,-0.13043E+01,-0.13061E+01,-0.13079E+01,&
     -0.13098E+01,-0.13116E+01,-0.13134E+01,-0.13152E+01,-0.13170E+01,&
     -0.13188E+01,-0.13206E+01,-0.13224E+01,-0.13242E+01,-0.13260E+01,&
     -0.13278E+01,-0.13296E+01,-0.13313E+01,-0.13331E+01,-0.13349E+01,&
     -0.13367E+01,-0.13385E+01,-0.13402E+01,-0.13420E+01,-0.13438E+01,&
     -0.13455E+01,-0.13473E+01,-0.13490E+01,-0.13508E+01,-0.13525E+01,&
     -0.13543E+01,-0.13560E+01,-0.13578E+01,-0.13595E+01,-0.13613E+01,&
     -0.13630E+01,-0.13647E+01,-0.13665E+01,-0.13682E+01,-0.13699E+01,&
     -0.13717E+01,-0.13734E+01,-0.13751E+01,-0.13768E+01,-0.13785E+01/
                             
     DATA (BNC02M (IA),IA=301,400)/                                     &
     -0.13802E+01,-0.13820E+01,-0.13837E+01,-0.13854E+01,-0.13871E+01,&
     -0.13888E+01,-0.13905E+01,-0.13922E+01,-0.13939E+01,-0.13956E+01,&
     -0.13973E+01,-0.13989E+01,-0.14006E+01,-0.14023E+01,-0.14040E+01,&
     -0.14057E+01,-0.14074E+01,-0.14090E+01,-0.14107E+01,-0.14124E+01,&
     -0.14141E+01,-0.14157E+01,-0.14174E+01,-0.14191E+01,-0.14207E+01,&
     -0.14224E+01,-0.14240E+01,-0.14257E+01,-0.14274E+01,-0.14290E+01,&
     -0.14307E+01,-0.14323E+01,-0.14340E+01,-0.14356E+01,-0.14372E+01,&
     -0.14389E+01,-0.14405E+01,-0.14422E+01,-0.14438E+01,-0.14454E+01,&
     -0.14471E+01,-0.14487E+01,-0.14503E+01,-0.14519E+01,-0.14536E+01,&
     -0.14552E+01,-0.14568E+01,-0.14584E+01,-0.14601E+01,-0.14617E+01,&
     -0.14633E+01,-0.14649E+01,-0.14665E+01,-0.14681E+01,-0.14697E+01,&
     -0.14713E+01,-0.14729E+01,-0.14745E+01,-0.14761E+01,-0.14777E+01,&
     -0.14793E+01,-0.14809E+01,-0.14825E+01,-0.14841E+01,-0.14857E+01,&
     -0.14873E+01,-0.14889E+01,-0.14905E+01,-0.14921E+01,-0.14936E+01,&
     -0.14952E+01,-0.14968E+01,-0.14984E+01,-0.15000E+01,-0.15015E+01,&
     -0.15031E+01,-0.15047E+01,-0.15062E+01,-0.15078E+01,-0.15094E+01,&
     -0.15110E+01,-0.15125E+01,-0.15141E+01,-0.15156E+01,-0.15172E+01,&
     -0.15188E+01,-0.15203E+01,-0.15219E+01,-0.15234E+01,-0.15250E+01,&
     -0.15265E+01,-0.15281E+01,-0.15296E+01,-0.15312E+01,-0.15327E+01,&
     -0.15343E+01,-0.15358E+01,-0.15374E+01,-0.15389E+01,-0.15404E+01/
                             
     DATA (BNC02M (IA),IA=401,500)/                                     &
     -0.15420E+01,-0.15435E+01,-0.15450E+01,-0.15466E+01,-0.15481E+01,&
     -0.15496E+01,-0.15512E+01,-0.15527E+01,-0.15542E+01,-0.15557E+01,&
     -0.15573E+01,-0.15588E+01,-0.15603E+01,-0.15618E+01,-0.15634E+01,&
     -0.15649E+01,-0.15664E+01,-0.15679E+01,-0.15694E+01,-0.15709E+01,&
     -0.15724E+01,-0.15740E+01,-0.15755E+01,-0.15770E+01,-0.15785E+01,&
     -0.15800E+01,-0.15815E+01,-0.15830E+01,-0.15845E+01,-0.15860E+01,&
     -0.15875E+01,-0.15890E+01,-0.15905E+01,-0.15920E+01,-0.15935E+01,&
     -0.15950E+01,-0.15965E+01,-0.15979E+01,-0.15994E+01,-0.16009E+01,&
     -0.16024E+01,-0.16039E+01,-0.16054E+01,-0.16069E+01,-0.16083E+01,&
     -0.16098E+01,-0.16113E+01,-0.16128E+01,-0.16143E+01,-0.16157E+01,&
     -0.16172E+01,-0.16187E+01,-0.16202E+01,-0.16216E+01,-0.16231E+01,&
     -0.16246E+01,-0.16260E+01,-0.16275E+01,-0.16290E+01,-0.16305E+01,&
     -0.16319E+01,-0.16334E+01,-0.16348E+01,-0.16363E+01,-0.16378E+01,&
     -0.16392E+01,-0.16407E+01,-0.16421E+01,-0.16436E+01,-0.16451E+01,&
     -0.16465E+01,-0.16480E+01,-0.16494E+01,-0.16509E+01,-0.16523E+01,&
     -0.16538E+01,-0.16552E+01,-0.16567E+01,-0.16581E+01,-0.16596E+01,&
     -0.16610E+01,-0.16624E+01,-0.16639E+01,-0.16653E+01,-0.16668E+01,&
     -0.16682E+01,-0.16696E+01,-0.16711E+01,-0.16725E+01,-0.16739E+01,&
     -0.16754E+01,-0.16768E+01,-0.16783E+01,-0.16797E+01,-0.16811E+01,&
     -0.16825E+01,-0.16840E+01,-0.16854E+01,-0.16868E+01,-0.16883E+01/
                             
     DATA (BNC02M (IA),IA=501,600)/                                     &
     -0.16897E+01,-0.16911E+01,-0.16925E+01,-0.16939E+01,-0.16954E+01,&
     -0.16968E+01,-0.16982E+01,-0.16996E+01,-0.17010E+01,-0.17025E+01,&
     -0.17039E+01,-0.17053E+01,-0.17067E+01,-0.17081E+01,-0.17095E+01,&
     -0.17109E+01,-0.17124E+01,-0.17138E+01,-0.17152E+01,-0.17166E+01,&
     -0.17180E+01,-0.17194E+01,-0.17208E+01,-0.17222E+01,-0.17236E+01,&
     -0.17250E+01,-0.17264E+01,-0.17278E+01,-0.17292E+01,-0.17306E+01,&
     -0.17320E+01,-0.17334E+01,-0.17348E+01,-0.17362E+01,-0.17376E+01,&
     -0.17390E+01,-0.17404E+01,-0.17418E+01,-0.17432E+01,-0.17446E+01,&
     -0.17460E+01,-0.17473E+01,-0.17487E+01,-0.17501E+01,-0.17515E+01,&
     -0.17529E+01,-0.17543E+01,-0.17557E+01,-0.17571E+01,-0.17584E+01,&
     -0.17598E+01,-0.17612E+01,-0.17626E+01,-0.17640E+01,-0.17653E+01,&
     -0.17667E+01,-0.17681E+01,-0.17695E+01,-0.17709E+01,-0.17722E+01,&
     -0.17736E+01,-0.17750E+01,-0.17764E+01,-0.17777E+01,-0.17791E+01,&
     -0.17805E+01,-0.17818E+01,-0.17832E+01,-0.17846E+01,-0.17859E+01,&
     -0.17873E+01,-0.17887E+01,-0.17900E+01,-0.17914E+01,-0.17928E+01,&
     -0.17941E+01,-0.17955E+01,-0.17969E+01,-0.17982E+01,-0.17996E+01,&
     -0.18009E+01,-0.18023E+01,-0.18037E+01,-0.18050E+01,-0.18064E+01,&
     -0.18077E+01,-0.18091E+01,-0.18105E+01,-0.18118E+01,-0.18132E+01,&
     -0.18145E+01,-0.18159E+01,-0.18172E+01,-0.18186E+01,-0.18199E+01,&
     -0.18213E+01,-0.18226E+01,-0.18240E+01,-0.18253E+01,-0.18304E+01/
                             
     DATA (BNC02M (IA),IA=601,700)/                                     &
     -0.18414E+01,-0.18548E+01,-0.18681E+01,-0.18813E+01,-0.18945E+01,&
     -0.19076E+01,-0.19207E+01,-0.19337E+01,-0.19467E+01,-0.19596E+01,&
     -0.19724E+01,-0.19852E+01,-0.19980E+01,-0.20107E+01,-0.20233E+01,&
     -0.20359E+01,-0.20485E+01,-0.20610E+01,-0.20735E+01,-0.20859E+01,&
     -0.20983E+01,-0.21107E+01,-0.21230E+01,-0.21353E+01,-0.21475E+01,&
     -0.21598E+01,-0.21719E+01,-0.21841E+01,-0.21962E+01,-0.22082E+01,&
     -0.22203E+01,-0.22323E+01,-0.22442E+01,-0.22562E+01,-0.22681E+01,&
     -0.22800E+01,-0.22918E+01,-0.23036E+01,-0.23154E+01,-0.23272E+01,&
     -0.23389E+01,-0.23506E+01,-0.23623E+01,-0.23740E+01,-0.23856E+01,&
     -0.23972E+01,-0.24088E+01,-0.24204E+01,-0.24319E+01,-0.24434E+01,&
     -0.24549E+01,-0.24663E+01,-0.24778E+01,-0.24892E+01,-0.25006E+01,&
     -0.25119E+01,-0.25233E+01,-0.25346E+01,-0.25459E+01,-0.25572E+01,&
     -0.25685E+01,-0.25797E+01,-0.25910E+01,-0.26022E+01,-0.26134E+01,&
     -0.26245E+01,-0.26357E+01,-0.26468E+01,-0.26579E+01,-0.26690E+01,&
     -0.26801E+01,-0.26912E+01,-0.27022E+01,-0.27132E+01,-0.27242E+01,&
     -0.27352E+01,-0.27462E+01,-0.27572E+01,-0.27681E+01,-0.27790E+01,&
     -0.27900E+01,-0.28009E+01,-0.28117E+01,-0.28226E+01,-0.28335E+01,&
     -0.28443E+01,-0.28551E+01,-0.28659E+01,-0.28767E+01,-0.28875E+01,&
     -0.28983E+01,-0.29090E+01,-0.29198E+01,-0.29305E+01,-0.29412E+01,&
     -0.29519E+01,-0.29626E+01,-0.29733E+01,-0.29839E+01,-0.29946E+01/
                             
     DATA (BNC02M(IA),IA=701,741)/                                      &
     -0.30052E+01,-0.30158E+01,-0.30264E+01,-0.30370E+01,-0.30476E+01,&
     -0.30582E+01,-0.30688E+01,-0.30793E+01,-0.30899E+01,-0.31004E+01,&
     -0.31109E+01,-0.31214E+01,-0.31319E+01,-0.31424E+01,-0.31529E+01,&
     -0.31633E+01,-0.31738E+01,-0.31842E+01,-0.31946E+01,-0.32051E+01,&
     -0.32155E+01,-0.32259E+01,-0.32363E+01,-0.32466E+01,-0.32570E+01,&
     -0.32674E+01,-0.32777E+01,-0.32881E+01,-0.32984E+01,-0.33087E+01,&
     -0.33190E+01,-0.33293E+01,-0.33396E+01,-0.33499E+01,-0.33602E+01,&
     -0.33705E+01,-0.33807E+01,-0.33910E+01,-0.34012E+01,-0.34114E+01,&
     -0.34217E+01                  /                      
!                            
!  ** NaNO3                  
!                            
     DATA (BNC03M (IA),IA=  1,100)/                                     &
     -0.55791E-01,-0.10256E+00,-0.13620E+00,-0.15954E+00,-0.17783E+00,&
     -0.19304E+00,-0.20616E+00,-0.21773E+00,-0.22813E+00,-0.23760E+00,&
     -0.24630E+00,-0.25438E+00,-0.26192E+00,-0.26900E+00,-0.27569E+00,&
     -0.28203E+00,-0.28806E+00,-0.29382E+00,-0.29933E+00,-0.30462E+00,&
     -0.30971E+00,-0.31462E+00,-0.31936E+00,-0.32394E+00,-0.32838E+00,&
     -0.33269E+00,-0.33687E+00,-0.34094E+00,-0.34490E+00,-0.34876E+00,&
     -0.35252E+00,-0.35620E+00,-0.35979E+00,-0.36330E+00,-0.36674E+00,&
     -0.37010E+00,-0.37340E+00,-0.37663E+00,-0.37979E+00,-0.38290E+00,&
     -0.38596E+00,-0.38895E+00,-0.39190E+00,-0.39480E+00,-0.39764E+00,&
     -0.40045E+00,-0.40320E+00,-0.40592E+00,-0.40859E+00,-0.41123E+00,&
     -0.41383E+00,-0.41639E+00,-0.41891E+00,-0.42141E+00,-0.42387E+00,&
     -0.42629E+00,-0.42869E+00,-0.43106E+00,-0.43340E+00,-0.43571E+00,&
     -0.43799E+00,-0.44025E+00,-0.44249E+00,-0.44470E+00,-0.44689E+00,&
     -0.44905E+00,-0.45120E+00,-0.45332E+00,-0.45543E+00,-0.45752E+00,&
     -0.45958E+00,-0.46163E+00,-0.46367E+00,-0.46568E+00,-0.46768E+00,&
     -0.46967E+00,-0.47164E+00,-0.47359E+00,-0.47554E+00,-0.47747E+00,&
     -0.47938E+00,-0.48129E+00,-0.48318E+00,-0.48506E+00,-0.48693E+00,&
     -0.48879E+00,-0.49064E+00,-0.49247E+00,-0.49430E+00,-0.49612E+00,&
     -0.49793E+00,-0.49973E+00,-0.50152E+00,-0.50330E+00,-0.50508E+00,&
     -0.50684E+00,-0.50860E+00,-0.51035E+00,-0.51209E+00,-0.51383E+00/
                             
     DATA (BNC03M (IA),IA=101,200)/                                     &
     -0.51555E+00,-0.51727E+00,-0.51898E+00,-0.52069E+00,-0.52239E+00,&
     -0.52408E+00,-0.52576E+00,-0.52743E+00,-0.52910E+00,-0.53077E+00,&
     -0.53242E+00,-0.53407E+00,-0.53571E+00,-0.53735E+00,-0.53898E+00,&
     -0.54060E+00,-0.54221E+00,-0.54382E+00,-0.54543E+00,-0.54702E+00,&
     -0.54856E+00,-0.55015E+00,-0.55173E+00,-0.55331E+00,-0.55488E+00,&
     -0.55644E+00,-0.55800E+00,-0.55955E+00,-0.56109E+00,-0.56263E+00,&
     -0.56416E+00,-0.56568E+00,-0.56720E+00,-0.56871E+00,-0.57022E+00,&
     -0.57172E+00,-0.57322E+00,-0.57471E+00,-0.57619E+00,-0.57767E+00,&
     -0.57915E+00,-0.58061E+00,-0.58208E+00,-0.58353E+00,-0.58499E+00,&
     -0.58643E+00,-0.58787E+00,-0.58931E+00,-0.59074E+00,-0.59217E+00,&
     -0.59359E+00,-0.59501E+00,-0.59642E+00,-0.59783E+00,-0.59924E+00,&
     -0.60063E+00,-0.60203E+00,-0.60342E+00,-0.60480E+00,-0.60619E+00,&
     -0.60756E+00,-0.60893E+00,-0.61030E+00,-0.61167E+00,-0.61303E+00,&
     -0.61438E+00,-0.61573E+00,-0.61708E+00,-0.61842E+00,-0.61976E+00,&
     -0.62110E+00,-0.62243E+00,-0.62376E+00,-0.62508E+00,-0.62640E+00,&
     -0.62772E+00,-0.62903E+00,-0.63034E+00,-0.63165E+00,-0.63295E+00,&
     -0.63425E+00,-0.63554E+00,-0.63683E+00,-0.63812E+00,-0.63941E+00,&
     -0.64069E+00,-0.64196E+00,-0.64324E+00,-0.64451E+00,-0.64578E+00,&
     -0.64704E+00,-0.64830E+00,-0.64956E+00,-0.65082E+00,-0.65207E+00,&
     -0.65332E+00,-0.65456E+00,-0.65580E+00,-0.65704E+00,-0.65828E+00/
                             
     DATA (BNC03M (IA),IA=201,300)/                                     &
     -0.65951E+00,-0.66074E+00,-0.66197E+00,-0.66320E+00,-0.66442E+00,&
     -0.66564E+00,-0.66685E+00,-0.66807E+00,-0.66928E+00,-0.67048E+00,&
     -0.67169E+00,-0.67289E+00,-0.67409E+00,-0.67529E+00,-0.67648E+00,&
     -0.67767E+00,-0.67886E+00,-0.68005E+00,-0.68123E+00,-0.68241E+00,&
     -0.68359E+00,-0.68476E+00,-0.68594E+00,-0.68711E+00,-0.68828E+00,&
     -0.68944E+00,-0.69060E+00,-0.69177E+00,-0.69292E+00,-0.69408E+00,&
     -0.69523E+00,-0.69638E+00,-0.69753E+00,-0.69868E+00,-0.69983E+00,&
     -0.70097E+00,-0.70211E+00,-0.70324E+00,-0.70438E+00,-0.70551E+00,&
     -0.70664E+00,-0.70777E+00,-0.70890E+00,-0.71002E+00,-0.71115E+00,&
     -0.71227E+00,-0.71338E+00,-0.71450E+00,-0.71561E+00,-0.71672E+00,&
     -0.71783E+00,-0.71894E+00,-0.72005E+00,-0.72115E+00,-0.72225E+00,&
     -0.72335E+00,-0.72445E+00,-0.72554E+00,-0.72664E+00,-0.72773E+00,&
     -0.72882E+00,-0.72991E+00,-0.73099E+00,-0.73208E+00,-0.73316E+00,&
     -0.73424E+00,-0.73532E+00,-0.73639E+00,-0.73747E+00,-0.73854E+00,&
     -0.73961E+00,-0.74068E+00,-0.74175E+00,-0.74281E+00,-0.74388E+00,&
     -0.74494E+00,-0.74600E+00,-0.74706E+00,-0.74811E+00,-0.74917E+00,&
     -0.75022E+00,-0.75127E+00,-0.75232E+00,-0.75337E+00,-0.75442E+00,&
     -0.75546E+00,-0.75651E+00,-0.75755E+00,-0.75859E+00,-0.75962E+00,&
     -0.76066E+00,-0.76170E+00,-0.76273E+00,-0.76376E+00,-0.76479E+00,&
     -0.76582E+00,-0.76685E+00,-0.76787E+00,-0.76890E+00,-0.76992E+00/
                             
     DATA (BNC03M (IA),IA=301,400)/                                     &
     -0.77094E+00,-0.77196E+00,-0.77298E+00,-0.77399E+00,-0.77501E+00,&
     -0.77602E+00,-0.77703E+00,-0.77804E+00,-0.77905E+00,-0.78006E+00,&
     -0.78107E+00,-0.78207E+00,-0.78308E+00,-0.78408E+00,-0.78508E+00,&
     -0.78608E+00,-0.78707E+00,-0.78807E+00,-0.78906E+00,-0.79006E+00,&
     -0.79105E+00,-0.79204E+00,-0.79303E+00,-0.79402E+00,-0.79500E+00,&
     -0.79599E+00,-0.79697E+00,-0.79796E+00,-0.79894E+00,-0.79992E+00,&
     -0.80090E+00,-0.80187E+00,-0.80285E+00,-0.80382E+00,-0.80480E+00,&
     -0.80577E+00,-0.80674E+00,-0.80771E+00,-0.80868E+00,-0.80965E+00,&
     -0.81061E+00,-0.81158E+00,-0.81254E+00,-0.81350E+00,-0.81446E+00,&
     -0.81542E+00,-0.81638E+00,-0.81734E+00,-0.81829E+00,-0.81925E+00,&
     -0.82020E+00,-0.82116E+00,-0.82211E+00,-0.82306E+00,-0.82401E+00,&
     -0.82496E+00,-0.82590E+00,-0.82685E+00,-0.82779E+00,-0.82874E+00,&
     -0.82968E+00,-0.83062E+00,-0.83156E+00,-0.83250E+00,-0.83344E+00,&
     -0.83437E+00,-0.83531E+00,-0.83624E+00,-0.83718E+00,-0.83811E+00,&
     -0.83904E+00,-0.83997E+00,-0.84090E+00,-0.84183E+00,-0.84275E+00,&
     -0.84368E+00,-0.84460E+00,-0.84553E+00,-0.84645E+00,-0.84737E+00,&
     -0.84829E+00,-0.84921E+00,-0.85013E+00,-0.85105E+00,-0.85197E+00,&
     -0.85288E+00,-0.85380E+00,-0.85471E+00,-0.85562E+00,-0.85653E+00,&
     -0.85744E+00,-0.85835E+00,-0.85926E+00,-0.86017E+00,-0.86108E+00,&
     -0.86198E+00,-0.86289E+00,-0.86379E+00,-0.86469E+00,-0.86560E+00/
                             
     DATA (BNC03M (IA),IA=401,500)/                                     &
     -0.86650E+00,-0.86740E+00,-0.86830E+00,-0.86919E+00,-0.87009E+00,&
     -0.87099E+00,-0.87188E+00,-0.87278E+00,-0.87367E+00,-0.87456E+00,&
     -0.87545E+00,-0.87634E+00,-0.87723E+00,-0.87812E+00,-0.87901E+00,&
     -0.87990E+00,-0.88078E+00,-0.88167E+00,-0.88255E+00,-0.88344E+00,&
     -0.88432E+00,-0.88520E+00,-0.88608E+00,-0.88696E+00,-0.88784E+00,&
     -0.88872E+00,-0.88960E+00,-0.89048E+00,-0.89135E+00,-0.89223E+00,&
     -0.89310E+00,-0.89397E+00,-0.89485E+00,-0.89572E+00,-0.89659E+00,&
     -0.89746E+00,-0.89833E+00,-0.89920E+00,-0.90006E+00,-0.90093E+00,&
     -0.90180E+00,-0.90266E+00,-0.90353E+00,-0.90439E+00,-0.90525E+00,&
     -0.90612E+00,-0.90698E+00,-0.90784E+00,-0.90870E+00,-0.90956E+00,&
     -0.91041E+00,-0.91127E+00,-0.91213E+00,-0.91298E+00,-0.91384E+00,&
     -0.91469E+00,-0.91555E+00,-0.91640E+00,-0.91725E+00,-0.91810E+00,&
     -0.91895E+00,-0.91980E+00,-0.92065E+00,-0.92150E+00,-0.92235E+00,&
     -0.92319E+00,-0.92404E+00,-0.92488E+00,-0.92573E+00,-0.92657E+00,&
     -0.92742E+00,-0.92826E+00,-0.92910E+00,-0.92994E+00,-0.93078E+00,&
     -0.93162E+00,-0.93246E+00,-0.93330E+00,-0.93413E+00,-0.93497E+00,&
     -0.93581E+00,-0.93664E+00,-0.93748E+00,-0.93831E+00,-0.93914E+00,&
     -0.93998E+00,-0.94081E+00,-0.94164E+00,-0.94247E+00,-0.94330E+00,&
     -0.94413E+00,-0.94496E+00,-0.94578E+00,-0.94661E+00,-0.94744E+00,&
     -0.94826E+00,-0.94909E+00,-0.94991E+00,-0.95074E+00,-0.95156E+00/
                             
     DATA (BNC03M (IA),IA=501,600)/                                     &
     -0.95238E+00,-0.95320E+00,-0.95403E+00,-0.95485E+00,-0.95567E+00,&
     -0.95649E+00,-0.95730E+00,-0.95812E+00,-0.95894E+00,-0.95976E+00,&
     -0.96057E+00,-0.96139E+00,-0.96220E+00,-0.96302E+00,-0.96383E+00,&
     -0.96464E+00,-0.96546E+00,-0.96627E+00,-0.96708E+00,-0.96789E+00,&
     -0.96870E+00,-0.96951E+00,-0.97032E+00,-0.97113E+00,-0.97193E+00,&
     -0.97274E+00,-0.97355E+00,-0.97435E+00,-0.97516E+00,-0.97596E+00,&
     -0.97677E+00,-0.97757E+00,-0.97837E+00,-0.97917E+00,-0.97997E+00,&
     -0.98078E+00,-0.98158E+00,-0.98238E+00,-0.98318E+00,-0.98397E+00,&
     -0.98477E+00,-0.98557E+00,-0.98637E+00,-0.98716E+00,-0.98796E+00,&
     -0.98875E+00,-0.98955E+00,-0.99034E+00,-0.99114E+00,-0.99193E+00,&
     -0.99272E+00,-0.99351E+00,-0.99431E+00,-0.99510E+00,-0.99589E+00,&
     -0.99668E+00,-0.99747E+00,-0.99825E+00,-0.99904E+00,-0.99983E+00,&
     -0.10006E+01,-0.10014E+01,-0.10022E+01,-0.10030E+01,-0.10038E+01,&
     -0.10045E+01,-0.10053E+01,-0.10061E+01,-0.10069E+01,-0.10077E+01,&
     -0.10085E+01,-0.10092E+01,-0.10100E+01,-0.10108E+01,-0.10116E+01,&
     -0.10124E+01,-0.10131E+01,-0.10139E+01,-0.10147E+01,-0.10155E+01,&
     -0.10162E+01,-0.10170E+01,-0.10178E+01,-0.10186E+01,-0.10193E+01,&
     -0.10201E+01,-0.10209E+01,-0.10217E+01,-0.10224E+01,-0.10232E+01,&
     -0.10240E+01,-0.10248E+01,-0.10255E+01,-0.10263E+01,-0.10271E+01,&
     -0.10278E+01,-0.10286E+01,-0.10294E+01,-0.10301E+01,-0.10330E+01/
                             
     DATA (BNC03M (IA),IA=601,700)/                                     &
     -0.10393E+01,-0.10469E+01,-0.10545E+01,-0.10620E+01,-0.10694E+01,&
     -0.10769E+01,-0.10842E+01,-0.10916E+01,-0.10989E+01,-0.11062E+01,&
     -0.11134E+01,-0.11206E+01,-0.11277E+01,-0.11349E+01,-0.11420E+01,&
     -0.11490E+01,-0.11560E+01,-0.11630E+01,-0.11700E+01,-0.11769E+01,&
     -0.11838E+01,-0.11907E+01,-0.11976E+01,-0.12044E+01,-0.12112E+01,&
     -0.12180E+01,-0.12247E+01,-0.12314E+01,-0.12381E+01,-0.12448E+01,&
     -0.12514E+01,-0.12581E+01,-0.12647E+01,-0.12713E+01,-0.12778E+01,&
     -0.12843E+01,-0.12909E+01,-0.12974E+01,-0.13038E+01,-0.13103E+01,&
     -0.13167E+01,-0.13231E+01,-0.13295E+01,-0.13359E+01,-0.13423E+01,&
     -0.13486E+01,-0.13549E+01,-0.13612E+01,-0.13675E+01,-0.13738E+01,&
     -0.13800E+01,-0.13863E+01,-0.13925E+01,-0.13987E+01,-0.14049E+01,&
     -0.14111E+01,-0.14172E+01,-0.14234E+01,-0.14295E+01,-0.14356E+01,&
     -0.14417E+01,-0.14478E+01,-0.14539E+01,-0.14599E+01,-0.14660E+01,&
     -0.14720E+01,-0.14780E+01,-0.14840E+01,-0.14900E+01,-0.14960E+01,&
     -0.15020E+01,-0.15079E+01,-0.15139E+01,-0.15198E+01,-0.15257E+01,&
     -0.15316E+01,-0.15375E+01,-0.15434E+01,-0.15493E+01,-0.15551E+01,&
     -0.15610E+01,-0.15668E+01,-0.15727E+01,-0.15785E+01,-0.15843E+01,&
     -0.15901E+01,-0.15959E+01,-0.16017E+01,-0.16074E+01,-0.16132E+01,&
     -0.16189E+01,-0.16247E+01,-0.16304E+01,-0.16361E+01,-0.16418E+01,&
     -0.16475E+01,-0.16532E+01,-0.16589E+01,-0.16646E+01,-0.16703E+01/
                             
     DATA (BNC03M(IA),IA=701,741)/                                      &
     -0.16759E+01,-0.16816E+01,-0.16872E+01,-0.16928E+01,-0.16985E+01,&
     -0.17041E+01,-0.17097E+01,-0.17153E+01,-0.17209E+01,-0.17265E+01,&
     -0.17320E+01,-0.17376E+01,-0.17432E+01,-0.17487E+01,-0.17543E+01,&
     -0.17598E+01,-0.17653E+01,-0.17709E+01,-0.17764E+01,-0.17819E+01,&
     -0.17874E+01,-0.17929E+01,-0.17984E+01,-0.18039E+01,-0.18093E+01,&
     -0.18148E+01,-0.18203E+01,-0.18257E+01,-0.18312E+01,-0.18366E+01,&
     -0.18420E+01,-0.18475E+01,-0.18529E+01,-0.18583E+01,-0.18637E+01,&
     -0.18691E+01,-0.18745E+01,-0.18799E+01,-0.18853E+01,-0.18907E+01,&
     -0.18960E+01                  /                      
!                            
!  ** (NH4)2SO4              
!                            
     DATA (BNC04M (IA),IA=  1,100)/                                     &
     -0.11131E+00,-0.20410E+00,-0.27045E+00,-0.31626E+00,-0.35200E+00,&
     -0.38161E+00,-0.40704E+00,-0.42941E+00,-0.44944E+00,-0.46762E+00,&
     -0.48429E+00,-0.49971E+00,-0.51407E+00,-0.52753E+00,-0.54020E+00,&
     -0.55219E+00,-0.56357E+00,-0.57441E+00,-0.58476E+00,-0.59468E+00,&
     -0.60421E+00,-0.61337E+00,-0.62220E+00,-0.63073E+00,-0.63898E+00,&
     -0.64698E+00,-0.65473E+00,-0.66226E+00,-0.66958E+00,-0.67670E+00,&
     -0.68364E+00,-0.69041E+00,-0.69701E+00,-0.70347E+00,-0.70977E+00,&
     -0.71594E+00,-0.72198E+00,-0.72789E+00,-0.73369E+00,-0.73937E+00,&
     -0.74495E+00,-0.75042E+00,-0.75579E+00,-0.76107E+00,-0.76627E+00,&
     -0.77137E+00,-0.77639E+00,-0.78133E+00,-0.78620E+00,-0.79099E+00,&
     -0.79571E+00,-0.80036E+00,-0.80495E+00,-0.80947E+00,-0.81393E+00,&
     -0.81834E+00,-0.82268E+00,-0.82697E+00,-0.83121E+00,-0.83540E+00,&
     -0.83954E+00,-0.84363E+00,-0.84768E+00,-0.85168E+00,-0.85563E+00,&
     -0.85955E+00,-0.86343E+00,-0.86727E+00,-0.87107E+00,-0.87483E+00,&
     -0.87856E+00,-0.88226E+00,-0.88592E+00,-0.88956E+00,-0.89316E+00,&
     -0.89673E+00,-0.90027E+00,-0.90379E+00,-0.90728E+00,-0.91075E+00,&
     -0.91419E+00,-0.91760E+00,-0.92099E+00,-0.92436E+00,-0.92771E+00,&
     -0.93104E+00,-0.93434E+00,-0.93763E+00,-0.94089E+00,-0.94414E+00,&
     -0.94737E+00,-0.95058E+00,-0.95377E+00,-0.95694E+00,-0.96010E+00,&
     -0.96324E+00,-0.96636E+00,-0.96947E+00,-0.97256E+00,-0.97564E+00/
                             
     DATA (BNC04M (IA),IA=101,200)/                                     &
     -0.97870E+00,-0.98175E+00,-0.98478E+00,-0.98780E+00,-0.99081E+00,&
     -0.99380E+00,-0.99677E+00,-0.99974E+00,-0.10027E+01,-0.10056E+01,&
     -0.10085E+01,-0.10115E+01,-0.10144E+01,-0.10172E+01,-0.10201E+01,&
     -0.10230E+01,-0.10258E+01,-0.10286E+01,-0.10315E+01,-0.10343E+01,&
     -0.10370E+01,-0.10398E+01,-0.10426E+01,-0.10454E+01,-0.10481E+01,&
     -0.10509E+01,-0.10536E+01,-0.10563E+01,-0.10590E+01,-0.10617E+01,&
     -0.10644E+01,-0.10671E+01,-0.10698E+01,-0.10724E+01,-0.10751E+01,&
     -0.10777E+01,-0.10803E+01,-0.10830E+01,-0.10856E+01,-0.10882E+01,&
     -0.10908E+01,-0.10933E+01,-0.10959E+01,-0.10985E+01,-0.11010E+01,&
     -0.11036E+01,-0.11061E+01,-0.11086E+01,-0.11111E+01,-0.11136E+01,&
     -0.11161E+01,-0.11186E+01,-0.11211E+01,-0.11236E+01,-0.11260E+01,&
     -0.11285E+01,-0.11309E+01,-0.11334E+01,-0.11358E+01,-0.11382E+01,&
     -0.11406E+01,-0.11431E+01,-0.11455E+01,-0.11479E+01,-0.11502E+01,&
     -0.11526E+01,-0.11550E+01,-0.11574E+01,-0.11597E+01,-0.11621E+01,&
     -0.11644E+01,-0.11668E+01,-0.11691E+01,-0.11714E+01,-0.11737E+01,&
     -0.11761E+01,-0.11784E+01,-0.11807E+01,-0.11830E+01,-0.11852E+01,&
     -0.11875E+01,-0.11898E+01,-0.11921E+01,-0.11943E+01,-0.11966E+01,&
     -0.11988E+01,-0.12011E+01,-0.12033E+01,-0.12056E+01,-0.12078E+01,&
     -0.12100E+01,-0.12122E+01,-0.12144E+01,-0.12166E+01,-0.12189E+01,&
     -0.12210E+01,-0.12232E+01,-0.12254E+01,-0.12276E+01,-0.12298E+01/
                             
     DATA (BNC04M (IA),IA=201,300)/                                     &
     -0.12319E+01,-0.12341E+01,-0.12363E+01,-0.12384E+01,-0.12406E+01,&
     -0.12427E+01,-0.12449E+01,-0.12470E+01,-0.12491E+01,-0.12513E+01,&
     -0.12534E+01,-0.12555E+01,-0.12576E+01,-0.12597E+01,-0.12618E+01,&
     -0.12639E+01,-0.12660E+01,-0.12681E+01,-0.12702E+01,-0.12723E+01,&
     -0.12743E+01,-0.12764E+01,-0.12785E+01,-0.12805E+01,-0.12826E+01,&
     -0.12847E+01,-0.12867E+01,-0.12888E+01,-0.12908E+01,-0.12928E+01,&
     -0.12949E+01,-0.12969E+01,-0.12989E+01,-0.13010E+01,-0.13030E+01,&
     -0.13050E+01,-0.13070E+01,-0.13090E+01,-0.13110E+01,-0.13130E+01,&
     -0.13150E+01,-0.13170E+01,-0.13190E+01,-0.13210E+01,-0.13230E+01,&
     -0.13249E+01,-0.13269E+01,-0.13289E+01,-0.13309E+01,-0.13328E+01,&
     -0.13348E+01,-0.13367E+01,-0.13387E+01,-0.13406E+01,-0.13426E+01,&
     -0.13445E+01,-0.13465E+01,-0.13484E+01,-0.13504E+01,-0.13523E+01,&
     -0.13542E+01,-0.13561E+01,-0.13581E+01,-0.13600E+01,-0.13619E+01,&
     -0.13638E+01,-0.13657E+01,-0.13676E+01,-0.13695E+01,-0.13714E+01,&
     -0.13733E+01,-0.13752E+01,-0.13771E+01,-0.13790E+01,-0.13809E+01,&
     -0.13828E+01,-0.13846E+01,-0.13865E+01,-0.13884E+01,-0.13903E+01,&
     -0.13921E+01,-0.13940E+01,-0.13958E+01,-0.13977E+01,-0.13996E+01,&
     -0.14014E+01,-0.14033E+01,-0.14051E+01,-0.14070E+01,-0.14088E+01,&
     -0.14106E+01,-0.14125E+01,-0.14143E+01,-0.14162E+01,-0.14180E+01,&
     -0.14198E+01,-0.14216E+01,-0.14235E+01,-0.14253E+01,-0.14271E+01/
                             
     DATA (BNC04M (IA),IA=301,400)/                                     &
     -0.14289E+01,-0.14307E+01,-0.14325E+01,-0.14343E+01,-0.14361E+01,&
     -0.14379E+01,-0.14397E+01,-0.14415E+01,-0.14433E+01,-0.14451E+01,&
     -0.14469E+01,-0.14487E+01,-0.14505E+01,-0.14523E+01,-0.14541E+01,&
     -0.14558E+01,-0.14576E+01,-0.14594E+01,-0.14612E+01,-0.14629E+01,&
     -0.14647E+01,-0.14665E+01,-0.14682E+01,-0.14700E+01,-0.14717E+01,&
     -0.14735E+01,-0.14752E+01,-0.14770E+01,-0.14787E+01,-0.14805E+01,&
     -0.14822E+01,-0.14840E+01,-0.14857E+01,-0.14875E+01,-0.14892E+01,&
     -0.14909E+01,-0.14927E+01,-0.14944E+01,-0.14961E+01,-0.14979E+01,&
     -0.14996E+01,-0.15013E+01,-0.15030E+01,-0.15047E+01,-0.15065E+01,&
     -0.15082E+01,-0.15099E+01,-0.15116E+01,-0.15133E+01,-0.15150E+01,&
     -0.15167E+01,-0.15184E+01,-0.15201E+01,-0.15218E+01,-0.15235E+01,&
     -0.15252E+01,-0.15269E+01,-0.15286E+01,-0.15303E+01,-0.15320E+01,&
     -0.15337E+01,-0.15353E+01,-0.15370E+01,-0.15387E+01,-0.15404E+01,&
     -0.15421E+01,-0.15437E+01,-0.15454E+01,-0.15471E+01,-0.15488E+01,&
     -0.15504E+01,-0.15521E+01,-0.15538E+01,-0.15554E+01,-0.15571E+01,&
     -0.15587E+01,-0.15604E+01,-0.15620E+01,-0.15637E+01,-0.15654E+01,&
     -0.15670E+01,-0.15687E+01,-0.15703E+01,-0.15720E+01,-0.15736E+01,&
     -0.15752E+01,-0.15769E+01,-0.15785E+01,-0.15802E+01,-0.15818E+01,&
     -0.15834E+01,-0.15851E+01,-0.15867E+01,-0.15883E+01,-0.15900E+01,&
     -0.15916E+01,-0.15932E+01,-0.15948E+01,-0.15965E+01,-0.15981E+01/
                             
     DATA (BNC04M (IA),IA=401,500)/                                     &
     -0.15997E+01,-0.16013E+01,-0.16029E+01,-0.16045E+01,-0.16062E+01,&
     -0.16078E+01,-0.16094E+01,-0.16110E+01,-0.16126E+01,-0.16142E+01,&
     -0.16158E+01,-0.16174E+01,-0.16190E+01,-0.16206E+01,-0.16222E+01,&
     -0.16238E+01,-0.16254E+01,-0.16270E+01,-0.16286E+01,-0.16302E+01,&
     -0.16318E+01,-0.16334E+01,-0.16349E+01,-0.16365E+01,-0.16381E+01,&
     -0.16397E+01,-0.16413E+01,-0.16429E+01,-0.16444E+01,-0.16460E+01,&
     -0.16476E+01,-0.16492E+01,-0.16507E+01,-0.16523E+01,-0.16539E+01,&
     -0.16555E+01,-0.16570E+01,-0.16586E+01,-0.16602E+01,-0.16617E+01,&
     -0.16633E+01,-0.16648E+01,-0.16664E+01,-0.16680E+01,-0.16695E+01,&
     -0.16711E+01,-0.16726E+01,-0.16742E+01,-0.16757E+01,-0.16773E+01,&
     -0.16788E+01,-0.16804E+01,-0.16819E+01,-0.16835E+01,-0.16850E+01,&
     -0.16866E+01,-0.16881E+01,-0.16897E+01,-0.16912E+01,-0.16928E+01,&
     -0.16943E+01,-0.16958E+01,-0.16974E+01,-0.16989E+01,-0.17004E+01,&
     -0.17020E+01,-0.17035E+01,-0.17050E+01,-0.17066E+01,-0.17081E+01,&
     -0.17096E+01,-0.17111E+01,-0.17127E+01,-0.17142E+01,-0.17157E+01,&
     -0.17172E+01,-0.17187E+01,-0.17203E+01,-0.17218E+01,-0.17233E+01,&
     -0.17248E+01,-0.17263E+01,-0.17278E+01,-0.17294E+01,-0.17309E+01,&
     -0.17324E+01,-0.17339E+01,-0.17354E+01,-0.17369E+01,-0.17384E+01,&
     -0.17399E+01,-0.17414E+01,-0.17429E+01,-0.17444E+01,-0.17459E+01,&
     -0.17474E+01,-0.17489E+01,-0.17504E+01,-0.17519E+01,-0.17534E+01/
                             
     DATA (BNC04M (IA),IA=501,600)/                                     &
     -0.17549E+01,-0.17564E+01,-0.17579E+01,-0.17594E+01,-0.17609E+01,&
     -0.17623E+01,-0.17638E+01,-0.17653E+01,-0.17668E+01,-0.17683E+01,&
     -0.17698E+01,-0.17713E+01,-0.17727E+01,-0.17742E+01,-0.17757E+01,&
     -0.17772E+01,-0.17787E+01,-0.17801E+01,-0.17816E+01,-0.17831E+01,&
     -0.17846E+01,-0.17860E+01,-0.17875E+01,-0.17890E+01,-0.17904E+01,&
     -0.17919E+01,-0.17934E+01,-0.17948E+01,-0.17963E+01,-0.17978E+01,&
     -0.17992E+01,-0.18007E+01,-0.18022E+01,-0.18036E+01,-0.18051E+01,&
     -0.18065E+01,-0.18080E+01,-0.18095E+01,-0.18109E+01,-0.18124E+01,&
     -0.18138E+01,-0.18153E+01,-0.18167E+01,-0.18182E+01,-0.18196E+01,&
     -0.18211E+01,-0.18225E+01,-0.18240E+01,-0.18254E+01,-0.18269E+01,&
     -0.18283E+01,-0.18298E+01,-0.18312E+01,-0.18327E+01,-0.18341E+01,&
     -0.18356E+01,-0.18370E+01,-0.18384E+01,-0.18399E+01,-0.18413E+01,&
     -0.18427E+01,-0.18442E+01,-0.18456E+01,-0.18471E+01,-0.18485E+01,&
     -0.18499E+01,-0.18514E+01,-0.18528E+01,-0.18542E+01,-0.18556E+01,&
     -0.18571E+01,-0.18585E+01,-0.18599E+01,-0.18614E+01,-0.18628E+01,&
     -0.18642E+01,-0.18656E+01,-0.18671E+01,-0.18685E+01,-0.18699E+01,&
     -0.18713E+01,-0.18727E+01,-0.18742E+01,-0.18756E+01,-0.18770E+01,&
     -0.18784E+01,-0.18798E+01,-0.18812E+01,-0.18827E+01,-0.18841E+01,&
     -0.18855E+01,-0.18869E+01,-0.18883E+01,-0.18897E+01,-0.18911E+01,&
     -0.18925E+01,-0.18940E+01,-0.18954E+01,-0.18968E+01,-0.19020E+01/
                             
     DATA (BNC04M (IA),IA=601,700)/                                     &
     -0.19136E+01,-0.19275E+01,-0.19414E+01,-0.19552E+01,-0.19689E+01,&
     -0.19826E+01,-0.19962E+01,-0.20097E+01,-0.20232E+01,-0.20366E+01,&
     -0.20500E+01,-0.20633E+01,-0.20766E+01,-0.20897E+01,-0.21029E+01,&
     -0.21160E+01,-0.21290E+01,-0.21420E+01,-0.21550E+01,-0.21679E+01,&
     -0.21807E+01,-0.21935E+01,-0.22063E+01,-0.22190E+01,-0.22317E+01,&
     -0.22443E+01,-0.22569E+01,-0.22695E+01,-0.22820E+01,-0.22945E+01,&
     -0.23069E+01,-0.23193E+01,-0.23317E+01,-0.23440E+01,-0.23563E+01,&
     -0.23686E+01,-0.23808E+01,-0.23930E+01,-0.24052E+01,-0.24173E+01,&
     -0.24294E+01,-0.24415E+01,-0.24535E+01,-0.24655E+01,-0.24775E+01,&
     -0.24895E+01,-0.25014E+01,-0.25133E+01,-0.25252E+01,-0.25370E+01,&
     -0.25488E+01,-0.25606E+01,-0.25724E+01,-0.25841E+01,-0.25959E+01,&
     -0.26076E+01,-0.26192E+01,-0.26309E+01,-0.26425E+01,-0.26541E+01,&
     -0.26657E+01,-0.26772E+01,-0.26887E+01,-0.27002E+01,-0.27117E+01,&
     -0.27232E+01,-0.27346E+01,-0.27461E+01,-0.27575E+01,-0.27688E+01,&
     -0.27802E+01,-0.27915E+01,-0.28029E+01,-0.28142E+01,-0.28255E+01,&
     -0.28367E+01,-0.28480E+01,-0.28592E+01,-0.28704E+01,-0.28816E+01,&
     -0.28928E+01,-0.29039E+01,-0.29151E+01,-0.29262E+01,-0.29373E+01,&
     -0.29484E+01,-0.29595E+01,-0.29705E+01,-0.29816E+01,-0.29926E+01,&
     -0.30036E+01,-0.30146E+01,-0.30256E+01,-0.30366E+01,-0.30475E+01,&
     -0.30585E+01,-0.30694E+01,-0.30803E+01,-0.30912E+01,-0.31021E+01/
                             
     DATA (BNC04M(IA),IA=701,741)/                                      &
     -0.31129E+01,-0.31238E+01,-0.31346E+01,-0.31454E+01,-0.31562E+01,&
     -0.31670E+01,-0.31778E+01,-0.31886E+01,-0.31993E+01,-0.32101E+01,&
     -0.32208E+01,-0.32315E+01,-0.32423E+01,-0.32529E+01,-0.32636E+01,&
     -0.32743E+01,-0.32850E+01,-0.32956E+01,-0.33062E+01,-0.33169E+01,&
     -0.33275E+01,-0.33381E+01,-0.33487E+01,-0.33592E+01,-0.33698E+01,&
     -0.33804E+01,-0.33909E+01,-0.34015E+01,-0.34120E+01,-0.34225E+01,&
     -0.34330E+01,-0.34435E+01,-0.34540E+01,-0.34644E+01,-0.34749E+01,&
     -0.34854E+01,-0.34958E+01,-0.35062E+01,-0.35166E+01,-0.35271E+01,&
     -0.35375E+01                  /                      
!                            
!  ** NH4NO3                 
!                            
     DATA (BNC05M (IA),IA=  1,100)/                                     &
     -0.56573E-01,-0.10548E+00,-0.14176E+00,-0.16761E+00,-0.18833E+00,&
     -0.20590E+00,-0.22130E+00,-0.23513E+00,-0.24773E+00,-0.25937E+00,&
     -0.27021E+00,-0.28039E+00,-0.29000E+00,-0.29914E+00,-0.30784E+00,&
     -0.31618E+00,-0.32419E+00,-0.33189E+00,-0.33933E+00,-0.34653E+00,&
     -0.35350E+00,-0.36027E+00,-0.36685E+00,-0.37326E+00,-0.37950E+00,&
     -0.38559E+00,-0.39153E+00,-0.39735E+00,-0.40303E+00,-0.40860E+00,&
     -0.41405E+00,-0.41939E+00,-0.42463E+00,-0.42977E+00,-0.43481E+00,&
     -0.43977E+00,-0.44464E+00,-0.44943E+00,-0.45413E+00,-0.45876E+00,&
     -0.46332E+00,-0.46780E+00,-0.47221E+00,-0.47656E+00,-0.48084E+00,&
     -0.48506E+00,-0.48922E+00,-0.49332E+00,-0.49737E+00,-0.50136E+00,&
     -0.50529E+00,-0.50918E+00,-0.51301E+00,-0.51680E+00,-0.52054E+00,&
     -0.52424E+00,-0.52790E+00,-0.53151E+00,-0.53508E+00,-0.53861E+00,&
     -0.54211E+00,-0.54557E+00,-0.54899E+00,-0.55239E+00,-0.55575E+00,&
     -0.55908E+00,-0.56238E+00,-0.56565E+00,-0.56890E+00,-0.57212E+00,&
     -0.57531E+00,-0.57848E+00,-0.58163E+00,-0.58476E+00,-0.58787E+00,&
     -0.59096E+00,-0.59403E+00,-0.59708E+00,-0.60011E+00,-0.60313E+00,&
     -0.60614E+00,-0.60912E+00,-0.61210E+00,-0.61506E+00,-0.61801E+00,&
     -0.62095E+00,-0.62387E+00,-0.62678E+00,-0.62969E+00,-0.63258E+00,&
     -0.63546E+00,-0.63833E+00,-0.64120E+00,-0.64405E+00,-0.64689E+00,&
     -0.64973E+00,-0.65255E+00,-0.65537E+00,-0.65818E+00,-0.66098E+00/
                             
     DATA (BNC05M (IA),IA=101,200)/                                     &
     -0.66377E+00,-0.66655E+00,-0.66933E+00,-0.67209E+00,-0.67485E+00,&
     -0.67760E+00,-0.68034E+00,-0.68307E+00,-0.68579E+00,-0.68850E+00,&
     -0.69121E+00,-0.69390E+00,-0.69659E+00,-0.69927E+00,-0.70194E+00,&
     -0.70459E+00,-0.70724E+00,-0.70988E+00,-0.71251E+00,-0.71514E+00,&
     -0.71759E+00,-0.72021E+00,-0.72282E+00,-0.72542E+00,-0.72800E+00,&
     -0.73058E+00,-0.73314E+00,-0.73570E+00,-0.73824E+00,-0.74077E+00,&
     -0.74329E+00,-0.74580E+00,-0.74830E+00,-0.75079E+00,-0.75327E+00,&
     -0.75574E+00,-0.75821E+00,-0.76066E+00,-0.76310E+00,-0.76553E+00,&
     -0.76795E+00,-0.77036E+00,-0.77277E+00,-0.77516E+00,-0.77755E+00,&
     -0.77992E+00,-0.78229E+00,-0.78465E+00,-0.78700E+00,-0.78934E+00,&
     -0.79167E+00,-0.79400E+00,-0.79631E+00,-0.79862E+00,-0.80092E+00,&
     -0.80321E+00,-0.80549E+00,-0.80776E+00,-0.81003E+00,-0.81229E+00,&
     -0.81454E+00,-0.81678E+00,-0.81901E+00,-0.82124E+00,-0.82346E+00,&
     -0.82567E+00,-0.82787E+00,-0.83007E+00,-0.83226E+00,-0.83444E+00,&
     -0.83661E+00,-0.83878E+00,-0.84094E+00,-0.84309E+00,-0.84524E+00,&
     -0.84738E+00,-0.84951E+00,-0.85163E+00,-0.85375E+00,-0.85586E+00,&
     -0.85797E+00,-0.86006E+00,-0.86215E+00,-0.86424E+00,-0.86632E+00,&
     -0.86839E+00,-0.87045E+00,-0.87251E+00,-0.87456E+00,-0.87661E+00,&
     -0.87865E+00,-0.88068E+00,-0.88271E+00,-0.88473E+00,-0.88675E+00,&
     -0.88876E+00,-0.89076E+00,-0.89276E+00,-0.89475E+00,-0.89673E+00/
                             
     DATA (BNC05M (IA),IA=201,300)/                                     &
     -0.89871E+00,-0.90068E+00,-0.90265E+00,-0.90462E+00,-0.90657E+00,&
     -0.90852E+00,-0.91047E+00,-0.91241E+00,-0.91434E+00,-0.91627E+00,&
     -0.91819E+00,-0.92011E+00,-0.92202E+00,-0.92393E+00,-0.92583E+00,&
     -0.92773E+00,-0.92962E+00,-0.93151E+00,-0.93339E+00,-0.93526E+00,&
     -0.93713E+00,-0.93900E+00,-0.94086E+00,-0.94272E+00,-0.94457E+00,&
     -0.94641E+00,-0.94825E+00,-0.95009E+00,-0.95192E+00,-0.95375E+00,&
     -0.95557E+00,-0.95738E+00,-0.95920E+00,-0.96100E+00,-0.96281E+00,&
     -0.96460E+00,-0.96640E+00,-0.96818E+00,-0.96997E+00,-0.97175E+00,&
     -0.97352E+00,-0.97529E+00,-0.97706E+00,-0.97882E+00,-0.98058E+00,&
     -0.98233E+00,-0.98408E+00,-0.98582E+00,-0.98756E+00,-0.98930E+00,&
     -0.99103E+00,-0.99276E+00,-0.99448E+00,-0.99620E+00,-0.99791E+00,&
     -0.99962E+00,-0.10013E+01,-0.10030E+01,-0.10047E+01,-0.10064E+01,&
     -0.10081E+01,-0.10098E+01,-0.10115E+01,-0.10132E+01,-0.10148E+01,&
     -0.10165E+01,-0.10182E+01,-0.10198E+01,-0.10215E+01,-0.10231E+01,&
     -0.10248E+01,-0.10264E+01,-0.10281E+01,-0.10297E+01,-0.10314E+01,&
     -0.10330E+01,-0.10346E+01,-0.10363E+01,-0.10379E+01,-0.10395E+01,&
     -0.10411E+01,-0.10427E+01,-0.10443E+01,-0.10459E+01,-0.10475E+01,&
     -0.10491E+01,-0.10507E+01,-0.10523E+01,-0.10539E+01,-0.10555E+01,&
     -0.10571E+01,-0.10586E+01,-0.10602E+01,-0.10618E+01,-0.10633E+01,&
     -0.10649E+01,-0.10665E+01,-0.10680E+01,-0.10696E+01,-0.10711E+01/
                             
     DATA (BNC05M (IA),IA=301,400)/                                     &
     -0.10727E+01,-0.10742E+01,-0.10757E+01,-0.10773E+01,-0.10788E+01,&
     -0.10803E+01,-0.10819E+01,-0.10834E+01,-0.10849E+01,-0.10864E+01,&
     -0.10879E+01,-0.10895E+01,-0.10910E+01,-0.10925E+01,-0.10940E+01,&
     -0.10955E+01,-0.10970E+01,-0.10985E+01,-0.10999E+01,-0.11014E+01,&
     -0.11029E+01,-0.11044E+01,-0.11059E+01,-0.11073E+01,-0.11088E+01,&
     -0.11103E+01,-0.11118E+01,-0.11132E+01,-0.11147E+01,-0.11161E+01,&
     -0.11176E+01,-0.11190E+01,-0.11205E+01,-0.11219E+01,-0.11234E+01,&
     -0.11248E+01,-0.11263E+01,-0.11277E+01,-0.11291E+01,-0.11306E+01,&
     -0.11320E+01,-0.11334E+01,-0.11348E+01,-0.11363E+01,-0.11377E+01,&
     -0.11391E+01,-0.11405E+01,-0.11419E+01,-0.11433E+01,-0.11447E+01,&
     -0.11461E+01,-0.11475E+01,-0.11489E+01,-0.11503E+01,-0.11517E+01,&
     -0.11531E+01,-0.11545E+01,-0.11559E+01,-0.11572E+01,-0.11586E+01,&
     -0.11600E+01,-0.11614E+01,-0.11627E+01,-0.11641E+01,-0.11655E+01,&
     -0.11668E+01,-0.11682E+01,-0.11696E+01,-0.11709E+01,-0.11723E+01,&
     -0.11736E+01,-0.11750E+01,-0.11763E+01,-0.11777E+01,-0.11790E+01,&
     -0.11804E+01,-0.11817E+01,-0.11830E+01,-0.11844E+01,-0.11857E+01,&
     -0.11870E+01,-0.11884E+01,-0.11897E+01,-0.11910E+01,-0.11923E+01,&
     -0.11936E+01,-0.11950E+01,-0.11963E+01,-0.11976E+01,-0.11989E+01,&
     -0.12002E+01,-0.12015E+01,-0.12028E+01,-0.12041E+01,-0.12054E+01,&
     -0.12067E+01,-0.12080E+01,-0.12093E+01,-0.12106E+01,-0.12119E+01/
                             
     DATA (BNC05M (IA),IA=401,500)/                                     &
     -0.12132E+01,-0.12144E+01,-0.12157E+01,-0.12170E+01,-0.12183E+01,&
     -0.12196E+01,-0.12208E+01,-0.12221E+01,-0.12234E+01,-0.12246E+01,&
     -0.12259E+01,-0.12272E+01,-0.12284E+01,-0.12297E+01,-0.12310E+01,&
     -0.12322E+01,-0.12335E+01,-0.12347E+01,-0.12360E+01,-0.12372E+01,&
     -0.12385E+01,-0.12397E+01,-0.12409E+01,-0.12422E+01,-0.12434E+01,&
     -0.12447E+01,-0.12459E+01,-0.12471E+01,-0.12484E+01,-0.12496E+01,&
     -0.12508E+01,-0.12520E+01,-0.12533E+01,-0.12545E+01,-0.12557E+01,&
     -0.12569E+01,-0.12581E+01,-0.12594E+01,-0.12606E+01,-0.12618E+01,&
     -0.12630E+01,-0.12642E+01,-0.12654E+01,-0.12666E+01,-0.12678E+01,&
     -0.12690E+01,-0.12702E+01,-0.12714E+01,-0.12726E+01,-0.12738E+01,&
     -0.12750E+01,-0.12762E+01,-0.12774E+01,-0.12786E+01,-0.12797E+01,&
     -0.12809E+01,-0.12821E+01,-0.12833E+01,-0.12845E+01,-0.12856E+01,&
     -0.12868E+01,-0.12880E+01,-0.12892E+01,-0.12903E+01,-0.12915E+01,&
     -0.12927E+01,-0.12938E+01,-0.12950E+01,-0.12962E+01,-0.12973E+01,&
     -0.12985E+01,-0.12996E+01,-0.13008E+01,-0.13020E+01,-0.13031E+01,&
     -0.13043E+01,-0.13054E+01,-0.13066E+01,-0.13077E+01,-0.13088E+01,&
     -0.13100E+01,-0.13111E+01,-0.13123E+01,-0.13134E+01,-0.13146E+01,&
     -0.13157E+01,-0.13168E+01,-0.13180E+01,-0.13191E+01,-0.13202E+01,&
     -0.13213E+01,-0.13225E+01,-0.13236E+01,-0.13247E+01,-0.13258E+01,&
     -0.13270E+01,-0.13281E+01,-0.13292E+01,-0.13303E+01,-0.13314E+01/
                             
     DATA (BNC05M (IA),IA=501,600)/                                     &
     -0.13325E+01,-0.13337E+01,-0.13348E+01,-0.13359E+01,-0.13370E+01,&
     -0.13381E+01,-0.13392E+01,-0.13403E+01,-0.13414E+01,-0.13425E+01,&
     -0.13436E+01,-0.13447E+01,-0.13458E+01,-0.13469E+01,-0.13480E+01,&
     -0.13491E+01,-0.13502E+01,-0.13513E+01,-0.13524E+01,-0.13534E+01,&
     -0.13545E+01,-0.13556E+01,-0.13567E+01,-0.13578E+01,-0.13589E+01,&
     -0.13599E+01,-0.13610E+01,-0.13621E+01,-0.13632E+01,-0.13643E+01,&
     -0.13653E+01,-0.13664E+01,-0.13675E+01,-0.13685E+01,-0.13696E+01,&
     -0.13707E+01,-0.13717E+01,-0.13728E+01,-0.13739E+01,-0.13749E+01,&
     -0.13760E+01,-0.13770E+01,-0.13781E+01,-0.13792E+01,-0.13802E+01,&
     -0.13813E+01,-0.13823E+01,-0.13834E+01,-0.13844E+01,-0.13855E+01,&
     -0.13865E+01,-0.13876E+01,-0.13886E+01,-0.13897E+01,-0.13907E+01,&
     -0.13917E+01,-0.13928E+01,-0.13938E+01,-0.13949E+01,-0.13959E+01,&
     -0.13969E+01,-0.13980E+01,-0.13990E+01,-0.14000E+01,-0.14011E+01,&
     -0.14021E+01,-0.14031E+01,-0.14042E+01,-0.14052E+01,-0.14062E+01,&
     -0.14072E+01,-0.14083E+01,-0.14093E+01,-0.14103E+01,-0.14113E+01,&
     -0.14123E+01,-0.14134E+01,-0.14144E+01,-0.14154E+01,-0.14164E+01,&
     -0.14174E+01,-0.14184E+01,-0.14194E+01,-0.14205E+01,-0.14215E+01,&
     -0.14225E+01,-0.14235E+01,-0.14245E+01,-0.14255E+01,-0.14265E+01,&
     -0.14275E+01,-0.14285E+01,-0.14295E+01,-0.14305E+01,-0.14315E+01,&
     -0.14325E+01,-0.14335E+01,-0.14345E+01,-0.14355E+01,-0.14392E+01/
                             
     DATA (BNC05M (IA),IA=601,700)/                                     &
     -0.14473E+01,-0.14571E+01,-0.14668E+01,-0.14763E+01,-0.14858E+01,&
     -0.14952E+01,-0.15045E+01,-0.15137E+01,-0.15229E+01,-0.15319E+01,&
     -0.15409E+01,-0.15498E+01,-0.15586E+01,-0.15674E+01,-0.15761E+01,&
     -0.15847E+01,-0.15933E+01,-0.16017E+01,-0.16102E+01,-0.16185E+01,&
     -0.16268E+01,-0.16351E+01,-0.16433E+01,-0.16514E+01,-0.16595E+01,&
     -0.16675E+01,-0.16754E+01,-0.16834E+01,-0.16912E+01,-0.16990E+01,&
     -0.17068E+01,-0.17145E+01,-0.17222E+01,-0.17298E+01,-0.17374E+01,&
     -0.17450E+01,-0.17525E+01,-0.17599E+01,-0.17674E+01,-0.17747E+01,&
     -0.17821E+01,-0.17894E+01,-0.17967E+01,-0.18039E+01,-0.18111E+01,&
     -0.18182E+01,-0.18254E+01,-0.18325E+01,-0.18395E+01,-0.18466E+01,&
     -0.18535E+01,-0.18605E+01,-0.18674E+01,-0.18743E+01,-0.18812E+01,&
     -0.18881E+01,-0.18949E+01,-0.19017E+01,-0.19084E+01,-0.19152E+01,&
     -0.19219E+01,-0.19285E+01,-0.19352E+01,-0.19418E+01,-0.19484E+01,&
     -0.19550E+01,-0.19616E+01,-0.19681E+01,-0.19746E+01,-0.19811E+01,&
     -0.19876E+01,-0.19940E+01,-0.20004E+01,-0.20068E+01,-0.20132E+01,&
     -0.20196E+01,-0.20259E+01,-0.20322E+01,-0.20385E+01,-0.20448E+01,&
     -0.20510E+01,-0.20573E+01,-0.20635E+01,-0.20697E+01,-0.20759E+01,&
     -0.20821E+01,-0.20882E+01,-0.20943E+01,-0.21005E+01,-0.21066E+01,&
     -0.21126E+01,-0.21187E+01,-0.21247E+01,-0.21308E+01,-0.21368E+01,&
     -0.21428E+01,-0.21488E+01,-0.21548E+01,-0.21607E+01,-0.21667E+01/
                             
     DATA (BNC05M(IA),IA=701,741)/                                      &
     -0.21726E+01,-0.21785E+01,-0.21844E+01,-0.21903E+01,-0.21962E+01,&
     -0.22020E+01,-0.22079E+01,-0.22137E+01,-0.22195E+01,-0.22253E+01,&
     -0.22311E+01,-0.22369E+01,-0.22427E+01,-0.22484E+01,-0.22542E+01,&
     -0.22599E+01,-0.22656E+01,-0.22714E+01,-0.22771E+01,-0.22827E+01,&
     -0.22884E+01,-0.22941E+01,-0.22997E+01,-0.23054E+01,-0.23110E+01,&
     -0.23167E+01,-0.23223E+01,-0.23279E+01,-0.23335E+01,-0.23390E+01,&
     -0.23446E+01,-0.23502E+01,-0.23557E+01,-0.23613E+01,-0.23668E+01,&
     -0.23723E+01,-0.23779E+01,-0.23834E+01,-0.23889E+01,-0.23944E+01,&
     -0.23998E+01                  /                      
!                            
!  ** NH4Cl                  
!                            
     DATA (BNC06M (IA),IA=  1,100)/                                     &
     -0.54668E-01,-0.98406E-01,-0.12832E+00,-0.14814E+00,-0.16306E+00,&
     -0.17499E+00,-0.18490E+00,-0.19335E+00,-0.20067E+00,-0.20712E+00,&
     -0.21285E+00,-0.21799E+00,-0.22263E+00,-0.22685E+00,-0.23071E+00,&
     -0.23426E+00,-0.23752E+00,-0.24054E+00,-0.24335E+00,-0.24596E+00,&
     -0.24839E+00,-0.25066E+00,-0.25280E+00,-0.25480E+00,-0.25668E+00,&
     -0.25846E+00,-0.26014E+00,-0.26172E+00,-0.26322E+00,-0.26464E+00,&
     -0.26599E+00,-0.26728E+00,-0.26850E+00,-0.26967E+00,-0.27078E+00,&
     -0.27184E+00,-0.27286E+00,-0.27383E+00,-0.27477E+00,-0.27566E+00,&
     -0.27653E+00,-0.27736E+00,-0.27815E+00,-0.27892E+00,-0.27966E+00,&
     -0.28038E+00,-0.28107E+00,-0.28174E+00,-0.28239E+00,-0.28302E+00,&
     -0.28363E+00,-0.28422E+00,-0.28479E+00,-0.28535E+00,-0.28588E+00,&
     -0.28641E+00,-0.28692E+00,-0.28741E+00,-0.28789E+00,-0.28836E+00,&
     -0.28882E+00,-0.28926E+00,-0.28969E+00,-0.29010E+00,-0.29051E+00,&
     -0.29090E+00,-0.29128E+00,-0.29165E+00,-0.29201E+00,-0.29235E+00,&
     -0.29269E+00,-0.29301E+00,-0.29332E+00,-0.29362E+00,-0.29390E+00,&
     -0.29418E+00,-0.29444E+00,-0.29470E+00,-0.29494E+00,-0.29517E+00,&
     -0.29538E+00,-0.29559E+00,-0.29578E+00,-0.29597E+00,-0.29614E+00,&
     -0.29630E+00,-0.29645E+00,-0.29659E+00,-0.29671E+00,-0.29683E+00,&
     -0.29694E+00,-0.29703E+00,-0.29711E+00,-0.29719E+00,-0.29725E+00,&
     -0.29731E+00,-0.29735E+00,-0.29739E+00,-0.29741E+00,-0.29743E+00/
                             
     DATA (BNC06M (IA),IA=101,200)/                                     &
     -0.29744E+00,-0.29744E+00,-0.29743E+00,-0.29741E+00,-0.29739E+00,&
     -0.29736E+00,-0.29732E+00,-0.29727E+00,-0.29722E+00,-0.29716E+00,&
     -0.29710E+00,-0.29703E+00,-0.29695E+00,-0.29687E+00,-0.29678E+00,&
     -0.29669E+00,-0.29660E+00,-0.29650E+00,-0.29639E+00,-0.29628E+00,&
     -0.29628E+00,-0.29615E+00,-0.29602E+00,-0.29589E+00,-0.29576E+00,&
     -0.29562E+00,-0.29548E+00,-0.29534E+00,-0.29520E+00,-0.29506E+00,&
     -0.29491E+00,-0.29477E+00,-0.29462E+00,-0.29447E+00,-0.29432E+00,&
     -0.29417E+00,-0.29402E+00,-0.29386E+00,-0.29371E+00,-0.29355E+00,&
     -0.29339E+00,-0.29323E+00,-0.29308E+00,-0.29291E+00,-0.29275E+00,&
     -0.29259E+00,-0.29243E+00,-0.29226E+00,-0.29210E+00,-0.29193E+00,&
     -0.29177E+00,-0.29160E+00,-0.29143E+00,-0.29127E+00,-0.29110E+00,&
     -0.29093E+00,-0.29076E+00,-0.29059E+00,-0.29042E+00,-0.29025E+00,&
     -0.29008E+00,-0.28990E+00,-0.28973E+00,-0.28956E+00,-0.28939E+00,&
     -0.28921E+00,-0.28904E+00,-0.28887E+00,-0.28869E+00,-0.28852E+00,&
     -0.28835E+00,-0.28817E+00,-0.28800E+00,-0.28782E+00,-0.28765E+00,&
     -0.28747E+00,-0.28730E+00,-0.28712E+00,-0.28695E+00,-0.28677E+00,&
     -0.28660E+00,-0.28642E+00,-0.28625E+00,-0.28607E+00,-0.28590E+00,&
     -0.28572E+00,-0.28555E+00,-0.28537E+00,-0.28520E+00,-0.28502E+00,&
     -0.28485E+00,-0.28468E+00,-0.28450E+00,-0.28433E+00,-0.28415E+00,&
     -0.28398E+00,-0.28381E+00,-0.28363E+00,-0.28346E+00,-0.28329E+00/
                             
     DATA (BNC06M (IA),IA=201,300)/                                     &
     -0.28312E+00,-0.28295E+00,-0.28277E+00,-0.28260E+00,-0.28243E+00,&
     -0.28226E+00,-0.28209E+00,-0.28192E+00,-0.28175E+00,-0.28158E+00,&
     -0.28141E+00,-0.28124E+00,-0.28107E+00,-0.28090E+00,-0.28074E+00,&
     -0.28057E+00,-0.28040E+00,-0.28023E+00,-0.28007E+00,-0.27990E+00,&
     -0.27974E+00,-0.27957E+00,-0.27941E+00,-0.27924E+00,-0.27908E+00,&
     -0.27892E+00,-0.27875E+00,-0.27859E+00,-0.27843E+00,-0.27827E+00,&
     -0.27810E+00,-0.27794E+00,-0.27778E+00,-0.27762E+00,-0.27746E+00,&
     -0.27731E+00,-0.27715E+00,-0.27699E+00,-0.27683E+00,-0.27667E+00,&
     -0.27652E+00,-0.27636E+00,-0.27621E+00,-0.27605E+00,-0.27590E+00,&
     -0.27574E+00,-0.27559E+00,-0.27544E+00,-0.27529E+00,-0.27513E+00,&
     -0.27498E+00,-0.27483E+00,-0.27468E+00,-0.27453E+00,-0.27438E+00,&
     -0.27424E+00,-0.27409E+00,-0.27394E+00,-0.27379E+00,-0.27365E+00,&
     -0.27350E+00,-0.27336E+00,-0.27321E+00,-0.27307E+00,-0.27292E+00,&
     -0.27278E+00,-0.27264E+00,-0.27250E+00,-0.27236E+00,-0.27222E+00,&
     -0.27208E+00,-0.27194E+00,-0.27180E+00,-0.27166E+00,-0.27152E+00,&
     -0.27139E+00,-0.27125E+00,-0.27111E+00,-0.27098E+00,-0.27084E+00,&
     -0.27071E+00,-0.27058E+00,-0.27044E+00,-0.27031E+00,-0.27018E+00,&
     -0.27005E+00,-0.26992E+00,-0.26979E+00,-0.26966E+00,-0.26953E+00,&
     -0.26940E+00,-0.26927E+00,-0.26915E+00,-0.26902E+00,-0.26890E+00,&
     -0.26877E+00,-0.26865E+00,-0.26852E+00,-0.26840E+00,-0.26828E+00/
                             
     DATA (BNC06M (IA),IA=301,400)/                                     &
     -0.26815E+00,-0.26803E+00,-0.26791E+00,-0.26779E+00,-0.26767E+00,&
     -0.26755E+00,-0.26744E+00,-0.26732E+00,-0.26720E+00,-0.26708E+00,&
     -0.26697E+00,-0.26685E+00,-0.26674E+00,-0.26662E+00,-0.26651E+00,&
     -0.26640E+00,-0.26629E+00,-0.26617E+00,-0.26606E+00,-0.26595E+00,&
     -0.26584E+00,-0.26573E+00,-0.26563E+00,-0.26552E+00,-0.26541E+00,&
     -0.26530E+00,-0.26520E+00,-0.26509E+00,-0.26499E+00,-0.26488E+00,&
     -0.26478E+00,-0.26468E+00,-0.26457E+00,-0.26447E+00,-0.26437E+00,&
     -0.26427E+00,-0.26417E+00,-0.26407E+00,-0.26397E+00,-0.26387E+00,&
     -0.26378E+00,-0.26368E+00,-0.26358E+00,-0.26349E+00,-0.26339E+00,&
     -0.26330E+00,-0.26320E+00,-0.26311E+00,-0.26302E+00,-0.26293E+00,&
     -0.26284E+00,-0.26274E+00,-0.26265E+00,-0.26256E+00,-0.26248E+00,&
     -0.26239E+00,-0.26230E+00,-0.26221E+00,-0.26213E+00,-0.26204E+00,&
     -0.26195E+00,-0.26187E+00,-0.26178E+00,-0.26170E+00,-0.26162E+00,&
     -0.26154E+00,-0.26145E+00,-0.26137E+00,-0.26129E+00,-0.26121E+00,&
     -0.26113E+00,-0.26105E+00,-0.26098E+00,-0.26090E+00,-0.26082E+00,&
     -0.26074E+00,-0.26067E+00,-0.26059E+00,-0.26052E+00,-0.26044E+00,&
     -0.26037E+00,-0.26030E+00,-0.26023E+00,-0.26015E+00,-0.26008E+00,&
     -0.26001E+00,-0.25994E+00,-0.25987E+00,-0.25980E+00,-0.25973E+00,&
     -0.25967E+00,-0.25960E+00,-0.25953E+00,-0.25947E+00,-0.25940E+00,&
     -0.25934E+00,-0.25927E+00,-0.25921E+00,-0.25915E+00,-0.25908E+00/
                             
     DATA (BNC06M (IA),IA=401,500)/                                     &
     -0.25902E+00,-0.25896E+00,-0.25890E+00,-0.25884E+00,-0.25878E+00,&
     -0.25872E+00,-0.25866E+00,-0.25860E+00,-0.25855E+00,-0.25849E+00,&
     -0.25843E+00,-0.25838E+00,-0.25832E+00,-0.25827E+00,-0.25821E+00,&
     -0.25816E+00,-0.25811E+00,-0.25805E+00,-0.25800E+00,-0.25795E+00,&
     -0.25790E+00,-0.25785E+00,-0.25780E+00,-0.25775E+00,-0.25770E+00,&
     -0.25765E+00,-0.25761E+00,-0.25756E+00,-0.25751E+00,-0.25747E+00,&
     -0.25742E+00,-0.25738E+00,-0.25733E+00,-0.25729E+00,-0.25725E+00,&
     -0.25721E+00,-0.25716E+00,-0.25712E+00,-0.25708E+00,-0.25704E+00,&
     -0.25700E+00,-0.25696E+00,-0.25692E+00,-0.25688E+00,-0.25685E+00,&
     -0.25681E+00,-0.25677E+00,-0.25674E+00,-0.25670E+00,-0.25667E+00,&
     -0.25663E+00,-0.25660E+00,-0.25656E+00,-0.25653E+00,-0.25650E+00,&
     -0.25647E+00,-0.25644E+00,-0.25640E+00,-0.25637E+00,-0.25634E+00,&
     -0.25632E+00,-0.25629E+00,-0.25626E+00,-0.25623E+00,-0.25620E+00,&
     -0.25618E+00,-0.25615E+00,-0.25612E+00,-0.25610E+00,-0.25608E+00,&
     -0.25605E+00,-0.25603E+00,-0.25600E+00,-0.25598E+00,-0.25596E+00,&
     -0.25594E+00,-0.25592E+00,-0.25590E+00,-0.25588E+00,-0.25586E+00,&
     -0.25584E+00,-0.25582E+00,-0.25580E+00,-0.25578E+00,-0.25577E+00,&
     -0.25575E+00,-0.25573E+00,-0.25572E+00,-0.25570E+00,-0.25569E+00,&
     -0.25567E+00,-0.25566E+00,-0.25565E+00,-0.25563E+00,-0.25562E+00,&
     -0.25561E+00,-0.25560E+00,-0.25559E+00,-0.25558E+00,-0.25557E+00/
                             
     DATA (BNC06M (IA),IA=501,600)/                                     &
     -0.25556E+00,-0.25555E+00,-0.25554E+00,-0.25553E+00,-0.25553E+00,&
     -0.25552E+00,-0.25551E+00,-0.25551E+00,-0.25550E+00,-0.25550E+00,&
     -0.25549E+00,-0.25549E+00,-0.25549E+00,-0.25548E+00,-0.25548E+00,&
     -0.25548E+00,-0.25548E+00,-0.25548E+00,-0.25547E+00,-0.25547E+00,&
     -0.25547E+00,-0.25548E+00,-0.25548E+00,-0.25548E+00,-0.25548E+00,&
     -0.25548E+00,-0.25549E+00,-0.25549E+00,-0.25549E+00,-0.25550E+00,&
     -0.25550E+00,-0.25551E+00,-0.25551E+00,-0.25552E+00,-0.25553E+00,&
     -0.25553E+00,-0.25554E+00,-0.25555E+00,-0.25556E+00,-0.25557E+00,&
     -0.25558E+00,-0.25559E+00,-0.25560E+00,-0.25561E+00,-0.25562E+00,&
     -0.25563E+00,-0.25564E+00,-0.25565E+00,-0.25567E+00,-0.25568E+00,&
     -0.25569E+00,-0.25571E+00,-0.25572E+00,-0.25574E+00,-0.25575E+00,&
     -0.25577E+00,-0.25579E+00,-0.25580E+00,-0.25582E+00,-0.25584E+00,&
     -0.25586E+00,-0.25588E+00,-0.25589E+00,-0.25591E+00,-0.25593E+00,&
     -0.25595E+00,-0.25597E+00,-0.25600E+00,-0.25602E+00,-0.25604E+00,&
     -0.25606E+00,-0.25609E+00,-0.25611E+00,-0.25613E+00,-0.25616E+00,&
     -0.25618E+00,-0.25621E+00,-0.25623E+00,-0.25626E+00,-0.25628E+00,&
     -0.25631E+00,-0.25634E+00,-0.25637E+00,-0.25639E+00,-0.25642E+00,&
     -0.25645E+00,-0.25648E+00,-0.25651E+00,-0.25654E+00,-0.25657E+00,&
     -0.25660E+00,-0.25663E+00,-0.25666E+00,-0.25670E+00,-0.25673E+00,&
     -0.25676E+00,-0.25679E+00,-0.25683E+00,-0.25686E+00,-0.25699E+00/
                             
     DATA (BNC06M (IA),IA=601,700)/                                     &
     -0.25730E+00,-0.25771E+00,-0.25816E+00,-0.25865E+00,-0.25917E+00,&
     -0.25973E+00,-0.26033E+00,-0.26096E+00,-0.26163E+00,-0.26233E+00,&
     -0.26307E+00,-0.26383E+00,-0.26463E+00,-0.26547E+00,-0.26633E+00,&
     -0.26722E+00,-0.26815E+00,-0.26910E+00,-0.27009E+00,-0.27110E+00,&
     -0.27214E+00,-0.27320E+00,-0.27430E+00,-0.27542E+00,-0.27657E+00,&
     -0.27774E+00,-0.27894E+00,-0.28017E+00,-0.28142E+00,-0.28269E+00,&
     -0.28399E+00,-0.28531E+00,-0.28666E+00,-0.28803E+00,-0.28942E+00,&
     -0.29083E+00,-0.29226E+00,-0.29372E+00,-0.29520E+00,-0.29669E+00,&
     -0.29821E+00,-0.29975E+00,-0.30131E+00,-0.30289E+00,-0.30449E+00,&
     -0.30610E+00,-0.30774E+00,-0.30939E+00,-0.31107E+00,-0.31276E+00,&
     -0.31447E+00,-0.31619E+00,-0.31794E+00,-0.31970E+00,-0.32147E+00,&
     -0.32327E+00,-0.32508E+00,-0.32690E+00,-0.32875E+00,-0.33060E+00,&
     -0.33248E+00,-0.33437E+00,-0.33627E+00,-0.33819E+00,-0.34012E+00,&
     -0.34207E+00,-0.34403E+00,-0.34601E+00,-0.34800E+00,-0.35001E+00,&
     -0.35203E+00,-0.35406E+00,-0.35610E+00,-0.35816E+00,-0.36023E+00,&
     -0.36232E+00,-0.36441E+00,-0.36652E+00,-0.36864E+00,-0.37078E+00,&
     -0.37292E+00,-0.37508E+00,-0.37725E+00,-0.37943E+00,-0.38162E+00,&
     -0.38383E+00,-0.38604E+00,-0.38827E+00,-0.39051E+00,-0.39275E+00,&
     -0.39501E+00,-0.39728E+00,-0.39956E+00,-0.40185E+00,-0.40415E+00,&
     -0.40646E+00,-0.40879E+00,-0.41112E+00,-0.41346E+00,-0.41581E+00/
                             
     DATA (BNC06M(IA),IA=701,741)/                                      &
     -0.41817E+00,-0.42054E+00,-0.42292E+00,-0.42530E+00,-0.42770E+00,&
     -0.43011E+00,-0.43252E+00,-0.43495E+00,-0.43738E+00,-0.43982E+00,&
     -0.44227E+00,-0.44473E+00,-0.44720E+00,-0.44967E+00,-0.45216E+00,&
     -0.45465E+00,-0.45715E+00,-0.45966E+00,-0.46218E+00,-0.46470E+00,&
     -0.46723E+00,-0.46977E+00,-0.47232E+00,-0.47487E+00,-0.47744E+00,&
     -0.48001E+00,-0.48258E+00,-0.48517E+00,-0.48776E+00,-0.49036E+00,&
     -0.49296E+00,-0.49558E+00,-0.49820E+00,-0.50082E+00,-0.50346E+00,&
     -0.50610E+00,-0.50874E+00,-0.51140E+00,-0.51406E+00,-0.51672E+00,&
     -0.51940E+00                  /                      
!                            
!  ** (2H, SO4)              
!                            
     DATA (BNC07M (IA),IA=  1,100)/                                     &
     -0.11102E+00,-0.20302E+00,-0.26840E+00,-0.31329E+00,-0.34815E+00,&
     -0.37690E+00,-0.40149E+00,-0.42304E+00,-0.44227E+00,-0.45966E+00,&
     -0.47555E+00,-0.49020E+00,-0.50381E+00,-0.51652E+00,-0.52846E+00,&
     -0.53971E+00,-0.55037E+00,-0.56050E+00,-0.57015E+00,-0.57937E+00,&
     -0.58821E+00,-0.59669E+00,-0.60484E+00,-0.61271E+00,-0.62030E+00,&
     -0.62763E+00,-0.63474E+00,-0.64162E+00,-0.64831E+00,-0.65480E+00,&
     -0.66112E+00,-0.66727E+00,-0.67327E+00,-0.67912E+00,-0.68483E+00,&
     -0.69041E+00,-0.69586E+00,-0.70120E+00,-0.70642E+00,-0.71154E+00,&
     -0.71656E+00,-0.72147E+00,-0.72630E+00,-0.73104E+00,-0.73570E+00,&
     -0.74027E+00,-0.74477E+00,-0.74919E+00,-0.75354E+00,-0.75782E+00,&
     -0.76204E+00,-0.76619E+00,-0.77029E+00,-0.77432E+00,-0.77830E+00,&
     -0.78222E+00,-0.78609E+00,-0.78991E+00,-0.79369E+00,-0.79741E+00,&
     -0.80109E+00,-0.80472E+00,-0.80832E+00,-0.81187E+00,-0.81538E+00,&
     -0.81885E+00,-0.82229E+00,-0.82569E+00,-0.82905E+00,-0.83239E+00,&
     -0.83568E+00,-0.83895E+00,-0.84219E+00,-0.84539E+00,-0.84857E+00,&
     -0.85172E+00,-0.85484E+00,-0.85793E+00,-0.86100E+00,-0.86405E+00,&
     -0.86706E+00,-0.87006E+00,-0.87303E+00,-0.87598E+00,-0.87891E+00,&
     -0.88182E+00,-0.88471E+00,-0.88757E+00,-0.89042E+00,-0.89325E+00,&
     -0.89605E+00,-0.89885E+00,-0.90162E+00,-0.90437E+00,-0.90711E+00,&
     -0.90983E+00,-0.91254E+00,-0.91522E+00,-0.91790E+00,-0.92056E+00/
                             
     DATA (BNC07M (IA),IA=101,200)/                                     &
     -0.92320E+00,-0.92583E+00,-0.92844E+00,-0.93104E+00,-0.93362E+00,&
     -0.93619E+00,-0.93875E+00,-0.94129E+00,-0.94382E+00,-0.94634E+00,&
     -0.94885E+00,-0.95134E+00,-0.95382E+00,-0.95629E+00,-0.95874E+00,&
     -0.96119E+00,-0.96362E+00,-0.96604E+00,-0.96845E+00,-0.97085E+00,&
     -0.97321E+00,-0.97559E+00,-0.97796E+00,-0.98032E+00,-0.98267E+00,&
     -0.98500E+00,-0.98733E+00,-0.98965E+00,-0.99196E+00,-0.99425E+00,&
     -0.99654E+00,-0.99882E+00,-0.10011E+01,-0.10033E+01,-0.10056E+01,&
     -0.10078E+01,-0.10101E+01,-0.10123E+01,-0.10145E+01,-0.10167E+01,&
     -0.10189E+01,-0.10211E+01,-0.10233E+01,-0.10255E+01,-0.10276E+01,&
     -0.10298E+01,-0.10319E+01,-0.10341E+01,-0.10362E+01,-0.10383E+01,&
     -0.10405E+01,-0.10426E+01,-0.10447E+01,-0.10468E+01,-0.10489E+01,&
     -0.10509E+01,-0.10530E+01,-0.10551E+01,-0.10572E+01,-0.10592E+01,&
     -0.10613E+01,-0.10633E+01,-0.10653E+01,-0.10674E+01,-0.10694E+01,&
     -0.10714E+01,-0.10734E+01,-0.10754E+01,-0.10775E+01,-0.10794E+01,&
     -0.10814E+01,-0.10834E+01,-0.10854E+01,-0.10874E+01,-0.10893E+01,&
     -0.10913E+01,-0.10933E+01,-0.10952E+01,-0.10972E+01,-0.10991E+01,&
     -0.11010E+01,-0.11030E+01,-0.11049E+01,-0.11068E+01,-0.11087E+01,&
     -0.11106E+01,-0.11126E+01,-0.11145E+01,-0.11164E+01,-0.11182E+01,&
     -0.11201E+01,-0.11220E+01,-0.11239E+01,-0.11258E+01,-0.11276E+01,&
     -0.11295E+01,-0.11314E+01,-0.11332E+01,-0.11351E+01,-0.11369E+01/
                             
     DATA (BNC07M (IA),IA=201,300)/                                     &
     -0.11388E+01,-0.11406E+01,-0.11424E+01,-0.11443E+01,-0.11461E+01,&
     -0.11479E+01,-0.11497E+01,-0.11516E+01,-0.11534E+01,-0.11552E+01,&
     -0.11570E+01,-0.11588E+01,-0.11606E+01,-0.11624E+01,-0.11642E+01,&
     -0.11659E+01,-0.11677E+01,-0.11695E+01,-0.11713E+01,-0.11730E+01,&
     -0.11748E+01,-0.11766E+01,-0.11783E+01,-0.11801E+01,-0.11819E+01,&
     -0.11836E+01,-0.11853E+01,-0.11871E+01,-0.11888E+01,-0.11906E+01,&
     -0.11923E+01,-0.11940E+01,-0.11958E+01,-0.11975E+01,-0.11992E+01,&
     -0.12009E+01,-0.12026E+01,-0.12044E+01,-0.12061E+01,-0.12078E+01,&
     -0.12095E+01,-0.12112E+01,-0.12129E+01,-0.12146E+01,-0.12163E+01,&
     -0.12179E+01,-0.12196E+01,-0.12213E+01,-0.12230E+01,-0.12247E+01,&
     -0.12263E+01,-0.12280E+01,-0.12297E+01,-0.12313E+01,-0.12330E+01,&
     -0.12347E+01,-0.12363E+01,-0.12380E+01,-0.12396E+01,-0.12413E+01,&
     -0.12429E+01,-0.12446E+01,-0.12462E+01,-0.12479E+01,-0.12495E+01,&
     -0.12511E+01,-0.12528E+01,-0.12544E+01,-0.12560E+01,-0.12577E+01,&
     -0.12593E+01,-0.12609E+01,-0.12625E+01,-0.12641E+01,-0.12658E+01,&
     -0.12674E+01,-0.12690E+01,-0.12706E+01,-0.12722E+01,-0.12738E+01,&
     -0.12754E+01,-0.12770E+01,-0.12786E+01,-0.12802E+01,-0.12818E+01,&
     -0.12834E+01,-0.12849E+01,-0.12865E+01,-0.12881E+01,-0.12897E+01,&
     -0.12913E+01,-0.12929E+01,-0.12944E+01,-0.12960E+01,-0.12976E+01,&
     -0.12991E+01,-0.13007E+01,-0.13023E+01,-0.13038E+01,-0.13054E+01/
                             
     DATA (BNC07M (IA),IA=301,400)/                                     &
     -0.13070E+01,-0.13085E+01,-0.13101E+01,-0.13116E+01,-0.13132E+01,&
     -0.13147E+01,-0.13163E+01,-0.13178E+01,-0.13194E+01,-0.13209E+01,&
     -0.13224E+01,-0.13240E+01,-0.13255E+01,-0.13271E+01,-0.13286E+01,&
     -0.13301E+01,-0.13316E+01,-0.13332E+01,-0.13347E+01,-0.13362E+01,&
     -0.13378E+01,-0.13393E+01,-0.13408E+01,-0.13423E+01,-0.13438E+01,&
     -0.13453E+01,-0.13468E+01,-0.13484E+01,-0.13499E+01,-0.13514E+01,&
     -0.13529E+01,-0.13544E+01,-0.13559E+01,-0.13574E+01,-0.13589E+01,&
     -0.13604E+01,-0.13619E+01,-0.13634E+01,-0.13649E+01,-0.13664E+01,&
     -0.13679E+01,-0.13693E+01,-0.13708E+01,-0.13723E+01,-0.13738E+01,&
     -0.13753E+01,-0.13768E+01,-0.13782E+01,-0.13797E+01,-0.13812E+01,&
     -0.13827E+01,-0.13841E+01,-0.13856E+01,-0.13871E+01,-0.13886E+01,&
     -0.13900E+01,-0.13915E+01,-0.13930E+01,-0.13944E+01,-0.13959E+01,&
     -0.13973E+01,-0.13988E+01,-0.14003E+01,-0.14017E+01,-0.14032E+01,&
     -0.14046E+01,-0.14061E+01,-0.14075E+01,-0.14090E+01,-0.14104E+01,&
     -0.14119E+01,-0.14133E+01,-0.14148E+01,-0.14162E+01,-0.14176E+01,&
     -0.14191E+01,-0.14205E+01,-0.14220E+01,-0.14234E+01,-0.14248E+01,&
     -0.14263E+01,-0.14277E+01,-0.14291E+01,-0.14306E+01,-0.14320E+01,&
     -0.14334E+01,-0.14349E+01,-0.14363E+01,-0.14377E+01,-0.14391E+01,&
     -0.14406E+01,-0.14420E+01,-0.14434E+01,-0.14448E+01,-0.14462E+01,&
     -0.14476E+01,-0.14491E+01,-0.14505E+01,-0.14519E+01,-0.14533E+01/
                             
     DATA (BNC07M (IA),IA=401,500)/                                     &
     -0.14547E+01,-0.14561E+01,-0.14575E+01,-0.14589E+01,-0.14603E+01,&
     -0.14617E+01,-0.14631E+01,-0.14646E+01,-0.14660E+01,-0.14674E+01,&
     -0.14688E+01,-0.14702E+01,-0.14715E+01,-0.14729E+01,-0.14743E+01,&
     -0.14757E+01,-0.14771E+01,-0.14785E+01,-0.14799E+01,-0.14813E+01,&
     -0.14827E+01,-0.14841E+01,-0.14855E+01,-0.14868E+01,-0.14882E+01,&
     -0.14896E+01,-0.14910E+01,-0.14924E+01,-0.14938E+01,-0.14951E+01,&
     -0.14965E+01,-0.14979E+01,-0.14993E+01,-0.15007E+01,-0.15020E+01,&
     -0.15034E+01,-0.15048E+01,-0.15061E+01,-0.15075E+01,-0.15089E+01,&
     -0.15103E+01,-0.15116E+01,-0.15130E+01,-0.15144E+01,-0.15157E+01,&
     -0.15171E+01,-0.15184E+01,-0.15198E+01,-0.15212E+01,-0.15225E+01,&
     -0.15239E+01,-0.15252E+01,-0.15266E+01,-0.15280E+01,-0.15293E+01,&
     -0.15307E+01,-0.15320E+01,-0.15334E+01,-0.15347E+01,-0.15361E+01,&
     -0.15374E+01,-0.15388E+01,-0.15401E+01,-0.15415E+01,-0.15428E+01,&
     -0.15442E+01,-0.15455E+01,-0.15469E+01,-0.15482E+01,-0.15495E+01,&
     -0.15509E+01,-0.15522E+01,-0.15536E+01,-0.15549E+01,-0.15562E+01,&
     -0.15576E+01,-0.15589E+01,-0.15603E+01,-0.15616E+01,-0.15629E+01,&
     -0.15643E+01,-0.15656E+01,-0.15669E+01,-0.15683E+01,-0.15696E+01,&
     -0.15709E+01,-0.15722E+01,-0.15736E+01,-0.15749E+01,-0.15762E+01,&
     -0.15776E+01,-0.15789E+01,-0.15802E+01,-0.15815E+01,-0.15828E+01,&
     -0.15842E+01,-0.15855E+01,-0.15868E+01,-0.15881E+01,-0.15894E+01/
                             
     DATA (BNC07M (IA),IA=501,600)/                                     &
     -0.15908E+01,-0.15921E+01,-0.15934E+01,-0.15947E+01,-0.15960E+01,&
     -0.15973E+01,-0.15987E+01,-0.16000E+01,-0.16013E+01,-0.16026E+01,&
     -0.16039E+01,-0.16052E+01,-0.16065E+01,-0.16078E+01,-0.16091E+01,&
     -0.16104E+01,-0.16117E+01,-0.16131E+01,-0.16144E+01,-0.16157E+01,&
     -0.16170E+01,-0.16183E+01,-0.16196E+01,-0.16209E+01,-0.16222E+01,&
     -0.16235E+01,-0.16248E+01,-0.16261E+01,-0.16274E+01,-0.16287E+01,&
     -0.16300E+01,-0.16313E+01,-0.16325E+01,-0.16338E+01,-0.16351E+01,&
     -0.16364E+01,-0.16377E+01,-0.16390E+01,-0.16403E+01,-0.16416E+01,&
     -0.16429E+01,-0.16442E+01,-0.16455E+01,-0.16467E+01,-0.16480E+01,&
     -0.16493E+01,-0.16506E+01,-0.16519E+01,-0.16532E+01,-0.16545E+01,&
     -0.16557E+01,-0.16570E+01,-0.16583E+01,-0.16596E+01,-0.16609E+01,&
     -0.16621E+01,-0.16634E+01,-0.16647E+01,-0.16660E+01,-0.16673E+01,&
     -0.16685E+01,-0.16698E+01,-0.16711E+01,-0.16724E+01,-0.16736E+01,&
     -0.16749E+01,-0.16762E+01,-0.16775E+01,-0.16787E+01,-0.16800E+01,&
     -0.16813E+01,-0.16825E+01,-0.16838E+01,-0.16851E+01,-0.16863E+01,&
     -0.16876E+01,-0.16889E+01,-0.16902E+01,-0.16914E+01,-0.16927E+01,&
     -0.16939E+01,-0.16952E+01,-0.16965E+01,-0.16977E+01,-0.16990E+01,&
     -0.17003E+01,-0.17015E+01,-0.17028E+01,-0.17040E+01,-0.17053E+01,&
     -0.17066E+01,-0.17078E+01,-0.17091E+01,-0.17103E+01,-0.17116E+01,&
     -0.17129E+01,-0.17141E+01,-0.17154E+01,-0.17166E+01,-0.17213E+01/
                             
     DATA (BNC07M (IA),IA=601,700)/                                     &
     -0.17316E+01,-0.17441E+01,-0.17565E+01,-0.17688E+01,-0.17811E+01,&
     -0.17934E+01,-0.18056E+01,-0.18178E+01,-0.18299E+01,-0.18420E+01,&
     -0.18540E+01,-0.18660E+01,-0.18780E+01,-0.18899E+01,-0.19018E+01,&
     -0.19136E+01,-0.19254E+01,-0.19372E+01,-0.19489E+01,-0.19607E+01,&
     -0.19723E+01,-0.19840E+01,-0.19956E+01,-0.20072E+01,-0.20187E+01,&
     -0.20302E+01,-0.20417E+01,-0.20532E+01,-0.20646E+01,-0.20760E+01,&
     -0.20874E+01,-0.20988E+01,-0.21101E+01,-0.21214E+01,-0.21327E+01,&
     -0.21440E+01,-0.21552E+01,-0.21664E+01,-0.21776E+01,-0.21888E+01,&
     -0.21999E+01,-0.22110E+01,-0.22221E+01,-0.22332E+01,-0.22443E+01,&
     -0.22553E+01,-0.22663E+01,-0.22773E+01,-0.22883E+01,-0.22992E+01,&
     -0.23102E+01,-0.23211E+01,-0.23320E+01,-0.23429E+01,-0.23537E+01,&
     -0.23646E+01,-0.23754E+01,-0.23862E+01,-0.23970E+01,-0.24078E+01,&
     -0.24186E+01,-0.24293E+01,-0.24401E+01,-0.24508E+01,-0.24615E+01,&
     -0.24722E+01,-0.24828E+01,-0.24935E+01,-0.25041E+01,-0.25148E+01,&
     -0.25254E+01,-0.25360E+01,-0.25466E+01,-0.25571E+01,-0.25677E+01,&
     -0.25782E+01,-0.25888E+01,-0.25993E+01,-0.26098E+01,-0.26203E+01,&
     -0.26308E+01,-0.26412E+01,-0.26517E+01,-0.26621E+01,-0.26726E+01,&
     -0.26830E+01,-0.26934E+01,-0.27038E+01,-0.27142E+01,-0.27245E+01,&
     -0.27349E+01,-0.27453E+01,-0.27556E+01,-0.27659E+01,-0.27762E+01,&
     -0.27866E+01,-0.27968E+01,-0.28071E+01,-0.28174E+01,-0.28277E+01/
                             
     DATA (BNC07M(IA),IA=701,741)/                                      &
     -0.28379E+01,-0.28482E+01,-0.28584E+01,-0.28686E+01,-0.28788E+01,&
     -0.28891E+01,-0.28992E+01,-0.29094E+01,-0.29196E+01,-0.29298E+01,&
     -0.29399E+01,-0.29501E+01,-0.29602E+01,-0.29704E+01,-0.29805E+01,&
     -0.29906E+01,-0.30007E+01,-0.30108E+01,-0.30209E+01,-0.30310E+01,&
     -0.30410E+01,-0.30511E+01,-0.30612E+01,-0.30712E+01,-0.30812E+01,&
     -0.30913E+01,-0.31013E+01,-0.31113E+01,-0.31213E+01,-0.31313E+01,&
     -0.31413E+01,-0.31513E+01,-0.31613E+01,-0.31712E+01,-0.31812E+01,&
     -0.31911E+01,-0.32011E+01,-0.32110E+01,-0.32210E+01,-0.32309E+01,&
     -0.32408E+01                  /                      
!                            
!  ** (H, HSO4)              
!                            
     DATA (BNC08M (IA),IA=  1,100)/                                     &
     -0.51043E-01,-0.86042E-01,-0.10613E+00,-0.11710E+00,-0.12372E+00,&
     -0.12771E+00,-0.12990E+00,-0.13078E+00,-0.13062E+00,-0.12964E+00,&
     -0.12796E+00,-0.12569E+00,-0.12291E+00,-0.11967E+00,-0.11602E+00,&
     -0.11201E+00,-0.10765E+00,-0.10298E+00,-0.98013E-01,-0.92777E-01,&
     -0.87285E-01,-0.81552E-01,-0.75590E-01,-0.69411E-01,-0.63026E-01,&
     -0.56444E-01,-0.49675E-01,-0.42726E-01,-0.35606E-01,-0.28321E-01,&
     -0.20880E-01,-0.13287E-01,-0.55488E-02, 0.23277E-02, 0.10337E-01,&
      0.18475E-01, 0.26735E-01, 0.35113E-01, 0.43603E-01, 0.52201E-01,&
      0.60903E-01, 0.69703E-01, 0.78599E-01, 0.87586E-01, 0.96660E-01,&
      0.10582E+00, 0.11506E+00, 0.12437E+00, 0.13376E+00, 0.14322E+00,&
      0.15274E+00, 0.16233E+00, 0.17199E+00, 0.18170E+00, 0.19147E+00,&
      0.20130E+00, 0.21119E+00, 0.22112E+00, 0.23111E+00, 0.24115E+00,&
      0.25124E+00, 0.26138E+00, 0.27157E+00, 0.28181E+00, 0.29209E+00,&
      0.30242E+00, 0.31280E+00, 0.32323E+00, 0.33370E+00, 0.34422E+00,&
      0.35480E+00, 0.36542E+00, 0.37609E+00, 0.38682E+00, 0.39759E+00,&
      0.40842E+00, 0.41931E+00, 0.43025E+00, 0.44124E+00, 0.45229E+00,&
      0.46340E+00, 0.47456E+00, 0.48578E+00, 0.49706E+00, 0.50840E+00,&
      0.51980E+00, 0.53126E+00, 0.54278E+00, 0.55435E+00, 0.56599E+00,&
      0.57768E+00, 0.58943E+00, 0.60124E+00, 0.61310E+00, 0.62502E+00,&
      0.63700E+00, 0.64902E+00, 0.66110E+00, 0.67322E+00, 0.68539E+00/
                             
     DATA (BNC08M (IA),IA=101,200)/                                     &
      0.69761E+00, 0.70987E+00, 0.72217E+00, 0.73451E+00, 0.74689E+00,&
      0.75930E+00, 0.77174E+00, 0.78422E+00, 0.79672E+00, 0.80925E+00,&
      0.82180E+00, 0.83437E+00, 0.84696E+00, 0.85957E+00, 0.87219E+00,&
      0.88482E+00, 0.89747E+00, 0.91012E+00, 0.92278E+00, 0.93544E+00,&
      0.94702E+00, 0.95981E+00, 0.97259E+00, 0.98535E+00, 0.99809E+00,&
      0.10108E+01, 0.10235E+01, 0.10362E+01, 0.10489E+01, 0.10616E+01,&
      0.10742E+01, 0.10869E+01, 0.10995E+01, 0.11121E+01, 0.11246E+01,&
      0.11372E+01, 0.11497E+01, 0.11622E+01, 0.11747E+01, 0.11872E+01,&
      0.11997E+01, 0.12121E+01, 0.12245E+01, 0.12369E+01, 0.12493E+01,&
      0.12616E+01, 0.12739E+01, 0.12862E+01, 0.12985E+01, 0.13108E+01,&
      0.13230E+01, 0.13352E+01, 0.13474E+01, 0.13595E+01, 0.13717E+01,&
      0.13838E+01, 0.13959E+01, 0.14079E+01, 0.14200E+01, 0.14320E+01,&
      0.14440E+01, 0.14559E+01, 0.14679E+01, 0.14798E+01, 0.14917E+01,&
      0.15036E+01, 0.15154E+01, 0.15272E+01, 0.15390E+01, 0.15508E+01,&
      0.15625E+01, 0.15742E+01, 0.15859E+01, 0.15976E+01, 0.16092E+01,&
      0.16209E+01, 0.16325E+01, 0.16440E+01, 0.16556E+01, 0.16671E+01,&
      0.16786E+01, 0.16900E+01, 0.17015E+01, 0.17129E+01, 0.17243E+01,&
      0.17356E+01, 0.17470E+01, 0.17583E+01, 0.17696E+01, 0.17809E+01,&
      0.17921E+01, 0.18033E+01, 0.18145E+01, 0.18257E+01, 0.18368E+01,&
      0.18479E+01, 0.18590E+01, 0.18701E+01, 0.18811E+01, 0.18921E+01/
                             
     DATA (BNC08M (IA),IA=201,300)/                                     &
      0.19031E+01, 0.19141E+01, 0.19250E+01, 0.19360E+01, 0.19468E+01,&
      0.19577E+01, 0.19686E+01, 0.19794E+01, 0.19902E+01, 0.20009E+01,&
      0.20117E+01, 0.20224E+01, 0.20331E+01, 0.20438E+01, 0.20544E+01,&
      0.20651E+01, 0.20757E+01, 0.20863E+01, 0.20968E+01, 0.21073E+01,&
      0.21179E+01, 0.21283E+01, 0.21388E+01, 0.21492E+01, 0.21597E+01,&
      0.21700E+01, 0.21804E+01, 0.21908E+01, 0.22011E+01, 0.22114E+01,&
      0.22217E+01, 0.22319E+01, 0.22422E+01, 0.22524E+01, 0.22625E+01,&
      0.22727E+01, 0.22829E+01, 0.22930E+01, 0.23031E+01, 0.23131E+01,&
      0.23232E+01, 0.23332E+01, 0.23432E+01, 0.23532E+01, 0.23632E+01,&
      0.23731E+01, 0.23830E+01, 0.23929E+01, 0.24028E+01, 0.24127E+01,&
      0.24225E+01, 0.24323E+01, 0.24421E+01, 0.24519E+01, 0.24616E+01,&
      0.24714E+01, 0.24811E+01, 0.24908E+01, 0.25004E+01, 0.25101E+01,&
      0.25197E+01, 0.25293E+01, 0.25389E+01, 0.25484E+01, 0.25580E+01,&
      0.25675E+01, 0.25770E+01, 0.25865E+01, 0.25960E+01, 0.26054E+01,&
      0.26148E+01, 0.26242E+01, 0.26336E+01, 0.26430E+01, 0.26523E+01,&
      0.26616E+01, 0.26709E+01, 0.26802E+01, 0.26895E+01, 0.26987E+01,&
      0.27079E+01, 0.27171E+01, 0.27263E+01, 0.27355E+01, 0.27446E+01,&
      0.27538E+01, 0.27629E+01, 0.27720E+01, 0.27810E+01, 0.27901E+01,&
      0.27991E+01, 0.28082E+01, 0.28171E+01, 0.28261E+01, 0.28351E+01,&
      0.28440E+01, 0.28530E+01, 0.28619E+01, 0.28707E+01, 0.28796E+01/
                             
     DATA (BNC08M (IA),IA=301,400)/                                     &
      0.28885E+01, 0.28973E+01, 0.29061E+01, 0.29149E+01, 0.29237E+01,&
      0.29325E+01, 0.29412E+01, 0.29499E+01, 0.29586E+01, 0.29673E+01,&
      0.29760E+01, 0.29847E+01, 0.29933E+01, 0.30019E+01, 0.30105E+01,&
      0.30191E+01, 0.30277E+01, 0.30363E+01, 0.30448E+01, 0.30533E+01,&
      0.30618E+01, 0.30703E+01, 0.30788E+01, 0.30872E+01, 0.30957E+01,&
      0.31041E+01, 0.31125E+01, 0.31209E+01, 0.31293E+01, 0.31376E+01,&
      0.31460E+01, 0.31543E+01, 0.31626E+01, 0.31709E+01, 0.31792E+01,&
      0.31874E+01, 0.31957E+01, 0.32039E+01, 0.32121E+01, 0.32203E+01,&
      0.32285E+01, 0.32366E+01, 0.32448E+01, 0.32529E+01, 0.32610E+01,&
      0.32691E+01, 0.32772E+01, 0.32853E+01, 0.32934E+01, 0.33014E+01,&
      0.33094E+01, 0.33175E+01, 0.33254E+01, 0.33334E+01, 0.33414E+01,&
      0.33494E+01, 0.33573E+01, 0.33652E+01, 0.33731E+01, 0.33810E+01,&
      0.33889E+01, 0.33968E+01, 0.34046E+01, 0.34124E+01, 0.34203E+01,&
      0.34281E+01, 0.34359E+01, 0.34436E+01, 0.34514E+01, 0.34592E+01,&
      0.34669E+01, 0.34746E+01, 0.34823E+01, 0.34900E+01, 0.34977E+01,&
      0.35054E+01, 0.35130E+01, 0.35206E+01, 0.35283E+01, 0.35359E+01,&
      0.35435E+01, 0.35511E+01, 0.35586E+01, 0.35662E+01, 0.35737E+01,&
      0.35813E+01, 0.35888E+01, 0.35963E+01, 0.36038E+01, 0.36112E+01,&
      0.36187E+01, 0.36262E+01, 0.36336E+01, 0.36410E+01, 0.36484E+01,&
      0.36558E+01, 0.36632E+01, 0.36706E+01, 0.36779E+01, 0.36853E+01/
                             
     DATA (BNC08M (IA),IA=401,500)/                                     &
      0.36926E+01, 0.36999E+01, 0.37072E+01, 0.37145E+01, 0.37218E+01,&
      0.37291E+01, 0.37363E+01, 0.37436E+01, 0.37508E+01, 0.37580E+01,&
      0.37652E+01, 0.37724E+01, 0.37796E+01, 0.37868E+01, 0.37939E+01,&
      0.38011E+01, 0.38082E+01, 0.38153E+01, 0.38225E+01, 0.38296E+01,&
      0.38366E+01, 0.38437E+01, 0.38508E+01, 0.38578E+01, 0.38649E+01,&
      0.38719E+01, 0.38789E+01, 0.38859E+01, 0.38929E+01, 0.38999E+01,&
      0.39068E+01, 0.39138E+01, 0.39207E+01, 0.39277E+01, 0.39346E+01,&
      0.39415E+01, 0.39484E+01, 0.39553E+01, 0.39622E+01, 0.39690E+01,&
      0.39759E+01, 0.39827E+01, 0.39895E+01, 0.39964E+01, 0.40032E+01,&
      0.40100E+01, 0.40167E+01, 0.40235E+01, 0.40303E+01, 0.40370E+01,&
      0.40438E+01, 0.40505E+01, 0.40572E+01, 0.40639E+01, 0.40706E+01,&
      0.40773E+01, 0.40840E+01, 0.40907E+01, 0.40973E+01, 0.41040E+01,&
      0.41106E+01, 0.41172E+01, 0.41238E+01, 0.41304E+01, 0.41370E+01,&
      0.41436E+01, 0.41502E+01, 0.41567E+01, 0.41633E+01, 0.41698E+01,&
      0.41763E+01, 0.41829E+01, 0.41894E+01, 0.41959E+01, 0.42024E+01,&
      0.42088E+01, 0.42153E+01, 0.42218E+01, 0.42282E+01, 0.42346E+01,&
      0.42411E+01, 0.42475E+01, 0.42539E+01, 0.42603E+01, 0.42667E+01,&
      0.42731E+01, 0.42794E+01, 0.42858E+01, 0.42921E+01, 0.42985E+01,&
      0.43048E+01, 0.43111E+01, 0.43174E+01, 0.43237E+01, 0.43300E+01,&
      0.43363E+01, 0.43426E+01, 0.43488E+01, 0.43551E+01, 0.43613E+01/
                             
     DATA (BNC08M (IA),IA=501,600)/                                     &
      0.43675E+01, 0.43738E+01, 0.43800E+01, 0.43862E+01, 0.43924E+01,&
      0.43986E+01, 0.44047E+01, 0.44109E+01, 0.44171E+01, 0.44232E+01,&
      0.44293E+01, 0.44355E+01, 0.44416E+01, 0.44477E+01, 0.44538E+01,&
      0.44599E+01, 0.44660E+01, 0.44721E+01, 0.44781E+01, 0.44842E+01,&
      0.44902E+01, 0.44963E+01, 0.45023E+01, 0.45083E+01, 0.45143E+01,&
      0.45203E+01, 0.45263E+01, 0.45323E+01, 0.45383E+01, 0.45443E+01,&
      0.45502E+01, 0.45562E+01, 0.45621E+01, 0.45681E+01, 0.45740E+01,&
      0.45799E+01, 0.45858E+01, 0.45917E+01, 0.45976E+01, 0.46035E+01,&
      0.46094E+01, 0.46152E+01, 0.46211E+01, 0.46269E+01, 0.46328E+01,&
      0.46386E+01, 0.46444E+01, 0.46502E+01, 0.46560E+01, 0.46618E+01,&
      0.46676E+01, 0.46734E+01, 0.46792E+01, 0.46849E+01, 0.46907E+01,&
      0.46965E+01, 0.47022E+01, 0.47079E+01, 0.47137E+01, 0.47194E+01,&
      0.47251E+01, 0.47308E+01, 0.47365E+01, 0.47422E+01, 0.47478E+01,&
      0.47535E+01, 0.47592E+01, 0.47648E+01, 0.47705E+01, 0.47761E+01,&
      0.47817E+01, 0.47873E+01, 0.47930E+01, 0.47986E+01, 0.48042E+01,&
      0.48098E+01, 0.48153E+01, 0.48209E+01, 0.48265E+01, 0.48320E+01,&
      0.48376E+01, 0.48431E+01, 0.48487E+01, 0.48542E+01, 0.48597E+01,&
      0.48652E+01, 0.48707E+01, 0.48762E+01, 0.48817E+01, 0.48872E+01,&
      0.48927E+01, 0.48982E+01, 0.49036E+01, 0.49091E+01, 0.49145E+01,&
      0.49200E+01, 0.49254E+01, 0.49308E+01, 0.49362E+01, 0.49565E+01/
                             
     DATA (BNC08M (IA),IA=601,700)/                                     &
      0.50007E+01, 0.50536E+01, 0.51058E+01, 0.51574E+01, 0.52083E+01,&
      0.52585E+01, 0.53082E+01, 0.53572E+01, 0.54056E+01, 0.54534E+01,&
      0.55007E+01, 0.55473E+01, 0.55935E+01, 0.56391E+01, 0.56841E+01,&
      0.57287E+01, 0.57727E+01, 0.58163E+01, 0.58594E+01, 0.59020E+01,&
      0.59441E+01, 0.59858E+01, 0.60270E+01, 0.60678E+01, 0.61081E+01,&
      0.61481E+01, 0.61876E+01, 0.62267E+01, 0.62654E+01, 0.63037E+01,&
      0.63416E+01, 0.63792E+01, 0.64164E+01, 0.64532E+01, 0.64897E+01,&
      0.65258E+01, 0.65615E+01, 0.65969E+01, 0.66320E+01, 0.66668E+01,&
      0.67012E+01, 0.67353E+01, 0.67691E+01, 0.68026E+01, 0.68358E+01,&
      0.68687E+01, 0.69013E+01, 0.69336E+01, 0.69656E+01, 0.69974E+01,&
      0.70288E+01, 0.70600E+01, 0.70910E+01, 0.71216E+01, 0.71520E+01,&
      0.71822E+01, 0.72121E+01, 0.72417E+01, 0.72711E+01, 0.73003E+01,&
      0.73292E+01, 0.73579E+01, 0.73864E+01, 0.74146E+01, 0.74426E+01,&
      0.74704E+01, 0.74980E+01, 0.75253E+01, 0.75524E+01, 0.75794E+01,&
      0.76061E+01, 0.76326E+01, 0.76589E+01, 0.76850E+01, 0.77110E+01,&
      0.77367E+01, 0.77622E+01, 0.77876E+01, 0.78127E+01, 0.78377E+01,&
      0.78625E+01, 0.78871E+01, 0.79115E+01, 0.79358E+01, 0.79599E+01,&
      0.79838E+01, 0.80075E+01, 0.80311E+01, 0.80545E+01, 0.80778E+01,&
      0.81009E+01, 0.81238E+01, 0.81466E+01, 0.81692E+01, 0.81916E+01,&
      0.82140E+01, 0.82361E+01, 0.82581E+01, 0.82800E+01, 0.83017E+01/
                             
     DATA (BNC08M(IA),IA=701,741)/                                      &
      0.83233E+01, 0.83447E+01, 0.83660E+01, 0.83872E+01, 0.84082E+01,&
      0.84291E+01, 0.84498E+01, 0.84704E+01, 0.84909E+01, 0.85113E+01,&
      0.85315E+01, 0.85516E+01, 0.85715E+01, 0.85914E+01, 0.86111E+01,&
      0.86307E+01, 0.86502E+01, 0.86695E+01, 0.86888E+01, 0.87079E+01,&
      0.87269E+01, 0.87458E+01, 0.87645E+01, 0.87832E+01, 0.88018E+01,&
      0.88202E+01, 0.88385E+01, 0.88567E+01, 0.88749E+01, 0.88929E+01,&
      0.89108E+01, 0.89286E+01, 0.89463E+01, 0.89638E+01, 0.89813E+01,&
      0.89987E+01, 0.90160E+01, 0.90332E+01, 0.90503E+01, 0.90673E+01,&
      0.90842E+01                  /                      
!                            
!  ** NH4HSO4                
!                            
     DATA (BNC09M (IA),IA=  1,100)/                                     &
     -0.54181E-01,-0.97084E-01,-0.12639E+00,-0.14587E+00,-0.16057E+00,&
     -0.17236E+00,-0.18218E+00,-0.19054E+00,-0.19779E+00,-0.20414E+00,&
     -0.20976E+00,-0.21476E+00,-0.21923E+00,-0.22324E+00,-0.22685E+00,&
     -0.23009E+00,-0.23301E+00,-0.23563E+00,-0.23798E+00,-0.24008E+00,&
     -0.24194E+00,-0.24359E+00,-0.24503E+00,-0.24629E+00,-0.24736E+00,&
     -0.24827E+00,-0.24901E+00,-0.24959E+00,-0.25003E+00,-0.25033E+00,&
     -0.25049E+00,-0.25052E+00,-0.25043E+00,-0.25022E+00,-0.24990E+00,&
     -0.24946E+00,-0.24892E+00,-0.24827E+00,-0.24753E+00,-0.24669E+00,&
     -0.24576E+00,-0.24473E+00,-0.24363E+00,-0.24244E+00,-0.24116E+00,&
     -0.23982E+00,-0.23839E+00,-0.23690E+00,-0.23533E+00,-0.23370E+00,&
     -0.23200E+00,-0.23024E+00,-0.22842E+00,-0.22654E+00,-0.22460E+00,&
     -0.22261E+00,-0.22056E+00,-0.21846E+00,-0.21632E+00,-0.21412E+00,&
     -0.21188E+00,-0.20959E+00,-0.20725E+00,-0.20487E+00,-0.20245E+00,&
     -0.19999E+00,-0.19748E+00,-0.19494E+00,-0.19236E+00,-0.18974E+00,&
     -0.18708E+00,-0.18439E+00,-0.18165E+00,-0.17889E+00,-0.17608E+00,&
     -0.17324E+00,-0.17037E+00,-0.16746E+00,-0.16452E+00,-0.16154E+00,&
     -0.15853E+00,-0.15549E+00,-0.15242E+00,-0.14931E+00,-0.14617E+00,&
     -0.14300E+00,-0.13980E+00,-0.13656E+00,-0.13330E+00,-0.13001E+00,&
     -0.12668E+00,-0.12333E+00,-0.11995E+00,-0.11655E+00,-0.11311E+00,&
     -0.10965E+00,-0.10617E+00,-0.10266E+00,-0.99129E-01,-0.95574E-01/
                             
     DATA (BNC09M (IA),IA=101,200)/                                     &
     -0.91997E-01,-0.88400E-01,-0.84784E-01,-0.81148E-01,-0.77495E-01,&
     -0.73825E-01,-0.70139E-01,-0.66438E-01,-0.62724E-01,-0.58997E-01,&
     -0.55258E-01,-0.51509E-01,-0.47750E-01,-0.43981E-01,-0.40206E-01,&
     -0.36423E-01,-0.32634E-01,-0.28839E-01,-0.25041E-01,-0.21238E-01,&
     -0.17814E-01,-0.13963E-01,-0.10114E-01,-0.62690E-02,-0.24276E-02,&
      0.14101E-02, 0.52436E-02, 0.90727E-02, 0.12897E-01, 0.16717E-01,&
      0.20532E-01, 0.24341E-01, 0.28145E-01, 0.31943E-01, 0.35736E-01,&
      0.39522E-01, 0.43302E-01, 0.47075E-01, 0.50843E-01, 0.54603E-01,&
      0.58356E-01, 0.62103E-01, 0.65842E-01, 0.69575E-01, 0.73300E-01,&
      0.77017E-01, 0.80727E-01, 0.84429E-01, 0.88124E-01, 0.91811E-01,&
      0.95490E-01, 0.99161E-01, 0.10282E+00, 0.10648E+00, 0.11012E+00,&
      0.11376E+00, 0.11739E+00, 0.12102E+00, 0.12463E+00, 0.12823E+00,&
      0.13183E+00, 0.13542E+00, 0.13900E+00, 0.14257E+00, 0.14613E+00,&
      0.14968E+00, 0.15323E+00, 0.15677E+00, 0.16029E+00, 0.16381E+00,&
      0.16732E+00, 0.17082E+00, 0.17432E+00, 0.17780E+00, 0.18128E+00,&
      0.18474E+00, 0.18820E+00, 0.19165E+00, 0.19509E+00, 0.19852E+00,&
      0.20194E+00, 0.20536E+00, 0.20876E+00, 0.21216E+00, 0.21555E+00,&
      0.21892E+00, 0.22229E+00, 0.22566E+00, 0.22901E+00, 0.23235E+00,&
      0.23569E+00, 0.23902E+00, 0.24233E+00, 0.24564E+00, 0.24894E+00,&
      0.25224E+00, 0.25552E+00, 0.25880E+00, 0.26206E+00, 0.26532E+00/
                             
     DATA (BNC09M (IA),IA=201,300)/                                     &
      0.26857E+00, 0.27181E+00, 0.27505E+00, 0.27827E+00, 0.28149E+00,&
      0.28470E+00, 0.28790E+00, 0.29109E+00, 0.29427E+00, 0.29745E+00,&
      0.30061E+00, 0.30377E+00, 0.30692E+00, 0.31007E+00, 0.31320E+00,&
      0.31633E+00, 0.31944E+00, 0.32255E+00, 0.32566E+00, 0.32875E+00,&
      0.33184E+00, 0.33492E+00, 0.33799E+00, 0.34105E+00, 0.34410E+00,&
      0.34715E+00, 0.35019E+00, 0.35322E+00, 0.35625E+00, 0.35926E+00,&
      0.36227E+00, 0.36527E+00, 0.36827E+00, 0.37125E+00, 0.37423E+00,&
      0.37720E+00, 0.38017E+00, 0.38312E+00, 0.38607E+00, 0.38901E+00,&
      0.39195E+00, 0.39487E+00, 0.39779E+00, 0.40070E+00, 0.40361E+00,&
      0.40651E+00, 0.40940E+00, 0.41228E+00, 0.41516E+00, 0.41803E+00,&
      0.42089E+00, 0.42374E+00, 0.42659E+00, 0.42943E+00, 0.43227E+00,&
      0.43509E+00, 0.43791E+00, 0.44073E+00, 0.44354E+00, 0.44634E+00,&
      0.44913E+00, 0.45192E+00, 0.45469E+00, 0.45747E+00, 0.46023E+00,&
      0.46299E+00, 0.46575E+00, 0.46849E+00, 0.47123E+00, 0.47397E+00,&
      0.47670E+00, 0.47942E+00, 0.48213E+00, 0.48484E+00, 0.48754E+00,&
      0.49023E+00, 0.49292E+00, 0.49561E+00, 0.49828E+00, 0.50095E+00,&
      0.50362E+00, 0.50627E+00, 0.50892E+00, 0.51157E+00, 0.51421E+00,&
      0.51684E+00, 0.51947E+00, 0.52209E+00, 0.52470E+00, 0.52731E+00,&
      0.52991E+00, 0.53251E+00, 0.53510E+00, 0.53769E+00, 0.54027E+00,&
      0.54284E+00, 0.54541E+00, 0.54797E+00, 0.55052E+00, 0.55307E+00/
                             
     DATA (BNC09M (IA),IA=301,400)/                                     &
      0.55562E+00, 0.55816E+00, 0.56069E+00, 0.56321E+00, 0.56574E+00,&
      0.56825E+00, 0.57076E+00, 0.57327E+00, 0.57576E+00, 0.57826E+00,&
      0.58075E+00, 0.58323E+00, 0.58570E+00, 0.58818E+00, 0.59064E+00,&
      0.59310E+00, 0.59556E+00, 0.59801E+00, 0.60045E+00, 0.60289E+00,&
      0.60532E+00, 0.60775E+00, 0.61017E+00, 0.61259E+00, 0.61500E+00,&
      0.61741E+00, 0.61981E+00, 0.62221E+00, 0.62460E+00, 0.62699E+00,&
      0.62937E+00, 0.63175E+00, 0.63412E+00, 0.63648E+00, 0.63885E+00,&
      0.64120E+00, 0.64355E+00, 0.64590E+00, 0.64824E+00, 0.65058E+00,&
      0.65291E+00, 0.65523E+00, 0.65755E+00, 0.65987E+00, 0.66218E+00,&
      0.66449E+00, 0.66679E+00, 0.66909E+00, 0.67138E+00, 0.67367E+00,&
      0.67595E+00, 0.67823E+00, 0.68050E+00, 0.68277E+00, 0.68503E+00,&
      0.68729E+00, 0.68955E+00, 0.69180E+00, 0.69404E+00, 0.69628E+00,&
      0.69852E+00, 0.70075E+00, 0.70298E+00, 0.70520E+00, 0.70742E+00,&
      0.70963E+00, 0.71184E+00, 0.71405E+00, 0.71625E+00, 0.71844E+00,&
      0.72063E+00, 0.72282E+00, 0.72500E+00, 0.72718E+00, 0.72935E+00,&
      0.73152E+00, 0.73369E+00, 0.73585E+00, 0.73800E+00, 0.74015E+00,&
      0.74230E+00, 0.74444E+00, 0.74658E+00, 0.74872E+00, 0.75085E+00,&
      0.75297E+00, 0.75510E+00, 0.75721E+00, 0.75933E+00, 0.76144E+00,&
      0.76354E+00, 0.76564E+00, 0.76774E+00, 0.76983E+00, 0.77192E+00,&
      0.77401E+00, 0.77609E+00, 0.77817E+00, 0.78024E+00, 0.78231E+00/
                             
     DATA (BNC09M (IA),IA=401,500)/                                     &
      0.78437E+00, 0.78643E+00, 0.78849E+00, 0.79054E+00, 0.79259E+00,&
      0.79464E+00, 0.79668E+00, 0.79871E+00, 0.80075E+00, 0.80278E+00,&
      0.80480E+00, 0.80682E+00, 0.80884E+00, 0.81085E+00, 0.81286E+00,&
      0.81487E+00, 0.81687E+00, 0.81887E+00, 0.82087E+00, 0.82286E+00,&
      0.82484E+00, 0.82683E+00, 0.82881E+00, 0.83078E+00, 0.83275E+00,&
      0.83472E+00, 0.83669E+00, 0.83865E+00, 0.84061E+00, 0.84256E+00,&
      0.84451E+00, 0.84646E+00, 0.84840E+00, 0.85034E+00, 0.85228E+00,&
      0.85421E+00, 0.85614E+00, 0.85806E+00, 0.85998E+00, 0.86190E+00,&
      0.86382E+00, 0.86573E+00, 0.86763E+00, 0.86954E+00, 0.87144E+00,&
      0.87333E+00, 0.87523E+00, 0.87712E+00, 0.87900E+00, 0.88089E+00,&
      0.88277E+00, 0.88464E+00, 0.88652E+00, 0.88839E+00, 0.89025E+00,&
      0.89212E+00, 0.89397E+00, 0.89583E+00, 0.89768E+00, 0.89953E+00,&
      0.90138E+00, 0.90322E+00, 0.90506E+00, 0.90690E+00, 0.90873E+00,&
      0.91056E+00, 0.91239E+00, 0.91421E+00, 0.91603E+00, 0.91784E+00,&
      0.91966E+00, 0.92147E+00, 0.92327E+00, 0.92508E+00, 0.92688E+00,&
      0.92868E+00, 0.93047E+00, 0.93226E+00, 0.93405E+00, 0.93583E+00,&
      0.93761E+00, 0.93939E+00, 0.94117E+00, 0.94294E+00, 0.94471E+00,&
      0.94648E+00, 0.94824E+00, 0.95000E+00, 0.95175E+00, 0.95351E+00,&
      0.95526E+00, 0.95701E+00, 0.95875E+00, 0.96049E+00, 0.96223E+00,&
      0.96397E+00, 0.96570E+00, 0.96743E+00, 0.96915E+00, 0.97088E+00/
                             
     DATA (BNC09M (IA),IA=501,600)/                                     &
      0.97260E+00, 0.97432E+00, 0.97603E+00, 0.97774E+00, 0.97945E+00,&
      0.98116E+00, 0.98286E+00, 0.98456E+00, 0.98626E+00, 0.98795E+00,&
      0.98964E+00, 0.99133E+00, 0.99302E+00, 0.99470E+00, 0.99638E+00,&
      0.99806E+00, 0.99973E+00, 0.10014E+01, 0.10031E+01, 0.10047E+01,&
      0.10064E+01, 0.10081E+01, 0.10097E+01, 0.10114E+01, 0.10130E+01,&
      0.10147E+01, 0.10163E+01, 0.10180E+01, 0.10196E+01, 0.10212E+01,&
      0.10229E+01, 0.10245E+01, 0.10261E+01, 0.10278E+01, 0.10294E+01,&
      0.10310E+01, 0.10326E+01, 0.10342E+01, 0.10359E+01, 0.10375E+01,&
      0.10391E+01, 0.10407E+01, 0.10423E+01, 0.10439E+01, 0.10455E+01,&
      0.10471E+01, 0.10487E+01, 0.10503E+01, 0.10519E+01, 0.10534E+01,&
      0.10550E+01, 0.10566E+01, 0.10582E+01, 0.10598E+01, 0.10613E+01,&
      0.10629E+01, 0.10645E+01, 0.10660E+01, 0.10676E+01, 0.10691E+01,&
      0.10707E+01, 0.10723E+01, 0.10738E+01, 0.10754E+01, 0.10769E+01,&
      0.10784E+01, 0.10800E+01, 0.10815E+01, 0.10831E+01, 0.10846E+01,&
      0.10861E+01, 0.10877E+01, 0.10892E+01, 0.10907E+01, 0.10922E+01,&
      0.10938E+01, 0.10953E+01, 0.10968E+01, 0.10983E+01, 0.10998E+01,&
      0.11013E+01, 0.11028E+01, 0.11043E+01, 0.11058E+01, 0.11073E+01,&
      0.11088E+01, 0.11103E+01, 0.11118E+01, 0.11133E+01, 0.11148E+01,&
      0.11163E+01, 0.11177E+01, 0.11192E+01, 0.11207E+01, 0.11222E+01,&
      0.11236E+01, 0.11251E+01, 0.11266E+01, 0.11280E+01, 0.11335E+01/
                             
     DATA (BNC09M (IA),IA=601,700)/                                     &
      0.11454E+01, 0.11597E+01, 0.11737E+01, 0.11876E+01, 0.12012E+01,&
      0.12146E+01, 0.12278E+01, 0.12409E+01, 0.12537E+01, 0.12663E+01,&
      0.12788E+01, 0.12911E+01, 0.13032E+01, 0.13152E+01, 0.13270E+01,&
      0.13386E+01, 0.13500E+01, 0.13613E+01, 0.13725E+01, 0.13835E+01,&
      0.13943E+01, 0.14050E+01, 0.14156E+01, 0.14260E+01, 0.14363E+01,&
      0.14464E+01, 0.14564E+01, 0.14663E+01, 0.14761E+01, 0.14857E+01,&
      0.14952E+01, 0.15046E+01, 0.15139E+01, 0.15231E+01, 0.15321E+01,&
      0.15410E+01, 0.15499E+01, 0.15586E+01, 0.15672E+01, 0.15757E+01,&
      0.15841E+01, 0.15923E+01, 0.16005E+01, 0.16086E+01, 0.16166E+01,&
      0.16245E+01, 0.16323E+01, 0.16400E+01, 0.16477E+01, 0.16552E+01,&
      0.16626E+01, 0.16700E+01, 0.16773E+01, 0.16845E+01, 0.16916E+01,&
      0.16986E+01, 0.17055E+01, 0.17124E+01, 0.17192E+01, 0.17259E+01,&
      0.17325E+01, 0.17390E+01, 0.17455E+01, 0.17519E+01, 0.17583E+01,&
      0.17645E+01, 0.17707E+01, 0.17768E+01, 0.17829E+01, 0.17889E+01,&
      0.17948E+01, 0.18006E+01, 0.18064E+01, 0.18121E+01, 0.18178E+01,&
      0.18234E+01, 0.18289E+01, 0.18344E+01, 0.18398E+01, 0.18452E+01,&
      0.18505E+01, 0.18557E+01, 0.18609E+01, 0.18660E+01, 0.18711E+01,&
      0.18761E+01, 0.18811E+01, 0.18860E+01, 0.18908E+01, 0.18956E+01,&
      0.19004E+01, 0.19050E+01, 0.19097E+01, 0.19143E+01, 0.19188E+01,&
      0.19233E+01, 0.19278E+01, 0.19322E+01, 0.19365E+01, 0.19408E+01/
                             
     DATA (BNC09M(IA),IA=701,741)/                                      &
      0.19451E+01, 0.19493E+01, 0.19535E+01, 0.19576E+01, 0.19616E+01,&
      0.19657E+01, 0.19697E+01, 0.19736E+01, 0.19775E+01, 0.19814E+01,&
      0.19852E+01, 0.19890E+01, 0.19927E+01, 0.19964E+01, 0.20001E+01,&
      0.20037E+01, 0.20073E+01, 0.20108E+01, 0.20143E+01, 0.20178E+01,&
      0.20212E+01, 0.20246E+01, 0.20279E+01, 0.20312E+01, 0.20345E+01,&
      0.20378E+01, 0.20410E+01, 0.20441E+01, 0.20473E+01, 0.20504E+01,&
      0.20534E+01, 0.20565E+01, 0.20595E+01, 0.20624E+01, 0.20654E+01,&
      0.20683E+01, 0.20711E+01, 0.20740E+01, 0.20768E+01, 0.20796E+01,&
      0.20823E+01                  /                      
!                            
!  ** (H, NO3)               
!                            
     DATA (BNC10M (IA),IA=  1,100)/                                     &
     -0.53284E-01,-0.93378E-01,-0.11890E+00,-0.13461E+00,-0.14557E+00,&
     -0.15369E+00,-0.15987E+00,-0.16466E+00,-0.16839E+00,-0.17129E+00,&
     -0.17352E+00,-0.17519E+00,-0.17640E+00,-0.17722E+00,-0.17770E+00,&
     -0.17789E+00,-0.17782E+00,-0.17753E+00,-0.17704E+00,-0.17638E+00,&
     -0.17556E+00,-0.17459E+00,-0.17350E+00,-0.17230E+00,-0.17099E+00,&
     -0.16959E+00,-0.16811E+00,-0.16655E+00,-0.16492E+00,-0.16323E+00,&
     -0.16149E+00,-0.15969E+00,-0.15785E+00,-0.15596E+00,-0.15404E+00,&
     -0.15208E+00,-0.15010E+00,-0.14808E+00,-0.14604E+00,-0.14398E+00,&
     -0.14191E+00,-0.13981E+00,-0.13770E+00,-0.13557E+00,-0.13344E+00,&
     -0.13129E+00,-0.12914E+00,-0.12698E+00,-0.12481E+00,-0.12264E+00,&
     -0.12046E+00,-0.11828E+00,-0.11609E+00,-0.11390E+00,-0.11171E+00,&
     -0.10952E+00,-0.10732E+00,-0.10512E+00,-0.10292E+00,-0.10071E+00,&
     -0.98502E-01,-0.96290E-01,-0.94074E-01,-0.91854E-01,-0.89629E-01,&
     -0.87399E-01,-0.85162E-01,-0.82919E-01,-0.80669E-01,-0.78411E-01,&
     -0.76144E-01,-0.73868E-01,-0.71581E-01,-0.69284E-01,-0.66975E-01,&
     -0.64655E-01,-0.62321E-01,-0.59973E-01,-0.57612E-01,-0.55236E-01,&
     -0.52844E-01,-0.50437E-01,-0.48014E-01,-0.45574E-01,-0.43117E-01,&
     -0.40643E-01,-0.38151E-01,-0.35641E-01,-0.33114E-01,-0.30569E-01,&
     -0.28006E-01,-0.25426E-01,-0.22827E-01,-0.20212E-01,-0.17578E-01,&
     -0.14928E-01,-0.12262E-01,-0.95788E-02,-0.68800E-02,-0.41657E-02/
                             
     DATA (BNC10M (IA),IA=101,200)/                                     &
     -0.14365E-02, 0.13072E-02, 0.40646E-02, 0.68354E-02, 0.96189E-02,&
      0.12415E-01, 0.15222E-01, 0.18040E-01, 0.20868E-01, 0.23706E-01,&
      0.26553E-01, 0.29408E-01, 0.32271E-01, 0.35141E-01, 0.38017E-01,&
      0.40900E-01, 0.43787E-01, 0.46680E-01, 0.49577E-01, 0.52478E-01,&
      0.55030E-01, 0.57977E-01, 0.60923E-01, 0.63866E-01, 0.66808E-01,&
      0.69748E-01, 0.72686E-01, 0.75621E-01, 0.78554E-01, 0.81485E-01,&
      0.84414E-01, 0.87340E-01, 0.90263E-01, 0.93184E-01, 0.96103E-01,&
      0.99018E-01, 0.10193E+00, 0.10484E+00, 0.10775E+00, 0.11065E+00,&
      0.11355E+00, 0.11645E+00, 0.11934E+00, 0.12224E+00, 0.12512E+00,&
      0.12801E+00, 0.13089E+00, 0.13377E+00, 0.13664E+00, 0.13951E+00,&
      0.14238E+00, 0.14525E+00, 0.14811E+00, 0.15097E+00, 0.15382E+00,&
      0.15667E+00, 0.15951E+00, 0.16236E+00, 0.16520E+00, 0.16803E+00,&
      0.17086E+00, 0.17369E+00, 0.17651E+00, 0.17933E+00, 0.18215E+00,&
      0.18496E+00, 0.18776E+00, 0.19057E+00, 0.19337E+00, 0.19616E+00,&
      0.19895E+00, 0.20174E+00, 0.20452E+00, 0.20730E+00, 0.21008E+00,&
      0.21285E+00, 0.21561E+00, 0.21837E+00, 0.22113E+00, 0.22389E+00,&
      0.22663E+00, 0.22938E+00, 0.23212E+00, 0.23486E+00, 0.23759E+00,&
      0.24032E+00, 0.24304E+00, 0.24576E+00, 0.24847E+00, 0.25118E+00,&
      0.25389E+00, 0.25659E+00, 0.25929E+00, 0.26198E+00, 0.26467E+00,&
      0.26735E+00, 0.27003E+00, 0.27270E+00, 0.27537E+00, 0.27804E+00/
                             
     DATA (BNC10M (IA),IA=201,300)/                                     &
      0.28070E+00, 0.28336E+00, 0.28601E+00, 0.28866E+00, 0.29130E+00,&
      0.29394E+00, 0.29657E+00, 0.29920E+00, 0.30183E+00, 0.30445E+00,&
      0.30707E+00, 0.30968E+00, 0.31229E+00, 0.31489E+00, 0.31749E+00,&
      0.32008E+00, 0.32267E+00, 0.32525E+00, 0.32783E+00, 0.33041E+00,&
      0.33298E+00, 0.33555E+00, 0.33811E+00, 0.34067E+00, 0.34322E+00,&
      0.34577E+00, 0.34831E+00, 0.35085E+00, 0.35339E+00, 0.35592E+00,&
      0.35844E+00, 0.36097E+00, 0.36348E+00, 0.36599E+00, 0.36850E+00,&
      0.37101E+00, 0.37351E+00, 0.37600E+00, 0.37849E+00, 0.38098E+00,&
      0.38346E+00, 0.38593E+00, 0.38840E+00, 0.39087E+00, 0.39334E+00,&
      0.39579E+00, 0.39825E+00, 0.40070E+00, 0.40314E+00, 0.40558E+00,&
      0.40802E+00, 0.41045E+00, 0.41288E+00, 0.41530E+00, 0.41772E+00,&
      0.42014E+00, 0.42255E+00, 0.42495E+00, 0.42735E+00, 0.42975E+00,&
      0.43214E+00, 0.43453E+00, 0.43691E+00, 0.43929E+00, 0.44167E+00,&
      0.44404E+00, 0.44640E+00, 0.44877E+00, 0.45112E+00, 0.45348E+00,&
      0.45583E+00, 0.45817E+00, 0.46051E+00, 0.46285E+00, 0.46518E+00,&
      0.46751E+00, 0.46983E+00, 0.47215E+00, 0.47446E+00, 0.47677E+00,&
      0.47908E+00, 0.48138E+00, 0.48368E+00, 0.48597E+00, 0.48826E+00,&
      0.49054E+00, 0.49283E+00, 0.49510E+00, 0.49737E+00, 0.49964E+00,&
      0.50191E+00, 0.50417E+00, 0.50642E+00, 0.50867E+00, 0.51092E+00,&
      0.51316E+00, 0.51540E+00, 0.51764E+00, 0.51987E+00, 0.52210E+00/
                             
     DATA (BNC10M (IA),IA=301,400)/                                     &
      0.52432E+00, 0.52654E+00, 0.52875E+00, 0.53096E+00, 0.53317E+00,&
      0.53537E+00, 0.53757E+00, 0.53976E+00, 0.54195E+00, 0.54414E+00,&
      0.54632E+00, 0.54850E+00, 0.55067E+00, 0.55284E+00, 0.55501E+00,&
      0.55717E+00, 0.55933E+00, 0.56148E+00, 0.56363E+00, 0.56578E+00,&
      0.56792E+00, 0.57006E+00, 0.57219E+00, 0.57433E+00, 0.57645E+00,&
      0.57857E+00, 0.58069E+00, 0.58281E+00, 0.58492E+00, 0.58703E+00,&
      0.58913E+00, 0.59123E+00, 0.59333E+00, 0.59542E+00, 0.59751E+00,&
      0.59959E+00, 0.60167E+00, 0.60375E+00, 0.60582E+00, 0.60789E+00,&
      0.60996E+00, 0.61202E+00, 0.61407E+00, 0.61613E+00, 0.61818E+00,&
      0.62023E+00, 0.62227E+00, 0.62431E+00, 0.62634E+00, 0.62838E+00,&
      0.63040E+00, 0.63243E+00, 0.63445E+00, 0.63647E+00, 0.63848E+00,&
      0.64049E+00, 0.64250E+00, 0.64450E+00, 0.64650E+00, 0.64849E+00,&
      0.65049E+00, 0.65247E+00, 0.65446E+00, 0.65644E+00, 0.65842E+00,&
      0.66039E+00, 0.66236E+00, 0.66433E+00, 0.66629E+00, 0.66825E+00,&
      0.67021E+00, 0.67216E+00, 0.67411E+00, 0.67606E+00, 0.67800E+00,&
      0.67994E+00, 0.68187E+00, 0.68380E+00, 0.68573E+00, 0.68766E+00,&
      0.68958E+00, 0.69150E+00, 0.69341E+00, 0.69532E+00, 0.69723E+00,&
      0.69914E+00, 0.70104E+00, 0.70294E+00, 0.70483E+00, 0.70672E+00,&
      0.70861E+00, 0.71049E+00, 0.71237E+00, 0.71425E+00, 0.71613E+00,&
      0.71800E+00, 0.71986E+00, 0.72173E+00, 0.72359E+00, 0.72545E+00/
                             
     DATA (BNC10M (IA),IA=401,500)/                                     &
      0.72730E+00, 0.72915E+00, 0.73100E+00, 0.73285E+00, 0.73469E+00,&
      0.73653E+00, 0.73836E+00, 0.74019E+00, 0.74202E+00, 0.74385E+00,&
      0.74567E+00, 0.74749E+00, 0.74930E+00, 0.75112E+00, 0.75293E+00,&
      0.75473E+00, 0.75654E+00, 0.75834E+00, 0.76013E+00, 0.76193E+00,&
      0.76372E+00, 0.76550E+00, 0.76729E+00, 0.76907E+00, 0.77085E+00,&
      0.77262E+00, 0.77439E+00, 0.77616E+00, 0.77793E+00, 0.77969E+00,&
      0.78145E+00, 0.78321E+00, 0.78496E+00, 0.78671E+00, 0.78846E+00,&
      0.79021E+00, 0.79195E+00, 0.79369E+00, 0.79542E+00, 0.79715E+00,&
      0.79888E+00, 0.80061E+00, 0.80233E+00, 0.80405E+00, 0.80577E+00,&
      0.80749E+00, 0.80920E+00, 0.81091E+00, 0.81261E+00, 0.81432E+00,&
      0.81602E+00, 0.81771E+00, 0.81941E+00, 0.82110E+00, 0.82279E+00,&
      0.82448E+00, 0.82616E+00, 0.82784E+00, 0.82952E+00, 0.83119E+00,&
      0.83286E+00, 0.83453E+00, 0.83620E+00, 0.83786E+00, 0.83952E+00,&
      0.84118E+00, 0.84283E+00, 0.84448E+00, 0.84613E+00, 0.84778E+00,&
      0.84942E+00, 0.85106E+00, 0.85270E+00, 0.85434E+00, 0.85597E+00,&
      0.85760E+00, 0.85922E+00, 0.86085E+00, 0.86247E+00, 0.86409E+00,&
      0.86571E+00, 0.86732E+00, 0.86893E+00, 0.87054E+00, 0.87214E+00,&
      0.87375E+00, 0.87535E+00, 0.87694E+00, 0.87854E+00, 0.88013E+00,&
      0.88172E+00, 0.88331E+00, 0.88489E+00, 0.88647E+00, 0.88805E+00,&
      0.88963E+00, 0.89120E+00, 0.89277E+00, 0.89434E+00, 0.89590E+00/
                             
     DATA (BNC10M (IA),IA=501,600)/                                     &
      0.89747E+00, 0.89903E+00, 0.90059E+00, 0.90214E+00, 0.90369E+00,&
      0.90524E+00, 0.90679E+00, 0.90834E+00, 0.90988E+00, 0.91142E+00,&
      0.91296E+00, 0.91449E+00, 0.91603E+00, 0.91756E+00, 0.91908E+00,&
      0.92061E+00, 0.92213E+00, 0.92365E+00, 0.92517E+00, 0.92668E+00,&
      0.92820E+00, 0.92971E+00, 0.93122E+00, 0.93272E+00, 0.93422E+00,&
      0.93572E+00, 0.93722E+00, 0.93872E+00, 0.94021E+00, 0.94170E+00,&
      0.94319E+00, 0.94468E+00, 0.94616E+00, 0.94764E+00, 0.94912E+00,&
      0.95060E+00, 0.95207E+00, 0.95354E+00, 0.95501E+00, 0.95648E+00,&
      0.95794E+00, 0.95940E+00, 0.96086E+00, 0.96232E+00, 0.96378E+00,&
      0.96523E+00, 0.96668E+00, 0.96813E+00, 0.96957E+00, 0.97102E+00,&
      0.97246E+00, 0.97390E+00, 0.97533E+00, 0.97677E+00, 0.97820E+00,&
      0.97963E+00, 0.98106E+00, 0.98248E+00, 0.98391E+00, 0.98533E+00,&
      0.98674E+00, 0.98816E+00, 0.98957E+00, 0.99099E+00, 0.99240E+00,&
      0.99380E+00, 0.99521E+00, 0.99661E+00, 0.99801E+00, 0.99941E+00,&
      0.10008E+01, 0.10022E+01, 0.10036E+01, 0.10050E+01, 0.10064E+01,&
      0.10078E+01, 0.10091E+01, 0.10105E+01, 0.10119E+01, 0.10133E+01,&
      0.10146E+01, 0.10160E+01, 0.10174E+01, 0.10188E+01, 0.10201E+01,&
      0.10215E+01, 0.10228E+01, 0.10242E+01, 0.10256E+01, 0.10269E+01,&
      0.10283E+01, 0.10296E+01, 0.10310E+01, 0.10323E+01, 0.10337E+01,&
      0.10350E+01, 0.10363E+01, 0.10377E+01, 0.10390E+01, 0.10440E+01/
                             
     DATA (BNC10M (IA),IA=601,700)/                                     &
      0.10549E+01, 0.10679E+01, 0.10807E+01, 0.10933E+01, 0.11058E+01,&
      0.11180E+01, 0.11301E+01, 0.11420E+01, 0.11537E+01, 0.11652E+01,&
      0.11766E+01, 0.11878E+01, 0.11989E+01, 0.12098E+01, 0.12205E+01,&
      0.12311E+01, 0.12415E+01, 0.12518E+01, 0.12620E+01, 0.12720E+01,&
      0.12819E+01, 0.12916E+01, 0.13012E+01, 0.13107E+01, 0.13201E+01,&
      0.13293E+01, 0.13384E+01, 0.13474E+01, 0.13562E+01, 0.13650E+01,&
      0.13736E+01, 0.13821E+01, 0.13905E+01, 0.13988E+01, 0.14070E+01,&
      0.14151E+01, 0.14231E+01, 0.14310E+01, 0.14388E+01, 0.14464E+01,&
      0.14540E+01, 0.14615E+01, 0.14689E+01, 0.14762E+01, 0.14834E+01,&
      0.14906E+01, 0.14976E+01, 0.15045E+01, 0.15114E+01, 0.15182E+01,&
      0.15249E+01, 0.15315E+01, 0.15380E+01, 0.15444E+01, 0.15508E+01,&
      0.15571E+01, 0.15633E+01, 0.15695E+01, 0.15755E+01, 0.15815E+01,&
      0.15875E+01, 0.15933E+01, 0.15991E+01, 0.16048E+01, 0.16105E+01,&
      0.16160E+01, 0.16215E+01, 0.16270E+01, 0.16324E+01, 0.16377E+01,&
      0.16429E+01, 0.16481E+01, 0.16533E+01, 0.16583E+01, 0.16634E+01,&
      0.16683E+01, 0.16732E+01, 0.16780E+01, 0.16828E+01, 0.16875E+01,&
      0.16922E+01, 0.16968E+01, 0.17014E+01, 0.17059E+01, 0.17104E+01,&
      0.17148E+01, 0.17191E+01, 0.17234E+01, 0.17277E+01, 0.17319E+01,&
      0.17360E+01, 0.17401E+01, 0.17442E+01, 0.17482E+01, 0.17521E+01,&
      0.17560E+01, 0.17599E+01, 0.17637E+01, 0.17675E+01, 0.17712E+01/
                             
     DATA (BNC10M(IA),IA=701,741)/                                      &
      0.17749E+01, 0.17786E+01, 0.17822E+01, 0.17858E+01, 0.17893E+01,&
      0.17927E+01, 0.17962E+01, 0.17996E+01, 0.18029E+01, 0.18063E+01,&
      0.18095E+01, 0.18128E+01, 0.18160E+01, 0.18191E+01, 0.18223E+01,&
      0.18253E+01, 0.18284E+01, 0.18314E+01, 0.18344E+01, 0.18373E+01,&
      0.18402E+01, 0.18431E+01, 0.18459E+01, 0.18487E+01, 0.18515E+01,&
      0.18542E+01, 0.18569E+01, 0.18596E+01, 0.18623E+01, 0.18649E+01,&
      0.18674E+01, 0.18700E+01, 0.18725E+01, 0.18749E+01, 0.18774E+01,&
      0.18798E+01, 0.18822E+01, 0.18845E+01, 0.18869E+01, 0.18892E+01,&
      0.18914E+01                  /                      
!                            
!  ** (H, Cl)                
!                            
     DATA (BNC11M (IA),IA=  1,100)/                                     &
     -0.51530E-01,-0.87364E-01,-0.10805E+00,-0.11938E+00,-0.12621E+00,&
     -0.13034E+00,-0.13263E+00,-0.13358E+00,-0.13351E+00,-0.13262E+00,&
     -0.13105E+00,-0.12892E+00,-0.12631E+00,-0.12328E+00,-0.11989E+00,&
     -0.11617E+00,-0.11216E+00,-0.10789E+00,-0.10338E+00,-0.98657E-01,&
     -0.93734E-01,-0.88627E-01,-0.83353E-01,-0.77922E-01,-0.72347E-01,&
     -0.66638E-01,-0.60804E-01,-0.54854E-01,-0.48795E-01,-0.42636E-01,&
     -0.36382E-01,-0.30040E-01,-0.23617E-01,-0.17116E-01,-0.10545E-01,&
     -0.39064E-02, 0.27939E-02, 0.95516E-02, 0.16363E-01, 0.23224E-01,&
      0.30132E-01, 0.37082E-01, 0.44072E-01, 0.51099E-01, 0.58160E-01,&
      0.65253E-01, 0.72375E-01, 0.79524E-01, 0.86699E-01, 0.93897E-01,&
      0.10112E+00, 0.10836E+00, 0.11562E+00, 0.12290E+00, 0.13019E+00,&
      0.13750E+00, 0.14483E+00, 0.15218E+00, 0.15954E+00, 0.16691E+00,&
      0.17430E+00, 0.18171E+00, 0.18913E+00, 0.19657E+00, 0.20403E+00,&
      0.21151E+00, 0.21900E+00, 0.22652E+00, 0.23405E+00, 0.24161E+00,&
      0.24919E+00, 0.25680E+00, 0.26443E+00, 0.27209E+00, 0.27977E+00,&
      0.28749E+00, 0.29523E+00, 0.30301E+00, 0.31082E+00, 0.31867E+00,&
      0.32655E+00, 0.33446E+00, 0.34241E+00, 0.35040E+00, 0.35843E+00,&
      0.36650E+00, 0.37461E+00, 0.38275E+00, 0.39094E+00, 0.39916E+00,&
      0.40743E+00, 0.41574E+00, 0.42408E+00, 0.43246E+00, 0.44088E+00,&
      0.44934E+00, 0.45784E+00, 0.46637E+00, 0.47494E+00, 0.48354E+00/
                             
     DATA (BNC11M (IA),IA=101,200)/                                     &
      0.49217E+00, 0.50083E+00, 0.50952E+00, 0.51825E+00, 0.52699E+00,&
      0.53577E+00, 0.54456E+00, 0.55338E+00, 0.56222E+00, 0.57108E+00,&
      0.57996E+00, 0.58885E+00, 0.59776E+00, 0.60668E+00, 0.61561E+00,&
      0.62456E+00, 0.63351E+00, 0.64246E+00, 0.65143E+00, 0.66039E+00,&
      0.66855E+00, 0.67762E+00, 0.68668E+00, 0.69573E+00, 0.70477E+00,&
      0.71380E+00, 0.72282E+00, 0.73183E+00, 0.74082E+00, 0.74981E+00,&
      0.75879E+00, 0.76776E+00, 0.77671E+00, 0.78566E+00, 0.79459E+00,&
      0.80351E+00, 0.81241E+00, 0.82131E+00, 0.83019E+00, 0.83906E+00,&
      0.84792E+00, 0.85676E+00, 0.86559E+00, 0.87440E+00, 0.88321E+00,&
      0.89200E+00, 0.90077E+00, 0.90953E+00, 0.91827E+00, 0.92701E+00,&
      0.93572E+00, 0.94443E+00, 0.95311E+00, 0.96178E+00, 0.97044E+00,&
      0.97908E+00, 0.98771E+00, 0.99632E+00, 0.10049E+01, 0.10135E+01,&
      0.10221E+01, 0.10306E+01, 0.10392E+01, 0.10477E+01, 0.10562E+01,&
      0.10647E+01, 0.10731E+01, 0.10816E+01, 0.10900E+01, 0.10984E+01,&
      0.11069E+01, 0.11152E+01, 0.11236E+01, 0.11320E+01, 0.11403E+01,&
      0.11486E+01, 0.11570E+01, 0.11652E+01, 0.11735E+01, 0.11818E+01,&
      0.11900E+01, 0.11983E+01, 0.12065E+01, 0.12147E+01, 0.12228E+01,&
      0.12310E+01, 0.12391E+01, 0.12473E+01, 0.12554E+01, 0.12635E+01,&
      0.12716E+01, 0.12796E+01, 0.12877E+01, 0.12957E+01, 0.13037E+01,&
      0.13117E+01, 0.13197E+01, 0.13276E+01, 0.13356E+01, 0.13435E+01/
                             
     DATA (BNC11M (IA),IA=201,300)/                                     &
      0.13514E+01, 0.13593E+01, 0.13672E+01, 0.13751E+01, 0.13829E+01,&
      0.13908E+01, 0.13986E+01, 0.14064E+01, 0.14142E+01, 0.14219E+01,&
      0.14297E+01, 0.14374E+01, 0.14451E+01, 0.14528E+01, 0.14605E+01,&
      0.14682E+01, 0.14758E+01, 0.14835E+01, 0.14911E+01, 0.14987E+01,&
      0.15063E+01, 0.15139E+01, 0.15214E+01, 0.15289E+01, 0.15365E+01,&
      0.15440E+01, 0.15515E+01, 0.15590E+01, 0.15664E+01, 0.15739E+01,&
      0.15813E+01, 0.15887E+01, 0.15961E+01, 0.16035E+01, 0.16109E+01,&
      0.16182E+01, 0.16255E+01, 0.16329E+01, 0.16402E+01, 0.16475E+01,&
      0.16547E+01, 0.16620E+01, 0.16692E+01, 0.16765E+01, 0.16837E+01,&
      0.16909E+01, 0.16981E+01, 0.17052E+01, 0.17124E+01, 0.17195E+01,&
      0.17266E+01, 0.17338E+01, 0.17408E+01, 0.17479E+01, 0.17550E+01,&
      0.17620E+01, 0.17691E+01, 0.17761E+01, 0.17831E+01, 0.17901E+01,&
      0.17971E+01, 0.18040E+01, 0.18110E+01, 0.18179E+01, 0.18248E+01,&
      0.18317E+01, 0.18386E+01, 0.18455E+01, 0.18524E+01, 0.18592E+01,&
      0.18660E+01, 0.18729E+01, 0.18797E+01, 0.18865E+01, 0.18932E+01,&
      0.19000E+01, 0.19068E+01, 0.19135E+01, 0.19202E+01, 0.19269E+01,&
      0.19336E+01, 0.19403E+01, 0.19470E+01, 0.19536E+01, 0.19603E+01,&
      0.19669E+01, 0.19735E+01, 0.19801E+01, 0.19867E+01, 0.19933E+01,&
      0.19998E+01, 0.20064E+01, 0.20129E+01, 0.20194E+01, 0.20259E+01,&
      0.20324E+01, 0.20389E+01, 0.20454E+01, 0.20518E+01, 0.20583E+01/
                             
     DATA (BNC11M (IA),IA=301,400)/                                     &
      0.20647E+01, 0.20711E+01, 0.20775E+01, 0.20839E+01, 0.20903E+01,&
      0.20967E+01, 0.21030E+01, 0.21093E+01, 0.21157E+01, 0.21220E+01,&
      0.21283E+01, 0.21346E+01, 0.21409E+01, 0.21471E+01, 0.21534E+01,&
      0.21596E+01, 0.21659E+01, 0.21721E+01, 0.21783E+01, 0.21845E+01,&
      0.21907E+01, 0.21968E+01, 0.22030E+01, 0.22091E+01, 0.22153E+01,&
      0.22214E+01, 0.22275E+01, 0.22336E+01, 0.22397E+01, 0.22457E+01,&
      0.22518E+01, 0.22579E+01, 0.22639E+01, 0.22699E+01, 0.22759E+01,&
      0.22819E+01, 0.22879E+01, 0.22939E+01, 0.22999E+01, 0.23058E+01,&
      0.23118E+01, 0.23177E+01, 0.23237E+01, 0.23296E+01, 0.23355E+01,&
      0.23414E+01, 0.23472E+01, 0.23531E+01, 0.23590E+01, 0.23648E+01,&
      0.23707E+01, 0.23765E+01, 0.23823E+01, 0.23881E+01, 0.23939E+01,&
      0.23997E+01, 0.24054E+01, 0.24112E+01, 0.24170E+01, 0.24227E+01,&
      0.24284E+01, 0.24341E+01, 0.24398E+01, 0.24455E+01, 0.24512E+01,&
      0.24569E+01, 0.24626E+01, 0.24682E+01, 0.24739E+01, 0.24795E+01,&
      0.24851E+01, 0.24907E+01, 0.24963E+01, 0.25019E+01, 0.25075E+01,&
      0.25131E+01, 0.25187E+01, 0.25242E+01, 0.25298E+01, 0.25353E+01,&
      0.25408E+01, 0.25463E+01, 0.25518E+01, 0.25573E+01, 0.25628E+01,&
      0.25683E+01, 0.25737E+01, 0.25792E+01, 0.25846E+01, 0.25901E+01,&
      0.25955E+01, 0.26009E+01, 0.26063E+01, 0.26117E+01, 0.26171E+01,&
      0.26225E+01, 0.26278E+01, 0.26332E+01, 0.26386E+01, 0.26439E+01/
                             
     DATA (BNC11M (IA),IA=401,500)/                                     &
      0.26492E+01, 0.26545E+01, 0.26599E+01, 0.26652E+01, 0.26704E+01,&
      0.26757E+01, 0.26810E+01, 0.26863E+01, 0.26915E+01, 0.26968E+01,&
      0.27020E+01, 0.27072E+01, 0.27125E+01, 0.27177E+01, 0.27229E+01,&
      0.27281E+01, 0.27332E+01, 0.27384E+01, 0.27436E+01, 0.27487E+01,&
      0.27539E+01, 0.27590E+01, 0.27642E+01, 0.27693E+01, 0.27744E+01,&
      0.27795E+01, 0.27846E+01, 0.27897E+01, 0.27948E+01, 0.27998E+01,&
      0.28049E+01, 0.28100E+01, 0.28150E+01, 0.28200E+01, 0.28251E+01,&
      0.28301E+01, 0.28351E+01, 0.28401E+01, 0.28451E+01, 0.28501E+01,&
      0.28551E+01, 0.28600E+01, 0.28650E+01, 0.28699E+01, 0.28749E+01,&
      0.28798E+01, 0.28847E+01, 0.28897E+01, 0.28946E+01, 0.28995E+01,&
      0.29044E+01, 0.29093E+01, 0.29141E+01, 0.29190E+01, 0.29239E+01,&
      0.29287E+01, 0.29336E+01, 0.29384E+01, 0.29433E+01, 0.29481E+01,&
      0.29529E+01, 0.29577E+01, 0.29625E+01, 0.29673E+01, 0.29721E+01,&
      0.29769E+01, 0.29816E+01, 0.29864E+01, 0.29911E+01, 0.29959E+01,&
      0.30006E+01, 0.30054E+01, 0.30101E+01, 0.30148E+01, 0.30195E+01,&
      0.30242E+01, 0.30289E+01, 0.30336E+01, 0.30383E+01, 0.30430E+01,&
      0.30476E+01, 0.30523E+01, 0.30569E+01, 0.30616E+01, 0.30662E+01,&
      0.30708E+01, 0.30754E+01, 0.30801E+01, 0.30847E+01, 0.30893E+01,&
      0.30939E+01, 0.30984E+01, 0.31030E+01, 0.31076E+01, 0.31122E+01,&
      0.31167E+01, 0.31213E+01, 0.31258E+01, 0.31303E+01, 0.31349E+01/
                             
     DATA (BNC11M (IA),IA=501,600)/                                     &
      0.31394E+01, 0.31439E+01, 0.31484E+01, 0.31529E+01, 0.31574E+01,&
      0.31619E+01, 0.31664E+01, 0.31708E+01, 0.31753E+01, 0.31798E+01,&
      0.31842E+01, 0.31887E+01, 0.31931E+01, 0.31975E+01, 0.32020E+01,&
      0.32064E+01, 0.32108E+01, 0.32152E+01, 0.32196E+01, 0.32240E+01,&
      0.32284E+01, 0.32327E+01, 0.32371E+01, 0.32415E+01, 0.32458E+01,&
      0.32502E+01, 0.32545E+01, 0.32589E+01, 0.32632E+01, 0.32675E+01,&
      0.32718E+01, 0.32762E+01, 0.32805E+01, 0.32848E+01, 0.32891E+01,&
      0.32934E+01, 0.32976E+01, 0.33019E+01, 0.33062E+01, 0.33104E+01,&
      0.33147E+01, 0.33189E+01, 0.33232E+01, 0.33274E+01, 0.33317E+01,&
      0.33359E+01, 0.33401E+01, 0.33443E+01, 0.33485E+01, 0.33527E+01,&
      0.33569E+01, 0.33611E+01, 0.33653E+01, 0.33695E+01, 0.33736E+01,&
      0.33778E+01, 0.33819E+01, 0.33861E+01, 0.33902E+01, 0.33944E+01,&
      0.33985E+01, 0.34026E+01, 0.34068E+01, 0.34109E+01, 0.34150E+01,&
      0.34191E+01, 0.34232E+01, 0.34273E+01, 0.34314E+01, 0.34355E+01,&
      0.34395E+01, 0.34436E+01, 0.34477E+01, 0.34517E+01, 0.34558E+01,&
      0.34598E+01, 0.34639E+01, 0.34679E+01, 0.34719E+01, 0.34759E+01,&
      0.34800E+01, 0.34840E+01, 0.34880E+01, 0.34920E+01, 0.34960E+01,&
      0.35000E+01, 0.35040E+01, 0.35079E+01, 0.35119E+01, 0.35159E+01,&
      0.35198E+01, 0.35238E+01, 0.35277E+01, 0.35317E+01, 0.35356E+01,&
      0.35396E+01, 0.35435E+01, 0.35474E+01, 0.35513E+01, 0.35660E+01/
                             
     DATA (BNC11M (IA),IA=601,700)/                                     &
      0.35979E+01, 0.36362E+01, 0.36739E+01, 0.37112E+01, 0.37479E+01,&
      0.37842E+01, 0.38200E+01, 0.38554E+01, 0.38903E+01, 0.39247E+01,&
      0.39588E+01, 0.39924E+01, 0.40256E+01, 0.40584E+01, 0.40909E+01,&
      0.41229E+01, 0.41546E+01, 0.41859E+01, 0.42168E+01, 0.42474E+01,&
      0.42776E+01, 0.43075E+01, 0.43371E+01, 0.43664E+01, 0.43953E+01,&
      0.44239E+01, 0.44522E+01, 0.44802E+01, 0.45079E+01, 0.45353E+01,&
      0.45624E+01, 0.45893E+01, 0.46158E+01, 0.46421E+01, 0.46681E+01,&
      0.46939E+01, 0.47194E+01, 0.47447E+01, 0.47697E+01, 0.47944E+01,&
      0.48190E+01, 0.48432E+01, 0.48673E+01, 0.48911E+01, 0.49147E+01,&
      0.49381E+01, 0.49612E+01, 0.49842E+01, 0.50069E+01, 0.50294E+01,&
      0.50517E+01, 0.50738E+01, 0.50958E+01, 0.51175E+01, 0.51390E+01,&
      0.51603E+01, 0.51815E+01, 0.52024E+01, 0.52232E+01, 0.52438E+01,&
      0.52643E+01, 0.52845E+01, 0.53046E+01, 0.53245E+01, 0.53442E+01,&
      0.53638E+01, 0.53832E+01, 0.54025E+01, 0.54216E+01, 0.54405E+01,&
      0.54593E+01, 0.54779E+01, 0.54964E+01, 0.55147E+01, 0.55329E+01,&
      0.55510E+01, 0.55689E+01, 0.55866E+01, 0.56043E+01, 0.56217E+01,&
      0.56391E+01, 0.56563E+01, 0.56734E+01, 0.56903E+01, 0.57072E+01,&
      0.57239E+01, 0.57404E+01, 0.57569E+01, 0.57732E+01, 0.57894E+01,&
      0.58055E+01, 0.58215E+01, 0.58373E+01, 0.58530E+01, 0.58687E+01,&
      0.58842E+01, 0.58996E+01, 0.59148E+01, 0.59300E+01, 0.59451E+01/
                             
     DATA (BNC11M(IA),IA=701,741)/                                      &
      0.59600E+01, 0.59749E+01, 0.59896E+01, 0.60043E+01, 0.60188E+01,&
      0.60333E+01, 0.60476E+01, 0.60619E+01, 0.60760E+01, 0.60901E+01,&
      0.61040E+01, 0.61179E+01, 0.61316E+01, 0.61453E+01, 0.61589E+01,&
      0.61724E+01, 0.61858E+01, 0.61991E+01, 0.62123E+01, 0.62254E+01,&
      0.62385E+01, 0.62514E+01, 0.62643E+01, 0.62771E+01, 0.62898E+01,&
      0.63024E+01, 0.63150E+01, 0.63274E+01, 0.63398E+01, 0.63521E+01,&
      0.63644E+01, 0.63765E+01, 0.63886E+01, 0.64006E+01, 0.64125E+01,&
      0.64243E+01, 0.64361E+01, 0.64478E+01, 0.64594E+01, 0.64710E+01,&
      0.64825E+01                  /                      
!                            
!  ** NaHSO4                 
!                            
     DATA (BNC12M (IA),IA=  1,100)/                                     &
     -0.53059E-01,-0.92995E-01,-0.11872E+00,-0.13483E+00,-0.14630E+00,&
     -0.15498E+00,-0.16174E+00,-0.16712E+00,-0.17143E+00,-0.17489E+00,&
     -0.17765E+00,-0.17982E+00,-0.18150E+00,-0.18274E+00,-0.18359E+00,&
     -0.18411E+00,-0.18432E+00,-0.18425E+00,-0.18392E+00,-0.18337E+00,&
     -0.18259E+00,-0.18162E+00,-0.18045E+00,-0.17912E+00,-0.17761E+00,&
     -0.17595E+00,-0.17414E+00,-0.17219E+00,-0.17011E+00,-0.16790E+00,&
     -0.16557E+00,-0.16313E+00,-0.16057E+00,-0.15791E+00,-0.15515E+00,&
     -0.15229E+00,-0.14934E+00,-0.14630E+00,-0.14318E+00,-0.13997E+00,&
     -0.13669E+00,-0.13333E+00,-0.12990E+00,-0.12640E+00,-0.12284E+00,&
     -0.11921E+00,-0.11552E+00,-0.11177E+00,-0.10796E+00,-0.10410E+00,&
     -0.10019E+00,-0.96227E-01,-0.92215E-01,-0.88157E-01,-0.84053E-01,&
     -0.79905E-01,-0.75715E-01,-0.71483E-01,-0.67210E-01,-0.62899E-01,&
     -0.58548E-01,-0.54161E-01,-0.49736E-01,-0.45274E-01,-0.40777E-01,&
     -0.36244E-01,-0.31676E-01,-0.27073E-01,-0.22436E-01,-0.17763E-01,&
     -0.13056E-01,-0.83143E-02,-0.35376E-02, 0.12738E-02, 0.61202E-02,&
      0.11002E-01, 0.15919E-01, 0.20871E-01, 0.25859E-01, 0.30883E-01,&
      0.35942E-01, 0.41038E-01, 0.46170E-01, 0.51337E-01, 0.56541E-01,&
      0.61781E-01, 0.67057E-01, 0.72367E-01, 0.77714E-01, 0.83095E-01,&
      0.88511E-01, 0.93961E-01, 0.99444E-01, 0.10496E+00, 0.11051E+00,&
      0.11609E+00, 0.12170E+00, 0.12733E+00, 0.13300E+00, 0.13870E+00/
                             
     DATA (BNC12M (IA),IA=101,200)/                                     &
      0.14442E+00, 0.15016E+00, 0.15593E+00, 0.16173E+00, 0.16754E+00,&
      0.17337E+00, 0.17923E+00, 0.18510E+00, 0.19099E+00, 0.19689E+00,&
      0.20280E+00, 0.20873E+00, 0.21467E+00, 0.22062E+00, 0.22658E+00,&
      0.23255E+00, 0.23852E+00, 0.24450E+00, 0.25048E+00, 0.25647E+00,&
      0.26188E+00, 0.26794E+00, 0.27399E+00, 0.28003E+00, 0.28607E+00,&
      0.29209E+00, 0.29812E+00, 0.30413E+00, 0.31014E+00, 0.31613E+00,&
      0.32212E+00, 0.32811E+00, 0.33408E+00, 0.34004E+00, 0.34600E+00,&
      0.35194E+00, 0.35788E+00, 0.36380E+00, 0.36972E+00, 0.37562E+00,&
      0.38152E+00, 0.38740E+00, 0.39328E+00, 0.39914E+00, 0.40500E+00,&
      0.41084E+00, 0.41667E+00, 0.42249E+00, 0.42830E+00, 0.43410E+00,&
      0.43989E+00, 0.44567E+00, 0.45143E+00, 0.45719E+00, 0.46293E+00,&
      0.46866E+00, 0.47438E+00, 0.48008E+00, 0.48578E+00, 0.49146E+00,&
      0.49713E+00, 0.50279E+00, 0.50844E+00, 0.51408E+00, 0.51970E+00,&
      0.52531E+00, 0.53091E+00, 0.53650E+00, 0.54208E+00, 0.54764E+00,&
      0.55319E+00, 0.55873E+00, 0.56426E+00, 0.56978E+00, 0.57528E+00,&
      0.58077E+00, 0.58625E+00, 0.59172E+00, 0.59717E+00, 0.60261E+00,&
      0.60804E+00, 0.61346E+00, 0.61887E+00, 0.62426E+00, 0.62965E+00,&
      0.63502E+00, 0.64038E+00, 0.64572E+00, 0.65106E+00, 0.65638E+00,&
      0.66169E+00, 0.66699E+00, 0.67227E+00, 0.67755E+00, 0.68281E+00,&
      0.68806E+00, 0.69330E+00, 0.69853E+00, 0.70375E+00, 0.70895E+00/
                             
     DATA (BNC12M (IA),IA=201,300)/                                     &
      0.71414E+00, 0.71932E+00, 0.72449E+00, 0.72965E+00, 0.73479E+00,&
      0.73993E+00, 0.74505E+00, 0.75016E+00, 0.75526E+00, 0.76035E+00,&
      0.76543E+00, 0.77049E+00, 0.77554E+00, 0.78059E+00, 0.78562E+00,&
      0.79064E+00, 0.79565E+00, 0.80064E+00, 0.80563E+00, 0.81061E+00,&
      0.81557E+00, 0.82052E+00, 0.82547E+00, 0.83040E+00, 0.83532E+00,&
      0.84023E+00, 0.84512E+00, 0.85001E+00, 0.85489E+00, 0.85975E+00,&
      0.86461E+00, 0.86945E+00, 0.87429E+00, 0.87911E+00, 0.88392E+00,&
      0.88873E+00, 0.89352E+00, 0.89830E+00, 0.90307E+00, 0.90783E+00,&
      0.91258E+00, 0.91732E+00, 0.92205E+00, 0.92677E+00, 0.93148E+00,&
      0.93617E+00, 0.94086E+00, 0.94554E+00, 0.95021E+00, 0.95487E+00,&
      0.95951E+00, 0.96415E+00, 0.96878E+00, 0.97340E+00, 0.97801E+00,&
      0.98260E+00, 0.98719E+00, 0.99177E+00, 0.99634E+00, 0.10009E+01,&
      0.10054E+01, 0.10100E+01, 0.10145E+01, 0.10190E+01, 0.10235E+01,&
      0.10281E+01, 0.10325E+01, 0.10370E+01, 0.10415E+01, 0.10460E+01,&
      0.10504E+01, 0.10549E+01, 0.10593E+01, 0.10637E+01, 0.10681E+01,&
      0.10725E+01, 0.10769E+01, 0.10813E+01, 0.10857E+01, 0.10901E+01,&
      0.10945E+01, 0.10988E+01, 0.11031E+01, 0.11075E+01, 0.11118E+01,&
      0.11161E+01, 0.11204E+01, 0.11247E+01, 0.11290E+01, 0.11333E+01,&
      0.11376E+01, 0.11419E+01, 0.11461E+01, 0.11504E+01, 0.11546E+01,&
      0.11588E+01, 0.11631E+01, 0.11673E+01, 0.11715E+01, 0.11757E+01/
                             
     DATA (BNC12M (IA),IA=301,400)/                                     &
      0.11799E+01, 0.11840E+01, 0.11882E+01, 0.11924E+01, 0.11965E+01,&
      0.12007E+01, 0.12048E+01, 0.12089E+01, 0.12131E+01, 0.12172E+01,&
      0.12213E+01, 0.12254E+01, 0.12295E+01, 0.12336E+01, 0.12376E+01,&
      0.12417E+01, 0.12457E+01, 0.12498E+01, 0.12538E+01, 0.12579E+01,&
      0.12619E+01, 0.12659E+01, 0.12699E+01, 0.12739E+01, 0.12779E+01,&
      0.12819E+01, 0.12859E+01, 0.12899E+01, 0.12938E+01, 0.12978E+01,&
      0.13017E+01, 0.13057E+01, 0.13096E+01, 0.13135E+01, 0.13175E+01,&
      0.13214E+01, 0.13253E+01, 0.13292E+01, 0.13331E+01, 0.13369E+01,&
      0.13408E+01, 0.13447E+01, 0.13485E+01, 0.13524E+01, 0.13562E+01,&
      0.13601E+01, 0.13639E+01, 0.13677E+01, 0.13715E+01, 0.13754E+01,&
      0.13792E+01, 0.13829E+01, 0.13867E+01, 0.13905E+01, 0.13943E+01,&
      0.13981E+01, 0.14018E+01, 0.14056E+01, 0.14093E+01, 0.14131E+01,&
      0.14168E+01, 0.14205E+01, 0.14242E+01, 0.14279E+01, 0.14316E+01,&
      0.14353E+01, 0.14390E+01, 0.14427E+01, 0.14464E+01, 0.14501E+01,&
      0.14537E+01, 0.14574E+01, 0.14610E+01, 0.14647E+01, 0.14683E+01,&
      0.14720E+01, 0.14756E+01, 0.14792E+01, 0.14828E+01, 0.14864E+01,&
      0.14900E+01, 0.14936E+01, 0.14972E+01, 0.15008E+01, 0.15043E+01,&
      0.15079E+01, 0.15115E+01, 0.15150E+01, 0.15186E+01, 0.15221E+01,&
      0.15256E+01, 0.15292E+01, 0.15327E+01, 0.15362E+01, 0.15397E+01,&
      0.15432E+01, 0.15467E+01, 0.15502E+01, 0.15537E+01, 0.15572E+01/
                             
     DATA (BNC12M (IA),IA=401,500)/                                     &
      0.15607E+01, 0.15641E+01, 0.15676E+01, 0.15710E+01, 0.15745E+01,&
      0.15779E+01, 0.15814E+01, 0.15848E+01, 0.15882E+01, 0.15916E+01,&
      0.15951E+01, 0.15985E+01, 0.16019E+01, 0.16053E+01, 0.16087E+01,&
      0.16120E+01, 0.16154E+01, 0.16188E+01, 0.16222E+01, 0.16255E+01,&
      0.16289E+01, 0.16322E+01, 0.16356E+01, 0.16389E+01, 0.16422E+01,&
      0.16456E+01, 0.16489E+01, 0.16522E+01, 0.16555E+01, 0.16588E+01,&
      0.16621E+01, 0.16654E+01, 0.16687E+01, 0.16720E+01, 0.16753E+01,&
      0.16785E+01, 0.16818E+01, 0.16850E+01, 0.16883E+01, 0.16916E+01,&
      0.16948E+01, 0.16980E+01, 0.17013E+01, 0.17045E+01, 0.17077E+01,&
      0.17109E+01, 0.17142E+01, 0.17174E+01, 0.17206E+01, 0.17238E+01,&
      0.17269E+01, 0.17301E+01, 0.17333E+01, 0.17365E+01, 0.17397E+01,&
      0.17428E+01, 0.17460E+01, 0.17491E+01, 0.17523E+01, 0.17554E+01,&
      0.17586E+01, 0.17617E+01, 0.17648E+01, 0.17680E+01, 0.17711E+01,&
      0.17742E+01, 0.17773E+01, 0.17804E+01, 0.17835E+01, 0.17866E+01,&
      0.17897E+01, 0.17928E+01, 0.17958E+01, 0.17989E+01, 0.18020E+01,&
      0.18050E+01, 0.18081E+01, 0.18112E+01, 0.18142E+01, 0.18173E+01,&
      0.18203E+01, 0.18233E+01, 0.18264E+01, 0.18294E+01, 0.18324E+01,&
      0.18354E+01, 0.18384E+01, 0.18414E+01, 0.18444E+01, 0.18474E+01,&
      0.18504E+01, 0.18534E+01, 0.18564E+01, 0.18594E+01, 0.18623E+01,&
      0.18653E+01, 0.18683E+01, 0.18712E+01, 0.18742E+01, 0.18771E+01/
                             
     DATA (BNC12M (IA),IA=501,600)/                                     &
      0.18801E+01, 0.18830E+01, 0.18860E+01, 0.18889E+01, 0.18918E+01,&
      0.18947E+01, 0.18977E+01, 0.19006E+01, 0.19035E+01, 0.19064E+01,&
      0.19093E+01, 0.19122E+01, 0.19151E+01, 0.19180E+01, 0.19209E+01,&
      0.19237E+01, 0.19266E+01, 0.19295E+01, 0.19323E+01, 0.19352E+01,&
      0.19381E+01, 0.19409E+01, 0.19438E+01, 0.19466E+01, 0.19494E+01,&
      0.19523E+01, 0.19551E+01, 0.19579E+01, 0.19607E+01, 0.19636E+01,&
      0.19664E+01, 0.19692E+01, 0.19720E+01, 0.19748E+01, 0.19776E+01,&
      0.19804E+01, 0.19832E+01, 0.19860E+01, 0.19887E+01, 0.19915E+01,&
      0.19943E+01, 0.19970E+01, 0.19998E+01, 0.20026E+01, 0.20053E+01,&
      0.20081E+01, 0.20108E+01, 0.20136E+01, 0.20163E+01, 0.20190E+01,&
      0.20218E+01, 0.20245E+01, 0.20272E+01, 0.20299E+01, 0.20327E+01,&
      0.20354E+01, 0.20381E+01, 0.20408E+01, 0.20435E+01, 0.20462E+01,&
      0.20489E+01, 0.20515E+01, 0.20542E+01, 0.20569E+01, 0.20596E+01,&
      0.20622E+01, 0.20649E+01, 0.20676E+01, 0.20702E+01, 0.20729E+01,&
      0.20755E+01, 0.20782E+01, 0.20808E+01, 0.20835E+01, 0.20861E+01,&
      0.20887E+01, 0.20914E+01, 0.20940E+01, 0.20966E+01, 0.20992E+01,&
      0.21019E+01, 0.21045E+01, 0.21071E+01, 0.21097E+01, 0.21123E+01,&
      0.21149E+01, 0.21175E+01, 0.21200E+01, 0.21226E+01, 0.21252E+01,&
      0.21278E+01, 0.21304E+01, 0.21329E+01, 0.21355E+01, 0.21381E+01,&
      0.21406E+01, 0.21432E+01, 0.21457E+01, 0.21483E+01, 0.21578E+01/
                             
     DATA (BNC12M (IA),IA=601,700)/                                     &
      0.21786E+01, 0.22034E+01, 0.22280E+01, 0.22522E+01, 0.22760E+01,&
      0.22996E+01, 0.23228E+01, 0.23457E+01, 0.23684E+01, 0.23907E+01,&
      0.24128E+01, 0.24345E+01, 0.24560E+01, 0.24773E+01, 0.24982E+01,&
      0.25190E+01, 0.25394E+01, 0.25596E+01, 0.25796E+01, 0.25993E+01,&
      0.26188E+01, 0.26381E+01, 0.26571E+01, 0.26760E+01, 0.26946E+01,&
      0.27130E+01, 0.27312E+01, 0.27491E+01, 0.27669E+01, 0.27845E+01,&
      0.28019E+01, 0.28191E+01, 0.28361E+01, 0.28529E+01, 0.28696E+01,&
      0.28860E+01, 0.29023E+01, 0.29185E+01, 0.29344E+01, 0.29502E+01,&
      0.29658E+01, 0.29813E+01, 0.29966E+01, 0.30117E+01, 0.30267E+01,&
      0.30415E+01, 0.30562E+01, 0.30708E+01, 0.30852E+01, 0.30994E+01,&
      0.31136E+01, 0.31275E+01, 0.31414E+01, 0.31551E+01, 0.31687E+01,&
      0.31821E+01, 0.31954E+01, 0.32086E+01, 0.32217E+01, 0.32346E+01,&
      0.32474E+01, 0.32601E+01, 0.32727E+01, 0.32852E+01, 0.32976E+01,&
      0.33098E+01, 0.33219E+01, 0.33339E+01, 0.33459E+01, 0.33577E+01,&
      0.33694E+01, 0.33810E+01, 0.33924E+01, 0.34038E+01, 0.34151E+01,&
      0.34263E+01, 0.34374E+01, 0.34484E+01, 0.34593E+01, 0.34701E+01,&
      0.34808E+01, 0.34914E+01, 0.35020E+01, 0.35124E+01, 0.35228E+01,&
      0.35330E+01, 0.35432E+01, 0.35533E+01, 0.35633E+01, 0.35732E+01,&
      0.35831E+01, 0.35928E+01, 0.36025E+01, 0.36121E+01, 0.36216E+01,&
      0.36311E+01, 0.36405E+01, 0.36497E+01, 0.36590E+01, 0.36681E+01/
                             
     DATA (BNC12M(IA),IA=701,741)/                                      &
      0.36772E+01, 0.36862E+01, 0.36951E+01, 0.37039E+01, 0.37127E+01,&
      0.37214E+01, 0.37301E+01, 0.37386E+01, 0.37472E+01, 0.37556E+01,&
      0.37640E+01, 0.37723E+01, 0.37805E+01, 0.37887E+01, 0.37968E+01,&
      0.38049E+01, 0.38129E+01, 0.38208E+01, 0.38287E+01, 0.38365E+01,&
      0.38442E+01, 0.38519E+01, 0.38595E+01, 0.38671E+01, 0.38746E+01,&
      0.38821E+01, 0.38895E+01, 0.38968E+01, 0.39041E+01, 0.39114E+01,&
      0.39186E+01, 0.39257E+01, 0.39328E+01, 0.39398E+01, 0.39468E+01,&
      0.39537E+01, 0.39606E+01, 0.39674E+01, 0.39742E+01, 0.39809E+01,&
      0.39875E+01                  /                      
!                            
!  ** (NH4)3H(SO4)2          
!                            
     DATA (BNC13M (IA),IA=  1,100)/                                     &
     -0.88457E-01,-0.16130E+00,-0.21283E+00,-0.24810E+00,-0.27543E+00,&
     -0.29791E+00,-0.31709E+00,-0.33386E+00,-0.34878E+00,-0.36223E+00,&
     -0.37448E+00,-0.38573E+00,-0.39614E+00,-0.40581E+00,-0.41486E+00,&
     -0.42335E+00,-0.43134E+00,-0.43890E+00,-0.44605E+00,-0.45284E+00,&
     -0.45930E+00,-0.46546E+00,-0.47134E+00,-0.47696E+00,-0.48234E+00,&
     -0.48749E+00,-0.49244E+00,-0.49719E+00,-0.50176E+00,-0.50615E+00,&
     -0.51038E+00,-0.51445E+00,-0.51838E+00,-0.52217E+00,-0.52582E+00,&
     -0.52935E+00,-0.53275E+00,-0.53604E+00,-0.53922E+00,-0.54230E+00,&
     -0.54527E+00,-0.54815E+00,-0.55093E+00,-0.55362E+00,-0.55622E+00,&
     -0.55875E+00,-0.56119E+00,-0.56356E+00,-0.56585E+00,-0.56807E+00,&
     -0.57023E+00,-0.57231E+00,-0.57434E+00,-0.57630E+00,-0.57820E+00,&
     -0.58005E+00,-0.58183E+00,-0.58357E+00,-0.58525E+00,-0.58689E+00,&
     -0.58847E+00,-0.59001E+00,-0.59151E+00,-0.59295E+00,-0.59436E+00,&
     -0.59573E+00,-0.59705E+00,-0.59834E+00,-0.59958E+00,-0.60079E+00,&
     -0.60197E+00,-0.60311E+00,-0.60421E+00,-0.60529E+00,-0.60633E+00,&
     -0.60734E+00,-0.60831E+00,-0.60926E+00,-0.61018E+00,-0.61107E+00,&
     -0.61193E+00,-0.61276E+00,-0.61356E+00,-0.61434E+00,-0.61509E+00,&
     -0.61582E+00,-0.61652E+00,-0.61720E+00,-0.61786E+00,-0.61849E+00,&
     -0.61909E+00,-0.61968E+00,-0.62024E+00,-0.62078E+00,-0.62130E+00,&
     -0.62180E+00,-0.62229E+00,-0.62275E+00,-0.62319E+00,-0.62361E+00/
                             
     DATA (BNC13M (IA),IA=101,200)/                                     &
     -0.62402E+00,-0.62441E+00,-0.62478E+00,-0.62514E+00,-0.62548E+00,&
     -0.62581E+00,-0.62612E+00,-0.62642E+00,-0.62670E+00,-0.62697E+00,&
     -0.62723E+00,-0.62748E+00,-0.62771E+00,-0.62793E+00,-0.62815E+00,&
     -0.62835E+00,-0.62854E+00,-0.62873E+00,-0.62890E+00,-0.62907E+00,&
     -0.62933E+00,-0.62947E+00,-0.62960E+00,-0.62973E+00,-0.62984E+00,&
     -0.62996E+00,-0.63006E+00,-0.63017E+00,-0.63026E+00,-0.63036E+00,&
     -0.63045E+00,-0.63053E+00,-0.63061E+00,-0.63068E+00,-0.63075E+00,&
     -0.63082E+00,-0.63089E+00,-0.63095E+00,-0.63100E+00,-0.63106E+00,&
     -0.63111E+00,-0.63116E+00,-0.63120E+00,-0.63125E+00,-0.63129E+00,&
     -0.63132E+00,-0.63136E+00,-0.63139E+00,-0.63142E+00,-0.63145E+00,&
     -0.63148E+00,-0.63150E+00,-0.63153E+00,-0.63155E+00,-0.63157E+00,&
     -0.63159E+00,-0.63160E+00,-0.63162E+00,-0.63163E+00,-0.63165E+00,&
     -0.63166E+00,-0.63167E+00,-0.63168E+00,-0.63169E+00,-0.63169E+00,&
     -0.63170E+00,-0.63171E+00,-0.63171E+00,-0.63172E+00,-0.63172E+00,&
     -0.63173E+00,-0.63173E+00,-0.63173E+00,-0.63173E+00,-0.63173E+00,&
     -0.63174E+00,-0.63174E+00,-0.63174E+00,-0.63174E+00,-0.63174E+00,&
     -0.63174E+00,-0.63174E+00,-0.63174E+00,-0.63174E+00,-0.63174E+00,&
     -0.63173E+00,-0.63173E+00,-0.63173E+00,-0.63173E+00,-0.63173E+00,&
     -0.63173E+00,-0.63173E+00,-0.63173E+00,-0.63173E+00,-0.63173E+00,&
     -0.63173E+00,-0.63173E+00,-0.63174E+00,-0.63174E+00,-0.63174E+00/
                             
     DATA (BNC13M (IA),IA=201,300)/                                     &
     -0.63174E+00,-0.63174E+00,-0.63174E+00,-0.63175E+00,-0.63175E+00,&
     -0.63176E+00,-0.63176E+00,-0.63176E+00,-0.63177E+00,-0.63177E+00,&
     -0.63178E+00,-0.63179E+00,-0.63179E+00,-0.63180E+00,-0.63181E+00,&
     -0.63182E+00,-0.63183E+00,-0.63184E+00,-0.63185E+00,-0.63186E+00,&
     -0.63187E+00,-0.63188E+00,-0.63189E+00,-0.63191E+00,-0.63192E+00,&
     -0.63193E+00,-0.63195E+00,-0.63197E+00,-0.63198E+00,-0.63200E+00,&
     -0.63202E+00,-0.63203E+00,-0.63205E+00,-0.63207E+00,-0.63209E+00,&
     -0.63211E+00,-0.63214E+00,-0.63216E+00,-0.63218E+00,-0.63221E+00,&
     -0.63223E+00,-0.63225E+00,-0.63228E+00,-0.63231E+00,-0.63233E+00,&
     -0.63236E+00,-0.63239E+00,-0.63242E+00,-0.63245E+00,-0.63248E+00,&
     -0.63251E+00,-0.63255E+00,-0.63258E+00,-0.63261E+00,-0.63265E+00,&
     -0.63268E+00,-0.63272E+00,-0.63276E+00,-0.63280E+00,-0.63283E+00,&
     -0.63287E+00,-0.63291E+00,-0.63296E+00,-0.63300E+00,-0.63304E+00,&
     -0.63308E+00,-0.63313E+00,-0.63317E+00,-0.63322E+00,-0.63326E+00,&
     -0.63331E+00,-0.63336E+00,-0.63341E+00,-0.63346E+00,-0.63351E+00,&
     -0.63356E+00,-0.63361E+00,-0.63366E+00,-0.63372E+00,-0.63377E+00,&
     -0.63383E+00,-0.63388E+00,-0.63394E+00,-0.63400E+00,-0.63406E+00,&
     -0.63411E+00,-0.63417E+00,-0.63424E+00,-0.63430E+00,-0.63436E+00,&
     -0.63442E+00,-0.63449E+00,-0.63455E+00,-0.63462E+00,-0.63468E+00,&
     -0.63475E+00,-0.63482E+00,-0.63489E+00,-0.63496E+00,-0.63503E+00/
                             
     DATA (BNC13M (IA),IA=301,400)/                                     &
     -0.63510E+00,-0.63517E+00,-0.63524E+00,-0.63531E+00,-0.63539E+00,&
     -0.63546E+00,-0.63554E+00,-0.63562E+00,-0.63569E+00,-0.63577E+00,&
     -0.63585E+00,-0.63593E+00,-0.63601E+00,-0.63609E+00,-0.63617E+00,&
     -0.63626E+00,-0.63634E+00,-0.63643E+00,-0.63651E+00,-0.63660E+00,&
     -0.63668E+00,-0.63677E+00,-0.63686E+00,-0.63695E+00,-0.63704E+00,&
     -0.63713E+00,-0.63722E+00,-0.63731E+00,-0.63741E+00,-0.63750E+00,&
     -0.63759E+00,-0.63769E+00,-0.63779E+00,-0.63788E+00,-0.63798E+00,&
     -0.63808E+00,-0.63818E+00,-0.63828E+00,-0.63838E+00,-0.63848E+00,&
     -0.63858E+00,-0.63869E+00,-0.63879E+00,-0.63889E+00,-0.63900E+00,&
     -0.63911E+00,-0.63921E+00,-0.63932E+00,-0.63943E+00,-0.63954E+00,&
     -0.63965E+00,-0.63976E+00,-0.63987E+00,-0.63998E+00,-0.64009E+00,&
     -0.64021E+00,-0.64032E+00,-0.64044E+00,-0.64055E+00,-0.64067E+00,&
     -0.64079E+00,-0.64090E+00,-0.64102E+00,-0.64114E+00,-0.64126E+00,&
     -0.64138E+00,-0.64150E+00,-0.64163E+00,-0.64175E+00,-0.64187E+00,&
     -0.64200E+00,-0.64212E+00,-0.64225E+00,-0.64238E+00,-0.64250E+00,&
     -0.64263E+00,-0.64276E+00,-0.64289E+00,-0.64302E+00,-0.64315E+00,&
     -0.64328E+00,-0.64342E+00,-0.64355E+00,-0.64368E+00,-0.64382E+00,&
     -0.64395E+00,-0.64409E+00,-0.64423E+00,-0.64436E+00,-0.64450E+00,&
     -0.64464E+00,-0.64478E+00,-0.64492E+00,-0.64506E+00,-0.64520E+00,&
     -0.64534E+00,-0.64549E+00,-0.64563E+00,-0.64578E+00,-0.64592E+00/
                             
     DATA (BNC13M (IA),IA=401,500)/                                     &
     -0.64607E+00,-0.64621E+00,-0.64636E+00,-0.64651E+00,-0.64666E+00,&
     -0.64681E+00,-0.64696E+00,-0.64711E+00,-0.64726E+00,-0.64741E+00,&
     -0.64756E+00,-0.64772E+00,-0.64787E+00,-0.64802E+00,-0.64818E+00,&
     -0.64833E+00,-0.64849E+00,-0.64865E+00,-0.64881E+00,-0.64897E+00,&
     -0.64912E+00,-0.64928E+00,-0.64944E+00,-0.64961E+00,-0.64977E+00,&
     -0.64993E+00,-0.65009E+00,-0.65026E+00,-0.65042E+00,-0.65059E+00,&
     -0.65075E+00,-0.65092E+00,-0.65109E+00,-0.65125E+00,-0.65142E+00,&
     -0.65159E+00,-0.65176E+00,-0.65193E+00,-0.65210E+00,-0.65227E+00,&
     -0.65245E+00,-0.65262E+00,-0.65279E+00,-0.65297E+00,-0.65314E+00,&
     -0.65332E+00,-0.65349E+00,-0.65367E+00,-0.65385E+00,-0.65402E+00,&
     -0.65420E+00,-0.65438E+00,-0.65456E+00,-0.65474E+00,-0.65492E+00,&
     -0.65510E+00,-0.65529E+00,-0.65547E+00,-0.65565E+00,-0.65584E+00,&
     -0.65602E+00,-0.65621E+00,-0.65639E+00,-0.65658E+00,-0.65677E+00,&
     -0.65695E+00,-0.65714E+00,-0.65733E+00,-0.65752E+00,-0.65771E+00,&
     -0.65790E+00,-0.65809E+00,-0.65828E+00,-0.65848E+00,-0.65867E+00,&
     -0.65886E+00,-0.65906E+00,-0.65925E+00,-0.65945E+00,-0.65964E+00,&
     -0.65984E+00,-0.66004E+00,-0.66024E+00,-0.66043E+00,-0.66063E+00,&
     -0.66083E+00,-0.66103E+00,-0.66123E+00,-0.66143E+00,-0.66164E+00,&
     -0.66184E+00,-0.66204E+00,-0.66225E+00,-0.66245E+00,-0.66265E+00,&
     -0.66286E+00,-0.66307E+00,-0.66327E+00,-0.66348E+00,-0.66369E+00/
                             
     DATA (BNC13M (IA),IA=501,600)/                                     &
     -0.66389E+00,-0.66410E+00,-0.66431E+00,-0.66452E+00,-0.66473E+00,&
     -0.66494E+00,-0.66515E+00,-0.66537E+00,-0.66558E+00,-0.66579E+00,&
     -0.66601E+00,-0.66622E+00,-0.66643E+00,-0.66665E+00,-0.66687E+00,&
     -0.66708E+00,-0.66730E+00,-0.66752E+00,-0.66773E+00,-0.66795E+00,&
     -0.66817E+00,-0.66839E+00,-0.66861E+00,-0.66883E+00,-0.66905E+00,&
     -0.66928E+00,-0.66950E+00,-0.66972E+00,-0.66994E+00,-0.67017E+00,&
     -0.67039E+00,-0.67062E+00,-0.67084E+00,-0.67107E+00,-0.67130E+00,&
     -0.67152E+00,-0.67175E+00,-0.67198E+00,-0.67221E+00,-0.67244E+00,&
     -0.67267E+00,-0.67290E+00,-0.67313E+00,-0.67336E+00,-0.67359E+00,&
     -0.67382E+00,-0.67406E+00,-0.67429E+00,-0.67452E+00,-0.67476E+00,&
     -0.67499E+00,-0.67523E+00,-0.67546E+00,-0.67570E+00,-0.67594E+00,&
     -0.67617E+00,-0.67641E+00,-0.67665E+00,-0.67689E+00,-0.67713E+00,&
     -0.67737E+00,-0.67761E+00,-0.67785E+00,-0.67809E+00,-0.67833E+00,&
     -0.67857E+00,-0.67882E+00,-0.67906E+00,-0.67931E+00,-0.67955E+00,&
     -0.67979E+00,-0.68004E+00,-0.68029E+00,-0.68053E+00,-0.68078E+00,&
     -0.68103E+00,-0.68127E+00,-0.68152E+00,-0.68177E+00,-0.68202E+00,&
     -0.68227E+00,-0.68252E+00,-0.68277E+00,-0.68302E+00,-0.68327E+00,&
     -0.68352E+00,-0.68378E+00,-0.68403E+00,-0.68428E+00,-0.68454E+00,&
     -0.68479E+00,-0.68505E+00,-0.68530E+00,-0.68556E+00,-0.68581E+00,&
     -0.68607E+00,-0.68633E+00,-0.68659E+00,-0.68684E+00,-0.68782E+00/
 
 

     DATA (BNC13M (IA),IA=601,700)/                                     &
     -0.68998E+00,-0.69264E+00,-0.69534E+00,-0.69809E+00,-0.70088E+00,&
     -0.70371E+00,-0.70659E+00,-0.70950E+00,-0.71245E+00,-0.71544E+00,&
     -0.71847E+00,-0.72154E+00,-0.72464E+00,-0.72778E+00,-0.73095E+00,&
     -0.73416E+00,-0.73741E+00,-0.74068E+00,-0.74399E+00,-0.74733E+00,&
     -0.75070E+00,-0.75411E+00,-0.75754E+00,-0.76101E+00,-0.76450E+00,&
     -0.76802E+00,-0.77157E+00,-0.77515E+00,-0.77876E+00,-0.78239E+00,&
     -0.78605E+00,-0.78974E+00,-0.79345E+00,-0.79719E+00,-0.80095E+00,&
     -0.80474E+00,-0.80855E+00,-0.81239E+00,-0.81625E+00,-0.82013E+00,&
     -0.82403E+00,-0.82796E+00,-0.83191E+00,-0.83588E+00,-0.83987E+00,&
     -0.84388E+00,-0.84792E+00,-0.85197E+00,-0.85604E+00,-0.86014E+00,&
     -0.86425E+00,-0.86838E+00,-0.87253E+00,-0.87670E+00,-0.88089E+00,&
     -0.88510E+00,-0.88932E+00,-0.89356E+00,-0.89782E+00,-0.90210E+00,&
     -0.90639E+00,-0.91070E+00,-0.91503E+00,-0.91937E+00,-0.92373E+00,&
     -0.92811E+00,-0.93250E+00,-0.93690E+00,-0.94132E+00,-0.94576E+00,&
     -0.95021E+00,-0.95467E+00,-0.95915E+00,-0.96365E+00,-0.96815E+00,&
     -0.97267E+00,-0.97721E+00,-0.98176E+00,-0.98632E+00,-0.99089E+00,&
     -0.99548E+00,-0.10001E+01,-0.10047E+01,-0.10093E+01,-0.10140E+01,&
     -0.10186E+01,-0.10233E+01,-0.10279E+01,-0.10326E+01,-0.10373E+01,&
     -0.10420E+01,-0.10468E+01,-0.10515E+01,-0.10562E+01,-0.10610E+01,&
     -0.10657E+01,-0.10705E+01,-0.10753E+01,-0.10801E+01,-0.10849E+01/
                             
     DATA (BNC13M(IA),IA=701,741)/                                      &
     -0.10897E+01,-0.10945E+01,-0.10994E+01,-0.11042E+01,-0.11091E+01,&
     -0.11139E+01,-0.11188E+01,-0.11237E+01,-0.11286E+01,-0.11335E+01,&
     -0.11384E+01,-0.11433E+01,-0.11483E+01,-0.11532E+01,-0.11582E+01,&
     -0.11631E+01,-0.11681E+01,-0.11730E+01,-0.11780E+01,-0.11830E+01,&
     -0.11880E+01,-0.11930E+01,-0.11980E+01,-0.12031E+01,-0.12081E+01,&
     -0.12131E+01,-0.12182E+01,-0.12232E+01,-0.12283E+01,-0.12333E+01,&
     -0.12384E+01,-0.12435E+01,-0.12486E+01,-0.12537E+01,-0.12588E+01,&
     -0.12639E+01,-0.12690E+01,-0.12741E+01,-0.12793E+01,-0.12844E+01,&
     -0.12896E+01                  /                      
!     END                     
                             
!  ** TEMP = 248.0           
                             
!     BLOCK DATA KMCF248      
!                            
!  ** Common block definition
!                            
!     COMMON /KMC248/                                                  &
!     BNC01M(  741),BNC02M(  741),BNC03M(  741),BNC04M(  741),         &
!     BNC05M(  741),BNC06M(  741),BNC07M(  741),BNC08M(  741),         &
!     BNC09M(  741),BNC10M(  741),BNC11M(  741),BNC12M(  741),         &
 !    BNC13M(  741)           
!                            
!  ** NaCl                   
!                            
     DATA (BNC01M (IA),IA=  1,100)/                                     &
     -0.52363E-01,-0.92329E-01,-0.11821E+00,-0.13443E+00,-0.14598E+00,&
     -0.15471E+00,-0.16154E+00,-0.16698E+00,-0.17138E+00,-0.17496E+00,&
     -0.17787E+00,-0.18024E+00,-0.18214E+00,-0.18366E+00,-0.18484E+00,&
     -0.18573E+00,-0.18637E+00,-0.18679E+00,-0.18701E+00,-0.18706E+00,&
     -0.18695E+00,-0.18669E+00,-0.18632E+00,-0.18583E+00,-0.18523E+00,&
     -0.18454E+00,-0.18377E+00,-0.18292E+00,-0.18200E+00,-0.18102E+00,&
     -0.17998E+00,-0.17889E+00,-0.17775E+00,-0.17657E+00,-0.17535E+00,&
     -0.17409E+00,-0.17280E+00,-0.17147E+00,-0.17013E+00,-0.16876E+00,&
     -0.16736E+00,-0.16595E+00,-0.16452E+00,-0.16307E+00,-0.16161E+00,&
     -0.16013E+00,-0.15865E+00,-0.15715E+00,-0.15565E+00,-0.15413E+00,&
     -0.15261E+00,-0.15108E+00,-0.14954E+00,-0.14800E+00,-0.14645E+00,&
     -0.14490E+00,-0.14334E+00,-0.14178E+00,-0.14021E+00,-0.13864E+00,&
     -0.13706E+00,-0.13548E+00,-0.13389E+00,-0.13229E+00,-0.13069E+00,&
     -0.12909E+00,-0.12747E+00,-0.12585E+00,-0.12422E+00,-0.12258E+00,&
     -0.12094E+00,-0.11928E+00,-0.11762E+00,-0.11594E+00,-0.11426E+00,&
     -0.11256E+00,-0.11085E+00,-0.10913E+00,-0.10740E+00,-0.10565E+00,&
     -0.10389E+00,-0.10212E+00,-0.10033E+00,-0.98525E-01,-0.96708E-01,&
     -0.94877E-01,-0.93031E-01,-0.91169E-01,-0.89293E-01,-0.87402E-01,&
     -0.85495E-01,-0.83574E-01,-0.81638E-01,-0.79687E-01,-0.77722E-01,&
     -0.75743E-01,-0.73749E-01,-0.71742E-01,-0.69722E-01,-0.67689E-01/
                             
     DATA (BNC01M (IA),IA=101,200)/                                     &
     -0.65644E-01,-0.63586E-01,-0.61517E-01,-0.59436E-01,-0.57345E-01,&
     -0.55244E-01,-0.53133E-01,-0.51013E-01,-0.48884E-01,-0.46747E-01,&
     -0.44603E-01,-0.42451E-01,-0.40292E-01,-0.38127E-01,-0.35957E-01,&
     -0.33781E-01,-0.31601E-01,-0.29416E-01,-0.27227E-01,-0.25035E-01,&
     -0.23114E-01,-0.20884E-01,-0.18655E-01,-0.16426E-01,-0.14199E-01,&
     -0.11973E-01,-0.97477E-02,-0.75237E-02,-0.53010E-02,-0.30795E-02,&
     -0.85942E-03, 0.13593E-02, 0.35765E-02, 0.57922E-02, 0.80063E-02,&
      0.10219E-01, 0.12430E-01, 0.14638E-01, 0.16846E-01, 0.19051E-01,&
      0.21255E-01, 0.23456E-01, 0.25656E-01, 0.27853E-01, 0.30049E-01,&
      0.32242E-01, 0.34434E-01, 0.36623E-01, 0.38810E-01, 0.40994E-01,&
      0.43177E-01, 0.45357E-01, 0.47535E-01, 0.49710E-01, 0.51883E-01,&
      0.54053E-01, 0.56221E-01, 0.58387E-01, 0.60550E-01, 0.62710E-01,&
      0.64868E-01, 0.67024E-01, 0.69176E-01, 0.71326E-01, 0.73474E-01,&
      0.75618E-01, 0.77760E-01, 0.79899E-01, 0.82036E-01, 0.84169E-01,&
      0.86300E-01, 0.88428E-01, 0.90554E-01, 0.92676E-01, 0.94796E-01,&
      0.96912E-01, 0.99026E-01, 0.10114E+00, 0.10324E+00, 0.10535E+00,&
      0.10745E+00, 0.10955E+00, 0.11165E+00, 0.11374E+00, 0.11583E+00,&
      0.11792E+00, 0.12000E+00, 0.12208E+00, 0.12416E+00, 0.12624E+00,&
      0.12831E+00, 0.13038E+00, 0.13244E+00, 0.13450E+00, 0.13656E+00,&
      0.13862E+00, 0.14067E+00, 0.14272E+00, 0.14477E+00, 0.14681E+00/
                             
     DATA (BNC01M (IA),IA=201,300)/                                     &
      0.14886E+00, 0.15089E+00, 0.15293E+00, 0.15496E+00, 0.15699E+00,&
      0.15901E+00, 0.16103E+00, 0.16305E+00, 0.16507E+00, 0.16708E+00,&
      0.16909E+00, 0.17110E+00, 0.17310E+00, 0.17510E+00, 0.17709E+00,&
      0.17909E+00, 0.18108E+00, 0.18306E+00, 0.18505E+00, 0.18703E+00,&
      0.18901E+00, 0.19098E+00, 0.19295E+00, 0.19492E+00, 0.19688E+00,&
      0.19884E+00, 0.20080E+00, 0.20276E+00, 0.20471E+00, 0.20666E+00,&
      0.20860E+00, 0.21054E+00, 0.21248E+00, 0.21442E+00, 0.21635E+00,&
      0.21828E+00, 0.22020E+00, 0.22213E+00, 0.22405E+00, 0.22596E+00,&
      0.22788E+00, 0.22979E+00, 0.23169E+00, 0.23360E+00, 0.23550E+00,&
      0.23739E+00, 0.23929E+00, 0.24118E+00, 0.24306E+00, 0.24495E+00,&
      0.24683E+00, 0.24871E+00, 0.25058E+00, 0.25245E+00, 0.25432E+00,&
      0.25619E+00, 0.25805E+00, 0.25991E+00, 0.26177E+00, 0.26362E+00,&
      0.26547E+00, 0.26731E+00, 0.26916E+00, 0.27100E+00, 0.27283E+00,&
      0.27467E+00, 0.27650E+00, 0.27833E+00, 0.28015E+00, 0.28197E+00,&
      0.28379E+00, 0.28560E+00, 0.28742E+00, 0.28923E+00, 0.29103E+00,&
      0.29283E+00, 0.29463E+00, 0.29643E+00, 0.29822E+00, 0.30001E+00,&
      0.30180E+00, 0.30359E+00, 0.30537E+00, 0.30715E+00, 0.30892E+00,&
      0.31069E+00, 0.31246E+00, 0.31423E+00, 0.31599E+00, 0.31775E+00,&
      0.31951E+00, 0.32126E+00, 0.32301E+00, 0.32476E+00, 0.32651E+00,&
      0.32825E+00, 0.32999E+00, 0.33172E+00, 0.33346E+00, 0.33518E+00/
                             
     DATA (BNC01M (IA),IA=301,400)/                                     &
      0.33691E+00, 0.33864E+00, 0.34036E+00, 0.34208E+00, 0.34379E+00,&
      0.34550E+00, 0.34721E+00, 0.34892E+00, 0.35062E+00, 0.35232E+00,&
      0.35402E+00, 0.35571E+00, 0.35741E+00, 0.35910E+00, 0.36078E+00,&
      0.36246E+00, 0.36414E+00, 0.36582E+00, 0.36750E+00, 0.36917E+00,&
      0.37084E+00, 0.37250E+00, 0.37417E+00, 0.37583E+00, 0.37748E+00,&
      0.37914E+00, 0.38079E+00, 0.38244E+00, 0.38409E+00, 0.38573E+00,&
      0.38737E+00, 0.38901E+00, 0.39064E+00, 0.39227E+00, 0.39390E+00,&
      0.39553E+00, 0.39715E+00, 0.39877E+00, 0.40039E+00, 0.40201E+00,&
      0.40362E+00, 0.40523E+00, 0.40684E+00, 0.40844E+00, 0.41004E+00,&
      0.41164E+00, 0.41324E+00, 0.41483E+00, 0.41642E+00, 0.41801E+00,&
      0.41960E+00, 0.42118E+00, 0.42276E+00, 0.42434E+00, 0.42591E+00,&
      0.42749E+00, 0.42906E+00, 0.43062E+00, 0.43219E+00, 0.43375E+00,&
      0.43531E+00, 0.43686E+00, 0.43842E+00, 0.43997E+00, 0.44152E+00,&
      0.44306E+00, 0.44461E+00, 0.44615E+00, 0.44769E+00, 0.44922E+00,&
      0.45075E+00, 0.45229E+00, 0.45381E+00, 0.45534E+00, 0.45686E+00,&
      0.45838E+00, 0.45990E+00, 0.46141E+00, 0.46293E+00, 0.46444E+00,&
      0.46594E+00, 0.46745E+00, 0.46895E+00, 0.47045E+00, 0.47195E+00,&
      0.47344E+00, 0.47494E+00, 0.47643E+00, 0.47791E+00, 0.47940E+00,&
      0.48088E+00, 0.48236E+00, 0.48384E+00, 0.48532E+00, 0.48679E+00,&
      0.48826E+00, 0.48973E+00, 0.49119E+00, 0.49266E+00, 0.49412E+00/
                             
     DATA (BNC01M (IA),IA=401,500)/                                     &
      0.49557E+00, 0.49703E+00, 0.49848E+00, 0.49993E+00, 0.50138E+00,&
      0.50283E+00, 0.50427E+00, 0.50572E+00, 0.50715E+00, 0.50859E+00,&
      0.51003E+00, 0.51146E+00, 0.51289E+00, 0.51432E+00, 0.51574E+00,&
      0.51716E+00, 0.51858E+00, 0.52000E+00, 0.52142E+00, 0.52283E+00,&
      0.52424E+00, 0.52565E+00, 0.52706E+00, 0.52846E+00, 0.52986E+00,&
      0.53126E+00, 0.53266E+00, 0.53406E+00, 0.53545E+00, 0.53684E+00,&
      0.53823E+00, 0.53962E+00, 0.54100E+00, 0.54238E+00, 0.54376E+00,&
      0.54514E+00, 0.54651E+00, 0.54789E+00, 0.54926E+00, 0.55062E+00,&
      0.55199E+00, 0.55335E+00, 0.55472E+00, 0.55608E+00, 0.55743E+00,&
      0.55879E+00, 0.56014E+00, 0.56149E+00, 0.56284E+00, 0.56419E+00,&
      0.56553E+00, 0.56688E+00, 0.56822E+00, 0.56955E+00, 0.57089E+00,&
      0.57222E+00, 0.57356E+00, 0.57488E+00, 0.57621E+00, 0.57754E+00,&
      0.57886E+00, 0.58018E+00, 0.58150E+00, 0.58282E+00, 0.58413E+00,&
      0.58545E+00, 0.58676E+00, 0.58806E+00, 0.58937E+00, 0.59068E+00,&
      0.59198E+00, 0.59328E+00, 0.59458E+00, 0.59587E+00, 0.59717E+00,&
      0.59846E+00, 0.59975E+00, 0.60104E+00, 0.60232E+00, 0.60361E+00,&
      0.60489E+00, 0.60617E+00, 0.60745E+00, 0.60872E+00, 0.61000E+00,&
      0.61127E+00, 0.61254E+00, 0.61381E+00, 0.61508E+00, 0.61634E+00,&
      0.61760E+00, 0.61886E+00, 0.62012E+00, 0.62138E+00, 0.62263E+00,&
      0.62388E+00, 0.62513E+00, 0.62638E+00, 0.62763E+00, 0.62887E+00/
                             
     DATA (BNC01M (IA),IA=501,600)/                                     &
      0.63012E+00, 0.63136E+00, 0.63260E+00, 0.63383E+00, 0.63507E+00,&
      0.63630E+00, 0.63753E+00, 0.63876E+00, 0.63999E+00, 0.64122E+00,&
      0.64244E+00, 0.64366E+00, 0.64488E+00, 0.64610E+00, 0.64732E+00,&
      0.64853E+00, 0.64975E+00, 0.65096E+00, 0.65217E+00, 0.65337E+00,&
      0.65458E+00, 0.65578E+00, 0.65698E+00, 0.65818E+00, 0.65938E+00,&
      0.66058E+00, 0.66177E+00, 0.66296E+00, 0.66415E+00, 0.66534E+00,&
      0.66653E+00, 0.66772E+00, 0.66890E+00, 0.67008E+00, 0.67126E+00,&
      0.67244E+00, 0.67362E+00, 0.67479E+00, 0.67596E+00, 0.67713E+00,&
      0.67830E+00, 0.67947E+00, 0.68064E+00, 0.68180E+00, 0.68296E+00,&
      0.68412E+00, 0.68528E+00, 0.68644E+00, 0.68760E+00, 0.68875E+00,&
      0.68990E+00, 0.69105E+00, 0.69220E+00, 0.69335E+00, 0.69449E+00,&
      0.69563E+00, 0.69678E+00, 0.69792E+00, 0.69905E+00, 0.70019E+00,&
      0.70133E+00, 0.70246E+00, 0.70359E+00, 0.70472E+00, 0.70585E+00,&
      0.70698E+00, 0.70810E+00, 0.70922E+00, 0.71035E+00, 0.71147E+00,&
      0.71258E+00, 0.71370E+00, 0.71482E+00, 0.71593E+00, 0.71704E+00,&
      0.71815E+00, 0.71926E+00, 0.72037E+00, 0.72147E+00, 0.72258E+00,&
      0.72368E+00, 0.72478E+00, 0.72588E+00, 0.72697E+00, 0.72807E+00,&
      0.72916E+00, 0.73026E+00, 0.73135E+00, 0.73244E+00, 0.73352E+00,&
      0.73461E+00, 0.73569E+00, 0.73678E+00, 0.73786E+00, 0.73894E+00,&
      0.74002E+00, 0.74109E+00, 0.74217E+00, 0.74324E+00, 0.74725E+00/
                             
     DATA (BNC01M (IA),IA=601,700)/                                     &
      0.75600E+00, 0.76647E+00, 0.77680E+00, 0.78697E+00, 0.79701E+00,&
      0.80690E+00, 0.81666E+00, 0.82629E+00, 0.83578E+00, 0.84515E+00,&
      0.85439E+00, 0.86350E+00, 0.87250E+00, 0.88138E+00, 0.89014E+00,&
      0.89879E+00, 0.90732E+00, 0.91574E+00, 0.92406E+00, 0.93227E+00,&
      0.94038E+00, 0.94838E+00, 0.95628E+00, 0.96409E+00, 0.97180E+00,&
      0.97941E+00, 0.98693E+00, 0.99435E+00, 0.10017E+01, 0.10089E+01,&
      0.10161E+01, 0.10232E+01, 0.10302E+01, 0.10371E+01, 0.10439E+01,&
      0.10506E+01, 0.10573E+01, 0.10639E+01, 0.10704E+01, 0.10768E+01,&
      0.10832E+01, 0.10895E+01, 0.10957E+01, 0.11018E+01, 0.11079E+01,&
      0.11139E+01, 0.11199E+01, 0.11257E+01, 0.11315E+01, 0.11373E+01,&
      0.11430E+01, 0.11486E+01, 0.11541E+01, 0.11596E+01, 0.11651E+01,&
      0.11704E+01, 0.11757E+01, 0.11810E+01, 0.11862E+01, 0.11913E+01,&
      0.11964E+01, 0.12015E+01, 0.12064E+01, 0.12114E+01, 0.12162E+01,&
      0.12211E+01, 0.12258E+01, 0.12306E+01, 0.12352E+01, 0.12399E+01,&
      0.12444E+01, 0.12490E+01, 0.12534E+01, 0.12579E+01, 0.12623E+01,&
      0.12666E+01, 0.12709E+01, 0.12751E+01, 0.12794E+01, 0.12835E+01,&
      0.12876E+01, 0.12917E+01, 0.12958E+01, 0.12998E+01, 0.13037E+01,&
      0.13076E+01, 0.13115E+01, 0.13153E+01, 0.13191E+01, 0.13229E+01,&
      0.13266E+01, 0.13303E+01, 0.13340E+01, 0.13376E+01, 0.13411E+01,&
      0.13447E+01, 0.13482E+01, 0.13517E+01, 0.13551E+01, 0.13585E+01/
                             
     DATA (BNC01M(IA),IA=701,741)/                                      &
      0.13619E+01, 0.13652E+01, 0.13685E+01, 0.13718E+01, 0.13750E+01,&
      0.13782E+01, 0.13814E+01, 0.13845E+01, 0.13876E+01, 0.13907E+01,&
      0.13937E+01, 0.13967E+01, 0.13997E+01, 0.14027E+01, 0.14056E+01,&
      0.14085E+01, 0.14114E+01, 0.14142E+01, 0.14170E+01, 0.14198E+01,&
      0.14226E+01, 0.14253E+01, 0.14280E+01, 0.14307E+01, 0.14333E+01,&
      0.14360E+01, 0.14386E+01, 0.14411E+01, 0.14437E+01, 0.14462E+01,&
      0.14487E+01, 0.14512E+01, 0.14536E+01, 0.14561E+01, 0.14585E+01,&
      0.14608E+01, 0.14632E+01, 0.14655E+01, 0.14678E+01, 0.14701E+01,&
      0.14724E+01                  /                      
!                            
!  ** Na2SO4                 
!                            
     DATA (BNC02M (IA),IA=  1,100)/                                     &
     -0.10845E+00,-0.19833E+00,-0.26217E+00,-0.30599E+00,-0.34002E+00,&
     -0.36806E+00,-0.39204E+00,-0.41305E+00,-0.43179E+00,-0.44872E+00,&
     -0.46420E+00,-0.47846E+00,-0.49169E+00,-0.50405E+00,-0.51565E+00,&
     -0.52658E+00,-0.53693E+00,-0.54675E+00,-0.55611E+00,-0.56505E+00,&
     -0.57361E+00,-0.58182E+00,-0.58971E+00,-0.59731E+00,-0.60464E+00,&
     -0.61173E+00,-0.61858E+00,-0.62522E+00,-0.63166E+00,-0.63792E+00,&
     -0.64400E+00,-0.64991E+00,-0.65567E+00,-0.66129E+00,-0.66676E+00,&
     -0.67211E+00,-0.67733E+00,-0.68243E+00,-0.68742E+00,-0.69231E+00,&
     -0.69710E+00,-0.70178E+00,-0.70638E+00,-0.71089E+00,-0.71531E+00,&
     -0.71965E+00,-0.72392E+00,-0.72811E+00,-0.73222E+00,-0.73627E+00,&
     -0.74026E+00,-0.74418E+00,-0.74803E+00,-0.75183E+00,-0.75558E+00,&
     -0.75926E+00,-0.76290E+00,-0.76648E+00,-0.77002E+00,-0.77350E+00,&
     -0.77695E+00,-0.78034E+00,-0.78370E+00,-0.78701E+00,-0.79029E+00,&
     -0.79352E+00,-0.79672E+00,-0.79988E+00,-0.80301E+00,-0.80610E+00,&
     -0.80916E+00,-0.81219E+00,-0.81519E+00,-0.81816E+00,-0.82110E+00,&
     -0.82401E+00,-0.82689E+00,-0.82975E+00,-0.83259E+00,-0.83540E+00,&
     -0.83818E+00,-0.84095E+00,-0.84369E+00,-0.84641E+00,-0.84911E+00,&
     -0.85178E+00,-0.85444E+00,-0.85708E+00,-0.85970E+00,-0.86230E+00,&
     -0.86488E+00,-0.86745E+00,-0.87000E+00,-0.87253E+00,-0.87505E+00,&
     -0.87755E+00,-0.88003E+00,-0.88250E+00,-0.88495E+00,-0.88739E+00/
                             
     DATA (BNC02M (IA),IA=101,200)/                                     &
     -0.88982E+00,-0.89223E+00,-0.89462E+00,-0.89700E+00,-0.89937E+00,&
     -0.90173E+00,-0.90407E+00,-0.90640E+00,-0.90872E+00,-0.91102E+00,&
     -0.91332E+00,-0.91560E+00,-0.91786E+00,-0.92012E+00,-0.92236E+00,&
     -0.92460E+00,-0.92682E+00,-0.92903E+00,-0.93123E+00,-0.93342E+00,&
     -0.93555E+00,-0.93772E+00,-0.93988E+00,-0.94203E+00,-0.94417E+00,&
     -0.94629E+00,-0.94841E+00,-0.95052E+00,-0.95262E+00,-0.95470E+00,&
     -0.95678E+00,-0.95885E+00,-0.96090E+00,-0.96295E+00,-0.96499E+00,&
     -0.96702E+00,-0.96904E+00,-0.97105E+00,-0.97305E+00,-0.97505E+00,&
     -0.97703E+00,-0.97901E+00,-0.98098E+00,-0.98294E+00,-0.98489E+00,&
     -0.98683E+00,-0.98877E+00,-0.99070E+00,-0.99262E+00,-0.99453E+00,&
     -0.99643E+00,-0.99833E+00,-0.10002E+01,-0.10021E+01,-0.10040E+01,&
     -0.10058E+01,-0.10077E+01,-0.10096E+01,-0.10114E+01,-0.10133E+01,&
     -0.10151E+01,-0.10169E+01,-0.10187E+01,-0.10205E+01,-0.10224E+01,&
     -0.10242E+01,-0.10260E+01,-0.10277E+01,-0.10295E+01,-0.10313E+01,&
     -0.10331E+01,-0.10348E+01,-0.10366E+01,-0.10384E+01,-0.10401E+01,&
     -0.10418E+01,-0.10436E+01,-0.10453E+01,-0.10470E+01,-0.10488E+01,&
     -0.10505E+01,-0.10522E+01,-0.10539E+01,-0.10556E+01,-0.10573E+01,&
     -0.10590E+01,-0.10606E+01,-0.10623E+01,-0.10640E+01,-0.10657E+01,&
     -0.10673E+01,-0.10690E+01,-0.10706E+01,-0.10723E+01,-0.10739E+01,&
     -0.10756E+01,-0.10772E+01,-0.10788E+01,-0.10805E+01,-0.10821E+01/
                             
     DATA (BNC02M (IA),IA=201,300)/                                     &
     -0.10837E+01,-0.10853E+01,-0.10869E+01,-0.10885E+01,-0.10901E+01,&
     -0.10917E+01,-0.10933E+01,-0.10949E+01,-0.10965E+01,-0.10981E+01,&
     -0.10997E+01,-0.11012E+01,-0.11028E+01,-0.11044E+01,-0.11059E+01,&
     -0.11075E+01,-0.11090E+01,-0.11106E+01,-0.11121E+01,-0.11137E+01,&
     -0.11152E+01,-0.11167E+01,-0.11183E+01,-0.11198E+01,-0.11213E+01,&
     -0.11228E+01,-0.11243E+01,-0.11259E+01,-0.11274E+01,-0.11289E+01,&
     -0.11304E+01,-0.11319E+01,-0.11334E+01,-0.11349E+01,-0.11364E+01,&
     -0.11378E+01,-0.11393E+01,-0.11408E+01,-0.11423E+01,-0.11437E+01,&
     -0.11452E+01,-0.11467E+01,-0.11481E+01,-0.11496E+01,-0.11511E+01,&
     -0.11525E+01,-0.11540E+01,-0.11554E+01,-0.11569E+01,-0.11583E+01,&
     -0.11597E+01,-0.11612E+01,-0.11626E+01,-0.11640E+01,-0.11655E+01,&
     -0.11669E+01,-0.11683E+01,-0.11697E+01,-0.11711E+01,-0.11726E+01,&
     -0.11740E+01,-0.11754E+01,-0.11768E+01,-0.11782E+01,-0.11796E+01,&
     -0.11810E+01,-0.11824E+01,-0.11838E+01,-0.11852E+01,-0.11865E+01,&
     -0.11879E+01,-0.11893E+01,-0.11907E+01,-0.11921E+01,-0.11934E+01,&
     -0.11948E+01,-0.11962E+01,-0.11976E+01,-0.11989E+01,-0.12003E+01,&
     -0.12016E+01,-0.12030E+01,-0.12044E+01,-0.12057E+01,-0.12071E+01,&
     -0.12084E+01,-0.12098E+01,-0.12111E+01,-0.12124E+01,-0.12138E+01,&
     -0.12151E+01,-0.12165E+01,-0.12178E+01,-0.12191E+01,-0.12204E+01,&
     -0.12218E+01,-0.12231E+01,-0.12244E+01,-0.12257E+01,-0.12271E+01/
                             
     DATA (BNC02M (IA),IA=301,400)/                                     &
     -0.12284E+01,-0.12297E+01,-0.12310E+01,-0.12323E+01,-0.12336E+01,&
     -0.12349E+01,-0.12362E+01,-0.12375E+01,-0.12388E+01,-0.12401E+01,&
     -0.12414E+01,-0.12427E+01,-0.12440E+01,-0.12453E+01,-0.12466E+01,&
     -0.12479E+01,-0.12491E+01,-0.12504E+01,-0.12517E+01,-0.12530E+01,&
     -0.12543E+01,-0.12555E+01,-0.12568E+01,-0.12581E+01,-0.12593E+01,&
     -0.12606E+01,-0.12619E+01,-0.12631E+01,-0.12644E+01,-0.12657E+01,&
     -0.12669E+01,-0.12682E+01,-0.12694E+01,-0.12707E+01,-0.12719E+01,&
     -0.12732E+01,-0.12744E+01,-0.12757E+01,-0.12769E+01,-0.12782E+01,&
     -0.12794E+01,-0.12806E+01,-0.12819E+01,-0.12831E+01,-0.12844E+01,&
     -0.12856E+01,-0.12868E+01,-0.12880E+01,-0.12893E+01,-0.12905E+01,&
     -0.12917E+01,-0.12930E+01,-0.12942E+01,-0.12954E+01,-0.12966E+01,&
     -0.12978E+01,-0.12990E+01,-0.13003E+01,-0.13015E+01,-0.13027E+01,&
     -0.13039E+01,-0.13051E+01,-0.13063E+01,-0.13075E+01,-0.13087E+01,&
     -0.13099E+01,-0.13111E+01,-0.13123E+01,-0.13135E+01,-0.13147E+01,&
     -0.13159E+01,-0.13171E+01,-0.13183E+01,-0.13195E+01,-0.13207E+01,&
     -0.13219E+01,-0.13230E+01,-0.13242E+01,-0.13254E+01,-0.13266E+01,&
     -0.13278E+01,-0.13290E+01,-0.13301E+01,-0.13313E+01,-0.13325E+01,&
     -0.13337E+01,-0.13348E+01,-0.13360E+01,-0.13372E+01,-0.13383E+01,&
     -0.13395E+01,-0.13407E+01,-0.13418E+01,-0.13430E+01,-0.13442E+01,&
     -0.13453E+01,-0.13465E+01,-0.13476E+01,-0.13488E+01,-0.13500E+01/
                             
     DATA (BNC02M (IA),IA=401,500)/                                     &
     -0.13511E+01,-0.13523E+01,-0.13534E+01,-0.13546E+01,-0.13557E+01,&
     -0.13569E+01,-0.13580E+01,-0.13592E+01,-0.13603E+01,-0.13615E+01,&
     -0.13626E+01,-0.13637E+01,-0.13649E+01,-0.13660E+01,-0.13672E+01,&
     -0.13683E+01,-0.13694E+01,-0.13706E+01,-0.13717E+01,-0.13728E+01,&
     -0.13740E+01,-0.13751E+01,-0.13762E+01,-0.13774E+01,-0.13785E+01,&
     -0.13796E+01,-0.13807E+01,-0.13819E+01,-0.13830E+01,-0.13841E+01,&
     -0.13852E+01,-0.13863E+01,-0.13875E+01,-0.13886E+01,-0.13897E+01,&
     -0.13908E+01,-0.13919E+01,-0.13930E+01,-0.13941E+01,-0.13952E+01,&
     -0.13964E+01,-0.13975E+01,-0.13986E+01,-0.13997E+01,-0.14008E+01,&
     -0.14019E+01,-0.14030E+01,-0.14041E+01,-0.14052E+01,-0.14063E+01,&
     -0.14074E+01,-0.14085E+01,-0.14096E+01,-0.14107E+01,-0.14118E+01,&
     -0.14129E+01,-0.14140E+01,-0.14151E+01,-0.14162E+01,-0.14172E+01,&
     -0.14183E+01,-0.14194E+01,-0.14205E+01,-0.14216E+01,-0.14227E+01,&
     -0.14238E+01,-0.14249E+01,-0.14259E+01,-0.14270E+01,-0.14281E+01,&
     -0.14292E+01,-0.14303E+01,-0.14313E+01,-0.14324E+01,-0.14335E+01,&
     -0.14346E+01,-0.14356E+01,-0.14367E+01,-0.14378E+01,-0.14389E+01,&
     -0.14399E+01,-0.14410E+01,-0.14421E+01,-0.14431E+01,-0.14442E+01,&
     -0.14453E+01,-0.14463E+01,-0.14474E+01,-0.14485E+01,-0.14495E+01,&
     -0.14506E+01,-0.14517E+01,-0.14527E+01,-0.14538E+01,-0.14548E+01,&
     -0.14559E+01,-0.14569E+01,-0.14580E+01,-0.14591E+01,-0.14601E+01/
                             
     DATA (BNC02M (IA),IA=501,600)/                                     &
     -0.14612E+01,-0.14622E+01,-0.14633E+01,-0.14643E+01,-0.14654E+01,&
     -0.14664E+01,-0.14675E+01,-0.14685E+01,-0.14696E+01,-0.14706E+01,&
     -0.14717E+01,-0.14727E+01,-0.14737E+01,-0.14748E+01,-0.14758E+01,&
     -0.14769E+01,-0.14779E+01,-0.14790E+01,-0.14800E+01,-0.14810E+01,&
     -0.14821E+01,-0.14831E+01,-0.14841E+01,-0.14852E+01,-0.14862E+01,&
     -0.14872E+01,-0.14883E+01,-0.14893E+01,-0.14903E+01,-0.14914E+01,&
     -0.14924E+01,-0.14934E+01,-0.14945E+01,-0.14955E+01,-0.14965E+01,&
     -0.14975E+01,-0.14986E+01,-0.14996E+01,-0.15006E+01,-0.15016E+01,&
     -0.15027E+01,-0.15037E+01,-0.15047E+01,-0.15057E+01,-0.15068E+01,&
     -0.15078E+01,-0.15088E+01,-0.15098E+01,-0.15108E+01,-0.15118E+01,&
     -0.15129E+01,-0.15139E+01,-0.15149E+01,-0.15159E+01,-0.15169E+01,&
     -0.15179E+01,-0.15189E+01,-0.15200E+01,-0.15210E+01,-0.15220E+01,&
     -0.15230E+01,-0.15240E+01,-0.15250E+01,-0.15260E+01,-0.15270E+01,&
     -0.15280E+01,-0.15290E+01,-0.15300E+01,-0.15310E+01,-0.15320E+01,&
     -0.15330E+01,-0.15340E+01,-0.15350E+01,-0.15360E+01,-0.15370E+01,&
     -0.15380E+01,-0.15390E+01,-0.15400E+01,-0.15410E+01,-0.15420E+01,&
     -0.15430E+01,-0.15440E+01,-0.15450E+01,-0.15460E+01,-0.15470E+01,&
     -0.15480E+01,-0.15490E+01,-0.15500E+01,-0.15510E+01,-0.15520E+01,&
     -0.15529E+01,-0.15539E+01,-0.15549E+01,-0.15559E+01,-0.15569E+01,&
     -0.15579E+01,-0.15589E+01,-0.15599E+01,-0.15608E+01,-0.15645E+01/
                             
     DATA (BNC02M (IA),IA=601,700)/                                     &
     -0.15726E+01,-0.15824E+01,-0.15921E+01,-0.16017E+01,-0.16113E+01,&
     -0.16208E+01,-0.16303E+01,-0.16397E+01,-0.16491E+01,-0.16584E+01,&
     -0.16677E+01,-0.16770E+01,-0.16862E+01,-0.16954E+01,-0.17045E+01,&
     -0.17136E+01,-0.17226E+01,-0.17316E+01,-0.17406E+01,-0.17495E+01,&
     -0.17584E+01,-0.17673E+01,-0.17761E+01,-0.17849E+01,-0.17937E+01,&
     -0.18024E+01,-0.18111E+01,-0.18198E+01,-0.18284E+01,-0.18370E+01,&
     -0.18456E+01,-0.18542E+01,-0.18627E+01,-0.18712E+01,-0.18797E+01,&
     -0.18881E+01,-0.18966E+01,-0.19050E+01,-0.19133E+01,-0.19217E+01,&
     -0.19300E+01,-0.19383E+01,-0.19466E+01,-0.19548E+01,-0.19631E+01,&
     -0.19713E+01,-0.19795E+01,-0.19876E+01,-0.19958E+01,-0.20039E+01,&
     -0.20120E+01,-0.20201E+01,-0.20282E+01,-0.20362E+01,-0.20443E+01,&
     -0.20523E+01,-0.20603E+01,-0.20682E+01,-0.20762E+01,-0.20841E+01,&
     -0.20921E+01,-0.21000E+01,-0.21079E+01,-0.21157E+01,-0.21236E+01,&
     -0.21314E+01,-0.21393E+01,-0.21471E+01,-0.21549E+01,-0.21626E+01,&
     -0.21704E+01,-0.21782E+01,-0.21859E+01,-0.21936E+01,-0.22013E+01,&
     -0.22090E+01,-0.22167E+01,-0.22244E+01,-0.22320E+01,-0.22396E+01,&
     -0.22473E+01,-0.22549E+01,-0.22625E+01,-0.22701E+01,-0.22776E+01,&
     -0.22852E+01,-0.22928E+01,-0.23003E+01,-0.23078E+01,-0.23153E+01,&
     -0.23228E+01,-0.23303E+01,-0.23378E+01,-0.23453E+01,-0.23527E+01,&
     -0.23602E+01,-0.23676E+01,-0.23750E+01,-0.23825E+01,-0.23899E+01/
                             
     DATA (BNC02M(IA),IA=701,741)/                                      &
     -0.23973E+01,-0.24046E+01,-0.24120E+01,-0.24194E+01,-0.24267E+01,&
     -0.24341E+01,-0.24414E+01,-0.24487E+01,-0.24560E+01,-0.24633E+01,&
     -0.24706E+01,-0.24779E+01,-0.24852E+01,-0.24925E+01,-0.24997E+01,&
     -0.25070E+01,-0.25142E+01,-0.25214E+01,-0.25287E+01,-0.25359E+01,&
     -0.25431E+01,-0.25503E+01,-0.25575E+01,-0.25647E+01,-0.25718E+01,&
     -0.25790E+01,-0.25862E+01,-0.25933E+01,-0.26004E+01,-0.26076E+01,&
     -0.26147E+01,-0.26218E+01,-0.26289E+01,-0.26360E+01,-0.26431E+01,&
     -0.26502E+01,-0.26573E+01,-0.26644E+01,-0.26714E+01,-0.26785E+01,&
     -0.26856E+01                  /                      
!                            
!  ** NaNO3                  
!                            
     DATA (BNC03M (IA),IA=  1,100)/                                     &
     -0.54405E-01,-0.99825E-01,-0.13234E+00,-0.15482E+00,-0.17238E+00,&
     -0.18693E+00,-0.19943E+00,-0.21044E+00,-0.22031E+00,-0.22926E+00,&
     -0.23748E+00,-0.24508E+00,-0.25216E+00,-0.25880E+00,-0.26505E+00,&
     -0.27097E+00,-0.27658E+00,-0.28194E+00,-0.28705E+00,-0.29195E+00,&
     -0.29665E+00,-0.30117E+00,-0.30553E+00,-0.30975E+00,-0.31382E+00,&
     -0.31776E+00,-0.32159E+00,-0.32530E+00,-0.32891E+00,-0.33243E+00,&
     -0.33585E+00,-0.33918E+00,-0.34243E+00,-0.34561E+00,-0.34871E+00,&
     -0.35175E+00,-0.35472E+00,-0.35762E+00,-0.36047E+00,-0.36326E+00,&
     -0.36599E+00,-0.36868E+00,-0.37131E+00,-0.37389E+00,-0.37643E+00,&
     -0.37893E+00,-0.38138E+00,-0.38379E+00,-0.38617E+00,-0.38850E+00,&
     -0.39080E+00,-0.39307E+00,-0.39530E+00,-0.39749E+00,-0.39966E+00,&
     -0.40180E+00,-0.40391E+00,-0.40598E+00,-0.40804E+00,-0.41006E+00,&
     -0.41206E+00,-0.41404E+00,-0.41599E+00,-0.41792E+00,-0.41983E+00,&
     -0.42172E+00,-0.42359E+00,-0.42543E+00,-0.42726E+00,-0.42907E+00,&
     -0.43087E+00,-0.43264E+00,-0.43440E+00,-0.43615E+00,-0.43787E+00,&
     -0.43959E+00,-0.44129E+00,-0.44298E+00,-0.44465E+00,-0.44631E+00,&
     -0.44796E+00,-0.44959E+00,-0.45122E+00,-0.45283E+00,-0.45444E+00,&
     -0.45603E+00,-0.45761E+00,-0.45918E+00,-0.46075E+00,-0.46230E+00,&
     -0.46385E+00,-0.46538E+00,-0.46691E+00,-0.46843E+00,-0.46994E+00,&
     -0.47145E+00,-0.47294E+00,-0.47443E+00,-0.47591E+00,-0.47739E+00/
                             
     DATA (BNC03M (IA),IA=101,200)/                                     &
     -0.47885E+00,-0.48031E+00,-0.48176E+00,-0.48321E+00,-0.48465E+00,&
     -0.48608E+00,-0.48750E+00,-0.48892E+00,-0.49033E+00,-0.49174E+00,&
     -0.49314E+00,-0.49453E+00,-0.49591E+00,-0.49729E+00,-0.49867E+00,&
     -0.50003E+00,-0.50139E+00,-0.50275E+00,-0.50410E+00,-0.50544E+00,&
     -0.50673E+00,-0.50806E+00,-0.50939E+00,-0.51071E+00,-0.51203E+00,&
     -0.51334E+00,-0.51465E+00,-0.51594E+00,-0.51724E+00,-0.51852E+00,&
     -0.51980E+00,-0.52108E+00,-0.52235E+00,-0.52361E+00,-0.52487E+00,&
     -0.52612E+00,-0.52737E+00,-0.52861E+00,-0.52985E+00,-0.53108E+00,&
     -0.53230E+00,-0.53353E+00,-0.53474E+00,-0.53595E+00,-0.53716E+00,&
     -0.53836E+00,-0.53956E+00,-0.54075E+00,-0.54194E+00,-0.54312E+00,&
     -0.54430E+00,-0.54548E+00,-0.54664E+00,-0.54781E+00,-0.54897E+00,&
     -0.55013E+00,-0.55128E+00,-0.55243E+00,-0.55357E+00,-0.55471E+00,&
     -0.55585E+00,-0.55698E+00,-0.55811E+00,-0.55923E+00,-0.56035E+00,&
     -0.56147E+00,-0.56258E+00,-0.56369E+00,-0.56480E+00,-0.56590E+00,&
     -0.56699E+00,-0.56809E+00,-0.56918E+00,-0.57027E+00,-0.57135E+00,&
     -0.57243E+00,-0.57351E+00,-0.57458E+00,-0.57565E+00,-0.57671E+00,&
     -0.57778E+00,-0.57884E+00,-0.57989E+00,-0.58095E+00,-0.58200E+00,&
     -0.58304E+00,-0.58409E+00,-0.58513E+00,-0.58617E+00,-0.58720E+00,&
     -0.58823E+00,-0.58926E+00,-0.59029E+00,-0.59131E+00,-0.59233E+00,&
     -0.59334E+00,-0.59436E+00,-0.59537E+00,-0.59638E+00,-0.59738E+00/
                             
     DATA (BNC03M (IA),IA=201,300)/                                     &
     -0.59839E+00,-0.59939E+00,-0.60038E+00,-0.60138E+00,-0.60237E+00,&
     -0.60336E+00,-0.60434E+00,-0.60533E+00,-0.60631E+00,-0.60729E+00,&
     -0.60826E+00,-0.60924E+00,-0.61021E+00,-0.61118E+00,-0.61214E+00,&
     -0.61311E+00,-0.61407E+00,-0.61503E+00,-0.61598E+00,-0.61694E+00,&
     -0.61789E+00,-0.61884E+00,-0.61979E+00,-0.62073E+00,-0.62167E+00,&
     -0.62261E+00,-0.62355E+00,-0.62449E+00,-0.62542E+00,-0.62635E+00,&
     -0.62728E+00,-0.62821E+00,-0.62913E+00,-0.63005E+00,-0.63097E+00,&
     -0.63189E+00,-0.63281E+00,-0.63372E+00,-0.63463E+00,-0.63554E+00,&
     -0.63645E+00,-0.63736E+00,-0.63826E+00,-0.63916E+00,-0.64006E+00,&
     -0.64096E+00,-0.64186E+00,-0.64275E+00,-0.64364E+00,-0.64453E+00,&
     -0.64542E+00,-0.64631E+00,-0.64719E+00,-0.64807E+00,-0.64896E+00,&
     -0.64983E+00,-0.65071E+00,-0.65159E+00,-0.65246E+00,-0.65333E+00,&
     -0.65420E+00,-0.65507E+00,-0.65594E+00,-0.65680E+00,-0.65766E+00,&
     -0.65852E+00,-0.65938E+00,-0.66024E+00,-0.66110E+00,-0.66195E+00,&
     -0.66281E+00,-0.66366E+00,-0.66451E+00,-0.66535E+00,-0.66620E+00,&
     -0.66704E+00,-0.66789E+00,-0.66873E+00,-0.66957E+00,-0.67041E+00,&
     -0.67124E+00,-0.67208E+00,-0.67291E+00,-0.67374E+00,-0.67457E+00,&
     -0.67540E+00,-0.67623E+00,-0.67705E+00,-0.67788E+00,-0.67870E+00,&
     -0.67952E+00,-0.68034E+00,-0.68116E+00,-0.68198E+00,-0.68279E+00,&
     -0.68361E+00,-0.68442E+00,-0.68523E+00,-0.68604E+00,-0.68685E+00/
                             
     DATA (BNC03M (IA),IA=301,400)/                                     &
     -0.68766E+00,-0.68846E+00,-0.68927E+00,-0.69007E+00,-0.69087E+00,&
     -0.69167E+00,-0.69247E+00,-0.69327E+00,-0.69406E+00,-0.69486E+00,&
     -0.69565E+00,-0.69644E+00,-0.69723E+00,-0.69802E+00,-0.69881E+00,&
     -0.69960E+00,-0.70038E+00,-0.70117E+00,-0.70195E+00,-0.70273E+00,&
     -0.70351E+00,-0.70429E+00,-0.70507E+00,-0.70585E+00,-0.70662E+00,&
     -0.70740E+00,-0.70817E+00,-0.70894E+00,-0.70971E+00,-0.71048E+00,&
     -0.71125E+00,-0.71202E+00,-0.71278E+00,-0.71355E+00,-0.71431E+00,&
     -0.71507E+00,-0.71583E+00,-0.71659E+00,-0.71735E+00,-0.71811E+00,&
     -0.71887E+00,-0.71962E+00,-0.72038E+00,-0.72113E+00,-0.72188E+00,&
     -0.72263E+00,-0.72338E+00,-0.72413E+00,-0.72488E+00,-0.72563E+00,&
     -0.72637E+00,-0.72712E+00,-0.72786E+00,-0.72860E+00,-0.72935E+00,&
     -0.73009E+00,-0.73083E+00,-0.73156E+00,-0.73230E+00,-0.73304E+00,&
     -0.73377E+00,-0.73451E+00,-0.73524E+00,-0.73597E+00,-0.73670E+00,&
     -0.73743E+00,-0.73816E+00,-0.73889E+00,-0.73962E+00,-0.74034E+00,&
     -0.74107E+00,-0.74179E+00,-0.74252E+00,-0.74324E+00,-0.74396E+00,&
     -0.74468E+00,-0.74540E+00,-0.74612E+00,-0.74683E+00,-0.74755E+00,&
     -0.74827E+00,-0.74898E+00,-0.74969E+00,-0.75041E+00,-0.75112E+00,&
     -0.75183E+00,-0.75254E+00,-0.75325E+00,-0.75396E+00,-0.75467E+00,&
     -0.75537E+00,-0.75608E+00,-0.75678E+00,-0.75749E+00,-0.75819E+00,&
     -0.75889E+00,-0.75959E+00,-0.76029E+00,-0.76099E+00,-0.76169E+00/
                             
     DATA (BNC03M (IA),IA=401,500)/                                     &
     -0.76239E+00,-0.76308E+00,-0.76378E+00,-0.76447E+00,-0.76517E+00,&
     -0.76586E+00,-0.76655E+00,-0.76725E+00,-0.76794E+00,-0.76863E+00,&
     -0.76932E+00,-0.77001E+00,-0.77069E+00,-0.77138E+00,-0.77207E+00,&
     -0.77275E+00,-0.77344E+00,-0.77412E+00,-0.77480E+00,-0.77548E+00,&
     -0.77616E+00,-0.77684E+00,-0.77752E+00,-0.77820E+00,-0.77888E+00,&
     -0.77956E+00,-0.78024E+00,-0.78091E+00,-0.78159E+00,-0.78226E+00,&
     -0.78293E+00,-0.78361E+00,-0.78428E+00,-0.78495E+00,-0.78562E+00,&
     -0.78629E+00,-0.78696E+00,-0.78763E+00,-0.78829E+00,-0.78896E+00,&
     -0.78963E+00,-0.79029E+00,-0.79096E+00,-0.79162E+00,-0.79228E+00,&
     -0.79295E+00,-0.79361E+00,-0.79427E+00,-0.79493E+00,-0.79559E+00,&
     -0.79625E+00,-0.79691E+00,-0.79756E+00,-0.79822E+00,-0.79888E+00,&
     -0.79953E+00,-0.80019E+00,-0.80084E+00,-0.80149E+00,-0.80215E+00,&
     -0.80280E+00,-0.80345E+00,-0.80410E+00,-0.80475E+00,-0.80540E+00,&
     -0.80605E+00,-0.80670E+00,-0.80734E+00,-0.80799E+00,-0.80864E+00,&
     -0.80928E+00,-0.80993E+00,-0.81057E+00,-0.81121E+00,-0.81186E+00,&
     -0.81250E+00,-0.81314E+00,-0.81378E+00,-0.81442E+00,-0.81506E+00,&
     -0.81570E+00,-0.81634E+00,-0.81698E+00,-0.81761E+00,-0.81825E+00,&
     -0.81888E+00,-0.81952E+00,-0.82015E+00,-0.82079E+00,-0.82142E+00,&
     -0.82205E+00,-0.82269E+00,-0.82332E+00,-0.82395E+00,-0.82458E+00,&
     -0.82521E+00,-0.82584E+00,-0.82647E+00,-0.82710E+00,-0.82772E+00/
                             
     DATA (BNC03M (IA),IA=501,600)/                                     &
     -0.82835E+00,-0.82898E+00,-0.82960E+00,-0.83023E+00,-0.83085E+00,&
     -0.83147E+00,-0.83210E+00,-0.83272E+00,-0.83334E+00,-0.83397E+00,&
     -0.83459E+00,-0.83521E+00,-0.83583E+00,-0.83645E+00,-0.83706E+00,&
     -0.83768E+00,-0.83830E+00,-0.83892E+00,-0.83953E+00,-0.84015E+00,&
     -0.84077E+00,-0.84138E+00,-0.84200E+00,-0.84261E+00,-0.84322E+00,&
     -0.84384E+00,-0.84445E+00,-0.84506E+00,-0.84567E+00,-0.84628E+00,&
     -0.84689E+00,-0.84750E+00,-0.84811E+00,-0.84872E+00,-0.84933E+00,&
     -0.84993E+00,-0.85054E+00,-0.85115E+00,-0.85175E+00,-0.85236E+00,&
     -0.85296E+00,-0.85357E+00,-0.85417E+00,-0.85478E+00,-0.85538E+00,&
     -0.85598E+00,-0.85658E+00,-0.85718E+00,-0.85779E+00,-0.85839E+00,&
     -0.85899E+00,-0.85959E+00,-0.86018E+00,-0.86078E+00,-0.86138E+00,&
     -0.86198E+00,-0.86257E+00,-0.86317E+00,-0.86377E+00,-0.86436E+00,&
     -0.86496E+00,-0.86555E+00,-0.86615E+00,-0.86674E+00,-0.86733E+00,&
     -0.86793E+00,-0.86852E+00,-0.86911E+00,-0.86970E+00,-0.87029E+00,&
     -0.87088E+00,-0.87147E+00,-0.87206E+00,-0.87265E+00,-0.87324E+00,&
     -0.87383E+00,-0.87441E+00,-0.87500E+00,-0.87559E+00,-0.87617E+00,&
     -0.87676E+00,-0.87734E+00,-0.87793E+00,-0.87851E+00,-0.87910E+00,&
     -0.87968E+00,-0.88026E+00,-0.88085E+00,-0.88143E+00,-0.88201E+00,&
     -0.88259E+00,-0.88317E+00,-0.88375E+00,-0.88433E+00,-0.88491E+00,&
     -0.88549E+00,-0.88607E+00,-0.88665E+00,-0.88723E+00,-0.88939E+00/
                             
     DATA (BNC03M (IA),IA=601,700)/                                     &
     -0.89413E+00,-0.89983E+00,-0.90549E+00,-0.91112E+00,-0.91671E+00,&
     -0.92226E+00,-0.92777E+00,-0.93325E+00,-0.93869E+00,-0.94410E+00,&
     -0.94948E+00,-0.95483E+00,-0.96015E+00,-0.96543E+00,-0.97069E+00,&
     -0.97592E+00,-0.98112E+00,-0.98629E+00,-0.99143E+00,-0.99655E+00,&
     -0.10016E+01,-0.10067E+01,-0.10118E+01,-0.10168E+01,-0.10218E+01,&
     -0.10267E+01,-0.10317E+01,-0.10366E+01,-0.10415E+01,-0.10464E+01,&
     -0.10513E+01,-0.10561E+01,-0.10609E+01,-0.10658E+01,-0.10705E+01,&
     -0.10753E+01,-0.10801E+01,-0.10848E+01,-0.10895E+01,-0.10942E+01,&
     -0.10989E+01,-0.11035E+01,-0.11082E+01,-0.11128E+01,-0.11174E+01,&
     -0.11220E+01,-0.11266E+01,-0.11311E+01,-0.11357E+01,-0.11402E+01,&
     -0.11447E+01,-0.11493E+01,-0.11537E+01,-0.11582E+01,-0.11627E+01,&
     -0.11671E+01,-0.11716E+01,-0.11760E+01,-0.11804E+01,-0.11848E+01,&
     -0.11892E+01,-0.11936E+01,-0.11979E+01,-0.12023E+01,-0.12066E+01,&
     -0.12109E+01,-0.12153E+01,-0.12196E+01,-0.12239E+01,-0.12281E+01,&
     -0.12324E+01,-0.12367E+01,-0.12409E+01,-0.12452E+01,-0.12494E+01,&
     -0.12536E+01,-0.12578E+01,-0.12620E+01,-0.12662E+01,-0.12704E+01,&
     -0.12746E+01,-0.12787E+01,-0.12829E+01,-0.12870E+01,-0.12912E+01,&
     -0.12953E+01,-0.12994E+01,-0.13035E+01,-0.13076E+01,-0.13117E+01,&
     -0.13158E+01,-0.13199E+01,-0.13239E+01,-0.13280E+01,-0.13320E+01,&
     -0.13361E+01,-0.13401E+01,-0.13441E+01,-0.13482E+01,-0.13522E+01/
                             
     DATA (BNC03M(IA),IA=701,741)/                                      &
     -0.13562E+01,-0.13602E+01,-0.13642E+01,-0.13682E+01,-0.13721E+01,&
     -0.13761E+01,-0.13801E+01,-0.13840E+01,-0.13880E+01,-0.13919E+01,&
     -0.13959E+01,-0.13998E+01,-0.14037E+01,-0.14076E+01,-0.14115E+01,&
     -0.14154E+01,-0.14193E+01,-0.14232E+01,-0.14271E+01,-0.14310E+01,&
     -0.14349E+01,-0.14387E+01,-0.14426E+01,-0.14464E+01,-0.14503E+01,&
     -0.14541E+01,-0.14580E+01,-0.14618E+01,-0.14656E+01,-0.14695E+01,&
     -0.14733E+01,-0.14771E+01,-0.14809E+01,-0.14847E+01,-0.14885E+01,&
     -0.14923E+01,-0.14961E+01,-0.14998E+01,-0.15036E+01,-0.15074E+01,&
     -0.15112E+01                  /                      
!                            
!  ** (NH4)2SO4              
!                            
     DATA (BNC04M (IA),IA=  1,100)/                                     &
     -0.10856E+00,-0.19872E+00,-0.26292E+00,-0.30708E+00,-0.34142E+00,&
     -0.36979E+00,-0.39407E+00,-0.41538E+00,-0.43441E+00,-0.45164E+00,&
     -0.46739E+00,-0.48193E+00,-0.49544E+00,-0.50808E+00,-0.51994E+00,&
     -0.53114E+00,-0.54176E+00,-0.55184E+00,-0.56146E+00,-0.57065E+00,&
     -0.57946E+00,-0.58792E+00,-0.59606E+00,-0.60391E+00,-0.61148E+00,&
     -0.61880E+00,-0.62590E+00,-0.63277E+00,-0.63944E+00,-0.64593E+00,&
     -0.65223E+00,-0.65837E+00,-0.66435E+00,-0.67019E+00,-0.67588E+00,&
     -0.68144E+00,-0.68688E+00,-0.69219E+00,-0.69739E+00,-0.70249E+00,&
     -0.70748E+00,-0.71237E+00,-0.71716E+00,-0.72187E+00,-0.72648E+00,&
     -0.73102E+00,-0.73548E+00,-0.73985E+00,-0.74416E+00,-0.74840E+00,&
     -0.75256E+00,-0.75666E+00,-0.76070E+00,-0.76468E+00,-0.76860E+00,&
     -0.77246E+00,-0.77627E+00,-0.78002E+00,-0.78373E+00,-0.78739E+00,&
     -0.79099E+00,-0.79456E+00,-0.79808E+00,-0.80155E+00,-0.80499E+00,&
     -0.80839E+00,-0.81175E+00,-0.81507E+00,-0.81835E+00,-0.82160E+00,&
     -0.82482E+00,-0.82801E+00,-0.83116E+00,-0.83428E+00,-0.83738E+00,&
     -0.84045E+00,-0.84349E+00,-0.84650E+00,-0.84949E+00,-0.85245E+00,&
     -0.85539E+00,-0.85831E+00,-0.86120E+00,-0.86407E+00,-0.86692E+00,&
     -0.86975E+00,-0.87256E+00,-0.87535E+00,-0.87812E+00,-0.88088E+00,&
     -0.88361E+00,-0.88633E+00,-0.88903E+00,-0.89172E+00,-0.89438E+00,&
     -0.89704E+00,-0.89967E+00,-0.90229E+00,-0.90490E+00,-0.90749E+00/
                             
     DATA (BNC04M (IA),IA=101,200)/                                     &
     -0.91007E+00,-0.91263E+00,-0.91518E+00,-0.91772E+00,-0.92024E+00,&
     -0.92275E+00,-0.92524E+00,-0.92772E+00,-0.93019E+00,-0.93265E+00,&
     -0.93509E+00,-0.93752E+00,-0.93994E+00,-0.94235E+00,-0.94475E+00,&
     -0.94713E+00,-0.94950E+00,-0.95186E+00,-0.95421E+00,-0.95655E+00,&
     -0.95881E+00,-0.96113E+00,-0.96344E+00,-0.96574E+00,-0.96803E+00,&
     -0.97031E+00,-0.97257E+00,-0.97483E+00,-0.97707E+00,-0.97930E+00,&
     -0.98153E+00,-0.98374E+00,-0.98594E+00,-0.98813E+00,-0.99032E+00,&
     -0.99249E+00,-0.99465E+00,-0.99681E+00,-0.99895E+00,-0.10011E+01,&
     -0.10032E+01,-0.10053E+01,-0.10074E+01,-0.10095E+01,-0.10116E+01,&
     -0.10137E+01,-0.10158E+01,-0.10179E+01,-0.10199E+01,-0.10220E+01,&
     -0.10240E+01,-0.10260E+01,-0.10281E+01,-0.10301E+01,-0.10321E+01,&
     -0.10341E+01,-0.10361E+01,-0.10381E+01,-0.10401E+01,-0.10420E+01,&
     -0.10440E+01,-0.10460E+01,-0.10479E+01,-0.10499E+01,-0.10518E+01,&
     -0.10537E+01,-0.10556E+01,-0.10576E+01,-0.10595E+01,-0.10614E+01,&
     -0.10633E+01,-0.10652E+01,-0.10671E+01,-0.10689E+01,-0.10708E+01,&
     -0.10727E+01,-0.10746E+01,-0.10764E+01,-0.10783E+01,-0.10801E+01,&
     -0.10819E+01,-0.10838E+01,-0.10856E+01,-0.10874E+01,-0.10892E+01,&
     -0.10911E+01,-0.10929E+01,-0.10947E+01,-0.10965E+01,-0.10983E+01,&
     -0.11000E+01,-0.11018E+01,-0.11036E+01,-0.11054E+01,-0.11071E+01,&
     -0.11089E+01,-0.11106E+01,-0.11124E+01,-0.11141E+01,-0.11159E+01/
                             
     DATA (BNC04M (IA),IA=201,300)/                                     &
     -0.11176E+01,-0.11193E+01,-0.11211E+01,-0.11228E+01,-0.11245E+01,&
     -0.11262E+01,-0.11279E+01,-0.11296E+01,-0.11313E+01,-0.11330E+01,&
     -0.11347E+01,-0.11364E+01,-0.11381E+01,-0.11398E+01,-0.11414E+01,&
     -0.11431E+01,-0.11448E+01,-0.11464E+01,-0.11481E+01,-0.11497E+01,&
     -0.11514E+01,-0.11530E+01,-0.11547E+01,-0.11563E+01,-0.11579E+01,&
     -0.11596E+01,-0.11612E+01,-0.11628E+01,-0.11644E+01,-0.11660E+01,&
     -0.11677E+01,-0.11693E+01,-0.11709E+01,-0.11725E+01,-0.11741E+01,&
     -0.11757E+01,-0.11772E+01,-0.11788E+01,-0.11804E+01,-0.11820E+01,&
     -0.11836E+01,-0.11851E+01,-0.11867E+01,-0.11883E+01,-0.11898E+01,&
     -0.11914E+01,-0.11929E+01,-0.11945E+01,-0.11960E+01,-0.11976E+01,&
     -0.11991E+01,-0.12007E+01,-0.12022E+01,-0.12037E+01,-0.12053E+01,&
     -0.12068E+01,-0.12083E+01,-0.12098E+01,-0.12114E+01,-0.12129E+01,&
     -0.12144E+01,-0.12159E+01,-0.12174E+01,-0.12189E+01,-0.12204E+01,&
     -0.12219E+01,-0.12234E+01,-0.12249E+01,-0.12264E+01,-0.12278E+01,&
     -0.12293E+01,-0.12308E+01,-0.12323E+01,-0.12338E+01,-0.12352E+01,&
     -0.12367E+01,-0.12382E+01,-0.12396E+01,-0.12411E+01,-0.12426E+01,&
     -0.12440E+01,-0.12455E+01,-0.12469E+01,-0.12484E+01,-0.12498E+01,&
     -0.12513E+01,-0.12527E+01,-0.12541E+01,-0.12556E+01,-0.12570E+01,&
     -0.12584E+01,-0.12599E+01,-0.12613E+01,-0.12627E+01,-0.12641E+01,&
     -0.12655E+01,-0.12670E+01,-0.12684E+01,-0.12698E+01,-0.12712E+01/
                             
     DATA (BNC04M (IA),IA=301,400)/                                     &
     -0.12726E+01,-0.12740E+01,-0.12754E+01,-0.12768E+01,-0.12782E+01,&
     -0.12796E+01,-0.12810E+01,-0.12824E+01,-0.12838E+01,-0.12852E+01,&
     -0.12866E+01,-0.12879E+01,-0.12893E+01,-0.12907E+01,-0.12921E+01,&
     -0.12934E+01,-0.12948E+01,-0.12962E+01,-0.12976E+01,-0.12989E+01,&
     -0.13003E+01,-0.13016E+01,-0.13030E+01,-0.13044E+01,-0.13057E+01,&
     -0.13071E+01,-0.13084E+01,-0.13098E+01,-0.13111E+01,-0.13125E+01,&
     -0.13138E+01,-0.13152E+01,-0.13165E+01,-0.13178E+01,-0.13192E+01,&
     -0.13205E+01,-0.13218E+01,-0.13232E+01,-0.13245E+01,-0.13258E+01,&
     -0.13271E+01,-0.13285E+01,-0.13298E+01,-0.13311E+01,-0.13324E+01,&
     -0.13337E+01,-0.13351E+01,-0.13364E+01,-0.13377E+01,-0.13390E+01,&
     -0.13403E+01,-0.13416E+01,-0.13429E+01,-0.13442E+01,-0.13455E+01,&
     -0.13468E+01,-0.13481E+01,-0.13494E+01,-0.13507E+01,-0.13520E+01,&
     -0.13533E+01,-0.13546E+01,-0.13558E+01,-0.13571E+01,-0.13584E+01,&
     -0.13597E+01,-0.13610E+01,-0.13623E+01,-0.13635E+01,-0.13648E+01,&
     -0.13661E+01,-0.13674E+01,-0.13686E+01,-0.13699E+01,-0.13712E+01,&
     -0.13724E+01,-0.13737E+01,-0.13750E+01,-0.13762E+01,-0.13775E+01,&
     -0.13787E+01,-0.13800E+01,-0.13812E+01,-0.13825E+01,-0.13838E+01,&
     -0.13850E+01,-0.13863E+01,-0.13875E+01,-0.13887E+01,-0.13900E+01,&
     -0.13912E+01,-0.13925E+01,-0.13937E+01,-0.13950E+01,-0.13962E+01,&
     -0.13974E+01,-0.13987E+01,-0.13999E+01,-0.14011E+01,-0.14024E+01/
                             
     DATA (BNC04M (IA),IA=401,500)/                                     &
     -0.14036E+01,-0.14048E+01,-0.14060E+01,-0.14073E+01,-0.14085E+01,&
     -0.14097E+01,-0.14109E+01,-0.14122E+01,-0.14134E+01,-0.14146E+01,&
     -0.14158E+01,-0.14170E+01,-0.14182E+01,-0.14195E+01,-0.14207E+01,&
     -0.14219E+01,-0.14231E+01,-0.14243E+01,-0.14255E+01,-0.14267E+01,&
     -0.14279E+01,-0.14291E+01,-0.14303E+01,-0.14315E+01,-0.14327E+01,&
     -0.14339E+01,-0.14351E+01,-0.14363E+01,-0.14375E+01,-0.14387E+01,&
     -0.14399E+01,-0.14411E+01,-0.14422E+01,-0.14434E+01,-0.14446E+01,&
     -0.14458E+01,-0.14470E+01,-0.14482E+01,-0.14493E+01,-0.14505E+01,&
     -0.14517E+01,-0.14529E+01,-0.14541E+01,-0.14552E+01,-0.14564E+01,&
     -0.14576E+01,-0.14587E+01,-0.14599E+01,-0.14611E+01,-0.14623E+01,&
     -0.14634E+01,-0.14646E+01,-0.14658E+01,-0.14669E+01,-0.14681E+01,&
     -0.14692E+01,-0.14704E+01,-0.14716E+01,-0.14727E+01,-0.14739E+01,&
     -0.14750E+01,-0.14762E+01,-0.14773E+01,-0.14785E+01,-0.14797E+01,&
     -0.14808E+01,-0.14820E+01,-0.14831E+01,-0.14842E+01,-0.14854E+01,&
     -0.14865E+01,-0.14877E+01,-0.14888E+01,-0.14900E+01,-0.14911E+01,&
     -0.14923E+01,-0.14934E+01,-0.14945E+01,-0.14957E+01,-0.14968E+01,&
     -0.14979E+01,-0.14991E+01,-0.15002E+01,-0.15013E+01,-0.15025E+01,&
     -0.15036E+01,-0.15047E+01,-0.15059E+01,-0.15070E+01,-0.15081E+01,&
     -0.15092E+01,-0.15104E+01,-0.15115E+01,-0.15126E+01,-0.15137E+01,&
     -0.15149E+01,-0.15160E+01,-0.15171E+01,-0.15182E+01,-0.15193E+01/
                             
     DATA (BNC04M (IA),IA=501,600)/                                     &
     -0.15204E+01,-0.15216E+01,-0.15227E+01,-0.15238E+01,-0.15249E+01,&
     -0.15260E+01,-0.15271E+01,-0.15282E+01,-0.15293E+01,-0.15305E+01,&
     -0.15316E+01,-0.15327E+01,-0.15338E+01,-0.15349E+01,-0.15360E+01,&
     -0.15371E+01,-0.15382E+01,-0.15393E+01,-0.15404E+01,-0.15415E+01,&
     -0.15426E+01,-0.15437E+01,-0.15448E+01,-0.15459E+01,-0.15470E+01,&
     -0.15481E+01,-0.15492E+01,-0.15502E+01,-0.15513E+01,-0.15524E+01,&
     -0.15535E+01,-0.15546E+01,-0.15557E+01,-0.15568E+01,-0.15579E+01,&
     -0.15590E+01,-0.15600E+01,-0.15611E+01,-0.15622E+01,-0.15633E+01,&
     -0.15644E+01,-0.15655E+01,-0.15665E+01,-0.15676E+01,-0.15687E+01,&
     -0.15698E+01,-0.15708E+01,-0.15719E+01,-0.15730E+01,-0.15741E+01,&
     -0.15751E+01,-0.15762E+01,-0.15773E+01,-0.15784E+01,-0.15794E+01,&
     -0.15805E+01,-0.15816E+01,-0.15826E+01,-0.15837E+01,-0.15848E+01,&
     -0.15858E+01,-0.15869E+01,-0.15880E+01,-0.15890E+01,-0.15901E+01,&
     -0.15912E+01,-0.15922E+01,-0.15933E+01,-0.15943E+01,-0.15954E+01,&
     -0.15965E+01,-0.15975E+01,-0.15986E+01,-0.15996E+01,-0.16007E+01,&
     -0.16017E+01,-0.16028E+01,-0.16038E+01,-0.16049E+01,-0.16059E+01,&
     -0.16070E+01,-0.16080E+01,-0.16091E+01,-0.16101E+01,-0.16112E+01,&
     -0.16122E+01,-0.16133E+01,-0.16143E+01,-0.16154E+01,-0.16164E+01,&
     -0.16175E+01,-0.16185E+01,-0.16196E+01,-0.16206E+01,-0.16216E+01,&
     -0.16227E+01,-0.16237E+01,-0.16248E+01,-0.16258E+01,-0.16297E+01/
                             
     DATA (BNC04M (IA),IA=601,700)/                                     &
     -0.16382E+01,-0.16485E+01,-0.16587E+01,-0.16688E+01,-0.16789E+01,&
     -0.16890E+01,-0.16989E+01,-0.17088E+01,-0.17187E+01,-0.17285E+01,&
     -0.17383E+01,-0.17480E+01,-0.17576E+01,-0.17673E+01,-0.17768E+01,&
     -0.17863E+01,-0.17958E+01,-0.18053E+01,-0.18146E+01,-0.18240E+01,&
     -0.18333E+01,-0.18426E+01,-0.18518E+01,-0.18610E+01,-0.18702E+01,&
     -0.18793E+01,-0.18884E+01,-0.18974E+01,-0.19065E+01,-0.19154E+01,&
     -0.19244E+01,-0.19333E+01,-0.19422E+01,-0.19511E+01,-0.19599E+01,&
     -0.19687E+01,-0.19775E+01,-0.19862E+01,-0.19949E+01,-0.20036E+01,&
     -0.20123E+01,-0.20209E+01,-0.20295E+01,-0.20381E+01,-0.20466E+01,&
     -0.20552E+01,-0.20637E+01,-0.20722E+01,-0.20806E+01,-0.20890E+01,&
     -0.20975E+01,-0.21058E+01,-0.21142E+01,-0.21226E+01,-0.21309E+01,&
     -0.21392E+01,-0.21475E+01,-0.21557E+01,-0.21640E+01,-0.21722E+01,&
     -0.21804E+01,-0.21886E+01,-0.21968E+01,-0.22049E+01,-0.22130E+01,&
     -0.22211E+01,-0.22292E+01,-0.22373E+01,-0.22454E+01,-0.22534E+01,&
     -0.22614E+01,-0.22694E+01,-0.22774E+01,-0.22854E+01,-0.22933E+01,&
     -0.23013E+01,-0.23092E+01,-0.23171E+01,-0.23250E+01,-0.23329E+01,&
     -0.23408E+01,-0.23486E+01,-0.23564E+01,-0.23643E+01,-0.23721E+01,&
     -0.23799E+01,-0.23876E+01,-0.23954E+01,-0.24032E+01,-0.24109E+01,&
     -0.24186E+01,-0.24263E+01,-0.24340E+01,-0.24417E+01,-0.24494E+01,&
     -0.24570E+01,-0.24647E+01,-0.24723E+01,-0.24800E+01,-0.24876E+01/
                             
     DATA (BNC04M(IA),IA=701,741)/                                      &
     -0.24952E+01,-0.25028E+01,-0.25103E+01,-0.25179E+01,-0.25255E+01,&
     -0.25330E+01,-0.25405E+01,-0.25481E+01,-0.25556E+01,-0.25631E+01,&
     -0.25706E+01,-0.25780E+01,-0.25855E+01,-0.25930E+01,-0.26004E+01,&
     -0.26079E+01,-0.26153E+01,-0.26227E+01,-0.26301E+01,-0.26375E+01,&
     -0.26449E+01,-0.26523E+01,-0.26597E+01,-0.26670E+01,-0.26744E+01,&
     -0.26817E+01,-0.26891E+01,-0.26964E+01,-0.27037E+01,-0.27110E+01,&
     -0.27183E+01,-0.27256E+01,-0.27329E+01,-0.27401E+01,-0.27474E+01,&
     -0.27547E+01,-0.27619E+01,-0.27692E+01,-0.27764E+01,-0.27836E+01,&
     -0.27908E+01                  /                      
!                            
!  ** NH4NO3                 
!                            
     DATA (BNC05M (IA),IA=  1,100)/                                     &
     -0.55115E-01,-0.10248E+00,-0.13740E+00,-0.16216E+00,-0.18192E+00,&
     -0.19861E+00,-0.21320E+00,-0.22626E+00,-0.23813E+00,-0.24905E+00,&
     -0.25921E+00,-0.26872E+00,-0.27769E+00,-0.28619E+00,-0.29428E+00,&
     -0.30201E+00,-0.30943E+00,-0.31655E+00,-0.32341E+00,-0.33004E+00,&
     -0.33646E+00,-0.34268E+00,-0.34871E+00,-0.35458E+00,-0.36029E+00,&
     -0.36586E+00,-0.37128E+00,-0.37658E+00,-0.38176E+00,-0.38682E+00,&
     -0.39178E+00,-0.39663E+00,-0.40138E+00,-0.40603E+00,-0.41060E+00,&
     -0.41508E+00,-0.41948E+00,-0.42380E+00,-0.42805E+00,-0.43222E+00,&
     -0.43632E+00,-0.44035E+00,-0.44432E+00,-0.44823E+00,-0.45207E+00,&
     -0.45585E+00,-0.45958E+00,-0.46325E+00,-0.46687E+00,-0.47044E+00,&
     -0.47395E+00,-0.47742E+00,-0.48084E+00,-0.48422E+00,-0.48755E+00,&
     -0.49084E+00,-0.49409E+00,-0.49730E+00,-0.50048E+00,-0.50361E+00,&
     -0.50671E+00,-0.50978E+00,-0.51282E+00,-0.51582E+00,-0.51880E+00,&
     -0.52174E+00,-0.52466E+00,-0.52755E+00,-0.53041E+00,-0.53326E+00,&
     -0.53607E+00,-0.53887E+00,-0.54164E+00,-0.54440E+00,-0.54713E+00,&
     -0.54985E+00,-0.55255E+00,-0.55523E+00,-0.55790E+00,-0.56055E+00,&
     -0.56319E+00,-0.56581E+00,-0.56842E+00,-0.57102E+00,-0.57360E+00,&
     -0.57617E+00,-0.57874E+00,-0.58129E+00,-0.58383E+00,-0.58636E+00,&
     -0.58888E+00,-0.59139E+00,-0.59389E+00,-0.59638E+00,-0.59887E+00,&
     -0.60134E+00,-0.60381E+00,-0.60627E+00,-0.60872E+00,-0.61116E+00/
                             
     DATA (BNC05M (IA),IA=101,200)/                                     &
     -0.61360E+00,-0.61602E+00,-0.61844E+00,-0.62085E+00,-0.62325E+00,&
     -0.62565E+00,-0.62803E+00,-0.63041E+00,-0.63278E+00,-0.63514E+00,&
     -0.63749E+00,-0.63983E+00,-0.64217E+00,-0.64449E+00,-0.64681E+00,&
     -0.64912E+00,-0.65142E+00,-0.65371E+00,-0.65599E+00,-0.65827E+00,&
     -0.66039E+00,-0.66266E+00,-0.66492E+00,-0.66718E+00,-0.66942E+00,&
     -0.67165E+00,-0.67387E+00,-0.67608E+00,-0.67828E+00,-0.68047E+00,&
     -0.68265E+00,-0.68482E+00,-0.68698E+00,-0.68914E+00,-0.69128E+00,&
     -0.69341E+00,-0.69554E+00,-0.69765E+00,-0.69976E+00,-0.70186E+00,&
     -0.70395E+00,-0.70603E+00,-0.70810E+00,-0.71016E+00,-0.71222E+00,&
     -0.71426E+00,-0.71630E+00,-0.71833E+00,-0.72035E+00,-0.72237E+00,&
     -0.72437E+00,-0.72637E+00,-0.72836E+00,-0.73034E+00,-0.73232E+00,&
     -0.73428E+00,-0.73624E+00,-0.73820E+00,-0.74014E+00,-0.74208E+00,&
     -0.74401E+00,-0.74593E+00,-0.74784E+00,-0.74975E+00,-0.75165E+00,&
     -0.75355E+00,-0.75544E+00,-0.75732E+00,-0.75919E+00,-0.76106E+00,&
     -0.76292E+00,-0.76477E+00,-0.76662E+00,-0.76846E+00,-0.77029E+00,&
     -0.77212E+00,-0.77394E+00,-0.77575E+00,-0.77756E+00,-0.77936E+00,&
     -0.78116E+00,-0.78295E+00,-0.78473E+00,-0.78651E+00,-0.78828E+00,&
     -0.79005E+00,-0.79180E+00,-0.79356E+00,-0.79531E+00,-0.79705E+00,&
     -0.79878E+00,-0.80051E+00,-0.80224E+00,-0.80396E+00,-0.80567E+00,&
     -0.80738E+00,-0.80908E+00,-0.81078E+00,-0.81247E+00,-0.81416E+00/
                             
     DATA (BNC05M (IA),IA=201,300)/                                     &
     -0.81584E+00,-0.81751E+00,-0.81918E+00,-0.82085E+00,-0.82251E+00,&
     -0.82416E+00,-0.82581E+00,-0.82746E+00,-0.82910E+00,-0.83073E+00,&
     -0.83236E+00,-0.83398E+00,-0.83560E+00,-0.83722E+00,-0.83883E+00,&
     -0.84043E+00,-0.84203E+00,-0.84363E+00,-0.84522E+00,-0.84680E+00,&
     -0.84839E+00,-0.84996E+00,-0.85153E+00,-0.85310E+00,-0.85466E+00,&
     -0.85622E+00,-0.85778E+00,-0.85932E+00,-0.86087E+00,-0.86241E+00,&
     -0.86395E+00,-0.86548E+00,-0.86700E+00,-0.86853E+00,-0.87005E+00,&
     -0.87156E+00,-0.87307E+00,-0.87458E+00,-0.87608E+00,-0.87758E+00,&
     -0.87907E+00,-0.88056E+00,-0.88204E+00,-0.88353E+00,-0.88500E+00,&
     -0.88648E+00,-0.88794E+00,-0.88941E+00,-0.89087E+00,-0.89233E+00,&
     -0.89378E+00,-0.89523E+00,-0.89668E+00,-0.89812E+00,-0.89956E+00,&
     -0.90099E+00,-0.90242E+00,-0.90385E+00,-0.90527E+00,-0.90669E+00,&
     -0.90811E+00,-0.90952E+00,-0.91093E+00,-0.91233E+00,-0.91373E+00,&
     -0.91513E+00,-0.91653E+00,-0.91792E+00,-0.91930E+00,-0.92069E+00,&
     -0.92207E+00,-0.92344E+00,-0.92482E+00,-0.92619E+00,-0.92755E+00,&
     -0.92892E+00,-0.93028E+00,-0.93163E+00,-0.93299E+00,-0.93434E+00,&
     -0.93568E+00,-0.93703E+00,-0.93837E+00,-0.93970E+00,-0.94104E+00,&
     -0.94237E+00,-0.94369E+00,-0.94502E+00,-0.94634E+00,-0.94765E+00,&
     -0.94897E+00,-0.95028E+00,-0.95159E+00,-0.95289E+00,-0.95420E+00,&
     -0.95549E+00,-0.95679E+00,-0.95808E+00,-0.95937E+00,-0.96066E+00/
                             
     DATA (BNC05M (IA),IA=301,400)/                                     &
     -0.96194E+00,-0.96323E+00,-0.96450E+00,-0.96578E+00,-0.96705E+00,&
     -0.96832E+00,-0.96959E+00,-0.97085E+00,-0.97211E+00,-0.97337E+00,&
     -0.97463E+00,-0.97588E+00,-0.97713E+00,-0.97837E+00,-0.97962E+00,&
     -0.98086E+00,-0.98210E+00,-0.98333E+00,-0.98457E+00,-0.98580E+00,&
     -0.98703E+00,-0.98825E+00,-0.98947E+00,-0.99069E+00,-0.99191E+00,&
     -0.99312E+00,-0.99434E+00,-0.99554E+00,-0.99675E+00,-0.99796E+00,&
     -0.99916E+00,-0.10004E+01,-0.10016E+01,-0.10027E+01,-0.10039E+01,&
     -0.10051E+01,-0.10063E+01,-0.10075E+01,-0.10087E+01,-0.10099E+01,&
     -0.10110E+01,-0.10122E+01,-0.10134E+01,-0.10145E+01,-0.10157E+01,&
     -0.10169E+01,-0.10180E+01,-0.10192E+01,-0.10204E+01,-0.10215E+01,&
     -0.10227E+01,-0.10238E+01,-0.10250E+01,-0.10261E+01,-0.10273E+01,&
     -0.10284E+01,-0.10295E+01,-0.10307E+01,-0.10318E+01,-0.10329E+01,&
     -0.10341E+01,-0.10352E+01,-0.10363E+01,-0.10374E+01,-0.10386E+01,&
     -0.10397E+01,-0.10408E+01,-0.10419E+01,-0.10430E+01,-0.10441E+01,&
     -0.10452E+01,-0.10464E+01,-0.10475E+01,-0.10486E+01,-0.10497E+01,&
     -0.10508E+01,-0.10519E+01,-0.10529E+01,-0.10540E+01,-0.10551E+01,&
     -0.10562E+01,-0.10573E+01,-0.10584E+01,-0.10595E+01,-0.10605E+01,&
     -0.10616E+01,-0.10627E+01,-0.10638E+01,-0.10648E+01,-0.10659E+01,&
     -0.10670E+01,-0.10680E+01,-0.10691E+01,-0.10702E+01,-0.10712E+01,&
     -0.10723E+01,-0.10733E+01,-0.10744E+01,-0.10754E+01,-0.10765E+01/
                             
     DATA (BNC05M (IA),IA=401,500)/                                     &
     -0.10775E+01,-0.10786E+01,-0.10796E+01,-0.10807E+01,-0.10817E+01,&
     -0.10827E+01,-0.10838E+01,-0.10848E+01,-0.10859E+01,-0.10869E+01,&
     -0.10879E+01,-0.10889E+01,-0.10900E+01,-0.10910E+01,-0.10920E+01,&
     -0.10930E+01,-0.10941E+01,-0.10951E+01,-0.10961E+01,-0.10971E+01,&
     -0.10981E+01,-0.10991E+01,-0.11001E+01,-0.11011E+01,-0.11021E+01,&
     -0.11031E+01,-0.11041E+01,-0.11051E+01,-0.11061E+01,-0.11071E+01,&
     -0.11081E+01,-0.11091E+01,-0.11101E+01,-0.11111E+01,-0.11121E+01,&
     -0.11131E+01,-0.11141E+01,-0.11150E+01,-0.11160E+01,-0.11170E+01,&
     -0.11180E+01,-0.11190E+01,-0.11199E+01,-0.11209E+01,-0.11219E+01,&
     -0.11229E+01,-0.11238E+01,-0.11248E+01,-0.11258E+01,-0.11267E+01,&
     -0.11277E+01,-0.11286E+01,-0.11296E+01,-0.11306E+01,-0.11315E+01,&
     -0.11325E+01,-0.11334E+01,-0.11344E+01,-0.11353E+01,-0.11363E+01,&
     -0.11372E+01,-0.11382E+01,-0.11391E+01,-0.11401E+01,-0.11410E+01,&
     -0.11419E+01,-0.11429E+01,-0.11438E+01,-0.11448E+01,-0.11457E+01,&
     -0.11466E+01,-0.11476E+01,-0.11485E+01,-0.11494E+01,-0.11503E+01,&
     -0.11513E+01,-0.11522E+01,-0.11531E+01,-0.11540E+01,-0.11549E+01,&
     -0.11559E+01,-0.11568E+01,-0.11577E+01,-0.11586E+01,-0.11595E+01,&
     -0.11604E+01,-0.11614E+01,-0.11623E+01,-0.11632E+01,-0.11641E+01,&
     -0.11650E+01,-0.11659E+01,-0.11668E+01,-0.11677E+01,-0.11686E+01,&
     -0.11695E+01,-0.11704E+01,-0.11713E+01,-0.11722E+01,-0.11731E+01/
                             
     DATA (BNC05M (IA),IA=501,600)/                                     &
     -0.11740E+01,-0.11748E+01,-0.11757E+01,-0.11766E+01,-0.11775E+01,&
     -0.11784E+01,-0.11793E+01,-0.11802E+01,-0.11810E+01,-0.11819E+01,&
     -0.11828E+01,-0.11837E+01,-0.11846E+01,-0.11854E+01,-0.11863E+01,&
     -0.11872E+01,-0.11881E+01,-0.11889E+01,-0.11898E+01,-0.11907E+01,&
     -0.11915E+01,-0.11924E+01,-0.11933E+01,-0.11941E+01,-0.11950E+01,&
     -0.11958E+01,-0.11967E+01,-0.11976E+01,-0.11984E+01,-0.11993E+01,&
     -0.12001E+01,-0.12010E+01,-0.12018E+01,-0.12027E+01,-0.12035E+01,&
     -0.12044E+01,-0.12052E+01,-0.12061E+01,-0.12069E+01,-0.12078E+01,&
     -0.12086E+01,-0.12095E+01,-0.12103E+01,-0.12111E+01,-0.12120E+01,&
     -0.12128E+01,-0.12137E+01,-0.12145E+01,-0.12153E+01,-0.12162E+01,&
     -0.12170E+01,-0.12178E+01,-0.12186E+01,-0.12195E+01,-0.12203E+01,&
     -0.12211E+01,-0.12220E+01,-0.12228E+01,-0.12236E+01,-0.12244E+01,&
     -0.12252E+01,-0.12261E+01,-0.12269E+01,-0.12277E+01,-0.12285E+01,&
     -0.12293E+01,-0.12302E+01,-0.12310E+01,-0.12318E+01,-0.12326E+01,&
     -0.12334E+01,-0.12342E+01,-0.12350E+01,-0.12358E+01,-0.12366E+01,&
     -0.12374E+01,-0.12383E+01,-0.12391E+01,-0.12399E+01,-0.12407E+01,&
     -0.12415E+01,-0.12423E+01,-0.12431E+01,-0.12439E+01,-0.12447E+01,&
     -0.12455E+01,-0.12462E+01,-0.12470E+01,-0.12478E+01,-0.12486E+01,&
     -0.12494E+01,-0.12502E+01,-0.12510E+01,-0.12518E+01,-0.12526E+01,&
     -0.12534E+01,-0.12541E+01,-0.12549E+01,-0.12557E+01,-0.12586E+01/
                             
     DATA (BNC05M (IA),IA=601,700)/                                     &
     -0.12650E+01,-0.12727E+01,-0.12803E+01,-0.12878E+01,-0.12952E+01,&
     -0.13026E+01,-0.13098E+01,-0.13170E+01,-0.13241E+01,-0.13312E+01,&
     -0.13381E+01,-0.13450E+01,-0.13519E+01,-0.13586E+01,-0.13654E+01,&
     -0.13720E+01,-0.13786E+01,-0.13851E+01,-0.13916E+01,-0.13980E+01,&
     -0.14044E+01,-0.14107E+01,-0.14169E+01,-0.14231E+01,-0.14293E+01,&
     -0.14354E+01,-0.14415E+01,-0.14475E+01,-0.14534E+01,-0.14594E+01,&
     -0.14652E+01,-0.14711E+01,-0.14769E+01,-0.14827E+01,-0.14884E+01,&
     -0.14941E+01,-0.14997E+01,-0.15053E+01,-0.15109E+01,-0.15164E+01,&
     -0.15219E+01,-0.15274E+01,-0.15328E+01,-0.15382E+01,-0.15436E+01,&
     -0.15490E+01,-0.15543E+01,-0.15595E+01,-0.15648E+01,-0.15700E+01,&
     -0.15752E+01,-0.15804E+01,-0.15855E+01,-0.15906E+01,-0.15957E+01,&
     -0.16008E+01,-0.16058E+01,-0.16108E+01,-0.16158E+01,-0.16208E+01,&
     -0.16257E+01,-0.16306E+01,-0.16355E+01,-0.16404E+01,-0.16452E+01,&
     -0.16500E+01,-0.16548E+01,-0.16596E+01,-0.16644E+01,-0.16691E+01,&
     -0.16739E+01,-0.16786E+01,-0.16832E+01,-0.16879E+01,-0.16926E+01,&
     -0.16972E+01,-0.17018E+01,-0.17064E+01,-0.17110E+01,-0.17155E+01,&
     -0.17201E+01,-0.17246E+01,-0.17291E+01,-0.17336E+01,-0.17381E+01,&
     -0.17425E+01,-0.17470E+01,-0.17514E+01,-0.17558E+01,-0.17602E+01,&
     -0.17646E+01,-0.17690E+01,-0.17733E+01,-0.17777E+01,-0.17820E+01,&
     -0.17863E+01,-0.17906E+01,-0.17949E+01,-0.17992E+01,-0.18035E+01/
                             
     DATA (BNC05M(IA),IA=701,741)/                                      &
     -0.18077E+01,-0.18119E+01,-0.18162E+01,-0.18204E+01,-0.18246E+01,&
     -0.18288E+01,-0.18330E+01,-0.18371E+01,-0.18413E+01,-0.18454E+01,&
     -0.18496E+01,-0.18537E+01,-0.18578E+01,-0.18619E+01,-0.18660E+01,&
     -0.18701E+01,-0.18742E+01,-0.18782E+01,-0.18823E+01,-0.18863E+01,&
     -0.18903E+01,-0.18944E+01,-0.18984E+01,-0.19024E+01,-0.19064E+01,&
     -0.19104E+01,-0.19144E+01,-0.19183E+01,-0.19223E+01,-0.19262E+01,&
     -0.19302E+01,-0.19341E+01,-0.19380E+01,-0.19419E+01,-0.19459E+01,&
     -0.19498E+01,-0.19537E+01,-0.19575E+01,-0.19614E+01,-0.19653E+01,&
     -0.19691E+01                  /                      
!                            
!  ** NH4Cl                  
!                            
     DATA (BNC06M (IA),IA=  1,100)/                                     &
     -0.53384E-01,-0.96046E-01,-0.12518E+00,-0.14446E+00,-0.15894E+00,&
     -0.17052E+00,-0.18011E+00,-0.18828E+00,-0.19534E+00,-0.20155E+00,&
     -0.20706E+00,-0.21199E+00,-0.21644E+00,-0.22048E+00,-0.22416E+00,&
     -0.22754E+00,-0.23064E+00,-0.23350E+00,-0.23615E+00,-0.23861E+00,&
     -0.24090E+00,-0.24303E+00,-0.24503E+00,-0.24689E+00,-0.24864E+00,&
     -0.25028E+00,-0.25183E+00,-0.25329E+00,-0.25466E+00,-0.25596E+00,&
     -0.25718E+00,-0.25834E+00,-0.25944E+00,-0.26049E+00,-0.26148E+00,&
     -0.26242E+00,-0.26332E+00,-0.26418E+00,-0.26499E+00,-0.26577E+00,&
     -0.26651E+00,-0.26722E+00,-0.26790E+00,-0.26856E+00,-0.26918E+00,&
     -0.26978E+00,-0.27035E+00,-0.27091E+00,-0.27144E+00,-0.27195E+00,&
     -0.27244E+00,-0.27291E+00,-0.27337E+00,-0.27380E+00,-0.27422E+00,&
     -0.27463E+00,-0.27502E+00,-0.27540E+00,-0.27576E+00,-0.27611E+00,&
     -0.27645E+00,-0.27677E+00,-0.27708E+00,-0.27738E+00,-0.27767E+00,&
     -0.27794E+00,-0.27821E+00,-0.27846E+00,-0.27870E+00,-0.27892E+00,&
     -0.27914E+00,-0.27935E+00,-0.27954E+00,-0.27972E+00,-0.27989E+00,&
     -0.28005E+00,-0.28020E+00,-0.28034E+00,-0.28047E+00,-0.28058E+00,&
     -0.28069E+00,-0.28078E+00,-0.28086E+00,-0.28093E+00,-0.28099E+00,&
     -0.28104E+00,-0.28108E+00,-0.28111E+00,-0.28112E+00,-0.28113E+00,&
     -0.28113E+00,-0.28111E+00,-0.28109E+00,-0.28106E+00,-0.28101E+00,&
     -0.28096E+00,-0.28090E+00,-0.28083E+00,-0.28075E+00,-0.28066E+00/
                             
     DATA (BNC06M (IA),IA=101,200)/                                     &
     -0.28057E+00,-0.28046E+00,-0.28035E+00,-0.28023E+00,-0.28010E+00,&
     -0.27997E+00,-0.27983E+00,-0.27968E+00,-0.27953E+00,-0.27937E+00,&
     -0.27920E+00,-0.27903E+00,-0.27886E+00,-0.27868E+00,-0.27849E+00,&
     -0.27830E+00,-0.27810E+00,-0.27790E+00,-0.27770E+00,-0.27749E+00,&
     -0.27738E+00,-0.27716E+00,-0.27693E+00,-0.27670E+00,-0.27647E+00,&
     -0.27623E+00,-0.27600E+00,-0.27576E+00,-0.27552E+00,-0.27528E+00,&
     -0.27503E+00,-0.27479E+00,-0.27454E+00,-0.27430E+00,-0.27405E+00,&
     -0.27380E+00,-0.27355E+00,-0.27329E+00,-0.27304E+00,-0.27279E+00,&
     -0.27253E+00,-0.27227E+00,-0.27201E+00,-0.27176E+00,-0.27149E+00,&
     -0.27123E+00,-0.27097E+00,-0.27071E+00,-0.27044E+00,-0.27018E+00,&
     -0.26991E+00,-0.26965E+00,-0.26938E+00,-0.26911E+00,-0.26885E+00,&
     -0.26858E+00,-0.26831E+00,-0.26804E+00,-0.26777E+00,-0.26750E+00,&
     -0.26723E+00,-0.26695E+00,-0.26668E+00,-0.26641E+00,-0.26614E+00,&
     -0.26586E+00,-0.26559E+00,-0.26531E+00,-0.26504E+00,-0.26477E+00,&
     -0.26449E+00,-0.26422E+00,-0.26394E+00,-0.26366E+00,-0.26339E+00,&
     -0.26311E+00,-0.26284E+00,-0.26256E+00,-0.26228E+00,-0.26201E+00,&
     -0.26173E+00,-0.26146E+00,-0.26118E+00,-0.26090E+00,-0.26063E+00,&
     -0.26035E+00,-0.26007E+00,-0.25980E+00,-0.25952E+00,-0.25924E+00,&
     -0.25897E+00,-0.25869E+00,-0.25841E+00,-0.25814E+00,-0.25786E+00,&
     -0.25759E+00,-0.25731E+00,-0.25703E+00,-0.25676E+00,-0.25648E+00/
                             
     DATA (BNC06M (IA),IA=201,300)/                                     &
     -0.25621E+00,-0.25593E+00,-0.25566E+00,-0.25538E+00,-0.25511E+00,&
     -0.25483E+00,-0.25456E+00,-0.25429E+00,-0.25401E+00,-0.25374E+00,&
     -0.25347E+00,-0.25319E+00,-0.25292E+00,-0.25265E+00,-0.25238E+00,&
     -0.25211E+00,-0.25183E+00,-0.25156E+00,-0.25129E+00,-0.25102E+00,&
     -0.25075E+00,-0.25048E+00,-0.25021E+00,-0.24994E+00,-0.24967E+00,&
     -0.24941E+00,-0.24914E+00,-0.24887E+00,-0.24860E+00,-0.24834E+00,&
     -0.24807E+00,-0.24780E+00,-0.24754E+00,-0.24727E+00,-0.24701E+00,&
     -0.24674E+00,-0.24648E+00,-0.24622E+00,-0.24595E+00,-0.24569E+00,&
     -0.24543E+00,-0.24517E+00,-0.24491E+00,-0.24464E+00,-0.24438E+00,&
     -0.24412E+00,-0.24386E+00,-0.24360E+00,-0.24335E+00,-0.24309E+00,&
     -0.24283E+00,-0.24257E+00,-0.24232E+00,-0.24206E+00,-0.24180E+00,&
     -0.24155E+00,-0.24129E+00,-0.24104E+00,-0.24078E+00,-0.24053E+00,&
     -0.24028E+00,-0.24002E+00,-0.23977E+00,-0.23952E+00,-0.23927E+00,&
     -0.23902E+00,-0.23877E+00,-0.23852E+00,-0.23827E+00,-0.23802E+00,&
     -0.23777E+00,-0.23753E+00,-0.23728E+00,-0.23703E+00,-0.23679E+00,&
     -0.23654E+00,-0.23630E+00,-0.23605E+00,-0.23581E+00,-0.23556E+00,&
     -0.23532E+00,-0.23508E+00,-0.23484E+00,-0.23460E+00,-0.23436E+00,&
     -0.23412E+00,-0.23388E+00,-0.23364E+00,-0.23340E+00,-0.23316E+00,&
     -0.23292E+00,-0.23269E+00,-0.23245E+00,-0.23221E+00,-0.23198E+00,&
     -0.23174E+00,-0.23151E+00,-0.23128E+00,-0.23104E+00,-0.23081E+00/
                             
     DATA (BNC06M (IA),IA=301,400)/                                     &
     -0.23058E+00,-0.23035E+00,-0.23012E+00,-0.22988E+00,-0.22965E+00,&
     -0.22943E+00,-0.22920E+00,-0.22897E+00,-0.22874E+00,-0.22851E+00,&
     -0.22829E+00,-0.22806E+00,-0.22784E+00,-0.22761E+00,-0.22739E+00,&
     -0.22716E+00,-0.22694E+00,-0.22672E+00,-0.22649E+00,-0.22627E+00,&
     -0.22605E+00,-0.22583E+00,-0.22561E+00,-0.22539E+00,-0.22517E+00,&
     -0.22495E+00,-0.22474E+00,-0.22452E+00,-0.22430E+00,-0.22409E+00,&
     -0.22387E+00,-0.22366E+00,-0.22344E+00,-0.22323E+00,-0.22301E+00,&
     -0.22280E+00,-0.22259E+00,-0.22238E+00,-0.22217E+00,-0.22196E+00,&
     -0.22175E+00,-0.22154E+00,-0.22133E+00,-0.22112E+00,-0.22091E+00,&
     -0.22070E+00,-0.22050E+00,-0.22029E+00,-0.22008E+00,-0.21988E+00,&
     -0.21968E+00,-0.21947E+00,-0.21927E+00,-0.21906E+00,-0.21886E+00,&
     -0.21866E+00,-0.21846E+00,-0.21826E+00,-0.21806E+00,-0.21786E+00,&
     -0.21766E+00,-0.21746E+00,-0.21726E+00,-0.21707E+00,-0.21687E+00,&
     -0.21667E+00,-0.21648E+00,-0.21628E+00,-0.21609E+00,-0.21589E+00,&
     -0.21570E+00,-0.21551E+00,-0.21531E+00,-0.21512E+00,-0.21493E+00,&
     -0.21474E+00,-0.21455E+00,-0.21436E+00,-0.21417E+00,-0.21398E+00,&
     -0.21379E+00,-0.21360E+00,-0.21342E+00,-0.21323E+00,-0.21304E+00,&
     -0.21286E+00,-0.21267E+00,-0.21249E+00,-0.21230E+00,-0.21212E+00,&
     -0.21194E+00,-0.21176E+00,-0.21157E+00,-0.21139E+00,-0.21121E+00,&
     -0.21103E+00,-0.21085E+00,-0.21067E+00,-0.21049E+00,-0.21032E+00/
                             
     DATA (BNC06M (IA),IA=401,500)/                                     &
     -0.21014E+00,-0.20996E+00,-0.20978E+00,-0.20961E+00,-0.20943E+00,&
     -0.20926E+00,-0.20908E+00,-0.20891E+00,-0.20873E+00,-0.20856E+00,&
     -0.20839E+00,-0.20822E+00,-0.20804E+00,-0.20787E+00,-0.20770E+00,&
     -0.20753E+00,-0.20736E+00,-0.20720E+00,-0.20703E+00,-0.20686E+00,&
     -0.20669E+00,-0.20652E+00,-0.20636E+00,-0.20619E+00,-0.20603E+00,&
     -0.20586E+00,-0.20570E+00,-0.20553E+00,-0.20537E+00,-0.20521E+00,&
     -0.20504E+00,-0.20488E+00,-0.20472E+00,-0.20456E+00,-0.20440E+00,&
     -0.20424E+00,-0.20408E+00,-0.20392E+00,-0.20376E+00,-0.20361E+00,&
     -0.20345E+00,-0.20329E+00,-0.20313E+00,-0.20298E+00,-0.20282E+00,&
     -0.20267E+00,-0.20251E+00,-0.20236E+00,-0.20221E+00,-0.20205E+00,&
     -0.20190E+00,-0.20175E+00,-0.20160E+00,-0.20145E+00,-0.20130E+00,&
     -0.20114E+00,-0.20100E+00,-0.20085E+00,-0.20070E+00,-0.20055E+00,&
     -0.20040E+00,-0.20025E+00,-0.20011E+00,-0.19996E+00,-0.19982E+00,&
     -0.19967E+00,-0.19952E+00,-0.19938E+00,-0.19924E+00,-0.19909E+00,&
     -0.19895E+00,-0.19881E+00,-0.19867E+00,-0.19852E+00,-0.19838E+00,&
     -0.19824E+00,-0.19810E+00,-0.19796E+00,-0.19782E+00,-0.19768E+00,&
     -0.19755E+00,-0.19741E+00,-0.19727E+00,-0.19713E+00,-0.19700E+00,&
     -0.19686E+00,-0.19672E+00,-0.19659E+00,-0.19646E+00,-0.19632E+00,&
     -0.19619E+00,-0.19605E+00,-0.19592E+00,-0.19579E+00,-0.19566E+00,&
     -0.19552E+00,-0.19539E+00,-0.19526E+00,-0.19513E+00,-0.19500E+00/
                             
     DATA (BNC06M (IA),IA=501,600)/                                     &
     -0.19487E+00,-0.19474E+00,-0.19462E+00,-0.19449E+00,-0.19436E+00,&
     -0.19423E+00,-0.19411E+00,-0.19398E+00,-0.19386E+00,-0.19373E+00,&
     -0.19361E+00,-0.19348E+00,-0.19336E+00,-0.19323E+00,-0.19311E+00,&
     -0.19299E+00,-0.19286E+00,-0.19274E+00,-0.19262E+00,-0.19250E+00,&
     -0.19238E+00,-0.19226E+00,-0.19214E+00,-0.19202E+00,-0.19190E+00,&
     -0.19178E+00,-0.19167E+00,-0.19155E+00,-0.19143E+00,-0.19131E+00,&
     -0.19120E+00,-0.19108E+00,-0.19097E+00,-0.19085E+00,-0.19074E+00,&
     -0.19062E+00,-0.19051E+00,-0.19040E+00,-0.19028E+00,-0.19017E+00,&
     -0.19006E+00,-0.18995E+00,-0.18984E+00,-0.18972E+00,-0.18961E+00,&
     -0.18950E+00,-0.18939E+00,-0.18929E+00,-0.18918E+00,-0.18907E+00,&
     -0.18896E+00,-0.18885E+00,-0.18875E+00,-0.18864E+00,-0.18853E+00,&
     -0.18843E+00,-0.18832E+00,-0.18822E+00,-0.18811E+00,-0.18801E+00,&
     -0.18790E+00,-0.18780E+00,-0.18770E+00,-0.18759E+00,-0.18749E+00,&
     -0.18739E+00,-0.18729E+00,-0.18719E+00,-0.18709E+00,-0.18699E+00,&
     -0.18689E+00,-0.18679E+00,-0.18669E+00,-0.18659E+00,-0.18649E+00,&
     -0.18639E+00,-0.18629E+00,-0.18620E+00,-0.18610E+00,-0.18600E+00,&
     -0.18591E+00,-0.18581E+00,-0.18572E+00,-0.18562E+00,-0.18553E+00,&
     -0.18543E+00,-0.18534E+00,-0.18525E+00,-0.18515E+00,-0.18506E+00,&
     -0.18497E+00,-0.18488E+00,-0.18478E+00,-0.18469E+00,-0.18460E+00,&
     -0.18451E+00,-0.18442E+00,-0.18433E+00,-0.18424E+00,-0.18391E+00/
                             
     DATA (BNC06M (IA),IA=601,700)/                                     &
     -0.18320E+00,-0.18237E+00,-0.18158E+00,-0.18083E+00,-0.18010E+00,&
     -0.17942E+00,-0.17876E+00,-0.17814E+00,-0.17755E+00,-0.17700E+00,&
     -0.17647E+00,-0.17597E+00,-0.17551E+00,-0.17507E+00,-0.17467E+00,&
     -0.17429E+00,-0.17394E+00,-0.17362E+00,-0.17333E+00,-0.17306E+00,&
     -0.17282E+00,-0.17260E+00,-0.17241E+00,-0.17225E+00,-0.17211E+00,&
     -0.17200E+00,-0.17190E+00,-0.17184E+00,-0.17179E+00,-0.17177E+00,&
     -0.17177E+00,-0.17180E+00,-0.17184E+00,-0.17191E+00,-0.17200E+00,&
     -0.17210E+00,-0.17223E+00,-0.17238E+00,-0.17255E+00,-0.17274E+00,&
     -0.17295E+00,-0.17318E+00,-0.17342E+00,-0.17369E+00,-0.17397E+00,&
     -0.17427E+00,-0.17459E+00,-0.17493E+00,-0.17528E+00,-0.17565E+00,&
     -0.17604E+00,-0.17644E+00,-0.17687E+00,-0.17730E+00,-0.17775E+00,&
     -0.17822E+00,-0.17871E+00,-0.17921E+00,-0.17972E+00,-0.18025E+00,&
     -0.18079E+00,-0.18135E+00,-0.18193E+00,-0.18251E+00,-0.18311E+00,&
     -0.18373E+00,-0.18436E+00,-0.18500E+00,-0.18565E+00,-0.18632E+00,&
     -0.18700E+00,-0.18770E+00,-0.18840E+00,-0.18912E+00,-0.18985E+00,&
     -0.19060E+00,-0.19135E+00,-0.19212E+00,-0.19290E+00,-0.19369E+00,&
     -0.19450E+00,-0.19531E+00,-0.19614E+00,-0.19697E+00,-0.19782E+00,&
     -0.19868E+00,-0.19955E+00,-0.20043E+00,-0.20132E+00,-0.20222E+00,&
     -0.20313E+00,-0.20405E+00,-0.20498E+00,-0.20592E+00,-0.20687E+00,&
     -0.20783E+00,-0.20880E+00,-0.20978E+00,-0.21077E+00,-0.21177E+00/
                             
     DATA (BNC06M(IA),IA=701,741)/                                      &
     -0.21278E+00,-0.21379E+00,-0.21482E+00,-0.21585E+00,-0.21690E+00,&
     -0.21795E+00,-0.21901E+00,-0.22008E+00,-0.22116E+00,-0.22224E+00,&
     -0.22334E+00,-0.22444E+00,-0.22555E+00,-0.22667E+00,-0.22780E+00,&
     -0.22893E+00,-0.23007E+00,-0.23122E+00,-0.23238E+00,-0.23355E+00,&
     -0.23472E+00,-0.23590E+00,-0.23709E+00,-0.23828E+00,-0.23949E+00,&
     -0.24070E+00,-0.24191E+00,-0.24314E+00,-0.24437E+00,-0.24561E+00,&
     -0.24685E+00,-0.24810E+00,-0.24936E+00,-0.25062E+00,-0.25189E+00,&
     -0.25317E+00,-0.25446E+00,-0.25575E+00,-0.25704E+00,-0.25835E+00,&
     -0.25966E+00                  /                      
!                            
!  ** (2H, SO4)              
!                            
     DATA (BNC07M (IA),IA=  1,100)/                                     &
     -0.10830E+00,-0.19774E+00,-0.26106E+00,-0.30438E+00,-0.33792E+00,&
     -0.36551E+00,-0.38903E+00,-0.40959E+00,-0.42789E+00,-0.44440E+00,&
     -0.45945E+00,-0.47329E+00,-0.48612E+00,-0.49807E+00,-0.50926E+00,&
     -0.51980E+00,-0.52976E+00,-0.53920E+00,-0.54817E+00,-0.55673E+00,&
     -0.56491E+00,-0.57275E+00,-0.58028E+00,-0.58752E+00,-0.59449E+00,&
     -0.60122E+00,-0.60772E+00,-0.61401E+00,-0.62011E+00,-0.62602E+00,&
     -0.63176E+00,-0.63734E+00,-0.64277E+00,-0.64805E+00,-0.65321E+00,&
     -0.65823E+00,-0.66313E+00,-0.66792E+00,-0.67261E+00,-0.67718E+00,&
     -0.68166E+00,-0.68605E+00,-0.69035E+00,-0.69456E+00,-0.69869E+00,&
     -0.70275E+00,-0.70673E+00,-0.71063E+00,-0.71447E+00,-0.71824E+00,&
     -0.72195E+00,-0.72560E+00,-0.72919E+00,-0.73272E+00,-0.73620E+00,&
     -0.73963E+00,-0.74301E+00,-0.74633E+00,-0.74961E+00,-0.75285E+00,&
     -0.75604E+00,-0.75919E+00,-0.76230E+00,-0.76537E+00,-0.76840E+00,&
     -0.77139E+00,-0.77435E+00,-0.77727E+00,-0.78016E+00,-0.78302E+00,&
     -0.78584E+00,-0.78863E+00,-0.79140E+00,-0.79414E+00,-0.79684E+00,&
     -0.79952E+00,-0.80218E+00,-0.80481E+00,-0.80741E+00,-0.80999E+00,&
     -0.81255E+00,-0.81509E+00,-0.81760E+00,-0.82009E+00,-0.82256E+00,&
     -0.82501E+00,-0.82744E+00,-0.82985E+00,-0.83224E+00,-0.83461E+00,&
     -0.83697E+00,-0.83930E+00,-0.84162E+00,-0.84393E+00,-0.84621E+00,&
     -0.84848E+00,-0.85074E+00,-0.85298E+00,-0.85520E+00,-0.85741E+00/
                             
     DATA (BNC07M (IA),IA=101,200)/                                     &
     -0.85961E+00,-0.86179E+00,-0.86396E+00,-0.86611E+00,-0.86825E+00,&
     -0.87038E+00,-0.87249E+00,-0.87459E+00,-0.87668E+00,-0.87876E+00,&
     -0.88082E+00,-0.88287E+00,-0.88491E+00,-0.88694E+00,-0.88896E+00,&
     -0.89097E+00,-0.89296E+00,-0.89495E+00,-0.89692E+00,-0.89888E+00,&
     -0.90081E+00,-0.90275E+00,-0.90469E+00,-0.90661E+00,-0.90853E+00,&
     -0.91043E+00,-0.91233E+00,-0.91421E+00,-0.91609E+00,-0.91795E+00,&
     -0.91981E+00,-0.92166E+00,-0.92349E+00,-0.92532E+00,-0.92715E+00,&
     -0.92896E+00,-0.93076E+00,-0.93256E+00,-0.93435E+00,-0.93613E+00,&
     -0.93790E+00,-0.93966E+00,-0.94142E+00,-0.94317E+00,-0.94491E+00,&
     -0.94664E+00,-0.94837E+00,-0.95009E+00,-0.95180E+00,-0.95351E+00,&
     -0.95521E+00,-0.95690E+00,-0.95858E+00,-0.96026E+00,-0.96193E+00,&
     -0.96360E+00,-0.96525E+00,-0.96691E+00,-0.96855E+00,-0.97019E+00,&
     -0.97183E+00,-0.97345E+00,-0.97508E+00,-0.97669E+00,-0.97830E+00,&
     -0.97991E+00,-0.98150E+00,-0.98310E+00,-0.98469E+00,-0.98627E+00,&
     -0.98784E+00,-0.98942E+00,-0.99098E+00,-0.99254E+00,-0.99410E+00,&
     -0.99565E+00,-0.99719E+00,-0.99873E+00,-0.10003E+01,-0.10018E+01,&
     -0.10033E+01,-0.10048E+01,-0.10064E+01,-0.10079E+01,-0.10094E+01,&
     -0.10109E+01,-0.10124E+01,-0.10139E+01,-0.10154E+01,-0.10168E+01,&
     -0.10183E+01,-0.10198E+01,-0.10213E+01,-0.10227E+01,-0.10242E+01,&
     -0.10257E+01,-0.10271E+01,-0.10286E+01,-0.10300E+01,-0.10315E+01/
                             
     DATA (BNC07M (IA),IA=201,300)/                                     &
     -0.10329E+01,-0.10343E+01,-0.10358E+01,-0.10372E+01,-0.10386E+01,&
     -0.10400E+01,-0.10415E+01,-0.10429E+01,-0.10443E+01,-0.10457E+01,&
     -0.10471E+01,-0.10485E+01,-0.10499E+01,-0.10513E+01,-0.10527E+01,&
     -0.10540E+01,-0.10554E+01,-0.10568E+01,-0.10582E+01,-0.10595E+01,&
     -0.10609E+01,-0.10623E+01,-0.10636E+01,-0.10650E+01,-0.10663E+01,&
     -0.10677E+01,-0.10690E+01,-0.10704E+01,-0.10717E+01,-0.10731E+01,&
     -0.10744E+01,-0.10757E+01,-0.10771E+01,-0.10784E+01,-0.10797E+01,&
     -0.10810E+01,-0.10824E+01,-0.10837E+01,-0.10850E+01,-0.10863E+01,&
     -0.10876E+01,-0.10889E+01,-0.10902E+01,-0.10915E+01,-0.10928E+01,&
     -0.10941E+01,-0.10954E+01,-0.10967E+01,-0.10980E+01,-0.10993E+01,&
     -0.11005E+01,-0.11018E+01,-0.11031E+01,-0.11044E+01,-0.11056E+01,&
     -0.11069E+01,-0.11082E+01,-0.11094E+01,-0.11107E+01,-0.11120E+01,&
     -0.11132E+01,-0.11145E+01,-0.11157E+01,-0.11170E+01,-0.11182E+01,&
     -0.11195E+01,-0.11207E+01,-0.11220E+01,-0.11232E+01,-0.11244E+01,&
     -0.11257E+01,-0.11269E+01,-0.11281E+01,-0.11294E+01,-0.11306E+01,&
     -0.11318E+01,-0.11330E+01,-0.11342E+01,-0.11355E+01,-0.11367E+01,&
     -0.11379E+01,-0.11391E+01,-0.11403E+01,-0.11415E+01,-0.11427E+01,&
     -0.11439E+01,-0.11451E+01,-0.11463E+01,-0.11475E+01,-0.11487E+01,&
     -0.11499E+01,-0.11511E+01,-0.11523E+01,-0.11535E+01,-0.11547E+01,&
     -0.11559E+01,-0.11570E+01,-0.11582E+01,-0.11594E+01,-0.11606E+01/
                             
     DATA (BNC07M (IA),IA=301,400)/                                     &
     -0.11617E+01,-0.11629E+01,-0.11641E+01,-0.11653E+01,-0.11664E+01,&
     -0.11676E+01,-0.11688E+01,-0.11699E+01,-0.11711E+01,-0.11722E+01,&
     -0.11734E+01,-0.11746E+01,-0.11757E+01,-0.11769E+01,-0.11780E+01,&
     -0.11792E+01,-0.11803E+01,-0.11815E+01,-0.11826E+01,-0.11837E+01,&
     -0.11849E+01,-0.11860E+01,-0.11872E+01,-0.11883E+01,-0.11894E+01,&
     -0.11906E+01,-0.11917E+01,-0.11928E+01,-0.11940E+01,-0.11951E+01,&
     -0.11962E+01,-0.11973E+01,-0.11985E+01,-0.11996E+01,-0.12007E+01,&
     -0.12018E+01,-0.12029E+01,-0.12041E+01,-0.12052E+01,-0.12063E+01,&
     -0.12074E+01,-0.12085E+01,-0.12096E+01,-0.12107E+01,-0.12118E+01,&
     -0.12129E+01,-0.12140E+01,-0.12151E+01,-0.12162E+01,-0.12173E+01,&
     -0.12184E+01,-0.12195E+01,-0.12206E+01,-0.12217E+01,-0.12228E+01,&
     -0.12239E+01,-0.12250E+01,-0.12261E+01,-0.12272E+01,-0.12283E+01,&
     -0.12293E+01,-0.12304E+01,-0.12315E+01,-0.12326E+01,-0.12337E+01,&
     -0.12348E+01,-0.12358E+01,-0.12369E+01,-0.12380E+01,-0.12391E+01,&
     -0.12401E+01,-0.12412E+01,-0.12423E+01,-0.12433E+01,-0.12444E+01,&
     -0.12455E+01,-0.12465E+01,-0.12476E+01,-0.12487E+01,-0.12497E+01,&
     -0.12508E+01,-0.12519E+01,-0.12529E+01,-0.12540E+01,-0.12550E+01,&
     -0.12561E+01,-0.12571E+01,-0.12582E+01,-0.12592E+01,-0.12603E+01,&
     -0.12613E+01,-0.12624E+01,-0.12634E+01,-0.12645E+01,-0.12655E+01,&
     -0.12666E+01,-0.12676E+01,-0.12687E+01,-0.12697E+01,-0.12708E+01/
                             
     DATA (BNC07M (IA),IA=401,500)/                                     &
     -0.12718E+01,-0.12728E+01,-0.12739E+01,-0.12749E+01,-0.12759E+01,&
     -0.12770E+01,-0.12780E+01,-0.12790E+01,-0.12801E+01,-0.12811E+01,&
     -0.12821E+01,-0.12832E+01,-0.12842E+01,-0.12852E+01,-0.12862E+01,&
     -0.12873E+01,-0.12883E+01,-0.12893E+01,-0.12903E+01,-0.12914E+01,&
     -0.12924E+01,-0.12934E+01,-0.12944E+01,-0.12954E+01,-0.12964E+01,&
     -0.12975E+01,-0.12985E+01,-0.12995E+01,-0.13005E+01,-0.13015E+01,&
     -0.13025E+01,-0.13035E+01,-0.13045E+01,-0.13055E+01,-0.13066E+01,&
     -0.13076E+01,-0.13086E+01,-0.13096E+01,-0.13106E+01,-0.13116E+01,&
     -0.13126E+01,-0.13136E+01,-0.13146E+01,-0.13156E+01,-0.13166E+01,&
     -0.13176E+01,-0.13186E+01,-0.13196E+01,-0.13206E+01,-0.13216E+01,&
     -0.13226E+01,-0.13235E+01,-0.13245E+01,-0.13255E+01,-0.13265E+01,&
     -0.13275E+01,-0.13285E+01,-0.13295E+01,-0.13305E+01,-0.13315E+01,&
     -0.13324E+01,-0.13334E+01,-0.13344E+01,-0.13354E+01,-0.13364E+01,&
     -0.13374E+01,-0.13383E+01,-0.13393E+01,-0.13403E+01,-0.13413E+01,&
     -0.13423E+01,-0.13432E+01,-0.13442E+01,-0.13452E+01,-0.13462E+01,&
     -0.13471E+01,-0.13481E+01,-0.13491E+01,-0.13500E+01,-0.13510E+01,&
     -0.13520E+01,-0.13530E+01,-0.13539E+01,-0.13549E+01,-0.13559E+01,&
     -0.13568E+01,-0.13578E+01,-0.13588E+01,-0.13597E+01,-0.13607E+01,&
     -0.13617E+01,-0.13626E+01,-0.13636E+01,-0.13645E+01,-0.13655E+01,&
     -0.13665E+01,-0.13674E+01,-0.13684E+01,-0.13693E+01,-0.13703E+01/
                             
     DATA (BNC07M (IA),IA=501,600)/                                     &
     -0.13712E+01,-0.13722E+01,-0.13732E+01,-0.13741E+01,-0.13751E+01,&
     -0.13760E+01,-0.13770E+01,-0.13779E+01,-0.13789E+01,-0.13798E+01,&
     -0.13808E+01,-0.13817E+01,-0.13827E+01,-0.13836E+01,-0.13846E+01,&
     -0.13855E+01,-0.13865E+01,-0.13874E+01,-0.13883E+01,-0.13893E+01,&
     -0.13902E+01,-0.13912E+01,-0.13921E+01,-0.13931E+01,-0.13940E+01,&
     -0.13949E+01,-0.13959E+01,-0.13968E+01,-0.13978E+01,-0.13987E+01,&
     -0.13996E+01,-0.14006E+01,-0.14015E+01,-0.14024E+01,-0.14034E+01,&
     -0.14043E+01,-0.14052E+01,-0.14062E+01,-0.14071E+01,-0.14080E+01,&
     -0.14090E+01,-0.14099E+01,-0.14108E+01,-0.14118E+01,-0.14127E+01,&
     -0.14136E+01,-0.14145E+01,-0.14155E+01,-0.14164E+01,-0.14173E+01,&
     -0.14182E+01,-0.14192E+01,-0.14201E+01,-0.14210E+01,-0.14219E+01,&
     -0.14229E+01,-0.14238E+01,-0.14247E+01,-0.14256E+01,-0.14265E+01,&
     -0.14275E+01,-0.14284E+01,-0.14293E+01,-0.14302E+01,-0.14311E+01,&
     -0.14321E+01,-0.14330E+01,-0.14339E+01,-0.14348E+01,-0.14357E+01,&
     -0.14366E+01,-0.14375E+01,-0.14385E+01,-0.14394E+01,-0.14403E+01,&
     -0.14412E+01,-0.14421E+01,-0.14430E+01,-0.14439E+01,-0.14448E+01,&
     -0.14457E+01,-0.14467E+01,-0.14476E+01,-0.14485E+01,-0.14494E+01,&
     -0.14503E+01,-0.14512E+01,-0.14521E+01,-0.14530E+01,-0.14539E+01,&
     -0.14548E+01,-0.14557E+01,-0.14566E+01,-0.14575E+01,-0.14584E+01,&
     -0.14593E+01,-0.14602E+01,-0.14611E+01,-0.14620E+01,-0.14654E+01/
                             
     DATA (BNC07M (IA),IA=601,700)/                                     &
     -0.14728E+01,-0.14817E+01,-0.14906E+01,-0.14994E+01,-0.15082E+01,&
     -0.15170E+01,-0.15257E+01,-0.15343E+01,-0.15430E+01,-0.15515E+01,&
     -0.15601E+01,-0.15686E+01,-0.15771E+01,-0.15856E+01,-0.15940E+01,&
     -0.16024E+01,-0.16107E+01,-0.16191E+01,-0.16274E+01,-0.16356E+01,&
     -0.16439E+01,-0.16521E+01,-0.16603E+01,-0.16684E+01,-0.16766E+01,&
     -0.16847E+01,-0.16928E+01,-0.17008E+01,-0.17089E+01,-0.17169E+01,&
     -0.17249E+01,-0.17328E+01,-0.17408E+01,-0.17487E+01,-0.17566E+01,&
     -0.17645E+01,-0.17723E+01,-0.17802E+01,-0.17880E+01,-0.17958E+01,&
     -0.18036E+01,-0.18114E+01,-0.18191E+01,-0.18268E+01,-0.18346E+01,&
     -0.18423E+01,-0.18499E+01,-0.18576E+01,-0.18652E+01,-0.18729E+01,&
     -0.18805E+01,-0.18881E+01,-0.18957E+01,-0.19032E+01,-0.19108E+01,&
     -0.19183E+01,-0.19258E+01,-0.19334E+01,-0.19409E+01,-0.19483E+01,&
     -0.19558E+01,-0.19633E+01,-0.19707E+01,-0.19781E+01,-0.19855E+01,&
     -0.19929E+01,-0.20003E+01,-0.20077E+01,-0.20151E+01,-0.20224E+01,&
     -0.20298E+01,-0.20371E+01,-0.20444E+01,-0.20517E+01,-0.20590E+01,&
     -0.20663E+01,-0.20736E+01,-0.20808E+01,-0.20881E+01,-0.20953E+01,&
     -0.21026E+01,-0.21098E+01,-0.21170E+01,-0.21242E+01,-0.21314E+01,&
     -0.21386E+01,-0.21457E+01,-0.21529E+01,-0.21601E+01,-0.21672E+01,&
     -0.21743E+01,-0.21815E+01,-0.21886E+01,-0.21957E+01,-0.22028E+01,&
     -0.22099E+01,-0.22169E+01,-0.22240E+01,-0.22311E+01,-0.22381E+01/
                             
     DATA (BNC07M(IA),IA=701,741)/                                      &
     -0.22452E+01,-0.22522E+01,-0.22593E+01,-0.22663E+01,-0.22733E+01,&
     -0.22803E+01,-0.22873E+01,-0.22943E+01,-0.23013E+01,-0.23082E+01,&
     -0.23152E+01,-0.23222E+01,-0.23291E+01,-0.23361E+01,-0.23430E+01,&
     -0.23499E+01,-0.23569E+01,-0.23638E+01,-0.23707E+01,-0.23776E+01,&
     -0.23845E+01,-0.23914E+01,-0.23983E+01,-0.24052E+01,-0.24120E+01,&
     -0.24189E+01,-0.24258E+01,-0.24326E+01,-0.24395E+01,-0.24463E+01,&
     -0.24531E+01,-0.24600E+01,-0.24668E+01,-0.24736E+01,-0.24804E+01,&
     -0.24872E+01,-0.24940E+01,-0.25008E+01,-0.25076E+01,-0.25144E+01,&
     -0.25211E+01                  /                      
!                            
!  ** (H, HSO4)              
!                            
     DATA (BNC08M (IA),IA=  1,100)/                                     &
     -0.50088E-01,-0.84806E-01,-0.10501E+00,-0.11624E+00,-0.12318E+00,&
     -0.12753E+00,-0.13011E+00,-0.13139E+00,-0.13166E+00,-0.13112E+00,&
     -0.12989E+00,-0.12809E+00,-0.12579E+00,-0.12304E+00,-0.11990E+00,&
     -0.11640E+00,-0.11257E+00,-0.10844E+00,-0.10403E+00,-0.99358E-01,&
     -0.94441E-01,-0.89293E-01,-0.83928E-01,-0.78356E-01,-0.72588E-01,&
     -0.66634E-01,-0.60502E-01,-0.54201E-01,-0.47738E-01,-0.41119E-01,&
     -0.34352E-01,-0.27443E-01,-0.20397E-01,-0.13221E-01,-0.59198E-02,&
      0.15015E-02, 0.90380E-02, 0.16685E-01, 0.24437E-01, 0.32290E-01,&
      0.40241E-01, 0.48284E-01, 0.56416E-01, 0.64634E-01, 0.72933E-01,&
      0.81310E-01, 0.89763E-01, 0.98287E-01, 0.10688E+00, 0.11554E+00,&
      0.12426E+00, 0.13304E+00, 0.14189E+00, 0.15078E+00, 0.15974E+00,&
      0.16874E+00, 0.17780E+00, 0.18691E+00, 0.19606E+00, 0.20527E+00,&
      0.21452E+00, 0.22381E+00, 0.23315E+00, 0.24254E+00, 0.25197E+00,&
      0.26144E+00, 0.27096E+00, 0.28052E+00, 0.29013E+00, 0.29978E+00,&
      0.30948E+00, 0.31922E+00, 0.32902E+00, 0.33885E+00, 0.34874E+00,&
      0.35868E+00, 0.36866E+00, 0.37870E+00, 0.38878E+00, 0.39892E+00,&
      0.40911E+00, 0.41936E+00, 0.42965E+00, 0.44000E+00, 0.45041E+00,&
      0.46087E+00, 0.47138E+00, 0.48195E+00, 0.49257E+00, 0.50325E+00,&
      0.51398E+00, 0.52476E+00, 0.53560E+00, 0.54648E+00, 0.55742E+00,&
      0.56840E+00, 0.57944E+00, 0.59052E+00, 0.60164E+00, 0.61281E+00/
                             
     DATA (BNC08M (IA),IA=101,200)/                                     &
      0.62402E+00, 0.63527E+00, 0.64656E+00, 0.65788E+00, 0.66924E+00,&
      0.68062E+00, 0.69204E+00, 0.70349E+00, 0.71496E+00, 0.72646E+00,&
      0.73797E+00, 0.74951E+00, 0.76106E+00, 0.77263E+00, 0.78421E+00,&
      0.79581E+00, 0.80741E+00, 0.81902E+00, 0.83063E+00, 0.84225E+00,&
      0.85289E+00, 0.86463E+00, 0.87635E+00, 0.88806E+00, 0.89976E+00,&
      0.91145E+00, 0.92312E+00, 0.93477E+00, 0.94641E+00, 0.95804E+00,&
      0.96965E+00, 0.98124E+00, 0.99282E+00, 0.10044E+01, 0.10159E+01,&
      0.10274E+01, 0.10390E+01, 0.10504E+01, 0.10619E+01, 0.10734E+01,&
      0.10848E+01, 0.10962E+01, 0.11076E+01, 0.11190E+01, 0.11303E+01,&
      0.11417E+01, 0.11530E+01, 0.11643E+01, 0.11756E+01, 0.11868E+01,&
      0.11980E+01, 0.12093E+01, 0.12204E+01, 0.12316E+01, 0.12428E+01,&
      0.12539E+01, 0.12650E+01, 0.12761E+01, 0.12871E+01, 0.12982E+01,&
      0.13092E+01, 0.13202E+01, 0.13311E+01, 0.13421E+01, 0.13530E+01,&
      0.13639E+01, 0.13748E+01, 0.13857E+01, 0.13965E+01, 0.14073E+01,&
      0.14181E+01, 0.14289E+01, 0.14396E+01, 0.14504E+01, 0.14611E+01,&
      0.14717E+01, 0.14824E+01, 0.14930E+01, 0.15036E+01, 0.15142E+01,&
      0.15248E+01, 0.15353E+01, 0.15458E+01, 0.15563E+01, 0.15668E+01,&
      0.15773E+01, 0.15877E+01, 0.15981E+01, 0.16085E+01, 0.16188E+01,&
      0.16292E+01, 0.16395E+01, 0.16498E+01, 0.16600E+01, 0.16703E+01,&
      0.16805E+01, 0.16907E+01, 0.17009E+01, 0.17110E+01, 0.17212E+01/
                             
     DATA (BNC08M (IA),IA=201,300)/                                     &
      0.17313E+01, 0.17414E+01, 0.17514E+01, 0.17615E+01, 0.17715E+01,&
      0.17815E+01, 0.17915E+01, 0.18014E+01, 0.18114E+01, 0.18213E+01,&
      0.18312E+01, 0.18410E+01, 0.18509E+01, 0.18607E+01, 0.18705E+01,&
      0.18803E+01, 0.18901E+01, 0.18998E+01, 0.19095E+01, 0.19192E+01,&
      0.19289E+01, 0.19385E+01, 0.19482E+01, 0.19578E+01, 0.19674E+01,&
      0.19769E+01, 0.19865E+01, 0.19960E+01, 0.20055E+01, 0.20150E+01,&
      0.20244E+01, 0.20339E+01, 0.20433E+01, 0.20527E+01, 0.20621E+01,&
      0.20715E+01, 0.20808E+01, 0.20901E+01, 0.20994E+01, 0.21087E+01,&
      0.21179E+01, 0.21272E+01, 0.21364E+01, 0.21456E+01, 0.21548E+01,&
      0.21639E+01, 0.21731E+01, 0.21822E+01, 0.21913E+01, 0.22004E+01,&
      0.22094E+01, 0.22185E+01, 0.22275E+01, 0.22365E+01, 0.22455E+01,&
      0.22545E+01, 0.22634E+01, 0.22723E+01, 0.22812E+01, 0.22901E+01,&
      0.22990E+01, 0.23078E+01, 0.23167E+01, 0.23255E+01, 0.23343E+01,&
      0.23431E+01, 0.23518E+01, 0.23606E+01, 0.23693E+01, 0.23780E+01,&
      0.23867E+01, 0.23953E+01, 0.24040E+01, 0.24126E+01, 0.24212E+01,&
      0.24298E+01, 0.24384E+01, 0.24470E+01, 0.24555E+01, 0.24640E+01,&
      0.24725E+01, 0.24810E+01, 0.24895E+01, 0.24980E+01, 0.25064E+01,&
      0.25148E+01, 0.25232E+01, 0.25316E+01, 0.25400E+01, 0.25483E+01,&
      0.25567E+01, 0.25650E+01, 0.25733E+01, 0.25816E+01, 0.25898E+01,&
      0.25981E+01, 0.26063E+01, 0.26145E+01, 0.26227E+01, 0.26309E+01/
                             
     DATA (BNC08M (IA),IA=301,400)/                                     &
      0.26391E+01, 0.26472E+01, 0.26554E+01, 0.26635E+01, 0.26716E+01,&
      0.26797E+01, 0.26877E+01, 0.26958E+01, 0.27038E+01, 0.27119E+01,&
      0.27199E+01, 0.27279E+01, 0.27358E+01, 0.27438E+01, 0.27517E+01,&
      0.27597E+01, 0.27676E+01, 0.27755E+01, 0.27834E+01, 0.27912E+01,&
      0.27991E+01, 0.28069E+01, 0.28148E+01, 0.28226E+01, 0.28304E+01,&
      0.28381E+01, 0.28459E+01, 0.28536E+01, 0.28614E+01, 0.28691E+01,&
      0.28768E+01, 0.28845E+01, 0.28922E+01, 0.28998E+01, 0.29075E+01,&
      0.29151E+01, 0.29227E+01, 0.29303E+01, 0.29379E+01, 0.29455E+01,&
      0.29530E+01, 0.29606E+01, 0.29681E+01, 0.29756E+01, 0.29831E+01,&
      0.29906E+01, 0.29981E+01, 0.30055E+01, 0.30130E+01, 0.30204E+01,&
      0.30278E+01, 0.30353E+01, 0.30426E+01, 0.30500E+01, 0.30574E+01,&
      0.30647E+01, 0.30721E+01, 0.30794E+01, 0.30867E+01, 0.30940E+01,&
      0.31013E+01, 0.31086E+01, 0.31158E+01, 0.31231E+01, 0.31303E+01,&
      0.31375E+01, 0.31447E+01, 0.31519E+01, 0.31591E+01, 0.31663E+01,&
      0.31734E+01, 0.31806E+01, 0.31877E+01, 0.31948E+01, 0.32019E+01,&
      0.32090E+01, 0.32161E+01, 0.32231E+01, 0.32302E+01, 0.32372E+01,&
      0.32443E+01, 0.32513E+01, 0.32583E+01, 0.32653E+01, 0.32722E+01,&
      0.32792E+01, 0.32862E+01, 0.32931E+01, 0.33000E+01, 0.33069E+01,&
      0.33139E+01, 0.33207E+01, 0.33276E+01, 0.33345E+01, 0.33414E+01,&
      0.33482E+01, 0.33550E+01, 0.33619E+01, 0.33687E+01, 0.33755E+01/
                             
     DATA (BNC08M (IA),IA=401,500)/                                     &
      0.33823E+01, 0.33890E+01, 0.33958E+01, 0.34026E+01, 0.34093E+01,&
      0.34160E+01, 0.34227E+01, 0.34294E+01, 0.34361E+01, 0.34428E+01,&
      0.34495E+01, 0.34562E+01, 0.34628E+01, 0.34695E+01, 0.34761E+01,&
      0.34827E+01, 0.34893E+01, 0.34959E+01, 0.35025E+01, 0.35091E+01,&
      0.35156E+01, 0.35222E+01, 0.35287E+01, 0.35352E+01, 0.35418E+01,&
      0.35483E+01, 0.35548E+01, 0.35612E+01, 0.35677E+01, 0.35742E+01,&
      0.35806E+01, 0.35871E+01, 0.35935E+01, 0.35999E+01, 0.36064E+01,&
      0.36128E+01, 0.36192E+01, 0.36255E+01, 0.36319E+01, 0.36383E+01,&
      0.36446E+01, 0.36510E+01, 0.36573E+01, 0.36636E+01, 0.36699E+01,&
      0.36762E+01, 0.36825E+01, 0.36888E+01, 0.36951E+01, 0.37013E+01,&
      0.37076E+01, 0.37138E+01, 0.37200E+01, 0.37262E+01, 0.37325E+01,&
      0.37387E+01, 0.37448E+01, 0.37510E+01, 0.37572E+01, 0.37634E+01,&
      0.37695E+01, 0.37757E+01, 0.37818E+01, 0.37879E+01, 0.37940E+01,&
      0.38001E+01, 0.38062E+01, 0.38123E+01, 0.38184E+01, 0.38244E+01,&
      0.38305E+01, 0.38365E+01, 0.38426E+01, 0.38486E+01, 0.38546E+01,&
      0.38606E+01, 0.38666E+01, 0.38726E+01, 0.38786E+01, 0.38846E+01,&
      0.38906E+01, 0.38965E+01, 0.39025E+01, 0.39084E+01, 0.39143E+01,&
      0.39202E+01, 0.39261E+01, 0.39320E+01, 0.39379E+01, 0.39438E+01,&
      0.39497E+01, 0.39556E+01, 0.39614E+01, 0.39673E+01, 0.39731E+01,&
      0.39789E+01, 0.39847E+01, 0.39906E+01, 0.39964E+01, 0.40022E+01/
                             
     DATA (BNC08M (IA),IA=501,600)/                                     &
      0.40079E+01, 0.40137E+01, 0.40195E+01, 0.40253E+01, 0.40310E+01,&
      0.40368E+01, 0.40425E+01, 0.40482E+01, 0.40539E+01, 0.40596E+01,&
      0.40653E+01, 0.40710E+01, 0.40767E+01, 0.40824E+01, 0.40881E+01,&
      0.40937E+01, 0.40994E+01, 0.41050E+01, 0.41107E+01, 0.41163E+01,&
      0.41219E+01, 0.41275E+01, 0.41331E+01, 0.41387E+01, 0.41443E+01,&
      0.41499E+01, 0.41554E+01, 0.41610E+01, 0.41666E+01, 0.41721E+01,&
      0.41776E+01, 0.41832E+01, 0.41887E+01, 0.41942E+01, 0.41997E+01,&
      0.42052E+01, 0.42107E+01, 0.42162E+01, 0.42217E+01, 0.42271E+01,&
      0.42326E+01, 0.42381E+01, 0.42435E+01, 0.42489E+01, 0.42544E+01,&
      0.42598E+01, 0.42652E+01, 0.42706E+01, 0.42760E+01, 0.42814E+01,&
      0.42868E+01, 0.42922E+01, 0.42975E+01, 0.43029E+01, 0.43082E+01,&
      0.43136E+01, 0.43189E+01, 0.43243E+01, 0.43296E+01, 0.43349E+01,&
      0.43402E+01, 0.43455E+01, 0.43508E+01, 0.43561E+01, 0.43614E+01,&
      0.43667E+01, 0.43719E+01, 0.43772E+01, 0.43824E+01, 0.43877E+01,&
      0.43929E+01, 0.43982E+01, 0.44034E+01, 0.44086E+01, 0.44138E+01,&
      0.44190E+01, 0.44242E+01, 0.44294E+01, 0.44346E+01, 0.44397E+01,&
      0.44449E+01, 0.44501E+01, 0.44552E+01, 0.44604E+01, 0.44655E+01,&
      0.44706E+01, 0.44758E+01, 0.44809E+01, 0.44860E+01, 0.44911E+01,&
      0.44962E+01, 0.45013E+01, 0.45064E+01, 0.45115E+01, 0.45165E+01,&
      0.45216E+01, 0.45267E+01, 0.45317E+01, 0.45368E+01, 0.45556E+01/
                             
     DATA (BNC08M (IA),IA=601,700)/                                     &
      0.45968E+01, 0.46461E+01, 0.46948E+01, 0.47428E+01, 0.47903E+01,&
      0.48372E+01, 0.48835E+01, 0.49293E+01, 0.49745E+01, 0.50191E+01,&
      0.50633E+01, 0.51069E+01, 0.51500E+01, 0.51927E+01, 0.52349E+01,&
      0.52765E+01, 0.53178E+01, 0.53586E+01, 0.53989E+01, 0.54388E+01,&
      0.54783E+01, 0.55174E+01, 0.55560E+01, 0.55943E+01, 0.56322E+01,&
      0.56696E+01, 0.57067E+01, 0.57435E+01, 0.57799E+01, 0.58159E+01,&
      0.58515E+01, 0.58869E+01, 0.59218E+01, 0.59565E+01, 0.59908E+01,&
      0.60248E+01, 0.60585E+01, 0.60919E+01, 0.61249E+01, 0.61577E+01,&
      0.61902E+01, 0.62224E+01, 0.62543E+01, 0.62859E+01, 0.63172E+01,&
      0.63483E+01, 0.63791E+01, 0.64096E+01, 0.64399E+01, 0.64699E+01,&
      0.64997E+01, 0.65292E+01, 0.65585E+01, 0.65875E+01, 0.66163E+01,&
      0.66449E+01, 0.66733E+01, 0.67014E+01, 0.67293E+01, 0.67569E+01,&
      0.67844E+01, 0.68116E+01, 0.68387E+01, 0.68655E+01, 0.68921E+01,&
      0.69185E+01, 0.69447E+01, 0.69707E+01, 0.69966E+01, 0.70222E+01,&
      0.70477E+01, 0.70729E+01, 0.70980E+01, 0.71229E+01, 0.71476E+01,&
      0.71721E+01, 0.71965E+01, 0.72207E+01, 0.72447E+01, 0.72686E+01,&
      0.72922E+01, 0.73158E+01, 0.73391E+01, 0.73623E+01, 0.73854E+01,&
      0.74082E+01, 0.74310E+01, 0.74536E+01, 0.74760E+01, 0.74983E+01,&
      0.75204E+01, 0.75424E+01, 0.75642E+01, 0.75859E+01, 0.76075E+01,&
      0.76289E+01, 0.76502E+01, 0.76714E+01, 0.76924E+01, 0.77132E+01/
                             
     DATA (BNC08M(IA),IA=701,741)/                                      &
      0.77340E+01, 0.77546E+01, 0.77751E+01, 0.77955E+01, 0.78157E+01,&
      0.78358E+01, 0.78558E+01, 0.78757E+01, 0.78955E+01, 0.79151E+01,&
      0.79346E+01, 0.79540E+01, 0.79733E+01, 0.79925E+01, 0.80115E+01,&
      0.80305E+01, 0.80493E+01, 0.80680E+01, 0.80867E+01, 0.81052E+01,&
      0.81236E+01, 0.81419E+01, 0.81601E+01, 0.81782E+01, 0.81961E+01,&
      0.82140E+01, 0.82318E+01, 0.82495E+01, 0.82671E+01, 0.82846E+01,&
      0.83020E+01, 0.83193E+01, 0.83365E+01, 0.83536E+01, 0.83706E+01,&
      0.83876E+01, 0.84044E+01, 0.84212E+01, 0.84378E+01, 0.84544E+01,&
      0.84709E+01                  /                      
!                            
!  ** NH4HSO4                
!                            
     DATA (BNC09M (IA),IA=  1,100)/                                     &
     -0.52941E-01,-0.94844E-01,-0.12343E+00,-0.14239E+00,-0.15668E+00,&
     -0.16813E+00,-0.17763E+00,-0.18572E+00,-0.19272E+00,-0.19884E+00,&
     -0.20425E+00,-0.20906E+00,-0.21335E+00,-0.21720E+00,-0.22065E+00,&
     -0.22375E+00,-0.22654E+00,-0.22903E+00,-0.23127E+00,-0.23327E+00,&
     -0.23504E+00,-0.23660E+00,-0.23797E+00,-0.23915E+00,-0.24017E+00,&
     -0.24102E+00,-0.24171E+00,-0.24226E+00,-0.24267E+00,-0.24294E+00,&
     -0.24309E+00,-0.24311E+00,-0.24302E+00,-0.24281E+00,-0.24250E+00,&
     -0.24208E+00,-0.24156E+00,-0.24094E+00,-0.24023E+00,-0.23943E+00,&
     -0.23854E+00,-0.23757E+00,-0.23652E+00,-0.23539E+00,-0.23418E+00,&
     -0.23290E+00,-0.23155E+00,-0.23014E+00,-0.22866E+00,-0.22711E+00,&
     -0.22551E+00,-0.22384E+00,-0.22212E+00,-0.22034E+00,-0.21851E+00,&
     -0.21663E+00,-0.21470E+00,-0.21272E+00,-0.21069E+00,-0.20862E+00,&
     -0.20650E+00,-0.20434E+00,-0.20214E+00,-0.19990E+00,-0.19762E+00,&
     -0.19530E+00,-0.19294E+00,-0.19054E+00,-0.18811E+00,-0.18564E+00,&
     -0.18314E+00,-0.18060E+00,-0.17803E+00,-0.17542E+00,-0.17278E+00,&
     -0.17011E+00,-0.16741E+00,-0.16467E+00,-0.16191E+00,-0.15911E+00,&
     -0.15628E+00,-0.15342E+00,-0.15053E+00,-0.14761E+00,-0.14466E+00,&
     -0.14168E+00,-0.13867E+00,-0.13563E+00,-0.13256E+00,-0.12947E+00,&
     -0.12635E+00,-0.12321E+00,-0.12003E+00,-0.11684E+00,-0.11361E+00,&
     -0.11037E+00,-0.10710E+00,-0.10381E+00,-0.10049E+00,-0.97158E-01/
                             
     DATA (BNC09M (IA),IA=101,200)/                                     &
     -0.93803E-01,-0.90429E-01,-0.87037E-01,-0.83628E-01,-0.80202E-01,&
     -0.76760E-01,-0.73304E-01,-0.69834E-01,-0.66351E-01,-0.62857E-01,&
     -0.59352E-01,-0.55836E-01,-0.52311E-01,-0.48778E-01,-0.45238E-01,&
     -0.41691E-01,-0.38138E-01,-0.34580E-01,-0.31018E-01,-0.27452E-01,&
     -0.24230E-01,-0.20619E-01,-0.17011E-01,-0.13406E-01,-0.98032E-02,&
     -0.62041E-02,-0.26086E-02, 0.98318E-03, 0.45710E-02, 0.81547E-02,&
      0.11734E-01, 0.15308E-01, 0.18878E-01, 0.22443E-01, 0.26003E-01,&
      0.29557E-01, 0.33105E-01, 0.36648E-01, 0.40186E-01, 0.43717E-01,&
      0.47242E-01, 0.50762E-01, 0.54274E-01, 0.57781E-01, 0.61281E-01,&
      0.64774E-01, 0.68261E-01, 0.71740E-01, 0.75213E-01, 0.78679E-01,&
      0.82138E-01, 0.85590E-01, 0.89034E-01, 0.92472E-01, 0.95902E-01,&
      0.99324E-01, 0.10274E+00, 0.10615E+00, 0.10955E+00, 0.11294E+00,&
      0.11633E+00, 0.11970E+00, 0.12307E+00, 0.12643E+00, 0.12979E+00,&
      0.13314E+00, 0.13647E+00, 0.13981E+00, 0.14313E+00, 0.14644E+00,&
      0.14975E+00, 0.15305E+00, 0.15634E+00, 0.15963E+00, 0.16290E+00,&
      0.16617E+00, 0.16943E+00, 0.17268E+00, 0.17593E+00, 0.17917E+00,&
      0.18239E+00, 0.18562E+00, 0.18883E+00, 0.19203E+00, 0.19523E+00,&
      0.19842E+00, 0.20160E+00, 0.20478E+00, 0.20794E+00, 0.21110E+00,&
      0.21425E+00, 0.21739E+00, 0.22053E+00, 0.22366E+00, 0.22677E+00,&
      0.22989E+00, 0.23299E+00, 0.23609E+00, 0.23917E+00, 0.24226E+00/
                             
     DATA (BNC09M (IA),IA=201,300)/                                     &
      0.24533E+00, 0.24839E+00, 0.25145E+00, 0.25450E+00, 0.25755E+00,&
      0.26058E+00, 0.26361E+00, 0.26663E+00, 0.26964E+00, 0.27265E+00,&
      0.27565E+00, 0.27864E+00, 0.28162E+00, 0.28460E+00, 0.28756E+00,&
      0.29053E+00, 0.29348E+00, 0.29643E+00, 0.29937E+00, 0.30230E+00,&
      0.30522E+00, 0.30814E+00, 0.31105E+00, 0.31396E+00, 0.31685E+00,&
      0.31974E+00, 0.32263E+00, 0.32550E+00, 0.32837E+00, 0.33123E+00,&
      0.33409E+00, 0.33694E+00, 0.33978E+00, 0.34261E+00, 0.34544E+00,&
      0.34826E+00, 0.35108E+00, 0.35388E+00, 0.35668E+00, 0.35948E+00,&
      0.36227E+00, 0.36505E+00, 0.36782E+00, 0.37059E+00, 0.37335E+00,&
      0.37610E+00, 0.37885E+00, 0.38159E+00, 0.38433E+00, 0.38706E+00,&
      0.38978E+00, 0.39250E+00, 0.39521E+00, 0.39791E+00, 0.40061E+00,&
      0.40330E+00, 0.40598E+00, 0.40866E+00, 0.41133E+00, 0.41400E+00,&
      0.41666E+00, 0.41931E+00, 0.42196E+00, 0.42460E+00, 0.42724E+00,&
      0.42987E+00, 0.43249E+00, 0.43511E+00, 0.43772E+00, 0.44033E+00,&
      0.44293E+00, 0.44552E+00, 0.44811E+00, 0.45069E+00, 0.45327E+00,&
      0.45584E+00, 0.45841E+00, 0.46097E+00, 0.46352E+00, 0.46607E+00,&
      0.46861E+00, 0.47115E+00, 0.47368E+00, 0.47620E+00, 0.47872E+00,&
      0.48124E+00, 0.48375E+00, 0.48625E+00, 0.48875E+00, 0.49124E+00,&
      0.49373E+00, 0.49621E+00, 0.49869E+00, 0.50116E+00, 0.50362E+00,&
      0.50608E+00, 0.50854E+00, 0.51099E+00, 0.51343E+00, 0.51587E+00/
                             
     DATA (BNC09M (IA),IA=301,400)/                                     &
      0.51831E+00, 0.52073E+00, 0.52316E+00, 0.52558E+00, 0.52799E+00,&
      0.53040E+00, 0.53280E+00, 0.53520E+00, 0.53759E+00, 0.53998E+00,&
      0.54236E+00, 0.54474E+00, 0.54711E+00, 0.54948E+00, 0.55184E+00,&
      0.55420E+00, 0.55655E+00, 0.55890E+00, 0.56125E+00, 0.56358E+00,&
      0.56592E+00, 0.56825E+00, 0.57057E+00, 0.57289E+00, 0.57520E+00,&
      0.57751E+00, 0.57982E+00, 0.58212E+00, 0.58442E+00, 0.58671E+00,&
      0.58899E+00, 0.59127E+00, 0.59355E+00, 0.59582E+00, 0.59809E+00,&
      0.60036E+00, 0.60261E+00, 0.60487E+00, 0.60712E+00, 0.60936E+00,&
      0.61160E+00, 0.61384E+00, 0.61607E+00, 0.61830E+00, 0.62052E+00,&
      0.62274E+00, 0.62495E+00, 0.62716E+00, 0.62937E+00, 0.63157E+00,&
      0.63377E+00, 0.63596E+00, 0.63815E+00, 0.64033E+00, 0.64251E+00,&
      0.64469E+00, 0.64686E+00, 0.64902E+00, 0.65119E+00, 0.65334E+00,&
      0.65550E+00, 0.65765E+00, 0.65979E+00, 0.66194E+00, 0.66407E+00,&
      0.66621E+00, 0.66834E+00, 0.67046E+00, 0.67258E+00, 0.67470E+00,&
      0.67681E+00, 0.67892E+00, 0.68103E+00, 0.68313E+00, 0.68523E+00,&
      0.68732E+00, 0.68941E+00, 0.69150E+00, 0.69358E+00, 0.69565E+00,&
      0.69773E+00, 0.69980E+00, 0.70186E+00, 0.70393E+00, 0.70598E+00,&
      0.70804E+00, 0.71009E+00, 0.71214E+00, 0.71418E+00, 0.71622E+00,&
      0.71825E+00, 0.72028E+00, 0.72231E+00, 0.72434E+00, 0.72636E+00,&
      0.72837E+00, 0.73039E+00, 0.73240E+00, 0.73440E+00, 0.73640E+00/
                             
     DATA (BNC09M (IA),IA=401,500)/                                     &
      0.73840E+00, 0.74040E+00, 0.74239E+00, 0.74438E+00, 0.74636E+00,&
      0.74834E+00, 0.75032E+00, 0.75229E+00, 0.75426E+00, 0.75623E+00,&
      0.75819E+00, 0.76015E+00, 0.76210E+00, 0.76405E+00, 0.76600E+00,&
      0.76795E+00, 0.76989E+00, 0.77183E+00, 0.77376E+00, 0.77569E+00,&
      0.77762E+00, 0.77955E+00, 0.78147E+00, 0.78338E+00, 0.78530E+00,&
      0.78721E+00, 0.78912E+00, 0.79102E+00, 0.79292E+00, 0.79482E+00,&
      0.79671E+00, 0.79861E+00, 0.80049E+00, 0.80238E+00, 0.80426E+00,&
      0.80614E+00, 0.80801E+00, 0.80988E+00, 0.81175E+00, 0.81361E+00,&
      0.81548E+00, 0.81733E+00, 0.81919E+00, 0.82104E+00, 0.82289E+00,&
      0.82474E+00, 0.82658E+00, 0.82842E+00, 0.83025E+00, 0.83209E+00,&
      0.83392E+00, 0.83574E+00, 0.83757E+00, 0.83939E+00, 0.84121E+00,&
      0.84302E+00, 0.84483E+00, 0.84664E+00, 0.84845E+00, 0.85025E+00,&
      0.85205E+00, 0.85384E+00, 0.85564E+00, 0.85743E+00, 0.85921E+00,&
      0.86100E+00, 0.86278E+00, 0.86456E+00, 0.86633E+00, 0.86811E+00,&
      0.86988E+00, 0.87164E+00, 0.87341E+00, 0.87517E+00, 0.87692E+00,&
      0.87868E+00, 0.88043E+00, 0.88218E+00, 0.88393E+00, 0.88567E+00,&
      0.88741E+00, 0.88915E+00, 0.89088E+00, 0.89262E+00, 0.89434E+00,&
      0.89607E+00, 0.89779E+00, 0.89952E+00, 0.90123E+00, 0.90295E+00,&
      0.90466E+00, 0.90637E+00, 0.90808E+00, 0.90978E+00, 0.91148E+00,&
      0.91318E+00, 0.91488E+00, 0.91657E+00, 0.91826E+00, 0.91995E+00/
                             
     DATA (BNC09M (IA),IA=501,600)/                                     &
      0.92163E+00, 0.92332E+00, 0.92500E+00, 0.92667E+00, 0.92835E+00,&
      0.93002E+00, 0.93169E+00, 0.93335E+00, 0.93502E+00, 0.93668E+00,&
      0.93834E+00, 0.93999E+00, 0.94165E+00, 0.94330E+00, 0.94495E+00,&
      0.94659E+00, 0.94823E+00, 0.94987E+00, 0.95151E+00, 0.95315E+00,&
      0.95478E+00, 0.95641E+00, 0.95804E+00, 0.95966E+00, 0.96128E+00,&
      0.96290E+00, 0.96452E+00, 0.96614E+00, 0.96775E+00, 0.96936E+00,&
      0.97097E+00, 0.97257E+00, 0.97417E+00, 0.97577E+00, 0.97737E+00,&
      0.97897E+00, 0.98056E+00, 0.98215E+00, 0.98374E+00, 0.98532E+00,&
      0.98690E+00, 0.98848E+00, 0.99006E+00, 0.99164E+00, 0.99321E+00,&
      0.99478E+00, 0.99635E+00, 0.99792E+00, 0.99948E+00, 0.10010E+01,&
      0.10026E+01, 0.10042E+01, 0.10057E+01, 0.10073E+01, 0.10088E+01,&
      0.10104E+01, 0.10119E+01, 0.10134E+01, 0.10150E+01, 0.10165E+01,&
      0.10181E+01, 0.10196E+01, 0.10211E+01, 0.10227E+01, 0.10242E+01,&
      0.10257E+01, 0.10272E+01, 0.10287E+01, 0.10303E+01, 0.10318E+01,&
      0.10333E+01, 0.10348E+01, 0.10363E+01, 0.10378E+01, 0.10393E+01,&
      0.10408E+01, 0.10423E+01, 0.10438E+01, 0.10453E+01, 0.10468E+01,&
      0.10483E+01, 0.10498E+01, 0.10513E+01, 0.10528E+01, 0.10542E+01,&
      0.10557E+01, 0.10572E+01, 0.10587E+01, 0.10601E+01, 0.10616E+01,&
      0.10631E+01, 0.10646E+01, 0.10660E+01, 0.10675E+01, 0.10689E+01,&
      0.10704E+01, 0.10719E+01, 0.10733E+01, 0.10748E+01, 0.10802E+01/
                             
     DATA (BNC09M (IA),IA=601,700)/                                     &
      0.10920E+01, 0.11062E+01, 0.11202E+01, 0.11339E+01, 0.11475E+01,&
      0.11609E+01, 0.11741E+01, 0.11872E+01, 0.12000E+01, 0.12127E+01,&
      0.12252E+01, 0.12376E+01, 0.12498E+01, 0.12619E+01, 0.12738E+01,&
      0.12855E+01, 0.12971E+01, 0.13086E+01, 0.13199E+01, 0.13311E+01,&
      0.13421E+01, 0.13531E+01, 0.13638E+01, 0.13745E+01, 0.13850E+01,&
      0.13954E+01, 0.14057E+01, 0.14159E+01, 0.14259E+01, 0.14359E+01,&
      0.14457E+01, 0.14554E+01, 0.14650E+01, 0.14745E+01, 0.14839E+01,&
      0.14932E+01, 0.15024E+01, 0.15115E+01, 0.15205E+01, 0.15294E+01,&
      0.15382E+01, 0.15469E+01, 0.15555E+01, 0.15641E+01, 0.15725E+01,&
      0.15808E+01, 0.15891E+01, 0.15973E+01, 0.16054E+01, 0.16134E+01,&
      0.16213E+01, 0.16292E+01, 0.16370E+01, 0.16447E+01, 0.16523E+01,&
      0.16598E+01, 0.16673E+01, 0.16747E+01, 0.16820E+01, 0.16893E+01,&
      0.16965E+01, 0.17036E+01, 0.17106E+01, 0.17176E+01, 0.17245E+01,&
      0.17314E+01, 0.17381E+01, 0.17449E+01, 0.17515E+01, 0.17581E+01,&
      0.17646E+01, 0.17711E+01, 0.17775E+01, 0.17839E+01, 0.17902E+01,&
      0.17964E+01, 0.18026E+01, 0.18087E+01, 0.18148E+01, 0.18208E+01,&
      0.18268E+01, 0.18327E+01, 0.18385E+01, 0.18443E+01, 0.18501E+01,&
      0.18558E+01, 0.18614E+01, 0.18671E+01, 0.18726E+01, 0.18781E+01,&
      0.18836E+01, 0.18890E+01, 0.18943E+01, 0.18997E+01, 0.19049E+01,&
      0.19102E+01, 0.19153E+01, 0.19205E+01, 0.19256E+01, 0.19306E+01/
                             
     DATA (BNC09M(IA),IA=701,741)/                                      &
      0.19356E+01, 0.19406E+01, 0.19455E+01, 0.19504E+01, 0.19552E+01,&
      0.19600E+01, 0.19648E+01, 0.19695E+01, 0.19742E+01, 0.19788E+01,&
      0.19835E+01, 0.19880E+01, 0.19925E+01, 0.19970E+01, 0.20015E+01,&
      0.20059E+01, 0.20103E+01, 0.20146E+01, 0.20190E+01, 0.20232E+01,&
      0.20275E+01, 0.20317E+01, 0.20359E+01, 0.20400E+01, 0.20441E+01,&
      0.20482E+01, 0.20522E+01, 0.20562E+01, 0.20602E+01, 0.20641E+01,&
      0.20681E+01, 0.20719E+01, 0.20758E+01, 0.20796E+01, 0.20834E+01,&
      0.20872E+01, 0.20909E+01, 0.20946E+01, 0.20983E+01, 0.21019E+01,&
      0.21055E+01                  /                      
!                            
!  ** (H, NO3)               
!                            
     DATA (BNC10M (IA),IA=  1,100)/                                     &
     -0.52126E-01,-0.91475E-01,-0.11662E+00,-0.13216E+00,-0.14305E+00,&
     -0.15115E+00,-0.15736E+00,-0.16220E+00,-0.16600E+00,-0.16898E+00,&
     -0.17131E+00,-0.17309E+00,-0.17442E+00,-0.17536E+00,-0.17597E+00,&
     -0.17629E+00,-0.17637E+00,-0.17622E+00,-0.17588E+00,-0.17536E+00,&
     -0.17469E+00,-0.17388E+00,-0.17294E+00,-0.17189E+00,-0.17074E+00,&
     -0.16950E+00,-0.16817E+00,-0.16677E+00,-0.16530E+00,-0.16377E+00,&
     -0.16218E+00,-0.16054E+00,-0.15885E+00,-0.15712E+00,-0.15535E+00,&
     -0.15355E+00,-0.15172E+00,-0.14986E+00,-0.14797E+00,-0.14606E+00,&
     -0.14413E+00,-0.14218E+00,-0.14022E+00,-0.13824E+00,-0.13625E+00,&
     -0.13425E+00,-0.13223E+00,-0.13021E+00,-0.12818E+00,-0.12615E+00,&
     -0.12410E+00,-0.12206E+00,-0.12000E+00,-0.11795E+00,-0.11588E+00,&
     -0.11382E+00,-0.11175E+00,-0.10968E+00,-0.10760E+00,-0.10552E+00,&
     -0.10344E+00,-0.10135E+00,-0.99254E-01,-0.97155E-01,-0.95051E-01,&
     -0.92942E-01,-0.90825E-01,-0.88702E-01,-0.86572E-01,-0.84433E-01,&
     -0.82285E-01,-0.80128E-01,-0.77962E-01,-0.75784E-01,-0.73596E-01,&
     -0.71395E-01,-0.69182E-01,-0.66957E-01,-0.64717E-01,-0.62464E-01,&
     -0.60196E-01,-0.57913E-01,-0.55615E-01,-0.53301E-01,-0.50971E-01,&
     -0.48625E-01,-0.46262E-01,-0.43883E-01,-0.41487E-01,-0.39075E-01,&
     -0.36646E-01,-0.34200E-01,-0.31738E-01,-0.29259E-01,-0.26764E-01,&
     -0.24254E-01,-0.21728E-01,-0.19186E-01,-0.16630E-01,-0.14060E-01/
                             
     DATA (BNC10M (IA),IA=101,200)/                                     &
     -0.11475E-01,-0.88771E-02,-0.62662E-02,-0.36428E-02,-0.10075E-02,&
      0.16391E-02, 0.42964E-02, 0.69640E-02, 0.96412E-02, 0.12327E-01,&
      0.15022E-01, 0.17725E-01, 0.20434E-01, 0.23151E-01, 0.25874E-01,&
      0.28602E-01, 0.31336E-01, 0.34074E-01, 0.36816E-01, 0.39562E-01,&
      0.41991E-01, 0.44780E-01, 0.47568E-01, 0.50354E-01, 0.53138E-01,&
      0.55921E-01, 0.58702E-01, 0.61482E-01, 0.64259E-01, 0.67035E-01,&
      0.69808E-01, 0.72580E-01, 0.75349E-01, 0.78117E-01, 0.80882E-01,&
      0.83644E-01, 0.86404E-01, 0.89162E-01, 0.91917E-01, 0.94670E-01,&
      0.97420E-01, 0.10017E+00, 0.10291E+00, 0.10565E+00, 0.10839E+00,&
      0.11113E+00, 0.11386E+00, 0.11659E+00, 0.11932E+00, 0.12205E+00,&
      0.12477E+00, 0.12749E+00, 0.13020E+00, 0.13291E+00, 0.13562E+00,&
      0.13833E+00, 0.14103E+00, 0.14373E+00, 0.14643E+00, 0.14912E+00,&
      0.15181E+00, 0.15449E+00, 0.15718E+00, 0.15985E+00, 0.16253E+00,&
      0.16520E+00, 0.16787E+00, 0.17053E+00, 0.17320E+00, 0.17585E+00,&
      0.17851E+00, 0.18116E+00, 0.18380E+00, 0.18645E+00, 0.18909E+00,&
      0.19172E+00, 0.19435E+00, 0.19698E+00, 0.19961E+00, 0.20223E+00,&
      0.20484E+00, 0.20745E+00, 0.21006E+00, 0.21267E+00, 0.21527E+00,&
      0.21787E+00, 0.22046E+00, 0.22305E+00, 0.22564E+00, 0.22822E+00,&
      0.23079E+00, 0.23337E+00, 0.23594E+00, 0.23850E+00, 0.24107E+00,&
      0.24362E+00, 0.24618E+00, 0.24873E+00, 0.25127E+00, 0.25382E+00/
                             
     DATA (BNC10M (IA),IA=201,300)/                                     &
      0.25635E+00, 0.25889E+00, 0.26142E+00, 0.26394E+00, 0.26647E+00,&
      0.26898E+00, 0.27150E+00, 0.27401E+00, 0.27651E+00, 0.27901E+00,&
      0.28151E+00, 0.28401E+00, 0.28649E+00, 0.28898E+00, 0.29146E+00,&
      0.29394E+00, 0.29641E+00, 0.29888E+00, 0.30135E+00, 0.30381E+00,&
      0.30626E+00, 0.30872E+00, 0.31117E+00, 0.31361E+00, 0.31605E+00,&
      0.31849E+00, 0.32092E+00, 0.32335E+00, 0.32577E+00, 0.32819E+00,&
      0.33061E+00, 0.33302E+00, 0.33543E+00, 0.33783E+00, 0.34023E+00,&
      0.34263E+00, 0.34502E+00, 0.34741E+00, 0.34979E+00, 0.35217E+00,&
      0.35455E+00, 0.35692E+00, 0.35929E+00, 0.36165E+00, 0.36401E+00,&
      0.36637E+00, 0.36872E+00, 0.37107E+00, 0.37341E+00, 0.37575E+00,&
      0.37808E+00, 0.38041E+00, 0.38274E+00, 0.38507E+00, 0.38738E+00,&
      0.38970E+00, 0.39201E+00, 0.39432E+00, 0.39662E+00, 0.39892E+00,&
      0.40122E+00, 0.40351E+00, 0.40580E+00, 0.40808E+00, 0.41036E+00,&
      0.41264E+00, 0.41491E+00, 0.41718E+00, 0.41944E+00, 0.42170E+00,&
      0.42396E+00, 0.42621E+00, 0.42846E+00, 0.43070E+00, 0.43294E+00,&
      0.43518E+00, 0.43741E+00, 0.43964E+00, 0.44186E+00, 0.44409E+00,&
      0.44630E+00, 0.44852E+00, 0.45073E+00, 0.45293E+00, 0.45513E+00,&
      0.45733E+00, 0.45953E+00, 0.46172E+00, 0.46390E+00, 0.46609E+00,&
      0.46827E+00, 0.47044E+00, 0.47261E+00, 0.47478E+00, 0.47695E+00,&
      0.47911E+00, 0.48126E+00, 0.48342E+00, 0.48556E+00, 0.48771E+00/
                             
     DATA (BNC10M (IA),IA=301,400)/                                     &
      0.48985E+00, 0.49199E+00, 0.49412E+00, 0.49625E+00, 0.49838E+00,&
      0.50050E+00, 0.50262E+00, 0.50474E+00, 0.50685E+00, 0.50896E+00,&
      0.51107E+00, 0.51317E+00, 0.51526E+00, 0.51736E+00, 0.51945E+00,&
      0.52154E+00, 0.52362E+00, 0.52570E+00, 0.52778E+00, 0.52985E+00,&
      0.53192E+00, 0.53398E+00, 0.53604E+00, 0.53810E+00, 0.54016E+00,&
      0.54221E+00, 0.54426E+00, 0.54630E+00, 0.54834E+00, 0.55038E+00,&
      0.55241E+00, 0.55444E+00, 0.55647E+00, 0.55849E+00, 0.56051E+00,&
      0.56253E+00, 0.56454E+00, 0.56655E+00, 0.56856E+00, 0.57056E+00,&
      0.57256E+00, 0.57455E+00, 0.57654E+00, 0.57853E+00, 0.58052E+00,&
      0.58250E+00, 0.58448E+00, 0.58645E+00, 0.58843E+00, 0.59040E+00,&
      0.59236E+00, 0.59432E+00, 0.59628E+00, 0.59824E+00, 0.60019E+00,&
      0.60214E+00, 0.60408E+00, 0.60602E+00, 0.60796E+00, 0.60990E+00,&
      0.61183E+00, 0.61376E+00, 0.61569E+00, 0.61761E+00, 0.61953E+00,&
      0.62144E+00, 0.62336E+00, 0.62527E+00, 0.62717E+00, 0.62907E+00,&
      0.63097E+00, 0.63287E+00, 0.63476E+00, 0.63666E+00, 0.63854E+00,&
      0.64043E+00, 0.64231E+00, 0.64418E+00, 0.64606E+00, 0.64793E+00,&
      0.64980E+00, 0.65166E+00, 0.65353E+00, 0.65539E+00, 0.65724E+00,&
      0.65909E+00, 0.66094E+00, 0.66279E+00, 0.66463E+00, 0.66647E+00,&
      0.66831E+00, 0.67015E+00, 0.67198E+00, 0.67381E+00, 0.67563E+00,&
      0.67745E+00, 0.67927E+00, 0.68109E+00, 0.68290E+00, 0.68471E+00/
                             
     DATA (BNC10M (IA),IA=401,500)/                                     &
      0.68652E+00, 0.68832E+00, 0.69013E+00, 0.69192E+00, 0.69372E+00,&
      0.69551E+00, 0.69730E+00, 0.69909E+00, 0.70087E+00, 0.70265E+00,&
      0.70443E+00, 0.70621E+00, 0.70798E+00, 0.70975E+00, 0.71151E+00,&
      0.71328E+00, 0.71504E+00, 0.71680E+00, 0.71855E+00, 0.72030E+00,&
      0.72205E+00, 0.72380E+00, 0.72554E+00, 0.72728E+00, 0.72902E+00,&
      0.73075E+00, 0.73249E+00, 0.73422E+00, 0.73594E+00, 0.73767E+00,&
      0.73939E+00, 0.74111E+00, 0.74282E+00, 0.74453E+00, 0.74624E+00,&
      0.74795E+00, 0.74966E+00, 0.75136E+00, 0.75306E+00, 0.75475E+00,&
      0.75645E+00, 0.75814E+00, 0.75983E+00, 0.76151E+00, 0.76319E+00,&
      0.76487E+00, 0.76655E+00, 0.76823E+00, 0.76990E+00, 0.77157E+00,&
      0.77324E+00, 0.77490E+00, 0.77656E+00, 0.77822E+00, 0.77988E+00,&
      0.78153E+00, 0.78318E+00, 0.78483E+00, 0.78648E+00, 0.78812E+00,&
      0.78976E+00, 0.79140E+00, 0.79303E+00, 0.79467E+00, 0.79630E+00,&
      0.79792E+00, 0.79955E+00, 0.80117E+00, 0.80279E+00, 0.80441E+00,&
      0.80603E+00, 0.80764E+00, 0.80925E+00, 0.81086E+00, 0.81246E+00,&
      0.81406E+00, 0.81566E+00, 0.81726E+00, 0.81886E+00, 0.82045E+00,&
      0.82204E+00, 0.82363E+00, 0.82521E+00, 0.82679E+00, 0.82837E+00,&
      0.82995E+00, 0.83153E+00, 0.83310E+00, 0.83467E+00, 0.83624E+00,&
      0.83781E+00, 0.83937E+00, 0.84093E+00, 0.84249E+00, 0.84405E+00,&
      0.84560E+00, 0.84715E+00, 0.84870E+00, 0.85025E+00, 0.85179E+00/
                             
     DATA (BNC10M (IA),IA=501,600)/                                     &
      0.85333E+00, 0.85487E+00, 0.85641E+00, 0.85794E+00, 0.85948E+00,&
      0.86101E+00, 0.86254E+00, 0.86406E+00, 0.86558E+00, 0.86711E+00,&
      0.86862E+00, 0.87014E+00, 0.87165E+00, 0.87317E+00, 0.87468E+00,&
      0.87618E+00, 0.87769E+00, 0.87919E+00, 0.88069E+00, 0.88219E+00,&
      0.88369E+00, 0.88518E+00, 0.88667E+00, 0.88816E+00, 0.88965E+00,&
      0.89113E+00, 0.89261E+00, 0.89409E+00, 0.89557E+00, 0.89705E+00,&
      0.89852E+00, 0.89999E+00, 0.90146E+00, 0.90293E+00, 0.90439E+00,&
      0.90586E+00, 0.90732E+00, 0.90878E+00, 0.91023E+00, 0.91169E+00,&
      0.91314E+00, 0.91459E+00, 0.91604E+00, 0.91748E+00, 0.91893E+00,&
      0.92037E+00, 0.92181E+00, 0.92324E+00, 0.92468E+00, 0.92611E+00,&
      0.92754E+00, 0.92897E+00, 0.93040E+00, 0.93182E+00, 0.93324E+00,&
      0.93466E+00, 0.93608E+00, 0.93750E+00, 0.93891E+00, 0.94032E+00,&
      0.94173E+00, 0.94314E+00, 0.94455E+00, 0.94595E+00, 0.94735E+00,&
      0.94875E+00, 0.95015E+00, 0.95155E+00, 0.95294E+00, 0.95433E+00,&
      0.95572E+00, 0.95711E+00, 0.95850E+00, 0.95988E+00, 0.96126E+00,&
      0.96264E+00, 0.96402E+00, 0.96539E+00, 0.96677E+00, 0.96814E+00,&
      0.96951E+00, 0.97088E+00, 0.97224E+00, 0.97361E+00, 0.97497E+00,&
      0.97633E+00, 0.97769E+00, 0.97904E+00, 0.98040E+00, 0.98175E+00,&
      0.98310E+00, 0.98445E+00, 0.98580E+00, 0.98714E+00, 0.98848E+00,&
      0.98982E+00, 0.99116E+00, 0.99250E+00, 0.99383E+00, 0.99882E+00/
                             
     DATA (BNC10M (IA),IA=601,700)/                                     &
      0.10097E+01, 0.10227E+01, 0.10356E+01, 0.10483E+01, 0.10608E+01,&
      0.10731E+01, 0.10852E+01, 0.10972E+01, 0.11091E+01, 0.11208E+01,&
      0.11323E+01, 0.11437E+01, 0.11549E+01, 0.11660E+01, 0.11770E+01,&
      0.11878E+01, 0.11985E+01, 0.12090E+01, 0.12195E+01, 0.12298E+01,&
      0.12399E+01, 0.12500E+01, 0.12599E+01, 0.12697E+01, 0.12794E+01,&
      0.12889E+01, 0.12984E+01, 0.13077E+01, 0.13170E+01, 0.13261E+01,&
      0.13351E+01, 0.13441E+01, 0.13529E+01, 0.13616E+01, 0.13702E+01,&
      0.13788E+01, 0.13872E+01, 0.13955E+01, 0.14038E+01, 0.14119E+01,&
      0.14200E+01, 0.14280E+01, 0.14359E+01, 0.14437E+01, 0.14514E+01,&
      0.14590E+01, 0.14666E+01, 0.14741E+01, 0.14815E+01, 0.14888E+01,&
      0.14961E+01, 0.15032E+01, 0.15103E+01, 0.15174E+01, 0.15243E+01,&
      0.15312E+01, 0.15380E+01, 0.15448E+01, 0.15515E+01, 0.15581E+01,&
      0.15646E+01, 0.15711E+01, 0.15775E+01, 0.15839E+01, 0.15901E+01,&
      0.15964E+01, 0.16025E+01, 0.16086E+01, 0.16147E+01, 0.16207E+01,&
      0.16266E+01, 0.16325E+01, 0.16383E+01, 0.16441E+01, 0.16498E+01,&
      0.16554E+01, 0.16610E+01, 0.16666E+01, 0.16721E+01, 0.16775E+01,&
      0.16829E+01, 0.16882E+01, 0.16935E+01, 0.16988E+01, 0.17040E+01,&
      0.17091E+01, 0.17142E+01, 0.17193E+01, 0.17243E+01, 0.17292E+01,&
      0.17342E+01, 0.17390E+01, 0.17439E+01, 0.17486E+01, 0.17534E+01,&
      0.17581E+01, 0.17627E+01, 0.17674E+01, 0.17719E+01, 0.17765E+01/
                             
     DATA (BNC10M(IA),IA=701,741)/                                      &
      0.17810E+01, 0.17854E+01, 0.17898E+01, 0.17942E+01, 0.17985E+01,&
      0.18028E+01, 0.18071E+01, 0.18113E+01, 0.18155E+01, 0.18196E+01,&
      0.18238E+01, 0.18278E+01, 0.18319E+01, 0.18359E+01, 0.18399E+01,&
      0.18438E+01, 0.18477E+01, 0.18516E+01, 0.18554E+01, 0.18592E+01,&
      0.18630E+01, 0.18667E+01, 0.18704E+01, 0.18741E+01, 0.18777E+01,&
      0.18814E+01, 0.18849E+01, 0.18885E+01, 0.18920E+01, 0.18955E+01,&
      0.18990E+01, 0.19024E+01, 0.19058E+01, 0.19092E+01, 0.19125E+01,&
      0.19158E+01, 0.19191E+01, 0.19224E+01, 0.19256E+01, 0.19288E+01,&
      0.19320E+01                  /                      
!                            
!  ** (H, Cl)                
!                            
     DATA (BNC11M (IA),IA=  1,100)/                                     &
     -0.50531E-01,-0.86008E-01,-0.10676E+00,-0.11831E+00,-0.12545E+00,&
     -0.12992E+00,-0.13259E+00,-0.13394E+00,-0.13429E+00,-0.13382E+00,&
     -0.13270E+00,-0.13103E+00,-0.12888E+00,-0.12633E+00,-0.12342E+00,&
     -0.12019E+00,-0.11668E+00,-0.11291E+00,-0.10891E+00,-0.10470E+00,&
     -0.10030E+00,-0.95726E-01,-0.90985E-01,-0.86094E-01,-0.81063E-01,&
     -0.75902E-01,-0.70620E-01,-0.65226E-01,-0.59728E-01,-0.54132E-01,&
     -0.48445E-01,-0.42673E-01,-0.36822E-01,-0.30897E-01,-0.24903E-01,&
     -0.18845E-01,-0.12727E-01,-0.65528E-02,-0.32679E-03, 0.59476E-02,&
      0.12267E-01, 0.18628E-01, 0.25028E-01, 0.31464E-01, 0.37933E-01,&
      0.44433E-01, 0.50963E-01, 0.57519E-01, 0.64099E-01, 0.70704E-01,&
      0.77329E-01, 0.83976E-01, 0.90641E-01, 0.97325E-01, 0.10403E+00,&
      0.11074E+00, 0.11748E+00, 0.12423E+00, 0.13099E+00, 0.13777E+00,&
      0.14457E+00, 0.15138E+00, 0.15821E+00, 0.16505E+00, 0.17191E+00,&
      0.17879E+00, 0.18569E+00, 0.19260E+00, 0.19954E+00, 0.20650E+00,&
      0.21347E+00, 0.22048E+00, 0.22750E+00, 0.23455E+00, 0.24163E+00,&
      0.24873E+00, 0.25587E+00, 0.26303E+00, 0.27022E+00, 0.27745E+00,&
      0.28470E+00, 0.29200E+00, 0.29932E+00, 0.30668E+00, 0.31407E+00,&
      0.32150E+00, 0.32897E+00, 0.33647E+00, 0.34402E+00, 0.35159E+00,&
      0.35921E+00, 0.36686E+00, 0.37454E+00, 0.38226E+00, 0.39002E+00,&
      0.39781E+00, 0.40564E+00, 0.41349E+00, 0.42138E+00, 0.42931E+00/
                             
     DATA (BNC11M (IA),IA=101,200)/                                     &
      0.43726E+00, 0.44524E+00, 0.45324E+00, 0.46128E+00, 0.46933E+00,&
      0.47741E+00, 0.48552E+00, 0.49364E+00, 0.50178E+00, 0.50994E+00,&
      0.51812E+00, 0.52631E+00, 0.53452E+00, 0.54273E+00, 0.55096E+00,&
      0.55920E+00, 0.56744E+00, 0.57570E+00, 0.58395E+00, 0.59221E+00,&
      0.59974E+00, 0.60809E+00, 0.61644E+00, 0.62477E+00, 0.63310E+00,&
      0.64142E+00, 0.64973E+00, 0.65803E+00, 0.66632E+00, 0.67461E+00,&
      0.68288E+00, 0.69114E+00, 0.69939E+00, 0.70764E+00, 0.71587E+00,&
      0.72409E+00, 0.73230E+00, 0.74050E+00, 0.74869E+00, 0.75686E+00,&
      0.76502E+00, 0.77318E+00, 0.78132E+00, 0.78944E+00, 0.79756E+00,&
      0.80566E+00, 0.81375E+00, 0.82183E+00, 0.82990E+00, 0.83795E+00,&
      0.84599E+00, 0.85401E+00, 0.86202E+00, 0.87002E+00, 0.87801E+00,&
      0.88598E+00, 0.89394E+00, 0.90188E+00, 0.90981E+00, 0.91773E+00,&
      0.92563E+00, 0.93352E+00, 0.94139E+00, 0.94925E+00, 0.95710E+00,&
      0.96493E+00, 0.97275E+00, 0.98055E+00, 0.98834E+00, 0.99611E+00,&
      0.10039E+01, 0.10116E+01, 0.10193E+01, 0.10271E+01, 0.10348E+01,&
      0.10424E+01, 0.10501E+01, 0.10578E+01, 0.10654E+01, 0.10730E+01,&
      0.10807E+01, 0.10883E+01, 0.10958E+01, 0.11034E+01, 0.11110E+01,&
      0.11185E+01, 0.11260E+01, 0.11335E+01, 0.11410E+01, 0.11485E+01,&
      0.11560E+01, 0.11634E+01, 0.11708E+01, 0.11782E+01, 0.11857E+01,&
      0.11930E+01, 0.12004E+01, 0.12078E+01, 0.12151E+01, 0.12224E+01/
                             
     DATA (BNC11M (IA),IA=201,300)/                                     &
      0.12298E+01, 0.12370E+01, 0.12443E+01, 0.12516E+01, 0.12589E+01,&
      0.12661E+01, 0.12733E+01, 0.12805E+01, 0.12877E+01, 0.12949E+01,&
      0.13021E+01, 0.13092E+01, 0.13163E+01, 0.13235E+01, 0.13306E+01,&
      0.13377E+01, 0.13447E+01, 0.13518E+01, 0.13588E+01, 0.13659E+01,&
      0.13729E+01, 0.13799E+01, 0.13869E+01, 0.13939E+01, 0.14008E+01,&
      0.14078E+01, 0.14147E+01, 0.14216E+01, 0.14285E+01, 0.14354E+01,&
      0.14423E+01, 0.14491E+01, 0.14560E+01, 0.14628E+01, 0.14696E+01,&
      0.14764E+01, 0.14832E+01, 0.14900E+01, 0.14968E+01, 0.15035E+01,&
      0.15103E+01, 0.15170E+01, 0.15237E+01, 0.15304E+01, 0.15370E+01,&
      0.15437E+01, 0.15504E+01, 0.15570E+01, 0.15636E+01, 0.15702E+01,&
      0.15768E+01, 0.15834E+01, 0.15900E+01, 0.15965E+01, 0.16031E+01,&
      0.16096E+01, 0.16161E+01, 0.16226E+01, 0.16291E+01, 0.16356E+01,&
      0.16421E+01, 0.16485E+01, 0.16549E+01, 0.16614E+01, 0.16678E+01,&
      0.16742E+01, 0.16806E+01, 0.16869E+01, 0.16933E+01, 0.16996E+01,&
      0.17060E+01, 0.17123E+01, 0.17186E+01, 0.17249E+01, 0.17312E+01,&
      0.17374E+01, 0.17437E+01, 0.17499E+01, 0.17562E+01, 0.17624E+01,&
      0.17686E+01, 0.17748E+01, 0.17810E+01, 0.17872E+01, 0.17933E+01,&
      0.17995E+01, 0.18056E+01, 0.18117E+01, 0.18178E+01, 0.18239E+01,&
      0.18300E+01, 0.18361E+01, 0.18421E+01, 0.18482E+01, 0.18542E+01,&
      0.18602E+01, 0.18663E+01, 0.18723E+01, 0.18783E+01, 0.18842E+01/
                             
     DATA (BNC11M (IA),IA=301,400)/                                     &
      0.18902E+01, 0.18962E+01, 0.19021E+01, 0.19080E+01, 0.19139E+01,&
      0.19199E+01, 0.19258E+01, 0.19316E+01, 0.19375E+01, 0.19434E+01,&
      0.19492E+01, 0.19551E+01, 0.19609E+01, 0.19667E+01, 0.19725E+01,&
      0.19783E+01, 0.19841E+01, 0.19899E+01, 0.19956E+01, 0.20014E+01,&
      0.20071E+01, 0.20129E+01, 0.20186E+01, 0.20243E+01, 0.20300E+01,&
      0.20357E+01, 0.20413E+01, 0.20470E+01, 0.20527E+01, 0.20583E+01,&
      0.20639E+01, 0.20696E+01, 0.20752E+01, 0.20808E+01, 0.20864E+01,&
      0.20919E+01, 0.20975E+01, 0.21031E+01, 0.21086E+01, 0.21142E+01,&
      0.21197E+01, 0.21252E+01, 0.21307E+01, 0.21362E+01, 0.21417E+01,&
      0.21472E+01, 0.21526E+01, 0.21581E+01, 0.21635E+01, 0.21690E+01,&
      0.21744E+01, 0.21798E+01, 0.21852E+01, 0.21906E+01, 0.21960E+01,&
      0.22014E+01, 0.22068E+01, 0.22121E+01, 0.22175E+01, 0.22228E+01,&
      0.22281E+01, 0.22335E+01, 0.22388E+01, 0.22441E+01, 0.22494E+01,&
      0.22546E+01, 0.22599E+01, 0.22652E+01, 0.22704E+01, 0.22757E+01,&
      0.22809E+01, 0.22861E+01, 0.22913E+01, 0.22965E+01, 0.23017E+01,&
      0.23069E+01, 0.23121E+01, 0.23173E+01, 0.23224E+01, 0.23276E+01,&
      0.23327E+01, 0.23379E+01, 0.23430E+01, 0.23481E+01, 0.23532E+01,&
      0.23583E+01, 0.23634E+01, 0.23685E+01, 0.23735E+01, 0.23786E+01,&
      0.23837E+01, 0.23887E+01, 0.23937E+01, 0.23988E+01, 0.24038E+01,&
      0.24088E+01, 0.24138E+01, 0.24188E+01, 0.24238E+01, 0.24288E+01/
                             
     DATA (BNC11M (IA),IA=401,500)/                                     &
      0.24337E+01, 0.24387E+01, 0.24436E+01, 0.24486E+01, 0.24535E+01,&
      0.24584E+01, 0.24633E+01, 0.24682E+01, 0.24731E+01, 0.24780E+01,&
      0.24829E+01, 0.24878E+01, 0.24927E+01, 0.24975E+01, 0.25024E+01,&
      0.25072E+01, 0.25120E+01, 0.25169E+01, 0.25217E+01, 0.25265E+01,&
      0.25313E+01, 0.25361E+01, 0.25409E+01, 0.25457E+01, 0.25504E+01,&
      0.25552E+01, 0.25599E+01, 0.25647E+01, 0.25694E+01, 0.25742E+01,&
      0.25789E+01, 0.25836E+01, 0.25883E+01, 0.25930E+01, 0.25977E+01,&
      0.26024E+01, 0.26071E+01, 0.26117E+01, 0.26164E+01, 0.26210E+01,&
      0.26257E+01, 0.26303E+01, 0.26350E+01, 0.26396E+01, 0.26442E+01,&
      0.26488E+01, 0.26534E+01, 0.26580E+01, 0.26626E+01, 0.26672E+01,&
      0.26717E+01, 0.26763E+01, 0.26809E+01, 0.26854E+01, 0.26900E+01,&
      0.26945E+01, 0.26990E+01, 0.27035E+01, 0.27081E+01, 0.27126E+01,&
      0.27171E+01, 0.27216E+01, 0.27260E+01, 0.27305E+01, 0.27350E+01,&
      0.27395E+01, 0.27439E+01, 0.27484E+01, 0.27528E+01, 0.27572E+01,&
      0.27617E+01, 0.27661E+01, 0.27705E+01, 0.27749E+01, 0.27793E+01,&
      0.27837E+01, 0.27881E+01, 0.27925E+01, 0.27969E+01, 0.28012E+01,&
      0.28056E+01, 0.28099E+01, 0.28143E+01, 0.28186E+01, 0.28230E+01,&
      0.28273E+01, 0.28316E+01, 0.28359E+01, 0.28402E+01, 0.28445E+01,&
      0.28488E+01, 0.28531E+01, 0.28574E+01, 0.28617E+01, 0.28660E+01,&
      0.28702E+01, 0.28745E+01, 0.28787E+01, 0.28830E+01, 0.28872E+01/
                             
     DATA (BNC11M (IA),IA=501,600)/                                     &
      0.28914E+01, 0.28957E+01, 0.28999E+01, 0.29041E+01, 0.29083E+01,&
      0.29125E+01, 0.29167E+01, 0.29209E+01, 0.29251E+01, 0.29292E+01,&
      0.29334E+01, 0.29376E+01, 0.29417E+01, 0.29459E+01, 0.29500E+01,&
      0.29541E+01, 0.29583E+01, 0.29624E+01, 0.29665E+01, 0.29706E+01,&
      0.29747E+01, 0.29788E+01, 0.29829E+01, 0.29870E+01, 0.29911E+01,&
      0.29952E+01, 0.29993E+01, 0.30033E+01, 0.30074E+01, 0.30114E+01,&
      0.30155E+01, 0.30195E+01, 0.30236E+01, 0.30276E+01, 0.30316E+01,&
      0.30356E+01, 0.30396E+01, 0.30437E+01, 0.30477E+01, 0.30517E+01,&
      0.30556E+01, 0.30596E+01, 0.30636E+01, 0.30676E+01, 0.30715E+01,&
      0.30755E+01, 0.30795E+01, 0.30834E+01, 0.30874E+01, 0.30913E+01,&
      0.30952E+01, 0.30992E+01, 0.31031E+01, 0.31070E+01, 0.31109E+01,&
      0.31148E+01, 0.31187E+01, 0.31226E+01, 0.31265E+01, 0.31304E+01,&
      0.31343E+01, 0.31381E+01, 0.31420E+01, 0.31459E+01, 0.31497E+01,&
      0.31536E+01, 0.31574E+01, 0.31613E+01, 0.31651E+01, 0.31689E+01,&
      0.31727E+01, 0.31766E+01, 0.31804E+01, 0.31842E+01, 0.31880E+01,&
      0.31918E+01, 0.31956E+01, 0.31994E+01, 0.32032E+01, 0.32069E+01,&
      0.32107E+01, 0.32145E+01, 0.32182E+01, 0.32220E+01, 0.32257E+01,&
      0.32295E+01, 0.32332E+01, 0.32370E+01, 0.32407E+01, 0.32444E+01,&
      0.32482E+01, 0.32519E+01, 0.32556E+01, 0.32593E+01, 0.32630E+01,&
      0.32667E+01, 0.32704E+01, 0.32741E+01, 0.32778E+01, 0.32915E+01/
                             
     DATA (BNC11M (IA),IA=601,700)/                                     &
      0.33216E+01, 0.33575E+01, 0.33930E+01, 0.34281E+01, 0.34627E+01,&
      0.34969E+01, 0.35306E+01, 0.35640E+01, 0.35969E+01, 0.36294E+01,&
      0.36616E+01, 0.36933E+01, 0.37247E+01, 0.37557E+01, 0.37864E+01,&
      0.38167E+01, 0.38467E+01, 0.38764E+01, 0.39057E+01, 0.39347E+01,&
      0.39633E+01, 0.39917E+01, 0.40198E+01, 0.40475E+01, 0.40750E+01,&
      0.41022E+01, 0.41291E+01, 0.41558E+01, 0.41821E+01, 0.42082E+01,&
      0.42341E+01, 0.42596E+01, 0.42850E+01, 0.43100E+01, 0.43349E+01,&
      0.43595E+01, 0.43838E+01, 0.44080E+01, 0.44319E+01, 0.44556E+01,&
      0.44790E+01, 0.45023E+01, 0.45253E+01, 0.45481E+01, 0.45707E+01,&
      0.45932E+01, 0.46154E+01, 0.46374E+01, 0.46592E+01, 0.46809E+01,&
      0.47023E+01, 0.47236E+01, 0.47447E+01, 0.47656E+01, 0.47863E+01,&
      0.48069E+01, 0.48273E+01, 0.48475E+01, 0.48675E+01, 0.48874E+01,&
      0.49071E+01, 0.49267E+01, 0.49461E+01, 0.49654E+01, 0.49845E+01,&
      0.50034E+01, 0.50222E+01, 0.50409E+01, 0.50594E+01, 0.50778E+01,&
      0.50960E+01, 0.51141E+01, 0.51321E+01, 0.51499E+01, 0.51676E+01,&
      0.51851E+01, 0.52025E+01, 0.52198E+01, 0.52370E+01, 0.52541E+01,&
      0.52710E+01, 0.52878E+01, 0.53044E+01, 0.53210E+01, 0.53374E+01,&
      0.53538E+01, 0.53700E+01, 0.53861E+01, 0.54021E+01, 0.54179E+01,&
      0.54337E+01, 0.54494E+01, 0.54649E+01, 0.54804E+01, 0.54957E+01,&
      0.55109E+01, 0.55261E+01, 0.55411E+01, 0.55560E+01, 0.55709E+01/
                             
     DATA (BNC11M(IA),IA=701,741)/                                      &
      0.55856E+01, 0.56002E+01, 0.56148E+01, 0.56292E+01, 0.56436E+01,&
      0.56579E+01, 0.56720E+01, 0.56861E+01, 0.57001E+01, 0.57140E+01,&
      0.57278E+01, 0.57416E+01, 0.57552E+01, 0.57688E+01, 0.57822E+01,&
      0.57956E+01, 0.58089E+01, 0.58222E+01, 0.58353E+01, 0.58484E+01,&
      0.58614E+01, 0.58743E+01, 0.58871E+01, 0.58999E+01, 0.59126E+01,&
      0.59252E+01, 0.59377E+01, 0.59501E+01, 0.59625E+01, 0.59748E+01,&
      0.59871E+01, 0.59993E+01, 0.60114E+01, 0.60234E+01, 0.60353E+01,&
      0.60472E+01, 0.60591E+01, 0.60708E+01, 0.60825E+01, 0.60941E+01,&
      0.61057E+01                  /                      
!                            
!  ** NaHSO4                 
!                            
     DATA (BNC12M (IA),IA=  1,100)/                                     &
     -0.51921E-01,-0.91127E-01,-0.11645E+00,-0.13236E+00,-0.14371E+00,&
     -0.15232E+00,-0.15906E+00,-0.16443E+00,-0.16876E+00,-0.17225E+00,&
     -0.17506E+00,-0.17730E+00,-0.17905E+00,-0.18038E+00,-0.18133E+00,&
     -0.18195E+00,-0.18227E+00,-0.18232E+00,-0.18213E+00,-0.18171E+00,&
     -0.18108E+00,-0.18026E+00,-0.17926E+00,-0.17809E+00,-0.17676E+00,&
     -0.17528E+00,-0.17365E+00,-0.17190E+00,-0.17001E+00,-0.16801E+00,&
     -0.16589E+00,-0.16366E+00,-0.16133E+00,-0.15889E+00,-0.15636E+00,&
     -0.15374E+00,-0.15103E+00,-0.14824E+00,-0.14536E+00,-0.14241E+00,&
     -0.13939E+00,-0.13629E+00,-0.13313E+00,-0.12990E+00,-0.12661E+00,&
     -0.12326E+00,-0.11985E+00,-0.11638E+00,-0.11286E+00,-0.10930E+00,&
     -0.10568E+00,-0.10201E+00,-0.98298E-01,-0.94541E-01,-0.90742E-01,&
     -0.86901E-01,-0.83019E-01,-0.79099E-01,-0.75141E-01,-0.71146E-01,&
     -0.67114E-01,-0.63048E-01,-0.58946E-01,-0.54810E-01,-0.50641E-01,&
     -0.46438E-01,-0.42202E-01,-0.37933E-01,-0.33632E-01,-0.29299E-01,&
     -0.24933E-01,-0.20535E-01,-0.16104E-01,-0.11641E-01,-0.71452E-02,&
     -0.26167E-02, 0.19444E-02, 0.65385E-02, 0.11166E-01, 0.15826E-01,&
      0.20520E-01, 0.25246E-01, 0.30007E-01, 0.34800E-01, 0.39627E-01,&
      0.44487E-01, 0.49381E-01, 0.54307E-01, 0.59265E-01, 0.64256E-01,&
      0.69279E-01, 0.74333E-01, 0.79418E-01, 0.84533E-01, 0.89677E-01,&
      0.94851E-01, 0.10005E+00, 0.10528E+00, 0.11054E+00, 0.11582E+00/
                             
     DATA (BNC12M (IA),IA=101,200)/                                     &
      0.12112E+00, 0.12645E+00, 0.13180E+00, 0.13717E+00, 0.14256E+00,&
      0.14797E+00, 0.15339E+00, 0.15884E+00, 0.16429E+00, 0.16977E+00,&
      0.17525E+00, 0.18075E+00, 0.18625E+00, 0.19177E+00, 0.19729E+00,&
      0.20283E+00, 0.20836E+00, 0.21391E+00, 0.21946E+00, 0.22501E+00,&
      0.23004E+00, 0.23565E+00, 0.24126E+00, 0.24687E+00, 0.25246E+00,&
      0.25805E+00, 0.26364E+00, 0.26922E+00, 0.27479E+00, 0.28035E+00,&
      0.28591E+00, 0.29146E+00, 0.29700E+00, 0.30253E+00, 0.30806E+00,&
      0.31357E+00, 0.31908E+00, 0.32458E+00, 0.33007E+00, 0.33555E+00,&
      0.34103E+00, 0.34649E+00, 0.35194E+00, 0.35739E+00, 0.36282E+00,&
      0.36825E+00, 0.37367E+00, 0.37907E+00, 0.38447E+00, 0.38985E+00,&
      0.39523E+00, 0.40060E+00, 0.40595E+00, 0.41130E+00, 0.41663E+00,&
      0.42196E+00, 0.42727E+00, 0.43257E+00, 0.43787E+00, 0.44315E+00,&
      0.44842E+00, 0.45368E+00, 0.45893E+00, 0.46417E+00, 0.46940E+00,&
      0.47462E+00, 0.47982E+00, 0.48502E+00, 0.49021E+00, 0.49538E+00,&
      0.50054E+00, 0.50570E+00, 0.51084E+00, 0.51597E+00, 0.52109E+00,&
      0.52620E+00, 0.53130E+00, 0.53638E+00, 0.54146E+00, 0.54652E+00,&
      0.55158E+00, 0.55662E+00, 0.56165E+00, 0.56668E+00, 0.57169E+00,&
      0.57669E+00, 0.58168E+00, 0.58665E+00, 0.59162E+00, 0.59658E+00,&
      0.60152E+00, 0.60646E+00, 0.61138E+00, 0.61630E+00, 0.62120E+00,&
      0.62609E+00, 0.63097E+00, 0.63584E+00, 0.64070E+00, 0.64555E+00/
                             
     DATA (BNC12M (IA),IA=201,300)/                                     &
      0.65039E+00, 0.65522E+00, 0.66004E+00, 0.66484E+00, 0.66964E+00,&
      0.67443E+00, 0.67920E+00, 0.68397E+00, 0.68872E+00, 0.69347E+00,&
      0.69820E+00, 0.70293E+00, 0.70764E+00, 0.71234E+00, 0.71704E+00,&
      0.72172E+00, 0.72639E+00, 0.73105E+00, 0.73571E+00, 0.74035E+00,&
      0.74498E+00, 0.74960E+00, 0.75422E+00, 0.75882E+00, 0.76341E+00,&
      0.76799E+00, 0.77257E+00, 0.77713E+00, 0.78168E+00, 0.78623E+00,&
      0.79076E+00, 0.79528E+00, 0.79980E+00, 0.80430E+00, 0.80880E+00,&
      0.81328E+00, 0.81776E+00, 0.82223E+00, 0.82668E+00, 0.83113E+00,&
      0.83557E+00, 0.84000E+00, 0.84442E+00, 0.84883E+00, 0.85323E+00,&
      0.85762E+00, 0.86200E+00, 0.86638E+00, 0.87074E+00, 0.87509E+00,&
      0.87944E+00, 0.88378E+00, 0.88810E+00, 0.89242E+00, 0.89673E+00,&
      0.90103E+00, 0.90533E+00, 0.90961E+00, 0.91388E+00, 0.91815E+00,&
      0.92240E+00, 0.92665E+00, 0.93089E+00, 0.93512E+00, 0.93934E+00,&
      0.94356E+00, 0.94776E+00, 0.95196E+00, 0.95614E+00, 0.96032E+00,&
      0.96449E+00, 0.96865E+00, 0.97281E+00, 0.97695E+00, 0.98109E+00,&
      0.98522E+00, 0.98934E+00, 0.99345E+00, 0.99755E+00, 0.10016E+01,&
      0.10057E+01, 0.10098E+01, 0.10139E+01, 0.10179E+01, 0.10220E+01,&
      0.10260E+01, 0.10301E+01, 0.10341E+01, 0.10381E+01, 0.10422E+01,&
      0.10462E+01, 0.10502E+01, 0.10541E+01, 0.10581E+01, 0.10621E+01,&
      0.10661E+01, 0.10700E+01, 0.10740E+01, 0.10779E+01, 0.10819E+01/
                             
     DATA (BNC12M (IA),IA=301,400)/                                     &
      0.10858E+01, 0.10897E+01, 0.10936E+01, 0.10975E+01, 0.11014E+01,&
      0.11053E+01, 0.11092E+01, 0.11131E+01, 0.11170E+01, 0.11208E+01,&
      0.11247E+01, 0.11285E+01, 0.11324E+01, 0.11362E+01, 0.11400E+01,&
      0.11438E+01, 0.11476E+01, 0.11514E+01, 0.11552E+01, 0.11590E+01,&
      0.11628E+01, 0.11666E+01, 0.11703E+01, 0.11741E+01, 0.11779E+01,&
      0.11816E+01, 0.11853E+01, 0.11891E+01, 0.11928E+01, 0.11965E+01,&
      0.12002E+01, 0.12039E+01, 0.12076E+01, 0.12113E+01, 0.12150E+01,&
      0.12187E+01, 0.12224E+01, 0.12260E+01, 0.12297E+01, 0.12333E+01,&
      0.12370E+01, 0.12406E+01, 0.12442E+01, 0.12479E+01, 0.12515E+01,&
      0.12551E+01, 0.12587E+01, 0.12623E+01, 0.12659E+01, 0.12695E+01,&
      0.12730E+01, 0.12766E+01, 0.12802E+01, 0.12837E+01, 0.12873E+01,&
      0.12908E+01, 0.12944E+01, 0.12979E+01, 0.13014E+01, 0.13050E+01,&
      0.13085E+01, 0.13120E+01, 0.13155E+01, 0.13190E+01, 0.13225E+01,&
      0.13259E+01, 0.13294E+01, 0.13329E+01, 0.13364E+01, 0.13398E+01,&
      0.13433E+01, 0.13467E+01, 0.13502E+01, 0.13536E+01, 0.13570E+01,&
      0.13604E+01, 0.13639E+01, 0.13673E+01, 0.13707E+01, 0.13741E+01,&
      0.13775E+01, 0.13809E+01, 0.13842E+01, 0.13876E+01, 0.13910E+01,&
      0.13943E+01, 0.13977E+01, 0.14011E+01, 0.14044E+01, 0.14077E+01,&
      0.14111E+01, 0.14144E+01, 0.14177E+01, 0.14210E+01, 0.14244E+01,&
      0.14277E+01, 0.14310E+01, 0.14343E+01, 0.14376E+01, 0.14408E+01/
                             
     DATA (BNC12M (IA),IA=401,500)/                                     &
      0.14441E+01, 0.14474E+01, 0.14507E+01, 0.14539E+01, 0.14572E+01,&
      0.14604E+01, 0.14637E+01, 0.14669E+01, 0.14701E+01, 0.14734E+01,&
      0.14766E+01, 0.14798E+01, 0.14830E+01, 0.14862E+01, 0.14894E+01,&
      0.14926E+01, 0.14958E+01, 0.14990E+01, 0.15022E+01, 0.15054E+01,&
      0.15086E+01, 0.15117E+01, 0.15149E+01, 0.15180E+01, 0.15212E+01,&
      0.15243E+01, 0.15275E+01, 0.15306E+01, 0.15337E+01, 0.15369E+01,&
      0.15400E+01, 0.15431E+01, 0.15462E+01, 0.15493E+01, 0.15524E+01,&
      0.15555E+01, 0.15586E+01, 0.15617E+01, 0.15648E+01, 0.15678E+01,&
      0.15709E+01, 0.15740E+01, 0.15770E+01, 0.15801E+01, 0.15831E+01,&
      0.15862E+01, 0.15892E+01, 0.15923E+01, 0.15953E+01, 0.15983E+01,&
      0.16014E+01, 0.16044E+01, 0.16074E+01, 0.16104E+01, 0.16134E+01,&
      0.16164E+01, 0.16194E+01, 0.16224E+01, 0.16254E+01, 0.16283E+01,&
      0.16313E+01, 0.16343E+01, 0.16372E+01, 0.16402E+01, 0.16432E+01,&
      0.16461E+01, 0.16491E+01, 0.16520E+01, 0.16549E+01, 0.16579E+01,&
      0.16608E+01, 0.16637E+01, 0.16666E+01, 0.16696E+01, 0.16725E+01,&
      0.16754E+01, 0.16783E+01, 0.16812E+01, 0.16841E+01, 0.16870E+01,&
      0.16898E+01, 0.16927E+01, 0.16956E+01, 0.16985E+01, 0.17013E+01,&
      0.17042E+01, 0.17071E+01, 0.17099E+01, 0.17128E+01, 0.17156E+01,&
      0.17185E+01, 0.17213E+01, 0.17241E+01, 0.17269E+01, 0.17298E+01,&
      0.17326E+01, 0.17354E+01, 0.17382E+01, 0.17410E+01, 0.17438E+01/
                             
     DATA (BNC12M (IA),IA=501,600)/                                     &
      0.17466E+01, 0.17494E+01, 0.17522E+01, 0.17550E+01, 0.17578E+01,&
      0.17606E+01, 0.17633E+01, 0.17661E+01, 0.17689E+01, 0.17716E+01,&
      0.17744E+01, 0.17771E+01, 0.17799E+01, 0.17826E+01, 0.17854E+01,&
      0.17881E+01, 0.17908E+01, 0.17936E+01, 0.17963E+01, 0.17990E+01,&
      0.18017E+01, 0.18044E+01, 0.18072E+01, 0.18099E+01, 0.18126E+01,&
      0.18153E+01, 0.18180E+01, 0.18206E+01, 0.18233E+01, 0.18260E+01,&
      0.18287E+01, 0.18314E+01, 0.18340E+01, 0.18367E+01, 0.18394E+01,&
      0.18420E+01, 0.18447E+01, 0.18473E+01, 0.18500E+01, 0.18526E+01,&
      0.18553E+01, 0.18579E+01, 0.18605E+01, 0.18632E+01, 0.18658E+01,&
      0.18684E+01, 0.18710E+01, 0.18736E+01, 0.18763E+01, 0.18789E+01,&
      0.18815E+01, 0.18841E+01, 0.18867E+01, 0.18892E+01, 0.18918E+01,&
      0.18944E+01, 0.18970E+01, 0.18996E+01, 0.19022E+01, 0.19047E+01,&
      0.19073E+01, 0.19099E+01, 0.19124E+01, 0.19150E+01, 0.19175E+01,&
      0.19201E+01, 0.19226E+01, 0.19252E+01, 0.19277E+01, 0.19302E+01,&
      0.19328E+01, 0.19353E+01, 0.19378E+01, 0.19403E+01, 0.19428E+01,&
      0.19454E+01, 0.19479E+01, 0.19504E+01, 0.19529E+01, 0.19554E+01,&
      0.19579E+01, 0.19604E+01, 0.19629E+01, 0.19653E+01, 0.19678E+01,&
      0.19703E+01, 0.19728E+01, 0.19753E+01, 0.19777E+01, 0.19802E+01,&
      0.19827E+01, 0.19851E+01, 0.19876E+01, 0.19900E+01, 0.19925E+01,&
      0.19949E+01, 0.19974E+01, 0.19998E+01, 0.20022E+01, 0.20114E+01/
                             
     DATA (BNC12M (IA),IA=601,700)/                                     &
      0.20312E+01, 0.20550E+01, 0.20785E+01, 0.21017E+01, 0.21246E+01,&
      0.21472E+01, 0.21695E+01, 0.21916E+01, 0.22134E+01, 0.22349E+01,&
      0.22561E+01, 0.22771E+01, 0.22978E+01, 0.23183E+01, 0.23386E+01,&
      0.23586E+01, 0.23784E+01, 0.23980E+01, 0.24173E+01, 0.24364E+01,&
      0.24553E+01, 0.24740E+01, 0.24925E+01, 0.25108E+01, 0.25289E+01,&
      0.25468E+01, 0.25646E+01, 0.25821E+01, 0.25994E+01, 0.26166E+01,&
      0.26336E+01, 0.26504E+01, 0.26670E+01, 0.26835E+01, 0.26998E+01,&
      0.27160E+01, 0.27320E+01, 0.27478E+01, 0.27635E+01, 0.27790E+01,&
      0.27943E+01, 0.28096E+01, 0.28247E+01, 0.28396E+01, 0.28544E+01,&
      0.28690E+01, 0.28836E+01, 0.28980E+01, 0.29122E+01, 0.29263E+01,&
      0.29403E+01, 0.29542E+01, 0.29680E+01, 0.29816E+01, 0.29951E+01,&
      0.30085E+01, 0.30217E+01, 0.30349E+01, 0.30479E+01, 0.30609E+01,&
      0.30737E+01, 0.30864E+01, 0.30990E+01, 0.31115E+01, 0.31239E+01,&
      0.31362E+01, 0.31483E+01, 0.31604E+01, 0.31724E+01, 0.31843E+01,&
      0.31961E+01, 0.32078E+01, 0.32194E+01, 0.32309E+01, 0.32423E+01,&
      0.32536E+01, 0.32648E+01, 0.32760E+01, 0.32870E+01, 0.32980E+01,&
      0.33089E+01, 0.33197E+01, 0.33304E+01, 0.33411E+01, 0.33516E+01,&
      0.33621E+01, 0.33725E+01, 0.33828E+01, 0.33931E+01, 0.34032E+01,&
      0.34133E+01, 0.34233E+01, 0.34333E+01, 0.34431E+01, 0.34529E+01,&
      0.34627E+01, 0.34723E+01, 0.34819E+01, 0.34914E+01, 0.35009E+01/
                             
     DATA (BNC12M(IA),IA=701,741)/                                      &
      0.35103E+01, 0.35196E+01, 0.35288E+01, 0.35380E+01, 0.35471E+01,&
      0.35562E+01, 0.35652E+01, 0.35741E+01, 0.35830E+01, 0.35918E+01,&
      0.36005E+01, 0.36092E+01, 0.36178E+01, 0.36264E+01, 0.36349E+01,&
      0.36434E+01, 0.36518E+01, 0.36601E+01, 0.36684E+01, 0.36766E+01,&
      0.36848E+01, 0.36929E+01, 0.37010E+01, 0.37090E+01, 0.37169E+01,&
      0.37248E+01, 0.37327E+01, 0.37405E+01, 0.37483E+01, 0.37560E+01,&
      0.37636E+01, 0.37712E+01, 0.37788E+01, 0.37863E+01, 0.37938E+01,&
      0.38012E+01, 0.38085E+01, 0.38159E+01, 0.38231E+01, 0.38304E+01,&
      0.38376E+01                  /                      
!                            
!  ** (NH4)3H(SO4)2          
!                            
     DATA (BNC13M (IA),IA=  1,100)/                                     &
     -0.86312E-01,-0.15717E+00,-0.20713E+00,-0.24120E+00,-0.26753E+00,&
     -0.28912E+00,-0.30750E+00,-0.32352E+00,-0.33773E+00,-0.35052E+00,&
     -0.36214E+00,-0.37278E+00,-0.38261E+00,-0.39173E+00,-0.40023E+00,&
     -0.40819E+00,-0.41567E+00,-0.42272E+00,-0.42938E+00,-0.43570E+00,&
     -0.44169E+00,-0.44739E+00,-0.45282E+00,-0.45800E+00,-0.46295E+00,&
     -0.46769E+00,-0.47222E+00,-0.47657E+00,-0.48073E+00,-0.48473E+00,&
     -0.48858E+00,-0.49227E+00,-0.49582E+00,-0.49924E+00,-0.50253E+00,&
     -0.50570E+00,-0.50875E+00,-0.51169E+00,-0.51453E+00,-0.51726E+00,&
     -0.51990E+00,-0.52245E+00,-0.52490E+00,-0.52727E+00,-0.52956E+00,&
     -0.53177E+00,-0.53391E+00,-0.53597E+00,-0.53796E+00,-0.53988E+00,&
     -0.54174E+00,-0.54353E+00,-0.54527E+00,-0.54694E+00,-0.54856E+00,&
     -0.55013E+00,-0.55164E+00,-0.55310E+00,-0.55451E+00,-0.55588E+00,&
     -0.55720E+00,-0.55847E+00,-0.55970E+00,-0.56089E+00,-0.56204E+00,&
     -0.56315E+00,-0.56422E+00,-0.56526E+00,-0.56625E+00,-0.56722E+00,&
     -0.56815E+00,-0.56904E+00,-0.56991E+00,-0.57074E+00,-0.57154E+00,&
     -0.57231E+00,-0.57305E+00,-0.57377E+00,-0.57445E+00,-0.57511E+00,&
     -0.57574E+00,-0.57635E+00,-0.57693E+00,-0.57748E+00,-0.57802E+00,&
     -0.57852E+00,-0.57900E+00,-0.57946E+00,-0.57990E+00,-0.58032E+00,&
     -0.58071E+00,-0.58108E+00,-0.58143E+00,-0.58176E+00,-0.58208E+00,&
     -0.58237E+00,-0.58264E+00,-0.58290E+00,-0.58314E+00,-0.58336E+00/
                             
     DATA (BNC13M (IA),IA=101,200)/                                     &
     -0.58356E+00,-0.58375E+00,-0.58392E+00,-0.58408E+00,-0.58422E+00,&
     -0.58435E+00,-0.58447E+00,-0.58457E+00,-0.58466E+00,-0.58473E+00,&
     -0.58480E+00,-0.58485E+00,-0.58489E+00,-0.58492E+00,-0.58494E+00,&
     -0.58495E+00,-0.58496E+00,-0.58495E+00,-0.58493E+00,-0.58491E+00,&
     -0.58498E+00,-0.58493E+00,-0.58487E+00,-0.58481E+00,-0.58474E+00,&
     -0.58467E+00,-0.58459E+00,-0.58450E+00,-0.58441E+00,-0.58432E+00,&
     -0.58422E+00,-0.58412E+00,-0.58401E+00,-0.58390E+00,-0.58379E+00,&
     -0.58367E+00,-0.58355E+00,-0.58342E+00,-0.58330E+00,-0.58316E+00,&
     -0.58303E+00,-0.58289E+00,-0.58275E+00,-0.58261E+00,-0.58246E+00,&
     -0.58232E+00,-0.58217E+00,-0.58201E+00,-0.58186E+00,-0.58170E+00,&
     -0.58154E+00,-0.58138E+00,-0.58122E+00,-0.58106E+00,-0.58089E+00,&
     -0.58072E+00,-0.58056E+00,-0.58039E+00,-0.58021E+00,-0.58004E+00,&
     -0.57987E+00,-0.57969E+00,-0.57951E+00,-0.57934E+00,-0.57916E+00,&
     -0.57898E+00,-0.57880E+00,-0.57862E+00,-0.57844E+00,-0.57825E+00,&
     -0.57807E+00,-0.57789E+00,-0.57770E+00,-0.57752E+00,-0.57733E+00,&
     -0.57715E+00,-0.57696E+00,-0.57677E+00,-0.57658E+00,-0.57640E+00,&
     -0.57621E+00,-0.57602E+00,-0.57583E+00,-0.57564E+00,-0.57546E+00,&
     -0.57527E+00,-0.57508E+00,-0.57489E+00,-0.57470E+00,-0.57451E+00,&
     -0.57432E+00,-0.57413E+00,-0.57394E+00,-0.57375E+00,-0.57356E+00,&
     -0.57338E+00,-0.57319E+00,-0.57300E+00,-0.57281E+00,-0.57262E+00/
                             
     DATA (BNC13M (IA),IA=201,300)/                                     &
     -0.57243E+00,-0.57225E+00,-0.57206E+00,-0.57187E+00,-0.57168E+00,&
     -0.57150E+00,-0.57131E+00,-0.57112E+00,-0.57094E+00,-0.57075E+00,&
     -0.57057E+00,-0.57038E+00,-0.57020E+00,-0.57002E+00,-0.56983E+00,&
     -0.56965E+00,-0.56947E+00,-0.56928E+00,-0.56910E+00,-0.56892E+00,&
     -0.56874E+00,-0.56856E+00,-0.56838E+00,-0.56820E+00,-0.56802E+00,&
     -0.56784E+00,-0.56766E+00,-0.56749E+00,-0.56731E+00,-0.56713E+00,&
     -0.56696E+00,-0.56678E+00,-0.56661E+00,-0.56643E+00,-0.56626E+00,&
     -0.56609E+00,-0.56591E+00,-0.56574E+00,-0.56557E+00,-0.56540E+00,&
     -0.56523E+00,-0.56506E+00,-0.56489E+00,-0.56472E+00,-0.56456E+00,&
     -0.56439E+00,-0.56422E+00,-0.56406E+00,-0.56389E+00,-0.56373E+00,&
     -0.56356E+00,-0.56340E+00,-0.56324E+00,-0.56308E+00,-0.56292E+00,&
     -0.56276E+00,-0.56260E+00,-0.56244E+00,-0.56228E+00,-0.56212E+00,&
     -0.56196E+00,-0.56181E+00,-0.56165E+00,-0.56150E+00,-0.56134E+00,&
     -0.56119E+00,-0.56103E+00,-0.56088E+00,-0.56073E+00,-0.56058E+00,&
     -0.56043E+00,-0.56028E+00,-0.56013E+00,-0.55998E+00,-0.55983E+00,&
     -0.55969E+00,-0.55954E+00,-0.55940E+00,-0.55925E+00,-0.55911E+00,&
     -0.55896E+00,-0.55882E+00,-0.55868E+00,-0.55854E+00,-0.55840E+00,&
     -0.55826E+00,-0.55812E+00,-0.55798E+00,-0.55784E+00,-0.55770E+00,&
     -0.55757E+00,-0.55743E+00,-0.55730E+00,-0.55716E+00,-0.55703E+00,&
     -0.55690E+00,-0.55676E+00,-0.55663E+00,-0.55650E+00,-0.55637E+00/
                             
     DATA (BNC13M (IA),IA=301,400)/                                     &
     -0.55624E+00,-0.55611E+00,-0.55599E+00,-0.55586E+00,-0.55573E+00,&
     -0.55561E+00,-0.55548E+00,-0.55536E+00,-0.55523E+00,-0.55511E+00,&
     -0.55499E+00,-0.55487E+00,-0.55475E+00,-0.55463E+00,-0.55451E+00,&
     -0.55439E+00,-0.55427E+00,-0.55415E+00,-0.55404E+00,-0.55392E+00,&
     -0.55380E+00,-0.55369E+00,-0.55358E+00,-0.55346E+00,-0.55335E+00,&
     -0.55324E+00,-0.55313E+00,-0.55302E+00,-0.55291E+00,-0.55280E+00,&
     -0.55269E+00,-0.55258E+00,-0.55248E+00,-0.55237E+00,-0.55226E+00,&
     -0.55216E+00,-0.55206E+00,-0.55195E+00,-0.55185E+00,-0.55175E+00,&
     -0.55165E+00,-0.55155E+00,-0.55145E+00,-0.55135E+00,-0.55125E+00,&
     -0.55115E+00,-0.55105E+00,-0.55096E+00,-0.55086E+00,-0.55077E+00,&
     -0.55067E+00,-0.55058E+00,-0.55048E+00,-0.55039E+00,-0.55030E+00,&
     -0.55021E+00,-0.55012E+00,-0.55003E+00,-0.54994E+00,-0.54985E+00,&
     -0.54976E+00,-0.54968E+00,-0.54959E+00,-0.54951E+00,-0.54942E+00,&
     -0.54934E+00,-0.54925E+00,-0.54917E+00,-0.54909E+00,-0.54900E+00,&
     -0.54892E+00,-0.54884E+00,-0.54876E+00,-0.54868E+00,-0.54861E+00,&
     -0.54853E+00,-0.54845E+00,-0.54838E+00,-0.54830E+00,-0.54822E+00,&
     -0.54815E+00,-0.54808E+00,-0.54800E+00,-0.54793E+00,-0.54786E+00,&
     -0.54779E+00,-0.54772E+00,-0.54765E+00,-0.54758E+00,-0.54751E+00,&
     -0.54744E+00,-0.54737E+00,-0.54731E+00,-0.54724E+00,-0.54717E+00,&
     -0.54711E+00,-0.54705E+00,-0.54698E+00,-0.54692E+00,-0.54686E+00/
                             
     DATA (BNC13M (IA),IA=401,500)/                                     &
     -0.54679E+00,-0.54673E+00,-0.54667E+00,-0.54661E+00,-0.54655E+00,&
     -0.54650E+00,-0.54644E+00,-0.54638E+00,-0.54632E+00,-0.54627E+00,&
     -0.54621E+00,-0.54616E+00,-0.54610E+00,-0.54605E+00,-0.54600E+00,&
     -0.54594E+00,-0.54589E+00,-0.54584E+00,-0.54579E+00,-0.54574E+00,&
     -0.54569E+00,-0.54564E+00,-0.54559E+00,-0.54555E+00,-0.54550E+00,&
     -0.54545E+00,-0.54541E+00,-0.54536E+00,-0.54532E+00,-0.54527E+00,&
     -0.54523E+00,-0.54519E+00,-0.54515E+00,-0.54510E+00,-0.54506E+00,&
     -0.54502E+00,-0.54498E+00,-0.54494E+00,-0.54491E+00,-0.54487E+00,&
     -0.54483E+00,-0.54479E+00,-0.54476E+00,-0.54472E+00,-0.54469E+00,&
     -0.54465E+00,-0.54462E+00,-0.54458E+00,-0.54455E+00,-0.54452E+00,&
     -0.54449E+00,-0.54446E+00,-0.54443E+00,-0.54440E+00,-0.54437E+00,&
     -0.54434E+00,-0.54431E+00,-0.54428E+00,-0.54426E+00,-0.54423E+00,&
     -0.54420E+00,-0.54418E+00,-0.54415E+00,-0.54413E+00,-0.54411E+00,&
     -0.54408E+00,-0.54406E+00,-0.54404E+00,-0.54402E+00,-0.54400E+00,&
     -0.54397E+00,-0.54395E+00,-0.54394E+00,-0.54392E+00,-0.54390E+00,&
     -0.54388E+00,-0.54386E+00,-0.54385E+00,-0.54383E+00,-0.54382E+00,&
     -0.54380E+00,-0.54379E+00,-0.54377E+00,-0.54376E+00,-0.54375E+00,&
     -0.54373E+00,-0.54372E+00,-0.54371E+00,-0.54370E+00,-0.54369E+00,&
     -0.54368E+00,-0.54367E+00,-0.54366E+00,-0.54366E+00,-0.54365E+00,&
     -0.54364E+00,-0.54364E+00,-0.54363E+00,-0.54362E+00,-0.54362E+00/
                             
     DATA (BNC13M (IA),IA=501,600)/                                     &
     -0.54362E+00,-0.54361E+00,-0.54361E+00,-0.54361E+00,-0.54360E+00,&
     -0.54360E+00,-0.54360E+00,-0.54360E+00,-0.54360E+00,-0.54360E+00,&
     -0.54360E+00,-0.54360E+00,-0.54360E+00,-0.54361E+00,-0.54361E+00,&
     -0.54361E+00,-0.54362E+00,-0.54362E+00,-0.54363E+00,-0.54363E+00,&
     -0.54364E+00,-0.54365E+00,-0.54365E+00,-0.54366E+00,-0.54367E+00,&
     -0.54368E+00,-0.54369E+00,-0.54369E+00,-0.54370E+00,-0.54371E+00,&
     -0.54373E+00,-0.54374E+00,-0.54375E+00,-0.54376E+00,-0.54377E+00,&
     -0.54379E+00,-0.54380E+00,-0.54382E+00,-0.54383E+00,-0.54385E+00,&
     -0.54386E+00,-0.54388E+00,-0.54390E+00,-0.54391E+00,-0.54393E+00,&
     -0.54395E+00,-0.54397E+00,-0.54399E+00,-0.54401E+00,-0.54403E+00,&
     -0.54405E+00,-0.54407E+00,-0.54409E+00,-0.54411E+00,-0.54413E+00,&
     -0.54416E+00,-0.54418E+00,-0.54420E+00,-0.54423E+00,-0.54425E+00,&
     -0.54428E+00,-0.54430E+00,-0.54433E+00,-0.54436E+00,-0.54438E+00,&
     -0.54441E+00,-0.54444E+00,-0.54447E+00,-0.54450E+00,-0.54453E+00,&
     -0.54456E+00,-0.54459E+00,-0.54462E+00,-0.54465E+00,-0.54468E+00,&
     -0.54471E+00,-0.54475E+00,-0.54478E+00,-0.54481E+00,-0.54485E+00,&
     -0.54488E+00,-0.54492E+00,-0.54495E+00,-0.54499E+00,-0.54502E+00,&
     -0.54506E+00,-0.54510E+00,-0.54513E+00,-0.54517E+00,-0.54521E+00,&
     -0.54525E+00,-0.54529E+00,-0.54533E+00,-0.54537E+00,-0.54541E+00,&
     -0.54545E+00,-0.54549E+00,-0.54553E+00,-0.54558E+00,-0.54574E+00/
                             
     DATA (BNC13M (IA),IA=601,700)/                                     &
     -0.54612E+00,-0.54661E+00,-0.54715E+00,-0.54773E+00,-0.54835E+00,&
     -0.54901E+00,-0.54971E+00,-0.55044E+00,-0.55121E+00,-0.55202E+00,&
     -0.55286E+00,-0.55374E+00,-0.55466E+00,-0.55560E+00,-0.55658E+00,&
     -0.55760E+00,-0.55864E+00,-0.55972E+00,-0.56083E+00,-0.56196E+00,&
     -0.56313E+00,-0.56433E+00,-0.56556E+00,-0.56681E+00,-0.56809E+00,&
     -0.56940E+00,-0.57074E+00,-0.57210E+00,-0.57349E+00,-0.57491E+00,&
     -0.57635E+00,-0.57782E+00,-0.57931E+00,-0.58082E+00,-0.58236E+00,&
     -0.58392E+00,-0.58551E+00,-0.58712E+00,-0.58875E+00,-0.59040E+00,&
     -0.59207E+00,-0.59377E+00,-0.59549E+00,-0.59722E+00,-0.59898E+00,&
     -0.60076E+00,-0.60256E+00,-0.60438E+00,-0.60621E+00,-0.60807E+00,&
     -0.60994E+00,-0.61183E+00,-0.61375E+00,-0.61567E+00,-0.61762E+00,&
     -0.61959E+00,-0.62157E+00,-0.62357E+00,-0.62558E+00,-0.62761E+00,&
     -0.62966E+00,-0.63173E+00,-0.63381E+00,-0.63590E+00,-0.63801E+00,&
     -0.64014E+00,-0.64228E+00,-0.64444E+00,-0.64661E+00,-0.64879E+00,&
     -0.65099E+00,-0.65321E+00,-0.65544E+00,-0.65768E+00,-0.65993E+00,&
     -0.66220E+00,-0.66448E+00,-0.66678E+00,-0.66909E+00,-0.67141E+00,&
     -0.67374E+00,-0.67609E+00,-0.67845E+00,-0.68082E+00,-0.68320E+00,&
     -0.68560E+00,-0.68800E+00,-0.69042E+00,-0.69285E+00,-0.69529E+00,&
     -0.69774E+00,-0.70021E+00,-0.70268E+00,-0.70516E+00,-0.70766E+00,&
     -0.71017E+00,-0.71268E+00,-0.71521E+00,-0.71775E+00,-0.72030E+00/
                             
     DATA (BNC13M(IA),IA=701,741)/                                      &
     -0.72285E+00,-0.72542E+00,-0.72800E+00,-0.73059E+00,-0.73318E+00,&
     -0.73579E+00,-0.73840E+00,-0.74103E+00,-0.74366E+00,-0.74631E+00,&
     -0.74896E+00,-0.75162E+00,-0.75429E+00,-0.75697E+00,-0.75966E+00,&
     -0.76235E+00,-0.76505E+00,-0.76777E+00,-0.77049E+00,-0.77322E+00,&
     -0.77595E+00,-0.77870E+00,-0.78145E+00,-0.78421E+00,-0.78698E+00,&
     -0.78976E+00,-0.79254E+00,-0.79534E+00,-0.79814E+00,-0.80094E+00,&
     -0.80376E+00,-0.80658E+00,-0.80941E+00,-0.81224E+00,-0.81509E+00,&
     -0.81794E+00,-0.82079E+00,-0.82366E+00,-0.82653E+00,-0.82940E+00,&
     -0.83229E+00                  /                      
!     END                     
                             
!  ** TEMP = 273.0           
                             
!     BLOCK DATA KMCF273      
!                            
!  ** Common block definition
!                            
!     COMMON /KMC273/                                                  &    
!     BNC01M(  741),BNC02M(  741),BNC03M(  741),BNC04M(  741),         &
!     BNC05M(  741),BNC06M(  741),BNC07M(  741),BNC08M(  741),         &
!     BNC09M(  741),BNC10M(  741),BNC11M(  741),BNC12M(  741),         &
!     BNC13M(  741)           
!                            
!  ** NaCl                   
!                            
     DATA (BNC01M (IA),IA=  1,100)/                                     &
     -0.51181E-01,-0.90341E-01,-0.11577E+00,-0.13175E+00,-0.14316E+00,&
     -0.15182E+00,-0.15860E+00,-0.16404E+00,-0.16845E+00,-0.17205E+00,&
     -0.17501E+00,-0.17742E+00,-0.17939E+00,-0.18097E+00,-0.18222E+00,&
     -0.18320E+00,-0.18392E+00,-0.18442E+00,-0.18473E+00,-0.18487E+00,&
     -0.18485E+00,-0.18470E+00,-0.18442E+00,-0.18402E+00,-0.18353E+00,&
     -0.18294E+00,-0.18227E+00,-0.18153E+00,-0.18071E+00,-0.17983E+00,&
     -0.17889E+00,-0.17790E+00,-0.17686E+00,-0.17578E+00,-0.17466E+00,&
     -0.17350E+00,-0.17231E+00,-0.17109E+00,-0.16984E+00,-0.16856E+00,&
     -0.16726E+00,-0.16594E+00,-0.16461E+00,-0.16325E+00,-0.16188E+00,&
     -0.16050E+00,-0.15910E+00,-0.15769E+00,-0.15627E+00,-0.15484E+00,&
     -0.15340E+00,-0.15196E+00,-0.15050E+00,-0.14904E+00,-0.14757E+00,&
     -0.14610E+00,-0.14462E+00,-0.14313E+00,-0.14164E+00,-0.14014E+00,&
     -0.13863E+00,-0.13712E+00,-0.13560E+00,-0.13408E+00,-0.13255E+00,&
     -0.13101E+00,-0.12947E+00,-0.12792E+00,-0.12636E+00,-0.12479E+00,&
     -0.12321E+00,-0.12163E+00,-0.12003E+00,-0.11843E+00,-0.11681E+00,&
     -0.11518E+00,-0.11355E+00,-0.11189E+00,-0.11023E+00,-0.10856E+00,&
     -0.10687E+00,-0.10517E+00,-0.10346E+00,-0.10173E+00,-0.99989E-01,&
     -0.98234E-01,-0.96465E-01,-0.94683E-01,-0.92886E-01,-0.91075E-01,&
     -0.89250E-01,-0.87411E-01,-0.85558E-01,-0.83692E-01,-0.81812E-01,&
     -0.79919E-01,-0.78013E-01,-0.76094E-01,-0.74163E-01,-0.72220E-01/
                             
     DATA (BNC01M (IA),IA=101,200)/                                     &
     -0.70265E-01,-0.68299E-01,-0.66323E-01,-0.64335E-01,-0.62338E-01,&
     -0.60331E-01,-0.58315E-01,-0.56291E-01,-0.54258E-01,-0.52218E-01,&
     -0.50171E-01,-0.48116E-01,-0.46056E-01,-0.43989E-01,-0.41917E-01,&
     -0.39840E-01,-0.37759E-01,-0.35673E-01,-0.33583E-01,-0.31490E-01,&
     -0.29641E-01,-0.27514E-01,-0.25387E-01,-0.23261E-01,-0.21135E-01,&
     -0.19010E-01,-0.16886E-01,-0.14763E-01,-0.12640E-01,-0.10519E-01,&
     -0.83981E-02,-0.62786E-02,-0.41603E-02,-0.20431E-02, 0.72873E-04,&
      0.21874E-02, 0.43007E-02, 0.64126E-02, 0.85231E-02, 0.10632E-01,&
      0.12740E-01, 0.14845E-01, 0.16950E-01, 0.19052E-01, 0.21153E-01,&
      0.23252E-01, 0.25350E-01, 0.27446E-01, 0.29539E-01, 0.31631E-01,&
      0.33721E-01, 0.35809E-01, 0.37895E-01, 0.39979E-01, 0.42061E-01,&
      0.44141E-01, 0.46219E-01, 0.48295E-01, 0.50369E-01, 0.52440E-01,&
      0.54509E-01, 0.56576E-01, 0.58641E-01, 0.60703E-01, 0.62764E-01,&
      0.64821E-01, 0.66877E-01, 0.68930E-01, 0.70981E-01, 0.73029E-01,&
      0.75075E-01, 0.77119E-01, 0.79160E-01, 0.81199E-01, 0.83235E-01,&
      0.85268E-01, 0.87299E-01, 0.89328E-01, 0.91354E-01, 0.93378E-01,&
      0.95399E-01, 0.97417E-01, 0.99433E-01, 0.10145E+00, 0.10346E+00,&
      0.10546E+00, 0.10747E+00, 0.10947E+00, 0.11147E+00, 0.11347E+00,&
      0.11546E+00, 0.11746E+00, 0.11944E+00, 0.12143E+00, 0.12341E+00,&
      0.12540E+00, 0.12737E+00, 0.12935E+00, 0.13132E+00, 0.13329E+00/
                             
     DATA (BNC01M (IA),IA=201,300)/                                     &
      0.13526E+00, 0.13722E+00, 0.13919E+00, 0.14114E+00, 0.14310E+00,&
      0.14505E+00, 0.14700E+00, 0.14895E+00, 0.15090E+00, 0.15284E+00,&
      0.15478E+00, 0.15671E+00, 0.15865E+00, 0.16058E+00, 0.16251E+00,&
      0.16443E+00, 0.16635E+00, 0.16827E+00, 0.17019E+00, 0.17210E+00,&
      0.17402E+00, 0.17592E+00, 0.17783E+00, 0.17973E+00, 0.18163E+00,&
      0.18353E+00, 0.18542E+00, 0.18731E+00, 0.18920E+00, 0.19109E+00,&
      0.19297E+00, 0.19485E+00, 0.19672E+00, 0.19860E+00, 0.20047E+00,&
      0.20234E+00, 0.20420E+00, 0.20606E+00, 0.20792E+00, 0.20978E+00,&
      0.21164E+00, 0.21349E+00, 0.21533E+00, 0.21718E+00, 0.21902E+00,&
      0.22086E+00, 0.22270E+00, 0.22453E+00, 0.22636E+00, 0.22819E+00,&
      0.23002E+00, 0.23184E+00, 0.23366E+00, 0.23548E+00, 0.23729E+00,&
      0.23910E+00, 0.24091E+00, 0.24272E+00, 0.24452E+00, 0.24632E+00,&
      0.24812E+00, 0.24991E+00, 0.25170E+00, 0.25349E+00, 0.25528E+00,&
      0.25706E+00, 0.25884E+00, 0.26062E+00, 0.26239E+00, 0.26417E+00,&
      0.26594E+00, 0.26770E+00, 0.26947E+00, 0.27123E+00, 0.27299E+00,&
      0.27474E+00, 0.27649E+00, 0.27824E+00, 0.27999E+00, 0.28173E+00,&
      0.28348E+00, 0.28522E+00, 0.28695E+00, 0.28869E+00, 0.29042E+00,&
      0.29214E+00, 0.29387E+00, 0.29559E+00, 0.29731E+00, 0.29903E+00,&
      0.30074E+00, 0.30245E+00, 0.30416E+00, 0.30587E+00, 0.30757E+00,&
      0.30927E+00, 0.31097E+00, 0.31267E+00, 0.31436E+00, 0.31605E+00/
                             
     DATA (BNC01M (IA),IA=301,400)/                                     &
      0.31774E+00, 0.31942E+00, 0.32111E+00, 0.32279E+00, 0.32446E+00,&
      0.32614E+00, 0.32781E+00, 0.32948E+00, 0.33115E+00, 0.33281E+00,&
      0.33447E+00, 0.33613E+00, 0.33779E+00, 0.33944E+00, 0.34109E+00,&
      0.34274E+00, 0.34438E+00, 0.34603E+00, 0.34767E+00, 0.34930E+00,&
      0.35094E+00, 0.35257E+00, 0.35420E+00, 0.35583E+00, 0.35746E+00,&
      0.35908E+00, 0.36070E+00, 0.36232E+00, 0.36393E+00, 0.36554E+00,&
      0.36715E+00, 0.36876E+00, 0.37037E+00, 0.37197E+00, 0.37357E+00,&
      0.37517E+00, 0.37676E+00, 0.37835E+00, 0.37994E+00, 0.38153E+00,&
      0.38312E+00, 0.38470E+00, 0.38628E+00, 0.38786E+00, 0.38943E+00,&
      0.39100E+00, 0.39257E+00, 0.39414E+00, 0.39571E+00, 0.39727E+00,&
      0.39883E+00, 0.40039E+00, 0.40195E+00, 0.40350E+00, 0.40505E+00,&
      0.40660E+00, 0.40814E+00, 0.40969E+00, 0.41123E+00, 0.41277E+00,&
      0.41431E+00, 0.41584E+00, 0.41737E+00, 0.41890E+00, 0.42043E+00,&
      0.42195E+00, 0.42348E+00, 0.42500E+00, 0.42651E+00, 0.42803E+00,&
      0.42954E+00, 0.43105E+00, 0.43256E+00, 0.43407E+00, 0.43557E+00,&
      0.43707E+00, 0.43857E+00, 0.44007E+00, 0.44157E+00, 0.44306E+00,&
      0.44455E+00, 0.44604E+00, 0.44752E+00, 0.44901E+00, 0.45049E+00,&
      0.45197E+00, 0.45344E+00, 0.45492E+00, 0.45639E+00, 0.45786E+00,&
      0.45933E+00, 0.46079E+00, 0.46226E+00, 0.46372E+00, 0.46518E+00,&
      0.46664E+00, 0.46809E+00, 0.46954E+00, 0.47099E+00, 0.47244E+00/
                             
     DATA (BNC01M (IA),IA=401,500)/                                     &
      0.47389E+00, 0.47533E+00, 0.47677E+00, 0.47821E+00, 0.47965E+00,&
      0.48108E+00, 0.48252E+00, 0.48395E+00, 0.48538E+00, 0.48680E+00,&
      0.48823E+00, 0.48965E+00, 0.49107E+00, 0.49249E+00, 0.49391E+00,&
      0.49532E+00, 0.49673E+00, 0.49814E+00, 0.49955E+00, 0.50095E+00,&
      0.50236E+00, 0.50376E+00, 0.50516E+00, 0.50656E+00, 0.50795E+00,&
      0.50934E+00, 0.51074E+00, 0.51213E+00, 0.51351E+00, 0.51490E+00,&
      0.51628E+00, 0.51766E+00, 0.51904E+00, 0.52042E+00, 0.52179E+00,&
      0.52317E+00, 0.52454E+00, 0.52591E+00, 0.52727E+00, 0.52864E+00,&
      0.53000E+00, 0.53136E+00, 0.53272E+00, 0.53408E+00, 0.53543E+00,&
      0.53678E+00, 0.53814E+00, 0.53949E+00, 0.54083E+00, 0.54218E+00,&
      0.54352E+00, 0.54486E+00, 0.54620E+00, 0.54754E+00, 0.54888E+00,&
      0.55021E+00, 0.55154E+00, 0.55287E+00, 0.55420E+00, 0.55552E+00,&
      0.55685E+00, 0.55817E+00, 0.55949E+00, 0.56081E+00, 0.56213E+00,&
      0.56344E+00, 0.56475E+00, 0.56606E+00, 0.56737E+00, 0.56868E+00,&
      0.56999E+00, 0.57129E+00, 0.57259E+00, 0.57389E+00, 0.57519E+00,&
      0.57649E+00, 0.57778E+00, 0.57907E+00, 0.58036E+00, 0.58165E+00,&
      0.58294E+00, 0.58422E+00, 0.58551E+00, 0.58679E+00, 0.58807E+00,&
      0.58935E+00, 0.59062E+00, 0.59190E+00, 0.59317E+00, 0.59444E+00,&
      0.59571E+00, 0.59698E+00, 0.59824E+00, 0.59951E+00, 0.60077E+00,&
      0.60203E+00, 0.60329E+00, 0.60454E+00, 0.60580E+00, 0.60705E+00/
                             
     DATA (BNC01M (IA),IA=501,600)/                                     &
      0.60830E+00, 0.60955E+00, 0.61080E+00, 0.61205E+00, 0.61329E+00,&
      0.61454E+00, 0.61578E+00, 0.61702E+00, 0.61825E+00, 0.61949E+00,&
      0.62072E+00, 0.62196E+00, 0.62319E+00, 0.62442E+00, 0.62565E+00,&
      0.62687E+00, 0.62810E+00, 0.62932E+00, 0.63054E+00, 0.63176E+00,&
      0.63298E+00, 0.63419E+00, 0.63541E+00, 0.63662E+00, 0.63783E+00,&
      0.63904E+00, 0.64025E+00, 0.64145E+00, 0.64266E+00, 0.64386E+00,&
      0.64506E+00, 0.64626E+00, 0.64746E+00, 0.64866E+00, 0.64985E+00,&
      0.65104E+00, 0.65223E+00, 0.65342E+00, 0.65461E+00, 0.65580E+00,&
      0.65698E+00, 0.65817E+00, 0.65935E+00, 0.66053E+00, 0.66171E+00,&
      0.66289E+00, 0.66406E+00, 0.66524E+00, 0.66641E+00, 0.66758E+00,&
      0.66875E+00, 0.66992E+00, 0.67108E+00, 0.67225E+00, 0.67341E+00,&
      0.67457E+00, 0.67573E+00, 0.67689E+00, 0.67805E+00, 0.67920E+00,&
      0.68036E+00, 0.68151E+00, 0.68266E+00, 0.68381E+00, 0.68496E+00,&
      0.68610E+00, 0.68725E+00, 0.68839E+00, 0.68953E+00, 0.69068E+00,&
      0.69181E+00, 0.69295E+00, 0.69409E+00, 0.69522E+00, 0.69636E+00,&
      0.69749E+00, 0.69862E+00, 0.69975E+00, 0.70087E+00, 0.70200E+00,&
      0.70312E+00, 0.70425E+00, 0.70537E+00, 0.70649E+00, 0.70760E+00,&
      0.70872E+00, 0.70984E+00, 0.71095E+00, 0.71206E+00, 0.71317E+00,&
      0.71428E+00, 0.71539E+00, 0.71650E+00, 0.71761E+00, 0.71871E+00,&
      0.71981E+00, 0.72091E+00, 0.72201E+00, 0.72311E+00, 0.72722E+00/
                             
     DATA (BNC01M (IA),IA=601,700)/                                     &
      0.73618E+00, 0.74693E+00, 0.75754E+00, 0.76801E+00, 0.77836E+00,&
      0.78859E+00, 0.79869E+00, 0.80867E+00, 0.81853E+00, 0.82827E+00,&
      0.83790E+00, 0.84742E+00, 0.85682E+00, 0.86613E+00, 0.87532E+00,&
      0.88441E+00, 0.89340E+00, 0.90229E+00, 0.91108E+00, 0.91978E+00,&
      0.92838E+00, 0.93688E+00, 0.94530E+00, 0.95363E+00, 0.96187E+00,&
      0.97002E+00, 0.97808E+00, 0.98607E+00, 0.99397E+00, 0.10018E+01,&
      0.10095E+01, 0.10172E+01, 0.10248E+01, 0.10323E+01, 0.10397E+01,&
      0.10471E+01, 0.10544E+01, 0.10616E+01, 0.10688E+01, 0.10758E+01,&
      0.10828E+01, 0.10898E+01, 0.10967E+01, 0.11035E+01, 0.11102E+01,&
      0.11169E+01, 0.11236E+01, 0.11301E+01, 0.11366E+01, 0.11431E+01,&
      0.11495E+01, 0.11558E+01, 0.11621E+01, 0.11683E+01, 0.11745E+01,&
      0.11806E+01, 0.11867E+01, 0.11927E+01, 0.11986E+01, 0.12045E+01,&
      0.12104E+01, 0.12162E+01, 0.12220E+01, 0.12277E+01, 0.12333E+01,&
      0.12389E+01, 0.12445E+01, 0.12500E+01, 0.12555E+01, 0.12609E+01,&
      0.12663E+01, 0.12717E+01, 0.12770E+01, 0.12822E+01, 0.12874E+01,&
      0.12926E+01, 0.12977E+01, 0.13028E+01, 0.13079E+01, 0.13129E+01,&
      0.13179E+01, 0.13228E+01, 0.13277E+01, 0.13325E+01, 0.13374E+01,&
      0.13421E+01, 0.13469E+01, 0.13516E+01, 0.13563E+01, 0.13609E+01,&
      0.13655E+01, 0.13701E+01, 0.13746E+01, 0.13792E+01, 0.13836E+01,&
      0.13881E+01, 0.13925E+01, 0.13968E+01, 0.14012E+01, 0.14055E+01/
                             
     DATA (BNC01M(IA),IA=701,741)/                                      &
      0.14098E+01, 0.14140E+01, 0.14183E+01, 0.14224E+01, 0.14266E+01,&
      0.14307E+01, 0.14348E+01, 0.14389E+01, 0.14430E+01, 0.14470E+01,&
      0.14510E+01, 0.14549E+01, 0.14589E+01, 0.14628E+01, 0.14666E+01,&
      0.14705E+01, 0.14743E+01, 0.14781E+01, 0.14819E+01, 0.14856E+01,&
      0.14894E+01, 0.14931E+01, 0.14967E+01, 0.15004E+01, 0.15040E+01,&
      0.15076E+01, 0.15112E+01, 0.15147E+01, 0.15183E+01, 0.15218E+01,&
      0.15253E+01, 0.15287E+01, 0.15322E+01, 0.15356E+01, 0.15390E+01,&
      0.15424E+01, 0.15457E+01, 0.15490E+01, 0.15524E+01, 0.15556E+01,&
      0.15589E+01                  /                      
!                            
!  ** Na2SO4                 
!                            
     DATA (BNC02M (IA),IA=  1,100)/                                     &
     -0.10572E+00,-0.19298E+00,-0.25472E+00,-0.29692E+00,-0.32958E+00,&
     -0.35641E+00,-0.37928E+00,-0.39926E+00,-0.41702E+00,-0.43303E+00,&
     -0.44762E+00,-0.46103E+00,-0.47344E+00,-0.48500E+00,-0.49582E+00,&
     -0.50599E+00,-0.51560E+00,-0.52470E+00,-0.53334E+00,-0.54158E+00,&
     -0.54945E+00,-0.55698E+00,-0.56420E+00,-0.57114E+00,-0.57782E+00,&
     -0.58426E+00,-0.59048E+00,-0.59649E+00,-0.60231E+00,-0.60795E+00,&
     -0.61341E+00,-0.61872E+00,-0.62388E+00,-0.62890E+00,-0.63378E+00,&
     -0.63854E+00,-0.64318E+00,-0.64771E+00,-0.65213E+00,-0.65644E+00,&
     -0.66066E+00,-0.66479E+00,-0.66882E+00,-0.67278E+00,-0.67665E+00,&
     -0.68044E+00,-0.68416E+00,-0.68780E+00,-0.69138E+00,-0.69489E+00,&
     -0.69834E+00,-0.70173E+00,-0.70505E+00,-0.70833E+00,-0.71154E+00,&
     -0.71471E+00,-0.71782E+00,-0.72089E+00,-0.72391E+00,-0.72688E+00,&
     -0.72981E+00,-0.73269E+00,-0.73554E+00,-0.73834E+00,-0.74111E+00,&
     -0.74384E+00,-0.74654E+00,-0.74920E+00,-0.75183E+00,-0.75442E+00,&
     -0.75698E+00,-0.75952E+00,-0.76202E+00,-0.76450E+00,-0.76695E+00,&
     -0.76937E+00,-0.77176E+00,-0.77414E+00,-0.77648E+00,-0.77881E+00,&
     -0.78111E+00,-0.78339E+00,-0.78564E+00,-0.78788E+00,-0.79010E+00,&
     -0.79229E+00,-0.79447E+00,-0.79663E+00,-0.79877E+00,-0.80090E+00,&
     -0.80300E+00,-0.80509E+00,-0.80717E+00,-0.80922E+00,-0.81127E+00,&
     -0.81329E+00,-0.81530E+00,-0.81730E+00,-0.81928E+00,-0.82125E+00/
                             
     DATA (BNC02M (IA),IA=101,200)/                                     &
     -0.82321E+00,-0.82515E+00,-0.82707E+00,-0.82899E+00,-0.83089E+00,&
     -0.83278E+00,-0.83466E+00,-0.83652E+00,-0.83837E+00,-0.84021E+00,&
     -0.84204E+00,-0.84386E+00,-0.84566E+00,-0.84746E+00,-0.84924E+00,&
     -0.85101E+00,-0.85277E+00,-0.85452E+00,-0.85626E+00,-0.85799E+00,&
     -0.85967E+00,-0.86138E+00,-0.86309E+00,-0.86478E+00,-0.86646E+00,&
     -0.86813E+00,-0.86980E+00,-0.87145E+00,-0.87309E+00,-0.87473E+00,&
     -0.87635E+00,-0.87797E+00,-0.87957E+00,-0.88117E+00,-0.88276E+00,&
     -0.88434E+00,-0.88591E+00,-0.88747E+00,-0.88902E+00,-0.89057E+00,&
     -0.89211E+00,-0.89364E+00,-0.89516E+00,-0.89667E+00,-0.89818E+00,&
     -0.89968E+00,-0.90117E+00,-0.90266E+00,-0.90413E+00,-0.90560E+00,&
     -0.90707E+00,-0.90852E+00,-0.90997E+00,-0.91141E+00,-0.91285E+00,&
     -0.91428E+00,-0.91570E+00,-0.91711E+00,-0.91852E+00,-0.91992E+00,&
     -0.92132E+00,-0.92271E+00,-0.92410E+00,-0.92547E+00,-0.92685E+00,&
     -0.92821E+00,-0.92957E+00,-0.93093E+00,-0.93228E+00,-0.93362E+00,&
     -0.93496E+00,-0.93629E+00,-0.93761E+00,-0.93894E+00,-0.94025E+00,&
     -0.94156E+00,-0.94287E+00,-0.94417E+00,-0.94546E+00,-0.94675E+00,&
     -0.94804E+00,-0.94932E+00,-0.95059E+00,-0.95186E+00,-0.95313E+00,&
     -0.95439E+00,-0.95565E+00,-0.95690E+00,-0.95815E+00,-0.95939E+00,&
     -0.96063E+00,-0.96186E+00,-0.96309E+00,-0.96431E+00,-0.96553E+00,&
     -0.96675E+00,-0.96796E+00,-0.96917E+00,-0.97037E+00,-0.97157E+00/
                             
     DATA (BNC02M (IA),IA=201,300)/                                     &
     -0.97277E+00,-0.97396E+00,-0.97514E+00,-0.97633E+00,-0.97751E+00,&
     -0.97868E+00,-0.97985E+00,-0.98102E+00,-0.98218E+00,-0.98334E+00,&
     -0.98450E+00,-0.98565E+00,-0.98680E+00,-0.98795E+00,-0.98909E+00,&
     -0.99023E+00,-0.99136E+00,-0.99249E+00,-0.99362E+00,-0.99474E+00,&
     -0.99586E+00,-0.99698E+00,-0.99809E+00,-0.99920E+00,-0.10003E+01,&
     -0.10014E+01,-0.10025E+01,-0.10036E+01,-0.10047E+01,-0.10058E+01,&
     -0.10069E+01,-0.10080E+01,-0.10091E+01,-0.10101E+01,-0.10112E+01,&
     -0.10123E+01,-0.10133E+01,-0.10144E+01,-0.10155E+01,-0.10165E+01,&
     -0.10176E+01,-0.10187E+01,-0.10197E+01,-0.10208E+01,-0.10218E+01,&
     -0.10228E+01,-0.10239E+01,-0.10249E+01,-0.10260E+01,-0.10270E+01,&
     -0.10280E+01,-0.10291E+01,-0.10301E+01,-0.10311E+01,-0.10321E+01,&
     -0.10331E+01,-0.10341E+01,-0.10352E+01,-0.10362E+01,-0.10372E+01,&
     -0.10382E+01,-0.10392E+01,-0.10402E+01,-0.10412E+01,-0.10422E+01,&
     -0.10432E+01,-0.10442E+01,-0.10451E+01,-0.10461E+01,-0.10471E+01,&
     -0.10481E+01,-0.10491E+01,-0.10500E+01,-0.10510E+01,-0.10520E+01,&
     -0.10530E+01,-0.10539E+01,-0.10549E+01,-0.10559E+01,-0.10568E+01,&
     -0.10578E+01,-0.10587E+01,-0.10597E+01,-0.10606E+01,-0.10616E+01,&
     -0.10625E+01,-0.10635E+01,-0.10644E+01,-0.10654E+01,-0.10663E+01,&
     -0.10672E+01,-0.10682E+01,-0.10691E+01,-0.10700E+01,-0.10710E+01,&
     -0.10719E+01,-0.10728E+01,-0.10737E+01,-0.10747E+01,-0.10756E+01/
                             
     DATA (BNC02M (IA),IA=301,400)/                                     &
     -0.10765E+01,-0.10774E+01,-0.10783E+01,-0.10792E+01,-0.10801E+01,&
     -0.10811E+01,-0.10820E+01,-0.10829E+01,-0.10838E+01,-0.10847E+01,&
     -0.10856E+01,-0.10865E+01,-0.10874E+01,-0.10883E+01,-0.10891E+01,&
     -0.10900E+01,-0.10909E+01,-0.10918E+01,-0.10927E+01,-0.10936E+01,&
     -0.10945E+01,-0.10953E+01,-0.10962E+01,-0.10971E+01,-0.10980E+01,&
     -0.10988E+01,-0.10997E+01,-0.11006E+01,-0.11015E+01,-0.11023E+01,&
     -0.11032E+01,-0.11040E+01,-0.11049E+01,-0.11058E+01,-0.11066E+01,&
     -0.11075E+01,-0.11083E+01,-0.11092E+01,-0.11101E+01,-0.11109E+01,&
     -0.11118E+01,-0.11126E+01,-0.11134E+01,-0.11143E+01,-0.11151E+01,&
     -0.11160E+01,-0.11168E+01,-0.11177E+01,-0.11185E+01,-0.11193E+01,&
     -0.11202E+01,-0.11210E+01,-0.11218E+01,-0.11227E+01,-0.11235E+01,&
     -0.11243E+01,-0.11252E+01,-0.11260E+01,-0.11268E+01,-0.11276E+01,&
     -0.11284E+01,-0.11293E+01,-0.11301E+01,-0.11309E+01,-0.11317E+01,&
     -0.11325E+01,-0.11333E+01,-0.11342E+01,-0.11350E+01,-0.11358E+01,&
     -0.11366E+01,-0.11374E+01,-0.11382E+01,-0.11390E+01,-0.11398E+01,&
     -0.11406E+01,-0.11414E+01,-0.11422E+01,-0.11430E+01,-0.11438E+01,&
     -0.11446E+01,-0.11454E+01,-0.11462E+01,-0.11470E+01,-0.11478E+01,&
     -0.11486E+01,-0.11493E+01,-0.11501E+01,-0.11509E+01,-0.11517E+01,&
     -0.11525E+01,-0.11533E+01,-0.11541E+01,-0.11548E+01,-0.11556E+01,&
     -0.11564E+01,-0.11572E+01,-0.11579E+01,-0.11587E+01,-0.11595E+01/
                             
     DATA (BNC02M (IA),IA=401,500)/                                     &
     -0.11603E+01,-0.11610E+01,-0.11618E+01,-0.11626E+01,-0.11633E+01,&
     -0.11641E+01,-0.11649E+01,-0.11656E+01,-0.11664E+01,-0.11672E+01,&
     -0.11679E+01,-0.11687E+01,-0.11694E+01,-0.11702E+01,-0.11710E+01,&
     -0.11717E+01,-0.11725E+01,-0.11732E+01,-0.11740E+01,-0.11747E+01,&
     -0.11755E+01,-0.11762E+01,-0.11770E+01,-0.11777E+01,-0.11785E+01,&
     -0.11792E+01,-0.11800E+01,-0.11807E+01,-0.11815E+01,-0.11822E+01,&
     -0.11829E+01,-0.11837E+01,-0.11844E+01,-0.11852E+01,-0.11859E+01,&
     -0.11866E+01,-0.11874E+01,-0.11881E+01,-0.11888E+01,-0.11896E+01,&
     -0.11903E+01,-0.11910E+01,-0.11918E+01,-0.11925E+01,-0.11932E+01,&
     -0.11940E+01,-0.11947E+01,-0.11954E+01,-0.11961E+01,-0.11969E+01,&
     -0.11976E+01,-0.11983E+01,-0.11990E+01,-0.11997E+01,-0.12005E+01,&
     -0.12012E+01,-0.12019E+01,-0.12026E+01,-0.12033E+01,-0.12040E+01,&
     -0.12048E+01,-0.12055E+01,-0.12062E+01,-0.12069E+01,-0.12076E+01,&
     -0.12083E+01,-0.12090E+01,-0.12097E+01,-0.12104E+01,-0.12111E+01,&
     -0.12118E+01,-0.12126E+01,-0.12133E+01,-0.12140E+01,-0.12147E+01,&
     -0.12154E+01,-0.12161E+01,-0.12168E+01,-0.12175E+01,-0.12182E+01,&
     -0.12189E+01,-0.12196E+01,-0.12203E+01,-0.12209E+01,-0.12216E+01,&
     -0.12223E+01,-0.12230E+01,-0.12237E+01,-0.12244E+01,-0.12251E+01,&
     -0.12258E+01,-0.12265E+01,-0.12272E+01,-0.12279E+01,-0.12285E+01,&
     -0.12292E+01,-0.12299E+01,-0.12306E+01,-0.12313E+01,-0.12320E+01/
                             
     DATA (BNC02M (IA),IA=501,600)/                                     &
     -0.12327E+01,-0.12333E+01,-0.12340E+01,-0.12347E+01,-0.12354E+01,&
     -0.12361E+01,-0.12367E+01,-0.12374E+01,-0.12381E+01,-0.12388E+01,&
     -0.12394E+01,-0.12401E+01,-0.12408E+01,-0.12415E+01,-0.12421E+01,&
     -0.12428E+01,-0.12435E+01,-0.12441E+01,-0.12448E+01,-0.12455E+01,&
     -0.12462E+01,-0.12468E+01,-0.12475E+01,-0.12482E+01,-0.12488E+01,&
     -0.12495E+01,-0.12501E+01,-0.12508E+01,-0.12515E+01,-0.12521E+01,&
     -0.12528E+01,-0.12535E+01,-0.12541E+01,-0.12548E+01,-0.12554E+01,&
     -0.12561E+01,-0.12568E+01,-0.12574E+01,-0.12581E+01,-0.12587E+01,&
     -0.12594E+01,-0.12600E+01,-0.12607E+01,-0.12613E+01,-0.12620E+01,&
     -0.12626E+01,-0.12633E+01,-0.12639E+01,-0.12646E+01,-0.12652E+01,&
     -0.12659E+01,-0.12665E+01,-0.12672E+01,-0.12678E+01,-0.12685E+01,&
     -0.12691E+01,-0.12698E+01,-0.12704E+01,-0.12711E+01,-0.12717E+01,&
     -0.12724E+01,-0.12730E+01,-0.12736E+01,-0.12743E+01,-0.12749E+01,&
     -0.12756E+01,-0.12762E+01,-0.12768E+01,-0.12775E+01,-0.12781E+01,&
     -0.12788E+01,-0.12794E+01,-0.12800E+01,-0.12807E+01,-0.12813E+01,&
     -0.12819E+01,-0.12826E+01,-0.12832E+01,-0.12838E+01,-0.12845E+01,&
     -0.12851E+01,-0.12857E+01,-0.12864E+01,-0.12870E+01,-0.12876E+01,&
     -0.12882E+01,-0.12889E+01,-0.12895E+01,-0.12901E+01,-0.12908E+01,&
     -0.12914E+01,-0.12920E+01,-0.12926E+01,-0.12933E+01,-0.12939E+01,&
     -0.12945E+01,-0.12951E+01,-0.12957E+01,-0.12964E+01,-0.12987E+01/
                             
     DATA (BNC02M (IA),IA=601,700)/                                     &
     -0.13038E+01,-0.13099E+01,-0.13160E+01,-0.13220E+01,-0.13280E+01,&
     -0.13340E+01,-0.13399E+01,-0.13457E+01,-0.13515E+01,-0.13573E+01,&
     -0.13631E+01,-0.13688E+01,-0.13744E+01,-0.13801E+01,-0.13856E+01,&
     -0.13912E+01,-0.13967E+01,-0.14022E+01,-0.14077E+01,-0.14131E+01,&
     -0.14185E+01,-0.14239E+01,-0.14292E+01,-0.14345E+01,-0.14398E+01,&
     -0.14451E+01,-0.14503E+01,-0.14555E+01,-0.14607E+01,-0.14659E+01,&
     -0.14710E+01,-0.14761E+01,-0.14812E+01,-0.14862E+01,-0.14913E+01,&
     -0.14963E+01,-0.15013E+01,-0.15063E+01,-0.15112E+01,-0.15161E+01,&
     -0.15211E+01,-0.15260E+01,-0.15308E+01,-0.15357E+01,-0.15405E+01,&
     -0.15453E+01,-0.15501E+01,-0.15549E+01,-0.15597E+01,-0.15644E+01,&
     -0.15692E+01,-0.15739E+01,-0.15786E+01,-0.15833E+01,-0.15880E+01,&
     -0.15926E+01,-0.15972E+01,-0.16019E+01,-0.16065E+01,-0.16111E+01,&
     -0.16157E+01,-0.16202E+01,-0.16248E+01,-0.16293E+01,-0.16338E+01,&
     -0.16384E+01,-0.16429E+01,-0.16473E+01,-0.16518E+01,-0.16563E+01,&
     -0.16607E+01,-0.16652E+01,-0.16696E+01,-0.16740E+01,-0.16784E+01,&
     -0.16828E+01,-0.16872E+01,-0.16915E+01,-0.16959E+01,-0.17003E+01,&
     -0.17046E+01,-0.17089E+01,-0.17132E+01,-0.17175E+01,-0.17218E+01,&
     -0.17261E+01,-0.17304E+01,-0.17347E+01,-0.17389E+01,-0.17432E+01,&
     -0.17474E+01,-0.17516E+01,-0.17559E+01,-0.17601E+01,-0.17643E+01,&
     -0.17685E+01,-0.17726E+01,-0.17768E+01,-0.17810E+01,-0.17851E+01/
                             
     DATA (BNC02M(IA),IA=701,741)/                                      &
     -0.17893E+01,-0.17934E+01,-0.17976E+01,-0.18017E+01,-0.18058E+01,&
     -0.18099E+01,-0.18140E+01,-0.18181E+01,-0.18222E+01,-0.18263E+01,&
     -0.18304E+01,-0.18344E+01,-0.18385E+01,-0.18425E+01,-0.18466E+01,&
     -0.18506E+01,-0.18547E+01,-0.18587E+01,-0.18627E+01,-0.18667E+01,&
     -0.18707E+01,-0.18747E+01,-0.18787E+01,-0.18827E+01,-0.18866E+01,&
     -0.18906E+01,-0.18946E+01,-0.18985E+01,-0.19025E+01,-0.19064E+01,&
     -0.19104E+01,-0.19143E+01,-0.19182E+01,-0.19222E+01,-0.19261E+01,&
     -0.19300E+01,-0.19339E+01,-0.19378E+01,-0.19417E+01,-0.19456E+01,&
     -0.19495E+01                  /                      
!                            
!  ** NaNO3                  
!                            
     DATA (BNC03M (IA),IA=  1,100)/                                     &
     -0.53018E-01,-0.97087E-01,-0.12849E+00,-0.15010E+00,-0.16692E+00,&
     -0.18081E+00,-0.19271E+00,-0.20315E+00,-0.21248E+00,-0.22092E+00,&
     -0.22865E+00,-0.23578E+00,-0.24240E+00,-0.24860E+00,-0.25441E+00,&
     -0.25991E+00,-0.26511E+00,-0.27005E+00,-0.27476E+00,-0.27927E+00,&
     -0.28358E+00,-0.28773E+00,-0.29171E+00,-0.29555E+00,-0.29926E+00,&
     -0.30284E+00,-0.30631E+00,-0.30967E+00,-0.31293E+00,-0.31609E+00,&
     -0.31917E+00,-0.32216E+00,-0.32508E+00,-0.32792E+00,-0.33069E+00,&
     -0.33340E+00,-0.33604E+00,-0.33862E+00,-0.34115E+00,-0.34361E+00,&
     -0.34603E+00,-0.34840E+00,-0.35072E+00,-0.35299E+00,-0.35522E+00,&
     -0.35741E+00,-0.35956E+00,-0.36167E+00,-0.36374E+00,-0.36578E+00,&
     -0.36778E+00,-0.36974E+00,-0.37168E+00,-0.37358E+00,-0.37546E+00,&
     -0.37730E+00,-0.37912E+00,-0.38091E+00,-0.38268E+00,-0.38442E+00,&
     -0.38613E+00,-0.38783E+00,-0.38950E+00,-0.39115E+00,-0.39278E+00,&
     -0.39439E+00,-0.39597E+00,-0.39754E+00,-0.39910E+00,-0.40063E+00,&
     -0.40215E+00,-0.40365E+00,-0.40514E+00,-0.40661E+00,-0.40807E+00,&
     -0.40951E+00,-0.41094E+00,-0.41236E+00,-0.41376E+00,-0.41515E+00,&
     -0.41653E+00,-0.41790E+00,-0.41926E+00,-0.42061E+00,-0.42194E+00,&
     -0.42327E+00,-0.42459E+00,-0.42590E+00,-0.42720E+00,-0.42849E+00,&
     -0.42977E+00,-0.43104E+00,-0.43231E+00,-0.43356E+00,-0.43481E+00,&
     -0.43605E+00,-0.43729E+00,-0.43852E+00,-0.43974E+00,-0.44095E+00/
                             
     DATA (BNC03M (IA),IA=101,200)/                                     &
     -0.44215E+00,-0.44335E+00,-0.44455E+00,-0.44573E+00,-0.44691E+00,&
     -0.44808E+00,-0.44925E+00,-0.45041E+00,-0.45156E+00,-0.45271E+00,&
     -0.45385E+00,-0.45499E+00,-0.45611E+00,-0.45724E+00,-0.45836E+00,&
     -0.45947E+00,-0.46057E+00,-0.46167E+00,-0.46277E+00,-0.46385E+00,&
     -0.46489E+00,-0.46597E+00,-0.46705E+00,-0.46812E+00,-0.46918E+00,&
     -0.47024E+00,-0.47129E+00,-0.47234E+00,-0.47338E+00,-0.47442E+00,&
     -0.47545E+00,-0.47647E+00,-0.47749E+00,-0.47850E+00,-0.47951E+00,&
     -0.48052E+00,-0.48152E+00,-0.48251E+00,-0.48350E+00,-0.48448E+00,&
     -0.48546E+00,-0.48644E+00,-0.48741E+00,-0.48837E+00,-0.48934E+00,&
     -0.49029E+00,-0.49124E+00,-0.49219E+00,-0.49313E+00,-0.49407E+00,&
     -0.49501E+00,-0.49594E+00,-0.49687E+00,-0.49779E+00,-0.49871E+00,&
     -0.49962E+00,-0.50053E+00,-0.50144E+00,-0.50234E+00,-0.50324E+00,&
     -0.50414E+00,-0.50503E+00,-0.50592E+00,-0.50680E+00,-0.50768E+00,&
     -0.50856E+00,-0.50943E+00,-0.51030E+00,-0.51117E+00,-0.51203E+00,&
     -0.51289E+00,-0.51375E+00,-0.51460E+00,-0.51545E+00,-0.51630E+00,&
     -0.51714E+00,-0.51798E+00,-0.51882E+00,-0.51965E+00,-0.52048E+00,&
     -0.52131E+00,-0.52213E+00,-0.52295E+00,-0.52377E+00,-0.52459E+00,&
     -0.52540E+00,-0.52621E+00,-0.52702E+00,-0.52782E+00,-0.52862E+00,&
     -0.52942E+00,-0.53022E+00,-0.53101E+00,-0.53180E+00,-0.53259E+00,&
     -0.53337E+00,-0.53416E+00,-0.53493E+00,-0.53571E+00,-0.53649E+00/
                             
     DATA (BNC03M (IA),IA=201,300)/                                     &
     -0.53726E+00,-0.53803E+00,-0.53879E+00,-0.53956E+00,-0.54032E+00,&
     -0.54108E+00,-0.54184E+00,-0.54259E+00,-0.54334E+00,-0.54409E+00,&
     -0.54484E+00,-0.54559E+00,-0.54633E+00,-0.54707E+00,-0.54781E+00,&
     -0.54854E+00,-0.54928E+00,-0.55001E+00,-0.55074E+00,-0.55147E+00,&
     -0.55219E+00,-0.55291E+00,-0.55363E+00,-0.55435E+00,-0.55507E+00,&
     -0.55578E+00,-0.55650E+00,-0.55721E+00,-0.55791E+00,-0.55862E+00,&
     -0.55932E+00,-0.56003E+00,-0.56073E+00,-0.56142E+00,-0.56212E+00,&
     -0.56282E+00,-0.56351E+00,-0.56420E+00,-0.56489E+00,-0.56557E+00,&
     -0.56626E+00,-0.56694E+00,-0.56762E+00,-0.56830E+00,-0.56898E+00,&
     -0.56966E+00,-0.57033E+00,-0.57100E+00,-0.57167E+00,-0.57234E+00,&
     -0.57301E+00,-0.57367E+00,-0.57434E+00,-0.57500E+00,-0.57566E+00,&
     -0.57632E+00,-0.57697E+00,-0.57763E+00,-0.57828E+00,-0.57893E+00,&
     -0.57958E+00,-0.58023E+00,-0.58088E+00,-0.58153E+00,-0.58217E+00,&
     -0.58281E+00,-0.58345E+00,-0.58409E+00,-0.58473E+00,-0.58537E+00,&
     -0.58600E+00,-0.58663E+00,-0.58726E+00,-0.58789E+00,-0.58852E+00,&
     -0.58915E+00,-0.58978E+00,-0.59040E+00,-0.59102E+00,-0.59164E+00,&
     -0.59226E+00,-0.59288E+00,-0.59350E+00,-0.59411E+00,-0.59473E+00,&
     -0.59534E+00,-0.59595E+00,-0.59656E+00,-0.59717E+00,-0.59778E+00,&
     -0.59838E+00,-0.59899E+00,-0.59959E+00,-0.60019E+00,-0.60079E+00,&
     -0.60139E+00,-0.60199E+00,-0.60259E+00,-0.60318E+00,-0.60378E+00/
                             
     DATA (BNC03M (IA),IA=301,400)/                                     &
     -0.60437E+00,-0.60496E+00,-0.60555E+00,-0.60614E+00,-0.60673E+00,&
     -0.60732E+00,-0.60790E+00,-0.60849E+00,-0.60907E+00,-0.60965E+00,&
     -0.61023E+00,-0.61081E+00,-0.61139E+00,-0.61197E+00,-0.61254E+00,&
     -0.61312E+00,-0.61369E+00,-0.61426E+00,-0.61484E+00,-0.61541E+00,&
     -0.61597E+00,-0.61654E+00,-0.61711E+00,-0.61767E+00,-0.61824E+00,&
     -0.61880E+00,-0.61936E+00,-0.61993E+00,-0.62049E+00,-0.62104E+00,&
     -0.62160E+00,-0.62216E+00,-0.62272E+00,-0.62327E+00,-0.62382E+00,&
     -0.62438E+00,-0.62493E+00,-0.62548E+00,-0.62603E+00,-0.62658E+00,&
     -0.62712E+00,-0.62767E+00,-0.62822E+00,-0.62876E+00,-0.62930E+00,&
     -0.62985E+00,-0.63039E+00,-0.63093E+00,-0.63147E+00,-0.63201E+00,&
     -0.63254E+00,-0.63308E+00,-0.63362E+00,-0.63415E+00,-0.63468E+00,&
     -0.63522E+00,-0.63575E+00,-0.63628E+00,-0.63681E+00,-0.63734E+00,&
     -0.63787E+00,-0.63839E+00,-0.63892E+00,-0.63945E+00,-0.63997E+00,&
     -0.64049E+00,-0.64102E+00,-0.64154E+00,-0.64206E+00,-0.64258E+00,&
     -0.64310E+00,-0.64362E+00,-0.64413E+00,-0.64465E+00,-0.64516E+00,&
     -0.64568E+00,-0.64619E+00,-0.64671E+00,-0.64722E+00,-0.64773E+00,&
     -0.64824E+00,-0.64875E+00,-0.64926E+00,-0.64977E+00,-0.65027E+00,&
     -0.65078E+00,-0.65129E+00,-0.65179E+00,-0.65229E+00,-0.65280E+00,&
     -0.65330E+00,-0.65380E+00,-0.65430E+00,-0.65480E+00,-0.65530E+00,&
     -0.65580E+00,-0.65630E+00,-0.65679E+00,-0.65729E+00,-0.65778E+00/
                             
     DATA (BNC03M (IA),IA=401,500)/                                     &
     -0.65828E+00,-0.65877E+00,-0.65926E+00,-0.65976E+00,-0.66025E+00,&
     -0.66074E+00,-0.66123E+00,-0.66172E+00,-0.66221E+00,-0.66269E+00,&
     -0.66318E+00,-0.66367E+00,-0.66415E+00,-0.66464E+00,-0.66512E+00,&
     -0.66560E+00,-0.66609E+00,-0.66657E+00,-0.66705E+00,-0.66753E+00,&
     -0.66801E+00,-0.66849E+00,-0.66897E+00,-0.66944E+00,-0.66992E+00,&
     -0.67040E+00,-0.67087E+00,-0.67135E+00,-0.67182E+00,-0.67229E+00,&
     -0.67277E+00,-0.67324E+00,-0.67371E+00,-0.67418E+00,-0.67465E+00,&
     -0.67512E+00,-0.67559E+00,-0.67606E+00,-0.67652E+00,-0.67699E+00,&
     -0.67746E+00,-0.67792E+00,-0.67839E+00,-0.67885E+00,-0.67931E+00,&
     -0.67978E+00,-0.68024E+00,-0.68070E+00,-0.68116E+00,-0.68162E+00,&
     -0.68208E+00,-0.68254E+00,-0.68300E+00,-0.68346E+00,-0.68391E+00,&
     -0.68437E+00,-0.68483E+00,-0.68528E+00,-0.68574E+00,-0.68619E+00,&
     -0.68664E+00,-0.68710E+00,-0.68755E+00,-0.68800E+00,-0.68845E+00,&
     -0.68890E+00,-0.68935E+00,-0.68980E+00,-0.69025E+00,-0.69070E+00,&
     -0.69115E+00,-0.69159E+00,-0.69204E+00,-0.69249E+00,-0.69293E+00,&
     -0.69338E+00,-0.69382E+00,-0.69426E+00,-0.69471E+00,-0.69515E+00,&
     -0.69559E+00,-0.69603E+00,-0.69647E+00,-0.69691E+00,-0.69735E+00,&
     -0.69779E+00,-0.69823E+00,-0.69867E+00,-0.69911E+00,-0.69954E+00,&
     -0.69998E+00,-0.70042E+00,-0.70085E+00,-0.70129E+00,-0.70172E+00,&
     -0.70216E+00,-0.70259E+00,-0.70302E+00,-0.70345E+00,-0.70389E+00/
                             
     DATA (BNC03M (IA),IA=501,600)/                                     &
     -0.70432E+00,-0.70475E+00,-0.70518E+00,-0.70561E+00,-0.70604E+00,&
     -0.70646E+00,-0.70689E+00,-0.70732E+00,-0.70775E+00,-0.70817E+00,&
     -0.70860E+00,-0.70903E+00,-0.70945E+00,-0.70987E+00,-0.71030E+00,&
     -0.71072E+00,-0.71115E+00,-0.71157E+00,-0.71199E+00,-0.71241E+00,&
     -0.71283E+00,-0.71325E+00,-0.71367E+00,-0.71409E+00,-0.71451E+00,&
     -0.71493E+00,-0.71535E+00,-0.71577E+00,-0.71618E+00,-0.71660E+00,&
     -0.71702E+00,-0.71743E+00,-0.71785E+00,-0.71826E+00,-0.71868E+00,&
     -0.71909E+00,-0.71951E+00,-0.71992E+00,-0.72033E+00,-0.72074E+00,&
     -0.72116E+00,-0.72157E+00,-0.72198E+00,-0.72239E+00,-0.72280E+00,&
     -0.72321E+00,-0.72362E+00,-0.72403E+00,-0.72443E+00,-0.72484E+00,&
     -0.72525E+00,-0.72566E+00,-0.72606E+00,-0.72647E+00,-0.72687E+00,&
     -0.72728E+00,-0.72768E+00,-0.72809E+00,-0.72849E+00,-0.72890E+00,&
     -0.72930E+00,-0.72970E+00,-0.73010E+00,-0.73050E+00,-0.73091E+00,&
     -0.73131E+00,-0.73171E+00,-0.73211E+00,-0.73251E+00,-0.73291E+00,&
     -0.73330E+00,-0.73370E+00,-0.73410E+00,-0.73450E+00,-0.73490E+00,&
     -0.73529E+00,-0.73569E+00,-0.73609E+00,-0.73648E+00,-0.73688E+00,&
     -0.73727E+00,-0.73766E+00,-0.73806E+00,-0.73845E+00,-0.73885E+00,&
     -0.73924E+00,-0.73963E+00,-0.74002E+00,-0.74041E+00,-0.74081E+00,&
     -0.74120E+00,-0.74159E+00,-0.74198E+00,-0.74237E+00,-0.74276E+00,&
     -0.74314E+00,-0.74353E+00,-0.74392E+00,-0.74431E+00,-0.74576E+00/
                             
     DATA (BNC03M (IA),IA=601,700)/                                     &
     -0.74893E+00,-0.75275E+00,-0.75652E+00,-0.76027E+00,-0.76398E+00,&
     -0.76765E+00,-0.77130E+00,-0.77492E+00,-0.77850E+00,-0.78206E+00,&
     -0.78558E+00,-0.78908E+00,-0.79256E+00,-0.79600E+00,-0.79942E+00,&
     -0.80282E+00,-0.80619E+00,-0.80954E+00,-0.81286E+00,-0.81616E+00,&
     -0.81944E+00,-0.82270E+00,-0.82594E+00,-0.82915E+00,-0.83235E+00,&
     -0.83552E+00,-0.83868E+00,-0.84181E+00,-0.84493E+00,-0.84803E+00,&
     -0.85111E+00,-0.85417E+00,-0.85722E+00,-0.86025E+00,-0.86326E+00,&
     -0.86626E+00,-0.86924E+00,-0.87221E+00,-0.87515E+00,-0.87809E+00,&
     -0.88101E+00,-0.88391E+00,-0.88681E+00,-0.88968E+00,-0.89255E+00,&
     -0.89540E+00,-0.89823E+00,-0.90106E+00,-0.90387E+00,-0.90666E+00,&
     -0.90945E+00,-0.91222E+00,-0.91499E+00,-0.91773E+00,-0.92047E+00,&
     -0.92320E+00,-0.92592E+00,-0.92862E+00,-0.93131E+00,-0.93400E+00,&
     -0.93667E+00,-0.93933E+00,-0.94198E+00,-0.94462E+00,-0.94726E+00,&
     -0.94988E+00,-0.95249E+00,-0.95509E+00,-0.95769E+00,-0.96027E+00,&
     -0.96285E+00,-0.96541E+00,-0.96797E+00,-0.97052E+00,-0.97306E+00,&
     -0.97559E+00,-0.97812E+00,-0.98063E+00,-0.98314E+00,-0.98564E+00,&
     -0.98813E+00,-0.99062E+00,-0.99309E+00,-0.99556E+00,-0.99802E+00,&
     -0.10005E+01,-0.10029E+01,-0.10054E+01,-0.10078E+01,-0.10102E+01,&
     -0.10126E+01,-0.10150E+01,-0.10175E+01,-0.10198E+01,-0.10222E+01,&
     -0.10246E+01,-0.10270E+01,-0.10294E+01,-0.10317E+01,-0.10341E+01/
                             
     DATA (BNC03M(IA),IA=701,741)/                                      &
     -0.10365E+01,-0.10388E+01,-0.10411E+01,-0.10435E+01,-0.10458E+01,&
     -0.10481E+01,-0.10505E+01,-0.10528E+01,-0.10551E+01,-0.10574E+01,&
     -0.10597E+01,-0.10620E+01,-0.10642E+01,-0.10665E+01,-0.10688E+01,&
     -0.10711E+01,-0.10733E+01,-0.10756E+01,-0.10778E+01,-0.10801E+01,&
     -0.10823E+01,-0.10846E+01,-0.10868E+01,-0.10890E+01,-0.10913E+01,&
     -0.10935E+01,-0.10957E+01,-0.10979E+01,-0.11001E+01,-0.11023E+01,&
     -0.11045E+01,-0.11067E+01,-0.11089E+01,-0.11111E+01,-0.11133E+01,&
     -0.11154E+01,-0.11176E+01,-0.11198E+01,-0.11219E+01,-0.11241E+01,&
     -0.11263E+01                  /                      
!                            
!  ** (NH4)2SO4              
!                            
     DATA (BNC04M (IA),IA=  1,100)/                                     &
     -0.10581E+00,-0.19334E+00,-0.25539E+00,-0.29790E+00,-0.33085E+00,&
     -0.35796E+00,-0.38111E+00,-0.40135E+00,-0.41938E+00,-0.43565E+00,&
     -0.45050E+00,-0.46416E+00,-0.47682E+00,-0.48862E+00,-0.49969E+00,&
     -0.51010E+00,-0.51994E+00,-0.52928E+00,-0.53815E+00,-0.54662E+00,&
     -0.55471E+00,-0.56247E+00,-0.56992E+00,-0.57708E+00,-0.58397E+00,&
     -0.59063E+00,-0.59706E+00,-0.60328E+00,-0.60931E+00,-0.61515E+00,&
     -0.62082E+00,-0.62634E+00,-0.63169E+00,-0.63691E+00,-0.64199E+00,&
     -0.64694E+00,-0.65178E+00,-0.65649E+00,-0.66110E+00,-0.66560E+00,&
     -0.67000E+00,-0.67431E+00,-0.67853E+00,-0.68266E+00,-0.68670E+00,&
     -0.69067E+00,-0.69456E+00,-0.69838E+00,-0.70212E+00,-0.70580E+00,&
     -0.70942E+00,-0.71297E+00,-0.71646E+00,-0.71989E+00,-0.72326E+00,&
     -0.72659E+00,-0.72986E+00,-0.73308E+00,-0.73625E+00,-0.73937E+00,&
     -0.74245E+00,-0.74549E+00,-0.74848E+00,-0.75143E+00,-0.75435E+00,&
     -0.75722E+00,-0.76006E+00,-0.76287E+00,-0.76564E+00,-0.76837E+00,&
     -0.77108E+00,-0.77375E+00,-0.77640E+00,-0.77901E+00,-0.78160E+00,&
     -0.78416E+00,-0.78670E+00,-0.78921E+00,-0.79169E+00,-0.79415E+00,&
     -0.79659E+00,-0.79901E+00,-0.80140E+00,-0.80378E+00,-0.80613E+00,&
     -0.80847E+00,-0.81078E+00,-0.81308E+00,-0.81536E+00,-0.81762E+00,&
     -0.81986E+00,-0.82209E+00,-0.82430E+00,-0.82649E+00,-0.82867E+00,&
     -0.83083E+00,-0.83298E+00,-0.83512E+00,-0.83724E+00,-0.83934E+00/
                             
     DATA (BNC04M (IA),IA=101,200)/                                     &
     -0.84143E+00,-0.84351E+00,-0.84558E+00,-0.84763E+00,-0.84967E+00,&
     -0.85169E+00,-0.85371E+00,-0.85571E+00,-0.85770E+00,-0.85967E+00,&
     -0.86164E+00,-0.86359E+00,-0.86553E+00,-0.86746E+00,-0.86938E+00,&
     -0.87129E+00,-0.87319E+00,-0.87507E+00,-0.87695E+00,-0.87881E+00,&
     -0.88061E+00,-0.88246E+00,-0.88430E+00,-0.88612E+00,-0.88794E+00,&
     -0.88975E+00,-0.89154E+00,-0.89333E+00,-0.89510E+00,-0.89687E+00,&
     -0.89862E+00,-0.90037E+00,-0.90211E+00,-0.90383E+00,-0.90555E+00,&
     -0.90726E+00,-0.90896E+00,-0.91065E+00,-0.91233E+00,-0.91401E+00,&
     -0.91567E+00,-0.91733E+00,-0.91897E+00,-0.92061E+00,-0.92225E+00,&
     -0.92387E+00,-0.92549E+00,-0.92710E+00,-0.92870E+00,-0.93029E+00,&
     -0.93188E+00,-0.93345E+00,-0.93502E+00,-0.93659E+00,-0.93814E+00,&
     -0.93969E+00,-0.94124E+00,-0.94277E+00,-0.94430E+00,-0.94582E+00,&
     -0.94734E+00,-0.94885E+00,-0.95035E+00,-0.95185E+00,-0.95334E+00,&
     -0.95482E+00,-0.95630E+00,-0.95777E+00,-0.95923E+00,-0.96069E+00,&
     -0.96215E+00,-0.96359E+00,-0.96504E+00,-0.96647E+00,-0.96790E+00,&
     -0.96933E+00,-0.97075E+00,-0.97216E+00,-0.97357E+00,-0.97497E+00,&
     -0.97637E+00,-0.97776E+00,-0.97915E+00,-0.98053E+00,-0.98190E+00,&
     -0.98327E+00,-0.98464E+00,-0.98600E+00,-0.98736E+00,-0.98871E+00,&
     -0.99006E+00,-0.99140E+00,-0.99274E+00,-0.99407E+00,-0.99540E+00,&
     -0.99672E+00,-0.99804E+00,-0.99935E+00,-0.10007E+01,-0.10020E+01/
                             
     DATA (BNC04M (IA),IA=201,300)/                                     &
     -0.10033E+01,-0.10046E+01,-0.10059E+01,-0.10071E+01,-0.10084E+01,&
     -0.10097E+01,-0.10110E+01,-0.10123E+01,-0.10135E+01,-0.10148E+01,&
     -0.10160E+01,-0.10173E+01,-0.10186E+01,-0.10198E+01,-0.10210E+01,&
     -0.10223E+01,-0.10235E+01,-0.10248E+01,-0.10260E+01,-0.10272E+01,&
     -0.10284E+01,-0.10296E+01,-0.10309E+01,-0.10321E+01,-0.10333E+01,&
     -0.10345E+01,-0.10357E+01,-0.10369E+01,-0.10381E+01,-0.10393E+01,&
     -0.10404E+01,-0.10416E+01,-0.10428E+01,-0.10440E+01,-0.10451E+01,&
     -0.10463E+01,-0.10475E+01,-0.10486E+01,-0.10498E+01,-0.10510E+01,&
     -0.10521E+01,-0.10533E+01,-0.10544E+01,-0.10556E+01,-0.10567E+01,&
     -0.10578E+01,-0.10590E+01,-0.10601E+01,-0.10612E+01,-0.10624E+01,&
     -0.10635E+01,-0.10646E+01,-0.10657E+01,-0.10668E+01,-0.10679E+01,&
     -0.10690E+01,-0.10702E+01,-0.10713E+01,-0.10724E+01,-0.10735E+01,&
     -0.10745E+01,-0.10756E+01,-0.10767E+01,-0.10778E+01,-0.10789E+01,&
     -0.10800E+01,-0.10811E+01,-0.10821E+01,-0.10832E+01,-0.10843E+01,&
     -0.10853E+01,-0.10864E+01,-0.10875E+01,-0.10885E+01,-0.10896E+01,&
     -0.10907E+01,-0.10917E+01,-0.10928E+01,-0.10938E+01,-0.10949E+01,&
     -0.10959E+01,-0.10969E+01,-0.10980E+01,-0.10990E+01,-0.11001E+01,&
     -0.11011E+01,-0.11021E+01,-0.11031E+01,-0.11042E+01,-0.11052E+01,&
     -0.11062E+01,-0.11072E+01,-0.11083E+01,-0.11093E+01,-0.11103E+01,&
     -0.11113E+01,-0.11123E+01,-0.11133E+01,-0.11143E+01,-0.11153E+01/
                             
     DATA (BNC04M (IA),IA=301,400)/                                     &
     -0.11163E+01,-0.11173E+01,-0.11183E+01,-0.11193E+01,-0.11203E+01,&
     -0.11213E+01,-0.11223E+01,-0.11232E+01,-0.11242E+01,-0.11252E+01,&
     -0.11262E+01,-0.11272E+01,-0.11281E+01,-0.11291E+01,-0.11301E+01,&
     -0.11311E+01,-0.11320E+01,-0.11330E+01,-0.11340E+01,-0.11349E+01,&
     -0.11359E+01,-0.11368E+01,-0.11378E+01,-0.11388E+01,-0.11397E+01,&
     -0.11407E+01,-0.11416E+01,-0.11426E+01,-0.11435E+01,-0.11444E+01,&
     -0.11454E+01,-0.11463E+01,-0.11473E+01,-0.11482E+01,-0.11491E+01,&
     -0.11501E+01,-0.11510E+01,-0.11519E+01,-0.11529E+01,-0.11538E+01,&
     -0.11547E+01,-0.11556E+01,-0.11566E+01,-0.11575E+01,-0.11584E+01,&
     -0.11593E+01,-0.11602E+01,-0.11612E+01,-0.11621E+01,-0.11630E+01,&
     -0.11639E+01,-0.11648E+01,-0.11657E+01,-0.11666E+01,-0.11675E+01,&
     -0.11684E+01,-0.11693E+01,-0.11702E+01,-0.11711E+01,-0.11720E+01,&
     -0.11729E+01,-0.11738E+01,-0.11747E+01,-0.11756E+01,-0.11764E+01,&
     -0.11773E+01,-0.11782E+01,-0.11791E+01,-0.11800E+01,-0.11809E+01,&
     -0.11817E+01,-0.11826E+01,-0.11835E+01,-0.11844E+01,-0.11852E+01,&
     -0.11861E+01,-0.11870E+01,-0.11879E+01,-0.11887E+01,-0.11896E+01,&
     -0.11905E+01,-0.11913E+01,-0.11922E+01,-0.11930E+01,-0.11939E+01,&
     -0.11948E+01,-0.11956E+01,-0.11965E+01,-0.11973E+01,-0.11982E+01,&
     -0.11990E+01,-0.11999E+01,-0.12007E+01,-0.12016E+01,-0.12024E+01,&
     -0.12033E+01,-0.12041E+01,-0.12050E+01,-0.12058E+01,-0.12067E+01/
                             
     DATA (BNC04M (IA),IA=401,500)/                                     &
     -0.12075E+01,-0.12083E+01,-0.12092E+01,-0.12100E+01,-0.12108E+01,&
     -0.12117E+01,-0.12125E+01,-0.12133E+01,-0.12142E+01,-0.12150E+01,&
     -0.12158E+01,-0.12166E+01,-0.12175E+01,-0.12183E+01,-0.12191E+01,&
     -0.12199E+01,-0.12208E+01,-0.12216E+01,-0.12224E+01,-0.12232E+01,&
     -0.12240E+01,-0.12248E+01,-0.12257E+01,-0.12265E+01,-0.12273E+01,&
     -0.12281E+01,-0.12289E+01,-0.12297E+01,-0.12305E+01,-0.12313E+01,&
     -0.12321E+01,-0.12329E+01,-0.12337E+01,-0.12345E+01,-0.12353E+01,&
     -0.12361E+01,-0.12369E+01,-0.12377E+01,-0.12385E+01,-0.12393E+01,&
     -0.12401E+01,-0.12409E+01,-0.12417E+01,-0.12425E+01,-0.12433E+01,&
     -0.12441E+01,-0.12449E+01,-0.12456E+01,-0.12464E+01,-0.12472E+01,&
     -0.12480E+01,-0.12488E+01,-0.12496E+01,-0.12503E+01,-0.12511E+01,&
     -0.12519E+01,-0.12527E+01,-0.12535E+01,-0.12542E+01,-0.12550E+01,&
     -0.12558E+01,-0.12566E+01,-0.12573E+01,-0.12581E+01,-0.12589E+01,&
     -0.12596E+01,-0.12604E+01,-0.12612E+01,-0.12619E+01,-0.12627E+01,&
     -0.12635E+01,-0.12642E+01,-0.12650E+01,-0.12658E+01,-0.12665E+01,&
     -0.12673E+01,-0.12680E+01,-0.12688E+01,-0.12696E+01,-0.12703E+01,&
     -0.12711E+01,-0.12718E+01,-0.12726E+01,-0.12733E+01,-0.12741E+01,&
     -0.12748E+01,-0.12756E+01,-0.12763E+01,-0.12771E+01,-0.12778E+01,&
     -0.12786E+01,-0.12793E+01,-0.12801E+01,-0.12808E+01,-0.12816E+01,&
     -0.12823E+01,-0.12830E+01,-0.12838E+01,-0.12845E+01,-0.12853E+01/
                             
     DATA (BNC04M (IA),IA=501,600)/                                     &
     -0.12860E+01,-0.12867E+01,-0.12875E+01,-0.12882E+01,-0.12890E+01,&
     -0.12897E+01,-0.12904E+01,-0.12912E+01,-0.12919E+01,-0.12926E+01,&
     -0.12933E+01,-0.12941E+01,-0.12948E+01,-0.12955E+01,-0.12963E+01,&
     -0.12970E+01,-0.12977E+01,-0.12984E+01,-0.12992E+01,-0.12999E+01,&
     -0.13006E+01,-0.13013E+01,-0.13021E+01,-0.13028E+01,-0.13035E+01,&
     -0.13042E+01,-0.13049E+01,-0.13057E+01,-0.13064E+01,-0.13071E+01,&
     -0.13078E+01,-0.13085E+01,-0.13092E+01,-0.13099E+01,-0.13107E+01,&
     -0.13114E+01,-0.13121E+01,-0.13128E+01,-0.13135E+01,-0.13142E+01,&
     -0.13149E+01,-0.13156E+01,-0.13163E+01,-0.13170E+01,-0.13177E+01,&
     -0.13184E+01,-0.13191E+01,-0.13198E+01,-0.13206E+01,-0.13213E+01,&
     -0.13220E+01,-0.13227E+01,-0.13234E+01,-0.13241E+01,-0.13248E+01,&
     -0.13254E+01,-0.13261E+01,-0.13268E+01,-0.13275E+01,-0.13282E+01,&
     -0.13289E+01,-0.13296E+01,-0.13303E+01,-0.13310E+01,-0.13317E+01,&
     -0.13324E+01,-0.13331E+01,-0.13338E+01,-0.13345E+01,-0.13351E+01,&
     -0.13358E+01,-0.13365E+01,-0.13372E+01,-0.13379E+01,-0.13386E+01,&
     -0.13393E+01,-0.13399E+01,-0.13406E+01,-0.13413E+01,-0.13420E+01,&
     -0.13427E+01,-0.13434E+01,-0.13440E+01,-0.13447E+01,-0.13454E+01,&
     -0.13461E+01,-0.13467E+01,-0.13474E+01,-0.13481E+01,-0.13488E+01,&
     -0.13495E+01,-0.13501E+01,-0.13508E+01,-0.13515E+01,-0.13521E+01,&
     -0.13528E+01,-0.13535E+01,-0.13542E+01,-0.13548E+01,-0.13573E+01/
                             
     DATA (BNC04M (IA),IA=601,700)/                                     &
     -0.13628E+01,-0.13694E+01,-0.13760E+01,-0.13825E+01,-0.13889E+01,&
     -0.13953E+01,-0.14016E+01,-0.14079E+01,-0.14142E+01,-0.14204E+01,&
     -0.14265E+01,-0.14327E+01,-0.14387E+01,-0.14448E+01,-0.14507E+01,&
     -0.14567E+01,-0.14626E+01,-0.14685E+01,-0.14743E+01,-0.14801E+01,&
     -0.14859E+01,-0.14916E+01,-0.14973E+01,-0.15030E+01,-0.15087E+01,&
     -0.15143E+01,-0.15198E+01,-0.15254E+01,-0.15309E+01,-0.15364E+01,&
     -0.15419E+01,-0.15473E+01,-0.15527E+01,-0.15581E+01,-0.15635E+01,&
     -0.15688E+01,-0.15741E+01,-0.15794E+01,-0.15846E+01,-0.15899E+01,&
     -0.15951E+01,-0.16003E+01,-0.16055E+01,-0.16106E+01,-0.16157E+01,&
     -0.16208E+01,-0.16259E+01,-0.16310E+01,-0.16360E+01,-0.16411E+01,&
     -0.16461E+01,-0.16511E+01,-0.16560E+01,-0.16610E+01,-0.16659E+01,&
     -0.16708E+01,-0.16757E+01,-0.16806E+01,-0.16855E+01,-0.16903E+01,&
     -0.16952E+01,-0.17000E+01,-0.17048E+01,-0.17096E+01,-0.17143E+01,&
     -0.17191E+01,-0.17238E+01,-0.17285E+01,-0.17333E+01,-0.17379E+01,&
     -0.17426E+01,-0.17473E+01,-0.17520E+01,-0.17566E+01,-0.17612E+01,&
     -0.17658E+01,-0.17704E+01,-0.17750E+01,-0.17796E+01,-0.17842E+01,&
     -0.17887E+01,-0.17933E+01,-0.17978E+01,-0.18023E+01,-0.18068E+01,&
     -0.18113E+01,-0.18158E+01,-0.18203E+01,-0.18247E+01,-0.18292E+01,&
     -0.18336E+01,-0.18380E+01,-0.18425E+01,-0.18469E+01,-0.18513E+01,&
     -0.18556E+01,-0.18600E+01,-0.18644E+01,-0.18687E+01,-0.18731E+01/
                             
     DATA (BNC04M(IA),IA=701,741)/                                      &
     -0.18774E+01,-0.18818E+01,-0.18861E+01,-0.18904E+01,-0.18947E+01,&
     -0.18990E+01,-0.19033E+01,-0.19075E+01,-0.19118E+01,-0.19161E+01,&
     -0.19203E+01,-0.19245E+01,-0.19288E+01,-0.19330E+01,-0.19372E+01,&
     -0.19414E+01,-0.19456E+01,-0.19498E+01,-0.19540E+01,-0.19582E+01,&
     -0.19623E+01,-0.19665E+01,-0.19707E+01,-0.19748E+01,-0.19789E+01,&
     -0.19831E+01,-0.19872E+01,-0.19913E+01,-0.19954E+01,-0.19995E+01,&
     -0.20036E+01,-0.20077E+01,-0.20118E+01,-0.20159E+01,-0.20199E+01,&
     -0.20240E+01,-0.20280E+01,-0.20321E+01,-0.20361E+01,-0.20402E+01,&
     -0.20442E+01                  /                      
!                            
!  ** NH4NO3                 
!                            
     DATA (BNC05M (IA),IA=  1,100)/                                     &
     -0.53657E-01,-0.99475E-01,-0.13304E+00,-0.15671E+00,-0.17551E+00,&
     -0.19133E+00,-0.20511E+00,-0.21739E+00,-0.22852E+00,-0.23874E+00,&
     -0.24821E+00,-0.25706E+00,-0.26538E+00,-0.27325E+00,-0.28072E+00,&
     -0.28785E+00,-0.29466E+00,-0.30120E+00,-0.30749E+00,-0.31356E+00,&
     -0.31941E+00,-0.32508E+00,-0.33057E+00,-0.33590E+00,-0.34108E+00,&
     -0.34612E+00,-0.35103E+00,-0.35582E+00,-0.36049E+00,-0.36505E+00,&
     -0.36951E+00,-0.37386E+00,-0.37813E+00,-0.38230E+00,-0.38639E+00,&
     -0.39040E+00,-0.39433E+00,-0.39818E+00,-0.40197E+00,-0.40568E+00,&
     -0.40933E+00,-0.41291E+00,-0.41643E+00,-0.41989E+00,-0.42330E+00,&
     -0.42664E+00,-0.42994E+00,-0.43318E+00,-0.43637E+00,-0.43952E+00,&
     -0.44261E+00,-0.44566E+00,-0.44867E+00,-0.45164E+00,-0.45456E+00,&
     -0.45744E+00,-0.46029E+00,-0.46310E+00,-0.46587E+00,-0.46861E+00,&
     -0.47132E+00,-0.47400E+00,-0.47664E+00,-0.47926E+00,-0.48184E+00,&
     -0.48440E+00,-0.48694E+00,-0.48945E+00,-0.49193E+00,-0.49440E+00,&
     -0.49684E+00,-0.49926E+00,-0.50166E+00,-0.50404E+00,-0.50640E+00,&
     -0.50875E+00,-0.51108E+00,-0.51339E+00,-0.51569E+00,-0.51797E+00,&
     -0.52024E+00,-0.52250E+00,-0.52474E+00,-0.52697E+00,-0.52919E+00,&
     -0.53140E+00,-0.53360E+00,-0.53579E+00,-0.53797E+00,-0.54014E+00,&
     -0.54229E+00,-0.54444E+00,-0.54659E+00,-0.54872E+00,-0.55084E+00,&
     -0.55296E+00,-0.55507E+00,-0.55717E+00,-0.55926E+00,-0.56135E+00/
                             
     DATA (BNC05M (IA),IA=101,200)/                                     &
     -0.56342E+00,-0.56549E+00,-0.56755E+00,-0.56961E+00,-0.57165E+00,&
     -0.57369E+00,-0.57572E+00,-0.57775E+00,-0.57976E+00,-0.58177E+00,&
     -0.58377E+00,-0.58576E+00,-0.58774E+00,-0.58972E+00,-0.59169E+00,&
     -0.59364E+00,-0.59560E+00,-0.59754E+00,-0.59947E+00,-0.60140E+00,&
     -0.60319E+00,-0.60512E+00,-0.60703E+00,-0.60894E+00,-0.61083E+00,&
     -0.61272E+00,-0.61459E+00,-0.61646E+00,-0.61832E+00,-0.62017E+00,&
     -0.62201E+00,-0.62384E+00,-0.62566E+00,-0.62748E+00,-0.62928E+00,&
     -0.63108E+00,-0.63287E+00,-0.63465E+00,-0.63642E+00,-0.63819E+00,&
     -0.63994E+00,-0.64169E+00,-0.64343E+00,-0.64516E+00,-0.64689E+00,&
     -0.64860E+00,-0.65031E+00,-0.65201E+00,-0.65371E+00,-0.65539E+00,&
     -0.65707E+00,-0.65875E+00,-0.66041E+00,-0.66207E+00,-0.66372E+00,&
     -0.66536E+00,-0.66700E+00,-0.66863E+00,-0.67025E+00,-0.67187E+00,&
     -0.67348E+00,-0.67508E+00,-0.67668E+00,-0.67827E+00,-0.67985E+00,&
     -0.68143E+00,-0.68300E+00,-0.68456E+00,-0.68612E+00,-0.68767E+00,&
     -0.68922E+00,-0.69076E+00,-0.69229E+00,-0.69382E+00,-0.69534E+00,&
     -0.69686E+00,-0.69837E+00,-0.69987E+00,-0.70137E+00,-0.70286E+00,&
     -0.70435E+00,-0.70583E+00,-0.70731E+00,-0.70878E+00,-0.71024E+00,&
     -0.71170E+00,-0.71316E+00,-0.71460E+00,-0.71605E+00,-0.71749E+00,&
     -0.71892E+00,-0.72035E+00,-0.72177E+00,-0.72319E+00,-0.72460E+00,&
     -0.72600E+00,-0.72741E+00,-0.72880E+00,-0.73020E+00,-0.73158E+00/
                             
     DATA (BNC05M (IA),IA=201,300)/                                     &
     -0.73297E+00,-0.73434E+00,-0.73572E+00,-0.73708E+00,-0.73845E+00,&
     -0.73980E+00,-0.74116E+00,-0.74251E+00,-0.74385E+00,-0.74519E+00,&
     -0.74653E+00,-0.74786E+00,-0.74918E+00,-0.75051E+00,-0.75182E+00,&
     -0.75314E+00,-0.75445E+00,-0.75575E+00,-0.75705E+00,-0.75835E+00,&
     -0.75964E+00,-0.76092E+00,-0.76221E+00,-0.76349E+00,-0.76476E+00,&
     -0.76603E+00,-0.76730E+00,-0.76856E+00,-0.76982E+00,-0.77107E+00,&
     -0.77232E+00,-0.77357E+00,-0.77481E+00,-0.77605E+00,-0.77729E+00,&
     -0.77852E+00,-0.77974E+00,-0.78097E+00,-0.78219E+00,-0.78340E+00,&
     -0.78461E+00,-0.78582E+00,-0.78703E+00,-0.78823E+00,-0.78943E+00,&
     -0.79062E+00,-0.79181E+00,-0.79300E+00,-0.79418E+00,-0.79536E+00,&
     -0.79653E+00,-0.79771E+00,-0.79887E+00,-0.80004E+00,-0.80120E+00,&
     -0.80236E+00,-0.80351E+00,-0.80467E+00,-0.80581E+00,-0.80696E+00,&
     -0.80810E+00,-0.80924E+00,-0.81037E+00,-0.81150E+00,-0.81263E+00,&
     -0.81376E+00,-0.81488E+00,-0.81600E+00,-0.81711E+00,-0.81823E+00,&
     -0.81934E+00,-0.82044E+00,-0.82155E+00,-0.82264E+00,-0.82374E+00,&
     -0.82484E+00,-0.82593E+00,-0.82701E+00,-0.82810E+00,-0.82918E+00,&
     -0.83026E+00,-0.83133E+00,-0.83241E+00,-0.83348E+00,-0.83454E+00,&
     -0.83561E+00,-0.83667E+00,-0.83773E+00,-0.83878E+00,-0.83984E+00,&
     -0.84089E+00,-0.84193E+00,-0.84298E+00,-0.84402E+00,-0.84506E+00,&
     -0.84609E+00,-0.84713E+00,-0.84816E+00,-0.84918E+00,-0.85021E+00/
                             
     DATA (BNC05M (IA),IA=301,400)/                                     &
     -0.85123E+00,-0.85225E+00,-0.85327E+00,-0.85428E+00,-0.85529E+00,&
     -0.85630E+00,-0.85731E+00,-0.85831E+00,-0.85932E+00,-0.86031E+00,&
     -0.86131E+00,-0.86230E+00,-0.86330E+00,-0.86428E+00,-0.86527E+00,&
     -0.86625E+00,-0.86724E+00,-0.86821E+00,-0.86919E+00,-0.87016E+00,&
     -0.87114E+00,-0.87210E+00,-0.87307E+00,-0.87404E+00,-0.87500E+00,&
     -0.87596E+00,-0.87691E+00,-0.87787E+00,-0.87882E+00,-0.87977E+00,&
     -0.88072E+00,-0.88167E+00,-0.88261E+00,-0.88355E+00,-0.88449E+00,&
     -0.88542E+00,-0.88636E+00,-0.88729E+00,-0.88822E+00,-0.88915E+00,&
     -0.89007E+00,-0.89100E+00,-0.89192E+00,-0.89284E+00,-0.89375E+00,&
     -0.89467E+00,-0.89558E+00,-0.89649E+00,-0.89740E+00,-0.89830E+00,&
     -0.89921E+00,-0.90011E+00,-0.90101E+00,-0.90191E+00,-0.90280E+00,&
     -0.90370E+00,-0.90459E+00,-0.90548E+00,-0.90636E+00,-0.90725E+00,&
     -0.90813E+00,-0.90901E+00,-0.90989E+00,-0.91077E+00,-0.91165E+00,&
     -0.91252E+00,-0.91339E+00,-0.91426E+00,-0.91513E+00,-0.91599E+00,&
     -0.91686E+00,-0.91772E+00,-0.91858E+00,-0.91944E+00,-0.92029E+00,&
     -0.92115E+00,-0.92200E+00,-0.92285E+00,-0.92370E+00,-0.92455E+00,&
     -0.92539E+00,-0.92623E+00,-0.92707E+00,-0.92791E+00,-0.92875E+00,&
     -0.92959E+00,-0.93042E+00,-0.93125E+00,-0.93208E+00,-0.93291E+00,&
     -0.93374E+00,-0.93456E+00,-0.93539E+00,-0.93621E+00,-0.93703E+00,&
     -0.93785E+00,-0.93866E+00,-0.93948E+00,-0.94029E+00,-0.94110E+00/
                             
     DATA (BNC05M (IA),IA=401,500)/                                     &
     -0.94191E+00,-0.94272E+00,-0.94353E+00,-0.94433E+00,-0.94513E+00,&
     -0.94594E+00,-0.94673E+00,-0.94753E+00,-0.94833E+00,-0.94912E+00,&
     -0.94992E+00,-0.95071E+00,-0.95150E+00,-0.95229E+00,-0.95307E+00,&
     -0.95386E+00,-0.95464E+00,-0.95542E+00,-0.95620E+00,-0.95698E+00,&
     -0.95776E+00,-0.95853E+00,-0.95931E+00,-0.96008E+00,-0.96085E+00,&
     -0.96162E+00,-0.96239E+00,-0.96316E+00,-0.96392E+00,-0.96468E+00,&
     -0.96545E+00,-0.96621E+00,-0.96696E+00,-0.96772E+00,-0.96848E+00,&
     -0.96923E+00,-0.96999E+00,-0.97074E+00,-0.97149E+00,-0.97224E+00,&
     -0.97298E+00,-0.97373E+00,-0.97447E+00,-0.97522E+00,-0.97596E+00,&
     -0.97670E+00,-0.97744E+00,-0.97817E+00,-0.97891E+00,-0.97964E+00,&
     -0.98038E+00,-0.98111E+00,-0.98184E+00,-0.98257E+00,-0.98329E+00,&
     -0.98402E+00,-0.98474E+00,-0.98547E+00,-0.98619E+00,-0.98691E+00,&
     -0.98763E+00,-0.98835E+00,-0.98906E+00,-0.98978E+00,-0.99049E+00,&
     -0.99121E+00,-0.99192E+00,-0.99263E+00,-0.99334E+00,-0.99404E+00,&
     -0.99475E+00,-0.99546E+00,-0.99616E+00,-0.99686E+00,-0.99756E+00,&
     -0.99826E+00,-0.99896E+00,-0.99966E+00,-0.10004E+01,-0.10011E+01,&
     -0.10017E+01,-0.10024E+01,-0.10031E+01,-0.10038E+01,-0.10045E+01,&
     -0.10052E+01,-0.10059E+01,-0.10066E+01,-0.10072E+01,-0.10079E+01,&
     -0.10086E+01,-0.10093E+01,-0.10100E+01,-0.10106E+01,-0.10113E+01,&
     -0.10120E+01,-0.10127E+01,-0.10133E+01,-0.10140E+01,-0.10147E+01/
                             
     DATA (BNC05M (IA),IA=501,600)/                                     &
     -0.10154E+01,-0.10160E+01,-0.10167E+01,-0.10174E+01,-0.10180E+01,&
     -0.10187E+01,-0.10194E+01,-0.10200E+01,-0.10207E+01,-0.10213E+01,&
     -0.10220E+01,-0.10227E+01,-0.10233E+01,-0.10240E+01,-0.10246E+01,&
     -0.10253E+01,-0.10259E+01,-0.10266E+01,-0.10272E+01,-0.10279E+01,&
     -0.10285E+01,-0.10292E+01,-0.10298E+01,-0.10305E+01,-0.10311E+01,&
     -0.10317E+01,-0.10324E+01,-0.10330E+01,-0.10337E+01,-0.10343E+01,&
     -0.10349E+01,-0.10356E+01,-0.10362E+01,-0.10368E+01,-0.10375E+01,&
     -0.10381E+01,-0.10387E+01,-0.10394E+01,-0.10400E+01,-0.10406E+01,&
     -0.10412E+01,-0.10419E+01,-0.10425E+01,-0.10431E+01,-0.10437E+01,&
     -0.10444E+01,-0.10450E+01,-0.10456E+01,-0.10462E+01,-0.10468E+01,&
     -0.10474E+01,-0.10481E+01,-0.10487E+01,-0.10493E+01,-0.10499E+01,&
     -0.10505E+01,-0.10511E+01,-0.10517E+01,-0.10523E+01,-0.10530E+01,&
     -0.10536E+01,-0.10542E+01,-0.10548E+01,-0.10554E+01,-0.10560E+01,&
     -0.10566E+01,-0.10572E+01,-0.10578E+01,-0.10584E+01,-0.10590E+01,&
     -0.10596E+01,-0.10602E+01,-0.10608E+01,-0.10614E+01,-0.10620E+01,&
     -0.10626E+01,-0.10631E+01,-0.10637E+01,-0.10643E+01,-0.10649E+01,&
     -0.10655E+01,-0.10661E+01,-0.10667E+01,-0.10673E+01,-0.10678E+01,&
     -0.10684E+01,-0.10690E+01,-0.10696E+01,-0.10702E+01,-0.10708E+01,&
     -0.10713E+01,-0.10719E+01,-0.10725E+01,-0.10731E+01,-0.10737E+01,&
     -0.10742E+01,-0.10748E+01,-0.10754E+01,-0.10759E+01,-0.10781E+01/
                             
     DATA (BNC05M (IA),IA=601,700)/                                     &
     -0.10828E+01,-0.10883E+01,-0.10939E+01,-0.10993E+01,-0.11047E+01,&
     -0.11099E+01,-0.11152E+01,-0.11203E+01,-0.11254E+01,-0.11304E+01,&
     -0.11354E+01,-0.11403E+01,-0.11451E+01,-0.11499E+01,-0.11546E+01,&
     -0.11593E+01,-0.11639E+01,-0.11685E+01,-0.11730E+01,-0.11775E+01,&
     -0.11819E+01,-0.11863E+01,-0.11906E+01,-0.11949E+01,-0.11991E+01,&
     -0.12033E+01,-0.12075E+01,-0.12116E+01,-0.12156E+01,-0.12197E+01,&
     -0.12237E+01,-0.12276E+01,-0.12316E+01,-0.12355E+01,-0.12393E+01,&
     -0.12431E+01,-0.12469E+01,-0.12507E+01,-0.12544E+01,-0.12581E+01,&
     -0.12618E+01,-0.12654E+01,-0.12690E+01,-0.12726E+01,-0.12761E+01,&
     -0.12797E+01,-0.12831E+01,-0.12866E+01,-0.12901E+01,-0.12935E+01,&
     -0.12969E+01,-0.13002E+01,-0.13036E+01,-0.13069E+01,-0.13102E+01,&
     -0.13135E+01,-0.13167E+01,-0.13200E+01,-0.13232E+01,-0.13264E+01,&
     -0.13295E+01,-0.13327E+01,-0.13358E+01,-0.13389E+01,-0.13420E+01,&
     -0.13451E+01,-0.13481E+01,-0.13512E+01,-0.13542E+01,-0.13572E+01,&
     -0.13601E+01,-0.13631E+01,-0.13661E+01,-0.13690E+01,-0.13719E+01,&
     -0.13748E+01,-0.13777E+01,-0.13806E+01,-0.13834E+01,-0.13863E+01,&
     -0.13891E+01,-0.13919E+01,-0.13947E+01,-0.13975E+01,-0.14002E+01,&
     -0.14030E+01,-0.14057E+01,-0.14085E+01,-0.14112E+01,-0.14139E+01,&
     -0.14166E+01,-0.14192E+01,-0.14219E+01,-0.14246E+01,-0.14272E+01,&
     -0.14298E+01,-0.14325E+01,-0.14351E+01,-0.14377E+01,-0.14402E+01/
                             
     DATA (BNC05M(IA),IA=701,741)/                                      &
     -0.14428E+01,-0.14454E+01,-0.14479E+01,-0.14505E+01,-0.14530E+01,&
     -0.14555E+01,-0.14581E+01,-0.14606E+01,-0.14631E+01,-0.14655E+01,&
     -0.14680E+01,-0.14705E+01,-0.14729E+01,-0.14754E+01,-0.14778E+01,&
     -0.14803E+01,-0.14827E+01,-0.14851E+01,-0.14875E+01,-0.14899E+01,&
     -0.14923E+01,-0.14947E+01,-0.14970E+01,-0.14994E+01,-0.15017E+01,&
     -0.15041E+01,-0.15064E+01,-0.15088E+01,-0.15111E+01,-0.15134E+01,&
     -0.15157E+01,-0.15180E+01,-0.15203E+01,-0.15226E+01,-0.15249E+01,&
     -0.15272E+01,-0.15294E+01,-0.15317E+01,-0.15340E+01,-0.15362E+01,&
     -0.15385E+01                  /                      
!                            
!  ** NH4Cl                  
!                            
     DATA (BNC06M (IA),IA=  1,100)/                                     &
     -0.52099E-01,-0.93686E-01,-0.12205E+00,-0.14078E+00,-0.15483E+00,&
     -0.16604E+00,-0.17532E+00,-0.18320E+00,-0.19002E+00,-0.19599E+00,&
     -0.20128E+00,-0.20600E+00,-0.21026E+00,-0.21411E+00,-0.21762E+00,&
     -0.22082E+00,-0.22376E+00,-0.22646E+00,-0.22896E+00,-0.23127E+00,&
     -0.23341E+00,-0.23540E+00,-0.23725E+00,-0.23898E+00,-0.24060E+00,&
     -0.24211E+00,-0.24353E+00,-0.24485E+00,-0.24610E+00,-0.24727E+00,&
     -0.24837E+00,-0.24941E+00,-0.25039E+00,-0.25131E+00,-0.25218E+00,&
     -0.25300E+00,-0.25378E+00,-0.25452E+00,-0.25521E+00,-0.25587E+00,&
     -0.25650E+00,-0.25709E+00,-0.25766E+00,-0.25819E+00,-0.25870E+00,&
     -0.25918E+00,-0.25963E+00,-0.26007E+00,-0.26048E+00,-0.26088E+00,&
     -0.26125E+00,-0.26160E+00,-0.26194E+00,-0.26226E+00,-0.26257E+00,&
     -0.26285E+00,-0.26313E+00,-0.26339E+00,-0.26363E+00,-0.26386E+00,&
     -0.26408E+00,-0.26429E+00,-0.26448E+00,-0.26466E+00,-0.26483E+00,&
     -0.26499E+00,-0.26513E+00,-0.26527E+00,-0.26539E+00,-0.26550E+00,&
     -0.26560E+00,-0.26569E+00,-0.26576E+00,-0.26583E+00,-0.26588E+00,&
     -0.26593E+00,-0.26596E+00,-0.26598E+00,-0.26600E+00,-0.26600E+00,&
     -0.26599E+00,-0.26597E+00,-0.26594E+00,-0.26590E+00,-0.26584E+00,&
     -0.26578E+00,-0.26571E+00,-0.26563E+00,-0.26553E+00,-0.26543E+00,&
     -0.26532E+00,-0.26520E+00,-0.26507E+00,-0.26492E+00,-0.26477E+00,&
     -0.26462E+00,-0.26445E+00,-0.26427E+00,-0.26409E+00,-0.26390E+00/
                             
     DATA (BNC06M (IA),IA=101,200)/                                     &
     -0.26370E+00,-0.26349E+00,-0.26327E+00,-0.26305E+00,-0.26282E+00,&
     -0.26258E+00,-0.26234E+00,-0.26209E+00,-0.26184E+00,-0.26158E+00,&
     -0.26131E+00,-0.26104E+00,-0.26076E+00,-0.26048E+00,-0.26020E+00,&
     -0.25991E+00,-0.25961E+00,-0.25931E+00,-0.25901E+00,-0.25870E+00,&
     -0.25848E+00,-0.25816E+00,-0.25783E+00,-0.25751E+00,-0.25718E+00,&
     -0.25684E+00,-0.25651E+00,-0.25617E+00,-0.25584E+00,-0.25550E+00,&
     -0.25516E+00,-0.25481E+00,-0.25447E+00,-0.25412E+00,-0.25378E+00,&
     -0.25343E+00,-0.25308E+00,-0.25273E+00,-0.25237E+00,-0.25202E+00,&
     -0.25167E+00,-0.25131E+00,-0.25095E+00,-0.25060E+00,-0.25024E+00,&
     -0.24988E+00,-0.24951E+00,-0.24915E+00,-0.24879E+00,-0.24843E+00,&
     -0.24806E+00,-0.24770E+00,-0.24733E+00,-0.24696E+00,-0.24659E+00,&
     -0.24623E+00,-0.24586E+00,-0.24549E+00,-0.24512E+00,-0.24475E+00,&
     -0.24438E+00,-0.24400E+00,-0.24363E+00,-0.24326E+00,-0.24289E+00,&
     -0.24251E+00,-0.24214E+00,-0.24176E+00,-0.24139E+00,-0.24101E+00,&
     -0.24064E+00,-0.24026E+00,-0.23988E+00,-0.23951E+00,-0.23913E+00,&
     -0.23875E+00,-0.23838E+00,-0.23800E+00,-0.23762E+00,-0.23724E+00,&
     -0.23687E+00,-0.23649E+00,-0.23611E+00,-0.23573E+00,-0.23535E+00,&
     -0.23498E+00,-0.23460E+00,-0.23422E+00,-0.23384E+00,-0.23346E+00,&
     -0.23308E+00,-0.23270E+00,-0.23232E+00,-0.23195E+00,-0.23157E+00,&
     -0.23119E+00,-0.23081E+00,-0.23043E+00,-0.23005E+00,-0.22968E+00/
                             
     DATA (BNC06M (IA),IA=201,300)/                                     &
     -0.22930E+00,-0.22892E+00,-0.22854E+00,-0.22816E+00,-0.22779E+00,&
     -0.22741E+00,-0.22703E+00,-0.22665E+00,-0.22628E+00,-0.22590E+00,&
     -0.22552E+00,-0.22515E+00,-0.22477E+00,-0.22439E+00,-0.22402E+00,&
     -0.22364E+00,-0.22327E+00,-0.22289E+00,-0.22252E+00,-0.22214E+00,&
     -0.22177E+00,-0.22139E+00,-0.22102E+00,-0.22064E+00,-0.22027E+00,&
     -0.21990E+00,-0.21953E+00,-0.21915E+00,-0.21878E+00,-0.21841E+00,&
     -0.21804E+00,-0.21767E+00,-0.21729E+00,-0.21692E+00,-0.21655E+00,&
     -0.21618E+00,-0.21581E+00,-0.21544E+00,-0.21508E+00,-0.21471E+00,&
     -0.21434E+00,-0.21397E+00,-0.21360E+00,-0.21324E+00,-0.21287E+00,&
     -0.21250E+00,-0.21214E+00,-0.21177E+00,-0.21141E+00,-0.21104E+00,&
     -0.21068E+00,-0.21031E+00,-0.20995E+00,-0.20958E+00,-0.20922E+00,&
     -0.20886E+00,-0.20850E+00,-0.20814E+00,-0.20777E+00,-0.20741E+00,&
     -0.20705E+00,-0.20669E+00,-0.20633E+00,-0.20597E+00,-0.20561E+00,&
     -0.20526E+00,-0.20490E+00,-0.20454E+00,-0.20418E+00,-0.20383E+00,&
     -0.20347E+00,-0.20312E+00,-0.20276E+00,-0.20241E+00,-0.20205E+00,&
     -0.20170E+00,-0.20134E+00,-0.20099E+00,-0.20064E+00,-0.20029E+00,&
     -0.19993E+00,-0.19958E+00,-0.19923E+00,-0.19888E+00,-0.19853E+00,&
     -0.19818E+00,-0.19783E+00,-0.19749E+00,-0.19714E+00,-0.19679E+00,&
     -0.19644E+00,-0.19610E+00,-0.19575E+00,-0.19541E+00,-0.19506E+00,&
     -0.19472E+00,-0.19437E+00,-0.19403E+00,-0.19369E+00,-0.19334E+00/
                             
     DATA (BNC06M (IA),IA=301,400)/                                     &
     -0.19300E+00,-0.19266E+00,-0.19232E+00,-0.19198E+00,-0.19164E+00,&
     -0.19130E+00,-0.19096E+00,-0.19062E+00,-0.19028E+00,-0.18994E+00,&
     -0.18961E+00,-0.18927E+00,-0.18893E+00,-0.18860E+00,-0.18826E+00,&
     -0.18793E+00,-0.18759E+00,-0.18726E+00,-0.18692E+00,-0.18659E+00,&
     -0.18626E+00,-0.18593E+00,-0.18560E+00,-0.18526E+00,-0.18493E+00,&
     -0.18460E+00,-0.18427E+00,-0.18395E+00,-0.18362E+00,-0.18329E+00,&
     -0.18296E+00,-0.18263E+00,-0.18231E+00,-0.18198E+00,-0.18166E+00,&
     -0.18133E+00,-0.18101E+00,-0.18068E+00,-0.18036E+00,-0.18004E+00,&
     -0.17971E+00,-0.17939E+00,-0.17907E+00,-0.17875E+00,-0.17843E+00,&
     -0.17811E+00,-0.17779E+00,-0.17747E+00,-0.17715E+00,-0.17683E+00,&
     -0.17652E+00,-0.17620E+00,-0.17588E+00,-0.17557E+00,-0.17525E+00,&
     -0.17493E+00,-0.17462E+00,-0.17431E+00,-0.17399E+00,-0.17368E+00,&
     -0.17337E+00,-0.17305E+00,-0.17274E+00,-0.17243E+00,-0.17212E+00,&
     -0.17181E+00,-0.17150E+00,-0.17119E+00,-0.17088E+00,-0.17057E+00,&
     -0.17027E+00,-0.16996E+00,-0.16965E+00,-0.16934E+00,-0.16904E+00,&
     -0.16873E+00,-0.16843E+00,-0.16812E+00,-0.16782E+00,-0.16752E+00,&
     -0.16721E+00,-0.16691E+00,-0.16661E+00,-0.16631E+00,-0.16601E+00,&
     -0.16571E+00,-0.16540E+00,-0.16511E+00,-0.16481E+00,-0.16451E+00,&
     -0.16421E+00,-0.16391E+00,-0.16361E+00,-0.16332E+00,-0.16302E+00,&
     -0.16273E+00,-0.16243E+00,-0.16213E+00,-0.16184E+00,-0.16155E+00/
                             
     DATA (BNC06M (IA),IA=401,500)/                                     &
     -0.16125E+00,-0.16096E+00,-0.16067E+00,-0.16038E+00,-0.16008E+00,&
     -0.15979E+00,-0.15950E+00,-0.15921E+00,-0.15892E+00,-0.15863E+00,&
     -0.15834E+00,-0.15806E+00,-0.15777E+00,-0.15748E+00,-0.15719E+00,&
     -0.15691E+00,-0.15662E+00,-0.15634E+00,-0.15605E+00,-0.15577E+00,&
     -0.15548E+00,-0.15520E+00,-0.15492E+00,-0.15463E+00,-0.15435E+00,&
     -0.15407E+00,-0.15379E+00,-0.15351E+00,-0.15323E+00,-0.15295E+00,&
     -0.15267E+00,-0.15239E+00,-0.15211E+00,-0.15183E+00,-0.15155E+00,&
     -0.15127E+00,-0.15100E+00,-0.15072E+00,-0.15045E+00,-0.15017E+00,&
     -0.14990E+00,-0.14962E+00,-0.14935E+00,-0.14907E+00,-0.14880E+00,&
     -0.14853E+00,-0.14825E+00,-0.14798E+00,-0.14771E+00,-0.14744E+00,&
     -0.14717E+00,-0.14690E+00,-0.14663E+00,-0.14636E+00,-0.14609E+00,&
     -0.14582E+00,-0.14555E+00,-0.14529E+00,-0.14502E+00,-0.14475E+00,&
     -0.14449E+00,-0.14422E+00,-0.14396E+00,-0.14369E+00,-0.14343E+00,&
     -0.14316E+00,-0.14290E+00,-0.14264E+00,-0.14237E+00,-0.14211E+00,&
     -0.14185E+00,-0.14159E+00,-0.14133E+00,-0.14107E+00,-0.14081E+00,&
     -0.14055E+00,-0.14029E+00,-0.14003E+00,-0.13977E+00,-0.13951E+00,&
     -0.13925E+00,-0.13900E+00,-0.13874E+00,-0.13848E+00,-0.13823E+00,&
     -0.13797E+00,-0.13772E+00,-0.13746E+00,-0.13721E+00,-0.13695E+00,&
     -0.13670E+00,-0.13645E+00,-0.13619E+00,-0.13594E+00,-0.13569E+00,&
     -0.13544E+00,-0.13519E+00,-0.13494E+00,-0.13469E+00,-0.13444E+00/
                             
     DATA (BNC06M (IA),IA=501,600)/                                     &
     -0.13419E+00,-0.13394E+00,-0.13369E+00,-0.13344E+00,-0.13319E+00,&
     -0.13295E+00,-0.13270E+00,-0.13245E+00,-0.13221E+00,-0.13196E+00,&
     -0.13172E+00,-0.13147E+00,-0.13123E+00,-0.13098E+00,-0.13074E+00,&
     -0.13050E+00,-0.13025E+00,-0.13001E+00,-0.12977E+00,-0.12953E+00,&
     -0.12929E+00,-0.12904E+00,-0.12880E+00,-0.12856E+00,-0.12832E+00,&
     -0.12808E+00,-0.12785E+00,-0.12761E+00,-0.12737E+00,-0.12713E+00,&
     -0.12689E+00,-0.12666E+00,-0.12642E+00,-0.12618E+00,-0.12595E+00,&
     -0.12571E+00,-0.12548E+00,-0.12524E+00,-0.12501E+00,-0.12477E+00,&
     -0.12454E+00,-0.12431E+00,-0.12407E+00,-0.12384E+00,-0.12361E+00,&
     -0.12338E+00,-0.12315E+00,-0.12292E+00,-0.12269E+00,-0.12246E+00,&
     -0.12223E+00,-0.12200E+00,-0.12177E+00,-0.12154E+00,-0.12131E+00,&
     -0.12108E+00,-0.12086E+00,-0.12063E+00,-0.12040E+00,-0.12017E+00,&
     -0.11995E+00,-0.11972E+00,-0.11950E+00,-0.11927E+00,-0.11905E+00,&
     -0.11882E+00,-0.11860E+00,-0.11838E+00,-0.11815E+00,-0.11793E+00,&
     -0.11771E+00,-0.11749E+00,-0.11726E+00,-0.11704E+00,-0.11682E+00,&
     -0.11660E+00,-0.11638E+00,-0.11616E+00,-0.11594E+00,-0.11572E+00,&
     -0.11550E+00,-0.11529E+00,-0.11507E+00,-0.11485E+00,-0.11463E+00,&
     -0.11441E+00,-0.11420E+00,-0.11398E+00,-0.11377E+00,-0.11355E+00,&
     -0.11333E+00,-0.11312E+00,-0.11291E+00,-0.11269E+00,-0.11248E+00,&
     -0.11226E+00,-0.11205E+00,-0.11184E+00,-0.11163E+00,-0.11083E+00/
                             
     DATA (BNC06M (IA),IA=601,700)/                                     &
     -0.10910E+00,-0.10704E+00,-0.10500E+00,-0.10300E+00,-0.10104E+00,&
     -0.99099E-01,-0.97194E-01,-0.95319E-01,-0.93474E-01,-0.91659E-01,&
     -0.89872E-01,-0.88115E-01,-0.86385E-01,-0.84682E-01,-0.83007E-01,&
     -0.81358E-01,-0.79736E-01,-0.78139E-01,-0.76568E-01,-0.75022E-01,&
     -0.73500E-01,-0.72002E-01,-0.70529E-01,-0.69079E-01,-0.67651E-01,&
     -0.66247E-01,-0.64865E-01,-0.63505E-01,-0.62167E-01,-0.60850E-01,&
     -0.59554E-01,-0.58278E-01,-0.57024E-01,-0.55789E-01,-0.54574E-01,&
     -0.53379E-01,-0.52203E-01,-0.51046E-01,-0.49908E-01,-0.48788E-01,&
     -0.47686E-01,-0.46602E-01,-0.45536E-01,-0.44487E-01,-0.43456E-01,&
     -0.42441E-01,-0.41444E-01,-0.40462E-01,-0.39497E-01,-0.38548E-01,&
     -0.37615E-01,-0.36698E-01,-0.35795E-01,-0.34909E-01,-0.34037E-01,&
     -0.33180E-01,-0.32337E-01,-0.31509E-01,-0.30696E-01,-0.29896E-01,&
     -0.29110E-01,-0.28338E-01,-0.27580E-01,-0.26835E-01,-0.26103E-01,&
     -0.25384E-01,-0.24679E-01,-0.23986E-01,-0.23305E-01,-0.22637E-01,&
     -0.21981E-01,-0.21338E-01,-0.20706E-01,-0.20086E-01,-0.19479E-01,&
     -0.18882E-01,-0.18297E-01,-0.17724E-01,-0.17161E-01,-0.16610E-01,&
     -0.16070E-01,-0.15540E-01,-0.15021E-01,-0.14513E-01,-0.14015E-01,&
     -0.13528E-01,-0.13050E-01,-0.12583E-01,-0.12126E-01,-0.11679E-01,&
     -0.11242E-01,-0.10814E-01,-0.10396E-01,-0.99873E-02,-0.95880E-02,&
     -0.91981E-02,-0.88174E-02,-0.84457E-02,-0.80831E-02,-0.77294E-02/
                             
     DATA (BNC06M(IA),IA=701,741)/                                      &
     -0.73845E-02,-0.70483E-02,-0.67207E-02,-0.64018E-02,-0.60913E-02,&
     -0.57891E-02,-0.54953E-02,-0.52096E-02,-0.49322E-02,-0.46628E-02,&
     -0.44013E-02,-0.41478E-02,-0.39020E-02,-0.36641E-02,-0.34337E-02,&
     -0.32110E-02,-0.29958E-02,-0.27881E-02,-0.25878E-02,-0.23947E-02,&
     -0.22090E-02,-0.20303E-02,-0.18589E-02,-0.16944E-02,-0.15369E-02,&
     -0.13864E-02,-0.12427E-02,-0.11058E-02,-0.97562E-03,-0.85213E-03,&
     -0.73527E-03,-0.62494E-03,-0.52106E-03,-0.42366E-03,-0.33266E-03,&
     -0.24793E-03,-0.16948E-03,-0.97253E-04,-0.31242E-04, 0.28753E-04,&
      0.82669E-04                  /                      
!                            
!  ** (2H, SO4)              
!                            
     DATA (BNC07M (IA),IA=  1,100)/                                     &
     -0.10557E+00,-0.19245E+00,-0.25372E+00,-0.29547E+00,-0.32770E+00,&
     -0.35411E+00,-0.37657E+00,-0.39614E+00,-0.41351E+00,-0.42914E+00,&
     -0.44335E+00,-0.45638E+00,-0.46842E+00,-0.47961E+00,-0.49007E+00,&
     -0.49989E+00,-0.50915E+00,-0.51790E+00,-0.52620E+00,-0.53409E+00,&
     -0.54162E+00,-0.54882E+00,-0.55571E+00,-0.56233E+00,-0.56868E+00,&
     -0.57480E+00,-0.58070E+00,-0.58640E+00,-0.59191E+00,-0.59724E+00,&
     -0.60240E+00,-0.60741E+00,-0.61227E+00,-0.61699E+00,-0.62158E+00,&
     -0.62605E+00,-0.63041E+00,-0.63465E+00,-0.63879E+00,-0.64283E+00,&
     -0.64677E+00,-0.65063E+00,-0.65440E+00,-0.65808E+00,-0.66169E+00,&
     -0.66522E+00,-0.66869E+00,-0.67208E+00,-0.67540E+00,-0.67867E+00,&
     -0.68187E+00,-0.68501E+00,-0.68810E+00,-0.69113E+00,-0.69411E+00,&
     -0.69704E+00,-0.69992E+00,-0.70275E+00,-0.70554E+00,-0.70829E+00,&
     -0.71099E+00,-0.71365E+00,-0.71628E+00,-0.71886E+00,-0.72141E+00,&
     -0.72392E+00,-0.72640E+00,-0.72885E+00,-0.73126E+00,-0.73364E+00,&
     -0.73600E+00,-0.73832E+00,-0.74061E+00,-0.74288E+00,-0.74512E+00,&
     -0.74733E+00,-0.74952E+00,-0.75169E+00,-0.75383E+00,-0.75594E+00,&
     -0.75804E+00,-0.76011E+00,-0.76216E+00,-0.76419E+00,-0.76621E+00,&
     -0.76820E+00,-0.77017E+00,-0.77212E+00,-0.77406E+00,-0.77598E+00,&
     -0.77788E+00,-0.77976E+00,-0.78163E+00,-0.78348E+00,-0.78532E+00,&
     -0.78714E+00,-0.78894E+00,-0.79073E+00,-0.79251E+00,-0.79427E+00/
                             
     DATA (BNC07M (IA),IA=101,200)/                                     &
     -0.79602E+00,-0.79775E+00,-0.79948E+00,-0.80118E+00,-0.80288E+00,&
     -0.80456E+00,-0.80623E+00,-0.80789E+00,-0.80954E+00,-0.81117E+00,&
     -0.81280E+00,-0.81441E+00,-0.81601E+00,-0.81760E+00,-0.81918E+00,&
     -0.82074E+00,-0.82230E+00,-0.82385E+00,-0.82538E+00,-0.82691E+00,&
     -0.82841E+00,-0.82992E+00,-0.83142E+00,-0.83291E+00,-0.83439E+00,&
     -0.83586E+00,-0.83732E+00,-0.83877E+00,-0.84022E+00,-0.84165E+00,&
     -0.84308E+00,-0.84449E+00,-0.84590E+00,-0.84730E+00,-0.84870E+00,&
     -0.85008E+00,-0.85146E+00,-0.85283E+00,-0.85419E+00,-0.85554E+00,&
     -0.85689E+00,-0.85823E+00,-0.85956E+00,-0.86088E+00,-0.86220E+00,&
     -0.86351E+00,-0.86481E+00,-0.86611E+00,-0.86740E+00,-0.86868E+00,&
     -0.86996E+00,-0.87123E+00,-0.87249E+00,-0.87375E+00,-0.87500E+00,&
     -0.87625E+00,-0.87749E+00,-0.87872E+00,-0.87995E+00,-0.88117E+00,&
     -0.88239E+00,-0.88360E+00,-0.88480E+00,-0.88600E+00,-0.88720E+00,&
     -0.88839E+00,-0.88957E+00,-0.89075E+00,-0.89192E+00,-0.89309E+00,&
     -0.89425E+00,-0.89541E+00,-0.89656E+00,-0.89771E+00,-0.89885E+00,&
     -0.89999E+00,-0.90112E+00,-0.90225E+00,-0.90337E+00,-0.90449E+00,&
     -0.90561E+00,-0.90672E+00,-0.90783E+00,-0.90893E+00,-0.91002E+00,&
     -0.91112E+00,-0.91221E+00,-0.91329E+00,-0.91437E+00,-0.91545E+00,&
     -0.91652E+00,-0.91759E+00,-0.91865E+00,-0.91971E+00,-0.92077E+00,&
     -0.92182E+00,-0.92287E+00,-0.92392E+00,-0.92496E+00,-0.92600E+00/
                             
     DATA (BNC07M (IA),IA=201,300)/                                     &
     -0.92703E+00,-0.92806E+00,-0.92909E+00,-0.93011E+00,-0.93113E+00,&
     -0.93215E+00,-0.93316E+00,-0.93417E+00,-0.93518E+00,-0.93618E+00,&
     -0.93718E+00,-0.93817E+00,-0.93917E+00,-0.94016E+00,-0.94114E+00,&
     -0.94213E+00,-0.94311E+00,-0.94408E+00,-0.94506E+00,-0.94603E+00,&
     -0.94700E+00,-0.94796E+00,-0.94892E+00,-0.94988E+00,-0.95084E+00,&
     -0.95179E+00,-0.95274E+00,-0.95369E+00,-0.95463E+00,-0.95557E+00,&
     -0.95651E+00,-0.95745E+00,-0.95838E+00,-0.95931E+00,-0.96024E+00,&
     -0.96117E+00,-0.96209E+00,-0.96301E+00,-0.96393E+00,-0.96484E+00,&
     -0.96576E+00,-0.96667E+00,-0.96758E+00,-0.96848E+00,-0.96938E+00,&
     -0.97028E+00,-0.97118E+00,-0.97208E+00,-0.97297E+00,-0.97386E+00,&
     -0.97475E+00,-0.97563E+00,-0.97652E+00,-0.97740E+00,-0.97828E+00,&
     -0.97916E+00,-0.98003E+00,-0.98090E+00,-0.98177E+00,-0.98264E+00,&
     -0.98351E+00,-0.98437E+00,-0.98523E+00,-0.98609E+00,-0.98695E+00,&
     -0.98780E+00,-0.98866E+00,-0.98951E+00,-0.99036E+00,-0.99120E+00,&
     -0.99205E+00,-0.99289E+00,-0.99373E+00,-0.99457E+00,-0.99541E+00,&
     -0.99625E+00,-0.99708E+00,-0.99791E+00,-0.99874E+00,-0.99957E+00,&
     -0.10004E+01,-0.10012E+01,-0.10020E+01,-0.10029E+01,-0.10037E+01,&
     -0.10045E+01,-0.10053E+01,-0.10061E+01,-0.10069E+01,-0.10077E+01,&
     -0.10086E+01,-0.10094E+01,-0.10102E+01,-0.10110E+01,-0.10118E+01,&
     -0.10126E+01,-0.10134E+01,-0.10142E+01,-0.10150E+01,-0.10157E+01/
                             
     DATA (BNC07M (IA),IA=301,400)/                                     &
     -0.10165E+01,-0.10173E+01,-0.10181E+01,-0.10189E+01,-0.10197E+01,&
     -0.10205E+01,-0.10212E+01,-0.10220E+01,-0.10228E+01,-0.10236E+01,&
     -0.10244E+01,-0.10251E+01,-0.10259E+01,-0.10267E+01,-0.10274E+01,&
     -0.10282E+01,-0.10290E+01,-0.10297E+01,-0.10305E+01,-0.10313E+01,&
     -0.10320E+01,-0.10328E+01,-0.10335E+01,-0.10343E+01,-0.10351E+01,&
     -0.10358E+01,-0.10366E+01,-0.10373E+01,-0.10381E+01,-0.10388E+01,&
     -0.10396E+01,-0.10403E+01,-0.10410E+01,-0.10418E+01,-0.10425E+01,&
     -0.10433E+01,-0.10440E+01,-0.10447E+01,-0.10455E+01,-0.10462E+01,&
     -0.10469E+01,-0.10477E+01,-0.10484E+01,-0.10491E+01,-0.10499E+01,&
     -0.10506E+01,-0.10513E+01,-0.10520E+01,-0.10528E+01,-0.10535E+01,&
     -0.10542E+01,-0.10549E+01,-0.10557E+01,-0.10564E+01,-0.10571E+01,&
     -0.10578E+01,-0.10585E+01,-0.10592E+01,-0.10599E+01,-0.10606E+01,&
     -0.10614E+01,-0.10621E+01,-0.10628E+01,-0.10635E+01,-0.10642E+01,&
     -0.10649E+01,-0.10656E+01,-0.10663E+01,-0.10670E+01,-0.10677E+01,&
     -0.10684E+01,-0.10691E+01,-0.10698E+01,-0.10705E+01,-0.10712E+01,&
     -0.10719E+01,-0.10726E+01,-0.10733E+01,-0.10739E+01,-0.10746E+01,&
     -0.10753E+01,-0.10760E+01,-0.10767E+01,-0.10774E+01,-0.10781E+01,&
     -0.10787E+01,-0.10794E+01,-0.10801E+01,-0.10808E+01,-0.10815E+01,&
     -0.10821E+01,-0.10828E+01,-0.10835E+01,-0.10842E+01,-0.10848E+01,&
     -0.10855E+01,-0.10862E+01,-0.10869E+01,-0.10875E+01,-0.10882E+01/
                             
     DATA (BNC07M (IA),IA=401,500)/                                     &
     -0.10889E+01,-0.10895E+01,-0.10902E+01,-0.10909E+01,-0.10915E+01,&
     -0.10922E+01,-0.10929E+01,-0.10935E+01,-0.10942E+01,-0.10948E+01,&
     -0.10955E+01,-0.10962E+01,-0.10968E+01,-0.10975E+01,-0.10981E+01,&
     -0.10988E+01,-0.10994E+01,-0.11001E+01,-0.11008E+01,-0.11014E+01,&
     -0.11021E+01,-0.11027E+01,-0.11034E+01,-0.11040E+01,-0.11047E+01,&
     -0.11053E+01,-0.11059E+01,-0.11066E+01,-0.11072E+01,-0.11079E+01,&
     -0.11085E+01,-0.11092E+01,-0.11098E+01,-0.11104E+01,-0.11111E+01,&
     -0.11117E+01,-0.11124E+01,-0.11130E+01,-0.11136E+01,-0.11143E+01,&
     -0.11149E+01,-0.11155E+01,-0.11162E+01,-0.11168E+01,-0.11174E+01,&
     -0.11181E+01,-0.11187E+01,-0.11193E+01,-0.11200E+01,-0.11206E+01,&
     -0.11212E+01,-0.11218E+01,-0.11225E+01,-0.11231E+01,-0.11237E+01,&
     -0.11243E+01,-0.11250E+01,-0.11256E+01,-0.11262E+01,-0.11268E+01,&
     -0.11274E+01,-0.11281E+01,-0.11287E+01,-0.11293E+01,-0.11299E+01,&
     -0.11305E+01,-0.11312E+01,-0.11318E+01,-0.11324E+01,-0.11330E+01,&
     -0.11336E+01,-0.11342E+01,-0.11348E+01,-0.11355E+01,-0.11361E+01,&
     -0.11367E+01,-0.11373E+01,-0.11379E+01,-0.11385E+01,-0.11391E+01,&
     -0.11397E+01,-0.11403E+01,-0.11409E+01,-0.11415E+01,-0.11421E+01,&
     -0.11427E+01,-0.11433E+01,-0.11439E+01,-0.11445E+01,-0.11451E+01,&
     -0.11457E+01,-0.11463E+01,-0.11469E+01,-0.11475E+01,-0.11481E+01,&
     -0.11487E+01,-0.11493E+01,-0.11499E+01,-0.11505E+01,-0.11511E+01/
                             
     DATA (BNC07M (IA),IA=501,600)/                                     &
     -0.11517E+01,-0.11523E+01,-0.11529E+01,-0.11535E+01,-0.11541E+01,&
     -0.11547E+01,-0.11553E+01,-0.11559E+01,-0.11565E+01,-0.11570E+01,&
     -0.11576E+01,-0.11582E+01,-0.11588E+01,-0.11594E+01,-0.11600E+01,&
     -0.11606E+01,-0.11612E+01,-0.11617E+01,-0.11623E+01,-0.11629E+01,&
     -0.11635E+01,-0.11641E+01,-0.11647E+01,-0.11652E+01,-0.11658E+01,&
     -0.11664E+01,-0.11670E+01,-0.11676E+01,-0.11681E+01,-0.11687E+01,&
     -0.11693E+01,-0.11699E+01,-0.11704E+01,-0.11710E+01,-0.11716E+01,&
     -0.11722E+01,-0.11728E+01,-0.11733E+01,-0.11739E+01,-0.11745E+01,&
     -0.11750E+01,-0.11756E+01,-0.11762E+01,-0.11768E+01,-0.11773E+01,&
     -0.11779E+01,-0.11785E+01,-0.11790E+01,-0.11796E+01,-0.11802E+01,&
     -0.11807E+01,-0.11813E+01,-0.11819E+01,-0.11824E+01,-0.11830E+01,&
     -0.11836E+01,-0.11841E+01,-0.11847E+01,-0.11853E+01,-0.11858E+01,&
     -0.11864E+01,-0.11870E+01,-0.11875E+01,-0.11881E+01,-0.11886E+01,&
     -0.11892E+01,-0.11898E+01,-0.11903E+01,-0.11909E+01,-0.11914E+01,&
     -0.11920E+01,-0.11925E+01,-0.11931E+01,-0.11937E+01,-0.11942E+01,&
     -0.11948E+01,-0.11953E+01,-0.11959E+01,-0.11964E+01,-0.11970E+01,&
     -0.11975E+01,-0.11981E+01,-0.11987E+01,-0.11992E+01,-0.11998E+01,&
     -0.12003E+01,-0.12009E+01,-0.12014E+01,-0.12020E+01,-0.12025E+01,&
     -0.12031E+01,-0.12036E+01,-0.12042E+01,-0.12047E+01,-0.12053E+01,&
     -0.12058E+01,-0.12063E+01,-0.12069E+01,-0.12074E+01,-0.12095E+01/
                             
     DATA (BNC07M (IA),IA=601,700)/                                     &
     -0.12140E+01,-0.12193E+01,-0.12247E+01,-0.12300E+01,-0.12353E+01,&
     -0.12405E+01,-0.12457E+01,-0.12509E+01,-0.12560E+01,-0.12611E+01,&
     -0.12662E+01,-0.12712E+01,-0.12763E+01,-0.12812E+01,-0.12862E+01,&
     -0.12911E+01,-0.12960E+01,-0.13009E+01,-0.13058E+01,-0.13106E+01,&
     -0.13154E+01,-0.13202E+01,-0.13250E+01,-0.13297E+01,-0.13344E+01,&
     -0.13391E+01,-0.13438E+01,-0.13484E+01,-0.13531E+01,-0.13577E+01,&
     -0.13623E+01,-0.13669E+01,-0.13714E+01,-0.13760E+01,-0.13805E+01,&
     -0.13850E+01,-0.13895E+01,-0.13940E+01,-0.13984E+01,-0.14029E+01,&
     -0.14073E+01,-0.14117E+01,-0.14161E+01,-0.14205E+01,-0.14249E+01,&
     -0.14292E+01,-0.14336E+01,-0.14379E+01,-0.14422E+01,-0.14465E+01,&
     -0.14508E+01,-0.14551E+01,-0.14593E+01,-0.14636E+01,-0.14678E+01,&
     -0.14720E+01,-0.14763E+01,-0.14805E+01,-0.14847E+01,-0.14888E+01,&
     -0.14930E+01,-0.14972E+01,-0.15013E+01,-0.15055E+01,-0.15096E+01,&
     -0.15137E+01,-0.15178E+01,-0.15219E+01,-0.15260E+01,-0.15301E+01,&
     -0.15341E+01,-0.15382E+01,-0.15423E+01,-0.15463E+01,-0.15503E+01,&
     -0.15544E+01,-0.15584E+01,-0.15624E+01,-0.15664E+01,-0.15704E+01,&
     -0.15744E+01,-0.15783E+01,-0.15823E+01,-0.15863E+01,-0.15902E+01,&
     -0.15941E+01,-0.15981E+01,-0.16020E+01,-0.16059E+01,-0.16098E+01,&
     -0.16138E+01,-0.16176E+01,-0.16215E+01,-0.16254E+01,-0.16293E+01,&
     -0.16332E+01,-0.16370E+01,-0.16409E+01,-0.16448E+01,-0.16486E+01/
                             
     DATA (BNC07M(IA),IA=701,741)/                                      &
     -0.16524E+01,-0.16563E+01,-0.16601E+01,-0.16639E+01,-0.16677E+01,&
     -0.16715E+01,-0.16753E+01,-0.16791E+01,-0.16829E+01,-0.16867E+01,&
     -0.16905E+01,-0.16943E+01,-0.16980E+01,-0.17018E+01,-0.17055E+01,&
     -0.17093E+01,-0.17130E+01,-0.17168E+01,-0.17205E+01,-0.17243E+01,&
     -0.17280E+01,-0.17317E+01,-0.17354E+01,-0.17391E+01,-0.17428E+01,&
     -0.17465E+01,-0.17502E+01,-0.17539E+01,-0.17576E+01,-0.17613E+01,&
     -0.17650E+01,-0.17686E+01,-0.17723E+01,-0.17760E+01,-0.17796E+01,&
     -0.17833E+01,-0.17869E+01,-0.17906E+01,-0.17942E+01,-0.17978E+01,&
     -0.18015E+01                  /                      
!                            
!  ** (H, HSO4)              
!                            
     DATA (BNC08M (IA),IA=  1,100)/                                     &
     -0.49133E-01,-0.83570E-01,-0.10389E+00,-0.11538E+00,-0.12265E+00,&
     -0.12736E+00,-0.13032E+00,-0.13201E+00,-0.13270E+00,-0.13259E+00,&
     -0.13182E+00,-0.13049E+00,-0.12867E+00,-0.12642E+00,-0.12378E+00,&
     -0.12080E+00,-0.11750E+00,-0.11391E+00,-0.11005E+00,-0.10594E+00,&
     -0.10160E+00,-0.97035E-01,-0.92266E-01,-0.87301E-01,-0.82151E-01,&
     -0.76825E-01,-0.71330E-01,-0.65676E-01,-0.59869E-01,-0.53917E-01,&
     -0.47824E-01,-0.41599E-01,-0.35245E-01,-0.28770E-01,-0.22177E-01,&
     -0.15472E-01,-0.86592E-02,-0.17436E-02, 0.52706E-02, 0.12379E-01,&
      0.19579E-01, 0.26864E-01, 0.34233E-01, 0.41682E-01, 0.49206E-01,&
      0.56803E-01, 0.64470E-01, 0.72204E-01, 0.80002E-01, 0.87862E-01,&
      0.95780E-01, 0.10376E+00, 0.11179E+00, 0.11987E+00, 0.12800E+00,&
      0.13618E+00, 0.14441E+00, 0.15269E+00, 0.16101E+00, 0.16938E+00,&
      0.17779E+00, 0.18624E+00, 0.19473E+00, 0.20327E+00, 0.21184E+00,&
      0.22046E+00, 0.22912E+00, 0.23782E+00, 0.24656E+00, 0.25534E+00,&
      0.26416E+00, 0.27303E+00, 0.28194E+00, 0.29089E+00, 0.29989E+00,&
      0.30893E+00, 0.31802E+00, 0.32715E+00, 0.33633E+00, 0.34556E+00,&
      0.35483E+00, 0.36415E+00, 0.37353E+00, 0.38295E+00, 0.39242E+00,&
      0.40194E+00, 0.41151E+00, 0.42113E+00, 0.43079E+00, 0.44051E+00,&
      0.45028E+00, 0.46009E+00, 0.46995E+00, 0.47986E+00, 0.48982E+00,&
      0.49981E+00, 0.50986E+00, 0.51994E+00, 0.53006E+00, 0.54023E+00/
                             
     DATA (BNC08M (IA),IA=101,200)/                                     &
      0.55043E+00, 0.56067E+00, 0.57094E+00, 0.58125E+00, 0.59158E+00,&
      0.60195E+00, 0.61234E+00, 0.62276E+00, 0.63320E+00, 0.64367E+00,&
      0.65415E+00, 0.66465E+00, 0.67516E+00, 0.68569E+00, 0.69624E+00,&
      0.70679E+00, 0.71735E+00, 0.72792E+00, 0.73849E+00, 0.74907E+00,&
      0.75876E+00, 0.76945E+00, 0.78012E+00, 0.79078E+00, 0.80143E+00,&
      0.81207E+00, 0.82269E+00, 0.83330E+00, 0.84390E+00, 0.85449E+00,&
      0.86506E+00, 0.87561E+00, 0.88616E+00, 0.89668E+00, 0.90719E+00,&
      0.91769E+00, 0.92817E+00, 0.93863E+00, 0.94908E+00, 0.95951E+00,&
      0.96993E+00, 0.98032E+00, 0.99070E+00, 0.10011E+01, 0.10114E+01,&
      0.10217E+01, 0.10320E+01, 0.10423E+01, 0.10526E+01, 0.10629E+01,&
      0.10731E+01, 0.10833E+01, 0.10935E+01, 0.11037E+01, 0.11138E+01,&
      0.11240E+01, 0.11341E+01, 0.11442E+01, 0.11543E+01, 0.11644E+01,&
      0.11744E+01, 0.11844E+01, 0.11944E+01, 0.12044E+01, 0.12144E+01,&
      0.12243E+01, 0.12342E+01, 0.12441E+01, 0.12540E+01, 0.12639E+01,&
      0.12737E+01, 0.12835E+01, 0.12933E+01, 0.13031E+01, 0.13129E+01,&
      0.13226E+01, 0.13323E+01, 0.13420E+01, 0.13517E+01, 0.13614E+01,&
      0.13710E+01, 0.13806E+01, 0.13902E+01, 0.13998E+01, 0.14093E+01,&
      0.14189E+01, 0.14284E+01, 0.14379E+01, 0.14474E+01, 0.14568E+01,&
      0.14662E+01, 0.14756E+01, 0.14850E+01, 0.14944E+01, 0.15038E+01,&
      0.15131E+01, 0.15224E+01, 0.15317E+01, 0.15410E+01, 0.15502E+01/
                             
     DATA (BNC08M (IA),IA=201,300)/                                     &
      0.15594E+01, 0.15687E+01, 0.15778E+01, 0.15870E+01, 0.15962E+01,&
      0.16053E+01, 0.16144E+01, 0.16235E+01, 0.16326E+01, 0.16416E+01,&
      0.16507E+01, 0.16597E+01, 0.16687E+01, 0.16776E+01, 0.16866E+01,&
      0.16955E+01, 0.17044E+01, 0.17133E+01, 0.17222E+01, 0.17311E+01,&
      0.17399E+01, 0.17487E+01, 0.17575E+01, 0.17663E+01, 0.17751E+01,&
      0.17838E+01, 0.17925E+01, 0.18012E+01, 0.18099E+01, 0.18186E+01,&
      0.18272E+01, 0.18359E+01, 0.18445E+01, 0.18531E+01, 0.18616E+01,&
      0.18702E+01, 0.18787E+01, 0.18872E+01, 0.18958E+01, 0.19042E+01,&
      0.19127E+01, 0.19211E+01, 0.19296E+01, 0.19380E+01, 0.19464E+01,&
      0.19548E+01, 0.19631E+01, 0.19715E+01, 0.19798E+01, 0.19881E+01,&
      0.19964E+01, 0.20046E+01, 0.20129E+01, 0.20211E+01, 0.20293E+01,&
      0.20375E+01, 0.20457E+01, 0.20539E+01, 0.20620E+01, 0.20702E+01,&
      0.20783E+01, 0.20864E+01, 0.20945E+01, 0.21025E+01, 0.21106E+01,&
      0.21186E+01, 0.21266E+01, 0.21346E+01, 0.21426E+01, 0.21506E+01,&
      0.21585E+01, 0.21665E+01, 0.21744E+01, 0.21823E+01, 0.21902E+01,&
      0.21980E+01, 0.22059E+01, 0.22137E+01, 0.22215E+01, 0.22294E+01,&
      0.22371E+01, 0.22449E+01, 0.22527E+01, 0.22604E+01, 0.22681E+01,&
      0.22759E+01, 0.22835E+01, 0.22912E+01, 0.22989E+01, 0.23065E+01,&
      0.23142E+01, 0.23218E+01, 0.23294E+01, 0.23370E+01, 0.23446E+01,&
      0.23521E+01, 0.23597E+01, 0.23672E+01, 0.23747E+01, 0.23822E+01/
                             
     DATA (BNC08M (IA),IA=301,400)/                                     &
      0.23897E+01, 0.23972E+01, 0.24046E+01, 0.24121E+01, 0.24195E+01,&
      0.24269E+01, 0.24343E+01, 0.24417E+01, 0.24490E+01, 0.24564E+01,&
      0.24637E+01, 0.24711E+01, 0.24784E+01, 0.24857E+01, 0.24930E+01,&
      0.25002E+01, 0.25075E+01, 0.25147E+01, 0.25220E+01, 0.25292E+01,&
      0.25364E+01, 0.25436E+01, 0.25507E+01, 0.25579E+01, 0.25650E+01,&
      0.25722E+01, 0.25793E+01, 0.25864E+01, 0.25935E+01, 0.26006E+01,&
      0.26076E+01, 0.26147E+01, 0.26217E+01, 0.26288E+01, 0.26358E+01,&
      0.26428E+01, 0.26498E+01, 0.26567E+01, 0.26637E+01, 0.26706E+01,&
      0.26776E+01, 0.26845E+01, 0.26914E+01, 0.26983E+01, 0.27052E+01,&
      0.27121E+01, 0.27189E+01, 0.27258E+01, 0.27326E+01, 0.27394E+01,&
      0.27463E+01, 0.27531E+01, 0.27598E+01, 0.27666E+01, 0.27734E+01,&
      0.27801E+01, 0.27869E+01, 0.27936E+01, 0.28003E+01, 0.28070E+01,&
      0.28137E+01, 0.28204E+01, 0.28270E+01, 0.28337E+01, 0.28403E+01,&
      0.28470E+01, 0.28536E+01, 0.28602E+01, 0.28668E+01, 0.28734E+01,&
      0.28799E+01, 0.28865E+01, 0.28930E+01, 0.28996E+01, 0.29061E+01,&
      0.29126E+01, 0.29191E+01, 0.29256E+01, 0.29321E+01, 0.29386E+01,&
      0.29450E+01, 0.29515E+01, 0.29579E+01, 0.29643E+01, 0.29708E+01,&
      0.29772E+01, 0.29835E+01, 0.29899E+01, 0.29963E+01, 0.30027E+01,&
      0.30090E+01, 0.30153E+01, 0.30217E+01, 0.30280E+01, 0.30343E+01,&
      0.30406E+01, 0.30469E+01, 0.30531E+01, 0.30594E+01, 0.30657E+01/
                             
     DATA (BNC08M (IA),IA=401,500)/                                     &
      0.30719E+01, 0.30781E+01, 0.30844E+01, 0.30906E+01, 0.30968E+01,&
      0.31030E+01, 0.31091E+01, 0.31153E+01, 0.31215E+01, 0.31276E+01,&
      0.31338E+01, 0.31399E+01, 0.31460E+01, 0.31521E+01, 0.31582E+01,&
      0.31643E+01, 0.31704E+01, 0.31764E+01, 0.31825E+01, 0.31886E+01,&
      0.31946E+01, 0.32006E+01, 0.32066E+01, 0.32127E+01, 0.32187E+01,&
      0.32246E+01, 0.32306E+01, 0.32366E+01, 0.32426E+01, 0.32485E+01,&
      0.32545E+01, 0.32604E+01, 0.32663E+01, 0.32722E+01, 0.32781E+01,&
      0.32840E+01, 0.32899E+01, 0.32958E+01, 0.33017E+01, 0.33075E+01,&
      0.33134E+01, 0.33192E+01, 0.33250E+01, 0.33309E+01, 0.33367E+01,&
      0.33425E+01, 0.33483E+01, 0.33540E+01, 0.33598E+01, 0.33656E+01,&
      0.33713E+01, 0.33771E+01, 0.33828E+01, 0.33886E+01, 0.33943E+01,&
      0.34000E+01, 0.34057E+01, 0.34114E+01, 0.34171E+01, 0.34228E+01,&
      0.34284E+01, 0.34341E+01, 0.34397E+01, 0.34454E+01, 0.34510E+01,&
      0.34567E+01, 0.34623E+01, 0.34679E+01, 0.34735E+01, 0.34791E+01,&
      0.34847E+01, 0.34902E+01, 0.34958E+01, 0.35014E+01, 0.35069E+01,&
      0.35124E+01, 0.35180E+01, 0.35235E+01, 0.35290E+01, 0.35345E+01,&
      0.35400E+01, 0.35455E+01, 0.35510E+01, 0.35565E+01, 0.35620E+01,&
      0.35674E+01, 0.35729E+01, 0.35783E+01, 0.35837E+01, 0.35892E+01,&
      0.35946E+01, 0.36000E+01, 0.36054E+01, 0.36108E+01, 0.36162E+01,&
      0.36216E+01, 0.36269E+01, 0.36323E+01, 0.36377E+01, 0.36430E+01/
                             
     DATA (BNC08M (IA),IA=501,600)/                                     &
      0.36483E+01, 0.36537E+01, 0.36590E+01, 0.36643E+01, 0.36696E+01,&
      0.36749E+01, 0.36802E+01, 0.36855E+01, 0.36908E+01, 0.36961E+01,&
      0.37013E+01, 0.37066E+01, 0.37118E+01, 0.37171E+01, 0.37223E+01,&
      0.37275E+01, 0.37328E+01, 0.37380E+01, 0.37432E+01, 0.37484E+01,&
      0.37536E+01, 0.37588E+01, 0.37639E+01, 0.37691E+01, 0.37743E+01,&
      0.37794E+01, 0.37846E+01, 0.37897E+01, 0.37948E+01, 0.38000E+01,&
      0.38051E+01, 0.38102E+01, 0.38153E+01, 0.38204E+01, 0.38255E+01,&
      0.38305E+01, 0.38356E+01, 0.38407E+01, 0.38458E+01, 0.38508E+01,&
      0.38559E+01, 0.38609E+01, 0.38659E+01, 0.38710E+01, 0.38760E+01,&
      0.38810E+01, 0.38860E+01, 0.38910E+01, 0.38960E+01, 0.39010E+01,&
      0.39059E+01, 0.39109E+01, 0.39159E+01, 0.39208E+01, 0.39258E+01,&
      0.39307E+01, 0.39357E+01, 0.39406E+01, 0.39455E+01, 0.39504E+01,&
      0.39554E+01, 0.39603E+01, 0.39652E+01, 0.39701E+01, 0.39749E+01,&
      0.39798E+01, 0.39847E+01, 0.39896E+01, 0.39944E+01, 0.39993E+01,&
      0.40041E+01, 0.40090E+01, 0.40138E+01, 0.40186E+01, 0.40234E+01,&
      0.40283E+01, 0.40331E+01, 0.40379E+01, 0.40427E+01, 0.40475E+01,&
      0.40522E+01, 0.40570E+01, 0.40618E+01, 0.40665E+01, 0.40713E+01,&
      0.40761E+01, 0.40808E+01, 0.40855E+01, 0.40903E+01, 0.40950E+01,&
      0.40997E+01, 0.41044E+01, 0.41091E+01, 0.41138E+01, 0.41185E+01,&
      0.41232E+01, 0.41279E+01, 0.41326E+01, 0.41373E+01, 0.41547E+01/
                             
     DATA (BNC08M (IA),IA=601,700)/                                     &
      0.41929E+01, 0.42386E+01, 0.42837E+01, 0.43283E+01, 0.43723E+01,&
      0.44159E+01, 0.44588E+01, 0.45013E+01, 0.45433E+01, 0.45849E+01,&
      0.46259E+01, 0.46665E+01, 0.47066E+01, 0.47463E+01, 0.47856E+01,&
      0.48244E+01, 0.48628E+01, 0.49008E+01, 0.49384E+01, 0.49757E+01,&
      0.50125E+01, 0.50490E+01, 0.50851E+01, 0.51208E+01, 0.51562E+01,&
      0.51912E+01, 0.52259E+01, 0.52603E+01, 0.52943E+01, 0.53280E+01,&
      0.53614E+01, 0.53945E+01, 0.54273E+01, 0.54598E+01, 0.54919E+01,&
      0.55238E+01, 0.55554E+01, 0.55868E+01, 0.56178E+01, 0.56486E+01,&
      0.56791E+01, 0.57094E+01, 0.57394E+01, 0.57691E+01, 0.57986E+01,&
      0.58279E+01, 0.58569E+01, 0.58856E+01, 0.59142E+01, 0.59425E+01,&
      0.59705E+01, 0.59984E+01, 0.60260E+01, 0.60534E+01, 0.60807E+01,&
      0.61076E+01, 0.61344E+01, 0.61610E+01, 0.61874E+01, 0.62136E+01,&
      0.62396E+01, 0.62653E+01, 0.62909E+01, 0.63164E+01, 0.63416E+01,&
      0.63666E+01, 0.63915E+01, 0.64162E+01, 0.64407E+01, 0.64650E+01,&
      0.64892E+01, 0.65132E+01, 0.65370E+01, 0.65607E+01, 0.65842E+01,&
      0.66076E+01, 0.66308E+01, 0.66538E+01, 0.66767E+01, 0.66994E+01,&
      0.67220E+01, 0.67444E+01, 0.67667E+01, 0.67889E+01, 0.68108E+01,&
      0.68327E+01, 0.68544E+01, 0.68760E+01, 0.68974E+01, 0.69188E+01,&
      0.69399E+01, 0.69610E+01, 0.69819E+01, 0.70027E+01, 0.70233E+01,&
      0.70439E+01, 0.70643E+01, 0.70846E+01, 0.71047E+01, 0.71248E+01/
                             
     DATA (BNC08M(IA),IA=701,741)/                                      &
      0.71447E+01, 0.71645E+01, 0.71842E+01, 0.72038E+01, 0.72233E+01,&
      0.72426E+01, 0.72619E+01, 0.72810E+01, 0.73000E+01, 0.73189E+01,&
      0.73378E+01, 0.73565E+01, 0.73751E+01, 0.73936E+01, 0.74120E+01,&
      0.74303E+01, 0.74484E+01, 0.74665E+01, 0.74845E+01, 0.75024E+01,&
      0.75203E+01, 0.75380E+01, 0.75556E+01, 0.75731E+01, 0.75905E+01,&
      0.76079E+01, 0.76251E+01, 0.76423E+01, 0.76593E+01, 0.76763E+01,&
      0.76932E+01, 0.77100E+01, 0.77268E+01, 0.77434E+01, 0.77600E+01,&
      0.77764E+01, 0.77928E+01, 0.78091E+01, 0.78253E+01, 0.78415E+01,&
      0.78576E+01                  /                      
!                            
!  ** NH4HSO4                
!                            
     DATA (BNC09M (IA),IA=  1,100)/                                     &
     -0.51701E-01,-0.92605E-01,-0.12047E+00,-0.13892E+00,-0.15280E+00,&
     -0.16389E+00,-0.17309E+00,-0.18091E+00,-0.18765E+00,-0.19355E+00,&
     -0.19875E+00,-0.20336E+00,-0.20748E+00,-0.21116E+00,-0.21445E+00,&
     -0.21741E+00,-0.22006E+00,-0.22244E+00,-0.22456E+00,-0.22646E+00,&
     -0.22813E+00,-0.22961E+00,-0.23090E+00,-0.23202E+00,-0.23297E+00,&
     -0.23377E+00,-0.23442E+00,-0.23493E+00,-0.23531E+00,-0.23556E+00,&
     -0.23569E+00,-0.23570E+00,-0.23561E+00,-0.23540E+00,-0.23510E+00,&
     -0.23469E+00,-0.23419E+00,-0.23360E+00,-0.23293E+00,-0.23217E+00,&
     -0.23132E+00,-0.23040E+00,-0.22941E+00,-0.22834E+00,-0.22720E+00,&
     -0.22599E+00,-0.22471E+00,-0.22338E+00,-0.22198E+00,-0.22052E+00,&
     -0.21901E+00,-0.21744E+00,-0.21582E+00,-0.21415E+00,-0.21242E+00,&
     -0.21065E+00,-0.20884E+00,-0.20697E+00,-0.20507E+00,-0.20312E+00,&
     -0.20113E+00,-0.19910E+00,-0.19703E+00,-0.19493E+00,-0.19278E+00,&
     -0.19060E+00,-0.18839E+00,-0.18614E+00,-0.18386E+00,-0.18154E+00,&
     -0.17919E+00,-0.17681E+00,-0.17440E+00,-0.17196E+00,-0.16948E+00,&
     -0.16698E+00,-0.16445E+00,-0.16188E+00,-0.15929E+00,-0.15667E+00,&
     -0.15402E+00,-0.15134E+00,-0.14864E+00,-0.14590E+00,-0.14314E+00,&
     -0.14035E+00,-0.13754E+00,-0.13470E+00,-0.13183E+00,-0.12894E+00,&
     -0.12602E+00,-0.12308E+00,-0.12011E+00,-0.11713E+00,-0.11411E+00,&
     -0.11108E+00,-0.10803E+00,-0.10495E+00,-0.10186E+00,-0.98742E-01/
                             
     DATA (BNC09M (IA),IA=101,200)/                                     &
     -0.95609E-01,-0.92458E-01,-0.89291E-01,-0.86108E-01,-0.82909E-01,&
     -0.79696E-01,-0.76469E-01,-0.73230E-01,-0.69979E-01,-0.66717E-01,&
     -0.63445E-01,-0.60163E-01,-0.56873E-01,-0.53575E-01,-0.50270E-01,&
     -0.46959E-01,-0.43642E-01,-0.40321E-01,-0.36995E-01,-0.33666E-01,&
     -0.30646E-01,-0.27276E-01,-0.23908E-01,-0.20542E-01,-0.17179E-01,&
     -0.13818E-01,-0.10461E-01,-0.71064E-02,-0.37554E-02,-0.40779E-03,&
      0.29358E-02, 0.62756E-02, 0.96112E-02, 0.12942E-01, 0.16269E-01,&
      0.19592E-01, 0.22909E-01, 0.26221E-01, 0.29529E-01, 0.32832E-01,&
      0.36129E-01, 0.39420E-01, 0.42706E-01, 0.45987E-01, 0.49262E-01,&
      0.52531E-01, 0.55794E-01, 0.59051E-01, 0.62303E-01, 0.65548E-01,&
      0.68786E-01, 0.72019E-01, 0.75245E-01, 0.78465E-01, 0.81678E-01,&
      0.84885E-01, 0.88086E-01, 0.91279E-01, 0.94466E-01, 0.97647E-01,&
      0.10082E+00, 0.10399E+00, 0.10715E+00, 0.11030E+00, 0.11345E+00,&
      0.11659E+00, 0.11972E+00, 0.12285E+00, 0.12596E+00, 0.12908E+00,&
      0.13218E+00, 0.13528E+00, 0.13837E+00, 0.14146E+00, 0.14453E+00,&
      0.14760E+00, 0.15067E+00, 0.15372E+00, 0.15677E+00, 0.15981E+00,&
      0.16285E+00, 0.16588E+00, 0.16890E+00, 0.17191E+00, 0.17492E+00,&
      0.17792E+00, 0.18091E+00, 0.18390E+00, 0.18688E+00, 0.18985E+00,&
      0.19281E+00, 0.19577E+00, 0.19872E+00, 0.20167E+00, 0.20460E+00,&
      0.20753E+00, 0.21046E+00, 0.21338E+00, 0.21629E+00, 0.21919E+00/
                             
     DATA (BNC09M (IA),IA=201,300)/                                     &
      0.22208E+00, 0.22497E+00, 0.22786E+00, 0.23073E+00, 0.23360E+00,&
      0.23647E+00, 0.23932E+00, 0.24217E+00, 0.24501E+00, 0.24785E+00,&
      0.25068E+00, 0.25350E+00, 0.25632E+00, 0.25913E+00, 0.26193E+00,&
      0.26473E+00, 0.26752E+00, 0.27030E+00, 0.27308E+00, 0.27585E+00,&
      0.27861E+00, 0.28137E+00, 0.28412E+00, 0.28687E+00, 0.28961E+00,&
      0.29234E+00, 0.29506E+00, 0.29778E+00, 0.30050E+00, 0.30321E+00,&
      0.30591E+00, 0.30860E+00, 0.31129E+00, 0.31397E+00, 0.31665E+00,&
      0.31932E+00, 0.32199E+00, 0.32465E+00, 0.32730E+00, 0.32995E+00,&
      0.33259E+00, 0.33522E+00, 0.33785E+00, 0.34047E+00, 0.34309E+00,&
      0.34570E+00, 0.34831E+00, 0.35091E+00, 0.35350E+00, 0.35609E+00,&
      0.35867E+00, 0.36125E+00, 0.36382E+00, 0.36639E+00, 0.36895E+00,&
      0.37150E+00, 0.37405E+00, 0.37659E+00, 0.37913E+00, 0.38166E+00,&
      0.38419E+00, 0.38671E+00, 0.38923E+00, 0.39174E+00, 0.39424E+00,&
      0.39674E+00, 0.39924E+00, 0.40173E+00, 0.40421E+00, 0.40669E+00,&
      0.40916E+00, 0.41163E+00, 0.41409E+00, 0.41655E+00, 0.41900E+00,&
      0.42145E+00, 0.42389E+00, 0.42632E+00, 0.42876E+00, 0.43118E+00,&
      0.43360E+00, 0.43602E+00, 0.43843E+00, 0.44084E+00, 0.44324E+00,&
      0.44563E+00, 0.44803E+00, 0.45041E+00, 0.45279E+00, 0.45517E+00,&
      0.45754E+00, 0.45991E+00, 0.46227E+00, 0.46463E+00, 0.46698E+00,&
      0.46933E+00, 0.47167E+00, 0.47401E+00, 0.47634E+00, 0.47867E+00/
                             
     DATA (BNC09M (IA),IA=301,400)/                                     &
      0.48099E+00, 0.48331E+00, 0.48563E+00, 0.48794E+00, 0.49024E+00,&
      0.49254E+00, 0.49484E+00, 0.49713E+00, 0.49942E+00, 0.50170E+00,&
      0.50398E+00, 0.50625E+00, 0.50852E+00, 0.51079E+00, 0.51305E+00,&
      0.51530E+00, 0.51755E+00, 0.51980E+00, 0.52204E+00, 0.52428E+00,&
      0.52651E+00, 0.52874E+00, 0.53097E+00, 0.53319E+00, 0.53540E+00,&
      0.53762E+00, 0.53983E+00, 0.54203E+00, 0.54423E+00, 0.54642E+00,&
      0.54862E+00, 0.55080E+00, 0.55299E+00, 0.55516E+00, 0.55734E+00,&
      0.55951E+00, 0.56168E+00, 0.56384E+00, 0.56600E+00, 0.56815E+00,&
      0.57030E+00, 0.57245E+00, 0.57459E+00, 0.57673E+00, 0.57886E+00,&
      0.58099E+00, 0.58312E+00, 0.58524E+00, 0.58736E+00, 0.58947E+00,&
      0.59158E+00, 0.59369E+00, 0.59579E+00, 0.59789E+00, 0.59999E+00,&
      0.60208E+00, 0.60416E+00, 0.60625E+00, 0.60833E+00, 0.61040E+00,&
      0.61248E+00, 0.61455E+00, 0.61661E+00, 0.61867E+00, 0.62073E+00,&
      0.62278E+00, 0.62483E+00, 0.62688E+00, 0.62892E+00, 0.63096E+00,&
      0.63300E+00, 0.63503E+00, 0.63706E+00, 0.63908E+00, 0.64110E+00,&
      0.64312E+00, 0.64513E+00, 0.64714E+00, 0.64915E+00, 0.65115E+00,&
      0.65316E+00, 0.65515E+00, 0.65714E+00, 0.65913E+00, 0.66112E+00,&
      0.66310E+00, 0.66508E+00, 0.66706E+00, 0.66903E+00, 0.67100E+00,&
      0.67296E+00, 0.67492E+00, 0.67688E+00, 0.67884E+00, 0.68079E+00,&
      0.68274E+00, 0.68468E+00, 0.68663E+00, 0.68856E+00, 0.69050E+00/
                             
     DATA (BNC09M (IA),IA=401,500)/                                     &
      0.69243E+00, 0.69436E+00, 0.69629E+00, 0.69821E+00, 0.70013E+00,&
      0.70204E+00, 0.70396E+00, 0.70587E+00, 0.70777E+00, 0.70967E+00,&
      0.71157E+00, 0.71347E+00, 0.71536E+00, 0.71725E+00, 0.71914E+00,&
      0.72103E+00, 0.72291E+00, 0.72478E+00, 0.72666E+00, 0.72853E+00,&
      0.73040E+00, 0.73226E+00, 0.73413E+00, 0.73599E+00, 0.73784E+00,&
      0.73970E+00, 0.74155E+00, 0.74339E+00, 0.74524E+00, 0.74708E+00,&
      0.74892E+00, 0.75075E+00, 0.75258E+00, 0.75441E+00, 0.75624E+00,&
      0.75806E+00, 0.75988E+00, 0.76170E+00, 0.76352E+00, 0.76533E+00,&
      0.76714E+00, 0.76894E+00, 0.77074E+00, 0.77255E+00, 0.77434E+00,&
      0.77614E+00, 0.77793E+00, 0.77972E+00, 0.78150E+00, 0.78329E+00,&
      0.78507E+00, 0.78684E+00, 0.78862E+00, 0.79039E+00, 0.79216E+00,&
      0.79393E+00, 0.79569E+00, 0.79745E+00, 0.79921E+00, 0.80096E+00,&
      0.80272E+00, 0.80447E+00, 0.80621E+00, 0.80796E+00, 0.80970E+00,&
      0.81144E+00, 0.81318E+00, 0.81491E+00, 0.81664E+00, 0.81837E+00,&
      0.82009E+00, 0.82182E+00, 0.82354E+00, 0.82526E+00, 0.82697E+00,&
      0.82868E+00, 0.83039E+00, 0.83210E+00, 0.83381E+00, 0.83551E+00,&
      0.83721E+00, 0.83890E+00, 0.84060E+00, 0.84229E+00, 0.84398E+00,&
      0.84567E+00, 0.84735E+00, 0.84903E+00, 0.85071E+00, 0.85239E+00,&
      0.85406E+00, 0.85573E+00, 0.85740E+00, 0.85907E+00, 0.86074E+00,&
      0.86240E+00, 0.86406E+00, 0.86571E+00, 0.86737E+00, 0.86902E+00/
                             
     DATA (BNC09M (IA),IA=501,600)/                                     &
      0.87067E+00, 0.87232E+00, 0.87396E+00, 0.87560E+00, 0.87724E+00,&
      0.87888E+00, 0.88052E+00, 0.88215E+00, 0.88378E+00, 0.88541E+00,&
      0.88703E+00, 0.88865E+00, 0.89028E+00, 0.89189E+00, 0.89351E+00,&
      0.89512E+00, 0.89674E+00, 0.89834E+00, 0.89995E+00, 0.90156E+00,&
      0.90316E+00, 0.90476E+00, 0.90635E+00, 0.90795E+00, 0.90954E+00,&
      0.91113E+00, 0.91272E+00, 0.91431E+00, 0.91589E+00, 0.91747E+00,&
      0.91905E+00, 0.92063E+00, 0.92221E+00, 0.92378E+00, 0.92535E+00,&
      0.92692E+00, 0.92848E+00, 0.93005E+00, 0.93161E+00, 0.93317E+00,&
      0.93472E+00, 0.93628E+00, 0.93783E+00, 0.93938E+00, 0.94093E+00,&
      0.94248E+00, 0.94402E+00, 0.94556E+00, 0.94710E+00, 0.94864E+00,&
      0.95018E+00, 0.95171E+00, 0.95324E+00, 0.95477E+00, 0.95630E+00,&
      0.95782E+00, 0.95935E+00, 0.96087E+00, 0.96239E+00, 0.96390E+00,&
      0.96542E+00, 0.96693E+00, 0.96844E+00, 0.96995E+00, 0.97145E+00,&
      0.97296E+00, 0.97446E+00, 0.97596E+00, 0.97746E+00, 0.97896E+00,&
      0.98045E+00, 0.98194E+00, 0.98343E+00, 0.98492E+00, 0.98641E+00,&
      0.98789E+00, 0.98937E+00, 0.99085E+00, 0.99233E+00, 0.99380E+00,&
      0.99528E+00, 0.99675E+00, 0.99822E+00, 0.99969E+00, 0.10012E+01,&
      0.10026E+01, 0.10041E+01, 0.10055E+01, 0.10070E+01, 0.10085E+01,&
      0.10099E+01, 0.10114E+01, 0.10128E+01, 0.10143E+01, 0.10157E+01,&
      0.10172E+01, 0.10186E+01, 0.10200E+01, 0.10215E+01, 0.10269E+01/
                             
     DATA (BNC09M (IA),IA=601,700)/                                     &
      0.10386E+01, 0.10527E+01, 0.10666E+01, 0.10803E+01, 0.10938E+01,&
      0.11072E+01, 0.11204E+01, 0.11334E+01, 0.11463E+01, 0.11591E+01,&
      0.11717E+01, 0.11841E+01, 0.11964E+01, 0.12086E+01, 0.12206E+01,&
      0.12325E+01, 0.12442E+01, 0.12558E+01, 0.12673E+01, 0.12787E+01,&
      0.12900E+01, 0.13011E+01, 0.13121E+01, 0.13230E+01, 0.13338E+01,&
      0.13444E+01, 0.13550E+01, 0.13655E+01, 0.13758E+01, 0.13860E+01,&
      0.13962E+01, 0.14062E+01, 0.14162E+01, 0.14260E+01, 0.14358E+01,&
      0.14454E+01, 0.14550E+01, 0.14645E+01, 0.14738E+01, 0.14831E+01,&
      0.14923E+01, 0.15015E+01, 0.15105E+01, 0.15195E+01, 0.15284E+01,&
      0.15372E+01, 0.15459E+01, 0.15545E+01, 0.15631E+01, 0.15716E+01,&
      0.15800E+01, 0.15884E+01, 0.15966E+01, 0.16049E+01, 0.16130E+01,&
      0.16211E+01, 0.16291E+01, 0.16370E+01, 0.16449E+01, 0.16527E+01,&
      0.16604E+01, 0.16681E+01, 0.16757E+01, 0.16833E+01, 0.16908E+01,&
      0.16982E+01, 0.17056E+01, 0.17129E+01, 0.17201E+01, 0.17273E+01,&
      0.17345E+01, 0.17416E+01, 0.17486E+01, 0.17556E+01, 0.17625E+01,&
      0.17694E+01, 0.17763E+01, 0.17830E+01, 0.17898E+01, 0.17964E+01,&
      0.18031E+01, 0.18097E+01, 0.18162E+01, 0.18227E+01, 0.18291E+01,&
      0.18355E+01, 0.18418E+01, 0.18481E+01, 0.18544E+01, 0.18606E+01,&
      0.18668E+01, 0.18729E+01, 0.18790E+01, 0.18850E+01, 0.18910E+01,&
      0.18970E+01, 0.19029E+01, 0.19088E+01, 0.19146E+01, 0.19204E+01/
                             
     DATA (BNC09M(IA),IA=701,741)/                                      &
      0.19262E+01, 0.19319E+01, 0.19376E+01, 0.19432E+01, 0.19488E+01,&
      0.19544E+01, 0.19599E+01, 0.19654E+01, 0.19709E+01, 0.19763E+01,&
      0.19817E+01, 0.19871E+01, 0.19924E+01, 0.19977E+01, 0.20029E+01,&
      0.20082E+01, 0.20133E+01, 0.20185E+01, 0.20236E+01, 0.20287E+01,&
      0.20338E+01, 0.20388E+01, 0.20438E+01, 0.20488E+01, 0.20537E+01,&
      0.20586E+01, 0.20635E+01, 0.20683E+01, 0.20731E+01, 0.20779E+01,&
      0.20827E+01, 0.20874E+01, 0.20921E+01, 0.20968E+01, 0.21014E+01,&
      0.21061E+01, 0.21107E+01, 0.21152E+01, 0.21198E+01, 0.21243E+01,&
      0.21288E+01               /                      
!                             
!  ** (H, NO3)               
!                            
     DATA (BNC10M (IA),IA=  1,100)/                                     &
     -0.50967E-01,-0.89573E-01,-0.11434E+00,-0.12971E+00,-0.14053E+00,&
     -0.14861E+00,-0.15484E+00,-0.15973E+00,-0.16360E+00,-0.16667E+00,&
     -0.16910E+00,-0.17099E+00,-0.17243E+00,-0.17350E+00,-0.17424E+00,&
     -0.17470E+00,-0.17491E+00,-0.17491E+00,-0.17471E+00,-0.17434E+00,&
     -0.17382E+00,-0.17316E+00,-0.17238E+00,-0.17148E+00,-0.17049E+00,&
     -0.16940E+00,-0.16823E+00,-0.16699E+00,-0.16567E+00,-0.16430E+00,&
     -0.16287E+00,-0.16138E+00,-0.15985E+00,-0.15828E+00,-0.15667E+00,&
     -0.15502E+00,-0.15334E+00,-0.15163E+00,-0.14989E+00,-0.14814E+00,&
     -0.14635E+00,-0.14456E+00,-0.14274E+00,-0.14090E+00,-0.13906E+00,&
     -0.13720E+00,-0.13533E+00,-0.13344E+00,-0.13155E+00,-0.12965E+00,&
     -0.12775E+00,-0.12583E+00,-0.12392E+00,-0.12199E+00,-0.12006E+00,&
     -0.11812E+00,-0.11618E+00,-0.11424E+00,-0.11229E+00,-0.11033E+00,&
     -0.10837E+00,-0.10640E+00,-0.10443E+00,-0.10246E+00,-0.10047E+00,&
     -0.98485E-01,-0.96489E-01,-0.94485E-01,-0.92474E-01,-0.90455E-01,&
     -0.88427E-01,-0.86389E-01,-0.84342E-01,-0.82285E-01,-0.80216E-01,&
     -0.78136E-01,-0.76044E-01,-0.73940E-01,-0.71822E-01,-0.69692E-01,&
     -0.67547E-01,-0.65389E-01,-0.63216E-01,-0.61028E-01,-0.58825E-01,&
     -0.56607E-01,-0.54374E-01,-0.52125E-01,-0.49861E-01,-0.47581E-01,&
     -0.45285E-01,-0.42974E-01,-0.40648E-01,-0.38307E-01,-0.35950E-01,&
     -0.33579E-01,-0.31194E-01,-0.28794E-01,-0.26380E-01,-0.23953E-01/
                             
     DATA (BNC10M (IA),IA=101,200)/                                     &
     -0.21514E-01,-0.19061E-01,-0.16597E-01,-0.14121E-01,-0.11634E-01,&
     -0.91364E-02,-0.66288E-02,-0.41117E-02,-0.15855E-02, 0.94906E-03,&
      0.34915E-02, 0.60415E-02, 0.85982E-02, 0.11161E-01, 0.13730E-01,&
      0.16305E-01, 0.18884E-01, 0.21468E-01, 0.24056E-01, 0.26647E-01,&
      0.28953E-01, 0.31584E-01, 0.34213E-01, 0.36841E-01, 0.39469E-01,&
      0.42094E-01, 0.44719E-01, 0.47342E-01, 0.49964E-01, 0.52584E-01,&
      0.55203E-01, 0.57820E-01, 0.60435E-01, 0.63049E-01, 0.65661E-01,&
      0.68270E-01, 0.70878E-01, 0.73484E-01, 0.76088E-01, 0.78689E-01,&
      0.81289E-01, 0.83886E-01, 0.86481E-01, 0.89073E-01, 0.91664E-01,&
      0.94252E-01, 0.96837E-01, 0.99420E-01, 0.10200E+00, 0.10458E+00,&
      0.10715E+00, 0.10973E+00, 0.11230E+00, 0.11486E+00, 0.11743E+00,&
      0.11999E+00, 0.12255E+00, 0.12510E+00, 0.12766E+00, 0.13021E+00,&
      0.13276E+00, 0.13530E+00, 0.13784E+00, 0.14038E+00, 0.14291E+00,&
      0.14545E+00, 0.14798E+00, 0.15050E+00, 0.15303E+00, 0.15555E+00,&
      0.15806E+00, 0.16058E+00, 0.16309E+00, 0.16559E+00, 0.16810E+00,&
      0.17060E+00, 0.17309E+00, 0.17559E+00, 0.17808E+00, 0.18057E+00,&
      0.18305E+00, 0.18553E+00, 0.18801E+00, 0.19048E+00, 0.19295E+00,&
      0.19542E+00, 0.19788E+00, 0.20034E+00, 0.20280E+00, 0.20525E+00,&
      0.20770E+00, 0.21015E+00, 0.21259E+00, 0.21503E+00, 0.21747E+00,&
      0.21990E+00, 0.22233E+00, 0.22475E+00, 0.22718E+00, 0.22959E+00/
                             
     DATA (BNC10M (IA),IA=201,300)/                                     &
      0.23201E+00, 0.23442E+00, 0.23683E+00, 0.23923E+00, 0.24163E+00,&
      0.24403E+00, 0.24642E+00, 0.24881E+00, 0.25120E+00, 0.25358E+00,&
      0.25596E+00, 0.25833E+00, 0.26070E+00, 0.26307E+00, 0.26544E+00,&
      0.26780E+00, 0.27016E+00, 0.27251E+00, 0.27486E+00, 0.27721E+00,&
      0.27955E+00, 0.28189E+00, 0.28422E+00, 0.28655E+00, 0.28888E+00,&
      0.29121E+00, 0.29353E+00, 0.29585E+00, 0.29816E+00, 0.30047E+00,&
      0.30278E+00, 0.30508E+00, 0.30738E+00, 0.30967E+00, 0.31197E+00,&
      0.31425E+00, 0.31654E+00, 0.31882E+00, 0.32110E+00, 0.32337E+00,&
      0.32564E+00, 0.32791E+00, 0.33017E+00, 0.33243E+00, 0.33469E+00,&
      0.33694E+00, 0.33919E+00, 0.34143E+00, 0.34367E+00, 0.34591E+00,&
      0.34815E+00, 0.35038E+00, 0.35260E+00, 0.35483E+00, 0.35705E+00,&
      0.35926E+00, 0.36148E+00, 0.36369E+00, 0.36589E+00, 0.36809E+00,&
      0.37029E+00, 0.37249E+00, 0.37468E+00, 0.37687E+00, 0.37905E+00,&
      0.38123E+00, 0.38341E+00, 0.38558E+00, 0.38775E+00, 0.38992E+00,&
      0.39208E+00, 0.39424E+00, 0.39640E+00, 0.39855E+00, 0.40070E+00,&
      0.40285E+00, 0.40499E+00, 0.40713E+00, 0.40927E+00, 0.41140E+00,&
      0.41353E+00, 0.41565E+00, 0.41777E+00, 0.41989E+00, 0.42201E+00,&
      0.42412E+00, 0.42623E+00, 0.42833E+00, 0.43043E+00, 0.43253E+00,&
      0.43463E+00, 0.43672E+00, 0.43880E+00, 0.44089E+00, 0.44297E+00,&
      0.44505E+00, 0.44712E+00, 0.44919E+00, 0.45126E+00, 0.45332E+00/
                             
     DATA (BNC10M (IA),IA=301,400)/                                     &
      0.45539E+00, 0.45744E+00, 0.45950E+00, 0.46155E+00, 0.46360E+00,&
      0.46564E+00, 0.46768E+00, 0.46972E+00, 0.47175E+00, 0.47378E+00,&
      0.47581E+00, 0.47784E+00, 0.47986E+00, 0.48188E+00, 0.48389E+00,&
      0.48590E+00, 0.48791E+00, 0.48992E+00, 0.49192E+00, 0.49392E+00,&
      0.49591E+00, 0.49790E+00, 0.49989E+00, 0.50188E+00, 0.50386E+00,&
      0.50584E+00, 0.50782E+00, 0.50979E+00, 0.51176E+00, 0.51373E+00,&
      0.51569E+00, 0.51765E+00, 0.51961E+00, 0.52156E+00, 0.52352E+00,&
      0.52546E+00, 0.52741E+00, 0.52935E+00, 0.53129E+00, 0.53323E+00,&
      0.53516E+00, 0.53709E+00, 0.53901E+00, 0.54094E+00, 0.54286E+00,&
      0.54478E+00, 0.54669E+00, 0.54860E+00, 0.55051E+00, 0.55241E+00,&
      0.55432E+00, 0.55622E+00, 0.55811E+00, 0.56001E+00, 0.56190E+00,&
      0.56378E+00, 0.56567E+00, 0.56755E+00, 0.56943E+00, 0.57130E+00,&
      0.57318E+00, 0.57505E+00, 0.57691E+00, 0.57878E+00, 0.58064E+00,&
      0.58249E+00, 0.58435E+00, 0.58620E+00, 0.58805E+00, 0.58990E+00,&
      0.59174E+00, 0.59358E+00, 0.59542E+00, 0.59725E+00, 0.59909E+00,&
      0.60092E+00, 0.60274E+00, 0.60457E+00, 0.60639E+00, 0.60820E+00,&
      0.61002E+00, 0.61183E+00, 0.61364E+00, 0.61545E+00, 0.61725E+00,&
      0.61905E+00, 0.62085E+00, 0.62265E+00, 0.62444E+00, 0.62623E+00,&
      0.62802E+00, 0.62980E+00, 0.63158E+00, 0.63336E+00, 0.63514E+00,&
      0.63691E+00, 0.63868E+00, 0.64045E+00, 0.64222E+00, 0.64398E+00/
                             
     DATA (BNC10M (IA),IA=401,500)/                                     &
      0.64574E+00, 0.64750E+00, 0.64925E+00, 0.65100E+00, 0.65275E+00,&
      0.65450E+00, 0.65624E+00, 0.65798E+00, 0.65972E+00, 0.66146E+00,&
      0.66319E+00, 0.66492E+00, 0.66665E+00, 0.66838E+00, 0.67010E+00,&
      0.67182E+00, 0.67354E+00, 0.67526E+00, 0.67697E+00, 0.67868E+00,&
      0.68039E+00, 0.68209E+00, 0.68379E+00, 0.68549E+00, 0.68719E+00,&
      0.68889E+00, 0.69058E+00, 0.69227E+00, 0.69396E+00, 0.69564E+00,&
      0.69732E+00, 0.69900E+00, 0.70068E+00, 0.70236E+00, 0.70403E+00,&
      0.70570E+00, 0.70736E+00, 0.70903E+00, 0.71069E+00, 0.71235E+00,&
      0.71401E+00, 0.71567E+00, 0.71732E+00, 0.71897E+00, 0.72062E+00,&
      0.72226E+00, 0.72390E+00, 0.72555E+00, 0.72718E+00, 0.72882E+00,&
      0.73045E+00, 0.73208E+00, 0.73371E+00, 0.73534E+00, 0.73696E+00,&
      0.73858E+00, 0.74020E+00, 0.74182E+00, 0.74344E+00, 0.74505E+00,&
      0.74666E+00, 0.74826E+00, 0.74987E+00, 0.75147E+00, 0.75307E+00,&
      0.75467E+00, 0.75627E+00, 0.75786E+00, 0.75945E+00, 0.76104E+00,&
      0.76263E+00, 0.76421E+00, 0.76580E+00, 0.76738E+00, 0.76895E+00,&
      0.77053E+00, 0.77210E+00, 0.77367E+00, 0.77524E+00, 0.77681E+00,&
      0.77837E+00, 0.77993E+00, 0.78149E+00, 0.78305E+00, 0.78461E+00,&
      0.78616E+00, 0.78771E+00, 0.78926E+00, 0.79081E+00, 0.79235E+00,&
      0.79389E+00, 0.79543E+00, 0.79697E+00, 0.79851E+00, 0.80004E+00,&
      0.80157E+00, 0.80310E+00, 0.80463E+00, 0.80615E+00, 0.80768E+00/
                             
     DATA (BNC10M (IA),IA=501,600)/                                     &
      0.80920E+00, 0.81072E+00, 0.81223E+00, 0.81375E+00, 0.81526E+00,&
      0.81677E+00, 0.81828E+00, 0.81978E+00, 0.82129E+00, 0.82279E+00,&
      0.82429E+00, 0.82579E+00, 0.82728E+00, 0.82878E+00, 0.83027E+00,&
      0.83176E+00, 0.83324E+00, 0.83473E+00, 0.83621E+00, 0.83769E+00,&
      0.83917E+00, 0.84065E+00, 0.84213E+00, 0.84360E+00, 0.84507E+00,&
      0.84654E+00, 0.84801E+00, 0.84947E+00, 0.85093E+00, 0.85240E+00,&
      0.85385E+00, 0.85531E+00, 0.85677E+00, 0.85822E+00, 0.85967E+00,&
      0.86112E+00, 0.86257E+00, 0.86401E+00, 0.86546E+00, 0.86690E+00,&
      0.86834E+00, 0.86977E+00, 0.87121E+00, 0.87264E+00, 0.87408E+00,&
      0.87551E+00, 0.87693E+00, 0.87836E+00, 0.87978E+00, 0.88121E+00,&
      0.88263E+00, 0.88404E+00, 0.88546E+00, 0.88688E+00, 0.88829E+00,&
      0.88970E+00, 0.89111E+00, 0.89251E+00, 0.89392E+00, 0.89532E+00,&
      0.89672E+00, 0.89812E+00, 0.89952E+00, 0.90092E+00, 0.90231E+00,&
      0.90370E+00, 0.90510E+00, 0.90648E+00, 0.90787E+00, 0.90926E+00,&
      0.91064E+00, 0.91202E+00, 0.91340E+00, 0.91478E+00, 0.91615E+00,&
      0.91753E+00, 0.91890E+00, 0.92027E+00, 0.92164E+00, 0.92301E+00,&
      0.92437E+00, 0.92573E+00, 0.92710E+00, 0.92846E+00, 0.92981E+00,&
      0.93117E+00, 0.93252E+00, 0.93388E+00, 0.93523E+00, 0.93658E+00,&
      0.93793E+00, 0.93927E+00, 0.94062E+00, 0.94196E+00, 0.94330E+00,&
      0.94464E+00, 0.94598E+00, 0.94731E+00, 0.94864E+00, 0.95363E+00/
                             
     DATA (BNC10M (IA),IA=601,700)/                                     &
      0.96452E+00, 0.97756E+00, 0.99045E+00, 0.10032E+01, 0.10157E+01,&
      0.10282E+01, 0.10404E+01, 0.10525E+01, 0.10645E+01, 0.10763E+01,&
      0.10880E+01, 0.10996E+01, 0.11110E+01, 0.11223E+01, 0.11335E+01,&
      0.11445E+01, 0.11555E+01, 0.11663E+01, 0.11769E+01, 0.11875E+01,&
      0.11980E+01, 0.12083E+01, 0.12185E+01, 0.12287E+01, 0.12387E+01,&
      0.12486E+01, 0.12584E+01, 0.12681E+01, 0.12777E+01, 0.12872E+01,&
      0.12967E+01, 0.13060E+01, 0.13152E+01, 0.13244E+01, 0.13334E+01,&
      0.13424E+01, 0.13513E+01, 0.13601E+01, 0.13688E+01, 0.13774E+01,&
      0.13860E+01, 0.13944E+01, 0.14028E+01, 0.14111E+01, 0.14194E+01,&
      0.14275E+01, 0.14356E+01, 0.14437E+01, 0.14516E+01, 0.14595E+01,&
      0.14673E+01, 0.14750E+01, 0.14827E+01, 0.14903E+01, 0.14978E+01,&
      0.15053E+01, 0.15127E+01, 0.15201E+01, 0.15274E+01, 0.15346E+01,&
      0.15418E+01, 0.15489E+01, 0.15559E+01, 0.15629E+01, 0.15698E+01,&
      0.15767E+01, 0.15835E+01, 0.15903E+01, 0.15970E+01, 0.16037E+01,&
      0.16103E+01, 0.16168E+01, 0.16233E+01, 0.16298E+01, 0.16362E+01,&
      0.16425E+01, 0.16488E+01, 0.16551E+01, 0.16613E+01, 0.16675E+01,&
      0.16736E+01, 0.16797E+01, 0.16857E+01, 0.16917E+01, 0.16976E+01,&
      0.17035E+01, 0.17093E+01, 0.17152E+01, 0.17209E+01, 0.17266E+01,&
      0.17323E+01, 0.17380E+01, 0.17436E+01, 0.17491E+01, 0.17546E+01,&
      0.17601E+01, 0.17656E+01, 0.17710E+01, 0.17763E+01, 0.17817E+01/
                             
     DATA (BNC10M(IA),IA=701,741)/                                      &
      0.17870E+01, 0.17922E+01, 0.17975E+01, 0.18026E+01, 0.18078E+01,&
      0.18129E+01, 0.18180E+01, 0.18230E+01, 0.18281E+01, 0.18330E+01,&
      0.18380E+01, 0.18429E+01, 0.18478E+01, 0.18526E+01, 0.18575E+01,&
      0.18622E+01, 0.18670E+01, 0.18717E+01, 0.18764E+01, 0.18811E+01,&
      0.18857E+01, 0.18903E+01, 0.18949E+01, 0.18994E+01, 0.19040E+01,&
      0.19085E+01, 0.19129E+01, 0.19174E+01, 0.19218E+01, 0.19261E+01,&
      0.19305E+01, 0.19348E+01, 0.19391E+01, 0.19434E+01, 0.19476E+01,&
      0.19519E+01, 0.19560E+01, 0.19602E+01, 0.19644E+01, 0.19685E+01,&
      0.19726E+01                  /                      
!                            
!  ** (H, Cl)                
!                            
     DATA (BNC11M (IA),IA=  1,100)/                                     &
     -0.49531E-01,-0.84652E-01,-0.10547E+00,-0.11724E+00,-0.12469E+00,&
     -0.12951E+00,-0.13255E+00,-0.13431E+00,-0.13506E+00,-0.13503E+00,&
     -0.13435E+00,-0.13313E+00,-0.13145E+00,-0.12937E+00,-0.12694E+00,&
     -0.12420E+00,-0.12119E+00,-0.11793E+00,-0.11444E+00,-0.11075E+00,&
     -0.10687E+00,-0.10282E+00,-0.98618E-01,-0.94265E-01,-0.89778E-01,&
     -0.85165E-01,-0.80436E-01,-0.75599E-01,-0.70661E-01,-0.65628E-01,&
     -0.60508E-01,-0.55306E-01,-0.50028E-01,-0.44679E-01,-0.39262E-01,&
     -0.33784E-01,-0.28247E-01,-0.22657E-01,-0.17017E-01,-0.11329E-01,&
     -0.55978E-02, 0.17400E-03, 0.59837E-02, 0.11828E-01, 0.17706E-01,&
      0.23614E-01, 0.29550E-01, 0.35513E-01, 0.41500E-01, 0.47510E-01,&
      0.53542E-01, 0.59594E-01, 0.65665E-01, 0.71754E-01, 0.77861E-01,&
      0.83984E-01, 0.90123E-01, 0.96278E-01, 0.10245E+00, 0.10863E+00,&
      0.11483E+00, 0.12105E+00, 0.12728E+00, 0.13353E+00, 0.13979E+00,&
      0.14608E+00, 0.15237E+00, 0.15869E+00, 0.16503E+00, 0.17138E+00,&
      0.17776E+00, 0.18415E+00, 0.19058E+00, 0.19702E+00, 0.20349E+00,&
      0.20998E+00, 0.21650E+00, 0.22305E+00, 0.22962E+00, 0.23623E+00,&
      0.24286E+00, 0.24953E+00, 0.25623E+00, 0.26295E+00, 0.26972E+00,&
      0.27651E+00, 0.28334E+00, 0.29020E+00, 0.29709E+00, 0.30402E+00,&
      0.31098E+00, 0.31798E+00, 0.32500E+00, 0.33206E+00, 0.33916E+00,&
      0.34628E+00, 0.35343E+00, 0.36062E+00, 0.36783E+00, 0.37507E+00/
                             
     DATA (BNC11M (IA),IA=101,200)/                                     &
      0.38234E+00, 0.38964E+00, 0.39696E+00, 0.40431E+00, 0.41167E+00,&
      0.41906E+00, 0.42647E+00, 0.43390E+00, 0.44134E+00, 0.44880E+00,&
      0.45628E+00, 0.46377E+00, 0.47127E+00, 0.47879E+00, 0.48631E+00,&
      0.49384E+00, 0.50138E+00, 0.50893E+00, 0.51648E+00, 0.52403E+00,&
      0.53093E+00, 0.53856E+00, 0.54619E+00, 0.55382E+00, 0.56143E+00,&
      0.56904E+00, 0.57664E+00, 0.58424E+00, 0.59182E+00, 0.59940E+00,&
      0.60697E+00, 0.61453E+00, 0.62208E+00, 0.62962E+00, 0.63715E+00,&
      0.64467E+00, 0.65218E+00, 0.65969E+00, 0.66718E+00, 0.67466E+00,&
      0.68213E+00, 0.68959E+00, 0.69704E+00, 0.70448E+00, 0.71191E+00,&
      0.71933E+00, 0.72674E+00, 0.73413E+00, 0.74152E+00, 0.74889E+00,&
      0.75625E+00, 0.76360E+00, 0.77094E+00, 0.77826E+00, 0.78557E+00,&
      0.79288E+00, 0.80016E+00, 0.80744E+00, 0.81471E+00, 0.82196E+00,&
      0.82920E+00, 0.83642E+00, 0.84364E+00, 0.85084E+00, 0.85803E+00,&
      0.86520E+00, 0.87237E+00, 0.87952E+00, 0.88665E+00, 0.89378E+00,&
      0.90089E+00, 0.90799E+00, 0.91507E+00, 0.92215E+00, 0.92921E+00,&
      0.93625E+00, 0.94328E+00, 0.95030E+00, 0.95731E+00, 0.96430E+00,&
      0.97128E+00, 0.97825E+00, 0.98520E+00, 0.99214E+00, 0.99907E+00,&
      0.10060E+01, 0.10129E+01, 0.10198E+01, 0.10266E+01, 0.10335E+01,&
      0.10403E+01, 0.10472E+01, 0.10540E+01, 0.10608E+01, 0.10676E+01,&
      0.10744E+01, 0.10811E+01, 0.10879E+01, 0.10946E+01, 0.11014E+01/
                             
     DATA (BNC11M (IA),IA=201,300)/                                     &
      0.11081E+01, 0.11148E+01, 0.11214E+01, 0.11281E+01, 0.11348E+01,&
      0.11414E+01, 0.11481E+01, 0.11547E+01, 0.11613E+01, 0.11679E+01,&
      0.11745E+01, 0.11810E+01, 0.11876E+01, 0.11941E+01, 0.12006E+01,&
      0.12071E+01, 0.12136E+01, 0.12201E+01, 0.12266E+01, 0.12331E+01,&
      0.12395E+01, 0.12460E+01, 0.12524E+01, 0.12588E+01, 0.12652E+01,&
      0.12716E+01, 0.12779E+01, 0.12843E+01, 0.12906E+01, 0.12970E+01,&
      0.13033E+01, 0.13096E+01, 0.13159E+01, 0.13222E+01, 0.13284E+01,&
      0.13347E+01, 0.13409E+01, 0.13472E+01, 0.13534E+01, 0.13596E+01,&
      0.13658E+01, 0.13720E+01, 0.13781E+01, 0.13843E+01, 0.13904E+01,&
      0.13966E+01, 0.14027E+01, 0.14088E+01, 0.14149E+01, 0.14210E+01,&
      0.14270E+01, 0.14331E+01, 0.14391E+01, 0.14452E+01, 0.14512E+01,&
      0.14572E+01, 0.14632E+01, 0.14692E+01, 0.14751E+01, 0.14811E+01,&
      0.14871E+01, 0.14930E+01, 0.14989E+01, 0.15048E+01, 0.15107E+01,&
      0.15166E+01, 0.15225E+01, 0.15284E+01, 0.15342E+01, 0.15401E+01,&
      0.15459E+01, 0.15517E+01, 0.15575E+01, 0.15633E+01, 0.15691E+01,&
      0.15749E+01, 0.15807E+01, 0.15864E+01, 0.15922E+01, 0.15979E+01,&
      0.16036E+01, 0.16093E+01, 0.16150E+01, 0.16207E+01, 0.16264E+01,&
      0.16320E+01, 0.16377E+01, 0.16433E+01, 0.16490E+01, 0.16546E+01,&
      0.16602E+01, 0.16658E+01, 0.16714E+01, 0.16770E+01, 0.16825E+01,&
      0.16881E+01, 0.16936E+01, 0.16992E+01, 0.17047E+01, 0.17102E+01/
                             
     DATA (BNC11M (IA),IA=301,400)/                                     &
      0.17157E+01, 0.17212E+01, 0.17267E+01, 0.17321E+01, 0.17376E+01,&
      0.17431E+01, 0.17485E+01, 0.17539E+01, 0.17593E+01, 0.17648E+01,&
      0.17702E+01, 0.17755E+01, 0.17809E+01, 0.17863E+01, 0.17917E+01,&
      0.17970E+01, 0.18023E+01, 0.18077E+01, 0.18130E+01, 0.18183E+01,&
      0.18236E+01, 0.18289E+01, 0.18342E+01, 0.18394E+01, 0.18447E+01,&
      0.18500E+01, 0.18552E+01, 0.18604E+01, 0.18656E+01, 0.18709E+01,&
      0.18761E+01, 0.18813E+01, 0.18864E+01, 0.18916E+01, 0.18968E+01,&
      0.19019E+01, 0.19071E+01, 0.19122E+01, 0.19173E+01, 0.19225E+01,&
      0.19276E+01, 0.19327E+01, 0.19378E+01, 0.19428E+01, 0.19479E+01,&
      0.19530E+01, 0.19580E+01, 0.19631E+01, 0.19681E+01, 0.19731E+01,&
      0.19782E+01, 0.19832E+01, 0.19882E+01, 0.19932E+01, 0.19981E+01,&
      0.20031E+01, 0.20081E+01, 0.20130E+01, 0.20180E+01, 0.20229E+01,&
      0.20278E+01, 0.20328E+01, 0.20377E+01, 0.20426E+01, 0.20475E+01,&
      0.20524E+01, 0.20572E+01, 0.20621E+01, 0.20670E+01, 0.20718E+01,&
      0.20767E+01, 0.20815E+01, 0.20863E+01, 0.20912E+01, 0.20960E+01,&
      0.21008E+01, 0.21056E+01, 0.21104E+01, 0.21151E+01, 0.21199E+01,&
      0.21247E+01, 0.21294E+01, 0.21342E+01, 0.21389E+01, 0.21436E+01,&
      0.21483E+01, 0.21531E+01, 0.21578E+01, 0.21625E+01, 0.21672E+01,&
      0.21718E+01, 0.21765E+01, 0.21812E+01, 0.21858E+01, 0.21905E+01,&
      0.21951E+01, 0.21998E+01, 0.22044E+01, 0.22090E+01, 0.22136E+01/
                             
     DATA (BNC11M (IA),IA=401,500)/                                     &
      0.22182E+01, 0.22228E+01, 0.22274E+01, 0.22320E+01, 0.22366E+01,&
      0.22411E+01, 0.22457E+01, 0.22502E+01, 0.22548E+01, 0.22593E+01,&
      0.22638E+01, 0.22684E+01, 0.22729E+01, 0.22774E+01, 0.22819E+01,&
      0.22864E+01, 0.22908E+01, 0.22953E+01, 0.22998E+01, 0.23043E+01,&
      0.23087E+01, 0.23132E+01, 0.23176E+01, 0.23220E+01, 0.23265E+01,&
      0.23309E+01, 0.23353E+01, 0.23397E+01, 0.23441E+01, 0.23485E+01,&
      0.23529E+01, 0.23572E+01, 0.23616E+01, 0.23660E+01, 0.23703E+01,&
      0.23747E+01, 0.23790E+01, 0.23834E+01, 0.23877E+01, 0.23920E+01,&
      0.23963E+01, 0.24006E+01, 0.24049E+01, 0.24092E+01, 0.24135E+01,&
      0.24178E+01, 0.24221E+01, 0.24263E+01, 0.24306E+01, 0.24349E+01,&
      0.24391E+01, 0.24434E+01, 0.24476E+01, 0.24518E+01, 0.24560E+01,&
      0.24603E+01, 0.24645E+01, 0.24687E+01, 0.24729E+01, 0.24770E+01,&
      0.24812E+01, 0.24854E+01, 0.24896E+01, 0.24937E+01, 0.24979E+01,&
      0.25021E+01, 0.25062E+01, 0.25103E+01, 0.25145E+01, 0.25186E+01,&
      0.25227E+01, 0.25268E+01, 0.25309E+01, 0.25350E+01, 0.25391E+01,&
      0.25432E+01, 0.25473E+01, 0.25514E+01, 0.25554E+01, 0.25595E+01,&
      0.25636E+01, 0.25676E+01, 0.25717E+01, 0.25757E+01, 0.25797E+01,&
      0.25838E+01, 0.25878E+01, 0.25918E+01, 0.25958E+01, 0.25998E+01,&
      0.26038E+01, 0.26078E+01, 0.26118E+01, 0.26158E+01, 0.26198E+01,&
      0.26237E+01, 0.26277E+01, 0.26317E+01, 0.26356E+01, 0.26396E+01/
                             
     DATA (BNC11M (IA),IA=501,600)/                                     &
      0.26435E+01, 0.26474E+01, 0.26514E+01, 0.26553E+01, 0.26592E+01,&
      0.26631E+01, 0.26670E+01, 0.26709E+01, 0.26748E+01, 0.26787E+01,&
      0.26826E+01, 0.26865E+01, 0.26903E+01, 0.26942E+01, 0.26981E+01,&
      0.27019E+01, 0.27058E+01, 0.27096E+01, 0.27135E+01, 0.27173E+01,&
      0.27211E+01, 0.27249E+01, 0.27288E+01, 0.27326E+01, 0.27364E+01,&
      0.27402E+01, 0.27440E+01, 0.27478E+01, 0.27516E+01, 0.27553E+01,&
      0.27591E+01, 0.27629E+01, 0.27667E+01, 0.27704E+01, 0.27742E+01,&
      0.27779E+01, 0.27817E+01, 0.27854E+01, 0.27891E+01, 0.27929E+01,&
      0.27966E+01, 0.28003E+01, 0.28040E+01, 0.28077E+01, 0.28114E+01,&
      0.28151E+01, 0.28188E+01, 0.28225E+01, 0.28262E+01, 0.28299E+01,&
      0.28335E+01, 0.28372E+01, 0.28409E+01, 0.28445E+01, 0.28482E+01,&
      0.28518E+01, 0.28555E+01, 0.28591E+01, 0.28627E+01, 0.28664E+01,&
      0.28700E+01, 0.28736E+01, 0.28772E+01, 0.28808E+01, 0.28844E+01,&
      0.28880E+01, 0.28916E+01, 0.28952E+01, 0.28988E+01, 0.29024E+01,&
      0.29060E+01, 0.29095E+01, 0.29131E+01, 0.29167E+01, 0.29202E+01,&
      0.29238E+01, 0.29273E+01, 0.29309E+01, 0.29344E+01, 0.29379E+01,&
      0.29415E+01, 0.29450E+01, 0.29485E+01, 0.29520E+01, 0.29555E+01,&
      0.29590E+01, 0.29625E+01, 0.29660E+01, 0.29695E+01, 0.29730E+01,&
      0.29765E+01, 0.29800E+01, 0.29834E+01, 0.29869E+01, 0.29904E+01,&
      0.29938E+01, 0.29973E+01, 0.30007E+01, 0.30042E+01, 0.30171E+01/
                             
     DATA (BNC11M (IA),IA=601,700)/                                     &
      0.30452E+01, 0.30789E+01, 0.31122E+01, 0.31450E+01, 0.31775E+01,&
      0.32096E+01, 0.32413E+01, 0.32726E+01, 0.33035E+01, 0.33341E+01,&
      0.33644E+01, 0.33943E+01, 0.34238E+01, 0.34531E+01, 0.34820E+01,&
      0.35106E+01, 0.35389E+01, 0.35668E+01, 0.35945E+01, 0.36219E+01,&
      0.36490E+01, 0.36759E+01, 0.37024E+01, 0.37287E+01, 0.37548E+01,&
      0.37805E+01, 0.38061E+01, 0.38313E+01, 0.38564E+01, 0.38811E+01,&
      0.39057E+01, 0.39300E+01, 0.39541E+01, 0.39780E+01, 0.40016E+01,&
      0.40250E+01, 0.40483E+01, 0.40713E+01, 0.40941E+01, 0.41167E+01,&
      0.41391E+01, 0.41613E+01, 0.41833E+01, 0.42051E+01, 0.42268E+01,&
      0.42482E+01, 0.42695E+01, 0.42906E+01, 0.43116E+01, 0.43323E+01,&
      0.43529E+01, 0.43733E+01, 0.43936E+01, 0.44137E+01, 0.44336E+01,&
      0.44534E+01, 0.44730E+01, 0.44925E+01, 0.45118E+01, 0.45310E+01,&
      0.45500E+01, 0.45689E+01, 0.45877E+01, 0.46063E+01, 0.46247E+01,&
      0.46431E+01, 0.46613E+01, 0.46793E+01, 0.46973E+01, 0.47151E+01,&
      0.47327E+01, 0.47503E+01, 0.47677E+01, 0.47850E+01, 0.48022E+01,&
      0.48193E+01, 0.48362E+01, 0.48530E+01, 0.48698E+01, 0.48864E+01,&
      0.49029E+01, 0.49192E+01, 0.49355E+01, 0.49517E+01, 0.49677E+01,&
      0.49837E+01, 0.49995E+01, 0.50153E+01, 0.50309E+01, 0.50465E+01,&
      0.50619E+01, 0.50773E+01, 0.50925E+01, 0.51077E+01, 0.51227E+01,&
      0.51377E+01, 0.51526E+01, 0.51673E+01, 0.51820E+01, 0.51966E+01/
                             
     DATA (BNC11M(IA),IA=701,741)/                                      &
      0.52112E+01, 0.52256E+01, 0.52399E+01, 0.52542E+01, 0.52683E+01,&
      0.52824E+01, 0.52964E+01, 0.53104E+01, 0.53242E+01, 0.53380E+01,&
      0.53516E+01, 0.53652E+01, 0.53788E+01, 0.53922E+01, 0.54056E+01,&
      0.54189E+01, 0.54321E+01, 0.54453E+01, 0.54583E+01, 0.54713E+01,&
      0.54843E+01, 0.54971E+01, 0.55099E+01, 0.55226E+01, 0.55353E+01,&
      0.55479E+01, 0.55604E+01, 0.55729E+01, 0.55852E+01, 0.55976E+01,&
      0.56098E+01, 0.56220E+01, 0.56341E+01, 0.56462E+01, 0.56582E+01,&
      0.56701E+01, 0.56820E+01, 0.56938E+01, 0.57056E+01, 0.57173E+01,&
      0.57289E+01                 /                      
!                            
!  ** NaHSO4                 
!                            
     DATA (BNC12M (IA),IA=  1,100)/                                     &
     -0.50782E-01,-0.89259E-01,-0.11419E+00,-0.12989E+00,-0.14113E+00,&
     -0.14967E+00,-0.15637E+00,-0.16174E+00,-0.16609E+00,-0.16962E+00,&
     -0.17248E+00,-0.17478E+00,-0.17660E+00,-0.17801E+00,-0.17906E+00,&
     -0.17979E+00,-0.18023E+00,-0.18040E+00,-0.18034E+00,-0.18006E+00,&
     -0.17958E+00,-0.17891E+00,-0.17806E+00,-0.17706E+00,-0.17590E+00,&
     -0.17460E+00,-0.17317E+00,-0.17160E+00,-0.16992E+00,-0.16812E+00,&
     -0.16621E+00,-0.16420E+00,-0.16208E+00,-0.15987E+00,-0.15758E+00,&
     -0.15519E+00,-0.15272E+00,-0.15017E+00,-0.14755E+00,-0.14485E+00,&
     -0.14209E+00,-0.13925E+00,-0.13636E+00,-0.13340E+00,-0.13038E+00,&
     -0.12731E+00,-0.12418E+00,-0.12100E+00,-0.11777E+00,-0.11449E+00,&
     -0.11116E+00,-0.10779E+00,-0.10438E+00,-0.10093E+00,-0.97430E-01,&
     -0.93896E-01,-0.90324E-01,-0.86716E-01,-0.83072E-01,-0.79393E-01,&
     -0.75680E-01,-0.71935E-01,-0.68156E-01,-0.64346E-01,-0.60504E-01,&
     -0.56631E-01,-0.52728E-01,-0.48793E-01,-0.44829E-01,-0.40834E-01,&
     -0.36810E-01,-0.32755E-01,-0.28670E-01,-0.24555E-01,-0.20411E-01,&
     -0.16235E-01,-0.12030E-01,-0.77941E-02,-0.35277E-02, 0.76915E-03,&
      0.50967E-02, 0.94548E-02, 0.13844E-01, 0.18263E-01, 0.22713E-01,&
      0.27194E-01, 0.31705E-01, 0.36246E-01, 0.40817E-01, 0.45417E-01,&
      0.50047E-01, 0.54705E-01, 0.59392E-01, 0.64106E-01, 0.68847E-01,&
      0.73615E-01, 0.78408E-01, 0.83227E-01, 0.88069E-01, 0.92934E-01/
                             
     DATA (BNC12M (IA),IA=101,200)/                                     &
      0.97821E-01, 0.10273E+00, 0.10766E+00, 0.11261E+00, 0.11757E+00,&
      0.12256E+00, 0.12756E+00, 0.13257E+00, 0.13760E+00, 0.14264E+00,&
      0.14770E+00, 0.15276E+00, 0.15784E+00, 0.16292E+00, 0.16801E+00,&
      0.17311E+00, 0.17821E+00, 0.18332E+00, 0.18843E+00, 0.19355E+00,&
      0.19820E+00, 0.20337E+00, 0.20854E+00, 0.21370E+00, 0.21886E+00,&
      0.22401E+00, 0.22916E+00, 0.23430E+00, 0.23944E+00, 0.24457E+00,&
      0.24969E+00, 0.25481E+00, 0.25992E+00, 0.26502E+00, 0.27012E+00,&
      0.27521E+00, 0.28029E+00, 0.28536E+00, 0.29043E+00, 0.29548E+00,&
      0.30053E+00, 0.30558E+00, 0.31061E+00, 0.31563E+00, 0.32065E+00,&
      0.32566E+00, 0.33066E+00, 0.33565E+00, 0.34063E+00, 0.34560E+00,&
      0.35057E+00, 0.35552E+00, 0.36047E+00, 0.36541E+00, 0.37033E+00,&
      0.37525E+00, 0.38016E+00, 0.38506E+00, 0.38995E+00, 0.39483E+00,&
      0.39971E+00, 0.40457E+00, 0.40942E+00, 0.41426E+00, 0.41910E+00,&
      0.42392E+00, 0.42873E+00, 0.43354E+00, 0.43833E+00, 0.44312E+00,&
      0.44789E+00, 0.45266E+00, 0.45742E+00, 0.46216E+00, 0.46690E+00,&
      0.47163E+00, 0.47634E+00, 0.48105E+00, 0.48575E+00, 0.49043E+00,&
      0.49511E+00, 0.49978E+00, 0.50444E+00, 0.50909E+00, 0.51373E+00,&
      0.51836E+00, 0.52298E+00, 0.52759E+00, 0.53219E+00, 0.53678E+00,&
      0.54136E+00, 0.54593E+00, 0.55049E+00, 0.55504E+00, 0.55959E+00,&
      0.56412E+00, 0.56864E+00, 0.57316E+00, 0.57766E+00, 0.58216E+00/
                             
     DATA (BNC12M (IA),IA=201,300)/                                     &
      0.58664E+00, 0.59112E+00, 0.59558E+00, 0.60004E+00, 0.60449E+00,&
      0.60893E+00, 0.61336E+00, 0.61778E+00, 0.62219E+00, 0.62659E+00,&
      0.63098E+00, 0.63536E+00, 0.63973E+00, 0.64410E+00, 0.64845E+00,&
      0.65280E+00, 0.65714E+00, 0.66146E+00, 0.66578E+00, 0.67009E+00,&
      0.67439E+00, 0.67869E+00, 0.68297E+00, 0.68724E+00, 0.69151E+00,&
      0.69576E+00, 0.70001E+00, 0.70425E+00, 0.70848E+00, 0.71270E+00,&
      0.71691E+00, 0.72111E+00, 0.72531E+00, 0.72950E+00, 0.73367E+00,&
      0.73784E+00, 0.74200E+00, 0.74616E+00, 0.75030E+00, 0.75443E+00,&
      0.75856E+00, 0.76268E+00, 0.76679E+00, 0.77089E+00, 0.77498E+00,&
      0.77907E+00, 0.78314E+00, 0.78721E+00, 0.79127E+00, 0.79532E+00,&
      0.79937E+00, 0.80340E+00, 0.80743E+00, 0.81145E+00, 0.81546E+00,&
      0.81946E+00, 0.82346E+00, 0.82745E+00, 0.83143E+00, 0.83540E+00,&
      0.83936E+00, 0.84332E+00, 0.84726E+00, 0.85120E+00, 0.85514E+00,&
      0.85906E+00, 0.86298E+00, 0.86689E+00, 0.87079E+00, 0.87468E+00,&
      0.87857E+00, 0.88245E+00, 0.88632E+00, 0.89018E+00, 0.89404E+00,&
      0.89788E+00, 0.90173E+00, 0.90556E+00, 0.90939E+00, 0.91320E+00,&
      0.91702E+00, 0.92082E+00, 0.92462E+00, 0.92840E+00, 0.93219E+00,&
      0.93596E+00, 0.93973E+00, 0.94349E+00, 0.94724E+00, 0.95099E+00,&
      0.95473E+00, 0.95846E+00, 0.96219E+00, 0.96590E+00, 0.96961E+00,&
      0.97332E+00, 0.97702E+00, 0.98071E+00, 0.98439E+00, 0.98807E+00/
                             
     DATA (BNC12M (IA),IA=301,400)/                                     &
      0.99173E+00, 0.99540E+00, 0.99905E+00, 0.10027E+01, 0.10063E+01,&
      0.10100E+01, 0.10136E+01, 0.10172E+01, 0.10208E+01, 0.10245E+01,&
      0.10281E+01, 0.10316E+01, 0.10352E+01, 0.10388E+01, 0.10424E+01,&
      0.10460E+01, 0.10495E+01, 0.10531E+01, 0.10566E+01, 0.10602E+01,&
      0.10637E+01, 0.10672E+01, 0.10708E+01, 0.10743E+01, 0.10778E+01,&
      0.10813E+01, 0.10848E+01, 0.10883E+01, 0.10918E+01, 0.10953E+01,&
      0.10987E+01, 0.11022E+01, 0.11057E+01, 0.11091E+01, 0.11126E+01,&
      0.11160E+01, 0.11194E+01, 0.11229E+01, 0.11263E+01, 0.11297E+01,&
      0.11331E+01, 0.11365E+01, 0.11399E+01, 0.11433E+01, 0.11467E+01,&
      0.11501E+01, 0.11535E+01, 0.11569E+01, 0.11602E+01, 0.11636E+01,&
      0.11669E+01, 0.11703E+01, 0.11736E+01, 0.11770E+01, 0.11803E+01,&
      0.11836E+01, 0.11869E+01, 0.11902E+01, 0.11935E+01, 0.11969E+01,&
      0.12001E+01, 0.12034E+01, 0.12067E+01, 0.12100E+01, 0.12133E+01,&
      0.12165E+01, 0.12198E+01, 0.12231E+01, 0.12263E+01, 0.12296E+01,&
      0.12328E+01, 0.12360E+01, 0.12393E+01, 0.12425E+01, 0.12457E+01,&
      0.12489E+01, 0.12521E+01, 0.12553E+01, 0.12585E+01, 0.12617E+01,&
      0.12649E+01, 0.12681E+01, 0.12713E+01, 0.12744E+01, 0.12776E+01,&
      0.12808E+01, 0.12839E+01, 0.12871E+01, 0.12902E+01, 0.12934E+01,&
      0.12965E+01, 0.12996E+01, 0.13028E+01, 0.13059E+01, 0.13090E+01,&
      0.13121E+01, 0.13152E+01, 0.13183E+01, 0.13214E+01, 0.13245E+01/
                             
     DATA (BNC12M (IA),IA=401,500)/                                     &
      0.13276E+01, 0.13307E+01, 0.13337E+01, 0.13368E+01, 0.13399E+01,&
      0.13429E+01, 0.13460E+01, 0.13490E+01, 0.13521E+01, 0.13551E+01,&
      0.13581E+01, 0.13612E+01, 0.13642E+01, 0.13672E+01, 0.13702E+01,&
      0.13733E+01, 0.13763E+01, 0.13793E+01, 0.13823E+01, 0.13853E+01,&
      0.13882E+01, 0.13912E+01, 0.13942E+01, 0.13972E+01, 0.14001E+01,&
      0.14031E+01, 0.14061E+01, 0.14090E+01, 0.14120E+01, 0.14149E+01,&
      0.14179E+01, 0.14208E+01, 0.14237E+01, 0.14267E+01, 0.14296E+01,&
      0.14325E+01, 0.14354E+01, 0.14383E+01, 0.14412E+01, 0.14441E+01,&
      0.14470E+01, 0.14499E+01, 0.14528E+01, 0.14557E+01, 0.14586E+01,&
      0.14614E+01, 0.14643E+01, 0.14672E+01, 0.14700E+01, 0.14729E+01,&
      0.14758E+01, 0.14786E+01, 0.14815E+01, 0.14843E+01, 0.14871E+01,&
      0.14900E+01, 0.14928E+01, 0.14956E+01, 0.14984E+01, 0.15012E+01,&
      0.15041E+01, 0.15069E+01, 0.15097E+01, 0.15125E+01, 0.15153E+01,&
      0.15180E+01, 0.15208E+01, 0.15236E+01, 0.15264E+01, 0.15292E+01,&
      0.15319E+01, 0.15347E+01, 0.15375E+01, 0.15402E+01, 0.15430E+01,&
      0.15457E+01, 0.15485E+01, 0.15512E+01, 0.15539E+01, 0.15567E+01,&
      0.15594E+01, 0.15621E+01, 0.15648E+01, 0.15676E+01, 0.15703E+01,&
      0.15730E+01, 0.15757E+01, 0.15784E+01, 0.15811E+01, 0.15838E+01,&
      0.15865E+01, 0.15892E+01, 0.15918E+01, 0.15945E+01, 0.15972E+01,&
      0.15999E+01, 0.16025E+01, 0.16052E+01, 0.16079E+01, 0.16105E+01/
                             
     DATA (BNC12M (IA),IA=501,600)/                                     &
      0.16132E+01, 0.16158E+01, 0.16185E+01, 0.16211E+01, 0.16237E+01,&
      0.16264E+01, 0.16290E+01, 0.16316E+01, 0.16342E+01, 0.16369E+01,&
      0.16395E+01, 0.16421E+01, 0.16447E+01, 0.16473E+01, 0.16499E+01,&
      0.16525E+01, 0.16551E+01, 0.16577E+01, 0.16603E+01, 0.16628E+01,&
      0.16654E+01, 0.16680E+01, 0.16706E+01, 0.16731E+01, 0.16757E+01,&
      0.16783E+01, 0.16808E+01, 0.16834E+01, 0.16859E+01, 0.16885E+01,&
      0.16910E+01, 0.16935E+01, 0.16961E+01, 0.16986E+01, 0.17011E+01,&
      0.17037E+01, 0.17062E+01, 0.17087E+01, 0.17112E+01, 0.17137E+01,&
      0.17162E+01, 0.17188E+01, 0.17213E+01, 0.17238E+01, 0.17263E+01,&
      0.17287E+01, 0.17312E+01, 0.17337E+01, 0.17362E+01, 0.17387E+01,&
      0.17412E+01, 0.17436E+01, 0.17461E+01, 0.17486E+01, 0.17510E+01,&
      0.17535E+01, 0.17559E+01, 0.17584E+01, 0.17608E+01, 0.17633E+01,&
      0.17657E+01, 0.17682E+01, 0.17706E+01, 0.17730E+01, 0.17755E+01,&
      0.17779E+01, 0.17803E+01, 0.17827E+01, 0.17851E+01, 0.17876E+01,&
      0.17900E+01, 0.17924E+01, 0.17948E+01, 0.17972E+01, 0.17996E+01,&
      0.18020E+01, 0.18044E+01, 0.18068E+01, 0.18091E+01, 0.18115E+01,&
      0.18139E+01, 0.18163E+01, 0.18187E+01, 0.18210E+01, 0.18234E+01,&
      0.18258E+01, 0.18281E+01, 0.18305E+01, 0.18328E+01, 0.18352E+01,&
      0.18375E+01, 0.18399E+01, 0.18422E+01, 0.18446E+01, 0.18469E+01,&
      0.18492E+01, 0.18516E+01, 0.18539E+01, 0.18562E+01, 0.18649E+01/
                             
     DATA (BNC12M (IA),IA=601,700)/                                     &
      0.18839E+01, 0.19066E+01, 0.19291E+01, 0.19513E+01, 0.19732E+01,&
      0.19949E+01, 0.20163E+01, 0.20374E+01, 0.20583E+01, 0.20790E+01,&
      0.20994E+01, 0.21196E+01, 0.21396E+01, 0.21594E+01, 0.21789E+01,&
      0.21982E+01, 0.22174E+01, 0.22363E+01, 0.22550E+01, 0.22735E+01,&
      0.22918E+01, 0.23100E+01, 0.23279E+01, 0.23457E+01, 0.23633E+01,&
      0.23807E+01, 0.23979E+01, 0.24150E+01, 0.24319E+01, 0.24487E+01,&
      0.24653E+01, 0.24817E+01, 0.24980E+01, 0.25141E+01, 0.25301E+01,&
      0.25459E+01, 0.25616E+01, 0.25771E+01, 0.25925E+01, 0.26078E+01,&
      0.26229E+01, 0.26379E+01, 0.26527E+01, 0.26675E+01, 0.26821E+01,&
      0.26965E+01, 0.27109E+01, 0.27251E+01, 0.27393E+01, 0.27532E+01,&
      0.27671E+01, 0.27809E+01, 0.27945E+01, 0.28081E+01, 0.28215E+01,&
      0.28349E+01, 0.28481E+01, 0.28612E+01, 0.28742E+01, 0.28871E+01,&
      0.28999E+01, 0.29126E+01, 0.29252E+01, 0.29378E+01, 0.29502E+01,&
      0.29625E+01, 0.29747E+01, 0.29869E+01, 0.29989E+01, 0.30109E+01,&
      0.30228E+01, 0.30346E+01, 0.30463E+01, 0.30579E+01, 0.30694E+01,&
      0.30809E+01, 0.30923E+01, 0.31036E+01, 0.31148E+01, 0.31259E+01,&
      0.31370E+01, 0.31480E+01, 0.31589E+01, 0.31697E+01, 0.31805E+01,&
      0.31912E+01, 0.32018E+01, 0.32123E+01, 0.32228E+01, 0.32332E+01,&
      0.32436E+01, 0.32538E+01, 0.32640E+01, 0.32742E+01, 0.32842E+01,&
      0.32943E+01, 0.33042E+01, 0.33141E+01, 0.33239E+01, 0.33336E+01/
                             
     DATA (BNC12M(IA),IA=701,741)/                                      &
      0.33433E+01, 0.33530E+01, 0.33626E+01, 0.33721E+01, 0.33815E+01,&
      0.33909E+01, 0.34003E+01, 0.34095E+01, 0.34188E+01, 0.34279E+01,&
      0.34371E+01, 0.34461E+01, 0.34551E+01, 0.34641E+01, 0.34730E+01,&
      0.34819E+01, 0.34907E+01, 0.34994E+01, 0.35081E+01, 0.35167E+01,&
      0.35253E+01, 0.35339E+01, 0.35424E+01, 0.35508E+01, 0.35592E+01,&
      0.35676E+01, 0.35759E+01, 0.35842E+01, 0.35924E+01, 0.36006E+01,&
      0.36087E+01, 0.36168E+01, 0.36248E+01, 0.36328E+01, 0.36408E+01,&
      0.36487E+01, 0.36565E+01, 0.36644E+01, 0.36721E+01, 0.36799E+01,&
      0.36876E+01                  /                      
!                            
!  ** (NH4)3H(SO4)2          
!                            
     DATA (BNC13M (IA),IA=  1,100)/                                     &
     -0.84167E-01,-0.15304E+00,-0.20142E+00,-0.23431E+00,-0.25963E+00,&
     -0.28033E+00,-0.29790E+00,-0.31317E+00,-0.32669E+00,-0.33881E+00,&
     -0.34980E+00,-0.35984E+00,-0.36908E+00,-0.37764E+00,-0.38559E+00,&
     -0.39302E+00,-0.39999E+00,-0.40654E+00,-0.41272E+00,-0.41855E+00,&
     -0.42408E+00,-0.42933E+00,-0.43431E+00,-0.43905E+00,-0.44357E+00,&
     -0.44789E+00,-0.45200E+00,-0.45594E+00,-0.45971E+00,-0.46332E+00,&
     -0.46677E+00,-0.47008E+00,-0.47326E+00,-0.47631E+00,-0.47923E+00,&
     -0.48204E+00,-0.48474E+00,-0.48734E+00,-0.48983E+00,-0.49223E+00,&
     -0.49453E+00,-0.49675E+00,-0.49888E+00,-0.50093E+00,-0.50290E+00,&
     -0.50480E+00,-0.50662E+00,-0.50838E+00,-0.51007E+00,-0.51169E+00,&
     -0.51325E+00,-0.51476E+00,-0.51620E+00,-0.51759E+00,-0.51893E+00,&
     -0.52021E+00,-0.52145E+00,-0.52263E+00,-0.52378E+00,-0.52487E+00,&
     -0.52592E+00,-0.52693E+00,-0.52790E+00,-0.52883E+00,-0.52972E+00,&
     -0.53058E+00,-0.53139E+00,-0.53218E+00,-0.53292E+00,-0.53364E+00,&
     -0.53432E+00,-0.53498E+00,-0.53560E+00,-0.53619E+00,-0.53675E+00,&
     -0.53729E+00,-0.53780E+00,-0.53828E+00,-0.53873E+00,-0.53916E+00,&
     -0.53956E+00,-0.53994E+00,-0.54030E+00,-0.54063E+00,-0.54094E+00,&
     -0.54122E+00,-0.54148E+00,-0.54173E+00,-0.54195E+00,-0.54215E+00,&
     -0.54232E+00,-0.54248E+00,-0.54262E+00,-0.54275E+00,-0.54285E+00,&
     -0.54293E+00,-0.54300E+00,-0.54305E+00,-0.54308E+00,-0.54310E+00/
                             
     DATA (BNC13M (IA),IA=101,200)/                                     &
     -0.54310E+00,-0.54309E+00,-0.54306E+00,-0.54302E+00,-0.54296E+00,&
     -0.54289E+00,-0.54281E+00,-0.54272E+00,-0.54261E+00,-0.54249E+00,&
     -0.54236E+00,-0.54222E+00,-0.54207E+00,-0.54191E+00,-0.54174E+00,&
     -0.54156E+00,-0.54137E+00,-0.54117E+00,-0.54097E+00,-0.54075E+00,&
     -0.54062E+00,-0.54039E+00,-0.54014E+00,-0.53989E+00,-0.53964E+00,&
     -0.53937E+00,-0.53911E+00,-0.53884E+00,-0.53856E+00,-0.53828E+00,&
     -0.53800E+00,-0.53771E+00,-0.53742E+00,-0.53712E+00,-0.53682E+00,&
     -0.53652E+00,-0.53621E+00,-0.53590E+00,-0.53559E+00,-0.53527E+00,&
     -0.53495E+00,-0.53463E+00,-0.53430E+00,-0.53397E+00,-0.53364E+00,&
     -0.53331E+00,-0.53297E+00,-0.53264E+00,-0.53230E+00,-0.53195E+00,&
     -0.53161E+00,-0.53126E+00,-0.53092E+00,-0.53057E+00,-0.53022E+00,&
     -0.52986E+00,-0.52951E+00,-0.52915E+00,-0.52879E+00,-0.52844E+00,&
     -0.52808E+00,-0.52771E+00,-0.52735E+00,-0.52699E+00,-0.52662E+00,&
     -0.52626E+00,-0.52589E+00,-0.52552E+00,-0.52515E+00,-0.52479E+00,&
     -0.52442E+00,-0.52404E+00,-0.52367E+00,-0.52330E+00,-0.52293E+00,&
     -0.52255E+00,-0.52218E+00,-0.52181E+00,-0.52143E+00,-0.52106E+00,&
     -0.52068E+00,-0.52030E+00,-0.51993E+00,-0.51955E+00,-0.51918E+00,&
     -0.51880E+00,-0.51842E+00,-0.51804E+00,-0.51767E+00,-0.51729E+00,&
     -0.51691E+00,-0.51653E+00,-0.51615E+00,-0.51577E+00,-0.51540E+00,&
     -0.51502E+00,-0.51464E+00,-0.51426E+00,-0.51388E+00,-0.51351E+00/
                             
     DATA (BNC13M (IA),IA=201,300)/                                     &
     -0.51313E+00,-0.51275E+00,-0.51237E+00,-0.51199E+00,-0.51162E+00,&
     -0.51124E+00,-0.51086E+00,-0.51049E+00,-0.51011E+00,-0.50973E+00,&
     -0.50936E+00,-0.50898E+00,-0.50860E+00,-0.50823E+00,-0.50785E+00,&
     -0.50748E+00,-0.50710E+00,-0.50673E+00,-0.50636E+00,-0.50598E+00,&
     -0.50561E+00,-0.50524E+00,-0.50486E+00,-0.50449E+00,-0.50412E+00,&
     -0.50375E+00,-0.50338E+00,-0.50301E+00,-0.50264E+00,-0.50227E+00,&
     -0.50190E+00,-0.50153E+00,-0.50116E+00,-0.50079E+00,-0.50043E+00,&
     -0.50006E+00,-0.49969E+00,-0.49933E+00,-0.49896E+00,-0.49860E+00,&
     -0.49823E+00,-0.49787E+00,-0.49750E+00,-0.49714E+00,-0.49678E+00,&
     -0.49642E+00,-0.49606E+00,-0.49569E+00,-0.49533E+00,-0.49497E+00,&
     -0.49461E+00,-0.49426E+00,-0.49390E+00,-0.49354E+00,-0.49318E+00,&
     -0.49283E+00,-0.49247E+00,-0.49211E+00,-0.49176E+00,-0.49141E+00,&
     -0.49105E+00,-0.49070E+00,-0.49035E+00,-0.48999E+00,-0.48964E+00,&
     -0.48929E+00,-0.48894E+00,-0.48859E+00,-0.48824E+00,-0.48789E+00,&
     -0.48755E+00,-0.48720E+00,-0.48685E+00,-0.48651E+00,-0.48616E+00,&
     -0.48581E+00,-0.48547E+00,-0.48513E+00,-0.48478E+00,-0.48444E+00,&
     -0.48410E+00,-0.48376E+00,-0.48342E+00,-0.48308E+00,-0.48274E+00,&
     -0.48240E+00,-0.48206E+00,-0.48172E+00,-0.48138E+00,-0.48105E+00,&
     -0.48071E+00,-0.48038E+00,-0.48004E+00,-0.47971E+00,-0.47938E+00,&
     -0.47904E+00,-0.47871E+00,-0.47838E+00,-0.47805E+00,-0.47772E+00/
                             
     DATA (BNC13M (IA),IA=301,400)/                                     &
     -0.47739E+00,-0.47706E+00,-0.47673E+00,-0.47640E+00,-0.47608E+00,&
     -0.47575E+00,-0.47542E+00,-0.47510E+00,-0.47477E+00,-0.47445E+00,&
     -0.47413E+00,-0.47380E+00,-0.47348E+00,-0.47316E+00,-0.47284E+00,&
     -0.47252E+00,-0.47220E+00,-0.47188E+00,-0.47156E+00,-0.47124E+00,&
     -0.47093E+00,-0.47061E+00,-0.47029E+00,-0.46998E+00,-0.46966E+00,&
     -0.46935E+00,-0.46903E+00,-0.46872E+00,-0.46841E+00,-0.46810E+00,&
     -0.46779E+00,-0.46748E+00,-0.46717E+00,-0.46686E+00,-0.46655E+00,&
     -0.46624E+00,-0.46593E+00,-0.46563E+00,-0.46532E+00,-0.46502E+00,&
     -0.46471E+00,-0.46441E+00,-0.46410E+00,-0.46380E+00,-0.46350E+00,&
     -0.46320E+00,-0.46289E+00,-0.46259E+00,-0.46229E+00,-0.46200E+00,&
     -0.46170E+00,-0.46140E+00,-0.46110E+00,-0.46080E+00,-0.46051E+00,&
     -0.46021E+00,-0.45992E+00,-0.45962E+00,-0.45933E+00,-0.45904E+00,&
     -0.45874E+00,-0.45845E+00,-0.45816E+00,-0.45787E+00,-0.45758E+00,&
     -0.45729E+00,-0.45700E+00,-0.45671E+00,-0.45642E+00,-0.45614E+00,&
     -0.45585E+00,-0.45556E+00,-0.45528E+00,-0.45499E+00,-0.45471E+00,&
     -0.45442E+00,-0.45414E+00,-0.45386E+00,-0.45358E+00,-0.45330E+00,&
     -0.45302E+00,-0.45274E+00,-0.45246E+00,-0.45218E+00,-0.45190E+00,&
     -0.45162E+00,-0.45134E+00,-0.45107E+00,-0.45079E+00,-0.45051E+00,&
     -0.45024E+00,-0.44997E+00,-0.44969E+00,-0.44942E+00,-0.44915E+00,&
     -0.44887E+00,-0.44860E+00,-0.44833E+00,-0.44806E+00,-0.44779E+00/
                             
     DATA (BNC13M (IA),IA=401,500)/                                     &
     -0.44752E+00,-0.44725E+00,-0.44699E+00,-0.44672E+00,-0.44645E+00,&
     -0.44619E+00,-0.44592E+00,-0.44565E+00,-0.44539E+00,-0.44513E+00,&
     -0.44486E+00,-0.44460E+00,-0.44434E+00,-0.44408E+00,-0.44381E+00,&
     -0.44355E+00,-0.44329E+00,-0.44303E+00,-0.44277E+00,-0.44252E+00,&
     -0.44226E+00,-0.44200E+00,-0.44174E+00,-0.44149E+00,-0.44123E+00,&
     -0.44098E+00,-0.44072E+00,-0.44047E+00,-0.44021E+00,-0.43996E+00,&
     -0.43971E+00,-0.43946E+00,-0.43921E+00,-0.43896E+00,-0.43870E+00,&
     -0.43846E+00,-0.43821E+00,-0.43796E+00,-0.43771E+00,-0.43746E+00,&
     -0.43721E+00,-0.43697E+00,-0.43672E+00,-0.43648E+00,-0.43623E+00,&
     -0.43599E+00,-0.43574E+00,-0.43550E+00,-0.43526E+00,-0.43502E+00,&
     -0.43477E+00,-0.43453E+00,-0.43429E+00,-0.43405E+00,-0.43381E+00,&
     -0.43357E+00,-0.43333E+00,-0.43310E+00,-0.43286E+00,-0.43262E+00,&
     -0.43238E+00,-0.43215E+00,-0.43191E+00,-0.43168E+00,-0.43144E+00,&
     -0.43121E+00,-0.43098E+00,-0.43074E+00,-0.43051E+00,-0.43028E+00,&
     -0.43005E+00,-0.42982E+00,-0.42959E+00,-0.42936E+00,-0.42913E+00,&
     -0.42890E+00,-0.42867E+00,-0.42844E+00,-0.42821E+00,-0.42799E+00,&
     -0.42776E+00,-0.42754E+00,-0.42731E+00,-0.42708E+00,-0.42686E+00,&
     -0.42664E+00,-0.42641E+00,-0.42619E+00,-0.42597E+00,-0.42575E+00,&
     -0.42552E+00,-0.42530E+00,-0.42508E+00,-0.42486E+00,-0.42464E+00,&
     -0.42442E+00,-0.42421E+00,-0.42399E+00,-0.42377E+00,-0.42355E+00/
                             
     DATA (BNC13M (IA),IA=501,600)/                                     &
     -0.42334E+00,-0.42312E+00,-0.42290E+00,-0.42269E+00,-0.42248E+00,&
     -0.42226E+00,-0.42205E+00,-0.42183E+00,-0.42162E+00,-0.42141E+00,&
     -0.42120E+00,-0.42099E+00,-0.42077E+00,-0.42056E+00,-0.42035E+00,&
     -0.42014E+00,-0.41994E+00,-0.41973E+00,-0.41952E+00,-0.41931E+00,&
     -0.41910E+00,-0.41890E+00,-0.41869E+00,-0.41849E+00,-0.41828E+00,&
     -0.41808E+00,-0.41787E+00,-0.41767E+00,-0.41746E+00,-0.41726E+00,&
     -0.41706E+00,-0.41686E+00,-0.41665E+00,-0.41645E+00,-0.41625E+00,&
     -0.41605E+00,-0.41585E+00,-0.41565E+00,-0.41545E+00,-0.41526E+00,&
     -0.41506E+00,-0.41486E+00,-0.41466E+00,-0.41447E+00,-0.41427E+00,&
     -0.41407E+00,-0.41388E+00,-0.41368E+00,-0.41349E+00,-0.41329E+00,&
     -0.41310E+00,-0.41291E+00,-0.41272E+00,-0.41252E+00,-0.41233E+00,&
     -0.41214E+00,-0.41195E+00,-0.41176E+00,-0.41157E+00,-0.41138E+00,&
     -0.41119E+00,-0.41100E+00,-0.41081E+00,-0.41062E+00,-0.41044E+00,&
     -0.41025E+00,-0.41006E+00,-0.40988E+00,-0.40969E+00,-0.40950E+00,&
     -0.40932E+00,-0.40914E+00,-0.40895E+00,-0.40877E+00,-0.40858E+00,&
     -0.40840E+00,-0.40822E+00,-0.40804E+00,-0.40785E+00,-0.40767E+00,&
     -0.40749E+00,-0.40731E+00,-0.40713E+00,-0.40695E+00,-0.40677E+00,&
     -0.40659E+00,-0.40642E+00,-0.40624E+00,-0.40606E+00,-0.40588E+00,&
     -0.40571E+00,-0.40553E+00,-0.40535E+00,-0.40518E+00,-0.40500E+00,&
     -0.40483E+00,-0.40466E+00,-0.40448E+00,-0.40431E+00,-0.40366E+00/
                             
     DATA (BNC13M (IA),IA=601,700)/                                     &
     -0.40226E+00,-0.40059E+00,-0.39896E+00,-0.39738E+00,-0.39582E+00,&
     -0.39431E+00,-0.39283E+00,-0.39138E+00,-0.38998E+00,-0.38860E+00,&
     -0.38726E+00,-0.38595E+00,-0.38467E+00,-0.38343E+00,-0.38221E+00,&
     -0.38103E+00,-0.37988E+00,-0.37876E+00,-0.37766E+00,-0.37660E+00,&
     -0.37556E+00,-0.37455E+00,-0.37357E+00,-0.37261E+00,-0.37169E+00,&
     -0.37078E+00,-0.36991E+00,-0.36906E+00,-0.36823E+00,-0.36743E+00,&
     -0.36665E+00,-0.36590E+00,-0.36516E+00,-0.36446E+00,-0.36377E+00,&
     -0.36311E+00,-0.36247E+00,-0.36185E+00,-0.36125E+00,-0.36067E+00,&
     -0.36012E+00,-0.35958E+00,-0.35907E+00,-0.35857E+00,-0.35809E+00,&
     -0.35764E+00,-0.35720E+00,-0.35678E+00,-0.35638E+00,-0.35600E+00,&
     -0.35563E+00,-0.35529E+00,-0.35496E+00,-0.35465E+00,-0.35435E+00,&
     -0.35407E+00,-0.35381E+00,-0.35357E+00,-0.35334E+00,-0.35313E+00,&
     -0.35293E+00,-0.35275E+00,-0.35258E+00,-0.35243E+00,-0.35229E+00,&
     -0.35217E+00,-0.35206E+00,-0.35197E+00,-0.35189E+00,-0.35183E+00,&
     -0.35178E+00,-0.35174E+00,-0.35172E+00,-0.35171E+00,-0.35171E+00,&
     -0.35173E+00,-0.35176E+00,-0.35180E+00,-0.35186E+00,-0.35193E+00,&
     -0.35201E+00,-0.35210E+00,-0.35220E+00,-0.35232E+00,-0.35245E+00,&
     -0.35258E+00,-0.35274E+00,-0.35290E+00,-0.35307E+00,-0.35326E+00,&
     -0.35345E+00,-0.35366E+00,-0.35387E+00,-0.35410E+00,-0.35434E+00,&
     -0.35459E+00,-0.35485E+00,-0.35512E+00,-0.35540E+00,-0.35569E+00/
                             
     DATA (BNC13M(IA),IA=701,741)/                                      &
     -0.35599E+00,-0.35629E+00,-0.35661E+00,-0.35694E+00,-0.35728E+00,&
     -0.35763E+00,-0.35798E+00,-0.35835E+00,-0.35872E+00,-0.35911E+00,&
     -0.35950E+00,-0.35990E+00,-0.36031E+00,-0.36073E+00,-0.36116E+00,&
     -0.36159E+00,-0.36204E+00,-0.36249E+00,-0.36295E+00,-0.36342E+00,&
     -0.36390E+00,-0.36438E+00,-0.36487E+00,-0.36538E+00,-0.36588E+00,&
     -0.36640E+00,-0.36692E+00,-0.36746E+00,-0.36799E+00,-0.36854E+00,&
     -0.36909E+00,-0.36966E+00,-0.37022E+00,-0.37080E+00,-0.37138E+00,&
     -0.37197E+00,-0.37257E+00,-0.37317E+00,-0.37378E+00,-0.37440E+00,&
     -0.37502E+00                 /                      
!     END                     
                             
!  ** TEMP = 298.0           
                             
!     BLOCK DATA KMCF298      
!                            
!  ** Common block definition
!                            
!     COMMON /KMC298/                                                  &         
!     BNC01M(  741),BNC02M(  741),BNC03M(  741),BNC04M(  741),         &
!     BNC05M(  741),BNC06M(  741),BNC07M(  741),BNC08M(  741),         &
!     BNC09M(  741),BNC10M(  741),BNC11M(  741),BNC12M(  741),         &
!     BNC13M(  741)           
!                            
!  ** NaCl                   
!                            
     DATA (BNC01M (IA),IA=  1,100)/                                     &
     -0.49998E-01,-0.88352E-01,-0.11333E+00,-0.12907E+00,-0.14035E+00,&
     -0.14892E+00,-0.15567E+00,-0.16110E+00,-0.16552E+00,-0.16915E+00,&
     -0.17214E+00,-0.17461E+00,-0.17663E+00,-0.17828E+00,-0.17961E+00,&
     -0.18066E+00,-0.18146E+00,-0.18205E+00,-0.18245E+00,-0.18268E+00,&
     -0.18276E+00,-0.18270E+00,-0.18252E+00,-0.18222E+00,-0.18183E+00,&
     -0.18134E+00,-0.18077E+00,-0.18013E+00,-0.17941E+00,-0.17864E+00,&
     -0.17780E+00,-0.17691E+00,-0.17598E+00,-0.17500E+00,-0.17397E+00,&
     -0.17292E+00,-0.17182E+00,-0.17070E+00,-0.16955E+00,-0.16837E+00,&
     -0.16717E+00,-0.16594E+00,-0.16470E+00,-0.16343E+00,-0.16215E+00,&
     -0.16086E+00,-0.15955E+00,-0.15823E+00,-0.15690E+00,-0.15555E+00,&
     -0.15420E+00,-0.15283E+00,-0.15146E+00,-0.15008E+00,-0.14869E+00,&
     -0.14729E+00,-0.14589E+00,-0.14448E+00,-0.14306E+00,-0.14163E+00,&
     -0.14020E+00,-0.13877E+00,-0.13732E+00,-0.13587E+00,-0.13441E+00,&
     -0.13294E+00,-0.13147E+00,-0.12999E+00,-0.12850E+00,-0.12700E+00,&
     -0.12549E+00,-0.12397E+00,-0.12245E+00,-0.12091E+00,-0.11936E+00,&
     -0.11781E+00,-0.11624E+00,-0.11466E+00,-0.11307E+00,-0.11147E+00,&
     -0.10985E+00,-0.10823E+00,-0.10659E+00,-0.10493E+00,-0.10327E+00,&
     -0.10159E+00,-0.99900E-01,-0.98196E-01,-0.96479E-01,-0.94748E-01,&
     -0.93005E-01,-0.91248E-01,-0.89479E-01,-0.87697E-01,-0.85902E-01,&
     -0.84096E-01,-0.82277E-01,-0.80446E-01,-0.78604E-01,-0.76751E-01/
                             
     DATA (BNC01M (IA),IA=101,200)/                                     &
     -0.74887E-01,-0.73013E-01,-0.71128E-01,-0.69234E-01,-0.67331E-01,&
     -0.65418E-01,-0.63498E-01,-0.61569E-01,-0.59633E-01,-0.57689E-01,&
     -0.55739E-01,-0.53782E-01,-0.51819E-01,-0.49851E-01,-0.47877E-01,&
     -0.45899E-01,-0.43917E-01,-0.41930E-01,-0.39940E-01,-0.37946E-01,&
     -0.36169E-01,-0.34144E-01,-0.32120E-01,-0.30095E-01,-0.28071E-01,&
     -0.26048E-01,-0.24024E-01,-0.22002E-01,-0.19979E-01,-0.17958E-01,&
     -0.15937E-01,-0.13916E-01,-0.11897E-01,-0.98784E-02,-0.78606E-02,&
     -0.58439E-02,-0.38280E-02,-0.18133E-02, 0.20048E-03, 0.22131E-02,&
      0.42245E-02, 0.62347E-02, 0.82436E-02, 0.10251E-01, 0.12258E-01,&
      0.14263E-01, 0.16266E-01, 0.18268E-01, 0.20269E-01, 0.22268E-01,&
      0.24266E-01, 0.26262E-01, 0.28256E-01, 0.30249E-01, 0.32240E-01,&
      0.34229E-01, 0.36217E-01, 0.38203E-01, 0.40187E-01, 0.42170E-01,&
      0.44150E-01, 0.46129E-01, 0.48106E-01, 0.50081E-01, 0.52054E-01,&
      0.54025E-01, 0.55994E-01, 0.57961E-01, 0.59926E-01, 0.61889E-01,&
      0.63850E-01, 0.65809E-01, 0.67766E-01, 0.69721E-01, 0.71674E-01,&
      0.73625E-01, 0.75573E-01, 0.77519E-01, 0.79464E-01, 0.81406E-01,&
      0.83345E-01, 0.85283E-01, 0.87218E-01, 0.89152E-01, 0.91082E-01,&
      0.93011E-01, 0.94937E-01, 0.96862E-01, 0.98783E-01, 0.10070E+00,&
      0.10262E+00, 0.10453E+00, 0.10645E+00, 0.10836E+00, 0.11027E+00,&
      0.11217E+00, 0.11407E+00, 0.11597E+00, 0.11787E+00, 0.11977E+00/
                             
     DATA (BNC01M (IA),IA=201,300)/                                     &
      0.12166E+00, 0.12355E+00, 0.12544E+00, 0.12733E+00, 0.12921E+00,&
      0.13109E+00, 0.13297E+00, 0.13485E+00, 0.13672E+00, 0.13860E+00,&
      0.14047E+00, 0.14233E+00, 0.14420E+00, 0.14606E+00, 0.14792E+00,&
      0.14978E+00, 0.15163E+00, 0.15348E+00, 0.15533E+00, 0.15718E+00,&
      0.15902E+00, 0.16087E+00, 0.16271E+00, 0.16454E+00, 0.16638E+00,&
      0.16821E+00, 0.17004E+00, 0.17187E+00, 0.17369E+00, 0.17551E+00,&
      0.17733E+00, 0.17915E+00, 0.18097E+00, 0.18278E+00, 0.18459E+00,&
      0.18640E+00, 0.18820E+00, 0.19000E+00, 0.19180E+00, 0.19360E+00,&
      0.19540E+00, 0.19719E+00, 0.19898E+00, 0.20076E+00, 0.20255E+00,&
      0.20433E+00, 0.20611E+00, 0.20789E+00, 0.20966E+00, 0.21144E+00,&
      0.21321E+00, 0.21497E+00, 0.21674E+00, 0.21850E+00, 0.22026E+00,&
      0.22202E+00, 0.22377E+00, 0.22553E+00, 0.22727E+00, 0.22902E+00,&
      0.23077E+00, 0.23251E+00, 0.23425E+00, 0.23599E+00, 0.23772E+00,&
      0.23946E+00, 0.24119E+00, 0.24291E+00, 0.24464E+00, 0.24636E+00,&
      0.24808E+00, 0.24980E+00, 0.25152E+00, 0.25323E+00, 0.25494E+00,&
      0.25665E+00, 0.25835E+00, 0.26006E+00, 0.26176E+00, 0.26346E+00,&
      0.26515E+00, 0.26684E+00, 0.26854E+00, 0.27022E+00, 0.27191E+00,&
      0.27360E+00, 0.27528E+00, 0.27696E+00, 0.27863E+00, 0.28031E+00,&
      0.28198E+00, 0.28365E+00, 0.28532E+00, 0.28698E+00, 0.28864E+00,&
      0.29030E+00, 0.29196E+00, 0.29362E+00, 0.29527E+00, 0.29692E+00/
                             
     DATA (BNC01M (IA),IA=301,400)/                                     &
      0.29857E+00, 0.30021E+00, 0.30186E+00, 0.30350E+00, 0.30514E+00,&
      0.30677E+00, 0.30841E+00, 0.31004E+00, 0.31167E+00, 0.31330E+00,&
      0.31492E+00, 0.31654E+00, 0.31816E+00, 0.31978E+00, 0.32140E+00,&
      0.32301E+00, 0.32462E+00, 0.32623E+00, 0.32784E+00, 0.32944E+00,&
      0.33104E+00, 0.33264E+00, 0.33424E+00, 0.33584E+00, 0.33743E+00,&
      0.33902E+00, 0.34061E+00, 0.34219E+00, 0.34378E+00, 0.34536E+00,&
      0.34694E+00, 0.34852E+00, 0.35009E+00, 0.35166E+00, 0.35323E+00,&
      0.35480E+00, 0.35637E+00, 0.35793E+00, 0.35949E+00, 0.36105E+00,&
      0.36261E+00, 0.36417E+00, 0.36572E+00, 0.36727E+00, 0.36882E+00,&
      0.37036E+00, 0.37191E+00, 0.37345E+00, 0.37499E+00, 0.37653E+00,&
      0.37806E+00, 0.37960E+00, 0.38113E+00, 0.38266E+00, 0.38419E+00,&
      0.38571E+00, 0.38723E+00, 0.38875E+00, 0.39027E+00, 0.39179E+00,&
      0.39330E+00, 0.39482E+00, 0.39633E+00, 0.39783E+00, 0.39934E+00,&
      0.40084E+00, 0.40235E+00, 0.40384E+00, 0.40534E+00, 0.40684E+00,&
      0.40833E+00, 0.40982E+00, 0.41131E+00, 0.41280E+00, 0.41429E+00,&
      0.41577E+00, 0.41725E+00, 0.41873E+00, 0.42021E+00, 0.42168E+00,&
      0.42315E+00, 0.42463E+00, 0.42609E+00, 0.42756E+00, 0.42903E+00,&
      0.43049E+00, 0.43195E+00, 0.43341E+00, 0.43487E+00, 0.43632E+00,&
      0.43778E+00, 0.43923E+00, 0.44068E+00, 0.44212E+00, 0.44357E+00,&
      0.44501E+00, 0.44645E+00, 0.44789E+00, 0.44933E+00, 0.45077E+00/
                             
     DATA (BNC01M (IA),IA=401,500)/                                     &
      0.45220E+00, 0.45363E+00, 0.45506E+00, 0.45649E+00, 0.45792E+00,&
      0.45934E+00, 0.46076E+00, 0.46218E+00, 0.46360E+00, 0.46502E+00,&
      0.46643E+00, 0.46784E+00, 0.46926E+00, 0.47066E+00, 0.47207E+00,&
      0.47348E+00, 0.47488E+00, 0.47628E+00, 0.47768E+00, 0.47908E+00,&
      0.48047E+00, 0.48187E+00, 0.48326E+00, 0.48465E+00, 0.48604E+00,&
      0.48743E+00, 0.48881E+00, 0.49019E+00, 0.49157E+00, 0.49295E+00,&
      0.49433E+00, 0.49571E+00, 0.49708E+00, 0.49845E+00, 0.49982E+00,&
      0.50119E+00, 0.50256E+00, 0.50392E+00, 0.50529E+00, 0.50665E+00,&
      0.50801E+00, 0.50937E+00, 0.51072E+00, 0.51208E+00, 0.51343E+00,&
      0.51478E+00, 0.51613E+00, 0.51748E+00, 0.51882E+00, 0.52017E+00,&
      0.52151E+00, 0.52285E+00, 0.52419E+00, 0.52553E+00, 0.52686E+00,&
      0.52819E+00, 0.52953E+00, 0.53086E+00, 0.53218E+00, 0.53351E+00,&
      0.53484E+00, 0.53616E+00, 0.53748E+00, 0.53880E+00, 0.54012E+00,&
      0.54144E+00, 0.54275E+00, 0.54406E+00, 0.54538E+00, 0.54669E+00,&
      0.54799E+00, 0.54930E+00, 0.55061E+00, 0.55191E+00, 0.55321E+00,&
      0.55451E+00, 0.55581E+00, 0.55711E+00, 0.55840E+00, 0.55970E+00,&
      0.56099E+00, 0.56228E+00, 0.56357E+00, 0.56485E+00, 0.56614E+00,&
      0.56742E+00, 0.56870E+00, 0.56999E+00, 0.57126E+00, 0.57254E+00,&
      0.57382E+00, 0.57509E+00, 0.57637E+00, 0.57764E+00, 0.57891E+00,&
      0.58017E+00, 0.58144E+00, 0.58271E+00, 0.58397E+00, 0.58523E+00/
                             
     DATA (BNC01M (IA),IA=501,600)/                                     &
      0.58649E+00, 0.58775E+00, 0.58901E+00, 0.59026E+00, 0.59152E+00,&
      0.59277E+00, 0.59402E+00, 0.59527E+00, 0.59652E+00, 0.59776E+00,&
      0.59901E+00, 0.60025E+00, 0.60149E+00, 0.60273E+00, 0.60397E+00,&
      0.60521E+00, 0.60645E+00, 0.60768E+00, 0.60891E+00, 0.61014E+00,&
      0.61137E+00, 0.61260E+00, 0.61383E+00, 0.61506E+00, 0.61628E+00,&
      0.61750E+00, 0.61872E+00, 0.61994E+00, 0.62116E+00, 0.62238E+00,&
      0.62359E+00, 0.62481E+00, 0.62602E+00, 0.62723E+00, 0.62844E+00,&
      0.62965E+00, 0.63085E+00, 0.63206E+00, 0.63326E+00, 0.63446E+00,&
      0.63567E+00, 0.63687E+00, 0.63806E+00, 0.63926E+00, 0.64045E+00,&
      0.64165E+00, 0.64284E+00, 0.64403E+00, 0.64522E+00, 0.64641E+00,&
      0.64760E+00, 0.64878E+00, 0.64997E+00, 0.65115E+00, 0.65233E+00,&
      0.65351E+00, 0.65469E+00, 0.65587E+00, 0.65704E+00, 0.65822E+00,&
      0.65939E+00, 0.66056E+00, 0.66173E+00, 0.66290E+00, 0.66407E+00,&
      0.66523E+00, 0.66640E+00, 0.66756E+00, 0.66872E+00, 0.66988E+00,&
      0.67104E+00, 0.67220E+00, 0.67336E+00, 0.67452E+00, 0.67567E+00,&
      0.67682E+00, 0.67797E+00, 0.67912E+00, 0.68027E+00, 0.68142E+00,&
      0.68257E+00, 0.68371E+00, 0.68486E+00, 0.68600E+00, 0.68714E+00,&
      0.68828E+00, 0.68942E+00, 0.69056E+00, 0.69169E+00, 0.69283E+00,&
      0.69396E+00, 0.69509E+00, 0.69622E+00, 0.69735E+00, 0.69848E+00,&
      0.69961E+00, 0.70073E+00, 0.70186E+00, 0.70298E+00, 0.70718E+00/
                             
     DATA (BNC01M (IA),IA=601,700)/                                     &
      0.71636E+00, 0.72738E+00, 0.73828E+00, 0.74906E+00, 0.75972E+00,&
      0.77027E+00, 0.78071E+00, 0.79104E+00, 0.80127E+00, 0.81139E+00,&
      0.82141E+00, 0.83133E+00, 0.84115E+00, 0.85087E+00, 0.86050E+00,&
      0.87004E+00, 0.87948E+00, 0.88883E+00, 0.89810E+00, 0.90728E+00,&
      0.91638E+00, 0.92539E+00, 0.93432E+00, 0.94316E+00, 0.95193E+00,&
      0.96063E+00, 0.96924E+00, 0.97778E+00, 0.98625E+00, 0.99464E+00,&
      0.10030E+01, 0.10112E+01, 0.10194E+01, 0.10275E+01, 0.10356E+01,&
      0.10435E+01, 0.10515E+01, 0.10593E+01, 0.10671E+01, 0.10748E+01,&
      0.10825E+01, 0.10901E+01, 0.10977E+01, 0.11051E+01, 0.11126E+01,&
      0.11200E+01, 0.11273E+01, 0.11345E+01, 0.11418E+01, 0.11489E+01,&
      0.11560E+01, 0.11631E+01, 0.11701E+01, 0.11770E+01, 0.11839E+01,&
      0.11908E+01, 0.11976E+01, 0.12044E+01, 0.12111E+01, 0.12177E+01,&
      0.12244E+01, 0.12309E+01, 0.12375E+01, 0.12440E+01, 0.12504E+01,&
      0.12568E+01, 0.12632E+01, 0.12695E+01, 0.12758E+01, 0.12820E+01,&
      0.12882E+01, 0.12943E+01, 0.13005E+01, 0.13065E+01, 0.13126E+01,&
      0.13186E+01, 0.13246E+01, 0.13305E+01, 0.13364E+01, 0.13422E+01,&
      0.13481E+01, 0.13539E+01, 0.13596E+01, 0.13653E+01, 0.13710E+01,&
      0.13767E+01, 0.13823E+01, 0.13879E+01, 0.13934E+01, 0.13990E+01,&
      0.14044E+01, 0.14099E+01, 0.14153E+01, 0.14207E+01, 0.14261E+01,&
      0.14314E+01, 0.14368E+01, 0.14420E+01, 0.14473E+01, 0.14525E+01/
                             
     DATA (BNC01M(IA),IA=701,741)/                                      &
      0.14577E+01, 0.14629E+01, 0.14680E+01, 0.14731E+01, 0.14782E+01,&
      0.14833E+01, 0.14883E+01, 0.14933E+01, 0.14983E+01, 0.15033E+01,&
      0.15082E+01, 0.15131E+01, 0.15180E+01, 0.15228E+01, 0.15277E+01,&
      0.15325E+01, 0.15372E+01, 0.15420E+01, 0.15467E+01, 0.15515E+01,&
      0.15561E+01, 0.15608E+01, 0.15655E+01, 0.15701E+01, 0.15747E+01,&
      0.15793E+01, 0.15838E+01, 0.15884E+01, 0.15929E+01, 0.15974E+01,&
      0.16018E+01, 0.16063E+01, 0.16107E+01, 0.16151E+01, 0.16195E+01,&
      0.16239E+01, 0.16282E+01, 0.16326E+01, 0.16369E+01, 0.16412E+01,&
      0.16454E+01                  /                      
!                            
!  ** Na2SO4                 
!                            
     DATA (BNC02M (IA),IA=  1,100)/                                     &
     -0.10298E+00,-0.18764E+00,-0.24726E+00,-0.28786E+00,-0.31914E+00,&
     -0.34476E+00,-0.36652E+00,-0.38546E+00,-0.40225E+00,-0.41734E+00,&
     -0.43104E+00,-0.44360E+00,-0.45519E+00,-0.46595E+00,-0.47599E+00,&
     -0.48541E+00,-0.49427E+00,-0.50264E+00,-0.51057E+00,-0.51811E+00,&
     -0.52529E+00,-0.53214E+00,-0.53869E+00,-0.54497E+00,-0.55100E+00,&
     -0.55680E+00,-0.56238E+00,-0.56776E+00,-0.57295E+00,-0.57797E+00,&
     -0.58283E+00,-0.58753E+00,-0.59209E+00,-0.59651E+00,-0.60081E+00,&
     -0.60498E+00,-0.60904E+00,-0.61298E+00,-0.61683E+00,-0.62058E+00,&
     -0.62423E+00,-0.62779E+00,-0.63127E+00,-0.63466E+00,-0.63798E+00,&
     -0.64123E+00,-0.64440E+00,-0.64750E+00,-0.65054E+00,-0.65351E+00,&
     -0.65642E+00,-0.65928E+00,-0.66208E+00,-0.66482E+00,-0.66751E+00,&
     -0.67015E+00,-0.67275E+00,-0.67529E+00,-0.67779E+00,-0.68025E+00,&
     -0.68267E+00,-0.68504E+00,-0.68738E+00,-0.68968E+00,-0.69194E+00,&
     -0.69416E+00,-0.69636E+00,-0.69852E+00,-0.70064E+00,-0.70274E+00,&
     -0.70481E+00,-0.70685E+00,-0.70886E+00,-0.71084E+00,-0.71280E+00,&
     -0.71473E+00,-0.71663E+00,-0.71852E+00,-0.72038E+00,-0.72221E+00,&
     -0.72403E+00,-0.72583E+00,-0.72760E+00,-0.72935E+00,-0.73109E+00,&
     -0.73281E+00,-0.73450E+00,-0.73618E+00,-0.73785E+00,-0.73949E+00,&
     -0.74112E+00,-0.74274E+00,-0.74434E+00,-0.74592E+00,-0.74749E+00,&
     -0.74904E+00,-0.75058E+00,-0.75210E+00,-0.75361E+00,-0.75511E+00/
                             
     DATA (BNC02M (IA),IA=101,200)/                                     &
     -0.75660E+00,-0.75807E+00,-0.75953E+00,-0.76097E+00,-0.76241E+00,&
     -0.76383E+00,-0.76524E+00,-0.76664E+00,-0.76803E+00,-0.76940E+00,&
     -0.77077E+00,-0.77212E+00,-0.77346E+00,-0.77479E+00,-0.77612E+00,&
     -0.77743E+00,-0.77873E+00,-0.78002E+00,-0.78130E+00,-0.78257E+00,&
     -0.78379E+00,-0.78505E+00,-0.78629E+00,-0.78753E+00,-0.78876E+00,&
     -0.78997E+00,-0.79118E+00,-0.79238E+00,-0.79357E+00,-0.79475E+00,&
     -0.79592E+00,-0.79708E+00,-0.79824E+00,-0.79939E+00,-0.80052E+00,&
     -0.80165E+00,-0.80277E+00,-0.80389E+00,-0.80499E+00,-0.80609E+00,&
     -0.80718E+00,-0.80827E+00,-0.80934E+00,-0.81041E+00,-0.81147E+00,&
     -0.81253E+00,-0.81358E+00,-0.81462E+00,-0.81565E+00,-0.81668E+00,&
     -0.81770E+00,-0.81871E+00,-0.81972E+00,-0.82072E+00,-0.82172E+00,&
     -0.82270E+00,-0.82369E+00,-0.82466E+00,-0.82563E+00,-0.82660E+00,&
     -0.82756E+00,-0.82851E+00,-0.82946E+00,-0.83040E+00,-0.83133E+00,&
     -0.83227E+00,-0.83319E+00,-0.83411E+00,-0.83503E+00,-0.83593E+00,&
     -0.83684E+00,-0.83774E+00,-0.83863E+00,-0.83952E+00,-0.84040E+00,&
     -0.84128E+00,-0.84216E+00,-0.84303E+00,-0.84389E+00,-0.84475E+00,&
     -0.84561E+00,-0.84646E+00,-0.84731E+00,-0.84815E+00,-0.84898E+00,&
     -0.84982E+00,-0.85065E+00,-0.85147E+00,-0.85229E+00,-0.85311E+00,&
     -0.85392E+00,-0.85473E+00,-0.85553E+00,-0.85633E+00,-0.85712E+00,&
     -0.85792E+00,-0.85870E+00,-0.85949E+00,-0.86027E+00,-0.86104E+00/
                             
     DATA (BNC02M (IA),IA=201,300)/                                     &
     -0.86182E+00,-0.86258E+00,-0.86335E+00,-0.86411E+00,-0.86487E+00,&
     -0.86562E+00,-0.86637E+00,-0.86712E+00,-0.86786E+00,-0.86860E+00,&
     -0.86934E+00,-0.87007E+00,-0.87080E+00,-0.87153E+00,-0.87225E+00,&
     -0.87297E+00,-0.87369E+00,-0.87440E+00,-0.87511E+00,-0.87582E+00,&
     -0.87652E+00,-0.87722E+00,-0.87792E+00,-0.87862E+00,-0.87931E+00,&
     -0.88000E+00,-0.88068E+00,-0.88136E+00,-0.88204E+00,-0.88272E+00,&
     -0.88340E+00,-0.88407E+00,-0.88473E+00,-0.88540E+00,-0.88606E+00,&
     -0.88672E+00,-0.88738E+00,-0.88804E+00,-0.88869E+00,-0.88934E+00,&
     -0.88998E+00,-0.89063E+00,-0.89127E+00,-0.89191E+00,-0.89254E+00,&
     -0.89318E+00,-0.89381E+00,-0.89444E+00,-0.89506E+00,-0.89569E+00,&
     -0.89631E+00,-0.89693E+00,-0.89754E+00,-0.89816E+00,-0.89877E+00,&
     -0.89938E+00,-0.89998E+00,-0.90059E+00,-0.90119E+00,-0.90179E+00,&
     -0.90239E+00,-0.90299E+00,-0.90358E+00,-0.90417E+00,-0.90476E+00,&
     -0.90535E+00,-0.90593E+00,-0.90651E+00,-0.90709E+00,-0.90767E+00,&
     -0.90825E+00,-0.90882E+00,-0.90939E+00,-0.90996E+00,-0.91053E+00,&
     -0.91110E+00,-0.91166E+00,-0.91222E+00,-0.91278E+00,-0.91334E+00,&
     -0.91389E+00,-0.91445E+00,-0.91500E+00,-0.91555E+00,-0.91610E+00,&
     -0.91664E+00,-0.91719E+00,-0.91773E+00,-0.91827E+00,-0.91881E+00,&
     -0.91935E+00,-0.91988E+00,-0.92042E+00,-0.92095E+00,-0.92148E+00,&
     -0.92201E+00,-0.92253E+00,-0.92306E+00,-0.92358E+00,-0.92410E+00/
                             
     DATA (BNC02M (IA),IA=301,400)/                                     &
     -0.92462E+00,-0.92514E+00,-0.92565E+00,-0.92617E+00,-0.92668E+00,&
     -0.92719E+00,-0.92770E+00,-0.92821E+00,-0.92871E+00,-0.92922E+00,&
     -0.92972E+00,-0.93022E+00,-0.93072E+00,-0.93122E+00,-0.93171E+00,&
     -0.93221E+00,-0.93270E+00,-0.93319E+00,-0.93368E+00,-0.93417E+00,&
     -0.93466E+00,-0.93515E+00,-0.93563E+00,-0.93611E+00,-0.93659E+00,&
     -0.93707E+00,-0.93755E+00,-0.93803E+00,-0.93850E+00,-0.93898E+00,&
     -0.93945E+00,-0.93992E+00,-0.94039E+00,-0.94086E+00,-0.94133E+00,&
     -0.94179E+00,-0.94226E+00,-0.94272E+00,-0.94318E+00,-0.94364E+00,&
     -0.94410E+00,-0.94456E+00,-0.94501E+00,-0.94547E+00,-0.94592E+00,&
     -0.94637E+00,-0.94682E+00,-0.94727E+00,-0.94772E+00,-0.94817E+00,&
     -0.94861E+00,-0.94906E+00,-0.94950E+00,-0.94994E+00,-0.95038E+00,&
     -0.95082E+00,-0.95126E+00,-0.95170E+00,-0.95213E+00,-0.95257E+00,&
     -0.95300E+00,-0.95343E+00,-0.95386E+00,-0.95429E+00,-0.95472E+00,&
     -0.95515E+00,-0.95557E+00,-0.95600E+00,-0.95642E+00,-0.95685E+00,&
     -0.95727E+00,-0.95769E+00,-0.95811E+00,-0.95853E+00,-0.95894E+00,&
     -0.95936E+00,-0.95977E+00,-0.96019E+00,-0.96060E+00,-0.96101E+00,&
     -0.96142E+00,-0.96183E+00,-0.96224E+00,-0.96265E+00,-0.96305E+00,&
     -0.96346E+00,-0.96386E+00,-0.96427E+00,-0.96467E+00,-0.96507E+00,&
     -0.96547E+00,-0.96587E+00,-0.96627E+00,-0.96666E+00,-0.96706E+00,&
     -0.96745E+00,-0.96785E+00,-0.96824E+00,-0.96863E+00,-0.96902E+00/
                             
     DATA (BNC02M (IA),IA=401,500)/                                     &
     -0.96941E+00,-0.96980E+00,-0.97019E+00,-0.97058E+00,-0.97096E+00,&
     -0.97135E+00,-0.97173E+00,-0.97211E+00,-0.97250E+00,-0.97288E+00,&
     -0.97326E+00,-0.97364E+00,-0.97402E+00,-0.97439E+00,-0.97477E+00,&
     -0.97515E+00,-0.97552E+00,-0.97589E+00,-0.97627E+00,-0.97664E+00,&
     -0.97701E+00,-0.97738E+00,-0.97775E+00,-0.97812E+00,-0.97849E+00,&
     -0.97885E+00,-0.97922E+00,-0.97958E+00,-0.97995E+00,-0.98031E+00,&
     -0.98067E+00,-0.98104E+00,-0.98140E+00,-0.98176E+00,-0.98212E+00,&
     -0.98247E+00,-0.98283E+00,-0.98319E+00,-0.98354E+00,-0.98390E+00,&
     -0.98425E+00,-0.98461E+00,-0.98496E+00,-0.98531E+00,-0.98566E+00,&
     -0.98601E+00,-0.98636E+00,-0.98671E+00,-0.98706E+00,-0.98741E+00,&
     -0.98775E+00,-0.98810E+00,-0.98844E+00,-0.98879E+00,-0.98913E+00,&
     -0.98947E+00,-0.98981E+00,-0.99015E+00,-0.99049E+00,-0.99083E+00,&
     -0.99117E+00,-0.99151E+00,-0.99185E+00,-0.99218E+00,-0.99252E+00,&
     -0.99285E+00,-0.99319E+00,-0.99352E+00,-0.99385E+00,-0.99419E+00,&
     -0.99452E+00,-0.99485E+00,-0.99518E+00,-0.99551E+00,-0.99584E+00,&
     -0.99616E+00,-0.99649E+00,-0.99682E+00,-0.99714E+00,-0.99747E+00,&
     -0.99779E+00,-0.99812E+00,-0.99844E+00,-0.99876E+00,-0.99908E+00,&
     -0.99940E+00,-0.99972E+00,-0.10000E+01,-0.10004E+01,-0.10007E+01,&
     -0.10010E+01,-0.10013E+01,-0.10016E+01,-0.10019E+01,-0.10023E+01,&
     -0.10026E+01,-0.10029E+01,-0.10032E+01,-0.10035E+01,-0.10038E+01/
                             
     DATA (BNC02M (IA),IA=501,600)/                                     &
     -0.10041E+01,-0.10044E+01,-0.10048E+01,-0.10051E+01,-0.10054E+01,&
     -0.10057E+01,-0.10060E+01,-0.10063E+01,-0.10066E+01,-0.10069E+01,&
     -0.10072E+01,-0.10075E+01,-0.10078E+01,-0.10081E+01,-0.10084E+01,&
     -0.10087E+01,-0.10090E+01,-0.10093E+01,-0.10096E+01,-0.10099E+01,&
     -0.10102E+01,-0.10105E+01,-0.10108E+01,-0.10111E+01,-0.10114E+01,&
     -0.10117E+01,-0.10120E+01,-0.10123E+01,-0.10126E+01,-0.10129E+01,&
     -0.10132E+01,-0.10135E+01,-0.10138E+01,-0.10141E+01,-0.10144E+01,&
     -0.10146E+01,-0.10149E+01,-0.10152E+01,-0.10155E+01,-0.10158E+01,&
     -0.10161E+01,-0.10164E+01,-0.10167E+01,-0.10169E+01,-0.10172E+01,&
     -0.10175E+01,-0.10178E+01,-0.10181E+01,-0.10184E+01,-0.10187E+01,&
     -0.10189E+01,-0.10192E+01,-0.10195E+01,-0.10198E+01,-0.10201E+01,&
     -0.10203E+01,-0.10206E+01,-0.10209E+01,-0.10212E+01,-0.10215E+01,&
     -0.10217E+01,-0.10220E+01,-0.10223E+01,-0.10226E+01,-0.10228E+01,&
     -0.10231E+01,-0.10234E+01,-0.10237E+01,-0.10239E+01,-0.10242E+01,&
     -0.10245E+01,-0.10247E+01,-0.10250E+01,-0.10253E+01,-0.10256E+01,&
     -0.10258E+01,-0.10261E+01,-0.10264E+01,-0.10266E+01,-0.10269E+01,&
     -0.10272E+01,-0.10274E+01,-0.10277E+01,-0.10280E+01,-0.10282E+01,&
     -0.10285E+01,-0.10288E+01,-0.10290E+01,-0.10293E+01,-0.10296E+01,&
     -0.10298E+01,-0.10301E+01,-0.10303E+01,-0.10306E+01,-0.10309E+01,&
     -0.10311E+01,-0.10314E+01,-0.10316E+01,-0.10319E+01,-0.10329E+01/
                             
     DATA (BNC02M (IA),IA=601,700)/                                     &
     -0.10350E+01,-0.10375E+01,-0.10400E+01,-0.10424E+01,-0.10448E+01,&
     -0.10471E+01,-0.10495E+01,-0.10517E+01,-0.10540E+01,-0.10562E+01,&
     -0.10584E+01,-0.10605E+01,-0.10627E+01,-0.10647E+01,-0.10668E+01,&
     -0.10688E+01,-0.10708E+01,-0.10728E+01,-0.10748E+01,-0.10767E+01,&
     -0.10786E+01,-0.10805E+01,-0.10823E+01,-0.10841E+01,-0.10860E+01,&
     -0.10877E+01,-0.10895E+01,-0.10912E+01,-0.10930E+01,-0.10947E+01,&
     -0.10963E+01,-0.10980E+01,-0.10996E+01,-0.11013E+01,-0.11029E+01,&
     -0.11044E+01,-0.11060E+01,-0.11076E+01,-0.11091E+01,-0.11106E+01,&
     -0.11121E+01,-0.11136E+01,-0.11151E+01,-0.11165E+01,-0.11180E+01,&
     -0.11194E+01,-0.11208E+01,-0.11222E+01,-0.11236E+01,-0.11250E+01,&
     -0.11263E+01,-0.11277E+01,-0.11290E+01,-0.11303E+01,-0.11316E+01,&
     -0.11329E+01,-0.11342E+01,-0.11355E+01,-0.11368E+01,-0.11380E+01,&
     -0.11392E+01,-0.11405E+01,-0.11417E+01,-0.11429E+01,-0.11441E+01,&
     -0.11453E+01,-0.11464E+01,-0.11476E+01,-0.11488E+01,-0.11499E+01,&
     -0.11510E+01,-0.11522E+01,-0.11533E+01,-0.11544E+01,-0.11555E+01,&
     -0.11566E+01,-0.11577E+01,-0.11587E+01,-0.11598E+01,-0.11609E+01,&
     -0.11619E+01,-0.11630E+01,-0.11640E+01,-0.11650E+01,-0.11660E+01,&
     -0.11670E+01,-0.11680E+01,-0.11690E+01,-0.11700E+01,-0.11710E+01,&
     -0.11720E+01,-0.11729E+01,-0.11739E+01,-0.11749E+01,-0.11758E+01,&
     -0.11767E+01,-0.11777E+01,-0.11786E+01,-0.11795E+01,-0.11804E+01/
                             
     DATA (BNC02M(IA),IA=701,741)/                                      &
     -0.11813E+01,-0.11822E+01,-0.11831E+01,-0.11840E+01,-0.11849E+01,&
     -0.11858E+01,-0.11867E+01,-0.11875E+01,-0.11884E+01,-0.11893E+01,&
     -0.11901E+01,-0.11909E+01,-0.11918E+01,-0.11926E+01,-0.11934E+01,&
     -0.11943E+01,-0.11951E+01,-0.11959E+01,-0.11967E+01,-0.11975E+01,&
     -0.11983E+01,-0.11991E+01,-0.11999E+01,-0.12007E+01,-0.12015E+01,&
     -0.12022E+01,-0.12030E+01,-0.12038E+01,-0.12045E+01,-0.12053E+01,&
     -0.12060E+01,-0.12068E+01,-0.12075E+01,-0.12083E+01,-0.12090E+01,&
     -0.12097E+01,-0.12105E+01,-0.12112E+01,-0.12119E+01,-0.12126E+01,&
     -0.12133E+01                  /                      
!                            
!  ** NaNO3                  
!                            
     DATA (BNC03M (IA),IA=  1,100)/                                     &
     -0.51631E-01,-0.94349E-01,-0.12464E+00,-0.14539E+00,-0.16147E+00,&
     -0.17470E+00,-0.18599E+00,-0.19586E+00,-0.20466E+00,-0.21259E+00,&
     -0.21982E+00,-0.22648E+00,-0.23265E+00,-0.23839E+00,-0.24378E+00,&
     -0.24884E+00,-0.25363E+00,-0.25817E+00,-0.26248E+00,-0.26659E+00,&
     -0.27052E+00,-0.27428E+00,-0.27789E+00,-0.28136E+00,-0.28470E+00,&
     -0.28792E+00,-0.29103E+00,-0.29403E+00,-0.29694E+00,-0.29976E+00,&
     -0.30249E+00,-0.30515E+00,-0.30772E+00,-0.31023E+00,-0.31267E+00,&
     -0.31505E+00,-0.31736E+00,-0.31962E+00,-0.32182E+00,-0.32397E+00,&
     -0.32607E+00,-0.32812E+00,-0.33013E+00,-0.33209E+00,-0.33401E+00,&
     -0.33590E+00,-0.33774E+00,-0.33954E+00,-0.34131E+00,-0.34305E+00,&
     -0.34475E+00,-0.34642E+00,-0.34806E+00,-0.34967E+00,-0.35125E+00,&
     -0.35281E+00,-0.35434E+00,-0.35584E+00,-0.35732E+00,-0.35877E+00,&
     -0.36021E+00,-0.36162E+00,-0.36300E+00,-0.36437E+00,-0.36572E+00,&
     -0.36705E+00,-0.36836E+00,-0.36965E+00,-0.37093E+00,-0.37219E+00,&
     -0.37343E+00,-0.37466E+00,-0.37588E+00,-0.37707E+00,-0.37826E+00,&
     -0.37943E+00,-0.38059E+00,-0.38174E+00,-0.38287E+00,-0.38400E+00,&
     -0.38511E+00,-0.38621E+00,-0.38730E+00,-0.38838E+00,-0.38945E+00,&
     -0.39051E+00,-0.39157E+00,-0.39261E+00,-0.39364E+00,-0.39467E+00,&
     -0.39569E+00,-0.39670E+00,-0.39770E+00,-0.39869E+00,-0.39968E+00,&
     -0.40066E+00,-0.40163E+00,-0.40260E+00,-0.40356E+00,-0.40451E+00/
                             
     DATA (BNC03M (IA),IA=101,200)/                                     &
     -0.40545E+00,-0.40639E+00,-0.40733E+00,-0.40825E+00,-0.40917E+00,&
     -0.41009E+00,-0.41099E+00,-0.41190E+00,-0.41279E+00,-0.41368E+00,&
     -0.41457E+00,-0.41544E+00,-0.41632E+00,-0.41718E+00,-0.41804E+00,&
     -0.41890E+00,-0.41975E+00,-0.42060E+00,-0.42143E+00,-0.42227E+00,&
     -0.42306E+00,-0.42389E+00,-0.42471E+00,-0.42553E+00,-0.42634E+00,&
     -0.42714E+00,-0.42794E+00,-0.42874E+00,-0.42953E+00,-0.43031E+00,&
     -0.43109E+00,-0.43187E+00,-0.43264E+00,-0.43340E+00,-0.43416E+00,&
     -0.43492E+00,-0.43567E+00,-0.43641E+00,-0.43715E+00,-0.43789E+00,&
     -0.43862E+00,-0.43935E+00,-0.44007E+00,-0.44079E+00,-0.44151E+00,&
     -0.44222E+00,-0.44293E+00,-0.44363E+00,-0.44433E+00,-0.44503E+00,&
     -0.44572E+00,-0.44640E+00,-0.44709E+00,-0.44777E+00,-0.44844E+00,&
     -0.44912E+00,-0.44978E+00,-0.45045E+00,-0.45111E+00,-0.45177E+00,&
     -0.45242E+00,-0.45307E+00,-0.45372E+00,-0.45437E+00,-0.45501E+00,&
     -0.45565E+00,-0.45628E+00,-0.45691E+00,-0.45754E+00,-0.45816E+00,&
     -0.45879E+00,-0.45940E+00,-0.46002E+00,-0.46063E+00,-0.46124E+00,&
     -0.46185E+00,-0.46245E+00,-0.46305E+00,-0.46365E+00,-0.46425E+00,&
     -0.46484E+00,-0.46543E+00,-0.46601E+00,-0.46660E+00,-0.46718E+00,&
     -0.46776E+00,-0.46833E+00,-0.46891E+00,-0.46948E+00,-0.47005E+00,&
     -0.47061E+00,-0.47117E+00,-0.47173E+00,-0.47229E+00,-0.47285E+00,&
     -0.47340E+00,-0.47395E+00,-0.47450E+00,-0.47505E+00,-0.47559E+00/
                             
     DATA (BNC03M (IA),IA=201,300)/                                     &
     -0.47613E+00,-0.47667E+00,-0.47721E+00,-0.47774E+00,-0.47827E+00,&
     -0.47880E+00,-0.47933E+00,-0.47985E+00,-0.48038E+00,-0.48090E+00,&
     -0.48142E+00,-0.48193E+00,-0.48245E+00,-0.48296E+00,-0.48347E+00,&
     -0.48398E+00,-0.48449E+00,-0.48499E+00,-0.48549E+00,-0.48599E+00,&
     -0.48649E+00,-0.48699E+00,-0.48748E+00,-0.48797E+00,-0.48847E+00,&
     -0.48895E+00,-0.48944E+00,-0.48993E+00,-0.49041E+00,-0.49089E+00,&
     -0.49137E+00,-0.49185E+00,-0.49232E+00,-0.49280E+00,-0.49327E+00,&
     -0.49374E+00,-0.49421E+00,-0.49468E+00,-0.49514E+00,-0.49560E+00,&
     -0.49607E+00,-0.49653E+00,-0.49699E+00,-0.49744E+00,-0.49790E+00,&
     -0.49835E+00,-0.49880E+00,-0.49925E+00,-0.49970E+00,-0.50015E+00,&
     -0.50060E+00,-0.50104E+00,-0.50148E+00,-0.50192E+00,-0.50236E+00,&
     -0.50280E+00,-0.50324E+00,-0.50367E+00,-0.50411E+00,-0.50454E+00,&
     -0.50497E+00,-0.50540E+00,-0.50582E+00,-0.50625E+00,-0.50668E+00,&
     -0.50710E+00,-0.50752E+00,-0.50794E+00,-0.50836E+00,-0.50878E+00,&
     -0.50919E+00,-0.50961E+00,-0.51002E+00,-0.51043E+00,-0.51085E+00,&
     -0.51126E+00,-0.51166E+00,-0.51207E+00,-0.51248E+00,-0.51288E+00,&
     -0.51328E+00,-0.51369E+00,-0.51409E+00,-0.51449E+00,-0.51488E+00,&
     -0.51528E+00,-0.51568E+00,-0.51607E+00,-0.51646E+00,-0.51686E+00,&
     -0.51725E+00,-0.51764E+00,-0.51802E+00,-0.51841E+00,-0.51880E+00,&
     -0.51918E+00,-0.51956E+00,-0.51995E+00,-0.52033E+00,-0.52071E+00/
                             
     DATA (BNC03M (IA),IA=301,400)/                                     &
     -0.52109E+00,-0.52146E+00,-0.52184E+00,-0.52222E+00,-0.52259E+00,&
     -0.52296E+00,-0.52334E+00,-0.52371E+00,-0.52408E+00,-0.52445E+00,&
     -0.52482E+00,-0.52518E+00,-0.52555E+00,-0.52591E+00,-0.52628E+00,&
     -0.52664E+00,-0.52700E+00,-0.52736E+00,-0.52772E+00,-0.52808E+00,&
     -0.52844E+00,-0.52879E+00,-0.52915E+00,-0.52950E+00,-0.52986E+00,&
     -0.53021E+00,-0.53056E+00,-0.53091E+00,-0.53126E+00,-0.53161E+00,&
     -0.53196E+00,-0.53230E+00,-0.53265E+00,-0.53299E+00,-0.53334E+00,&
     -0.53368E+00,-0.53402E+00,-0.53436E+00,-0.53470E+00,-0.53504E+00,&
     -0.53538E+00,-0.53572E+00,-0.53605E+00,-0.53639E+00,-0.53672E+00,&
     -0.53706E+00,-0.53739E+00,-0.53772E+00,-0.53805E+00,-0.53838E+00,&
     -0.53871E+00,-0.53904E+00,-0.53937E+00,-0.53970E+00,-0.54002E+00,&
     -0.54035E+00,-0.54067E+00,-0.54100E+00,-0.54132E+00,-0.54164E+00,&
     -0.54196E+00,-0.54228E+00,-0.54260E+00,-0.54292E+00,-0.54324E+00,&
     -0.54355E+00,-0.54387E+00,-0.54419E+00,-0.54450E+00,-0.54481E+00,&
     -0.54513E+00,-0.54544E+00,-0.54575E+00,-0.54606E+00,-0.54637E+00,&
     -0.54668E+00,-0.54699E+00,-0.54730E+00,-0.54760E+00,-0.54791E+00,&
     -0.54821E+00,-0.54852E+00,-0.54882E+00,-0.54913E+00,-0.54943E+00,&
     -0.54973E+00,-0.55003E+00,-0.55033E+00,-0.55063E+00,-0.55093E+00,&
     -0.55123E+00,-0.55152E+00,-0.55182E+00,-0.55212E+00,-0.55241E+00,&
     -0.55271E+00,-0.55300E+00,-0.55329E+00,-0.55359E+00,-0.55388E+00/
                             
     DATA (BNC03M (IA),IA=401,500)/                                     &
     -0.55417E+00,-0.55446E+00,-0.55475E+00,-0.55504E+00,-0.55533E+00,&
     -0.55561E+00,-0.55590E+00,-0.55619E+00,-0.55647E+00,-0.55676E+00,&
     -0.55704E+00,-0.55733E+00,-0.55761E+00,-0.55789E+00,-0.55817E+00,&
     -0.55845E+00,-0.55874E+00,-0.55902E+00,-0.55929E+00,-0.55957E+00,&
     -0.55985E+00,-0.56013E+00,-0.56041E+00,-0.56068E+00,-0.56096E+00,&
     -0.56123E+00,-0.56151E+00,-0.56178E+00,-0.56205E+00,-0.56233E+00,&
     -0.56260E+00,-0.56287E+00,-0.56314E+00,-0.56341E+00,-0.56368E+00,&
     -0.56395E+00,-0.56422E+00,-0.56449E+00,-0.56475E+00,-0.56502E+00,&
     -0.56529E+00,-0.56555E+00,-0.56582E+00,-0.56608E+00,-0.56634E+00,&
     -0.56661E+00,-0.56687E+00,-0.56713E+00,-0.56739E+00,-0.56766E+00,&
     -0.56792E+00,-0.56818E+00,-0.56843E+00,-0.56869E+00,-0.56895E+00,&
     -0.56921E+00,-0.56947E+00,-0.56972E+00,-0.56998E+00,-0.57024E+00,&
     -0.57049E+00,-0.57075E+00,-0.57100E+00,-0.57125E+00,-0.57151E+00,&
     -0.57176E+00,-0.57201E+00,-0.57226E+00,-0.57251E+00,-0.57276E+00,&
     -0.57301E+00,-0.57326E+00,-0.57351E+00,-0.57376E+00,-0.57401E+00,&
     -0.57425E+00,-0.57450E+00,-0.57475E+00,-0.57499E+00,-0.57524E+00,&
     -0.57548E+00,-0.57573E+00,-0.57597E+00,-0.57622E+00,-0.57646E+00,&
     -0.57670E+00,-0.57694E+00,-0.57719E+00,-0.57743E+00,-0.57767E+00,&
     -0.57791E+00,-0.57815E+00,-0.57839E+00,-0.57862E+00,-0.57886E+00,&
     -0.57910E+00,-0.57934E+00,-0.57958E+00,-0.57981E+00,-0.58005E+00/
                             
     DATA (BNC03M (IA),IA=501,600)/                                     &
     -0.58028E+00,-0.58052E+00,-0.58075E+00,-0.58099E+00,-0.58122E+00,&
     -0.58145E+00,-0.58169E+00,-0.58192E+00,-0.58215E+00,-0.58238E+00,&
     -0.58261E+00,-0.58284E+00,-0.58307E+00,-0.58330E+00,-0.58353E+00,&
     -0.58376E+00,-0.58399E+00,-0.58422E+00,-0.58445E+00,-0.58467E+00,&
     -0.58490E+00,-0.58513E+00,-0.58535E+00,-0.58558E+00,-0.58580E+00,&
     -0.58603E+00,-0.58625E+00,-0.58648E+00,-0.58670E+00,-0.58692E+00,&
     -0.58714E+00,-0.58737E+00,-0.58759E+00,-0.58781E+00,-0.58803E+00,&
     -0.58825E+00,-0.58847E+00,-0.58869E+00,-0.58891E+00,-0.58913E+00,&
     -0.58935E+00,-0.58957E+00,-0.58978E+00,-0.59000E+00,-0.59022E+00,&
     -0.59044E+00,-0.59065E+00,-0.59087E+00,-0.59108E+00,-0.59130E+00,&
     -0.59151E+00,-0.59173E+00,-0.59194E+00,-0.59215E+00,-0.59237E+00,&
     -0.59258E+00,-0.59279E+00,-0.59300E+00,-0.59322E+00,-0.59343E+00,&
     -0.59364E+00,-0.59385E+00,-0.59406E+00,-0.59427E+00,-0.59448E+00,&
     -0.59469E+00,-0.59490E+00,-0.59511E+00,-0.59531E+00,-0.59552E+00,&
     -0.59573E+00,-0.59594E+00,-0.59614E+00,-0.59635E+00,-0.59655E+00,&
     -0.59676E+00,-0.59696E+00,-0.59717E+00,-0.59737E+00,-0.59758E+00,&
     -0.59778E+00,-0.59799E+00,-0.59819E+00,-0.59839E+00,-0.59859E+00,&
     -0.59880E+00,-0.59900E+00,-0.59920E+00,-0.59940E+00,-0.59960E+00,&
     -0.59980E+00,-0.60000E+00,-0.60020E+00,-0.60040E+00,-0.60060E+00,&
     -0.60080E+00,-0.60100E+00,-0.60119E+00,-0.60139E+00,-0.60213E+00/
                             
     DATA (BNC03M (IA),IA=601,700)/                                     &
     -0.60374E+00,-0.60566E+00,-0.60755E+00,-0.60942E+00,-0.61125E+00,&
     -0.61305E+00,-0.61483E+00,-0.61658E+00,-0.61831E+00,-0.62001E+00,&
     -0.62169E+00,-0.62334E+00,-0.62497E+00,-0.62658E+00,-0.62816E+00,&
     -0.62973E+00,-0.63127E+00,-0.63279E+00,-0.63429E+00,-0.63578E+00,&
     -0.63724E+00,-0.63869E+00,-0.64012E+00,-0.64153E+00,-0.64292E+00,&
     -0.64430E+00,-0.64566E+00,-0.64700E+00,-0.64833E+00,-0.64964E+00,&
     -0.65094E+00,-0.65222E+00,-0.65349E+00,-0.65475E+00,-0.65599E+00,&
     -0.65721E+00,-0.65843E+00,-0.65963E+00,-0.66082E+00,-0.66199E+00,&
     -0.66315E+00,-0.66431E+00,-0.66544E+00,-0.66657E+00,-0.66769E+00,&
     -0.66879E+00,-0.66989E+00,-0.67097E+00,-0.67204E+00,-0.67310E+00,&
     -0.67415E+00,-0.67520E+00,-0.67623E+00,-0.67725E+00,-0.67826E+00,&
     -0.67927E+00,-0.68026E+00,-0.68124E+00,-0.68222E+00,-0.68319E+00,&
     -0.68415E+00,-0.68510E+00,-0.68604E+00,-0.68697E+00,-0.68790E+00,&
     -0.68881E+00,-0.68972E+00,-0.69062E+00,-0.69152E+00,-0.69241E+00,&
     -0.69329E+00,-0.69416E+00,-0.69502E+00,-0.69588E+00,-0.69673E+00,&
     -0.69758E+00,-0.69841E+00,-0.69924E+00,-0.70007E+00,-0.70089E+00,&
     -0.70170E+00,-0.70250E+00,-0.70330E+00,-0.70410E+00,-0.70488E+00,&
     -0.70566E+00,-0.70644E+00,-0.70721E+00,-0.70797E+00,-0.70873E+00,&
     -0.70948E+00,-0.71023E+00,-0.71097E+00,-0.71171E+00,-0.71244E+00,&
     -0.71317E+00,-0.71389E+00,-0.71460E+00,-0.71531E+00,-0.71602E+00/
                             
     DATA (BNC03M(IA),IA=701,741)/                                      &
     -0.71672E+00,-0.71742E+00,-0.71811E+00,-0.71880E+00,-0.71948E+00,&
     -0.72016E+00,-0.72083E+00,-0.72150E+00,-0.72216E+00,-0.72282E+00,&
     -0.72348E+00,-0.72413E+00,-0.72478E+00,-0.72542E+00,-0.72606E+00,&
     -0.72670E+00,-0.72733E+00,-0.72795E+00,-0.72858E+00,-0.72920E+00,&
     -0.72981E+00,-0.73042E+00,-0.73103E+00,-0.73163E+00,-0.73223E+00,&
     -0.73283E+00,-0.73342E+00,-0.73401E+00,-0.73460E+00,-0.73518E+00,&
     -0.73576E+00,-0.73634E+00,-0.73691E+00,-0.73748E+00,-0.73805E+00,&
     -0.73861E+00,-0.73917E+00,-0.73972E+00,-0.74028E+00,-0.74083E+00,&
     -0.74137E+00                  /                      
!                            
!  ** (NH4)2SO4              
!                            
     DATA (BNC04M (IA),IA=  1,100)/                                     &
     -0.10306E+00,-0.18795E+00,-0.24786E+00,-0.28872E+00,-0.32027E+00,&
     -0.34614E+00,-0.36814E+00,-0.38733E+00,-0.40435E+00,-0.41967E+00,&
     -0.43360E+00,-0.44638E+00,-0.45819E+00,-0.46917E+00,-0.47943E+00,&
     -0.48906E+00,-0.49813E+00,-0.50671E+00,-0.51485E+00,-0.52259E+00,&
     -0.52997E+00,-0.53702E+00,-0.54377E+00,-0.55025E+00,-0.55647E+00,&
     -0.56246E+00,-0.56823E+00,-0.57380E+00,-0.57918E+00,-0.58438E+00,&
     -0.58942E+00,-0.59430E+00,-0.59904E+00,-0.60363E+00,-0.60810E+00,&
     -0.61245E+00,-0.61668E+00,-0.62079E+00,-0.62480E+00,-0.62872E+00,&
     -0.63253E+00,-0.63626E+00,-0.63989E+00,-0.64345E+00,-0.64692E+00,&
     -0.65032E+00,-0.65365E+00,-0.65690E+00,-0.66009E+00,-0.66321E+00,&
     -0.66627E+00,-0.66927E+00,-0.67221E+00,-0.67510E+00,-0.67793E+00,&
     -0.68071E+00,-0.68344E+00,-0.68613E+00,-0.68876E+00,-0.69136E+00,&
     -0.69391E+00,-0.69641E+00,-0.69888E+00,-0.70131E+00,-0.70370E+00,&
     -0.70606E+00,-0.70838E+00,-0.71067E+00,-0.71292E+00,-0.71514E+00,&
     -0.71734E+00,-0.71950E+00,-0.72164E+00,-0.72374E+00,-0.72582E+00,&
     -0.72788E+00,-0.72991E+00,-0.73191E+00,-0.73390E+00,-0.73586E+00,&
     -0.73780E+00,-0.73971E+00,-0.74161E+00,-0.74349E+00,-0.74534E+00,&
     -0.74718E+00,-0.74900E+00,-0.75080E+00,-0.75259E+00,-0.75436E+00,&
     -0.75611E+00,-0.75784E+00,-0.75956E+00,-0.76127E+00,-0.76296E+00,&
     -0.76463E+00,-0.76629E+00,-0.76794E+00,-0.76957E+00,-0.77119E+00/
                             
     DATA (BNC04M (IA),IA=101,200)/                                     &
     -0.77280E+00,-0.77439E+00,-0.77597E+00,-0.77754E+00,-0.77910E+00,&
     -0.78064E+00,-0.78218E+00,-0.78370E+00,-0.78520E+00,-0.78670E+00,&
     -0.78819E+00,-0.78966E+00,-0.79113E+00,-0.79258E+00,-0.79402E+00,&
     -0.79545E+00,-0.79687E+00,-0.79828E+00,-0.79968E+00,-0.80107E+00,&
     -0.80241E+00,-0.80378E+00,-0.80515E+00,-0.80650E+00,-0.80785E+00,&
     -0.80918E+00,-0.81051E+00,-0.81183E+00,-0.81313E+00,-0.81443E+00,&
     -0.81572E+00,-0.81700E+00,-0.81827E+00,-0.81953E+00,-0.82078E+00,&
     -0.82203E+00,-0.82327E+00,-0.82449E+00,-0.82571E+00,-0.82692E+00,&
     -0.82813E+00,-0.82932E+00,-0.83051E+00,-0.83169E+00,-0.83287E+00,&
     -0.83403E+00,-0.83519E+00,-0.83634E+00,-0.83748E+00,-0.83862E+00,&
     -0.83975E+00,-0.84087E+00,-0.84199E+00,-0.84310E+00,-0.84420E+00,&
     -0.84530E+00,-0.84639E+00,-0.84747E+00,-0.84855E+00,-0.84962E+00,&
     -0.85068E+00,-0.85174E+00,-0.85280E+00,-0.85384E+00,-0.85488E+00,&
     -0.85592E+00,-0.85695E+00,-0.85797E+00,-0.85899E+00,-0.86000E+00,&
     -0.86101E+00,-0.86201E+00,-0.86301E+00,-0.86400E+00,-0.86498E+00,&
     -0.86596E+00,-0.86694E+00,-0.86791E+00,-0.86887E+00,-0.86983E+00,&
     -0.87079E+00,-0.87174E+00,-0.87268E+00,-0.87362E+00,-0.87456E+00,&
     -0.87549E+00,-0.87642E+00,-0.87734E+00,-0.87826E+00,-0.87917E+00,&
     -0.88008E+00,-0.88098E+00,-0.88188E+00,-0.88278E+00,-0.88367E+00,&
     -0.88456E+00,-0.88544E+00,-0.88632E+00,-0.88719E+00,-0.88806E+00/
                             
     DATA (BNC04M (IA),IA=201,300)/                                     &
     -0.88893E+00,-0.88979E+00,-0.89065E+00,-0.89151E+00,-0.89236E+00,&
     -0.89320E+00,-0.89405E+00,-0.89489E+00,-0.89572E+00,-0.89655E+00,&
     -0.89738E+00,-0.89821E+00,-0.89903E+00,-0.89984E+00,-0.90066E+00,&
     -0.90147E+00,-0.90227E+00,-0.90308E+00,-0.90388E+00,-0.90467E+00,&
     -0.90547E+00,-0.90626E+00,-0.90704E+00,-0.90783E+00,-0.90861E+00,&
     -0.90938E+00,-0.91016E+00,-0.91093E+00,-0.91169E+00,-0.91246E+00,&
     -0.91322E+00,-0.91398E+00,-0.91473E+00,-0.91548E+00,-0.91623E+00,&
     -0.91698E+00,-0.91772E+00,-0.91846E+00,-0.91920E+00,-0.91993E+00,&
     -0.92066E+00,-0.92139E+00,-0.92211E+00,-0.92284E+00,-0.92356E+00,&
     -0.92427E+00,-0.92499E+00,-0.92570E+00,-0.92641E+00,-0.92712E+00,&
     -0.92782E+00,-0.92852E+00,-0.92922E+00,-0.92991E+00,-0.93061E+00,&
     -0.93130E+00,-0.93199E+00,-0.93267E+00,-0.93336E+00,-0.93404E+00,&
     -0.93471E+00,-0.93539E+00,-0.93606E+00,-0.93674E+00,-0.93740E+00,&
     -0.93807E+00,-0.93873E+00,-0.93940E+00,-0.94005E+00,-0.94071E+00,&
     -0.94137E+00,-0.94202E+00,-0.94267E+00,-0.94332E+00,-0.94396E+00,&
     -0.94460E+00,-0.94525E+00,-0.94589E+00,-0.94652E+00,-0.94716E+00,&
     -0.94779E+00,-0.94842E+00,-0.94905E+00,-0.94967E+00,-0.95030E+00,&
     -0.95092E+00,-0.95154E+00,-0.95216E+00,-0.95277E+00,-0.95339E+00,&
     -0.95400E+00,-0.95461E+00,-0.95522E+00,-0.95582E+00,-0.95643E+00,&
     -0.95703E+00,-0.95763E+00,-0.95823E+00,-0.95882E+00,-0.95942E+00/
                             
     DATA (BNC04M (IA),IA=301,400)/                                     &
     -0.96001E+00,-0.96060E+00,-0.96119E+00,-0.96178E+00,-0.96236E+00,&
     -0.96294E+00,-0.96353E+00,-0.96411E+00,-0.96468E+00,-0.96526E+00,&
     -0.96583E+00,-0.96641E+00,-0.96698E+00,-0.96755E+00,-0.96811E+00,&
     -0.96868E+00,-0.96924E+00,-0.96981E+00,-0.97037E+00,-0.97092E+00,&
     -0.97148E+00,-0.97204E+00,-0.97259E+00,-0.97314E+00,-0.97369E+00,&
     -0.97424E+00,-0.97479E+00,-0.97534E+00,-0.97588E+00,-0.97642E+00,&
     -0.97696E+00,-0.97750E+00,-0.97804E+00,-0.97858E+00,-0.97911E+00,&
     -0.97965E+00,-0.98018E+00,-0.98071E+00,-0.98124E+00,-0.98176E+00,&
     -0.98229E+00,-0.98281E+00,-0.98334E+00,-0.98386E+00,-0.98438E+00,&
     -0.98490E+00,-0.98541E+00,-0.98593E+00,-0.98644E+00,-0.98696E+00,&
     -0.98747E+00,-0.98798E+00,-0.98849E+00,-0.98899E+00,-0.98950E+00,&
     -0.99000E+00,-0.99051E+00,-0.99101E+00,-0.99151E+00,-0.99201E+00,&
     -0.99251E+00,-0.99300E+00,-0.99350E+00,-0.99399E+00,-0.99448E+00,&
     -0.99497E+00,-0.99546E+00,-0.99595E+00,-0.99644E+00,-0.99693E+00,&
     -0.99741E+00,-0.99789E+00,-0.99838E+00,-0.99886E+00,-0.99934E+00,&
     -0.99982E+00,-0.10003E+01,-0.10008E+01,-0.10012E+01,-0.10017E+01,&
     -0.10022E+01,-0.10027E+01,-0.10031E+01,-0.10036E+01,-0.10041E+01,&
     -0.10045E+01,-0.10050E+01,-0.10055E+01,-0.10059E+01,-0.10064E+01,&
     -0.10068E+01,-0.10073E+01,-0.10078E+01,-0.10082E+01,-0.10087E+01,&
     -0.10091E+01,-0.10096E+01,-0.10100E+01,-0.10105E+01,-0.10109E+01/
                             
     DATA (BNC04M (IA),IA=401,500)/                                     &
     -0.10114E+01,-0.10118E+01,-0.10123E+01,-0.10127E+01,-0.10132E+01,&
     -0.10136E+01,-0.10141E+01,-0.10145E+01,-0.10149E+01,-0.10154E+01,&
     -0.10158E+01,-0.10163E+01,-0.10167E+01,-0.10171E+01,-0.10176E+01,&
     -0.10180E+01,-0.10184E+01,-0.10189E+01,-0.10193E+01,-0.10197E+01,&
     -0.10202E+01,-0.10206E+01,-0.10210E+01,-0.10214E+01,-0.10219E+01,&
     -0.10223E+01,-0.10227E+01,-0.10231E+01,-0.10236E+01,-0.10240E+01,&
     -0.10244E+01,-0.10248E+01,-0.10252E+01,-0.10256E+01,-0.10261E+01,&
     -0.10265E+01,-0.10269E+01,-0.10273E+01,-0.10277E+01,-0.10281E+01,&
     -0.10285E+01,-0.10289E+01,-0.10293E+01,-0.10298E+01,-0.10302E+01,&
     -0.10306E+01,-0.10310E+01,-0.10314E+01,-0.10318E+01,-0.10322E+01,&
     -0.10326E+01,-0.10330E+01,-0.10334E+01,-0.10338E+01,-0.10342E+01,&
     -0.10346E+01,-0.10350E+01,-0.10354E+01,-0.10357E+01,-0.10361E+01,&
     -0.10365E+01,-0.10369E+01,-0.10373E+01,-0.10377E+01,-0.10381E+01,&
     -0.10385E+01,-0.10389E+01,-0.10393E+01,-0.10396E+01,-0.10400E+01,&
     -0.10404E+01,-0.10408E+01,-0.10412E+01,-0.10416E+01,-0.10419E+01,&
     -0.10423E+01,-0.10427E+01,-0.10431E+01,-0.10435E+01,-0.10438E+01,&
     -0.10442E+01,-0.10446E+01,-0.10450E+01,-0.10453E+01,-0.10457E+01,&
     -0.10461E+01,-0.10464E+01,-0.10468E+01,-0.10472E+01,-0.10476E+01,&
     -0.10479E+01,-0.10483E+01,-0.10487E+01,-0.10490E+01,-0.10494E+01,&
     -0.10498E+01,-0.10501E+01,-0.10505E+01,-0.10508E+01,-0.10512E+01/
                             
     DATA (BNC04M (IA),IA=501,600)/                                     &
     -0.10516E+01,-0.10519E+01,-0.10523E+01,-0.10526E+01,-0.10530E+01,&
     -0.10534E+01,-0.10537E+01,-0.10541E+01,-0.10544E+01,-0.10548E+01,&
     -0.10551E+01,-0.10555E+01,-0.10558E+01,-0.10562E+01,-0.10565E+01,&
     -0.10569E+01,-0.10572E+01,-0.10576E+01,-0.10579E+01,-0.10583E+01,&
     -0.10586E+01,-0.10590E+01,-0.10593E+01,-0.10597E+01,-0.10600E+01,&
     -0.10604E+01,-0.10607E+01,-0.10611E+01,-0.10614E+01,-0.10617E+01,&
     -0.10621E+01,-0.10624E+01,-0.10628E+01,-0.10631E+01,-0.10634E+01,&
     -0.10638E+01,-0.10641E+01,-0.10644E+01,-0.10648E+01,-0.10651E+01,&
     -0.10655E+01,-0.10658E+01,-0.10661E+01,-0.10665E+01,-0.10668E+01,&
     -0.10671E+01,-0.10674E+01,-0.10678E+01,-0.10681E+01,-0.10684E+01,&
     -0.10688E+01,-0.10691E+01,-0.10694E+01,-0.10697E+01,-0.10701E+01,&
     -0.10704E+01,-0.10707E+01,-0.10710E+01,-0.10714E+01,-0.10717E+01,&
     -0.10720E+01,-0.10723E+01,-0.10727E+01,-0.10730E+01,-0.10733E+01,&
     -0.10736E+01,-0.10739E+01,-0.10743E+01,-0.10746E+01,-0.10749E+01,&
     -0.10752E+01,-0.10755E+01,-0.10758E+01,-0.10762E+01,-0.10765E+01,&
     -0.10768E+01,-0.10771E+01,-0.10774E+01,-0.10777E+01,-0.10780E+01,&
     -0.10783E+01,-0.10787E+01,-0.10790E+01,-0.10793E+01,-0.10796E+01,&
     -0.10799E+01,-0.10802E+01,-0.10805E+01,-0.10808E+01,-0.10811E+01,&
     -0.10814E+01,-0.10817E+01,-0.10820E+01,-0.10823E+01,-0.10827E+01,&
     -0.10830E+01,-0.10833E+01,-0.10836E+01,-0.10839E+01,-0.10850E+01/
                             
     DATA (BNC04M (IA),IA=601,700)/                                     &
     -0.10874E+01,-0.10904E+01,-0.10933E+01,-0.10961E+01,-0.10989E+01,&
     -0.11017E+01,-0.11044E+01,-0.11070E+01,-0.11097E+01,-0.11123E+01,&
     -0.11148E+01,-0.11173E+01,-0.11198E+01,-0.11223E+01,-0.11247E+01,&
     -0.11271E+01,-0.11294E+01,-0.11317E+01,-0.11340E+01,-0.11363E+01,&
     -0.11385E+01,-0.11407E+01,-0.11429E+01,-0.11450E+01,-0.11471E+01,&
     -0.11492E+01,-0.11513E+01,-0.11534E+01,-0.11554E+01,-0.11574E+01,&
     -0.11593E+01,-0.11613E+01,-0.11632E+01,-0.11651E+01,-0.11670E+01,&
     -0.11689E+01,-0.11707E+01,-0.11726E+01,-0.11744E+01,-0.11762E+01,&
     -0.11779E+01,-0.11797E+01,-0.11814E+01,-0.11831E+01,-0.11848E+01,&
     -0.11865E+01,-0.11882E+01,-0.11898E+01,-0.11915E+01,-0.11931E+01,&
     -0.11947E+01,-0.11963E+01,-0.11978E+01,-0.11994E+01,-0.12009E+01,&
     -0.12025E+01,-0.12040E+01,-0.12055E+01,-0.12070E+01,-0.12084E+01,&
     -0.12099E+01,-0.12114E+01,-0.12128E+01,-0.12142E+01,-0.12156E+01,&
     -0.12170E+01,-0.12184E+01,-0.12198E+01,-0.12212E+01,-0.12225E+01,&
     -0.12238E+01,-0.12252E+01,-0.12265E+01,-0.12278E+01,-0.12291E+01,&
     -0.12304E+01,-0.12317E+01,-0.12329E+01,-0.12342E+01,-0.12355E+01,&
     -0.12367E+01,-0.12379E+01,-0.12391E+01,-0.12404E+01,-0.12416E+01,&
     -0.12428E+01,-0.12439E+01,-0.12451E+01,-0.12463E+01,-0.12474E+01,&
     -0.12486E+01,-0.12497E+01,-0.12509E+01,-0.12520E+01,-0.12531E+01,&
     -0.12542E+01,-0.12553E+01,-0.12564E+01,-0.12575E+01,-0.12586E+01/
                             
     DATA (BNC04M(IA),IA=701,741)/                                      &
     -0.12597E+01,-0.12607E+01,-0.12618E+01,-0.12629E+01,-0.12639E+01,&
     -0.12649E+01,-0.12660E+01,-0.12670E+01,-0.12680E+01,-0.12690E+01,&
     -0.12700E+01,-0.12710E+01,-0.12720E+01,-0.12730E+01,-0.12740E+01,&
     -0.12750E+01,-0.12760E+01,-0.12769E+01,-0.12779E+01,-0.12788E+01,&
     -0.12798E+01,-0.12807E+01,-0.12816E+01,-0.12826E+01,-0.12835E+01,&
     -0.12844E+01,-0.12853E+01,-0.12862E+01,-0.12871E+01,-0.12880E+01,&
     -0.12889E+01,-0.12898E+01,-0.12907E+01,-0.12916E+01,-0.12924E+01,&
     -0.12933E+01,-0.12942E+01,-0.12950E+01,-0.12959E+01,-0.12967E+01,&
     -0.12976E+01                 /                      
!                            
!  ** NH4NO3                 
!                            
     DATA (BNC05M (IA),IA=  1,100)/                                     &
     -0.52199E-01,-0.96472E-01,-0.12869E+00,-0.15126E+00,-0.16910E+00,&
     -0.18404E+00,-0.19701E+00,-0.20852E+00,-0.21891E+00,-0.22842E+00,&
     -0.23721E+00,-0.24540E+00,-0.25307E+00,-0.26031E+00,-0.26716E+00,&
     -0.27368E+00,-0.27990E+00,-0.28586E+00,-0.29157E+00,-0.29707E+00,&
     -0.30237E+00,-0.30748E+00,-0.31243E+00,-0.31723E+00,-0.32188E+00,&
     -0.32639E+00,-0.33078E+00,-0.33506E+00,-0.33922E+00,-0.34328E+00,&
     -0.34724E+00,-0.35110E+00,-0.35488E+00,-0.35857E+00,-0.36218E+00,&
     -0.36571E+00,-0.36917E+00,-0.37256E+00,-0.37588E+00,-0.37914E+00,&
     -0.38233E+00,-0.38547E+00,-0.38854E+00,-0.39156E+00,-0.39452E+00,&
     -0.39743E+00,-0.40030E+00,-0.40311E+00,-0.40587E+00,-0.40860E+00,&
     -0.41127E+00,-0.41391E+00,-0.41650E+00,-0.41905E+00,-0.42157E+00,&
     -0.42404E+00,-0.42649E+00,-0.42890E+00,-0.43127E+00,-0.43361E+00,&
     -0.43593E+00,-0.43821E+00,-0.44046E+00,-0.44269E+00,-0.44489E+00,&
     -0.44707E+00,-0.44922E+00,-0.45135E+00,-0.45345E+00,-0.45554E+00,&
     -0.45760E+00,-0.45964E+00,-0.46167E+00,-0.46368E+00,-0.46567E+00,&
     -0.46764E+00,-0.46960E+00,-0.47154E+00,-0.47347E+00,-0.47539E+00,&
     -0.47729E+00,-0.47918E+00,-0.48106E+00,-0.48293E+00,-0.48478E+00,&
     -0.48663E+00,-0.48846E+00,-0.49029E+00,-0.49211E+00,-0.49391E+00,&
     -0.49571E+00,-0.49750E+00,-0.49928E+00,-0.50105E+00,-0.50282E+00,&
     -0.50458E+00,-0.50633E+00,-0.50807E+00,-0.50980E+00,-0.51153E+00/
                             
     DATA (BNC05M (IA),IA=101,200)/                                     &
     -0.51325E+00,-0.51496E+00,-0.51667E+00,-0.51837E+00,-0.52006E+00,&
     -0.52174E+00,-0.52342E+00,-0.52508E+00,-0.52675E+00,-0.52840E+00,&
     -0.53005E+00,-0.53169E+00,-0.53332E+00,-0.53494E+00,-0.53656E+00,&
     -0.53817E+00,-0.53977E+00,-0.54137E+00,-0.54295E+00,-0.54453E+00,&
     -0.54599E+00,-0.54757E+00,-0.54914E+00,-0.55070E+00,-0.55225E+00,&
     -0.55379E+00,-0.55532E+00,-0.55685E+00,-0.55836E+00,-0.55987E+00,&
     -0.56137E+00,-0.56286E+00,-0.56435E+00,-0.56582E+00,-0.56729E+00,&
     -0.56875E+00,-0.57020E+00,-0.57165E+00,-0.57308E+00,-0.57451E+00,&
     -0.57594E+00,-0.57735E+00,-0.57876E+00,-0.58016E+00,-0.58156E+00,&
     -0.58294E+00,-0.58432E+00,-0.58570E+00,-0.58706E+00,-0.58842E+00,&
     -0.58977E+00,-0.59112E+00,-0.59246E+00,-0.59379E+00,-0.59512E+00,&
     -0.59644E+00,-0.59775E+00,-0.59906E+00,-0.60036E+00,-0.60166E+00,&
     -0.60295E+00,-0.60423E+00,-0.60551E+00,-0.60678E+00,-0.60805E+00,&
     -0.60931E+00,-0.61056E+00,-0.61181E+00,-0.61305E+00,-0.61429E+00,&
     -0.61552E+00,-0.61675E+00,-0.61797E+00,-0.61918E+00,-0.62039E+00,&
     -0.62160E+00,-0.62280E+00,-0.62399E+00,-0.62518E+00,-0.62636E+00,&
     -0.62754E+00,-0.62872E+00,-0.62988E+00,-0.63105E+00,-0.63221E+00,&
     -0.63336E+00,-0.63451E+00,-0.63565E+00,-0.63679E+00,-0.63792E+00,&
     -0.63905E+00,-0.64018E+00,-0.64130E+00,-0.64241E+00,-0.64352E+00,&
     -0.64463E+00,-0.64573E+00,-0.64683E+00,-0.64792E+00,-0.64901E+00/
                             
     DATA (BNC05M (IA),IA=201,300)/                                     &
     -0.65009E+00,-0.65117E+00,-0.65225E+00,-0.65332E+00,-0.65438E+00,&
     -0.65545E+00,-0.65650E+00,-0.65756E+00,-0.65861E+00,-0.65965E+00,&
     -0.66069E+00,-0.66173E+00,-0.66276E+00,-0.66379E+00,-0.66482E+00,&
     -0.66584E+00,-0.66686E+00,-0.66787E+00,-0.66888E+00,-0.66989E+00,&
     -0.67089E+00,-0.67189E+00,-0.67288E+00,-0.67387E+00,-0.67486E+00,&
     -0.67584E+00,-0.67682E+00,-0.67780E+00,-0.67877E+00,-0.67974E+00,&
     -0.68070E+00,-0.68166E+00,-0.68262E+00,-0.68358E+00,-0.68453E+00,&
     -0.68548E+00,-0.68642E+00,-0.68736E+00,-0.68830E+00,-0.68923E+00,&
     -0.69016E+00,-0.69109E+00,-0.69201E+00,-0.69293E+00,-0.69385E+00,&
     -0.69476E+00,-0.69567E+00,-0.69658E+00,-0.69749E+00,-0.69839E+00,&
     -0.69928E+00,-0.70018E+00,-0.70107E+00,-0.70196E+00,-0.70284E+00,&
     -0.70373E+00,-0.70461E+00,-0.70548E+00,-0.70636E+00,-0.70723E+00,&
     -0.70809E+00,-0.70896E+00,-0.70982E+00,-0.71068E+00,-0.71153E+00,&
     -0.71238E+00,-0.71323E+00,-0.71408E+00,-0.71492E+00,-0.71577E+00,&
     -0.71660E+00,-0.71744E+00,-0.71827E+00,-0.71910E+00,-0.71993E+00,&
     -0.72075E+00,-0.72158E+00,-0.72239E+00,-0.72321E+00,-0.72402E+00,&
     -0.72484E+00,-0.72564E+00,-0.72645E+00,-0.72725E+00,-0.72805E+00,&
     -0.72885E+00,-0.72965E+00,-0.73044E+00,-0.73123E+00,-0.73202E+00,&
     -0.73280E+00,-0.73359E+00,-0.73437E+00,-0.73514E+00,-0.73592E+00,&
     -0.73669E+00,-0.73746E+00,-0.73823E+00,-0.73899E+00,-0.73976E+00/
                             
     DATA (BNC05M (IA),IA=301,400)/                                     &
     -0.74052E+00,-0.74128E+00,-0.74203E+00,-0.74279E+00,-0.74354E+00,&
     -0.74429E+00,-0.74503E+00,-0.74578E+00,-0.74652E+00,-0.74726E+00,&
     -0.74800E+00,-0.74873E+00,-0.74946E+00,-0.75019E+00,-0.75092E+00,&
     -0.75165E+00,-0.75237E+00,-0.75309E+00,-0.75381E+00,-0.75453E+00,&
     -0.75525E+00,-0.75596E+00,-0.75667E+00,-0.75738E+00,-0.75809E+00,&
     -0.75879E+00,-0.75949E+00,-0.76019E+00,-0.76089E+00,-0.76159E+00,&
     -0.76228E+00,-0.76297E+00,-0.76366E+00,-0.76435E+00,-0.76504E+00,&
     -0.76572E+00,-0.76641E+00,-0.76709E+00,-0.76776E+00,-0.76844E+00,&
     -0.76911E+00,-0.76979E+00,-0.77046E+00,-0.77112E+00,-0.77179E+00,&
     -0.77246E+00,-0.77312E+00,-0.77378E+00,-0.77444E+00,-0.77509E+00,&
     -0.77575E+00,-0.77640E+00,-0.77705E+00,-0.77770E+00,-0.77835E+00,&
     -0.77900E+00,-0.77964E+00,-0.78028E+00,-0.78092E+00,-0.78156E+00,&
     -0.78220E+00,-0.78283E+00,-0.78347E+00,-0.78410E+00,-0.78473E+00,&
     -0.78536E+00,-0.78598E+00,-0.78661E+00,-0.78723E+00,-0.78785E+00,&
     -0.78847E+00,-0.78909E+00,-0.78970E+00,-0.79032E+00,-0.79093E+00,&
     -0.79154E+00,-0.79215E+00,-0.79276E+00,-0.79336E+00,-0.79397E+00,&
     -0.79457E+00,-0.79517E+00,-0.79577E+00,-0.79637E+00,-0.79696E+00,&
     -0.79756E+00,-0.79815E+00,-0.79874E+00,-0.79933E+00,-0.79992E+00,&
     -0.80051E+00,-0.80109E+00,-0.80168E+00,-0.80226E+00,-0.80284E+00,&
     -0.80342E+00,-0.80399E+00,-0.80457E+00,-0.80514E+00,-0.80572E+00/
                             
     DATA (BNC05M (IA),IA=401,500)/                                     &
     -0.80629E+00,-0.80686E+00,-0.80743E+00,-0.80799E+00,-0.80856E+00,&
     -0.80912E+00,-0.80968E+00,-0.81025E+00,-0.81081E+00,-0.81136E+00,&
     -0.81192E+00,-0.81248E+00,-0.81303E+00,-0.81358E+00,-0.81413E+00,&
     -0.81468E+00,-0.81523E+00,-0.81578E+00,-0.81632E+00,-0.81687E+00,&
     -0.81741E+00,-0.81795E+00,-0.81849E+00,-0.81903E+00,-0.81956E+00,&
     -0.82010E+00,-0.82063E+00,-0.82117E+00,-0.82170E+00,-0.82223E+00,&
     -0.82276E+00,-0.82329E+00,-0.82381E+00,-0.82434E+00,-0.82486E+00,&
     -0.82538E+00,-0.82590E+00,-0.82642E+00,-0.82694E+00,-0.82746E+00,&
     -0.82798E+00,-0.82849E+00,-0.82900E+00,-0.82952E+00,-0.83003E+00,&
     -0.83054E+00,-0.83104E+00,-0.83155E+00,-0.83206E+00,-0.83256E+00,&
     -0.83307E+00,-0.83357E+00,-0.83407E+00,-0.83457E+00,-0.83507E+00,&
     -0.83556E+00,-0.83606E+00,-0.83656E+00,-0.83705E+00,-0.83754E+00,&
     -0.83803E+00,-0.83852E+00,-0.83901E+00,-0.83950E+00,-0.83999E+00,&
     -0.84047E+00,-0.84096E+00,-0.84144E+00,-0.84192E+00,-0.84240E+00,&
     -0.84288E+00,-0.84336E+00,-0.84384E+00,-0.84432E+00,-0.84479E+00,&
     -0.84527E+00,-0.84574E+00,-0.84621E+00,-0.84668E+00,-0.84715E+00,&
     -0.84762E+00,-0.84809E+00,-0.84855E+00,-0.84902E+00,-0.84948E+00,&
     -0.84995E+00,-0.85041E+00,-0.85087E+00,-0.85133E+00,-0.85179E+00,&
     -0.85225E+00,-0.85270E+00,-0.85316E+00,-0.85361E+00,-0.85407E+00,&
     -0.85452E+00,-0.85497E+00,-0.85542E+00,-0.85587E+00,-0.85632E+00/
                             
     DATA (BNC05M (IA),IA=501,600)/                                     &
     -0.85677E+00,-0.85721E+00,-0.85766E+00,-0.85810E+00,-0.85855E+00,&
     -0.85899E+00,-0.85943E+00,-0.85987E+00,-0.86031E+00,-0.86075E+00,&
     -0.86119E+00,-0.86162E+00,-0.86206E+00,-0.86249E+00,-0.86293E+00,&
     -0.86336E+00,-0.86379E+00,-0.86422E+00,-0.86465E+00,-0.86508E+00,&
     -0.86551E+00,-0.86593E+00,-0.86636E+00,-0.86678E+00,-0.86721E+00,&
     -0.86763E+00,-0.86805E+00,-0.86848E+00,-0.86890E+00,-0.86931E+00,&
     -0.86973E+00,-0.87015E+00,-0.87057E+00,-0.87098E+00,-0.87140E+00,&
     -0.87181E+00,-0.87222E+00,-0.87264E+00,-0.87305E+00,-0.87346E+00,&
     -0.87387E+00,-0.87428E+00,-0.87468E+00,-0.87509E+00,-0.87550E+00,&
     -0.87590E+00,-0.87630E+00,-0.87671E+00,-0.87711E+00,-0.87751E+00,&
     -0.87791E+00,-0.87831E+00,-0.87871E+00,-0.87911E+00,-0.87951E+00,&
     -0.87990E+00,-0.88030E+00,-0.88069E+00,-0.88109E+00,-0.88148E+00,&
     -0.88187E+00,-0.88226E+00,-0.88265E+00,-0.88304E+00,-0.88343E+00,&
     -0.88382E+00,-0.88421E+00,-0.88459E+00,-0.88498E+00,-0.88537E+00,&
     -0.88575E+00,-0.88613E+00,-0.88651E+00,-0.88690E+00,-0.88728E+00,&
     -0.88766E+00,-0.88804E+00,-0.88841E+00,-0.88879E+00,-0.88917E+00,&
     -0.88955E+00,-0.88992E+00,-0.89030E+00,-0.89067E+00,-0.89104E+00,&
     -0.89141E+00,-0.89179E+00,-0.89216E+00,-0.89253E+00,-0.89290E+00,&
     -0.89326E+00,-0.89363E+00,-0.89400E+00,-0.89436E+00,-0.89473E+00,&
     -0.89509E+00,-0.89546E+00,-0.89582E+00,-0.89618E+00,-0.89754E+00/
                             
     DATA (BNC05M (IA),IA=601,700)/                                     &
     -0.90048E+00,-0.90398E+00,-0.90741E+00,-0.91077E+00,-0.91407E+00,&
     -0.91731E+00,-0.92048E+00,-0.92360E+00,-0.92666E+00,-0.92966E+00,&
     -0.93261E+00,-0.93551E+00,-0.93835E+00,-0.94115E+00,-0.94389E+00,&
     -0.94659E+00,-0.94924E+00,-0.95185E+00,-0.95441E+00,-0.95693E+00,&
     -0.95941E+00,-0.96185E+00,-0.96425E+00,-0.96661E+00,-0.96893E+00,&
     -0.97121E+00,-0.97346E+00,-0.97568E+00,-0.97786E+00,-0.98000E+00,&
     -0.98212E+00,-0.98420E+00,-0.98625E+00,-0.98827E+00,-0.99026E+00,&
     -0.99222E+00,-0.99415E+00,-0.99605E+00,-0.99793E+00,-0.99978E+00,&
     -0.10016E+01,-0.10034E+01,-0.10052E+01,-0.10069E+01,-0.10087E+01,&
     -0.10104E+01,-0.10120E+01,-0.10137E+01,-0.10153E+01,-0.10169E+01,&
     -0.10185E+01,-0.10201E+01,-0.10216E+01,-0.10232E+01,-0.10247E+01,&
     -0.10262E+01,-0.10276E+01,-0.10291E+01,-0.10305E+01,-0.10319E+01,&
     -0.10333E+01,-0.10347E+01,-0.10361E+01,-0.10374E+01,-0.10388E+01,&
     -0.10401E+01,-0.10414E+01,-0.10427E+01,-0.10439E+01,-0.10452E+01,&
     -0.10464E+01,-0.10477E+01,-0.10489E+01,-0.10501E+01,-0.10513E+01,&
     -0.10524E+01,-0.10536E+01,-0.10547E+01,-0.10559E+01,-0.10570E+01,&
     -0.10581E+01,-0.10592E+01,-0.10603E+01,-0.10613E+01,-0.10624E+01,&
     -0.10635E+01,-0.10645E+01,-0.10655E+01,-0.10665E+01,-0.10675E+01,&
     -0.10685E+01,-0.10695E+01,-0.10705E+01,-0.10715E+01,-0.10724E+01,&
     -0.10734E+01,-0.10743E+01,-0.10752E+01,-0.10761E+01,-0.10770E+01/
                             
     DATA (BNC05M(IA),IA=701,741)/                                      &
     -0.10779E+01,-0.10788E+01,-0.10797E+01,-0.10806E+01,-0.10814E+01,&
     -0.10823E+01,-0.10831E+01,-0.10840E+01,-0.10848E+01,-0.10856E+01,&
     -0.10865E+01,-0.10873E+01,-0.10881E+01,-0.10889E+01,-0.10896E+01,&
     -0.10904E+01,-0.10912E+01,-0.10920E+01,-0.10927E+01,-0.10935E+01,&
     -0.10942E+01,-0.10949E+01,-0.10957E+01,-0.10964E+01,-0.10971E+01,&
     -0.10978E+01,-0.10985E+01,-0.10992E+01,-0.10999E+01,-0.11006E+01,&
     -0.11013E+01,-0.11020E+01,-0.11026E+01,-0.11033E+01,-0.11039E+01,&
     -0.11046E+01,-0.11052E+01,-0.11059E+01,-0.11065E+01,-0.11071E+01,&
     -0.11078E+01                  /                      
!                            
!  ** NH4Cl                  
!                            
     DATA (BNC06M (IA),IA=  1,100)/                                     &
     -0.50814E-01,-0.91326E-01,-0.11891E+00,-0.13710E+00,-0.15072E+00,&
     -0.16157E+00,-0.17053E+00,-0.17813E+00,-0.18469E+00,-0.19042E+00,&
     -0.19549E+00,-0.20001E+00,-0.20407E+00,-0.20774E+00,-0.21107E+00,&
     -0.21410E+00,-0.21687E+00,-0.21942E+00,-0.22176E+00,-0.22392E+00,&
     -0.22592E+00,-0.22777E+00,-0.22948E+00,-0.23108E+00,-0.23256E+00,&
     -0.23394E+00,-0.23522E+00,-0.23642E+00,-0.23754E+00,-0.23858E+00,&
     -0.23956E+00,-0.24048E+00,-0.24133E+00,-0.24213E+00,-0.24288E+00,&
     -0.24359E+00,-0.24424E+00,-0.24486E+00,-0.24544E+00,-0.24598E+00,&
     -0.24649E+00,-0.24696E+00,-0.24741E+00,-0.24782E+00,-0.24821E+00,&
     -0.24858E+00,-0.24892E+00,-0.24923E+00,-0.24953E+00,-0.24980E+00,&
     -0.25006E+00,-0.25030E+00,-0.25052E+00,-0.25072E+00,-0.25091E+00,&
     -0.25108E+00,-0.25123E+00,-0.25137E+00,-0.25150E+00,-0.25161E+00,&
     -0.25171E+00,-0.25180E+00,-0.25188E+00,-0.25194E+00,-0.25199E+00,&
     -0.25203E+00,-0.25206E+00,-0.25207E+00,-0.25208E+00,-0.25207E+00,&
     -0.25205E+00,-0.25203E+00,-0.25199E+00,-0.25194E+00,-0.25188E+00,&
     -0.25180E+00,-0.25172E+00,-0.25163E+00,-0.25153E+00,-0.25141E+00,&
     -0.25129E+00,-0.25116E+00,-0.25101E+00,-0.25086E+00,-0.25070E+00,&
     -0.25052E+00,-0.25034E+00,-0.25015E+00,-0.24994E+00,-0.24973E+00,&
     -0.24951E+00,-0.24928E+00,-0.24904E+00,-0.24879E+00,-0.24854E+00,&
     -0.24827E+00,-0.24800E+00,-0.24772E+00,-0.24743E+00,-0.24713E+00/
                             
     DATA (BNC06M (IA),IA=101,200)/                                     &
     -0.24683E+00,-0.24651E+00,-0.24620E+00,-0.24587E+00,-0.24554E+00,&
     -0.24520E+00,-0.24485E+00,-0.24450E+00,-0.24415E+00,-0.24379E+00,&
     -0.24342E+00,-0.24305E+00,-0.24267E+00,-0.24229E+00,-0.24190E+00,&
     -0.24151E+00,-0.24112E+00,-0.24072E+00,-0.24032E+00,-0.23991E+00,&
     -0.23958E+00,-0.23916E+00,-0.23874E+00,-0.23831E+00,-0.23788E+00,&
     -0.23745E+00,-0.23702E+00,-0.23659E+00,-0.23615E+00,-0.23572E+00,&
     -0.23528E+00,-0.23484E+00,-0.23439E+00,-0.23395E+00,-0.23350E+00,&
     -0.23306E+00,-0.23261E+00,-0.23216E+00,-0.23171E+00,-0.23126E+00,&
     -0.23080E+00,-0.23035E+00,-0.22989E+00,-0.22944E+00,-0.22898E+00,&
     -0.22852E+00,-0.22806E+00,-0.22760E+00,-0.22713E+00,-0.22667E+00,&
     -0.22621E+00,-0.22574E+00,-0.22528E+00,-0.22481E+00,-0.22434E+00,&
     -0.22388E+00,-0.22341E+00,-0.22294E+00,-0.22247E+00,-0.22200E+00,&
     -0.22153E+00,-0.22105E+00,-0.22058E+00,-0.22011E+00,-0.21963E+00,&
     -0.21916E+00,-0.21869E+00,-0.21821E+00,-0.21773E+00,-0.21726E+00,&
     -0.21678E+00,-0.21631E+00,-0.21583E+00,-0.21535E+00,-0.21487E+00,&
     -0.21440E+00,-0.21392E+00,-0.21344E+00,-0.21296E+00,-0.21248E+00,&
     -0.21200E+00,-0.21152E+00,-0.21104E+00,-0.21056E+00,-0.21008E+00,&
     -0.20960E+00,-0.20912E+00,-0.20864E+00,-0.20816E+00,-0.20768E+00,&
     -0.20720E+00,-0.20672E+00,-0.20624E+00,-0.20576E+00,-0.20527E+00,&
     -0.20479E+00,-0.20431E+00,-0.20383E+00,-0.20335E+00,-0.20287E+00/
                             
     DATA (BNC06M (IA),IA=201,300)/                                     &
     -0.20239E+00,-0.20191E+00,-0.20143E+00,-0.20094E+00,-0.20046E+00,&
     -0.19998E+00,-0.19950E+00,-0.19902E+00,-0.19854E+00,-0.19806E+00,&
     -0.19758E+00,-0.19710E+00,-0.19662E+00,-0.19614E+00,-0.19566E+00,&
     -0.19518E+00,-0.19470E+00,-0.19422E+00,-0.19374E+00,-0.19326E+00,&
     -0.19278E+00,-0.19230E+00,-0.19182E+00,-0.19135E+00,-0.19087E+00,&
     -0.19039E+00,-0.18991E+00,-0.18943E+00,-0.18896E+00,-0.18848E+00,&
     -0.18800E+00,-0.18753E+00,-0.18705E+00,-0.18657E+00,-0.18610E+00,&
     -0.18562E+00,-0.18515E+00,-0.18467E+00,-0.18420E+00,-0.18372E+00,&
     -0.18325E+00,-0.18277E+00,-0.18230E+00,-0.18183E+00,-0.18135E+00,&
     -0.18088E+00,-0.18041E+00,-0.17994E+00,-0.17946E+00,-0.17899E+00,&
     -0.17852E+00,-0.17805E+00,-0.17758E+00,-0.17711E+00,-0.17664E+00,&
     -0.17617E+00,-0.17570E+00,-0.17523E+00,-0.17476E+00,-0.17430E+00,&
     -0.17383E+00,-0.17336E+00,-0.17289E+00,-0.17243E+00,-0.17196E+00,&
     -0.17149E+00,-0.17103E+00,-0.17056E+00,-0.17010E+00,-0.16963E+00,&
     -0.16917E+00,-0.16871E+00,-0.16824E+00,-0.16778E+00,-0.16732E+00,&
     -0.16685E+00,-0.16639E+00,-0.16593E+00,-0.16547E+00,-0.16501E+00,&
     -0.16455E+00,-0.16409E+00,-0.16363E+00,-0.16317E+00,-0.16271E+00,&
     -0.16225E+00,-0.16179E+00,-0.16134E+00,-0.16088E+00,-0.16042E+00,&
     -0.15997E+00,-0.15951E+00,-0.15905E+00,-0.15860E+00,-0.15814E+00,&
     -0.15769E+00,-0.15724E+00,-0.15678E+00,-0.15633E+00,-0.15588E+00/
                             
     DATA (BNC06M (IA),IA=301,400)/                                     &
     -0.15542E+00,-0.15497E+00,-0.15452E+00,-0.15407E+00,-0.15362E+00,&
     -0.15317E+00,-0.15272E+00,-0.15227E+00,-0.15182E+00,-0.15137E+00,&
     -0.15092E+00,-0.15048E+00,-0.15003E+00,-0.14958E+00,-0.14914E+00,&
     -0.14869E+00,-0.14825E+00,-0.14780E+00,-0.14736E+00,-0.14691E+00,&
     -0.14647E+00,-0.14602E+00,-0.14558E+00,-0.14514E+00,-0.14470E+00,&
     -0.14425E+00,-0.14381E+00,-0.14337E+00,-0.14293E+00,-0.14249E+00,&
     -0.14205E+00,-0.14161E+00,-0.14118E+00,-0.14074E+00,-0.14030E+00,&
     -0.13986E+00,-0.13943E+00,-0.13899E+00,-0.13855E+00,-0.13812E+00,&
     -0.13768E+00,-0.13725E+00,-0.13681E+00,-0.13638E+00,-0.13595E+00,&
     -0.13551E+00,-0.13508E+00,-0.13465E+00,-0.13422E+00,-0.13379E+00,&
     -0.13336E+00,-0.13292E+00,-0.13249E+00,-0.13207E+00,-0.13164E+00,&
     -0.13121E+00,-0.13078E+00,-0.13035E+00,-0.12992E+00,-0.12950E+00,&
     -0.12907E+00,-0.12865E+00,-0.12822E+00,-0.12779E+00,-0.12737E+00,&
     -0.12695E+00,-0.12652E+00,-0.12610E+00,-0.12568E+00,-0.12525E+00,&
     -0.12483E+00,-0.12441E+00,-0.12399E+00,-0.12357E+00,-0.12315E+00,&
     -0.12273E+00,-0.12231E+00,-0.12189E+00,-0.12147E+00,-0.12105E+00,&
     -0.12063E+00,-0.12022E+00,-0.11980E+00,-0.11938E+00,-0.11897E+00,&
     -0.11855E+00,-0.11814E+00,-0.11772E+00,-0.11731E+00,-0.11689E+00,&
     -0.11648E+00,-0.11607E+00,-0.11565E+00,-0.11524E+00,-0.11483E+00,&
     -0.11442E+00,-0.11401E+00,-0.11360E+00,-0.11319E+00,-0.11278E+00/
                             
     DATA (BNC06M (IA),IA=401,500)/                                     &
     -0.11237E+00,-0.11196E+00,-0.11155E+00,-0.11114E+00,-0.11074E+00,&
     -0.11033E+00,-0.10992E+00,-0.10952E+00,-0.10911E+00,-0.10871E+00,&
     -0.10830E+00,-0.10790E+00,-0.10749E+00,-0.10709E+00,-0.10668E+00,&
     -0.10628E+00,-0.10588E+00,-0.10548E+00,-0.10507E+00,-0.10467E+00,&
     -0.10427E+00,-0.10387E+00,-0.10347E+00,-0.10307E+00,-0.10267E+00,&
     -0.10227E+00,-0.10188E+00,-0.10148E+00,-0.10108E+00,-0.10068E+00,&
     -0.10029E+00,-0.99891E-01,-0.99495E-01,-0.99100E-01,-0.98704E-01,&
     -0.98310E-01,-0.97915E-01,-0.97522E-01,-0.97128E-01,-0.96735E-01,&
     -0.96342E-01,-0.95950E-01,-0.95558E-01,-0.95167E-01,-0.94776E-01,&
     -0.94385E-01,-0.93995E-01,-0.93605E-01,-0.93216E-01,-0.92827E-01,&
     -0.92438E-01,-0.92050E-01,-0.91662E-01,-0.91274E-01,-0.90887E-01,&
     -0.90501E-01,-0.90114E-01,-0.89729E-01,-0.89343E-01,-0.88958E-01,&
     -0.88573E-01,-0.88189E-01,-0.87805E-01,-0.87422E-01,-0.87039E-01,&
     -0.86656E-01,-0.86274E-01,-0.85892E-01,-0.85510E-01,-0.85129E-01,&
     -0.84748E-01,-0.84368E-01,-0.83988E-01,-0.83608E-01,-0.83229E-01,&
     -0.82850E-01,-0.82472E-01,-0.82094E-01,-0.81716E-01,-0.81339E-01,&
     -0.80962E-01,-0.80585E-01,-0.80209E-01,-0.79833E-01,-0.79458E-01,&
     -0.79083E-01,-0.78708E-01,-0.78334E-01,-0.77960E-01,-0.77586E-01,&
     -0.77213E-01,-0.76840E-01,-0.76468E-01,-0.76096E-01,-0.75724E-01,&
     -0.75353E-01,-0.74982E-01,-0.74612E-01,-0.74242E-01,-0.73872E-01/
                             
     DATA (BNC06M (IA),IA=501,600)/                                     &
     -0.73502E-01,-0.73133E-01,-0.72765E-01,-0.72396E-01,-0.72028E-01,&
     -0.71661E-01,-0.71294E-01,-0.70927E-01,-0.70560E-01,-0.70194E-01,&
     -0.69829E-01,-0.69463E-01,-0.69098E-01,-0.68734E-01,-0.68369E-01,&
     -0.68005E-01,-0.67642E-01,-0.67279E-01,-0.66916E-01,-0.66553E-01,&
     -0.66191E-01,-0.65829E-01,-0.65468E-01,-0.65107E-01,-0.64746E-01,&
     -0.64386E-01,-0.64026E-01,-0.63666E-01,-0.63307E-01,-0.62948E-01,&
     -0.62590E-01,-0.62232E-01,-0.61874E-01,-0.61516E-01,-0.61159E-01,&
     -0.60802E-01,-0.60446E-01,-0.60090E-01,-0.59734E-01,-0.59379E-01,&
     -0.59024E-01,-0.58669E-01,-0.58315E-01,-0.57961E-01,-0.57607E-01,&
     -0.57254E-01,-0.56901E-01,-0.56548E-01,-0.56196E-01,-0.55844E-01,&
     -0.55492E-01,-0.55141E-01,-0.54790E-01,-0.54439E-01,-0.54089E-01,&
     -0.53739E-01,-0.53390E-01,-0.53040E-01,-0.52692E-01,-0.52343E-01,&
     -0.51995E-01,-0.51647E-01,-0.51299E-01,-0.50952E-01,-0.50605E-01,&
     -0.50259E-01,-0.49913E-01,-0.49567E-01,-0.49221E-01,-0.48876E-01,&
     -0.48531E-01,-0.48187E-01,-0.47842E-01,-0.47498E-01,-0.47155E-01,&
     -0.46812E-01,-0.46469E-01,-0.46126E-01,-0.45784E-01,-0.45442E-01,&
     -0.45100E-01,-0.44759E-01,-0.44418E-01,-0.44078E-01,-0.43737E-01,&
     -0.43397E-01,-0.43058E-01,-0.42718E-01,-0.42379E-01,-0.42041E-01,&
     -0.41702E-01,-0.41364E-01,-0.41027E-01,-0.40689E-01,-0.40352E-01,&
     -0.40015E-01,-0.39679E-01,-0.39343E-01,-0.39007E-01,-0.37750E-01/
                             
     DATA (BNC06M (IA),IA=601,700)/                                     &
     -0.35001E-01,-0.31698E-01,-0.28424E-01,-0.25181E-01,-0.21967E-01,&
     -0.18782E-01,-0.15626E-01,-0.12497E-01,-0.93963E-02,-0.63224E-02,&
     -0.32753E-02,-0.25450E-03, 0.27406E-02, 0.57102E-02, 0.86547E-02,&
      0.11575E-01, 0.14470E-01, 0.17342E-01, 0.20191E-01, 0.23016E-01,&
      0.25819E-01, 0.28599E-01, 0.31357E-01, 0.34093E-01, 0.36808E-01,&
      0.39502E-01, 0.42175E-01, 0.44827E-01, 0.47460E-01, 0.50072E-01,&
      0.52665E-01, 0.55239E-01, 0.57793E-01, 0.60329E-01, 0.62847E-01,&
      0.65346E-01, 0.67827E-01, 0.70291E-01, 0.72737E-01, 0.75165E-01,&
      0.77577E-01, 0.79972E-01, 0.82351E-01, 0.84713E-01, 0.87059E-01,&
      0.89390E-01, 0.91704E-01, 0.94003E-01, 0.96287E-01, 0.98556E-01,&
      0.10081E+00, 0.10305E+00, 0.10527E+00, 0.10749E+00, 0.10968E+00,&
      0.11186E+00, 0.11403E+00, 0.11619E+00, 0.11833E+00, 0.12046E+00,&
      0.12257E+00, 0.12468E+00, 0.12677E+00, 0.12884E+00, 0.13091E+00,&
      0.13296E+00, 0.13500E+00, 0.13703E+00, 0.13904E+00, 0.14105E+00,&
      0.14304E+00, 0.14502E+00, 0.14699E+00, 0.14895E+00, 0.15090E+00,&
      0.15283E+00, 0.15476E+00, 0.15668E+00, 0.15858E+00, 0.16047E+00,&
      0.16236E+00, 0.16423E+00, 0.16609E+00, 0.16795E+00, 0.16979E+00,&
      0.17162E+00, 0.17345E+00, 0.17526E+00, 0.17706E+00, 0.17886E+00,&
      0.18064E+00, 0.18242E+00, 0.18419E+00, 0.18595E+00, 0.18769E+00,&
      0.18944E+00, 0.19117E+00, 0.19289E+00, 0.19460E+00, 0.19631E+00/
                             
     DATA (BNC06M(IA),IA=701,741)/                                      &
      0.19801E+00, 0.19970E+00, 0.20138E+00, 0.20305E+00, 0.20471E+00,&
      0.20637E+00, 0.20802E+00, 0.20966E+00, 0.21129E+00, 0.21292E+00,&
      0.21453E+00, 0.21614E+00, 0.21775E+00, 0.21934E+00, 0.22093E+00,&
      0.22251E+00, 0.22408E+00, 0.22565E+00, 0.22721E+00, 0.22876E+00,&
      0.23030E+00, 0.23184E+00, 0.23337E+00, 0.23490E+00, 0.23641E+00,&
      0.23792E+00, 0.23943E+00, 0.24093E+00, 0.24242E+00, 0.24390E+00,&
      0.24538E+00, 0.24685E+00, 0.24832E+00, 0.24978E+00, 0.25123E+00,&
      0.25268E+00, 0.25412E+00, 0.25555E+00, 0.25698E+00, 0.25840E+00,&
      0.25982E+00                  /                      
!                            
!  ** (2H, SO4)              
!                            
     DATA (BNC07M (IA),IA=  1,100)/                                     &
     -0.10285E+00,-0.18717E+00,-0.24637E+00,-0.28657E+00,-0.31747E+00,&
     -0.34271E+00,-0.36411E+00,-0.38270E+00,-0.39914E+00,-0.41388E+00,&
     -0.42725E+00,-0.43947E+00,-0.45073E+00,-0.46116E+00,-0.47088E+00,&
     -0.47998E+00,-0.48853E+00,-0.49659E+00,-0.50422E+00,-0.51145E+00,&
     -0.51833E+00,-0.52489E+00,-0.53115E+00,-0.53714E+00,-0.54288E+00,&
     -0.54839E+00,-0.55369E+00,-0.55879E+00,-0.56371E+00,-0.56845E+00,&
     -0.57304E+00,-0.57747E+00,-0.58177E+00,-0.58593E+00,-0.58996E+00,&
     -0.59388E+00,-0.59768E+00,-0.60138E+00,-0.60497E+00,-0.60847E+00,&
     -0.61188E+00,-0.61521E+00,-0.61845E+00,-0.62161E+00,-0.62469E+00,&
     -0.62770E+00,-0.63065E+00,-0.63352E+00,-0.63634E+00,-0.63909E+00,&
     -0.64178E+00,-0.64442E+00,-0.64700E+00,-0.64953E+00,-0.65201E+00,&
     -0.65445E+00,-0.65683E+00,-0.65917E+00,-0.66147E+00,-0.66373E+00,&
     -0.66594E+00,-0.66812E+00,-0.67026E+00,-0.67236E+00,-0.67443E+00,&
     -0.67646E+00,-0.67846E+00,-0.68043E+00,-0.68237E+00,-0.68427E+00,&
     -0.68615E+00,-0.68800E+00,-0.68983E+00,-0.69162E+00,-0.69339E+00,&
     -0.69514E+00,-0.69686E+00,-0.69856E+00,-0.70024E+00,-0.70189E+00,&
     -0.70352E+00,-0.70514E+00,-0.70673E+00,-0.70830E+00,-0.70985E+00,&
     -0.71139E+00,-0.71290E+00,-0.71440E+00,-0.71588E+00,-0.71734E+00,&
     -0.71879E+00,-0.72022E+00,-0.72164E+00,-0.72304E+00,-0.72442E+00,&
     -0.72579E+00,-0.72715E+00,-0.72849E+00,-0.72982E+00,-0.73113E+00/
                             
     DATA (BNC07M (IA),IA=101,200)/                                     &
     -0.73243E+00,-0.73372E+00,-0.73500E+00,-0.73626E+00,-0.73751E+00,&
     -0.73875E+00,-0.73998E+00,-0.74119E+00,-0.74240E+00,-0.74359E+00,&
     -0.74477E+00,-0.74594E+00,-0.74710E+00,-0.74825E+00,-0.74939E+00,&
     -0.75052E+00,-0.75164E+00,-0.75275E+00,-0.75385E+00,-0.75494E+00,&
     -0.75600E+00,-0.75708E+00,-0.75814E+00,-0.75920E+00,-0.76025E+00,&
     -0.76128E+00,-0.76231E+00,-0.76333E+00,-0.76435E+00,-0.76535E+00,&
     -0.76634E+00,-0.76733E+00,-0.76831E+00,-0.76928E+00,-0.77025E+00,&
     -0.77120E+00,-0.77215E+00,-0.77310E+00,-0.77403E+00,-0.77496E+00,&
     -0.77588E+00,-0.77679E+00,-0.77770E+00,-0.77860E+00,-0.77949E+00,&
     -0.78038E+00,-0.78126E+00,-0.78213E+00,-0.78300E+00,-0.78386E+00,&
     -0.78472E+00,-0.78557E+00,-0.78641E+00,-0.78725E+00,-0.78808E+00,&
     -0.78890E+00,-0.78972E+00,-0.79054E+00,-0.79135E+00,-0.79215E+00,&
     -0.79295E+00,-0.79374E+00,-0.79453E+00,-0.79531E+00,-0.79609E+00,&
     -0.79686E+00,-0.79763E+00,-0.79840E+00,-0.79915E+00,-0.79991E+00,&
     -0.80065E+00,-0.80140E+00,-0.80214E+00,-0.80287E+00,-0.80360E+00,&
     -0.80433E+00,-0.80505E+00,-0.80577E+00,-0.80648E+00,-0.80719E+00,&
     -0.80789E+00,-0.80859E+00,-0.80929E+00,-0.80998E+00,-0.81067E+00,&
     -0.81135E+00,-0.81203E+00,-0.81271E+00,-0.81338E+00,-0.81405E+00,&
     -0.81471E+00,-0.81537E+00,-0.81603E+00,-0.81669E+00,-0.81734E+00,&
     -0.81798E+00,-0.81863E+00,-0.81926E+00,-0.81990E+00,-0.82053E+00/
                             
     DATA (BNC07M (IA),IA=201,300)/                                     &
     -0.82116E+00,-0.82179E+00,-0.82241E+00,-0.82303E+00,-0.82365E+00,&
     -0.82426E+00,-0.82487E+00,-0.82548E+00,-0.82608E+00,-0.82668E+00,&
     -0.82728E+00,-0.82787E+00,-0.82846E+00,-0.82905E+00,-0.82963E+00,&
     -0.83022E+00,-0.83080E+00,-0.83137E+00,-0.83195E+00,-0.83252E+00,&
     -0.83309E+00,-0.83365E+00,-0.83421E+00,-0.83477E+00,-0.83533E+00,&
     -0.83589E+00,-0.83644E+00,-0.83699E+00,-0.83753E+00,-0.83808E+00,&
     -0.83862E+00,-0.83916E+00,-0.83970E+00,-0.84023E+00,-0.84076E+00,&
     -0.84129E+00,-0.84182E+00,-0.84234E+00,-0.84286E+00,-0.84338E+00,&
     -0.84390E+00,-0.84442E+00,-0.84493E+00,-0.84544E+00,-0.84595E+00,&
     -0.84645E+00,-0.84696E+00,-0.84746E+00,-0.84796E+00,-0.84846E+00,&
     -0.84895E+00,-0.84945E+00,-0.84994E+00,-0.85043E+00,-0.85091E+00,&
     -0.85140E+00,-0.85188E+00,-0.85236E+00,-0.85284E+00,-0.85332E+00,&
     -0.85379E+00,-0.85426E+00,-0.85473E+00,-0.85520E+00,-0.85567E+00,&
     -0.85614E+00,-0.85660E+00,-0.85706E+00,-0.85752E+00,-0.85798E+00,&
     -0.85843E+00,-0.85889E+00,-0.85934E+00,-0.85979E+00,-0.86024E+00,&
     -0.86069E+00,-0.86113E+00,-0.86157E+00,-0.86202E+00,-0.86246E+00,&
     -0.86289E+00,-0.86333E+00,-0.86377E+00,-0.86420E+00,-0.86463E+00,&
     -0.86506E+00,-0.86549E+00,-0.86592E+00,-0.86634E+00,-0.86676E+00,&
     -0.86719E+00,-0.86761E+00,-0.86803E+00,-0.86844E+00,-0.86886E+00,&
     -0.86927E+00,-0.86969E+00,-0.87010E+00,-0.87051E+00,-0.87091E+00/
                             
     DATA (BNC07M (IA),IA=301,400)/                                     &
     -0.87132E+00,-0.87173E+00,-0.87213E+00,-0.87253E+00,-0.87293E+00,&
     -0.87333E+00,-0.87373E+00,-0.87413E+00,-0.87452E+00,-0.87492E+00,&
     -0.87531E+00,-0.87570E+00,-0.87609E+00,-0.87648E+00,-0.87687E+00,&
     -0.87725E+00,-0.87764E+00,-0.87802E+00,-0.87840E+00,-0.87878E+00,&
     -0.87916E+00,-0.87954E+00,-0.87992E+00,-0.88029E+00,-0.88067E+00,&
     -0.88104E+00,-0.88141E+00,-0.88178E+00,-0.88215E+00,-0.88252E+00,&
     -0.88289E+00,-0.88325E+00,-0.88362E+00,-0.88398E+00,-0.88434E+00,&
     -0.88470E+00,-0.88506E+00,-0.88542E+00,-0.88578E+00,-0.88614E+00,&
     -0.88649E+00,-0.88685E+00,-0.88720E+00,-0.88755E+00,-0.88790E+00,&
     -0.88825E+00,-0.88860E+00,-0.88895E+00,-0.88929E+00,-0.88964E+00,&
     -0.88998E+00,-0.89033E+00,-0.89067E+00,-0.89101E+00,-0.89135E+00,&
     -0.89169E+00,-0.89203E+00,-0.89236E+00,-0.89270E+00,-0.89303E+00,&
     -0.89337E+00,-0.89370E+00,-0.89403E+00,-0.89436E+00,-0.89469E+00,&
     -0.89502E+00,-0.89535E+00,-0.89568E+00,-0.89600E+00,-0.89633E+00,&
     -0.89665E+00,-0.89697E+00,-0.89730E+00,-0.89762E+00,-0.89794E+00,&
     -0.89826E+00,-0.89857E+00,-0.89889E+00,-0.89921E+00,-0.89952E+00,&
     -0.89984E+00,-0.90015E+00,-0.90047E+00,-0.90078E+00,-0.90109E+00,&
     -0.90140E+00,-0.90171E+00,-0.90202E+00,-0.90232E+00,-0.90263E+00,&
     -0.90294E+00,-0.90324E+00,-0.90355E+00,-0.90385E+00,-0.90415E+00,&
     -0.90445E+00,-0.90475E+00,-0.90505E+00,-0.90535E+00,-0.90565E+00/
                             
     DATA (BNC07M (IA),IA=401,500)/                                     &
     -0.90595E+00,-0.90625E+00,-0.90654E+00,-0.90684E+00,-0.90713E+00,&
     -0.90743E+00,-0.90772E+00,-0.90801E+00,-0.90830E+00,-0.90859E+00,&
     -0.90888E+00,-0.90917E+00,-0.90946E+00,-0.90975E+00,-0.91003E+00,&
     -0.91032E+00,-0.91060E+00,-0.91089E+00,-0.91117E+00,-0.91145E+00,&
     -0.91174E+00,-0.91202E+00,-0.91230E+00,-0.91258E+00,-0.91286E+00,&
     -0.91314E+00,-0.91341E+00,-0.91369E+00,-0.91397E+00,-0.91424E+00,&
     -0.91452E+00,-0.91479E+00,-0.91507E+00,-0.91534E+00,-0.91561E+00,&
     -0.91588E+00,-0.91615E+00,-0.91642E+00,-0.91669E+00,-0.91696E+00,&
     -0.91723E+00,-0.91750E+00,-0.91776E+00,-0.91803E+00,-0.91830E+00,&
     -0.91856E+00,-0.91883E+00,-0.91909E+00,-0.91935E+00,-0.91961E+00,&
     -0.91988E+00,-0.92014E+00,-0.92040E+00,-0.92066E+00,-0.92092E+00,&
     -0.92117E+00,-0.92143E+00,-0.92169E+00,-0.92195E+00,-0.92220E+00,&
     -0.92246E+00,-0.92271E+00,-0.92297E+00,-0.92322E+00,-0.92347E+00,&
     -0.92373E+00,-0.92398E+00,-0.92423E+00,-0.92448E+00,-0.92473E+00,&
     -0.92498E+00,-0.92523E+00,-0.92548E+00,-0.92572E+00,-0.92597E+00,&
     -0.92622E+00,-0.92646E+00,-0.92671E+00,-0.92695E+00,-0.92720E+00,&
     -0.92744E+00,-0.92768E+00,-0.92793E+00,-0.92817E+00,-0.92841E+00,&
     -0.92865E+00,-0.92889E+00,-0.92913E+00,-0.92937E+00,-0.92961E+00,&
     -0.92985E+00,-0.93009E+00,-0.93032E+00,-0.93056E+00,-0.93080E+00,&
     -0.93103E+00,-0.93127E+00,-0.93150E+00,-0.93174E+00,-0.93197E+00/
                             
     DATA (BNC07M (IA),IA=501,600)/                                     &
     -0.93220E+00,-0.93243E+00,-0.93267E+00,-0.93290E+00,-0.93313E+00,&
     -0.93336E+00,-0.93359E+00,-0.93382E+00,-0.93405E+00,-0.93428E+00,&
     -0.93450E+00,-0.93473E+00,-0.93496E+00,-0.93519E+00,-0.93541E+00,&
     -0.93564E+00,-0.93586E+00,-0.93609E+00,-0.93631E+00,-0.93653E+00,&
     -0.93676E+00,-0.93698E+00,-0.93720E+00,-0.93742E+00,-0.93765E+00,&
     -0.93787E+00,-0.93809E+00,-0.93831E+00,-0.93853E+00,-0.93875E+00,&
     -0.93896E+00,-0.93918E+00,-0.93940E+00,-0.93962E+00,-0.93983E+00,&
     -0.94005E+00,-0.94027E+00,-0.94048E+00,-0.94070E+00,-0.94091E+00,&
     -0.94112E+00,-0.94134E+00,-0.94155E+00,-0.94176E+00,-0.94198E+00,&
     -0.94219E+00,-0.94240E+00,-0.94261E+00,-0.94282E+00,-0.94303E+00,&
     -0.94324E+00,-0.94345E+00,-0.94366E+00,-0.94387E+00,-0.94408E+00,&
     -0.94428E+00,-0.94449E+00,-0.94470E+00,-0.94491E+00,-0.94511E+00,&
     -0.94532E+00,-0.94552E+00,-0.94573E+00,-0.94593E+00,-0.94614E+00,&
     -0.94634E+00,-0.94654E+00,-0.94675E+00,-0.94695E+00,-0.94715E+00,&
     -0.94735E+00,-0.94755E+00,-0.94775E+00,-0.94795E+00,-0.94815E+00,&
     -0.94835E+00,-0.94855E+00,-0.94875E+00,-0.94895E+00,-0.94915E+00,&
     -0.94935E+00,-0.94954E+00,-0.94974E+00,-0.94994E+00,-0.95014E+00,&
     -0.95033E+00,-0.95053E+00,-0.95072E+00,-0.95092E+00,-0.95111E+00,&
     -0.95131E+00,-0.95150E+00,-0.95169E+00,-0.95189E+00,-0.95208E+00,&
     -0.95227E+00,-0.95246E+00,-0.95265E+00,-0.95285E+00,-0.95356E+00/
                             
     DATA (BNC07M (IA),IA=601,700)/                                     &
     -0.95511E+00,-0.95697E+00,-0.95879E+00,-0.96057E+00,-0.96233E+00,&
     -0.96406E+00,-0.96576E+00,-0.96743E+00,-0.96907E+00,-0.97069E+00,&
     -0.97228E+00,-0.97385E+00,-0.97539E+00,-0.97691E+00,-0.97841E+00,&
     -0.97989E+00,-0.98134E+00,-0.98277E+00,-0.98418E+00,-0.98558E+00,&
     -0.98695E+00,-0.98830E+00,-0.98964E+00,-0.99096E+00,-0.99226E+00,&
     -0.99354E+00,-0.99481E+00,-0.99606E+00,-0.99730E+00,-0.99852E+00,&
     -0.99972E+00,-0.10009E+01,-0.10021E+01,-0.10032E+01,-0.10044E+01,&
     -0.10055E+01,-0.10067E+01,-0.10078E+01,-0.10089E+01,-0.10099E+01,&
     -0.10110E+01,-0.10121E+01,-0.10131E+01,-0.10142E+01,-0.10152E+01,&
     -0.10162E+01,-0.10172E+01,-0.10182E+01,-0.10192E+01,-0.10201E+01,&
     -0.10211E+01,-0.10221E+01,-0.10230E+01,-0.10239E+01,-0.10249E+01,&
     -0.10258E+01,-0.10267E+01,-0.10276E+01,-0.10285E+01,-0.10293E+01,&
     -0.10302E+01,-0.10311E+01,-0.10319E+01,-0.10328E+01,-0.10336E+01,&
     -0.10345E+01,-0.10353E+01,-0.10361E+01,-0.10369E+01,-0.10377E+01,&
     -0.10385E+01,-0.10393E+01,-0.10401E+01,-0.10409E+01,-0.10416E+01,&
     -0.10424E+01,-0.10432E+01,-0.10439E+01,-0.10447E+01,-0.10454E+01,&
     -0.10461E+01,-0.10469E+01,-0.10476E+01,-0.10483E+01,-0.10490E+01,&
     -0.10497E+01,-0.10504E+01,-0.10511E+01,-0.10518E+01,-0.10525E+01,&
     -0.10532E+01,-0.10538E+01,-0.10545E+01,-0.10552E+01,-0.10558E+01,&
     -0.10565E+01,-0.10571E+01,-0.10578E+01,-0.10584E+01,-0.10591E+01/
                             
     DATA (BNC07M(IA),IA=701,741)/                                      &
     -0.10597E+01,-0.10603E+01,-0.10609E+01,-0.10616E+01,-0.10622E+01,&
     -0.10628E+01,-0.10634E+01,-0.10640E+01,-0.10646E+01,-0.10652E+01,&
     -0.10658E+01,-0.10663E+01,-0.10669E+01,-0.10675E+01,-0.10681E+01,&
     -0.10687E+01,-0.10692E+01,-0.10698E+01,-0.10703E+01,-0.10709E+01,&
     -0.10714E+01,-0.10720E+01,-0.10725E+01,-0.10731E+01,-0.10736E+01,&
     -0.10742E+01,-0.10747E+01,-0.10752E+01,-0.10757E+01,-0.10763E+01,&
     -0.10768E+01,-0.10773E+01,-0.10778E+01,-0.10783E+01,-0.10788E+01,&
     -0.10793E+01,-0.10798E+01,-0.10803E+01,-0.10808E+01,-0.10813E+01,&
     -0.10818E+01                 /                      
!                            
!  ** (H, HSO4)              
!                            
     DATA (BNC08M (IA),IA=  1,100)/                                     &
     -0.48178E-01,-0.82334E-01,-0.10277E+00,-0.11452E+00,-0.12211E+00,&
     -0.12718E+00,-0.13053E+00,-0.13262E+00,-0.13374E+00,-0.13407E+00,&
     -0.13376E+00,-0.13289E+00,-0.13155E+00,-0.12979E+00,-0.12766E+00,&
     -0.12519E+00,-0.12242E+00,-0.11937E+00,-0.11607E+00,-0.11252E+00,&
     -0.10875E+00,-0.10478E+00,-0.10060E+00,-0.96246E-01,-0.91714E-01,&
     -0.87015E-01,-0.82158E-01,-0.77151E-01,-0.72001E-01,-0.66714E-01,&
     -0.61297E-01,-0.55755E-01,-0.50094E-01,-0.44319E-01,-0.38434E-01,&
     -0.32445E-01,-0.26356E-01,-0.20172E-01,-0.13895E-01,-0.75315E-02,&
     -0.10835E-02, 0.54448E-02, 0.12050E-01, 0.18729E-01, 0.25479E-01,&
      0.32296E-01, 0.39178E-01, 0.46121E-01, 0.53125E-01, 0.60185E-01,&
      0.67299E-01, 0.74467E-01, 0.81685E-01, 0.88951E-01, 0.96265E-01,&
      0.10362E+00, 0.11103E+00, 0.11847E+00, 0.12596E+00, 0.13349E+00,&
      0.14106E+00, 0.14866E+00, 0.15631E+00, 0.16400E+00, 0.17172E+00,&
      0.17948E+00, 0.18727E+00, 0.19511E+00, 0.20298E+00, 0.21089E+00,&
      0.21884E+00, 0.22683E+00, 0.23486E+00, 0.24293E+00, 0.25103E+00,&
      0.25918E+00, 0.26737E+00, 0.27560E+00, 0.28387E+00, 0.29219E+00,&
      0.30055E+00, 0.30895E+00, 0.31740E+00, 0.32589E+00, 0.33443E+00,&
      0.34301E+00, 0.35163E+00, 0.36030E+00, 0.36901E+00, 0.37777E+00,&
      0.38658E+00, 0.39542E+00, 0.40431E+00, 0.41324E+00, 0.42221E+00,&
      0.43122E+00, 0.44027E+00, 0.44936E+00, 0.45849E+00, 0.46765E+00/
                             
     DATA (BNC08M (IA),IA=101,200)/                                     &
      0.47684E+00, 0.48607E+00, 0.49533E+00, 0.50462E+00, 0.51393E+00,&
      0.52328E+00, 0.53264E+00, 0.54203E+00, 0.55144E+00, 0.56087E+00,&
      0.57032E+00, 0.57979E+00, 0.58926E+00, 0.59876E+00, 0.60826E+00,&
      0.61777E+00, 0.62729E+00, 0.63682E+00, 0.64635E+00, 0.65589E+00,&
      0.66464E+00, 0.67427E+00, 0.68389E+00, 0.69350E+00, 0.70310E+00,&
      0.71269E+00, 0.72227E+00, 0.73184E+00, 0.74139E+00, 0.75094E+00,&
      0.76047E+00, 0.76999E+00, 0.77950E+00, 0.78899E+00, 0.79847E+00,&
      0.80794E+00, 0.81739E+00, 0.82683E+00, 0.83625E+00, 0.84566E+00,&
      0.85506E+00, 0.86444E+00, 0.87380E+00, 0.88315E+00, 0.89249E+00,&
      0.90181E+00, 0.91111E+00, 0.92039E+00, 0.92966E+00, 0.93892E+00,&
      0.94816E+00, 0.95738E+00, 0.96658E+00, 0.97577E+00, 0.98494E+00,&
      0.99409E+00, 0.10032E+01, 0.10123E+01, 0.10215E+01, 0.10305E+01,&
      0.10396E+01, 0.10487E+01, 0.10577E+01, 0.10667E+01, 0.10757E+01,&
      0.10847E+01, 0.10936E+01, 0.11026E+01, 0.11115E+01, 0.11204E+01,&
      0.11293E+01, 0.11382E+01, 0.11470E+01, 0.11559E+01, 0.11647E+01,&
      0.11735E+01, 0.11823E+01, 0.11910E+01, 0.11998E+01, 0.12085E+01,&
      0.12172E+01, 0.12259E+01, 0.12346E+01, 0.12432E+01, 0.12519E+01,&
      0.12605E+01, 0.12691E+01, 0.12777E+01, 0.12862E+01, 0.12948E+01,&
      0.13033E+01, 0.13118E+01, 0.13203E+01, 0.13288E+01, 0.13372E+01,&
      0.13457E+01, 0.13541E+01, 0.13625E+01, 0.13709E+01, 0.13793E+01/
                             
     DATA (BNC08M (IA),IA=201,300)/                                     &
      0.13876E+01, 0.13959E+01, 0.14043E+01, 0.14126E+01, 0.14208E+01,&
      0.14291E+01, 0.14373E+01, 0.14456E+01, 0.14538E+01, 0.14620E+01,&
      0.14701E+01, 0.14783E+01, 0.14864E+01, 0.14945E+01, 0.15027E+01,&
      0.15107E+01, 0.15188E+01, 0.15269E+01, 0.15349E+01, 0.15429E+01,&
      0.15509E+01, 0.15589E+01, 0.15669E+01, 0.15748E+01, 0.15828E+01,&
      0.15907E+01, 0.15986E+01, 0.16065E+01, 0.16143E+01, 0.16222E+01,&
      0.16300E+01, 0.16378E+01, 0.16456E+01, 0.16534E+01, 0.16612E+01,&
      0.16689E+01, 0.16767E+01, 0.16844E+01, 0.16921E+01, 0.16998E+01,&
      0.17075E+01, 0.17151E+01, 0.17227E+01, 0.17304E+01, 0.17380E+01,&
      0.17456E+01, 0.17531E+01, 0.17607E+01, 0.17683E+01, 0.17758E+01,&
      0.17833E+01, 0.17908E+01, 0.17983E+01, 0.18057E+01, 0.18132E+01,&
      0.18206E+01, 0.18281E+01, 0.18355E+01, 0.18429E+01, 0.18502E+01,&
      0.18576E+01, 0.18649E+01, 0.18723E+01, 0.18796E+01, 0.18869E+01,&
      0.18942E+01, 0.19014E+01, 0.19087E+01, 0.19159E+01, 0.19232E+01,&
      0.19304E+01, 0.19376E+01, 0.19448E+01, 0.19519E+01, 0.19591E+01,&
      0.19662E+01, 0.19734E+01, 0.19805E+01, 0.19876E+01, 0.19947E+01,&
      0.20017E+01, 0.20088E+01, 0.20158E+01, 0.20229E+01, 0.20299E+01,&
      0.20369E+01, 0.20439E+01, 0.20509E+01, 0.20578E+01, 0.20648E+01,&
      0.20717E+01, 0.20786E+01, 0.20855E+01, 0.20924E+01, 0.20993E+01,&
      0.21062E+01, 0.21130E+01, 0.21199E+01, 0.21267E+01, 0.21335E+01/
                             
     DATA (BNC08M (IA),IA=301,400)/                                     &
      0.21403E+01, 0.21471E+01, 0.21539E+01, 0.21606E+01, 0.21674E+01,&
      0.21741E+01, 0.21808E+01, 0.21875E+01, 0.21942E+01, 0.22009E+01,&
      0.22076E+01, 0.22143E+01, 0.22209E+01, 0.22275E+01, 0.22342E+01,&
      0.22408E+01, 0.22474E+01, 0.22540E+01, 0.22605E+01, 0.22671E+01,&
      0.22737E+01, 0.22802E+01, 0.22867E+01, 0.22932E+01, 0.22997E+01,&
      0.23062E+01, 0.23127E+01, 0.23192E+01, 0.23256E+01, 0.23321E+01,&
      0.23385E+01, 0.23449E+01, 0.23513E+01, 0.23577E+01, 0.23641E+01,&
      0.23705E+01, 0.23768E+01, 0.23832E+01, 0.23895E+01, 0.23958E+01,&
      0.24021E+01, 0.24084E+01, 0.24147E+01, 0.24210E+01, 0.24273E+01,&
      0.24335E+01, 0.24398E+01, 0.24460E+01, 0.24522E+01, 0.24585E+01,&
      0.24647E+01, 0.24709E+01, 0.24770E+01, 0.24832E+01, 0.24894E+01,&
      0.24955E+01, 0.25016E+01, 0.25078E+01, 0.25139E+01, 0.25200E+01,&
      0.25261E+01, 0.25322E+01, 0.25382E+01, 0.25443E+01, 0.25504E+01,&
      0.25564E+01, 0.25624E+01, 0.25685E+01, 0.25745E+01, 0.25805E+01,&
      0.25865E+01, 0.25924E+01, 0.25984E+01, 0.26044E+01, 0.26103E+01,&
      0.26163E+01, 0.26222E+01, 0.26281E+01, 0.26340E+01, 0.26399E+01,&
      0.26458E+01, 0.26517E+01, 0.26576E+01, 0.26634E+01, 0.26693E+01,&
      0.26751E+01, 0.26809E+01, 0.26868E+01, 0.26926E+01, 0.26984E+01,&
      0.27042E+01, 0.27099E+01, 0.27157E+01, 0.27215E+01, 0.27272E+01,&
      0.27330E+01, 0.27387E+01, 0.27444E+01, 0.27501E+01, 0.27559E+01/
                             
     DATA (BNC08M (IA),IA=401,500)/                                     &
      0.27615E+01, 0.27672E+01, 0.27729E+01, 0.27786E+01, 0.27842E+01,&
      0.27899E+01, 0.27955E+01, 0.28012E+01, 0.28068E+01, 0.28124E+01,&
      0.28180E+01, 0.28236E+01, 0.28292E+01, 0.28348E+01, 0.28403E+01,&
      0.28459E+01, 0.28515E+01, 0.28570E+01, 0.28625E+01, 0.28681E+01,&
      0.28736E+01, 0.28791E+01, 0.28846E+01, 0.28901E+01, 0.28956E+01,&
      0.29010E+01, 0.29065E+01, 0.29119E+01, 0.29174E+01, 0.29228E+01,&
      0.29283E+01, 0.29337E+01, 0.29391E+01, 0.29445E+01, 0.29499E+01,&
      0.29553E+01, 0.29607E+01, 0.29660E+01, 0.29714E+01, 0.29768E+01,&
      0.29821E+01, 0.29874E+01, 0.29928E+01, 0.29981E+01, 0.30034E+01,&
      0.30087E+01, 0.30140E+01, 0.30193E+01, 0.30246E+01, 0.30299E+01,&
      0.30351E+01, 0.30404E+01, 0.30456E+01, 0.30509E+01, 0.30561E+01,&
      0.30613E+01, 0.30666E+01, 0.30718E+01, 0.30770E+01, 0.30822E+01,&
      0.30874E+01, 0.30925E+01, 0.30977E+01, 0.31029E+01, 0.31080E+01,&
      0.31132E+01, 0.31183E+01, 0.31235E+01, 0.31286E+01, 0.31337E+01,&
      0.31388E+01, 0.31439E+01, 0.31490E+01, 0.31541E+01, 0.31592E+01,&
      0.31643E+01, 0.31693E+01, 0.31744E+01, 0.31794E+01, 0.31845E+01,&
      0.31895E+01, 0.31945E+01, 0.31996E+01, 0.32046E+01, 0.32096E+01,&
      0.32146E+01, 0.32196E+01, 0.32246E+01, 0.32296E+01, 0.32345E+01,&
      0.32395E+01, 0.32444E+01, 0.32494E+01, 0.32543E+01, 0.32593E+01,&
      0.32642E+01, 0.32691E+01, 0.32740E+01, 0.32790E+01, 0.32839E+01/
                             
     DATA (BNC08M (IA),IA=501,600)/                                     &
      0.32888E+01, 0.32936E+01, 0.32985E+01, 0.33034E+01, 0.33083E+01,&
      0.33131E+01, 0.33180E+01, 0.33228E+01, 0.33277E+01, 0.33325E+01,&
      0.33373E+01, 0.33421E+01, 0.33470E+01, 0.33518E+01, 0.33566E+01,&
      0.33614E+01, 0.33662E+01, 0.33709E+01, 0.33757E+01, 0.33805E+01,&
      0.33852E+01, 0.33900E+01, 0.33947E+01, 0.33995E+01, 0.34042E+01,&
      0.34089E+01, 0.34137E+01, 0.34184E+01, 0.34231E+01, 0.34278E+01,&
      0.34325E+01, 0.34372E+01, 0.34419E+01, 0.34465E+01, 0.34512E+01,&
      0.34559E+01, 0.34605E+01, 0.34652E+01, 0.34698E+01, 0.34745E+01,&
      0.34791E+01, 0.34837E+01, 0.34884E+01, 0.34930E+01, 0.34976E+01,&
      0.35022E+01, 0.35068E+01, 0.35114E+01, 0.35160E+01, 0.35205E+01,&
      0.35251E+01, 0.35297E+01, 0.35342E+01, 0.35388E+01, 0.35433E+01,&
      0.35479E+01, 0.35524E+01, 0.35569E+01, 0.35615E+01, 0.35660E+01,&
      0.35705E+01, 0.35750E+01, 0.35795E+01, 0.35840E+01, 0.35885E+01,&
      0.35930E+01, 0.35975E+01, 0.36019E+01, 0.36064E+01, 0.36109E+01,&
      0.36153E+01, 0.36198E+01, 0.36242E+01, 0.36286E+01, 0.36331E+01,&
      0.36375E+01, 0.36419E+01, 0.36463E+01, 0.36508E+01, 0.36552E+01,&
      0.36596E+01, 0.36639E+01, 0.36683E+01, 0.36727E+01, 0.36771E+01,&
      0.36815E+01, 0.36858E+01, 0.36902E+01, 0.36945E+01, 0.36989E+01,&
      0.37032E+01, 0.37076E+01, 0.37119E+01, 0.37162E+01, 0.37206E+01,&
      0.37249E+01, 0.37292E+01, 0.37335E+01, 0.37378E+01, 0.37539E+01/
                             
     DATA (BNC08M (IA),IA=601,700)/                                     &
      0.37890E+01, 0.38311E+01, 0.38727E+01, 0.39138E+01, 0.39544E+01,&
      0.39945E+01, 0.40342E+01, 0.40734E+01, 0.41122E+01, 0.41506E+01,&
      0.41885E+01, 0.42261E+01, 0.42632E+01, 0.42999E+01, 0.43363E+01,&
      0.43722E+01, 0.44078E+01, 0.44431E+01, 0.44780E+01, 0.45125E+01,&
      0.45467E+01, 0.45806E+01, 0.46141E+01, 0.46473E+01, 0.46802E+01,&
      0.47128E+01, 0.47451E+01, 0.47771E+01, 0.48088E+01, 0.48402E+01,&
      0.48713E+01, 0.49022E+01, 0.49327E+01, 0.49630E+01, 0.49931E+01,&
      0.50229E+01, 0.50524E+01, 0.50817E+01, 0.51107E+01, 0.51395E+01,&
      0.51681E+01, 0.51964E+01, 0.52245E+01, 0.52524E+01, 0.52800E+01,&
      0.53074E+01, 0.53346E+01, 0.53616E+01, 0.53884E+01, 0.54150E+01,&
      0.54414E+01, 0.54676E+01, 0.54936E+01, 0.55194E+01, 0.55450E+01,&
      0.55704E+01, 0.55956E+01, 0.56206E+01, 0.56455E+01, 0.56702E+01,&
      0.56947E+01, 0.57191E+01, 0.57432E+01, 0.57672E+01, 0.57911E+01,&
      0.58148E+01, 0.58383E+01, 0.58616E+01, 0.58848E+01, 0.59079E+01,&
      0.59308E+01, 0.59535E+01, 0.59761E+01, 0.59986E+01, 0.60209E+01,&
      0.60430E+01, 0.60650E+01, 0.60869E+01, 0.61087E+01, 0.61303E+01,&
      0.61517E+01, 0.61731E+01, 0.61943E+01, 0.62154E+01, 0.62363E+01,&
      0.62572E+01, 0.62779E+01, 0.62984E+01, 0.63189E+01, 0.63392E+01,&
      0.63595E+01, 0.63796E+01, 0.63996E+01, 0.64194E+01, 0.64392E+01,&
      0.64588E+01, 0.64784E+01, 0.64978E+01, 0.65171E+01, 0.65363E+01/
                             
     DATA (BNC08M(IA),IA=701,741)/                                      &
      0.65554E+01, 0.65744E+01, 0.65933E+01, 0.66121E+01, 0.66308E+01,&
      0.66494E+01, 0.66679E+01, 0.66863E+01, 0.67046E+01, 0.67228E+01,&
      0.67409E+01, 0.67589E+01, 0.67768E+01, 0.67947E+01, 0.68124E+01,&
      0.68300E+01, 0.68476E+01, 0.68651E+01, 0.68824E+01, 0.68997E+01,&
      0.69169E+01, 0.69341E+01, 0.69511E+01, 0.69680E+01, 0.69849E+01,&
      0.70017E+01, 0.70184E+01, 0.70350E+01, 0.70516E+01, 0.70681E+01,&
      0.70845E+01, 0.71008E+01, 0.71170E+01, 0.71332E+01, 0.71493E+01,&
      0.71653E+01, 0.71812E+01, 0.71971E+01, 0.72129E+01, 0.72286E+01,&
      0.72442E+01                  /                      
!                            
!  ** NH4HSO4                
!                            
     DATA (BNC09M (IA),IA=  1,100)/                                     &
     -0.50460E-01,-0.90365E-01,-0.11751E+00,-0.13545E+00,-0.14891E+00,&
     -0.15966E+00,-0.16855E+00,-0.17609E+00,-0.18259E+00,-0.18826E+00,&
     -0.19325E+00,-0.19767E+00,-0.20160E+00,-0.20511E+00,-0.20826E+00,&
     -0.21107E+00,-0.21359E+00,-0.21585E+00,-0.21786E+00,-0.21965E+00,&
     -0.22123E+00,-0.22262E+00,-0.22384E+00,-0.22488E+00,-0.22578E+00,&
     -0.22652E+00,-0.22713E+00,-0.22760E+00,-0.22795E+00,-0.22817E+00,&
     -0.22829E+00,-0.22829E+00,-0.22819E+00,-0.22799E+00,-0.22770E+00,&
     -0.22731E+00,-0.22683E+00,-0.22627E+00,-0.22563E+00,-0.22491E+00,&
     -0.22411E+00,-0.22324E+00,-0.22230E+00,-0.22129E+00,-0.22021E+00,&
     -0.21907E+00,-0.21788E+00,-0.21662E+00,-0.21530E+00,-0.21394E+00,&
     -0.21251E+00,-0.21104E+00,-0.20952E+00,-0.20795E+00,-0.20634E+00,&
     -0.20468E+00,-0.20297E+00,-0.20123E+00,-0.19944E+00,-0.19762E+00,&
     -0.19576E+00,-0.19386E+00,-0.19192E+00,-0.18995E+00,-0.18795E+00,&
     -0.18591E+00,-0.18384E+00,-0.18174E+00,-0.17961E+00,-0.17744E+00,&
     -0.17525E+00,-0.17303E+00,-0.17078E+00,-0.16849E+00,-0.16619E+00,&
     -0.16385E+00,-0.16149E+00,-0.15910E+00,-0.15668E+00,-0.15423E+00,&
     -0.15176E+00,-0.14927E+00,-0.14675E+00,-0.14420E+00,-0.14163E+00,&
     -0.13903E+00,-0.13641E+00,-0.13376E+00,-0.13110E+00,-0.12840E+00,&
     -0.12569E+00,-0.12295E+00,-0.12020E+00,-0.11742E+00,-0.11462E+00,&
     -0.11180E+00,-0.10896E+00,-0.10610E+00,-0.10322E+00,-0.10033E+00/
                             
     DATA (BNC09M (IA),IA=101,200)/                                     &
     -0.97415E-01,-0.94487E-01,-0.91545E-01,-0.88587E-01,-0.85616E-01,&
     -0.82631E-01,-0.79634E-01,-0.76626E-01,-0.73606E-01,-0.70577E-01,&
     -0.67538E-01,-0.64490E-01,-0.61435E-01,-0.58371E-01,-0.55302E-01,&
     -0.52227E-01,-0.49147E-01,-0.46061E-01,-0.42972E-01,-0.39880E-01,&
     -0.37062E-01,-0.33933E-01,-0.30805E-01,-0.27679E-01,-0.24555E-01,&
     -0.21433E-01,-0.18313E-01,-0.15196E-01,-0.12082E-01,-0.89703E-02,&
     -0.58621E-02,-0.27572E-02, 0.34429E-03, 0.34421E-02, 0.65364E-02,&
      0.96264E-02, 0.12713E-01, 0.15795E-01, 0.18873E-01, 0.21946E-01,&
      0.25015E-01, 0.28079E-01, 0.31139E-01, 0.34193E-01, 0.37243E-01,&
      0.40288E-01, 0.43328E-01, 0.46362E-01, 0.49392E-01, 0.52416E-01,&
      0.55435E-01, 0.58448E-01, 0.61456E-01, 0.64458E-01, 0.67455E-01,&
      0.70446E-01, 0.73432E-01, 0.76411E-01, 0.79385E-01, 0.82354E-01,&
      0.85316E-01, 0.88272E-01, 0.91223E-01, 0.94168E-01, 0.97106E-01,&
      0.10004E+00, 0.10297E+00, 0.10589E+00, 0.10880E+00, 0.11171E+00,&
      0.11461E+00, 0.11751E+00, 0.12040E+00, 0.12328E+00, 0.12616E+00,&
      0.12903E+00, 0.13190E+00, 0.13476E+00, 0.13761E+00, 0.14046E+00,&
      0.14330E+00, 0.14614E+00, 0.14896E+00, 0.15179E+00, 0.15460E+00,&
      0.15741E+00, 0.16022E+00, 0.16302E+00, 0.16581E+00, 0.16859E+00,&
      0.17138E+00, 0.17415E+00, 0.17692E+00, 0.17968E+00, 0.18243E+00,&
      0.18518E+00, 0.18793E+00, 0.19066E+00, 0.19340E+00, 0.19612E+00/
                             
     DATA (BNC09M (IA),IA=201,300)/                                     &
      0.19884E+00, 0.20155E+00, 0.20426E+00, 0.20696E+00, 0.20966E+00,&
      0.21235E+00, 0.21503E+00, 0.21771E+00, 0.22038E+00, 0.22305E+00,&
      0.22571E+00, 0.22837E+00, 0.23101E+00, 0.23366E+00, 0.23629E+00,&
      0.23893E+00, 0.24155E+00, 0.24417E+00, 0.24679E+00, 0.24940E+00,&
      0.25200E+00, 0.25460E+00, 0.25719E+00, 0.25978E+00, 0.26236E+00,&
      0.26493E+00, 0.26750E+00, 0.27007E+00, 0.27262E+00, 0.27518E+00,&
      0.27772E+00, 0.28027E+00, 0.28280E+00, 0.28534E+00, 0.28786E+00,&
      0.29038E+00, 0.29290E+00, 0.29541E+00, 0.29791E+00, 0.30041E+00,&
      0.30291E+00, 0.30540E+00, 0.30788E+00, 0.31036E+00, 0.31283E+00,&
      0.31530E+00, 0.31776E+00, 0.32022E+00, 0.32268E+00, 0.32512E+00,&
      0.32757E+00, 0.33000E+00, 0.33244E+00, 0.33486E+00, 0.33729E+00,&
      0.33971E+00, 0.34212E+00, 0.34453E+00, 0.34693E+00, 0.34933E+00,&
      0.35172E+00, 0.35411E+00, 0.35649E+00, 0.35887E+00, 0.36125E+00,&
      0.36362E+00, 0.36598E+00, 0.36834E+00, 0.37070E+00, 0.37305E+00,&
      0.37539E+00, 0.37773E+00, 0.38007E+00, 0.38240E+00, 0.38473E+00,&
      0.38705E+00, 0.38937E+00, 0.39168E+00, 0.39399E+00, 0.39630E+00,&
      0.39860E+00, 0.40089E+00, 0.40318E+00, 0.40547E+00, 0.40775E+00,&
      0.41003E+00, 0.41230E+00, 0.41457E+00, 0.41684E+00, 0.41910E+00,&
      0.42136E+00, 0.42361E+00, 0.42585E+00, 0.42810E+00, 0.43034E+00,&
      0.43257E+00, 0.43480E+00, 0.43703E+00, 0.43925E+00, 0.44147E+00/
                             
     DATA (BNC09M (IA),IA=301,400)/                                     &
      0.44368E+00, 0.44589E+00, 0.44810E+00, 0.45030E+00, 0.45250E+00,&
      0.45469E+00, 0.45688E+00, 0.45906E+00, 0.46124E+00, 0.46342E+00,&
      0.46559E+00, 0.46776E+00, 0.46993E+00, 0.47209E+00, 0.47425E+00,&
      0.47640E+00, 0.47855E+00, 0.48070E+00, 0.48284E+00, 0.48497E+00,&
      0.48711E+00, 0.48924E+00, 0.49136E+00, 0.49349E+00, 0.49561E+00,&
      0.49772E+00, 0.49983E+00, 0.50194E+00, 0.50404E+00, 0.50614E+00,&
      0.50824E+00, 0.51033E+00, 0.51242E+00, 0.51450E+00, 0.51658E+00,&
      0.51866E+00, 0.52074E+00, 0.52281E+00, 0.52487E+00, 0.52694E+00,&
      0.52900E+00, 0.53105E+00, 0.53311E+00, 0.53515E+00, 0.53720E+00,&
      0.53924E+00, 0.54128E+00, 0.54331E+00, 0.54535E+00, 0.54737E+00,&
      0.54940E+00, 0.55142E+00, 0.55344E+00, 0.55545E+00, 0.55746E+00,&
      0.55947E+00, 0.56147E+00, 0.56347E+00, 0.56547E+00, 0.56747E+00,&
      0.56946E+00, 0.57144E+00, 0.57343E+00, 0.57541E+00, 0.57738E+00,&
      0.57936E+00, 0.58133E+00, 0.58330E+00, 0.58526E+00, 0.58722E+00,&
      0.58918E+00, 0.59113E+00, 0.59309E+00, 0.59503E+00, 0.59698E+00,&
      0.59892E+00, 0.60086E+00, 0.60279E+00, 0.60473E+00, 0.60666E+00,&
      0.60858E+00, 0.61050E+00, 0.61242E+00, 0.61434E+00, 0.61625E+00,&
      0.61817E+00, 0.62007E+00, 0.62198E+00, 0.62388E+00, 0.62578E+00,&
      0.62767E+00, 0.62957E+00, 0.63145E+00, 0.63334E+00, 0.63522E+00,&
      0.63710E+00, 0.63898E+00, 0.64086E+00, 0.64273E+00, 0.64460E+00/
                             
     DATA (BNC09M (IA),IA=401,500)/                                     &
      0.64646E+00, 0.64833E+00, 0.65019E+00, 0.65204E+00, 0.65390E+00,&
      0.65575E+00, 0.65760E+00, 0.65944E+00, 0.66128E+00, 0.66312E+00,&
      0.66496E+00, 0.66680E+00, 0.66863E+00, 0.67046E+00, 0.67228E+00,&
      0.67410E+00, 0.67592E+00, 0.67774E+00, 0.67956E+00, 0.68137E+00,&
      0.68318E+00, 0.68498E+00, 0.68679E+00, 0.68859E+00, 0.69039E+00,&
      0.69218E+00, 0.69398E+00, 0.69577E+00, 0.69755E+00, 0.69934E+00,&
      0.70112E+00, 0.70290E+00, 0.70468E+00, 0.70645E+00, 0.70822E+00,&
      0.70999E+00, 0.71176E+00, 0.71352E+00, 0.71528E+00, 0.71704E+00,&
      0.71880E+00, 0.72055E+00, 0.72230E+00, 0.72405E+00, 0.72580E+00,&
      0.72754E+00, 0.72928E+00, 0.73102E+00, 0.73275E+00, 0.73449E+00,&
      0.73622E+00, 0.73794E+00, 0.73967E+00, 0.74139E+00, 0.74311E+00,&
      0.74483E+00, 0.74655E+00, 0.74826E+00, 0.74997E+00, 0.75168E+00,&
      0.75339E+00, 0.75509E+00, 0.75679E+00, 0.75849E+00, 0.76019E+00,&
      0.76188E+00, 0.76357E+00, 0.76526E+00, 0.76695E+00, 0.76863E+00,&
      0.77031E+00, 0.77199E+00, 0.77367E+00, 0.77534E+00, 0.77702E+00,&
      0.77869E+00, 0.78035E+00, 0.78202E+00, 0.78368E+00, 0.78534E+00,&
      0.78700E+00, 0.78866E+00, 0.79031E+00, 0.79197E+00, 0.79362E+00,&
      0.79526E+00, 0.79691E+00, 0.79855E+00, 0.80019E+00, 0.80183E+00,&
      0.80347E+00, 0.80510E+00, 0.80673E+00, 0.80836E+00, 0.80999E+00,&
      0.81161E+00, 0.81323E+00, 0.81486E+00, 0.81647E+00, 0.81809E+00/
                             
     DATA (BNC09M (IA),IA=501,600)/                                     &
      0.81970E+00, 0.82132E+00, 0.82293E+00, 0.82453E+00, 0.82614E+00,&
      0.82774E+00, 0.82934E+00, 0.83094E+00, 0.83254E+00, 0.83413E+00,&
      0.83573E+00, 0.83732E+00, 0.83890E+00, 0.84049E+00, 0.84207E+00,&
      0.84366E+00, 0.84524E+00, 0.84681E+00, 0.84839E+00, 0.84996E+00,&
      0.85154E+00, 0.85311E+00, 0.85467E+00, 0.85624E+00, 0.85780E+00,&
      0.85936E+00, 0.86092E+00, 0.86248E+00, 0.86404E+00, 0.86559E+00,&
      0.86714E+00, 0.86869E+00, 0.87024E+00, 0.87178E+00, 0.87333E+00,&
      0.87487E+00, 0.87641E+00, 0.87795E+00, 0.87948E+00, 0.88101E+00,&
      0.88255E+00, 0.88408E+00, 0.88560E+00, 0.88713E+00, 0.88865E+00,&
      0.89017E+00, 0.89169E+00, 0.89321E+00, 0.89473E+00, 0.89624E+00,&
      0.89776E+00, 0.89927E+00, 0.90077E+00, 0.90228E+00, 0.90379E+00,&
      0.90529E+00, 0.90679E+00, 0.90829E+00, 0.90979E+00, 0.91128E+00,&
      0.91277E+00, 0.91427E+00, 0.91576E+00, 0.91724E+00, 0.91873E+00,&
      0.92021E+00, 0.92170E+00, 0.92318E+00, 0.92466E+00, 0.92613E+00,&
      0.92761E+00, 0.92908E+00, 0.93055E+00, 0.93202E+00, 0.93349E+00,&
      0.93496E+00, 0.93642E+00, 0.93788E+00, 0.93935E+00, 0.94080E+00,&
      0.94226E+00, 0.94372E+00, 0.94517E+00, 0.94662E+00, 0.94807E+00,&
      0.94952E+00, 0.95097E+00, 0.95241E+00, 0.95386E+00, 0.95530E+00,&
      0.95674E+00, 0.95818E+00, 0.95961E+00, 0.96105E+00, 0.96248E+00,&
      0.96391E+00, 0.96534E+00, 0.96677E+00, 0.96820E+00, 0.97353E+00/
                             
     DATA (BNC09M (IA),IA=601,700)/                                     &
      0.98518E+00, 0.99915E+00, 0.10130E+01, 0.10266E+01, 0.10401E+01,&
      0.10535E+01, 0.10667E+01, 0.10797E+01, 0.10927E+01, 0.11054E+01,&
      0.11181E+01, 0.11306E+01, 0.11430E+01, 0.11553E+01, 0.11674E+01,&
      0.11794E+01, 0.11913E+01, 0.12031E+01, 0.12148E+01, 0.12263E+01,&
      0.12378E+01, 0.12491E+01, 0.12604E+01, 0.12715E+01, 0.12825E+01,&
      0.12934E+01, 0.13043E+01, 0.13150E+01, 0.13257E+01, 0.13362E+01,&
      0.13467E+01, 0.13570E+01, 0.13673E+01, 0.13775E+01, 0.13876E+01,&
      0.13976E+01, 0.14075E+01, 0.14174E+01, 0.14272E+01, 0.14369E+01,&
      0.14465E+01, 0.14560E+01, 0.14655E+01, 0.14749E+01, 0.14842E+01,&
      0.14935E+01, 0.15027E+01, 0.15118E+01, 0.15208E+01, 0.15298E+01,&
      0.15387E+01, 0.15476E+01, 0.15563E+01, 0.15651E+01, 0.15737E+01,&
      0.15823E+01, 0.15908E+01, 0.15993E+01, 0.16077E+01, 0.16161E+01,&
      0.16244E+01, 0.16326E+01, 0.16408E+01, 0.16489E+01, 0.16570E+01,&
      0.16650E+01, 0.16730E+01, 0.16809E+01, 0.16888E+01, 0.16966E+01,&
      0.17044E+01, 0.17121E+01, 0.17197E+01, 0.17274E+01, 0.17349E+01,&
      0.17424E+01, 0.17499E+01, 0.17574E+01, 0.17647E+01, 0.17721E+01,&
      0.17794E+01, 0.17866E+01, 0.17938E+01, 0.18010E+01, 0.18081E+01,&
      0.18152E+01, 0.18222E+01, 0.18292E+01, 0.18362E+01, 0.18431E+01,&
      0.18500E+01, 0.18568E+01, 0.18636E+01, 0.18704E+01, 0.18771E+01,&
      0.18838E+01, 0.18905E+01, 0.18971E+01, 0.19037E+01, 0.19102E+01/
                             
     DATA (BNC09M(IA),IA=701,741)/                                      &
      0.19167E+01, 0.19232E+01, 0.19296E+01, 0.19360E+01, 0.19424E+01,&
      0.19488E+01, 0.19551E+01, 0.19613E+01, 0.19676E+01, 0.19738E+01,&
      0.19800E+01, 0.19861E+01, 0.19922E+01, 0.19983E+01, 0.20044E+01,&
      0.20104E+01, 0.20164E+01, 0.20223E+01, 0.20283E+01, 0.20342E+01,&
      0.20401E+01, 0.20459E+01, 0.20517E+01, 0.20575E+01, 0.20633E+01,&
      0.20690E+01, 0.20747E+01, 0.20804E+01, 0.20861E+01, 0.20917E+01,&
      0.20973E+01, 0.21029E+01, 0.21084E+01, 0.21140E+01, 0.21195E+01,&
      0.21249E+01, 0.21304E+01, 0.21358E+01, 0.21412E+01, 0.21466E+01,&
      0.21520E+01                  /                      
!                            
!  ** (H, NO3)               
!                            
     DATA (BNC10M (IA),IA=  1,100)/                                     &
     -0.49808E-01,-0.87670E-01,-0.11206E+00,-0.12725E+00,-0.13801E+00,&
     -0.14607E+00,-0.15233E+00,-0.15727E+00,-0.16121E+00,-0.16437E+00,&
     -0.16689E+00,-0.16889E+00,-0.17045E+00,-0.17164E+00,-0.17251E+00,&
     -0.17311E+00,-0.17346E+00,-0.17359E+00,-0.17354E+00,-0.17332E+00,&
     -0.17295E+00,-0.17244E+00,-0.17181E+00,-0.17107E+00,-0.17023E+00,&
     -0.16931E+00,-0.16829E+00,-0.16721E+00,-0.16605E+00,-0.16483E+00,&
     -0.16356E+00,-0.16223E+00,-0.16086E+00,-0.15944E+00,-0.15798E+00,&
     -0.15649E+00,-0.15496E+00,-0.15340E+00,-0.15182E+00,-0.15021E+00,&
     -0.14858E+00,-0.14693E+00,-0.14526E+00,-0.14357E+00,-0.14187E+00,&
     -0.14015E+00,-0.13842E+00,-0.13668E+00,-0.13493E+00,-0.13316E+00,&
     -0.13139E+00,-0.12961E+00,-0.12783E+00,-0.12603E+00,-0.12423E+00,&
     -0.12243E+00,-0.12061E+00,-0.11880E+00,-0.11697E+00,-0.11514E+00,&
     -0.11330E+00,-0.11146E+00,-0.10961E+00,-0.10776E+00,-0.10590E+00,&
     -0.10403E+00,-0.10215E+00,-0.10027E+00,-0.98377E-01,-0.96477E-01,&
     -0.94568E-01,-0.92650E-01,-0.90723E-01,-0.88785E-01,-0.86836E-01,&
     -0.84877E-01,-0.82906E-01,-0.80923E-01,-0.78927E-01,-0.76919E-01,&
     -0.74899E-01,-0.72864E-01,-0.70817E-01,-0.68755E-01,-0.66679E-01,&
     -0.64590E-01,-0.62485E-01,-0.60367E-01,-0.58234E-01,-0.56087E-01,&
     -0.53925E-01,-0.51749E-01,-0.49559E-01,-0.47354E-01,-0.45136E-01,&
     -0.42905E-01,-0.40659E-01,-0.38401E-01,-0.36131E-01,-0.33847E-01/
                             
     DATA (BNC10M (IA),IA=101,200)/                                     &
     -0.31552E-01,-0.29246E-01,-0.26928E-01,-0.24599E-01,-0.22261E-01,&
     -0.19912E-01,-0.17554E-01,-0.15187E-01,-0.12812E-01,-0.10429E-01,&
     -0.80390E-02,-0.56417E-02,-0.32380E-02,-0.82822E-03, 0.15871E-02,&
      0.40074E-02, 0.64324E-02, 0.88617E-02, 0.11295E-01, 0.13731E-01,&
      0.15915E-01, 0.18387E-01, 0.20858E-01, 0.23329E-01, 0.25799E-01,&
      0.28268E-01, 0.30736E-01, 0.33203E-01, 0.35669E-01, 0.38134E-01,&
      0.40598E-01, 0.43060E-01, 0.45521E-01, 0.47981E-01, 0.50440E-01,&
      0.52896E-01, 0.55352E-01, 0.57806E-01, 0.60258E-01, 0.62708E-01,&
      0.65157E-01, 0.67604E-01, 0.70049E-01, 0.72492E-01, 0.74934E-01,&
      0.77373E-01, 0.79810E-01, 0.82246E-01, 0.84679E-01, 0.87110E-01,&
      0.89539E-01, 0.91966E-01, 0.94390E-01, 0.96812E-01, 0.99232E-01,&
      0.10165E+00, 0.10407E+00, 0.10648E+00, 0.10889E+00, 0.11130E+00,&
      0.11370E+00, 0.11611E+00, 0.11851E+00, 0.12090E+00, 0.12330E+00,&
      0.12569E+00, 0.12808E+00, 0.13047E+00, 0.13285E+00, 0.13524E+00,&
      0.13762E+00, 0.13999E+00, 0.14237E+00, 0.14474E+00, 0.14711E+00,&
      0.14947E+00, 0.15183E+00, 0.15419E+00, 0.15655E+00, 0.15891E+00,&
      0.16126E+00, 0.16361E+00, 0.16595E+00, 0.16829E+00, 0.17063E+00,&
      0.17297E+00, 0.17530E+00, 0.17764E+00, 0.17996E+00, 0.18229E+00,&
      0.18461E+00, 0.18693E+00, 0.18924E+00, 0.19156E+00, 0.19387E+00,&
      0.19617E+00, 0.19848E+00, 0.20078E+00, 0.20308E+00, 0.20537E+00/
                             
     DATA (BNC10M (IA),IA=201,300)/                                     &
      0.20766E+00, 0.20995E+00, 0.21223E+00, 0.21452E+00, 0.21680E+00,&
      0.21907E+00, 0.22134E+00, 0.22361E+00, 0.22588E+00, 0.22814E+00,&
      0.23040E+00, 0.23266E+00, 0.23491E+00, 0.23717E+00, 0.23941E+00,&
      0.24166E+00, 0.24390E+00, 0.24614E+00, 0.24837E+00, 0.25060E+00,&
      0.25283E+00, 0.25506E+00, 0.25728E+00, 0.25950E+00, 0.26171E+00,&
      0.26393E+00, 0.26614E+00, 0.26834E+00, 0.27054E+00, 0.27274E+00,&
      0.27494E+00, 0.27713E+00, 0.27933E+00, 0.28151E+00, 0.28370E+00,&
      0.28588E+00, 0.28805E+00, 0.29023E+00, 0.29240E+00, 0.29457E+00,&
      0.29673E+00, 0.29890E+00, 0.30105E+00, 0.30321E+00, 0.30536E+00,&
      0.30751E+00, 0.30966E+00, 0.31180E+00, 0.31394E+00, 0.31607E+00,&
      0.31821E+00, 0.32034E+00, 0.32247E+00, 0.32459E+00, 0.32671E+00,&
      0.32883E+00, 0.33094E+00, 0.33305E+00, 0.33516E+00, 0.33727E+00,&
      0.33937E+00, 0.34147E+00, 0.34356E+00, 0.34565E+00, 0.34774E+00,&
      0.34983E+00, 0.35191E+00, 0.35399E+00, 0.35607E+00, 0.35814E+00,&
      0.36021E+00, 0.36228E+00, 0.36435E+00, 0.36641E+00, 0.36847E+00,&
      0.37052E+00, 0.37257E+00, 0.37462E+00, 0.37667E+00, 0.37871E+00,&
      0.38075E+00, 0.38279E+00, 0.38482E+00, 0.38685E+00, 0.38888E+00,&
      0.39091E+00, 0.39293E+00, 0.39495E+00, 0.39696E+00, 0.39898E+00,&
      0.40099E+00, 0.40299E+00, 0.40500E+00, 0.40700E+00, 0.40899E+00,&
      0.41099E+00, 0.41298E+00, 0.41497E+00, 0.41696E+00, 0.41894E+00/
                             
     DATA (BNC10M (IA),IA=301,400)/                                     &
      0.42092E+00, 0.42290E+00, 0.42487E+00, 0.42684E+00, 0.42881E+00,&
      0.43077E+00, 0.43274E+00, 0.43470E+00, 0.43665E+00, 0.43861E+00,&
      0.44056E+00, 0.44251E+00, 0.44445E+00, 0.44639E+00, 0.44833E+00,&
      0.45027E+00, 0.45220E+00, 0.45413E+00, 0.45606E+00, 0.45798E+00,&
      0.45991E+00, 0.46183E+00, 0.46374E+00, 0.46566E+00, 0.46757E+00,&
      0.46947E+00, 0.47138E+00, 0.47328E+00, 0.47518E+00, 0.47708E+00,&
      0.47897E+00, 0.48086E+00, 0.48275E+00, 0.48464E+00, 0.48652E+00,&
      0.48840E+00, 0.49028E+00, 0.49215E+00, 0.49402E+00, 0.49589E+00,&
      0.49776E+00, 0.49962E+00, 0.50148E+00, 0.50334E+00, 0.50520E+00,&
      0.50705E+00, 0.50890E+00, 0.51075E+00, 0.51259E+00, 0.51443E+00,&
      0.51627E+00, 0.51811E+00, 0.51994E+00, 0.52178E+00, 0.52360E+00,&
      0.52543E+00, 0.52725E+00, 0.52907E+00, 0.53089E+00, 0.53271E+00,&
      0.53452E+00, 0.53633E+00, 0.53814E+00, 0.53994E+00, 0.54175E+00,&
      0.54355E+00, 0.54534E+00, 0.54714E+00, 0.54893E+00, 0.55072E+00,&
      0.55251E+00, 0.55429E+00, 0.55607E+00, 0.55785E+00, 0.55963E+00,&
      0.56140E+00, 0.56318E+00, 0.56495E+00, 0.56671E+00, 0.56848E+00,&
      0.57024E+00, 0.57200E+00, 0.57375E+00, 0.57551E+00, 0.57726E+00,&
      0.57901E+00, 0.58076E+00, 0.58250E+00, 0.58424E+00, 0.58598E+00,&
      0.58772E+00, 0.58945E+00, 0.59119E+00, 0.59292E+00, 0.59464E+00,&
      0.59637E+00, 0.59809E+00, 0.59981E+00, 0.60153E+00, 0.60324E+00/
                             
     DATA (BNC10M (IA),IA=401,500)/                                     &
      0.60496E+00, 0.60667E+00, 0.60838E+00, 0.61008E+00, 0.61178E+00,&
      0.61349E+00, 0.61518E+00, 0.61688E+00, 0.61857E+00, 0.62027E+00,&
      0.62196E+00, 0.62364E+00, 0.62533E+00, 0.62701E+00, 0.62869E+00,&
      0.63037E+00, 0.63204E+00, 0.63372E+00, 0.63539E+00, 0.63705E+00,&
      0.63872E+00, 0.64039E+00, 0.64205E+00, 0.64371E+00, 0.64536E+00,&
      0.64702E+00, 0.64867E+00, 0.65032E+00, 0.65197E+00, 0.65362E+00,&
      0.65526E+00, 0.65690E+00, 0.65854E+00, 0.66018E+00, 0.66181E+00,&
      0.66344E+00, 0.66507E+00, 0.66670E+00, 0.66833E+00, 0.66995E+00,&
      0.67157E+00, 0.67319E+00, 0.67481E+00, 0.67643E+00, 0.67804E+00,&
      0.67965E+00, 0.68126E+00, 0.68286E+00, 0.68447E+00, 0.68607E+00,&
      0.68767E+00, 0.68927E+00, 0.69086E+00, 0.69246E+00, 0.69405E+00,&
      0.69564E+00, 0.69723E+00, 0.69881E+00, 0.70040E+00, 0.70198E+00,&
      0.70356E+00, 0.70513E+00, 0.70671E+00, 0.70828E+00, 0.70985E+00,&
      0.71142E+00, 0.71299E+00, 0.71455E+00, 0.71611E+00, 0.71767E+00,&
      0.71923E+00, 0.72079E+00, 0.72234E+00, 0.72390E+00, 0.72545E+00,&
      0.72699E+00, 0.72854E+00, 0.73008E+00, 0.73163E+00, 0.73317E+00,&
      0.73471E+00, 0.73624E+00, 0.73778E+00, 0.73931E+00, 0.74084E+00,&
      0.74237E+00, 0.74389E+00, 0.74542E+00, 0.74694E+00, 0.74846E+00,&
      0.74998E+00, 0.75150E+00, 0.75301E+00, 0.75453E+00, 0.75604E+00,&
      0.75755E+00, 0.75905E+00, 0.76056E+00, 0.76206E+00, 0.76356E+00/
                             
     DATA (BNC10M (IA),IA=501,600)/                                     &
      0.76506E+00, 0.76656E+00, 0.76806E+00, 0.76955E+00, 0.77104E+00,&
      0.77253E+00, 0.77402E+00, 0.77551E+00, 0.77699E+00, 0.77847E+00,&
      0.77995E+00, 0.78143E+00, 0.78291E+00, 0.78439E+00, 0.78586E+00,&
      0.78733E+00, 0.78880E+00, 0.79027E+00, 0.79173E+00, 0.79320E+00,&
      0.79466E+00, 0.79612E+00, 0.79758E+00, 0.79904E+00, 0.80049E+00,&
      0.80195E+00, 0.80340E+00, 0.80485E+00, 0.80630E+00, 0.80774E+00,&
      0.80919E+00, 0.81063E+00, 0.81207E+00, 0.81351E+00, 0.81495E+00,&
      0.81638E+00, 0.81782E+00, 0.81925E+00, 0.82068E+00, 0.82211E+00,&
      0.82353E+00, 0.82496E+00, 0.82638E+00, 0.82780E+00, 0.82923E+00,&
      0.83064E+00, 0.83206E+00, 0.83347E+00, 0.83489E+00, 0.83630E+00,&
      0.83771E+00, 0.83912E+00, 0.84052E+00, 0.84193E+00, 0.84333E+00,&
      0.84473E+00, 0.84613E+00, 0.84753E+00, 0.84893E+00, 0.85032E+00,&
      0.85171E+00, 0.85311E+00, 0.85450E+00, 0.85588E+00, 0.85727E+00,&
      0.85866E+00, 0.86004E+00, 0.86142E+00, 0.86280E+00, 0.86418E+00,&
      0.86555E+00, 0.86693E+00, 0.86830E+00, 0.86968E+00, 0.87105E+00,&
      0.87241E+00, 0.87378E+00, 0.87515E+00, 0.87651E+00, 0.87787E+00,&
      0.87923E+00, 0.88059E+00, 0.88195E+00, 0.88330E+00, 0.88466E+00,&
      0.88601E+00, 0.88736E+00, 0.88871E+00, 0.89006E+00, 0.89141E+00,&
      0.89275E+00, 0.89410E+00, 0.89544E+00, 0.89678E+00, 0.89812E+00,&
      0.89945E+00, 0.90079E+00, 0.90212E+00, 0.90346E+00, 0.90844E+00/
                             
     DATA (BNC10M (IA),IA=601,700)/                                     &
      0.91933E+00, 0.93239E+00, 0.94531E+00, 0.95808E+00, 0.97072E+00,&
      0.98322E+00, 0.99558E+00, 0.10078E+01, 0.10199E+01, 0.10319E+01,&
      0.10438E+01, 0.10555E+01, 0.10671E+01, 0.10786E+01, 0.10900E+01,&
      0.11013E+01, 0.11124E+01, 0.11235E+01, 0.11344E+01, 0.11453E+01,&
      0.11560E+01, 0.11666E+01, 0.11772E+01, 0.11876E+01, 0.11980E+01,&
      0.12082E+01, 0.12184E+01, 0.12285E+01, 0.12385E+01, 0.12484E+01,&
      0.12582E+01, 0.12679E+01, 0.12776E+01, 0.12871E+01, 0.12966E+01,&
      0.13060E+01, 0.13154E+01, 0.13246E+01, 0.13338E+01, 0.13429E+01,&
      0.13519E+01, 0.13609E+01, 0.13698E+01, 0.13786E+01, 0.13874E+01,&
      0.13960E+01, 0.14047E+01, 0.14132E+01, 0.14217E+01, 0.14301E+01,&
      0.14385E+01, 0.14468E+01, 0.14550E+01, 0.14632E+01, 0.14713E+01,&
      0.14794E+01, 0.14874E+01, 0.14954E+01, 0.15033E+01, 0.15111E+01,&
      0.15189E+01, 0.15266E+01, 0.15343E+01, 0.15419E+01, 0.15495E+01,&
      0.15570E+01, 0.15645E+01, 0.15719E+01, 0.15793E+01, 0.15866E+01,&
      0.15939E+01, 0.16012E+01, 0.16084E+01, 0.16155E+01, 0.16226E+01,&
      0.16297E+01, 0.16367E+01, 0.16436E+01, 0.16506E+01, 0.16574E+01,&
      0.16643E+01, 0.16711E+01, 0.16778E+01, 0.16845E+01, 0.16912E+01,&
      0.16979E+01, 0.17045E+01, 0.17110E+01, 0.17175E+01, 0.17240E+01,&
      0.17305E+01, 0.17369E+01, 0.17433E+01, 0.17496E+01, 0.17559E+01,&
      0.17622E+01, 0.17684E+01, 0.17746E+01, 0.17808E+01, 0.17869E+01/
                             
     DATA (BNC10M(IA),IA=701,741)/                                      &
      0.17930E+01, 0.17991E+01, 0.18051E+01, 0.18111E+01, 0.18171E+01,&
      0.18230E+01, 0.18289E+01, 0.18348E+01, 0.18406E+01, 0.18464E+01,&
      0.18522E+01, 0.18580E+01, 0.18637E+01, 0.18694E+01, 0.18751E+01,&
      0.18807E+01, 0.18863E+01, 0.18919E+01, 0.18974E+01, 0.19030E+01,&
      0.19085E+01, 0.19139E+01, 0.19194E+01, 0.19248E+01, 0.19302E+01,&
      0.19356E+01, 0.19409E+01, 0.19462E+01, 0.19515E+01, 0.19568E+01,&
      0.19620E+01, 0.19672E+01, 0.19724E+01, 0.19776E+01, 0.19828E+01,&
      0.19879E+01, 0.19930E+01, 0.19981E+01, 0.20031E+01, 0.20081E+01,&
      0.20131E+01                  /                      
!                            
!  ** (H, Cl)                
!                            
     DATA (BNC11M (IA),IA=  1,100)/                                     &
     -0.48532E-01,-0.83296E-01,-0.10417E+00,-0.11618E+00,-0.12392E+00,&
     -0.12909E+00,-0.13252E+00,-0.13467E+00,-0.13584E+00,-0.13624E+00,&
     -0.13600E+00,-0.13524E+00,-0.13402E+00,-0.13242E+00,-0.13047E+00,&
     -0.12822E+00,-0.12570E+00,-0.12295E+00,-0.11997E+00,-0.11680E+00,&
     -0.11344E+00,-0.10992E+00,-0.10625E+00,-0.10244E+00,-0.98493E-01,&
     -0.94429E-01,-0.90252E-01,-0.85971E-01,-0.81593E-01,-0.77125E-01,&
     -0.72571E-01,-0.67939E-01,-0.63234E-01,-0.58460E-01,-0.53621E-01,&
     -0.48723E-01,-0.43768E-01,-0.38762E-01,-0.33706E-01,-0.28606E-01,&
     -0.23462E-01,-0.18280E-01,-0.13061E-01,-0.78068E-02,-0.25211E-02,&
      0.27943E-02, 0.81376E-02, 0.13507E-01, 0.18900E-01, 0.24317E-01,&
      0.29754E-01, 0.35212E-01, 0.40689E-01, 0.46183E-01, 0.51695E-01,&
      0.57224E-01, 0.62769E-01, 0.68329E-01, 0.73904E-01, 0.79495E-01,&
      0.85100E-01, 0.90721E-01, 0.96357E-01, 0.10201E+00, 0.10768E+00,&
      0.11336E+00, 0.11906E+00, 0.12478E+00, 0.13051E+00, 0.13627E+00,&
      0.14204E+00, 0.14783E+00, 0.15365E+00, 0.15948E+00, 0.16534E+00,&
      0.17123E+00, 0.17713E+00, 0.18307E+00, 0.18902E+00, 0.19501E+00,&
      0.20102E+00, 0.20706E+00, 0.21313E+00, 0.21923E+00, 0.22536E+00,&
      0.23151E+00, 0.23770E+00, 0.24392E+00, 0.25017E+00, 0.25645E+00,&
      0.26276E+00, 0.26910E+00, 0.27546E+00, 0.28186E+00, 0.28829E+00,&
      0.29475E+00, 0.30123E+00, 0.30774E+00, 0.31428E+00, 0.32084E+00/
                             
     DATA (BNC11M (IA),IA=101,200)/                                     &
      0.32743E+00, 0.33404E+00, 0.34068E+00, 0.34734E+00, 0.35401E+00,&
      0.36071E+00, 0.36742E+00, 0.37415E+00, 0.38090E+00, 0.38766E+00,&
      0.39444E+00, 0.40123E+00, 0.40803E+00, 0.41484E+00, 0.42166E+00,&
      0.42848E+00, 0.43532E+00, 0.44216E+00, 0.44900E+00, 0.45585E+00,&
      0.46211E+00, 0.46904E+00, 0.47595E+00, 0.48286E+00, 0.48977E+00,&
      0.49667E+00, 0.50356E+00, 0.51044E+00, 0.51732E+00, 0.52419E+00,&
      0.53105E+00, 0.53791E+00, 0.54476E+00, 0.55160E+00, 0.55843E+00,&
      0.56525E+00, 0.57207E+00, 0.57887E+00, 0.58567E+00, 0.59246E+00,&
      0.59924E+00, 0.60601E+00, 0.61277E+00, 0.61952E+00, 0.62627E+00,&
      0.63300E+00, 0.63972E+00, 0.64643E+00, 0.65314E+00, 0.65983E+00,&
      0.66651E+00, 0.67319E+00, 0.67985E+00, 0.68650E+00, 0.69314E+00,&
      0.69977E+00, 0.70639E+00, 0.71300E+00, 0.71960E+00, 0.72618E+00,&
      0.73276E+00, 0.73933E+00, 0.74588E+00, 0.75242E+00, 0.75896E+00,&
      0.76548E+00, 0.77198E+00, 0.77848E+00, 0.78497E+00, 0.79144E+00,&
      0.79791E+00, 0.80436E+00, 0.81080E+00, 0.81723E+00, 0.82365E+00,&
      0.83005E+00, 0.83645E+00, 0.84283E+00, 0.84920E+00, 0.85556E+00,&
      0.86191E+00, 0.86824E+00, 0.87457E+00, 0.88088E+00, 0.88718E+00,&
      0.89347E+00, 0.89975E+00, 0.90601E+00, 0.91226E+00, 0.91851E+00,&
      0.92473E+00, 0.93095E+00, 0.93716E+00, 0.94335E+00, 0.94953E+00,&
      0.95570E+00, 0.96186E+00, 0.96801E+00, 0.97414E+00, 0.98027E+00/
                             
     DATA (BNC11M (IA),IA=201,300)/                                     &
      0.98638E+00, 0.99248E+00, 0.99857E+00, 0.10046E+01, 0.10107E+01,&
      0.10168E+01, 0.10228E+01, 0.10288E+01, 0.10348E+01, 0.10408E+01,&
      0.10468E+01, 0.10528E+01, 0.10588E+01, 0.10648E+01, 0.10707E+01,&
      0.10766E+01, 0.10826E+01, 0.10885E+01, 0.10944E+01, 0.11003E+01,&
      0.11061E+01, 0.11120E+01, 0.11179E+01, 0.11237E+01, 0.11295E+01,&
      0.11354E+01, 0.11412E+01, 0.11470E+01, 0.11527E+01, 0.11585E+01,&
      0.11643E+01, 0.11700E+01, 0.11758E+01, 0.11815E+01, 0.11872E+01,&
      0.11929E+01, 0.11986E+01, 0.12043E+01, 0.12100E+01, 0.12156E+01,&
      0.12213E+01, 0.12269E+01, 0.12326E+01, 0.12382E+01, 0.12438E+01,&
      0.12494E+01, 0.12550E+01, 0.12605E+01, 0.12661E+01, 0.12717E+01,&
      0.12772E+01, 0.12827E+01, 0.12883E+01, 0.12938E+01, 0.12993E+01,&
      0.13048E+01, 0.13102E+01, 0.13157E+01, 0.13212E+01, 0.13266E+01,&
      0.13320E+01, 0.13375E+01, 0.13429E+01, 0.13483E+01, 0.13537E+01,&
      0.13591E+01, 0.13644E+01, 0.13698E+01, 0.13752E+01, 0.13805E+01,&
      0.13858E+01, 0.13912E+01, 0.13965E+01, 0.14018E+01, 0.14071E+01,&
      0.14123E+01, 0.14176E+01, 0.14229E+01, 0.14281E+01, 0.14334E+01,&
      0.14386E+01, 0.14438E+01, 0.14490E+01, 0.14542E+01, 0.14594E+01,&
      0.14646E+01, 0.14698E+01, 0.14749E+01, 0.14801E+01, 0.14852E+01,&
      0.14904E+01, 0.14955E+01, 0.15006E+01, 0.15057E+01, 0.15108E+01,&
      0.15159E+01, 0.15210E+01, 0.15260E+01, 0.15311E+01, 0.15362E+01/
                             
     DATA (BNC11M (IA),IA=301,400)/                                     &
      0.15412E+01, 0.15462E+01, 0.15512E+01, 0.15563E+01, 0.15613E+01,&
      0.15663E+01, 0.15712E+01, 0.15762E+01, 0.15812E+01, 0.15861E+01,&
      0.15911E+01, 0.15960E+01, 0.16010E+01, 0.16059E+01, 0.16108E+01,&
      0.16157E+01, 0.16206E+01, 0.16255E+01, 0.16303E+01, 0.16352E+01,&
      0.16401E+01, 0.16449E+01, 0.16498E+01, 0.16546E+01, 0.16594E+01,&
      0.16642E+01, 0.16690E+01, 0.16738E+01, 0.16786E+01, 0.16834E+01,&
      0.16882E+01, 0.16930E+01, 0.16977E+01, 0.17025E+01, 0.17072E+01,&
      0.17119E+01, 0.17167E+01, 0.17214E+01, 0.17261E+01, 0.17308E+01,&
      0.17355E+01, 0.17401E+01, 0.17448E+01, 0.17495E+01, 0.17541E+01,&
      0.17588E+01, 0.17634E+01, 0.17681E+01, 0.17727E+01, 0.17773E+01,&
      0.17819E+01, 0.17865E+01, 0.17911E+01, 0.17957E+01, 0.18003E+01,&
      0.18048E+01, 0.18094E+01, 0.18139E+01, 0.18185E+01, 0.18230E+01,&
      0.18276E+01, 0.18321E+01, 0.18366E+01, 0.18411E+01, 0.18456E+01,&
      0.18501E+01, 0.18546E+01, 0.18591E+01, 0.18635E+01, 0.18680E+01,&
      0.18724E+01, 0.18769E+01, 0.18813E+01, 0.18858E+01, 0.18902E+01,&
      0.18946E+01, 0.18990E+01, 0.19034E+01, 0.19078E+01, 0.19122E+01,&
      0.19166E+01, 0.19210E+01, 0.19253E+01, 0.19297E+01, 0.19340E+01,&
      0.19384E+01, 0.19427E+01, 0.19471E+01, 0.19514E+01, 0.19557E+01,&
      0.19600E+01, 0.19643E+01, 0.19686E+01, 0.19729E+01, 0.19772E+01,&
      0.19814E+01, 0.19857E+01, 0.19900E+01, 0.19942E+01, 0.19985E+01/
                              
     DATA (BNC11M (IA),IA=401,500)/                                     &
      0.20027E+01, 0.20069E+01, 0.20112E+01, 0.20154E+01, 0.20196E+01,&
      0.20238E+01, 0.20280E+01, 0.20322E+01, 0.20364E+01, 0.20406E+01,&
      0.20447E+01, 0.20489E+01, 0.20531E+01, 0.20572E+01, 0.20614E+01,&
      0.20655E+01, 0.20697E+01, 0.20738E+01, 0.20779E+01, 0.20820E+01,&
      0.20861E+01, 0.20902E+01, 0.20943E+01, 0.20984E+01, 0.21025E+01,&
      0.21066E+01, 0.21106E+01, 0.21147E+01, 0.21188E+01, 0.21228E+01,&
      0.21269E+01, 0.21309E+01, 0.21349E+01, 0.21390E+01, 0.21430E+01,&
      0.21470E+01, 0.21510E+01, 0.21550E+01, 0.21590E+01, 0.21630E+01,&
      0.21670E+01, 0.21709E+01, 0.21749E+01, 0.21789E+01, 0.21828E+01,&
      0.21868E+01, 0.21907E+01, 0.21947E+01, 0.21986E+01, 0.22026E+01,&
      0.22065E+01, 0.22104E+01, 0.22143E+01, 0.22182E+01, 0.22221E+01,&
      0.22260E+01, 0.22299E+01, 0.22338E+01, 0.22377E+01, 0.22415E+01,&
      0.22454E+01, 0.22493E+01, 0.22531E+01, 0.22570E+01, 0.22608E+01,&
      0.22646E+01, 0.22685E+01, 0.22723E+01, 0.22761E+01, 0.22799E+01,&
      0.22838E+01, 0.22876E+01, 0.22914E+01, 0.22951E+01, 0.22989E+01,&
      0.23027E+01, 0.23065E+01, 0.23103E+01, 0.23140E+01, 0.23178E+01,&
      0.23215E+01, 0.23253E+01, 0.23290E+01, 0.23328E+01, 0.23365E+01,&
      0.23402E+01, 0.23440E+01, 0.23477E+01, 0.23514E+01, 0.23551E+01,&
      0.23588E+01, 0.23625E+01, 0.23662E+01, 0.23699E+01, 0.23736E+01,&
      0.23772E+01, 0.23809E+01, 0.23846E+01, 0.23882E+01, 0.23919E+01/
                             
     DATA (BNC11M (IA),IA=501,600)/                                     &
      0.23955E+01, 0.23992E+01, 0.24028E+01, 0.24065E+01, 0.24101E+01,&
      0.24137E+01, 0.24173E+01, 0.24210E+01, 0.24246E+01, 0.24282E+01,&
      0.24318E+01, 0.24354E+01, 0.24390E+01, 0.24425E+01, 0.24461E+01,&
      0.24497E+01, 0.24533E+01, 0.24568E+01, 0.24604E+01, 0.24640E+01,&
      0.24675E+01, 0.24711E+01, 0.24746E+01, 0.24781E+01, 0.24817E+01,&
      0.24852E+01, 0.24887E+01, 0.24922E+01, 0.24957E+01, 0.24993E+01,&
      0.25028E+01, 0.25063E+01, 0.25097E+01, 0.25132E+01, 0.25167E+01,&
      0.25202E+01, 0.25237E+01, 0.25272E+01, 0.25306E+01, 0.25341E+01,&
      0.25375E+01, 0.25410E+01, 0.25444E+01, 0.25479E+01, 0.25513E+01,&
      0.25548E+01, 0.25582E+01, 0.25616E+01, 0.25650E+01, 0.25684E+01,&
      0.25719E+01, 0.25753E+01, 0.25787E+01, 0.25821E+01, 0.25855E+01,&
      0.25889E+01, 0.25922E+01, 0.25956E+01, 0.25990E+01, 0.26024E+01,&
      0.26057E+01, 0.26091E+01, 0.26125E+01, 0.26158E+01, 0.26192E+01,&
      0.26225E+01, 0.26258E+01, 0.26292E+01, 0.26325E+01, 0.26358E+01,&
      0.26392E+01, 0.26425E+01, 0.26458E+01, 0.26491E+01, 0.26524E+01,&
      0.26557E+01, 0.26590E+01, 0.26623E+01, 0.26656E+01, 0.26689E+01,&
      0.26722E+01, 0.26755E+01, 0.26787E+01, 0.26820E+01, 0.26853E+01,&
      0.26885E+01, 0.26918E+01, 0.26951E+01, 0.26983E+01, 0.27016E+01,&
      0.27048E+01, 0.27080E+01, 0.27113E+01, 0.27145E+01, 0.27177E+01,&
      0.27209E+01, 0.27242E+01, 0.27274E+01, 0.27306E+01, 0.27426E+01/
                             
     DATA (BNC11M (IA),IA=601,700)/                                     &
      0.27688E+01, 0.28002E+01, 0.28313E+01, 0.28620E+01, 0.28923E+01,&
      0.29223E+01, 0.29519E+01, 0.29812E+01, 0.30102E+01, 0.30388E+01,&
      0.30672E+01, 0.30952E+01, 0.31229E+01, 0.31504E+01, 0.31775E+01,&
      0.32044E+01, 0.32310E+01, 0.32573E+01, 0.32834E+01, 0.33092E+01,&
      0.33347E+01, 0.33601E+01, 0.33851E+01, 0.34099E+01, 0.34345E+01,&
      0.34589E+01, 0.34830E+01, 0.35069E+01, 0.35306E+01, 0.35541E+01,&
      0.35773E+01, 0.36004E+01, 0.36232E+01, 0.36459E+01, 0.36683E+01,&
      0.36906E+01, 0.37127E+01, 0.37346E+01, 0.37563E+01, 0.37778E+01,&
      0.37992E+01, 0.38203E+01, 0.38413E+01, 0.38622E+01, 0.38828E+01,&
      0.39033E+01, 0.39237E+01, 0.39439E+01, 0.39639E+01, 0.39838E+01,&
      0.40035E+01, 0.40231E+01, 0.40425E+01, 0.40618E+01, 0.40809E+01,&
      0.40999E+01, 0.41188E+01, 0.41375E+01, 0.41561E+01, 0.41746E+01,&
      0.41929E+01, 0.42111E+01, 0.42292E+01, 0.42472E+01, 0.42650E+01,&
      0.42827E+01, 0.43003E+01, 0.43177E+01, 0.43351E+01, 0.43523E+01,&
      0.43695E+01, 0.43865E+01, 0.44034E+01, 0.44202E+01, 0.44368E+01,&
      0.44534E+01, 0.44699E+01, 0.44862E+01, 0.45025E+01, 0.45187E+01,&
      0.45347E+01, 0.45507E+01, 0.45666E+01, 0.45823E+01, 0.45980E+01,&
      0.46136E+01, 0.46291E+01, 0.46445E+01, 0.46598E+01, 0.46750E+01,&
      0.46901E+01, 0.47051E+01, 0.47201E+01, 0.47350E+01, 0.47497E+01,&
      0.47644E+01, 0.47791E+01, 0.47936E+01, 0.48080E+01, 0.48224E+01/
                             
     DATA (BNC11M(IA),IA=701,741)/                                      &
      0.48367E+01, 0.48509E+01, 0.48651E+01, 0.48791E+01, 0.48931E+01,&
      0.49070E+01, 0.49208E+01, 0.49346E+01, 0.49483E+01, 0.49619E+01,&
      0.49755E+01, 0.49889E+01, 0.50023E+01, 0.50157E+01, 0.50290E+01,&
      0.50422E+01, 0.50553E+01, 0.50684E+01, 0.50814E+01, 0.50943E+01,&
      0.51072E+01, 0.51200E+01, 0.51327E+01, 0.51454E+01, 0.51580E+01,&
      0.51706E+01, 0.51831E+01, 0.51956E+01, 0.52079E+01, 0.52203E+01,&
      0.52325E+01, 0.52447E+01, 0.52569E+01, 0.52690E+01, 0.52810E+01,&
      0.52930E+01, 0.53049E+01, 0.53168E+01, 0.53286E+01, 0.53404E+01,&
      0.53521E+01                  /                      
!                            
!  ** NaHSO4                 
!                            
     DATA (BNC12M (IA),IA=  1,100)/                                     &
     -0.49644E-01,-0.87391E-01,-0.11193E+00,-0.12742E+00,-0.13854E+00,&
     -0.14701E+00,-0.15369E+00,-0.15906E+00,-0.16342E+00,-0.16698E+00,&
     -0.16989E+00,-0.17226E+00,-0.17416E+00,-0.17565E+00,-0.17680E+00,&
     -0.17763E+00,-0.17818E+00,-0.17848E+00,-0.17855E+00,-0.17840E+00,&
     -0.17807E+00,-0.17755E+00,-0.17687E+00,-0.17603E+00,-0.17505E+00,&
     -0.17393E+00,-0.17268E+00,-0.17131E+00,-0.16982E+00,-0.16823E+00,&
     -0.16653E+00,-0.16473E+00,-0.16284E+00,-0.16086E+00,-0.15879E+00,&
     -0.15664E+00,-0.15441E+00,-0.15211E+00,-0.14974E+00,-0.14729E+00,&
     -0.14479E+00,-0.14222E+00,-0.13959E+00,-0.13690E+00,-0.13415E+00,&
     -0.13136E+00,-0.12851E+00,-0.12561E+00,-0.12267E+00,-0.11968E+00,&
     -0.11665E+00,-0.11358E+00,-0.11046E+00,-0.10731E+00,-0.10412E+00,&
     -0.10089E+00,-0.97629E-01,-0.94332E-01,-0.91002E-01,-0.87640E-01,&
     -0.84246E-01,-0.80821E-01,-0.77366E-01,-0.73882E-01,-0.70367E-01,&
     -0.66825E-01,-0.63253E-01,-0.59653E-01,-0.56026E-01,-0.52370E-01,&
     -0.48687E-01,-0.44975E-01,-0.41237E-01,-0.37470E-01,-0.33676E-01,&
     -0.29854E-01,-0.26004E-01,-0.22127E-01,-0.18221E-01,-0.14288E-01,&
     -0.10326E-01,-0.63369E-02,-0.23194E-02, 0.17259E-02, 0.57993E-02,&
      0.99002E-02, 0.14029E-01, 0.18185E-01, 0.22368E-01, 0.26578E-01,&
      0.30815E-01, 0.35078E-01, 0.39366E-01, 0.43679E-01, 0.48017E-01,&
      0.52379E-01, 0.56764E-01, 0.61172E-01, 0.65602E-01, 0.70053E-01/
                             
     DATA (BNC12M (IA),IA=101,200)/                                     &
      0.74523E-01, 0.79013E-01, 0.83522E-01, 0.88048E-01, 0.92591E-01,&
      0.97150E-01, 0.10172E+00, 0.10631E+00, 0.11091E+00, 0.11552E+00,&
      0.12014E+00, 0.12478E+00, 0.12942E+00, 0.13407E+00, 0.13872E+00,&
      0.14339E+00, 0.14806E+00, 0.15273E+00, 0.15741E+00, 0.16209E+00,&
      0.16635E+00, 0.17109E+00, 0.17581E+00, 0.18054E+00, 0.18526E+00,&
      0.18997E+00, 0.19469E+00, 0.19939E+00, 0.20409E+00, 0.20879E+00,&
      0.21348E+00, 0.21816E+00, 0.22284E+00, 0.22751E+00, 0.23218E+00,&
      0.23684E+00, 0.24149E+00, 0.24614E+00, 0.25078E+00, 0.25542E+00,&
      0.26004E+00, 0.26466E+00, 0.26927E+00, 0.27388E+00, 0.27848E+00,&
      0.28307E+00, 0.28765E+00, 0.29223E+00, 0.29680E+00, 0.30136E+00,&
      0.30591E+00, 0.31045E+00, 0.31499E+00, 0.31952E+00, 0.32404E+00,&
      0.32855E+00, 0.33306E+00, 0.33755E+00, 0.34204E+00, 0.34652E+00,&
      0.35099E+00, 0.35545E+00, 0.35991E+00, 0.36436E+00, 0.36879E+00,&
      0.37322E+00, 0.37764E+00, 0.38206E+00, 0.38646E+00, 0.39086E+00,&
      0.39524E+00, 0.39962E+00, 0.40399E+00, 0.40836E+00, 0.41271E+00,&
      0.41705E+00, 0.42139E+00, 0.42572E+00, 0.43003E+00, 0.43435E+00,&
      0.43865E+00, 0.44294E+00, 0.44722E+00, 0.45150E+00, 0.45577E+00,&
      0.46003E+00, 0.46428E+00, 0.46852E+00, 0.47275E+00, 0.47698E+00,&
      0.48119E+00, 0.48540E+00, 0.48960E+00, 0.49379E+00, 0.49797E+00,&
      0.50215E+00, 0.50631E+00, 0.51047E+00, 0.51462E+00, 0.51876E+00/
                             
     DATA (BNC12M (IA),IA=201,300)/                                     &
      0.52289E+00, 0.52702E+00, 0.53113E+00, 0.53524E+00, 0.53934E+00,&
       0.54343E+00, 0.54751E+00, 0.55158E+00, 0.55565E+00, 0.55971E+00,&
      0.56376E+00, 0.56780E+00, 0.57183E+00, 0.57586E+00, 0.57987E+00,&
      0.58388E+00, 0.58788E+00, 0.59187E+00, 0.59586E+00, 0.59984E+00,&
      0.60381E+00, 0.60777E+00, 0.61172E+00, 0.61566E+00, 0.61960E+00,&
      0.62353E+00, 0.62745E+00, 0.63137E+00, 0.63527E+00, 0.63917E+00,&
      0.64306E+00, 0.64695E+00, 0.65082E+00, 0.65469E+00, 0.65855E+00,&
      0.66240E+00, 0.66625E+00, 0.67008E+00, 0.67391E+00, 0.67774E+00,&
      0.68155E+00, 0.68536E+00, 0.68916E+00, 0.69295E+00, 0.69674E+00,&
      0.70051E+00, 0.70428E+00, 0.70805E+00, 0.71180E+00, 0.71555E+00,&
      0.71929E+00, 0.72303E+00, 0.72676E+00, 0.73048E+00, 0.73419E+00,&
      0.73789E+00, 0.74159E+00, 0.74528E+00, 0.74897E+00, 0.75265E+00,&
      0.75632E+00, 0.75998E+00, 0.76364E+00, 0.76729E+00, 0.77093E+00,&
      0.77457E+00, 0.77819E+00, 0.78182E+00, 0.78543E+00, 0.78904E+00,&
      0.79264E+00, 0.79624E+00, 0.79983E+00, 0.80341E+00, 0.80698E+00,&
      0.81055E+00, 0.81411E+00, 0.81767E+00, 0.82122E+00, 0.82476E+00,&
      0.82830E+00, 0.83183E+00, 0.83535E+00, 0.83886E+00, 0.84237E+00,&
      0.84588E+00, 0.84938E+00, 0.85287E+00, 0.85635E+00, 0.85983E+00,&
      0.86330E+00, 0.86676E+00, 0.87022E+00, 0.87368E+00, 0.87712E+00,&
      0.88056E+00, 0.88400E+00, 0.88743E+00, 0.89085E+00, 0.89426E+00/
                             
     DATA (BNC12M (IA),IA=301,400)/                                     &
      0.89767E+00, 0.90108E+00, 0.90447E+00, 0.90787E+00, 0.91125E+00,&
      0.91463E+00, 0.91801E+00, 0.92137E+00, 0.92473E+00, 0.92809E+00,&
      0.93144E+00, 0.93478E+00, 0.93812E+00, 0.94145E+00, 0.94478E+00,&
      0.94810E+00, 0.95142E+00, 0.95473E+00, 0.95803E+00, 0.96133E+00,&
       0.96462E+00, 0.96791E+00, 0.97119E+00, 0.97446E+00, 0.97773E+00,&
      0.98099E+00, 0.98425E+00, 0.98750E+00, 0.99075E+00, 0.99399E+00,&
      0.99723E+00, 0.10005E+01, 0.10037E+01, 0.10069E+01, 0.10101E+01,&
      0.10133E+01, 0.10165E+01, 0.10197E+01, 0.10229E+01, 0.10261E+01,&
      0.10293E+01, 0.10325E+01, 0.10356E+01, 0.10388E+01, 0.10420E+01,&
      0.10451E+01, 0.10483E+01, 0.10514E+01, 0.10546E+01, 0.10577E+01,&
      0.10608E+01, 0.10639E+01, 0.10671E+01, 0.10702E+01, 0.10733E+01,&
      0.10764E+01, 0.10795E+01, 0.10826E+01, 0.10857E+01, 0.10888E+01,&
      0.10918E+01, 0.10949E+01, 0.10980E+01, 0.11010E+01, 0.11041E+01,&
      0.11071E+01, 0.11102E+01, 0.11132E+01, 0.11163E+01, 0.11193E+01,&
      0.11223E+01, 0.11254E+01, 0.11284E+01, 0.11314E+01, 0.11344E+01,&
      0.11374E+01, 0.11404E+01, 0.11434E+01, 0.11464E+01, 0.11494E+01,&
      0.11524E+01, 0.11553E+01, 0.11583E+01, 0.11613E+01, 0.11642E+01,&
      0.11672E+01, 0.11702E+01, 0.11731E+01, 0.11761E+01, 0.11790E+01,&
      0.11819E+01, 0.11849E+01, 0.11878E+01, 0.11907E+01, 0.11936E+01,&
      0.11965E+01, 0.11994E+01, 0.12023E+01, 0.12052E+01, 0.12081E+01/
                             
     DATA (BNC12M (IA),IA=401,500)/                                     &
      0.12110E+01, 0.12139E+01, 0.12168E+01, 0.12197E+01, 0.12225E+01,&
      0.12254E+01, 0.12283E+01, 0.12311E+01, 0.12340E+01, 0.12368E+01,&
      0.12397E+01, 0.12425E+01, 0.12454E+01, 0.12482E+01, 0.12510E+01,&
      0.12539E+01, 0.12567E+01, 0.12595E+01, 0.12623E+01, 0.12651E+01,&
      0.12679E+01, 0.12707E+01, 0.12735E+01, 0.12763E+01, 0.12791E+01,&
      0.12819E+01, 0.12847E+01, 0.12874E+01, 0.12902E+01, 0.12930E+01,&
      0.12957E+01, 0.12985E+01, 0.13013E+01, 0.13040E+01, 0.13068E+01,&
      0.13095E+01, 0.13122E+01, 0.13150E+01, 0.13177E+01, 0.13204E+01,&
      0.13231E+01, 0.13259E+01, 0.13286E+01, 0.13313E+01, 0.13340E+01,&
      0.13367E+01, 0.13394E+01, 0.13421E+01, 0.13448E+01, 0.13475E+01,&
      0.13502E+01, 0.13528E+01, 0.13555E+01, 0.13582E+01, 0.13609E+01,&
      0.13635E+01, 0.13662E+01, 0.13688E+01, 0.13715E+01, 0.13741E+01,&
      0.13768E+01, 0.13794E+01, 0.13821E+01, 0.13847E+01, 0.13873E+01,&
      0.13900E+01, 0.13926E+01, 0.13952E+01, 0.13978E+01, 0.14004E+01,&
      0.14031E+01, 0.14057E+01, 0.14083E+01, 0.14109E+01, 0.14135E+01,&
      0.14160E+01, 0.14186E+01, 0.14212E+01, 0.14238E+01, 0.14264E+01,&
      0.14290E+01, 0.14315E+01, 0.14341E+01, 0.14367E+01, 0.14392E+01,&
      0.14418E+01, 0.14443E+01, 0.14469E+01, 0.14494E+01, 0.14520E+01,&
      0.14545E+01, 0.14570E+01, 0.14596E+01, 0.14621E+01, 0.14646E+01,&
      0.14671E+01, 0.14697E+01, 0.14722E+01, 0.14747E+01, 0.14772E+01/
                             
     DATA (BNC12M (IA),IA=501,600)/                                     &
      0.14797E+01, 0.14822E+01, 0.14847E+01, 0.14872E+01, 0.14897E+01,&
      0.14922E+01, 0.14947E+01, 0.14971E+01, 0.14996E+01, 0.15021E+01,&
      0.15046E+01, 0.15070E+01, 0.15095E+01, 0.15120E+01, 0.15144E+01,&
      0.15169E+01, 0.15193E+01, 0.15218E+01, 0.15242E+01, 0.15267E+01,&
      0.15291E+01, 0.15315E+01, 0.15340E+01, 0.15364E+01, 0.15388E+01,&
      0.15413E+01, 0.15437E+01, 0.15461E+01, 0.15485E+01, 0.15509E+01,&
      0.15533E+01, 0.15557E+01, 0.15581E+01, 0.15605E+01, 0.15629E+01,&
      0.15653E+01, 0.15677E+01, 0.15701E+01, 0.15725E+01, 0.15749E+01,&
      0.15772E+01, 0.15796E+01, 0.15820E+01, 0.15843E+01, 0.15867E+01,&
      0.15891E+01, 0.15914E+01, 0.15938E+01, 0.15961E+01, 0.15985E+01,&
      0.16008E+01, 0.16032E+01, 0.16055E+01, 0.16079E+01, 0.16102E+01,&
      0.16125E+01, 0.16149E+01, 0.16172E+01, 0.16195E+01, 0.16218E+01,&
      0.16242E+01, 0.16265E+01, 0.16288E+01, 0.16311E+01, 0.16334E+01,&
      0.16357E+01, 0.16380E+01, 0.16403E+01, 0.16426E+01, 0.16449E+01,&
      0.16472E+01, 0.16495E+01, 0.16518E+01, 0.16540E+01, 0.16563E+01,&
      0.16586E+01, 0.16609E+01, 0.16631E+01, 0.16654E+01, 0.16677E+01,&
      0.16699E+01, 0.16722E+01, 0.16744E+01, 0.16767E+01, 0.16790E+01,&
      0.16812E+01, 0.16834E+01, 0.16857E+01, 0.16879E+01, 0.16902E+01,&
      0.16924E+01, 0.16946E+01, 0.16969E+01, 0.16991E+01, 0.17013E+01,&
      0.17035E+01, 0.17058E+01, 0.17080E+01, 0.17102E+01, 0.17185E+01/
                             
     DATA (BNC12M (IA),IA=601,700)/                                     &
      0.17365E+01, 0.17582E+01, 0.17797E+01, 0.18009E+01, 0.18218E+01,&
      0.18425E+01, 0.18630E+01, 0.18833E+01, 0.19033E+01, 0.19232E+01,&
      0.19428E+01, 0.19622E+01, 0.19814E+01, 0.20004E+01, 0.20193E+01,&
      0.20379E+01, 0.20563E+01, 0.20746E+01, 0.20927E+01, 0.21106E+01,&
      0.21283E+01, 0.21459E+01, 0.21633E+01, 0.21806E+01, 0.21976E+01,&
      0.22146E+01, 0.22313E+01, 0.22480E+01, 0.22644E+01, 0.22808E+01,&
      0.22969E+01, 0.23130E+01, 0.23289E+01, 0.23447E+01, 0.23603E+01,&
      0.23758E+01, 0.23912E+01, 0.24064E+01, 0.24215E+01, 0.24365E+01,&
      0.24514E+01, 0.24662E+01, 0.24808E+01, 0.24953E+01, 0.25097E+01,&
      0.25240E+01, 0.25382E+01, 0.25523E+01, 0.25663E+01, 0.25802E+01,&
      0.25939E+01, 0.26076E+01, 0.26211E+01, 0.26346E+01, 0.26480E+01,&
      0.26612E+01, 0.26744E+01, 0.26875E+01, 0.27005E+01, 0.27133E+01,&
      0.27262E+01, 0.27389E+01, 0.27515E+01, 0.27640E+01, 0.27765E+01,&
      0.27889E+01, 0.28012E+01, 0.28134E+01, 0.28255E+01, 0.28375E+01,&
      0.28495E+01, 0.28614E+01, 0.28732E+01, 0.28849E+01, 0.28966E+01,&
      0.29082E+01, 0.29197E+01, 0.29312E+01, 0.29425E+01, 0.29538E+01,&
      0.29651E+01, 0.29762E+01, 0.29873E+01, 0.29984E+01, 0.30093E+01,&
      0.30202E+01, 0.30311E+01, 0.30419E+01, 0.30526E+01, 0.30632E+01,&
      0.30738E+01, 0.30843E+01, 0.30948E+01, 0.31052E+01, 0.31155E+01,&
      0.31258E+01, 0.31361E+01, 0.31462E+01, 0.31564E+01, 0.31664E+01/
                             
     DATA (BNC12M(IA),IA=701,741)/                                      &
      0.31764E+01, 0.31864E+01, 0.31963E+01, 0.32061E+01, 0.32159E+01,&
      0.32257E+01, 0.32354E+01, 0.32450E+01, 0.32546E+01, 0.32641E+01,&
      0.32736E+01, 0.32831E+01, 0.32924E+01, 0.33018E+01, 0.33111E+01,&
      0.33203E+01, 0.33295E+01, 0.33387E+01, 0.33478E+01, 0.33569E+01,&
      0.33659E+01, 0.33749E+01, 0.33838E+01, 0.33927E+01, 0.34016E+01,&
      0.34104E+01, 0.34191E+01, 0.34278E+01, 0.34365E+01, 0.34452E+01,&
      0.34538E+01, 0.34623E+01, 0.34708E+01, 0.34793E+01, 0.34878E+01,&
      0.34962E+01, 0.35045E+01, 0.35128E+01, 0.35211E+01, 0.35294E+01,&
      0.35376E+01                  /                      
!                            
!  ** (NH4)3H(SO4)2          
!                            
     DATA (BNC13M (IA),IA=  1,100)/                                     &
     -0.82022E-01,-0.14892E+00,-0.19572E+00,-0.22741E+00,-0.25173E+00,&
     -0.27155E+00,-0.28831E+00,-0.30283E+00,-0.31565E+00,-0.32710E+00,&
     -0.33746E+00,-0.34689E+00,-0.35555E+00,-0.36355E+00,-0.37096E+00,&
     -0.37786E+00,-0.38431E+00,-0.39036E+00,-0.39605E+00,-0.40141E+00,&
     -0.40647E+00,-0.41126E+00,-0.41580E+00,-0.42010E+00,-0.42419E+00,&
     -0.42808E+00,-0.43179E+00,-0.43532E+00,-0.43868E+00,-0.44190E+00,&
     -0.44496E+00,-0.44790E+00,-0.45070E+00,-0.45338E+00,-0.45594E+00,&
     -0.45839E+00,-0.46074E+00,-0.46298E+00,-0.46513E+00,-0.46719E+00,&
     -0.46916E+00,-0.47105E+00,-0.47285E+00,-0.47458E+00,-0.47624E+00,&
     -0.47782E+00,-0.47934E+00,-0.48079E+00,-0.48217E+00,-0.48350E+00,&
     -0.48477E+00,-0.48598E+00,-0.48713E+00,-0.48824E+00,-0.48929E+00,&
     -0.49030E+00,-0.49125E+00,-0.49217E+00,-0.49304E+00,-0.49386E+00,&
     -0.49465E+00,-0.49539E+00,-0.49610E+00,-0.49677E+00,-0.49740E+00,&
     -0.49800E+00,-0.49856E+00,-0.49910E+00,-0.49960E+00,-0.50006E+00,&
     -0.50050E+00,-0.50091E+00,-0.50129E+00,-0.50164E+00,-0.50197E+00,&
     -0.50227E+00,-0.50254E+00,-0.50279E+00,-0.50301E+00,-0.50321E+00,&
     -0.50338E+00,-0.50353E+00,-0.50366E+00,-0.50377E+00,-0.50386E+00,&
     -0.50392E+00,-0.50396E+00,-0.50399E+00,-0.50399E+00,-0.50398E+00,&
     -0.50394E+00,-0.50389E+00,-0.50382E+00,-0.50373E+00,-0.50362E+00,&
     -0.50350E+00,-0.50336E+00,-0.50320E+00,-0.50303E+00,-0.50285E+00/
                             
     DATA (BNC13M (IA),IA=101,200)/                                     &
     -0.50265E+00,-0.50243E+00,-0.50220E+00,-0.50196E+00,-0.50171E+00,&
     -0.50144E+00,-0.50116E+00,-0.50087E+00,-0.50056E+00,-0.50025E+00,&
     -0.49993E+00,-0.49959E+00,-0.49925E+00,-0.49890E+00,-0.49853E+00,&
     -0.49816E+00,-0.49778E+00,-0.49739E+00,-0.49700E+00,-0.49660E+00,&
     -0.49627E+00,-0.49584E+00,-0.49541E+00,-0.49497E+00,-0.49453E+00,&
     -0.49408E+00,-0.49363E+00,-0.49317E+00,-0.49271E+00,-0.49225E+00,&
     -0.49178E+00,-0.49130E+00,-0.49082E+00,-0.49034E+00,-0.48986E+00,&
     -0.48937E+00,-0.48887E+00,-0.48838E+00,-0.48788E+00,-0.48738E+00,&
     -0.48687E+00,-0.48636E+00,-0.48585E+00,-0.48534E+00,-0.48482E+00,&
     -0.48430E+00,-0.48378E+00,-0.48326E+00,-0.48273E+00,-0.48221E+00,&
     -0.48168E+00,-0.48115E+00,-0.48061E+00,-0.48008E+00,-0.47954E+00,&
     -0.47900E+00,-0.47846E+00,-0.47792E+00,-0.47738E+00,-0.47683E+00,&
     -0.47628E+00,-0.47574E+00,-0.47519E+00,-0.47464E+00,-0.47409E+00,&
     -0.47354E+00,-0.47298E+00,-0.47243E+00,-0.47187E+00,-0.47132E+00,&
     -0.47076E+00,-0.47020E+00,-0.46964E+00,-0.46908E+00,-0.46852E+00,&
     -0.46796E+00,-0.46740E+00,-0.46684E+00,-0.46628E+00,-0.46572E+00,&
     -0.46515E+00,-0.46459E+00,-0.46402E+00,-0.46346E+00,-0.46289E+00,&
     -0.46233E+00,-0.46176E+00,-0.46120E+00,-0.46063E+00,-0.46006E+00,&
     -0.45950E+00,-0.45893E+00,-0.45836E+00,-0.45780E+00,-0.45723E+00,&
     -0.45666E+00,-0.45609E+00,-0.45553E+00,-0.45496E+00,-0.45439E+00/
                             
     DATA (BNC13M (IA),IA=201,300)/                                     &
     -0.45382E+00,-0.45325E+00,-0.45269E+00,-0.45212E+00,-0.45155E+00,&
     -0.45098E+00,-0.45041E+00,-0.44985E+00,-0.44928E+00,-0.44871E+00,&
     -0.44814E+00,-0.44758E+00,-0.44701E+00,-0.44644E+00,-0.44588E+00,&
     -0.44531E+00,-0.44474E+00,-0.44418E+00,-0.44361E+00,-0.44305E+00,&
     -0.44248E+00,-0.44192E+00,-0.44135E+00,-0.44079E+00,-0.44022E+00,&
     -0.43966E+00,-0.43909E+00,-0.43853E+00,-0.43797E+00,-0.43740E+00,&
     -0.43684E+00,-0.43628E+00,-0.43572E+00,-0.43515E+00,-0.43459E+00,&
     -0.43403E+00,-0.43347E+00,-0.43291E+00,-0.43235E+00,-0.43179E+00,&
     -0.43123E+00,-0.43067E+00,-0.43012E+00,-0.42956E+00,-0.42900E+00,&
     -0.42844E+00,-0.42789E+00,-0.42733E+00,-0.42678E+00,-0.42622E+00,&
     -0.42567E+00,-0.42511E+00,-0.42456E+00,-0.42400E+00,-0.42345E+00,&
     -0.42290E+00,-0.42234E+00,-0.42179E+00,-0.42124E+00,-0.42069E+00,&
     -0.42014E+00,-0.41959E+00,-0.41904E+00,-0.41849E+00,-0.41794E+00,&
     -0.41740E+00,-0.41685E+00,-0.41630E+00,-0.41575E+00,-0.41521E+00,&
     -0.41466E+00,-0.41412E+00,-0.41357E+00,-0.41303E+00,-0.41249E+00,&
     -0.41194E+00,-0.41140E+00,-0.41086E+00,-0.41032E+00,-0.40977E+00,&
     -0.40923E+00,-0.40869E+00,-0.40815E+00,-0.40762E+00,-0.40708E+00,&
     -0.40654E+00,-0.40600E+00,-0.40547E+00,-0.40493E+00,-0.40439E+00,&
     -0.40386E+00,-0.40332E+00,-0.40279E+00,-0.40225E+00,-0.40172E+00,&
     -0.40119E+00,-0.40066E+00,-0.40013E+00,-0.39959E+00,-0.39906E+00/
                             
     DATA (BNC13M (IA),IA=301,400)/                                     &
     -0.39853E+00,-0.39800E+00,-0.39747E+00,-0.39695E+00,-0.39642E+00,&
     -0.39589E+00,-0.39536E+00,-0.39484E+00,-0.39431E+00,-0.39379E+00,&
     -0.39326E+00,-0.39274E+00,-0.39221E+00,-0.39169E+00,-0.39117E+00,&
     -0.39065E+00,-0.39013E+00,-0.38961E+00,-0.38908E+00,-0.38857E+00,&
     -0.38805E+00,-0.38753E+00,-0.38701E+00,-0.38649E+00,-0.38597E+00,&
     -0.38546E+00,-0.38494E+00,-0.38443E+00,-0.38391E+00,-0.38340E+00,&
     -0.38288E+00,-0.38237E+00,-0.38186E+00,-0.38135E+00,-0.38083E+00,&
     -0.38032E+00,-0.37981E+00,-0.37930E+00,-0.37879E+00,-0.37828E+00,&
     -0.37778E+00,-0.37727E+00,-0.37676E+00,-0.37625E+00,-0.37575E+00,&
     -0.37524E+00,-0.37474E+00,-0.37423E+00,-0.37373E+00,-0.37322E+00,&
     -0.37272E+00,-0.37222E+00,-0.37172E+00,-0.37122E+00,-0.37071E+00,&
     -0.37021E+00,-0.36971E+00,-0.36922E+00,-0.36872E+00,-0.36822E+00,&
     -0.36772E+00,-0.36722E+00,-0.36673E+00,-0.36623E+00,-0.36574E+00,&
     -0.36524E+00,-0.36475E+00,-0.36425E+00,-0.36376E+00,-0.36327E+00,&
     -0.36277E+00,-0.36228E+00,-0.36179E+00,-0.36130E+00,-0.36081E+00,&
     -0.36032E+00,-0.35983E+00,-0.35934E+00,-0.35886E+00,-0.35837E+00,&
     -0.35788E+00,-0.35739E+00,-0.35691E+00,-0.35642E+00,-0.35594E+00,&
     -0.35545E+00,-0.35497E+00,-0.35449E+00,-0.35400E+00,-0.35352E+00,&
     -0.35304E+00,-0.35256E+00,-0.35208E+00,-0.35160E+00,-0.35112E+00,&
     -0.35064E+00,-0.35016E+00,-0.34968E+00,-0.34920E+00,-0.34873E+00/
                             
     DATA (BNC13M (IA),IA=401,500)/                                     &
     -0.34825E+00,-0.34777E+00,-0.34730E+00,-0.34682E+00,-0.34635E+00,&
     -0.34588E+00,-0.34540E+00,-0.34493E+00,-0.34446E+00,-0.34398E+00,&
     -0.34351E+00,-0.34304E+00,-0.34257E+00,-0.34210E+00,-0.34163E+00,&
     -0.34116E+00,-0.34069E+00,-0.34023E+00,-0.33976E+00,-0.33929E+00,&
     -0.33882E+00,-0.33836E+00,-0.33789E+00,-0.33743E+00,-0.33696E+00,&
     -0.33650E+00,-0.33604E+00,-0.33557E+00,-0.33511E+00,-0.33465E+00,&
     -0.33419E+00,-0.33373E+00,-0.33327E+00,-0.33281E+00,-0.33235E+00,&
     -0.33189E+00,-0.33143E+00,-0.33097E+00,-0.33051E+00,-0.33006E+00,&
     -0.32960E+00,-0.32914E+00,-0.32869E+00,-0.32823E+00,-0.32778E+00,&
     -0.32732E+00,-0.32687E+00,-0.32642E+00,-0.32596E+00,-0.32551E+00,&
     -0.32506E+00,-0.32461E+00,-0.32416E+00,-0.32371E+00,-0.32326E+00,&
     -0.32281E+00,-0.32236E+00,-0.32191E+00,-0.32146E+00,-0.32101E+00,&
     -0.32057E+00,-0.32012E+00,-0.31967E+00,-0.31923E+00,-0.31878E+00,&
     -0.31834E+00,-0.31789E+00,-0.31745E+00,-0.31701E+00,-0.31656E+00,&
     -0.31612E+00,-0.31568E+00,-0.31524E+00,-0.31480E+00,-0.31436E+00,&
     -0.31392E+00,-0.31348E+00,-0.31304E+00,-0.31260E+00,-0.31216E+00,&
     -0.31172E+00,-0.31128E+00,-0.31085E+00,-0.31041E+00,-0.30997E+00,&
     -0.30954E+00,-0.30910E+00,-0.30867E+00,-0.30823E+00,-0.30780E+00,&
     -0.30737E+00,-0.30693E+00,-0.30650E+00,-0.30607E+00,-0.30564E+00,&
     -0.30521E+00,-0.30478E+00,-0.30435E+00,-0.30392E+00,-0.30349E+00/
                             
     DATA (BNC13M (IA),IA=501,600)/                                     &
     -0.30306E+00,-0.30263E+00,-0.30220E+00,-0.30177E+00,-0.30135E+00,&
     -0.30092E+00,-0.30049E+00,-0.30007E+00,-0.29964E+00,-0.29922E+00,&
     -0.29879E+00,-0.29837E+00,-0.29794E+00,-0.29752E+00,-0.29710E+00,&
     -0.29668E+00,-0.29625E+00,-0.29583E+00,-0.29541E+00,-0.29499E+00,&
     -0.29457E+00,-0.29415E+00,-0.29373E+00,-0.29331E+00,-0.29289E+00,&
     -0.29248E+00,-0.29206E+00,-0.29164E+00,-0.29122E+00,-0.29081E+00,&
     -0.29039E+00,-0.28997E+00,-0.28956E+00,-0.28914E+00,-0.28873E+00,&
     -0.28832E+00,-0.28790E+00,-0.28749E+00,-0.28708E+00,-0.28666E+00,&
     -0.28625E+00,-0.28584E+00,-0.28543E+00,-0.28502E+00,-0.28461E+00,&
     -0.28420E+00,-0.28379E+00,-0.28338E+00,-0.28297E+00,-0.28256E+00,&
     -0.28216E+00,-0.28175E+00,-0.28134E+00,-0.28093E+00,-0.28053E+00,&
     -0.28012E+00,-0.27972E+00,-0.27931E+00,-0.27891E+00,-0.27850E+00,&
     -0.27810E+00,-0.27770E+00,-0.27729E+00,-0.27689E+00,-0.27649E+00,&
     -0.27609E+00,-0.27568E+00,-0.27528E+00,-0.27488E+00,-0.27448E+00,&
     -0.27408E+00,-0.27368E+00,-0.27328E+00,-0.27288E+00,-0.27249E+00,&
     -0.27209E+00,-0.27169E+00,-0.27129E+00,-0.27090E+00,-0.27050E+00,&
     -0.27010E+00,-0.26971E+00,-0.26931E+00,-0.26892E+00,-0.26852E+00,&
     -0.26813E+00,-0.26774E+00,-0.26734E+00,-0.26695E+00,-0.26656E+00,&
     -0.26616E+00,-0.26577E+00,-0.26538E+00,-0.26499E+00,-0.26460E+00,&
     -0.26421E+00,-0.26382E+00,-0.26343E+00,-0.26304E+00,-0.26158E+00/
                             
     DATA (BNC13M (IA),IA=601,700)/                                     &
     -0.25840E+00,-0.25457E+00,-0.25078E+00,-0.24702E+00,-0.24330E+00,&
     -0.23961E+00,-0.23595E+00,-0.23233E+00,-0.22874E+00,-0.22518E+00,&
     -0.22165E+00,-0.21815E+00,-0.21469E+00,-0.21125E+00,-0.20784E+00,&
     -0.20447E+00,-0.20112E+00,-0.19779E+00,-0.19450E+00,-0.19123E+00,&
     -0.18799E+00,-0.18477E+00,-0.18158E+00,-0.17842E+00,-0.17528E+00,&
     -0.17217E+00,-0.16907E+00,-0.16601E+00,-0.16297E+00,-0.15995E+00,&
     -0.15695E+00,-0.15397E+00,-0.15102E+00,-0.14809E+00,-0.14518E+00,&
     -0.14229E+00,-0.13943E+00,-0.13658E+00,-0.13375E+00,-0.13095E+00,&
     -0.12816E+00,-0.12539E+00,-0.12265E+00,-0.11992E+00,-0.11721E+00,&
     -0.11452E+00,-0.11184E+00,-0.10919E+00,-0.10655E+00,-0.10393E+00,&
     -0.10133E+00,-0.98739E-01,-0.96170E-01,-0.93617E-01,-0.91081E-01,&
     -0.88561E-01,-0.86056E-01,-0.83568E-01,-0.81095E-01,-0.78637E-01,&
     -0.76195E-01,-0.73767E-01,-0.71355E-01,-0.68957E-01,-0.66573E-01,&
     -0.64204E-01,-0.61849E-01,-0.59507E-01,-0.57180E-01,-0.54866E-01,&
     -0.52566E-01,-0.50279E-01,-0.48005E-01,-0.45744E-01,-0.43496E-01,&
     -0.41260E-01,-0.39037E-01,-0.36827E-01,-0.34628E-01,-0.32442E-01,&
     -0.30268E-01,-0.28106E-01,-0.25956E-01,-0.23817E-01,-0.21689E-01,&
     -0.19574E-01,-0.17469E-01,-0.15375E-01,-0.13292E-01,-0.11221E-01,&
     -0.91598E-02,-0.71093E-02,-0.50696E-02,-0.30402E-02,-0.10212E-02,&
      0.98748E-03, 0.29862E-02, 0.49749E-02, 0.69534E-02, 0.89223E-02/
                             
     DATA (BNC13M(IA),IA=701,741)/                                      &
      0.10881E-01, 0.12831E-01, 0.14771E-01, 0.16702E-01, 0.18623E-01,&
      0.20535E-01, 0.22438E-01, 0.24331E-01, 0.26216E-01, 0.28092E-01,&
      0.29959E-01, 0.31817E-01, 0.33667E-01, 0.35508E-01, 0.37340E-01,&
      0.39165E-01, 0.40981E-01, 0.42788E-01, 0.44588E-01, 0.46379E-01,&
      0.48162E-01, 0.49937E-01, 0.51705E-01, 0.53464E-01, 0.55216E-01,&
      0.56961E-01, 0.58697E-01, 0.60426E-01, 0.62148E-01, 0.63862E-01,&
      0.65569E-01, 0.67268E-01, 0.68960E-01, 0.70645E-01, 0.72323E-01,&
      0.73994E-01, 0.75658E-01, 0.77315E-01, 0.78966E-01, 0.80609E-01,&
      0.82246E-01                  /                      
!     END                     
                             
!  ** TEMP = 323.0           
                             
!     BLOCK DATA KMCF323      
!                            
!  ** Common block definition
!                            
!     COMMON /KMC323/                                                  &         
!     BNC01M(  741),BNC02M(  741),BNC03M(  741),BNC04M(  741),         &
!     BNC05M(  741),BNC06M(  741),BNC07M(  741),BNC08M(  741),         &
!     BNC09M(  741),BNC10M(  741),BNC11M(  741),BNC12M(  741),         &
!     BNC13M(  741)           
!                            
!  ** NaCl                   
!                            
     DATA (BNC01M (IA),IA=  1,100)/                                     &
     -0.48816E-01,-0.86364E-01,-0.11089E+00,-0.12640E+00,-0.13753E+00,&
     -0.14603E+00,-0.15274E+00,-0.15816E+00,-0.16259E+00,-0.16624E+00,&
     -0.16927E+00,-0.17179E+00,-0.17387E+00,-0.17559E+00,-0.17699E+00,&
     -0.17812E+00,-0.17901E+00,-0.17968E+00,-0.18017E+00,-0.18049E+00,&
     -0.18066E+00,-0.18070E+00,-0.18061E+00,-0.18042E+00,-0.18013E+00,&
     -0.17974E+00,-0.17927E+00,-0.17873E+00,-0.17812E+00,-0.17744E+00,&
     -0.17671E+00,-0.17593E+00,-0.17509E+00,-0.17421E+00,-0.17329E+00,&
     -0.17233E+00,-0.17134E+00,-0.17031E+00,-0.16926E+00,-0.16817E+00,&
     -0.16707E+00,-0.16594E+00,-0.16479E+00,-0.16362E+00,-0.16243E+00,&
     -0.16122E+00,-0.16000E+00,-0.15877E+00,-0.15752E+00,-0.15626E+00,&
     -0.15499E+00,-0.15371E+00,-0.15242E+00,-0.15112E+00,-0.14981E+00,&
     -0.14849E+00,-0.14716E+00,-0.14583E+00,-0.14448E+00,-0.14313E+00,&
     -0.14177E+00,-0.14041E+00,-0.13904E+00,-0.13766E+00,-0.13627E+00,&
     -0.13487E+00,-0.13347E+00,-0.13206E+00,-0.13063E+00,-0.12920E+00,&
     -0.12777E+00,-0.12632E+00,-0.12486E+00,-0.12340E+00,-0.12192E+00,&
     -0.12043E+00,-0.11893E+00,-0.11743E+00,-0.11591E+00,-0.11438E+00,&
     -0.11283E+00,-0.11128E+00,-0.10972E+00,-0.10814E+00,-0.10655E+00,&
     -0.10495E+00,-0.10333E+00,-0.10171E+00,-0.10007E+00,-0.98421E-01,&
     -0.96759E-01,-0.95085E-01,-0.93399E-01,-0.91702E-01,-0.89993E-01,&
     -0.88272E-01,-0.86541E-01,-0.84798E-01,-0.83045E-01,-0.81282E-01/
                             
     DATA (BNC01M (IA),IA=101,200)/                                     &
     -0.79509E-01,-0.77726E-01,-0.75934E-01,-0.74133E-01,-0.72323E-01,&
     -0.70506E-01,-0.68680E-01,-0.66847E-01,-0.65007E-01,-0.63160E-01,&
     -0.61307E-01,-0.59447E-01,-0.57583E-01,-0.55713E-01,-0.53838E-01,&
     -0.51958E-01,-0.50075E-01,-0.48187E-01,-0.46296E-01,-0.44402E-01,&
     -0.42697E-01,-0.40775E-01,-0.38852E-01,-0.36930E-01,-0.35007E-01,&
     -0.33085E-01,-0.31163E-01,-0.29240E-01,-0.27318E-01,-0.25397E-01,&
     -0.23475E-01,-0.21554E-01,-0.19634E-01,-0.17714E-01,-0.15794E-01,&
     -0.13875E-01,-0.11957E-01,-0.10039E-01,-0.81222E-02,-0.62060E-02,&
     -0.42906E-02,-0.23761E-02,-0.46246E-03, 0.14502E-02, 0.33620E-02,&
      0.52727E-02, 0.71824E-02, 0.90910E-02, 0.10999E-01, 0.12905E-01,&
      0.14810E-01, 0.16714E-01, 0.18617E-01, 0.20518E-01, 0.22419E-01,&
      0.24317E-01, 0.26215E-01, 0.28111E-01, 0.30006E-01, 0.31899E-01,&
      0.33791E-01, 0.35682E-01, 0.37571E-01, 0.39458E-01, 0.41344E-01,&
      0.43228E-01, 0.45111E-01, 0.46992E-01, 0.48871E-01, 0.50749E-01,&
      0.52625E-01, 0.54500E-01, 0.56373E-01, 0.58244E-01, 0.60113E-01,&
      0.61981E-01, 0.63847E-01, 0.65711E-01, 0.67573E-01, 0.69434E-01,&
      0.71292E-01, 0.73149E-01, 0.75004E-01, 0.76857E-01, 0.78709E-01,&
      0.80558E-01, 0.82406E-01, 0.84251E-01, 0.86095E-01, 0.87937E-01,&
      0.89776E-01, 0.91614E-01, 0.93450E-01, 0.95284E-01, 0.97116E-01,&
      0.98946E-01, 0.10077E+00, 0.10260E+00, 0.10442E+00, 0.10625E+00/
                             
     DATA (BNC01M (IA),IA=201,300)/                                     &
      0.10807E+00, 0.10988E+00, 0.11170E+00, 0.11351E+00, 0.11533E+00,&
      0.11714E+00, 0.11894E+00, 0.12075E+00, 0.12255E+00, 0.12435E+00,&
      0.12615E+00, 0.12795E+00, 0.12975E+00, 0.13154E+00, 0.13333E+00,&
      0.13512E+00, 0.13691E+00, 0.13869E+00, 0.14047E+00, 0.14226E+00,&
      0.14403E+00, 0.14581E+00, 0.14758E+00, 0.14936E+00, 0.15113E+00,&
      0.15289E+00, 0.15466E+00, 0.15642E+00, 0.15818E+00, 0.15994E+00,&
      0.16170E+00, 0.16346E+00, 0.16521E+00, 0.16696E+00, 0.16871E+00,&
      0.17045E+00, 0.17220E+00, 0.17394E+00, 0.17568E+00, 0.17742E+00,&
      0.17915E+00, 0.18089E+00, 0.18262E+00, 0.18435E+00, 0.18608E+00,&
      0.18780E+00, 0.18952E+00, 0.19124E+00, 0.19296E+00, 0.19468E+00,&
      0.19639E+00, 0.19811E+00, 0.19982E+00, 0.20152E+00, 0.20323E+00,&
      0.20493E+00, 0.20663E+00, 0.20833E+00, 0.21003E+00, 0.21172E+00,&
      0.21342E+00, 0.21511E+00, 0.21680E+00, 0.21848E+00, 0.22017E+00,&
      0.22185E+00, 0.22353E+00, 0.22521E+00, 0.22688E+00, 0.22856E+00,&
      0.23023E+00, 0.23190E+00, 0.23356E+00, 0.23523E+00, 0.23689E+00,&
      0.23855E+00, 0.24021E+00, 0.24187E+00, 0.24352E+00, 0.24518E+00,&
      0.24683E+00, 0.24847E+00, 0.25012E+00, 0.25176E+00, 0.25341E+00,&
      0.25505E+00, 0.25668E+00, 0.25832E+00, 0.25995E+00, 0.26158E+00,&
      0.26321E+00, 0.26484E+00, 0.26647E+00, 0.26809E+00, 0.26971E+00,&
      0.27133E+00, 0.27295E+00, 0.27456E+00, 0.27618E+00, 0.27779E+00/
                             
     DATA (BNC01M (IA),IA=301,400)/                                     &
      0.27940E+00, 0.28100E+00, 0.28261E+00, 0.28421E+00, 0.28581E+00,&
      0.28741E+00, 0.28901E+00, 0.29060E+00, 0.29219E+00, 0.29378E+00,&
      0.29537E+00, 0.29696E+00, 0.29854E+00, 0.30012E+00, 0.30171E+00,&
      0.30328E+00, 0.30486E+00, 0.30643E+00, 0.30801E+00, 0.30958E+00,&
      0.31115E+00, 0.31271E+00, 0.31428E+00, 0.31584E+00, 0.31740E+00,&
      0.31896E+00, 0.32052E+00, 0.32207E+00, 0.32362E+00, 0.32517E+00,&
      0.32672E+00, 0.32827E+00, 0.32982E+00, 0.33136E+00, 0.33290E+00,&
      0.33444E+00, 0.33598E+00, 0.33751E+00, 0.33904E+00, 0.34058E+00,&
      0.34211E+00, 0.34363E+00, 0.34516E+00, 0.34668E+00, 0.34820E+00,&
      0.34972E+00, 0.35124E+00, 0.35276E+00, 0.35427E+00, 0.35579E+00,&
      0.35730E+00, 0.35881E+00, 0.36031E+00, 0.36182E+00, 0.36332E+00,&
      0.36482E+00, 0.36632E+00, 0.36782E+00, 0.36931E+00, 0.37081E+00,&
      0.37230E+00, 0.37379E+00, 0.37528E+00, 0.37677E+00, 0.37825E+00,&
      0.37973E+00, 0.38121E+00, 0.38269E+00, 0.38417E+00, 0.38565E+00,&
      0.38712E+00, 0.38859E+00, 0.39006E+00, 0.39153E+00, 0.39300E+00,&
      0.39446E+00, 0.39593E+00, 0.39739E+00, 0.39885E+00, 0.40030E+00,&
      0.40176E+00, 0.40321E+00, 0.40467E+00, 0.40612E+00, 0.40757E+00,&
      0.40901E+00, 0.41046E+00, 0.41190E+00, 0.41334E+00, 0.41478E+00,&
      0.41622E+00, 0.41766E+00, 0.41909E+00, 0.42053E+00, 0.42196E+00,&
      0.42339E+00, 0.42482E+00, 0.42624E+00, 0.42767E+00, 0.42909E+00/
                             
     DATA (BNC01M (IA),IA=401,500)/                                     &
      0.43051E+00, 0.43193E+00, 0.43335E+00, 0.43477E+00, 0.43618E+00,&
      0.43759E+00, 0.43901E+00, 0.44042E+00, 0.44182E+00, 0.44323E+00,&
      0.44463E+00, 0.44604E+00, 0.44744E+00, 0.44884E+00, 0.45024E+00,&
      0.45163E+00, 0.45303E+00, 0.45442E+00, 0.45581E+00, 0.45720E+00,&
      0.45859E+00, 0.45998E+00, 0.46136E+00, 0.46274E+00, 0.46413E+00,&
      0.46551E+00, 0.46689E+00, 0.46826E+00, 0.46964E+00, 0.47101E+00,&
      0.47238E+00, 0.47375E+00, 0.47512E+00, 0.47649E+00, 0.47786E+00,&
      0.47922E+00, 0.48058E+00, 0.48194E+00, 0.48330E+00, 0.48466E+00,&
      0.48602E+00, 0.48737E+00, 0.48873E+00, 0.49008E+00, 0.49143E+00,&
      0.49278E+00, 0.49412E+00, 0.49547E+00, 0.49681E+00, 0.49816E+00,&
      0.49950E+00, 0.50084E+00, 0.50217E+00, 0.50351E+00, 0.50485E+00,&
      0.50618E+00, 0.50751E+00, 0.50884E+00, 0.51017E+00, 0.51150E+00,&
      0.51282E+00, 0.51415E+00, 0.51547E+00, 0.51679E+00, 0.51811E+00,&
      0.51943E+00, 0.52075E+00, 0.52206E+00, 0.52338E+00, 0.52469E+00,&
      0.52600E+00, 0.52731E+00, 0.52862E+00, 0.52993E+00, 0.53123E+00,&
      0.53254E+00, 0.53384E+00, 0.53514E+00, 0.53644E+00, 0.53774E+00,&
      0.53904E+00, 0.54033E+00, 0.54162E+00, 0.54292E+00, 0.54421E+00,&
      0.54550E+00, 0.54679E+00, 0.54807E+00, 0.54936E+00, 0.55064E+00,&
      0.55193E+00, 0.55321E+00, 0.55449E+00, 0.55577E+00, 0.55704E+00,&
      0.55832E+00, 0.55959E+00, 0.56087E+00, 0.56214E+00, 0.56341E+00/
                             
     DATA (BNC01M (IA),IA=501,600)/                                     &
      0.56468E+00, 0.56594E+00, 0.56721E+00, 0.56848E+00, 0.56974E+00,&
      0.57100E+00, 0.57226E+00, 0.57352E+00, 0.57478E+00, 0.57604E+00,&
      0.57729E+00, 0.57855E+00, 0.57980E+00, 0.58105E+00, 0.58230E+00,&
      0.58355E+00, 0.58480E+00, 0.58604E+00, 0.58729E+00, 0.58853E+00,&
      0.58977E+00, 0.59101E+00, 0.59225E+00, 0.59349E+00, 0.59473E+00,&
      0.59596E+00, 0.59720E+00, 0.59843E+00, 0.59966E+00, 0.60089E+00,&
      0.60212E+00, 0.60335E+00, 0.60458E+00, 0.60580E+00, 0.60703E+00,&
      0.60825E+00, 0.60947E+00, 0.61069E+00, 0.61191E+00, 0.61313E+00,&
      0.61435E+00, 0.61556E+00, 0.61678E+00, 0.61799E+00, 0.61920E+00,&
      0.62041E+00, 0.62162E+00, 0.62283E+00, 0.62403E+00, 0.62524E+00,&
      0.62644E+00, 0.62765E+00, 0.62885E+00, 0.63005E+00, 0.63125E+00,&
      0.63245E+00, 0.63364E+00, 0.63484E+00, 0.63603E+00, 0.63723E+00,&
      0.63842E+00, 0.63961E+00, 0.64080E+00, 0.64199E+00, 0.64318E+00,&
      0.64436E+00, 0.64555E+00, 0.64673E+00, 0.64791E+00, 0.64909E+00,&
      0.65027E+00, 0.65145E+00, 0.65263E+00, 0.65381E+00, 0.65498E+00,&
      0.65616E+00, 0.65733E+00, 0.65850E+00, 0.65967E+00, 0.66084E+00,&
      0.66201E+00, 0.66318E+00, 0.66435E+00, 0.66551E+00, 0.66667E+00,&
      0.66784E+00, 0.66900E+00, 0.67016E+00, 0.67132E+00, 0.67248E+00,&
      0.67363E+00, 0.67479E+00, 0.67595E+00, 0.67710E+00, 0.67825E+00,&
      0.67940E+00, 0.68055E+00, 0.68170E+00, 0.68285E+00, 0.68715E+00/
                             
     DATA (BNC01M (IA),IA=601,700)/                                     &
      0.69654E+00, 0.70783E+00, 0.71902E+00, 0.73010E+00, 0.74108E+00,&
      0.75196E+00, 0.76274E+00, 0.77342E+00, 0.78402E+00, 0.79451E+00,&
      0.80492E+00, 0.81524E+00, 0.82547E+00, 0.83562E+00, 0.84568E+00,&
      0.85566E+00, 0.86556E+00, 0.87538E+00, 0.88512E+00, 0.89478E+00,&
      0.90437E+00, 0.91389E+00, 0.92333E+00, 0.93270E+00, 0.94200E+00,&
      0.95123E+00, 0.96040E+00, 0.96949E+00, 0.97852E+00, 0.98749E+00,&
      0.99639E+00, 0.10052E+01, 0.10140E+01, 0.10227E+01, 0.10314E+01,&
      0.10400E+01, 0.10485E+01, 0.10570E+01, 0.10654E+01, 0.10738E+01,&
      0.10821E+01, 0.10904E+01, 0.10986E+01, 0.11068E+01, 0.11149E+01,&
      0.11230E+01, 0.11310E+01, 0.11389E+01, 0.11469E+01, 0.11547E+01,&
      0.11625E+01, 0.11703E+01, 0.11780E+01, 0.11857E+01, 0.11934E+01,&
      0.12010E+01, 0.12085E+01, 0.12160E+01, 0.12235E+01, 0.12309E+01,&
      0.12383E+01, 0.12457E+01, 0.12530E+01, 0.12602E+01, 0.12675E+01,&
      0.12747E+01, 0.12818E+01, 0.12889E+01, 0.12960E+01, 0.13031E+01,&
      0.13101E+01, 0.13170E+01, 0.13240E+01, 0.13309E+01, 0.13378E+01,&
      0.13446E+01, 0.13514E+01, 0.13582E+01, 0.13649E+01, 0.13716E+01,&
      0.13783E+01, 0.13849E+01, 0.13915E+01, 0.13981E+01, 0.14047E+01,&
      0.14112E+01, 0.14177E+01, 0.14241E+01, 0.14306E+01, 0.14370E+01,&
      0.14434E+01, 0.14497E+01, 0.14560E+01, 0.14623E+01, 0.14686E+01,&
      0.14748E+01, 0.14810E+01, 0.14872E+01, 0.14934E+01, 0.14995E+01/
                             
     DATA (BNC01M(IA),IA=701,741)/                                      &
      0.15056E+01, 0.15117E+01, 0.15178E+01, 0.15238E+01, 0.15298E+01,&
      0.15358E+01, 0.15418E+01, 0.15477E+01, 0.15536E+01, 0.15595E+01,&
      0.15654E+01, 0.15713E+01, 0.15771E+01, 0.15829E+01, 0.15887E+01,&
      0.15944E+01, 0.16002E+01, 0.16059E+01, 0.16116E+01, 0.16173E+01,&
      0.16229E+01, 0.16286E+01, 0.16342E+01, 0.16398E+01, 0.16453E+01,&
      0.16509E+01, 0.16564E+01, 0.16620E+01, 0.16675E+01, 0.16729E+01,&
      0.16784E+01, 0.16838E+01, 0.16893E+01, 0.16947E+01, 0.17000E+01,&
      0.17054E+01, 0.17108E+01, 0.17161E+01, 0.17214E+01, 0.17267E+01,&
      0.17320E+01                 /                      
!                            
!  ** Na2SO4                 
!                            
     DATA (BNC02M (IA),IA=  1,100)/                                     &
     -0.10024E+00,-0.18230E+00,-0.23981E+00,-0.27879E+00,-0.30871E+00,&
     -0.33311E+00,-0.35376E+00,-0.37167E+00,-0.38749E+00,-0.40165E+00,&
     -0.41447E+00,-0.42617E+00,-0.43693E+00,-0.44690E+00,-0.45616E+00,&
     -0.46482E+00,-0.47294E+00,-0.48058E+00,-0.48780E+00,-0.49464E+00,&
     -0.50113E+00,-0.50730E+00,-0.51318E+00,-0.51880E+00,-0.52418E+00,&
     -0.52933E+00,-0.53428E+00,-0.53903E+00,-0.54360E+00,-0.54800E+00,&
     -0.55224E+00,-0.55634E+00,-0.56030E+00,-0.56412E+00,-0.56783E+00,&
     -0.57141E+00,-0.57489E+00,-0.57826E+00,-0.58153E+00,-0.58471E+00,&
     -0.58779E+00,-0.59080E+00,-0.59371E+00,-0.59655E+00,-0.59932E+00,&
     -0.60201E+00,-0.60464E+00,-0.60720E+00,-0.60969E+00,-0.61213E+00,&
     -0.61451E+00,-0.61683E+00,-0.61910E+00,-0.62131E+00,-0.62348E+00,&
     -0.62560E+00,-0.62767E+00,-0.62970E+00,-0.63168E+00,-0.63362E+00,&
     -0.63553E+00,-0.63739E+00,-0.63922E+00,-0.64101E+00,-0.64276E+00,&
     -0.64449E+00,-0.64618E+00,-0.64784E+00,-0.64946E+00,-0.65106E+00,&
     -0.65263E+00,-0.65417E+00,-0.65569E+00,-0.65718E+00,-0.65865E+00,&
     -0.66009E+00,-0.66150E+00,-0.66290E+00,-0.66427E+00,-0.66562E+00,&
     -0.66695E+00,-0.66826E+00,-0.66956E+00,-0.67083E+00,-0.67208E+00,&
     -0.67332E+00,-0.67454E+00,-0.67574E+00,-0.67692E+00,-0.67809E+00,&
     -0.67924E+00,-0.68038E+00,-0.68150E+00,-0.68261E+00,-0.68371E+00,&
     -0.68479E+00,-0.68585E+00,-0.68691E+00,-0.68795E+00,-0.68897E+00/
                             
     DATA (BNC02M (IA),IA=101,200)/                                     &
     -0.68999E+00,-0.69099E+00,-0.69198E+00,-0.69296E+00,-0.69393E+00,&
     -0.69488E+00,-0.69582E+00,-0.69676E+00,-0.69768E+00,-0.69859E+00,&
     -0.69949E+00,-0.70038E+00,-0.70126E+00,-0.70213E+00,-0.70299E+00,&
     -0.70384E+00,-0.70468E+00,-0.70551E+00,-0.70633E+00,-0.70715E+00,&
     -0.70792E+00,-0.70871E+00,-0.70950E+00,-0.71028E+00,-0.71105E+00,&
     -0.71181E+00,-0.71257E+00,-0.71331E+00,-0.71405E+00,-0.71477E+00,&
     -0.71549E+00,-0.71620E+00,-0.71691E+00,-0.71760E+00,-0.71829E+00,&
     -0.71897E+00,-0.71964E+00,-0.72031E+00,-0.72097E+00,-0.72162E+00,&
     -0.72226E+00,-0.72290E+00,-0.72353E+00,-0.72415E+00,-0.72477E+00,&
     -0.72538E+00,-0.72598E+00,-0.72658E+00,-0.72717E+00,-0.72775E+00,&
     -0.72833E+00,-0.72890E+00,-0.72947E+00,-0.73003E+00,-0.73058E+00,&
     -0.73113E+00,-0.73168E+00,-0.73221E+00,-0.73274E+00,-0.73327E+00,&
     -0.73379E+00,-0.73431E+00,-0.73482E+00,-0.73532E+00,-0.73582E+00,&
     -0.73632E+00,-0.73681E+00,-0.73729E+00,-0.73778E+00,-0.73825E+00,&
     -0.73872E+00,-0.73919E+00,-0.73965E+00,-0.74011E+00,-0.74056E+00,&
     -0.74100E+00,-0.74145E+00,-0.74189E+00,-0.74232E+00,-0.74275E+00,&
     -0.74318E+00,-0.74360E+00,-0.74402E+00,-0.74443E+00,-0.74484E+00,&
     -0.74524E+00,-0.74564E+00,-0.74604E+00,-0.74644E+00,-0.74683E+00,&
     -0.74721E+00,-0.74759E+00,-0.74797E+00,-0.74835E+00,-0.74872E+00,&
     -0.74908E+00,-0.74945E+00,-0.74981E+00,-0.75016E+00,-0.75052E+00/
                             
     DATA (BNC02M (IA),IA=201,300)/                                     &
     -0.75087E+00,-0.75121E+00,-0.75155E+00,-0.75189E+00,-0.75223E+00,&
     -0.75256E+00,-0.75289E+00,-0.75322E+00,-0.75354E+00,-0.75386E+00,&
     -0.75418E+00,-0.75449E+00,-0.75480E+00,-0.75511E+00,-0.75542E+00,&
     -0.75572E+00,-0.75602E+00,-0.75631E+00,-0.75661E+00,-0.75690E+00,&
     -0.75718E+00,-0.75747E+00,-0.75775E+00,-0.75803E+00,-0.75830E+00,&
     -0.75858E+00,-0.75885E+00,-0.75912E+00,-0.75938E+00,-0.75964E+00,&
     -0.75990E+00,-0.76016E+00,-0.76042E+00,-0.76067E+00,-0.76092E+00,&
     -0.76117E+00,-0.76141E+00,-0.76165E+00,-0.76189E+00,-0.76213E+00,&
     -0.76237E+00,-0.76260E+00,-0.76283E+00,-0.76306E+00,-0.76328E+00,&
     -0.76351E+00,-0.76373E+00,-0.76395E+00,-0.76417E+00,-0.76438E+00,&
     -0.76459E+00,-0.76480E+00,-0.76501E+00,-0.76522E+00,-0.76542E+00,&
     -0.76562E+00,-0.76582E+00,-0.76602E+00,-0.76621E+00,-0.76641E+00,&
     -0.76660E+00,-0.76679E+00,-0.76698E+00,-0.76716E+00,-0.76734E+00,&
     -0.76753E+00,-0.76770E+00,-0.76788E+00,-0.76806E+00,-0.76823E+00,&
     -0.76840E+00,-0.76857E+00,-0.76874E+00,-0.76891E+00,-0.76907E+00,&
     -0.76923E+00,-0.76940E+00,-0.76955E+00,-0.76971E+00,-0.76987E+00,&
     -0.77002E+00,-0.77017E+00,-0.77032E+00,-0.77047E+00,-0.77062E+00,&
     -0.77076E+00,-0.77091E+00,-0.77105E+00,-0.77119E+00,-0.77133E+00,&
     -0.77146E+00,-0.77160E+00,-0.77173E+00,-0.77186E+00,-0.77199E+00,&
     -0.77212E+00,-0.77225E+00,-0.77238E+00,-0.77250E+00,-0.77262E+00/
                             
     DATA (BNC02M (IA),IA=301,400)/                                     &
     -0.77274E+00,-0.77286E+00,-0.77298E+00,-0.77310E+00,-0.77321E+00,&
     -0.77333E+00,-0.77344E+00,-0.77355E+00,-0.77366E+00,-0.77377E+00,&
     -0.77387E+00,-0.77398E+00,-0.77408E+00,-0.77418E+00,-0.77428E+00,&
     -0.77438E+00,-0.77448E+00,-0.77458E+00,-0.77467E+00,-0.77477E+00,&
     -0.77486E+00,-0.77495E+00,-0.77504E+00,-0.77513E+00,-0.77522E+00,&
     -0.77530E+00,-0.77539E+00,-0.77547E+00,-0.77555E+00,-0.77563E+00,&
     -0.77571E+00,-0.77579E+00,-0.77587E+00,-0.77595E+00,-0.77602E+00,&
     -0.77609E+00,-0.77617E+00,-0.77624E+00,-0.77631E+00,-0.77638E+00,&
     -0.77644E+00,-0.77651E+00,-0.77657E+00,-0.77664E+00,-0.77670E+00,&
     -0.77676E+00,-0.77682E+00,-0.77688E+00,-0.77694E+00,-0.77700E+00,&
     -0.77705E+00,-0.77711E+00,-0.77716E+00,-0.77722E+00,-0.77727E+00,&
     -0.77732E+00,-0.77737E+00,-0.77742E+00,-0.77746E+00,-0.77751E+00,&
     -0.77755E+00,-0.77760E+00,-0.77764E+00,-0.77768E+00,-0.77772E+00,&
     -0.77776E+00,-0.77780E+00,-0.77784E+00,-0.77788E+00,-0.77791E+00,&
     -0.77795E+00,-0.77798E+00,-0.77802E+00,-0.77805E+00,-0.77808E+00,&
     -0.77811E+00,-0.77814E+00,-0.77817E+00,-0.77819E+00,-0.77822E+00,&
     -0.77825E+00,-0.77827E+00,-0.77829E+00,-0.77832E+00,-0.77834E+00,&
     -0.77836E+00,-0.77838E+00,-0.77840E+00,-0.77841E+00,-0.77843E+00,&
     -0.77845E+00,-0.77846E+00,-0.77848E+00,-0.77849E+00,-0.77850E+00,&
     -0.77851E+00,-0.77852E+00,-0.77853E+00,-0.77854E+00,-0.77855E+00/
                             
     DATA (BNC02M (IA),IA=401,500)/                                     &
     -0.77856E+00,-0.77857E+00,-0.77857E+00,-0.77858E+00,-0.77858E+00,&
     -0.77858E+00,-0.77859E+00,-0.77859E+00,-0.77859E+00,-0.77859E+00,&
     -0.77859E+00,-0.77859E+00,-0.77858E+00,-0.77858E+00,-0.77858E+00,&
     -0.77857E+00,-0.77856E+00,-0.77856E+00,-0.77855E+00,-0.77854E+00,&
     -0.77853E+00,-0.77852E+00,-0.77851E+00,-0.77850E+00,-0.77849E+00,&
     -0.77848E+00,-0.77847E+00,-0.77845E+00,-0.77844E+00,-0.77842E+00,&
     -0.77840E+00,-0.77839E+00,-0.77837E+00,-0.77835E+00,-0.77833E+00,&
     -0.77831E+00,-0.77829E+00,-0.77827E+00,-0.77825E+00,-0.77823E+00,&
     -0.77820E+00,-0.77818E+00,-0.77815E+00,-0.77813E+00,-0.77810E+00,&
     -0.77807E+00,-0.77805E+00,-0.77802E+00,-0.77799E+00,-0.77796E+00,&
     -0.77793E+00,-0.77790E+00,-0.77787E+00,-0.77784E+00,-0.77780E+00,&
     -0.77777E+00,-0.77773E+00,-0.77770E+00,-0.77766E+00,-0.77763E+00,&
     -0.77759E+00,-0.77755E+00,-0.77752E+00,-0.77748E+00,-0.77744E+00,&
     -0.77740E+00,-0.77736E+00,-0.77732E+00,-0.77727E+00,-0.77723E+00,&
     -0.77719E+00,-0.77714E+00,-0.77710E+00,-0.77706E+00,-0.77701E+00,&
     -0.77696E+00,-0.77692E+00,-0.77687E+00,-0.77682E+00,-0.77677E+00,&
     -0.77672E+00,-0.77668E+00,-0.77663E+00,-0.77657E+00,-0.77652E+00,&
     -0.77647E+00,-0.77642E+00,-0.77637E+00,-0.77631E+00,-0.77626E+00,&
     -0.77620E+00,-0.77615E+00,-0.77609E+00,-0.77604E+00,-0.77598E+00,&
     -0.77592E+00,-0.77586E+00,-0.77580E+00,-0.77575E+00,-0.77569E+00/
                             
     DATA (BNC02M (IA),IA=501,600)/                                     &
     -0.77563E+00,-0.77556E+00,-0.77550E+00,-0.77544E+00,-0.77538E+00,&
     -0.77532E+00,-0.77525E+00,-0.77519E+00,-0.77512E+00,-0.77506E+00,&
     -0.77499E+00,-0.77493E+00,-0.77486E+00,-0.77479E+00,-0.77473E+00,&
     -0.77466E+00,-0.77459E+00,-0.77452E+00,-0.77445E+00,-0.77438E+00,&
     -0.77431E+00,-0.77424E+00,-0.77417E+00,-0.77410E+00,-0.77402E+00,&
     -0.77395E+00,-0.77388E+00,-0.77380E+00,-0.77373E+00,-0.77365E+00,&
     -0.77358E+00,-0.77350E+00,-0.77343E+00,-0.77335E+00,-0.77327E+00,&
     -0.77319E+00,-0.77312E+00,-0.77304E+00,-0.77296E+00,-0.77288E+00,&
     -0.77280E+00,-0.77272E+00,-0.77264E+00,-0.77256E+00,-0.77247E+00,&
     -0.77239E+00,-0.77231E+00,-0.77223E+00,-0.77214E+00,-0.77206E+00,&
     -0.77197E+00,-0.77189E+00,-0.77180E+00,-0.77172E+00,-0.77163E+00,&
     -0.77154E+00,-0.77146E+00,-0.77137E+00,-0.77128E+00,-0.77119E+00,&
     -0.77110E+00,-0.77102E+00,-0.77093E+00,-0.77084E+00,-0.77074E+00,&
     -0.77065E+00,-0.77056E+00,-0.77047E+00,-0.77038E+00,-0.77029E+00,&
     -0.77019E+00,-0.77010E+00,-0.77001E+00,-0.76991E+00,-0.76982E+00,&
     -0.76972E+00,-0.76963E+00,-0.76953E+00,-0.76943E+00,-0.76934E+00,&
     -0.76924E+00,-0.76914E+00,-0.76904E+00,-0.76895E+00,-0.76885E+00,&
     -0.76875E+00,-0.76865E+00,-0.76855E+00,-0.76845E+00,-0.76835E+00,&
     -0.76825E+00,-0.76815E+00,-0.76804E+00,-0.76794E+00,-0.76784E+00,&
     -0.76774E+00,-0.76763E+00,-0.76753E+00,-0.76743E+00,-0.76703E+00/
                             
     DATA (BNC02M (IA),IA=601,700)/                                     &
     -0.76615E+00,-0.76505E+00,-0.76391E+00,-0.76274E+00,-0.76154E+00,&
     -0.76031E+00,-0.75905E+00,-0.75775E+00,-0.75643E+00,-0.75509E+00,&
     -0.75371E+00,-0.75231E+00,-0.75089E+00,-0.74944E+00,-0.74797E+00,&
     -0.74647E+00,-0.74496E+00,-0.74342E+00,-0.74186E+00,-0.74028E+00,&
     -0.73868E+00,-0.73706E+00,-0.73542E+00,-0.73376E+00,-0.73209E+00,&
     -0.73040E+00,-0.72869E+00,-0.72696E+00,-0.72522E+00,-0.72346E+00,&
     -0.72169E+00,-0.71990E+00,-0.71810E+00,-0.71628E+00,-0.71445E+00,&
     -0.71261E+00,-0.71075E+00,-0.70888E+00,-0.70699E+00,-0.70510E+00,&
     -0.70319E+00,-0.70127E+00,-0.69934E+00,-0.69739E+00,-0.69544E+00,&
     -0.69347E+00,-0.69150E+00,-0.68951E+00,-0.68751E+00,-0.68551E+00,&
     -0.68349E+00,-0.68146E+00,-0.67943E+00,-0.67738E+00,-0.67533E+00,&
     -0.67326E+00,-0.67119E+00,-0.66911E+00,-0.66702E+00,-0.66493E+00,&
     -0.66282E+00,-0.66071E+00,-0.65859E+00,-0.65646E+00,-0.65432E+00,&
     -0.65218E+00,-0.65003E+00,-0.64787E+00,-0.64571E+00,-0.64354E+00,&
     -0.64136E+00,-0.63917E+00,-0.63698E+00,-0.63478E+00,-0.63258E+00,&
     -0.63037E+00,-0.62815E+00,-0.62593E+00,-0.62370E+00,-0.62147E+00,&
     -0.61923E+00,-0.61699E+00,-0.61474E+00,-0.61248E+00,-0.61022E+00,&
     -0.60795E+00,-0.60568E+00,-0.60341E+00,-0.60113E+00,-0.59884E+00,&
     -0.59655E+00,-0.59425E+00,-0.59195E+00,-0.58965E+00,-0.58734E+00,&
     -0.58503E+00,-0.58271E+00,-0.58039E+00,-0.57806E+00,-0.57573E+00/
                             
     DATA (BNC02M(IA),IA=701,741)/                                      &
     -0.57339E+00,-0.57106E+00,-0.56871E+00,-0.56637E+00,-0.56402E+00,&
     -0.56166E+00,-0.55930E+00,-0.55694E+00,-0.55458E+00,-0.55221E+00,&
     -0.54984E+00,-0.54746E+00,-0.54508E+00,-0.54270E+00,-0.54031E+00,&
     -0.53792E+00,-0.53553E+00,-0.53313E+00,-0.53073E+00,-0.52833E+00,&
     -0.52593E+00,-0.52352E+00,-0.52111E+00,-0.51870E+00,-0.51628E+00,&
     -0.51386E+00,-0.51144E+00,-0.50901E+00,-0.50658E+00,-0.50415E+00,&
     -0.50172E+00,-0.49928E+00,-0.49684E+00,-0.49440E+00,-0.49196E+00,&
     -0.48951E+00,-0.48706E+00,-0.48461E+00,-0.48216E+00,-0.47970E+00,&
     -0.47725E+00                  /                      
!                            
!  ** NaNO3                  
!                            
     DATA (BNC03M (IA),IA=  1,100)/                                     &
     -0.50245E-01,-0.91612E-01,-0.12079E+00,-0.14067E+00,-0.15601E+00,&
     -0.16858E+00,-0.17927E+00,-0.18858E+00,-0.19683E+00,-0.20425E+00,&
     -0.21100E+00,-0.21718E+00,-0.22289E+00,-0.22819E+00,-0.23314E+00,&
     -0.23778E+00,-0.24215E+00,-0.24628E+00,-0.25020E+00,-0.25391E+00,&
     -0.25745E+00,-0.26083E+00,-0.26407E+00,-0.26716E+00,-0.27014E+00,&
     -0.27300E+00,-0.27575E+00,-0.27840E+00,-0.28095E+00,-0.28343E+00,&
     -0.28582E+00,-0.28813E+00,-0.29037E+00,-0.29254E+00,-0.29465E+00,&
     -0.29669E+00,-0.29868E+00,-0.30062E+00,-0.30250E+00,-0.30433E+00,&
     -0.30611E+00,-0.30785E+00,-0.30954E+00,-0.31119E+00,-0.31281E+00,&
     -0.31438E+00,-0.31592E+00,-0.31742E+00,-0.31889E+00,-0.32032E+00,&
     -0.32173E+00,-0.32310E+00,-0.32444E+00,-0.32576E+00,-0.32705E+00,&
     -0.32832E+00,-0.32955E+00,-0.33077E+00,-0.33196E+00,-0.33313E+00,&
     -0.33428E+00,-0.33540E+00,-0.33651E+00,-0.33760E+00,-0.33867E+00,&
     -0.33972E+00,-0.34075E+00,-0.34176E+00,-0.34276E+00,-0.34375E+00,&
     -0.34472E+00,-0.34567E+00,-0.34661E+00,-0.34754E+00,-0.34845E+00,&
     -0.34935E+00,-0.35024E+00,-0.35112E+00,-0.35198E+00,-0.35284E+00,&
     -0.35368E+00,-0.35452E+00,-0.35534E+00,-0.35615E+00,-0.35696E+00,&
     -0.35775E+00,-0.35854E+00,-0.35932E+00,-0.36009E+00,-0.36085E+00,&
     -0.36161E+00,-0.36235E+00,-0.36309E+00,-0.36382E+00,-0.36455E+00,&
     -0.36527E+00,-0.36598E+00,-0.36668E+00,-0.36738E+00,-0.36807E+00/
                             
     DATA (BNC03M (IA),IA=101,200)/                                     &
     -0.36876E+00,-0.36943E+00,-0.37011E+00,-0.37077E+00,-0.37143E+00,&
     -0.37209E+00,-0.37274E+00,-0.37338E+00,-0.37402E+00,-0.37465E+00,&
     -0.37528E+00,-0.37590E+00,-0.37652E+00,-0.37713E+00,-0.37773E+00,&
     -0.37833E+00,-0.37893E+00,-0.37952E+00,-0.38010E+00,-0.38068E+00,&
     -0.38123E+00,-0.38180E+00,-0.38237E+00,-0.38293E+00,-0.38349E+00,&
     -0.38404E+00,-0.38459E+00,-0.38513E+00,-0.38567E+00,-0.38621E+00,&
     -0.38674E+00,-0.38726E+00,-0.38778E+00,-0.38830E+00,-0.38881E+00,&
     -0.38931E+00,-0.38981E+00,-0.39031E+00,-0.39081E+00,-0.39130E+00,&
     -0.39178E+00,-0.39226E+00,-0.39274E+00,-0.39321E+00,-0.39368E+00,&
     -0.39415E+00,-0.39461E+00,-0.39507E+00,-0.39553E+00,-0.39598E+00,&
     -0.39642E+00,-0.39687E+00,-0.39731E+00,-0.39775E+00,-0.39818E+00,&
     -0.39861E+00,-0.39904E+00,-0.39946E+00,-0.39988E+00,-0.40030E+00,&
     -0.40071E+00,-0.40112E+00,-0.40153E+00,-0.40193E+00,-0.40233E+00,&
     -0.40273E+00,-0.40313E+00,-0.40352E+00,-0.40391E+00,-0.40430E+00,&
     -0.40468E+00,-0.40506E+00,-0.40544E+00,-0.40582E+00,-0.40619E+00,&
     -0.40656E+00,-0.40693E+00,-0.40729E+00,-0.40765E+00,-0.40801E+00,&
     -0.40837E+00,-0.40872E+00,-0.40907E+00,-0.40942E+00,-0.40977E+00,&
     -0.41011E+00,-0.41046E+00,-0.41080E+00,-0.41113E+00,-0.41147E+00,&
     -0.41180E+00,-0.41213E+00,-0.41246E+00,-0.41278E+00,-0.41311E+00,&
     -0.41343E+00,-0.41375E+00,-0.41407E+00,-0.41438E+00,-0.41469E+00/
                             
     DATA (BNC03M (IA),IA=201,300)/                                     &
     -0.41500E+00,-0.41531E+00,-0.41562E+00,-0.41592E+00,-0.41622E+00,&
     -0.41652E+00,-0.41682E+00,-0.41712E+00,-0.41741E+00,-0.41770E+00,&
     -0.41799E+00,-0.41828E+00,-0.41857E+00,-0.41885E+00,-0.41914E+00,&
     -0.41942E+00,-0.41970E+00,-0.41997E+00,-0.42025E+00,-0.42052E+00,&
     -0.42079E+00,-0.42106E+00,-0.42133E+00,-0.42160E+00,-0.42186E+00,&
     -0.42213E+00,-0.42239E+00,-0.42265E+00,-0.42290E+00,-0.42316E+00,&
     -0.42342E+00,-0.42367E+00,-0.42392E+00,-0.42417E+00,-0.42442E+00,&
     -0.42466E+00,-0.42491E+00,-0.42515E+00,-0.42539E+00,-0.42564E+00,&
     -0.42587E+00,-0.42611E+00,-0.42635E+00,-0.42658E+00,-0.42681E+00,&
     -0.42705E+00,-0.42728E+00,-0.42751E+00,-0.42773E+00,-0.42796E+00,&
     -0.42818E+00,-0.42841E+00,-0.42863E+00,-0.42885E+00,-0.42907E+00,&
     -0.42928E+00,-0.42950E+00,-0.42971E+00,-0.42993E+00,-0.43014E+00,&
     -0.43035E+00,-0.43056E+00,-0.43077E+00,-0.43098E+00,-0.43118E+00,&
     -0.43139E+00,-0.43159E+00,-0.43179E+00,-0.43199E+00,-0.43219E+00,&
     -0.43239E+00,-0.43259E+00,-0.43278E+00,-0.43298E+00,-0.43317E+00,&
     -0.43336E+00,-0.43355E+00,-0.43374E+00,-0.43393E+00,-0.43412E+00,&
     -0.43430E+00,-0.43449E+00,-0.43467E+00,-0.43486E+00,-0.43504E+00,&
     -0.43522E+00,-0.43540E+00,-0.43558E+00,-0.43576E+00,-0.43593E+00,&
     -0.43611E+00,-0.43628E+00,-0.43645E+00,-0.43663E+00,-0.43680E+00,&
     -0.43697E+00,-0.43714E+00,-0.43730E+00,-0.43747E+00,-0.43764E+00/
                             
     DATA (BNC03M (IA),IA=301,400)/                                     &
     -0.43780E+00,-0.43797E+00,-0.43813E+00,-0.43829E+00,-0.43845E+00,&
     -0.43861E+00,-0.43877E+00,-0.43893E+00,-0.43909E+00,-0.43924E+00,&
     -0.43940E+00,-0.43955E+00,-0.43971E+00,-0.43986E+00,-0.44001E+00,&
     -0.44016E+00,-0.44031E+00,-0.44046E+00,-0.44061E+00,-0.44075E+00,&
     -0.44090E+00,-0.44104E+00,-0.44119E+00,-0.44133E+00,-0.44147E+00,&
     -0.44161E+00,-0.44176E+00,-0.44190E+00,-0.44203E+00,-0.44217E+00,&
     -0.44231E+00,-0.44245E+00,-0.44258E+00,-0.44272E+00,-0.44285E+00,&
     -0.44298E+00,-0.44312E+00,-0.44325E+00,-0.44338E+00,-0.44351E+00,&
     -0.44364E+00,-0.44377E+00,-0.44389E+00,-0.44402E+00,-0.44415E+00,&
     -0.44427E+00,-0.44439E+00,-0.44452E+00,-0.44464E+00,-0.44476E+00,&
     -0.44488E+00,-0.44500E+00,-0.44512E+00,-0.44524E+00,-0.44536E+00,&
     -0.44548E+00,-0.44560E+00,-0.44571E+00,-0.44583E+00,-0.44594E+00,&
     -0.44606E+00,-0.44617E+00,-0.44628E+00,-0.44639E+00,-0.44650E+00,&
     -0.44661E+00,-0.44672E+00,-0.44683E+00,-0.44694E+00,-0.44705E+00,&
     -0.44716E+00,-0.44726E+00,-0.44737E+00,-0.44747E+00,-0.44758E+00,&
     -0.44768E+00,-0.44778E+00,-0.44789E+00,-0.44799E+00,-0.44809E+00,&
     -0.44819E+00,-0.44829E+00,-0.44839E+00,-0.44848E+00,-0.44858E+00,&
     -0.44868E+00,-0.44878E+00,-0.44887E+00,-0.44897E+00,-0.44906E+00,&
     -0.44915E+00,-0.44925E+00,-0.44934E+00,-0.44943E+00,-0.44952E+00,&
     -0.44961E+00,-0.44970E+00,-0.44979E+00,-0.44988E+00,-0.44997E+00/
                             
     DATA (BNC03M (IA),IA=401,500)/                                     &
     -0.45006E+00,-0.45015E+00,-0.45023E+00,-0.45032E+00,-0.45040E+00,&
     -0.45049E+00,-0.45057E+00,-0.45066E+00,-0.45074E+00,-0.45082E+00,&
     -0.45091E+00,-0.45099E+00,-0.45107E+00,-0.45115E+00,-0.45123E+00,&
     -0.45131E+00,-0.45139E+00,-0.45146E+00,-0.45154E+00,-0.45162E+00,&
     -0.45170E+00,-0.45177E+00,-0.45185E+00,-0.45192E+00,-0.45200E+00,&
     -0.45207E+00,-0.45214E+00,-0.45222E+00,-0.45229E+00,-0.45236E+00,&
     -0.45243E+00,-0.45250E+00,-0.45257E+00,-0.45264E+00,-0.45271E+00,&
     -0.45278E+00,-0.45285E+00,-0.45291E+00,-0.45298E+00,-0.45305E+00,&
     -0.45311E+00,-0.45318E+00,-0.45325E+00,-0.45331E+00,-0.45337E+00,&
     -0.45344E+00,-0.45350E+00,-0.45356E+00,-0.45363E+00,-0.45369E+00,&
     -0.45375E+00,-0.45381E+00,-0.45387E+00,-0.45393E+00,-0.45399E+00,&
     -0.45405E+00,-0.45411E+00,-0.45417E+00,-0.45422E+00,-0.45428E+00,&
     -0.45434E+00,-0.45439E+00,-0.45445E+00,-0.45450E+00,-0.45456E+00,&
     -0.45461E+00,-0.45467E+00,-0.45472E+00,-0.45477E+00,-0.45483E+00,&
     -0.45488E+00,-0.45493E+00,-0.45498E+00,-0.45503E+00,-0.45508E+00,&
     -0.45513E+00,-0.45518E+00,-0.45523E+00,-0.45528E+00,-0.45533E+00,&
     -0.45538E+00,-0.45542E+00,-0.45547E+00,-0.45552E+00,-0.45556E+00,&
     -0.45561E+00,-0.45566E+00,-0.45570E+00,-0.45575E+00,-0.45579E+00,&
     -0.45583E+00,-0.45588E+00,-0.45592E+00,-0.45596E+00,-0.45600E+00,&
     -0.45605E+00,-0.45609E+00,-0.45613E+00,-0.45617E+00,-0.45621E+00/
                             
     DATA (BNC03M (IA),IA=501,600)/                                     &
     -0.45625E+00,-0.45629E+00,-0.45633E+00,-0.45637E+00,-0.45641E+00,&
     -0.45644E+00,-0.45648E+00,-0.45652E+00,-0.45655E+00,-0.45659E+00,&
     -0.45663E+00,-0.45666E+00,-0.45670E+00,-0.45673E+00,-0.45677E+00,&
     -0.45680E+00,-0.45684E+00,-0.45687E+00,-0.45690E+00,-0.45693E+00,&
     -0.45697E+00,-0.45700E+00,-0.45703E+00,-0.45706E+00,-0.45709E+00,&
     -0.45712E+00,-0.45715E+00,-0.45718E+00,-0.45721E+00,-0.45724E+00,&
     -0.45727E+00,-0.45730E+00,-0.45733E+00,-0.45736E+00,-0.45738E+00,&
     -0.45741E+00,-0.45744E+00,-0.45746E+00,-0.45749E+00,-0.45751E+00,&
     -0.45754E+00,-0.45757E+00,-0.45759E+00,-0.45761E+00,-0.45764E+00,&
     -0.45766E+00,-0.45769E+00,-0.45771E+00,-0.45773E+00,-0.45775E+00,&
     -0.45778E+00,-0.45780E+00,-0.45782E+00,-0.45784E+00,-0.45786E+00,&
     -0.45788E+00,-0.45790E+00,-0.45792E+00,-0.45794E+00,-0.45796E+00,&
     -0.45798E+00,-0.45800E+00,-0.45802E+00,-0.45803E+00,-0.45805E+00,&
     -0.45807E+00,-0.45809E+00,-0.45810E+00,-0.45812E+00,-0.45814E+00,&
     -0.45815E+00,-0.45817E+00,-0.45818E+00,-0.45820E+00,-0.45821E+00,&
     -0.45823E+00,-0.45824E+00,-0.45825E+00,-0.45827E+00,-0.45828E+00,&
     -0.45829E+00,-0.45831E+00,-0.45832E+00,-0.45833E+00,-0.45834E+00,&
     -0.45835E+00,-0.45836E+00,-0.45838E+00,-0.45839E+00,-0.45840E+00,&
     -0.45841E+00,-0.45842E+00,-0.45843E+00,-0.45843E+00,-0.45844E+00,&
     -0.45845E+00,-0.45846E+00,-0.45847E+00,-0.45848E+00,-0.45850E+00/
                             
     DATA (BNC03M (IA),IA=601,700)/                                     &
     -0.45855E+00,-0.45858E+00,-0.45858E+00,-0.45856E+00,-0.45852E+00,&
     -0.45845E+00,-0.45836E+00,-0.45825E+00,-0.45812E+00,-0.45796E+00,&
     -0.45779E+00,-0.45759E+00,-0.45738E+00,-0.45715E+00,-0.45690E+00,&
     -0.45663E+00,-0.45634E+00,-0.45604E+00,-0.45573E+00,-0.45539E+00,&
     -0.45504E+00,-0.45468E+00,-0.45430E+00,-0.45390E+00,-0.45350E+00,&
     -0.45307E+00,-0.45264E+00,-0.45219E+00,-0.45173E+00,-0.45126E+00,&
     -0.45077E+00,-0.45027E+00,-0.44976E+00,-0.44924E+00,-0.44871E+00,&
     -0.44817E+00,-0.44762E+00,-0.44705E+00,-0.44648E+00,-0.44589E+00,&
     -0.44530E+00,-0.44470E+00,-0.44408E+00,-0.44346E+00,-0.44283E+00,&
     -0.44219E+00,-0.44154E+00,-0.44088E+00,-0.44022E+00,-0.43954E+00,&
     -0.43886E+00,-0.43817E+00,-0.43747E+00,-0.43676E+00,-0.43605E+00,&
     -0.43533E+00,-0.43460E+00,-0.43387E+00,-0.43313E+00,-0.43238E+00,&
     -0.43162E+00,-0.43086E+00,-0.43009E+00,-0.42932E+00,-0.42854E+00,&
     -0.42775E+00,-0.42695E+00,-0.42616E+00,-0.42535E+00,-0.42454E+00,&
     -0.42372E+00,-0.42290E+00,-0.42207E+00,-0.42124E+00,-0.42040E+00,&
     -0.41956E+00,-0.41871E+00,-0.41786E+00,-0.41700E+00,-0.41613E+00,&
     -0.41527E+00,-0.41439E+00,-0.41351E+00,-0.41263E+00,-0.41175E+00,&
     -0.41085E+00,-0.40996E+00,-0.40906E+00,-0.40815E+00,-0.40724E+00,&
     -0.40633E+00,-0.40542E+00,-0.40449E+00,-0.40357E+00,-0.40264E+00,&
     -0.40171E+00,-0.40077E+00,-0.39983E+00,-0.39889E+00,-0.39794E+00/
                             
     DATA (BNC03M(IA),IA=701,741)/                                      &
     -0.39699E+00,-0.39604E+00,-0.39508E+00,-0.39412E+00,-0.39315E+00,&
     -0.39218E+00,-0.39121E+00,-0.39024E+00,-0.38926E+00,-0.38828E+00,&
     -0.38729E+00,-0.38630E+00,-0.38531E+00,-0.38432E+00,-0.38332E+00,&
     -0.38232E+00,-0.38132E+00,-0.38032E+00,-0.37931E+00,-0.37830E+00,&
     -0.37729E+00,-0.37627E+00,-0.37525E+00,-0.37423E+00,-0.37320E+00,&
     -0.37218E+00,-0.37115E+00,-0.37012E+00,-0.36908E+00,-0.36804E+00,&
     -0.36701E+00,-0.36596E+00,-0.36492E+00,-0.36387E+00,-0.36282E+00,&
     -0.36177E+00,-0.36072E+00,-0.35967E+00,-0.35861E+00,-0.35755E+00,&
     -0.35649E+00                  /                      
!                            
!  ** (NH4)2SO4              
!                            
     DATA (BNC04M (IA),IA=  1,100)/                                     &
     -0.10031E+00,-0.18257E+00,-0.24033E+00,-0.27955E+00,-0.30969E+00,&
     -0.33432E+00,-0.35518E+00,-0.37330E+00,-0.38932E+00,-0.40369E+00,&
     -0.41670E+00,-0.42860E+00,-0.43956E+00,-0.44971E+00,-0.45917E+00,&
     -0.46801E+00,-0.47632E+00,-0.48414E+00,-0.49154E+00,-0.49856E+00,&
     -0.50522E+00,-0.51157E+00,-0.51763E+00,-0.52342E+00,-0.52897E+00,&
     -0.53428E+00,-0.53939E+00,-0.54431E+00,-0.54904E+00,-0.55361E+00,&
     -0.55801E+00,-0.56226E+00,-0.56638E+00,-0.57036E+00,-0.57421E+00,&
     -0.57795E+00,-0.58157E+00,-0.58509E+00,-0.58851E+00,-0.59183E+00,&
     -0.59506E+00,-0.59820E+00,-0.60126E+00,-0.60424E+00,-0.60714E+00,&
     -0.60997E+00,-0.61273E+00,-0.61542E+00,-0.61805E+00,-0.62062E+00,&
     -0.62312E+00,-0.62557E+00,-0.62796E+00,-0.63030E+00,-0.63259E+00,&
     -0.63484E+00,-0.63703E+00,-0.63918E+00,-0.64128E+00,-0.64334E+00,&
     -0.64536E+00,-0.64734E+00,-0.64928E+00,-0.65119E+00,-0.65306E+00,&
     -0.65489E+00,-0.65670E+00,-0.65847E+00,-0.66021E+00,-0.66191E+00,&
     -0.66360E+00,-0.66525E+00,-0.66687E+00,-0.66847E+00,-0.67004E+00,&
     -0.67159E+00,-0.67312E+00,-0.67462E+00,-0.67610E+00,-0.67756E+00,&
     -0.67900E+00,-0.68042E+00,-0.68181E+00,-0.68319E+00,-0.68455E+00,&
     -0.68590E+00,-0.68722E+00,-0.68853E+00,-0.68982E+00,-0.69109E+00,&
     -0.69235E+00,-0.69360E+00,-0.69483E+00,-0.69604E+00,-0.69724E+00,&
     -0.69843E+00,-0.69960E+00,-0.70076E+00,-0.70191E+00,-0.70304E+00/
                             
     DATA (BNC04M (IA),IA=101,200)/                                     &
     -0.70417E+00,-0.70527E+00,-0.70637E+00,-0.70746E+00,-0.70853E+00,&
     -0.70959E+00,-0.71064E+00,-0.71168E+00,-0.71271E+00,-0.71373E+00,&
     -0.71473E+00,-0.71573E+00,-0.71672E+00,-0.71769E+00,-0.71866E+00,&
     -0.71961E+00,-0.72056E+00,-0.72150E+00,-0.72242E+00,-0.72334E+00,&
     -0.72420E+00,-0.72511E+00,-0.72600E+00,-0.72688E+00,-0.72776E+00,&
     -0.72862E+00,-0.72948E+00,-0.73033E+00,-0.73116E+00,-0.73199E+00,&
     -0.73282E+00,-0.73363E+00,-0.73443E+00,-0.73523E+00,-0.73602E+00,&
     -0.73680E+00,-0.73757E+00,-0.73834E+00,-0.73909E+00,-0.73984E+00,&
     -0.74059E+00,-0.74132E+00,-0.74205E+00,-0.74277E+00,-0.74348E+00,&
     -0.74419E+00,-0.74489E+00,-0.74559E+00,-0.74627E+00,-0.74695E+00,&
     -0.74763E+00,-0.74829E+00,-0.74896E+00,-0.74961E+00,-0.75026E+00,&
     -0.75090E+00,-0.75154E+00,-0.75217E+00,-0.75280E+00,-0.75342E+00,&
     -0.75403E+00,-0.75464E+00,-0.75524E+00,-0.75584E+00,-0.75643E+00,&
     -0.75702E+00,-0.75760E+00,-0.75817E+00,-0.75874E+00,-0.75931E+00,&
     -0.75987E+00,-0.76042E+00,-0.76098E+00,-0.76152E+00,-0.76206E+00,&
     -0.76260E+00,-0.76313E+00,-0.76366E+00,-0.76418E+00,-0.76470E+00,&
     -0.76521E+00,-0.76572E+00,-0.76622E+00,-0.76672E+00,-0.76722E+00,&
     -0.76771E+00,-0.76820E+00,-0.76868E+00,-0.76916E+00,-0.76963E+00,&
     -0.77010E+00,-0.77057E+00,-0.77103E+00,-0.77149E+00,-0.77194E+00,&
     -0.77239E+00,-0.77284E+00,-0.77328E+00,-0.77372E+00,-0.77416E+00/
                             
     DATA (BNC04M (IA),IA=201,300)/                                     &
     -0.77459E+00,-0.77502E+00,-0.77544E+00,-0.77587E+00,-0.77628E+00,&
     -0.77670E+00,-0.77711E+00,-0.77751E+00,-0.77792E+00,-0.77832E+00,&
     -0.77872E+00,-0.77911E+00,-0.77950E+00,-0.77989E+00,-0.78027E+00,&
     -0.78065E+00,-0.78103E+00,-0.78140E+00,-0.78178E+00,-0.78214E+00,&
     -0.78251E+00,-0.78287E+00,-0.78323E+00,-0.78359E+00,-0.78394E+00,&
     -0.78429E+00,-0.78464E+00,-0.78498E+00,-0.78532E+00,-0.78566E+00,&
     -0.78600E+00,-0.78633E+00,-0.78666E+00,-0.78699E+00,-0.78732E+00,&
     -0.78764E+00,-0.78796E+00,-0.78827E+00,-0.78859E+00,-0.78890E+00,&
     -0.78921E+00,-0.78952E+00,-0.78982E+00,-0.79012E+00,-0.79042E+00,&
     -0.79072E+00,-0.79101E+00,-0.79130E+00,-0.79159E+00,-0.79188E+00,&
     -0.79216E+00,-0.79245E+00,-0.79273E+00,-0.79300E+00,-0.79328E+00,&
     -0.79355E+00,-0.79382E+00,-0.79409E+00,-0.79436E+00,-0.79462E+00,&
     -0.79488E+00,-0.79514E+00,-0.79540E+00,-0.79566E+00,-0.79591E+00,&
     -0.79616E+00,-0.79641E+00,-0.79666E+00,-0.79690E+00,-0.79714E+00,&
     -0.79738E+00,-0.79762E+00,-0.79786E+00,-0.79809E+00,-0.79832E+00,&
     -0.79855E+00,-0.79878E+00,-0.79901E+00,-0.79923E+00,-0.79946E+00,&
     -0.79968E+00,-0.79990E+00,-0.80011E+00,-0.80033E+00,-0.80054E+00,&
     -0.80075E+00,-0.80096E+00,-0.80117E+00,-0.80138E+00,-0.80158E+00,&
     -0.80178E+00,-0.80198E+00,-0.80218E+00,-0.80238E+00,-0.80258E+00,&
     -0.80277E+00,-0.80296E+00,-0.80315E+00,-0.80334E+00,-0.80353E+00/
                             
     DATA (BNC04M (IA),IA=301,400)/                                     &
     -0.80371E+00,-0.80390E+00,-0.80408E+00,-0.80426E+00,-0.80444E+00,&
     -0.80461E+00,-0.80479E+00,-0.80496E+00,-0.80513E+00,-0.80530E+00,&
     -0.80547E+00,-0.80564E+00,-0.80581E+00,-0.80597E+00,-0.80613E+00,&
     -0.80630E+00,-0.80646E+00,-0.80661E+00,-0.80677E+00,-0.80693E+00,&
     -0.80708E+00,-0.80723E+00,-0.80738E+00,-0.80753E+00,-0.80768E+00,&
     -0.80783E+00,-0.80797E+00,-0.80812E+00,-0.80826E+00,-0.80840E+00,&
     -0.80854E+00,-0.80868E+00,-0.80881E+00,-0.80895E+00,-0.80908E+00,&
     -0.80922E+00,-0.80935E+00,-0.80948E+00,-0.80961E+00,-0.80974E+00,&
     -0.80986E+00,-0.80999E+00,-0.81011E+00,-0.81023E+00,-0.81035E+00,&
     -0.81047E+00,-0.81059E+00,-0.81071E+00,-0.81082E+00,-0.81094E+00,&
     -0.81105E+00,-0.81117E+00,-0.81128E+00,-0.81139E+00,-0.81150E+00,&
     -0.81160E+00,-0.81171E+00,-0.81181E+00,-0.81192E+00,-0.81202E+00,&
     -0.81212E+00,-0.81222E+00,-0.81232E+00,-0.81242E+00,-0.81252E+00,&
     -0.81261E+00,-0.81271E+00,-0.81280E+00,-0.81289E+00,-0.81298E+00,&
     -0.81307E+00,-0.81316E+00,-0.81325E+00,-0.81334E+00,-0.81342E+00,&
     -0.81351E+00,-0.81359E+00,-0.81368E+00,-0.81376E+00,-0.81384E+00,&
     -0.81392E+00,-0.81399E+00,-0.81407E+00,-0.81415E+00,-0.81422E+00,&
     -0.81430E+00,-0.81437E+00,-0.81444E+00,-0.81451E+00,-0.81459E+00,&
     -0.81465E+00,-0.81472E+00,-0.81479E+00,-0.81486E+00,-0.81492E+00,&
     -0.81499E+00,-0.81505E+00,-0.81511E+00,-0.81517E+00,-0.81523E+00/
                             
     DATA (BNC04M (IA),IA=401,500)/                                     &
     -0.81529E+00,-0.81535E+00,-0.81541E+00,-0.81547E+00,-0.81552E+00,&
     -0.81558E+00,-0.81563E+00,-0.81568E+00,-0.81573E+00,-0.81579E+00,&
     -0.81584E+00,-0.81589E+00,-0.81593E+00,-0.81598E+00,-0.81603E+00,&
     -0.81607E+00,-0.81612E+00,-0.81616E+00,-0.81621E+00,-0.81625E+00,&
     -0.81629E+00,-0.81633E+00,-0.81637E+00,-0.81641E+00,-0.81645E+00,&
     -0.81648E+00,-0.81652E+00,-0.81656E+00,-0.81659E+00,-0.81662E+00,&
     -0.81666E+00,-0.81669E+00,-0.81672E+00,-0.81675E+00,-0.81678E+00,&
     -0.81681E+00,-0.81684E+00,-0.81687E+00,-0.81689E+00,-0.81692E+00,&
     -0.81694E+00,-0.81697E+00,-0.81699E+00,-0.81701E+00,-0.81704E+00,&
     -0.81706E+00,-0.81708E+00,-0.81710E+00,-0.81711E+00,-0.81713E+00,&
     -0.81715E+00,-0.81717E+00,-0.81718E+00,-0.81720E+00,-0.81721E+00,&
     -0.81723E+00,-0.81724E+00,-0.81725E+00,-0.81726E+00,-0.81727E+00,&
     -0.81728E+00,-0.81729E+00,-0.81730E+00,-0.81731E+00,-0.81732E+00,&
     -0.81732E+00,-0.81733E+00,-0.81733E+00,-0.81734E+00,-0.81734E+00,&
     -0.81734E+00,-0.81735E+00,-0.81735E+00,-0.81735E+00,-0.81735E+00,&
     -0.81735E+00,-0.81735E+00,-0.81734E+00,-0.81734E+00,-0.81734E+00,&
     -0.81734E+00,-0.81733E+00,-0.81733E+00,-0.81732E+00,-0.81731E+00,&
     -0.81731E+00,-0.81730E+00,-0.81729E+00,-0.81728E+00,-0.81727E+00,&
     -0.81726E+00,-0.81725E+00,-0.81724E+00,-0.81723E+00,-0.81721E+00,&
     -0.81720E+00,-0.81719E+00,-0.81717E+00,-0.81716E+00,-0.81714E+00/
                             
     DATA (BNC04M (IA),IA=501,600)/                                     &
     -0.81712E+00,-0.81711E+00,-0.81709E+00,-0.81707E+00,-0.81705E+00,&
     -0.81703E+00,-0.81701E+00,-0.81699E+00,-0.81697E+00,-0.81695E+00,&
     -0.81693E+00,-0.81690E+00,-0.81688E+00,-0.81686E+00,-0.81683E+00,&
     -0.81681E+00,-0.81678E+00,-0.81675E+00,-0.81673E+00,-0.81670E+00,&
     -0.81667E+00,-0.81664E+00,-0.81661E+00,-0.81658E+00,-0.81655E+00,&
     -0.81652E+00,-0.81649E+00,-0.81646E+00,-0.81642E+00,-0.81639E+00,&
     -0.81636E+00,-0.81632E+00,-0.81629E+00,-0.81625E+00,-0.81622E+00,&
     -0.81618E+00,-0.81614E+00,-0.81611E+00,-0.81607E+00,-0.81603E+00,&
     -0.81599E+00,-0.81595E+00,-0.81591E+00,-0.81587E+00,-0.81583E+00,&
     -0.81579E+00,-0.81575E+00,-0.81570E+00,-0.81566E+00,-0.81562E+00,&
     -0.81557E+00,-0.81553E+00,-0.81548E+00,-0.81544E+00,-0.81539E+00,&
     -0.81534E+00,-0.81530E+00,-0.81525E+00,-0.81520E+00,-0.81515E+00,&
     -0.81510E+00,-0.81505E+00,-0.81500E+00,-0.81495E+00,-0.81490E+00,&
     -0.81485E+00,-0.81480E+00,-0.81475E+00,-0.81469E+00,-0.81464E+00,&
     -0.81459E+00,-0.81453E+00,-0.81448E+00,-0.81442E+00,-0.81437E+00,&
     -0.81431E+00,-0.81425E+00,-0.81420E+00,-0.81414E+00,-0.81408E+00,&
     -0.81402E+00,-0.81396E+00,-0.81391E+00,-0.81385E+00,-0.81379E+00,&
     -0.81372E+00,-0.81366E+00,-0.81360E+00,-0.81354E+00,-0.81348E+00,&
     -0.81341E+00,-0.81335E+00,-0.81329E+00,-0.81322E+00,-0.81316E+00,&
     -0.81309E+00,-0.81303E+00,-0.81296E+00,-0.81290E+00,-0.81264E+00/
                             
     DATA (BNC04M (IA),IA=601,700)/                                     &
     -0.81207E+00,-0.81133E+00,-0.81056E+00,-0.80975E+00,-0.80890E+00,&
     -0.80801E+00,-0.80709E+00,-0.80614E+00,-0.80515E+00,-0.80414E+00,&
     -0.80309E+00,-0.80201E+00,-0.80090E+00,-0.79977E+00,-0.79861E+00,&
     -0.79742E+00,-0.79620E+00,-0.79496E+00,-0.79370E+00,-0.79241E+00,&
     -0.79110E+00,-0.78976E+00,-0.78841E+00,-0.78703E+00,-0.78563E+00,&
     -0.78421E+00,-0.78277E+00,-0.78131E+00,-0.77984E+00,-0.77834E+00,&
     -0.77683E+00,-0.77529E+00,-0.77374E+00,-0.77218E+00,-0.77060E+00,&
     -0.76900E+00,-0.76738E+00,-0.76575E+00,-0.76411E+00,-0.76245E+00,&
     -0.76077E+00,-0.75908E+00,-0.75738E+00,-0.75566E+00,-0.75393E+00,&
     -0.75219E+00,-0.75044E+00,-0.74867E+00,-0.74689E+00,-0.74510E+00,&
     -0.74329E+00,-0.74148E+00,-0.73965E+00,-0.73781E+00,-0.73596E+00,&
     -0.73411E+00,-0.73224E+00,-0.73036E+00,-0.72847E+00,-0.72657E+00,&
     -0.72466E+00,-0.72274E+00,-0.72081E+00,-0.71887E+00,-0.71692E+00,&
     -0.71497E+00,-0.71300E+00,-0.71103E+00,-0.70905E+00,-0.70706E+00,&
     -0.70506E+00,-0.70306E+00,-0.70104E+00,-0.69902E+00,-0.69699E+00,&
     -0.69496E+00,-0.69291E+00,-0.69086E+00,-0.68880E+00,-0.68674E+00,&
     -0.68467E+00,-0.68259E+00,-0.68050E+00,-0.67841E+00,-0.67631E+00,&
     -0.67421E+00,-0.67210E+00,-0.66998E+00,-0.66786E+00,-0.66573E+00,&
     -0.66359E+00,-0.66145E+00,-0.65930E+00,-0.65715E+00,-0.65499E+00,&
     -0.65283E+00,-0.65066E+00,-0.64849E+00,-0.64631E+00,-0.64413E+00/
                             
     DATA (BNC04M(IA),IA=701,741)/                                      &
     -0.64194E+00,-0.63974E+00,-0.63755E+00,-0.63534E+00,-0.63313E+00,&
     -0.63092E+00,-0.62870E+00,-0.62648E+00,-0.62425E+00,-0.62202E+00,&
     -0.61979E+00,-0.61755E+00,-0.61530E+00,-0.61305E+00,-0.61080E+00,&
     -0.60854E+00,-0.60628E+00,-0.60402E+00,-0.60175E+00,-0.59948E+00,&
     -0.59720E+00,-0.59492E+00,-0.59264E+00,-0.59035E+00,-0.58806E+00,&
     -0.58576E+00,-0.58346E+00,-0.58116E+00,-0.57886E+00,-0.57655E+00,&
     -0.57424E+00,-0.57192E+00,-0.56960E+00,-0.56728E+00,-0.56496E+00,&
     -0.56263E+00,-0.56030E+00,-0.55796E+00,-0.55562E+00,-0.55328E+00,&
     -0.55094E+00                  /                      
!                            
!  ** NH4NO3                 
!                            
     DATA (BNC05M (IA),IA=  1,100)/                                     &
     -0.50742E-01,-0.93469E-01,-0.12433E+00,-0.14581E+00,-0.16269E+00,&
     -0.17676E+00,-0.18891E+00,-0.19965E+00,-0.20931E+00,-0.21811E+00,&
     -0.22621E+00,-0.23373E+00,-0.24076E+00,-0.24737E+00,-0.25360E+00,&
     -0.25952E+00,-0.26514E+00,-0.27051E+00,-0.27565E+00,-0.28058E+00,&
     -0.28532E+00,-0.28989E+00,-0.29429E+00,-0.29855E+00,-0.30267E+00,&
     -0.30666E+00,-0.31053E+00,-0.31429E+00,-0.31795E+00,-0.32150E+00,&
     -0.32497E+00,-0.32834E+00,-0.33163E+00,-0.33484E+00,-0.33797E+00,&
     -0.34103E+00,-0.34402E+00,-0.34694E+00,-0.34980E+00,-0.35260E+00,&
     -0.35534E+00,-0.35802E+00,-0.36065E+00,-0.36322E+00,-0.36575E+00,&
     -0.36823E+00,-0.37065E+00,-0.37304E+00,-0.37538E+00,-0.37767E+00,&
     -0.37993E+00,-0.38215E+00,-0.38433E+00,-0.38647E+00,-0.38857E+00,&
     -0.39065E+00,-0.39269E+00,-0.39469E+00,-0.39667E+00,-0.39861E+00,&
     -0.40053E+00,-0.40242E+00,-0.40429E+00,-0.40613E+00,-0.40794E+00,&
     -0.40973E+00,-0.41150E+00,-0.41324E+00,-0.41497E+00,-0.41668E+00,&
     -0.41836E+00,-0.42003E+00,-0.42168E+00,-0.42332E+00,-0.42493E+00,&
     -0.42654E+00,-0.42812E+00,-0.42970E+00,-0.43126E+00,-0.43281E+00,&
     -0.43434E+00,-0.43587E+00,-0.43738E+00,-0.43888E+00,-0.44037E+00,&
     -0.44186E+00,-0.44333E+00,-0.44479E+00,-0.44625E+00,-0.44769E+00,&
     -0.44913E+00,-0.45056E+00,-0.45198E+00,-0.45339E+00,-0.45480E+00,&
     -0.45619E+00,-0.45758E+00,-0.45897E+00,-0.46034E+00,-0.46171E+00/
                             
     DATA (BNC05M (IA),IA=101,200)/                                     &
     -0.46308E+00,-0.46443E+00,-0.46578E+00,-0.46712E+00,-0.46846E+00,&
     -0.46979E+00,-0.47111E+00,-0.47242E+00,-0.47373E+00,-0.47503E+00,&
     -0.47633E+00,-0.47761E+00,-0.47889E+00,-0.48017E+00,-0.48144E+00,&
     -0.48270E+00,-0.48395E+00,-0.48519E+00,-0.48643E+00,-0.48766E+00,&
     -0.48879E+00,-0.49002E+00,-0.49124E+00,-0.49245E+00,-0.49366E+00,&
     -0.49486E+00,-0.49605E+00,-0.49723E+00,-0.49840E+00,-0.49957E+00,&
     -0.50073E+00,-0.50188E+00,-0.50303E+00,-0.50416E+00,-0.50529E+00,&
     -0.50642E+00,-0.50753E+00,-0.50864E+00,-0.50975E+00,-0.51084E+00,&
     -0.51193E+00,-0.51301E+00,-0.51409E+00,-0.51516E+00,-0.51622E+00,&
     -0.51728E+00,-0.51833E+00,-0.51938E+00,-0.52042E+00,-0.52145E+00,&
     -0.52247E+00,-0.52350E+00,-0.52451E+00,-0.52552E+00,-0.52652E+00,&
     -0.52752E+00,-0.52851E+00,-0.52950E+00,-0.53048E+00,-0.53145E+00,&
     -0.53242E+00,-0.53339E+00,-0.53434E+00,-0.53530E+00,-0.53625E+00,&
     -0.53719E+00,-0.53813E+00,-0.53906E+00,-0.53999E+00,-0.54091E+00,&
     -0.54183E+00,-0.54274E+00,-0.54365E+00,-0.54455E+00,-0.54545E+00,&
     -0.54634E+00,-0.54723E+00,-0.54811E+00,-0.54899E+00,-0.54986E+00,&
     -0.55073E+00,-0.55160E+00,-0.55246E+00,-0.55332E+00,-0.55417E+00,&
     -0.55502E+00,-0.55586E+00,-0.55670E+00,-0.55753E+00,-0.55836E+00,&
     -0.55919E+00,-0.56001E+00,-0.56083E+00,-0.56164E+00,-0.56245E+00,&
     -0.56325E+00,-0.56405E+00,-0.56485E+00,-0.56565E+00,-0.56643E+00/
                             
     DATA (BNC05M (IA),IA=201,300)/                                     &
     -0.56722E+00,-0.56800E+00,-0.56878E+00,-0.56955E+00,-0.57032E+00,&
     -0.57109E+00,-0.57185E+00,-0.57261E+00,-0.57336E+00,-0.57411E+00,&
     -0.57486E+00,-0.57561E+00,-0.57635E+00,-0.57708E+00,-0.57782E+00,&
     -0.57854E+00,-0.57927E+00,-0.57999E+00,-0.58071E+00,-0.58143E+00,&
     -0.58214E+00,-0.58285E+00,-0.58356E+00,-0.58426E+00,-0.58496E+00,&
     -0.58565E+00,-0.58634E+00,-0.58703E+00,-0.58772E+00,-0.58840E+00,&
     -0.58908E+00,-0.58976E+00,-0.59043E+00,-0.59110E+00,-0.59177E+00,&
     -0.59243E+00,-0.59309E+00,-0.59375E+00,-0.59441E+00,-0.59506E+00,&
     -0.59571E+00,-0.59635E+00,-0.59700E+00,-0.59764E+00,-0.59827E+00,&
     -0.59891E+00,-0.59954E+00,-0.60017E+00,-0.60079E+00,-0.60141E+00,&
     -0.60203E+00,-0.60265E+00,-0.60327E+00,-0.60388E+00,-0.60449E+00,&
     -0.60509E+00,-0.60570E+00,-0.60630E+00,-0.60690E+00,-0.60749E+00,&
     -0.60808E+00,-0.60868E+00,-0.60926E+00,-0.60985E+00,-0.61043E+00,&
     -0.61101E+00,-0.61159E+00,-0.61216E+00,-0.61274E+00,-0.61331E+00,&
     -0.61387E+00,-0.61444E+00,-0.61500E+00,-0.61556E+00,-0.61612E+00,&
     -0.61667E+00,-0.61723E+00,-0.61778E+00,-0.61832E+00,-0.61887E+00,&
     -0.61941E+00,-0.61995E+00,-0.62049E+00,-0.62103E+00,-0.62156E+00,&
     -0.62209E+00,-0.62262E+00,-0.62315E+00,-0.62368E+00,-0.62420E+00,&
     -0.62472E+00,-0.62524E+00,-0.62575E+00,-0.62627E+00,-0.62678E+00,&
     -0.62729E+00,-0.62780E+00,-0.62830E+00,-0.62880E+00,-0.62931E+00/
                             
     DATA (BNC05M (IA),IA=301,400)/                                     &
     -0.62980E+00,-0.63030E+00,-0.63080E+00,-0.63129E+00,-0.63178E+00,&
     -0.63227E+00,-0.63275E+00,-0.63324E+00,-0.63372E+00,-0.63420E+00,&
     -0.63468E+00,-0.63516E+00,-0.63563E+00,-0.63610E+00,-0.63657E+00,&
     -0.63704E+00,-0.63751E+00,-0.63797E+00,-0.63844E+00,-0.63890E+00,&
     -0.63936E+00,-0.63981E+00,-0.64027E+00,-0.64072E+00,-0.64117E+00,&
     -0.64162E+00,-0.64207E+00,-0.64252E+00,-0.64296E+00,-0.64340E+00,&
     -0.64385E+00,-0.64428E+00,-0.64472E+00,-0.64516E+00,-0.64559E+00,&
     -0.64602E+00,-0.64645E+00,-0.64688E+00,-0.64731E+00,-0.64773E+00,&
     -0.64815E+00,-0.64857E+00,-0.64899E+00,-0.64941E+00,-0.64983E+00,&
     -0.65024E+00,-0.65066E+00,-0.65107E+00,-0.65148E+00,-0.65188E+00,&
     -0.65229E+00,-0.65269E+00,-0.65310E+00,-0.65350E+00,-0.65390E+00,&
     -0.65430E+00,-0.65469E+00,-0.65509E+00,-0.65548E+00,-0.65587E+00,&
     -0.65626E+00,-0.65665E+00,-0.65704E+00,-0.65742E+00,-0.65781E+00,&
     -0.65819E+00,-0.65857E+00,-0.65895E+00,-0.65933E+00,-0.65971E+00,&
     -0.66008E+00,-0.66045E+00,-0.66083E+00,-0.66120E+00,-0.66157E+00,&
     -0.66193E+00,-0.66230E+00,-0.66266E+00,-0.66303E+00,-0.66339E+00,&
     -0.66375E+00,-0.66411E+00,-0.66447E+00,-0.66482E+00,-0.66518E+00,&
     -0.66553E+00,-0.66588E+00,-0.66623E+00,-0.66658E+00,-0.66693E+00,&
     -0.66727E+00,-0.66762E+00,-0.66796E+00,-0.66831E+00,-0.66865E+00,&
     -0.66899E+00,-0.66932E+00,-0.66966E+00,-0.67000E+00,-0.67033E+00/
                             
     DATA (BNC05M (IA),IA=401,500)/                                     &
     -0.67066E+00,-0.67100E+00,-0.67133E+00,-0.67166E+00,-0.67198E+00,&
     -0.67231E+00,-0.67263E+00,-0.67296E+00,-0.67328E+00,-0.67360E+00,&
     -0.67392E+00,-0.67424E+00,-0.67456E+00,-0.67488E+00,-0.67519E+00,&
     -0.67551E+00,-0.67582E+00,-0.67613E+00,-0.67644E+00,-0.67675E+00,&
     -0.67706E+00,-0.67736E+00,-0.67767E+00,-0.67797E+00,-0.67828E+00,&
     -0.67858E+00,-0.67888E+00,-0.67918E+00,-0.67948E+00,-0.67977E+00,&
     -0.68007E+00,-0.68037E+00,-0.68066E+00,-0.68095E+00,-0.68124E+00,&
     -0.68153E+00,-0.68182E+00,-0.68211E+00,-0.68240E+00,-0.68268E+00,&
     -0.68297E+00,-0.68325E+00,-0.68353E+00,-0.68382E+00,-0.68410E+00,&
     -0.68438E+00,-0.68465E+00,-0.68493E+00,-0.68521E+00,-0.68548E+00,&
     -0.68576E+00,-0.68603E+00,-0.68630E+00,-0.68657E+00,-0.68684E+00,&
     -0.68711E+00,-0.68738E+00,-0.68764E+00,-0.68791E+00,-0.68817E+00,&
     -0.68844E+00,-0.68870E+00,-0.68896E+00,-0.68922E+00,-0.68948E+00,&
     -0.68974E+00,-0.69000E+00,-0.69025E+00,-0.69051E+00,-0.69076E+00,&
     -0.69102E+00,-0.69127E+00,-0.69152E+00,-0.69177E+00,-0.69202E+00,&
     -0.69227E+00,-0.69252E+00,-0.69276E+00,-0.69301E+00,-0.69325E+00,&
     -0.69350E+00,-0.69374E+00,-0.69398E+00,-0.69422E+00,-0.69446E+00,&
     -0.69470E+00,-0.69494E+00,-0.69517E+00,-0.69541E+00,-0.69565E+00,&
     -0.69588E+00,-0.69611E+00,-0.69635E+00,-0.69658E+00,-0.69681E+00,&
     -0.69704E+00,-0.69727E+00,-0.69749E+00,-0.69772E+00,-0.69795E+00/
                             
     DATA (BNC05M (IA),IA=501,600)/                                     &
     -0.69817E+00,-0.69840E+00,-0.69862E+00,-0.69884E+00,-0.69907E+00,&
     -0.69929E+00,-0.69951E+00,-0.69973E+00,-0.69994E+00,-0.70016E+00,&
     -0.70038E+00,-0.70059E+00,-0.70081E+00,-0.70102E+00,-0.70124E+00,&
     -0.70145E+00,-0.70166E+00,-0.70187E+00,-0.70208E+00,-0.70229E+00,&
     -0.70250E+00,-0.70271E+00,-0.70291E+00,-0.70312E+00,-0.70332E+00,&
     -0.70353E+00,-0.70373E+00,-0.70393E+00,-0.70413E+00,-0.70434E+00,&
     -0.70454E+00,-0.70474E+00,-0.70493E+00,-0.70513E+00,-0.70533E+00,&
     -0.70552E+00,-0.70572E+00,-0.70592E+00,-0.70611E+00,-0.70630E+00,&
     -0.70649E+00,-0.70669E+00,-0.70688E+00,-0.70707E+00,-0.70726E+00,&
     -0.70744E+00,-0.70763E+00,-0.70782E+00,-0.70801E+00,-0.70819E+00,&
     -0.70838E+00,-0.70856E+00,-0.70874E+00,-0.70893E+00,-0.70911E+00,&
     -0.70929E+00,-0.70947E+00,-0.70965E+00,-0.70983E+00,-0.71001E+00,&
     -0.71018E+00,-0.71036E+00,-0.71054E+00,-0.71071E+00,-0.71089E+00,&
     -0.71106E+00,-0.71123E+00,-0.71141E+00,-0.71158E+00,-0.71175E+00,&
     -0.71192E+00,-0.71209E+00,-0.71226E+00,-0.71243E+00,-0.71259E+00,&
     -0.71276E+00,-0.71293E+00,-0.71309E+00,-0.71326E+00,-0.71342E+00,&
     -0.71359E+00,-0.71375E+00,-0.71391E+00,-0.71407E+00,-0.71423E+00,&
     -0.71439E+00,-0.71455E+00,-0.71471E+00,-0.71487E+00,-0.71503E+00,&
     -0.71519E+00,-0.71534E+00,-0.71550E+00,-0.71565E+00,-0.71581E+00,&
     -0.71596E+00,-0.71611E+00,-0.71627E+00,-0.71642E+00,-0.71698E+00/
                             
     DATA (BNC05M (IA),IA=601,700)/                                     &
     -0.71819E+00,-0.71960E+00,-0.72096E+00,-0.72225E+00,-0.72349E+00,&
     -0.72467E+00,-0.72581E+00,-0.72689E+00,-0.72792E+00,-0.72891E+00,&
     -0.72985E+00,-0.73074E+00,-0.73159E+00,-0.73240E+00,-0.73316E+00,&
     -0.73389E+00,-0.73457E+00,-0.73522E+00,-0.73583E+00,-0.73640E+00,&
     -0.73694E+00,-0.73744E+00,-0.73791E+00,-0.73835E+00,-0.73875E+00,&
     -0.73912E+00,-0.73947E+00,-0.73978E+00,-0.74006E+00,-0.74032E+00,&
     -0.74055E+00,-0.74075E+00,-0.74093E+00,-0.74107E+00,-0.74120E+00,&
     -0.74130E+00,-0.74137E+00,-0.74142E+00,-0.74145E+00,-0.74146E+00,&
     -0.74144E+00,-0.74141E+00,-0.74135E+00,-0.74127E+00,-0.74117E+00,&
     -0.74105E+00,-0.74092E+00,-0.74076E+00,-0.74058E+00,-0.74039E+00,&
     -0.74018E+00,-0.73995E+00,-0.73971E+00,-0.73945E+00,-0.73917E+00,&
     -0.73887E+00,-0.73856E+00,-0.73824E+00,-0.73790E+00,-0.73754E+00,&
     -0.73717E+00,-0.73679E+00,-0.73639E+00,-0.73598E+00,-0.73555E+00,&
     -0.73512E+00,-0.73466E+00,-0.73420E+00,-0.73372E+00,-0.73324E+00,&
     -0.73273E+00,-0.73222E+00,-0.73170E+00,-0.73116E+00,-0.73062E+00,&
     -0.73006E+00,-0.72949E+00,-0.72891E+00,-0.72832E+00,-0.72772E+00,&
     -0.72711E+00,-0.72649E+00,-0.72587E+00,-0.72523E+00,-0.72458E+00,&
     -0.72392E+00,-0.72325E+00,-0.72258E+00,-0.72190E+00,-0.72120E+00,&
     -0.72050E+00,-0.71979E+00,-0.71908E+00,-0.71835E+00,-0.71762E+00,&
     -0.71687E+00,-0.71613E+00,-0.71537E+00,-0.71460E+00,-0.71383E+00/
                             
     DATA (BNC05M(IA),IA=701,741)/                                      &
     -0.71305E+00,-0.71227E+00,-0.71148E+00,-0.71068E+00,-0.70987E+00,&
     -0.70906E+00,-0.70824E+00,-0.70741E+00,-0.70658E+00,-0.70574E+00,&
     -0.70490E+00,-0.70404E+00,-0.70319E+00,-0.70232E+00,-0.70146E+00,&
     -0.70058E+00,-0.69970E+00,-0.69882E+00,-0.69792E+00,-0.69703E+00,&
     -0.69613E+00,-0.69522E+00,-0.69431E+00,-0.69339E+00,-0.69247E+00,&
     -0.69154E+00,-0.69061E+00,-0.68967E+00,-0.68873E+00,-0.68778E+00,&
     -0.68683E+00,-0.68588E+00,-0.68492E+00,-0.68395E+00,-0.68298E+00,&
     -0.68201E+00,-0.68103E+00,-0.68005E+00,-0.67907E+00,-0.67808E+00,&
     -0.67708E+00                  /                      
!                            
!  ** NH4Cl                  
!                            
     DATA (BNC06M (IA),IA=  1,100)/                                     &
     -0.49530E-01,-0.88966E-01,-0.11577E+00,-0.13342E+00,-0.14661E+00,&
     -0.15709E+00,-0.16574E+00,-0.17306E+00,-0.17936E+00,-0.18486E+00,&
     -0.18971E+00,-0.19402E+00,-0.19789E+00,-0.20137E+00,-0.20452E+00,&
     -0.20738E+00,-0.20999E+00,-0.21238E+00,-0.21457E+00,-0.21658E+00,&
     -0.21843E+00,-0.22014E+00,-0.22171E+00,-0.22317E+00,-0.22451E+00,&
     -0.22576E+00,-0.22692E+00,-0.22799E+00,-0.22898E+00,-0.22990E+00,&
     -0.23075E+00,-0.23154E+00,-0.23228E+00,-0.23295E+00,-0.23358E+00,&
     -0.23417E+00,-0.23470E+00,-0.23520E+00,-0.23566E+00,-0.23608E+00,&
     -0.23647E+00,-0.23683E+00,-0.23716E+00,-0.23746E+00,-0.23773E+00,&
     -0.23797E+00,-0.23820E+00,-0.23840E+00,-0.23857E+00,-0.23873E+00,&
     -0.23887E+00,-0.23899E+00,-0.23909E+00,-0.23918E+00,-0.23925E+00,&
     -0.23930E+00,-0.23934E+00,-0.23936E+00,-0.23937E+00,-0.23936E+00,&
     -0.23935E+00,-0.23932E+00,-0.23927E+00,-0.23922E+00,-0.23915E+00,&
     -0.23907E+00,-0.23898E+00,-0.23888E+00,-0.23877E+00,-0.23864E+00,&
     -0.23851E+00,-0.23836E+00,-0.23821E+00,-0.23804E+00,-0.23787E+00,&
     -0.23768E+00,-0.23748E+00,-0.23727E+00,-0.23706E+00,-0.23683E+00,&
     -0.23659E+00,-0.23635E+00,-0.23609E+00,-0.23582E+00,-0.23555E+00,&
     -0.23526E+00,-0.23497E+00,-0.23466E+00,-0.23435E+00,-0.23403E+00,&
     -0.23370E+00,-0.23336E+00,-0.23302E+00,-0.23266E+00,-0.23230E+00,&
     -0.23193E+00,-0.23155E+00,-0.23116E+00,-0.23076E+00,-0.23036E+00/
                             
     DATA (BNC06M (IA),IA=101,200)/                                     &
     -0.22995E+00,-0.22954E+00,-0.22912E+00,-0.22869E+00,-0.22825E+00,&
     -0.22781E+00,-0.22737E+00,-0.22692E+00,-0.22646E+00,-0.22600E+00,&
     -0.22553E+00,-0.22506E+00,-0.22458E+00,-0.22410E+00,-0.22361E+00,&
     -0.22312E+00,-0.22263E+00,-0.22213E+00,-0.22163E+00,-0.22112E+00,&
     -0.22068E+00,-0.22017E+00,-0.21964E+00,-0.21912E+00,-0.21859E+00,&
     -0.21807E+00,-0.21754E+00,-0.21700E+00,-0.21647E+00,-0.21594E+00,&
     -0.21540E+00,-0.21486E+00,-0.21432E+00,-0.21378E+00,-0.21323E+00,&
     -0.21269E+00,-0.21214E+00,-0.21159E+00,-0.21104E+00,-0.21049E+00,&
     -0.20994E+00,-0.20939E+00,-0.20883E+00,-0.20828E+00,-0.20772E+00,&
     -0.20716E+00,-0.20660E+00,-0.20604E+00,-0.20548E+00,-0.20492E+00,&
     -0.20435E+00,-0.20379E+00,-0.20322E+00,-0.20266E+00,-0.20209E+00,&
     -0.20152E+00,-0.20096E+00,-0.20039E+00,-0.19982E+00,-0.19925E+00,&
     -0.19867E+00,-0.19810E+00,-0.19753E+00,-0.19696E+00,-0.19638E+00,&
     -0.19581E+00,-0.19523E+00,-0.19466E+00,-0.19408E+00,-0.19351E+00,&
     -0.19293E+00,-0.19235E+00,-0.19177E+00,-0.19119E+00,-0.19062E+00,&
     -0.19004E+00,-0.18946E+00,-0.18888E+00,-0.18830E+00,-0.18772E+00,&
     -0.18714E+00,-0.18656E+00,-0.18597E+00,-0.18539E+00,-0.18481E+00,&
     -0.18423E+00,-0.18365E+00,-0.18306E+00,-0.18248E+00,-0.18190E+00,&
     -0.18131E+00,-0.18073E+00,-0.18015E+00,-0.17956E+00,-0.17898E+00,&
     -0.17840E+00,-0.17781E+00,-0.17723E+00,-0.17665E+00,-0.17606E+00/
                             
     DATA (BNC06M (IA),IA=201,300)/                                     &
     -0.17548E+00,-0.17489E+00,-0.17431E+00,-0.17372E+00,-0.17314E+00,&
     -0.17256E+00,-0.17197E+00,-0.17139E+00,-0.17080E+00,-0.17022E+00,&
     -0.16964E+00,-0.16905E+00,-0.16847E+00,-0.16788E+00,-0.16730E+00,&
     -0.16672E+00,-0.16613E+00,-0.16555E+00,-0.16496E+00,-0.16438E+00,&
     -0.16380E+00,-0.16321E+00,-0.16263E+00,-0.16205E+00,-0.16146E+00,&
     -0.16088E+00,-0.16030E+00,-0.15972E+00,-0.15913E+00,-0.15855E+00,&
     -0.15797E+00,-0.15739E+00,-0.15681E+00,-0.15622E+00,-0.15564E+00,&
     -0.15506E+00,-0.15448E+00,-0.15390E+00,-0.15332E+00,-0.15274E+00,&
     -0.15216E+00,-0.15158E+00,-0.15100E+00,-0.15042E+00,-0.14984E+00,&
     -0.14926E+00,-0.14868E+00,-0.14810E+00,-0.14752E+00,-0.14695E+00,&
     -0.14637E+00,-0.14579E+00,-0.14521E+00,-0.14464E+00,-0.14406E+00,&
     -0.14348E+00,-0.14291E+00,-0.14233E+00,-0.14175E+00,-0.14118E+00,&
     -0.14060E+00,-0.14003E+00,-0.13945E+00,-0.13888E+00,-0.13831E+00,&
     -0.13773E+00,-0.13716E+00,-0.13658E+00,-0.13601E+00,-0.13544E+00,&
     -0.13487E+00,-0.13429E+00,-0.13372E+00,-0.13315E+00,-0.13258E+00,&
     -0.13201E+00,-0.13144E+00,-0.13087E+00,-0.13030E+00,-0.12973E+00,&
     -0.12916E+00,-0.12859E+00,-0.12802E+00,-0.12746E+00,-0.12689E+00,&
     -0.12632E+00,-0.12575E+00,-0.12519E+00,-0.12462E+00,-0.12405E+00,&
     -0.12349E+00,-0.12292E+00,-0.12236E+00,-0.12179E+00,-0.12123E+00,&
     -0.12066E+00,-0.12010E+00,-0.11954E+00,-0.11897E+00,-0.11841E+00/
                             
     DATA (BNC06M (IA),IA=301,400)/                                     &
     -0.11785E+00,-0.11729E+00,-0.11672E+00,-0.11616E+00,-0.11560E+00,&
     -0.11504E+00,-0.11448E+00,-0.11392E+00,-0.11336E+00,-0.11280E+00,&
     -0.11224E+00,-0.11169E+00,-0.11113E+00,-0.11057E+00,-0.11001E+00,&
     -0.10945E+00,-0.10890E+00,-0.10834E+00,-0.10779E+00,-0.10723E+00,&
     -0.10668E+00,-0.10612E+00,-0.10557E+00,-0.10501E+00,-0.10446E+00,&
     -0.10391E+00,-0.10335E+00,-0.10280E+00,-0.10225E+00,-0.10170E+00,&
     -0.10114E+00,-0.10059E+00,-0.10004E+00,-0.99493E-01,-0.98943E-01,&
     -0.98393E-01,-0.97844E-01,-0.97295E-01,-0.96747E-01,-0.96199E-01,&
     -0.95651E-01,-0.95104E-01,-0.94557E-01,-0.94010E-01,-0.93464E-01,&
     -0.92918E-01,-0.92373E-01,-0.91828E-01,-0.91283E-01,-0.90739E-01,&
     -0.90195E-01,-0.89652E-01,-0.89109E-01,-0.88566E-01,-0.88023E-01,&
     -0.87481E-01,-0.86940E-01,-0.86399E-01,-0.85858E-01,-0.85317E-01,&
     -0.84777E-01,-0.84238E-01,-0.83698E-01,-0.83159E-01,-0.82621E-01,&
     -0.82083E-01,-0.81545E-01,-0.81007E-01,-0.80470E-01,-0.79934E-01,&
     -0.79397E-01,-0.78861E-01,-0.78326E-01,-0.77791E-01,-0.77256E-01,&
     -0.76722E-01,-0.76188E-01,-0.75654E-01,-0.75121E-01,-0.74588E-01,&
     -0.74055E-01,-0.73523E-01,-0.72992E-01,-0.72460E-01,-0.71929E-01,&
     -0.71399E-01,-0.70868E-01,-0.70339E-01,-0.69809E-01,-0.69280E-01,&
     -0.68751E-01,-0.68223E-01,-0.67695E-01,-0.67167E-01,-0.66640E-01,&
     -0.66113E-01,-0.65587E-01,-0.65061E-01,-0.64535E-01,-0.64010E-01/
                             
     DATA (BNC06M (IA),IA=401,500)/                                     &
     -0.63485E-01,-0.62960E-01,-0.62436E-01,-0.61912E-01,-0.61389E-01,&
     -0.60866E-01,-0.60343E-01,-0.59821E-01,-0.59299E-01,-0.58777E-01,&
     -0.58256E-01,-0.57735E-01,-0.57214E-01,-0.56694E-01,-0.56174E-01,&
     -0.55655E-01,-0.55136E-01,-0.54617E-01,-0.54099E-01,-0.53581E-01,&
     -0.53064E-01,-0.52547E-01,-0.52030E-01,-0.51513E-01,-0.50997E-01,&
     -0.50482E-01,-0.49966E-01,-0.49451E-01,-0.48937E-01,-0.48422E-01,&
     -0.47908E-01,-0.47395E-01,-0.46882E-01,-0.46369E-01,-0.45857E-01,&
     -0.45345E-01,-0.44833E-01,-0.44321E-01,-0.43811E-01,-0.43300E-01,&
     -0.42790E-01,-0.42280E-01,-0.41770E-01,-0.41261E-01,-0.40752E-01,&
     -0.40244E-01,-0.39736E-01,-0.39228E-01,-0.38720E-01,-0.38213E-01,&
     -0.37707E-01,-0.37200E-01,-0.36694E-01,-0.36189E-01,-0.35684E-01,&
     -0.35179E-01,-0.34674E-01,-0.34170E-01,-0.33666E-01,-0.33163E-01,&
     -0.32659E-01,-0.32157E-01,-0.31654E-01,-0.31152E-01,-0.30650E-01,&
     -0.30149E-01,-0.29648E-01,-0.29147E-01,-0.28647E-01,-0.28147E-01,&
     -0.27647E-01,-0.27148E-01,-0.26649E-01,-0.26150E-01,-0.25652E-01,&
     -0.25154E-01,-0.24657E-01,-0.24159E-01,-0.23662E-01,-0.23166E-01,&
     -0.22670E-01,-0.22174E-01,-0.21678E-01,-0.21183E-01,-0.20688E-01,&
     -0.20194E-01,-0.19700E-01,-0.19206E-01,-0.18712E-01,-0.18219E-01,&
     -0.17726E-01,-0.17234E-01,-0.16742E-01,-0.16250E-01,-0.15758E-01,&
     -0.15267E-01,-0.14777E-01,-0.14286E-01,-0.13796E-01,-0.13306E-01/
                             
     DATA (BNC06M (IA),IA=501,600)/                                     &
     -0.12817E-01,-0.12328E-01,-0.11839E-01,-0.11350E-01,-0.10862E-01,&
     -0.10374E-01,-0.98870E-02,-0.93998E-02,-0.89130E-02,-0.84266E-02,&
     -0.79404E-02,-0.74546E-02,-0.69691E-02,-0.64839E-02,-0.59991E-02,&
     -0.55146E-02,-0.50304E-02,-0.45465E-02,-0.40630E-02,-0.35797E-02,&
     -0.30969E-02,-0.26142E-02,-0.21320E-02,-0.16501E-02,-0.11685E-02,&
     -0.68724E-03,-0.20627E-03, 0.27439E-03, 0.75471E-03, 0.12347E-02,&
      0.17144E-02, 0.21938E-02, 0.26728E-02, 0.31515E-02, 0.36300E-02,&
      0.41080E-02, 0.45858E-02, 0.50633E-02, 0.55405E-02, 0.60173E-02,&
      0.64938E-02, 0.69700E-02, 0.74459E-02, 0.79215E-02, 0.83968E-02,&
      0.88718E-02, 0.93464E-02, 0.98208E-02, 0.10295E-01, 0.10768E-01,&
      0.11242E-01, 0.11715E-01, 0.12188E-01, 0.12660E-01, 0.13132E-01,&
      0.13604E-01, 0.14076E-01, 0.14547E-01, 0.15018E-01, 0.15489E-01,&
      0.15959E-01, 0.16429E-01, 0.16899E-01, 0.17368E-01, 0.17837E-01,&
      0.18306E-01, 0.18775E-01, 0.19243E-01, 0.19711E-01, 0.20179E-01,&
      0.20646E-01, 0.21113E-01, 0.21580E-01, 0.22046E-01, 0.22512E-01,&
      0.22978E-01, 0.23444E-01, 0.23909E-01, 0.24374E-01, 0.24838E-01,&
      0.25303E-01, 0.25767E-01, 0.26231E-01, 0.26694E-01, 0.27157E-01,&
      0.27620E-01, 0.28083E-01, 0.28545E-01, 0.29007E-01, 0.29469E-01,&
      0.29930E-01, 0.30391E-01, 0.30852E-01, 0.31313E-01, 0.31773E-01,&
      0.32233E-01, 0.32693E-01, 0.33152E-01, 0.33611E-01, 0.35330E-01/
                             
     DATA (BNC06M (IA),IA=601,700)/                                     &
      0.39099E-01, 0.43640E-01, 0.48154E-01, 0.52641E-01, 0.57101E-01,&
      0.61535E-01, 0.65943E-01, 0.70325E-01, 0.74682E-01, 0.79014E-01,&
      0.83322E-01, 0.87606E-01, 0.91866E-01, 0.96102E-01, 0.10032E+00,&
      0.10451E+00, 0.10868E+00, 0.11282E+00, 0.11695E+00, 0.12105E+00,&
      0.12514E+00, 0.12920E+00, 0.13324E+00, 0.13726E+00, 0.14127E+00,&
      0.14525E+00, 0.14921E+00, 0.15316E+00, 0.15709E+00, 0.16099E+00,&
      0.16488E+00, 0.16876E+00, 0.17261E+00, 0.17645E+00, 0.18027E+00,&
      0.18407E+00, 0.18786E+00, 0.19163E+00, 0.19538E+00, 0.19912E+00,&
      0.20284E+00, 0.20655E+00, 0.21024E+00, 0.21391E+00, 0.21757E+00,&
      0.22122E+00, 0.22485E+00, 0.22847E+00, 0.23207E+00, 0.23566E+00,&
      0.23924E+00, 0.24280E+00, 0.24634E+00, 0.24988E+00, 0.25340E+00,&
      0.25691E+00, 0.26040E+00, 0.26389E+00, 0.26735E+00, 0.27081E+00,&
      0.27426E+00, 0.27769E+00, 0.28111E+00, 0.28452E+00, 0.28792E+00,&
      0.29130E+00, 0.29468E+00, 0.29804E+00, 0.30139E+00, 0.30473E+00,&
      0.30806E+00, 0.31138E+00, 0.31469E+00, 0.31799E+00, 0.32127E+00,&
      0.32455E+00, 0.32782E+00, 0.33107E+00, 0.33432E+00, 0.33756E+00,&
      0.34078E+00, 0.34400E+00, 0.34721E+00, 0.35040E+00, 0.35359E+00,&
      0.35677E+00, 0.35994E+00, 0.36310E+00, 0.36625E+00, 0.36940E+00,&
      0.37253E+00, 0.37565E+00, 0.37877E+00, 0.38188E+00, 0.38498E+00,&
      0.38807E+00, 0.39115E+00, 0.39422E+00, 0.39729E+00, 0.40035E+00/
                             
     DATA (BNC06M(IA),IA=701,741)/                                      &
      0.40340E+00, 0.40644E+00, 0.40947E+00, 0.41250E+00, 0.41552E+00,&
      0.41853E+00, 0.42153E+00, 0.42453E+00, 0.42752E+00, 0.43050E+00,&
      0.43347E+00, 0.43644E+00, 0.43939E+00, 0.44235E+00, 0.44529E+00,&
      0.44823E+00, 0.45116E+00, 0.45408E+00, 0.45700E+00, 0.45991E+00,&
      0.46281E+00, 0.46571E+00, 0.46860E+00, 0.47148E+00, 0.47436E+00,&
      0.47723E+00, 0.48010E+00, 0.48296E+00, 0.48581E+00, 0.48865E+00,&
      0.49149E+00, 0.49433E+00, 0.49715E+00, 0.49998E+00, 0.50279E+00,&
      0.50560E+00, 0.50840E+00, 0.51120E+00, 0.51399E+00, 0.51678E+00,&
      0.51956E+00                  /                      
!                            
!  ** (2H, SO4)              
!                            
     DATA (BNC07M (IA),IA=  1,100)/                                     &
     -0.10013E+00,-0.18189E+00,-0.23903E+00,-0.27766E+00,-0.30724E+00,&
     -0.33132E+00,-0.35165E+00,-0.36925E+00,-0.38476E+00,-0.39862E+00,&
     -0.41114E+00,-0.42256E+00,-0.43303E+00,-0.44271E+00,-0.45169E+00,&
     -0.46007E+00,-0.46792E+00,-0.47529E+00,-0.48224E+00,-0.48881E+00,&
     -0.49504E+00,-0.50095E+00,-0.50658E+00,-0.51195E+00,-0.51707E+00,&
     -0.52197E+00,-0.52667E+00,-0.53118E+00,-0.53551E+00,-0.53967E+00,&
     -0.54368E+00,-0.54754E+00,-0.55127E+00,-0.55486E+00,-0.55834E+00,&
     -0.56170E+00,-0.56495E+00,-0.56811E+00,-0.57116E+00,-0.57412E+00,&
     -0.57699E+00,-0.57978E+00,-0.58249E+00,-0.58513E+00,-0.58769E+00,&
     -0.59018E+00,-0.59261E+00,-0.59497E+00,-0.59727E+00,-0.59951E+00,&
     -0.60169E+00,-0.60383E+00,-0.60591E+00,-0.60794E+00,-0.60992E+00,&
     -0.61185E+00,-0.61374E+00,-0.61559E+00,-0.61740E+00,-0.61916E+00,&
     -0.62089E+00,-0.62258E+00,-0.62424E+00,-0.62586E+00,-0.62744E+00,&
     -0.62900E+00,-0.63052E+00,-0.63201E+00,-0.63347E+00,-0.63490E+00,&
     -0.63631E+00,-0.63769E+00,-0.63904E+00,-0.64037E+00,-0.64167E+00,&
     -0.64295E+00,-0.64420E+00,-0.64544E+00,-0.64665E+00,-0.64784E+00,&
     -0.64901E+00,-0.65016E+00,-0.65129E+00,-0.65240E+00,-0.65350E+00,&
     -0.65457E+00,-0.65563E+00,-0.65667E+00,-0.65770E+00,-0.65871E+00,&
     -0.65970E+00,-0.66068E+00,-0.66164E+00,-0.66259E+00,-0.66352E+00,&
     -0.66444E+00,-0.66535E+00,-0.66624E+00,-0.66712E+00,-0.66799E+00/
                             
     DATA (BNC07M (IA),IA=101,200)/                                     &
     -0.66884E+00,-0.66968E+00,-0.67051E+00,-0.67133E+00,-0.67214E+00,&
     -0.67293E+00,-0.67372E+00,-0.67449E+00,-0.67525E+00,-0.67600E+00,&
     -0.67674E+00,-0.67748E+00,-0.67820E+00,-0.67891E+00,-0.67961E+00,&
     -0.68030E+00,-0.68098E+00,-0.68165E+00,-0.68232E+00,-0.68297E+00,&
     -0.68360E+00,-0.68424E+00,-0.68487E+00,-0.68549E+00,-0.68610E+00,&
     -0.68671E+00,-0.68731E+00,-0.68789E+00,-0.68848E+00,-0.68905E+00,&
     -0.68961E+00,-0.69017E+00,-0.69072E+00,-0.69126E+00,-0.69180E+00,&
     -0.69233E+00,-0.69285E+00,-0.69336E+00,-0.69387E+00,-0.69437E+00,&
     -0.69487E+00,-0.69536E+00,-0.69584E+00,-0.69631E+00,-0.69678E+00,&
     -0.69724E+00,-0.69770E+00,-0.69815E+00,-0.69860E+00,-0.69904E+00,&
     -0.69947E+00,-0.69990E+00,-0.70032E+00,-0.70074E+00,-0.70115E+00,&
     -0.70156E+00,-0.70196E+00,-0.70235E+00,-0.70274E+00,-0.70313E+00,&
     -0.70351E+00,-0.70389E+00,-0.70426E+00,-0.70463E+00,-0.70499E+00,&
     -0.70534E+00,-0.70570E+00,-0.70604E+00,-0.70639E+00,-0.70673E+00,&
     -0.70706E+00,-0.70739E+00,-0.70772E+00,-0.70804E+00,-0.70836E+00,&
     -0.70867E+00,-0.70898E+00,-0.70928E+00,-0.70958E+00,-0.70988E+00,&
     -0.71018E+00,-0.71047E+00,-0.71075E+00,-0.71103E+00,-0.71131E+00,&
     -0.71159E+00,-0.71186E+00,-0.71213E+00,-0.71239E+00,-0.71265E+00,&
     -0.71291E+00,-0.71316E+00,-0.71341E+00,-0.71366E+00,-0.71390E+00,&
     -0.71414E+00,-0.71438E+00,-0.71461E+00,-0.71484E+00,-0.71507E+00/
                             
     DATA (BNC07M (IA),IA=201,300)/                                     &
     -0.71529E+00,-0.71552E+00,-0.71573E+00,-0.71595E+00,-0.71616E+00,&
     -0.71637E+00,-0.71658E+00,-0.71678E+00,-0.71698E+00,-0.71718E+00,&
     -0.71737E+00,-0.71757E+00,-0.71776E+00,-0.71794E+00,-0.71813E+00,&
     -0.71831E+00,-0.71849E+00,-0.71866E+00,-0.71884E+00,-0.71901E+00,&
     -0.71918E+00,-0.71934E+00,-0.71950E+00,-0.71967E+00,-0.71982E+00,&
     -0.71998E+00,-0.72013E+00,-0.72029E+00,-0.72043E+00,-0.72058E+00,&
     -0.72073E+00,-0.72087E+00,-0.72101E+00,-0.72114E+00,-0.72128E+00,&
     -0.72141E+00,-0.72154E+00,-0.72167E+00,-0.72180E+00,-0.72192E+00,&
     -0.72205E+00,-0.72217E+00,-0.72228E+00,-0.72240E+00,-0.72251E+00,&
     -0.72263E+00,-0.72274E+00,-0.72284E+00,-0.72295E+00,-0.72305E+00,&
     -0.72316E+00,-0.72326E+00,-0.72335E+00,-0.72345E+00,-0.72355E+00,&
     -0.72364E+00,-0.72373E+00,-0.72382E+00,-0.72391E+00,-0.72399E+00,&
     -0.72407E+00,-0.72416E+00,-0.72424E+00,-0.72432E+00,-0.72439E+00,&
     -0.72447E+00,-0.72454E+00,-0.72461E+00,-0.72468E+00,-0.72475E+00,&
     -0.72482E+00,-0.72488E+00,-0.72494E+00,-0.72501E+00,-0.72507E+00,&
     -0.72513E+00,-0.72518E+00,-0.72524E+00,-0.72529E+00,-0.72534E+00,&
     -0.72539E+00,-0.72544E+00,-0.72549E+00,-0.72554E+00,-0.72558E+00,&
     -0.72563E+00,-0.72567E+00,-0.72571E+00,-0.72575E+00,-0.72579E+00,&
     -0.72582E+00,-0.72586E+00,-0.72589E+00,-0.72592E+00,-0.72595E+00,&
     -0.72598E+00,-0.72601E+00,-0.72604E+00,-0.72606E+00,-0.72609E+00/
                             
     DATA (BNC07M (IA),IA=301,400)/                                     &
     -0.72611E+00,-0.72613E+00,-0.72615E+00,-0.72617E+00,-0.72619E+00,&
     -0.72620E+00,-0.72622E+00,-0.72623E+00,-0.72624E+00,-0.72626E+00,&
     -0.72627E+00,-0.72627E+00,-0.72628E+00,-0.72629E+00,-0.72629E+00,&
     -0.72630E+00,-0.72630E+00,-0.72630E+00,-0.72630E+00,-0.72630E+00,&
     -0.72630E+00,-0.72630E+00,-0.72629E+00,-0.72629E+00,-0.72628E+00,&
     -0.72628E+00,-0.72627E+00,-0.72626E+00,-0.72625E+00,-0.72624E+00,&
     -0.72622E+00,-0.72621E+00,-0.72619E+00,-0.72618E+00,-0.72616E+00,&
     -0.72614E+00,-0.72612E+00,-0.72610E+00,-0.72608E+00,-0.72606E+00,&
     -0.72604E+00,-0.72601E+00,-0.72599E+00,-0.72596E+00,-0.72594E+00,&
     -0.72591E+00,-0.72588E+00,-0.72585E+00,-0.72582E+00,-0.72579E+00,&
     -0.72575E+00,-0.72572E+00,-0.72569E+00,-0.72565E+00,-0.72561E+00,&
     -0.72558E+00,-0.72554E+00,-0.72550E+00,-0.72546E+00,-0.72542E+00,&
     -0.72538E+00,-0.72533E+00,-0.72529E+00,-0.72524E+00,-0.72520E+00,&
     -0.72515E+00,-0.72511E+00,-0.72506E+00,-0.72501E+00,-0.72496E+00,&
     -0.72491E+00,-0.72486E+00,-0.72481E+00,-0.72475E+00,-0.72470E+00,&
     -0.72464E+00,-0.72459E+00,-0.72453E+00,-0.72448E+00,-0.72442E+00,&
     -0.72436E+00,-0.72430E+00,-0.72424E+00,-0.72418E+00,-0.72412E+00,&
     -0.72406E+00,-0.72399E+00,-0.72393E+00,-0.72386E+00,-0.72380E+00,&
     -0.72373E+00,-0.72367E+00,-0.72360E+00,-0.72353E+00,-0.72346E+00,&
     -0.72339E+00,-0.72332E+00,-0.72325E+00,-0.72318E+00,-0.72310E+00/
                             
     DATA (BNC07M (IA),IA=401,500)/                                     &
     -0.72303E+00,-0.72296E+00,-0.72288E+00,-0.72281E+00,-0.72273E+00,&
     -0.72265E+00,-0.72258E+00,-0.72250E+00,-0.72242E+00,-0.72234E+00,&
     -0.72226E+00,-0.72218E+00,-0.72210E+00,-0.72201E+00,-0.72193E+00,&
     -0.72185E+00,-0.72176E+00,-0.72168E+00,-0.72159E+00,-0.72151E+00,&
     -0.72142E+00,-0.72133E+00,-0.72124E+00,-0.72116E+00,-0.72107E+00,&
     -0.72098E+00,-0.72089E+00,-0.72080E+00,-0.72070E+00,-0.72061E+00,&
     -0.72052E+00,-0.72042E+00,-0.72033E+00,-0.72024E+00,-0.72014E+00,&
     -0.72004E+00,-0.71995E+00,-0.71985E+00,-0.71975E+00,-0.71966E+00,&
     -0.71956E+00,-0.71946E+00,-0.71936E+00,-0.71926E+00,-0.71916E+00,&
     -0.71905E+00,-0.71895E+00,-0.71885E+00,-0.71875E+00,-0.71864E+00,&
     -0.71854E+00,-0.71843E+00,-0.71833E+00,-0.71822E+00,-0.71812E+00,&
     -0.71801E+00,-0.71790E+00,-0.71779E+00,-0.71768E+00,-0.71758E+00,&
     -0.71747E+00,-0.71736E+00,-0.71724E+00,-0.71713E+00,-0.71702E+00,&
     -0.71691E+00,-0.71680E+00,-0.71668E+00,-0.71657E+00,-0.71646E+00,&
     -0.71634E+00,-0.71623E+00,-0.71611E+00,-0.71599E+00,-0.71588E+00,&
     -0.71576E+00,-0.71564E+00,-0.71552E+00,-0.71541E+00,-0.71529E+00,&
     -0.71517E+00,-0.71505E+00,-0.71493E+00,-0.71481E+00,-0.71468E+00,&
     -0.71456E+00,-0.71444E+00,-0.71432E+00,-0.71419E+00,-0.71407E+00,&
     -0.71395E+00,-0.71382E+00,-0.71370E+00,-0.71357E+00,-0.71345E+00,&
     -0.71332E+00,-0.71319E+00,-0.71307E+00,-0.71294E+00,-0.71281E+00/
                             
     DATA (BNC07M (IA),IA=501,600)/                                     &
     -0.71268E+00,-0.71255E+00,-0.71242E+00,-0.71229E+00,-0.71216E+00,&
     -0.71203E+00,-0.71190E+00,-0.71177E+00,-0.71164E+00,-0.71150E+00,&
     -0.71137E+00,-0.71124E+00,-0.71111E+00,-0.71097E+00,-0.71084E+00,&
     -0.71070E+00,-0.71057E+00,-0.71043E+00,-0.71030E+00,-0.71016E+00,&
     -0.71002E+00,-0.70988E+00,-0.70975E+00,-0.70961E+00,-0.70947E+00,&
     -0.70933E+00,-0.70919E+00,-0.70905E+00,-0.70891E+00,-0.70877E+00,&
     -0.70863E+00,-0.70849E+00,-0.70835E+00,-0.70821E+00,-0.70807E+00,&
     -0.70792E+00,-0.70778E+00,-0.70764E+00,-0.70749E+00,-0.70735E+00,&
     -0.70721E+00,-0.70706E+00,-0.70692E+00,-0.70677E+00,-0.70662E+00,&
     -0.70648E+00,-0.70633E+00,-0.70618E+00,-0.70604E+00,-0.70589E+00,&
     -0.70574E+00,-0.70559E+00,-0.70544E+00,-0.70530E+00,-0.70515E+00,&
     -0.70500E+00,-0.70485E+00,-0.70470E+00,-0.70455E+00,-0.70439E+00,&
     -0.70424E+00,-0.70409E+00,-0.70394E+00,-0.70379E+00,-0.70363E+00,&
     -0.70348E+00,-0.70333E+00,-0.70317E+00,-0.70302E+00,-0.70287E+00,&
     -0.70271E+00,-0.70256E+00,-0.70240E+00,-0.70225E+00,-0.70209E+00,&
     -0.70193E+00,-0.70178E+00,-0.70162E+00,-0.70146E+00,-0.70131E+00,&
     -0.70115E+00,-0.70099E+00,-0.70083E+00,-0.70067E+00,-0.70051E+00,&
     -0.70035E+00,-0.70019E+00,-0.70003E+00,-0.69987E+00,-0.69971E+00,&
     -0.69955E+00,-0.69939E+00,-0.69923E+00,-0.69907E+00,-0.69891E+00,&
     -0.69874E+00,-0.69858E+00,-0.69842E+00,-0.69826E+00,-0.69764E+00/
                             
     DATA (BNC07M (IA),IA=601,700)/                                     &
     -0.69627E+00,-0.69459E+00,-0.69289E+00,-0.69115E+00,-0.68939E+00,&
     -0.68761E+00,-0.68581E+00,-0.68398E+00,-0.68213E+00,-0.68026E+00,&
     -0.67837E+00,-0.67646E+00,-0.67453E+00,-0.67259E+00,-0.67062E+00,&
     -0.66864E+00,-0.66664E+00,-0.66463E+00,-0.66260E+00,-0.66055E+00,&
     -0.65849E+00,-0.65641E+00,-0.65433E+00,-0.65222E+00,-0.65011E+00,&
     -0.64798E+00,-0.64584E+00,-0.64368E+00,-0.64152E+00,-0.63934E+00,&
     -0.63715E+00,-0.63495E+00,-0.63274E+00,-0.63052E+00,-0.62829E+00,&
     -0.62605E+00,-0.62380E+00,-0.62154E+00,-0.61927E+00,-0.61700E+00,&
     -0.61471E+00,-0.61242E+00,-0.61011E+00,-0.60780E+00,-0.60548E+00,&
     -0.60316E+00,-0.60082E+00,-0.59848E+00,-0.59613E+00,-0.59378E+00,&
     -0.59141E+00,-0.58904E+00,-0.58667E+00,-0.58428E+00,-0.58189E+00,&
     -0.57950E+00,-0.57710E+00,-0.57469E+00,-0.57228E+00,-0.56986E+00,&
     -0.56743E+00,-0.56500E+00,-0.56257E+00,-0.56013E+00,-0.55768E+00,&
     -0.55523E+00,-0.55278E+00,-0.55032E+00,-0.54785E+00,-0.54538E+00,&
     -0.54291E+00,-0.54043E+00,-0.53795E+00,-0.53546E+00,-0.53297E+00,&
     -0.53047E+00,-0.52797E+00,-0.52547E+00,-0.52296E+00,-0.52045E+00,&
     -0.51793E+00,-0.51541E+00,-0.51289E+00,-0.51037E+00,-0.50784E+00,&
     -0.50530E+00,-0.50277E+00,-0.50023E+00,-0.49769E+00,-0.49514E+00,&
     -0.49259E+00,-0.49004E+00,-0.48749E+00,-0.48493E+00,-0.48237E+00,&
     -0.47980E+00,-0.47724E+00,-0.47467E+00,-0.47210E+00,-0.46952E+00/
                             
     DATA (BNC07M(IA),IA=701,741)/                                      &
     -0.46694E+00,-0.46436E+00,-0.46178E+00,-0.45920E+00,-0.45661E+00,&
     -0.45402E+00,-0.45143E+00,-0.44884E+00,-0.44624E+00,-0.44364E+00,&
     -0.44104E+00,-0.43844E+00,-0.43583E+00,-0.43322E+00,-0.43062E+00,&
     -0.42800E+00,-0.42539E+00,-0.42278E+00,-0.42016E+00,-0.41754E+00,&
     -0.41492E+00,-0.41230E+00,-0.40967E+00,-0.40704E+00,-0.40442E+00,&
     -0.40179E+00,-0.39916E+00,-0.39652E+00,-0.39389E+00,-0.39125E+00,&
     -0.38861E+00,-0.38597E+00,-0.38333E+00,-0.38069E+00,-0.37805E+00,&
     -0.37540E+00,-0.37275E+00,-0.37010E+00,-0.36746E+00,-0.36480E+00,&
     -0.36215E+00                  /                      
!                            
!  ** (H, HSO4)              
!                            
     DATA (BNC08M (IA),IA=  1,100)/                                     &
     -0.47223E-01,-0.81099E-01,-0.10165E+00,-0.11366E+00,-0.12158E+00,&
     -0.12700E+00,-0.13074E+00,-0.13324E+00,-0.13478E+00,-0.13555E+00,&
     -0.13569E+00,-0.13529E+00,-0.13443E+00,-0.13316E+00,-0.13154E+00,&
     -0.12959E+00,-0.12735E+00,-0.12484E+00,-0.12208E+00,-0.11910E+00,&
     -0.11591E+00,-0.11252E+00,-0.10894E+00,-0.10519E+00,-0.10128E+00,&
     -0.97205E-01,-0.92986E-01,-0.88626E-01,-0.84132E-01,-0.79512E-01,&
     -0.74769E-01,-0.69911E-01,-0.64942E-01,-0.59867E-01,-0.54691E-01,&
     -0.49419E-01,-0.44054E-01,-0.38600E-01,-0.33062E-01,-0.27442E-01,&
     -0.21746E-01,-0.15975E-01,-0.10133E-01,-0.42230E-02, 0.17517E-02,&
      0.77886E-02, 0.13885E-01, 0.20039E-01, 0.26247E-01, 0.32508E-01,&
      0.38819E-01, 0.45178E-01, 0.51584E-01, 0.58035E-01, 0.64529E-01,&
      0.71064E-01, 0.77640E-01, 0.84256E-01, 0.90910E-01, 0.97601E-01,&
      0.10433E+00, 0.11109E+00, 0.11789E+00, 0.12472E+00, 0.13159E+00,&
      0.13850E+00, 0.14543E+00, 0.15240E+00, 0.15941E+00, 0.16645E+00,&
      0.17353E+00, 0.18064E+00, 0.18778E+00, 0.19496E+00, 0.20218E+00,&
      0.20943E+00, 0.21672E+00, 0.22405E+00, 0.23142E+00, 0.23882E+00,&
      0.24627E+00, 0.25375E+00, 0.26127E+00, 0.26883E+00, 0.27643E+00,&
      0.28407E+00, 0.29175E+00, 0.29947E+00, 0.30724E+00, 0.31503E+00,&
      0.32287E+00, 0.33075E+00, 0.33867E+00, 0.34662E+00, 0.35461E+00,&
      0.36263E+00, 0.37069E+00, 0.37878E+00, 0.38691E+00, 0.39507E+00/
                             
     DATA (BNC08M (IA),IA=101,200)/                                     &
      0.40325E+00, 0.41147E+00, 0.41972E+00, 0.42799E+00, 0.43628E+00,&
      0.44460E+00, 0.45294E+00, 0.46130E+00, 0.46968E+00, 0.47808E+00,&
      0.48650E+00, 0.49492E+00, 0.50337E+00, 0.51182E+00, 0.52028E+00,&
      0.52875E+00, 0.53723E+00, 0.54572E+00, 0.55421E+00, 0.56270E+00,&
      0.57051E+00, 0.57908E+00, 0.58765E+00, 0.59621E+00, 0.60477E+00,&
      0.61331E+00, 0.62184E+00, 0.63037E+00, 0.63888E+00, 0.64739E+00,&
      0.65588E+00, 0.66436E+00, 0.67283E+00, 0.68130E+00, 0.68975E+00,&
      0.69818E+00, 0.70661E+00, 0.71502E+00, 0.72342E+00, 0.73181E+00,&
      0.74019E+00, 0.74855E+00, 0.75690E+00, 0.76524E+00, 0.77356E+00,&
      0.78187E+00, 0.79017E+00, 0.79845E+00, 0.80672E+00, 0.81497E+00,&
      0.82321E+00, 0.83144E+00, 0.83965E+00, 0.84785E+00, 0.85603E+00,&
      0.86420E+00, 0.87235E+00, 0.88049E+00, 0.88861E+00, 0.89672E+00,&
      0.90481E+00, 0.91289E+00, 0.92095E+00, 0.92900E+00, 0.93703E+00,&
      0.94505E+00, 0.95305E+00, 0.96103E+00, 0.96900E+00, 0.97696E+00,&
      0.98490E+00, 0.99282E+00, 0.10007E+01, 0.10086E+01, 0.10165E+01,&
      0.10244E+01, 0.10322E+01, 0.10400E+01, 0.10478E+01, 0.10556E+01,&
      0.10634E+01, 0.10712E+01, 0.10789E+01, 0.10867E+01, 0.10944E+01,&
      0.11021E+01, 0.11098E+01, 0.11175E+01, 0.11251E+01, 0.11328E+01,&
      0.11404E+01, 0.11480E+01, 0.11556E+01, 0.11632E+01, 0.11707E+01,&
      0.11783E+01, 0.11858E+01, 0.11933E+01, 0.12008E+01, 0.12083E+01/
                             
     DATA (BNC08M (IA),IA=201,300)/                                     &
      0.12158E+01, 0.12232E+01, 0.12307E+01, 0.12381E+01, 0.12455E+01,&
      0.12529E+01, 0.12603E+01, 0.12676E+01, 0.12750E+01, 0.12823E+01,&
      0.12896E+01, 0.12969E+01, 0.13042E+01, 0.13115E+01, 0.13187E+01,&
      0.13260E+01, 0.13332E+01, 0.13404E+01, 0.13476E+01, 0.13548E+01,&
      0.13619E+01, 0.13691E+01, 0.13762E+01, 0.13834E+01, 0.13905E+01,&
      0.13975E+01, 0.14046E+01, 0.14117E+01, 0.14187E+01, 0.14258E+01,&
      0.14328E+01, 0.14398E+01, 0.14468E+01, 0.14538E+01, 0.14607E+01,&
      0.14677E+01, 0.14746E+01, 0.14815E+01, 0.14884E+01, 0.14953E+01,&
      0.15022E+01, 0.15091E+01, 0.15159E+01, 0.15228E+01, 0.15296E+01,&
      0.15364E+01, 0.15432E+01, 0.15500E+01, 0.15567E+01, 0.15635E+01,&
      0.15702E+01, 0.15769E+01, 0.15837E+01, 0.15904E+01, 0.15970E+01,&
      0.16037E+01, 0.16104E+01, 0.16170E+01, 0.16237E+01, 0.16303E+01,&
      0.16369E+01, 0.16435E+01, 0.16501E+01, 0.16566E+01, 0.16632E+01,&
      0.16697E+01, 0.16763E+01, 0.16828E+01, 0.16893E+01, 0.16958E+01,&
      0.17022E+01, 0.17087E+01, 0.17152E+01, 0.17216E+01, 0.17280E+01,&
      0.17345E+01, 0.17409E+01, 0.17472E+01, 0.17536E+01, 0.17600E+01,&
      0.17663E+01, 0.17727E+01, 0.17790E+01, 0.17853E+01, 0.17916E+01,&
      0.17979E+01, 0.18042E+01, 0.18105E+01, 0.18167E+01, 0.18230E+01,&
      0.18292E+01, 0.18354E+01, 0.18416E+01, 0.18478E+01, 0.18540E+01,&
      0.18602E+01, 0.18664E+01, 0.18725E+01, 0.18787E+01, 0.18848E+01/
                             
     DATA (BNC08M (IA),IA=301,400)/                                     &
      0.18909E+01, 0.18970E+01, 0.19031E+01, 0.19092E+01, 0.19153E+01,&
      0.19213E+01, 0.19274E+01, 0.19334E+01, 0.19394E+01, 0.19455E+01,&
      0.19515E+01, 0.19575E+01, 0.19634E+01, 0.19694E+01, 0.19754E+01,&
      0.19813E+01, 0.19873E+01, 0.19932E+01, 0.19991E+01, 0.20050E+01,&
      0.20109E+01, 0.20168E+01, 0.20227E+01, 0.20286E+01, 0.20344E+01,&
      0.20403E+01, 0.20461E+01, 0.20519E+01, 0.20577E+01, 0.20635E+01,&
      0.20693E+01, 0.20751E+01, 0.20809E+01, 0.20866E+01, 0.20924E+01,&
      0.20981E+01, 0.21039E+01, 0.21096E+01, 0.21153E+01, 0.21210E+01,&
      0.21267E+01, 0.21324E+01, 0.21380E+01, 0.21437E+01, 0.21494E+01,&
      0.21550E+01, 0.21606E+01, 0.21663E+01, 0.21719E+01, 0.21775E+01,&
      0.21831E+01, 0.21887E+01, 0.21942E+01, 0.21998E+01, 0.22054E+01,&
      0.22109E+01, 0.22164E+01, 0.22220E+01, 0.22275E+01, 0.22330E+01,&
      0.22385E+01, 0.22440E+01, 0.22495E+01, 0.22549E+01, 0.22604E+01,&
      0.22658E+01, 0.22713E+01, 0.22767E+01, 0.22822E+01, 0.22876E+01,&
      0.22930E+01, 0.22984E+01, 0.23038E+01, 0.23092E+01, 0.23145E+01,&
      0.23199E+01, 0.23252E+01, 0.23306E+01, 0.23359E+01, 0.23413E+01,&
      0.23466E+01, 0.23519E+01, 0.23572E+01, 0.23625E+01, 0.23678E+01,&
      0.23730E+01, 0.23783E+01, 0.23836E+01, 0.23888E+01, 0.23941E+01,&
      0.23993E+01, 0.24045E+01, 0.24097E+01, 0.24150E+01, 0.24202E+01,&
      0.24254E+01, 0.24305E+01, 0.24357E+01, 0.24409E+01, 0.24460E+01/
                             
     DATA (BNC08M (IA),IA=401,500)/                                     &
      0.24512E+01, 0.24563E+01, 0.24615E+01, 0.24666E+01, 0.24717E+01,&
      0.24768E+01, 0.24819E+01, 0.24870E+01, 0.24921E+01, 0.24972E+01,&
      0.25023E+01, 0.25073E+01, 0.25124E+01, 0.25174E+01, 0.25225E+01,&
      0.25275E+01, 0.25325E+01, 0.25375E+01, 0.25426E+01, 0.25476E+01,&
      0.25526E+01, 0.25575E+01, 0.25625E+01, 0.25675E+01, 0.25725E+01,&
      0.25774E+01, 0.25824E+01, 0.25873E+01, 0.25922E+01, 0.25972E+01,&
      0.26021E+01, 0.26070E+01, 0.26119E+01, 0.26168E+01, 0.26217E+01,&
      0.26266E+01, 0.26314E+01, 0.26363E+01, 0.26412E+01, 0.26460E+01,&
      0.26509E+01, 0.26557E+01, 0.26605E+01, 0.26653E+01, 0.26702E+01,&
      0.26750E+01, 0.26798E+01, 0.26846E+01, 0.26894E+01, 0.26941E+01,&
      0.26989E+01, 0.27037E+01, 0.27084E+01, 0.27132E+01, 0.27179E+01,&
      0.27227E+01, 0.27274E+01, 0.27321E+01, 0.27369E+01, 0.27416E+01,&
      0.27463E+01, 0.27510E+01, 0.27557E+01, 0.27604E+01, 0.27650E+01,&
      0.27697E+01, 0.27744E+01, 0.27790E+01, 0.27837E+01, 0.27883E+01,&
      0.27930E+01, 0.27976E+01, 0.28022E+01, 0.28068E+01, 0.28115E+01,&
      0.28161E+01, 0.28207E+01, 0.28253E+01, 0.28298E+01, 0.28344E+01,&
      0.28390E+01, 0.28436E+01, 0.28481E+01, 0.28527E+01, 0.28572E+01,&
      0.28618E+01, 0.28663E+01, 0.28708E+01, 0.28754E+01, 0.28799E+01,&
      0.28844E+01, 0.28889E+01, 0.28934E+01, 0.28979E+01, 0.29024E+01,&
      0.29068E+01, 0.29113E+01, 0.29158E+01, 0.29203E+01, 0.29247E+01/
                             
     DATA (BNC08M (IA),IA=501,600)/                                     &
      0.29292E+01, 0.29336E+01, 0.29380E+01, 0.29425E+01, 0.29469E+01,&
      0.29513E+01, 0.29557E+01, 0.29601E+01, 0.29645E+01, 0.29689E+01,&
      0.29733E+01, 0.29777E+01, 0.29821E+01, 0.29865E+01, 0.29908E+01,&
      0.29952E+01, 0.29995E+01, 0.30039E+01, 0.30082E+01, 0.30126E+01,&
      0.30169E+01, 0.30212E+01, 0.30255E+01, 0.30299E+01, 0.30342E+01,&
      0.30385E+01, 0.30428E+01, 0.30471E+01, 0.30514E+01, 0.30556E+01,&
      0.30599E+01, 0.30642E+01, 0.30684E+01, 0.30727E+01, 0.30770E+01,&
      0.30812E+01, 0.30854E+01, 0.30897E+01, 0.30939E+01, 0.30981E+01,&
      0.31024E+01, 0.31066E+01, 0.31108E+01, 0.31150E+01, 0.31192E+01,&
      0.31234E+01, 0.31276E+01, 0.31317E+01, 0.31359E+01, 0.31401E+01,&
      0.31443E+01, 0.31484E+01, 0.31526E+01, 0.31567E+01, 0.31609E+01,&
      0.31650E+01, 0.31692E+01, 0.31733E+01, 0.31774E+01, 0.31815E+01,&
      0.31856E+01, 0.31898E+01, 0.31939E+01, 0.31980E+01, 0.32021E+01,&
      0.32061E+01, 0.32102E+01, 0.32143E+01, 0.32184E+01, 0.32224E+01,&
      0.32265E+01, 0.32306E+01, 0.32346E+01, 0.32387E+01, 0.32427E+01,&
      0.32468E+01, 0.32508E+01, 0.32548E+01, 0.32588E+01, 0.32629E+01,&
      0.32669E+01, 0.32709E+01, 0.32749E+01, 0.32789E+01, 0.32829E+01,&
      0.32869E+01, 0.32909E+01, 0.32948E+01, 0.32988E+01, 0.33028E+01,&
      0.33068E+01, 0.33107E+01, 0.33147E+01, 0.33186E+01, 0.33226E+01,&
      0.33265E+01, 0.33304E+01, 0.33344E+01, 0.33383E+01, 0.33530E+01/
                             
     DATA (BNC08M (IA),IA=601,700)/                                     &
      0.33851E+01, 0.34236E+01, 0.34616E+01, 0.34992E+01, 0.35364E+01,&
      0.35732E+01, 0.36095E+01, 0.36455E+01, 0.36811E+01, 0.37163E+01,&
      0.37511E+01, 0.37856E+01, 0.38198E+01, 0.38535E+01, 0.38870E+01,&
      0.39201E+01, 0.39529E+01, 0.39854E+01, 0.40175E+01, 0.40494E+01,&
      0.40809E+01, 0.41122E+01, 0.41432E+01, 0.41738E+01, 0.42043E+01,&
      0.42344E+01, 0.42643E+01, 0.42939E+01, 0.43232E+01, 0.43523E+01,&
      0.43812E+01, 0.44098E+01, 0.44382E+01, 0.44663E+01, 0.44942E+01,&
      0.45219E+01, 0.45494E+01, 0.45766E+01, 0.46036E+01, 0.46304E+01,&
      0.46570E+01, 0.46834E+01, 0.47096E+01, 0.47356E+01, 0.47614E+01,&
      0.47870E+01, 0.48124E+01, 0.48377E+01, 0.48627E+01, 0.48876E+01,&
      0.49122E+01, 0.49368E+01, 0.49611E+01, 0.49853E+01, 0.50093E+01,&
      0.50331E+01, 0.50568E+01, 0.50803E+01, 0.51036E+01, 0.51268E+01,&
      0.51499E+01, 0.51728E+01, 0.51955E+01, 0.52181E+01, 0.52406E+01,&
      0.52629E+01, 0.52850E+01, 0.53071E+01, 0.53290E+01, 0.53507E+01,&
      0.53723E+01, 0.53938E+01, 0.54152E+01, 0.54364E+01, 0.54575E+01,&
      0.54785E+01, 0.54993E+01, 0.55200E+01, 0.55406E+01, 0.55611E+01,&
      0.55815E+01, 0.56017E+01, 0.56219E+01, 0.56419E+01, 0.56618E+01,&
      0.56816E+01, 0.57013E+01, 0.57209E+01, 0.57404E+01, 0.57597E+01,&
      0.57790E+01, 0.57982E+01, 0.58172E+01, 0.58362E+01, 0.58550E+01,&
      0.58738E+01, 0.58925E+01, 0.59110E+01, 0.59295E+01, 0.59479E+01/
                             
     DATA (BNC08M(IA),IA=701,741)/                                      &
      0.59661E+01, 0.59843E+01, 0.60024E+01, 0.60204E+01, 0.60384E+01,&
      0.60562E+01, 0.60739E+01, 0.60916E+01, 0.61091E+01, 0.61266E+01,&
      0.61440E+01, 0.61614E+01, 0.61786E+01, 0.61957E+01, 0.62128E+01,&
      0.62298E+01, 0.62467E+01, 0.62636E+01, 0.62803E+01, 0.62970E+01,&
      0.63136E+01, 0.63301E+01, 0.63466E+01, 0.63630E+01, 0.63793E+01,&
      0.63955E+01, 0.64117E+01, 0.64278E+01, 0.64438E+01, 0.64598E+01,&
      0.64757E+01, 0.64915E+01, 0.65073E+01, 0.65229E+01, 0.65386E+01,&
      0.65541E+01, 0.65696E+01, 0.65850E+01, 0.66004E+01, 0.66157E+01,&
      0.66309E+01                  /                      
!                            
!  ** NH4HSO4                
!                            
     DATA (BNC09M (IA),IA=  1,100)/                                     &
     -0.49220E-01,-0.88125E-01,-0.11455E+00,-0.13197E+00,-0.14502E+00,&
     -0.15542E+00,-0.16401E+00,-0.17127E+00,-0.17752E+00,-0.18296E+00,&
     -0.18774E+00,-0.19197E+00,-0.19572E+00,-0.19907E+00,-0.20206E+00,&
     -0.20473E+00,-0.20712E+00,-0.20925E+00,-0.21115E+00,-0.21284E+00,&
     -0.21433E+00,-0.21563E+00,-0.21677E+00,-0.21775E+00,-0.21858E+00,&
     -0.21927E+00,-0.21983E+00,-0.22027E+00,-0.22058E+00,-0.22079E+00,&
     -0.22089E+00,-0.22088E+00,-0.22078E+00,-0.22058E+00,-0.22030E+00,&
     -0.21992E+00,-0.21947E+00,-0.21894E+00,-0.21833E+00,-0.21764E+00,&
     -0.21689E+00,-0.21607E+00,-0.21519E+00,-0.21424E+00,-0.21323E+00,&
     -0.21216E+00,-0.21104E+00,-0.20986E+00,-0.20863E+00,-0.20735E+00,&
     -0.20602E+00,-0.20464E+00,-0.20322E+00,-0.20175E+00,-0.20025E+00,&
     -0.19870E+00,-0.19711E+00,-0.19548E+00,-0.19382E+00,-0.19212E+00,&
     -0.19038E+00,-0.18862E+00,-0.18681E+00,-0.18498E+00,-0.18311E+00,&
     -0.18122E+00,-0.17929E+00,-0.17734E+00,-0.17536E+00,-0.17334E+00,&
     -0.17131E+00,-0.16924E+00,-0.16715E+00,-0.16503E+00,-0.16289E+00,&
     -0.16072E+00,-0.15853E+00,-0.15631E+00,-0.15406E+00,-0.15180E+00,&
     -0.14951E+00,-0.14719E+00,-0.14486E+00,-0.14250E+00,-0.14011E+00,&
     -0.13771E+00,-0.13528E+00,-0.13283E+00,-0.13036E+00,-0.12787E+00,&
     -0.12536E+00,-0.12283E+00,-0.12028E+00,-0.11771E+00,-0.11512E+00,&
     -0.11251E+00,-0.10988E+00,-0.10724E+00,-0.10458E+00,-0.10191E+00/
                             
     DATA (BNC09M (IA),IA=101,200)/                                     &
     -0.99221E-01,-0.96517E-01,-0.93798E-01,-0.91067E-01,-0.88323E-01,&
     -0.85567E-01,-0.82800E-01,-0.80022E-01,-0.77234E-01,-0.74437E-01,&
     -0.71631E-01,-0.68817E-01,-0.65996E-01,-0.63168E-01,-0.60334E-01,&
     -0.57495E-01,-0.54651E-01,-0.51802E-01,-0.48950E-01,-0.46094E-01,&
     -0.43478E-01,-0.40589E-01,-0.37702E-01,-0.34815E-01,-0.31930E-01,&
     -0.29047E-01,-0.26165E-01,-0.23286E-01,-0.20408E-01,-0.17533E-01,&
     -0.14660E-01,-0.11790E-01,-0.89226E-02,-0.60582E-02,-0.31967E-02,&
     -0.33866E-03, 0.25164E-02, 0.53678E-02, 0.82159E-02, 0.11060E-01,&
      0.13901E-01, 0.16738E-01, 0.19571E-01, 0.22399E-01, 0.25224E-01,&
      0.28045E-01, 0.30861E-01, 0.33673E-01, 0.36481E-01, 0.39284E-01,&
      0.42083E-01, 0.44877E-01, 0.47667E-01, 0.50452E-01, 0.53232E-01,&
      0.56007E-01, 0.58778E-01, 0.61543E-01, 0.64304E-01, 0.67060E-01,&
      0.69811E-01, 0.72557E-01, 0.75298E-01, 0.78034E-01, 0.80765E-01,&
      0.83490E-01, 0.86211E-01, 0.88926E-01, 0.91637E-01, 0.94342E-01,&
      0.97042E-01, 0.99736E-01, 0.10243E+00, 0.10511E+00, 0.10779E+00,&
      0.11046E+00, 0.11313E+00, 0.11579E+00, 0.11845E+00, 0.12111E+00,&
      0.12375E+00, 0.12639E+00, 0.12903E+00, 0.13166E+00, 0.13429E+00,&
      0.13691E+00, 0.13953E+00, 0.14214E+00, 0.14474E+00, 0.14734E+00,&
      0.14994E+00, 0.15253E+00, 0.15511E+00, 0.15769E+00, 0.16026E+00,&
      0.16283E+00, 0.16540E+00, 0.16795E+00, 0.17051E+00, 0.17305E+00/
                             
     DATA (BNC09M (IA),IA=201,300)/                                     &
      0.17560E+00, 0.17814E+00, 0.18067E+00, 0.18319E+00, 0.18572E+00,&
      0.18823E+00, 0.19075E+00, 0.19325E+00, 0.19575E+00, 0.19825E+00,&
      0.20074E+00, 0.20323E+00, 0.20571E+00, 0.20819E+00, 0.21066E+00,&
      0.21313E+00, 0.21559E+00, 0.21805E+00, 0.22050E+00, 0.22294E+00,&
      0.22539E+00, 0.22782E+00, 0.23026E+00, 0.23268E+00, 0.23511E+00,&
      0.23752E+00, 0.23994E+00, 0.24235E+00, 0.24475E+00, 0.24715E+00,&
      0.24954E+00, 0.25193E+00, 0.25432E+00, 0.25670E+00, 0.25907E+00,&
      0.26144E+00, 0.26381E+00, 0.26617E+00, 0.26853E+00, 0.27088E+00,&
      0.27323E+00, 0.27557E+00, 0.27791E+00, 0.28024E+00, 0.28257E+00,&
      0.28490E+00, 0.28722E+00, 0.28954E+00, 0.29185E+00, 0.29416E+00,&
      0.29646E+00, 0.29876E+00, 0.30105E+00, 0.30334E+00, 0.30563E+00,&
      0.30791E+00, 0.31019E+00, 0.31246E+00, 0.31473E+00, 0.31699E+00,&
      0.31925E+00, 0.32151E+00, 0.32376E+00, 0.32601E+00, 0.32825E+00,&
      0.33049E+00, 0.33273E+00, 0.33496E+00, 0.33718E+00, 0.33941E+00,&
      0.34162E+00, 0.34384E+00, 0.34605E+00, 0.34826E+00, 0.35046E+00,&
      0.35266E+00, 0.35485E+00, 0.35704E+00, 0.35923E+00, 0.36141E+00,&
      0.36359E+00, 0.36577E+00, 0.36794E+00, 0.37010E+00, 0.37227E+00,&
      0.37443E+00, 0.37658E+00, 0.37874E+00, 0.38088E+00, 0.38303E+00,&
      0.38517E+00, 0.38731E+00, 0.38944E+00, 0.39157E+00, 0.39369E+00,&
      0.39582E+00, 0.39793E+00, 0.40005E+00, 0.40216E+00, 0.40427E+00/
                             
     DATA (BNC09M (IA),IA=301,400)/                                     &
      0.40637E+00, 0.40847E+00, 0.41057E+00, 0.41266E+00, 0.41475E+00,&
      0.41684E+00, 0.41892E+00, 0.42100E+00, 0.42307E+00, 0.42514E+00,&
      0.42721E+00, 0.42928E+00, 0.43134E+00, 0.43339E+00, 0.43545E+00,&
      0.43750E+00, 0.43955E+00, 0.44159E+00, 0.44363E+00, 0.44567E+00,&
      0.44770E+00, 0.44973E+00, 0.45176E+00, 0.45378E+00, 0.45581E+00,&
      0.45782E+00, 0.45984E+00, 0.46185E+00, 0.46385E+00, 0.46586E+00,&
      0.46786E+00, 0.46986E+00, 0.47185E+00, 0.47384E+00, 0.47583E+00,&
      0.47782E+00, 0.47980E+00, 0.48178E+00, 0.48375E+00, 0.48572E+00,&
      0.48769E+00, 0.48966E+00, 0.49162E+00, 0.49358E+00, 0.49554E+00,&
      0.49749E+00, 0.49944E+00, 0.50139E+00, 0.50333E+00, 0.50528E+00,&
      0.50721E+00, 0.50915E+00, 0.51108E+00, 0.51301E+00, 0.51494E+00,&
      0.51686E+00, 0.51878E+00, 0.52070E+00, 0.52261E+00, 0.52453E+00,&
      0.52643E+00, 0.52834E+00, 0.53024E+00, 0.53214E+00, 0.53404E+00,&
      0.53593E+00, 0.53782E+00, 0.53971E+00, 0.54160E+00, 0.54348E+00,&
      0.54536E+00, 0.54724E+00, 0.54911E+00, 0.55099E+00, 0.55285E+00,&
      0.55472E+00, 0.55658E+00, 0.55844E+00, 0.56030E+00, 0.56216E+00,&
      0.56401E+00, 0.56586E+00, 0.56770E+00, 0.56955E+00, 0.57139E+00,&
      0.57323E+00, 0.57507E+00, 0.57690E+00, 0.57873E+00, 0.58056E+00,&
      0.58238E+00, 0.58421E+00, 0.58603E+00, 0.58784E+00, 0.58966E+00,&
      0.59147E+00, 0.59328E+00, 0.59509E+00, 0.59689E+00, 0.59869E+00/
                             
     DATA (BNC09M (IA),IA=401,500)/                                     &
      0.60049E+00, 0.60229E+00, 0.60408E+00, 0.60588E+00, 0.60766E+00,&
      0.60945E+00, 0.61124E+00, 0.61302E+00, 0.61480E+00, 0.61657E+00,&
      0.61835E+00, 0.62012E+00, 0.62189E+00, 0.62366E+00, 0.62542E+00,&
      0.62718E+00, 0.62894E+00, 0.63070E+00, 0.63245E+00, 0.63421E+00,&
      0.63596E+00, 0.63770E+00, 0.63945E+00, 0.64119E+00, 0.64293E+00,&
      0.64467E+00, 0.64640E+00, 0.64814E+00, 0.64987E+00, 0.65160E+00,&
      0.65332E+00, 0.65505E+00, 0.65677E+00, 0.65849E+00, 0.66020E+00,&
      0.66192E+00, 0.66363E+00, 0.66534E+00, 0.66705E+00, 0.66875E+00,&
      0.67046E+00, 0.67216E+00, 0.67386E+00, 0.67555E+00, 0.67725E+00,&
      0.67894E+00, 0.68063E+00, 0.68232E+00, 0.68400E+00, 0.68568E+00,&
      0.68737E+00, 0.68904E+00, 0.69072E+00, 0.69240E+00, 0.69407E+00,&
      0.69574E+00, 0.69741E+00, 0.69907E+00, 0.70073E+00, 0.70240E+00,&
      0.70405E+00, 0.70571E+00, 0.70737E+00, 0.70902E+00, 0.71067E+00,&
      0.71232E+00, 0.71397E+00, 0.71561E+00, 0.71725E+00, 0.71889E+00,&
      0.72053E+00, 0.72217E+00, 0.72380E+00, 0.72543E+00, 0.72706E+00,&
      0.72869E+00, 0.73032E+00, 0.73194E+00, 0.73356E+00, 0.73518E+00,&
      0.73680E+00, 0.73842E+00, 0.74003E+00, 0.74164E+00, 0.74325E+00,&
      0.74486E+00, 0.74646E+00, 0.74807E+00, 0.74967E+00, 0.75127E+00,&
      0.75287E+00, 0.75446E+00, 0.75606E+00, 0.75765E+00, 0.75924E+00,&
      0.76083E+00, 0.76241E+00, 0.76400E+00, 0.76558E+00, 0.76716E+00/
                             
     DATA (BNC09M (IA),IA=501,600)/                                     &
      0.76874E+00, 0.77032E+00, 0.77189E+00, 0.77346E+00, 0.77503E+00,&
      0.77660E+00, 0.77817E+00, 0.77973E+00, 0.78130E+00, 0.78286E+00,&
      0.78442E+00, 0.78598E+00, 0.78753E+00, 0.78909E+00, 0.79064E+00,&
      0.79219E+00, 0.79374E+00, 0.79529E+00, 0.79683E+00, 0.79837E+00,&
      0.79991E+00, 0.80145E+00, 0.80299E+00, 0.80453E+00, 0.80606E+00,&
      0.80759E+00, 0.80912E+00, 0.81065E+00, 0.81218E+00, 0.81371E+00,&
      0.81523E+00, 0.81675E+00, 0.81827E+00, 0.81979E+00, 0.82131E+00,&
      0.82282E+00, 0.82433E+00, 0.82584E+00, 0.82735E+00, 0.82886E+00,&
      0.83037E+00, 0.83187E+00, 0.83337E+00, 0.83487E+00, 0.83637E+00,&
      0.83787E+00, 0.83937E+00, 0.84086E+00, 0.84235E+00, 0.84384E+00,&
      0.84533E+00, 0.84682E+00, 0.84831E+00, 0.84979E+00, 0.85127E+00,&
      0.85275E+00, 0.85423E+00, 0.85571E+00, 0.85719E+00, 0.85866E+00,&
      0.86013E+00, 0.86160E+00, 0.86307E+00, 0.86454E+00, 0.86601E+00,&
      0.86747E+00, 0.86893E+00, 0.87039E+00, 0.87185E+00, 0.87331E+00,&
      0.87477E+00, 0.87622E+00, 0.87768E+00, 0.87913E+00, 0.88058E+00,&
      0.88203E+00, 0.88347E+00, 0.88492E+00, 0.88636E+00, 0.88780E+00,&
      0.88924E+00, 0.89068E+00, 0.89212E+00, 0.89356E+00, 0.89499E+00,&
      0.89642E+00, 0.89786E+00, 0.89929E+00, 0.90071E+00, 0.90214E+00,&
      0.90357E+00, 0.90499E+00, 0.90641E+00, 0.90783E+00, 0.90925E+00,&
      0.91067E+00, 0.91209E+00, 0.91350E+00, 0.91491E+00, 0.92020E+00/
                             
     DATA (BNC09M (IA),IA=601,700)/                                     &
      0.93176E+00, 0.94563E+00, 0.95937E+00, 0.97296E+00, 0.98643E+00,&
      0.99976E+00, 0.10130E+01, 0.10260E+01, 0.10390E+01, 0.10518E+01,&
      0.10645E+01, 0.10771E+01, 0.10896E+01, 0.11020E+01, 0.11142E+01,&
      0.11264E+01, 0.11384E+01, 0.11504E+01, 0.11622E+01, 0.11740E+01,&
      0.11856E+01, 0.11972E+01, 0.12086E+01, 0.12200E+01, 0.12313E+01,&
      0.12425E+01, 0.12536E+01, 0.12646E+01, 0.12755E+01, 0.12864E+01,&
      0.12971E+01, 0.13078E+01, 0.13184E+01, 0.13290E+01, 0.13394E+01,&
      0.13498E+01, 0.13601E+01, 0.13704E+01, 0.13805E+01, 0.13906E+01,&
      0.14006E+01, 0.14106E+01, 0.14205E+01, 0.14303E+01, 0.14401E+01,&
      0.14498E+01, 0.14594E+01, 0.14690E+01, 0.14785E+01, 0.14880E+01,&
      0.14974E+01, 0.15067E+01, 0.15160E+01, 0.15252E+01, 0.15344E+01,&
      0.15435E+01, 0.15526E+01, 0.15616E+01, 0.15706E+01, 0.15795E+01,&
      0.15883E+01, 0.15971E+01, 0.16059E+01, 0.16146E+01, 0.16233E+01,&
      0.16319E+01, 0.16404E+01, 0.16489E+01, 0.16574E+01, 0.16658E+01,&
      0.16742E+01, 0.16825E+01, 0.16908E+01, 0.16991E+01, 0.17073E+01,&
      0.17155E+01, 0.17236E+01, 0.17317E+01, 0.17397E+01, 0.17477E+01,&
      0.17557E+01, 0.17636E+01, 0.17715E+01, 0.17793E+01, 0.17871E+01,&
      0.17949E+01, 0.18026E+01, 0.18103E+01, 0.18180E+01, 0.18256E+01,&
      0.18332E+01, 0.18408E+01, 0.18483E+01, 0.18558E+01, 0.18632E+01,&
      0.18707E+01, 0.18780E+01, 0.18854E+01, 0.18927E+01, 0.19000E+01/
                             
     DATA (BNC09M(IA),IA=701,741)/                                      &
      0.19073E+01, 0.19145E+01, 0.19217E+01, 0.19289E+01, 0.19360E+01,&
      0.19431E+01, 0.19502E+01, 0.19572E+01, 0.19643E+01, 0.19713E+01,&
      0.19782E+01, 0.19852E+01, 0.19921E+01, 0.19989E+01, 0.20058E+01,&
      0.20126E+01, 0.20194E+01, 0.20262E+01, 0.20329E+01, 0.20397E+01,&
      0.20464E+01, 0.20530E+01, 0.20597E+01, 0.20663E+01, 0.20729E+01,&
      0.20794E+01, 0.20860E+01, 0.20925E+01, 0.20990E+01, 0.21055E+01,&
      0.21119E+01, 0.21184E+01, 0.21248E+01, 0.21311E+01, 0.21375E+01,&
      0.21438E+01, 0.21502E+01, 0.21564E+01, 0.21627E+01, 0.21690E+01,&
      0.21752E+01                  /                      
!                            
!  ** (H, NO3)               
!                            
     DATA (BNC10M (IA),IA=  1,100)/                                     &
     -0.48649E-01,-0.85767E-01,-0.10978E+00,-0.12480E+00,-0.13548E+00,&
     -0.14354E+00,-0.14981E+00,-0.15480E+00,-0.15882E+00,-0.16206E+00,&
     -0.16468E+00,-0.16679E+00,-0.16847E+00,-0.16978E+00,-0.17078E+00,&
     -0.17151E+00,-0.17200E+00,-0.17228E+00,-0.17237E+00,-0.17230E+00,&
     -0.17208E+00,-0.17173E+00,-0.17125E+00,-0.17067E+00,-0.16998E+00,&
     -0.16921E+00,-0.16835E+00,-0.16742E+00,-0.16643E+00,-0.16536E+00,&
     -0.16425E+00,-0.16308E+00,-0.16186E+00,-0.16060E+00,-0.15929E+00,&
     -0.15795E+00,-0.15658E+00,-0.15518E+00,-0.15375E+00,-0.15229E+00,&
     -0.15080E+00,-0.14930E+00,-0.14778E+00,-0.14623E+00,-0.14468E+00,&
     -0.14310E+00,-0.14151E+00,-0.13991E+00,-0.13830E+00,-0.13667E+00,&
     -0.13504E+00,-0.13339E+00,-0.13174E+00,-0.13008E+00,-0.12841E+00,&
     -0.12673E+00,-0.12505E+00,-0.12335E+00,-0.12166E+00,-0.11995E+00,&
     -0.11824E+00,-0.11652E+00,-0.11479E+00,-0.11306E+00,-0.11132E+00,&
     -0.10957E+00,-0.10782E+00,-0.10605E+00,-0.10428E+00,-0.10250E+00,&
     -0.10071E+00,-0.98911E-01,-0.97103E-01,-0.95285E-01,-0.93457E-01,&
     -0.91617E-01,-0.89767E-01,-0.87906E-01,-0.86032E-01,-0.84147E-01,&
     -0.82250E-01,-0.80340E-01,-0.78418E-01,-0.76482E-01,-0.74534E-01,&
     -0.72572E-01,-0.70597E-01,-0.68609E-01,-0.66607E-01,-0.64593E-01,&
     -0.62565E-01,-0.60523E-01,-0.58469E-01,-0.56402E-01,-0.54322E-01,&
     -0.52230E-01,-0.50125E-01,-0.48009E-01,-0.45881E-01,-0.43741E-01/
                             
     DATA (BNC10M (IA),IA=101,200)/                                     &
     -0.41591E-01,-0.39430E-01,-0.37259E-01,-0.35077E-01,-0.32887E-01,&
     -0.30687E-01,-0.28479E-01,-0.26263E-01,-0.24039E-01,-0.21808E-01,&
     -0.19569E-01,-0.17325E-01,-0.15074E-01,-0.12818E-01,-0.10556E-01,&
     -0.82900E-02,-0.60192E-02,-0.37444E-02,-0.14659E-02, 0.81591E-03,&
      0.28768E-02, 0.51902E-02, 0.75034E-02, 0.98163E-02, 0.12129E-01,&
      0.14441E-01, 0.16752E-01, 0.19063E-01, 0.21374E-01, 0.23683E-01,&
      0.25992E-01, 0.28300E-01, 0.30607E-01, 0.32913E-01, 0.35219E-01,&
      0.37523E-01, 0.39826E-01, 0.42127E-01, 0.44428E-01, 0.46727E-01,&
      0.49025E-01, 0.51322E-01, 0.53617E-01, 0.55911E-01, 0.58203E-01,&
      0.60494E-01, 0.62784E-01, 0.65071E-01, 0.67357E-01, 0.69642E-01,&
      0.71924E-01, 0.74205E-01, 0.76484E-01, 0.78761E-01, 0.81037E-01,&
      0.83310E-01, 0.85582E-01, 0.87852E-01, 0.90120E-01, 0.92385E-01,&
      0.94649E-01, 0.96911E-01, 0.99170E-01, 0.10143E+00, 0.10368E+00,&
      0.10594E+00, 0.10819E+00, 0.11044E+00, 0.11268E+00, 0.11493E+00,&
      0.11717E+00, 0.11941E+00, 0.12165E+00, 0.12388E+00, 0.12612E+00,&
      0.12835E+00, 0.13058E+00, 0.13280E+00, 0.13503E+00, 0.13725E+00,&
      0.13947E+00, 0.14168E+00, 0.14390E+00, 0.14611E+00, 0.14832E+00,&
      0.15052E+00, 0.15273E+00, 0.15493E+00, 0.15713E+00, 0.15932E+00,&
      0.16152E+00, 0.16371E+00, 0.16590E+00, 0.16808E+00, 0.17027E+00,&
      0.17245E+00, 0.17463E+00, 0.17680E+00, 0.17898E+00, 0.18115E+00/
                             
     DATA (BNC10M (IA),IA=201,300)/                                     &
      0.18332E+00, 0.18548E+00, 0.18764E+00, 0.18980E+00, 0.19196E+00,&
      0.19412E+00, 0.19627E+00, 0.19842E+00, 0.20056E+00, 0.20271E+00,&
      0.20485E+00, 0.20699E+00, 0.20912E+00, 0.21126E+00, 0.21339E+00,&
      0.21552E+00, 0.21764E+00, 0.21976E+00, 0.22188E+00, 0.22400E+00,&
      0.22611E+00, 0.22823E+00, 0.23033E+00, 0.23244E+00, 0.23454E+00,&
      0.23664E+00, 0.23874E+00, 0.24084E+00, 0.24293E+00, 0.24502E+00,&
      0.24711E+00, 0.24919E+00, 0.25127E+00, 0.25335E+00, 0.25543E+00,&
      0.25750E+00, 0.25957E+00, 0.26164E+00, 0.26370E+00, 0.26577E+00,&
      0.26783E+00, 0.26988E+00, 0.27194E+00, 0.27399E+00, 0.27604E+00,&
      0.27808E+00, 0.28013E+00, 0.28217E+00, 0.28420E+00, 0.28624E+00,&
      0.28827E+00, 0.29030E+00, 0.29233E+00, 0.29435E+00, 0.29637E+00,&
      0.29839E+00, 0.30041E+00, 0.30242E+00, 0.30443E+00, 0.30644E+00,&
      0.30844E+00, 0.31044E+00, 0.31244E+00, 0.31444E+00, 0.31644E+00,&
      0.31843E+00, 0.32042E+00, 0.32240E+00, 0.32439E+00, 0.32637E+00,&
      0.32834E+00, 0.33032E+00, 0.33229E+00, 0.33426E+00, 0.33623E+00,&
      0.33819E+00, 0.34016E+00, 0.34211E+00, 0.34407E+00, 0.34603E+00,&
      0.34798E+00, 0.34993E+00, 0.35187E+00, 0.35382E+00, 0.35576E+00,&
      0.35769E+00, 0.35963E+00, 0.36156E+00, 0.36349E+00, 0.36542E+00,&
      0.36735E+00, 0.36927E+00, 0.37119E+00, 0.37310E+00, 0.37502E+00,&
      0.37693E+00, 0.37884E+00, 0.38075E+00, 0.38265E+00, 0.38455E+00/
                             
     DATA (BNC10M (IA),IA=301,400)/                                     &
      0.38645E+00, 0.38835E+00, 0.39024E+00, 0.39213E+00, 0.39402E+00,&
      0.39591E+00, 0.39779E+00, 0.39968E+00, 0.40155E+00, 0.40343E+00,&
      0.40530E+00, 0.40717E+00, 0.40904E+00, 0.41091E+00, 0.41277E+00,&
      0.41463E+00, 0.41649E+00, 0.41835E+00, 0.42020E+00, 0.42205E+00,&
      0.42390E+00, 0.42575E+00, 0.42759E+00, 0.42943E+00, 0.43127E+00,&
      0.43311E+00, 0.43494E+00, 0.43677E+00, 0.43860E+00, 0.44043E+00,&
      0.44225E+00, 0.44407E+00, 0.44589E+00, 0.44771E+00, 0.44952E+00,&
      0.45134E+00, 0.45315E+00, 0.45495E+00, 0.45676E+00, 0.45856E+00,&
      0.46036E+00, 0.46216E+00, 0.46395E+00, 0.46575E+00, 0.46754E+00,&
      0.46932E+00, 0.47111E+00, 0.47289E+00, 0.47467E+00, 0.47645E+00,&
      0.47823E+00, 0.48000E+00, 0.48178E+00, 0.48355E+00, 0.48531E+00,&
      0.48708E+00, 0.48884E+00, 0.49060E+00, 0.49236E+00, 0.49411E+00,&
      0.49587E+00, 0.49762E+00, 0.49937E+00, 0.50111E+00, 0.50286E+00,&
      0.50460E+00, 0.50634E+00, 0.50808E+00, 0.50981E+00, 0.51154E+00,&
      0.51327E+00, 0.51500E+00, 0.51673E+00, 0.51845E+00, 0.52017E+00,&
      0.52189E+00, 0.52361E+00, 0.52533E+00, 0.52704E+00, 0.52875E+00,&
      0.53046E+00, 0.53216E+00, 0.53387E+00, 0.53557E+00, 0.53727E+00,&
      0.53897E+00, 0.54066E+00, 0.54236E+00, 0.54405E+00, 0.54574E+00,&
      0.54742E+00, 0.54911E+00, 0.55079E+00, 0.55247E+00, 0.55415E+00,&
      0.55583E+00, 0.55750E+00, 0.55917E+00, 0.56084E+00, 0.56251E+00/
                             
     DATA (BNC10M (IA),IA=401,500)/                                     &
      0.56418E+00, 0.56584E+00, 0.56750E+00, 0.56916E+00, 0.57082E+00,&
      0.57247E+00, 0.57413E+00, 0.57578E+00, 0.57743E+00, 0.57907E+00,&
      0.58072E+00, 0.58236E+00, 0.58400E+00, 0.58564E+00, 0.58728E+00,&
      0.58891E+00, 0.59055E+00, 0.59218E+00, 0.59380E+00, 0.59543E+00,&
      0.59706E+00, 0.59868E+00, 0.60030E+00, 0.60192E+00, 0.60354E+00,&
      0.60515E+00, 0.60676E+00, 0.60837E+00, 0.60998E+00, 0.61159E+00,&
      0.61319E+00, 0.61480E+00, 0.61640E+00, 0.61800E+00, 0.61959E+00,&
      0.62119E+00, 0.62278E+00, 0.62437E+00, 0.62596E+00, 0.62755E+00,&
      0.62914E+00, 0.63072E+00, 0.63230E+00, 0.63388E+00, 0.63546E+00,&
      0.63704E+00, 0.63861E+00, 0.64018E+00, 0.64175E+00, 0.64332E+00,&
      0.64489E+00, 0.64645E+00, 0.64802E+00, 0.64958E+00, 0.65114E+00,&
      0.65269E+00, 0.65425E+00, 0.65580E+00, 0.65735E+00, 0.65890E+00,&
      0.66045E+00, 0.66200E+00, 0.66354E+00, 0.66509E+00, 0.66663E+00,&
      0.66817E+00, 0.66970E+00, 0.67124E+00, 0.67277E+00, 0.67431E+00,&
      0.67584E+00, 0.67736E+00, 0.67889E+00, 0.68042E+00, 0.68194E+00,&
      0.68346E+00, 0.68498E+00, 0.68650E+00, 0.68801E+00, 0.68953E+00,&
      0.69104E+00, 0.69255E+00, 0.69406E+00, 0.69557E+00, 0.69707E+00,&
      0.69858E+00, 0.70008E+00, 0.70158E+00, 0.70308E+00, 0.70457E+00,&
      0.70607E+00, 0.70756E+00, 0.70905E+00, 0.71054E+00, 0.71203E+00,&
      0.71352E+00, 0.71500E+00, 0.71649E+00, 0.71797E+00, 0.71945E+00/
                             
     DATA (BNC10M (IA),IA=501,600)/                                     &
      0.72093E+00, 0.72240E+00, 0.72388E+00, 0.72535E+00, 0.72682E+00,&
      0.72829E+00, 0.72976E+00, 0.73123E+00, 0.73269E+00, 0.73416E+00,&
      0.73562E+00, 0.73708E+00, 0.73854E+00, 0.74000E+00, 0.74145E+00,&
      0.74290E+00, 0.74436E+00, 0.74581E+00, 0.74726E+00, 0.74870E+00,&
      0.75015E+00, 0.75159E+00, 0.75304E+00, 0.75448E+00, 0.75592E+00,&
      0.75735E+00, 0.75879E+00, 0.76022E+00, 0.76166E+00, 0.76309E+00,&
      0.76452E+00, 0.76595E+00, 0.76737E+00, 0.76880E+00, 0.77022E+00,&
      0.77164E+00, 0.77307E+00, 0.77448E+00, 0.77590E+00, 0.77732E+00,&
      0.77873E+00, 0.78015E+00, 0.78156E+00, 0.78297E+00, 0.78437E+00,&
      0.78578E+00, 0.78719E+00, 0.78859E+00, 0.78999E+00, 0.79139E+00,&
      0.79279E+00, 0.79419E+00, 0.79559E+00, 0.79698E+00, 0.79838E+00,&
      0.79977E+00, 0.80116E+00, 0.80255E+00, 0.80393E+00, 0.80532E+00,&
      0.80671E+00, 0.80809E+00, 0.80947E+00, 0.81085E+00, 0.81223E+00,&
      0.81361E+00, 0.81498E+00, 0.81636E+00, 0.81773E+00, 0.81910E+00,&
      0.82047E+00, 0.82184E+00, 0.82321E+00, 0.82457E+00, 0.82594E+00,&
      0.82730E+00, 0.82866E+00, 0.83002E+00, 0.83138E+00, 0.83274E+00,&
      0.83409E+00, 0.83545E+00, 0.83680E+00, 0.83815E+00, 0.83950E+00,&
      0.84085E+00, 0.84220E+00, 0.84355E+00, 0.84489E+00, 0.84624E+00,&
      0.84758E+00, 0.84892E+00, 0.85026E+00, 0.85160E+00, 0.85293E+00,&
      0.85427E+00, 0.85560E+00, 0.85693E+00, 0.85827E+00, 0.86325E+00/
                             
     DATA (BNC10M (IA),IA=601,700)/                                     &
      0.87414E+00, 0.88722E+00, 0.90017E+00, 0.91300E+00, 0.92570E+00,&
      0.93828E+00, 0.95075E+00, 0.96310E+00, 0.97533E+00, 0.98746E+00,&
      0.99947E+00, 0.10114E+01, 0.10232E+01, 0.10349E+01, 0.10465E+01,&
      0.10580E+01, 0.10694E+01, 0.10807E+01, 0.10919E+01, 0.11030E+01,&
      0.11141E+01, 0.11250E+01, 0.11358E+01, 0.11466E+01, 0.11573E+01,&
      0.11679E+01, 0.11784E+01, 0.11889E+01, 0.11992E+01, 0.12095E+01,&
      0.12197E+01, 0.12299E+01, 0.12399E+01, 0.12499E+01, 0.12598E+01,&
      0.12697E+01, 0.12795E+01, 0.12892E+01, 0.12988E+01, 0.13084E+01,&
      0.13179E+01, 0.13274E+01, 0.13367E+01, 0.13461E+01, 0.13553E+01,&
      0.13645E+01, 0.13737E+01, 0.13828E+01, 0.13918E+01, 0.14008E+01,&
      0.14097E+01, 0.14186E+01, 0.14274E+01, 0.14362E+01, 0.14449E+01,&
      0.14535E+01, 0.14621E+01, 0.14707E+01, 0.14792E+01, 0.14876E+01,&
      0.14960E+01, 0.15044E+01, 0.15127E+01, 0.15210E+01, 0.15292E+01,&
      0.15374E+01, 0.15455E+01, 0.15536E+01, 0.15616E+01, 0.15696E+01,&
      0.15776E+01, 0.15855E+01, 0.15934E+01, 0.16012E+01, 0.16090E+01,&
      0.16168E+01, 0.16245E+01, 0.16322E+01, 0.16398E+01, 0.16474E+01,&
      0.16550E+01, 0.16625E+01, 0.16700E+01, 0.16774E+01, 0.16849E+01,&
      0.16922E+01, 0.16996E+01, 0.17069E+01, 0.17142E+01, 0.17214E+01,&
      0.17286E+01, 0.17358E+01, 0.17430E+01, 0.17501E+01, 0.17572E+01,&
      0.17642E+01, 0.17712E+01, 0.17782E+01, 0.17852E+01, 0.17921E+01/
                             
     DATA (BNC10M(IA),IA=701,741)/                                      &
      0.17990E+01, 0.18059E+01, 0.18127E+01, 0.18195E+01, 0.18263E+01,&
      0.18331E+01, 0.18398E+01, 0.18465E+01, 0.18532E+01, 0.18598E+01,&
      0.18664E+01, 0.18730E+01, 0.18796E+01, 0.18861E+01, 0.18926E+01,&
      0.18991E+01, 0.19056E+01, 0.19120E+01, 0.19184E+01, 0.19248E+01,&
      0.19312E+01, 0.19375E+01, 0.19439E+01, 0.19502E+01, 0.19564E+01,&
      0.19627E+01, 0.19689E+01, 0.19751E+01, 0.19813E+01, 0.19874E+01,&
      0.19936E+01, 0.19997E+01, 0.20058E+01, 0.20118E+01, 0.20179E+01,&
      0.20239E+01, 0.20299E+01, 0.20359E+01, 0.20419E+01, 0.20478E+01,&
      0.20537E+01                  /                      
!                            
!  ** (H, Cl)                
!                            
     DATA (BNC11M (IA),IA=  1,100)/                                     &
     -0.47533E-01,-0.81940E-01,-0.10288E+00,-0.11511E+00,-0.12316E+00,&
     -0.12868E+00,-0.13248E+00,-0.13503E+00,-0.13662E+00,-0.13745E+00,&
     -0.13766E+00,-0.13734E+00,-0.13659E+00,-0.13546E+00,-0.13399E+00,&
     -0.13224E+00,-0.13022E+00,-0.12796E+00,-0.12550E+00,-0.12284E+00,&
     -0.12001E+00,-0.11702E+00,-0.11388E+00,-0.11061E+00,-0.10721E+00,&
     -0.10369E+00,-0.10007E+00,-0.96344E-01,-0.92526E-01,-0.88621E-01,&
     -0.84635E-01,-0.80573E-01,-0.76440E-01,-0.72241E-01,-0.67980E-01,&
     -0.63661E-01,-0.59289E-01,-0.54866E-01,-0.50396E-01,-0.45882E-01,&
     -0.41327E-01,-0.36734E-01,-0.32105E-01,-0.27442E-01,-0.22748E-01,&
     -0.18025E-01,-0.13275E-01,-0.84990E-02,-0.36992E-02, 0.11231E-02,&
      0.59666E-02, 0.10830E-01, 0.15712E-01, 0.20613E-01, 0.25530E-01,&
      0.30464E-01, 0.35414E-01, 0.40380E-01, 0.45360E-01, 0.50356E-01,&
      0.55366E-01, 0.60391E-01, 0.65431E-01, 0.70486E-01, 0.75557E-01,&
      0.80642E-01, 0.85744E-01, 0.90863E-01, 0.95998E-01, 0.10115E+00,&
      0.10632E+00, 0.11151E+00, 0.11672E+00, 0.12195E+00, 0.12720E+00,&
      0.13247E+00, 0.13777E+00, 0.14308E+00, 0.14843E+00, 0.15379E+00,&
      0.15918E+00, 0.16460E+00, 0.17004E+00, 0.17550E+00, 0.18100E+00,&
      0.18652E+00, 0.19207E+00, 0.19764E+00, 0.20324E+00, 0.20887E+00,&
      0.21453E+00, 0.22022E+00, 0.22593E+00, 0.23166E+00, 0.23743E+00,&
      0.24322E+00, 0.24903E+00, 0.25487E+00, 0.26073E+00, 0.26661E+00/
                             
     DATA (BNC11M (IA),IA=101,200)/                                     &
      0.27252E+00, 0.27845E+00, 0.28440E+00, 0.29037E+00, 0.29635E+00,&
      0.30235E+00, 0.30838E+00, 0.31441E+00, 0.32046E+00, 0.32652E+00,&
      0.33260E+00, 0.33869E+00, 0.34478E+00, 0.35089E+00, 0.35701E+00,&
      0.36313E+00, 0.36926E+00, 0.37539E+00, 0.38153E+00, 0.38767E+00,&
      0.39330E+00, 0.39951E+00, 0.40571E+00, 0.41191E+00, 0.41810E+00,&
      0.42429E+00, 0.43047E+00, 0.43665E+00, 0.44282E+00, 0.44898E+00,&
      0.45514E+00, 0.46129E+00, 0.46744E+00, 0.47358E+00, 0.47971E+00,&
      0.48583E+00, 0.49195E+00, 0.49806E+00, 0.50417E+00, 0.51026E+00,&
      0.51635E+00, 0.52243E+00, 0.52850E+00, 0.53456E+00, 0.54062E+00,&
      0.54667E+00, 0.55271E+00, 0.55874E+00, 0.56476E+00, 0.57077E+00,&
      0.57678E+00, 0.58277E+00, 0.58876E+00, 0.59474E+00, 0.60071E+00,&
      0.60667E+00, 0.61262E+00, 0.61856E+00, 0.62449E+00, 0.63041E+00,&
      0.63633E+00, 0.64223E+00, 0.64812E+00, 0.65401E+00, 0.65988E+00,&
      0.66575E+00, 0.67160E+00, 0.67745E+00, 0.68328E+00, 0.68911E+00,&
      0.69493E+00, 0.70073E+00, 0.70653E+00, 0.71231E+00, 0.71809E+00,&
      0.72386E+00, 0.72961E+00, 0.73536E+00, 0.74109E+00, 0.74682E+00,&
      0.75253E+00, 0.75824E+00, 0.76393E+00, 0.76962E+00, 0.77529E+00,&
      0.78096E+00, 0.78661E+00, 0.79226E+00, 0.79789E+00, 0.80351E+00,&
      0.80913E+00, 0.81473E+00, 0.82032E+00, 0.82590E+00, 0.83148E+00,&
      0.83704E+00, 0.84259E+00, 0.84813E+00, 0.85366E+00, 0.85918E+00/
                             
     DATA (BNC11M (IA),IA=201,300)/                                     &
      0.86469E+00, 0.87019E+00, 0.87568E+00, 0.88116E+00, 0.88663E+00,&
      0.89209E+00, 0.89754E+00, 0.90298E+00, 0.90841E+00, 0.91383E+00,&
      0.91923E+00, 0.92463E+00, 0.93002E+00, 0.93540E+00, 0.94077E+00,&
      0.94612E+00, 0.95147E+00, 0.95681E+00, 0.96213E+00, 0.96745E+00,&
      0.97276E+00, 0.97806E+00, 0.98334E+00, 0.98862E+00, 0.99389E+00,&
      0.99914E+00, 0.10044E+01, 0.10096E+01, 0.10149E+01, 0.10201E+01,&
      0.10253E+01, 0.10305E+01, 0.10357E+01, 0.10408E+01, 0.10460E+01,&
      0.10512E+01, 0.10563E+01, 0.10615E+01, 0.10666E+01, 0.10717E+01,&
      0.10768E+01, 0.10819E+01, 0.10870E+01, 0.10921E+01, 0.10972E+01,&
      0.11022E+01, 0.11073E+01, 0.11123E+01, 0.11174E+01, 0.11224E+01,&
      0.11274E+01, 0.11324E+01, 0.11374E+01, 0.11424E+01, 0.11474E+01,&
      0.11523E+01, 0.11573E+01, 0.11622E+01, 0.11672E+01, 0.11721E+01,&
      0.11770E+01, 0.11819E+01, 0.11868E+01, 0.11917E+01, 0.11966E+01,&
      0.12015E+01, 0.12064E+01, 0.12112E+01, 0.12161E+01, 0.12209E+01,&
      0.12258E+01, 0.12306E+01, 0.12354E+01, 0.12402E+01, 0.12450E+01,&
      0.12498E+01, 0.12546E+01, 0.12593E+01, 0.12641E+01, 0.12688E+01,&
      0.12736E+01, 0.12783E+01, 0.12831E+01, 0.12878E+01, 0.12925E+01,&
      0.12972E+01, 0.13019E+01, 0.13066E+01, 0.13112E+01, 0.13159E+01,&
      0.13206E+01, 0.13252E+01, 0.13299E+01, 0.13345E+01, 0.13391E+01,&
      0.13437E+01, 0.13483E+01, 0.13529E+01, 0.13575E+01, 0.13621E+01/
                             
     DATA (BNC11M (IA),IA=301,400)/                                     &
      0.13667E+01, 0.13713E+01, 0.13758E+01, 0.13804E+01, 0.13849E+01,&
      0.13895E+01, 0.13940E+01, 0.13985E+01, 0.14030E+01, 0.14075E+01,&
      0.14120E+01, 0.14165E+01, 0.14210E+01, 0.14255E+01, 0.14299E+01,&
      0.14344E+01, 0.14388E+01, 0.14433E+01, 0.14477E+01, 0.14521E+01,&
      0.14565E+01, 0.14610E+01, 0.14654E+01, 0.14698E+01, 0.14741E+01,&
      0.14785E+01, 0.14829E+01, 0.14873E+01, 0.14916E+01, 0.14960E+01,&
      0.15003E+01, 0.15047E+01, 0.15090E+01, 0.15133E+01, 0.15176E+01,&
      0.15219E+01, 0.15262E+01, 0.15305E+01, 0.15348E+01, 0.15391E+01,&
      0.15433E+01, 0.15476E+01, 0.15519E+01, 0.15561E+01, 0.15604E+01,&
      0.15646E+01, 0.15688E+01, 0.15730E+01, 0.15773E+01, 0.15815E+01,&
      0.15857E+01, 0.15899E+01, 0.15940E+01, 0.15982E+01, 0.16024E+01,&
      0.16066E+01, 0.16107E+01, 0.16149E+01, 0.16190E+01, 0.16231E+01,&
      0.16273E+01, 0.16314E+01, 0.16355E+01, 0.16396E+01, 0.16437E+01,&
      0.16478E+01, 0.16519E+01, 0.16560E+01, 0.16601E+01, 0.16642E+01,&
      0.16682E+01, 0.16723E+01, 0.16763E+01, 0.16804E+01, 0.16844E+01,&
      0.16884E+01, 0.16925E+01, 0.16965E+01, 0.17005E+01, 0.17045E+01,&
      0.17085E+01, 0.17125E+01, 0.17165E+01, 0.17205E+01, 0.17245E+01,&
      0.17284E+01, 0.17324E+01, 0.17363E+01, 0.17403E+01, 0.17442E+01,&
      0.17482E+01, 0.17521E+01, 0.17560E+01, 0.17599E+01, 0.17639E+01,&
      0.17678E+01, 0.17717E+01, 0.17756E+01, 0.17795E+01, 0.17833E+01/
                             
     DATA (BNC11M (IA),IA=401,500)/                                     &
      0.17872E+01, 0.17911E+01, 0.17950E+01, 0.17988E+01, 0.18027E+01,&
      0.18065E+01, 0.18104E+01, 0.18142E+01, 0.18180E+01, 0.18218E+01,&
      0.18257E+01, 0.18295E+01, 0.18333E+01, 0.18371E+01, 0.18409E+01,&
      0.18447E+01, 0.18485E+01, 0.18522E+01, 0.18560E+01, 0.18598E+01,&
      0.18635E+01, 0.18673E+01, 0.18710E+01, 0.18748E+01, 0.18785E+01,&
      0.18823E+01, 0.18860E+01, 0.18897E+01, 0.18934E+01, 0.18971E+01,&
      0.19008E+01, 0.19045E+01, 0.19082E+01, 0.19119E+01, 0.19156E+01,&
      0.19193E+01, 0.19230E+01, 0.19266E+01, 0.19303E+01, 0.19340E+01,&
      0.19376E+01, 0.19413E+01, 0.19449E+01, 0.19485E+01, 0.19522E+01,&
      0.19558E+01, 0.19594E+01, 0.19630E+01, 0.19666E+01, 0.19702E+01,&
      0.19738E+01, 0.19774E+01, 0.19810E+01, 0.19846E+01, 0.19882E+01,&
      0.19918E+01, 0.19953E+01, 0.19989E+01, 0.20025E+01, 0.20060E+01,&
      0.20096E+01, 0.20131E+01, 0.20167E+01, 0.20202E+01, 0.20237E+01,&
      0.20272E+01, 0.20308E+01, 0.20343E+01, 0.20378E+01, 0.20413E+01,&
      0.20448E+01, 0.20483E+01, 0.20518E+01, 0.20553E+01, 0.20587E+01,&
      0.20622E+01, 0.20657E+01, 0.20692E+01, 0.20726E+01, 0.20761E+01,&
      0.20795E+01, 0.20830E+01, 0.20864E+01, 0.20899E+01, 0.20933E+01,&
      0.20967E+01, 0.21001E+01, 0.21036E+01, 0.21070E+01, 0.21104E+01,&
      0.21138E+01, 0.21172E+01, 0.21206E+01, 0.21240E+01, 0.21274E+01,&
      0.21308E+01, 0.21341E+01, 0.21375E+01, 0.21409E+01, 0.21442E+01/
                             
     DATA (BNC11M (IA),IA=501,600)/                                     &
      0.21476E+01, 0.21510E+01, 0.21543E+01, 0.21577E+01, 0.21610E+01,&
      0.21643E+01, 0.21677E+01, 0.21710E+01, 0.21743E+01, 0.21776E+01,&
      0.21810E+01, 0.21843E+01, 0.21876E+01, 0.21909E+01, 0.21942E+01,&
      0.21975E+01, 0.22008E+01, 0.22041E+01, 0.22073E+01, 0.22106E+01,&
      0.22139E+01, 0.22172E+01, 0.22204E+01, 0.22237E+01, 0.22269E+01,&
      0.22302E+01, 0.22334E+01, 0.22367E+01, 0.22399E+01, 0.22432E+01,&
      0.22464E+01, 0.22496E+01, 0.22528E+01, 0.22561E+01, 0.22593E+01,&
      0.22625E+01, 0.22657E+01, 0.22689E+01, 0.22721E+01, 0.22753E+01,&
      0.22785E+01, 0.22817E+01, 0.22849E+01, 0.22880E+01, 0.22912E+01,&
      0.22944E+01, 0.22975E+01, 0.23007E+01, 0.23039E+01, 0.23070E+01,&
      0.23102E+01, 0.23133E+01, 0.23165E+01, 0.23196E+01, 0.23227E+01,&
      0.23259E+01, 0.23290E+01, 0.23321E+01, 0.23352E+01, 0.23384E+01,&
      0.23415E+01, 0.23446E+01, 0.23477E+01, 0.23508E+01, 0.23539E+01,&
      0.23570E+01, 0.23601E+01, 0.23632E+01, 0.23662E+01, 0.23693E+01,&
      0.23724E+01, 0.23755E+01, 0.23785E+01, 0.23816E+01, 0.23847E+01,&
      0.23877E+01, 0.23908E+01, 0.23938E+01, 0.23969E+01, 0.23999E+01,&
      0.24029E+01, 0.24060E+01, 0.24090E+01, 0.24120E+01, 0.24150E+01,&
      0.24181E+01, 0.24211E+01, 0.24241E+01, 0.24271E+01, 0.24301E+01,&
      0.24331E+01, 0.24361E+01, 0.24391E+01, 0.24421E+01, 0.24451E+01,&
      0.24481E+01, 0.24511E+01, 0.24540E+01, 0.24570E+01, 0.24681E+01/
                             
     DATA (BNC11M (IA),IA=601,700)/                                     &
      0.24924E+01, 0.25216E+01, 0.25504E+01, 0.25789E+01, 0.26071E+01,&
      0.26349E+01, 0.26625E+01, 0.26898E+01, 0.27168E+01, 0.27435E+01,&
      0.27699E+01, 0.27961E+01, 0.28220E+01, 0.28477E+01, 0.28731E+01,&
      0.28982E+01, 0.29231E+01, 0.29478E+01, 0.29722E+01, 0.29965E+01,&
      0.30205E+01, 0.30442E+01, 0.30678E+01, 0.30911E+01, 0.31143E+01,&
      0.31372E+01, 0.31599E+01, 0.31825E+01, 0.32048E+01, 0.32270E+01,&
      0.32490E+01, 0.32708E+01, 0.32924E+01, 0.33138E+01, 0.33351E+01,&
      0.33562E+01, 0.33771E+01, 0.33979E+01, 0.34185E+01, 0.34389E+01,&
      0.34592E+01, 0.34794E+01, 0.34993E+01, 0.35192E+01, 0.35389E+01,&
      0.35584E+01, 0.35778E+01, 0.35971E+01, 0.36162E+01, 0.36352E+01,&
      0.36541E+01, 0.36728E+01, 0.36914E+01, 0.37099E+01, 0.37282E+01,&
      0.37465E+01, 0.37646E+01, 0.37826E+01, 0.38004E+01, 0.38182E+01,&
      0.38358E+01, 0.38533E+01, 0.38707E+01, 0.38880E+01, 0.39052E+01,&
      0.39223E+01, 0.39393E+01, 0.39562E+01, 0.39729E+01, 0.39896E+01,&
      0.40062E+01, 0.40226E+01, 0.40390E+01, 0.40553E+01, 0.40715E+01,&
      0.40876E+01, 0.41035E+01, 0.41194E+01, 0.41353E+01, 0.41510E+01,&
      0.41666E+01, 0.41822E+01, 0.41976E+01, 0.42130E+01, 0.42283E+01,&
      0.42435E+01, 0.42586E+01, 0.42737E+01, 0.42886E+01, 0.43035E+01,&
      0.43183E+01, 0.43330E+01, 0.43477E+01, 0.43623E+01, 0.43768E+01,&
      0.43912E+01, 0.44056E+01, 0.44198E+01, 0.44341E+01, 0.44482E+01/
                             
     DATA (BNC11M(IA),IA=701,741)/                                      &
      0.44623E+01, 0.44763E+01, 0.44902E+01, 0.45041E+01, 0.45179E+01,&
      0.45316E+01, 0.45453E+01, 0.45589E+01, 0.45724E+01, 0.45859E+01,&
      0.45993E+01, 0.46126E+01, 0.46259E+01, 0.46391E+01, 0.46523E+01,&
      0.46654E+01, 0.46785E+01, 0.46915E+01, 0.47044E+01, 0.47173E+01,&
      0.47301E+01, 0.47428E+01, 0.47555E+01, 0.47682E+01, 0.47808E+01,&
      0.47933E+01, 0.48058E+01, 0.48183E+01, 0.48306E+01, 0.48430E+01,&
      0.48552E+01, 0.48675E+01, 0.48797E+01, 0.48918E+01, 0.49039E+01,&
      0.49159E+01, 0.49279E+01, 0.49398E+01, 0.49517E+01, 0.49635E+01,&
      0.49753E+01                  /                      
!                            
!  ** NaHSO4                 
!                            
     DATA (BNC12M (IA),IA=  1,100)/                                     &
     -0.48506E-01,-0.85523E-01,-0.10966E+00,-0.12495E+00,-0.13595E+00,&
     -0.14436E+00,-0.15100E+00,-0.15637E+00,-0.16075E+00,-0.16435E+00,&
     -0.16731E+00,-0.16974E+00,-0.17171E+00,-0.17329E+00,-0.17453E+00,&
     -0.17547E+00,-0.17613E+00,-0.17655E+00,-0.17675E+00,-0.17675E+00,&
     -0.17656E+00,-0.17620E+00,-0.17567E+00,-0.17500E+00,-0.17419E+00,&
     -0.17325E+00,-0.17219E+00,-0.17101E+00,-0.16973E+00,-0.16834E+00,&
     -0.16685E+00,-0.16526E+00,-0.16359E+00,-0.16184E+00,-0.16000E+00,&
     -0.15809E+00,-0.15610E+00,-0.15405E+00,-0.15192E+00,-0.14973E+00,&
     -0.14749E+00,-0.14518E+00,-0.14281E+00,-0.14040E+00,-0.13793E+00,&
     -0.13541E+00,-0.13284E+00,-0.13023E+00,-0.12757E+00,-0.12488E+00,&
     -0.12214E+00,-0.11936E+00,-0.11654E+00,-0.11369E+00,-0.11081E+00,&
     -0.10789E+00,-0.10493E+00,-0.10195E+00,-0.98933E-01,-0.95887E-01,&
     -0.92812E-01,-0.89708E-01,-0.86577E-01,-0.83417E-01,-0.80231E-01,&
     -0.77018E-01,-0.73779E-01,-0.70513E-01,-0.67222E-01,-0.63906E-01,&
     -0.60563E-01,-0.57196E-01,-0.53803E-01,-0.50385E-01,-0.46941E-01,&
     -0.43472E-01,-0.39979E-01,-0.36459E-01,-0.32915E-01,-0.29345E-01,&
     -0.25749E-01,-0.22128E-01,-0.18482E-01,-0.14811E-01,-0.11115E-01,&
     -0.73934E-02,-0.36468E-02, 0.12404E-03, 0.39196E-02, 0.77393E-02,&
      0.11583E-01, 0.15450E-01, 0.19340E-01, 0.23253E-01, 0.27187E-01,&
      0.31143E-01, 0.35121E-01, 0.39118E-01, 0.43135E-01, 0.47171E-01/
                             
     DATA (BNC12M (IA),IA=101,200)/                                     &
      0.51225E-01, 0.55297E-01, 0.59385E-01, 0.63489E-01, 0.67608E-01,&
      0.71741E-01, 0.75888E-01, 0.80047E-01, 0.84217E-01, 0.88399E-01,&
      0.92590E-01, 0.96791E-01, 0.10100E+00, 0.10522E+00, 0.10944E+00,&
      0.11367E+00, 0.11790E+00, 0.12214E+00, 0.12638E+00, 0.13063E+00,&
      0.13451E+00, 0.13880E+00, 0.14309E+00, 0.14737E+00, 0.15166E+00,&
      0.15593E+00, 0.16021E+00, 0.16448E+00, 0.16874E+00, 0.17301E+00,&
      0.17726E+00, 0.18151E+00, 0.18576E+00, 0.19000E+00, 0.19424E+00,&
      0.19847E+00, 0.20270E+00, 0.20692E+00, 0.21114E+00, 0.21535E+00,&
      0.21955E+00, 0.22375E+00, 0.22794E+00, 0.23213E+00, 0.23630E+00,&
      0.24048E+00, 0.24464E+00, 0.24881E+00, 0.25296E+00, 0.25711E+00,&
      0.26125E+00, 0.26538E+00, 0.26951E+00, 0.27363E+00, 0.27774E+00,&
      0.28185E+00, 0.28595E+00, 0.29004E+00, 0.29413E+00, 0.29821E+00,&
      0.30228E+00, 0.30634E+00, 0.31040E+00, 0.31445E+00, 0.31849E+00,&
      0.32253E+00, 0.32656E+00, 0.33058E+00, 0.33459E+00, 0.33860E+00,&
      0.34260E+00, 0.34659E+00, 0.35057E+00, 0.35455E+00, 0.35852E+00,&
      0.36248E+00, 0.36644E+00, 0.37038E+00, 0.37432E+00, 0.37826E+00,&
      0.38218E+00, 0.38610E+00, 0.39001E+00, 0.39391E+00, 0.39781E+00,&
      0.40170E+00, 0.40558E+00, 0.40945E+00, 0.41332E+00, 0.41718E+00,&
      0.42103E+00, 0.42487E+00, 0.42871E+00, 0.43254E+00, 0.43636E+00,&
      0.44018E+00, 0.44398E+00, 0.44778E+00, 0.45158E+00, 0.45536E+00/
                             
     DATA (BNC12M (IA),IA=201,300)/                                     &
      0.45914E+00, 0.46291E+00, 0.46668E+00, 0.47043E+00, 0.47418E+00,&
      0.47793E+00, 0.48166E+00, 0.48539E+00, 0.48911E+00, 0.49283E+00,&
      0.49653E+00, 0.50023E+00, 0.50393E+00, 0.50761E+00, 0.51129E+00,&
      0.51496E+00, 0.51863E+00, 0.52228E+00, 0.52594E+00, 0.52958E+00,&
      0.53322E+00, 0.53685E+00, 0.54047E+00, 0.54409E+00, 0.54770E+00,&
      0.55130E+00, 0.55490E+00, 0.55849E+00, 0.56207E+00, 0.56564E+00,&
      0.56921E+00, 0.57278E+00, 0.57633E+00, 0.57988E+00, 0.58342E+00,&
      0.58696E+00, 0.59049E+00, 0.59401E+00, 0.59753E+00, 0.60104E+00,&
      0.60454E+00, 0.60804E+00, 0.61153E+00, 0.61501E+00, 0.61849E+00,&
      0.62196E+00, 0.62543E+00, 0.62888E+00, 0.63234E+00, 0.63578E+00,&
      0.63922E+00, 0.64265E+00, 0.64608E+00, 0.64950E+00, 0.65292E+00,&
      0.65632E+00, 0.65973E+00, 0.66312E+00, 0.66651E+00, 0.66990E+00,&
      0.67327E+00, 0.67664E+00, 0.68001E+00, 0.68337E+00, 0.68672E+00,&
      0.69007E+00, 0.69341E+00, 0.69675E+00, 0.70008E+00, 0.70340E+00,&
      0.70672E+00, 0.71003E+00, 0.71334E+00, 0.71664E+00, 0.71993E+00,&
      0.72322E+00, 0.72650E+00, 0.72978E+00, 0.73305E+00, 0.73632E+00,&
      0.73958E+00, 0.74283E+00, 0.74608E+00, 0.74932E+00, 0.75256E+00,&
      0.75579E+00, 0.75902E+00, 0.76224E+00, 0.76546E+00, 0.76867E+00,&
      0.77187E+00, 0.77507E+00, 0.77826E+00, 0.78145E+00, 0.78463E+00,&
      0.78781E+00, 0.79098E+00, 0.79415E+00, 0.79731E+00, 0.80046E+00/
                             
     DATA (BNC12M (IA),IA=301,400)/                                     &
      0.80361E+00, 0.80676E+00, 0.80990E+00, 0.81303E+00, 0.81616E+00,&
      0.81928E+00, 0.82240E+00, 0.82552E+00, 0.82862E+00, 0.83173E+00,&
      0.83483E+00, 0.83792E+00, 0.84101E+00, 0.84409E+00, 0.84717E+00,&
      0.85024E+00, 0.85331E+00, 0.85637E+00, 0.85943E+00, 0.86248E+00,&
      0.86553E+00, 0.86857E+00, 0.87160E+00, 0.87464E+00, 0.87766E+00,&
      0.88069E+00, 0.88371E+00, 0.88672E+00, 0.88973E+00, 0.89273E+00,&
      0.89573E+00, 0.89872E+00, 0.90171E+00, 0.90469E+00, 0.90767E+00,&
      0.91065E+00, 0.91362E+00, 0.91658E+00, 0.91954E+00, 0.92250E+00,&
      0.92545E+00, 0.92840E+00, 0.93134E+00, 0.93427E+00, 0.93721E+00,&
      0.94014E+00, 0.94306E+00, 0.94598E+00, 0.94889E+00, 0.95180E+00,&
      0.95471E+00, 0.95761E+00, 0.96050E+00, 0.96339E+00, 0.96628E+00,&
      0.96916E+00, 0.97204E+00, 0.97492E+00, 0.97779E+00, 0.98065E+00,&
      0.98351E+00, 0.98637E+00, 0.98922E+00, 0.99207E+00, 0.99491E+00,&
      0.99775E+00, 0.10006E+01, 0.10034E+01, 0.10062E+01, 0.10091E+01,&
      0.10119E+01, 0.10147E+01, 0.10175E+01, 0.10203E+01, 0.10231E+01,&
      0.10259E+01, 0.10287E+01, 0.10315E+01, 0.10343E+01, 0.10370E+01,&
      0.10398E+01, 0.10426E+01, 0.10454E+01, 0.10481E+01, 0.10509E+01,&
      0.10536E+01, 0.10564E+01, 0.10591E+01, 0.10619E+01, 0.10646E+01,&
      0.10674E+01, 0.10701E+01, 0.10728E+01, 0.10755E+01, 0.10783E+01,&
      0.10810E+01, 0.10837E+01, 0.10864E+01, 0.10891E+01, 0.10918E+01/
                             
     DATA (BNC12M (IA),IA=401,500)/                                     &
      0.10945E+01, 0.10972E+01, 0.10999E+01, 0.11026E+01, 0.11052E+01,&
      0.11079E+01, 0.11106E+01, 0.11133E+01, 0.11159E+01, 0.11186E+01,&
      0.11212E+01, 0.11239E+01, 0.11265E+01, 0.11292E+01, 0.11318E+01,&
      0.11345E+01, 0.11371E+01, 0.11397E+01, 0.11424E+01, 0.11450E+01,&
      0.11476E+01, 0.11502E+01, 0.11528E+01, 0.11554E+01, 0.11581E+01,&
      0.11607E+01, 0.11633E+01, 0.11658E+01, 0.11684E+01, 0.11710E+01,&
      0.11736E+01, 0.11762E+01, 0.11788E+01, 0.11813E+01, 0.11839E+01,&
      0.11865E+01, 0.11890E+01, 0.11916E+01, 0.11942E+01, 0.11967E+01,&
      0.11993E+01, 0.12018E+01, 0.12044E+01, 0.12069E+01, 0.12094E+01,&
      0.12120E+01, 0.12145E+01, 0.12170E+01, 0.12195E+01, 0.12221E+01,&
      0.12246E+01, 0.12271E+01, 0.12296E+01, 0.12321E+01, 0.12346E+01,&
      0.12371E+01, 0.12396E+01, 0.12421E+01, 0.12446E+01, 0.12471E+01,&
      0.12495E+01, 0.12520E+01, 0.12545E+01, 0.12570E+01, 0.12594E+01,&
      0.12619E+01, 0.12644E+01, 0.12668E+01, 0.12693E+01, 0.12717E+01,&
      0.12742E+01, 0.12766E+01, 0.12791E+01, 0.12815E+01, 0.12839E+01,&
      0.12864E+01, 0.12888E+01, 0.12912E+01, 0.12937E+01, 0.12961E+01,&
      0.12985E+01, 0.13009E+01, 0.13033E+01, 0.13057E+01, 0.13081E+01,&
      0.13106E+01, 0.13130E+01, 0.13153E+01, 0.13177E+01, 0.13201E+01,&
      0.13225E+01, 0.13249E+01, 0.13273E+01, 0.13297E+01, 0.13320E+01,&
      0.13344E+01, 0.13368E+01, 0.13392E+01, 0.13415E+01, 0.13439E+01/
                             
     DATA (BNC12M (IA),IA=501,600)/                                     &
      0.13462E+01, 0.13486E+01, 0.13509E+01, 0.13533E+01, 0.13556E+01,&
      0.13580E+01, 0.13603E+01, 0.13627E+01, 0.13650E+01, 0.13673E+01,&
      0.13697E+01, 0.13720E+01, 0.13743E+01, 0.13766E+01, 0.13789E+01,&
      0.13813E+01, 0.13836E+01, 0.13859E+01, 0.13882E+01, 0.13905E+01,&
      0.13928E+01, 0.13951E+01, 0.13974E+01, 0.13997E+01, 0.14020E+01,&
      0.14042E+01, 0.14065E+01, 0.14088E+01, 0.14111E+01, 0.14134E+01,&
      0.14156E+01, 0.14179E+01, 0.14202E+01, 0.14224E+01, 0.14247E+01,&
      0.14270E+01, 0.14292E+01, 0.14315E+01, 0.14337E+01, 0.14360E+01,&
      0.14382E+01, 0.14405E+01, 0.14427E+01, 0.14449E+01, 0.14472E+01,&
      0.14494E+01, 0.14516E+01, 0.14539E+01, 0.14561E+01, 0.14583E+01,&
      0.14605E+01, 0.14628E+01, 0.14650E+01, 0.14672E+01, 0.14694E+01,&
      0.14716E+01, 0.14738E+01, 0.14760E+01, 0.14782E+01, 0.14804E+01,&
      0.14826E+01, 0.14848E+01, 0.14870E+01, 0.14892E+01, 0.14913E+01,&
      0.14935E+01, 0.14957E+01, 0.14979E+01, 0.15001E+01, 0.15022E+01,&
      0.15044E+01, 0.15066E+01, 0.15087E+01, 0.15109E+01, 0.15130E+01,&
      0.15152E+01, 0.15174E+01, 0.15195E+01, 0.15217E+01, 0.15238E+01,&
      0.15260E+01, 0.15281E+01, 0.15302E+01, 0.15324E+01, 0.15345E+01,&
      0.15366E+01, 0.15388E+01, 0.15409E+01, 0.15430E+01, 0.15451E+01,&
      0.15473E+01, 0.15494E+01, 0.15515E+01, 0.15536E+01, 0.15557E+01,&
      0.15578E+01, 0.15599E+01, 0.15621E+01, 0.15642E+01, 0.15720E+01/
                             
     DATA (BNC12M (IA),IA=601,700)/                                     &
      0.15892E+01, 0.16098E+01, 0.16302E+01, 0.16504E+01, 0.16704E+01,&
      0.16902E+01, 0.17098E+01, 0.17291E+01, 0.17483E+01, 0.17673E+01,&
      0.17861E+01, 0.18047E+01, 0.18232E+01, 0.18415E+01, 0.18596E+01,&
      0.18775E+01, 0.18953E+01, 0.19129E+01, 0.19304E+01, 0.19477E+01,&
      0.19648E+01, 0.19818E+01, 0.19987E+01, 0.20154E+01, 0.20320E+01,&
      0.20484E+01, 0.20647E+01, 0.20809E+01, 0.20969E+01, 0.21128E+01,&
      0.21286E+01, 0.21443E+01, 0.21598E+01, 0.21752E+01, 0.21905E+01,&
      0.22057E+01, 0.22208E+01, 0.22357E+01, 0.22506E+01, 0.22653E+01,&
      0.22800E+01, 0.22945E+01, 0.23089E+01, 0.23232E+01, 0.23374E+01,&
      0.23515E+01, 0.23656E+01, 0.23795E+01, 0.23933E+01, 0.24071E+01,&
      0.24207E+01, 0.24343E+01, 0.24477E+01, 0.24611E+01, 0.24744E+01,&
      0.24876E+01, 0.25007E+01, 0.25138E+01, 0.25267E+01, 0.25396E+01,&
      0.25524E+01, 0.25651E+01, 0.25778E+01, 0.25903E+01, 0.26028E+01,&
      0.26152E+01, 0.26276E+01, 0.26398E+01, 0.26520E+01, 0.26642E+01,&
      0.26762E+01, 0.26882E+01, 0.27001E+01, 0.27120E+01, 0.27238E+01,&
      0.27355E+01, 0.27472E+01, 0.27588E+01, 0.27703E+01, 0.27818E+01,&
      0.27932E+01, 0.28045E+01, 0.28158E+01, 0.28270E+01, 0.28382E+01,&
      0.28493E+01, 0.28604E+01, 0.28714E+01, 0.28823E+01, 0.28932E+01,&
      0.29040E+01, 0.29148E+01, 0.29256E+01, 0.29362E+01, 0.29468E+01,&
      0.29574E+01, 0.29679E+01, 0.29784E+01, 0.29888E+01, 0.29992E+01/
                             
     DATA (BNC12M(IA),IA=701,741)/                                      &
      0.30095E+01, 0.30198E+01, 0.30300E+01, 0.30402E+01, 0.30503E+01,&
      0.30604E+01, 0.30705E+01, 0.30804E+01, 0.30904E+01, 0.31003E+01,&
      0.31102E+01, 0.31200E+01, 0.31298E+01, 0.31395E+01, 0.31492E+01,&
      0.31588E+01, 0.31684E+01, 0.31780E+01, 0.31875E+01, 0.31970E+01,&
      0.32065E+01, 0.32159E+01, 0.32252E+01, 0.32346E+01, 0.32439E+01,&
      0.32531E+01, 0.32623E+01, 0.32715E+01, 0.32807E+01, 0.32898E+01,&
      0.32988E+01, 0.33079E+01, 0.33169E+01, 0.33258E+01, 0.33348E+01,&
      0.33436E+01, 0.33525E+01, 0.33613E+01, 0.33701E+01, 0.33789E+01,&
      0.33876E+01                  /                      
!                            
!  ** (NH4)3H(SO4)2          
!                            
     DATA (BNC13M (IA),IA=  1,100)/                                     &
     -0.79876E-01,-0.14479E+00,-0.19002E+00,-0.22052E+00,-0.24382E+00,&
     -0.26276E+00,-0.27871E+00,-0.29249E+00,-0.30460E+00,-0.31540E+00,&
     -0.32512E+00,-0.33395E+00,-0.34203E+00,-0.34946E+00,-0.35632E+00,&
     -0.36270E+00,-0.36864E+00,-0.37419E+00,-0.37939E+00,-0.38427E+00,&
     -0.38886E+00,-0.39320E+00,-0.39728E+00,-0.40115E+00,-0.40481E+00,&
     -0.40828E+00,-0.41157E+00,-0.41469E+00,-0.41766E+00,-0.42048E+00,&
     -0.42316E+00,-0.42571E+00,-0.42814E+00,-0.43045E+00,-0.43265E+00,&
     -0.43474E+00,-0.43673E+00,-0.43863E+00,-0.44044E+00,-0.44216E+00,&
     -0.44379E+00,-0.44535E+00,-0.44683E+00,-0.44824E+00,-0.44958E+00,&
     -0.45085E+00,-0.45205E+00,-0.45320E+00,-0.45428E+00,-0.45531E+00,&
     -0.45628E+00,-0.45720E+00,-0.45807E+00,-0.45888E+00,-0.45966E+00,&
     -0.46038E+00,-0.46106E+00,-0.46170E+00,-0.46230E+00,-0.46285E+00,&
     -0.46337E+00,-0.46385E+00,-0.46430E+00,-0.46471E+00,-0.46508E+00,&
     -0.46542E+00,-0.46574E+00,-0.46602E+00,-0.46627E+00,-0.46649E+00,&
     -0.46668E+00,-0.46684E+00,-0.46698E+00,-0.46710E+00,-0.46718E+00,&
     -0.46724E+00,-0.46728E+00,-0.46730E+00,-0.46729E+00,-0.46726E+00,&
     -0.46720E+00,-0.46713E+00,-0.46703E+00,-0.46691E+00,-0.46678E+00,&
     -0.46662E+00,-0.46644E+00,-0.46625E+00,-0.46604E+00,-0.46580E+00,&
     -0.46556E+00,-0.46529E+00,-0.46501E+00,-0.46471E+00,-0.46439E+00,&
     -0.46406E+00,-0.46372E+00,-0.46335E+00,-0.46298E+00,-0.46259E+00/
                             
     DATA (BNC13M (IA),IA=101,200)/                                     &
     -0.46219E+00,-0.46177E+00,-0.46134E+00,-0.46090E+00,-0.46045E+00,&
     -0.45998E+00,-0.45951E+00,-0.45902E+00,-0.45852E+00,-0.45801E+00,&
     -0.45749E+00,-0.45697E+00,-0.45643E+00,-0.45588E+00,-0.45533E+00,&
     -0.45477E+00,-0.45420E+00,-0.45362E+00,-0.45303E+00,-0.45244E+00,&
     -0.45191E+00,-0.45130E+00,-0.45068E+00,-0.45006E+00,-0.44943E+00,&
     -0.44879E+00,-0.44815E+00,-0.44751E+00,-0.44686E+00,-0.44621E+00,&
     -0.44555E+00,-0.44489E+00,-0.44423E+00,-0.44356E+00,-0.44289E+00,&
     -0.44221E+00,-0.44154E+00,-0.44085E+00,-0.44017E+00,-0.43948E+00,&
     -0.43879E+00,-0.43810E+00,-0.43740E+00,-0.43670E+00,-0.43600E+00,&
     -0.43530E+00,-0.43459E+00,-0.43388E+00,-0.43317E+00,-0.43246E+00,&
     -0.43174E+00,-0.43103E+00,-0.43031E+00,-0.42959E+00,-0.42886E+00,&
     -0.42814E+00,-0.42741E+00,-0.42669E+00,-0.42596E+00,-0.42523E+00,&
     -0.42449E+00,-0.42376E+00,-0.42302E+00,-0.42229E+00,-0.42155E+00,&
     -0.42081E+00,-0.42007E+00,-0.41933E+00,-0.41859E+00,-0.41785E+00,&
     -0.41711E+00,-0.41636E+00,-0.41562E+00,-0.41487E+00,-0.41412E+00,&
     -0.41337E+00,-0.41263E+00,-0.41188E+00,-0.41113E+00,-0.41038E+00,&
     -0.40962E+00,-0.40887E+00,-0.40812E+00,-0.40737E+00,-0.40661E+00,&
     -0.40586E+00,-0.40511E+00,-0.40435E+00,-0.40360E+00,-0.40284E+00,&
     -0.40209E+00,-0.40133E+00,-0.40057E+00,-0.39982E+00,-0.39906E+00,&
     -0.39830E+00,-0.39755E+00,-0.39679E+00,-0.39603E+00,-0.39527E+00/
                             
     DATA (BNC13M (IA),IA=201,300)/                                     &
     -0.39452E+00,-0.39376E+00,-0.39300E+00,-0.39224E+00,-0.39148E+00,&
     -0.39072E+00,-0.38997E+00,-0.38921E+00,-0.38845E+00,-0.38769E+00,&
     -0.38693E+00,-0.38617E+00,-0.38542E+00,-0.38466E+00,-0.38390E+00,&
     -0.38314E+00,-0.38238E+00,-0.38162E+00,-0.38087E+00,-0.38011E+00,&
     -0.37935E+00,-0.37859E+00,-0.37784E+00,-0.37708E+00,-0.37632E+00,&
     -0.37556E+00,-0.37481E+00,-0.37405E+00,-0.37329E+00,-0.37254E+00,&
     -0.37178E+00,-0.37103E+00,-0.37027E+00,-0.36952E+00,-0.36876E+00,&
     -0.36801E+00,-0.36725E+00,-0.36650E+00,-0.36574E+00,-0.36499E+00,&
     -0.36423E+00,-0.36348E+00,-0.36273E+00,-0.36198E+00,-0.36122E+00,&
     -0.36047E+00,-0.35972E+00,-0.35897E+00,-0.35822E+00,-0.35747E+00,&
     -0.35672E+00,-0.35597E+00,-0.35522E+00,-0.35447E+00,-0.35372E+00,&
     -0.35297E+00,-0.35222E+00,-0.35147E+00,-0.35072E+00,-0.34998E+00,&
     -0.34923E+00,-0.34848E+00,-0.34774E+00,-0.34699E+00,-0.34624E+00,&
     -0.34550E+00,-0.34475E+00,-0.34401E+00,-0.34327E+00,-0.34252E+00,&
     -0.34178E+00,-0.34104E+00,-0.34029E+00,-0.33955E+00,-0.33881E+00,&
     -0.33807E+00,-0.33733E+00,-0.33659E+00,-0.33585E+00,-0.33511E+00,&
     -0.33437E+00,-0.33363E+00,-0.33289E+00,-0.33216E+00,-0.33142E+00,&
     -0.33068E+00,-0.32994E+00,-0.32921E+00,-0.32847E+00,-0.32774E+00,&
     -0.32700E+00,-0.32627E+00,-0.32553E+00,-0.32480E+00,-0.32407E+00,&
     -0.32334E+00,-0.32260E+00,-0.32187E+00,-0.32114E+00,-0.32041E+00/
                             
     DATA (BNC13M (IA),IA=301,400)/                                     &
     -0.31968E+00,-0.31895E+00,-0.31822E+00,-0.31749E+00,-0.31676E+00,&
     -0.31603E+00,-0.31531E+00,-0.31458E+00,-0.31385E+00,-0.31313E+00,&
     -0.31240E+00,-0.31167E+00,-0.31095E+00,-0.31023E+00,-0.30950E+00,&
     -0.30878E+00,-0.30805E+00,-0.30733E+00,-0.30661E+00,-0.30589E+00,&
     -0.30517E+00,-0.30445E+00,-0.30373E+00,-0.30301E+00,-0.30229E+00,&
     -0.30157E+00,-0.30085E+00,-0.30013E+00,-0.29941E+00,-0.29870E+00,&
     -0.29798E+00,-0.29726E+00,-0.29655E+00,-0.29583E+00,-0.29512E+00,&
     -0.29440E+00,-0.29369E+00,-0.29298E+00,-0.29226E+00,-0.29155E+00,&
     -0.29084E+00,-0.29013E+00,-0.28942E+00,-0.28871E+00,-0.28800E+00,&
     -0.28729E+00,-0.28658E+00,-0.28587E+00,-0.28516E+00,-0.28445E+00,&
     -0.28375E+00,-0.28304E+00,-0.28233E+00,-0.28163E+00,-0.28092E+00,&
     -0.28022E+00,-0.27951E+00,-0.27881E+00,-0.27811E+00,-0.27740E+00,&
     -0.27670E+00,-0.27600E+00,-0.27530E+00,-0.27459E+00,-0.27389E+00,&
     -0.27319E+00,-0.27249E+00,-0.27179E+00,-0.27110E+00,-0.27040E+00,&
     -0.26970E+00,-0.26900E+00,-0.26831E+00,-0.26761E+00,-0.26691E+00,&
     -0.26622E+00,-0.26552E+00,-0.26483E+00,-0.26413E+00,-0.26344E+00,&
     -0.26275E+00,-0.26205E+00,-0.26136E+00,-0.26067E+00,-0.25998E+00,&
     -0.25929E+00,-0.25860E+00,-0.25791E+00,-0.25722E+00,-0.25653E+00,&
     -0.25584E+00,-0.25515E+00,-0.25446E+00,-0.25378E+00,-0.25309E+00,&
     -0.25240E+00,-0.25172E+00,-0.25103E+00,-0.25035E+00,-0.24966E+00/
                             
     DATA (BNC13M (IA),IA=401,500)/                                     &
     -0.24898E+00,-0.24829E+00,-0.24761E+00,-0.24693E+00,-0.24625E+00,&
     -0.24556E+00,-0.24488E+00,-0.24420E+00,-0.24352E+00,-0.24284E+00,&
     -0.24216E+00,-0.24148E+00,-0.24080E+00,-0.24013E+00,-0.23945E+00,&
     -0.23877E+00,-0.23809E+00,-0.23742E+00,-0.23674E+00,-0.23607E+00,&
     -0.23539E+00,-0.23472E+00,-0.23404E+00,-0.23337E+00,-0.23270E+00,&
     -0.23202E+00,-0.23135E+00,-0.23068E+00,-0.23001E+00,-0.22934E+00,&
     -0.22867E+00,-0.22800E+00,-0.22733E+00,-0.22666E+00,-0.22599E+00,&
     -0.22532E+00,-0.22465E+00,-0.22398E+00,-0.22332E+00,-0.22265E+00,&
     -0.22198E+00,-0.22132E+00,-0.22065E+00,-0.21999E+00,-0.21932E+00,&
     -0.21866E+00,-0.21799E+00,-0.21733E+00,-0.21667E+00,-0.21601E+00,&
     -0.21534E+00,-0.21468E+00,-0.21402E+00,-0.21336E+00,-0.21270E+00,&
     -0.21204E+00,-0.21138E+00,-0.21072E+00,-0.21006E+00,-0.20941E+00,&
     -0.20875E+00,-0.20809E+00,-0.20743E+00,-0.20678E+00,-0.20612E+00,&
     -0.20547E+00,-0.20481E+00,-0.20416E+00,-0.20350E+00,-0.20285E+00,&
     -0.20219E+00,-0.20154E+00,-0.20089E+00,-0.20024E+00,-0.19958E+00,&
     -0.19893E+00,-0.19828E+00,-0.19763E+00,-0.19698E+00,-0.19633E+00,&
     -0.19568E+00,-0.19503E+00,-0.19438E+00,-0.19374E+00,-0.19309E+00,&
     -0.19244E+00,-0.19179E+00,-0.19115E+00,-0.19050E+00,-0.18986E+00,&
     -0.18921E+00,-0.18857E+00,-0.18792E+00,-0.18728E+00,-0.18663E+00,&
     -0.18599E+00,-0.18535E+00,-0.18470E+00,-0.18406E+00,-0.18342E+00/
                                                                      
     DATA (BNC13M (IA),IA=501,600)/                                     &
     -0.18278E+00,-0.18214E+00,-0.18150E+00,-0.18086E+00,-0.18022E+00,&
     -0.17958E+00,-0.17894E+00,-0.17830E+00,-0.17766E+00,-0.17703E+00,&
     -0.17639E+00,-0.17575E+00,-0.17511E+00,-0.17448E+00,-0.17384E+00,&
     -0.17321E+00,-0.17257E+00,-0.17194E+00,-0.17130E+00,-0.17067E+00,&
     -0.17004E+00,-0.16940E+00,-0.16877E+00,-0.16814E+00,-0.16751E+00,&
     -0.16687E+00,-0.16624E+00,-0.16561E+00,-0.16498E+00,-0.16435E+00,&
     -0.16372E+00,-0.16309E+00,-0.16247E+00,-0.16184E+00,-0.16121E+00,&
     -0.16058E+00,-0.15995E+00,-0.15933E+00,-0.15870E+00,-0.15807E+00,&
     -0.15745E+00,-0.15682E+00,-0.15620E+00,-0.15557E+00,-0.15495E+00,&
     -0.15432E+00,-0.15370E+00,-0.15308E+00,-0.15245E+00,-0.15183E+00,&
     -0.15121E+00,-0.15059E+00,-0.14997E+00,-0.14935E+00,-0.14873E+00,&
     -0.14811E+00,-0.14749E+00,-0.14687E+00,-0.14625E+00,-0.14563E+00,&
     -0.14501E+00,-0.14439E+00,-0.14377E+00,-0.14316E+00,-0.14254E+00,&
     -0.14192E+00,-0.14131E+00,-0.14069E+00,-0.14007E+00,-0.13946E+00,&
     -0.13885E+00,-0.13823E+00,-0.13762E+00,-0.13700E+00,-0.13639E+00,&
     -0.13578E+00,-0.13516E+00,-0.13455E+00,-0.13394E+00,-0.13333E+00,&
     -0.13272E+00,-0.13211E+00,-0.13149E+00,-0.13088E+00,-0.13027E+00,&
     -0.12966E+00,-0.12906E+00,-0.12845E+00,-0.12784E+00,-0.12723E+00,&
     -0.12662E+00,-0.12601E+00,-0.12541E+00,-0.12480E+00,-0.12419E+00,&
     -0.12359E+00,-0.12298E+00,-0.12238E+00,-0.12177E+00,-0.11951E+00/
                                                                      
     DATA (BNC13M (IA),IA=601,700)/                                     &
     -0.11454E+00,-0.10855E+00,-0.10259E+00,-0.96662E-01,-0.90768E-01,&
     -0.84905E-01,-0.79073E-01,-0.73271E-01,-0.67500E-01,-0.61758E-01,&
     -0.56045E-01,-0.50361E-01,-0.44704E-01,-0.39075E-01,-0.33474E-01,&
     -0.27900E-01,-0.22352E-01,-0.16830E-01,-0.11333E-01,-0.58624E-02,&
     -0.41641E-03, 0.50053E-02, 0.10403E-01, 0.15776E-01, 0.21127E-01,&
      0.26453E-01, 0.31758E-01, 0.37040E-01, 0.42299E-01, 0.47537E-01,&
      0.52753E-01, 0.57948E-01, 0.63123E-01, 0.68276E-01, 0.73409E-01,&
      0.78522E-01, 0.83615E-01, 0.88689E-01, 0.93744E-01, 0.98779E-01,&
      0.10380E+00, 0.10879E+00, 0.11377E+00, 0.11874E+00, 0.12368E+00,&
      0.12861E+00, 0.13352E+00, 0.13841E+00, 0.14328E+00, 0.14814E+00,&
      0.15298E+00, 0.15781E+00, 0.16262E+00, 0.16741E+00, 0.17219E+00,&
      0.17695E+00, 0.18170E+00, 0.18643E+00, 0.19115E+00, 0.19585E+00,&
      0.20054E+00, 0.20521E+00, 0.20987E+00, 0.21452E+00, 0.21915E+00,&
      0.22376E+00, 0.22837E+00, 0.23296E+00, 0.23753E+00, 0.24210E+00,&
      0.24665E+00, 0.25119E+00, 0.25571E+00, 0.26022E+00, 0.26472E+00,&
      0.26921E+00, 0.27369E+00, 0.27815E+00, 0.28260E+00, 0.28704E+00,&
      0.29147E+00, 0.29589E+00, 0.30029E+00, 0.30468E+00, 0.30907E+00,&
      0.31344E+00, 0.31780E+00, 0.32215E+00, 0.32649E+00, 0.33081E+00,&
      0.33513E+00, 0.33944E+00, 0.34374E+00, 0.34802E+00, 0.35230E+00,&
      0.35656E+00, 0.36082E+00, 0.36507E+00, 0.36930E+00, 0.37353E+00/
                                                                      
     DATA (BNC13M(IA),IA=701,741)/                                      &
      0.37775E+00, 0.38196E+00, 0.38616E+00, 0.39035E+00, 0.39453E+00,&
      0.39870E+00, 0.40286E+00, 0.40701E+00, 0.41116E+00, 0.41529E+00,&
      0.41942E+00, 0.42354E+00, 0.42764E+00, 0.43175E+00, 0.43584E+00,&
      0.43992E+00, 0.44400E+00, 0.44807E+00, 0.45213E+00, 0.45618E+00,&
      0.46022E+00, 0.46426E+00, 0.46828E+00, 0.47230E+00, 0.47632E+00,&
      0.48032E+00, 0.48432E+00, 0.48831E+00, 0.49229E+00, 0.49626E+00,&
      0.50023E+00, 0.50419E+00, 0.50814E+00, 0.51209E+00, 0.51603E+00,&
      0.51996E+00, 0.52388E+00, 0.52780E+00, 0.53171E+00, 0.53562E+00,&
      0.53951E+00 /
!      END                                   


!=======================================================================
!
! *** ISORROPIA CODE
! *** BLOCK DATA EXPON
! *** CONTAINS DATA FOR EXPONENT ARRAYS NEEDED IN FUNCTION EXP10
!
! *** COPYRIGHT 1996-2006, UNIVERSITY OF MIAMI, CARNEGIE MELLON UNIVERSITY,
! *** GEORGIA INSTITUTE OF TECHNOLOGY
! *** WRITTEN BY ATHANASIOS NENES
! *** UPDATED BY CHRISTOS FOUNTOUKIS
!
!=======================================================================
!
!      BLOCK DATA EXPON
!
! *** Common block definition
!
      REAL  AINT10(20), ADEC10(200)
!
! *** Integer part        
!
      DATA AINT10/                                              &
      0.1000E-08, 0.1000E-07, 0.1000E-06, 0.1000E-05, 0.1000E-04,&
      0.1000E-03, 0.1000E-02, 0.1000E-01, 0.1000E+00, 0.1000E+01,&
      0.1000E+02, 0.1000E+03, 0.1000E+04, 0.1000E+05, 0.1000E+06,&
      0.1000E+07, 0.1000E+08, 0.1000E+09, 0.1000E+10, 0.1000E+11/                                                         
!                                                               
! ***decimal part                                               
!                                                               
     DATA (ADEC10(IA),IA=1,100)/                                  &
      0.1023E+00, 0.1047E+00, 0.1072E+00, 0.1096E+00, 0.1122E+00,&
      0.1148E+00, 0.1175E+00, 0.1202E+00, 0.1230E+00, 0.1259E+00,&
      0.1288E+00, 0.1318E+00, 0.1349E+00, 0.1380E+00, 0.1413E+00,&
      0.1445E+00, 0.1479E+00, 0.1514E+00, 0.1549E+00, 0.1585E+00,&
      0.1622E+00, 0.1660E+00, 0.1698E+00, 0.1738E+00, 0.1778E+00,&
      0.1820E+00, 0.1862E+00, 0.1905E+00, 0.1950E+00, 0.1995E+00,&
      0.2042E+00, 0.2089E+00, 0.2138E+00, 0.2188E+00, 0.2239E+00,&
      0.2291E+00, 0.2344E+00, 0.2399E+00, 0.2455E+00, 0.2512E+00,&
      0.2570E+00, 0.2630E+00, 0.2692E+00, 0.2754E+00, 0.2818E+00,&
      0.2884E+00, 0.2951E+00, 0.3020E+00, 0.3090E+00, 0.3162E+00,&
      0.3236E+00, 0.3311E+00, 0.3388E+00, 0.3467E+00, 0.3548E+00,&
      0.3631E+00, 0.3715E+00, 0.3802E+00, 0.3890E+00, 0.3981E+00,&
      0.4074E+00, 0.4169E+00, 0.4266E+00, 0.4365E+00, 0.4467E+00,&
      0.4571E+00, 0.4677E+00, 0.4786E+00, 0.4898E+00, 0.5012E+00,&
      0.5129E+00, 0.5248E+00, 0.5370E+00, 0.5495E+00, 0.5623E+00,&
      0.5754E+00, 0.5888E+00, 0.6026E+00, 0.6166E+00, 0.6310E+00,&
      0.6457E+00, 0.6607E+00, 0.6761E+00, 0.6918E+00, 0.7079E+00,&
      0.7244E+00, 0.7413E+00, 0.7586E+00, 0.7762E+00, 0.7943E+00,&
      0.8128E+00, 0.8318E+00, 0.8511E+00, 0.8710E+00, 0.8913E+00,&
      0.9120E+00, 0.9333E+00, 0.9550E+00, 0.9772E+00, 0.1000E+01/
                                                                
     DATA (ADEC10(IA),IA=101,200)/                                &
      0.1023E+01, 0.1047E+01, 0.1072E+01, 0.1096E+01, 0.1122E+01,&
      0.1148E+01, 0.1175E+01, 0.1202E+01, 0.1230E+01, 0.1259E+01,&
      0.1288E+01, 0.1318E+01, 0.1349E+01, 0.1380E+01, 0.1413E+01,&
      0.1445E+01, 0.1479E+01, 0.1514E+01, 0.1549E+01, 0.1585E+01,&
      0.1622E+01, 0.1660E+01, 0.1698E+01, 0.1738E+01, 0.1778E+01,&
      0.1820E+01, 0.1862E+01, 0.1905E+01, 0.1950E+01, 0.1995E+01,&
      0.2042E+01, 0.2089E+01, 0.2138E+01, 0.2188E+01, 0.2239E+01,&
      0.2291E+01, 0.2344E+01, 0.2399E+01, 0.2455E+01, 0.2512E+01,&
      0.2570E+01, 0.2630E+01, 0.2692E+01, 0.2754E+01, 0.2818E+01,&
      0.2884E+01, 0.2951E+01, 0.3020E+01, 0.3090E+01, 0.3162E+01,&
      0.3236E+01, 0.3311E+01, 0.3388E+01, 0.3467E+01, 0.3548E+01,&
      0.3631E+01, 0.3715E+01, 0.3802E+01, 0.3890E+01, 0.3981E+01,&
      0.4074E+01, 0.4169E+01, 0.4266E+01, 0.4365E+01, 0.4467E+01,&
      0.4571E+01, 0.4677E+01, 0.4786E+01, 0.4898E+01, 0.5012E+01,&
      0.5129E+01, 0.5248E+01, 0.5370E+01, 0.5495E+01, 0.5623E+01,&
      0.5754E+01, 0.5888E+01, 0.6026E+01, 0.6166E+01, 0.6310E+01,&
      0.6457E+01, 0.6607E+01, 0.6761E+01, 0.6918E+01, 0.7079E+01,&
      0.7244E+01, 0.7413E+01, 0.7586E+01, 0.7762E+01, 0.7943E+01,&
      0.8128E+01, 0.8318E+01, 0.8511E+01, 0.8710E+01, 0.8913E+01,&
      0.9120E+01, 0.9333E+01, 0.9550E+01, 0.9772E+01, 0.1000E+02/
!
! *** END OF BLOCK DATA EXPON ******************************************
!
!   END 

END module module_data_isrpia
