!dis   
!dis    Open Source License/Disclaimer, Forecast Systems Laboratory
!dis    NOAA/OAR/FSL, 325 Broadway Boulder, CO 80305
!dis    
!dis    This software is distributed under the Open Source Definition,
!dis    which may be found at http://www.opensource.org/osd.html.
!dis    
!dis    In particular, redistribution and use in source and binary forms,
!dis    with or without modification, are permitted provided that the
!dis    following conditions are met:
!dis    
!dis    - Redistributions of source code must retain this notice, this
!dis    list of conditions and the following disclaimer.
!dis    
!dis    - Redistributions in binary form must provide access to this
!dis    notice, this list of conditions and the following disclaimer, and
!dis    the underlying source code.
!dis    
!dis    - All modifications to this software must be clearly documented,
!dis    and are solely the responsibility of the agent making the
!dis    modifications.
!dis    
!dis    - If significant modifications or enhancements are made to this
!dis    software, the FSL Software Policy Manager
!dis    (softwaremgr@fsl.noaa.gov) should be notified.
!dis    
!dis    THIS SOFTWARE AND ITS DOCUMENTATION ARE IN THE PUBLIC DOMAIN
!dis    AND ARE FURNISHED "AS IS."  THE AUTHORS, THE UNITED STATES
!dis    GOVERNMENT, ITS INSTRUMENTALITIES, OFFICERS, EMPLOYEES, AND
!dis    AGENTS MAKE NO WARRANTY, EXPRESS OR IMPLIED, AS TO THE USEFULNESS
!dis    OF THE SOFTWARE AND DOCUMENTATION FOR ANY PURPOSE.  THEY ASSUME
!dis    NO RESPONSIBILITY (1) FOR THE USE OF THE SOFTWARE AND
!dis    DOCUMENTATION; OR (2) TO PROVIDE TECHNICAL SUPPORT TO USERS.
!dis   
!dis 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!  hinterp
!!
!!
!!  Version:  0.1, Aug 2000, Brent Shaw, NOAA/OAR/FSL/FRD/LAPB
!!
!!  Apr 2001 - Multiple modifications - Brent Shaw, NOAA/FSL
!!             -- Improved modularity
!!             -- Improved mapping accuracy
!!             -- LSM support 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

PROGRAM hinterp

  USE date_pack
  USE wrf_metadata
  USE hinterp_setup
  USE domain_info
  USE gridded_data
  USE hinterp_gribprep

  IMPLICIT NONE

  INTEGER :: dom_index
  INTEGER :: t       
  LOGICAL :: data_processed, found_init

  ! Get the dataroot
  CALL GETENV("MOAD_DATAROOT", moad_dataroot)
  IF (moad_dataroot(1:5) .EQ. '     ') THEN
    PRINT '(A)', 'No MOAD_DATAROOT Environment variable set!'
    STOP 'HINTERP MAIN'
  ENDIF

  ! Get the setup information for hinterp

  CALL init_hinterp(moad_dataroot)

  PRINT '(A)', 'HINTERP processing ' // TRIM(global_meta%simulation_name)
  PRINT '(A)', 'for ' // TRIM(global_meta%user_desc)
  

  min_top_height = 999999.
  ! Loop over all domains 

  domain_loop: DO dom_index = 1, num_domains_to_proc

    PRINT '(A,I2)', 'HINTERP: Processing WRF Domain: ', domain_ids(dom_index)
    ! Read the WRF static data file created by gridgen_wrf to get 
    ! the domain information.

    CALL init_wrf_domain(moad_dataroot, domain_ids(dom_index))
    
    !  This is the time loop.  Initialize the current time to be the
    !  starting time requested in the namelist.
    found_init = .false.
    time_loop : DO t = 1, num_output_times
     ! For subdomains, only process 1st time period
     IF ((dom_index .EQ. 1) .or. (t .EQ. 1)) THEN
      PRINT '(//A,A)','Processing time:        ', time_list(t)

      !  Read in the 2d meteorological fields.  Each field is horizontally
      !  interpolated to the model grid (defined by the information obtained from the
      !  static.wrfsi netCDF file via module_domain_info).  All
      !  of the data comes into this routine as slices, even the 3d data come
      !  in as separate levels to be ordered in the linked list.

      data_processed  = .false.
      CALL ingest_gribprep(time_list(t),data_processed)

      IF (data_processed) THEN
   
        ! Set the time in the domain metadata
        CALL mm5_to_wrf_date(time_list(t),dom_meta%vt_date,dom_meta%vt_time)
  
        ! Set start time in global metadata if this is the first time we processed
        ! some data           
        IF ( (dom_index .EQ. 1) .AND. (.NOT. found_init)) THEN
         global_meta%init_date = dom_meta%vt_date
         global_meta%init_time = dom_meta%vt_time
         found_init = .true.
        END IF   

        
        ! Build the variable metadata
        CALL proc_make_variable_metadata(dom_index,dom_meta%vt_date,dom_meta%vt_time)
       
        ! Output the ingested data
        CALL proc_output_variable(time_list(t))

        ! Zap the gridded data array
        DEALLOCATE(all_3d)
        DEALLOCATE(all_2d)
        DEALLOCATE(output_levels)
  
        ! Update the ending time of the global metadata
        global_meta%end_date = dom_meta%vt_date
        global_meta%end_time = dom_meta%vt_time
      ELSE
        PRINT '(A)', 'No data processed for this domain and time period.'
      ENDIF
     ENDIF ! Check for domain 1 or time 1
    END DO time_loop
    PRINT '(A,I2)', 'HINTERP: Completed for domain: ', domain_ids(dom_index)
    IF(ALLOCATED(soilhgt_bg))DEALLOCATE(soilhgt_bg) ! WRFSI for nested domains , update 
    ! Deallocate domain info arrays
      
  END DO domain_loop
  
  ! Write global metadata
  global_meta%vertical_coord='PRESSURE'
 
  CALL proc_store_global_metadata
  PRINT '(A)', "* Make sure to set model top <= 50mb (or to"
  PRINT '(A)', "* the lowest pressure level in your dataset)."
  
END PROGRAM hinterp
